import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestRadioStats(DeviceTestCase):

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_4_5_3_10_60_57_2(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.4.5.3.10_60_57_2")
        exp_info = {
            'model': 'UFiber OLT4',
            'rf_tx_power': None,
            'sta_count': 53,
            'sw_version': '4.5.3',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': 4}
        exp_sta_stats = {
            '18:e8:29:19:6c:11': {
                'dev_macs': ['a0:40:a0:71:2d:88'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:6c:11',
                'name': 'Island View - 12705 - Karen '
                'Mulvahill - 14204'
            },
            '18:e8:29:19:70:7b': {
                'dev_macs': ['10:0c:6b:2d:94:8a'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:70:7b',
                'name': 'Island View-12545-John '
                'Wadas-16542'
            },
            '18:e8:29:19:74:e5': {
                'dev_macs': ['e0:63:da:99:cd:79'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:74:e5',
                'name': 'Island View - 12571 - John Scott '
                '- 18909'
            },
            '18:e8:29:19:b0:a9': {
                'dev_macs': ['3c:37:86:c8:4c:76'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b0:a9',
                'name': 'Island View - 12771 - Bill Brown '
                '- 13712'
            },
            '18:e8:29:19:b0:f9': {
                'dev_macs': ['b0:39:56:50:a7:80'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b0:f9',
                'name': 'Island View - 12563 - Don '
                'DAnnunzio - 17717'
            },
            '18:e8:29:19:b1:12': {
                'dev_macs': ['a0:04:60:04:24:be'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b1:12',
                'name': 'Island View - 12585 - Ronald '
                'Jones - 14376'
            },
            '18:e8:29:19:b2:57': {
                'dev_macs': ['f4:92:bf:66:6a:d1'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b2:57',
                'name': 'Island View - 12527 - John '
                'Christophersen - 17017'
            },
            '18:e8:29:19:b2:61': {
                'dev_macs': ['6c:b0:ce:10:fa:03'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b2:61',
                'name': 'Island View - 12755 - Paul '
                'Christopheren - 16068'
            },
            '18:e8:29:19:b2:6b': {
                'dev_macs': ['10:0c:6b:d6:f0:fe'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b2:6b',
                'name': 'Island View - 12727 - Rich '
                'Sutliff - 14696'
            },
            '18:e8:29:19:b2:7f': {
                'dev_macs': ['78:d2:94:18:c2:98'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b2:7f',
                'name': 'Island View - 12811 - Robert '
                'Shirkey - 13719'
            },
            '18:e8:29:19:b2:98': {
                'dev_macs': ['d8:07:b6:74:c5:ee'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b2:98',
                'name': 'Island VIew - 12655 - Al Blinke '
                '- 15472'
            },
            '18:e8:29:19:b2:a7': {
                'dev_macs': ['f8:32:e4:b2:fc:50'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b2:a7',
                'name': 'Island View - 12831 - DomeHouse '
                'LLC - 13718'
            },
            '18:e8:29:19:b2:ac': {
                'dev_macs': ['08:36:c9:14:fc:10'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b2:ac',
                'name': 'Island View - 12891 - Terry Fera '
                '- 15115'
            },
            '18:e8:29:19:b2:b1': {
                'dev_macs': ['78:d2:94:18:e9:d8'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b2:b1',
                'name': 'Island View - 12371 - Christine '
                'Polo - 20910'
            },
            '18:e8:29:19:b3:f6': {
                'dev_macs': ['6c:3b:6b:92:e4:29'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b3:f6',
                'name': 'Island View - 12973 - Christine '
                'Kay - 16910'
            },
            '18:e8:29:19:b4:0a': {
                'dev_macs': ['e0:63:da:f9:95:4f'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b4:0a',
                'name': 'Island View - 12803 - Stephen '
                'Rigotti - 14850'
            },
            '18:e8:29:19:b4:91': {
                'dev_macs': ['60:b7:6e:1e:fa:76'],
                'ip_address': None,
                'mac_address': '18:e8:29:19:b4:91',
                'name': 'Island View - 12515 - Brandon '
                'Theophilus - 18564'
            },
            '18:e8:29:f5:ff:97': {
                'dev_macs': ['74:ac:b9:46:e6:45'],
                'ip_address': None,
                'mac_address': '18:e8:29:f5:ff:97',
                'name': 'Foxview - 12010 - Douglas Jester '
                '- 16616'
            },
            '68:d7:9a:06:87:03': {
                'dev_macs': ['cc:40:d0:50:f6:20'],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:87:03',
                'name': 'Island View - 12331 - William '
                'Cron - 13536'
            },
            '68:d7:9a:06:8a:ad': {
                'dev_macs': [],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:8a:ad',
                'name': 'Island Dr - 12901 - Dan Cermak - '
                '20905'
            },
            '68:d7:9a:06:8a:f2': {
                'dev_macs': ['40:ed:00:a9:df:2c'],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:8a:f2',
                'name': 'Island View - 12445 - Stanley '
                'Pruss -  15077'
            },
            '74:83:c2:43:f7:28': {
                'dev_macs': ['74:b6:b6:05:8c:80'],
                'ip_address': None,
                'mac_address': '74:83:c2:43:f7:28',
                'name': 'Foxview - 11907 - Todd Hoogland '
                '- 17100'
            },
            '74:83:c2:43:f7:90': {
                'dev_macs': ['48:22:54:32:d5:d1'],
                'ip_address': None,
                'mac_address': '74:83:c2:43:f7:90',
                'name': 'Island View - 12531 - Malcolm '
                'Hickok - 21903'
            },
            '74:83:c2:43:fb:46': {
                'dev_macs': ['14:91:82:2e:cf:55'],
                'ip_address': None,
                'mac_address': '74:83:c2:43:fb:46',
                'name': 'Island View Dr - 12931 - Judy '
                'Burns - 15696'
            },
            '74:83:c2:68:af:3b': {
                'dev_macs': ['8c:3b:ad:f1:f0:12'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:af:3b',
                'name': 'N Foxview - 11981 - Tina Serne - '
                '17978'
            },
            '78:45:58:90:da:70': {
                'dev_macs': ['40:ed:00:85:28:a5'],
                'ip_address': None,
                'mac_address': '78:45:58:90:da:70',
                'name': 'Island View - 12875 - Bridget '
                'Lamont - 13721'
            },
            '78:45:58:90:e0:f4': {
                'dev_macs': ['c8:9e:43:db:81:8b'],
                'ip_address': None,
                'mac_address': '78:45:58:90:e0:f4',
                'name': 'Island View - 12851 - Joanne '
                'Whitley - 14649'
            },
            '78:45:58:90:e1:88': {
                'dev_macs': ['c0:06:c3:2f:d4:3d'],
                'ip_address': None,
                'mac_address': '78:45:58:90:e1:88',
                'name': 'Shores Ct - 12372 - Maginot, '
                'Anne & Peter - 20791'
            },
            '78:45:58:90:e8:94': {
                'dev_macs': ['50:91:e3:43:0d:f4'],
                'ip_address': None,
                'mac_address': '78:45:58:90:e8:94',
                'name': 'Island Lake Dr - 13015 -Marilee '
                'Milroy - 13348'
            },
            '78:45:58:95:28:a4': {
                'dev_macs': ['28:87:ba:76:31:21'],
                'ip_address': None,
                'mac_address': '78:45:58:95:28:a4',
                'name': 'Peterson Park - 10323 - Rich '
                'Simons - 21424'
            },
            '78:8a:20:73:6f:2c': {
                'dev_macs': ['24:4b:fe:39:0b:19'],
                'ip_address': None,
                'mac_address': '78:8a:20:73:6f:2c',
                'name': 'Foxview - 11850 - Paul Belden - '
                '17943'
            },
            '78:8a:20:73:72:15': {
                'dev_macs': ['68:d7:9a:d0:82:f8'],
                'ip_address': None,
                'mac_address': '78:8a:20:73:72:15',
                'name': 'Island View - 12260 - Thomas '
                'Shaver - 13374'
            },
            '78:8a:20:73:72:bf': {
                'dev_macs': ['80:02:9c:53:0a:b0'],
                'ip_address': None,
                'mac_address': '78:8a:20:73:72:bf',
                'name': 'Foxview - 12155 - Jeffery '
                'McGalliard - 17944'
            },
            '78:8a:20:73:79:18': {
                'dev_macs': ['00:01:9f:1e:4b:01'],
                'ip_address': None,
                'mac_address': '78:8a:20:73:79:18',
                'name': 'Foxview - 12097 - Steve Holmes - '
                '18097'
            },
            '78:8a:20:78:e8:a3': {
                'dev_macs': ['14:59:c0:a4:a6:6b'],
                'ip_address': None,
                'mac_address': '78:8a:20:78:e8:a3',
                'name': 'Foxview - 12236 - Randy Harmson '
                '- 15026'
            },
            '78:8a:20:78:f0:a5': {
                'dev_macs': ['80:cc:9c:2c:d0:ac'],
                'ip_address': None,
                'mac_address': '78:8a:20:78:f0:a5',
                'name': 'Foxview - 12191 - Jim Flutur -  '
                '13587'
            },
            '78:8a:20:c0:40:96': {
                'dev_macs': ['48:dd:0c:be:7a:20'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:40:96',
                'name': 'Foxview - 11945 - Phil Smith - '
                '17942'
            },
            '78:8a:20:c0:40:aa': {
                'dev_macs': ['74:ac:b9:fd:bc:a6'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:40:aa',
                'name': 'Foxview - 11963 - David Watkins '
                '- 17965'
            },
            '78:8a:20:c0:40:c8': {
                'dev_macs': ['30:de:4b:9e:af:e1'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:40:c8',
                'name': 'Island View - 12411 - Paul Hsieh '
                '- 17977'
            },
            '78:8a:20:c0:41:18': {
                'dev_macs': ['e0:63:da:f9:07:c8'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:41:18',
                'name': 'Foxview - 11920 - Chase, Janeen '
                '- 21513'
            },
            '78:8a:20:c0:41:2c': {
                'dev_macs': ['8c:3b:ad:3d:32:a3'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:41:2c',
                'name': 'Foxview - 12158 - Carolyn Grauer '
                '- 21816'
            },
            '78:8a:20:c0:41:45': {
                'dev_macs': ['00:01:9f:20:4e:b9'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:41:45',
                'name': 'Shores Ct - 12390 - Ann Anderson '
                '- 18014'
            },
            '78:8a:20:c0:41:54': {
                'dev_macs': ['48:8f:5a:d2:68:7d'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:41:54',
                'name': 'Christmas Cove - 10720 - Willard '
                'Kolarik'
            },
            '78:8a:20:c0:41:72': {
                'dev_macs': ['44:a5:6e:78:04:4a'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:41:72',
                'name': 'Island View - 12271 - Peter '
                'Wolcott - 13381'
            },
            '78:8a:20:c0:43:11': {
                'dev_macs': ['38:94:ed:5a:74:1e'],
                'ip_address': None,
                'mac_address': '78:8a:20:c0:43:11',
                'name': 'Shores Ct - 12375 - Joseph '
                'Defors - 15486'
            }
        }
        exp_ne_msg = {
            'data': {
                'cpu':
                4.0,
                'interfaces': [{
                    'admin_up': True,
                    'id': 'sfp1',
                    'in_octets': '17432437662040',
                    'in_ucast_pkts': '13403734956',
                    'manufacturer': 'Maxxwax',
                    'model': 'MW-SFP+DAC-1M',
                    'name': 'SFP+ 1',
                    'oper_up': True,
                    'out_octets': '1960754435039',
                    'out_ucast_pkts': '5159145010',
                    'poller_hash': 'Nzg4YTIwZmRmNzRic2ZwMWludGY=',
                    'speed': '1000000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon1',
                    'in_errors':
                    '0',
                    'in_octets':
                    '132619257054',
                    'in_ucast_pkts':
                    '478026886',
                    'links': [{
                        'in_octets': '20334980259',
                        'out_octets': '382126985882',
                        'poller_hash': 'Nzg4YTIwYzA0MGM4cGVlcmludGY='
                    }, {
                        'in_octets': '299534420',
                        'out_octets': '1200060485',
                        'poller_hash': 'MThlODI5MTliMmIxcGVlcmludGY='
                    }, {
                        'in_octets': '57927547038',
                        'out_octets': '738675917692',
                        'poller_hash': 'MThlODI5MTliNDkxcGVlcmludGY='
                    }, {
                        'in_octets': '54057044262',
                        'out_octets': '1084558219988',
                        'poller_hash': 'NjhkNzlhMDY4YWYycGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon1',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '2206807730808',
                    'out_ucast_pkts':
                    '1642226790',
                    'poller_hash':
                    'Nzg4YTIwZmRmNzRicG9uMWludGY=',
                    'pons': [{
                        'id':
                        '1',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 805,
                            'poller_hash': 'Nzg4YTIwYzA0MGM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 753,
                            'poller_hash': 'MThlODI5MTliMmIxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 979,
                            'poller_hash': 'MThlODI5MTliNDkxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581158',
                            'fiber_length': 837,
                            'poller_hash': 'NjhkNzlhMDY4YWYycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon2',
                    'in_errors':
                    '0',
                    'in_octets':
                    '982136526966',
                    'in_ucast_pkts':
                    '1764271804',
                    'links': [{
                        'in_octets': '2875320771',
                        'out_octets': '6767013935',
                        'poller_hash': 'Nzg4YTIwNzM2ZjJjcGVlcmludGY='
                    }, {
                        'in_octets': '28844222892',
                        'out_octets': '215852524750',
                        'poller_hash': 'Nzg4YTIwNzM3MjE1cGVlcmludGY='
                    }, {
                        'in_octets': '29760272385',
                        'out_octets': '1004391321993',
                        'poller_hash': 'Nzg4YTIwNzM3MmJmcGVlcmludGY='
                    }, {
                        'in_octets': '7011212619',
                        'out_octets': '5572730769',
                        'poller_hash': 'Nzg4YTIwNzM3OTE4cGVlcmludGY='
                    }, {
                        'in_octets': '65006343841',
                        'out_octets': '722698902912',
                        'poller_hash': 'Nzg4YTIwNzhlOGEzcGVlcmludGY='
                    }, {
                        'in_octets': '26498294287',
                        'out_octets': '645815695042',
                        'poller_hash': 'Nzg4YTIwNzhmMGE1cGVlcmludGY='
                    }, {
                        'in_octets': '28901479743',
                        'out_octets': '340845759857',
                        'poller_hash': 'Nzg4YTIwYzA0MDk2cGVlcmludGY='
                    }, {
                        'in_octets': '525422464390',
                        'out_octets': '875156510117',
                        'poller_hash': 'Nzg4YTIwYzA0MGFhcGVlcmludGY='
                    }, {
                        'in_octets': '6015029149',
                        'out_octets': '37764131492',
                        'poller_hash': 'Nzg4YTIwYzA0MTE4cGVlcmludGY='
                    }, {
                        'in_octets': '9495503296',
                        'out_octets': '63838111302',
                        'poller_hash': 'Nzg4YTIwYzA0MTJjcGVlcmludGY='
                    }, {
                        'in_octets': '14549160824',
                        'out_octets': '188409558464',
                        'poller_hash': 'Nzg4YTIwYzA0MTcycGVlcmludGY='
                    }, {
                        'in_octets': '214824761527',
                        'out_octets': '712397394726',
                        'poller_hash': 'MThlODI5ZjVmZjk3cGVlcmludGY='
                    }, {
                        'in_octets': '16592512237',
                        'out_octets': '252309439843',
                        'poller_hash': 'Nzg0NTU4OTUyOGE0cGVlcmludGY='
                    }, {
                        'in_octets': '2480037101',
                        'out_octets': '3867703421',
                        'poller_hash': 'NzQ4M2MyNDNmNzI4cGVlcmludGY='
                    }, {
                        'in_octets': '3859797070',
                        'out_octets': '218246124809',
                        'poller_hash': 'NzQ4M2MyNjhhZjNicGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon2',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '5294179544000',
                    'out_ucast_pkts':
                    '4227859375',
                    'poller_hash':
                    'Nzg4YTIwZmRmNzRicG9uMmludGY=',
                    'pons': [{
                        'id':
                        '2',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 2247,
                            'poller_hash': 'Nzg4YTIwNzM2ZjJjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 975,
                            'poller_hash': 'Nzg4YTIwNzM3MjE1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 1448,
                            'poller_hash': 'Nzg4YTIwNzM3MmJmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 1398,
                            'poller_hash': 'Nzg4YTIwNzM3OTE4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 1137,
                            'poller_hash': 'Nzg4YTIwNzhlOGEzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 1350,
                            'poller_hash': 'Nzg4YTIwNzhmMGE1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 1904,
                            'poller_hash': 'Nzg4YTIwYzA0MDk2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 1833,
                            'poller_hash': 'Nzg4YTIwYzA0MGFhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 1894,
                            'poller_hash': 'Nzg4YTIwYzA0MTE4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 1296,
                            'poller_hash': 'Nzg4YTIwYzA0MTJjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 951,
                            'poller_hash': 'Nzg4YTIwYzA0MTcycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 1475,
                            'poller_hash': 'MThlODI5ZjVmZjk3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 2354,
                            'poller_hash': 'Nzg0NTU4OTUyOGE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 2019,
                            'poller_hash': 'NzQ4M2MyNDNmNzI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581158',
                            'fiber_length': 1729,
                            'poller_hash': 'NzQ4M2MyNjhhZjNicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon2',
                        'poller_hash':
                        'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon3',
                    'in_errors':
                    '0',
                    'in_octets':
                    '187879663770',
                    'in_ucast_pkts':
                    '733145429',
                    'links': [{
                        'in_octets': '63692729499',
                        'out_octets': '1248255671903',
                        'poller_hash': 'Nzg4YTIwYzA0MTQ1cGVlcmludGY='
                    }, {
                        'in_octets': '5530696993',
                        'out_octets': '76576807976',
                        'poller_hash': 'Nzg4YTIwYzA0MTU0cGVlcmludGY='
                    }, {
                        'in_octets': '57572867345',
                        'out_octets': '514072433979',
                        'poller_hash': 'Nzg4YTIwYzA0MzExcGVlcmludGY='
                    }, {
                        'in_octets': '5850564344',
                        'out_octets': '195572574649',
                        'poller_hash': 'Nzg0NTU4OTBlMTg4cGVlcmludGY='
                    }, {
                        'in_octets': '28482786557',
                        'out_octets': '367692822981',
                        'poller_hash': 'NjhkNzlhMDY4NzAzcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon3',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '3205860065741',
                    'out_ucast_pkts':
                    '2484178192',
                    'poller_hash':
                    'Nzg4YTIwZmRmNzRicG9uM2ludGY=',
                    'pons': [{
                        'id':
                        '3',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 1051,
                            'poller_hash': 'Nzg4YTIwYzA0MTQ1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 1254,
                            'poller_hash': 'Nzg4YTIwYzA0MTU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4322406',
                            'fiber_length': 1160,
                            'poller_hash': 'Nzg4YTIwYzA0MzExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '696276',
                            'fiber_length': 963,
                            'poller_hash': 'Nzg0NTU4OTBlMTg4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 701,
                            'poller_hash': 'NjhkNzlhMDY4NzAzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon3',
                        'poller_hash':
                        'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon4',
                    'in_errors':
                    '0',
                    'in_octets':
                    '324120174550',
                    'in_ucast_pkts':
                    '1563494514',
                    'links': [{
                        'in_octets': '32455680456',
                        'out_octets': '678532036424',
                        'poller_hash': 'MThlODI5MTk2YzExcGVlcmludGY='
                    }, {
                        'in_octets': '1239678225',
                        'out_octets': '4915886238',
                        'poller_hash': 'MThlODI5MTk3MDdicGVlcmludGY='
                    }, {
                        'in_octets': '952532292',
                        'out_octets': '1375491216',
                        'poller_hash': 'MThlODI5MTk3NGU1cGVlcmludGY='
                    }, {
                        'in_octets': '1260143510',
                        'out_octets': '1734780886',
                        'poller_hash': 'MThlODI5MTliMGE5cGVlcmludGY='
                    }, {
                        'in_octets': '2380974756',
                        'out_octets': '4845405777',
                        'poller_hash': 'MThlODI5MTliMGY5cGVlcmludGY='
                    }, {
                        'in_octets': '1472743210',
                        'out_octets': '8140378726',
                        'poller_hash': 'MThlODI5MTliMTEycGVlcmludGY='
                    }, {
                        'in_octets': '33981904572',
                        'out_octets': '918992463273',
                        'poller_hash': 'MThlODI5MTliMjU3cGVlcmludGY='
                    }, {
                        'in_octets': '7464622801',
                        'out_octets': '154147386163',
                        'poller_hash': 'MThlODI5MTliMjYxcGVlcmludGY='
                    }, {
                        'in_octets': '36544651',
                        'out_octets': '40935539',
                        'poller_hash': 'MThlODI5MTliMjZicGVlcmludGY='
                    }, {
                        'in_octets': '1104833731',
                        'out_octets': '337998269',
                        'poller_hash': 'MThlODI5MTliMjdmcGVlcmludGY='
                    }, {
                        'in_octets': '2776436093',
                        'out_octets': '14599689500',
                        'poller_hash': 'MThlODI5MTliMjk4cGVlcmludGY='
                    }, {
                        'in_octets': '77755899',
                        'out_octets': '475854997',
                        'poller_hash': 'MThlODI5MTliMmE3cGVlcmludGY='
                    }, {
                        'in_octets': '2309536034',
                        'out_octets': '27306362339',
                        'poller_hash': 'MThlODI5MTliMmFjcGVlcmludGY='
                    }, {
                        'in_octets': '3089520612',
                        'out_octets': '33990849922',
                        'poller_hash': 'MThlODI5MTliM2Y2cGVlcmludGY='
                    }, {
                        'in_octets': '388447918',
                        'out_octets': '139759797',
                        'poller_hash': 'MThlODI5MTliNDBhcGVlcmludGY='
                    }, {
                        'in_octets': '435561254',
                        'out_octets': '297617759',
                        'poller_hash': 'Nzg0NTU4OTBkYTcwcGVlcmludGY='
                    }, {
                        'in_octets': '27249793080',
                        'out_octets': '410031384428',
                        'poller_hash': 'Nzg0NTU4OTBlMGY0cGVlcmludGY='
                    }, {
                        'in_octets': '3237963499',
                        'out_octets': '60424821524',
                        'poller_hash': 'Nzg0NTU4OTBlODk0cGVlcmludGY='
                    }, {
                        'in_octets': '176',
                        'out_octets': '0',
                        'poller_hash': 'NjhkNzlhMDY4YWFkcGVlcmludGY='
                    }, {
                        'in_octets': '51881481642',
                        'out_octets': '31896289481',
                        'poller_hash': 'NzQ4M2MyNDNmNzkwcGVlcmludGY='
                    }, {
                        'in_octets': '7828326027',
                        'out_octets': '178128411569',
                        'poller_hash': 'NzQ4M2MyNDNmYjQ2cGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon4',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '4842897763204',
                    'out_ucast_pkts':
                    '3568612716',
                    'poller_hash':
                    'Nzg4YTIwZmRmNzRicG9uNGludGY=',
                    'pons': [{
                        'id':
                        '4',
                        'links': [{
                            'connected_time': '4484758',
                            'fiber_length': 1721,
                            'poller_hash': 'MThlODI5MTk2YzExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581166',
                            'fiber_length': 1419,
                            'poller_hash': 'MThlODI5MTk3MDdicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 1361,
                            'poller_hash': 'MThlODI5MTk3NGU1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581158',
                            'fiber_length': 1874,
                            'poller_hash': 'MThlODI5MTliMGE5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 1340,
                            'poller_hash': 'MThlODI5MTliMGY5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 1356,
                            'poller_hash': 'MThlODI5MTliMTEycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 1227,
                            'poller_hash': 'MThlODI5MTliMjU3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 1776,
                            'poller_hash': 'MThlODI5MTliMjYxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '185592',
                            'fiber_length': 1747,
                            'poller_hash': 'MThlODI5MTliMjZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1737394',
                            'fiber_length': 1929,
                            'poller_hash': 'MThlODI5MTliMjdmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 1626,
                            'poller_hash': 'MThlODI5MTliMjk4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581166',
                            'fiber_length': 1966,
                            'poller_hash': 'MThlODI5MTliMmE3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581166',
                            'fiber_length': 2131,
                            'poller_hash': 'MThlODI5MTliMmFjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581158',
                            'fiber_length': 2421,
                            'poller_hash': 'MThlODI5MTliM2Y2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '575075',
                            'fiber_length': 1900,
                            'poller_hash': 'MThlODI5MTliNDBhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581168',
                            'fiber_length': 2134,
                            'poller_hash': 'Nzg0NTU4OTBkYTcwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2734303',
                            'fiber_length': 2014,
                            'poller_hash': 'Nzg0NTU4OTBlMGY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581167',
                            'fiber_length': 2366,
                            'poller_hash': 'Nzg0NTU4OTBlODk0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4581166',
                            'fiber_length': 2134,
                            'poller_hash': 'NjhkNzlhMDY4YWFkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3377329',
                            'fiber_length': 1196,
                            'poller_hash': 'NzQ4M2MyNDNmNzkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '477264',
                            'fiber_length': 2310,
                            'poller_hash': 'NzQ4M2MyNDNmYjQ2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon4',
                        'poller_hash':
                        'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up': True,
                    'id': 'eth0',
                    'in_discards': '1',
                    'in_errors': '3',
                    'in_nucast_pkts': '0',
                    'in_octets': '21243180341',
                    'in_ucast_pkts': '127696014',
                    'in_unknown_protos': '0',
                    'name': 'MGMT',
                    'oper_up': True,
                    'out_discards': '0',
                    'out_errors': '0',
                    'out_nucast_pkts': '0',
                    'out_octets': '36341474912',
                    'out_ucast_pkts': '125425445',
                    'poller_hash': 'Nzg4YTIwZmRmNzRiZXRoMGludGY=',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                13.0,
                'model':
                'UFiber OLT4',
                'serial_number':
                'UBNT20fdf74b',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:fd:f7:4b',
                'temperature':
                45.25,
                'uptime':
                '5032002'
            },
            'peers': [{
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '382126985882',
                    'links': [{
                        'in_octets': '382126985882',
                        'out_octets': '20334980259',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '20334980259',
                    'poller_hash':
                    'Nzg4YTIwYzA0MGM4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 805,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.538,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.948
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwYzA0MGM4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['30:de:4b:9e:af:e1'],
                    'id': '1',
                    'in_octets': '20334980259',
                    'mac_address': '78:8a:20:c1:40:c8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '382126985882',
                    'poller_hash': 'Nzg4YTIwYzA0MGM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12411 - Paul Hsieh - '
                '17977',
                'serial_number':
                'UBNT20c040c8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:c0:40:c8',
                'temperature':
                35.0,
                'uptime':
                '5032189'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1200060485',
                    'links': [{
                        'in_octets': '1200060485',
                        'out_octets': '299534420',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '299534420',
                    'poller_hash':
                    'MThlODI5MTliMmIxcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 753,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.832,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.28
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMmIxcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['78:d2:94:18:e9:d8'],
                    'id': '1',
                    'in_octets': '299534420',
                    'mac_address': '18:e8:29:1a:b2:b1',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1200060485',
                    'poller_hash': 'MThlODI5MTliMmIxZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12371 - Christine Polo '
                '- 20910',
                'serial_number':
                'UBNT2919b2b1',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b2:b1',
                'temperature':
                27.0,
                'uptime':
                '5032195'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '738675917692',
                    'links': [{
                        'in_octets': '738675917692',
                        'out_octets': '57927547038',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '57927547038',
                    'poller_hash':
                    'MThlODI5MTliNDkxcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 979,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.728,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.618
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliNDkxcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['60:b7:6e:1e:fa:76'],
                    'id': '1',
                    'in_octets': '57927547038',
                    'mac_address': '18:e8:29:1a:b4:91',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '738675917692',
                    'poller_hash': 'MThlODI5MTliNDkxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12515 - Brandon '
                'Theophilus - 18564',
                'serial_number':
                'UBNT2919b491',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b4:91',
                'temperature':
                35.0,
                'uptime':
                '5032196'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1084558219988',
                    'links': [{
                        'in_octets': '1084558219988',
                        'out_octets': '54057044262',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '54057044262',
                    'poller_hash':
                    'NjhkNzlhMDY4YWYycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581158',
                            'fiber_length': 837,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.354,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.968
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NjhkNzlhMDY4YWYycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['40:ed:00:a9:df:2c'],
                    'id': '1',
                    'in_octets': '54057044262',
                    'mac_address': '68:d7:9a:07:8a:f2',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1084558219988',
                    'poller_hash': 'NjhkNzlhMDY4YWYyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island View - 12445 - Stanley Pruss '
                '-  15077',
                'serial_number':
                'UBNT9a068af2',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '68:d7:9a:06:8a:f2',
                'temperature':
                32.0,
                'uptime':
                '5032185'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '6767013935',
                    'links': [{
                        'in_octets': '6767013935',
                        'out_octets': '2875320771',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2875320771',
                    'poller_hash':
                    'Nzg4YTIwNzM2ZjJjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 2247,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.426,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.566
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwNzM2ZjJjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:4b:fe:39:0b:19'],
                    'id': '1',
                    'in_octets': '2875320771',
                    'mac_address': '78:8a:20:74:6f:2c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '6767013935',
                    'poller_hash': 'Nzg4YTIwNzM2ZjJjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'Foxview - 11850 - Paul Belden - '
                '17943',
                'serial_number':
                'UBNT20736f2c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:73:6f:2c',
                'temperature':
                36.0,
                'uptime':
                '5032237'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '215852524750',
                    'links': [{
                        'in_octets': '215852524750',
                        'out_octets': '28844222892',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '28844222892',
                    'poller_hash':
                    'Nzg4YTIwNzM3MjE1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 975,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.412,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.414
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwNzM3MjE1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['68:d7:9a:d0:82:f8'],
                    'id': '1',
                    'in_octets': '28844222892',
                    'mac_address': '78:8a:20:74:72:15',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '215852524750',
                    'poller_hash': 'Nzg4YTIwNzM3MjE1ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'Island View - 12260 - Thomas Shaver '
                '- 13374',
                'serial_number':
                'UBNT20737215',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:73:72:15',
                'temperature':
                32.0,
                'uptime':
                '5032234'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1004391321993',
                    'links': [{
                        'in_octets': '1004391321993',
                        'out_octets': '29760272385',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '29760272385',
                    'poller_hash':
                    'Nzg4YTIwNzM3MmJmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 1448,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.45,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.278
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwNzM3MmJmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['80:02:9c:53:0a:b0'],
                    'id': '1',
                    'in_octets': '29760272385',
                    'mac_address': '78:8a:20:74:72:bf',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1004391321993',
                    'poller_hash': 'Nzg4YTIwNzM3MmJmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'Foxview - 12155 - Jeffery McGalliard '
                '- 17944',
                'serial_number':
                'UBNT207372bf',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:73:72:bf',
                'temperature':
                37.0,
                'uptime':
                '5032231'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '5572730769',
                    'links': [{
                        'in_octets': '5572730769',
                        'out_octets': '7011212619',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7011212619',
                    'poller_hash':
                    'Nzg4YTIwNzM3OTE4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 1398,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.788,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.412
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwNzM3OTE4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['00:01:9f:1e:4b:01'],
                    'id': '1',
                    'in_octets': '7011212619',
                    'mac_address': '78:8a:20:74:79:18',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '5572730769',
                    'poller_hash': 'Nzg4YTIwNzM3OTE4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'NanoG',
                'name':
                'Foxview - 12097 - Steve Holmes - '
                '18097',
                'serial_number':
                'UBNT20737918',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:73:79:18',
                'temperature':
                35.0,
                'uptime':
                '5032242'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '722698902912',
                    'links': [{
                        'in_octets': '722698902912',
                        'out_octets': '65006343841',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '65006343841',
                    'poller_hash':
                    'Nzg4YTIwNzhlOGEzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 1137,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.986
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwNzhlOGEzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['14:59:c0:a4:a6:6b'],
                    'id': '1',
                    'in_octets': '65006343841',
                    'mac_address': '78:8a:20:79:e8:a3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '722698902912',
                    'poller_hash': 'Nzg4YTIwNzhlOGEzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Foxview - 12236 - Randy Harmson - '
                '15026',
                'serial_number':
                'UBNT2078e8a3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:78:e8:a3',
                'temperature':
                38.0,
                'uptime':
                '5032185'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '645815695042',
                    'links': [{
                        'in_octets': '645815695042',
                        'out_octets': '26498294287',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '26498294287',
                    'poller_hash':
                    'Nzg4YTIwNzhmMGE1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 1350,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.398,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.99
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwNzhmMGE1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['80:cc:9c:2c:d0:ac'],
                    'id': '1',
                    'in_octets': '26498294287',
                    'mac_address': '78:8a:20:79:f0:a5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '645815695042',
                    'poller_hash': 'Nzg4YTIwNzhmMGE1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Foxview - 12191 - Jim Flutur -  '
                '13587',
                'serial_number':
                'UBNT2078f0a5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:78:f0:a5',
                'temperature':
                43.0,
                'uptime':
                '5032187'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '340845759857',
                    'links': [{
                        'in_octets': '340845759857',
                        'out_octets': '28901479743',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '28901479743',
                    'poller_hash':
                    'Nzg4YTIwYzA0MDk2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 1904,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.078,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.968
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwYzA0MDk2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:dd:0c:be:7a:20'],
                    'id': '1',
                    'in_octets': '28901479743',
                    'mac_address': '78:8a:20:c1:40:96',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '340845759857',
                    'poller_hash': 'Nzg4YTIwYzA0MDk2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Foxview - 11945 - Phil Smith - 17942',
                'serial_number':
                'UBNT20c04096',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:c0:40:96',
                'temperature':
                31.0,
                'uptime':
                '5032187'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '875156510117',
                    'links': [{
                        'in_octets': '875156510117',
                        'out_octets': '525422464390',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '525422464390',
                    'poller_hash':
                    'Nzg4YTIwYzA0MGFhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 1833,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.872,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.906
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwYzA0MGFhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:fd:bc:a6'],
                    'id': '1',
                    'in_octets': '525422464390',
                    'mac_address': '78:8a:20:c1:40:aa',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '875156510117',
                    'poller_hash': 'Nzg4YTIwYzA0MGFhZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Foxview - 11963 - David Watkins - '
                '17965',
                'serial_number':
                'UBNT20c040aa',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:c0:40:aa',
                'temperature':
                27.0,
                'uptime':
                '5032188'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '37764131492',
                    'links': [{
                        'in_octets': '37764131492',
                        'out_octets': '6015029149',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6015029149',
                    'poller_hash':
                    'Nzg4YTIwYzA0MTE4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 1894,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.078,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.8
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwYzA0MTE4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['e0:63:da:f9:07:c8'],
                    'id': '1',
                    'in_octets': '6015029149',
                    'mac_address': '78:8a:20:c1:41:18',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '37764131492',
                    'poller_hash': 'Nzg4YTIwYzA0MTE4ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'Foxview - 11920 - Chase, Janeen - '
                '21513',
                'serial_number':
                'UBNT20c04118',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:c0:41:18',
                'temperature':
                33.0,
                'uptime':
                '5032185'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '63838111302',
                    'links': [{
                        'in_octets': '63838111302',
                        'out_octets': '9495503296',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '9495503296',
                    'poller_hash':
                    'Nzg4YTIwYzA0MTJjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 1296,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.416,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.662
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwYzA0MTJjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['8c:3b:ad:3d:32:a3'],
                    'id': '1',
                    'in_octets': '9495503296',
                    'mac_address': '78:8a:20:c1:41:2c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '63838111302',
                    'poller_hash': 'Nzg4YTIwYzA0MTJjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Foxview - 12158 - Carolyn Grauer - '
                '21816',
                'serial_number':
                'UBNT20c0412c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:c0:41:2c',
                'temperature':
                32.0,
                'uptime':
                '5032191'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '188409558464',
                    'links': [{
                        'in_octets': '188409558464',
                        'out_octets': '14549160824',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '14549160824',
                    'poller_hash':
                    'Nzg4YTIwYzA0MTcycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 951,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.562
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwYzA0MTcycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['44:a5:6e:78:04:4a'],
                    'id': '1',
                    'in_octets': '14549160824',
                    'mac_address': '78:8a:20:c1:41:72',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '188409558464',
                    'poller_hash': 'Nzg4YTIwYzA0MTcyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12271 - Peter Wolcott '
                '- 13381',
                'serial_number':
                'UBNT20c04172',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:c0:41:72',
                'temperature':
                36.0,
                'uptime':
                '5032188'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '712397394726',
                    'links': [{
                        'in_octets': '712397394726',
                        'out_octets': '214824761527',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '214824761527',
                    'poller_hash':
                    'MThlODI5ZjVmZjk3cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 1475,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.564,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.032
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5ZjVmZjk3cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:46:e6:45'],
                    'id': '1',
                    'in_octets': '214824761527',
                    'mac_address': '18:e8:29:f6:ff:97',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '712397394726',
                    'poller_hash': 'MThlODI5ZjVmZjk3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Foxview - 12010 - Douglas Jester - '
                '16616',
                'serial_number':
                'UBNT29f5ff97',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:f5:ff:97',
                'temperature':
                28.0,
                'uptime':
                '5032179'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '252309439843',
                    'links': [{
                        'in_octets': '252309439843',
                        'out_octets': '16592512237',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '16592512237',
                    'poller_hash':
                    'Nzg0NTU4OTUyOGE0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 2354,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.938,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.556
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTUyOGE0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['28:87:ba:76:31:21'],
                    'id': '1',
                    'in_octets': '16592512237',
                    'mac_address': '78:45:58:96:28:a4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '252309439843',
                    'poller_hash': 'Nzg0NTU4OTUyOGE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Peterson Park - 10323 - Rich Simons '
                '- 21424',
                'serial_number':
                'UBNT589528a4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:45:58:95:28:a4',
                'temperature':
                31.0,
                'uptime':
                '8187325'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3867703421',
                    'links': [{
                        'in_octets': '3867703421',
                        'out_octets': '2480037101',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2480037101',
                    'poller_hash':
                    'NzQ4M2MyNDNmNzI4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 2019,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -25.228,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.696
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNDNmNzI4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:b6:b6:05:8c:80'],
                    'id': '1',
                    'in_octets': '2480037101',
                    'mac_address': '74:83:c2:44:f7:28',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3867703421',
                    'poller_hash': 'NzQ4M2MyNDNmNzI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'Foxview - 11907 - Todd Hoogland - '
                '17100',
                'serial_number':
                'UBNTc243f728',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '74:83:c2:43:f7:28',
                'temperature':
                26.0,
                'uptime':
                '5032181'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '218246124809',
                    'links': [{
                        'in_octets': '218246124809',
                        'out_octets': '3859797070',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3859797070',
                    'poller_hash':
                    'NzQ4M2MyNjhhZjNicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581158',
                            'fiber_length': 1729,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.35,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.708
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhhZjNicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['8c:3b:ad:f1:f0:12'],
                    'id': '1',
                    'in_octets': '3859797070',
                    'mac_address': '74:83:c2:69:af:3b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '218246124809',
                    'poller_hash': 'NzQ4M2MyNjhhZjNiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                'N Foxview - 11981 - Tina Serne - '
                '17978',
                'serial_number':
                'UBNTc268af3b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '74:83:c2:68:af:3b',
                'temperature':
                27.0,
                'uptime':
                '5032221'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1248255671903',
                    'links': [{
                        'in_octets': '1248255671903',
                        'out_octets': '63692729499',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '63692729499',
                    'poller_hash':
                    'Nzg4YTIwYzA0MTQ1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 1051,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.532,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.618
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwYzA0MTQ1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['00:01:9f:20:4e:b9'],
                    'id': '1',
                    'in_octets': '63692729499',
                    'mac_address': '78:8a:20:c1:41:45',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1248255671903',
                    'poller_hash': 'Nzg4YTIwYzA0MTQ1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Shores Ct - 12390 - Ann Anderson - '
                '18014',
                'serial_number':
                'UBNT20c04145',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:c0:41:45',
                'temperature':
                31.0,
                'uptime':
                '5032190'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '76576807976',
                    'links': [{
                        'in_octets': '76576807976',
                        'out_octets': '5530696993',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5530696993',
                    'poller_hash':
                    'Nzg4YTIwYzA0MTU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 1254,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.898
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwYzA0MTU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:8f:5a:d2:68:7d'],
                    'id': '1',
                    'in_octets': '5530696993',
                    'mac_address': '78:8a:20:c1:41:54',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '76576807976',
                    'poller_hash': 'Nzg4YTIwYzA0MTU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Christmas Cove - 10720 - Willard '
                'Kolarik',
                'serial_number':
                'UBNT20c04154',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:c0:41:54',
                'temperature':
                33.0,
                'uptime':
                '5255084'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '514072433979',
                    'links': [{
                        'in_octets': '514072433979',
                        'out_octets': '57572867345',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '57572867345',
                    'poller_hash':
                    'Nzg4YTIwYzA0MzExcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4322406',
                            'fiber_length': 1160,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.088,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.982
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg4YTIwYzA0MzExcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['38:94:ed:5a:74:1e'],
                    'id': '1',
                    'in_octets': '57572867345',
                    'mac_address': '78:8a:20:c1:43:11',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '514072433979',
                    'poller_hash': 'Nzg4YTIwYzA0MzExZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Shores Ct - 12375 - Joseph Defors - '
                '15486',
                'serial_number':
                'UBNT20c04311',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:8a:20:c0:43:11',
                'temperature':
                34.0,
                'uptime':
                '4322459'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '195572574649',
                    'links': [{
                        'in_octets': '195572574649',
                        'out_octets': '5850564344',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5850564344',
                    'poller_hash':
                    'Nzg0NTU4OTBlMTg4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '696276',
                            'fiber_length': 963,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.316,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.266
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTBlMTg4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['c0:06:c3:2f:d4:3d'],
                    'id': '1',
                    'in_octets': '5850564344',
                    'mac_address': '78:45:58:91:e1:88',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '195572574649',
                    'poller_hash': 'Nzg0NTU4OTBlMTg4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Shores Ct - 12372 - Maginot, Anne & '
                'Peter - 20791',
                'serial_number':
                'UBNT5890e188',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:45:58:90:e1:88',
                'temperature':
                28.0,
                'uptime':
                '738817'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '367692822981',
                    'links': [{
                        'in_octets': '367692822981',
                        'out_octets': '28482786557',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '28482786557',
                    'poller_hash':
                    'NjhkNzlhMDY4NzAzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 701,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.324,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.784
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NjhkNzlhMDY4NzAzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['cc:40:d0:50:f6:20'],
                    'id': '1',
                    'in_octets': '28482786557',
                    'mac_address': '68:d7:9a:07:87:03',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '367692822981',
                    'poller_hash': 'NjhkNzlhMDY4NzAzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island View - 12331 - William Cron - '
                '13536',
                'serial_number':
                'UBNT9a068703',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '68:d7:9a:06:87:03',
                'temperature':
                34.0,
                'uptime':
                '5032185'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '678532036424',
                    'links': [{
                        'in_octets': '678532036424',
                        'out_octets': '32455680456',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '32455680456',
                    'poller_hash':
                    'MThlODI5MTk2YzExcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4484758',
                            'fiber_length': 1721,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.934,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.534
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTk2YzExcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['a0:40:a0:71:2d:88'],
                    'id': '1',
                    'in_octets': '32455680456',
                    'mac_address': '18:e8:29:1a:6c:11',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '678532036424',
                    'poller_hash': 'MThlODI5MTk2YzExZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12705 - Karen '
                'Mulvahill - 14204',
                'serial_number':
                'UBNT29196c11',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:6c:11',
                'temperature':
                28.0,
                'uptime':
                '4484807'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4915886238',
                    'links': [{
                        'in_octets': '4915886238',
                        'out_octets': '1239678225',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1239678225',
                    'poller_hash':
                    'MThlODI5MTk3MDdicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581166',
                            'fiber_length': 1419,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.016,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.66
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTk3MDdicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['10:0c:6b:2d:94:8a'],
                    'id': '1',
                    'in_octets': '1239678225',
                    'mac_address': '18:e8:29:1a:70:7b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4915886238',
                    'poller_hash': 'MThlODI5MTk3MDdiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island View-12545-John Wadas-16542',
                'serial_number':
                'UBNT2919707b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:70:7b',
                'temperature':
                40.0,
                'uptime':
                '5032193'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1375491216',
                    'links': [{
                        'in_octets': '1375491216',
                        'out_octets': '952532292',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '952532292',
                    'poller_hash':
                    'MThlODI5MTk3NGU1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 1361,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.664,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.406
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTk3NGU1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['e0:63:da:99:cd:79'],
                    'id': '1',
                    'in_octets': '952532292',
                    'mac_address': '18:e8:29:1a:74:e5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1375491216',
                    'poller_hash': 'MThlODI5MTk3NGU1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'Loco',
                'name':
                'Island View - 12571 - John Scott - '
                '18909',
                'serial_number':
                'UBNT291974e5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:74:e5',
                'temperature':
                37.0,
                'uptime':
                '5032194'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1734780886',
                    'links': [{
                        'in_octets': '1734780886',
                        'out_octets': '1260143510',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1260143510',
                    'poller_hash':
                    'MThlODI5MTliMGE5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581158',
                            'fiber_length': 1874,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.494,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.626
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMGE5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:37:86:c8:4c:76'],
                    'id': '1',
                    'in_octets': '1260143510',
                    'mac_address': '18:e8:29:1a:b0:a9',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1734780886',
                    'poller_hash': 'MThlODI5MTliMGE5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island View - 12771 - Bill Brown - '
                '13712',
                'serial_number':
                'UBNT2919b0a9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b0:a9',
                'temperature':
                30.0,
                'uptime':
                '5032196'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4845405777',
                    'links': [{
                        'in_octets': '4845405777',
                        'out_octets': '2380974756',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2380974756',
                    'poller_hash':
                    'MThlODI5MTliMGY5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 1340,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.168,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.64
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMGY5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['b0:39:56:50:a7:80'],
                    'id': '1',
                    'in_octets': '2380974756',
                    'mac_address': '18:e8:29:1a:b0:f9',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4845405777',
                    'poller_hash': 'MThlODI5MTliMGY5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island View - 12563 - Don DAnnunzio '
                '- 17717',
                'serial_number':
                'UBNT2919b0f9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b0:f9',
                'temperature':
                35.0,
                'uptime':
                '5032197'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '8140378726',
                    'links': [{
                        'in_octets': '8140378726',
                        'out_octets': '1472743210',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1472743210',
                    'poller_hash':
                    'MThlODI5MTliMTEycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 1356,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.326,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.692
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMTEycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['a0:04:60:04:24:be'],
                    'id': '1',
                    'in_octets': '1472743210',
                    'mac_address': '18:e8:29:1a:b1:12',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '8140378726',
                    'poller_hash': 'MThlODI5MTliMTEyZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12585 - Ronald Jones - '
                '14376',
                'serial_number':
                'UBNT2919b112',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b1:12',
                'temperature':
                32.0,
                'uptime':
                '5032199'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '918992463273',
                    'links': [{
                        'in_octets': '918992463273',
                        'out_octets': '33981904572',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '33981904572',
                    'poller_hash':
                    'MThlODI5MTliMjU3cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 1227,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.634,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.768
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMjU3cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['f4:92:bf:66:6a:d1'],
                    'id': '1',
                    'in_octets': '33981904572',
                    'mac_address': '18:e8:29:1a:b2:57',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '918992463273',
                    'poller_hash': 'MThlODI5MTliMjU3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12527 - John '
                'Christophersen - 17017',
                'serial_number':
                'UBNT2919b257',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b2:57',
                'temperature':
                37.0,
                'uptime':
                '5032197'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '154147386163',
                    'links': [{
                        'in_octets': '154147386163',
                        'out_octets': '7464622801',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7464622801',
                    'poller_hash':
                    'MThlODI5MTliMjYxcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 1776,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.042,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.496
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMjYxcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['6c:b0:ce:10:fa:03'],
                    'id': '1',
                    'in_octets': '7464622801',
                    'mac_address': '18:e8:29:1a:b2:61',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '154147386163',
                    'poller_hash': 'MThlODI5MTliMjYxZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12755 - Paul '
                'Christopheren - 16068',
                'serial_number':
                'UBNT2919b261',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b2:61',
                'temperature':
                30.0,
                'uptime':
                '5032201'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '40935539',
                    'links': [{
                        'in_octets': '40935539',
                        'out_octets': '36544651',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '36544651',
                    'poller_hash':
                    'MThlODI5MTliMjZicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '185592',
                            'fiber_length': 1747,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.366,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.638
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMjZicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['10:0c:6b:d6:f0:fe'],
                    'id': '1',
                    'in_octets': '36544651',
                    'mac_address': '18:e8:29:1a:b2:6b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '40935539',
                    'poller_hash': 'MThlODI5MTliMjZiZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12727 - Rich Sutliff - '
                '14696',
                'serial_number':
                'UBNT2919b26b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b2:6b',
                'temperature':
                31.0,
                'uptime':
                '185648'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '337998269',
                    'links': [{
                        'in_octets': '337998269',
                        'out_octets': '1104833731',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1104833731',
                    'poller_hash':
                    'MThlODI5MTliMjdmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1737394',
                            'fiber_length': 1929,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.19,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.39
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMjdmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['78:d2:94:18:c2:98'],
                    'id': '1',
                    'in_octets': '1104833731',
                    'mac_address': '18:e8:29:1a:b2:7f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '337998269',
                    'poller_hash': 'MThlODI5MTliMjdmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12811 - Robert Shirkey '
                '- 13719',
                'serial_number':
                'UBNT2919b27f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b2:7f',
                'temperature':
                37.0,
                'uptime':
                '1737450'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '14599689500',
                    'links': [{
                        'in_octets': '14599689500',
                        'out_octets': '2776436093',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2776436093',
                    'poller_hash':
                    'MThlODI5MTliMjk4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 1626,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.272,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.088
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMjk4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['d8:07:b6:74:c5:ee'],
                    'id': '1',
                    'in_octets': '2776436093',
                    'mac_address': '18:e8:29:1a:b2:98',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '14599689500',
                    'poller_hash': 'MThlODI5MTliMjk4ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island VIew - 12655 - Al Blinke - '
                '15472',
                'serial_number':
                'UBNT2919b298',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b2:98',
                'temperature':
                35.0,
                'uptime':
                '5032197'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '475854997',
                    'links': [{
                        'in_octets': '475854997',
                        'out_octets': '77755899',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '77755899',
                    'poller_hash':
                    'MThlODI5MTliMmE3cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581166',
                            'fiber_length': 1966,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.362,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.428
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMmE3cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['f8:32:e4:b2:fc:50'],
                    'id': '1',
                    'in_octets': '77755899',
                    'mac_address': '18:e8:29:1a:b2:a7',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '475854997',
                    'poller_hash': 'MThlODI5MTliMmE3ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12831 - DomeHouse LLC '
                '- 13718',
                'serial_number':
                'UBNT2919b2a7',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b2:a7',
                'temperature':
                30.0,
                'uptime':
                '5032200'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '27306362339',
                    'links': [{
                        'in_octets': '27306362339',
                        'out_octets': '2309536034',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2309536034',
                    'poller_hash':
                    'MThlODI5MTliMmFjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581166',
                            'fiber_length': 2131,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.644,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.742
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliMmFjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['08:36:c9:14:fc:10'],
                    'id': '1',
                    'in_octets': '2309536034',
                    'mac_address': '18:e8:29:1a:b2:ac',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '27306362339',
                    'poller_hash': 'MThlODI5MTliMmFjZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island View - 12891 - Terry Fera - '
                '15115',
                'serial_number':
                'UBNT2919b2ac',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b2:ac',
                'temperature':
                34.0,
                'uptime':
                '5032197'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '33990849922',
                    'links': [{
                        'in_octets': '33990849922',
                        'out_octets': '3089520612',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3089520612',
                    'poller_hash':
                    'MThlODI5MTliM2Y2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581158',
                            'fiber_length': 2421,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.594,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.56
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliM2Y2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['6c:3b:6b:92:e4:29'],
                    'id': '1',
                    'in_octets': '3089520612',
                    'mac_address': '18:e8:29:1a:b3:f6',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '33990849922',
                    'poller_hash': 'MThlODI5MTliM2Y2ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12973 - Christine Kay '
                '- 16910',
                'serial_number':
                'UBNT2919b3f6',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b3:f6',
                'temperature':
                34.0,
                'uptime':
                '5032192'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '139759797',
                    'links': [{
                        'in_octets': '139759797',
                        'out_octets': '388447918',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '388447918',
                    'poller_hash':
                    'MThlODI5MTliNDBhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '575075',
                            'fiber_length': 1900,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.212,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.342
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MTliNDBhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['e0:63:da:f9:95:4f'],
                    'id': '1',
                    'in_octets': '388447918',
                    'mac_address': '18:e8:29:1a:b4:0a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '139759797',
                    'poller_hash': 'MThlODI5MTliNDBhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'Island View - 12803 - Stephen '
                'Rigotti - 14850',
                'serial_number':
                'UBNT2919b40a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:19:b4:0a',
                'temperature':
                35.0,
                'uptime':
                '575128'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '297617759',
                    'links': [{
                        'in_octets': '297617759',
                        'out_octets': '435561254',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '435561254',
                    'poller_hash':
                    'Nzg0NTU4OTBkYTcwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581168',
                            'fiber_length': 2134,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.544,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.7
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTBkYTcwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['40:ed:00:85:28:a5'],
                    'id': '1',
                    'in_octets': '435561254',
                    'mac_address': '78:45:58:91:da:70',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '297617759',
                    'poller_hash': 'Nzg0NTU4OTBkYTcwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island View - 12875 - Bridget Lamont '
                '- 13721',
                'serial_number':
                'UBNT5890da70',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:45:58:90:da:70',
                'temperature':
                28.0,
                'uptime':
                '5032195'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '410031384428',
                    'links': [{
                        'in_octets': '410031384428',
                        'out_octets': '27249793080',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27249793080',
                    'poller_hash':
                    'Nzg0NTU4OTBlMGY0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2734303',
                            'fiber_length': 2014,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.912,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.364
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTBlMGY0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['c8:9e:43:db:81:8b'],
                    'id': '1',
                    'in_octets': '27249793080',
                    'mac_address': '78:45:58:91:e0:f4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '410031384428',
                    'poller_hash': 'Nzg0NTU4OTBlMGY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island View - 12851 - Joanne Whitley '
                '- 14649',
                'serial_number':
                'UBNT5890e0f4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:45:58:90:e0:f4',
                'temperature':
                30.0,
                'uptime':
                '2734357'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '60424821524',
                    'links': [{
                        'in_octets': '60424821524',
                        'out_octets': '3237963499',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3237963499',
                    'poller_hash':
                    'Nzg0NTU4OTBlODk0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581167',
                            'fiber_length': 2366,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.142,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.622
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTBlODk0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:91:e3:43:0d:f4'],
                    'id': '1',
                    'in_octets': '3237963499',
                    'mac_address': '78:45:58:91:e8:94',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '60424821524',
                    'poller_hash': 'Nzg0NTU4OTBlODk0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island Lake Dr - 13015 -Marilee '
                'Milroy - 13348',
                'serial_number':
                'UBNT5890e894',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '78:45:58:90:e8:94',
                'temperature':
                26.0,
                'uptime':
                '5032196'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '0',
                    'links': [{
                        'in_octets': '0',
                        'out_octets': '176',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '176',
                    'poller_hash':
                    'NjhkNzlhMDY4YWFkcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4581166',
                            'fiber_length': 2134,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.798,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.486
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NjhkNzlhMDY4YWFkcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'mac_address': '68:d7:9a:07:8a:ad',
                    'name': 'eth0',
                    'oper_up': False,
                    'poller_hash': 'NjhkNzlhMDY4YWFkZXRoMQ=='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island Dr - 12901 - Dan Cermak - '
                '20905',
                'serial_number':
                'UBNT9a068aad',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '68:d7:9a:06:8a:ad',
                'temperature':
                23.0,
                'uptime':
                '5032185'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '31896289481',
                    'links': [{
                        'in_octets': '31896289481',
                        'out_octets': '51881481642',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '51881481642',
                    'poller_hash':
                    'NzQ4M2MyNDNmNzkwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3377329',
                            'fiber_length': 1196,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.586,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.672
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNDNmNzkwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:32:d5:d1'],
                    'id': '1',
                    'in_octets': '51881481642',
                    'mac_address': '74:83:c2:44:f7:90',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '31896289481',
                    'poller_hash': 'NzQ4M2MyNDNmNzkwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island View - 12531 - Malcolm Hickok '
                '- 21903',
                'serial_number':
                'UBNTc243f790',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '74:83:c2:43:f7:90',
                'temperature':
                31.0,
                'uptime':
                '3377385'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '178128411569',
                    'links': [{
                        'in_octets': '178128411569',
                        'out_octets': '7828326027',
                        'poller_hash': 'Nzg4YTIwZmRmNzRicG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7828326027',
                    'poller_hash':
                    'NzQ4M2MyNDNmYjQ2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '477264',
                            'fiber_length': 2310,
                            'poller_hash': 'Nzg4YTIwZmRmNzRiVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.664,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.31
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNDNmYjQ2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['14:91:82:2e:cf:55'],
                    'id': '1',
                    'in_octets': '7828326027',
                    'mac_address': '74:83:c2:44:fb:46',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '178128411569',
                    'poller_hash': 'NzQ4M2MyNDNmYjQ2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'Loco',
                'name':
                'Island View Dr - 12931 - Judy Burns '
                '- 15696',
                'serial_number':
                'UBNTc243fb46',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '74:83:c2:43:fb:46',
                'temperature':
                33.0,
                'uptime':
                '477324'
            }]
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_4_4_9_172_21_44_6(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.4.4.9.172_21_44_6")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 16,
            'sw_version': '4.4.9',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': 1}
        exp_sta_stats = {
            '18:e8:29:0b:9a:d8': {
                'dev_macs': ['74:4d:28:5b:15:46'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:9a:d8',
                'name': '22062-christina-king'
            },
            '18:e8:29:0b:b2:60': {
                'dev_macs': ['1c:b7:2c:73:fb:88'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:b2:60',
                'name': '756737-blake-bennetts'
            },
            '18:e8:29:0b:d5:8c': {
                'dev_macs': ['78:9a:18:42:bd:d4'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:d5:8c',
                'name': '23673-luke-urbine-nanog'
            },
            '18:e8:29:0b:d5:e4': {
                'dev_macs': ['c8:7f:54:27:30:80'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:d5:e4',
                'name': '756708-dallas-campbell'
            },
            '18:e8:29:0b:f7:10': {
                'dev_macs': ['48:a9:8a:3a:a4:36'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:f7:10',
                'name': '756279-alison-peticolas'
            },
            '18:e8:29:0b:f8:04': {
                'dev_macs': ['d8:07:b6:f8:97:5e'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:f8:04',
                'name': '26323-brett-wingo'
            },
            '18:e8:29:0b:f9:c0': {
                'dev_macs': ['48:8f:5a:48:c3:db'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:f9:c0',
                'name': '21839-greg-turner'
            },
            '18:e8:29:0b:f9:ec': {
                'dev_macs': ['78:9a:18:90:0c:6f'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:f9:ec',
                'name': '756755-michael-blashka'
            },
            '18:e8:29:f5:80:54': {
                'dev_macs': ['18:b1:69:e3:c3:a1'],
                'ip_address': None,
                'mac_address': '18:e8:29:f5:80:54',
                'name': '22049-Darren Patterson Christian '
                'Academy'
            },
            '18:e8:29:f5:b0:72': {
                'dev_macs': ['68:d7:9a:67:b9:2d'],
                'ip_address': None,
                'mac_address': '18:e8:29:f5:b0:72',
                'name': '10340-carlin-walsh-ufiberwifi'
            },
            '74:83:c2:f0:1e:90': {
                'dev_macs': ['48:a9:8a:5f:bc:94'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:1e:90',
                'name': '756289-evan-bartlett-nanog'
            },
            '74:83:c2:f0:b1:a4': {
                'dev_macs': ['18:fd:74:1c:bf:7a'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:b1:a4',
                'name': '756084-anna-toll'
            },
            'b4:fb:e4:eb:4d:58': {
                'dev_macs': ['48:8f:5a:49:bf:9b'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:eb:4d:58',
                'name': '10523-jay-leaver-nanog'
            },
            'b4:fb:e4:eb:4d:62': {
                'dev_macs': ['34:98:b5:c4:4e:11'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:eb:4d:62',
                'name': '24017-grace-garret-nanog'
            },
            'b4:fb:e4:eb:50:73': {
                'dev_macs': ['48:8f:5a:82:a9:f7'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:eb:50:73',
                'name': '20157-ellen-kelly-nanog'
            }
        }
        exp_ne_msg = {
            'data': {
                'cpu':
                1.0,
                'interfaces': [{
                    'admin_up': True,
                    'id': 'eth0',
                    'in_discards': '2',
                    'in_errors': '0',
                    'in_nucast_pkts': '0',
                    'in_octets': '20388745886',
                    'in_ucast_pkts': '86765026',
                    'in_unknown_protos': '0',
                    'name': 'MGMT',
                    'oper_up': True,
                    'out_discards': '0',
                    'out_errors': '0',
                    'out_nucast_pkts': '0',
                    'out_octets': '22445466182',
                    'out_ucast_pkts': '113743252',
                    'poller_hash': 'YjRmYmU0MWIyODc1ZXRoMGludGY=',
                    'speed': '1000000000'
                }, {
                    'admin_up': True,
                    'id': 'pon1',
                    'name': 'pon1',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uMWludGY='
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon2',
                    'in_errors':
                    '0',
                    'in_octets':
                    '1120555480947',
                    'in_ucast_pkts':
                    '3004647724',
                    'links': [{
                        'in_octets': '60038134941',
                        'out_octets': '433845025854',
                        'poller_hash': 'MThlODI5MGI5YWQ4cGVlcmludGY='
                    }, {
                        'in_octets': '51597476640',
                        'out_octets': '376473216479',
                        'poller_hash': 'MThlODI5MGJiMjYwcGVlcmludGY='
                    }, {
                        'in_octets': '77031716161',
                        'out_octets': '1285929769043',
                        'poller_hash': 'MThlODI5MGJmODA0cGVlcmludGY='
                    }, {
                        'in_octets': '55272372563',
                        'out_octets': '654710786269',
                        'poller_hash': 'MThlODI5MGJmOWMwcGVlcmludGY='
                    }, {
                        'in_octets': '140405299525',
                        'out_octets': '758396543589',
                        'poller_hash': 'MThlODI5ZjU4MDU0cGVlcmludGY='
                    }, {
                        'in_octets': '13635545316',
                        'out_octets': '153401865394',
                        'poller_hash': 'MThlODI5ZjViMDcycGVlcmludGY='
                    }, {
                        'in_octets': '79506814602',
                        'out_octets': '877525143799',
                        'poller_hash': 'NzQ4M2MyZjAxZTkwcGVlcmludGY='
                    }, {
                        'in_octets': '33624625113',
                        'out_octets': '343333914855',
                        'poller_hash': 'NzQ4M2MyZjBiMWE0cGVlcmludGY='
                    }, {
                        'in_octets': '6190169311',
                        'out_octets': '26759028333',
                        'poller_hash': 'YjRmYmU0ZWI0ZDU4cGVlcmludGY='
                    }, {
                        'in_octets': '16408151466',
                        'out_octets': '244967364534',
                        'poller_hash': 'YjRmYmU0ZWI0ZDYycGVlcmludGY='
                    }, {
                        'in_octets': '30361231639',
                        'out_octets': '882718479596',
                        'poller_hash': 'YjRmYmU0ZWI1MDczcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon2',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '11228178267328',
                    'out_ucast_pkts':
                    '8601966144',
                    'poller_hash':
                    'YjRmYmU0MWIyODc1cG9uMmludGY=',
                    'pons': [{
                        'id':
                        '2',
                        'links': [{
                            'connected_time': '5605556',
                            'fiber_length': 330,
                            'poller_hash': 'MThlODI5MGI5YWQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3604765',
                            'fiber_length': 666,
                            'poller_hash': 'MThlODI5MGJiMjYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2561113',
                            'fiber_length': 82,
                            'poller_hash': 'MThlODI5MGJmODA0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3890178',
                            'fiber_length': 407,
                            'poller_hash': 'MThlODI5MGJmOWMwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3699886',
                            'fiber_length': 775,
                            'poller_hash': 'MThlODI5ZjU4MDU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '389919',
                            'fiber_length': 14,
                            'poller_hash': 'MThlODI5ZjViMDcycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7496547',
                            'fiber_length': 644,
                            'poller_hash': 'NzQ4M2MyZjAxZTkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2409532',
                            'fiber_length': 892,
                            'poller_hash': 'NzQ4M2MyZjBiMWE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7496546',
                            'fiber_length': 276,
                            'poller_hash': 'YjRmYmU0ZWI0ZDU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7496546',
                            'fiber_length': 299,
                            'poller_hash': 'YjRmYmU0ZWI0ZDYycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7496537',
                            'fiber_length': 333,
                            'poller_hash': 'YjRmYmU0ZWI1MDczcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon2',
                        'poller_hash':
                        'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up': True,
                    'id': 'pon3',
                    'name': 'pon3',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uM2ludGY='
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon4',
                    'in_errors':
                    '0',
                    'in_octets':
                    '127260632961',
                    'in_ucast_pkts':
                    '499224099',
                    'links': [{
                        'in_octets': '36518536949',
                        'out_octets': '548885766037',
                        'poller_hash': 'MThlODI5MGJkNThjcGVlcmludGY='
                    }, {
                        'in_octets': '11447796092',
                        'out_octets': '194847602663',
                        'poller_hash': 'MThlODI5MGJkNWU0cGVlcmludGY='
                    }, {
                        'in_octets': '44346977227',
                        'out_octets': '554524252919',
                        'poller_hash': 'MThlODI5MGJmNzEwcGVlcmludGY='
                    }, {
                        'in_octets': '28361070702',
                        'out_octets': '276946513313',
                        'poller_hash': 'MThlODI5MGJmOWVjcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon4',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '1645173503700',
                    'out_ucast_pkts':
                    '1273390540',
                    'poller_hash':
                    'YjRmYmU0MWIyODc1cG9uNGludGY=',
                    'pons': [{
                        'id':
                        '4',
                        'links': [{
                            'connected_time': '6636377',
                            'fiber_length': 1098,
                            'poller_hash': 'MThlODI5MGJkNThjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6280693',
                            'fiber_length': 980,
                            'poller_hash': 'MThlODI5MGJkNWU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6654297',
                            'fiber_length': 920,
                            'poller_hash': 'MThlODI5MGJmNzEwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2856206',
                            'fiber_length': 852,
                            'poller_hash': 'MThlODI5MGJmOWVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon4',
                        'poller_hash':
                        'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up': True,
                    'id': 'pon5',
                    'name': 'pon5',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uNWludGY='
                }, {
                    'admin_up': True,
                    'id': 'pon6',
                    'name': 'pon6',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uNmludGY='
                }, {
                    'admin_up': True,
                    'id': 'pon7',
                    'name': 'pon7',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uN2ludGY='
                }, {
                    'admin_up': True,
                    'id': 'pon8',
                    'name': 'pon8',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0MWIyODc1cG9uOGludGY='
                }, {
                    'admin_up': True,
                    'id': 'sfp1',
                    'in_octets': '12833913779436',
                    'in_ucast_pkts': '9877430610',
                    'manufacturer': 'OEM',
                    'model': 'HWDA0001',
                    'name': 'SFP+ 1',
                    'oper_up': True,
                    'out_octets': '1233848286561',
                    'out_ucast_pkts': '3503991099',
                    'poller_hash': 'YjRmYmU0MWIyODc1c2ZwMWludGY=',
                    'speed': '10000000000'
                }, {
                    'admin_up': True,
                    'id': 'sfp2',
                    'name': 'SFP+ 2',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0MWIyODc1c2ZwMmludGY='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                13.0,
                'model':
                'UFiber OLT',
                'serial_number':
                'UBNTe41b2875',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                'b4:fb:e4:1b:28:75',
                'temperature':
                30.25,
                'uptime':
                '7496661'
            },
            'peers': [{
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '433845025854',
                    'links': [{
                        'in_octets': '433845025854',
                        'out_octets': '60038134941',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '60038134941',
                    'poller_hash':
                    'MThlODI5MGI5YWQ4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '5605556',
                            'fiber_length': 330,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.392,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.716
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI5YWQ4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:4d:28:5b:15:46'],
                    'id': '1',
                    'in_octets': '60038134941',
                    'mac_address': '18:e8:29:0c:9a:d8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '433845025854',
                    'poller_hash': 'MThlODI5MGI5YWQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '22062-christina-king',
                'serial_number':
                'UBNT290b9ad8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '18:e8:29:0b:9a:d8',
                'temperature':
                48.0,
                'uptime':
                '5605599'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '376473216479',
                    'links': [{
                        'in_octets': '376473216479',
                        'out_octets': '51597476640',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '51597476640',
                    'poller_hash':
                    'MThlODI5MGJiMjYwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3604765',
                            'fiber_length': 666,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.988,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.118
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGJiMjYwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['1c:b7:2c:73:fb:88'],
                    'id': '1',
                    'in_octets': '51597476640',
                    'mac_address': '18:e8:29:0c:b2:60',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '376473216479',
                    'poller_hash': 'MThlODI5MGJiMjYwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '756737-blake-bennetts',
                'serial_number':
                'UBNT290bb260',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '18:e8:29:0b:b2:60',
                'temperature':
                50.0,
                'uptime':
                '3604806'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1285929769043',
                    'links': [{
                        'in_octets': '1285929769043',
                        'out_octets': '77031716161',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '77031716161',
                    'poller_hash':
                    'MThlODI5MGJmODA0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2561113',
                            'fiber_length': 82,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.466,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.494
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGJmODA0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['d8:07:b6:f8:97:5e'],
                    'id': '1',
                    'in_octets': '77031716161',
                    'mac_address': '18:e8:29:0c:f8:04',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1285929769043',
                    'poller_hash': 'MThlODI5MGJmODA0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '26323-brett-wingo',
                'serial_number':
                'UBNT290bf804',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '18:e8:29:0b:f8:04',
                'temperature':
                37.0,
                'uptime':
                '2561157'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '654710786269',
                    'links': [{
                        'in_octets': '654710786269',
                        'out_octets': '55272372563',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '55272372563',
                    'poller_hash':
                    'MThlODI5MGJmOWMwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3890178',
                            'fiber_length': 407,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.022,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.214
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGJmOWMwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:8f:5a:48:c3:db'],
                    'id': '1',
                    'in_octets': '55272372563',
                    'mac_address': '18:e8:29:0c:f9:c0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '654710786269',
                    'poller_hash': 'MThlODI5MGJmOWMwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '21839-greg-turner',
                'serial_number':
                'UBNT290bf9c0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '18:e8:29:0b:f9:c0',
                'temperature':
                40.0,
                'uptime':
                '3890220'
            }, {
                'admin_disabled':
                False,
                'cpu':
                0.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '758396543589',
                    'links': [{
                        'in_octets': '758396543589',
                        'out_octets': '140405299525',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '140405299525',
                    'poller_hash':
                    'MThlODI5ZjU4MDU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3699886',
                            'fiber_length': 775,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.766,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.532
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5ZjU4MDU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['18:b1:69:e3:c3:a1'],
                    'id': '1',
                    'in_octets': '140405299525',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '758396543589',
                    'poller_hash': 'MThlODI5ZjU4MDU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                39.0,
                'model':
                'Instant',
                'name':
                '22049-Darren Patterson Christian '
                'Academy',
                'serial_number':
                'UBNT29f58054',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '18:e8:29:f5:80:54',
                'temperature':
                82.0,
                'uptime':
                '3699919'
            }, {
                'admin_disabled':
                False,
                'cpu':
                50.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '153401865394',
                    'links': [{
                        'in_octets': '153401865394',
                        'out_octets': '13635545316',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '13635545316',
                    'poller_hash':
                    'MThlODI5ZjViMDcycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '389919',
                            'fiber_length': 14,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.52,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.648
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5ZjViMDcycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'name': 'eth0',
                    'oper_up': False,
                    'poller_hash': 'MThlODI5ZjViMDcyZXRoMQ=='
                }, {
                    'admin_up': True,
                    'id': '2',
                    'name': 'eth1',
                    'oper_up': False,
                    'poller_hash': 'MThlODI5ZjViMDcyZXRoMg=='
                }, {
                    'admin_up': True,
                    'id': '3',
                    'name': 'eth2',
                    'oper_up': False,
                    'poller_hash': 'MThlODI5ZjViMDcyZXRoMw=='
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['68:d7:9a:67:b9:2d'],
                    'id': '4',
                    'in_octets': '276638288894',
                    'name': 'eth3',
                    'oper_up': True,
                    'out_octets': '2564788784954',
                    'poller_hash': 'MThlODI5ZjViMDcyZXRoNA==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                15.0,
                'model':
                'WiFi',
                'name':
                '10340-carlin-walsh-ufiberwifi',
                'serial_number':
                'UBNT29f5b072',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '18:e8:29:f5:b0:72',
                'temperature':
                57.0,
                'uptime':
                '389959'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '877525143799',
                    'links': [{
                        'in_octets': '877525143799',
                        'out_octets': '79506814602',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '79506814602',
                    'poller_hash':
                    'NzQ4M2MyZjAxZTkwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7496547',
                            'fiber_length': 644,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.054,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.108
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyZjAxZTkwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:a9:8a:5f:bc:94'],
                    'id': '1',
                    'in_octets': '79506814602',
                    'mac_address': '74:83:c2:f1:1e:90',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '877525143799',
                    'poller_hash': 'NzQ4M2MyZjAxZTkwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '756289-evan-bartlett-nanog',
                'serial_number':
                'UBNTc2f01e90',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '74:83:c2:f0:1e:90',
                'temperature':
                50.0,
                'uptime':
                '8889556'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '343333914855',
                    'links': [{
                        'in_octets': '343333914855',
                        'out_octets': '33624625113',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '33624625113',
                    'poller_hash':
                    'NzQ4M2MyZjBiMWE0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2409532',
                            'fiber_length': 892,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.248,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.73
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyZjBiMWE0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['18:fd:74:1c:bf:7a'],
                    'id': '1',
                    'in_octets': '33624625113',
                    'mac_address': '74:83:c2:f1:b1:a4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '343333914855',
                    'poller_hash': 'NzQ4M2MyZjBiMWE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '756084-anna-toll',
                'serial_number':
                'UBNTc2f0b1a4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '74:83:c2:f0:b1:a4',
                'temperature':
                46.0,
                'uptime':
                '2409570'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '26759028333',
                    'links': [{
                        'in_octets': '26759028333',
                        'out_octets': '6190169311',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6190169311',
                    'poller_hash':
                    'YjRmYmU0ZWI0ZDU4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7496546',
                            'fiber_length': 276,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.222,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.822
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZWI0ZDU4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:8f:5a:49:bf:9b'],
                    'id': '1',
                    'in_octets': '6190169311',
                    'mac_address': 'b4:fb:e4:ec:4d:58',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '26759028333',
                    'poller_hash': 'YjRmYmU0ZWI0ZDU4ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '10523-jay-leaver-nanog',
                'serial_number':
                'UBNTe4eb4d58',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                'b4:fb:e4:eb:4d:58',
                'temperature':
                53.0,
                'uptime':
                '8889544'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '244967364534',
                    'links': [{
                        'in_octets': '244967364534',
                        'out_octets': '16408151466',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '16408151466',
                    'poller_hash':
                    'YjRmYmU0ZWI0ZDYycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7496546',
                            'fiber_length': 299,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.574,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.014
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZWI0ZDYycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['34:98:b5:c4:4e:11'],
                    'id': '1',
                    'in_octets': '16408151466',
                    'mac_address': 'b4:fb:e4:ec:4d:62',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '244967364534',
                    'poller_hash': 'YjRmYmU0ZWI0ZDYyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '24017-grace-garret-nanog',
                'serial_number':
                'UBNTe4eb4d62',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                'b4:fb:e4:eb:4d:62',
                'temperature':
                40.0,
                'uptime':
                '8889525'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '882718479596',
                    'links': [{
                        'in_octets': '882718479596',
                        'out_octets': '30361231639',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '30361231639',
                    'poller_hash':
                    'YjRmYmU0ZWI1MDczcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7496537',
                            'fiber_length': 333,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.172,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.078
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZWI1MDczcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:8f:5a:82:a9:f7'],
                    'id': '1',
                    'in_octets': '30361231639',
                    'mac_address': 'b4:fb:e4:ec:50:73',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '882718479596',
                    'poller_hash': 'YjRmYmU0ZWI1MDczZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '20157-ellen-kelly-nanog',
                'serial_number':
                'UBNTe4eb5073',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                'b4:fb:e4:eb:50:73',
                'temperature':
                48.0,
                'uptime':
                '8889522'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '548885766037',
                    'links': [{
                        'in_octets': '548885766037',
                        'out_octets': '36518536949',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '36518536949',
                    'poller_hash':
                    'MThlODI5MGJkNThjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '6636377',
                            'fiber_length': 1098,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.872,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.934
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGJkNThjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['78:9a:18:42:bd:d4'],
                    'id': '1',
                    'in_octets': '36518536949',
                    'mac_address': '18:e8:29:0c:d5:8c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '548885766037',
                    'poller_hash': 'MThlODI5MGJkNThjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '23673-luke-urbine-nanog',
                'serial_number':
                'UBNT290bd58c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '18:e8:29:0b:d5:8c',
                'temperature':
                45.0,
                'uptime':
                '6636417'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '194847602663',
                    'links': [{
                        'in_octets': '194847602663',
                        'out_octets': '11447796092',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11447796092',
                    'poller_hash':
                    'MThlODI5MGJkNWU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '6280693',
                            'fiber_length': 980,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.47,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.772
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGJkNWU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['c8:7f:54:27:30:80'],
                    'id': '1',
                    'in_octets': '11447796092',
                    'mac_address': '18:e8:29:0c:d5:e4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '194847602663',
                    'poller_hash': 'MThlODI5MGJkNWU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '756708-dallas-campbell',
                'serial_number':
                'UBNT290bd5e4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '18:e8:29:0b:d5:e4',
                'temperature':
                50.0,
                'uptime':
                '6280735'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '554524252919',
                    'links': [{
                        'in_octets': '554524252919',
                        'out_octets': '44346977227',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '44346977227',
                    'poller_hash':
                    'MThlODI5MGJmNzEwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '6654297',
                            'fiber_length': 920,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.01,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.744
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGJmNzEwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:a9:8a:3a:a4:36'],
                    'id': '1',
                    'in_octets': '44346977227',
                    'mac_address': '18:e8:29:0c:f7:10',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '554524252919',
                    'poller_hash': 'MThlODI5MGJmNzEwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '756279-alison-peticolas',
                'serial_number':
                'UBNT290bf710',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '18:e8:29:0b:f7:10',
                'temperature':
                40.0,
                'uptime':
                '6654336'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '276946513313',
                    'links': [{
                        'in_octets': '276946513313',
                        'out_octets': '28361070702',
                        'poller_hash': 'YjRmYmU0MWIyODc1cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '28361070702',
                    'poller_hash':
                    'MThlODI5MGJmOWVjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2856206',
                            'fiber_length': 852,
                            'poller_hash': 'YjRmYmU0MWIyODc1VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.06
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGJmOWVjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['78:9a:18:90:0c:6f'],
                    'id': '1',
                    'in_octets': '28361070702',
                    'mac_address': '18:e8:29:0c:f9:ec',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '276946513313',
                    'poller_hash': 'MThlODI5MGJmOWVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '756755-michael-blashka',
                'serial_number':
                'UBNT290bf9ec',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.4.9',
                'system_mac_address':
                '18:e8:29:0b:f9:ec',
                'temperature':
                48.0,
                'uptime':
                '2856244'
            }]
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT4_v4_5_3_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT4.v4.5.3.01")
        exp_info = {
            'model': 'UFiber OLT4',
            'rf_tx_power': None,
            'sta_count': 49,
            'sw_version': '4.5.3',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': 1}
        exp_sta_stats = {
            '18:e8:29:0b:6e:30': {
                'dev_macs': ['0c:72:74:dd:50:47'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6e:30',
                'name': '25 Dunn Street'
            },
            '18:e8:29:0b:6e:54': {
                'dev_macs': ['50:e6:36:34:91:99'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6e:54',
                'name': '14 Bosworth Street'
            },
            '18:e8:29:0b:6e:58': {
                'dev_macs': ['3c:37:12:f4:4a:99'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6e:58',
                'name': '1248 Egmont Road'
            },
            '18:e8:29:0b:6e:dc': {
                'dev_macs': ['3c:a6:2f:2b:93:2f'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6e:dc',
                'name': '1257 Egmont Road'
            },
            '18:e8:29:0b:6e:e0': {
                'dev_macs': ['50:e6:36:35:98:58'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6e:e0',
                'name': '1274 Egmont Road'
            },
            '18:e8:29:0b:6e:ec': {
                'dev_macs': ['50:e6:36:35:9c:aa'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6e:ec',
                'name': '19 Bosworth Street'
            },
            '18:e8:29:0b:6e:f0': {
                'dev_macs': ['0c:72:74:dd:58:82'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6e:f0',
                'name': '27 Dunn Street'
            },
            '18:e8:29:0b:6f:1c': {
                'dev_macs': [],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6f:1c',
                'name': '1253 Egmont Road'
            },
            '18:e8:29:0b:6f:3c': {
                'dev_macs': ['3c:37:12:f4:21:d4'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6f:3c',
                'name': '26 Dunn Street'
            },
            '18:e8:29:0b:6f:40': {
                'dev_macs': ['0c:72:74:dd:67:0e'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6f:40',
                'name': '17  Bosworth Street'
            },
            '18:e8:29:0b:6f:4c': {
                'dev_macs': ['0c:72:74:dd:5b:ae'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6f:4c',
                'name': '1265 Egmont Road'
            },
            '18:e8:29:0b:6f:58': {
                'dev_macs': ['50:e6:36:34:7d:e2'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:6f:58',
                'name': '1025 Junction Road'
            },
            '18:e8:29:0b:71:4c': {
                'dev_macs': ['50:e6:36:34:b4:84'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:71:4c',
                'name': '1268C Egmont Road'
            },
            '18:e8:29:0b:71:60': {
                'dev_macs': ['50:e6:36:35:aa:41'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:71:60',
                'name': '1279 Egmont Road'
            },
            '18:e8:29:0b:71:b4': {
                'dev_macs': ['0c:72:74:dd:65:fd'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:71:b4',
                'name': '12 Cunningham Street'
            },
            '18:e8:29:0b:71:f8': {
                'dev_macs': ['2c:c8:1b:f5:d7:9f'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:71:f8',
                'name': '1249 Egmont Road'
            },
            '18:e8:29:0b:72:04': {
                'dev_macs': ['0c:72:74:dd:55:8e'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:72:04',
                'name': '15 Bosworth Street'
            },
            '18:e8:29:0b:72:20': {
                'dev_macs': ['1c:ed:6f:77:f2:1a'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:72:20',
                'name': '1 Bosworth Street'
            },
            '18:e8:29:0b:72:64': {
                'dev_macs': ['3c:37:12:ca:e4:df'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:72:64',
                'name': '10 Dunn Street'
            },
            '18:e8:29:0b:73:28': {
                'dev_macs': ['3c:37:12:f6:60:67'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:73:28',
                'name': '1268B Egmont Road'
            },
            '18:e8:29:0b:73:e0': {
                'dev_macs': ['0c:72:74:dd:61:9d'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:73:e0',
                'name': '21 Bosworth Street'
            },
            '18:e8:29:0b:74:08': {
                'dev_macs': ['3c:37:12:f6:59:d7'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:74:08',
                'name': '9 Dunn Street'
            },
            '18:e8:29:0b:74:0c': {
                'dev_macs': ['0c:72:74:dd:62:37'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:74:0c',
                'name': '16 Bosworth Street'
            },
            '18:e8:29:0b:74:1c': {
                'dev_macs': ['0c:72:74:dd:70:84'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:74:1c',
                'name': '1268 Egmont Road'
            },
            '18:e8:29:0b:74:20': {
                'dev_macs': ['0c:72:74:dd:62:84'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:74:20',
                'name': '11 Dunn Street'
            },
            '18:e8:29:0b:74:38': {
                'dev_macs': ['3c:a6:2f:1a:61:cc'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:74:38',
                'name': '1281 Egmont Road'
            },
            '18:e8:29:0b:74:50': {
                'dev_macs': ['0c:72:74:dd:5d:0c'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:74:50',
                'name': '1276 Egmont Road'
            },
            '18:e8:29:0b:74:5c': {
                'dev_macs': ['50:e6:36:35:7f:d8'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:74:5c',
                'name': '12 Dunn Street'
            },
            '18:e8:29:0b:74:60': {
                'dev_macs': ['0c:72:74:dd:61:96'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:74:60',
                'name': '20 Dunn Street'
            },
            '18:e8:29:0b:74:68': {
                'dev_macs': ['2c:c8:1b:f5:0a:84'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:74:68',
                'name': '28 Dunn Street'
            },
            '18:e8:29:0b:74:6c': {
                'dev_macs': ['50:e6:36:35:7e:34'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:74:6c',
                'name': '1256 Egmont Road'
            },
            '18:e8:29:0b:77:0c': {
                'dev_macs': ['0c:72:74:dd:63:bf'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:77:0c',
                'name': '1263 Egmont Road'
            },
            '18:e8:29:0b:77:14': {
                'dev_macs': ['50:e6:36:35:8d:84'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:77:14',
                'name': '1268A Egmont Road'
            },
            '18:e8:29:0b:77:18': {
                'dev_macs': ['50:e6:36:35:89:f6'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:77:18',
                'name': '1274 Egmont Road (Cottage)'
            },
            '18:e8:29:0b:77:20': {
                'dev_macs': ['50:e6:36:35:9e:c5'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:77:20',
                'name': '22 Dunn Street'
            },
            '18:e8:29:0b:77:34': {
                'dev_macs': ['0c:72:74:dd:68:0a'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:77:34',
                'name': '13 Bosworth Street'
            },
            '18:e8:29:0b:77:38': {
                'dev_macs': ['3c:37:12:ca:73:18'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:77:38',
                'name': '8 Bosworth Street'
            },
            '18:e8:29:0b:77:40': {
                'dev_macs': ['3c:37:12:cb:11:5c'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:77:40',
                'name': '1273 Egmont Road'
            },
            '18:e8:29:0b:77:ac': {
                'dev_macs': ['50:e6:36:34:84:5d'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:77:ac',
                'name': '7 Bosworth Street'
            },
            '18:e8:29:0b:78:68': {
                'dev_macs': ['0c:72:74:dd:66:27'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:78:68',
                'name': '18 Dunn Street'
            },
            '18:e8:29:0b:d1:e8': {
                'dev_macs': ['3c:37:12:ca:fc:78'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:d1:e8',
                'name': '1262 Egmont Road'
            },
            'd0:21:f9:9a:0c:10': {
                'dev_macs': ['0c:72:74:dd:67:15'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:0c:10',
                'name': '1250 Egmont Road'
            },
            'd0:21:f9:9a:0e:5c': {
                'dev_macs': ['50:e6:36:35:80:bf'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:0e:5c',
                'name': '21 Dunn Street'
            },
            'd0:21:f9:9a:0e:60': {
                'dev_macs': ['0c:72:74:dd:5d:67'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:0e:60',
                'name': '1277 Egmont Road'
            },
            'd0:21:f9:9a:0e:70': {
                'dev_macs': ['0c:72:74:dd:58:90'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:0e:70',
                'name': '1252 Egmont Road'
            },
            'd0:21:f9:9a:0e:ac': {
                'dev_macs': ['0c:72:74:dd:66:2e'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:0e:ac',
                'name': '1275 Egmont Road'
            },
            'd0:21:f9:9a:0e:d0': {
                'dev_macs': ['2c:91:ab:fb:a9:5a'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:0e:d0',
                'name': '1255 Egmont Road'
            },
            'd0:21:f9:9a:0e:e0': {
                'dev_macs': ['0c:72:74:dd:70:b5'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:0e:e0',
                'name': '3 Bosworth Street'
            },
            'd0:21:f9:9a:10:c8': {
                'dev_macs': ['0c:72:74:dd:5d:bb'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:10:c8',
                'name': '1278 Egmont Road'
            }
        }
        exp_ne_msg = {
            'data': {
                'cpu':
                1.0,
                'interfaces': [{
                    'admin_up': True,
                    'id': 'sfp1',
                    'in_octets': '16960719591038',
                    'in_ucast_pkts': '12858272056',
                    'manufacturer': 'FLEXOPTIX',
                    'model': 'P.1396.10',
                    'name': 'SFP+ 1',
                    'oper_up': True,
                    'out_octets': '1513124154100',
                    'out_ucast_pkts': '4362801919',
                    'poller_hash': 'ZDAyMWY5ZTllMWY5c2ZwMWludGY=',
                    'speed': '10000000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon1',
                    'in_errors':
                    '0',
                    'in_octets':
                    '129478846899',
                    'in_ucast_pkts':
                    '450190308',
                    'links': [{
                        'in_octets': '74583721904',
                        'out_octets': '418688613613',
                        'poller_hash': 'MThlODI5MGI2ZTU4cGVlcmludGY='
                    }, {
                        'in_octets': '4016217',
                        'out_octets': '10800214',
                        'poller_hash': 'MThlODI5MGI2ZWUwcGVlcmludGY='
                    }, {
                        'in_octets': '116835822',
                        'out_octets': '100270144',
                        'poller_hash': 'MThlODI5MGI3NDUwcGVlcmludGY='
                    }, {
                        'in_octets': '68907819',
                        'out_octets': '80636424',
                        'poller_hash': 'MThlODI5MGI3NzE4cGVlcmludGY='
                    }, {
                        'in_octets': '27071071341',
                        'out_octets': '512576693259',
                        'poller_hash': 'ZDAyMWY5OWEwYzEwcGVlcmludGY='
                    }, {
                        'in_octets': '8396456619',
                        'out_octets': '284153528518',
                        'poller_hash': 'ZDAyMWY5OWEwZTcwcGVlcmludGY='
                    }, {
                        'in_octets': '10274914264',
                        'out_octets': '340409330277',
                        'poller_hash': 'ZDAyMWY5OWExMGM4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'cabinet1',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '1702457729153',
                    'out_ucast_pkts':
                    '1274865512',
                    'poller_hash':
                    'ZDAyMWY5ZTllMWY5cG9uMWludGY=',
                    'pons': [{
                        'id':
                        '1',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 443,
                            'poller_hash': 'MThlODI5MGI2ZTU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '59570',
                            'fiber_length': 255,
                            'poller_hash': 'MThlODI5MGI2ZWUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 247,
                            'poller_hash': 'MThlODI5MGI3NDUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '59570',
                            'fiber_length': 284,
                            'poller_hash': 'MThlODI5MGI3NzE4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 466,
                            'poller_hash': 'ZDAyMWY5OWEwYzEwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1171060',
                            'fiber_length': 380,
                            'poller_hash': 'ZDAyMWY5OWEwZTcwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 276,
                            'poller_hash': 'ZDAyMWY5OWExMGM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'cabinet1',
                        'poller_hash':
                        'ZDAyMWY5ZTllMWY5VUYtR1AtQisx',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon2',
                    'in_errors':
                    '0',
                    'in_octets':
                    '265315932604',
                    'in_ucast_pkts':
                    '1144292190',
                    'links': [{
                        'in_octets': '12440659108',
                        'out_octets': '194268092712',
                        'poller_hash': 'MThlODI5MGI2ZWRjcGVlcmludGY='
                    }, {
                        'in_octets': '25388000588',
                        'out_octets': '832440727883',
                        'poller_hash': 'MThlODI5MGI2ZjFjcGVlcmludGY='
                    }, {
                        'in_octets': '4829053755',
                        'out_octets': '110149954492',
                        'poller_hash': 'MThlODI5MGI2ZjRjcGVlcmludGY='
                    }, {
                        'in_octets': '6570211734',
                        'out_octets': '33450577427',
                        'poller_hash': 'MThlODI5MGI2ZjU4cGVlcmludGY='
                    }, {
                        'in_octets': '32742281465',
                        'out_octets': '373349939029',
                        'poller_hash': 'MThlODI5MGI3MTRjcGVlcmludGY='
                    }, {
                        'in_octets': '17693466684',
                        'out_octets': '557393757347',
                        'poller_hash': 'MThlODI5MGI3MTYwcGVlcmludGY='
                    }, {
                        'in_octets': '6885297752',
                        'out_octets': '68913567279',
                        'poller_hash': 'MThlODI5MGI3MzI4cGVlcmludGY='
                    }, {
                        'in_octets': '26431068396',
                        'out_octets': '367353237369',
                        'poller_hash': 'MThlODI5MGI3NDFjcGVlcmludGY='
                    }, {
                        'in_octets': '7960067965',
                        'out_octets': '47064080328',
                        'poller_hash': 'MThlODI5MGI3NDM4cGVlcmludGY='
                    }, {
                        'in_octets': '5545687248',
                        'out_octets': '59928926133',
                        'poller_hash': 'MThlODI5MGI3NDZjcGVlcmludGY='
                    }, {
                        'in_octets': '13558071838',
                        'out_octets': '311548255475',
                        'poller_hash': 'MThlODI5MGI3NzBjcGVlcmludGY='
                    }, {
                        'in_octets': '9437395937',
                        'out_octets': '275634014192',
                        'poller_hash': 'MThlODI5MGI3NzE0cGVlcmludGY='
                    }, {
                        'in_octets': '13688944590',
                        'out_octets': '293642465917',
                        'poller_hash': 'MThlODI5MGI3NzQwcGVlcmludGY='
                    }, {
                        'in_octets': '7387553916',
                        'out_octets': '123805448337',
                        'poller_hash': 'MThlODI5MGJkMWU4cGVlcmludGY='
                    }, {
                        'in_octets': '24569379205',
                        'out_octets': '280888013658',
                        'poller_hash': 'ZDAyMWY5OWEwZTYwcGVlcmludGY='
                    }, {
                        'in_octets': '15606159485',
                        'out_octets': '317400217761',
                        'poller_hash': 'ZDAyMWY5OWEwZWFjcGVlcmludGY='
                    }, {
                        'in_octets': '12957677340',
                        'out_octets': '251080937525',
                        'poller_hash': 'ZDAyMWY5OWEwZWQwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'cabinet1-pon2',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '4855388578822',
                    'out_ucast_pkts':
                    '3609630724',
                    'poller_hash':
                    'ZDAyMWY5ZTllMWY5cG9uMmludGY=',
                    'pons': [{
                        'id':
                        '2',
                        'links': [{
                            'connected_time': '1871702',
                            'fiber_length': 367,
                            'poller_hash': 'MThlODI5MGI2ZWRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 408,
                            'poller_hash': 'MThlODI5MGI2ZjFjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 278,
                            'poller_hash': 'MThlODI5MGI2ZjRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 365,
                            'poller_hash': 'MThlODI5MGI2ZjU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 256,
                            'poller_hash': 'MThlODI5MGI3MTRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 331,
                            'poller_hash': 'MThlODI5MGI3MTYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 264,
                            'poller_hash': 'MThlODI5MGI3MzI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 235,
                            'poller_hash': 'MThlODI5MGI3NDFjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1532186',
                            'fiber_length': 337,
                            'poller_hash': 'MThlODI5MGI3NDM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '464037',
                            'fiber_length': 339,
                            'poller_hash': 'MThlODI5MGI3NDZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 301,
                            'poller_hash': 'MThlODI5MGI3NzBjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 359,
                            'poller_hash': 'MThlODI5MGI3NzE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1534906',
                            'fiber_length': 253,
                            'poller_hash': 'MThlODI5MGI3NzQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 301,
                            'poller_hash': 'MThlODI5MGJkMWU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 286,
                            'poller_hash': 'ZDAyMWY5OWEwZTYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871731',
                            'fiber_length': 258,
                            'poller_hash': 'ZDAyMWY5OWEwZWFjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 371,
                            'poller_hash': 'ZDAyMWY5OWEwZWQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'cabinet1-pon2',
                        'poller_hash':
                        'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon3',
                    'in_errors':
                    '0',
                    'in_octets':
                    '934931385014',
                    'in_ucast_pkts':
                    '1978933961',
                    'links': [{
                        'in_octets': '22164789961',
                        'out_octets': '436547822501',
                        'poller_hash': 'MThlODI5MGI2ZTU0cGVlcmludGY='
                    }, {
                        'in_octets': '666303966',
                        'out_octets': '9595966476',
                        'poller_hash': 'MThlODI5MGI2ZWVjcGVlcmludGY='
                    }, {
                        'in_octets': '3748585021',
                        'out_octets': '36662140991',
                        'poller_hash': 'MThlODI5MGI2ZjNjcGVlcmludGY='
                    }, {
                        'in_octets': '93102050109',
                        'out_octets': '128724784197',
                        'poller_hash': 'MThlODI5MGI2ZjQwcGVlcmludGY='
                    }, {
                        'in_octets': '34062300109',
                        'out_octets': '650771291425',
                        'poller_hash': 'MThlODI5MGI3MjA0cGVlcmludGY='
                    }, {
                        'in_octets': '65369326335',
                        'out_octets': '659429137445',
                        'poller_hash': 'MThlODI5MGI3MjY0cGVlcmludGY='
                    }, {
                        'in_octets': '118029244360',
                        'out_octets': '420503670736',
                        'poller_hash': 'MThlODI5MGI3M2UwcGVlcmludGY='
                    }, {
                        'in_octets': '13415453172',
                        'out_octets': '235206162681',
                        'poller_hash': 'MThlODI5MGI3NDBjcGVlcmludGY='
                    }, {
                        'in_octets': '13788224666',
                        'out_octets': '85740930950',
                        'poller_hash': 'MThlODI5MGI3NDVjcGVlcmludGY='
                    }, {
                        'in_octets': '37329102485',
                        'out_octets': '413784135729',
                        'poller_hash': 'MThlODI5MGI3NDYwcGVlcmludGY='
                    }, {
                        'in_octets': '1789635018',
                        'out_octets': '23535157288',
                        'poller_hash': 'MThlODI5MGI3NDY4cGVlcmludGY='
                    }, {
                        'in_octets': '415927094328',
                        'out_octets': '711552945970',
                        'poller_hash': 'MThlODI5MGI3NzIwcGVlcmludGY='
                    }, {
                        'in_octets': '35891842815',
                        'out_octets': '986608997625',
                        'poller_hash': 'MThlODI5MGI3NzM0cGVlcmludGY='
                    }, {
                        'in_octets': '21172068877',
                        'out_octets': '644032974131',
                        'poller_hash': 'MThlODI5MGI3NzM4cGVlcmludGY='
                    }, {
                        'in_octets': '5085114287',
                        'out_octets': '86365559943',
                        'poller_hash': 'MThlODI5MGI3N2FjcGVlcmludGY='
                    }, {
                        'in_octets': '13651055130',
                        'out_octets': '413573793772',
                        'poller_hash': 'MThlODI5MGI3ODY4cGVlcmludGY='
                    }, {
                        'in_octets': '39450087447',
                        'out_octets': '659368939625',
                        'poller_hash': 'ZDAyMWY5OWEwZWUwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'cabinet2',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '6611493968617',
                    'out_ucast_pkts':
                    '5136078039',
                    'poller_hash':
                    'ZDAyMWY5ZTllMWY5cG9uM2ludGY=',
                    'pons': [{
                        'id':
                        '3',
                        'links': [{
                            'connected_time': '1871731',
                            'fiber_length': 591,
                            'poller_hash': 'MThlODI5MGI2ZTU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 673,
                            'poller_hash': 'MThlODI5MGI2ZWVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 538,
                            'poller_hash': 'MThlODI5MGI2ZjNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 667,
                            'poller_hash': 'MThlODI5MGI2ZjQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 621,
                            'poller_hash': 'MThlODI5MGI3MjA0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 555,
                            'poller_hash': 'MThlODI5MGI3MjY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 683,
                            'poller_hash': 'MThlODI5MGI3M2UwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 612,
                            'poller_hash': 'MThlODI5MGI3NDBjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1015557',
                            'fiber_length': 534,
                            'poller_hash': 'MThlODI5MGI3NDVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 481,
                            'poller_hash': 'MThlODI5MGI3NDYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '132951',
                            'fiber_length': 561,
                            'poller_hash': 'MThlODI5MGI3NDY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 491,
                            'poller_hash': 'MThlODI5MGI3NzIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1789731',
                            'fiber_length': 617,
                            'poller_hash': 'MThlODI5MGI3NzM0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 515,
                            'poller_hash': 'MThlODI5MGI3NzM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 531,
                            'poller_hash': 'MThlODI5MGI3N2FjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871731',
                            'fiber_length': 463,
                            'poller_hash': 'MThlODI5MGI3ODY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871731',
                            'fiber_length': 487,
                            'poller_hash': 'ZDAyMWY5OWEwZWUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'cabinet2',
                        'poller_hash':
                        'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon4',
                    'in_errors':
                    '0',
                    'in_octets':
                    '183302486927',
                    'in_ucast_pkts':
                    '788432797',
                    'links': [{
                        'in_octets': '10641523399',
                        'out_octets': '170360716016',
                        'poller_hash': 'MThlODI5MGI2ZTMwcGVlcmludGY='
                    }, {
                        'in_octets': '20787308677',
                        'out_octets': '302617000851',
                        'poller_hash': 'MThlODI5MGI2ZWYwcGVlcmludGY='
                    }, {
                        'in_octets': '45016277732',
                        'out_octets': '1342881300165',
                        'poller_hash': 'MThlODI5MGI3MWI0cGVlcmludGY='
                    }, {
                        'in_octets': '163668668',
                        'out_octets': '671323926',
                        'poller_hash': 'MThlODI5MGI3MWY4cGVlcmludGY='
                    }, {
                        'in_octets': '10922452689',
                        'out_octets': '482803639055',
                        'poller_hash': 'MThlODI5MGI3MjIwcGVlcmludGY='
                    }, {
                        'in_octets': '12758453714',
                        'out_octets': '342876332378',
                        'poller_hash': 'MThlODI5MGI3NDA4cGVlcmludGY='
                    }, {
                        'in_octets': '29514767492',
                        'out_octets': '467170980003',
                        'poller_hash': 'MThlODI5MGI3NDIwcGVlcmludGY='
                    }, {
                        'in_octets': '23057948255',
                        'out_octets': '534469997214',
                        'poller_hash': 'ZDAyMWY5OWEwZTVjcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'cabinet2-pon4',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '3791399340008',
                    'out_ucast_pkts':
                    '2837821654',
                    'poller_hash':
                    'ZDAyMWY5ZTllMWY5cG9uNGludGY=',
                    'pons': [{
                        'id':
                        '4',
                        'links': [{
                            'connected_time': '1871731',
                            'fiber_length': 524,
                            'poller_hash': 'MThlODI5MGI2ZTMwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871722',
                            'fiber_length': 554,
                            'poller_hash': 'MThlODI5MGI2ZWYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871632',
                            'fiber_length': 408,
                            'poller_hash': 'MThlODI5MGI3MWI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '44870',
                            'fiber_length': 718,
                            'poller_hash': 'MThlODI5MGI3MWY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 468,
                            'poller_hash': 'MThlODI5MGI3MjIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 520,
                            'poller_hash': 'MThlODI5MGI3NDA4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 530,
                            'poller_hash': 'MThlODI5MGI3NDIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1871732',
                            'fiber_length': 483,
                            'poller_hash': 'ZDAyMWY5OWEwZTVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'cabinet2-pon4',
                        'poller_hash':
                        'ZDAyMWY5ZTllMWY5VUYtR1AtQis0',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up': True,
                    'id': 'eth0',
                    'in_discards': '5',
                    'in_errors': '0',
                    'in_nucast_pkts': '0',
                    'in_octets': '5800684937',
                    'in_ucast_pkts': '27126844',
                    'in_unknown_protos': '0',
                    'name': 'MGMT',
                    'oper_up': True,
                    'out_discards': '0',
                    'out_errors': '0',
                    'out_nucast_pkts': '0',
                    'out_octets': '13861501363',
                    'out_ucast_pkts': '37364548',
                    'poller_hash': 'ZDAyMWY5ZTllMWY5ZXRoMGludGY=',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                12.0,
                'model':
                'UFiber OLT4',
                'serial_number':
                'UBNTf9e9e1f9',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                'd0:21:f9:e9:e1:f9',
                'temperature':
                45.0,
                'uptime':
                '1871878'
            },
            'peers': [{
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '418688613613',
                    'links': [{
                        'in_octets': '418688613613',
                        'out_octets': '74583721904',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '74583721904',
                    'poller_hash':
                    'MThlODI5MGI2ZTU4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 443,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.204,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.366
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZTU4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:37:12:f4:4a:99'],
                    'id': '1',
                    'in_octets': '74583721904',
                    'mac_address': '18:e8:29:0c:6e:58',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '418688613613',
                    'poller_hash': 'MThlODI5MGI2ZTU4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1248 Egmont Road',
                'serial_number':
                'UBNT290b6e58',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6e:58',
                'temperature':
                45.0,
                'uptime':
                '6010135'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '10800214',
                    'links': [{
                        'in_octets': '10800214',
                        'out_octets': '4016217',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '4016217',
                    'poller_hash':
                    'MThlODI5MGI2ZWUwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '59570',
                            'fiber_length': 255,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.484,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.832
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZWUwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:35:98:58'],
                    'id': '1',
                    'in_octets': '4016217',
                    'mac_address': '18:e8:29:0c:6e:e0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '10800214',
                    'poller_hash': 'MThlODI5MGI2ZWUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1274 Egmont Road',
                'serial_number':
                'UBNT290b6ee0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6e:e0',
                'temperature':
                42.0,
                'uptime':
                '59607'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '100270144',
                    'links': [{
                        'in_octets': '100270144',
                        'out_octets': '116835822',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '116835822',
                    'poller_hash':
                    'MThlODI5MGI3NDUwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 247,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.788,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.472
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NDUwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:5d:0c'],
                    'id': '1',
                    'in_octets': '116835822',
                    'mac_address': '18:e8:29:0c:74:50',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '100270144',
                    'poller_hash': 'MThlODI5MGI3NDUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1276 Egmont Road',
                'serial_number':
                'UBNT290b7450',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:74:50',
                'temperature':
                42.0,
                'uptime':
                '2752394'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '80636424',
                    'links': [{
                        'in_octets': '80636424',
                        'out_octets': '68907819',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '68907819',
                    'poller_hash':
                    'MThlODI5MGI3NzE4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '59570',
                            'fiber_length': 284,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.052,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.864
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NzE4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:35:89:f6'],
                    'id': '1',
                    'in_octets': '68907819',
                    'mac_address': '18:e8:29:0c:77:18',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '80636424',
                    'poller_hash': 'MThlODI5MGI3NzE4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1274 Egmont Road (Cottage)',
                'serial_number':
                'UBNT290b7718',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:77:18',
                'temperature':
                41.0,
                'uptime':
                '59607'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '512576693259',
                    'links': [{
                        'in_octets': '512576693259',
                        'out_octets': '27071071341',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27071071341',
                    'poller_hash':
                    'ZDAyMWY5OWEwYzEwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 466,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.436,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.82
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZDAyMWY5OWEwYzEwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:67:15'],
                    'id': '1',
                    'in_octets': '27071071341',
                    'mac_address': 'd0:21:f9:9b:0c:10',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '512576693259',
                    'poller_hash': 'ZDAyMWY5OWEwYzEwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1250 Egmont Road',
                'serial_number':
                'UBNTf99a0c10',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                'd0:21:f9:9a:0c:10',
                'temperature':
                42.0,
                'uptime':
                '6010067'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '284153528518',
                    'links': [{
                        'in_octets': '284153528518',
                        'out_octets': '8396456619',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8396456619',
                    'poller_hash':
                    'ZDAyMWY5OWEwZTcwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1171060',
                            'fiber_length': 380,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.866,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.344
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZDAyMWY5OWEwZTcwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:58:90'],
                    'id': '1',
                    'in_octets': '8396456619',
                    'mac_address': 'd0:21:f9:9b:0e:70',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '284153528518',
                    'poller_hash': 'ZDAyMWY5OWEwZTcwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1252 Egmont Road',
                'serial_number':
                'UBNTf99a0e70',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                'd0:21:f9:9a:0e:70',
                'temperature':
                40.0,
                'uptime':
                '1171101'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '340409330277',
                    'links': [{
                        'in_octets': '340409330277',
                        'out_octets': '10274914264',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10274914264',
                    'poller_hash':
                    'ZDAyMWY5OWExMGM4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 276,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.762,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.922
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZDAyMWY5OWExMGM4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:5d:bb'],
                    'id': '1',
                    'in_octets': '10274914264',
                    'mac_address': 'd0:21:f9:9b:10:c8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '340409330277',
                    'poller_hash': 'ZDAyMWY5OWExMGM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1278 Egmont Road',
                'serial_number':
                'UBNTf99a10c8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                'd0:21:f9:9a:10:c8',
                'temperature':
                43.0,
                'uptime':
                '6010023'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '194268092712',
                    'links': [{
                        'in_octets': '194268092712',
                        'out_octets': '12440659108',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12440659108',
                    'poller_hash':
                    'MThlODI5MGI2ZWRjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871702',
                            'fiber_length': 367,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.178,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.684
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZWRjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:a6:2f:2b:93:2f'],
                    'id': '1',
                    'in_octets': '12440659108',
                    'mac_address': '18:e8:29:0c:6e:dc',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '194268092712',
                    'poller_hash': 'MThlODI5MGI2ZWRjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1257 Egmont Road',
                'serial_number':
                'UBNT290b6edc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6e:dc',
                'temperature':
                32.0,
                'uptime':
                '5767080'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '832440727883',
                    'links': [{
                        'in_octets': '832440727883',
                        'out_octets': '25388000588',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '25388000588',
                    'poller_hash':
                    'MThlODI5MGI2ZjFjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 408,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.306,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.596
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZjFjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '25388000588',
                    'mac_address': '18:e8:29:0c:6f:1c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '832440727883',
                    'poller_hash': 'MThlODI5MGI2ZjFjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1253 Egmont Road',
                'serial_number':
                'UBNT290b6f1c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6f:1c',
                'temperature':
                48.0,
                'uptime':
                '3215775'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '110149954492',
                    'links': [{
                        'in_octets': '110149954492',
                        'out_octets': '4829053755',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '4829053755',
                    'poller_hash':
                    'MThlODI5MGI2ZjRjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 278,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.168,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.368
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZjRjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:5b:ae'],
                    'id': '1',
                    'in_octets': '4829053755',
                    'mac_address': '18:e8:29:0c:6f:4c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '110149954492',
                    'poller_hash': 'MThlODI5MGI2ZjRjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1265 Egmont Road',
                'serial_number':
                'UBNT290b6f4c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6f:4c',
                'temperature':
                37.0,
                'uptime':
                '3314122'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '33450577427',
                    'links': [{
                        'in_octets': '33450577427',
                        'out_octets': '6570211734',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6570211734',
                    'poller_hash':
                    'MThlODI5MGI2ZjU4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 365,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.736,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.19
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZjU4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:34:7d:e2'],
                    'id': '1',
                    'in_octets': '6570211734',
                    'mac_address': '18:e8:29:0c:6f:58',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '33450577427',
                    'poller_hash': 'MThlODI5MGI2ZjU4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1025 Junction Road',
                'serial_number':
                'UBNT290b6f58',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6f:58',
                'temperature':
                39.0,
                'uptime':
                '5662185'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '373349939029',
                    'links': [{
                        'in_octets': '373349939029',
                        'out_octets': '32742281465',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '32742281465',
                    'poller_hash':
                    'MThlODI5MGI3MTRjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 256,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.828,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.54
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3MTRjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:34:b4:84'],
                    'id': '1',
                    'in_octets': '32742281465',
                    'mac_address': '18:e8:29:0c:71:4c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '373349939029',
                    'poller_hash': 'MThlODI5MGI3MTRjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1268C Egmont Road',
                'serial_number':
                'UBNT290b714c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:71:4c',
                'temperature':
                40.0,
                'uptime':
                '6010101'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '557393757347',
                    'links': [{
                        'in_octets': '557393757347',
                        'out_octets': '17693466684',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '17693466684',
                    'poller_hash':
                    'MThlODI5MGI3MTYwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 331,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.458,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.266
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3MTYwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:35:aa:41'],
                    'id': '1',
                    'in_octets': '17693466684',
                    'mac_address': '18:e8:29:0c:71:60',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '557393757347',
                    'poller_hash': 'MThlODI5MGI3MTYwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1279 Egmont Road',
                'serial_number':
                'UBNT290b7160',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:71:60',
                'temperature':
                41.0,
                'uptime':
                '5685796'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '68913567279',
                    'links': [{
                        'in_octets': '68913567279',
                        'out_octets': '6885297752',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6885297752',
                    'poller_hash':
                    'MThlODI5MGI3MzI4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 264,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.412,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.38
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3MzI4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:37:12:f6:60:67'],
                    'id': '1',
                    'in_octets': '6885297752',
                    'mac_address': '18:e8:29:0c:73:28',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '68913567279',
                    'poller_hash': 'MThlODI5MGI3MzI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1268B Egmont Road',
                'serial_number':
                'UBNT290b7328',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:73:28',
                'temperature':
                38.0,
                'uptime':
                '3942416'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '367353237369',
                    'links': [{
                        'in_octets': '367353237369',
                        'out_octets': '26431068396',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '26431068396',
                    'poller_hash':
                    'MThlODI5MGI3NDFjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 235,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.588,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.648
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NDFjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:70:84'],
                    'id': '1',
                    'in_octets': '26431068396',
                    'mac_address': '18:e8:29:0c:74:1c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '367353237369',
                    'poller_hash': 'MThlODI5MGI3NDFjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1268 Egmont Road',
                'serial_number':
                'UBNT290b741c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:74:1c',
                'temperature':
                42.0,
                'uptime':
                '6010120'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '47064080328',
                    'links': [{
                        'in_octets': '47064080328',
                        'out_octets': '7960067965',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7960067965',
                    'poller_hash':
                    'MThlODI5MGI3NDM4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1532186',
                            'fiber_length': 337,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.644,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.118
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NDM4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:a6:2f:1a:61:cc'],
                    'id': '1',
                    'in_octets': '7960067965',
                    'mac_address': '18:e8:29:0c:74:38',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '47064080328',
                    'poller_hash': 'MThlODI5MGI3NDM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1281 Egmont Road',
                'serial_number':
                'UBNT290b7438',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:74:38',
                'temperature':
                34.0,
                'uptime':
                '1532230'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '59928926133',
                    'links': [{
                        'in_octets': '59928926133',
                        'out_octets': '5545687248',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5545687248',
                    'poller_hash':
                    'MThlODI5MGI3NDZjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '464037',
                            'fiber_length': 339,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.168,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.684
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NDZjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:35:7e:34'],
                    'id': '1',
                    'in_octets': '5545687248',
                    'mac_address': '18:e8:29:0c:74:6c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '59928926133',
                    'poller_hash': 'MThlODI5MGI3NDZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1256 Egmont Road',
                'serial_number':
                'UBNT290b746c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:74:6c',
                'temperature':
                41.0,
                'uptime':
                '464079'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '311548255475',
                    'links': [{
                        'in_octets': '311548255475',
                        'out_octets': '13558071838',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '13558071838',
                    'poller_hash':
                    'MThlODI5MGI3NzBjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 301,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.088,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.368
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NzBjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:63:bf'],
                    'id': '1',
                    'in_octets': '13558071838',
                    'mac_address': '18:e8:29:0c:77:0c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '311548255475',
                    'poller_hash': 'MThlODI5MGI3NzBjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1263 Egmont Road',
                'serial_number':
                'UBNT290b770c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:77:0c',
                'temperature':
                45.0,
                'uptime':
                '6010129'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '275634014192',
                    'links': [{
                        'in_octets': '275634014192',
                        'out_octets': '9437395937',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '9437395937',
                    'poller_hash':
                    'MThlODI5MGI3NzE0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 359,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.144,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.506
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NzE0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:35:8d:84'],
                    'id': '1',
                    'in_octets': '9437395937',
                    'mac_address': '18:e8:29:0c:77:14',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '275634014192',
                    'poller_hash': 'MThlODI5MGI3NzE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1268A Egmont Road',
                'serial_number':
                'UBNT290b7714',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:77:14',
                'temperature':
                40.0,
                'uptime':
                '3927505'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '293642465917',
                    'links': [{
                        'in_octets': '293642465917',
                        'out_octets': '13688944590',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '13688944590',
                    'poller_hash':
                    'MThlODI5MGI3NzQwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1534906',
                            'fiber_length': 253,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.872,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.266
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NzQwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:37:12:cb:11:5c'],
                    'id': '1',
                    'in_octets': '13688944590',
                    'mac_address': '18:e8:29:0c:77:40',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '293642465917',
                    'poller_hash': 'MThlODI5MGI3NzQwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1273 Egmont Road',
                'serial_number':
                'UBNT290b7740',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:77:40',
                'temperature':
                39.0,
                'uptime':
                '1534943'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '123805448337',
                    'links': [{
                        'in_octets': '123805448337',
                        'out_octets': '7387553916',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7387553916',
                    'poller_hash':
                    'MThlODI5MGJkMWU4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 301,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.892,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.126
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGJkMWU4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:37:12:ca:fc:78'],
                    'id': '1',
                    'in_octets': '7387553916',
                    'mac_address': '18:e8:29:0c:d1:e8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '123805448337',
                    'poller_hash': 'MThlODI5MGJkMWU4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1262 Egmont Road',
                'serial_number':
                'UBNT290bd1e8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:d1:e8',
                'temperature':
                42.0,
                'uptime':
                '6010097'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '280888013658',
                    'links': [{
                        'in_octets': '280888013658',
                        'out_octets': '24569379205',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24569379205',
                    'poller_hash':
                    'ZDAyMWY5OWEwZTYwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 286,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.472,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.602
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZDAyMWY5OWEwZTYwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:5d:67'],
                    'id': '1',
                    'in_octets': '24569379205',
                    'mac_address': 'd0:21:f9:9b:0e:60',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '280888013658',
                    'poller_hash': 'ZDAyMWY5OWEwZTYwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1277 Egmont Road',
                'serial_number':
                'UBNTf99a0e60',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                'd0:21:f9:9a:0e:60',
                'temperature':
                42.0,
                'uptime':
                '3588911'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '317400217761',
                    'links': [{
                        'in_octets': '317400217761',
                        'out_octets': '15606159485',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15606159485',
                    'poller_hash':
                    'ZDAyMWY5OWEwZWFjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871731',
                            'fiber_length': 258,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.644,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.924
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZDAyMWY5OWEwZWFjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:66:2e'],
                    'id': '1',
                    'in_octets': '15606159485',
                    'mac_address': 'd0:21:f9:9b:0e:ac',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '317400217761',
                    'poller_hash': 'ZDAyMWY5OWEwZWFjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '1275 Egmont Road',
                'serial_number':
                'UBNTf99a0eac',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                'd0:21:f9:9a:0e:ac',
                'temperature':
                40.0,
                'uptime':
                '3262195'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '251080937525',
                    'links': [{
                        'in_octets': '251080937525',
                        'out_octets': '12957677340',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12957677340',
                    'poller_hash':
                    'ZDAyMWY5OWEwZWQwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 371,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.496,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.596
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZDAyMWY5OWEwZWQwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['2c:91:ab:fb:a9:5a'],
                    'id': '1',
                    'in_octets': '12957677340',
                    'mac_address': 'd0:21:f9:9b:0e:d0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '251080937525',
                    'poller_hash': 'ZDAyMWY5OWEwZWQwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1255 Egmont Road',
                'serial_number':
                'UBNTf99a0ed0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                'd0:21:f9:9a:0e:d0',
                'temperature':
                43.0,
                'uptime':
                '6010120'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '436547822501',
                    'links': [{
                        'in_octets': '436547822501',
                        'out_octets': '22164789961',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '22164789961',
                    'poller_hash':
                    'MThlODI5MGI2ZTU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871731',
                            'fiber_length': 591,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.268,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.088
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZTU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:34:91:99'],
                    'id': '1',
                    'in_octets': '22164789961',
                    'mac_address': '18:e8:29:0c:6e:54',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '436547822501',
                    'poller_hash': 'MThlODI5MGI2ZTU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '14 Bosworth Street',
                'serial_number':
                'UBNT290b6e54',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6e:54',
                'temperature':
                36.0,
                'uptime':
                '6010001'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '9595966476',
                    'links': [{
                        'in_octets': '9595966476',
                        'out_octets': '666303966',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '666303966',
                    'poller_hash':
                    'MThlODI5MGI2ZWVjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 673,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.222,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.186
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZWVjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:35:9c:aa'],
                    'id': '1',
                    'in_octets': '666303966',
                    'mac_address': '18:e8:29:0c:6e:ec',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '9595966476',
                    'poller_hash': 'MThlODI5MGI2ZWVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '19 Bosworth Street',
                'serial_number':
                'UBNT290b6eec',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6e:ec',
                'temperature':
                41.0,
                'uptime':
                '6010050'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '36662140991',
                    'links': [{
                        'in_octets': '36662140991',
                        'out_octets': '3748585021',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3748585021',
                    'poller_hash':
                    'MThlODI5MGI2ZjNjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 538,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.132,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.98
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZjNjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:37:12:f4:21:d4'],
                    'id': '1',
                    'in_octets': '3748585021',
                    'mac_address': '18:e8:29:0c:6f:3c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '36662140991',
                    'poller_hash': 'MThlODI5MGI2ZjNjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '26 Dunn Street',
                'serial_number':
                'UBNT290b6f3c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6f:3c',
                'temperature':
                43.0,
                'uptime':
                '6010106'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '128724784197',
                    'links': [{
                        'in_octets': '128724784197',
                        'out_octets': '93102050109',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '93102050109',
                    'poller_hash':
                    'MThlODI5MGI2ZjQwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 667,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.124,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.898
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZjQwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:67:0e'],
                    'id': '1',
                    'in_octets': '93102050109',
                    'mac_address': '18:e8:29:0c:6f:40',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '128724784197',
                    'poller_hash': 'MThlODI5MGI2ZjQwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '17  Bosworth Street',
                'serial_number':
                'UBNT290b6f40',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6f:40',
                'temperature':
                42.0,
                'uptime':
                '6010077'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '650771291425',
                    'links': [{
                        'in_octets': '650771291425',
                        'out_octets': '34062300109',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '34062300109',
                    'poller_hash':
                    'MThlODI5MGI3MjA0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 621,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.798,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.08
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3MjA0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:55:8e'],
                    'id': '1',
                    'in_octets': '34062300109',
                    'mac_address': '18:e8:29:0c:72:04',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '650771291425',
                    'poller_hash': 'MThlODI5MGI3MjA0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '15 Bosworth Street',
                'serial_number':
                'UBNT290b7204',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:72:04',
                'temperature':
                38.0,
                'uptime':
                '4467832'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '659429137445',
                    'links': [{
                        'in_octets': '659429137445',
                        'out_octets': '65369326335',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '65369326335',
                    'poller_hash':
                    'MThlODI5MGI3MjY0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 555,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -11.85,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.684
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3MjY0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:37:12:ca:e4:df'],
                    'id': '1',
                    'in_octets': '65369326335',
                    'mac_address': '18:e8:29:0c:72:64',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '659429137445',
                    'poller_hash': 'MThlODI5MGI3MjY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '10 Dunn Street',
                'serial_number':
                'UBNT290b7264',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:72:64',
                'temperature':
                44.0,
                'uptime':
                '6010087'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '420503670736',
                    'links': [{
                        'in_octets': '420503670736',
                        'out_octets': '118029244360',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '118029244360',
                    'poller_hash':
                    'MThlODI5MGI3M2UwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 683,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.026,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.21
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3M2UwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:61:9d'],
                    'id': '1',
                    'in_octets': '118029244360',
                    'mac_address': '18:e8:29:0c:73:e0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '420503670736',
                    'poller_hash': 'MThlODI5MGI3M2UwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '21 Bosworth Street',
                'serial_number':
                'UBNT290b73e0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:73:e0',
                'temperature':
                42.0,
                'uptime':
                '6010089'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '235206162681',
                    'links': [{
                        'in_octets': '235206162681',
                        'out_octets': '13415453172',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '13415453172',
                    'poller_hash':
                    'MThlODI5MGI3NDBjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 612,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.352,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.274
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NDBjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:62:37'],
                    'id': '1',
                    'in_octets': '13415453172',
                    'mac_address': '18:e8:29:0c:74:0c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '235206162681',
                    'poller_hash': 'MThlODI5MGI3NDBjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '16 Bosworth Street',
                'serial_number':
                'UBNT290b740c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:74:0c',
                'temperature':
                40.0,
                'uptime':
                '4154928'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '85740930950',
                    'links': [{
                        'in_octets': '85740930950',
                        'out_octets': '13788224666',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '13788224666',
                    'poller_hash':
                    'MThlODI5MGI3NDVjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1015557',
                            'fiber_length': 534,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.034,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.888
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NDVjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:35:7f:d8'],
                    'id': '1',
                    'in_octets': '13788224666',
                    'mac_address': '18:e8:29:0c:74:5c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '85740930950',
                    'poller_hash': 'MThlODI5MGI3NDVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '12 Dunn Street',
                'serial_number':
                'UBNT290b745c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:74:5c',
                'temperature':
                37.0,
                'uptime':
                '1015603'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '413784135729',
                    'links': [{
                        'in_octets': '413784135729',
                        'out_octets': '37329102485',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '37329102485',
                    'poller_hash':
                    'MThlODI5MGI3NDYwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 481,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.932,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.272
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NDYwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:61:96'],
                    'id': '1',
                    'in_octets': '37329102485',
                    'mac_address': '18:e8:29:0c:74:60',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '413784135729',
                    'poller_hash': 'MThlODI5MGI3NDYwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '20 Dunn Street',
                'serial_number':
                'UBNT290b7460',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:74:60',
                'temperature':
                43.0,
                'uptime':
                '6010154'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '23535157288',
                    'links': [{
                        'in_octets': '23535157288',
                        'out_octets': '1789635018',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1789635018',
                    'poller_hash':
                    'MThlODI5MGI3NDY4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '132951',
                            'fiber_length': 561,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.872,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.898
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NDY4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['2c:c8:1b:f5:0a:84'],
                    'id': '1',
                    'in_octets': '1789635018',
                    'mac_address': '18:e8:29:0c:74:68',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '23535157288',
                    'poller_hash': 'MThlODI5MGI3NDY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '28 Dunn Street',
                'serial_number':
                'UBNT290b7468',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:74:68',
                'temperature':
                36.0,
                'uptime':
                '132991'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '711552945970',
                    'links': [{
                        'in_octets': '711552945970',
                        'out_octets': '415927094328',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '415927094328',
                    'poller_hash':
                    'MThlODI5MGI3NzIwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 491,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.168,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.274
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NzIwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:35:9e:c5'],
                    'id': '1',
                    'in_octets': '415927094328',
                    'mac_address': '18:e8:29:0c:77:20',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '711552945970',
                    'poller_hash': 'MThlODI5MGI3NzIwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '22 Dunn Street',
                'serial_number':
                'UBNT290b7720',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:77:20',
                'temperature':
                42.0,
                'uptime':
                '6010121'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '986608997625',
                    'links': [{
                        'in_octets': '986608997625',
                        'out_octets': '35891842815',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '35891842815',
                    'poller_hash':
                    'MThlODI5MGI3NzM0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1789731',
                            'fiber_length': 617,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.974,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.996
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NzM0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:68:0a'],
                    'id': '1',
                    'in_octets': '35891842815',
                    'mac_address': '18:e8:29:0c:77:34',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '986608997625',
                    'poller_hash': 'MThlODI5MGI3NzM0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '13 Bosworth Street',
                'serial_number':
                'UBNT290b7734',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:77:34',
                'temperature':
                40.0,
                'uptime':
                '1789777'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '644032974131',
                    'links': [{
                        'in_octets': '644032974131',
                        'out_octets': '21172068877',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '21172068877',
                    'poller_hash':
                    'MThlODI5MGI3NzM4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 515,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.08,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.772
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NzM4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:37:12:ca:73:18'],
                    'id': '1',
                    'in_octets': '21172068877',
                    'mac_address': '18:e8:29:0c:77:38',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '644032974131',
                    'poller_hash': 'MThlODI5MGI3NzM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '8 Bosworth Street',
                'serial_number':
                'UBNT290b7738',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:77:38',
                'temperature':
                40.0,
                'uptime':
                '4303274'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '86365559943',
                    'links': [{
                        'in_octets': '86365559943',
                        'out_octets': '5085114287',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5085114287',
                    'poller_hash':
                    'MThlODI5MGI3N2FjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 531,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.494,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.146
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3N2FjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:34:84:5d'],
                    'id': '1',
                    'in_octets': '5085114287',
                    'mac_address': '18:e8:29:0c:77:ac',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '86365559943',
                    'poller_hash': 'MThlODI5MGI3N2FjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '7 Bosworth Street',
                'serial_number':
                'UBNT290b77ac',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:77:ac',
                'temperature':
                36.0,
                'uptime':
                '2453129'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '413573793772',
                    'links': [{
                        'in_octets': '413573793772',
                        'out_octets': '13651055130',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '13651055130',
                    'poller_hash':
                    'MThlODI5MGI3ODY4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871731',
                            'fiber_length': 463,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.644,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.74
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3ODY4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:66:27'],
                    'id': '1',
                    'in_octets': '13651055130',
                    'mac_address': '18:e8:29:0c:78:68',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '413573793772',
                    'poller_hash': 'MThlODI5MGI3ODY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '18 Dunn Street',
                'serial_number':
                'UBNT290b7868',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:78:68',
                'temperature':
                35.0,
                'uptime':
                '4358086'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '659368939625',
                    'links': [{
                        'in_octets': '659368939625',
                        'out_octets': '39450087447',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '39450087447',
                    'poller_hash':
                    'ZDAyMWY5OWEwZWUwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871731',
                            'fiber_length': 487,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -12.38,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.316
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZDAyMWY5OWEwZWUwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:70:b5'],
                    'id': '1',
                    'in_octets': '39450087447',
                    'mac_address': 'd0:21:f9:9b:0e:e0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '659368939625',
                    'poller_hash': 'ZDAyMWY5OWEwZWUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '3 Bosworth Street',
                'serial_number':
                'UBNTf99a0ee0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                'd0:21:f9:9a:0e:e0',
                'temperature':
                35.0,
                'uptime':
                '6010066'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '170360716016',
                    'links': [{
                        'in_octets': '170360716016',
                        'out_octets': '10641523399',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10641523399',
                    'poller_hash':
                    'MThlODI5MGI2ZTMwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871731',
                            'fiber_length': 524,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.098,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.38
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZTMwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:50:47'],
                    'id': '1',
                    'in_octets': '10641523399',
                    'mac_address': '18:e8:29:0c:6e:30',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '170360716016',
                    'poller_hash': 'MThlODI5MGI2ZTMwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '25 Dunn Street',
                'serial_number':
                'UBNT290b6e30',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6e:30',
                'temperature':
                40.0,
                'uptime':
                '6010129'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '302617000851',
                    'links': [{
                        'in_octets': '302617000851',
                        'out_octets': '20787308677',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '20787308677',
                    'poller_hash':
                    'MThlODI5MGI2ZWYwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871722',
                            'fiber_length': 554,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.382,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.948
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI2ZWYwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:58:82'],
                    'id': '1',
                    'in_octets': '20787308677',
                    'mac_address': '18:e8:29:0c:6e:f0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '302617000851',
                    'poller_hash': 'MThlODI5MGI2ZWYwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '27 Dunn Street',
                'serial_number':
                'UBNT290b6ef0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:6e:f0',
                'temperature':
                38.0,
                'uptime':
                '6010097'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1342881300165',
                    'links': [{
                        'in_octets': '1342881300165',
                        'out_octets': '45016277732',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '45016277732',
                    'poller_hash':
                    'MThlODI5MGI3MWI0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871632',
                            'fiber_length': 408,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.376,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.246
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3MWI0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:65:fd'],
                    'id': '1',
                    'in_octets': '45016277732',
                    'mac_address': '18:e8:29:0c:71:b4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1342881300165',
                    'poller_hash': 'MThlODI5MGI3MWI0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                55.0,
                'model':
                'NanoG',
                'name':
                '12 Cunningham Street',
                'serial_number':
                'UBNT290b71b4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:71:b4',
                'temperature':
                41.0,
                'uptime':
                '1871676'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '671323926',
                    'links': [{
                        'in_octets': '671323926',
                        'out_octets': '163668668',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '163668668',
                    'poller_hash':
                    'MThlODI5MGI3MWY4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '44870',
                            'fiber_length': 718,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.71,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.83
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3MWY4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['2c:c8:1b:f5:d7:9f'],
                    'id': '1',
                    'in_octets': '163668668',
                    'mac_address': '18:e8:29:0c:71:f8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '671323926',
                    'poller_hash': 'MThlODI5MGI3MWY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                57.0,
                'model':
                'NanoG',
                'name':
                '1249 Egmont Road',
                'serial_number':
                'UBNT290b71f8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:71:f8',
                'temperature':
                41.0,
                'uptime':
                '44913'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '482803639055',
                    'links': [{
                        'in_octets': '482803639055',
                        'out_octets': '10922452689',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10922452689',
                    'poller_hash':
                    'MThlODI5MGI3MjIwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 468,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.188,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.71
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3MjIwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['1c:ed:6f:77:f2:1a'],
                    'id': '1',
                    'in_octets': '10922452689',
                    'mac_address': '18:e8:29:0c:72:20',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '482803639055',
                    'poller_hash': 'MThlODI5MGI3MjIwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '1 Bosworth Street',
                'serial_number':
                'UBNT290b7220',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:72:20',
                'temperature':
                42.0,
                'uptime':
                '5669214'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '342876332378',
                    'links': [{
                        'in_octets': '342876332378',
                        'out_octets': '12758453714',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12758453714',
                    'poller_hash':
                    'MThlODI5MGI3NDA4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 520,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.178,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.816
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NDA4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:37:12:f6:59:d7'],
                    'id': '1',
                    'in_octets': '12758453714',
                    'mac_address': '18:e8:29:0c:74:08',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '342876332378',
                    'poller_hash': 'MThlODI5MGI3NDA4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '9 Dunn Street',
                'serial_number':
                'UBNT290b7408',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:74:08',
                'temperature':
                44.0,
                'uptime':
                '6010096'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '467170980003',
                    'links': [{
                        'in_octets': '467170980003',
                        'out_octets': '29514767492',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '29514767492',
                    'poller_hash':
                    'MThlODI5MGI3NDIwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 530,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.814,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.8
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'MThlODI5MGI3NDIwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['0c:72:74:dd:62:84'],
                    'id': '1',
                    'in_octets': '29514767492',
                    'mac_address': '18:e8:29:0c:74:20',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '467170980003',
                    'poller_hash': 'MThlODI5MGI3NDIwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '11 Dunn Street',
                'serial_number':
                'UBNT290b7420',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                '18:e8:29:0b:74:20',
                'temperature':
                42.0,
                'uptime':
                '6010152'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '534469997214',
                    'links': [{
                        'in_octets': '534469997214',
                        'out_octets': '23057948255',
                        'poller_hash': 'ZDAyMWY5ZTllMWY5cG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '23057948255',
                    'poller_hash':
                    'ZDAyMWY5OWEwZTVjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1871732',
                            'fiber_length': 483,
                            'poller_hash': 'ZDAyMWY5ZTllMWY5VUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.446,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.462
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZDAyMWY5OWEwZTVjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['50:e6:36:35:80:bf'],
                    'id': '1',
                    'in_octets': '23057948255',
                    'mac_address': 'd0:21:f9:9b:0e:5c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '534469997214',
                    'poller_hash': 'ZDAyMWY5OWEwZTVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                56.0,
                'model':
                'NanoG',
                'name':
                '21 Dunn Street',
                'serial_number':
                'UBNTf99a0e5c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.5.3',
                'system_mac_address':
                'd0:21:f9:9a:0e:5c',
                'temperature':
                35.0,
                'uptime':
                '5653995'
            }]
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_2_1_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.2.1.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 89,
            'sw_version': '4.2.1',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': 50}
        exp_sta_stats = {
            '68:d7:9a:06:53:61': {
                'dev_macs': ['40:ed:00:42:96:7d'],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:53:61',
                'name': 'brandi_pederson'
            },
            '68:d7:9a:06:53:bf': {
                'dev_macs': ['74:ac:b9:8d:ce:d8'],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:53:bf',
                'name': 'ron_gallardo'
            },
            '68:d7:9a:06:fe:93': {
                'dev_macs': ['98:da:c4:8e:86:ab'],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:fe:93',
                'name': 'nick_lundquist'
            },
            '68:d7:9a:06:ff:31': {
                'dev_macs': ['74:ac:b9:75:d1:6c'],
                'ip_address': None,
                'mac_address': '68:d7:9a:06:ff:31',
                'name': 'cathy_thompson'
            },
            '70:a7:41:32:f4:4c': {
                'dev_macs': ['5c:62:8b:ab:6a:bc'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f4:4c',
                'name': 'douglas_owens'
            },
            '70:a7:41:32:f4:8c': {
                'dev_macs': ['84:d8:1b:7a:da:60'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f4:8c',
                'name': 'brenda_chenal'
            },
            '70:a7:41:32:f5:10': {
                'dev_macs': ['48:22:54:57:18:bb'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f5:10',
                'name': 'terra_nomeland'
            },
            '70:a7:41:32:f5:7c': {
                'dev_macs': ['48:22:54:38:a7:ce'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f5:7c',
                'name': 'aaron_thole'
            },
            '70:a7:41:32:f5:d8': {
                'dev_macs': ['48:22:54:45:b9:48'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f5:d8',
                'name': 'atc_agency'
            },
            '70:a7:41:32:f6:54': {
                'dev_macs': ['48:22:54:57:23:6e'],
                'ip_address': None,
                'mac_address': '70:a7:41:32:f6:54',
                'name': 'nicole_richter'
            },
            '70:a7:41:33:2b:fc': {
                'dev_macs': ['48:22:54:38:a2:82'],
                'ip_address': None,
                'mac_address': '70:a7:41:33:2b:fc',
                'name': 'jo_degeer'
            },
            '70:a7:41:33:2c:b8': {
                'dev_macs': ['48:22:54:57:20:e9'],
                'ip_address': None,
                'mac_address': '70:a7:41:33:2c:b8',
                'name': 'corinne_mcnielly'
            },
            '70:a7:41:33:2c:d0': {
                'dev_macs': ['74:ac:b9:83:c0:00'],
                'ip_address': None,
                'mac_address': '70:a7:41:33:2c:d0',
                'name': 'pauline_miller'
            },
            '74:ac:b9:06:a7:ca': {
                'dev_macs': ['68:d7:9a:af:f1:39'],
                'ip_address': None,
                'mac_address': '74:ac:b9:06:a7:ca',
                'name': 'matt_johnson'
            },
            '78:45:58:95:c0:f4': {
                'dev_macs': ['5c:62:8b:ab:68:c4'],
                'ip_address': None,
                'mac_address': '78:45:58:95:c0:f4',
                'name': 'connie_ecklund'
            },
            '78:45:58:95:c3:08': {
                'dev_macs': ['40:ed:00:42:8f:ea'],
                'ip_address': None,
                'mac_address': '78:45:58:95:c3:08',
                'name': 'larry_hedlund'
            },
            '78:45:58:95:c3:6c': {
                'dev_macs': ['48:22:54:57:33:c7'],
                'ip_address': None,
                'mac_address': '78:45:58:95:c3:6c',
                'name': 'dawn_meadows'
            },
            '78:45:58:95:c3:ac': {
                'dev_macs': ['5c:62:8b:ab:6f:45'],
                'ip_address': None,
                'mac_address': '78:45:58:95:c3:ac',
                'name': 'laurie_hopp'
            },
            '78:45:58:95:c3:b0': {
                'dev_macs': ['a0:36:bc:1a:6b:68'],
                'ip_address': None,
                'mac_address': '78:45:58:95:c3:b0',
                'name': 'justin_campbell'
            },
            '78:45:58:95:d3:80': {
                'dev_macs': ['5c:62:8b:ab:73:80'],
                'ip_address': None,
                'mac_address': '78:45:58:95:d3:80',
                'name': 'susan_olson'
            },
            '78:45:58:95:d4:78': {
                'dev_macs': ['5c:62:8b:ab:6b:19'],
                'ip_address': None,
                'mac_address': '78:45:58:95:d4:78',
                'name': 'lucy_swanson'
            },
            '78:45:58:95:d4:90': {
                'dev_macs': ['5c:62:8b:ab:66:39'],
                'ip_address': None,
                'mac_address': '78:45:58:95:d4:90',
                'name': 'marissa_woletz'
            },
            'b4:fb:e4:e6:d7:28': {
                'dev_macs': ['ac:15:a2:b2:16:08'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:d7:28',
                'name': 'james_brewster'
            },
            'b4:fb:e4:e6:d7:33': {
                'dev_macs': ['24:4b:fe:62:40:58'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:d7:33',
                'name': 'sarah_jorgenson'
            },
            'b4:fb:e4:e6:d7:37': {
                'dev_macs': ['68:d7:9a:af:f8:70'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:d7:37',
                'name': 'sundown_saloon'
            },
            'b4:fb:e4:e6:df:f5': {
                'dev_macs': [],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:df:f5',
                'name': 'sarah15_ltd'
            },
            'b4:fb:e4:e6:e2:86': {
                'dev_macs': ['b0:95:75:3d:59:a1'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e2:86',
                'name': 'pam_engen'
            },
            'b4:fb:e4:e6:e7:28': {
                'dev_macs': ['74:ac:b9:83:bc:b0'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e7:28',
                'name': 'sarah15_showroom'
            },
            'b4:fb:e4:e6:e7:2e': {
                'dev_macs': ['54:af:97:4f:f3:48'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e7:2e',
                'name': 'tim_olson'
            },
            'b4:fb:e4:e6:e7:3d': {
                'dev_macs': ['74:ac:b9:fd:b8:54'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e7:3d',
                'name': 'rich_brande'
            },
            'b4:fb:e4:e6:e7:c4': {
                'dev_macs': ['74:ac:b9:fd:b8:e4'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e7:c4',
                'name': 'veda_gade'
            },
            'b4:fb:e4:e6:e8:16': {
                'dev_macs': ['74:ac:b9:75:d0:a6'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e8:16',
                'name': 'lewis_vfw'
            },
            'b4:fb:e4:e6:e8:5f': {
                'dev_macs': ['74:ac:b9:75:d3:99'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e8:5f',
                'name': 'christine_strak'
            },
            'b4:fb:e4:e6:e8:9b': {
                'dev_macs': ['74:ac:b9:fd:b2:16'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e8:9b',
                'name': 'lance_howard'
            },
            'b4:fb:e4:e6:e8:fb': {
                'dev_macs': ['74:ac:b9:75:ce:21'],
                'ip_address': None,
                'mac_address': 'b4:fb:e4:e6:e8:fb',
                'name': 'elaine_thomas'
            },
            'd0:21:f9:1a:cd:38': {
                'dev_macs': ['48:22:54:38:a2:79'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:1a:cd:38',
                'name': 'lisa_olson'
            },
            'f4:92:bf:06:0a:54': {
                'dev_macs': ['74:ac:b9:83:c0:13'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:54',
                'name': 'frank_backlin'
            },
            'f4:92:bf:06:0a:56': {
                'dev_macs': ['54:af:97:4f:7e:74'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:56',
                'name': 'larry_bergeron'
            },
            'f4:92:bf:06:0a:5c': {
                'dev_macs': ['54:af:97:4f:aa:24'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:5c',
                'name': 'adam_lein'
            },
            'f4:92:bf:06:0a:5f': {
                'dev_macs': ['00:31:92:f6:78:6c'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:5f',
                'name': 'joshua_corrigan'
            },
            'f4:92:bf:06:0a:a3': {
                'dev_macs': ['24:5a:4c:d5:05:3d'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:a3',
                'name': 'rick_anderson'
            },
            'f4:92:bf:06:0a:a4': {
                'dev_macs': ['24:5a:4c:d5:04:e5'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:a4',
                'name': 'nancy_chenal'
            },
            'f4:92:bf:06:0a:a5': {
                'dev_macs': ['24:5a:4c:d5:04:70'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:a5',
                'name': 'mike_knauber'
            },
            'f4:92:bf:06:0a:a6': {
                'dev_macs': ['f4:92:bf:4b:d1:c9'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:a6',
                'name': 'barb_burke'
            },
            'f4:92:bf:06:0a:ab': {
                'dev_macs': ['10:da:43:7a:d3:56'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:ab',
                'name': 'shari_chadwick'
            },
            'f4:92:bf:06:0a:c0': {
                'dev_macs': [
                    '18:e8:29:8c:44:67', 'b4:fb:e4:4f:2f:fe', 'b4:fb:e4:4f:31:2c',
                    'b4:fb:e4:6a:7c:2f', 'e0:63:da:4e:c1:4d', 'e0:63:da:4f:c1:4d',
                    'f4:92:bf:d2:89:aa'
                ],
                'ip_address':
                None,
                'mac_address':
                'f4:92:bf:06:0a:c0',
                'name':
                'SNDW01-ONU'
            },
            'f4:92:bf:06:0a:c3': {
                'dev_macs': ['54:af:97:4f:c8:88'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0a:c3',
                'name': 'michelle_bengtson'
            },
            'f4:92:bf:06:0b:a4': {
                'dev_macs': ['54:af:97:4f:8c:d4'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:a4',
                'name': 'ryan_tschumperlin'
            },
            'f4:92:bf:06:0b:ce': {
                'dev_macs': ['54:af:97:4f:8c:3c'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:ce',
                'name': 'neal_chapman'
            },
            'f4:92:bf:06:0b:d2': {
                'dev_macs': ['d8:47:32:da:c7:51'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:d2',
                'name': 'bart_chouinard'
            },
            'f4:92:bf:06:0b:d9': {
                'dev_macs': ['54:af:97:4f:e3:f0'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:d9',
                'name': 'jennifer_campbell'
            },
            'f4:92:bf:06:0b:e3': {
                'dev_macs': ['24:5a:4c:e7:3b:9f'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:e3',
                'name': 'teresa_blok'
            },
            'f4:92:bf:06:0b:e4': {
                'dev_macs': ['24:5a:4c:e3:af:af'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:e4',
                'name': 'wayne_gustafson'
            },
            'f4:92:bf:06:0b:f3': {
                'dev_macs': ['54:af:97:4f:7e:0c'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:f3',
                'name': 'jeffrey_schefelker'
            },
            'f4:92:bf:06:0b:f5': {
                'dev_macs': ['54:af:97:4f:8c:34'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0b:f5',
                'name': 'kathy_griffin'
            },
            'f4:92:bf:06:0c:03': {
                'dev_macs': ['54:af:97:4f:8b:d0'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:03',
                'name': 'lesa_beeler'
            },
            'f4:92:bf:06:0c:32': {
                'dev_macs': ['24:5a:4c:d5:01:ee'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:32',
                'name': 'ed_peterson'
            },
            'f4:92:bf:06:0c:39': {
                'dev_macs': ['54:af:97:4f:ac:18'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:39',
                'name': 'jason_craig'
            },
            'f4:92:bf:06:0c:5b': {
                'dev_macs': ['54:af:97:4f:a6:d4'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:5b',
                'name': 'troy_lee'
            },
            'f4:92:bf:06:0c:8b': {
                'dev_macs': ['24:5a:4c:e3:b0:25'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:8b',
                'name': 'rob_anderson'
            },
            'f4:92:bf:06:0c:8f': {
                'dev_macs': ['24:f5:a2:90:24:c6'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:8f',
                'name': 'jessica_pett'
            },
            'f4:92:bf:06:0c:b8': {
                'dev_macs': ['38:94:ed:aa:2f:a2'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:b8',
                'name': 'ben_rathbun'
            },
            'f4:92:bf:06:0c:c4': {
                'dev_macs': ['18:e8:29:37:a4:fb'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:c4',
                'name': 'darvaia_stinar'
            },
            'f4:92:bf:06:0c:c8': {
                'dev_macs': ['24:5a:4c:e3:b1:90'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0c:c8',
                'name': 'mike_freeberg'
            },
            'f4:92:bf:06:0d:89': {
                'dev_macs': ['24:5a:4c:e7:3c:68'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0d:89',
                'name': 'edward_feidt'
            },
            'f4:92:bf:06:0d:c4': {
                'dev_macs': ['14:91:82:12:6c:5d'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0d:c4',
                'name': 'eric_carlson'
            },
            'f4:92:bf:06:0d:d8': {
                'dev_macs': ['74:83:c2:eb:89:b3'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:0d:d8',
                'name': 'jackie_schommer'
            },
            'f4:92:bf:06:e0:be': {
                'dev_macs': ['54:af:97:4f:c7:dc'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e0:be',
                'name': 'judith_shafer'
            },
            'f4:92:bf:06:e4:04': {
                'dev_macs': ['54:af:97:50:09:3c'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e4:04',
                'name': 'jean_porter'
            },
            'f4:92:bf:06:e4:2f': {
                'dev_macs': ['54:af:97:50:06:b0'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e4:2f',
                'name': 'sarah_radomsky'
            },
            'f4:92:bf:06:e4:56': {
                'dev_macs': ['54:af:97:4f:df:94'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e4:56',
                'name': 'marshall_davis'
            },
            'f4:92:bf:06:e5:2d': {
                'dev_macs': ['54:af:97:4f:c7:e8'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e5:2d',
                'name': 'steven_stoner'
            },
            'f4:92:bf:06:e5:99': {
                'dev_macs': ['10:da:43:a9:55:e3'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e5:99',
                'name': 'bruce_lundquist'
            },
            'f4:92:bf:06:e5:f8': {
                'dev_macs': ['ac:15:a2:b2:0f:24'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e5:f8',
                'name': 'luis_karl'
            },
            'f4:92:bf:06:e6:3a': {
                'dev_macs': ['54:af:97:4f:c8:84'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e6:3a',
                'name': 'louann_skillings'
            },
            'f4:92:bf:06:e7:25': {
                'dev_macs': ['10:0c:6b:e1:63:48'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e7:25',
                'name': 'cory_wondra'
            },
            'f4:92:bf:06:e7:3e': {
                'dev_macs': ['54:af:97:4f:e0:30'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e7:3e',
                'name': 'kim_rognrud'
            },
            'f4:92:bf:06:e7:49': {
                'dev_macs': ['54:af:97:50:0f:54'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e7:49',
                'name': 'denise_nelson'
            },
            'f4:92:bf:06:e7:55': {
                'dev_macs': ['54:af:97:50:01:dc'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e7:55',
                'name': 'jim_renno'
            },
            'f4:92:bf:06:e7:5c': {
                'dev_macs': ['54:af:97:4f:d7:78'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:e7:5c',
                'name': 'mark_schumacher'
            },
            'f4:92:bf:06:f0:dc': {
                'dev_macs': ['48:22:54:38:a3:69'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f0:dc',
                'name': 'lisa_lundeenbrooks'
            },
            'f4:92:bf:06:f2:98': {
                'dev_macs': ['74:ac:b9:fd:b8:50'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f2:98',
                'name': 'adam_hedlund'
            },
            'f4:92:bf:06:f3:19': {
                'dev_macs': ['9c:53:22:89:56:b2'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f3:19',
                'name': 'tina_douglas'
            },
            'f4:92:bf:06:f4:d9': {
                'dev_macs': ['48:22:54:38:a3:39'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f4:d9',
                'name': 'suzanne_starcevich'
            },
            'f4:92:bf:06:f5:0f': {
                'dev_macs': ['54:af:97:4f:f5:c4'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f5:0f',
                'name': 'diane_mork'
            },
            'f4:92:bf:06:f5:1a': {
                'dev_macs': ['9c:53:22:89:4d:70'],
                'ip_address': None,
                'mac_address': 'f4:92:bf:06:f5:1a',
                'name': 'chad_thomas'
            }
        }
        exp_ne_msg = {
            'data': {
                'cpu':
                50.0,
                'interfaces': [{
                    'admin_up': True,
                    'id': 'eth0',
                    'in_discards': '13615765',
                    'in_errors': '2714',
                    'in_nucast_pkts': '0',
                    'in_octets': '187627648941',
                    'in_ucast_pkts': '1103479743',
                    'in_unknown_protos': '0',
                    'name': 'MGMT',
                    'oper_up': True,
                    'out_discards': '0',
                    'out_errors': '1',
                    'out_nucast_pkts': '0',
                    'out_octets': '423959147837',
                    'out_ucast_pkts': '823772131',
                    'poller_hash': 'YjRmYmU0NTAzYjhhZXRoMGludGY='
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon1',
                    'in_errors':
                    '0',
                    'in_octets':
                    '4189052261426',
                    'in_ucast_pkts':
                    '19803009057',
                    'links': [{
                        'in_octets': '222461380262',
                        'out_octets': '3849134107222',
                        'poller_hash': 'NzBhNzQxMzJmNDhjcGVlcmludGY='
                    }, {
                        'in_octets': '111764754227',
                        'out_octets': '3319896763602',
                        'poller_hash': 'ZjQ5MmJmMDYwYTU0cGVlcmludGY='
                    }, {
                        'in_octets': '11928576097',
                        'out_octets': '175714892507',
                        'poller_hash': 'ZjQ5MmJmMDYwYTVjcGVlcmludGY='
                    }, {
                        'in_octets': '8965376115',
                        'out_octets': '243062662871',
                        'poller_hash': 'ZjQ5MmJmMDYwYWMzcGVlcmludGY='
                    }, {
                        'in_octets': '6098156361',
                        'out_octets': '106792795550',
                        'poller_hash': 'ZjQ5MmJmMDYwYmE0cGVlcmludGY='
                    }, {
                        'in_octets': '7093446055',
                        'out_octets': '118738709706',
                        'poller_hash': 'ZjQ5MmJmMDYwYmQ5cGVlcmludGY='
                    }, {
                        'in_octets': '15625512575',
                        'out_octets': '299112485055',
                        'poller_hash': 'ZjQ5MmJmMDYwY2M0cGVlcmludGY='
                    }, {
                        'in_octets': '3088512466',
                        'out_octets': '32803386862',
                        'poller_hash': 'ZjQ5MmJmMDYwZGM0cGVlcmludGY='
                    }, {
                        'in_octets': '27896807920',
                        'out_octets': '208297711695',
                        'poller_hash': 'ZjQ5MmJmMDYwZGQ4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon1',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '63741905074100',
                    'out_ucast_pkts':
                    '56333961347',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uMWludGY=',
                    'pons': [{
                        'id':
                        '1',
                        'links': [{
                            'connected_time': '4733215',
                            'fiber_length': 10823,
                            'poller_hash': 'NzBhNzQxMzJmNDhjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10687697',
                            'fiber_length': 9570,
                            'poller_hash': 'ZjQ5MmJmMDYwYTU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5255521',
                            'fiber_length': 9382,
                            'poller_hash': 'ZjQ5MmJmMDYwYTVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 13287,
                            'poller_hash': 'ZjQ5MmJmMDYwYWMzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 10549,
                            'poller_hash': 'ZjQ5MmJmMDYwYmE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1085902',
                            'fiber_length': 10126,
                            'poller_hash': 'ZjQ5MmJmMDYwYmQ5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2589910',
                            'fiber_length': 10653,
                            'poller_hash': 'ZjQ5MmJmMDYwY2M0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '231971',
                            'fiber_length': 9799,
                            'poller_hash': 'ZjQ5MmJmMDYwZGM0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 12573,
                            'poller_hash': 'ZjQ5MmJmMDYwZGQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon2',
                    'in_errors':
                    '0',
                    'in_octets':
                    '4065137599156',
                    'in_ucast_pkts':
                    '17205107754',
                    'links': [{
                        'in_octets': '21808323770',
                        'out_octets': '1068117378952',
                        'poller_hash': 'NzBhNzQxMzMyY2QwcGVlcmludGY='
                    }, {
                        'in_octets': '3965917114',
                        'out_octets': '46449359742',
                        'poller_hash': 'Nzg0NTU4OTVjM2FjcGVlcmludGY='
                    }, {
                        'in_octets': '11458675648',
                        'out_octets': '362985476692',
                        'poller_hash': 'NjhkNzlhMDZmZjMxcGVlcmludGY='
                    }, {
                        'in_octets': '3228637671',
                        'out_octets': '49350620497',
                        'poller_hash': 'ZjQ5MmJmMDYwYTU2cGVlcmludGY='
                    }, {
                        'in_octets': '15428891751',
                        'out_octets': '24727742883',
                        'poller_hash': 'ZjQ5MmJmMDYwYWE2cGVlcmludGY='
                    }, {
                        'in_octets': '384893936',
                        'out_octets': '296509311',
                        'poller_hash': 'ZjQ5MmJmMDYwYmNlcGVlcmludGY='
                    }, {
                        'in_octets': '37869131747',
                        'out_octets': '847913610460',
                        'poller_hash': 'ZjQ5MmJmMDYwYmY1cGVlcmludGY='
                    }, {
                        'in_octets': '46691526639',
                        'out_octets': '514400993381',
                        'poller_hash': 'ZjQ5MmJmMDYwYzMycGVlcmludGY='
                    }, {
                        'in_octets': '569467655952',
                        'out_octets': '396073241457',
                        'poller_hash': 'ZjQ5MmJmMDYwYzVicGVlcmludGY='
                    }, {
                        'in_octets': '2588687025',
                        'out_octets': '42718453903',
                        'poller_hash': 'ZjQ5MmJmMDYwZDg5cGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon2',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '62144129580810',
                    'out_ucast_pkts':
                    '53406723784',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uMmludGY=',
                    'pons': [{
                        'id':
                        '2',
                        'links': [{
                            'connected_time': '1101972',
                            'fiber_length': 356,
                            'poller_hash': 'NzBhNzQxMzMyY2QwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '767428',
                            'fiber_length': 1238,
                            'poller_hash': 'Nzg0NTU4OTVjM2FjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '415944',
                            'fiber_length': 1535,
                            'poller_hash': 'NjhkNzlhMDZmZjMxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '929970',
                            'fiber_length': 7149,
                            'poller_hash': 'ZjQ5MmJmMDYwYTU2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 1203,
                            'poller_hash': 'ZjQ5MmJmMDYwYWE2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3545451',
                            'fiber_length': 993,
                            'poller_hash': 'ZjQ5MmJmMDYwYmNlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9388152',
                            'fiber_length': 4086,
                            'poller_hash': 'ZjQ5MmJmMDYwYmY1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7081734',
                            'fiber_length': 6556,
                            'poller_hash': 'ZjQ5MmJmMDYwYzMycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10687697',
                            'fiber_length': 6956,
                            'poller_hash': 'ZjQ5MmJmMDYwYzVicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '580746',
                            'fiber_length': 1087,
                            'poller_hash': 'ZjQ5MmJmMDYwZDg5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon2',
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon3',
                    'in_errors':
                    '0',
                    'in_octets':
                    '4984518037469',
                    'in_ucast_pkts':
                    '22284664859',
                    'links': [{
                        'in_octets': '1870565314',
                        'out_octets': '81002587634',
                        'poller_hash': 'NzBhNzQxMzJmNTEwcGVlcmludGY='
                    }, {
                        'in_octets': '9952355709',
                        'out_octets': '488053817808',
                        'poller_hash': 'NzBhNzQxMzMyYmZjcGVlcmludGY='
                    }, {
                        'in_octets': '49917708030',
                        'out_octets': '480299524792',
                        'poller_hash': 'NzBhNzQxMzMyY2I4cGVlcmludGY='
                    }, {
                        'in_octets': '93966740222',
                        'out_octets': '615106324750',
                        'poller_hash': 'Nzg0NTU4OTVjMzZjcGVlcmludGY='
                    }, {
                        'in_octets': '21693880245',
                        'out_octets': '1062438998472',
                        'poller_hash': 'Nzg0NTU4OTVjM2IwcGVlcmludGY='
                    }, {
                        'in_octets': '2868103384',
                        'out_octets': '62357381027',
                        'poller_hash': 'NjhkNzlhMDY1M2JmcGVlcmludGY='
                    }, {
                        'in_octets': '656121422531',
                        'out_octets': '10615202891754',
                        'poller_hash': 'NzRhY2I5MDZhN2NhcGVlcmludGY='
                    }, {
                        'in_octets': '286889795472',
                        'out_octets': '1008130759425',
                        'poller_hash': 'ZjQ5MmJmMDYwYWMwcGVlcmludGY='
                    }, {
                        'in_octets': '93942891299',
                        'out_octets': '855601086055',
                        'poller_hash': 'ZjQ5MmJmMDYwYzhmcGVlcmludGY='
                    }, {
                        'in_octets': '17888404761',
                        'out_octets': '352025510070',
                        'poller_hash': 'ZjQ5MmJmMDZlNDA0cGVlcmludGY='
                    }, {
                        'in_octets': '2516227918',
                        'out_octets': '37351004210',
                        'poller_hash': 'ZjQ5MmJmMDZlNDU2cGVlcmludGY='
                    }, {
                        'in_octets': '41199525945',
                        'out_octets': '673463910431',
                        'poller_hash': 'ZjQ5MmJmMDZlNTJkcGVlcmludGY='
                    }, {
                        'in_octets': '48254841861',
                        'out_octets': '2510522673470',
                        'poller_hash': 'ZjQ5MmJmMDZlNWY4cGVlcmludGY='
                    }, {
                        'in_octets': '14773019171',
                        'out_octets': '333970562947',
                        'poller_hash': 'ZjQ5MmJmMDZlNzVjcGVlcmludGY='
                    }, {
                        'in_octets': '32197629888',
                        'out_octets': '1031592999146',
                        'poller_hash': 'ZjQ5MmJmMDZmMzE5cGVlcmludGY='
                    }, {
                        'in_octets': '7450548046',
                        'out_octets': '130979488301',
                        'poller_hash': 'ZjQ5MmJmMDZmNTFhcGVlcmludGY='
                    }, {
                        'in_octets': '48724513380',
                        'out_octets': '226908179626',
                        'poller_hash': 'YjRmYmU0ZTZkNzM3cGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon3',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '82451686830701',
                    'out_ucast_pkts':
                    '68685949384',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uM2ludGY=',
                    'pons': [{
                        'id':
                        '3',
                        'links': [{
                            'connected_time': '144430',
                            'fiber_length': 401,
                            'poller_hash': 'NzBhNzQxMzJmNTEwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751985',
                            'fiber_length': 3998,
                            'poller_hash': 'NzBhNzQxMzMyYmZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751985',
                            'fiber_length': 1655,
                            'poller_hash': 'NzBhNzQxMzMyY2I4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4147878',
                            'fiber_length': 2635,
                            'poller_hash': 'Nzg0NTU4OTVjMzZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2502009',
                            'fiber_length': 4162,
                            'poller_hash': 'Nzg0NTU4OTVjM2IwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '131380',
                            'fiber_length': 2476,
                            'poller_hash': 'NjhkNzlhMDY1M2JmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '17542490',
                            'fiber_length': 651,
                            'poller_hash': 'NzRhY2I5MDZhN2NhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '32820169',
                            'fiber_length': 2404,
                            'poller_hash': 'ZjQ5MmJmMDYwYWMwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751985',
                            'fiber_length': 507,
                            'poller_hash': 'ZjQ5MmJmMDYwYzhmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 4029,
                            'poller_hash': 'ZjQ5MmJmMDZlNDA0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '314732',
                            'fiber_length': 2991,
                            'poller_hash': 'ZjQ5MmJmMDZlNDU2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 4064,
                            'poller_hash': 'ZjQ5MmJmMDZlNTJkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 3833,
                            'poller_hash': 'ZjQ5MmJmMDZlNWY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2718991',
                            'fiber_length': 800,
                            'poller_hash': 'ZjQ5MmJmMDZlNzVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2735041',
                            'fiber_length': 644,
                            'poller_hash': 'ZjQ5MmJmMDZmMzE5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 3353,
                            'poller_hash': 'ZjQ5MmJmMDZmNTFhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3915985',
                            'fiber_length': 2450,
                            'poller_hash': 'YjRmYmU0ZTZkNzM3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon3',
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon4',
                    'in_errors':
                    '0',
                    'in_octets':
                    '10808593119543',
                    'in_ucast_pkts':
                    '39501190629',
                    'links': [{
                        'in_octets': '8080434118',
                        'out_octets': '311147212731',
                        'poller_hash': 'NzBhNzQxMzJmNTdjcGVlcmludGY='
                    }, {
                        'in_octets': '38561419547',
                        'out_octets': '1206856652724',
                        'poller_hash': 'NzBhNzQxMzJmNjU0cGVlcmludGY='
                    }, {
                        'in_octets': '10113597175',
                        'out_octets': '631194097615',
                        'poller_hash': 'Nzg0NTU4OTVjMGY0cGVlcmludGY='
                    }, {
                        'in_octets': '6939365487',
                        'out_octets': '34503963233',
                        'poller_hash': 'Nzg0NTU4OTVkNDkwcGVlcmludGY='
                    }, {
                        'in_octets': '48191616857',
                        'out_octets': '748100643863',
                        'poller_hash': 'ZjQ5MmJmMDYwYWEzcGVlcmludGY='
                    }, {
                        'in_octets': '231734211008',
                        'out_octets': '1290564132006',
                        'poller_hash': 'ZjQ5MmJmMDYwYWE0cGVlcmludGY='
                    }, {
                        'in_octets': '234235459162',
                        'out_octets': '3081515418301',
                        'poller_hash': 'ZjQ5MmJmMDYwYWE1cGVlcmludGY='
                    }, {
                        'in_octets': '70436261425',
                        'out_octets': '1990196695797',
                        'poller_hash': 'ZjQ5MmJmMDYwYWFicGVlcmludGY='
                    }, {
                        'in_octets': '2405435622',
                        'out_octets': '68138729320',
                        'poller_hash': 'ZjQ5MmJmMDYwYmQycGVlcmludGY='
                    }, {
                        'in_octets': '9846408154',
                        'out_octets': '64674445492',
                        'poller_hash': 'ZjQ5MmJmMDYwYmUzcGVlcmludGY='
                    }, {
                        'in_octets': '10184826899',
                        'out_octets': '291225455440',
                        'poller_hash': 'ZjQ5MmJmMDYwYmU0cGVlcmludGY='
                    }, {
                        'in_octets': '18712593205',
                        'out_octets': '254366955439',
                        'poller_hash': 'ZjQ5MmJmMDYwYmYzcGVlcmludGY='
                    }, {
                        'in_octets': '8094178403',
                        'out_octets': '66615357827',
                        'poller_hash': 'ZjQ5MmJmMDYwYzAzcGVlcmludGY='
                    }, {
                        'in_octets': '46607020203',
                        'out_octets': '305207258415',
                        'poller_hash': 'ZjQ5MmJmMDYwYzM5cGVlcmludGY='
                    }, {
                        'in_octets': '41585133775',
                        'out_octets': '767047358429',
                        'poller_hash': 'ZjQ5MmJmMDYwYzhicGVlcmludGY='
                    }, {
                        'in_octets': '29895627635',
                        'out_octets': '319637726358',
                        'poller_hash': 'ZjQ5MmJmMDYwY2I4cGVlcmludGY='
                    }, {
                        'in_octets': '181560676436',
                        'out_octets': '454658110267',
                        'poller_hash': 'ZjQ5MmJmMDYwY2M4cGVlcmludGY='
                    }, {
                        'in_octets': '24061190613',
                        'out_octets': '875916588153',
                        'poller_hash': 'ZjQ5MmJmMDZlNzNlcGVlcmludGY='
                    }, {
                        'in_octets': '2685243941',
                        'out_octets': '72158810188',
                        'poller_hash': 'ZjQ5MmJmMDZlNzU1cGVlcmludGY='
                    }, {
                        'in_octets': '11569552211',
                        'out_octets': '342658834887',
                        'poller_hash': 'ZjQ5MmJmMDZmMGRjcGVlcmludGY='
                    }, {
                        'in_octets': '143891962160',
                        'out_octets': '2153845937130',
                        'poller_hash': 'YjRmYmU0ZTZlNzNkcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon4',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '115080032451807',
                    'out_ucast_pkts':
                    '96309904252',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uNGludGY=',
                    'pons': [{
                        'id':
                        '4',
                        'links': [{
                            'connected_time': '1703649',
                            'fiber_length': 18518,
                            'poller_hash': 'NzBhNzQxMzJmNTdjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4400731',
                            'fiber_length': 355,
                            'poller_hash': 'NzBhNzQxMzJmNjU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 526,
                            'poller_hash': 'Nzg0NTU4OTVjMGY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '139980',
                            'fiber_length': 419,
                            'poller_hash': 'Nzg0NTU4OTVkNDkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6011281',
                            'fiber_length': 10989,
                            'poller_hash': 'ZjQ5MmJmMDYwYWEzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9394672',
                            'fiber_length': 11011,
                            'poller_hash': 'ZjQ5MmJmMDYwYWE0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '10687697',
                            'fiber_length': 15323,
                            'poller_hash': 'ZjQ5MmJmMDYwYWE1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9395072',
                            'fiber_length': 15294,
                            'poller_hash': 'ZjQ5MmJmMDYwYWFicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 17606,
                            'poller_hash': 'ZjQ5MmJmMDYwYmQycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 15476,
                            'poller_hash': 'ZjQ5MmJmMDYwYmUzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703649',
                            'fiber_length': 18141,
                            'poller_hash': 'ZjQ5MmJmMDYwYmU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9394671',
                            'fiber_length': 11429,
                            'poller_hash': 'ZjQ5MmJmMDYwYmYzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9394662',
                            'fiber_length': 11416,
                            'poller_hash': 'ZjQ5MmJmMDYwYzAzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9394671',
                            'fiber_length': 11441,
                            'poller_hash': 'ZjQ5MmJmMDYwYzM5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3017725',
                            'fiber_length': 11115,
                            'poller_hash': 'ZjQ5MmJmMDYwYzhicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 15707,
                            'poller_hash': 'ZjQ5MmJmMDYwY2I4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '9394671',
                            'fiber_length': 11268,
                            'poller_hash': 'ZjQ5MmJmMDYwY2M4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4034357',
                            'fiber_length': 823,
                            'poller_hash': 'ZjQ5MmJmMDZlNzNlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 18691,
                            'poller_hash': 'ZjQ5MmJmMDZlNzU1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1703679',
                            'fiber_length': 17588,
                            'poller_hash': 'ZjQ5MmJmMDZmMGRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 370,
                            'poller_hash': 'YjRmYmU0ZTZlNzNkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon4',
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon5',
                    'in_errors':
                    '0',
                    'in_octets':
                    '9158326990757',
                    'in_ucast_pkts':
                    '28492029152',
                    'links': [{
                        'in_octets': '61538569267',
                        'out_octets': '2083065968776',
                        'poller_hash': 'NjhkNzlhMDY1MzYxcGVlcmludGY='
                    }, {
                        'in_octets': '15174113650',
                        'out_octets': '138426127587',
                        'poller_hash': 'ZjQ5MmJmMDYwYTVmcGVlcmludGY='
                    }, {
                        'in_octets': '30791492050',
                        'out_octets': '344350385160',
                        'poller_hash': 'YjRmYmU0ZTZkNzMzcGVlcmludGY='
                    }, {
                        'in_octets': '29988333305',
                        'out_octets': '1230012998216',
                        'poller_hash': 'YjRmYmU0ZTZlNzJlcGVlcmludGY='
                    }, {
                        'in_octets': '407301660',
                        'out_octets': '8148840961',
                        'poller_hash': 'YjRmYmU0ZTZlN2M0cGVlcmludGY='
                    }, {
                        'in_octets': '54186737319',
                        'out_octets': '1595930280165',
                        'poller_hash': 'YjRmYmU0ZTZlODE2cGVlcmludGY='
                    }, {
                        'in_octets': '511199320123',
                        'out_octets': '1138527495450',
                        'poller_hash': 'YjRmYmU0ZTZlODVmcGVlcmludGY='
                    }, {
                        'in_octets': '33940226416',
                        'out_octets': '137006998777',
                        'poller_hash': 'YjRmYmU0ZTZlODlicGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon5',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '77087474445243',
                    'out_ucast_pkts':
                    '71231951349',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uNWludGY=',
                    'pons': [{
                        'id':
                        '5',
                        'links': [{
                            'connected_time': '4044297',
                            'fiber_length': 3458,
                            'poller_hash': 'NjhkNzlhMDY1MzYxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4044287',
                            'fiber_length': 3045,
                            'poller_hash': 'ZjQ5MmJmMDYwYTVmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '799058',
                            'fiber_length': 1218,
                            'poller_hash': 'YjRmYmU0ZTZkNzMzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4044277',
                            'fiber_length': 3466,
                            'poller_hash': 'YjRmYmU0ZTZlNzJlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '58129',
                            'fiber_length': 2933,
                            'poller_hash': 'YjRmYmU0ZTZlN2M0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 611,
                            'poller_hash': 'YjRmYmU0ZTZlODE2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4044287',
                            'fiber_length': 4320,
                            'poller_hash': 'YjRmYmU0ZTZlODVmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2393197',
                            'fiber_length': 2896,
                            'poller_hash': 'YjRmYmU0ZTZlODlicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon5',
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon6',
                    'in_errors':
                    '0',
                    'in_octets':
                    '6585668951255',
                    'in_ucast_pkts':
                    '21368420958',
                    'links': [{
                        'in_octets': '12889658994',
                        'out_octets': '474807784979',
                        'poller_hash': 'NzBhNzQxMzJmNDRjcGVlcmludGY='
                    }, {
                        'in_octets': '53481170163',
                        'out_octets': '1817054145489',
                        'poller_hash': 'NzBhNzQxMzJmNWQ4cGVlcmludGY='
                    }, {
                        'in_octets': '26739296554',
                        'out_octets': '596894349104',
                        'poller_hash': 'Nzg0NTU4OTVkMzgwcGVlcmludGY='
                    }, {
                        'in_octets': '20106793170',
                        'out_octets': '799506207056',
                        'poller_hash': 'ZjQ5MmJmMDZlMGJlcGVlcmludGY='
                    }, {
                        'in_octets': '100218969278',
                        'out_octets': '1649284105874',
                        'poller_hash': 'ZjQ5MmJmMDZlNDJmcGVlcmludGY='
                    }, {
                        'in_octets': '49206395961',
                        'out_octets': '1217535082077',
                        'poller_hash': 'ZjQ5MmJmMDZlNjNhcGVlcmludGY='
                    }, {
                        'in_octets': '45484282143',
                        'out_octets': '865593485595',
                        'poller_hash': 'ZjQ5MmJmMDZlNzI1cGVlcmludGY='
                    }, {
                        'in_octets': '22052831664',
                        'out_octets': '148587210657',
                        'poller_hash': 'ZjQ5MmJmMDZlNzQ5cGVlcmludGY='
                    }, {
                        'in_octets': '35833393893',
                        'out_octets': '445010687552',
                        'poller_hash': 'ZjQ5MmJmMDZmNGQ5cGVlcmludGY='
                    }, {
                        'in_octets': '6903138178',
                        'out_octets': '72174486170',
                        'poller_hash': 'ZjQ5MmJmMDZmNTBmcGVlcmludGY='
                    }, {
                        'in_octets': '26297243907',
                        'out_octets': '308568394681',
                        'poller_hash': 'YjRmYmU0ZTZkNzI4cGVlcmludGY='
                    }, {
                        'in_octets': '0',
                        'out_octets': '0',
                        'poller_hash': 'YjRmYmU0ZTZkZmY1cGVlcmludGY='
                    }, {
                        'in_octets': '38940730145',
                        'out_octets': '297984857264',
                        'poller_hash': 'YjRmYmU0ZTZlMjg2cGVlcmludGY='
                    }, {
                        'in_octets': '37345066606',
                        'out_octets': '192032241569',
                        'poller_hash': 'YjRmYmU0ZTZlNzI4cGVlcmludGY='
                    }, {
                        'in_octets': '5543285944',
                        'out_octets': '30194536974',
                        'poller_hash': 'YjRmYmU0ZTZlOGZicGVlcmludGY='
                    }, {
                        'in_octets': '24900785839',
                        'out_octets': '432410612283',
                        'poller_hash': 'ZDAyMWY5MWFjZDM4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon6',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '80304823153103',
                    'out_ucast_pkts':
                    '68671226933',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uNmludGY=',
                    'pons': [{
                        'id':
                        '6',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 5613,
                            'poller_hash': 'NzBhNzQxMzJmNDRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751995',
                            'fiber_length': 3246,
                            'poller_hash': 'NzBhNzQxMzJmNWQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751985',
                            'fiber_length': 6528,
                            'poller_hash': 'Nzg0NTU4OTVkMzgwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1282814',
                            'fiber_length': 6060,
                            'poller_hash': 'ZjQ5MmJmMDZlMGJlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751985',
                            'fiber_length': 7061,
                            'poller_hash': 'ZjQ5MmJmMDZlNDJmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4044287',
                            'fiber_length': 5635,
                            'poller_hash': 'ZjQ5MmJmMDZlNjNhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 5341,
                            'poller_hash': 'ZjQ5MmJmMDZlNzI1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 5702,
                            'poller_hash': 'ZjQ5MmJmMDZlNzQ5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1362655',
                            'fiber_length': 4638,
                            'poller_hash': 'ZjQ5MmJmMDZmNGQ5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4751994',
                            'fiber_length': 4751,
                            'poller_hash': 'ZjQ5MmJmMDZmNTBmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '799058',
                            'fiber_length': 3746,
                            'poller_hash': 'YjRmYmU0ZTZkNzI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '799058',
                            'fiber_length': 3727,
                            'poller_hash': 'YjRmYmU0ZTZkZmY1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1786550',
                            'fiber_length': 3120,
                            'poller_hash': 'YjRmYmU0ZTZlMjg2cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '799058',
                            'fiber_length': 3735,
                            'poller_hash': 'YjRmYmU0ZTZlNzI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '746687',
                            'fiber_length': 2933,
                            'poller_hash': 'YjRmYmU0ZTZlOGZicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2237305',
                            'fiber_length': 5324,
                            'poller_hash': 'ZDAyMWY5MWFjZDM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon6',
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up': True,
                    'id': 'pon7',
                    'name': 'pon7',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0NTAzYjhhcG9uN2ludGY='
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon8',
                    'in_errors':
                    '0',
                    'in_octets':
                    '106250154232',
                    'in_ucast_pkts':
                    '626086928',
                    'links': [{
                        'in_octets': '18909417133',
                        'out_octets': '84043068539',
                        'poller_hash': 'Nzg0NTU4OTVjMzA4cGVlcmludGY='
                    }, {
                        'in_octets': '2483381931',
                        'out_octets': '19877537988',
                        'poller_hash': 'Nzg0NTU4OTVkNDc4cGVlcmludGY='
                    }, {
                        'in_octets': '17123883502',
                        'out_octets': '384995526756',
                        'poller_hash': 'NjhkNzlhMDZmZTkzcGVlcmludGY='
                    }, {
                        'in_octets': '25176369735',
                        'out_octets': '891036245817',
                        'poller_hash': 'ZjQ5MmJmMDZlNTk5cGVlcmludGY='
                    }, {
                        'in_octets': '32624369913',
                        'out_octets': '394319264326',
                        'poller_hash': 'ZjQ5MmJmMDZmMjk4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon8',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '2644835208953',
                    'out_ucast_pkts':
                    '10542868966',
                    'poller_hash':
                    'YjRmYmU0NTAzYjhhcG9uOGludGY=',
                    'pons': [{
                        'id':
                        '8',
                        'links': [{
                            'connected_time': '3532081',
                            'fiber_length': 9329,
                            'poller_hash': 'Nzg0NTU4OTVjMzA4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1116712',
                            'fiber_length': 7992,
                            'poller_hash': 'Nzg0NTU4OTVkNDc4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2476078',
                            'fiber_length': 7849,
                            'poller_hash': 'NjhkNzlhMDZmZTkzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3532080',
                            'fiber_length': 19937,
                            'poller_hash': 'ZjQ5MmJmMDZlNTk5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3532080',
                            'fiber_length': 8195,
                            'poller_hash': 'ZjQ5MmJmMDZmMjk4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon8',
                        'poller_hash':
                        'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up': True,
                    'id': 'sfp1',
                    'in_octets': '336846084827683',
                    'in_ucast_pkts': '256867207664',
                    'manufacturer': 'MikroTik',
                    'model': 'XS+DA0001',
                    'name': 'SFP+ 1',
                    'oper_up': True,
                    'out_octets': '25647616061166',
                    'out_ucast_pkts': '92707513904',
                    'poller_hash': 'YjRmYmU0NTAzYjhhc2ZwMWludGY=',
                    'speed': '10000000000'
                }, {
                    'admin_up': True,
                    'id': 'sfp2',
                    'name': 'SFP+ 2',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0NTAzYjhhc2ZwMmludGY='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                20.0,
                'model':
                'UFiber OLT',
                'serial_number':
                'UBNTe4503b8a',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:50:3b:8a',
                'temperature':
                13.75,
                'uptime':
                '43465206'
            },
            'peers': [{
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3849134107222',
                    'links': [{
                        'in_octets': '3849134107222',
                        'out_octets': '222461380262',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '222461380262',
                    'poller_hash':
                    'NzBhNzQxMzJmNDhjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4733215',
                            'fiber_length': 10823,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -24.684,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.794
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzBhNzQxMzJmNDhjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['84:d8:1b:7a:da:60'],
                    'id': '1',
                    'in_octets': '222461380262',
                    'mac_address': '70:a7:41:33:f4:8c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3849134107222',
                    'poller_hash': 'NzBhNzQxMzJmNDhjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'brenda_chenal',
                'serial_number':
                'UBNT4132f48c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f4:8c',
                'temperature':
                15.0,
                'uptime':
                '4733273'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3319896763602',
                    'links': [{
                        'in_octets': '3319896763602',
                        'out_octets': '111764754227',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '111764754227',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYTU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '10687697',
                            'fiber_length': 9570,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.676
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYTU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:83:c0:13'],
                    'id': '1',
                    'in_octets': '111764754227',
                    'mac_address': 'f4:92:bf:07:0a:54',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3319896763602',
                    'poller_hash': 'ZjQ5MmJmMDYwYTU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'frank_backlin',
                'serial_number':
                'UBNTbf060a54',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:54',
                'temperature':
                18.0,
                'uptime':
                '10687756'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '175714892507',
                    'links': [{
                        'in_octets': '175714892507',
                        'out_octets': '11928576097',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11928576097',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYTVjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '5255521',
                            'fiber_length': 9382,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.098,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.084
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYTVjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:aa:24'],
                    'id': '1',
                    'in_octets': '11928576097',
                    'mac_address': 'f4:92:bf:07:0a:5c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '175714892507',
                    'poller_hash': 'ZjQ5MmJmMDYwYTVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'adam_lein',
                'serial_number':
                'UBNTbf060a5c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:5c',
                'temperature':
                13.0,
                'uptime':
                '5255574'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '243062662871',
                    'links': [{
                        'in_octets': '243062662871',
                        'out_octets': '8965376115',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8965376115',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWMzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 13287,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.486,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.054
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWMzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:c8:88'],
                    'id': '1',
                    'in_octets': '8965376115',
                    'mac_address': 'f4:92:bf:07:0a:c3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '243062662871',
                    'poller_hash': 'ZjQ5MmJmMDYwYWMzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'michelle_bengtson',
                'serial_number':
                'UBNTbf060ac3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:c3',
                'temperature':
                8.0,
                'uptime':
                '1703732'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '106792795550',
                    'links': [{
                        'in_octets': '106792795550',
                        'out_octets': '6098156361',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6098156361',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmE0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 10549,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.674,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.354
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmE0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:8c:d4'],
                    'id': '1',
                    'in_octets': '6098156361',
                    'mac_address': 'f4:92:bf:07:0b:a4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '106792795550',
                    'poller_hash': 'ZjQ5MmJmMDYwYmE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'ryan_tschumperlin',
                'serial_number':
                'UBNTbf060ba4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:a4',
                'temperature':
                14.0,
                'uptime':
                '1703737'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '118738709706',
                    'links': [{
                        'in_octets': '118738709706',
                        'out_octets': '7093446055',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7093446055',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmQ5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1085902',
                            'fiber_length': 10126,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.29
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmQ5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:e3:f0'],
                    'id': '1',
                    'in_octets': '7093446055',
                    'mac_address': 'f4:92:bf:07:0b:d9',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '118738709706',
                    'poller_hash': 'ZjQ5MmJmMDYwYmQ5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jennifer_campbell',
                'serial_number':
                'UBNTbf060bd9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:d9',
                'temperature':
                13.0,
                'uptime':
                '1085955'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '299112485055',
                    'links': [{
                        'in_octets': '299112485055',
                        'out_octets': '15625512575',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15625512575',
                    'poller_hash':
                    'ZjQ5MmJmMDYwY2M0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2589910',
                            'fiber_length': 10653,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.364,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.958
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwY2M0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['18:e8:29:37:a4:fb'],
                    'id': '1',
                    'in_octets': '15625512575',
                    'mac_address': 'f4:92:bf:07:0c:c4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '299112485055',
                    'poller_hash': 'ZjQ5MmJmMDYwY2M0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'darvaia_stinar',
                'serial_number':
                'UBNTbf060cc4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:c4',
                'temperature':
                15.0,
                'uptime':
                '2589970'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '32803386862',
                    'links': [{
                        'in_octets': '32803386862',
                        'out_octets': '3088512466',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3088512466',
                    'poller_hash':
                    'ZjQ5MmJmMDYwZGM0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '231971',
                            'fiber_length': 9799,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.838,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.932
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwZGM0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['14:91:82:12:6c:5d'],
                    'id': '1',
                    'in_octets': '3088512466',
                    'mac_address': 'f4:92:bf:07:0d:c4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '32803386862',
                    'poller_hash': 'ZjQ5MmJmMDYwZGM0ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'eric_carlson',
                'serial_number':
                'UBNTbf060dc4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0d:c4',
                'temperature':
                8.0,
                'uptime':
                '232025'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '208297711695',
                    'links': [{
                        'in_octets': '208297711695',
                        'out_octets': '27896807920',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '27896807920',
                    'poller_hash':
                    'ZjQ5MmJmMDYwZGQ4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 12573,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisx',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.19,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.34
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwZGQ4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:83:c2:eb:89:b3'],
                    'id': '1',
                    'in_octets': '27896807920',
                    'mac_address': 'f4:92:bf:07:0d:d8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '208297711695',
                    'poller_hash': 'ZjQ5MmJmMDYwZGQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'jackie_schommer',
                'serial_number':
                'UBNTbf060dd8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0d:d8',
                'temperature':
                13.0,
                'uptime':
                '1703735'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1068117378952',
                    'links': [{
                        'in_octets': '1068117378952',
                        'out_octets': '21808323770',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '21808323770',
                    'poller_hash':
                    'NzBhNzQxMzMyY2QwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1101972',
                            'fiber_length': 356,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.716,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.436
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzBhNzQxMzMyY2QwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:83:c0:00'],
                    'id': '1',
                    'in_octets': '21808323770',
                    'mac_address': '70:a7:41:34:2c:d0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1068117378952',
                    'poller_hash': 'NzBhNzQxMzMyY2QwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'pauline_miller',
                'serial_number':
                'UBNT41332cd0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:33:2c:d0',
                'temperature':
                14.0,
                'uptime':
                '1102029'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '46449359742',
                    'links': [{
                        'in_octets': '46449359742',
                        'out_octets': '3965917114',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3965917114',
                    'poller_hash':
                    'Nzg0NTU4OTVjM2FjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '767428',
                            'fiber_length': 1238,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.45,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.262
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTVjM2FjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['5c:62:8b:ab:6f:45'],
                    'id': '1',
                    'in_octets': '3965917114',
                    'mac_address': '78:45:58:96:c3:ac',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '46449359742',
                    'poller_hash': 'Nzg0NTU4OTVjM2FjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'laurie_hopp',
                'serial_number':
                'UBNT5895c3ac',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:c3:ac',
                'temperature':
                11.0,
                'uptime':
                '767483'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '362985476692',
                    'links': [{
                        'in_octets': '362985476692',
                        'out_octets': '11458675648',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11458675648',
                    'poller_hash':
                    'NjhkNzlhMDZmZjMxcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '415944',
                            'fiber_length': 1535,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.496,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.346
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NjhkNzlhMDZmZjMxcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:75:d1:6c'],
                    'id': '1',
                    'in_octets': '11458675648',
                    'mac_address': '68:d7:9a:07:ff:31',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '362985476692',
                    'poller_hash': 'NjhkNzlhMDZmZjMxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'cathy_thompson',
                'serial_number':
                'UBNT9a06ff31',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '68:d7:9a:06:ff:31',
                'temperature':
                14.0,
                'uptime':
                '416001'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '49350620497',
                    'links': [{
                        'in_octets': '49350620497',
                        'out_octets': '3228637671',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '3228637671',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYTU2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '929970',
                            'fiber_length': 7149,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.988,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.382
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYTU2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:7e:74'],
                    'id': '1',
                    'in_octets': '3228637671',
                    'mac_address': 'f4:92:bf:07:0a:56',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '49350620497',
                    'poller_hash': 'ZjQ5MmJmMDYwYTU2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'larry_bergeron',
                'serial_number':
                'UBNTbf060a56',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:56',
                'temperature':
                15.0,
                'uptime':
                '930026'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '24727742883',
                    'links': [{
                        'in_octets': '24727742883',
                        'out_octets': '15428891751',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15428891751',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWE2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 1203,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.214,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.154
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWE2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['f4:92:bf:4b:d1:c9'],
                    'id': '1',
                    'in_octets': '15428891751',
                    'mac_address': 'f4:92:bf:07:0a:a6',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '24727742883',
                    'poller_hash': 'ZjQ5MmJmMDYwYWE2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'barb_burke',
                'serial_number':
                'UBNTbf060aa6',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:a6',
                'temperature':
                17.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '296509311',
                    'links': [{
                        'in_octets': '296509311',
                        'out_octets': '384893936',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '384893936',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmNlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3545451',
                            'fiber_length': 993,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.574,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.292
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmNlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:8c:3c'],
                    'id': '1',
                    'in_octets': '384893936',
                    'mac_address': 'f4:92:bf:07:0b:ce',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '296509311',
                    'poller_hash': 'ZjQ5MmJmMDYwYmNlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'neal_chapman',
                'serial_number':
                'UBNTbf060bce',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:ce',
                'temperature':
                8.0,
                'uptime':
                '3545511'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '847913610460',
                    'links': [{
                        'in_octets': '847913610460',
                        'out_octets': '37869131747',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '37869131747',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmY1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9388152',
                            'fiber_length': 4086,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.828,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.782
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmY1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:8c:34'],
                    'id': '1',
                    'in_octets': '37869131747',
                    'mac_address': 'f4:92:bf:07:0b:f5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '847913610460',
                    'poller_hash': 'ZjQ5MmJmMDYwYmY1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'kathy_griffin',
                'serial_number':
                'UBNTbf060bf5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:f5',
                'temperature':
                8.0,
                'uptime':
                '9388208'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '514400993381',
                    'links': [{
                        'in_octets': '514400993381',
                        'out_octets': '46691526639',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '46691526639',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzMycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7081734',
                            'fiber_length': 6556,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.27,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.42
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzMycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:5a:4c:d5:01:ee'],
                    'id': '1',
                    'in_octets': '46691526639',
                    'mac_address': 'f4:92:bf:07:0c:32',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '514400993381',
                    'poller_hash': 'ZjQ5MmJmMDYwYzMyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'ed_peterson',
                'serial_number':
                'UBNTbf060c32',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:32',
                'temperature':
                14.0,
                'uptime':
                '7081788'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '396073241457',
                    'links': [{
                        'in_octets': '396073241457',
                        'out_octets': '569467655952',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '569467655952',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzVicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '10687697',
                            'fiber_length': 6956,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.458,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.892
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzVicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:a6:d4'],
                    'id': '1',
                    'in_octets': '569467655952',
                    'mac_address': 'f4:92:bf:07:0c:5b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '396073241457',
                    'poller_hash': 'ZjQ5MmJmMDYwYzViZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'troy_lee',
                'serial_number':
                'UBNTbf060c5b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:5b',
                'temperature':
                16.0,
                'uptime':
                '10687758'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '42718453903',
                    'links': [{
                        'in_octets': '42718453903',
                        'out_octets': '2588687025',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2588687025',
                    'poller_hash':
                    'ZjQ5MmJmMDYwZDg5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '580746',
                            'fiber_length': 1087,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.288,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.05
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwZDg5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:5a:4c:e7:3c:68'],
                    'id': '1',
                    'in_octets': '2588687025',
                    'mac_address': 'f4:92:bf:07:0d:89',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '42718453903',
                    'poller_hash': 'ZjQ5MmJmMDYwZDg5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'edward_feidt',
                'serial_number':
                'UBNTbf060d89',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0d:89',
                'temperature':
                15.0,
                'uptime':
                '580804'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '81002587634',
                    'links': [{
                        'in_octets': '81002587634',
                        'out_octets': '1870565314',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1870565314',
                    'poller_hash':
                    'NzBhNzQxMzJmNTEwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '144430',
                            'fiber_length': 401,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.534,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.27
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzBhNzQxMzJmNTEwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:57:18:bb'],
                    'id': '1',
                    'in_octets': '1870565314',
                    'mac_address': '70:a7:41:33:f5:10',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '81002587634',
                    'poller_hash': 'NzBhNzQxMzJmNTEwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'terra_nomeland',
                'serial_number':
                'UBNT4132f510',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f5:10',
                'temperature':
                8.0,
                'uptime':
                '144483'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '488053817808',
                    'links': [{
                        'in_octets': '488053817808',
                        'out_octets': '9952355709',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '9952355709',
                    'poller_hash':
                    'NzBhNzQxMzMyYmZjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751985',
                            'fiber_length': 3998,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.304,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.1
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzBhNzQxMzMyYmZjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:38:a2:82'],
                    'id': '1',
                    'in_octets': '9952355709',
                    'mac_address': '70:a7:41:34:2b:fc',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '488053817808',
                    'poller_hash': 'NzBhNzQxMzMyYmZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jo_degeer',
                'serial_number':
                'UBNT41332bfc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:33:2b:fc',
                'temperature':
                14.0,
                'uptime':
                '4752054'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '480299524792',
                    'links': [{
                        'in_octets': '480299524792',
                        'out_octets': '49917708030',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '49917708030',
                    'poller_hash':
                    'NzBhNzQxMzMyY2I4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751985',
                            'fiber_length': 1655,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.974,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.054
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzBhNzQxMzMyY2I4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:57:20:e9'],
                    'id': '1',
                    'in_octets': '49917708030',
                    'mac_address': '70:a7:41:34:2c:b8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '480299524792',
                    'poller_hash': 'NzBhNzQxMzMyY2I4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'corinne_mcnielly',
                'serial_number':
                'UBNT41332cb8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:33:2c:b8',
                'temperature':
                12.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '615106324750',
                    'links': [{
                        'in_octets': '615106324750',
                        'out_octets': '93966740222',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '93966740222',
                    'poller_hash':
                    'Nzg0NTU4OTVjMzZjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4147878',
                            'fiber_length': 2635,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.926,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.612
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTVjMzZjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:57:33:c7'],
                    'id': '1',
                    'in_octets': '93966740222',
                    'mac_address': '78:45:58:96:c3:6c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '615106324750',
                    'poller_hash': 'Nzg0NTU4OTVjMzZjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'dawn_meadows',
                'serial_number':
                'UBNT5895c36c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:c3:6c',
                'temperature':
                3.0,
                'uptime':
                '4147940'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1062438998472',
                    'links': [{
                        'in_octets': '1062438998472',
                        'out_octets': '21693880245',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '21693880245',
                    'poller_hash':
                    'Nzg0NTU4OTVjM2IwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2502009',
                            'fiber_length': 4162,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.772,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.954
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTVjM2IwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['a0:36:bc:1a:6b:68'],
                    'id': '1',
                    'in_octets': '21693880245',
                    'mac_address': '78:45:58:96:c3:b0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1062438998472',
                    'poller_hash': 'Nzg0NTU4OTVjM2IwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'justin_campbell',
                'serial_number':
                'UBNT5895c3b0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:c3:b0',
                'temperature':
                23.0,
                'uptime':
                '2502066'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '62357381027',
                    'links': [{
                        'in_octets': '62357381027',
                        'out_octets': '2868103384',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2868103384',
                    'poller_hash':
                    'NjhkNzlhMDY1M2JmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '131380',
                            'fiber_length': 2476,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.882,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.898
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NjhkNzlhMDY1M2JmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:8d:ce:d8'],
                    'id': '1',
                    'in_octets': '2868103384',
                    'mac_address': '68:d7:9a:07:53:bf',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '62357381027',
                    'poller_hash': 'NjhkNzlhMDY1M2JmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'ron_gallardo',
                'serial_number':
                'UBNT9a0653bf',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '68:d7:9a:06:53:bf',
                'temperature':
                15.0,
                'uptime':
                '131433'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '10615202891754',
                    'links': [{
                        'in_octets': '10615202891754',
                        'out_octets': '656121422531',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '656121422531',
                    'poller_hash':
                    'NzRhY2I5MDZhN2NhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '17542490',
                            'fiber_length': 651,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.57,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.276
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzRhY2I5MDZhN2NhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['68:d7:9a:af:f1:39'],
                    'id': '1',
                    'in_octets': '656121422531',
                    'mac_address': '74:ac:b9:07:a7:ca',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '10615202891754',
                    'poller_hash': 'NzRhY2I5MDZhN2NhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'matt_johnson',
                'serial_number':
                'UBNTb906a7ca',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '74:ac:b9:06:a7:ca',
                'temperature':
                13.0,
                'uptime':
                '17674336'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1008130759425',
                    'links': [{
                        'in_octets': '1008130759425',
                        'out_octets': '286889795472',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '286889795472',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWMwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '32820169',
                            'fiber_length': 2404,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.3,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.784
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWMwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up':
                    True,
                    'bridged_mac_addresses': [
                        '18:e8:29:8c:44:67', 'b4:fb:e4:4f:2f:fe', 'b4:fb:e4:4f:31:2c',
                        'b4:fb:e4:6a:7c:2f', 'e0:63:da:4e:c1:4d', 'e0:63:da:4f:c1:4d',
                        'f4:92:bf:d2:89:aa'
                    ],
                    'id':
                    '1',
                    'in_octets':
                    '286889795472',
                    'mac_address':
                    'f4:92:bf:07:0a:c0',
                    'name':
                    'eth0',
                    'oper_up':
                    True,
                    'out_octets':
                    '1008130759425',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWMwZXRoMQ==',
                    'speed':
                    '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'SNDW01-ONU',
                'serial_number':
                'UBNTbf060ac0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:c0',
                'temperature':
                7.0,
                'uptime':
                '35327034'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '855601086055',
                    'links': [{
                        'in_octets': '855601086055',
                        'out_octets': '93942891299',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '93942891299',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzhmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751985',
                            'fiber_length': 507,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.234,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.558
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzhmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:f5:a2:90:24:c6'],
                    'id': '1',
                    'in_octets': '93942891299',
                    'mac_address': 'f4:92:bf:07:0c:8f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '855601086055',
                    'poller_hash': 'ZjQ5MmJmMDYwYzhmZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jessica_pett',
                'serial_number':
                'UBNTbf060c8f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:8f',
                'temperature':
                9.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '352025510070',
                    'links': [{
                        'in_octets': '352025510070',
                        'out_octets': '17888404761',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '17888404761',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNDA0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 4029,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.272,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.78
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNDA0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:50:09:3c'],
                    'id': '1',
                    'in_octets': '17888404761',
                    'mac_address': 'f4:92:bf:07:e4:04',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '352025510070',
                    'poller_hash': 'ZjQ5MmJmMDZlNDA0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jean_porter',
                'serial_number':
                'UBNTbf06e404',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e4:04',
                'temperature':
                8.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '37351004210',
                    'links': [{
                        'in_octets': '37351004210',
                        'out_octets': '2516227918',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2516227918',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNDU2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '314732',
                            'fiber_length': 2991,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.686,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.682
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNDU2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:df:94'],
                    'id': '1',
                    'in_octets': '2516227918',
                    'mac_address': 'f4:92:bf:07:e4:56',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '37351004210',
                    'poller_hash': 'ZjQ5MmJmMDZlNDU2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'marshall_davis',
                'serial_number':
                'UBNTbf06e456',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e4:56',
                'temperature':
                10.0,
                'uptime':
                '314789'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '673463910431',
                    'links': [{
                        'in_octets': '673463910431',
                        'out_octets': '41199525945',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '41199525945',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNTJkcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 4064,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.556,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.056
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNTJkcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:c7:e8'],
                    'id': '1',
                    'in_octets': '41199525945',
                    'mac_address': 'f4:92:bf:07:e5:2d',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '673463910431',
                    'poller_hash': 'ZjQ5MmJmMDZlNTJkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'steven_stoner',
                'serial_number':
                'UBNTbf06e52d',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e5:2d',
                'temperature':
                9.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2510522673470',
                    'links': [{
                        'in_octets': '2510522673470',
                        'out_octets': '48254841861',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48254841861',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNWY4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 3833,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.016,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.502
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNWY4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['ac:15:a2:b2:0f:24'],
                    'id': '1',
                    'in_octets': '48254841861',
                    'mac_address': 'f4:92:bf:07:e5:f8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2510522673470',
                    'poller_hash': 'ZjQ5MmJmMDZlNWY4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'luis_karl',
                'serial_number':
                'UBNTbf06e5f8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e5:f8',
                'temperature':
                16.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '333970562947',
                    'links': [{
                        'in_octets': '333970562947',
                        'out_octets': '14773019171',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '14773019171',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNzVjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2718991',
                            'fiber_length': 800,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -13.914,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.604
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNzVjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:d7:78'],
                    'id': '1',
                    'in_octets': '14773019171',
                    'mac_address': 'f4:92:bf:07:e7:5c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '333970562947',
                    'poller_hash': 'ZjQ5MmJmMDZlNzVjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'mark_schumacher',
                'serial_number':
                'UBNTbf06e75c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e7:5c',
                'temperature':
                13.0,
                'uptime':
                '2719048'
            }, {
                'admin_disabled':
                False,
                'cpu':
                9.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1031592999146',
                    'links': [{
                        'in_octets': '1031592999146',
                        'out_octets': '32197629888',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '32197629888',
                    'poller_hash':
                    'ZjQ5MmJmMDZmMzE5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2735041',
                            'fiber_length': 644,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.686,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.934
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZmMzE5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['9c:53:22:89:56:b2'],
                    'id': '1',
                    'in_octets': '32197629888',
                    'mac_address': 'f4:92:bf:07:f3:19',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1031592999146',
                    'poller_hash': 'ZjQ5MmJmMDZmMzE5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'tina_douglas',
                'serial_number':
                'UBNTbf06f319',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f3:19',
                'temperature':
                8.0,
                'uptime':
                '2735094'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '130979488301',
                    'links': [{
                        'in_octets': '130979488301',
                        'out_octets': '7450548046',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7450548046',
                    'poller_hash':
                    'ZjQ5MmJmMDZmNTFhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 3353,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.878,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.066
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZmNTFhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['9c:53:22:89:4d:70'],
                    'id': '1',
                    'in_octets': '7450548046',
                    'mac_address': 'f4:92:bf:07:f5:1a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '130979488301',
                    'poller_hash': 'ZjQ5MmJmMDZmNTFhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'chad_thomas',
                'serial_number':
                'UBNTbf06f51a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f5:1a',
                'temperature':
                8.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '226908179626',
                    'links': [{
                        'in_octets': '226908179626',
                        'out_octets': '48724513380',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uM2ludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48724513380',
                    'poller_hash':
                    'YjRmYmU0ZTZkNzM3cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3915985',
                            'fiber_length': 2450,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQisz',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.002,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.106
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZkNzM3cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['68:d7:9a:af:f8:70'],
                    'id': '1',
                    'in_octets': '48724513380',
                    'mac_address': 'b4:fb:e4:e7:d7:37',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '226908179626',
                    'poller_hash': 'YjRmYmU0ZTZkNzM3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'sundown_saloon',
                'serial_number':
                'UBNTe4e6d737',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:d7:37',
                'temperature':
                23.0,
                'uptime':
                '3916046'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '311147212731',
                    'links': [{
                        'in_octets': '311147212731',
                        'out_octets': '8080434118',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8080434118',
                    'poller_hash':
                    'NzBhNzQxMzJmNTdjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703649',
                            'fiber_length': 18518,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.766,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.58
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzBhNzQxMzJmNTdjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:38:a7:ce'],
                    'id': '1',
                    'in_octets': '8080434118',
                    'mac_address': '70:a7:41:33:f5:7c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '311147212731',
                    'poller_hash': 'NzBhNzQxMzJmNTdjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'aaron_thole',
                'serial_number':
                'UBNT4132f57c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f5:7c',
                'temperature':
                18.0,
                'uptime':
                '1703735'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1206856652724',
                    'links': [{
                        'in_octets': '1206856652724',
                        'out_octets': '38561419547',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '38561419547',
                    'poller_hash':
                    'NzBhNzQxMzJmNjU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4400731',
                            'fiber_length': 355,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.38
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzBhNzQxMzJmNjU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:57:23:6e'],
                    'id': '1',
                    'in_octets': '38561419547',
                    'mac_address': '70:a7:41:33:f6:54',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1206856652724',
                    'poller_hash': 'NzBhNzQxMzJmNjU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'nicole_richter',
                'serial_number':
                'UBNT4132f654',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f6:54',
                'temperature':
                14.0,
                'uptime':
                '4400786'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '631194097615',
                    'links': [{
                        'in_octets': '631194097615',
                        'out_octets': '10113597175',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10113597175',
                    'poller_hash':
                    'Nzg0NTU4OTVjMGY0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 526,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.252,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.788
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTVjMGY0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['5c:62:8b:ab:68:c4'],
                    'id': '1',
                    'in_octets': '10113597175',
                    'mac_address': '78:45:58:96:c0:f4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '631194097615',
                    'poller_hash': 'Nzg0NTU4OTVjMGY0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'connie_ecklund',
                'serial_number':
                'UBNT5895c0f4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:c0:f4',
                'temperature':
                7.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '34503963233',
                    'links': [{
                        'in_octets': '34503963233',
                        'out_octets': '6939365487',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6939365487',
                    'poller_hash':
                    'Nzg0NTU4OTVkNDkwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '139980',
                            'fiber_length': 419,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.568,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.286
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTVkNDkwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['5c:62:8b:ab:66:39'],
                    'id': '1',
                    'in_octets': '6939365487',
                    'mac_address': '78:45:58:96:d4:90',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '34503963233',
                    'poller_hash': 'Nzg0NTU4OTVkNDkwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'marissa_woletz',
                'serial_number':
                'UBNT5895d490',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:d4:90',
                'temperature':
                12.0,
                'uptime':
                '140040'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '748100643863',
                    'links': [{
                        'in_octets': '748100643863',
                        'out_octets': '48191616857',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48191616857',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWEzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '6011281',
                            'fiber_length': 10989,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.704,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.258
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWEzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:5a:4c:d5:05:3d'],
                    'id': '1',
                    'in_octets': '48191616857',
                    'mac_address': 'f4:92:bf:07:0a:a3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '748100643863',
                    'poller_hash': 'ZjQ5MmJmMDYwYWEzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'rick_anderson',
                'serial_number':
                'UBNTbf060aa3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:a3',
                'temperature':
                16.0,
                'uptime':
                '6011333'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1290564132006',
                    'links': [{
                        'in_octets': '1290564132006',
                        'out_octets': '231734211008',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '231734211008',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWE0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9394672',
                            'fiber_length': 11011,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.506,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.614
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWE0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:5a:4c:d5:04:e5'],
                    'id': '1',
                    'in_octets': '231734211008',
                    'mac_address': 'f4:92:bf:07:0a:a4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1290564132006',
                    'poller_hash': 'ZjQ5MmJmMDYwYWE0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'nancy_chenal',
                'serial_number':
                'UBNTbf060aa4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:a4',
                'temperature':
                13.0,
                'uptime':
                '9394731'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3081515418301',
                    'links': [{
                        'in_octets': '3081515418301',
                        'out_octets': '234235459162',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '234235459162',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWE1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '10687697',
                            'fiber_length': 15323,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.838,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.25
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWE1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:5a:4c:d5:04:70'],
                    'id': '1',
                    'in_octets': '234235459162',
                    'mac_address': 'f4:92:bf:07:0a:a5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3081515418301',
                    'poller_hash': 'ZjQ5MmJmMDYwYWE1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'mike_knauber',
                'serial_number':
                'UBNTbf060aa5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:a5',
                'temperature':
                12.0,
                'uptime':
                '10687756'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1990196695797',
                    'links': [{
                        'in_octets': '1990196695797',
                        'out_octets': '70436261425',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '70436261425',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYWFicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9395072',
                            'fiber_length': 15294,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.44,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.512
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYWFicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['10:da:43:7a:d3:56'],
                    'id': '1',
                    'in_octets': '70436261425',
                    'mac_address': 'f4:92:bf:07:0a:ab',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1990196695797',
                    'poller_hash': 'ZjQ5MmJmMDYwYWFiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'shari_chadwick',
                'serial_number':
                'UBNTbf060aab',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:ab',
                'temperature':
                17.0,
                'uptime':
                '9395134'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '68138729320',
                    'links': [{
                        'in_octets': '68138729320',
                        'out_octets': '2405435622',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2405435622',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmQycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 17606,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.872,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.168
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmQycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['d8:47:32:da:c7:51'],
                    'id': '1',
                    'in_octets': '2405435622',
                    'mac_address': 'f4:92:bf:07:0b:d2',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '68138729320',
                    'poller_hash': 'ZjQ5MmJmMDYwYmQyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'bart_chouinard',
                'serial_number':
                'UBNTbf060bd2',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:d2',
                'temperature':
                16.0,
                'uptime':
                '1703734'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '64674445492',
                    'links': [{
                        'in_octets': '64674445492',
                        'out_octets': '9846408154',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '9846408154',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmUzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 15476,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.87,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.712
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmUzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:5a:4c:e7:3b:9f'],
                    'id': '1',
                    'in_octets': '9846408154',
                    'mac_address': 'f4:92:bf:07:0b:e3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '64674445492',
                    'poller_hash': 'ZjQ5MmJmMDYwYmUzZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'teresa_blok',
                'serial_number':
                'UBNTbf060be3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:e3',
                'temperature':
                10.0,
                'uptime':
                '1703735'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '291225455440',
                    'links': [{
                        'in_octets': '291225455440',
                        'out_octets': '10184826899',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '10184826899',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703649',
                            'fiber_length': 18141,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.098,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.016
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:5a:4c:e3:af:af'],
                    'id': '1',
                    'in_octets': '10184826899',
                    'mac_address': 'f4:92:bf:07:0b:e4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '291225455440',
                    'poller_hash': 'ZjQ5MmJmMDYwYmU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'wayne_gustafson',
                'serial_number':
                'UBNTbf060be4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:e4',
                'temperature':
                12.0,
                'uptime':
                '1703736'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '254366955439',
                    'links': [{
                        'in_octets': '254366955439',
                        'out_octets': '18712593205',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18712593205',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYmYzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9394671',
                            'fiber_length': 11429,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.61,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.96
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYmYzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:7e:0c'],
                    'id': '1',
                    'in_octets': '18712593205',
                    'mac_address': 'f4:92:bf:07:0b:f3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '254366955439',
                    'poller_hash': 'ZjQ5MmJmMDYwYmYzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jeffrey_schefelker',
                'serial_number':
                'UBNTbf060bf3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0b:f3',
                'temperature':
                12.0,
                'uptime':
                '9394732'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '66615357827',
                    'links': [{
                        'in_octets': '66615357827',
                        'out_octets': '8094178403',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '8094178403',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzAzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9394662',
                            'fiber_length': 11416,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.704,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.286
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzAzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:8b:d0'],
                    'id': '1',
                    'in_octets': '8094178403',
                    'mac_address': 'f4:92:bf:07:0c:03',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '66615357827',
                    'poller_hash': 'ZjQ5MmJmMDYwYzAzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'lesa_beeler',
                'serial_number':
                'UBNTbf060c03',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:03',
                'temperature':
                15.0,
                'uptime':
                '9394731'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '305207258415',
                    'links': [{
                        'in_octets': '305207258415',
                        'out_octets': '46607020203',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '46607020203',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzM5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9394671',
                            'fiber_length': 11441,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.788,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.886
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzM5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:ac:18'],
                    'id': '1',
                    'in_octets': '46607020203',
                    'mac_address': 'f4:92:bf:07:0c:39',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '305207258415',
                    'poller_hash': 'ZjQ5MmJmMDYwYzM5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jason_craig',
                'serial_number':
                'UBNTbf060c39',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:39',
                'temperature':
                9.0,
                'uptime':
                '9394731'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '767047358429',
                    'links': [{
                        'in_octets': '767047358429',
                        'out_octets': '41585133775',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '41585133775',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYzhicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3017725',
                            'fiber_length': 11115,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.022,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.726
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYzhicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:5a:4c:e3:b0:25'],
                    'id': '1',
                    'in_octets': '41585133775',
                    'mac_address': 'f4:92:bf:07:0c:8b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '767047358429',
                    'poller_hash': 'ZjQ5MmJmMDYwYzhiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'rob_anderson',
                'serial_number':
                'UBNTbf060c8b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:8b',
                'temperature':
                14.0,
                'uptime':
                '3017781'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '319637726358',
                    'links': [{
                        'in_octets': '319637726358',
                        'out_octets': '29895627635',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '29895627635',
                    'poller_hash':
                    'ZjQ5MmJmMDYwY2I4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 15707,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.314,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.932
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwY2I4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['38:94:ed:aa:2f:a2'],
                    'id': '1',
                    'in_octets': '29895627635',
                    'mac_address': 'f4:92:bf:07:0c:b8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '319637726358',
                    'poller_hash': 'ZjQ5MmJmMDYwY2I4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'ben_rathbun',
                'serial_number':
                'UBNTbf060cb8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:b8',
                'temperature':
                20.0,
                'uptime':
                '1703735'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '454658110267',
                    'links': [{
                        'in_octets': '454658110267',
                        'out_octets': '181560676436',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '181560676436',
                    'poller_hash':
                    'ZjQ5MmJmMDYwY2M4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '9394671',
                            'fiber_length': 11268,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.654,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.19
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwY2M4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:5a:4c:e3:b1:90'],
                    'id': '1',
                    'in_octets': '181560676436',
                    'mac_address': 'f4:92:bf:07:0c:c8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '454658110267',
                    'poller_hash': 'ZjQ5MmJmMDYwY2M4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'mike_freeberg',
                'serial_number':
                'UBNTbf060cc8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0c:c8',
                'temperature':
                19.0,
                'uptime':
                '9394732'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '875916588153',
                    'links': [{
                        'in_octets': '875916588153',
                        'out_octets': '24061190613',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24061190613',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNzNlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4034357',
                            'fiber_length': 823,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.258,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.666
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNzNlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:e0:30'],
                    'id': '1',
                    'in_octets': '24061190613',
                    'mac_address': 'f4:92:bf:07:e7:3e',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '875916588153',
                    'poller_hash': 'ZjQ5MmJmMDZlNzNlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'kim_rognrud',
                'serial_number':
                'UBNTbf06e73e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e7:3e',
                'temperature':
                8.0,
                'uptime':
                '4034410'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '72158810188',
                    'links': [{
                        'in_octets': '72158810188',
                        'out_octets': '2685243941',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2685243941',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNzU1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 18691,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -23.978,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.9
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNzU1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:50:01:dc'],
                    'id': '1',
                    'in_octets': '2685243941',
                    'mac_address': 'f4:92:bf:07:e7:55',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '72158810188',
                    'poller_hash': 'ZjQ5MmJmMDZlNzU1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'jim_renno',
                'serial_number':
                'UBNTbf06e755',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e7:55',
                'temperature':
                16.0,
                'uptime':
                '1703736'
            }, {
                'admin_disabled':
                False,
                'cpu':
                9.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '342658834887',
                    'links': [{
                        'in_octets': '342658834887',
                        'out_octets': '11569552211',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '11569552211',
                    'poller_hash':
                    'ZjQ5MmJmMDZmMGRjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1703679',
                            'fiber_length': 17588,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -22.838,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.602
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZmMGRjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:38:a3:69'],
                    'id': '1',
                    'in_octets': '11569552211',
                    'mac_address': 'f4:92:bf:07:f0:dc',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '342658834887',
                    'poller_hash': 'ZjQ5MmJmMDZmMGRjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'lisa_lundeenbrooks',
                'serial_number':
                'UBNTbf06f0dc',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f0:dc',
                'temperature':
                13.0,
                'uptime':
                '1703736'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2153845937130',
                    'links': [{
                        'in_octets': '2153845937130',
                        'out_octets': '143891962160',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '143891962160',
                    'poller_hash':
                    'YjRmYmU0ZTZlNzNkcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 370,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis0',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.478,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.968
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZlNzNkcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:fd:b8:54'],
                    'id': '1',
                    'in_octets': '143891962160',
                    'mac_address': 'b4:fb:e4:e7:e7:3d',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2153845937130',
                    'poller_hash': 'YjRmYmU0ZTZlNzNkZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'rich_brande',
                'serial_number':
                'UBNTe4e6e73d',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e7:3d',
                'temperature':
                15.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2083065968776',
                    'links': [{
                        'in_octets': '2083065968776',
                        'out_octets': '61538569267',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '61538569267',
                    'poller_hash':
                    'NjhkNzlhMDY1MzYxcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4044297',
                            'fiber_length': 3458,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.894,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.958
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NjhkNzlhMDY1MzYxcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['40:ed:00:42:96:7d'],
                    'id': '1',
                    'in_octets': '61538569267',
                    'mac_address': '68:d7:9a:07:53:61',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2083065968776',
                    'poller_hash': 'NjhkNzlhMDY1MzYxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'brandi_pederson',
                'serial_number':
                'UBNT9a065361',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '68:d7:9a:06:53:61',
                'temperature':
                5.0,
                'uptime':
                '4044348'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '138426127587',
                    'links': [{
                        'in_octets': '138426127587',
                        'out_octets': '15174113650',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '15174113650',
                    'poller_hash':
                    'ZjQ5MmJmMDYwYTVmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4044287',
                            'fiber_length': 3045,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.604,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.918
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDYwYTVmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['00:31:92:f6:78:6c'],
                    'id': '1',
                    'in_octets': '15174113650',
                    'mac_address': 'f4:92:bf:07:0a:5f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '138426127587',
                    'poller_hash': 'ZjQ5MmJmMDYwYTVmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'joshua_corrigan',
                'serial_number':
                'UBNTbf060a5f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:0a:5f',
                'temperature':
                14.0,
                'uptime':
                '4044348'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '344350385160',
                    'links': [{
                        'in_octets': '344350385160',
                        'out_octets': '30791492050',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '30791492050',
                    'poller_hash':
                    'YjRmYmU0ZTZkNzMzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '799058',
                            'fiber_length': 1218,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.924,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.184
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZkNzMzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:4b:fe:62:40:58'],
                    'id': '1',
                    'in_octets': '30791492050',
                    'mac_address': 'b4:fb:e4:e7:d7:33',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '344350385160',
                    'poller_hash': 'YjRmYmU0ZTZkNzMzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'sarah_jorgenson',
                'serial_number':
                'UBNTe4e6d733',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:d7:33',
                'temperature':
                23.0,
                'uptime':
                '799112'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1230012998216',
                    'links': [{
                        'in_octets': '1230012998216',
                        'out_octets': '29988333305',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '29988333305',
                    'poller_hash':
                    'YjRmYmU0ZTZlNzJlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4044277',
                            'fiber_length': 3466,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.0,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.712
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZlNzJlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:f3:48'],
                    'id': '1',
                    'in_octets': '29988333305',
                    'mac_address': 'b4:fb:e4:e7:e7:2e',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1230012998216',
                    'poller_hash': 'YjRmYmU0ZTZlNzJlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'tim_olson',
                'serial_number':
                'UBNTe4e6e72e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e7:2e',
                'temperature':
                12.0,
                'uptime':
                '4044347'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '8148840961',
                    'links': [{
                        'in_octets': '8148840961',
                        'out_octets': '407301660',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '407301660',
                    'poller_hash':
                    'YjRmYmU0ZTZlN2M0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '58129',
                            'fiber_length': 2933,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.03,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.978
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZlN2M0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:fd:b8:e4'],
                    'id': '1',
                    'in_octets': '407301660',
                    'mac_address': 'b4:fb:e4:e7:e7:c4',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '8148840961',
                    'poller_hash': 'YjRmYmU0ZTZlN2M0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'veda_gade',
                'serial_number':
                'UBNTe4e6e7c4',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e7:c4',
                'temperature':
                22.0,
                'uptime':
                '58190'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1595930280165',
                    'links': [{
                        'in_octets': '1595930280165',
                        'out_octets': '54186737319',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '54186737319',
                    'poller_hash':
                    'YjRmYmU0ZTZlODE2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 611,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.238,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.302
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZlODE2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:75:d0:a6'],
                    'id': '1',
                    'in_octets': '54186737319',
                    'mac_address': 'b4:fb:e4:e7:e8:16',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1595930280165',
                    'poller_hash': 'YjRmYmU0ZTZlODE2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'lewis_vfw',
                'serial_number':
                'UBNTe4e6e816',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e8:16',
                'temperature':
                18.0,
                'uptime':
                '4752053'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1138527495450',
                    'links': [{
                        'in_octets': '1138527495450',
                        'out_octets': '511199320123',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '511199320123',
                    'poller_hash':
                    'YjRmYmU0ZTZlODVmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4044287',
                            'fiber_length': 4320,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.1,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.726
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZlODVmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:75:d3:99'],
                    'id': '1',
                    'in_octets': '511199320123',
                    'mac_address': 'b4:fb:e4:e7:e8:5f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1138527495450',
                    'poller_hash': 'YjRmYmU0ZTZlODVmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'christine_strak',
                'serial_number':
                'UBNTe4e6e85f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e8:5f',
                'temperature':
                21.0,
                'uptime':
                '4044348'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '137006998777',
                    'links': [{
                        'in_octets': '137006998777',
                        'out_octets': '33940226416',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNWludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '33940226416',
                    'poller_hash':
                    'YjRmYmU0ZTZlODlicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2393197',
                            'fiber_length': 2896,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis1',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.326,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.11
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZlODlicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:fd:b2:16'],
                    'id': '1',
                    'in_octets': '33940226416',
                    'mac_address': 'b4:fb:e4:e7:e8:9b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '137006998777',
                    'poller_hash': 'YjRmYmU0ZTZlODliZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'lance_howard',
                'serial_number':
                'UBNTe4e6e89b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e8:9b',
                'temperature':
                24.0,
                'uptime':
                '4045022'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '474807784979',
                    'links': [{
                        'in_octets': '474807784979',
                        'out_octets': '12889658994',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '12889658994',
                    'poller_hash':
                    'NzBhNzQxMzJmNDRjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 5613,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.516,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.026
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzBhNzQxMzJmNDRjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['5c:62:8b:ab:6a:bc'],
                    'id': '1',
                    'in_octets': '12889658994',
                    'mac_address': '70:a7:41:33:f4:4c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '474807784979',
                    'poller_hash': 'NzBhNzQxMzJmNDRjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'douglas_owens',
                'serial_number':
                'UBNT4132f44c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f4:4c',
                'temperature':
                6.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1817054145489',
                    'links': [{
                        'in_octets': '1817054145489',
                        'out_octets': '53481170163',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '53481170163',
                    'poller_hash':
                    'NzBhNzQxMzJmNWQ4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751995',
                            'fiber_length': 3246,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.126,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.848
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzBhNzQxMzJmNWQ4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:45:b9:48'],
                    'id': '1',
                    'in_octets': '53481170163',
                    'mac_address': '70:a7:41:33:f5:d8',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1817054145489',
                    'poller_hash': 'NzBhNzQxMzJmNWQ4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'atc_agency',
                'serial_number':
                'UBNT4132f5d8',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '70:a7:41:32:f5:d8',
                'temperature':
                17.0,
                'uptime':
                '4752055'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '596894349104',
                    'links': [{
                        'in_octets': '596894349104',
                        'out_octets': '26739296554',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '26739296554',
                    'poller_hash':
                    'Nzg0NTU4OTVkMzgwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751985',
                            'fiber_length': 6528,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.064,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.698
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTVkMzgwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['5c:62:8b:ab:73:80'],
                    'id': '1',
                    'in_octets': '26739296554',
                    'mac_address': '78:45:58:96:d3:80',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '596894349104',
                    'poller_hash': 'Nzg0NTU4OTVkMzgwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'susan_olson',
                'serial_number':
                'UBNT5895d380',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:d3:80',
                'temperature':
                12.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '799506207056',
                    'links': [{
                        'in_octets': '799506207056',
                        'out_octets': '20106793170',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '20106793170',
                    'poller_hash':
                    'ZjQ5MmJmMDZlMGJlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1282814',
                            'fiber_length': 6060,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.374,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.024
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlMGJlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:c7:dc'],
                    'id': '1',
                    'in_octets': '20106793170',
                    'mac_address': 'f4:92:bf:07:e0:be',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '799506207056',
                    'poller_hash': 'ZjQ5MmJmMDZlMGJlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'judith_shafer',
                'serial_number':
                'UBNTbf06e0be',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e0:be',
                'temperature':
                13.0,
                'uptime':
                '1282867'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1649284105874',
                    'links': [{
                        'in_octets': '1649284105874',
                        'out_octets': '100218969278',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '100218969278',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNDJmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751985',
                            'fiber_length': 7061,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.12,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.58
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNDJmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:50:06:b0'],
                    'id': '1',
                    'in_octets': '100218969278',
                    'mac_address': 'f4:92:bf:07:e4:2f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1649284105874',
                    'poller_hash': 'ZjQ5MmJmMDZlNDJmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'sarah_radomsky',
                'serial_number':
                'UBNTbf06e42f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e4:2f',
                'temperature':
                10.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1217535082077',
                    'links': [{
                        'in_octets': '1217535082077',
                        'out_octets': '49206395961',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '49206395961',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNjNhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4044287',
                            'fiber_length': 5635,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.448,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.73
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNjNhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:c8:84'],
                    'id': '1',
                    'in_octets': '49206395961',
                    'mac_address': 'f4:92:bf:07:e6:3a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1217535082077',
                    'poller_hash': 'ZjQ5MmJmMDZlNjNhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'louann_skillings',
                'serial_number':
                'UBNTbf06e63a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e6:3a',
                'temperature':
                11.0,
                'uptime':
                '4044348'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '865593485595',
                    'links': [{
                        'in_octets': '865593485595',
                        'out_octets': '45484282143',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '45484282143',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNzI1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 5341,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.032,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.592
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNzI1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['10:0c:6b:e1:63:48'],
                    'id': '1',
                    'in_octets': '45484282143',
                    'mac_address': 'f4:92:bf:07:e7:25',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '865593485595',
                    'poller_hash': 'ZjQ5MmJmMDZlNzI1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'cory_wondra',
                'serial_number':
                'UBNTbf06e725',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e7:25',
                'temperature':
                12.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '148587210657',
                    'links': [{
                        'in_octets': '148587210657',
                        'out_octets': '22052831664',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '22052831664',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNzQ5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 5702,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -14.672,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.144
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNzQ5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:50:0f:54'],
                    'id': '1',
                    'in_octets': '22052831664',
                    'mac_address': 'f4:92:bf:07:e7:49',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '148587210657',
                    'poller_hash': 'ZjQ5MmJmMDZlNzQ5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'denise_nelson',
                'serial_number':
                'UBNTbf06e749',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e7:49',
                'temperature':
                14.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '445010687552',
                    'links': [{
                        'in_octets': '445010687552',
                        'out_octets': '35833393893',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '35833393893',
                    'poller_hash':
                    'ZjQ5MmJmMDZmNGQ5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1362655',
                            'fiber_length': 4638,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.152,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.88
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZmNGQ5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:38:a3:39'],
                    'id': '1',
                    'in_octets': '35833393893',
                    'mac_address': 'f4:92:bf:07:f4:d9',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '445010687552',
                    'poller_hash': 'ZjQ5MmJmMDZmNGQ5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'suzanne_starcevich',
                'serial_number':
                'UBNTbf06f4d9',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f4:d9',
                'temperature':
                18.0,
                'uptime':
                '1362713'
            }, {
                'admin_disabled':
                False,
                'cpu':
                6.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '72174486170',
                    'links': [{
                        'in_octets': '72174486170',
                        'out_octets': '6903138178',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '6903138178',
                    'poller_hash':
                    'ZjQ5MmJmMDZmNTBmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4751994',
                            'fiber_length': 4751,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.614,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.364
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZmNTBmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:4f:f5:c4'],
                    'id': '1',
                    'in_octets': '6903138178',
                    'mac_address': 'f4:92:bf:07:f5:0f',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '72174486170',
                    'poller_hash': 'ZjQ5MmJmMDZmNTBmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'diane_mork',
                'serial_number':
                'UBNTbf06f50f',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f5:0f',
                'temperature':
                10.0,
                'uptime':
                '4752056'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '308568394681',
                    'links': [{
                        'in_octets': '308568394681',
                        'out_octets': '26297243907',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '26297243907',
                    'poller_hash':
                    'YjRmYmU0ZTZkNzI4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '799058',
                            'fiber_length': 3746,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.968,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.528
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZkNzI4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['ac:15:a2:b2:16:08'],
                    'id': '1',
                    'in_octets': '26297243907',
                    'mac_address': 'b4:fb:e4:e7:d7:28',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '308568394681',
                    'poller_hash': 'YjRmYmU0ZTZkNzI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'james_brewster',
                'serial_number':
                'UBNTe4e6d728',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:d7:28',
                'temperature':
                22.0,
                'uptime':
                '799114'
            }, {
                'admin_disabled':
                True,
                'cpu':
                0.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '0',
                    'links': [{
                        'in_octets': '0',
                        'out_octets': '0',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '0',
                    'poller_hash':
                    'YjRmYmU0ZTZkZmY1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '799058',
                            'fiber_length': 3727,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.124,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.562
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZkZmY1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'id': '1',
                    'in_octets': '0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '0',
                    'poller_hash': 'YjRmYmU0ZTZkZmY1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                54.0,
                'model':
                'Loco',
                'name':
                'sarah15_ltd',
                'serial_number':
                'UBNTe4e6dff5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:df:f5',
                'temperature':
                23.0,
                'uptime':
                '799112'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '297984857264',
                    'links': [{
                        'in_octets': '297984857264',
                        'out_octets': '38940730145',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '38940730145',
                    'poller_hash':
                    'YjRmYmU0ZTZlMjg2cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1786550',
                            'fiber_length': 3120,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.832,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.766
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZlMjg2cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['b0:95:75:3d:59:a1'],
                    'id': '1',
                    'in_octets': '38940730145',
                    'mac_address': 'b4:fb:e4:e7:e2:86',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '297984857264',
                    'poller_hash': 'YjRmYmU0ZTZlMjg2ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'pam_engen',
                'serial_number':
                'UBNTe4e6e286',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e2:86',
                'temperature':
                20.0,
                'uptime':
                '1786606'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '192032241569',
                    'links': [{
                        'in_octets': '192032241569',
                        'out_octets': '37345066606',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '37345066606',
                    'poller_hash':
                    'YjRmYmU0ZTZlNzI4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '799058',
                            'fiber_length': 3735,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.634,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.828
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZlNzI4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:83:bc:b0'],
                    'id': '1',
                    'in_octets': '37345066606',
                    'mac_address': 'b4:fb:e4:e7:e7:28',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '192032241569',
                    'poller_hash': 'YjRmYmU0ZTZlNzI4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'sarah15_showroom',
                'serial_number':
                'UBNTe4e6e728',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e7:28',
                'temperature':
                23.0,
                'uptime':
                '799114'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '30194536974',
                    'links': [{
                        'in_octets': '30194536974',
                        'out_octets': '5543285944',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '5543285944',
                    'poller_hash':
                    'YjRmYmU0ZTZlOGZicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '746687',
                            'fiber_length': 2933,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.12,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.78
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'YjRmYmU0ZTZlOGZicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:75:ce:21'],
                    'id': '1',
                    'in_octets': '5543285944',
                    'mac_address': 'b4:fb:e4:e7:e8:fb',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '30194536974',
                    'poller_hash': 'YjRmYmU0ZTZlOGZiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'elaine_thomas',
                'serial_number':
                'UBNTe4e6e8fb',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'b4:fb:e4:e6:e8:fb',
                'temperature':
                25.0,
                'uptime':
                '746745'
            }, {
                'admin_disabled':
                False,
                'cpu':
                9.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '432410612283',
                    'links': [{
                        'in_octets': '432410612283',
                        'out_octets': '24900785839',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uNmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '24900785839',
                    'poller_hash':
                    'ZDAyMWY5MWFjZDM4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2237305',
                            'fiber_length': 5324,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis2',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.75,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.692
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZDAyMWY5MWFjZDM4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['48:22:54:38:a2:79'],
                    'id': '1',
                    'in_octets': '24900785839',
                    'mac_address': 'd0:21:f9:1b:cd:38',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '432410612283',
                    'poller_hash': 'ZDAyMWY5MWFjZDM4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'lisa_olson',
                'serial_number':
                'UBNTf91acd38',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'd0:21:f9:1a:cd:38',
                'temperature':
                21.0,
                'uptime':
                '2237365'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '84043068539',
                    'links': [{
                        'in_octets': '84043068539',
                        'out_octets': '18909417133',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '18909417133',
                    'poller_hash':
                    'Nzg0NTU4OTVjMzA4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3532081',
                            'fiber_length': 9329,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.1,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.044
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTVjMzA4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['40:ed:00:42:8f:ea'],
                    'id': '1',
                    'in_octets': '18909417133',
                    'mac_address': '78:45:58:96:c3:08',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '84043068539',
                    'poller_hash': 'Nzg0NTU4OTVjMzA4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'larry_hedlund',
                'serial_number':
                'UBNT5895c308',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:c3:08',
                'temperature':
                10.0,
                'uptime':
                '4489301'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '19877537988',
                    'links': [{
                        'in_octets': '19877537988',
                        'out_octets': '2483381931',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '2483381931',
                    'poller_hash':
                    'Nzg0NTU4OTVkNDc4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '1116712',
                            'fiber_length': 7992,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.43,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.582
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'Nzg0NTU4OTVkNDc4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['5c:62:8b:ab:6b:19'],
                    'id': '1',
                    'in_octets': '2483381931',
                    'mac_address': '78:45:58:96:d4:78',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '19877537988',
                    'poller_hash': 'Nzg0NTU4OTVkNDc4ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'lucy_swanson',
                'serial_number':
                'UBNT5895d478',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '78:45:58:95:d4:78',
                'temperature':
                8.0,
                'uptime':
                '1116766'
            }, {
                'admin_disabled':
                False,
                'cpu':
                8.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '384995526756',
                    'links': [{
                        'in_octets': '384995526756',
                        'out_octets': '17123883502',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '17123883502',
                    'poller_hash':
                    'NjhkNzlhMDZmZTkzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2476078',
                            'fiber_length': 7849,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.706,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.68
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NjhkNzlhMDZmZTkzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['98:da:c4:8e:86:ab'],
                    'id': '1',
                    'in_octets': '17123883502',
                    'mac_address': '68:d7:9a:07:fe:93',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '384995526756',
                    'poller_hash': 'NjhkNzlhMDZmZTkzZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'nick_lundquist',
                'serial_number':
                'UBNT9a06fe93',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                '68:d7:9a:06:fe:93',
                'temperature':
                12.0,
                'uptime':
                '2476139'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '891036245817',
                    'links': [{
                        'in_octets': '891036245817',
                        'out_octets': '25176369735',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '25176369735',
                    'poller_hash':
                    'ZjQ5MmJmMDZlNTk5cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3532080',
                            'fiber_length': 19937,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.538
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZlNTk5cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['10:da:43:a9:55:e3'],
                    'id': '1',
                    'in_octets': '25176369735',
                    'mac_address': 'f4:92:bf:07:e5:99',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '891036245817',
                    'poller_hash': 'ZjQ5MmJmMDZlNTk5ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'Loco',
                'name':
                'bruce_lundquist',
                'serial_number':
                'UBNTbf06e599',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:e5:99',
                'temperature':
                25.0,
                'uptime':
                '4384770'
            }, {
                'admin_disabled':
                False,
                'cpu':
                7.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '394319264326',
                    'links': [{
                        'in_octets': '394319264326',
                        'out_octets': '32624369913',
                        'poller_hash': 'YjRmYmU0NTAzYjhhcG9uOGludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '32624369913',
                    'poller_hash':
                    'ZjQ5MmJmMDZmMjk4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3532080',
                            'fiber_length': 8195,
                            'poller_hash': 'YjRmYmU0NTAzYjhhVUYtR1AtQis4',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.222,
                            'tx_link_rate': '1244160000',
                            'tx_power': 0.938
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'ZjQ5MmJmMDZmMjk4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:fd:b8:50'],
                    'id': '1',
                    'in_octets': '32624369913',
                    'mac_address': 'f4:92:bf:07:f2:98',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '394319264326',
                    'poller_hash': 'ZjQ5MmJmMDZmMjk4ZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                53.0,
                'model':
                'Loco',
                'name':
                'adam_hedlund',
                'serial_number':
                'UBNTbf06f298',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.2.1',
                'system_mac_address':
                'f4:92:bf:06:f2:98',
                'temperature':
                6.0,
                'uptime':
                '6395712'
            }]
        }
        id_field = 'mac_address' if not obj.stations else (
            'mac_address' if hasattr(obj.stations[0], 'mac_address')
            and getattr(obj.stations[0], 'mac_address') else
            ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) +
            [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]
        }
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (
                cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {
            x: getattr(obj, x, None)
            for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)
        }
        cur_sta_stats = {
            getattr(sta, id_field): {
                x: getattr(sta, x, None)
                for (x, data_type) in
                sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) +
                [(id_field, 'str'), ('ip_address', 'str'), ('name',
                                                            'str'), ('dev_macs', 'str')]
            }
            for sta in sorted(obj.stations)
        }
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ubnt_edgemax_edgemax_UFiber_OLT_v4_3_1_01(self):
        obj = self.run_data("ubnt-edgemax.edgemax.UFiber OLT.v4.3.1.01")
        exp_info = {
            'model': 'UFiber OLT',
            'rf_tx_power': None,
            'sta_count': 143,
            'sw_version': '4.3.1',
            'vendor': 'Ubiquiti'
        }
        exp_stats = {'cpu': 32}
        exp_sta_stats = {
            '18:e8:29:0b:3f:88': {
                'dev_macs': ['34:60:f9:c1:b9:7d'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:3f:88',
                'name': '38188HuntsEndPl'
            },
            '18:e8:29:0b:3f:e4': {
                'dev_macs': ['04:42:1a:18:75:70'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:3f:e4',
                'name': '19287LincolnRoad-Shed'
            },
            '18:e8:29:0b:3f:f0': {
                'dev_macs': ['48:22:54:38:18:95'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:3f:f0',
                'name': '19443JodhpurDr'
            },
            '18:e8:29:0b:40:b0': {
                'dev_macs': [
                    '00:18:61:51:af:cd', '14:20:5e:05:d6:7a', '18:b4:30:0c:45:20',
                    '32:55:13:a6:c9:5a', '38:b8:00:62:b8:49', '60:22:32:42:e8:f0',
                    '64:16:66:d5:76:95', '84:ea:ed:6a:fc:fe', '9a:47:44:34:1e:83',
                    'bc:d7:d4:6a:e0:f0', 'c8:ff:77:4a:fb:76', 'cc:08:fa:60:33:84',
                    'e0:63:da:14:80:ee'
                ],
                'ip_address':
                None,
                'mac_address':
                '18:e8:29:0b:40:b0',
                'name':
                '19965LincolnRoad'
            },
            '18:e8:29:0b:41:20': {
                'dev_macs': [
                    '0a:cf:8d:4b:cd:a4', '18:16:c9:d9:44:bc', '1c:53:f9:ac:14:0d',
                    '1c:53:f9:b5:8e:56', '20:1f:3b:7f:9e:08', '20:1f:3b:9a:8f:27',
                    '34:98:b5:a3:c0:9d', '34:98:b5:a4:43:33', '34:98:b5:a4:44:77',
                    '36:98:b5:a3:c0:a0', '40:bd:32:6e:84:db', '64:cc:22:bf:07:61',
                    '64:cc:22:bf:08:11', '68:3e:26:ec:86:6e', '68:fc:ca:b4:8e:d4',
                    '9c:b6:d0:d6:16:d7', 'a4:bb:6d:5d:9f:a5', 'a8:a2:37:89:0c:19',
                    'a8:a2:37:89:0c:2d', 'aa:14:fa:68:96:0a', 'd8:d0:90:1c:c0:23',
                    'ee:61:84:68:12:3e'
                ],
                'ip_address':
                None,
                'mac_address':
                '18:e8:29:0b:41:20',
                'name':
                '20013LincolnRoad'
            },
            '18:e8:29:0b:41:94': {
                'dev_macs': [
                    '40:16:3b:3d:4b:50', '48:a9:d2:72:42:77', '9c:5a:44:c6:a3:43',
                    '9c:5a:44:cb:37:23', 'd8:0d:17:f5:f5:50'
                ],
                'ip_address':
                None,
                'mac_address':
                '18:e8:29:0b:41:94',
                'name':
                '19287LincolnRoad-House'
            },
            '18:e8:29:0b:41:e8': {
                'dev_macs': ['54:af:97:17:c2:e1'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:41:e8',
                'name': '38195HuntsEndPl'
            },
            '18:e8:29:0b:4b:64': {
                'dev_macs': ['0c:51:01:e2:25:46'],
                'ip_address': None,
                'mac_address': '18:e8:29:0b:4b:64',
                'name': '19783GreggsvilleRoad'
            },
            '74:83:c2:68:e0:2b': {
                'dev_macs': ['54:af:97:f8:b7:35'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:2b',
                'name': '19369LancerCircle'
            },
            '74:83:c2:68:e0:3f': {
                'dev_macs': ['54:af:97:12:12:8b'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:3f',
                'name': '38153HuntsEndPl'
            },
            '74:83:c2:68:e0:42': {
                'dev_macs': ['6c:cd:d6:27:b4:fa'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:42',
                'name': '38202HuntsEndPl'
            },
            '74:83:c2:68:e0:43': {
                'dev_macs': ['34:98:b5:a3:e7:e5'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:43',
                'name': '19144ShelburneGlebeRd'
            },
            '74:83:c2:68:e0:50': {
                'dev_macs': ['34:60:f9:5d:75:d9'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:50',
                'name': '19464JodhpurDr'
            },
            '74:83:c2:68:e0:59': {
                'dev_macs': ['54:af:97:79:cd:05'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:59',
                'name': '19749LincolnRoad-House'
            },
            '74:83:c2:68:e0:78': {
                'dev_macs': ['54:af:97:4f:e0:f0'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:78',
                'name': '19749LincolnRoad-Garage'
            },
            '74:83:c2:68:e0:79': {
                'dev_macs': ['30:34:22:21:73:21'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:79',
                'name': '19351LincolnRoad'
            },
            '74:83:c2:68:e0:7b': {
                'dev_macs': ['2c:30:33:60:5c:57'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:7b',
                'name': '19163LincolnRd'
            },
            '74:83:c2:68:e0:87': {
                'dev_macs': ['cc:40:d0:4d:3b:d0'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:87',
                'name': '38174NorthForkRd'
            },
            '74:83:c2:68:e0:93': {
                'dev_macs': ['78:d2:94:c3:e5:89'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:93',
                'name': '19110ShelburneGlebeRd'
            },
            '74:83:c2:68:e0:a1': {
                'dev_macs': ['68:d7:9a:5c:fa:4c'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:a1',
                'name': '19320LancerCircle'
            },
            '74:83:c2:68:e0:b3': {
                'dev_macs': ['14:59:c0:42:7d:3b'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:b3',
                'name': '19231LancerCircle'
            },
            '74:83:c2:68:e0:bf': {
                'dev_macs': ['30:34:22:09:59:a0'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:bf',
                'name': '19203LincolnRoad'
            },
            '74:83:c2:68:e0:dc': {
                'dev_macs': ['9c:c9:eb:f5:90:63'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:dc',
                'name': '19008LincolnRd'
            },
            '74:83:c2:68:e0:df': {
                'dev_macs': ['b4:b0:24:42:6e:5d'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:df',
                'name': '19243LancerCircle'
            },
            '74:83:c2:68:e0:e3': {
                'dev_macs': ['7c:d9:5c:99:1f:fc'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:e3',
                'name': '37967ForestMillsRd'
            },
            '74:83:c2:68:e0:eb': {
                'dev_macs': ['c8:9e:43:c2:57:b6'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:eb',
                'name': '20152GreggsvilleRd'
            },
            '74:83:c2:68:e0:ec': {
                'dev_macs': ['e8:48:b8:20:a9:5f'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:ec',
                'name': '38057ForestMillsRoad-Cottage'
            },
            '74:83:c2:68:e0:fd': {
                'dev_macs': ['b0:39:56:f5:46:06'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e0:fd',
                'name': '20200ShelburneGlebeRd'
            },
            '74:83:c2:68:e1:00': {
                'dev_macs': ['a4:97:33:b0:73:d0'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:00',
                'name': '19110LancerCircle'
            },
            '74:83:c2:68:e1:10': {
                'dev_macs': ['6c:cd:d6:03:8c:1f', 'a8:51:ab:95:30:9f'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:10',
                'name': '19167LancerCircle'
            },
            '74:83:c2:68:e1:4a': {
                'dev_macs': ['04:42:1a:9a:fd:a0'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:4a',
                'name': '19061LancerCircle'
            },
            '74:83:c2:68:e1:71': {
                'dev_macs': ['54:af:97:4f:fa:30'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:71',
                'name': '19964PleasantMeadowLn'
            },
            '74:83:c2:68:e1:73': {
                'dev_macs': ['3c:37:86:69:e1:ad'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:73',
                'name': '38011NorthForkRd'
            },
            '74:83:c2:68:e1:77': {
                'dev_macs': ['e0:b2:60:30:36:f9'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:77',
                'name': '19277OaklandGreenRd'
            },
            '74:83:c2:68:e1:a1': {
                'dev_macs': ['80:da:13:ac:5b:c1'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:a1',
                'name': '19815GreggsvilleRoad'
            },
            '74:83:c2:68:e1:ad': {
                'dev_macs': ['78:d2:94:12:bd:4d', 'cc:f4:11:80:c8:97'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:ad',
                'name': '37626NorthForkRd'
            },
            '74:83:c2:68:e1:bb': {
                'dev_macs': ['c8:9e:43:9c:0d:5a'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:bb',
                'name': '19396LincolnRd'
            },
            '74:83:c2:68:e1:ca': {
                'dev_macs': ['40:ed:00:43:69:94'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:ca',
                'name': '38313NorthForkRd'
            },
            '74:83:c2:68:e1:cb': {
                'dev_macs': ['38:94:ed:43:ac:3d'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:cb',
                'name': '19432JodhpurDr'
            },
            '74:83:c2:68:e1:cd': {
                'dev_macs': ['54:af:97:4f:fe:24'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:cd',
                'name': '19299OaklandGreenRd'
            },
            '74:83:c2:68:e1:ce': {
                'dev_macs': ['74:ac:b9:4e:87:ef'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:ce',
                'name': '19249LincolnRoad'
            },
            '74:83:c2:68:e1:d4': {
                'dev_macs': ['54:af:97:0f:d8:f5'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:d4',
                'name': '37972NorthForkRd'
            },
            '74:83:c2:68:e1:d5': {
                'dev_macs': ['e8:da:00:15:b6:5b'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:d5',
                'name': '38307NorthForkRd'
            },
            '74:83:c2:68:e1:f4': {
                'dev_macs': ['38:94:ed:69:f0:aa'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:f4',
                'name': '38110NorthForkRd'
            },
            '74:83:c2:68:e1:fc': {
                'dev_macs': ['24:4b:fe:40:71:31'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:fc',
                'name': '20248GrerggsvilleRoad'
            },
            '74:83:c2:68:e1:ff': {
                'dev_macs': ['54:af:97:4f:d4:34'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e1:ff',
                'name': '38158NorthForkRd'
            },
            '74:83:c2:68:e2:02': {
                'dev_macs': ['78:d2:94:ab:9a:cd'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:02',
                'name': '19430LancerCir'
            },
            '74:83:c2:68:e2:03': {
                'dev_macs':
                ['90:9a:4a:d0:74:1a', '9c:a2:f4:4e:5a:4d', 'c0:74:ad:74:89:cb'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:03',
                'name': '19080LancerCircle'
            },
            '74:83:c2:68:e2:1b': {
                'dev_macs': ['e8:da:00:15:d7:f7'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:1b',
                'name': '20017ShelburneGlebeRd'
            },
            '74:83:c2:68:e2:98': {
                'dev_macs': ['c8:9e:43:ab:11:cd'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:98',
                'name': '20011PleasantMeadowsLane'
            },
            '74:83:c2:68:e2:a1': {
                'dev_macs': ['c8:9e:43:b6:00:bf'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:a1',
                'name': '19070LincolnRoad'
            },
            '74:83:c2:68:e2:a3': {
                'dev_macs': ['c8:9e:43:67:5f:fb'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:a3',
                'name': '19675LincolnRoad'
            },
            '74:83:c2:68:e2:b7': {
                'dev_macs': ['38:94:ed:b3:38:7a'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:b7',
                'name': '19221LincolnRd'
            },
            '74:83:c2:68:e2:b8': {
                'dev_macs': ['54:af:97:4f:e2:ec'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:b8',
                'name': '38134HuntsEndPl'
            },
            '74:83:c2:68:e2:bd': {
                'dev_macs': ['14:91:82:71:43:86'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:bd',
                'name': '19209LincolnRoad'
            },
            '74:83:c2:68:e2:c5': {
                'dev_macs': ['74:ac:b9:d2:b2:81'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:c5',
                'name': '19391LancerCircle'
            },
            '74:83:c2:68:e2:e5': {
                'dev_macs': ['44:a5:6e:63:3e:48'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e2:e5',
                'name': '37967ForestMillsRd'
            },
            '74:83:c2:68:e3:11': {
                'dev_macs': [
                    'b4:b7:42:a0:04:ca', 'e0:63:da:25:0c:e8', 'e0:63:da:25:0c:e9',
                    'e0:63:da:73:04:04'
                ],
                'ip_address':
                None,
                'mac_address':
                '74:83:c2:68:e3:11',
                'name':
                '19249LincolnRoad-Cottage'
            },
            '74:83:c2:68:e3:21': {
                'dev_macs': ['24:05:88:40:ef:31'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:21',
                'name': '19382LancerCircle'
            },
            '74:83:c2:68:e3:25': {
                'dev_macs': ['d8:47:32:98:46:73'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:25',
                'name': '19060LincolnRoad'
            },
            '74:83:c2:68:e3:2e': {
                'dev_macs': ['74:ac:b9:58:9d:ce'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:2e',
                'name': '19226LancerCircle'
            },
            '74:83:c2:68:e3:32': {
                'dev_macs': ['1c:61:b4:b1:23:c5'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:32',
                'name': '38298HuntsEndPl'
            },
            '74:83:c2:68:e3:35': {
                'dev_macs': ['18:90:88:a2:12:e1'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:35',
                'name': '19625LincolnRoad'
            },
            '74:83:c2:68:e3:3a': {
                'dev_macs': ['c8:9e:43:a5:85:ee'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:3a',
                'name': '19215LincolnRoad'
            },
            '74:83:c2:68:e3:3b': {
                'dev_macs': ['3c:37:86:14:45:65'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:3b',
                'name': '19496JodhpurDr'
            },
            '74:83:c2:68:e3:49': {
                'dev_macs': ['e8:9f:80:1c:82:49'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:49',
                'name': '38166HuntsEndPl'
            },
            '74:83:c2:68:e3:4c': {
                'dev_macs': ['28:87:ba:76:91:c1'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:4c',
                'name': '19783GreggsvilleRoad-Cottage'
            },
            '74:83:c2:68:e3:50': {
                'dev_macs': ['6c:cd:d6:e1:de:09'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:50',
                'name': '19058LancerCircle'
            },
            '74:83:c2:68:e3:54': {
                'dev_macs': ['3c:37:86:fb:37:1b'],
                'ip_address': None,
                'mac_address': '74:83:c2:68:e3:54',
                'name': '19105LancerCircle'
            },
            '74:83:c2:f0:20:00': {
                'dev_macs': ['24:f5:a2:0a:88:9a'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:20:00',
                'name': '19002LincolnRd'
            },
            '74:83:c2:f0:27:58': {
                'dev_macs': ['08:36:c9:7c:52:ab'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:27:58',
                'name': '38236NorthForkRd-House'
            },
            '74:83:c2:f0:27:b4': {
                'dev_macs': ['00:ab:48:c5:87:e1', '74:83:c2:f5:fb:74'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:27:b4',
                'name': '20124CreekspringCt'
            },
            '74:83:c2:f0:29:0c': {
                'dev_macs': ['34:98:b5:73:34:ea'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:29:0c',
                'name': '38236NorthForkRd-Garage'
            },
            '74:83:c2:f0:29:b8': {
                'dev_macs': ['90:9a:4a:cd:e0:b9'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:29:b8',
                'name': '19281SwanCt'
            },
            '74:83:c2:f0:29:c8': {
                'dev_macs': ['d4:6a:91:bd:8c:0d'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:29:c8',
                'name': '38253NorthForkRd'
            },
            '74:83:c2:f0:29:cc': {
                'dev_macs': ['c8:9e:43:dc:8b:ce'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:29:cc',
                'name': '19108NicholsonFarmLn'
            },
            '74:83:c2:f0:2a:38': {
                'dev_macs': ['10:0c:6b:f7:57:de'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:2a:38',
                'name': '19821GreggsvilleRoad'
            },
            '74:83:c2:f0:30:f4': {
                'dev_macs': ['cc:40:d0:8b:14:bd'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:30:f4',
                'name': '19985ShelburneGlebeRd'
            },
            '74:83:c2:f0:31:00': {
                'dev_macs': ['94:18:65:6a:7f:ea'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:31:00',
                'name': '36675WoodDuckCt'
            },
            '74:83:c2:f0:31:34': {
                'dev_macs': ['78:45:58:3c:52:27'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:31:34',
                'name': '19165SwanCt'
            },
            '74:83:c2:f0:31:40': {
                'dev_macs': ['e8:da:00:15:f8:d9'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:31:40',
                'name': '38213NorthForkRd'
            },
            '74:83:c2:f0:31:50': {
                'dev_macs': ['8c:3b:ad:41:48:bc'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:31:50',
                'name': '19130PintailCt'
            },
            '74:83:c2:f0:3d:e0': {
                'dev_macs': ['28:80:88:d6:ea:5f'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:3d:e0',
                'name': '36448ShoemakerSchoolRd'
            },
            '74:83:c2:f0:3e:68': {
                'dev_macs': ['d0:17:c2:58:52:20'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:3e:68',
                'name': '19140PintailCt'
            },
            '74:83:c2:f0:3f:b4': {
                'dev_macs': ['28:80:88:43:ee:f4'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:3f:b4',
                'name': '38276HuntsEndPl'
            },
            '74:83:c2:f0:3f:d0': {
                'dev_macs': ['08:b4:b1:89:ba:86'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:3f:d0',
                'name': '19204LancerCircle'
            },
            '74:83:c2:f0:41:0c': {
                'dev_macs': ['78:8c:b5:3c:5d:41'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:41:0c',
                'name': '19275SwanCt'
            },
            '74:83:c2:f0:44:cc': {
                'dev_macs': ['38:94:ed:63:b2:20'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:44:cc',
                'name': '19827GreggsvilleRoad'
            },
            '74:83:c2:f0:46:08': {
                'dev_macs': ['68:d7:9a:d0:77:c5'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:46:08',
                'name': '19981GreggsvilleRoad'
            },
            '74:83:c2:f0:46:ac': {
                'dev_macs': ['54:af:97:50:00:e0'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:46:ac',
                'name': '19564GreggsvilleRd'
            },
            '74:83:c2:f0:50:68': {
                'dev_macs': ['2c:b0:5d:33:25:e1'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:50:68',
                'name': '19185PintailCt'
            },
            '74:83:c2:f0:54:d0': {
                'dev_macs': ['2c:b0:5d:49:d6:c1'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:54:d0',
                'name': '19060LincolnRoad-MilkHouse'
            },
            '74:83:c2:f0:54:e8': {
                'dev_macs': ['58:ef:68:44:55:b4'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:54:e8',
                'name': '19669LincolnRoad'
            },
            '74:83:c2:f0:55:00': {
                'dev_macs': ['f8:1a:2b:22:af:94'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:55:00',
                'name': '19600LincolnRoad'
            },
            '74:83:c2:f0:68:e4': {
                'dev_macs': ['34:98:b5:d4:80:7f'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:68:e4',
                'name': '37330WileyChaseLn'
            },
            '74:83:c2:f0:69:0c': {
                'dev_macs': ['00:14:f6:90:45:d1'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:69:0c',
                'name': '19179LancerCircle'
            },
            '74:83:c2:f0:69:68': {
                'dev_macs': ['08:36:c9:2d:84:f1', 'c0:74:ad:74:89:8e'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:69:68',
                'name': '19199LancerCircle'
            },
            '74:83:c2:f0:6d:48': {
                'dev_macs': ['78:8c:b5:11:fb:6f'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:6d:48',
                'name': '38085ForestMillsRd'
            },
            '74:83:c2:f0:6d:64': {
                'dev_macs': ['cc:f4:11:31:74:66'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:6d:64',
                'name': '38104NorthForkRd'
            },
            '74:83:c2:f0:6d:84': {
                'dev_macs': ['44:a5:6e:4d:c6:66'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:6d:84',
                'name': '38057ForestMillsRd'
            },
            '74:83:c2:f0:6d:8c': {
                'dev_macs': ['a0:04:60:cb:75:ec'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:6d:8c',
                'name': '19155LancerCircle'
            },
            '74:83:c2:f0:70:58': {
                'dev_macs': ['78:d2:94:3f:e6:4c'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:70:58',
                'name': '38359NorthForkRd'
            },
            '74:83:c2:f0:70:74': {
                'dev_macs': ['d0:21:f9:66:56:bf'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:70:74',
                'name': '19582GreggsvilleRoad'
            },
            '74:83:c2:f0:70:80': {
                'dev_macs': ['7c:d9:5c:9f:8d:6e'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:70:80',
                'name': '19348LancerCircle'
            },
            '74:83:c2:f0:70:98': {
                'dev_macs': ['c8:9e:43:5c:89:93'],
                'ip_address': None,
                'mac_address': '74:83:c2:f0:70:98',
                'name': '19987GreggsvilleRoad'
            },
            '74:ac:b9:99:e8:e2': {
                'dev_macs': [
                    '08:12:a5:7f:11:d9', 'c4:de:e2:d5:3d:04', '74:d8:3e:b7:d1:e9',
                    'dc:e5:5b:a3:ea:06', 'c2:1f:92:42:c4:fa', '0c:ee:99:3f:91:95',
                    '40:a2:db:85:74:8b', '30:89:4a:b2:60:65', 'ac:0b:fb:63:1f:6c',
                    '44:61:32:04:62:1d', '08:e9:f6:63:41:42', '46:52:68:8b:ab:d5',
                    '10:27:f5:a8:1c:e5', 'b8:13:32:e0:a3:4e', '24:41:8c:65:78:68',
                    'f0:de:f1:08:fb:85', 'c0:33:5e:63:74:11', 'ac:0b:fb:63:1e:90',
                    '8c:85:80:9e:9b:3d', '08:e9:f6:a7:1c:1e', '44:61:32:34:37:a7',
                    'd8:28:c9:8f:95:e6', '84:c7:ea:35:9f:c9', '44:61:32:82:33:76',
                    '80:f5:b5:8b:2e:b1', 'a0:ce:c8:fa:f1:48', 'dc:a6:32:0a:b8:1f',
                    '68:ec:8a:05:b5:57', '8c:85:80:bf:d2:0d', '66:9e:36:ba:4a:d5',
                    '14:f5:f9:fa:99:95', 'd8:28:c9:a3:96:e2', '1c:c1:de:6e:ea:75'
                ],
                'ip_address':
                None,
                'mac_address':
                '74:ac:b9:99:e8:e2',
                'name':
                'UBNTb999e8e2'
            },
            'd0:21:f9:9a:52:74': {
                'dev_macs': ['28:80:88:2a:29:8b'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:52:74',
                'name': '19976ShelburneGlebeRd'
            },
            'd0:21:f9:9a:63:98': {
                'dev_macs': ['40:ed:00:ad:d0:29'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:63:98',
                'name': '19151PintailCt'
            },
            'd0:21:f9:9a:64:90': {
                'dev_macs': ['44:a5:6e:55:57:56'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:64:90',
                'name': '38211NorthForkRd'
            },
            'd0:21:f9:9a:65:18': {
                'dev_macs': ['10:27:f5:16:c3:0a'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:18',
                'name': '19164PintailCt'
            },
            'd0:21:f9:9a:65:48': {
                'dev_macs': ['f0:9f:c2:ac:7c:b7'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:48',
                'name': '19116NicholsonFarmLn'
            },
            'd0:21:f9:9a:65:5c': {
                'dev_macs': ['e4:3a:65:17:44:56'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:5c',
                'name': '19260SwanCt'
            },
            'd0:21:f9:9a:65:70': {
                'dev_macs': ['54:af:97:02:c2:60'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:70',
                'name': '36460ShoemakerSchoolRd'
            },
            'd0:21:f9:9a:65:74': {
                'dev_macs': ['20:6d:31:31:65:a3'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:74',
                'name': '19184SwanCt'
            },
            'd0:21:f9:9a:65:84': {
                'dev_macs': ['34:98:b5:9a:84:7e'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:84',
                'name': '19040NicholsonFarmLn'
            },
            'd0:21:f9:9a:65:d0': {
                'dev_macs': ['70:81:05:aa:58:40'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:65:d0',
                'name': '36415ShoemakerSchoolRd'
            },
            'd0:21:f9:9a:66:68': {
                'dev_macs': ['3c:52:a1:19:13:59'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:66:68',
                'name': '19193PintailCt'
            },
            'd0:21:f9:9a:68:b0': {
                'dev_macs': ['10:0c:6b:56:3c:17'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:68:b0',
                'name': '36466ShoemakerSchoolRd'
            },
            'd0:21:f9:9a:69:d8': {
                'dev_macs': ['88:3d:24:7c:35:aa'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:69:d8',
                'name': '38244HuntsEndPl'
            },
            'd0:21:f9:9a:69:e4': {
                'dev_macs': ['38:94:ed:36:64:1e'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:69:e4',
                'name': '19192OaklandGreenRd'
            },
            'd0:21:f9:9a:6a:44': {
                'dev_macs': ['c0:c9:e3:8e:22:61'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:44',
                'name': '19328LincolnRd'
            },
            'd0:21:f9:9a:6a:64': {
                'dev_macs': ['e0:63:da:82:1d:fe'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:64',
                'name': '19150NicholsonFarmLn'
            },
            'd0:21:f9:9a:6a:88': {
                'dev_macs': [],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:88',
                'name': '38287NorthForkRd-Shed'
            },
            'd0:21:f9:9a:6a:90': {
                'dev_macs': ['b4:b0:24:87:39:f5'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:90',
                'name': '38287NorthForkRd-House'
            },
            'd0:21:f9:9a:6a:b4': {
                'dev_macs': ['54:af:97:4f:f3:bc'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:b4',
                'name': '19704GreggsvilleRoad'
            },
            'd0:21:f9:9a:6a:f0': {
                'dev_macs': ['54:af:97:4f:fe:74'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6a:f0',
                'name': '19906ShelburneGlebeRd'
            },
            'd0:21:f9:9a:6b:6c': {
                'dev_macs': ['54:af:97:4f:d4:f0'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6b:6c',
                'name': '19423LincolnRd'
            },
            'd0:21:f9:9a:6b:70': {
                'dev_macs': ['c8:7f:54:63:07:68'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6b:70',
                'name': '18783TelegraphSpringsRd'
            },
            'd0:21:f9:9a:6b:7c': {
                'dev_macs': ['cc:40:d0:50:ba:84'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6b:7c',
                'name': '19323OaklandGreenRd'
            },
            'd0:21:f9:9a:6b:ac': {
                'dev_macs': ['54:af:97:4f:c7:bc'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6b:ac',
                'name': '19970ShelburneGlebeRd'
            },
            'd0:21:f9:9a:6c:80': {
                'dev_macs': ['c8:7f:54:49:35:80'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6c:80',
                'name': '19514LincolnRd'
            },
            'd0:21:f9:9a:6c:e8': {
                'dev_macs': ['e8:9f:80:a5:e3:85'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6c:e8',
                'name': '19411ShelburneGlebeRoad'
            },
            'd0:21:f9:9a:6d:cc': {
                'dev_macs': ['c8:9e:43:bc:71:32'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6d:cc',
                'name': '38110GospondLn'
            },
            'd0:21:f9:9a:6e:24': {
                'dev_macs': ['e8:da:00:15:ab:c3'],
                'ip_address': None,
                'mac_address': 'd0:21:f9:9a:6e:24',
                'name': '19269OaklandsGreenRd'
            }
        }
        exp_ne_msg = {
            'data': {
                'cpu':
                32.0,
                'interfaces': [{
                    'admin_up': True,
                    'id': 'eth0',
                    'in_discards': '62497419',
                    'in_errors': '40957',
                    'in_nucast_pkts': '0',
                    'in_octets': '87605360817',
                    'in_ucast_pkts': '562563993',
                    'in_unknown_protos': '0',
                    'name': 'MGMT',
                    'oper_up': True,
                    'out_discards': '0',
                    'out_errors': '0',
                    'out_nucast_pkts': '0',
                    'out_octets': '210328930463',
                    'out_ucast_pkts': '362118407',
                    'poller_hash': 'YjRmYmU0NTA0YTQ3ZXRoMGludGY='
                }, {
                    'admin_up': True,
                    'id': 'pon1',
                    'name': 'pon1',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMWludGY='
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon2',
                    'in_errors':
                    '0',
                    'in_octets':
                    '18861105900786',
                    'in_ucast_pkts':
                    '53057523128',
                    'links': [{
                        'in_octets': '100324308108',
                        'out_octets': '820035615528',
                        'poller_hash': 'NzQ4M2MyNjhlMDJicGVlcmludGY='
                    }, {
                        'in_octets': '139565314813',
                        'out_octets': '2996558436399',
                        'poller_hash': 'NzQ4M2MyNjhlMDdicGVlcmludGY='
                    }, {
                        'in_octets': '132749350490',
                        'out_octets': '2646054293568',
                        'poller_hash': 'NzQ4M2MyNjhlMGExcGVlcmludGY='
                    }, {
                        'in_octets': '244424999842',
                        'out_octets': '2186440045060',
                        'poller_hash': 'NzQ4M2MyNjhlMGIzcGVlcmludGY='
                    }, {
                        'in_octets': '1245160880098',
                        'out_octets': '5121959123389',
                        'poller_hash': 'NzQ4M2MyNjhlMGJmcGVlcmludGY='
                    }, {
                        'in_octets': '119670939285',
                        'out_octets': '1494023287910',
                        'poller_hash': 'NzQ4M2MyNjhlMGRmcGVlcmludGY='
                    }, {
                        'in_octets': '56555672526',
                        'out_octets': '286769245927',
                        'poller_hash': 'NzQ4M2MyNjhlMTAwcGVlcmludGY='
                    }, {
                        'in_octets': '220206239381',
                        'out_octets': '2521309511179',
                        'poller_hash': 'NzQ4M2MyNjhlMTEwcGVlcmludGY='
                    }, {
                        'in_octets': '243091001033',
                        'out_octets': '4340435272320',
                        'poller_hash': 'NzQ4M2MyNjhlMTRhcGVlcmludGY='
                    }, {
                        'in_octets': '124236330502',
                        'out_octets': '1657403497298',
                        'poller_hash': 'NzQ4M2MyNjhlMjAycGVlcmludGY='
                    }, {
                        'in_octets': '170671770826',
                        'out_octets': '953751967501',
                        'poller_hash': 'NzQ4M2MyNjhlMjAzcGVlcmludGY='
                    }, {
                        'in_octets': '55062873390',
                        'out_octets': '1244149056605',
                        'poller_hash': 'NzQ4M2MyNjhlMmExcGVlcmludGY='
                    }, {
                        'in_octets': '142162920578',
                        'out_octets': '3137160207456',
                        'poller_hash': 'NzQ4M2MyNjhlMmI3cGVlcmludGY='
                    }, {
                        'in_octets': '156238978100',
                        'out_octets': '2043343390962',
                        'poller_hash': 'NzQ4M2MyNjhlMmJkcGVlcmludGY='
                    }, {
                        'in_octets': '42324369713',
                        'out_octets': '614804305940',
                        'poller_hash': 'NzQ4M2MyNjhlMmM1cGVlcmludGY='
                    }, {
                        'in_octets': '47317801454',
                        'out_octets': '1153229350068',
                        'poller_hash': 'NzQ4M2MyNjhlMzExcGVlcmludGY='
                    }, {
                        'in_octets': '23711662173',
                        'out_octets': '146270831483',
                        'poller_hash': 'NzQ4M2MyNjhlMzIxcGVlcmludGY='
                    }, {
                        'in_octets': '310042254680',
                        'out_octets': '6781398714211',
                        'poller_hash': 'NzQ4M2MyNjhlMzI1cGVlcmludGY='
                    }, {
                        'in_octets': '867392745646',
                        'out_octets': '13890809517327',
                        'poller_hash': 'NzQ4M2MyNjhlMzJlcGVlcmludGY='
                    }, {
                        'in_octets': '74580086771',
                        'out_octets': '3834216953694',
                        'poller_hash': 'NzQ4M2MyNjhlMzNhcGVlcmludGY='
                    }, {
                        'in_octets': '7789426259',
                        'out_octets': '84525278369',
                        'poller_hash': 'NzQ4M2MyNjhlMzUwcGVlcmludGY='
                    }, {
                        'in_octets': '48042507592',
                        'out_octets': '493138803253',
                        'poller_hash': 'NzQ4M2MyNjhlMzU0cGVlcmludGY='
                    }, {
                        'in_octets': '380791876350',
                        'out_octets': '3053223141963',
                        'poller_hash': 'NzQ4M2MyZjAzZmQwcGVlcmludGY='
                    }, {
                        'in_octets': '163682568555',
                        'out_octets': '2505658355768',
                        'poller_hash': 'NzQ4M2MyZjA0NmFjcGVlcmludGY='
                    }, {
                        'in_octets': '1377723100',
                        'out_octets': '27467042447',
                        'poller_hash': 'NzQ4M2MyZjA1NGQwcGVlcmludGY='
                    }, {
                        'in_octets': '266497356947',
                        'out_octets': '1514329790933',
                        'poller_hash': 'NzQ4M2MyZjA2OTBjcGVlcmludGY='
                    }, {
                        'in_octets': '53380893648',
                        'out_octets': '561107653217',
                        'poller_hash': 'NzQ4M2MyZjA2OTY4cGVlcmludGY='
                    }, {
                        'in_octets': '220258027678',
                        'out_octets': '3804670312341',
                        'poller_hash': 'NzQ4M2MyZjA2ZDhjcGVlcmludGY='
                    }, {
                        'in_octets': '1457082746013',
                        'out_octets': '2762125828926',
                        'poller_hash': 'NzQ4M2MyZjA3MDgwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon2',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '181850517829583',
                    'out_ucast_pkts':
                    '142261491214',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uMmludGY=',
                    'pons': [{
                        'id':
                        '2',
                        'links': [{
                            'connected_time': '2759250',
                            'fiber_length': 7280,
                            'poller_hash': 'NzQ4M2MyNjhlMDJicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681701',
                            'fiber_length': 7682,
                            'poller_hash': 'NzQ4M2MyNjhlMDdicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7145418',
                            'fiber_length': 8543,
                            'poller_hash': 'NzQ4M2MyNjhlMGExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681700',
                            'fiber_length': 8683,
                            'poller_hash': 'NzQ4M2MyNjhlMGIzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681700',
                            'fiber_length': 7281,
                            'poller_hash': 'NzQ4M2MyNjhlMGJmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681699',
                            'fiber_length': 8658,
                            'poller_hash': 'NzQ4M2MyNjhlMGRmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '836113',
                            'fiber_length': 8602,
                            'poller_hash': 'NzQ4M2MyNjhlMTAwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681700',
                            'fiber_length': 8405,
                            'poller_hash': 'NzQ4M2MyNjhlMTEwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7148288',
                            'fiber_length': 8000,
                            'poller_hash': 'NzQ4M2MyNjhlMTRhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6381381',
                            'fiber_length': 8129,
                            'poller_hash': 'NzQ4M2MyNjhlMjAycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7146208',
                            'fiber_length': 8411,
                            'poller_hash': 'NzQ4M2MyNjhlMjAzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4218443',
                            'fiber_length': 8084,
                            'poller_hash': 'NzQ4M2MyNjhlMmExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681700',
                            'fiber_length': 7481,
                            'poller_hash': 'NzQ4M2MyNjhlMmI3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681701',
                            'fiber_length': 7201,
                            'poller_hash': 'NzQ4M2MyNjhlMmJkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7146288',
                            'fiber_length': 7332,
                            'poller_hash': 'NzQ4M2MyNjhlMmM1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681700',
                            'fiber_length': 7574,
                            'poller_hash': 'NzQ4M2MyNjhlMzExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3588447',
                            'fiber_length': 8354,
                            'poller_hash': 'NzQ4M2MyNjhlMzIxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681701',
                            'fiber_length': 8032,
                            'poller_hash': 'NzQ4M2MyNjhlMzI1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8847462',
                            'fiber_length': 8516,
                            'poller_hash': 'NzQ4M2MyNjhlMzJlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7147428',
                            'fiber_length': 7166,
                            'poller_hash': 'NzQ4M2MyNjhlMzNhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833813',
                            'fiber_length': 8012,
                            'poller_hash': 'NzQ4M2MyNjhlMzUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '834653',
                            'fiber_length': 8447,
                            'poller_hash': 'NzQ4M2MyNjhlMzU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681699',
                            'fiber_length': 8653,
                            'poller_hash': 'NzQ4M2MyZjAzZmQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8847472',
                            'fiber_length': 7592,
                            'poller_hash': 'NzQ4M2MyZjA0NmFjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '691952',
                            'fiber_length': 7976,
                            'poller_hash': 'NzQ4M2MyZjA1NGQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681691',
                            'fiber_length': 8458,
                            'poller_hash': 'NzQ4M2MyZjA2OTBjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681741',
                            'fiber_length': 8467,
                            'poller_hash': 'NzQ4M2MyZjA2OTY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681691',
                            'fiber_length': 8285,
                            'poller_hash': 'NzQ4M2MyZjA2ZDhjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7147508',
                            'fiber_length': 8366,
                            'poller_hash': 'NzQ4M2MyZjA3MDgwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'name':
                        'pon2',
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon3',
                    'in_errors':
                    '0',
                    'in_octets':
                    '8305785854059',
                    'in_ucast_pkts':
                    '23559095865',
                    'links': [{
                        'in_octets': '135159672477',
                        'out_octets': '4449250945461',
                        'poller_hash': 'MThlODI5MGI0MGIwcGVlcmludGY='
                    }, {
                        'in_octets': '51362830391',
                        'out_octets': '211228825396',
                        'poller_hash': 'MThlODI5MGI0MTIwcGVlcmludGY='
                    }, {
                        'in_octets': '24321650043',
                        'out_octets': '409324676445',
                        'poller_hash': 'MThlODI5MGI0YjY0cGVlcmludGY='
                    }, {
                        'in_octets': '16611088826',
                        'out_octets': '350004142230',
                        'poller_hash': 'NzQ4M2MyNjhlMDg3cGVlcmludGY='
                    }, {
                        'in_octets': '2080765286',
                        'out_octets': '20620738694',
                        'poller_hash': 'NzQ4M2MyNjhlMGVicGVlcmludGY='
                    }, {
                        'in_octets': '4215472299',
                        'out_octets': '26293224067',
                        'poller_hash': 'NzQ4M2MyNjhlMGZkcGVlcmludGY='
                    }, {
                        'in_octets': '26904249977',
                        'out_octets': '95730254474',
                        'poller_hash': 'NzQ4M2MyNjhlMTcxcGVlcmludGY='
                    }, {
                        'in_octets': '34168718507',
                        'out_octets': '1706048813812',
                        'poller_hash': 'NzQ4M2MyNjhlMTczcGVlcmludGY='
                    }, {
                        'in_octets': '48278002484',
                        'out_octets': '757764942767',
                        'poller_hash': 'NzQ4M2MyNjhlMWExcGVlcmludGY='
                    }, {
                        'in_octets': '49335455458',
                        'out_octets': '695144533896',
                        'poller_hash': 'NzQ4M2MyNjhlMWFkcGVlcmludGY='
                    }, {
                        'in_octets': '53982139677',
                        'out_octets': '766285594570',
                        'poller_hash': 'NzQ4M2MyNjhlMWQ0cGVlcmludGY='
                    }, {
                        'in_octets': '523200308521',
                        'out_octets': '3860192578640',
                        'poller_hash': 'NzQ4M2MyNjhlMWZjcGVlcmludGY='
                    }, {
                        'in_octets': '40030214157',
                        'out_octets': '708880775335',
                        'poller_hash': 'NzQ4M2MyNjhlMWZmcGVlcmludGY='
                    }, {
                        'in_octets': '43335531017',
                        'out_octets': '177884781681',
                        'poller_hash': 'NzQ4M2MyNjhlMjk4cGVlcmludGY='
                    }, {
                        'in_octets': '7069294602',
                        'out_octets': '308509214080',
                        'poller_hash': 'NzQ4M2MyNjhlMzRjcGVlcmludGY='
                    }, {
                        'in_octets': '65073454145',
                        'out_octets': '104838036906',
                        'poller_hash': 'NzQ4M2MyZjAyN2I0cGVlcmludGY='
                    }, {
                        'in_octets': '13348139927',
                        'out_octets': '191949510392',
                        'poller_hash': 'NzQ4M2MyZjAyYTM4cGVlcmludGY='
                    }, {
                        'in_octets': '209604634055',
                        'out_octets': '4006844975783',
                        'poller_hash': 'NzQ4M2MyZjA0NGNjcGVlcmludGY='
                    }, {
                        'in_octets': '3981305981',
                        'out_octets': '33589122215',
                        'poller_hash': 'NzQ4M2MyZjA0NjA4cGVlcmludGY='
                    }, {
                        'in_octets': '232663434544',
                        'out_octets': '567256137139',
                        'poller_hash': 'NzQ4M2MyZjA2ZDY0cGVlcmludGY='
                    }, {
                        'in_octets': '76445609371',
                        'out_octets': '487864309994',
                        'poller_hash': 'NzQ4M2MyZjA3MDU4cGVlcmludGY='
                    }, {
                        'in_octets': '1190357340',
                        'out_octets': '9467383439',
                        'poller_hash': 'NzQ4M2MyZjA3MDk4cGVlcmludGY='
                    }, {
                        'in_octets': '135928020386',
                        'out_octets': '1473137823819',
                        'poller_hash': 'ZDAyMWY5OWE2YWI0cGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon3',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '79668035551272',
                    'out_ucast_pkts':
                    '60095606357',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uM2ludGY=',
                    'pons': [{
                        'id':
                        '3',
                        'links': [{
                            'connected_time': '17755237',
                            'fiber_length': 5292,
                            'poller_hash': 'MThlODI5MGI0MGIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '967264',
                            'fiber_length': 5238,
                            'poller_hash': 'MThlODI5MGI0MTIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8847472',
                            'fiber_length': 4002,
                            'poller_hash': 'MThlODI5MGI0YjY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2272,
                            'poller_hash': 'NzQ4M2MyNjhlMDg3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '698752',
                            'fiber_length': 3576,
                            'poller_hash': 'NzQ4M2MyNjhlMGVicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 1533,
                            'poller_hash': 'NzQ4M2MyNjhlMGZkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '835543',
                            'fiber_length': 4871,
                            'poller_hash': 'NzQ4M2MyNjhlMTcxcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278473',
                            'fiber_length': 1462,
                            'poller_hash': 'NzQ4M2MyNjhlMTczcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833203',
                            'fiber_length': 4097,
                            'poller_hash': 'NzQ4M2MyNjhlMWExcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833573',
                            'fiber_length': 4906,
                            'poller_hash': 'NzQ4M2MyNjhlMWFkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 1709,
                            'poller_hash': 'NzQ4M2MyNjhlMWQ0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '17755238',
                            'fiber_length': 3689,
                            'poller_hash': 'NzQ4M2MyNjhlMWZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2169,
                            'poller_hash': 'NzQ4M2MyNjhlMWZmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 4759,
                            'poller_hash': 'NzQ4M2MyNjhlMjk4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '700192',
                            'fiber_length': 3971,
                            'poller_hash': 'NzQ4M2MyNjhlMzRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '698752',
                            'fiber_length': 2645,
                            'poller_hash': 'NzQ4M2MyZjAyN2I0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1109896',
                            'fiber_length': 3984,
                            'poller_hash': 'NzQ4M2MyZjAyYTM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8847472',
                            'fiber_length': 3958,
                            'poller_hash': 'NzQ4M2MyZjA0NGNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '698751',
                            'fiber_length': 3508,
                            'poller_hash': 'NzQ4M2MyZjA0NjA4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3867460',
                            'fiber_length': 1748,
                            'poller_hash': 'NzQ4M2MyZjA2ZDY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2706,
                            'poller_hash': 'NzQ4M2MyZjA3MDU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '297008',
                            'fiber_length': 3586,
                            'poller_hash': 'NzQ4M2MyZjA3MDk4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8851422',
                            'fiber_length': 3712,
                            'poller_hash': 'ZDAyMWY5OWE2YWI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon3',
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQisz',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon4',
                    'in_errors':
                    '0',
                    'in_octets':
                    '20772955441921',
                    'in_ucast_pkts':
                    '42303149005',
                    'links': [{
                        'in_octets': '169608291315',
                        'out_octets': '570035358507',
                        'poller_hash': 'MThlODI5MGIzZjg4cGVlcmludGY='
                    }, {
                        'in_octets': '122683183',
                        'out_octets': '926611901',
                        'poller_hash': 'MThlODI5MGIzZmU0cGVlcmludGY='
                    }, {
                        'in_octets': '27422530030',
                        'out_octets': '1520521028270',
                        'poller_hash': 'MThlODI5MGI0MTk0cGVlcmludGY='
                    }, {
                        'in_octets': '149294437544',
                        'out_octets': '1391468269599',
                        'poller_hash': 'MThlODI5MGI0MWU4cGVlcmludGY='
                    }, {
                        'in_octets': '125174916315',
                        'out_octets': '2700372723631',
                        'poller_hash': 'NzQ4M2MyNjhlMDNmcGVlcmludGY='
                    }, {
                        'in_octets': '19935658325',
                        'out_octets': '180597411818',
                        'poller_hash': 'NzQ4M2MyNjhlMDQycGVlcmludGY='
                    }, {
                        'in_octets': '211824214312',
                        'out_octets': '455387477016',
                        'poller_hash': 'NzQ4M2MyNjhlMDU5cGVlcmludGY='
                    }, {
                        'in_octets': '13603438797',
                        'out_octets': '90549708770',
                        'poller_hash': 'NzQ4M2MyNjhlMDc4cGVlcmludGY='
                    }, {
                        'in_octets': '64076329101',
                        'out_octets': '1016967514777',
                        'poller_hash': 'NzQ4M2MyNjhlMDc5cGVlcmludGY='
                    }, {
                        'in_octets': '66876520295',
                        'out_octets': '567773054791',
                        'poller_hash': 'NzQ4M2MyNjhlMGRjcGVlcmludGY='
                    }, {
                        'in_octets': '1465726649',
                        'out_octets': '16842167640',
                        'poller_hash': 'NzQ4M2MyNjhlMGUzcGVlcmludGY='
                    }, {
                        'in_octets': '2021512725',
                        'out_octets': '97688576095',
                        'poller_hash': 'NzQ4M2MyNjhlMGVjcGVlcmludGY='
                    }, {
                        'in_octets': '115041542432',
                        'out_octets': '1369270068022',
                        'poller_hash': 'NzQ4M2MyNjhlMWNlcGVlcmludGY='
                    }, {
                        'in_octets': '67611332935',
                        'out_octets': '1389158163103',
                        'poller_hash': 'NzQ4M2MyNjhlMmEzcGVlcmludGY='
                    }, {
                        'in_octets': '117503972309',
                        'out_octets': '1778767070505',
                        'poller_hash': 'NzQ4M2MyNjhlMmI4cGVlcmludGY='
                    }, {
                        'in_octets': '185981422',
                        'out_octets': '1770806021',
                        'poller_hash': 'NzQ4M2MyNjhlMmU1cGVlcmludGY='
                    }, {
                        'in_octets': '32730253043',
                        'out_octets': '279902687032',
                        'poller_hash': 'NzQ4M2MyNjhlMzM1cGVlcmludGY='
                    }, {
                        'in_octets': '29668853091',
                        'out_octets': '208527310093',
                        'poller_hash': 'NzQ4M2MyNjhlMzQ5cGVlcmludGY='
                    }, {
                        'in_octets': '12359817482',
                        'out_octets': '171373739719',
                        'poller_hash': 'NzQ4M2MyZjAyMDAwcGVlcmludGY='
                    }, {
                        'in_octets': '5631465143',
                        'out_octets': '106886941423',
                        'poller_hash': 'NzQ4M2MyZjA1NGU4cGVlcmludGY='
                    }, {
                        'in_octets': '150564662047',
                        'out_octets': '271005948801',
                        'poller_hash': 'NzQ4M2MyZjA1NTAwcGVlcmludGY='
                    }, {
                        'in_octets': '6157201296',
                        'out_octets': '40596015326',
                        'poller_hash': 'NzQ4M2MyZjA2ZDQ4cGVlcmludGY='
                    }, {
                        'in_octets': '60262533659',
                        'out_octets': '77223524168',
                        'poller_hash': 'NzQ4M2MyZjA2ZDg0cGVlcmludGY='
                    }, {
                        'in_octets': '1187778998628',
                        'out_octets': '1496644684944',
                        'poller_hash': 'NzQ4M2MyZjA3MDc0cGVlcmludGY='
                    }, {
                        'in_octets': '105811370179',
                        'out_octets': '977788275924',
                        'poller_hash': 'ZDAyMWY5OWE2OWQ4cGVlcmludGY='
                    }, {
                        'in_octets': '17537411143',
                        'out_octets': '232152632390',
                        'poller_hash': 'ZDAyMWY5OWE2Y2U4cGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon4',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '120362762073301',
                    'out_ucast_pkts':
                    '98374756417',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uNGludGY=',
                    'pons': [{
                        'id':
                        '4',
                        'links': [{
                            'connected_time': '4997559',
                            'fiber_length': 11785,
                            'poller_hash': 'MThlODI5MGIzZjg4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '62516',
                            'fiber_length': 8103,
                            'poller_hash': 'MThlODI5MGIzZmU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4885089',
                            'fiber_length': 8315,
                            'poller_hash': 'MThlODI5MGI0MTk0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3080213',
                            'fiber_length': 11743,
                            'poller_hash': 'MThlODI5MGI0MWU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997149',
                            'fiber_length': 11893,
                            'poller_hash': 'NzQ4M2MyNjhlMDNmcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '835173',
                            'fiber_length': 11715,
                            'poller_hash': 'NzQ4M2MyNjhlMDQycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2853541',
                            'fiber_length': 8473,
                            'poller_hash': 'NzQ4M2MyNjhlMDU5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 8543,
                            'poller_hash': 'NzQ4M2MyNjhlMDc4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 8138,
                            'poller_hash': 'NzQ4M2MyNjhlMDc5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681691',
                            'fiber_length': 8668,
                            'poller_hash': 'NzQ4M2MyNjhlMGRjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '146986',
                            'fiber_length': 8878,
                            'poller_hash': 'NzQ4M2MyNjhlMGUzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '146986',
                            'fiber_length': 9210,
                            'poller_hash': 'NzQ4M2MyNjhlMGVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '8681701',
                            'fiber_length': 7755,
                            'poller_hash': 'NzQ4M2MyNjhlMWNlcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 8679,
                            'poller_hash': 'NzQ4M2MyNjhlMmEzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '5019760',
                            'fiber_length': 11944,
                            'poller_hash': 'NzQ4M2MyNjhlMmI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '146987',
                            'fiber_length': 8807,
                            'poller_hash': 'NzQ4M2MyNjhlMmU1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 10288,
                            'poller_hash': 'NzQ4M2MyNjhlMzM1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '184477',
                            'fiber_length': 11970,
                            'poller_hash': 'NzQ4M2MyNjhlMzQ5cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '836243',
                            'fiber_length': 8558,
                            'poller_hash': 'NzQ4M2MyZjAyMDAwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '835503',
                            'fiber_length': 8733,
                            'poller_hash': 'NzQ4M2MyZjA1NGU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278473',
                            'fiber_length': 9676,
                            'poller_hash': 'NzQ4M2MyZjA1NTAwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '146986',
                            'fiber_length': 9617,
                            'poller_hash': 'NzQ4M2MyZjA2ZDQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '146987',
                            'fiber_length': 9320,
                            'poller_hash': 'NzQ4M2MyZjA2ZDg0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '6027238',
                            'fiber_length': 7867,
                            'poller_hash': 'NzQ4M2MyZjA3MDc0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997330',
                            'fiber_length': 11833,
                            'poller_hash': 'ZDAyMWY5OWE2OWQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3936880',
                            'fiber_length': 11288,
                            'poller_hash': 'ZDAyMWY5OWE2Y2U4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'name':
                        'pon4',
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQys0',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon5',
                    'in_errors':
                    '0',
                    'in_octets':
                    '967252330512',
                    'in_ucast_pkts':
                    '2576787019',
                    'links': [{
                        'in_octets': '14048582668',
                        'out_octets': '274624776323',
                        'poller_hash': 'NzQ4M2MyZjAyOWI4cGVlcmludGY='
                    }, {
                        'in_octets': '16131852330',
                        'out_octets': '63721866874',
                        'poller_hash': 'NzQ4M2MyZjAzMTAwcGVlcmludGY='
                    }, {
                        'in_octets': '9657226005',
                        'out_octets': '84954144187',
                        'poller_hash': 'NzQ4M2MyZjAzMTM0cGVlcmludGY='
                    }, {
                        'in_octets': '3182441623',
                        'out_octets': '39905129205',
                        'poller_hash': 'NzQ4M2MyZjAzMTUwcGVlcmludGY='
                    }, {
                        'in_octets': '20265296969',
                        'out_octets': '282946260150',
                        'poller_hash': 'NzQ4M2MyZjAzZGUwcGVlcmludGY='
                    }, {
                        'in_octets': '110700458158',
                        'out_octets': '444936869400',
                        'poller_hash': 'NzQ4M2MyZjAzZTY4cGVlcmludGY='
                    }, {
                        'in_octets': '35662411941',
                        'out_octets': '291731428977',
                        'poller_hash': 'NzQ4M2MyZjA0MTBjcGVlcmludGY='
                    }, {
                        'in_octets': '6970348369',
                        'out_octets': '49129075877',
                        'poller_hash': 'NzQ4M2MyZjA1MDY4cGVlcmludGY='
                    }, {
                        'in_octets': '67829562804',
                        'out_octets': '983279540878',
                        'poller_hash': 'ZDAyMWY5OWE2Mzk4cGVlcmludGY='
                    }, {
                        'in_octets': '13102342619',
                        'out_octets': '160422727981',
                        'poller_hash': 'ZDAyMWY5OWE2NTE4cGVlcmludGY='
                    }, {
                        'in_octets': '69955251863',
                        'out_octets': '1286202225421',
                        'poller_hash': 'ZDAyMWY5OWE2NTQ4cGVlcmludGY='
                    }, {
                        'in_octets': '1814409027',
                        'out_octets': '38626237646',
                        'poller_hash': 'ZDAyMWY5OWE2NTVjcGVlcmludGY='
                    }, {
                        'in_octets': '61292469972',
                        'out_octets': '958724239744',
                        'poller_hash': 'ZDAyMWY5OWE2NTcwcGVlcmludGY='
                    }, {
                        'in_octets': '55038145877',
                        'out_octets': '261383580621',
                        'poller_hash': 'ZDAyMWY5OWE2NTc0cGVlcmludGY='
                    }, {
                        'in_octets': '39318486675',
                        'out_octets': '314294341270',
                        'poller_hash': 'ZDAyMWY5OWE2NWQwcGVlcmludGY='
                    }, {
                        'in_octets': '52196691090',
                        'out_octets': '1052726516247',
                        'poller_hash': 'ZDAyMWY5OWE2NjY4cGVlcmludGY='
                    }, {
                        'in_octets': '18167547944',
                        'out_octets': '140582636676',
                        'poller_hash': 'ZDAyMWY5OWE2OGIwcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon5',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '9951011981792',
                    'out_ucast_pkts':
                    '7950435012',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uNWludGY=',
                    'pons': [{
                        'id':
                        '5',
                        'links': [{
                            'connected_time': '834233',
                            'fiber_length': 15791,
                            'poller_hash': 'NzQ4M2MyZjAyOWI4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833443',
                            'fiber_length': 15424,
                            'poller_hash': 'NzQ4M2MyZjAzMTAwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '677602',
                            'fiber_length': 15356,
                            'poller_hash': 'NzQ4M2MyZjAzMTM0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '62106',
                            'fiber_length': 15746,
                            'poller_hash': 'NzQ4M2MyZjAzMTUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '834343',
                            'fiber_length': 16109,
                            'poller_hash': 'NzQ4M2MyZjAzZGUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '1557720',
                            'fiber_length': 16027,
                            'poller_hash': 'NzQ4M2MyZjAzZTY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '950444',
                            'fiber_length': 15781,
                            'poller_hash': 'NzQ4M2MyZjA0MTBjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2661429',
                            'fiber_length': 16093,
                            'poller_hash': 'NzQ4M2MyZjA1MDY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2661889',
                            'fiber_length': 15923,
                            'poller_hash': 'ZDAyMWY5OWE2Mzk4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833623',
                            'fiber_length': 15882,
                            'poller_hash': 'ZDAyMWY5OWE2NTE4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2764900',
                            'fiber_length': 15566,
                            'poller_hash': 'ZDAyMWY5OWE2NTQ4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '314588',
                            'fiber_length': 15682,
                            'poller_hash': 'ZDAyMWY5OWE2NTVjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2566168',
                            'fiber_length': 16111,
                            'poller_hash': 'ZDAyMWY5OWE2NTcwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '948054',
                            'fiber_length': 15322,
                            'poller_hash': 'ZDAyMWY5OWE2NTc0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2662229',
                            'fiber_length': 15780,
                            'poller_hash': 'ZDAyMWY5OWE2NWQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2160565',
                            'fiber_length': 16158,
                            'poller_hash': 'ZDAyMWY5OWE2NjY4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2144715',
                            'fiber_length': 16191,
                            'poller_hash': 'ZDAyMWY5OWE2OGIwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'name':
                        'pon5',
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQys1',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon6',
                    'in_errors':
                    '0',
                    'in_octets':
                    '11550533961586',
                    'in_ucast_pkts':
                    '27732987643',
                    'links': [{
                        'in_octets': '64682686650',
                        'out_octets': '1378430172533',
                        'poller_hash': 'MThlODI5MGIzZmYwcGVlcmludGY='
                    }, {
                        'in_octets': '58935837394',
                        'out_octets': '103243505750',
                        'poller_hash': 'NzRhY2I5OTllOGUycGVlcmludGY='
                    }, {
                        'in_octets': '97716269138',
                        'out_octets': '542051877093',
                        'poller_hash': 'NzQ4M2MyNjhlMDQzcGVlcmludGY='
                    }, {
                        'in_octets': '166413636836',
                        'out_octets': '804364868742',
                        'poller_hash': 'NzQ4M2MyNjhlMDUwcGVlcmludGY='
                    }, {
                        'in_octets': '33046972656',
                        'out_octets': '299499908771',
                        'poller_hash': 'NzQ4M2MyNjhlMTc3cGVlcmludGY='
                    }, {
                        'in_octets': '28410002462',
                        'out_octets': '581947443928',
                        'poller_hash': 'NzQ4M2MyNjhlMWJicGVlcmludGY='
                    }, {
                        'in_octets': '35219493695',
                        'out_octets': '339625360998',
                        'poller_hash': 'NzQ4M2MyNjhlMWNicGVlcmludGY='
                    }, {
                        'in_octets': '50812142746',
                        'out_octets': '562509529652',
                        'poller_hash': 'NzQ4M2MyNjhlMWNkcGVlcmludGY='
                    }, {
                        'in_octets': '137985309916',
                        'out_octets': '1198772314150',
                        'poller_hash': 'NzQ4M2MyNjhlMzMycGVlcmludGY='
                    }, {
                        'in_octets': '51831183827',
                        'out_octets': '489216405112',
                        'poller_hash': 'NzQ4M2MyNjhlMzNicGVlcmludGY='
                    }, {
                        'in_octets': '39274623155',
                        'out_octets': '409019139729',
                        'poller_hash': 'NzQ4M2MyZjAyOWNjcGVlcmludGY='
                    }, {
                        'in_octets': '150142253877',
                        'out_octets': '1611139413248',
                        'poller_hash': 'NzQ4M2MyZjAzZmI0cGVlcmludGY='
                    }, {
                        'in_octets': '29177723323',
                        'out_octets': '773416988603',
                        'poller_hash': 'NzQ4M2MyZjA2OGU0cGVlcmludGY='
                    }, {
                        'in_octets': '17546018017',
                        'out_octets': '443085698340',
                        'poller_hash': 'ZDAyMWY5OWE2NTg0cGVlcmludGY='
                    }, {
                        'in_octets': '9572622904',
                        'out_octets': '89696434174',
                        'poller_hash': 'ZDAyMWY5OWE2OWU0cGVlcmludGY='
                    }, {
                        'in_octets': '95782914966',
                        'out_octets': '521901715225',
                        'poller_hash': 'ZDAyMWY5OWE2YTQ0cGVlcmludGY='
                    }, {
                        'in_octets': '18239730929',
                        'out_octets': '156793311470',
                        'poller_hash': 'ZDAyMWY5OWE2YTY0cGVlcmludGY='
                    }, {
                        'in_octets': '65745451819',
                        'out_octets': '1629541492753',
                        'poller_hash': 'ZDAyMWY5OWE2YjZjcGVlcmludGY='
                    }, {
                        'in_octets': '204582276691',
                        'out_octets': '1991524037999',
                        'poller_hash': 'ZDAyMWY5OWE2YjcwcGVlcmludGY='
                    }, {
                        'in_octets': '467525045560',
                        'out_octets': '208972267153',
                        'poller_hash': 'ZDAyMWY5OWE2YjdjcGVlcmludGY='
                    }, {
                        'in_octets': '310969088212',
                        'out_octets': '2905404066142',
                        'poller_hash': 'ZDAyMWY5OWE2YzgwcGVlcmludGY='
                    }, {
                        'in_octets': '58344509241',
                        'out_octets': '604577138728',
                        'poller_hash': 'ZDAyMWY5OWE2ZGNjcGVlcmludGY='
                    }, {
                        'in_octets': '124994783885',
                        'out_octets': '3100243215818',
                        'poller_hash': 'ZDAyMWY5OWE2ZTI0cGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-B+',
                    'name':
                    'pon6',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '75652798030021',
                    'out_ucast_pkts':
                    '60433007684',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uNmludGY=',
                    'pons': [{
                        'id':
                        '6',
                        'links': [{
                            'connected_time': '3244914',
                            'fiber_length': 12060,
                            'poller_hash': 'MThlODI5MGIzZmYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833693',
                            'fiber_length': 12030,
                            'poller_hash': 'NzRhY2I5OTllOGUycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 11596,
                            'poller_hash': 'NzQ4M2MyNjhlMDQzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7144038',
                            'fiber_length': 11983,
                            'poller_hash': 'NzQ4M2MyNjhlMDUwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 11159,
                            'poller_hash': 'NzQ4M2MyNjhlMTc3cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 11311,
                            'poller_hash': 'NzQ4M2MyNjhlMWJicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997559',
                            'fiber_length': 12072,
                            'poller_hash': 'NzQ4M2MyNjhlMWNicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '3887420',
                            'fiber_length': 11077,
                            'poller_hash': 'NzQ4M2MyNjhlMWNkcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 11218,
                            'poller_hash': 'NzQ4M2MyNjhlMzMycG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 12015,
                            'poller_hash': 'NzQ4M2MyNjhlMzNicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833613',
                            'fiber_length': 12446,
                            'poller_hash': 'NzQ4M2MyZjAyOWNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997559',
                            'fiber_length': 11484,
                            'poller_hash': 'NzQ4M2MyZjAzZmI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2207095',
                            'fiber_length': 7900,
                            'poller_hash': 'NzQ4M2MyZjA2OGU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2761630',
                            'fiber_length': 12737,
                            'poller_hash': 'ZDAyMWY5OWE2NTg0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '665452',
                            'fiber_length': 10818,
                            'poller_hash': 'ZDAyMWY5OWE2OWU0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 10967,
                            'poller_hash': 'ZDAyMWY5OWE2YTQ0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833133',
                            'fiber_length': 12496,
                            'poller_hash': 'ZDAyMWY5OWE2YTY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 8265,
                            'poller_hash': 'ZDAyMWY5OWE2YjZjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4069192',
                            'fiber_length': 9924,
                            'poller_hash': 'ZDAyMWY5OWE2YjcwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 10882,
                            'poller_hash': 'ZDAyMWY5OWE2YjdjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7147668',
                            'fiber_length': 11413,
                            'poller_hash': 'ZDAyMWY5OWE2YzgwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997559',
                            'fiber_length': 10202,
                            'poller_hash': 'ZDAyMWY5OWE2ZGNjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4997559',
                            'fiber_length': 11279,
                            'poller_hash': 'ZDAyMWY5OWE2ZTI0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon6',
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQis2',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up':
                    True,
                    'id':
                    'pon7',
                    'in_errors':
                    '0',
                    'in_octets':
                    '2094095155860',
                    'in_ucast_pkts':
                    '8314183386',
                    'links': [{
                        'in_octets': '21520436418',
                        'out_octets': '969079701468',
                        'poller_hash': 'NzQ4M2MyNjhlMDkzcGVlcmludGY='
                    }, {
                        'in_octets': '18157842209',
                        'out_octets': '347983704827',
                        'poller_hash': 'NzQ4M2MyNjhlMWNhcGVlcmludGY='
                    }, {
                        'in_octets': '23950416454',
                        'out_octets': '638499111925',
                        'poller_hash': 'NzQ4M2MyNjhlMWQ1cGVlcmludGY='
                    }, {
                        'in_octets': '19653761561',
                        'out_octets': '881262437368',
                        'poller_hash': 'NzQ4M2MyNjhlMWY0cGVlcmludGY='
                    }, {
                        'in_octets': '5828413357',
                        'out_octets': '82279656275',
                        'poller_hash': 'NzQ4M2MyNjhlMjFicGVlcmludGY='
                    }, {
                        'in_octets': '10753248487',
                        'out_octets': '278751320357',
                        'poller_hash': 'NzQ4M2MyZjAyNzU4cGVlcmludGY='
                    }, {
                        'in_octets': '802491631',
                        'out_octets': '8344825064',
                        'poller_hash': 'NzQ4M2MyZjAyOTBjcGVlcmludGY='
                    }, {
                        'in_octets': '23627117702',
                        'out_octets': '127421559740',
                        'poller_hash': 'NzQ4M2MyZjAyOWM4cGVlcmludGY='
                    }, {
                        'in_octets': '6684940984',
                        'out_octets': '133989600571',
                        'poller_hash': 'NzQ4M2MyZjAzMGY0cGVlcmludGY='
                    }, {
                        'in_octets': '51032775231',
                        'out_octets': '546286601691',
                        'poller_hash': 'NzQ4M2MyZjAzMTQwcGVlcmludGY='
                    }, {
                        'in_octets': '28129386784',
                        'out_octets': '486241716971',
                        'poller_hash': 'ZDAyMWY5OWE1Mjc0cGVlcmludGY='
                    }, {
                        'in_octets': '336605294975',
                        'out_octets': '689704574249',
                        'poller_hash': 'ZDAyMWY5OWE2NDkwcGVlcmludGY='
                    }, {
                        'in_octets': '94',
                        'out_octets': '0',
                        'poller_hash': 'ZDAyMWY5OWE2YTg4cGVlcmludGY='
                    }, {
                        'in_octets': '160497034318',
                        'out_octets': '3762863382520',
                        'poller_hash': 'ZDAyMWY5OWE2YTkwcGVlcmludGY='
                    }, {
                        'in_octets': '30002950143',
                        'out_octets': '299600356873',
                        'poller_hash': 'ZDAyMWY5OWE2YWYwcGVlcmludGY='
                    }, {
                        'in_octets': '28674891079',
                        'out_octets': '327293401453',
                        'poller_hash': 'ZDAyMWY5OWE2YmFjcGVlcmludGY='
                    }],
                    'manufacturer':
                    'Ubiquiti',
                    'model':
                    'UF-GP-C+',
                    'name':
                    'pon7',
                    'oper_up':
                    True,
                    'out_errors':
                    '0',
                    'out_octets':
                    '28736899884549',
                    'out_ucast_pkts':
                    '21657911520',
                    'poller_hash':
                    'YjRmYmU0NTA0YTQ3cG9uN2ludGY=',
                    'pons': [{
                        'id':
                        '7',
                        'links': [{
                            'connected_time': '4261533',
                            'fiber_length': 2762,
                            'poller_hash': 'NzQ4M2MyNjhlMDkzcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2306656',
                            'fiber_length': 3260,
                            'poller_hash': 'NzQ4M2MyNjhlMWNhcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 2626,
                            'poller_hash': 'NzQ4M2MyNjhlMWQ1cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278413',
                            'fiber_length': 1900,
                            'poller_hash': 'NzQ4M2MyNjhlMWY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '833603',
                            'fiber_length': 2367,
                            'poller_hash': 'NzQ4M2MyNjhlMjFicG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4056632',
                            'fiber_length': 2305,
                            'poller_hash': 'NzQ4M2MyZjAyNzU4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2388,
                            'poller_hash': 'NzQ4M2MyZjAyOTBjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '423039',
                            'fiber_length': 3392,
                            'poller_hash': 'NzQ4M2MyZjAyOWM4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '834323',
                            'fiber_length': 2271,
                            'poller_hash': 'NzQ4M2MyZjAzMGY0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2491318',
                            'fiber_length': 3308,
                            'poller_hash': 'NzQ4M2MyZjAzMTQwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2559,
                            'poller_hash': 'ZDAyMWY5OWE1Mjc0cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '2569389',
                            'fiber_length': 2462,
                            'poller_hash': 'ZDAyMWY5OWE2NDkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278463',
                            'fiber_length': 2679,
                            'poller_hash': 'ZDAyMWY5OWE2YTg4cG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '7146988',
                            'fiber_length': 2619,
                            'poller_hash': 'ZDAyMWY5OWE2YTkwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '510630',
                            'fiber_length': 2599,
                            'poller_hash': 'ZDAyMWY5OWE2YWYwcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }, {
                            'connected_time': '4278453',
                            'fiber_length': 2577,
                            'poller_hash': 'ZDAyMWY5OWE2YmFjcG9ubGluaw==',
                            'rx_link_rate': '1244160000',
                            'tx_link_rate': '2488320000'
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -12.0,
                        'minimum_loss':
                        -30.0,
                        'name':
                        'pon7',
                        'poller_hash':
                        'YjRmYmU0NTA0YTQ3VUYtR1AtQys3',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '1244160000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '2488320000'
                    }],
                    'speed':
                    '2500000000'
                }, {
                    'admin_up': True,
                    'id': 'pon8',
                    'name': 'pon8',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uOGludGY='
                }, {
                    'admin_up': True,
                    'id': 'sfp1',
                    'in_octets': '64999563447566',
                    'in_ucast_pkts': '389399718721',
                    'manufacturer': 'OEM',
                    'model': 'SFP-H10GB-CU1M',
                    'name': 'SFP+ 1',
                    'oper_up': True,
                    'out_octets': '62111558741541',
                    'out_ucast_pkts': '157639782479',
                    'poller_hash': 'YjRmYmU0NTA0YTQ3c2ZwMWludGY=',
                    'speed': '10000000000'
                }, {
                    'admin_up': True,
                    'id': 'sfp2',
                    'name': 'SFP+ 2',
                    'oper_up': False,
                    'poller_hash': 'YjRmYmU0NTA0YTQ3c2ZwMmludGY='
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                22.0,
                'model':
                'UFiber OLT',
                'serial_number':
                'UBNTe4504a47',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                'b4:fb:e4:50:4a:47',
                'temperature':
                38.5,
                'uptime':
                '17755358'
            },
            'peers': [{
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '820035615528',
                    'links': [{
                        'in_octets': '820035615528',
                        'out_octets': '100324308108',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '100324308108',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDJicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '2759250',
                            'fiber_length': 7280,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.746,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.842
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMDJicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:f8:b7:35'],
                    'id': '1',
                    'in_octets': '100324308108',
                    'mac_address': '74:83:c2:69:e0:2b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '820035615528',
                    'poller_hash': 'NzQ4M2MyNjhlMDJiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19369LancerCircle',
                'serial_number':
                'UBNTc268e02b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:2b',
                'temperature':
                43.0,
                'uptime':
                '2759298'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2996558436399',
                    'links': [{
                        'in_octets': '2996558436399',
                        'out_octets': '139565314813',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '139565314813',
                    'poller_hash':
                    'NzQ4M2MyNjhlMDdicGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681701',
                            'fiber_length': 7682,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.108,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.438
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMDdicG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['2c:30:33:60:5c:57'],
                    'id': '1',
                    'in_octets': '139565314813',
                    'mac_address': '74:83:c2:69:e0:7b',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2996558436399',
                    'poller_hash': 'NzQ4M2MyNjhlMDdiZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19163LincolnRd',
                'serial_number':
                'UBNTc268e07b',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:7b',
                'temperature':
                45.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2646054293568',
                    'links': [{
                        'in_octets': '2646054293568',
                        'out_octets': '132749350490',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '132749350490',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGExcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7145418',
                            'fiber_length': 8543,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.022,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.624
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMGExcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['68:d7:9a:5c:fa:4c'],
                    'id': '1',
                    'in_octets': '132749350490',
                    'mac_address': '74:83:c2:69:e0:a1',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2646054293568',
                    'poller_hash': 'NzQ4M2MyNjhlMGExZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19320LancerCircle',
                'serial_number':
                'UBNTc268e0a1',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:a1',
                'temperature':
                45.0,
                'uptime':
                '7145456'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2186440045060',
                    'links': [{
                        'in_octets': '2186440045060',
                        'out_octets': '244424999842',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '244424999842',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGIzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681700',
                            'fiber_length': 8683,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.136,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.18
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMGIzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['14:59:c0:42:7d:3b'],
                    'id': '1',
                    'in_octets': '244424999842',
                    'mac_address': '74:83:c2:69:e0:b3',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2186440045060',
                    'poller_hash': 'NzQ4M2MyNjhlMGIzZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19231LancerCircle',
                'serial_number':
                'UBNTc268e0b3',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:b3',
                'temperature':
                43.0,
                'uptime':
                '8681748'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '5121959123389',
                    'links': [{
                        'in_octets': '5121959123389',
                        'out_octets': '1245160880098',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1245160880098',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGJmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681700',
                            'fiber_length': 7281,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.544,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.892
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMGJmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['30:34:22:09:59:a0'],
                    'id': '1',
                    'in_octets': '1245160880098',
                    'mac_address': '74:83:c2:69:e0:bf',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '5121959123389',
                    'poller_hash': 'NzQ4M2MyNjhlMGJmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19203LincolnRoad',
                'serial_number':
                'UBNTc268e0bf',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:bf',
                'temperature':
                46.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1494023287910',
                    'links': [{
                        'in_octets': '1494023287910',
                        'out_octets': '119670939285',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '119670939285',
                    'poller_hash':
                    'NzQ4M2MyNjhlMGRmcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681699',
                            'fiber_length': 8658,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.398,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.63
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMGRmcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['b4:b0:24:42:6e:5d'],
                    'id': '1',
                    'in_octets': '119670939285',
                    'mac_address': '74:83:c2:69:e0:df',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1494023287910',
                    'poller_hash': 'NzQ4M2MyNjhlMGRmZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19243LancerCircle',
                'serial_number':
                'UBNTc268e0df',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e0:df',
                'temperature':
                45.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '286769245927',
                    'links': [{
                        'in_octets': '286769245927',
                        'out_octets': '56555672526',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '56555672526',
                    'poller_hash':
                    'NzQ4M2MyNjhlMTAwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '836113',
                            'fiber_length': 8602,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.826,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.308
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMTAwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['a4:97:33:b0:73:d0'],
                    'id': '1',
                    'in_octets': '56555672526',
                    'mac_address': '74:83:c2:69:e1:00',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '286769245927',
                    'poller_hash': 'NzQ4M2MyNjhlMTAwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19110LancerCircle',
                'serial_number':
                'UBNTc268e100',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:00',
                'temperature':
                45.0,
                'uptime':
                '836156'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2521309511179',
                    'links': [{
                        'in_octets': '2521309511179',
                        'out_octets': '220206239381',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '220206239381',
                    'poller_hash':
                    'NzQ4M2MyNjhlMTEwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681700',
                            'fiber_length': 8405,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.808,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.556
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMTEwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up':
                    True,
                    'bridged_mac_addresses': ['6c:cd:d6:03:8c:1f', 'a8:51:ab:95:30:9f'],
                    'id':
                    '1',
                    'in_octets':
                    '220206239381',
                    'mac_address':
                    '74:83:c2:69:e1:10',
                    'name':
                    'eth0',
                    'oper_up':
                    True,
                    'out_octets':
                    '2521309511179',
                    'poller_hash':
                    'NzQ4M2MyNjhlMTEwZXRoMQ==',
                    'speed':
                    '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19167LancerCircle',
                'serial_number':
                'UBNTc268e110',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:10',
                'temperature':
                46.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '4340435272320',
                    'links': [{
                        'in_octets': '4340435272320',
                        'out_octets': '243091001033',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '243091001033',
                    'poller_hash':
                    'NzQ4M2MyNjhlMTRhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7148288',
                            'fiber_length': 8000,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.108,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.644
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMTRhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['04:42:1a:9a:fd:a0'],
                    'id': '1',
                    'in_octets': '243091001033',
                    'mac_address': '74:83:c2:69:e1:4a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '4340435272320',
                    'poller_hash': 'NzQ4M2MyNjhlMTRhZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19061LancerCircle',
                'serial_number':
                'UBNTc268e14a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e1:4a',
                'temperature':
                40.0,
                'uptime':
                '7148328'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1657403497298',
                    'links': [{
                        'in_octets': '1657403497298',
                        'out_octets': '124236330502',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '124236330502',
                    'poller_hash':
                    'NzQ4M2MyNjhlMjAycGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '6381381',
                            'fiber_length': 8129,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.632,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.806
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMjAycG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['78:d2:94:ab:9a:cd'],
                    'id': '1',
                    'in_octets': '124236330502',
                    'mac_address': '74:83:c2:69:e2:02',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1657403497298',
                    'poller_hash': 'NzQ4M2MyNjhlMjAyZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19430LancerCir',
                'serial_number':
                'UBNTc268e202',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:02',
                'temperature':
                46.0,
                'uptime':
                '6381423'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '953751967501',
                    'links': [{
                        'in_octets': '953751967501',
                        'out_octets': '170671770826',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '170671770826',
                    'poller_hash':
                    'NzQ4M2MyNjhlMjAzcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7146208',
                            'fiber_length': 8411,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.0,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.088
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMjAzcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up':
                    True,
                    'bridged_mac_addresses':
                    ['90:9a:4a:d0:74:1a', '9c:a2:f4:4e:5a:4d', 'c0:74:ad:74:89:cb'],
                    'id':
                    '1',
                    'in_octets':
                    '170671770826',
                    'mac_address':
                    '74:83:c2:69:e2:03',
                    'name':
                    'eth0',
                    'oper_up':
                    True,
                    'out_octets':
                    '953751967501',
                    'poller_hash':
                    'NzQ4M2MyNjhlMjAzZXRoMQ==',
                    'speed':
                    '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19080LancerCircle',
                'serial_number':
                'UBNTc268e203',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:03',
                'temperature':
                43.0,
                'uptime':
                '7146250'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1244149056605',
                    'links': [{
                        'in_octets': '1244149056605',
                        'out_octets': '55062873390',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '55062873390',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmExcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '4218443',
                            'fiber_length': 8084,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.242,
                            'tx_link_rate': '1244160000',
                            'tx_power': 3.066
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMmExcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['c8:9e:43:b6:00:bf'],
                    'id': '1',
                    'in_octets': '55062873390',
                    'mac_address': '74:83:c2:69:e2:a1',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1244149056605',
                    'poller_hash': 'NzQ4M2MyNjhlMmExZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19070LincolnRoad',
                'serial_number':
                'UBNTc268e2a1',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:a1',
                'temperature':
                36.0,
                'uptime':
                '4218486'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3137160207456',
                    'links': [{
                        'in_octets': '3137160207456',
                        'out_octets': '142162920578',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '142162920578',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmI3cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681700',
                            'fiber_length': 7481,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.01,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.692
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMmI3cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['38:94:ed:b3:38:7a'],
                    'id': '1',
                    'in_octets': '142162920578',
                    'mac_address': '74:83:c2:69:e2:b7',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3137160207456',
                    'poller_hash': 'NzQ4M2MyNjhlMmI3ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19221LincolnRd',
                'serial_number':
                'UBNTc268e2b7',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:b7',
                'temperature':
                41.0,
                'uptime':
                '8681748'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2043343390962',
                    'links': [{
                        'in_octets': '2043343390962',
                        'out_octets': '156238978100',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '156238978100',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmJkcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681701',
                            'fiber_length': 7201,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.28,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.07
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMmJkcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['14:91:82:71:43:86'],
                    'id': '1',
                    'in_octets': '156238978100',
                    'mac_address': '74:83:c2:69:e2:bd',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2043343390962',
                    'poller_hash': 'NzQ4M2MyNjhlMmJkZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19209LincolnRoad',
                'serial_number':
                'UBNTc268e2bd',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:bd',
                'temperature':
                41.0,
                'uptime':
                '8681748'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '614804305940',
                    'links': [{
                        'in_octets': '614804305940',
                        'out_octets': '42324369713',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '42324369713',
                    'poller_hash':
                    'NzQ4M2MyNjhlMmM1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7146288',
                            'fiber_length': 7332,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -15.9,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.624
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMmM1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:d2:b2:81'],
                    'id': '1',
                    'in_octets': '42324369713',
                    'mac_address': '74:83:c2:69:e2:c5',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '614804305940',
                    'poller_hash': 'NzQ4M2MyNjhlMmM1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19391LancerCircle',
                'serial_number':
                'UBNTc268e2c5',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e2:c5',
                'temperature':
                41.0,
                'uptime':
                '7146332'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1153229350068',
                    'links': [{
                        'in_octets': '1153229350068',
                        'out_octets': '47317801454',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '47317801454',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzExcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681700',
                            'fiber_length': 7574,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.694,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.06
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMzExcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up':
                    True,
                    'bridged_mac_addresses': [
                        'b4:b7:42:a0:04:ca', 'e0:63:da:25:0c:e8', 'e0:63:da:25:0c:e9',
                        'e0:63:da:73:04:04'
                    ],
                    'id':
                    '1',
                    'in_octets':
                    '47317801454',
                    'mac_address':
                    '74:83:c2:69:e3:11',
                    'name':
                    'eth0',
                    'oper_up':
                    True,
                    'out_octets':
                    '1153229350068',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzExZXRoMQ==',
                    'speed':
                    '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19249LincolnRoad-Cottage',
                'serial_number':
                'UBNTc268e311',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:11',
                'temperature':
                37.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '146270831483',
                    'links': [{
                        'in_octets': '146270831483',
                        'out_octets': '23711662173',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '23711662173',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzIxcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '3588447',
                            'fiber_length': 8354,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.446,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.012
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMzIxcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['24:05:88:40:ef:31'],
                    'id': '1',
                    'in_octets': '23711662173',
                    'mac_address': '74:83:c2:69:e3:21',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '146270831483',
                    'poller_hash': 'NzQ4M2MyNjhlMzIxZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19382LancerCircle',
                'serial_number':
                'UBNTc268e321',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:21',
                'temperature':
                41.0,
                'uptime':
                '3588491'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '6781398714211',
                    'links': [{
                        'in_octets': '6781398714211',
                        'out_octets': '310042254680',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '310042254680',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzI1cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681701',
                            'fiber_length': 8032,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.828,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.252
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMzI1cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['d8:47:32:98:46:73'],
                    'id': '1',
                    'in_octets': '310042254680',
                    'mac_address': '74:83:c2:69:e3:25',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '6781398714211',
                    'poller_hash': 'NzQ4M2MyNjhlMzI1ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19060LincolnRoad',
                'serial_number':
                'UBNTc268e325',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:25',
                'temperature':
                45.0,
                'uptime':
                '8681748'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '13890809517327',
                    'links': [{
                        'in_octets': '13890809517327',
                        'out_octets': '867392745646',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '867392745646',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzJlcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8847462',
                            'fiber_length': 8516,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.064,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.378
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMzJlcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['74:ac:b9:58:9d:ce'],
                    'id': '1',
                    'in_octets': '867392745646',
                    'mac_address': '74:83:c2:69:e3:2e',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '13890809517327',
                    'poller_hash': 'NzQ4M2MyNjhlMzJlZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                52.0,
                'model':
                'NanoG',
                'name':
                '19226LancerCircle',
                'serial_number':
                'UBNTc268e32e',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:2e',
                'temperature':
                47.0,
                'uptime':
                '8847510'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3834216953694',
                    'links': [{
                        'in_octets': '3834216953694',
                        'out_octets': '74580086771',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '74580086771',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzNhcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7147428',
                            'fiber_length': 7166,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.362,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.0
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMzNhcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['c8:9e:43:a5:85:ee'],
                    'id': '1',
                    'in_octets': '74580086771',
                    'mac_address': '74:83:c2:69:e3:3a',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3834216953694',
                    'poller_hash': 'NzQ4M2MyNjhlMzNhZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19215LincolnRoad',
                'serial_number':
                'UBNTc268e33a',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:3a',
                'temperature':
                43.0,
                'uptime':
                '7147471'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '84525278369',
                    'links': [{
                        'in_octets': '84525278369',
                        'out_octets': '7789426259',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '7789426259',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzUwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '833813',
                            'fiber_length': 8012,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.152,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.996
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMzUwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['6c:cd:d6:e1:de:09'],
                    'id': '1',
                    'in_octets': '7789426259',
                    'mac_address': '74:83:c2:69:e3:50',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '84525278369',
                    'poller_hash': 'NzQ4M2MyNjhlMzUwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19058LancerCircle',
                'serial_number':
                'UBNTc268e350',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:50',
                'temperature':
                45.0,
                'uptime':
                '833857'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '493138803253',
                    'links': [{
                        'in_octets': '493138803253',
                        'out_octets': '48042507592',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '48042507592',
                    'poller_hash':
                    'NzQ4M2MyNjhlMzU0cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '834653',
                            'fiber_length': 8447,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.538,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.298
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyNjhlMzU0cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['3c:37:86:fb:37:1b'],
                    'id': '1',
                    'in_octets': '48042507592',
                    'mac_address': '74:83:c2:69:e3:54',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '493138803253',
                    'poller_hash': 'NzQ4M2MyNjhlMzU0ZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19105LancerCircle',
                'serial_number':
                'UBNTc268e354',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:68:e3:54',
                'temperature':
                38.0,
                'uptime':
                '834692'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3053223141963',
                    'links': [{
                        'in_octets': '3053223141963',
                        'out_octets': '380791876350',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '380791876350',
                    'poller_hash':
                    'NzQ4M2MyZjAzZmQwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681699',
                            'fiber_length': 8653,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -21.248,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.75
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyZjAzZmQwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['08:b4:b1:89:ba:86'],
                    'id': '1',
                    'in_octets': '380791876350',
                    'mac_address': '74:83:c2:f1:3f:d0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3053223141963',
                    'poller_hash': 'NzQ4M2MyZjAzZmQwZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19204LancerCircle',
                'serial_number':
                'UBNTc2f03fd0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:3f:d0',
                'temperature':
                45.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                3.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2505658355768',
                    'links': [{
                        'in_octets': '2505658355768',
                        'out_octets': '163682568555',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '163682568555',
                    'poller_hash':
                    'NzQ4M2MyZjA0NmFjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8847472',
                            'fiber_length': 7592,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -18.268,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.052
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyZjA0NmFjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['54:af:97:50:00:e0'],
                    'id': '1',
                    'in_octets': '163682568555',
                    'mac_address': '74:83:c2:f1:46:ac',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '2505658355768',
                    'poller_hash': 'NzQ4M2MyZjA0NmFjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19564GreggsvilleRd',
                'serial_number':
                'UBNTc2f046ac',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:46:ac',
                'temperature':
                39.0,
                'uptime':
                '8847513'
            }, {
                'admin_disabled':
                False,
                'cpu':
                1.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '27467042447',
                    'links': [{
                        'in_octets': '27467042447',
                        'out_octets': '1377723100',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1377723100',
                    'poller_hash':
                    'NzQ4M2MyZjA1NGQwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '691952',
                            'fiber_length': 7976,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -16.516,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.598
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyZjA1NGQwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['2c:b0:5d:49:d6:c1'],
                    'id': '1',
                    'in_octets': '1377723100',
                    'mac_address': '74:83:c2:f1:54:d0',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '27467042447',
                    'poller_hash': 'NzQ4M2MyZjA1NGQwZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19060LincolnRoad-MilkHouse',
                'serial_number':
                'UBNTc2f054d0',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:54:d0',
                'temperature':
                45.0,
                'uptime':
                '691995'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '1514329790933',
                    'links': [{
                        'in_octets': '1514329790933',
                        'out_octets': '266497356947',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '266497356947',
                    'poller_hash':
                    'NzQ4M2MyZjA2OTBjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681691',
                            'fiber_length': 8458,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -17.644,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.38
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyZjA2OTBjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['00:14:f6:90:45:d1'],
                    'id': '1',
                    'in_octets': '266497356947',
                    'mac_address': '74:83:c2:f1:69:0c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '1514329790933',
                    'poller_hash': 'NzQ4M2MyZjA2OTBjZXRoMQ==',
                    'speed': '100000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19179LancerCircle',
                'serial_number':
                'UBNTc2f0690c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:69:0c',
                'temperature':
                44.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '561107653217',
                    'links': [{
                        'in_octets': '561107653217',
                        'out_octets': '53380893648',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '53380893648',
                    'poller_hash':
                    'NzQ4M2MyZjA2OTY4cGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681741',
                            'fiber_length': 8467,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.586,
                            'tx_link_rate': '1244160000',
                            'tx_power': 2.472
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyZjA2OTY4cG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up':
                    True,
                    'bridged_mac_addresses': ['08:36:c9:2d:84:f1', 'c0:74:ad:74:89:8e'],
                    'id':
                    '1',
                    'in_octets':
                    '53380893648',
                    'mac_address':
                    '74:83:c2:f1:69:68',
                    'name':
                    'eth0',
                    'oper_up':
                    True,
                    'out_octets':
                    '561107653217',
                    'poller_hash':
                    'NzQ4M2MyZjA2OTY4ZXRoMQ==',
                    'speed':
                    '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19199LancerCircle',
                'serial_number':
                'UBNTc2f06968',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:69:68',
                'temperature':
                44.0,
                'uptime':
                '8681782'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '3804670312341',
                    'links': [{
                        'in_octets': '3804670312341',
                        'out_octets': '220258027678',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '220258027678',
                    'poller_hash':
                    'NzQ4M2MyZjA2ZDhjcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '8681691',
                            'fiber_length': 8285,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -19.828,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.864
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyZjA2ZDhjcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin_up': True,
                    'bridged_mac_addresses': ['a0:04:60:cb:75:ec'],
                    'id': '1',
                    'in_octets': '220258027678',
                    'mac_address': '74:83:c2:f1:6d:8c',
                    'name': 'eth0',
                    'oper_up': True,
                    'out_octets': '3804670312341',
                    'poller_hash': 'NzQ4M2MyZjA2ZDhjZXRoMQ==',
                    'speed': '1000000000'
                }],
                'manufacturer':
                'Ubiquiti',
                'mem':
                51.0,
                'model':
                'NanoG',
                'name':
                '19155LancerCircle',
                'serial_number':
                'UBNTc2f06d8c',
                'status':
                'ELEMENT_STATUS_ONLINE',
                'sw_version':
                '4.3.1',
                'system_mac_address':
                '74:83:c2:f0:6d:8c',
                'temperature':
                41.0,
                'uptime':
                '8681747'
            }, {
                'admin_disabled':
                False,
                'cpu':
                2.0,
                'interfaces': [{
                    'id':
                    '0',
                    'in_octets':
                    '2762125828926',
                    'links': [{
                        'in_octets': '2762125828926',
                        'out_octets': '1457082746013',
                        'poller_hash': 'YjRmYmU0NTA0YTQ3cG9uMmludGY='
                    }],
                    'name':
                    'pon1',
                    'out_octets':
                    '1457082746013',
                    'poller_hash':
                    'NzQ4M2MyZjA3MDgwcGVlcmludGY=',
                    'pons': [{
                        'id':
                        '0',
                        'links': [{
                            'connected_time': '7147508',
                            'fiber_length': 8366,
                            'poller_hash': 'YjRmYmU0NTA0YTQ3VUYtR1AtQysy',
                            'rx_link_rate': '2488320000',
                            'rx_power': -20.86,
                            'tx_link_rate': '1244160000',
                            'tx_power': 1.486
                        }],
                        'max_distance':
                        20000,
                        'maximum_loss':
                        -8.0,
                        'minimum_loss':
                        -28.0,
                        'name':
                        'pon1',
                        'poller_hash':
                        'NzQ4M2MyZjA3MDgwcG9ubGluaw==',
                        'pon_technology':
                        'GPON',
                        'rx_link_rate':
                        '2488320000',
                        'split_ratio':
                        128,
                        'tx_link_rate':
                        '1244160000'
                    }]
                }, {
                    'admin