import os.path
import sys
sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase
 
class TestEpmpModels(DeviceTestCase):
    def test_cambium_epmp_epmp3000_ePMP_3000_4_3_01(self):
        obj = self.run_data("cambium-epmp.epmp3000.ePMP 3000.4.3.01")
        exp_info = {
                'framing': 'FIXED',
                'model': 'ePMP 3000',
                'rf_chan_width': 20,
                'rf_dl_percent': 50,
                'rf_freq': 5180,
                'rf_tx_power': 7,
                'sta_count': 0,
                'sta_mode_cpe': False,
                'sw_version': '4.3',
                'vendor': 'Cambium'
        }
        exp_stats = {
                'cpu': 22.6,
                'dl_en_bytes': 616048620,
                'dl_en_packets': 9752898,
                'dl_en_packets_dropped': 0,
                'dl_frutl': None,
                'dl_noise_floor': None,
                'dl_rf_bytes': 47883250,
                'dl_rf_packets': 953821,
                'dl_rf_packets_dropped': 8659312,
                'en_if_speed': 1000000000,
                'rf_packets_retransmitted': 2897,
                'ul_en_bytes': 21052724,
                'ul_en_packets': 188734,
                'ul_en_packets_dropped': 0,
                'ul_frutl': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': 3284125,
                'ul_rf_packets': 19111,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 22.6,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '11',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '9590180',
                                                              'in_octets': '615952451',
                                                              'in_ucast_pkts': '9751716',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:04:56:20:dd:32',
                                                              'mtu': 1538,
                                                              'name': 'LAN interface 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '24733',
                                                              'out_octets': '20974909',
                                                              'out_ucast_pkts': '187897',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '7271',
                                                              'in_octets': '3362983',
                                                              'in_ucast_pkts': '19111',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:04:56:20:dd:33',
                                                              'mtu': 1546,
                                                              'name': 'WLAN interface',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '8659091',
                                                              'out_nucast_pkts': '939436',
                                                              'out_octets': '49032474',
                                                              'out_ucast_pkts': '953821',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 50,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5180,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 7}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'NKAT250C5_2'}],
                                                              'speed': '110000000',
                                                              'type': 71}],
                                'manufacturer': 'Cambium',
                                'model': 'ePMP 3000',
                                'serial_number': '00045620DD32',
                                'sw_version': '4.3',
                                'system_mac_address': '00:04:56:20:dd:32',
                                'uptime': '524188'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_cambium_epmp_epmp3000_ePMP_3000_4_3_1_01(self):
        obj = self.run_data("cambium-epmp.epmp3000.ePMP 3000.4.3.1.01")
        exp_info = {
                'framing': 'FIXED',
                'model': 'ePMP 3000',
                'rf_chan_width': 40,
                'rf_dl_percent': 75,
                'rf_freq': 5190,
                'rf_tx_power': 19,
                'sta_count': 8,
                'sta_mode_cpe': False,
                'sw_version': '4.3.1',
                'vendor': 'Cambium'
        }
        exp_stats = {
                'cpu': 27.1,
                'dl_en_bytes': 1568451626372,
                'dl_en_packets': 1166169500,
                'dl_en_packets_dropped': 0,
                'dl_frutl': None,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1629603248750,
                'dl_rf_packets': 1250324800,
                'dl_rf_packets_dropped': 27808,
                'en_if_speed': 1000000000,
                'rf_packets_retransmitted': 83411653,
                'ul_en_bytes': 71029036296,
                'ul_en_packets': 472679825,
                'ul_en_packets_dropped': 0,
                'ul_frutl': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': 62873493500,
                'ul_rf_packets': 470491365,
                'ul_rf_packets_dropped': 112
        }
        exp_sta_stats = {
                '00:04:56:20:b4:87': {       'alt_macs': {'00:04:56:20:b4:86'},
                                             'dev_macs': {'20:4e:7f:8a:31:3d'},
                                             'dl_link_rate': 182250000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -86.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': 37339968930054144,
                                             'dl_rf_packets_dropped': 4294967296,
                                             'dl_rssi': -50.0,
                                             'dl_snr': 36.0,
                                             'ip_address': '10.7.0.1',
                                             'mac_address': '00:04:56:20:b4:87',
                                             'name': 'Jake Harms - 45',
                                             'rf_packets_retransmitted': 3280135243431936,
                                             'ul_link_rate': 89660000,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -88.0,
                                             'ul_rf_bytes': 2386586624851968000,
                                             'ul_rf_packets': 12812179501744128,
                                             'ul_rf_packets_dropped': 8589934592,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 39.0},
                '00:04:56:20:b6:25': {       'alt_macs': {'00:04:56:20:b6:24'},
                                             'dev_macs': {'10:da:43:77:c6:8f'},
                                             'dl_link_rate': 162000000,
                                             'dl_mcs': 5,
                                             'dl_noise_floor': -86.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': 177860548552032256,
                                             'dl_rf_packets_dropped': 700079669248,
                                             'dl_rssi': -49.0,
                                             'dl_snr': 37.0,
                                             'ip_address': '0.0.0.0',
                                             'mac_address': '00:04:56:20:b6:25',
                                             'name': '',
                                             'rf_packets_retransmitted': 22316735969361920,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -88.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': 94294697018654720,
                                             'ul_rf_packets_dropped': 21474836480,
                                             'ul_rssi': -52.0,
                                             'ul_snr': 36.0},
                '00:04:56:20:b7:1e': {       'alt_macs': {'00:04:56:20:b7:1d'},
                                             'dev_macs': {'c0:56:27:92:38:03'},
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -85.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': 77591869852221440,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': -37.0,
                                             'dl_snr': 48.0,
                                             'ip_address': '0.0.0.0',
                                             'mac_address': '00:04:56:20:b7:1e',
                                             'name': '',
                                             'rf_packets_retransmitted': 511101108224,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': 2841358700118016000,
                                             'ul_rf_packets': 33249884458975232,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 37.0},
                '00:04:56:20:bb:92': {       'alt_macs': {'00:04:56:20:bb:91'},
                                             'dev_macs': {'d8:0d:17:bf:50:50'},
                                             'dl_link_rate': 202500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -86.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': 11799636666744832,
                                             'dl_rf_packets_dropped': 154618822656,
                                             'dl_rssi': -53.0,
                                             'dl_snr': 33.0,
                                             'ip_address': '10.7.0.3',
                                             'mac_address': '00:04:56:20:bb:92',
                                             'name': 'Abe Schmitt - 234',
                                             'rf_packets_retransmitted': 680069416615936,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': 2824593832148992000,
                                             'ul_rf_packets': 7183569025761280,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -51.0,
                                             'ul_snr': 36.0},
                '00:04:56:20:c2:01': {       'alt_macs': {'00:04:56:20:c2:00'},
                                             'dev_macs': {'b8:69:f4:ac:df:c4'},
                                             'dl_link_rate': 121500000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -85.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': 110264106979688448,
                                             'dl_rf_packets_dropped': 1486058684416,
                                             'dl_rssi': -61.0,
                                             'dl_snr': 24.0,
                                             'ip_address': '0.0.0.0',
                                             'mac_address': '00:04:56:20:c2:01',
                                             'name': '',
                                             'rf_packets_retransmitted': 12889329999282176,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': 6806737185144832000,
                                             'ul_rf_packets': 51366533254873088,
                                             'ul_rf_packets_dropped': 0,
                                             'ul_rssi': -54.0,
                                             'ul_snr': 36.0},
                '00:04:56:20:c9:2a': {       'alt_macs': {'00:04:56:20:c9:29'},
                                             'dev_macs': {'b8:69:f4:ad:18:fb'},
                                             'dl_link_rate': 202500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -86.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': 113577888996917248,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 31.0,
                                             'ip_address': '10.7.0.7',
                                             'mac_address': '00:04:56:20:c9:2a',
                                             'name': 'Joseph A Vest - 449',
                                             'rf_packets_retransmitted': 5518951370981376,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -88.0,
                                             'ul_rf_bytes': 4361308971466752000,
                                             'ul_rf_packets': 45420047954345984,
                                             'ul_rf_packets_dropped': 4294967296,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 38.0},
                '00:04:56:20:c9:39': {       'alt_macs': {'00:04:56:20:c9:38'},
                                             'dev_macs': {'f0:99:bf:03:7b:a8'},
                                             'dl_link_rate': 202500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -86.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': 211115144590131200,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': -57.0,
                                             'dl_snr': 29.0,
                                             'ip_address': '0.0.0.0',
                                             'mac_address': '00:04:56:20:c9:39',
                                             'name': '',
                                             'rf_packets_retransmitted': 14119236834164736,
                                             'ul_link_rate': 89660000,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': 68576046303150080,
                                             'ul_rf_packets_dropped': 4294967296,
                                             'ul_rssi': -51.0,
                                             'ul_snr': 39.0},
                '00:04:56:20:e0:a1': {       'alt_macs': {'00:04:56:20:e0:a0'},
                                             'dev_macs': {'b8:69:f4:ac:f6:79'},
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -85.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': 125789945603293184,
                                             'dl_rf_packets_dropped': 257698037760,
                                             'dl_rssi': -41.0,
                                             'dl_snr': 44.0,
                                             'ip_address': '10.7.0.8',
                                             'mac_address': '00:04:56:20:e0:a1',
                                             'name': 'Abe T Harms - 497',
                                             'rf_packets_retransmitted': 9508658161385472,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -88.0,
                                             'ul_rf_bytes': 5524795210858496000,
                                             'ul_rf_packets': 55413955815800832,
                                             'ul_rf_packets_dropped': 12884901888,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 38.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 27.1,
                                'elevation': 1037.5,
                                'errors': [{'bad_firmware': {'code': 'BF1005'}}],
                                'gps_sats_tracked': 18,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '10',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '35461227',
                                                              'in_octets': '1565459425059',
                                                              'in_ucast_pkts': '1163690715',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:04:56:21:36:97',
                                                              'mtu': 1700,
                                                              'name': 'LAN interface 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '180514',
                                                              'out_octets': '70846709240',
                                                              'out_ucast_pkts': '471640996',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '112',
                                                              'in_nucast_pkts': '72460',
                                                              'in_octets': '64382079859',
                                                              'in_ucast_pkts': '470488033',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       'b8:69:f4:ac:df:c4'],
                                                                                       'in_octets': '6806737185144832000',
                                                                                       'in_ucast_pkts': '51366533254873088',
                                                                                       'mac_address': '00:04:56:20:c2:01',
                                                                                       'out_discards': '1486058684416',
                                                                                       'out_retransmits': '12889329999282176',
                                                                                       'out_ucast_pkts': '110264106979688448'},
                                                                               {       'bridged_mac_addresses': [       'f0:99:bf:03:7b:a8'],
                                                                                       'in_discards': '4294967296',
                                                                                       'in_ucast_pkts': '68576046303150080',
                                                                                       'mac_address': '00:04:56:20:c9:39',
                                                                                       'out_retransmits': '14119236834164736',
                                                                                       'out_ucast_pkts': '211115144590131200'},
                                                                               {       'bridged_mac_addresses': [       '10:da:43:77:c6:8f'],
                                                                                       'in_discards': '21474836480',
                                                                                       'in_ucast_pkts': '94294697018654720',
                                                                                       'mac_address': '00:04:56:20:b6:25',
                                                                                       'out_discards': '700079669248',
                                                                                       'out_retransmits': '22316735969361920',
                                                                                       'out_ucast_pkts': '177860548552032256'},
                                                                               {       'bridged_mac_addresses': [       'c0:56:27:92:38:03'],
                                                                                       'in_octets': '2841358700118016000',
                                                                                       'in_ucast_pkts': '33249884458975232',
                                                                                       'mac_address': '00:04:56:20:b7:1e',
                                                                                       'out_retransmits': '511101108224',
                                                                                       'out_ucast_pkts': '77591869852221440'},
                                                                               {       'bridged_mac_addresses': [       'b8:69:f4:ac:f6:79'],
                                                                                       'in_discards': '12884901888',
                                                                                       'in_octets': '5524795210858496000',
                                                                                       'in_ucast_pkts': '55413955815800832',
                                                                                       'mac_address': '00:04:56:20:e0:a1',
                                                                                       'out_discards': '257698037760',
                                                                                       'out_retransmits': '9508658161385472',
                                                                                       'out_ucast_pkts': '125789945603293184'},
                                                                               {       'bridged_mac_addresses': [       '20:4e:7f:8a:31:3d'],
                                                                                       'in_discards': '8589934592',
                                                                                       'in_octets': '2386586624851968000',
                                                                                       'in_ucast_pkts': '12812179501744128',
                                                                                       'mac_address': '00:04:56:20:b4:87',
                                                                                       'out_discards': '4294967296',
                                                                                       'out_retransmits': '3280135243431936',
                                                                                       'out_ucast_pkts': '37339968930054144'},
                                                                               {       'bridged_mac_addresses': [       'b8:69:f4:ad:18:fb'],
                                                                                       'in_discards': '4294967296',
                                                                                       'in_octets': '4361308971466752000',
                                                                                       'in_ucast_pkts': '45420047954345984',
                                                                                       'mac_address': '00:04:56:20:c9:2a',
                                                                                       'out_retransmits': '5518951370981376',
                                                                                       'out_ucast_pkts': '113577888996917248'},
                                                                               {       'bridged_mac_addresses': [       'd8:0d:17:bf:50:50'],
                                                                                       'in_octets': '2824593832148992000',
                                                                                       'in_ucast_pkts': '7183569025761280',
                                                                                       'mac_address': '00:04:56:20:bb:92',
                                                                                       'out_discards': '154618822656',
                                                                                       'out_retransmits': '680069416615936',
                                                                                       'out_ucast_pkts': '11799636666744832'}],
                                                              'mac_address': '00:04:56:21:36:98',
                                                              'mtu': 1708,
                                                              'name': 'WLAN interface',
                                                              'oper_up': True,
                                                              'out_discards': '24628',
                                                              'out_errors': '3180',
                                                              'out_nucast_pkts': '35665663',
                                                              'out_octets': '1668692118667',
                                                              'out_ucast_pkts': '1250309448',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5190,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '267198',
                                                                                                                                            'distance': 899,
                                                                                                                                            'mac_address': '00:04:56:20:c2:01',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -54.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '121500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '267189',
                                                                                                                                            'distance': 749,
                                                                                                                                            'mac_address': '00:04:56:20:c9:39',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'rx_link_rate': '89660000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 39.0,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '267180',
                                                                                                                                            'distance': 449,
                                                                                                                                            'mac_address': '00:04:56:20:b6:25',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -52.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '260461',
                                                                                                                                            'distance': 149,
                                                                                                                                            'mac_address': '00:04:56:20:b7:1e',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 37.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '253830',
                                                                                                                                            'distance': 299,
                                                                                                                                            'mac_address': '00:04:56:20:e0:a1',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 38.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '241385',
                                                                                                                                            'distance': 599,
                                                                                                                                            'mac_address': '00:04:56:20:b4:87',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '89660000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 39.0,
                                                                                                                                            'tx_link_rate': '182250000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '125352',
                                                                                                                                            'distance': 1049,
                                                                                                                                            'mac_address': '00:04:56:20:c9:2a',
                                                                                                                                            'noise_floor': -88.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 38.0,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '59879',
                                                                                                                                            'distance': 449,
                                                                                                                                            'mac_address': '00:04:56:20:bb:92',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7}],
                                                                                                                   'noise_floor': -87.0}],
                                                                                        'tx_power': 19}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Tx7'}],
                                                              'speed': '220000000',
                                                              'type': 71}],
                                'latitude': 32.763828,
                                'longitude': -102.579834,
                                'manufacturer': 'Cambium',
                                'model': 'ePMP 3000',
                                'serial_number': '000456213697',
                                'sw_version': '4.3.1',
                                'system_mac_address': '00:04:56:21:36:97',
                                'uptime': '1635785'},
                'peers': [       {       'interfaces': [       {       'id': '2',
                                                                       'in_ucast_pkts': '110264106979688448',
                                                                       'links': [       {       'in_ucast_pkts': '110264106979688448',
                                                                                                'mac_address': '00:04:56:21:36:98',
                                                                                                'out_octets': '6806737185144832000',
                                                                                                'out_ucast_pkts': '51366533254873088'}],
                                                                       'mac_address': '00:04:56:20:c2:01',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '6806737185144832000',
                                                                       'out_ucast_pkts': '51366533254873088',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '121500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '267198',
                                                                                                                                                     'distance': 899,
                                                                                                                                                     'mac_address': '00:04:56:21:36:98',
                                                                                                                                                     'noise_floor': -85.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '121500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx7'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '6806737185144832000',
                                                                       'in_ucast_pkts': '51366533254873088',
                                                                       'mac_address': '00:04:56:20:c2:00',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_ucast_pkts': '110264106979688448',
                                                                       'poller_hash': 'MDAwNDU2MjBjMjAxTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '0.0.0.0',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': '',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:c2:00'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_ucast_pkts': '211115144590131200',
                                                                       'links': [       {       'in_ucast_pkts': '211115144590131200',
                                                                                                'mac_address': '00:04:56:21:36:98',
                                                                                                'out_ucast_pkts': '68576046303150080'}],
                                                                       'mac_address': '00:04:56:20:c9:39',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_ucast_pkts': '68576046303150080',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '267189',
                                                                                                                                                     'distance': 749,
                                                                                                                                                     'mac_address': '00:04:56:21:36:98',
                                                                                                                                                     'noise_floor': -86.0,
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '89660000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '89660000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx7'}]},
                                                               {       'id': '1',
                                                                       'in_ucast_pkts': '68576046303150080',
                                                                       'mac_address': '00:04:56:20:c9:38',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_ucast_pkts': '211115144590131200',
                                                                       'poller_hash': 'MDAwNDU2MjBjOTM5TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '0.0.0.0',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': '',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:c9:38'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_ucast_pkts': '177860548552032256',
                                                                       'links': [       {       'in_ucast_pkts': '177860548552032256',
                                                                                                'mac_address': '00:04:56:21:36:98',
                                                                                                'out_ucast_pkts': '94294697018654720'}],
                                                                       'mac_address': '00:04:56:20:b6:25',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_ucast_pkts': '94294697018654720',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '267180',
                                                                                                                                                     'distance': 449,
                                                                                                                                                     'mac_address': '00:04:56:21:36:98',
                                                                                                                                                     'noise_floor': -86.0,
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'snr': 37.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx7'}]},
                                                               {       'id': '1',
                                                                       'in_ucast_pkts': '94294697018654720',
                                                                       'mac_address': '00:04:56:20:b6:24',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_ucast_pkts': '177860548552032256',
                                                                       'poller_hash': 'MDAwNDU2MjBiNjI1TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '0.0.0.0',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': '',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:b6:24'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_ucast_pkts': '77591869852221440',
                                                                       'links': [       {       'in_ucast_pkts': '77591869852221440',
                                                                                                'mac_address': '00:04:56:21:36:98',
                                                                                                'out_octets': '2841358700118016000',
                                                                                                'out_ucast_pkts': '33249884458975232'}],
                                                                       'mac_address': '00:04:56:20:b7:1e',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '2841358700118016000',
                                                                       'out_ucast_pkts': '33249884458975232',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '260461',
                                                                                                                                                     'distance': 149,
                                                                                                                                                     'mac_address': '00:04:56:21:36:98',
                                                                                                                                                     'noise_floor': -85.0,
                                                                                                                                                     'rssi': -37.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 48.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx7'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2841358700118016000',
                                                                       'in_ucast_pkts': '33249884458975232',
                                                                       'mac_address': '00:04:56:20:b7:1d',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_ucast_pkts': '77591869852221440',
                                                                       'poller_hash': 'MDAwNDU2MjBiNzFlTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '0.0.0.0',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': '',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:b7:1d'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_ucast_pkts': '125789945603293184',
                                                                       'links': [       {       'in_ucast_pkts': '125789945603293184',
                                                                                                'mac_address': '00:04:56:21:36:98',
                                                                                                'out_octets': '5524795210858496000',
                                                                                                'out_ucast_pkts': '55413955815800832'}],
                                                                       'mac_address': '00:04:56:20:e0:a1',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '5524795210858496000',
                                                                       'out_ucast_pkts': '55413955815800832',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '253830',
                                                                                                                                                     'distance': 299,
                                                                                                                                                     'mac_address': '00:04:56:21:36:98',
                                                                                                                                                     'noise_floor': -85.0,
                                                                                                                                                     'rssi': -41.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 44.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx7'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '5524795210858496000',
                                                                       'in_ucast_pkts': '55413955815800832',
                                                                       'mac_address': '00:04:56:20:e0:a0',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_ucast_pkts': '125789945603293184',
                                                                       'poller_hash': 'MDAwNDU2MjBlMGExTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.7.0.8',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Abe T Harms - 497',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:e0:a0'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_ucast_pkts': '37339968930054144',
                                                                       'links': [       {       'in_ucast_pkts': '37339968930054144',
                                                                                                'mac_address': '00:04:56:21:36:98',
                                                                                                'out_octets': '2386586624851968000',
                                                                                                'out_ucast_pkts': '12812179501744128'}],
                                                                       'mac_address': '00:04:56:20:b4:87',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '2386586624851968000',
                                                                       'out_ucast_pkts': '12812179501744128',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '182250000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '241385',
                                                                                                                                                     'distance': 599,
                                                                                                                                                     'mac_address': '00:04:56:21:36:98',
                                                                                                                                                     'noise_floor': -86.0,
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'rx_link_rate': '182250000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '89660000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '89660000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx7'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2386586624851968000',
                                                                       'in_ucast_pkts': '12812179501744128',
                                                                       'mac_address': '00:04:56:20:b4:86',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_ucast_pkts': '37339968930054144',
                                                                       'poller_hash': 'MDAwNDU2MjBiNDg3TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.7.0.1',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Jake Harms - 45',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:b4:86'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_ucast_pkts': '113577888996917248',
                                                                       'links': [       {       'in_ucast_pkts': '113577888996917248',
                                                                                                'mac_address': '00:04:56:21:36:98',
                                                                                                'out_octets': '4361308971466752000',
                                                                                                'out_ucast_pkts': '45420047954345984'}],
                                                                       'mac_address': '00:04:56:20:c9:2a',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '4361308971466752000',
                                                                       'out_ucast_pkts': '45420047954345984',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '125352',
                                                                                                                                                     'distance': 1049,
                                                                                                                                                     'mac_address': '00:04:56:21:36:98',
                                                                                                                                                     'noise_floor': -86.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx7'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '4361308971466752000',
                                                                       'in_ucast_pkts': '45420047954345984',
                                                                       'mac_address': '00:04:56:20:c9:29',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_ucast_pkts': '113577888996917248',
                                                                       'poller_hash': 'MDAwNDU2MjBjOTJhTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.7.0.7',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Joseph A Vest - 449',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:c9:29'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_ucast_pkts': '11799636666744832',
                                                                       'links': [       {       'in_ucast_pkts': '11799636666744832',
                                                                                                'mac_address': '00:04:56:21:36:98',
                                                                                                'out_octets': '2824593832148992000',
                                                                                                'out_ucast_pkts': '7183569025761280'}],
                                                                       'mac_address': '00:04:56:20:bb:92',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '2824593832148992000',
                                                                       'out_ucast_pkts': '7183569025761280',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5190,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '59879',
                                                                                                                                                     'distance': 449,
                                                                                                                                                     'mac_address': '00:04:56:21:36:98',
                                                                                                                                                     'noise_floor': -86.0,
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 33.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx7'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2824593832148992000',
                                                                       'in_ucast_pkts': '7183569025761280',
                                                                       'mac_address': '00:04:56:20:bb:91',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_ucast_pkts': '11799636666744832',
                                                                       'poller_hash': 'MDAwNDU2MjBiYjkyTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.7.0.3',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Abe Schmitt - 234',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:bb:91'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_cambium_epmp_epmp3000_ePMP_3000_4_3_2_01(self):
        obj = self.run_data("cambium-epmp.epmp3000.ePMP 3000.4.3.2.01")
        exp_info = {
                'framing': 'FIXED',
                'model': 'ePMP 3000',
                'rf_chan_width': 20,
                'rf_dl_percent': 50,
                'rf_freq': 5180,
                'rf_tx_power': 29,
                'sta_count': 1,
                'sta_mode_cpe': False,
                'sw_version': '4.3.2',
                'vendor': 'Cambium'
        }
        exp_stats = {
                'cpu': 15.7,
                'dl_en_bytes': 174097990,
                'dl_en_packets': 2844456,
                'dl_en_packets_dropped': 0,
                'dl_frutl': None,
                'dl_noise_floor': None,
                'dl_rf_bytes': 127749500,
                'dl_rf_packets': 2790220,
                'dl_rf_packets_dropped': 206,
                'en_if_speed': 1000000000,
                'rf_packets_retransmitted': 1273,
                'ul_en_bytes': 12195268,
                'ul_en_packets': 132312,
                'ul_en_packets_dropped': 0,
                'ul_frutl': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': 4036000,
                'ul_rf_packets': 65853,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
                '00:04:56:20:c0:c9': {       'alt_macs': {'00:04:56:20:c0:c8'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 86500000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -45.0,
                                             'dl_snr': 47.0,
                                             'ip_address': '10.117.66.2',
                                             'mac_address': '00:04:56:20:c0:c9',
                                             'name': 'CFCU( Main Branch)',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 31.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 15.7,
                                'elevation': 722.3,
                                'gps_sats_tracked': 19,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '11',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '2734027',
                                                              'in_octets': '173984340',
                                                              'in_ucast_pkts': '2843009',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:04:56:21:2f:bf',
                                                              'mtu': 1538,
                                                              'name': 'LAN interface 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '11674',
                                                              'out_octets': '12110227',
                                                              'out_ucast_pkts': '131407',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '2366',
                                                              'in_octets': '4132516',
                                                              'in_ucast_pkts': '65846',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:04:56:20:c0:c9'}],
                                                              'mac_address': '00:04:56:21:2f:c0',
                                                              'mtu': 1546,
                                                              'name': 'WLAN interface',
                                                              'oper_up': True,
                                                              'out_discards': '204',
                                                              'out_errors': '2',
                                                              'out_nucast_pkts': '2736144',
                                                              'out_octets': '130805519',
                                                              'out_ucast_pkts': '2790005',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 50,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5180,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '141869',
                                                                                                                                            'distance': 299,
                                                                                                                                            'mac_address': '00:04:56:20:c0:c9',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '86500000',
                                                                                                                                            'tx_mcs': 9}],
                                                                                                                   'noise_floor': -92.0}],
                                                                                        'tx_power': 29}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'FSTC000C5_2'}],
                                                              'speed': '110000000',
                                                              'type': 71}],
                                'latitude': 47.486771,
                                'longitude': -117.57589,
                                'manufacturer': 'Cambium',
                                'model': 'ePMP 3000',
                                'serial_number': '000456212FBF',
                                'sw_version': '4.3.2',
                                'system_mac_address': '00:04:56:21:2f:bf',
                                'uptime': '141921'},
                'peers': [       {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:2f:c0'}],
                                                                       'mac_address': '00:04:56:20:c0:c9',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 50,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5180,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '86500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '141869',
                                                                                                                                                     'distance': 299,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:c0',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -45.0,
                                                                                                                                                     'rx_link_rate': '86500000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 47.0,
                                                                                                                                                     'tx_link_rate': '32377222',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '32377222'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'FSTC000C5_2'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:20:c0:c8',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MjBjMGM5TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.117.66.2',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'CFCU( Main Branch)',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:c0:c8'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_cambium_epmp_epmp3000_ePMP_3000_4_3_2_1_01(self):
        obj = self.run_data("cambium-epmp.epmp3000.ePMP 3000.4.3.2.1.01")
        exp_info = {
                'framing': 'FIXED',
                'model': 'ePMP 3000',
                'rf_chan_width': 20,
                'rf_dl_percent': 50,
                'rf_freq': 5240,
                'rf_tx_power': 17,
                'sta_count': 0,
                'sta_mode_cpe': False,
                'sw_version': '4.3.2.1',
                'vendor': 'Cambium'
        }
        exp_stats = {
                'cpu': 27.6,
                'dl_en_bytes': 625943195,
                'dl_en_packets': 9823075,
                'dl_en_packets_dropped': 0,
                'dl_frutl': None,
                'dl_noise_floor': None,
                'dl_rf_bytes': 417416375,
                'dl_rf_packets': 8743157,
                'dl_rf_packets_dropped': 941814,
                'en_if_speed': 1000000000,
                'rf_packets_retransmitted': 1169,
                'ul_en_bytes': 44256022,
                'ul_en_packets': 293415,
                'ul_en_packets_dropped': 0,
                'ul_frutl': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': 22534625,
                'ul_rf_packets': 108005,
                'ul_rf_packets_dropped': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 27.6,
                                'elevation': 1129.8,
                                'gps_sats_tracked': 21,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '11',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '9572994',
                                                              'in_octets': '625846133',
                                                              'in_ucast_pkts': '9821889',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:04:56:21:31:23',
                                                              'mtu': 1538,
                                                              'name': 'LAN interface 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '35140',
                                                              'out_octets': '44176782',
                                                              'out_ucast_pkts': '292563',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '228',
                                                              'in_octets': '23075364',
                                                              'in_ucast_pkts': '108003',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:04:56:21:31:24',
                                                              'mtu': 1546,
                                                              'name': 'WLAN interface',
                                                              'oper_up': True,
                                                              'out_discards': '941810',
                                                              'out_errors': '4',
                                                              'out_nucast_pkts': '8641319',
                                                              'out_octets': '427428527',
                                                              'out_ucast_pkts': '8743036',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 50,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5240,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}],
                                                                                        'tx_power': 17}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'NKAT250C5_4'}],
                                                              'speed': '110000000',
                                                              'type': 71}],
                                'latitude': 47.592907,
                                'longitude': -117.29879,
                                'manufacturer': 'Cambium',
                                'model': 'ePMP 3000',
                                'serial_number': '000456213123',
                                'sw_version': '4.3.2.1',
                                'system_mac_address': '00:04:56:21:31:23',
                                'uptime': '523805'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_cambium_epmp_epmp3000_ePMP_3000_4_4_01(self):
        obj = self.run_data("cambium-epmp.epmp3000.ePMP 3000.4.4.01")
        exp_info = {
                'framing': 'FIXED',
                'model': 'ePMP 3000',
                'rf_chan_width': 40,
                'rf_dl_percent': 75,
                'rf_freq': 5230,
                'rf_tx_power': 21,
                'sta_count': 52,
                'sta_mode_cpe': False,
                'sw_version': '4.4',
                'vendor': 'Cambium'
        }
        exp_stats = {
                'cpu': 24.7,
                'dl_en_bytes': 1209771936841,
                'dl_en_packets': 939161446,
                'dl_en_packets_dropped': 0,
                'dl_frutl': 24.58,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1358407072375,
                'dl_rf_packets': 1059506396,
                'dl_rf_packets_dropped': 1013805,
                'en_if_speed': 1000000000,
                'rf_packets_retransmitted': 105711361,
                'ul_en_bytes': 104400069836,
                'ul_en_packets': 529978135,
                'ul_en_packets_dropped': 0,
                'ul_frutl': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': 97225627250,
                'ul_rf_packets': 538497284,
                'ul_rf_packets_dropped': 82290
        }
        exp_sta_stats = {
                '00:04:56:28:66:12': {       'alt_macs': {'00:04:56:28:66:11'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 30.0,
                                             'ip_address': '10.100.5.24',
                                             'mac_address': '00:04:56:28:66:12',
                                             'name': 'Minton',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 40347000,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:66:2a': {       'alt_macs': {'00:04:56:28:66:29'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 202500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -62.0,
                                             'dl_snr': 27.0,
                                             'ip_address': '10.100.5.54',
                                             'mac_address': '00:04:56:28:66:2a',
                                             'name': 'Lisa Scholzen',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 89660000,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:69:18': {       'alt_macs': {'00:04:56:28:69:17'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 33.0,
                                             'ip_address': '10.100.5.162',
                                             'mac_address': '00:04:56:28:69:18',
                                             'name': 'Yorkville United Methodist Churc',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 6724500,
                                             'ul_mcs': 1,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:69:fc': {       'alt_macs': {'00:04:56:28:69:fb'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -54.0,
                                             'dl_snr': 36.0,
                                             'ip_address': '10.100.5.51',
                                             'mac_address': '00:04:56:28:69:fc',
                                             'name': 'Racine Atronomical Society',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 60520500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 32.0},
                '00:04:56:28:6e:37': {       'alt_macs': {'00:04:56:28:6e:36'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 30.0,
                                             'ip_address': '10.100.5.106',
                                             'mac_address': '00:04:56:28:6e:37',
                                             'name': 'Andrew Szabo',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 35.0},
                '00:04:56:28:6e:43': {       'alt_macs': {'00:04:56:28:6e:42'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -53.0,
                                             'dl_snr': 36.0,
                                             'ip_address': '10.100.5.161',
                                             'mac_address': '00:04:56:28:6e:43',
                                             'name': 'Michael Knight',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:71:3d': {       'alt_macs': {'00:04:56:28:71:3c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -65.0,
                                             'dl_snr': 24.0,
                                             'ip_address': '10.100.5.184',
                                             'mac_address': '00:04:56:28:71:3d',
                                             'name': 'Amanda Williamson',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 40347000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:71:b2': {       'alt_macs': {'00:04:56:28:71:b1'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -49.0,
                                             'dl_snr': 40.0,
                                             'ip_address': '10.100.5.157',
                                             'mac_address': '00:04:56:28:71:b2',
                                             'name': 'Kurt Lekschas',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 33622500,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:72:96': {       'alt_macs': {'00:04:56:28:72:95'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 202500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -63.0,
                                             'dl_snr': 27.0,
                                             'ip_address': '10.100.5.89',
                                             'mac_address': '00:04:56:28:72:96',
                                             'name': 'Dave and Shelley Rogers',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:73:71': {       'alt_macs': {'00:04:56:28:73:70'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -87.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 28.0,
                                             'ip_address': '10.100.5.117',
                                             'mac_address': '00:04:56:28:73:71',
                                             'name': 'Kara Vyvyan',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 53796000,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:73:74': {       'alt_macs': {'00:04:56:28:73:73'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 29.0,
                                             'ip_address': '10.100.5.27',
                                             'mac_address': '00:04:56:28:73:74',
                                             'name': 'Anthony Fox',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -55.0,
                                             'ul_snr': 35.0},
                '00:04:56:28:73:83': {       'alt_macs': {'00:04:56:28:73:82'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 202500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -87.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -63.0,
                                             'dl_snr': 24.0,
                                             'ip_address': '10.100.5.57',
                                             'mac_address': '00:04:56:28:73:83',
                                             'name': 'Shane Deschler',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 89660000,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:73:a1': {       'alt_macs': {'00:04:56:28:73:a0'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -62.0,
                                             'dl_snr': 27.0,
                                             'ip_address': '10.100.5.142',
                                             'mac_address': '00:04:56:28:73:a1',
                                             'name': 'Tom Lauber',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:73:a7': {       'alt_macs': {'00:04:56:28:73:a6'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -87.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 28.0,
                                             'ip_address': '10.100.5.31',
                                             'mac_address': '00:04:56:28:73:a7',
                                             'name': 'Daniel Peterson',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 89660000,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:73:ad': {       'alt_macs': {'00:04:56:28:73:ac'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 29.0,
                                             'ip_address': '10.100.5.186',
                                             'mac_address': '00:04:56:28:73:ad',
                                             'name': 'Gilbert Nilsen',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:74:c7': {       'alt_macs': {'00:04:56:28:74:c6'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 60750000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -64.0,
                                             'dl_snr': 24.0,
                                             'ip_address': '10.100.5.69',
                                             'mac_address': '00:04:56:28:74:c7',
                                             'name': 'Glodowski',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 40347000,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -65.0,
                                             'ul_snr': 25.0},
                '00:04:56:28:77:2b': {       'alt_macs': {'00:04:56:28:77:2a'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -50.0,
                                             'dl_snr': 39.0,
                                             'ip_address': '10.100.5.156',
                                             'mac_address': '00:04:56:28:77:2b',
                                             'name': 'Justin Skewes',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:77:2e': {       'alt_macs': {'00:04:56:28:77:2d'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -91.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -51.0,
                                             'dl_snr': 40.0,
                                             'ip_address': '10.100.5.43',
                                             'mac_address': '00:04:56:28:77:2e',
                                             'name': 'David Rowntree',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 33622500,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:78:21': {       'alt_macs': {'00:04:56:28:78:20'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 162000000,
                                             'dl_mcs': 5,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -69.0,
                                             'dl_snr': 20.0,
                                             'ip_address': '10.100.5.30',
                                             'mac_address': '00:04:56:28:78:21',
                                             'name': 'Jamey Shiels',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 53796000,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 30.0},
                '00:04:56:28:78:ff': {       'alt_macs': {'00:04:56:28:78:fe'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 182250000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -64.0,
                                             'dl_snr': 25.0,
                                             'ip_address': '10.100.5.176',
                                             'mac_address': '00:04:56:28:78:ff',
                                             'name': 'Jody Halladay',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:79:4d': {       'alt_macs': {'00:04:56:28:79:4c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -58.0,
                                             'dl_snr': 32.0,
                                             'ip_address': '10.100.5.160',
                                             'mac_address': '00:04:56:28:79:4d',
                                             'name': 'David V. Anderson',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:79:5f': {       'alt_macs': {'00:04:56:28:79:5e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 182250000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -63.0,
                                             'dl_snr': 25.0,
                                             'ip_address': '10.100.5.148',
                                             'mac_address': '00:04:56:28:79:5f',
                                             'name': 'Bruce Beth',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:7a:85': {       'alt_macs': {'00:04:56:28:7a:84'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 121500000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -70.0,
                                             'dl_snr': 18.0,
                                             'ip_address': '10.100.5.129',
                                             'mac_address': '00:04:56:28:7a:85',
                                             'name': 'William and Karen Jackowski',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 33622500,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 29.0},
                '00:04:56:28:7a:a0': {       'alt_macs': {'00:04:56:28:7a:9f'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 162000000,
                                             'dl_mcs': 5,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -64.0,
                                             'dl_snr': 24.0,
                                             'ip_address': '10.100.5.101',
                                             'mac_address': '00:04:56:28:7a:a0',
                                             'name': 'Jennifer Ably',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 60520500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:7b:9c': {       'alt_macs': {'00:04:56:28:7b:9b'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -61.0,
                                             'dl_snr': 29.0,
                                             'ip_address': '10.100.5.73',
                                             'mac_address': '00:04:56:28:7b:9c',
                                             'name': 'Scott Smith',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 13449000,
                                             'ul_mcs': 3,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:7c:9e': {       'alt_macs': {'00:04:56:28:7c:9d'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 202500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -64.0,
                                             'dl_snr': 26.0,
                                             'ip_address': '10.100.5.71',
                                             'mac_address': '00:04:56:28:7c:9e',
                                             'name': 'Jill Helm',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 20173500,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:7c:e3': {       'alt_macs': {'00:04:56:28:7c:e2'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -52.0,
                                             'dl_snr': 36.0,
                                             'ip_address': '10.100.5.75',
                                             'mac_address': '00:04:56:28:7c:e3',
                                             'name': 'Peter Braun',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 89660000,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -55.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:7c:f2': {       'alt_macs': {'00:04:56:28:7c:f1'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -54.0,
                                             'dl_snr': 35.0,
                                             'ip_address': '10.100.5.48',
                                             'mac_address': '00:04:56:28:7c:f2',
                                             'name': 'Carol Wennerstrand',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:7d:64': {       'alt_macs': {'00:04:56:28:7d:63'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 202500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -62.0,
                                             'dl_snr': 26.0,
                                             'ip_address': '10.100.5.150',
                                             'mac_address': '00:04:56:28:7d:64',
                                             'name': 'Anne Wendorf',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 53796000,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:7f:29': {       'alt_macs': {'00:04:56:28:7f:28'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -60.0,
                                             'dl_snr': 29.0,
                                             'ip_address': '10.100.5.35',
                                             'mac_address': '00:04:56:28:7f:29',
                                             'name': 'Todd Graf',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -55.0,
                                             'ul_snr': 35.0},
                '00:04:56:28:7f:38': {       'alt_macs': {'00:04:56:28:7f:37'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 29.0,
                                             'ip_address': '10.100.5.172',
                                             'mac_address': '00:04:56:28:7f:38',
                                             'name': 'Autumn Russell',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:7f:59': {       'alt_macs': {'00:04:56:28:7f:58'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 35.0,
                                             'ip_address': '10.100.5.122',
                                             'mac_address': '00:04:56:28:7f:59',
                                             'name': 'Kaitlin Zarletti Vaughn',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:7f:c8': {       'alt_macs': {'00:04:56:28:7f:c7'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 182250000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -63.0,
                                             'dl_snr': 25.0,
                                             'ip_address': '10.100.5.34',
                                             'mac_address': '00:04:56:28:7f:c8',
                                             'name': 'Marc DeJarlais',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 40347000,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 31.0},
                '00:04:56:28:80:7c': {       'alt_macs': {'00:04:56:28:80:7b'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -58.0,
                                             'dl_snr': 31.0,
                                             'ip_address': '10.100.5.97',
                                             'mac_address': '00:04:56:28:80:7c',
                                             'name': 'Thomas Blodgett',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 60520500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 33.0},
                '00:04:56:28:80:c4': {       'alt_macs': {'00:04:56:28:80:c3'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -58.0,
                                             'dl_snr': 30.0,
                                             'ip_address': '10.100.5.45',
                                             'mac_address': '00:04:56:28:80:c4',
                                             'name': 'Jamie Anderson',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:81:48': {       'alt_macs': {'00:04:56:28:81:47'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 182250000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -62.0,
                                             'dl_snr': 28.0,
                                             'ip_address': '10.100.5.99',
                                             'mac_address': '00:04:56:28:81:48',
                                             'name': 'Jeffrey Coopman',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 60520500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:28:81:93': {       'alt_macs': {'00:04:56:28:81:92'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -53.0,
                                             'dl_snr': 35.0,
                                             'ip_address': '10.100.5.179',
                                             'mac_address': '00:04:56:28:81:93',
                                             'name': 'Amanda Prince',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 34.0},
                '00:04:56:29:09:a5': {       'alt_macs': {'00:04:56:29:09:a4'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 162000000,
                                             'dl_mcs': 5,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -62.0,
                                             'dl_snr': 27.0,
                                             'ip_address': '10.100.5.100',
                                             'mac_address': '00:04:56:29:09:a5',
                                             'name': 'Aspen property care',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 40347000,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:29:0c:78': {       'alt_macs': {'00:04:56:29:0c:77'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -61.0,
                                             'dl_snr': 27.0,
                                             'ip_address': '10.100.5.240',
                                             'mac_address': '00:04:56:29:0c:78',
                                             'name': 'Skewes',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 32.0},
                '00:04:56:29:0e:af': {       'alt_macs': {'00:04:56:29:0e:ae'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 121500000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -63.0,
                                             'dl_snr': 26.0,
                                             'ip_address': '10.100.5.244',
                                             'mac_address': '00:04:56:29:0e:af',
                                             'name': 'Dave moyer ',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 6724500,
                                             'ul_mcs': 1,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:2a:63:f2': {       'alt_macs': {'00:04:56:2a:63:f1'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 202500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 31.0,
                                             'ip_address': '10.100.5.149',
                                             'mac_address': '00:04:56:2a:63:f2',
                                             'name': 'Ellen Jante',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 53796000,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 33.0},
                '00:04:56:2a:64:04': {       'alt_macs': {'00:04:56:2a:64:03'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -61.0,
                                             'dl_snr': 29.0,
                                             'ip_address': '10.100.5.88',
                                             'mac_address': '00:04:56:2a:64:04',
                                             'name': 'Julie Lauber',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 53796000,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:2a:64:0d': {       'alt_macs': {'00:04:56:2a:64:0c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -47.0,
                                             'dl_snr': 43.0,
                                             'ip_address': '10.100.5.141',
                                             'mac_address': '00:04:56:2a:64:0d',
                                             'name': 'Karen Peterson',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 60520500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:2a:64:2e': {       'alt_macs': {'00:04:56:2a:64:2d'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 162000000,
                                             'dl_mcs': 5,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -63.0,
                                             'dl_snr': 26.0,
                                             'ip_address': '10.100.5.170',
                                             'mac_address': '00:04:56:2a:64:2e',
                                             'name': 'Dan Ramon',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -58.0,
                                             'ul_snr': 32.0},
                '00:04:56:2a:64:a3': {       'alt_macs': {'00:04:56:2a:64:a2'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 243000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -60.0,
                                             'dl_snr': 30.0,
                                             'ip_address': '10.100.5.22',
                                             'mac_address': '00:04:56:2a:64:a3',
                                             'name': 'Lindsey Rank',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 67245000,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:2a:64:b8': {       'alt_macs': {'00:04:56:2a:64:b7'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 162000000,
                                             'dl_mcs': 5,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -64.0,
                                             'dl_snr': 25.0,
                                             'ip_address': '10.100.5.81',
                                             'mac_address': '00:04:56:2a:64:b8',
                                             'name': 'Jim May',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 44830000,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 34.0},
                '00:04:56:2a:66:02': {       'alt_macs': {'00:04:56:2a:66:01'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 35.0,
                                             'ip_address': '10.100.5.185',
                                             'mac_address': '00:04:56:2a:66:02',
                                             'name': 'Peter Falk',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 60520500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 33.0},
                '00:04:56:2a:6a:10': {       'alt_macs': {'00:04:56:2a:6a:0f'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 81000000,
                                             'dl_mcs': 3,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -77.0,
                                             'dl_snr': 12.0,
                                             'ip_address': '10.100.5.38',
                                             'mac_address': '00:04:56:2a:6a:10',
                                             'name': 'Jennifer Herndon',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 13449000,
                                             'ul_mcs': 3,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 23.0},
                '00:04:56:2a:6d:61': {       'alt_macs': {'00:04:56:2a:6d:60'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -89.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -51.0,
                                             'dl_snr': 38.0,
                                             'ip_address': '10.100.5.36',
                                             'mac_address': '00:04:56:2a:6d:61',
                                             'name': 'Sean Mulligan',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 89660000,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 33.0},
                '00:04:56:2a:6e:2d': {       'alt_macs': {'00:04:56:2a:6e:2c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -57.0,
                                             'dl_snr': 31.0,
                                             'ip_address': '10.100.5.191',
                                             'mac_address': '00:04:56:2a:6e:2d',
                                             'name': 'Jane Luedtke',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 33622500,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -89.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 32.0},
                '00:04:56:2a:6e:87': {       'alt_macs': {'00:04:56:2a:6e:86'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 202500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -91.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -65.0,
                                             'dl_snr': 26.0,
                                             'ip_address': '10.100.5.193',
                                             'mac_address': '00:04:56:2a:6e:87',
                                             'name': 'Kevin Moran',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 89660000,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0},
                '00:04:56:2a:d5:f2': {       'alt_macs': {'00:04:56:2a:d5:f1'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 270000000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 31.0,
                                             'ip_address': '10.100.5.104',
                                             'mac_address': '00:04:56:2a:d5:f2',
                                             'name': 'Jean Chambers',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 80694000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -90.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -56.0,
                                             'ul_snr': 34.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 24.7,
                                'elevation': 309.969,
                                'gps_sats_tracked': 18,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '11',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '3151034',
                                                              'in_octets': '1209771936841',
                                                              'in_ucast_pkts': '939095258',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:04:56:20:57:e9',
                                                              'mtu': 1538,
                                                              'name': 'LAN interface 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '681978',
                                                              'out_octets': '104396904734',
                                                              'out_ucast_pkts': '529949424',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '82290',
                                                              'in_nucast_pkts': '4278113',
                                                              'in_octets': '97223840687',
                                                              'in_ucast_pkts': '538477339',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:04:56:2a:64:a3'},
                                                                               {       'mac_address': '00:04:56:28:6e:37'},
                                                                               {       'mac_address': '00:04:56:28:69:18'},
                                                                               {       'mac_address': '00:04:56:28:7a:85'},
                                                                               {       'mac_address': '00:04:56:28:7b:9c'},
                                                                               {       'mac_address': '00:04:56:28:72:96'},
                                                                               {       'mac_address': '00:04:56:28:7a:a0'},
                                                                               {       'mac_address': '00:04:56:28:77:2e'},
                                                                               {       'mac_address': '00:04:56:2a:6e:87'},
                                                                               {       'mac_address': '00:04:56:28:7d:64'},
                                                                               {       'mac_address': '00:04:56:28:73:a1'},
                                                                               {       'mac_address': '00:04:56:28:73:ad'},
                                                                               {       'mac_address': '00:04:56:29:09:a5'},
                                                                               {       'mac_address': '00:04:56:28:7c:e3'},
                                                                               {       'mac_address': '00:04:56:28:81:93'},
                                                                               {       'mac_address': '00:04:56:28:71:3d'},
                                                                               {       'mac_address': '00:04:56:2a:63:f2'},
                                                                               {       'mac_address': '00:04:56:2a:d5:f2'},
                                                                               {       'mac_address': '00:04:56:28:66:12'},
                                                                               {       'mac_address': '00:04:56:29:0c:78'},
                                                                               {       'mac_address': '00:04:56:28:79:4d'},
                                                                               {       'mac_address': '00:04:56:28:78:ff'},
                                                                               {       'mac_address': '00:04:56:28:73:71'},
                                                                               {       'mac_address': '00:04:56:2a:6a:10'},
                                                                               {       'mac_address': '00:04:56:2a:6e:2d'},
                                                                               {       'mac_address': '00:04:56:28:78:21'},
                                                                               {       'mac_address': '00:04:56:2a:64:b8'},
                                                                               {       'mac_address': '00:04:56:28:79:5f'},
                                                                               {       'mac_address': '00:04:56:28:66:2a'},
                                                                               {       'mac_address': '00:04:56:28:7f:c8'},
                                                                               {       'mac_address': '00:04:56:2a:64:04'},
                                                                               {       'mac_address': '00:04:56:28:80:7c'},
                                                                               {       'mac_address': '00:04:56:28:7c:f2'},
                                                                               {       'mac_address': '00:04:56:29:0e:af'},
                                                                               {       'mac_address': '00:04:56:2a:64:0d'},
                                                                               {       'mac_address': '00:04:56:28:77:2b'},
                                                                               {       'mac_address': '00:04:56:28:71:b2'},
                                                                               {       'mac_address': '00:04:56:28:73:83'},
                                                                               {       'mac_address': '00:04:56:28:69:fc'},
                                                                               {       'mac_address': '00:04:56:2a:6d:61'},
                                                                               {       'mac_address': '00:04:56:28:73:74'},
                                                                               {       'mac_address': '00:04:56:2a:64:2e'},
                                                                               {       'mac_address': '00:04:56:2a:66:02'},
                                                                               {       'mac_address': '00:04:56:28:74:c7'},
                                                                               {       'mac_address': '00:04:56:28:7f:38'},
                                                                               {       'mac_address': '00:04:56:28:73:a7'},
                                                                               {       'mac_address': '00:04:56:28:6e:43'},
                                                                               {       'mac_address': '00:04:56:28:7c:9e'},
                                                                               {       'mac_address': '00:04:56:28:7f:59'},
                                                                               {       'mac_address': '00:04:56:28:7f:29'},
                                                                               {       'mac_address': '00:04:56:28:80:c4'},
                                                                               {       'mac_address': '00:04:56:28:81:48'}],
                                                              'mac_address': '00:04:56:20:57:ea',
                                                              'mtu': 1546,
                                                              'name': 'WLAN interface',
                                                              'oper_up': True,
                                                              'out_discards': '66744',
                                                              'out_errors': '947053',
                                                              'out_nucast_pkts': '3155898',
                                                              'out_octets': '1358336594693',
                                                              'out_ucast_pkts': '1059454897',
                                                              'radios': [       {       'chan_width': 40,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5230,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '331868',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'mac_address': '00:04:56:2a:64:a3',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '331861',
                                                                                                                                            'distance': 3447,
                                                                                                                                            'mac_address': '00:04:56:28:6e:37',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '331858',
                                                                                                                                            'distance': 4496,
                                                                                                                                            'mac_address': '00:04:56:28:69:18',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '6724500',
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331856',
                                                                                                                                            'distance': 4197,
                                                                                                                                            'mac_address': '00:04:56:28:7a:85',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '33622500',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 29.0,
                                                                                                                                            'tx_link_rate': '121500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '331856',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'mac_address': '00:04:56:28:7b:9c',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '13449000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '331856',
                                                                                                                                            'distance': 4496,
                                                                                                                                            'mac_address': '00:04:56:28:72:96',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '331855',
                                                                                                                                            'distance': 5995,
                                                                                                                                            'mac_address': '00:04:56:28:7a:a0',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '60520500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '331854',
                                                                                                                                            'distance': 1049,
                                                                                                                                            'mac_address': '00:04:56:28:77:2e',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '33622500',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '331850',
                                                                                                                                            'distance': 5845,
                                                                                                                                            'mac_address': '00:04:56:2a:6e:87',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '89660000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '331850',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'mac_address': '00:04:56:28:7d:64',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '53796000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '331839',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'mac_address': '00:04:56:28:73:a1',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '331867',
                                                                                                                                            'distance': 3147,
                                                                                                                                            'mac_address': '00:04:56:28:73:ad',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331838',
                                                                                                                                            'distance': 4796,
                                                                                                                                            'mac_address': '00:04:56:29:09:a5',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '40347000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '331836',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'mac_address': '00:04:56:28:7c:e3',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '89660000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331835',
                                                                                                                                            'distance': 3297,
                                                                                                                                            'mac_address': '00:04:56:28:81:93',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331826',
                                                                                                                                            'distance': 6595,
                                                                                                                                            'mac_address': '00:04:56:28:71:3d',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '40347000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '331821',
                                                                                                                                            'distance': 3447,
                                                                                                                                            'mac_address': '00:04:56:2a:63:f2',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '53796000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '331816',
                                                                                                                                            'distance': 3297,
                                                                                                                                            'mac_address': '00:04:56:2a:d5:f2',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331810',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'mac_address': '00:04:56:28:66:12',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '40347000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '331803',
                                                                                                                                            'distance': 5845,
                                                                                                                                            'mac_address': '00:04:56:29:0c:78',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '331799',
                                                                                                                                            'distance': 4346,
                                                                                                                                            'mac_address': '00:04:56:28:79:4d',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331795',
                                                                                                                                            'distance': 5845,
                                                                                                                                            'mac_address': '00:04:56:28:78:ff',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '182250000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '331867',
                                                                                                                                            'distance': 5696,
                                                                                                                                            'mac_address': '00:04:56:28:73:71',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '53796000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331376',
                                                                                                                                            'distance': 7494,
                                                                                                                                            'mac_address': '00:04:56:2a:6a:10',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '13449000',
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 23.0,
                                                                                                                                            'tx_link_rate': '81000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'connected_time': '279598',
                                                                                                                                            'distance': 4946,
                                                                                                                                            'mac_address': '00:04:56:2a:6e:2d',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '33622500',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '33837',
                                                                                                                                            'distance': 7644,
                                                                                                                                            'mac_address': '00:04:56:28:78:21',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '53796000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 30.0,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '33824',
                                                                                                                                            'distance': 6145,
                                                                                                                                            'mac_address': '00:04:56:2a:64:b8',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '44830000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '33803',
                                                                                                                                            'distance': 4496,
                                                                                                                                            'mac_address': '00:04:56:28:79:5f',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '182250000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '33330',
                                                                                                                                            'distance': 3297,
                                                                                                                                            'mac_address': '00:04:56:28:66:2a',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '89660000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '33328',
                                                                                                                                            'distance': 4346,
                                                                                                                                            'mac_address': '00:04:56:28:7f:c8',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '40347000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 31.0,
                                                                                                                                            'tx_link_rate': '182250000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '33326',
                                                                                                                                            'distance': 5696,
                                                                                                                                            'mac_address': '00:04:56:2a:64:04',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '53796000',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '33325',
                                                                                                                                            'distance': 3297,
                                                                                                                                            'mac_address': '00:04:56:28:80:7c',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '60520500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '33325',
                                                                                                                                            'distance': 3297,
                                                                                                                                            'mac_address': '00:04:56:28:7c:f2',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331866',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'mac_address': '00:04:56:29:0e:af',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '6724500',
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '121500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '33320',
                                                                                                                                            'distance': 1199,
                                                                                                                                            'mac_address': '00:04:56:2a:64:0d',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '60520500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '33318',
                                                                                                                                            'distance': 2098,
                                                                                                                                            'mac_address': '00:04:56:28:77:2b',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '33314',
                                                                                                                                            'distance': 1199,
                                                                                                                                            'mac_address': '00:04:56:28:71:b2',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '33622500',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '33297',
                                                                                                                                            'distance': 5546,
                                                                                                                                            'mac_address': '00:04:56:28:73:83',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '89660000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '21567',
                                                                                                                                            'distance': 2698,
                                                                                                                                            'mac_address': '00:04:56:28:69:fc',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '60520500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '21012',
                                                                                                                                            'distance': 2248,
                                                                                                                                            'mac_address': '00:04:56:2a:6d:61',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '89660000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '21003',
                                                                                                                                            'distance': 2098,
                                                                                                                                            'mac_address': '00:04:56:28:73:74',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '20997',
                                                                                                                                            'distance': 1948,
                                                                                                                                            'mac_address': '00:04:56:2a:64:2e',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 32.0,
                                                                                                                                            'tx_link_rate': '162000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '15003',
                                                                                                                                            'distance': 2698,
                                                                                                                                            'mac_address': '00:04:56:2a:66:02',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '60520500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '14166',
                                                                                                                                            'distance': 3297,
                                                                                                                                            'mac_address': '00:04:56:28:74:c7',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '40347000',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '60750000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '331866',
                                                                                                                                            'distance': 3897,
                                                                                                                                            'mac_address': '00:04:56:28:7f:38',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '243000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '10927',
                                                                                                                                            'distance': 3297,
                                                                                                                                            'mac_address': '00:04:56:28:73:a7',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '89660000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '4176',
                                                                                                                                            'distance': 2098,
                                                                                                                                            'mac_address': '00:04:56:28:6e:43',
                                                                                                                                            'noise_floor': -89.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '3840',
                                                                                                                                            'distance': 4496,
                                                                                                                                            'mac_address': '00:04:56:28:7c:9e',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '20173500',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '202500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '331865',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'mac_address': '00:04:56:28:7f:59',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '80694000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 33.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331864',
                                                                                                                                            'distance': 4796,
                                                                                                                                            'mac_address': '00:04:56:28:7f:29',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331861',
                                                                                                                                            'distance': 5396,
                                                                                                                                            'mac_address': '00:04:56:28:80:c4',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '67245000',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '270000000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '331861',
                                                                                                                                            'distance': 3447,
                                                                                                                                            'mac_address': '00:04:56:28:81:48',
                                                                                                                                            'noise_floor': -90.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_link_rate': '60520500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '182250000',
                                                                                                                                            'tx_mcs': 6}],
                                                                                                                   'noise_floor': -89.0}],
                                                                                        'tx_frutl': 24.58,
                                                                                        'tx_power': 21}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'RG-3K-045-90'}],
                                                              'speed': '220000000',
                                                              'type': 71}],
                                'latitude': 42.711021,
                                'longitude': -88.047119,
                                'manufacturer': 'Cambium',
                                'model': 'ePMP 3000',
                                'serial_number': '0004562057E9',
                                'sw_version': '4.4',
                                'system_mac_address': '00:04:56:20:57:e9',
                                'uptime': '331938'},
                'peers': [       {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:64:a3',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331868',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:64:a2',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2NGEzTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.22',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Lindsey Rank',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:64:a2'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:6e:37',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331861',
                                                                                                                                                     'distance': 3447,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:6e:36',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg2ZTM3TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.106',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Andrew Szabo',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:6e:36'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:69:18',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331858',
                                                                                                                                                     'distance': 4496,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 33.0,
                                                                                                                                                     'tx_link_rate': '6724500',
                                                                                                                                                     'tx_mcs': 1}]}],
                                                                                                 'tx_link_rate': '6724500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:69:17',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg2OTE4TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.162',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Yorkville United Methodist Churc',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:69:17'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7a:85',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '121500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331856',
                                                                                                                                                     'distance': 4197,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -70.0,
                                                                                                                                                     'rx_link_rate': '121500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 18.0,
                                                                                                                                                     'tx_link_rate': '33622500',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '33622500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7a:84',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3YTg1TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.129',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'William and Karen Jackowski',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7a:84'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7b:9c',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331856',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '13449000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '13449000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7b:9b',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3YjljTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.73',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Scott Smith',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7b:9b'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:72:96',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331856',
                                                                                                                                                     'distance': 4496,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:72:95',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3Mjk2TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.89',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Dave and Shelley Rogers',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:72:95'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7a:a0',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331855',
                                                                                                                                                     'distance': 5995,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '60520500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '60520500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7a:9f',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3YWEwTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.101',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Jennifer Ably',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7a:9f'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:77:2e',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331854',
                                                                                                                                                     'distance': 1049,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 40.0,
                                                                                                                                                     'tx_link_rate': '33622500',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '33622500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:77:2d',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3NzJlTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.43',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'David Rowntree',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:77:2d'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:6e:87',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331850',
                                                                                                                                                     'distance': 5845,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '89660000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '89660000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:6e:86',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2ZTg3TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.193',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Kevin Moran',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:6e:86'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7d:64',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331850',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '53796000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '53796000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7d:63',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3ZDY0TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.150',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Anne Wendorf',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7d:63'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:73:a1',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331839',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:73:a0',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3M2ExTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.142',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Tom Lauber',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:73:a0'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:73:ad',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331867',
                                                                                                                                                     'distance': 3147,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:73:ac',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3M2FkTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.186',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Gilbert Nilsen',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:73:ac'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:29:09:a5',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331838',
                                                                                                                                                     'distance': 4796,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '40347000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '40347000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:29:09:a4',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MjkwOWE1TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.100',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Aspen property care',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:29:09:a4'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7c:e3',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331836',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -52.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '89660000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '89660000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7c:e2',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3Y2UzTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.75',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Peter Braun',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7c:e2'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:81:93',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331835',
                                                                                                                                                     'distance': 3297,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:81:92',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg4MTkzTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.179',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Amanda Prince',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:81:92'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:71:3d',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331826',
                                                                                                                                                     'distance': 6595,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '40347000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '40347000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:71:3c',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3MTNkTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.184',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Amanda Williamson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:71:3c'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:63:f2',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331821',
                                                                                                                                                     'distance': 3447,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '53796000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '53796000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:63:f1',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2M2YyTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.149',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Ellen Jante',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:63:f1'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:d5:f2',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331816',
                                                                                                                                                     'distance': 3297,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:d5:f1',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmFkNWYyTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.104',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Jean Chambers',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:d5:f1'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:66:12',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331810',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '40347000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '40347000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:66:11',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg2NjEyTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.24',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Minton',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:66:11'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:29:0c:78',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331803',
                                                                                                                                                     'distance': 5845,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:29:0c:77',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MjkwYzc4TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.240',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Skewes',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:29:0c:77'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:79:4d',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331799',
                                                                                                                                                     'distance': 4346,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:79:4c',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3OTRkTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.160',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'David V. Anderson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:79:4c'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:78:ff',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '182250000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331795',
                                                                                                                                                     'distance': 5845,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '182250000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:78:fe',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3OGZmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.176',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Jody Halladay',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:78:fe'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:73:71',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331867',
                                                                                                                                                     'distance': 5696,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -87.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '53796000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '53796000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:73:70',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3MzcxTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.117',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Kara Vyvyan',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:73:70'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:6a:10',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '81000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331376',
                                                                                                                                                     'distance': 7494,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -77.0,
                                                                                                                                                     'rx_link_rate': '81000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'snr': 12.0,
                                                                                                                                                     'tx_link_rate': '13449000',
                                                                                                                                                     'tx_mcs': 3}]}],
                                                                                                 'tx_link_rate': '13449000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:6a:0f',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2YTEwTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.38',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Jennifer Herndon',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:6a:0f'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:6e:2d',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '279598',
                                                                                                                                                     'distance': 4946,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '33622500',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '33622500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:6e:2c',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2ZTJkTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.191',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Jane Luedtke',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:6e:2c'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:78:21',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33837',
                                                                                                                                                     'distance': 7644,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'snr': 20.0,
                                                                                                                                                     'tx_link_rate': '53796000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '53796000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:78:20',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3ODIxTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.30',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Jamey Shiels',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:78:20'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:64:b8',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33824',
                                                                                                                                                     'distance': 6145,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '44830000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '44830000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:64:b7',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2NGI4TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.81',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Jim May',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:64:b7'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:79:5f',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '182250000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33803',
                                                                                                                                                     'distance': 4496,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '182250000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:79:5e',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3OTVmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.148',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Bruce Beth',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:79:5e'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:66:2a',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33330',
                                                                                                                                                     'distance': 3297,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '89660000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '89660000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:66:29',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg2NjJhTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.54',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Lisa Scholzen',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:66:29'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7f:c8',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '182250000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33328',
                                                                                                                                                     'distance': 4346,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '182250000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '40347000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '40347000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7f:c7',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3ZmM4TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.34',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Marc DeJarlais',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7f:c7'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:64:04',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33326',
                                                                                                                                                     'distance': 5696,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '53796000',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '53796000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:64:03',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2NDA0TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.88',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Julie Lauber',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:64:03'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:80:7c',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33325',
                                                                                                                                                     'distance': 3297,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '60520500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '60520500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:80:7b',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg4MDdjTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.97',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Thomas Blodgett',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:80:7b'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7c:f2',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33325',
                                                                                                                                                     'distance': 3297,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7c:f1',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3Y2YyTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.48',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Carol Wennerstrand',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7c:f1'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:29:0e:af',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '121500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331866',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '121500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '6724500',
                                                                                                                                                     'tx_mcs': 1}]}],
                                                                                                 'tx_link_rate': '6724500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:29:0e:ae',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MjkwZWFmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.244',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Dave moyer ',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:29:0e:ae'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:64:0d',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33320',
                                                                                                                                                     'distance': 1199,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -47.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 43.0,
                                                                                                                                                     'tx_link_rate': '60520500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '60520500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:64:0c',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2NDBkTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.141',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Karen Peterson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:64:0c'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:77:2b',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33318',
                                                                                                                                                     'distance': 2098,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 39.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:77:2a',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3NzJiTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.156',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Justin Skewes',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:77:2a'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:71:b2',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33314',
                                                                                                                                                     'distance': 1199,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 40.0,
                                                                                                                                                     'tx_link_rate': '33622500',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '33622500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:71:b1',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3MWIyTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.157',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Kurt Lekschas',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:71:b1'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:73:83',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '33297',
                                                                                                                                                     'distance': 5546,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -87.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '89660000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '89660000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:73:82',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3MzgzTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.57',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Shane Deschler',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:73:82'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:69:fc',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '21567',
                                                                                                                                                     'distance': 2698,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '60520500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '60520500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:69:fb',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg2OWZjTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.51',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Racine Atronomical Society',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:69:fb'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:6d:61',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '21012',
                                                                                                                                                     'distance': 2248,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -51.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '89660000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '89660000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:6d:60',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2ZDYxTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.36',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Sean Mulligan',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:6d:60'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:73:74',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '21003',
                                                                                                                                                     'distance': 2098,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:73:73',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3Mzc0TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.27',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Anthony Fox',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:73:73'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:64:2e',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '162000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '20997',
                                                                                                                                                     'distance': 1948,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '162000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:64:2d',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2NDJlTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.170',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Dan Ramon',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:64:2d'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:2a:66:02',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '15003',
                                                                                                                                                     'distance': 2698,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '60520500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '60520500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:2a:66:01',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2MmE2NjAyTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.185',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Peter Falk',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:66:01'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:74:c7',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '60750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '14166',
                                                                                                                                                     'distance': 3297,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '60750000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '40347000',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '40347000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:74:c6',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3NGM3TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.69',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Glodowski',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:74:c6'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7f:38',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '243000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331866',
                                                                                                                                                     'distance': 3897,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '243000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7f:37',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3ZjM4TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.172',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Autumn Russell',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7f:37'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:73:a7',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '10927',
                                                                                                                                                     'distance': 3297,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -87.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '89660000',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '89660000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:73:a6',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3M2E3TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.31',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Daniel Peterson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:73:a6'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:6e:43',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '4176',
                                                                                                                                                     'distance': 2098,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:6e:42',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg2ZTQzTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.161',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Michael Knight',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:6e:42'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7c:9e',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '202500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3840',
                                                                                                                                                     'distance': 4496,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '202500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '20173500',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '20173500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7c:9d',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3YzllTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.71',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Jill Helm',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7c:9d'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7f:59',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331865',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '80694000',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '80694000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7f:58',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3ZjU5TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.122',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Kaitlin Zarletti Vaughn',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7f:58'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:7f:29',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331864',
                                                                                                                                                     'distance': 4796,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -89.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:7f:28',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg3ZjI5TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.35',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Todd Graf',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7f:28'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:80:c4',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '270000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331861',
                                                                                                                                                     'distance': 5396,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -88.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '270000000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '67245000',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '67245000'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:80:c3',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg4MGM0TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.45',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Jamie Anderson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:80:c3'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:20:57:ea'}],
                                                                       'mac_address': '00:04:56:28:81:48',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 40,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5230,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '182250000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '331861',
                                                                                                                                                     'distance': 3447,
                                                                                                                                                     'mac_address': '00:04:56:20:57:ea',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '182250000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '60520500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '60520500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RG-3K-045-90'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:28:81:47',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Mjg4MTQ4TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.100.5.99',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Jeffrey Coopman',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:81:47'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_cambium_epmp_epmp3000_ePMP_3000_4_4_02(self):
        obj = self.run_data("cambium-epmp.epmp3000.ePMP 3000.4.4.02")
        exp_info = {
                'framing': 'FIXED',
                'model': 'ePMP 3000',
                'rf_chan_width': 20,
                'rf_dl_percent': 75,
                'rf_freq': 5835,
                'rf_tx_power': 23,
                'sta_count': 34,
                'sta_mode_cpe': False,
                'sw_version': '4.4',
                'vendor': 'Cambium'
        }
        exp_stats = {
                'cpu': 53.7,
                'dl_en_bytes': 10802262845956,
                'dl_en_packets': 7869490215,
                'dl_en_packets_dropped': 0,
                'dl_frutl': 76.75,
                'dl_noise_floor': None,
                'dl_rf_bytes': 11259232527250,
                'dl_rf_packets': 8302313666,
                'dl_rf_packets_dropped': 6050361,
                'en_if_speed': 1000000000,
                'rf_packets_retransmitted': 409162720,
                'ul_en_bytes': 766369422107,
                'ul_en_packets': 4679638170,
                'ul_en_packets_dropped': 0,
                'ul_frutl': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': 700646128375,
                'ul_rf_packets': 4784185236,
                'ul_rf_packets_dropped': 14447
        }
        exp_sta_stats = {
                '00:04:56:c1:82:f9': {       'alt_macs': {'00:04:56:c1:82:f8'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 78000000,
                                             'dl_mcs': 5,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -66.0,
                                             'dl_snr': 31.0,
                                             'ip_address': '10.69.3.215',
                                             'mac_address': '00:04:56:c1:82:f9',
                                             'name': 'Misty',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 29139500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 27.0},
                '00:04:56:c1:9e:98': {       'alt_macs': {'00:04:56:c1:9e:97'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 58500000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -73.0,
                                             'dl_snr': 24.0,
                                             'ip_address': '10.69.2.47',
                                             'mac_address': '00:04:56:c1:9e:98',
                                             'name': 'JeanHelton',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -65.0,
                                             'ul_snr': 21.0},
                '00:04:56:c5:48:d6': {       'alt_macs': {'00:04:56:c5:48:d5'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 38.0,
                                             'ip_address': '10.69.3.207',
                                             'mac_address': '00:04:56:c5:48:d6',
                                             'name': 'Keith',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 29139500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 26.0},
                '00:04:56:c8:9f:e4': {       'alt_macs': {'00:04:56:c8:9f:e3'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -64.0,
                                             'dl_snr': 33.0,
                                             'ip_address': '10.69.3.209',
                                             'mac_address': '00:04:56:c8:9f:e4',
                                             'name': 'Neely',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 29139500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 27.0},
                '00:04:56:ce:af:d3': {       'alt_macs': {'00:04:56:ce:af:d2'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 58500000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -74.0,
                                             'dl_snr': 23.0,
                                             'ip_address': '10.69.3.34',
                                             'mac_address': '00:04:56:ce:af:d3',
                                             'name': 'Chirigotis',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -64.0,
                                             'ul_snr': 22.0},
                '00:04:56:ce:af:ee': {       'alt_macs': {'00:04:56:ce:af:ed'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 87750000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -74.0,
                                             'dl_snr': 23.0,
                                             'ip_address': '10.69.2.74',
                                             'mac_address': '00:04:56:ce:af:ee',
                                             'name': 'Jeff Houge',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -66.0,
                                             'ul_snr': 21.0},
                '00:04:56:ce:b0:0f': {       'alt_macs': {'00:04:56:ce:b0:0e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 39000000,
                                             'dl_mcs': 3,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -75.0,
                                             'dl_snr': 22.0,
                                             'ip_address': '10.69.2.19',
                                             'mac_address': '00:04:56:ce:b0:0f',
                                             'name': 'Eric Maggard',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -66.0,
                                             'ul_snr': 20.0},
                '00:04:56:e2:32:55': {       'alt_macs': {'00:04:56:e2:32:54'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 58500000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -74.0,
                                             'dl_snr': 23.0,
                                             'ip_address': '10.69.2.51',
                                             'mac_address': '00:04:56:e2:32:55',
                                             'name': 'Thomas Bustle',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 25.0},
                '00:04:56:e3:3b:dd': {       'alt_macs': {'00:04:56:e3:3b:dc'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -64.0,
                                             'dl_snr': 33.0,
                                             'ip_address': '10.69.2.102',
                                             'mac_address': '00:04:56:e3:3b:dd',
                                             'name': 'Lisa Nickerson',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 26.0},
                '00:04:56:e3:3f:0d': {       'alt_macs': {'00:04:56:e3:3f:0c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -66.0,
                                             'dl_snr': 31.0,
                                             'ip_address': '10.69.2.53',
                                             'mac_address': '00:04:56:e3:3f:0d',
                                             'name': 'Jonathon Greene',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 14569750,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -85.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 24.0},
                '00:04:56:e3:41:4b': {       'alt_macs': {'00:04:56:e3:41:4a'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -56.0,
                                             'dl_snr': 41.0,
                                             'ip_address': '10.69.3.10',
                                             'mac_address': '00:04:56:e3:41:4b',
                                             'name': 'Earl Coffey',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 25901777,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 25.0},
                '00:04:56:e8:84:bf': {       'alt_macs': {'00:04:56:e8:84:be'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 87750000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -69.0,
                                             'dl_snr': 28.0,
                                             'ip_address': '10.69.2.134',
                                             'mac_address': '00:04:56:e8:84:bf',
                                             'name': 'Donna Schepman',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 25901777,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -59.0,
                                             'ul_snr': 28.0},
                '00:04:56:ea:12:e5': {       'alt_macs': {'00:04:56:ea:12:e4'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -63.0,
                                             'dl_snr': 34.0,
                                             'ip_address': '10.69.2.123',
                                             'mac_address': '00:04:56:ea:12:e5',
                                             'name': 'Logan Germann',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 25901777,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 26.0},
                '00:04:56:ef:b3:7f': {       'alt_macs': {'00:04:56:ef:b3:7e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 87750000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -69.0,
                                             'dl_snr': 28.0,
                                             'ip_address': '10.69.2.52',
                                             'mac_address': '00:04:56:ef:b3:7f',
                                             'name': 'O.J. Bailey',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 29139500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 26.0},
                '00:04:56:ef:b4:91': {       'alt_macs': {'00:04:56:ef:b4:90'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 58500000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -72.0,
                                             'dl_snr': 25.0,
                                             'ip_address': '10.69.2.49',
                                             'mac_address': '00:04:56:ef:b4:91',
                                             'name': 'Jason Gaffney',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 25.0},
                '00:04:56:f5:f8:7f': {       'alt_macs': {'00:04:56:f5:f8:7e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -68.0,
                                             'dl_snr': 29.0,
                                             'ip_address': '10.69.3.208',
                                             'mac_address': '00:04:56:f5:f8:7f',
                                             'name': 'Tanner Warlick',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 26.0},
                '00:04:56:f7:4e:6b': {       'alt_macs': {'00:04:56:f7:4e:6a'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -63.0,
                                             'dl_snr': 34.0,
                                             'ip_address': '10.69.2.11',
                                             'mac_address': '00:04:56:f7:4e:6b',
                                             'name': 'Jeremy Shephard',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 25901777,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 25.0},
                '00:04:56:f7:5d:c1': {       'alt_macs': {'00:04:56:f7:5d:c0'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -65.0,
                                             'dl_snr': 32.0,
                                             'ip_address': '10.69.2.243',
                                             'mac_address': '00:04:56:f7:5d:c1',
                                             'name': 'Cheryl Griffith',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 29139500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 26.0},
                '00:04:56:f7:f8:85': {       'alt_macs': {'00:04:56:f7:f8:84'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 87750000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -72.0,
                                             'dl_snr': 25.0,
                                             'ip_address': '10.69.2.68',
                                             'mac_address': '00:04:56:f7:f8:85',
                                             'name': 'Fallon Carnes',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 25901777,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 24.0},
                '00:04:56:fa:41:f7': {       'alt_macs': {'00:04:56:fa:41:f6'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 38.0,
                                             'ip_address': '10.69.2.32',
                                             'mac_address': '00:04:56:fa:41:f7',
                                             'name': 'Staci Holderman',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 27.0},
                '00:04:56:fa:93:8f': {       'alt_macs': {'00:04:56:fa:93:8e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -69.0,
                                             'dl_snr': 28.0,
                                             'ip_address': '10.69.2.4',
                                             'mac_address': '00:04:56:fa:93:8f',
                                             'name': 'Mike LaFavers 6101 Lebanon Rd',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 25901777,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 25.0},
                '00:04:56:fa:94:6d': {       'alt_macs': {'00:04:56:fa:94:6c'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 58500000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -72.0,
                                             'dl_snr': 25.0,
                                             'ip_address': '10.69.2.72',
                                             'mac_address': '00:04:56:fa:94:6d',
                                             'name': 'Gary Whittle',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -62.0,
                                             'ul_snr': 24.0},
                '00:04:56:fa:95:59': {       'alt_macs': {'00:04:56:fa:95:58'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -61.0,
                                             'dl_snr': 36.0,
                                             'ip_address': '10.69.3.206',
                                             'mac_address': '00:04:56:fa:95:59',
                                             'name': 'Josh Tarter 910 Irvine Rd',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 26.0},
                '00:04:56:fa:96:59': {       'alt_macs': {'00:04:56:fa:96:58'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -60.0,
                                             'dl_snr': 37.0,
                                             'ip_address': '10.69.2.50',
                                             'mac_address': '00:04:56:fa:96:59',
                                             'name': 'John Blakeemore',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 25.0},
                '00:04:56:fa:a8:91': {       'alt_macs': {'00:04:56:fa:a8:90'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -64.0,
                                             'dl_snr': 33.0,
                                             'ip_address': '10.69.3.205',
                                             'mac_address': '00:04:56:fa:a8:91',
                                             'name': 'Carney',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 26.0},
                '00:04:56:fb:5a:13': {       'alt_macs': {'00:04:56:fb:5a:12'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 39000000,
                                             'dl_mcs': 3,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -75.0,
                                             'dl_snr': 22.0,
                                             'ip_address': '10.69.3.30',
                                             'mac_address': '00:04:56:fb:5a:13',
                                             'name': 'Brushway',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -67.0,
                                             'ul_snr': 20.0},
                '00:04:56:fc:40:cf': {       'alt_macs': {'00:04:56:fc:40:ce'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -68.0,
                                             'dl_snr': 29.0,
                                             'ip_address': '10.69.2.34',
                                             'mac_address': '00:04:56:fc:40:cf',
                                             'name': 'James Stevens',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 25901777,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 26.0},
                '00:04:56:fc:46:3f': {       'alt_macs': {'00:04:56:fc:46:3e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 58500000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -73.0,
                                             'dl_snr': 24.0,
                                             'ip_address': '10.69.2.215',
                                             'mac_address': '00:04:56:fc:46:3f',
                                             'name': 'Ronnie Bottoms',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 24.0},
                '00:04:56:ff:9a:c7': {       'alt_macs': {'00:04:56:ff:9a:c6'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -62.0,
                                             'dl_snr': 35.0,
                                             'ip_address': '10.69.2.100',
                                             'mac_address': '00:04:56:ff:9a:c7',
                                             'name': 'Michael Bradshaw',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 25901777,
                                             'ul_mcs': 5,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 25.0},
                '00:04:56:ff:a3:57': {       'alt_macs': {'00:04:56:ff:a3:56'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 87750000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -70.0,
                                             'dl_snr': 27.0,
                                             'ip_address': '10.69.3.61',
                                             'mac_address': '00:04:56:ff:a3:57',
                                             'name': 'Daniel Troutman',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -60.0,
                                             'ul_snr': 26.0},
                '00:04:56:ff:c6:49': {       'alt_macs': {'00:04:56:ff:c6:48'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 87750000,
                                             'dl_mcs': 6,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -72.0,
                                             'dl_snr': 25.0,
                                             'ip_address': '10.69.2.222',
                                             'mac_address': '00:04:56:ff:c6:49',
                                             'name': 'Ken Conklin',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 26.0},
                '58:c1:7a:40:51:7f': {       'alt_macs': {'58:c1:7a:40:51:7e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 78000000,
                                             'dl_mcs': 5,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -71.0,
                                             'dl_snr': 26.0,
                                             'ip_address': '10.69.3.106',
                                             'mac_address': '58:c1:7a:40:51:7f',
                                             'name': 'Jana Bottoms',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 26.0},
                '58:c1:7a:41:43:9f': {       'alt_macs': {'58:c1:7a:41:43:9e'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 58500000,
                                             'dl_mcs': 4,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -73.0,
                                             'dl_snr': 24.0,
                                             'ip_address': '10.69.2.10',
                                             'mac_address': '58:c1:7a:41:43:9f',
                                             'name': 'Marty Warren',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 19426333,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -87.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -63.0,
                                             'ul_snr': 24.0},
                '58:c1:7a:41:4d:b1': {       'alt_macs': {'58:c1:7a:41:4d:b0'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 97500000,
                                             'dl_mcs': 7,
                                             'dl_noise_floor': -97.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rf_packets_dropped': None,
                                             'dl_rssi': -67.0,
                                             'dl_snr': 30.0,
                                             'ip_address': '10.69.2.113',
                                             'mac_address': '58:c1:7a:41:4d:b1',
                                             'name': 'George Riley',
                                             'rf_packets_retransmitted': None,
                                             'ul_link_rate': 29139500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -86.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rf_packets_dropped': None,
                                             'ul_rssi': -61.0,
                                             'ul_snr': 25.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 53.7,
                                'elevation': 457.3,
                                'gps_sats_tracked': 10,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '11',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '34342017',
                                                              'in_octets': '10802169622875',
                                                              'in_ucast_pkts': '7869415752',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:04:56:21:39:eb',
                                                              'mtu': 1538,
                                                              'name': 'LAN interface 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '9443526',
                                                              'out_octets': '766361265728',
                                                              'out_ucast_pkts': '4679591472',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '14447',
                                                              'in_nucast_pkts': '9338844',
                                                              'in_octets': '700639195774',
                                                              'in_ucast_pkts': '4784141638',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'mac_address': '00:04:56:e3:3f:0d'},
                                                                               {       'mac_address': '00:04:56:ff:9a:c7'},
                                                                               {       'mac_address': '00:04:56:f7:f8:85'},
                                                                               {       'mac_address': '00:04:56:e3:41:4b'},
                                                                               {       'mac_address': '00:04:56:fa:41:f7'},
                                                                               {       'mac_address': '00:04:56:fa:96:59'},
                                                                               {       'mac_address': '00:04:56:c5:48:d6'},
                                                                               {       'mac_address': '00:04:56:f7:5d:c1'},
                                                                               {       'mac_address': '00:04:56:ff:c6:49'},
                                                                               {       'mac_address': '00:04:56:ff:a3:57'},
                                                                               {       'mac_address': '00:04:56:e3:3b:dd'},
                                                                               {       'mac_address': '00:04:56:f7:4e:6b'},
                                                                               {       'mac_address': '00:04:56:fb:5a:13'},
                                                                               {       'mac_address': '00:04:56:c8:9f:e4'},
                                                                               {       'mac_address': '00:04:56:fa:94:6d'},
                                                                               {       'mac_address': '00:04:56:c1:82:f9'},
                                                                               {       'mac_address': '58:c1:7a:40:51:7f'},
                                                                               {       'mac_address': '00:04:56:fa:95:59'},
                                                                               {       'mac_address': '00:04:56:e8:84:bf'},
                                                                               {       'mac_address': '00:04:56:e2:32:55'},
                                                                               {       'mac_address': '00:04:56:fa:93:8f'},
                                                                               {       'mac_address': '58:c1:7a:41:4d:b1'},
                                                                               {       'mac_address': '00:04:56:ea:12:e5'},
                                                                               {       'mac_address': '00:04:56:ce:af:ee'},
                                                                               {       'mac_address': '00:04:56:c1:9e:98'},
                                                                               {       'mac_address': '00:04:56:ef:b4:91'},
                                                                               {       'mac_address': '00:04:56:ef:b3:7f'},
                                                                               {       'mac_address': '00:04:56:ce:af:d3'},
                                                                               {       'mac_address': '00:04:56:fc:46:3f'},
                                                                               {       'mac_address': '58:c1:7a:41:43:9f'},
                                                                               {       'mac_address': '00:04:56:ce:b0:0f'},
                                                                               {       'mac_address': '00:04:56:f5:f8:7f'},
                                                                               {       'mac_address': '00:04:56:fa:a8:91'},
                                                                               {       'mac_address': '00:04:56:fc:40:cf'}],
                                                              'mac_address': '00:04:56:21:39:ec',
                                                              'mtu': 1546,
                                                              'name': 'WLAN interface',
                                                              'oper_up': True,
                                                              'out_discards': '6016753',
                                                              'out_errors': '33608',
                                                              'out_nucast_pkts': '43608128',
                                                              'out_octets': '11259134830807',
                                                              'out_ucast_pkts': '8302242225',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5835,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '3071458',
                                                                                                                                            'distance': 4496,
                                                                                                                                            'mac_address': '00:04:56:e3:3f:0d',
                                                                                                                                            'noise_floor': -85.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '14569750',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3071187',
                                                                                                                                            'distance': 2548,
                                                                                                                                            'mac_address': '00:04:56:ff:9a:c7',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '25901777',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3071136',
                                                                                                                                            'distance': 2398,
                                                                                                                                            'mac_address': '00:04:56:f7:f8:85',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '25901777',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_link_rate': '87750000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '3071135',
                                                                                                                                            'distance': 2548,
                                                                                                                                            'mac_address': '00:04:56:e3:41:4b',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '25901777',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3071121',
                                                                                                                                            'distance': 2548,
                                                                                                                                            'mac_address': '00:04:56:fa:41:f7',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3071108',
                                                                                                                                            'distance': 2698,
                                                                                                                                            'mac_address': '00:04:56:fa:96:59',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3071101',
                                                                                                                                            'distance': 3897,
                                                                                                                                            'mac_address': '00:04:56:c5:48:d6',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '29139500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3070944',
                                                                                                                                            'distance': 4946,
                                                                                                                                            'mac_address': '00:04:56:f7:5d:c1',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '29139500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3070936',
                                                                                                                                            'distance': 8394,
                                                                                                                                            'mac_address': '00:04:56:ff:c6:49',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '87750000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '3070922',
                                                                                                                                            'distance': 2398,
                                                                                                                                            'mac_address': '00:04:56:ff:a3:57',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '87750000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '2266679',
                                                                                                                                            'distance': 6895,
                                                                                                                                            'mac_address': '00:04:56:e3:3b:dd',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3071449',
                                                                                                                                            'distance': 4346,
                                                                                                                                            'mac_address': '00:04:56:f7:4e:6b',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '25901777',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '1650259',
                                                                                                                                            'distance': 10942,
                                                                                                                                            'mac_address': '00:04:56:fb:5a:13',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '39000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'connected_time': '1579172',
                                                                                                                                            'distance': 2548,
                                                                                                                                            'mac_address': '00:04:56:c8:9f:e4',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '29139500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '1257717',
                                                                                                                                            'distance': 7944,
                                                                                                                                            'mac_address': '00:04:56:fa:94:6d',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_link_rate': '58500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '1081783',
                                                                                                                                            'distance': 2698,
                                                                                                                                            'mac_address': '00:04:56:c1:82:f9',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '29139500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 27.0,
                                                                                                                                            'tx_link_rate': '78000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '1081342',
                                                                                                                                            'distance': 11542,
                                                                                                                                            'mac_address': '58:c1:7a:40:51:7f',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '78000000',
                                                                                                                                            'tx_mcs': 5},
                                                                                                                                    {       'connected_time': '736427',
                                                                                                                                            'distance': 4047,
                                                                                                                                            'mac_address': '00:04:56:fa:95:59',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '734688',
                                                                                                                                            'distance': 2248,
                                                                                                                                            'mac_address': '00:04:56:e8:84:bf',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '25901777',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 28.0,
                                                                                                                                            'tx_link_rate': '87750000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '734666',
                                                                                                                                            'distance': 2848,
                                                                                                                                            'mac_address': '00:04:56:e2:32:55',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '58500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '734659',
                                                                                                                                            'distance': 2698,
                                                                                                                                            'mac_address': '00:04:56:fa:93:8f',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '25901777',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '734657',
                                                                                                                                            'distance': 2698,
                                                                                                                                            'mac_address': '58:c1:7a:41:4d:b1',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '29139500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3071422',
                                                                                                                                            'distance': 3297,
                                                                                                                                            'mac_address': '00:04:56:ea:12:e5',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -60.0,
                                                                                                                                            'rx_link_rate': '25901777',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '734620',
                                                                                                                                            'distance': 8244,
                                                                                                                                            'mac_address': '00:04:56:ce:af:ee',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_link_rate': '87750000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '710830',
                                                                                                                                            'distance': 3147,
                                                                                                                                            'mac_address': '00:04:56:c1:9e:98',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 21.0,
                                                                                                                                            'tx_link_rate': '58500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '604121',
                                                                                                                                            'distance': 9893,
                                                                                                                                            'mac_address': '00:04:56:ef:b4:91',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 25.0,
                                                                                                                                            'tx_link_rate': '58500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '53016',
                                                                                                                                            'distance': 11092,
                                                                                                                                            'mac_address': '00:04:56:ef:b3:7f',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '29139500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '87750000',
                                                                                                                                            'tx_mcs': 6},
                                                                                                                                    {       'connected_time': '39194',
                                                                                                                                            'distance': 11691,
                                                                                                                                            'mac_address': '00:04:56:ce:af:d3',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 22.0,
                                                                                                                                            'tx_link_rate': '58500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '3071404',
                                                                                                                                            'distance': 8394,
                                                                                                                                            'mac_address': '00:04:56:fc:46:3f',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_link_rate': '58500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '3071374',
                                                                                                                                            'distance': 5096,
                                                                                                                                            'mac_address': '58:c1:7a:41:43:9f',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 24.0,
                                                                                                                                            'tx_link_rate': '58500000',
                                                                                                                                            'tx_mcs': 4},
                                                                                                                                    {       'connected_time': '3071361',
                                                                                                                                            'distance': 2997,
                                                                                                                                            'mac_address': '00:04:56:ce:b0:0f',
                                                                                                                                            'noise_floor': -86.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_link_rate': '19426333',
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '39000000',
                                                                                                                                            'tx_mcs': 3},
                                                                                                                                    {       'connected_time': '3071349',
                                                                                                                                            'distance': 12291,
                                                                                                                                            'mac_address': '00:04:56:f5:f8:7f',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3071315',
                                                                                                                                            'distance': 2248,
                                                                                                                                            'mac_address': '00:04:56:fa:a8:91',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7},
                                                                                                                                    {       'connected_time': '3071195',
                                                                                                                                            'distance': 3597,
                                                                                                                                            'mac_address': '00:04:56:fc:40:cf',
                                                                                                                                            'noise_floor': -87.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_link_rate': '25901777',
                                                                                                                                            'rx_mcs': 5,
                                                                                                                                            'snr': 26.0,
                                                                                                                                            'tx_link_rate': '97500000',
                                                                                                                                            'tx_mcs': 7}],
                                                                                                                   'noise_floor': -85.0}],
                                                                                        'tx_frutl': 76.75,
                                                                                        'tx_power': 23}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'PER069-61'}],
                                                              'speed': '110000000',
                                                              'type': 71}],
                                'latitude': 37.590977,
                                'longitude': -84.844887,
                                'manufacturer': 'Cambium',
                                'model': 'ePMP 3000',
                                'serial_number': '0004562139EB',
                                'sw_version': '4.4',
                                'system_mac_address': '00:04:56:21:39:eb',
                                'uptime': '3071586'},
                'peers': [       {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:e3:3f:0d',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071458',
                                                                                                                                                     'distance': 4496,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '14569750',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '14569750'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:e3:3f:0c',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZTMzZjBkTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.53',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Jonathon Greene',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:e3:3f:0c'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:ff:9a:c7',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071187',
                                                                                                                                                     'distance': 2548,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '25901777',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '25901777'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:ff:9a:c6',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmY5YWM3TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.100',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'Michael Bradshaw',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:ff:9a:c6'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:f7:f8:85',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '87750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071136',
                                                                                                                                                     'distance': 2398,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '87750000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '25901777',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '25901777'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:f7:f8:84',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZjdmODg1TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.68',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'Fallon Carnes',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:f7:f8:84'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:e3:41:4b',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071135',
                                                                                                                                                     'distance': 2548,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 41.0,
                                                                                                                                                     'tx_link_rate': '25901777',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '25901777'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:e3:41:4a',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZTM0MTRiTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.10',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Earl Coffey',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:e3:41:4a'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:fa:41:f7',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071121',
                                                                                                                                                     'distance': 2548,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '32377222',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '32377222'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:fa:41:f6',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmE0MWY3TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.32',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Staci Holderman',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:fa:41:f6'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:fa:96:59',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071108',
                                                                                                                                                     'distance': 2698,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -60.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 37.0,
                                                                                                                                                     'tx_link_rate': '32377222',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '32377222'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:fa:96:58',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmE5NjU5TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.50',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'John Blakeemore',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:fa:96:58'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:c5:48:d6',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071101',
                                                                                                                                                     'distance': 3897,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -59.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '29139500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '29139500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:c5:48:d5',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2YzU0OGQ2TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.207',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Connectorized Radio',
                                         'name': 'Keith',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:c5:48:d5'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:f7:5d:c1',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3070944',
                                                                                                                                                     'distance': 4946,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -65.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 32.0,
                                                                                                                                                     'tx_link_rate': '29139500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '29139500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:f7:5d:c0',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Zjc1ZGMxTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.243',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Cheryl Griffith',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:f7:5d:c0'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:ff:c6:49',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '87750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3070936',
                                                                                                                                                     'distance': 8394,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '87750000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:ff:c6:48',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmZjNjQ5TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.222',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Ken Conklin',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:ff:c6:48'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:ff:a3:57',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '87750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3070922',
                                                                                                                                                     'distance': 2398,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -70.0,
                                                                                                                                                     'rx_link_rate': '87750000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 27.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:ff:a3:56',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmZhMzU3TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.61',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'Daniel Troutman',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:ff:a3:56'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:e3:3b:dd',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '2266679',
                                                                                                                                                     'distance': 6895,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 33.0,
                                                                                                                                                     'tx_link_rate': '32377222',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '32377222'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:e3:3b:dc',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZTMzYmRkTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.102',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Lisa Nickerson',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:e3:3b:dc'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:f7:4e:6b',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071449',
                                                                                                                                                     'distance': 4346,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 34.0,
                                                                                                                                                     'tx_link_rate': '25901777',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '25901777'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:f7:4e:6a',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Zjc0ZTZiTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.11',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Jeremy Shephard',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:f7:4e:6a'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:fb:5a:13',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '39000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1650259',
                                                                                                                                                     'distance': 10942,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -75.0,
                                                                                                                                                     'rx_link_rate': '39000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:fb:5a:12',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmI1YTEzTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.30',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Brushway',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:fb:5a:12'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:c8:9f:e4',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1579172',
                                                                                                                                                     'distance': 2548,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 33.0,
                                                                                                                                                     'tx_link_rate': '29139500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '29139500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:c8:9f:e3',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Yzg5ZmU0TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.209',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Connectorized Radio',
                                         'name': 'Neely',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:c8:9f:e3'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:fa:94:6d',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '58500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1257717',
                                                                                                                                                     'distance': 7944,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '58500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:fa:94:6c',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmE5NDZkTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.72',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Gary Whittle',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:fa:94:6c'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:c1:82:f9',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1081783',
                                                                                                                                                     'distance': 2698,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -66.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'snr': 31.0,
                                                                                                                                                     'tx_link_rate': '29139500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '29139500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:c1:82:f8',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2YzE4MmY5TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.215',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Integrated Radio',
                                         'name': 'Misty',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:c1:82:f8'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '58:c1:7a:40:51:7f',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '78000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '1081342',
                                                                                                                                                     'distance': 11542,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -71.0,
                                                                                                                                                     'rx_link_rate': '78000000',
                                                                                                                                                     'rx_mcs': 5,
                                                                                                                                                     'snr': 26.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '58:c1:7a:40:51:7e',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'NThjMTdhNDA1MTdmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.106',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Jana Bottoms',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '58:c1:7a:40:51:7e'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:fa:95:59',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '736427',
                                                                                                                                                     'distance': 4047,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -61.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '32377222',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '32377222'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:fa:95:58',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmE5NTU5TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.206',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Josh Tarter 910 Irvine Rd',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:fa:95:58'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:e8:84:bf',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '87750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '734688',
                                                                                                                                                     'distance': 2248,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '87750000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '25901777',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '25901777'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:e8:84:be',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZTg4NGJmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.134',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'Donna Schepman',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:e8:84:be'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:e2:32:55',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '58500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '734666',
                                                                                                                                                     'distance': 2848,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -74.0,
                                                                                                                                                     'rx_link_rate': '58500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 23.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:e2:32:54',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZTIzMjU1TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.51',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'Thomas Bustle',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:e2:32:54'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:fa:93:8f',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '734659',
                                                                                                                                                     'distance': 2698,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '25901777',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '25901777'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:fa:93:8e',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmE5MzhmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.4',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Mike LaFavers 6101 Lebanon Rd',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:fa:93:8e'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '58:c1:7a:41:4d:b1',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '734657',
                                                                                                                                                     'distance': 2698,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -67.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '29139500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '29139500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '58:c1:7a:41:4d:b0',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'NThjMTdhNDE0ZGIxTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.113',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'George Riley',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '58:c1:7a:41:4d:b0'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:ea:12:e5',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071422',
                                                                                                                                                     'distance': 3297,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 34.0,
                                                                                                                                                     'tx_link_rate': '25901777',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '25901777'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:ea:12:e4',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZWExMmU1TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.123',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'Logan Germann',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:ea:12:e4'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:ce:af:ee',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '87750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '734620',
                                                                                                                                                     'distance': 8244,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -74.0,
                                                                                                                                                     'rx_link_rate': '87750000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 23.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:ce:af:ed',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Y2VhZmVlTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.74',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Connectorized Radio',
                                         'name': 'Jeff Houge',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:ce:af:ed'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:c1:9e:98',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '58500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '710830',
                                                                                                                                                     'distance': 3147,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -73.0,
                                                                                                                                                     'rx_link_rate': '58500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:c1:9e:97',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2YzE5ZTk4TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.47',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Integrated Radio',
                                         'name': 'JeanHelton',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:c1:9e:97'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:ef:b4:91',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '58500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '604121',
                                                                                                                                                     'distance': 9893,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -72.0,
                                                                                                                                                     'rx_link_rate': '58500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 25.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:ef:b4:90',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZWZiNDkxTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.49',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Jason Gaffney',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:ef:b4:90'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:ef:b3:7f',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '87750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '53016',
                                                                                                                                                     'distance': 11092,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -69.0,
                                                                                                                                                     'rx_link_rate': '87750000',
                                                                                                                                                     'rx_mcs': 6,
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '29139500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '29139500'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:ef:b3:7e',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZWZiMzdmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.52',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'O.J. Bailey',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:ef:b3:7e'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:ce:af:d3',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '58500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '39194',
                                                                                                                                                     'distance': 11691,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -74.0,
                                                                                                                                                     'rx_link_rate': '58500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 23.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:ce:af:d2',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Y2VhZmQzTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.34',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Connectorized Radio',
                                         'name': 'Chirigotis',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:ce:af:d2'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:fc:46:3f',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '58500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071404',
                                                                                                                                                     'distance': 8394,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -73.0,
                                                                                                                                                     'rx_link_rate': '58500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:fc:46:3e',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmM0NjNmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.215',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'Ronnie Bottoms',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:fc:46:3e'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '58:c1:7a:41:43:9f',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '58500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071374',
                                                                                                                                                     'distance': 5096,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -73.0,
                                                                                                                                                     'rx_link_rate': '58500000',
                                                                                                                                                     'rx_mcs': 4,
                                                                                                                                                     'snr': 24.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '58:c1:7a:41:43:9e',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'NThjMTdhNDE0MzlmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.10',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'Marty Warren',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '58:c1:7a:41:43:9e'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:ce:b0:0f',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '39000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071361',
                                                                                                                                                     'distance': 2997,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -75.0,
                                                                                                                                                     'rx_link_rate': '39000000',
                                                                                                                                                     'rx_mcs': 3,
                                                                                                                                                     'snr': 22.0,
                                                                                                                                                     'tx_link_rate': '19426333',
                                                                                                                                                     'tx_mcs': 4}]}],
                                                                                                 'tx_link_rate': '19426333'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:ce:b0:0e',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2Y2ViMDBmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.19',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Connectorized Radio',
                                         'name': 'Eric Maggard',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:ce:b0:0e'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:f5:f8:7f',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071349',
                                                                                                                                                     'distance': 12291,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '32377222',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '32377222'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:f5:f8:7e',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZjVmODdmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.208',
                                         'manufacturer': 'Cambium',
                                         'model': '5G Force 200 (FCC)',
                                         'name': 'Tanner Warlick',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:f5:f8:7e'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:fa:a8:91',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071315',
                                                                                                                                                     'distance': 2248,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 33.0,
                                                                                                                                                     'tx_link_rate': '32377222',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '32377222'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:fa:a8:90',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmFhODkxTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.3.205',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'Carney',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:fa:a8:90'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'links': [       {       'mac_address': '00:04:56:21:39:ec'}],
                                                                       'mac_address': '00:04:56:fc:40:cf',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5835,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '97500000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '3071195',
                                                                                                                                                     'distance': 3597,
                                                                                                                                                     'mac_address': '00:04:56:21:39:ec',
                                                                                                                                                     'noise_floor': -97.0,
                                                                                                                                                     'rssi': -68.0,
                                                                                                                                                     'rx_link_rate': '97500000',
                                                                                                                                                     'rx_mcs': 7,
                                                                                                                                                     'snr': 29.0,
                                                                                                                                                     'tx_link_rate': '25901777',
                                                                                                                                                     'tx_mcs': 5}]}],
                                                                                                 'tx_link_rate': '25901777'}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'PER069-61'}]},
                                                               {       'id': '1',
                                                                       'mac_address': '00:04:56:fc:40:ce',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'poller_hash': 'MDAwNDU2ZmM0MGNmTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.69.2.34',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 180 (FCC)',
                                         'name': 'James Stevens',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:fc:40:ce'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_cambium_epmp_epmp3000_ePMP_3000_4_4_1_01(self):
        obj = self.run_data("cambium-epmp.epmp3000.ePMP 3000.4.4.1.01")
        exp_info = {
                'framing': 'FIXED',
                'model': 'ePMP 3000',
                'rf_chan_width': 20,
                'rf_dl_percent': 75,
                'rf_freq': 5240,
                'rf_tx_power': 19,
                'sta_count': 22,
                'sta_mode_cpe': False,
                'sw_version': '4.4.1',
                'vendor': 'Cambium'
        }
        exp_stats = {
                'cpu': 13.9,
                'dl_en_bytes': 852654162819,
                'dl_en_packets': 655531769,
                'dl_en_packets_dropped': 0,
                'dl_frutl': 9.04,
                'dl_noise_floor': None,
                'dl_rf_bytes': 878734118875,
                'dl_rf_packets': 681715187,
                'dl_rf_packets_dropped': 52169,
                'en_if_speed': 1000000000,
                'rf_packets_retransmitted': 23232948,
                'ul_en_bytes': 73394689732,
                'ul_en_packets': 330333091,
                'ul_en_packets_dropped': 0,
                'ul_frutl': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': 68756846500,
                'ul_rf_packets': 335157236,
                'ul_rf_packets_dropped': 156248
        }
        exp_sta_stats = {
                '00:04:56:20:b5:14': {       'alt_macs': {'00:04:56:20:b5:13'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -93.0,
                                             'dl_rf_bytes': 54977810375,
                                             'dl_rf_packets': 60926015,
                                             'dl_rf_packets_dropped': 173,
                                             'dl_rssi': -51.0,
                                             'dl_snr': 42.0,
                                             'ip_address': '10.4.0.26',
                                             'mac_address': '00:04:56:20:b5:14',
                                             'name': 'Peter Neudorf - 16',
                                             'rf_packets_retransmitted': 80502,
                                             'ul_link_rate': 38852666,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 1969836250,
                                             'ul_rf_packets': 19259953,
                                             'ul_rf_packets_dropped': 1310,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 41.0},
                '00:04:56:20:b8:05': {       'alt_macs': {'00:04:56:20:b8:04'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 117000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': 24772906750,
                                             'dl_rf_packets': 32711414,
                                             'dl_rf_packets_dropped': 308,
                                             'dl_rssi': -64.0,
                                             'dl_snr': 28.0,
                                             'ip_address': '10.4.0.52',
                                             'mac_address': '00:04:56:20:b8:05',
                                             'name': 'Manda Anderson - 516',
                                             'rf_packets_retransmitted': 1498088,
                                             'ul_link_rate': 38852666,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 6364481625,
                                             'ul_rf_packets': 14180576,
                                             'ul_rf_packets_dropped': 51578,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 35.0},
                '00:04:56:20:b8:5c': {       'alt_macs': {'00:04:56:20:b8:5b'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 117000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': 36360559500,
                                             'dl_rf_packets': 40509655,
                                             'dl_rf_packets_dropped': 19659,
                                             'dl_rssi': -62.0,
                                             'dl_snr': 30.0,
                                             'ip_address': '10.4.0.21',
                                             'mac_address': '00:04:56:20:b8:5c',
                                             'name': 'Henry Fehr - 347',
                                             'rf_packets_retransmitted': 2974870,
                                             'ul_link_rate': 29139500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 1614083000,
                                             'ul_rf_packets': 10112095,
                                             'ul_rf_packets_dropped': 12352,
                                             'ul_rssi': -53.0,
                                             'ul_snr': 39.0},
                '00:04:56:20:bb:9e': {       'alt_macs': {'00:04:56:20:bb:9d'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': 17846486750,
                                             'dl_rf_packets': 25169455,
                                             'dl_rf_packets_dropped': 83,
                                             'dl_rssi': -57.0,
                                             'dl_snr': 35.0,
                                             'ip_address': '10.4.0.47',
                                             'mac_address': '00:04:56:20:bb:9e',
                                             'name': 'William Wiebe - 459',
                                             'rf_packets_retransmitted': 8664,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 820013875,
                                             'ul_rf_packets': 5564382,
                                             'ul_rf_packets_dropped': 388,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 43.0},
                '00:04:56:20:bb:d7': {       'alt_macs': {'00:04:56:20:bb:d6'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -93.0,
                                             'dl_rf_bytes': 43954284250,
                                             'dl_rf_packets': 46072709,
                                             'dl_rf_packets_dropped': 506,
                                             'dl_rssi': -49.0,
                                             'dl_snr': 44.0,
                                             'ip_address': '10.4.0.30',
                                             'mac_address': '00:04:56:20:bb:d7',
                                             'name': 'Jacob Hiebert - 384',
                                             'rf_packets_retransmitted': 200886,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 2070806750,
                                             'ul_rf_packets': 18704578,
                                             'ul_rf_packets_dropped': 7154,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 41.0},
                '00:04:56:20:bc:5e': {       'alt_macs': {'00:04:56:20:bc:5d'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': 87803920750,
                                             'dl_rf_packets': 72742806,
                                             'dl_rf_packets_dropped': 247,
                                             'dl_rssi': -54.0,
                                             'dl_snr': 38.0,
                                             'ip_address': '10.4.0.27',
                                             'mac_address': '00:04:56:20:bc:5e',
                                             'name': 'Annie Elias - 417',
                                             'rf_packets_retransmitted': 2310339,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 3069663500,
                                             'ul_rf_packets': 25019303,
                                             'ul_rf_packets_dropped': 409,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 43.0},
                '00:04:56:20:bc:70': {       'alt_macs': {'00:04:56:20:bc:6f'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -93.0,
                                             'dl_rf_bytes': 1852864625,
                                             'dl_rf_packets': 18449455,
                                             'dl_rf_packets_dropped': 11,
                                             'dl_rssi': -60.0,
                                             'dl_snr': 33.0,
                                             'ip_address': '10.4.0.32',
                                             'mac_address': '00:04:56:20:bc:70',
                                             'name': 'Franz Peters - 401',
                                             'rf_packets_retransmitted': 16707,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 151603000,
                                             'ul_rf_packets': 751165,
                                             'ul_rf_packets_dropped': 221,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 42.0},
                '00:04:56:20:be:e3': {       'alt_macs': {'00:04:56:20:be:e2'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -85.0,
                                             'dl_rf_bytes': 32650429875,
                                             'dl_rf_packets': 33453518,
                                             'dl_rf_packets_dropped': 72,
                                             'dl_rssi': -39.0,
                                             'dl_snr': 46.0,
                                             'ip_address': '10.4.0.17',
                                             'mac_address': '00:04:56:20:be:e3',
                                             'name': 'Dwayne Friesen - 166',
                                             'rf_packets_retransmitted': 4803,
                                             'ul_link_rate': 38852666,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 622179500,
                                             'ul_rf_packets': 7165573,
                                             'ul_rf_packets_dropped': 509,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 42.0},
                '00:04:56:20:c8:df': {       'alt_macs': {'00:04:56:20:c8:de'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 117000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': 9964957875,
                                             'dl_rf_packets': 30205291,
                                             'dl_rf_packets_dropped': 12,
                                             'dl_rssi': -64.0,
                                             'dl_snr': 28.0,
                                             'ip_address': '10.4.0.28',
                                             'mac_address': '00:04:56:20:c8:df',
                                             'name': 'Johan Doerksen - 408',
                                             'rf_packets_retransmitted': 589468,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 1224402375,
                                             'ul_rf_packets': 4209507,
                                             'ul_rf_packets_dropped': 11325,
                                             'ul_rssi': -57.0,
                                             'ul_snr': 34.0},
                '00:04:56:20:ca:b6': {       'alt_macs': {'00:04:56:20:ca:b5'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': 16926939625,
                                             'dl_rf_packets': 36332843,
                                             'dl_rf_packets_dropped': 204,
                                             'dl_rssi': -59.0,
                                             'dl_snr': 33.0,
                                             'ip_address': '10.4.0.46',
                                             'mac_address': '00:04:56:20:ca:b6',
                                             'name': 'Pedro Fehr - 455',
                                             'rf_packets_retransmitted': 41678,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 1507329750,
                                             'ul_rf_packets': 8523672,
                                             'ul_rf_packets_dropped': 1881,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 41.0},
                '00:04:56:20:e0:68': {       'alt_macs': {'00:04:56:20:e0:67'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -93.0,
                                             'dl_rf_bytes': 38705925750,
                                             'dl_rf_packets': 59258491,
                                             'dl_rf_packets_dropped': 1531,
                                             'dl_rssi': -56.0,
                                             'dl_snr': 37.0,
                                             'ip_address': '10.4.0.48',
                                             'mac_address': '00:04:56:20:e0:68',
                                             'name': 'Jacob Friesen - 465',
                                             'rf_packets_retransmitted': 149524,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 20867444500,
                                             'ul_rf_packets': 32262712,
                                             'ul_rf_packets_dropped': 22590,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 41.0},
                '00:04:56:20:e0:71': {       'alt_macs': {'00:04:56:20:e0:70'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -93.0,
                                             'dl_rf_bytes': 8493691375,
                                             'dl_rf_packets': 29259486,
                                             'dl_rf_packets_dropped': 248,
                                             'dl_rssi': -51.0,
                                             'dl_snr': 42.0,
                                             'ip_address': '10.4.0.53',
                                             'mac_address': '00:04:56:20:e0:71',
                                             'name': 'Gerardo Wall - 389',
                                             'rf_packets_retransmitted': 13370,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 1060939875,
                                             'ul_rf_packets': 4573802,
                                             'ul_rf_packets_dropped': 792,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 43.0},
                '00:04:56:21:1a:5b': {       'alt_macs': {'00:04:56:21:1a:5a'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': 41464251375,
                                             'dl_rf_packets': 52230200,
                                             'dl_rf_packets_dropped': 226,
                                             'dl_rssi': -54.0,
                                             'dl_snr': 38.0,
                                             'ip_address': '10.4.0.6',
                                             'mac_address': '00:04:56:21:1a:5b',
                                             'name': 'Roger Froese - 244',
                                             'rf_packets_retransmitted': 35898,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 1553903000,
                                             'ul_rf_packets': 11389514,
                                             'ul_rf_packets_dropped': 1141,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 41.0},
                '00:04:56:21:1c:4a': {       'alt_macs': {'00:04:56:21:1c:49'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -92.0,
                                             'dl_rf_bytes': 31752559625,
                                             'dl_rf_packets': 35239842,
                                             'dl_rf_packets_dropped': 96,
                                             'dl_rssi': -54.0,
                                             'dl_snr': 38.0,
                                             'ip_address': '10.4.0.9',
                                             'mac_address': '00:04:56:21:1c:4a',
                                             'name': 'Peter L Peters - 249',
                                             'rf_packets_retransmitted': 1969798,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 1389274875,
                                             'ul_rf_packets': 10928825,
                                             'ul_rf_packets_dropped': 555,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 43.0},
                '00:04:56:21:1d:9a': {       'alt_macs': {'00:04:56:21:1d:99'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 117000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -86.0,
                                             'dl_rf_bytes': 4139579000,
                                             'dl_rf_packets': 16320555,
                                             'dl_rf_packets_dropped': 43,
                                             'dl_rssi': -53.0,
                                             'dl_snr': 33.0,
                                             'ip_address': '10.4.0.10',
                                             'mac_address': '00:04:56:21:1d:9a',
                                             'name': 'Cassie Bryan - 253',
                                             'rf_packets_retransmitted': 348136,
                                             'ul_link_rate': 32377222,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 570657375,
                                             'ul_rf_packets': 2263710,
                                             'ul_rf_packets_dropped': 901,
                                             'ul_rssi': -51.0,
                                             'ul_snr': 40.0},
                '00:04:56:28:77:91': {       'alt_macs': {'00:04:56:28:77:90'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -88.0,
                                             'dl_rf_bytes': 24994678125,
                                             'dl_rf_packets': 38713683,
                                             'dl_rf_packets_dropped': 56,
                                             'dl_rssi': -54.0,
                                             'dl_snr': 34.0,
                                             'ip_address': '10.4.0.13',
                                             'mac_address': '00:04:56:28:77:91',
                                             'name': 'Corny Froese - 267',
                                             'rf_packets_retransmitted': 143466,
                                             'ul_link_rate': 38852666,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 2002192875,
                                             'ul_rf_packets': 10155637,
                                             'ul_rf_packets_dropped': 984,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 42.0},
                '00:04:56:28:7c:ce': {       'alt_macs': {'00:04:56:28:7c:cd'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': 37731578250,
                                             'dl_rf_packets': 41126102,
                                             'dl_rf_packets_dropped': 80,
                                             'dl_rssi': -54.0,
                                             'dl_snr': 36.0,
                                             'ip_address': '10.4.0.16',
                                             'mac_address': '00:04:56:28:7c:ce',
                                             'name': 'Johnny Loewen - 15',
                                             'rf_packets_retransmitted': 24295,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 1569704875,
                                             'ul_rf_packets': 11920392,
                                             'ul_rf_packets_dropped': 676,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 43.0},
                '00:04:56:29:51:ec': {       'alt_macs': {'00:04:56:29:51:eb'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -91.0,
                                             'dl_rf_bytes': 10024332250,
                                             'dl_rf_packets': 13374138,
                                             'dl_rf_packets_dropped': 77,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 36.0,
                                             'ip_address': '10.4.0.60',
                                             'mac_address': '00:04:56:29:51:ec',
                                             'name': 'Doug Clark - 577',
                                             'rf_packets_retransmitted': 217520,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 493008125,
                                             'ul_rf_packets': 3884767,
                                             'ul_rf_packets_dropped': 1208,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 41.0},
                '00:04:56:29:80:cd': {       'alt_macs': {'00:04:56:29:80:cc'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -94.0,
                                             'dl_rf_bytes': 72963113500,
                                             'dl_rf_packets': 65057920,
                                             'dl_rf_packets_dropped': 225,
                                             'dl_rssi': -58.0,
                                             'dl_snr': 36.0,
                                             'ip_address': '10.4.0.54',
                                             'mac_address': '00:04:56:29:80:cd',
                                             'name': 'Ray Young - 359',
                                             'rf_packets_retransmitted': 6383790,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 1444822750,
                                             'ul_rf_packets': 16343439,
                                             'ul_rf_packets_dropped': 166,
                                             'ul_rssi': -49.0,
                                             'ul_snr': 43.0},
                '00:04:56:2a:4b:4b': {       'alt_macs': {'00:04:56:2a:4b:4a'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -91.0,
                                             'dl_rf_bytes': 787897750,
                                             'dl_rf_packets': 14477536,
                                             'dl_rf_packets_dropped': 0,
                                             'dl_rssi': -63.0,
                                             'dl_snr': 28.0,
                                             'ip_address': '10.4.0.55',
                                             'mac_address': '00:04:56:2a:4b:4b',
                                             'name': 'Ben and Helen Froese - 354',
                                             'rf_packets_retransmitted': 4685,
                                             'ul_link_rate': 29139500,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -91.0,
                                             'ul_rf_bytes': 41320250,
                                             'ul_rf_packets': 222366,
                                             'ul_rf_packets_dropped': 92,
                                             'ul_rssi': -55.0,
                                             'ul_snr': 36.0},
                '00:04:56:2a:6c:f8': {       'alt_macs': {'00:04:56:2a:6c:f7'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': 9885536000,
                                             'dl_rf_packets': 21328598,
                                             'dl_rf_packets_dropped': 16,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 35.0,
                                             'ip_address': '10.4.0.64',
                                             'mac_address': '00:04:56:2a:6c:f8',
                                             'name': 'Xpress Bookkeeping - 176',
                                             'rf_packets_retransmitted': 21666,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 544160000,
                                             'ul_rf_packets': 3497558,
                                             'ul_rf_packets_dropped': 698,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 42.0},
                '00:04:56:2a:6f:2c': {       'alt_macs': {'00:04:56:2a:6f:2b'},
                                             'dev_macs': set(),
                                             'dl_link_rate': 129750000,
                                             'dl_mcs': 9,
                                             'dl_noise_floor': -90.0,
                                             'dl_rf_bytes': 53157907000,
                                             'dl_rf_packets': 58800571,
                                             'dl_rf_packets_dropped': 137,
                                             'dl_rssi': -55.0,
                                             'dl_snr': 35.0,
                                             'ip_address': '10.4.0.61',
                                             'mac_address': '00:04:56:2a:6f:2c',
                                             'name': 'Albert Reimer - 594',
                                             'rf_packets_retransmitted': 127344,
                                             'ul_link_rate': 43086611,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -92.0,
                                             'ul_rf_bytes': 1507533750,
                                             'ul_rf_packets': 21903461,
                                             'ul_rf_packets_dropped': 644,
                                             'ul_rssi': -50.0,
                                             'ul_snr': 42.0}
        }
        exp_ne_msg = {
                'data': {       'cpu': 13.9,
                                'elevation': 1047.9,
                                'gps_sats_tracked': 18,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '10',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:04:56:21:2f:df',
                                                              'mtu': 1700,
                                                              'name': 'LAN interface 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '8',
                                                              'in_discards': '0',
                                                              'in_errors': '156248',
                                                              'in_nucast_pkts': '2589611',
                                                              'in_octets': '68756112896',
                                                              'in_ucast_pkts': '335149014',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_discards': '644',
                                                                                       'in_octets': '1507533750',
                                                                                       'in_ucast_pkts': '21903461',
                                                                                       'mac_address': '00:04:56:2a:6f:2c',
                                                                                       'out_discards': '137',
                                                                                       'out_octets': '53157907000',
                                                                                       'out_retransmits': '127344',
                                                                                       'out_ucast_pkts': '58800571'},
                                                                               {       'in_discards': '166',
                                                                                       'in_octets': '1444822750',
                                                                                       'in_ucast_pkts': '16343439',
                                                                                       'mac_address': '00:04:56:29:80:cd',
                                                                                       'out_discards': '225',
                                                                                       'out_octets': '72963113500',
                                                                                       'out_retransmits': '6383790',
                                                                                       'out_ucast_pkts': '65057920'},
                                                                               {       'in_discards': '92',
                                                                                       'in_octets': '41320250',
                                                                                       'in_ucast_pkts': '222366',
                                                                                       'mac_address': '00:04:56:2a:4b:4b',
                                                                                       'out_octets': '787897750',
                                                                                       'out_retransmits': '4685',
                                                                                       'out_ucast_pkts': '14477536'},
                                                                               {       'in_discards': '676',
                                                                                       'in_octets': '1569704875',
                                                                                       'in_ucast_pkts': '11920392',
                                                                                       'mac_address': '00:04:56:28:7c:ce',
                                                                                       'out_discards': '80',
                                                                                       'out_octets': '37731578250',
                                                                                       'out_retransmits': '24295',
                                                                                       'out_ucast_pkts': '41126102'},
                                                                               {       'in_discards': '698',
                                                                                       'in_octets': '544160000',
                                                                                       'in_ucast_pkts': '3497558',
                                                                                       'mac_address': '00:04:56:2a:6c:f8',
                                                                                       'out_discards': '16',
                                                                                       'out_octets': '9885536000',
                                                                                       'out_retransmits': '21666',
                                                                                       'out_ucast_pkts': '21328598'},
                                                                               {       'in_discards': '7154',
                                                                                       'in_octets': '2070806750',
                                                                                       'in_ucast_pkts': '18704578',
                                                                                       'mac_address': '00:04:56:20:bb:d7',
                                                                                       'out_discards': '506',
                                                                                       'out_octets': '43954284250',
                                                                                       'out_retransmits': '200886',
                                                                                       'out_ucast_pkts': '46072709'},
                                                                               {       'in_discards': '409',
                                                                                       'in_octets': '3069663500',
                                                                                       'in_ucast_pkts': '25019303',
                                                                                       'mac_address': '00:04:56:20:bc:5e',
                                                                                       'out_discards': '247',
                                                                                       'out_octets': '87803920750',
                                                                                       'out_retransmits': '2310339',
                                                                                       'out_ucast_pkts': '72742806'},
                                                                               {       'in_discards': '12352',
                                                                                       'in_octets': '1614083000',
                                                                                       'in_ucast_pkts': '10112095',
                                                                                       'mac_address': '00:04:56:20:b8:5c',
                                                                                       'out_discards': '19659',
                                                                                       'out_octets': '36360559500',
                                                                                       'out_retransmits': '2974870',
                                                                                       'out_ucast_pkts': '40509655'},
                                                                               {       'in_discards': '901',
                                                                                       'in_octets': '570657375',
                                                                                       'in_ucast_pkts': '2263710',
                                                                                       'mac_address': '00:04:56:21:1d:9a',
                                                                                       'out_discards': '43',
                                                                                       'out_octets': '4139579000',
                                                                                       'out_retransmits': '348136',
                                                                                       'out_ucast_pkts': '16320555'},
                                                                               {       'in_discards': '555',
                                                                                       'in_octets': '1389274875',
                                                                                       'in_ucast_pkts': '10928825',
                                                                                       'mac_address': '00:04:56:21:1c:4a',
                                                                                       'out_discards': '96',
                                                                                       'out_octets': '31752559625',
                                                                                       'out_retransmits': '1969798',
                                                                                       'out_ucast_pkts': '35239842'},
                                                                               {       'in_discards': '388',
                                                                                       'in_octets': '820013875',
                                                                                       'in_ucast_pkts': '5564382',
                                                                                       'mac_address': '00:04:56:20:bb:9e',
                                                                                       'out_discards': '83',
                                                                                       'out_octets': '17846486750',
                                                                                       'out_retransmits': '8664',
                                                                                       'out_ucast_pkts': '25169455'},
                                                                               {       'in_discards': '1141',
                                                                                       'in_octets': '1553903000',
                                                                                       'in_ucast_pkts': '11389514',
                                                                                       'mac_address': '00:04:56:21:1a:5b',
                                                                                       'out_discards': '226',
                                                                                       'out_octets': '41464251375',
                                                                                       'out_retransmits': '35898',
                                                                                       'out_ucast_pkts': '52230200'},
                                                                               {       'in_discards': '51578',
                                                                                       'in_octets': '6364481625',
                                                                                       'in_ucast_pkts': '14180576',
                                                                                       'mac_address': '00:04:56:20:b8:05',
                                                                                       'out_discards': '308',
                                                                                       'out_octets': '24772906750',
                                                                                       'out_retransmits': '1498088',
                                                                                       'out_ucast_pkts': '32711414'},
                                                                               {       'in_discards': '509',
                                                                                       'in_octets': '622179500',
                                                                                       'in_ucast_pkts': '7165573',
                                                                                       'mac_address': '00:04:56:20:be:e3',
                                                                                       'out_discards': '72',
                                                                                       'out_octets': '32650429875',
                                                                                       'out_retransmits': '4803',
                                                                                       'out_ucast_pkts': '33453518'},
                                                                               {       'in_discards': '1208',
                                                                                       'in_octets': '493008125',
                                                                                       'in_ucast_pkts': '3884767',
                                                                                       'mac_address': '00:04:56:29:51:ec',
                                                                                       'out_discards': '77',
                                                                                       'out_octets': '10024332250',
                                                                                       'out_retransmits': '217520',
                                                                                       'out_ucast_pkts': '13374138'},
                                                                               {       'in_discards': '22590',
                                                                                       'in_octets': '20867444500',
                                                                                       'in_ucast_pkts': '32262712',
                                                                                       'mac_address': '00:04:56:20:e0:68',
                                                                                       'out_discards': '1531',
                                                                                       'out_octets': '38705925750',
                                                                                       'out_retransmits': '149524',
                                                                                       'out_ucast_pkts': '59258491'},
                                                                               {       'in_discards': '792',
                                                                                       'in_octets': '1060939875',
                                                                                       'in_ucast_pkts': '4573802',
                                                                                       'mac_address': '00:04:56:20:e0:71',
                                                                                       'out_discards': '248',
                                                                                       'out_octets': '8493691375',
                                                                                       'out_retransmits': '13370',
                                                                                       'out_ucast_pkts': '29259486'},
                                                                               {       'in_discards': '1881',
                                                                                       'in_octets': '1507329750',
                                                                                       'in_ucast_pkts': '8523672',
                                                                                       'mac_address': '00:04:56:20:ca:b6',
                                                                                       'out_discards': '204',
                                                                                       'out_octets': '16926939625',
                                                                                       'out_retransmits': '41678',
                                                                                       'out_ucast_pkts': '36332843'},
                                                                               {       'in_discards': '1310',
                                                                                       'in_octets': '1969836250',
                                                                                       'in_ucast_pkts': '19259953',
                                                                                       'mac_address': '00:04:56:20:b5:14',
                                                                                       'out_discards': '173',
                                                                                       'out_octets': '54977810375',
                                                                                       'out_retransmits': '80502',
                                                                                       'out_ucast_pkts': '60926015'},
                                                                               {       'in_discards': '11325',
                                                                                       'in_octets': '1224402375',
                                                                                       'in_ucast_pkts': '4209507',
                                                                                       'mac_address': '00:04:56:20:c8:df',
                                                                                       'out_discards': '12',
                                                                                       'out_octets': '9964957875',
                                                                                       'out_retransmits': '589468',
                                                                                       'out_ucast_pkts': '30205291'},
                                                                               {       'in_discards': '984',
                                                                                       'in_octets': '2002192875',
                                                                                       'in_ucast_pkts': '10155637',
                                                                                       'mac_address': '00:04:56:28:77:91',
                                                                                       'out_discards': '56',
                                                                                       'out_octets': '24994678125',
                                                                                       'out_retransmits': '143466',
                                                                                       'out_ucast_pkts': '38713683'},
                                                                               {       'in_discards': '221',
                                                                                       'in_octets': '151603000',
                                                                                       'in_ucast_pkts': '751165',
                                                                                       'mac_address': '00:04:56:20:bc:70',
                                                                                       'out_discards': '11',
                                                                                       'out_octets': '1852864625',
                                                                                       'out_retransmits': '16707',
                                                                                       'out_ucast_pkts': '18449455'}],
                                                              'mac_address': '00:04:56:21:2f:e0',
                                                              'mtu': 1708,
                                                              'name': 'WLAN interface',
                                                              'oper_up': True,
                                                              'out_discards': '39658',
                                                              'out_errors': '12509',
                                                              'out_nucast_pkts': '23346241',
                                                              'out_octets': '878717519814',
                                                              'out_ucast_pkts': '681700951',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'dl_percent': 75,
                                                                                        'frame_duration': 5000,
                                                                                        'framing': 'FIXED',
                                                                                        'frequency': 5240,
                                                                                        'gps_sync': True,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'connected_time': '448153',
                                                                                                                                            'distance': 2848,
                                                                                                                                            'mac_address': '00:04:56:2a:6f:2c',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 42.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '313512',
                                                                                                                                            'distance': 2248,
                                                                                                                                            'mac_address': '00:04:56:29:80:cd',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 43.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '284153',
                                                                                                                                            'distance': 3147,
                                                                                                                                            'mac_address': '00:04:56:2a:4b:4b',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '29139500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 36.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '284135',
                                                                                                                                            'distance': 2548,
                                                                                                                                            'mac_address': '00:04:56:28:7c:ce',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 43.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '283907',
                                                                                                                                            'distance': 2548,
                                                                                                                                            'mac_address': '00:04:56:2a:6c:f8',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 42.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '262668',
                                                                                                                                            'distance': 749,
                                                                                                                                            'mac_address': '00:04:56:20:bb:d7',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '262652',
                                                                                                                                            'distance': 899,
                                                                                                                                            'mac_address': '00:04:56:20:bc:5e',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 43.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '262645',
                                                                                                                                            'distance': 1049,
                                                                                                                                            'mac_address': '00:04:56:20:b8:5c',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_link_rate': '29139500',
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 39.0,
                                                                                                                                            'tx_link_rate': '117000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '262632',
                                                                                                                                            'distance': 1199,
                                                                                                                                            'mac_address': '00:04:56:21:1d:9a',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 40.0,
                                                                                                                                            'tx_link_rate': '117000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '262625',
                                                                                                                                            'distance': 749,
                                                                                                                                            'mac_address': '00:04:56:21:1c:4a',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 43.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '262457',
                                                                                                                                            'distance': 1199,
                                                                                                                                            'mac_address': '00:04:56:20:bb:9e',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 43.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '448107',
                                                                                                                                            'distance': 1049,
                                                                                                                                            'mac_address': '00:04:56:21:1a:5b',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '241530',
                                                                                                                                            'distance': 1349,
                                                                                                                                            'mac_address': '00:04:56:20:b8:05',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '38852666',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 35.0,
                                                                                                                                            'tx_link_rate': '117000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '240340',
                                                                                                                                            'distance': 449,
                                                                                                                                            'mac_address': '00:04:56:20:be:e3',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '38852666',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 42.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '132151',
                                                                                                                                            'distance': 2248,
                                                                                                                                            'mac_address': '00:04:56:29:51:ec',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '448106',
                                                                                                                                            'distance': 899,
                                                                                                                                            'mac_address': '00:04:56:20:e0:68',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '447992',
                                                                                                                                            'distance': 899,
                                                                                                                                            'mac_address': '00:04:56:20:e0:71',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 43.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '447983',
                                                                                                                                            'distance': 1199,
                                                                                                                                            'mac_address': '00:04:56:20:ca:b6',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '43086611',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '447981',
                                                                                                                                            'distance': 1049,
                                                                                                                                            'mac_address': '00:04:56:20:b5:14',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '38852666',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 41.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '447840',
                                                                                                                                            'distance': 1498,
                                                                                                                                            'mac_address': '00:04:56:20:c8:df',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 34.0,
                                                                                                                                            'tx_link_rate': '117000000',
                                                                                                                                            'tx_mcs': 8},
                                                                                                                                    {       'connected_time': '400886',
                                                                                                                                            'distance': 2997,
                                                                                                                                            'mac_address': '00:04:56:28:77:91',
                                                                                                                                            'noise_floor': -91.0,
                                                                                                                                            'rssi': -49.0,
                                                                                                                                            'rx_link_rate': '38852666',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 42.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9},
                                                                                                                                    {       'connected_time': '345996',
                                                                                                                                            'distance': 1349,
                                                                                                                                            'mac_address': '00:04:56:20:bc:70',
                                                                                                                                            'noise_floor': -92.0,
                                                                                                                                            'rssi': -50.0,
                                                                                                                                            'rx_link_rate': '32377222',
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 42.0,
                                                                                                                                            'tx_link_rate': '129750000',
                                                                                                                                            'tx_mcs': 9}],
                                                                                                                   'noise_floor': -91.0}],
                                                                                        'tx_frutl': 9.04,
                                                                                        'tx_power': 19}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Tx4 '
                                                                                                 'NW'}],
                                                              'speed': '110000000',
                                                              'type': 71}],
                                'latitude': 32.682968,
                                'longitude': -102.673714,
                                'manufacturer': 'Cambium',
                                'model': 'ePMP 3000',
                                'serial_number': '000456212FDF',
                                'sw_version': '4.4.1',
                                'system_mac_address': '00:04:56:21:2f:df',
                                'uptime': '448223'},
                'peers': [       {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '53157907000',
                                                                       'in_ucast_pkts': '58800571',
                                                                       'links': [       {       'in_octets': '53157907000',
                                                                                                'in_ucast_pkts': '58800571',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '1507533750',
                                                                                                'out_ucast_pkts': '21903461'}],
                                                                       'mac_address': '00:04:56:2a:6f:2c',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '1507533750',
                                                                       'out_ucast_pkts': '21903461',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '448153',
                                                                                                                                                     'distance': 2848,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '43086611',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '43086611',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1507533750',
                                                                       'in_ucast_pkts': '21903461',
                                                                       'mac_address': '00:04:56:2a:6f:2b',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '53157907000',
                                                                       'out_ucast_pkts': '58800571',
                                                                       'poller_hash': 'MDAwNDU2MmE2ZjJjTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.61',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Albert Reimer - 594',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:6f:2b'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '72963113500',
                                                                       'in_ucast_pkts': '65057920',
                                                                       'links': [       {       'in_octets': '72963113500',
                                                                                                'in_ucast_pkts': '65057920',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '1444822750',
                                                                                                'out_ucast_pkts': '16343439'}],
                                                                       'mac_address': '00:04:56:29:80:cd',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '1444822750',
                                                                       'out_ucast_pkts': '16343439',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '313512',
                                                                                                                                                     'distance': 2248,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -94.0,
                                                                                                                                                     'rssi': -58.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '43086611',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '43086611',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1444822750',
                                                                       'in_ucast_pkts': '16343439',
                                                                       'mac_address': '00:04:56:29:80:cc',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '72963113500',
                                                                       'out_ucast_pkts': '65057920',
                                                                       'poller_hash': 'MDAwNDU2Mjk4MGNkTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.54',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Ray Young - 359',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:29:80:cc'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '787897750',
                                                                       'in_ucast_pkts': '14477536',
                                                                       'links': [       {       'in_octets': '787897750',
                                                                                                'in_ucast_pkts': '14477536',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '41320250',
                                                                                                'out_ucast_pkts': '222366'}],
                                                                       'mac_address': '00:04:56:2a:4b:4b',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '41320250',
                                                                       'out_ucast_pkts': '222366',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '284153',
                                                                                                                                                     'distance': 3147,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -63.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '29139500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '29139500',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '41320250',
                                                                       'in_ucast_pkts': '222366',
                                                                       'mac_address': '00:04:56:2a:4b:4a',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '787897750',
                                                                       'out_ucast_pkts': '14477536',
                                                                       'poller_hash': 'MDAwNDU2MmE0YjRiTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.55',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Ben and Helen Froese - 354',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:4b:4a'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '37731578250',
                                                                       'in_ucast_pkts': '41126102',
                                                                       'links': [       {       'in_octets': '37731578250',
                                                                                                'in_ucast_pkts': '41126102',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '1569704875',
                                                                                                'out_ucast_pkts': '11920392'}],
                                                                       'mac_address': '00:04:56:28:7c:ce',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '1569704875',
                                                                       'out_ucast_pkts': '11920392',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '284135',
                                                                                                                                                     'distance': 2548,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '43086611',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '43086611',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1569704875',
                                                                       'in_ucast_pkts': '11920392',
                                                                       'mac_address': '00:04:56:28:7c:cd',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '37731578250',
                                                                       'out_ucast_pkts': '41126102',
                                                                       'poller_hash': 'MDAwNDU2Mjg3Y2NlTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.16',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Johnny Loewen - 15',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:28:7c:cd'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '9885536000',
                                                                       'in_ucast_pkts': '21328598',
                                                                       'links': [       {       'in_octets': '9885536000',
                                                                                                'in_ucast_pkts': '21328598',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '544160000',
                                                                                                'out_ucast_pkts': '3497558'}],
                                                                       'mac_address': '00:04:56:2a:6c:f8',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '544160000',
                                                                       'out_ucast_pkts': '3497558',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '283907',
                                                                                                                                                     'distance': 2548,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -90.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '43086611',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '43086611',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '544160000',
                                                                       'in_ucast_pkts': '3497558',
                                                                       'mac_address': '00:04:56:2a:6c:f7',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '9885536000',
                                                                       'out_ucast_pkts': '21328598',
                                                                       'poller_hash': 'MDAwNDU2MmE2Y2Y4TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.64',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Xpress Bookkeeping - 176',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:2a:6c:f7'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '43954284250',
                                                                       'in_ucast_pkts': '46072709',
                                                                       'links': [       {       'in_octets': '43954284250',
                                                                                                'in_ucast_pkts': '46072709',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '2070806750',
                                                                                                'out_ucast_pkts': '18704578'}],
                                                                       'mac_address': '00:04:56:20:bb:d7',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '2070806750',
                                                                       'out_ucast_pkts': '18704578',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '262668',
                                                                                                                                                     'distance': 749,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -93.0,
                                                                                                                                                     'rssi': -49.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 44.0,
                                                                                                                                                     'tx_link_rate': '32377222',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '32377222',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '2070806750',
                                                                       'in_ucast_pkts': '18704578',
                                                                       'mac_address': '00:04:56:20:bb:d6',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '43954284250',
                                                                       'out_ucast_pkts': '46072709',
                                                                       'poller_hash': 'MDAwNDU2MjBiYmQ3TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.30',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Jacob Hiebert - 384',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:bb:d6'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '87803920750',
                                                                       'in_ucast_pkts': '72742806',
                                                                       'links': [       {       'in_octets': '87803920750',
                                                                                                'in_ucast_pkts': '72742806',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '3069663500',
                                                                                                'out_ucast_pkts': '25019303'}],
                                                                       'mac_address': '00:04:56:20:bc:5e',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '3069663500',
                                                                       'out_ucast_pkts': '25019303',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '262652',
                                                                                                                                                     'distance': 899,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '43086611',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '43086611',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '3069663500',
                                                                       'in_ucast_pkts': '25019303',
                                                                       'mac_address': '00:04:56:20:bc:5d',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '87803920750',
                                                                       'out_ucast_pkts': '72742806',
                                                                       'poller_hash': 'MDAwNDU2MjBiYzVlTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.27',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Annie Elias - 417',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:bc:5d'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '36360559500',
                                                                       'in_ucast_pkts': '40509655',
                                                                       'links': [       {       'in_octets': '36360559500',
                                                                                                'in_ucast_pkts': '40509655',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '1614083000',
                                                                                                'out_ucast_pkts': '10112095'}],
                                                                       'mac_address': '00:04:56:20:b8:5c',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '1614083000',
                                                                       'out_ucast_pkts': '10112095',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '117000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '262645',
                                                                                                                                                     'distance': 1049,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -62.0,
                                                                                                                                                     'rx_link_rate': '117000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 30.0,
                                                                                                                                                     'tx_link_rate': '29139500',
                                                                                                                                                     'tx_mcs': 6}]}],
                                                                                                 'tx_link_rate': '29139500',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1614083000',
                                                                       'in_ucast_pkts': '10112095',
                                                                       'mac_address': '00:04:56:20:b8:5b',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '36360559500',
                                                                       'out_ucast_pkts': '40509655',
                                                                       'poller_hash': 'MDAwNDU2MjBiODVjTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.21',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Henry Fehr - 347',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:b8:5b'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '4139579000',
                                                                       'in_ucast_pkts': '16320555',
                                                                       'links': [       {       'in_octets': '4139579000',
                                                                                                'in_ucast_pkts': '16320555',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '570657375',
                                                                                                'out_ucast_pkts': '2263710'}],
                                                                       'mac_address': '00:04:56:21:1d:9a',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '570657375',
                                                                       'out_ucast_pkts': '2263710',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '117000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '262632',
                                                                                                                                                     'distance': 1199,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -86.0,
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '117000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 33.0,
                                                                                                                                                     'tx_link_rate': '32377222',
                                                                                                                                                     'tx_mcs': 7}]}],
                                                                                                 'tx_link_rate': '32377222',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '570657375',
                                                                       'in_ucast_pkts': '2263710',
                                                                       'mac_address': '00:04:56:21:1d:99',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '4139579000',
                                                                       'out_ucast_pkts': '16320555',
                                                                       'poller_hash': 'MDAwNDU2MjExZDlhTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.10',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Cassie Bryan - 253',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:21:1d:99'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '31752559625',
                                                                       'in_ucast_pkts': '35239842',
                                                                       'links': [       {       'in_octets': '31752559625',
                                                                                                'in_ucast_pkts': '35239842',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '1389274875',
                                                                                                'out_ucast_pkts': '10928825'}],
                                                                       'mac_address': '00:04:56:21:1c:4a',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '1389274875',
                                                                       'out_ucast_pkts': '10928825',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '262625',
                                                                                                                                                     'distance': 749,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '43086611',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '43086611',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1389274875',
                                                                       'in_ucast_pkts': '10928825',
                                                                       'mac_address': '00:04:56:21:1c:49',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '31752559625',
                                                                       'out_ucast_pkts': '35239842',
                                                                       'poller_hash': 'MDAwNDU2MjExYzRhTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.9',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Peter L Peters - 249',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:21:1c:49'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '17846486750',
                                                                       'in_ucast_pkts': '25169455',
                                                                       'links': [       {       'in_octets': '17846486750',
                                                                                                'in_ucast_pkts': '25169455',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '820013875',
                                                                                                'out_ucast_pkts': '5564382'}],
                                                                       'mac_address': '00:04:56:20:bb:9e',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '820013875',
                                                                       'out_ucast_pkts': '5564382',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '262457',
                                                                                                                                                     'distance': 1199,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 35.0,
                                                                                                                                                     'tx_link_rate': '43086611',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '43086611',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '820013875',
                                                                       'in_ucast_pkts': '5564382',
                                                                       'mac_address': '00:04:56:20:bb:9d',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '17846486750',
                                                                       'out_ucast_pkts': '25169455',
                                                                       'poller_hash': 'MDAwNDU2MjBiYjllTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.47',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'William Wiebe - 459',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:bb:9d'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '41464251375',
                                                                       'in_ucast_pkts': '52230200',
                                                                       'links': [       {       'in_octets': '41464251375',
                                                                                                'in_ucast_pkts': '52230200',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '1553903000',
                                                                                                'out_ucast_pkts': '11389514'}],
                                                                       'mac_address': '00:04:56:21:1a:5b',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '1553903000',
                                                                       'out_ucast_pkts': '11389514',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '448107',
                                                                                                                                                     'distance': 1049,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -54.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 38.0,
                                                                                                                                                     'tx_link_rate': '43086611',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '43086611',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '1553903000',
                                                                       'in_ucast_pkts': '11389514',
                                                                       'mac_address': '00:04:56:21:1a:5a',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '41464251375',
                                                                       'out_ucast_pkts': '52230200',
                                                                       'poller_hash': 'MDAwNDU2MjExYTViTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.6',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Roger Froese - 244',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:21:1a:5a'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '24772906750',
                                                                       'in_ucast_pkts': '32711414',
                                                                       'links': [       {       'in_octets': '24772906750',
                                                                                                'in_ucast_pkts': '32711414',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '6364481625',
                                                                                                'out_ucast_pkts': '14180576'}],
                                                                       'mac_address': '00:04:56:20:b8:05',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '6364481625',
                                                                       'out_ucast_pkts': '14180576',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '117000000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '241530',
                                                                                                                                                     'distance': 1349,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -92.0,
                                                                                                                                                     'rssi': -64.0,
                                                                                                                                                     'rx_link_rate': '117000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 28.0,
                                                                                                                                                     'tx_link_rate': '38852666',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '38852666',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '6364481625',
                                                                       'in_ucast_pkts': '14180576',
                                                                       'mac_address': '00:04:56:20:b8:04',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '24772906750',
                                                                       'out_ucast_pkts': '32711414',
                                                                       'poller_hash': 'MDAwNDU2MjBiODA1TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.52',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Manda Anderson - 516',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:b8:04'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '32650429875',
                                                                       'in_ucast_pkts': '33453518',
                                                                       'links': [       {       'in_octets': '32650429875',
                                                                                                'in_ucast_pkts': '33453518',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '622179500',
                                                                                                'out_ucast_pkts': '7165573'}],
                                                                       'mac_address': '00:04:56:20:be:e3',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '622179500',
                                                                       'out_ucast_pkts': '7165573',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '240340',
                                                                                                                                                     'distance': 449,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -85.0,
                                                                                                                                                     'rssi': -39.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 46.0,
                                                                                                                                                     'tx_link_rate': '38852666',
                                                                                                                                                     'tx_mcs': 8}]}],
                                                                                                 'tx_link_rate': '38852666',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '622179500',
                                                                       'in_ucast_pkts': '7165573',
                                                                       'mac_address': '00:04:56:20:be:e2',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '32650429875',
                                                                       'out_ucast_pkts': '33453518',
                                                                       'poller_hash': 'MDAwNDU2MjBiZWUzTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.17',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Dwayne Friesen - 166',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:be:e2'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '10024332250',
                                                                       'in_ucast_pkts': '13374138',
                                                                       'links': [       {       'in_octets': '10024332250',
                                                                                                'in_ucast_pkts': '13374138',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '493008125',
                                                                                                'out_ucast_pkts': '3884767'}],
                                                                       'mac_address': '00:04:56:29:51:ec',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '493008125',
                                                                       'out_ucast_pkts': '3884767',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '132151',
                                                                                                                                                     'distance': 2248,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -91.0,
                                                                                                                                                     'rssi': -55.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 36.0,
                                                                                                                                                     'tx_link_rate': '43086611',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '43086611',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '493008125',
                                                                       'in_ucast_pkts': '3884767',
                                                                       'mac_address': '00:04:56:29:51:eb',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '10024332250',
                                                                       'out_ucast_pkts': '13374138',
                                                                       'poller_hash': 'MDAwNDU2Mjk1MWVjTEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.60',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-25 Radio (FCC)',
                                         'name': 'Doug Clark - 577',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:29:51:eb'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '38705925750',
                                                                       'in_ucast_pkts': '59258491',
                                                                       'links': [       {       'in_octets': '38705925750',
                                                                                                'in_ucast_pkts': '59258491',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '20867444500',
                                                                                                'out_ucast_pkts': '32262712'}],
                                                                       'mac_address': '00:04:56:20:e0:68',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '20867444500',
                                                                       'out_ucast_pkts': '32262712',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 5240,
                                                                                                 'id': '1',
                                                                                                 'rx_link_rate': '129750000',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'connected_time': '448106',
                                                                                                                                                     'distance': 899,
                                                                                                                                                     'mac_address': '00:04:56:21:2f:e0',
                                                                                                                                                     'noise_floor': -93.0,
                                                                                                                                                     'rssi': -56.0,
                                                                                                                                                     'rx_link_rate': '129750000',
                                                                                                                                                     'rx_mcs': 9,
                                                                                                                                                     'snr': 37.0,
                                                                                                                                                     'tx_link_rate': '43086611',
                                                                                                                                                     'tx_mcs': 9}]}],
                                                                                                 'tx_link_rate': '43086611',
                                                                                                 'tx_power': 19}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx4 '
                                                                                                          'NW'}]},
                                                               {       'id': '1',
                                                                       'in_octets': '20867444500',
                                                                       'in_ucast_pkts': '32262712',
                                                                       'mac_address': '00:04:56:20:e0:67',
                                                                       'name': 'LAN '
                                                                               'interface '
                                                                               '1',
                                                                       'out_octets': '38705925750',
                                                                       'out_ucast_pkts': '59258491',
                                                                       'poller_hash': 'MDAwNDU2MjBlMDY4TEFOIGludGVyZmFjZSAx'}],
                                         'management_ip': '10.4.0.48',
                                         'manufacturer': 'Cambium',
                                         'model': '5 GHz Force 300-16 Radio (FCC)',
                                         'name': 'Jacob Friesen - 465',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '00:04:56:20:e0:67'},
                                 {       'interfaces': [       {       'id': '2',
                                                                       'in_octets': '8493691375',
                                                                       'in_ucast_pkts': '29259486',
                                                                       'links': [       {       'in_octets': '8493691375',
                                                                                                'in_ucast_pkts': '29259486',
                                                                                                'mac_address': '00:04:56:21:2f:e0',
                                                                                                'out_octets': '1060939875',
                                                                                                'out_ucast_pkts': '4573802'}],
                                                                       'mac_address': '00:04:56:20:e0:71',
                                                                       'name': 'WLAN '
                                                                               'interface',
                                                                       'out_octets': '1060939875',
                                                                       'out_ucast_pkts': '4573802',
                                                                       'radios': [       {       'chan_width': 20,
                                                                                                 'dl_percent': 75,
                                                                                                 'frame_duration': 5000,
                                                                                                 'framing': 'FIXED',
                                                                                                 'frequency': 524