import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase


class TestBdcomModels(DeviceTestCase):

    def test_bdcom_p3600_P3310D_10_7_90_12(self):
        obj = self.run_data("bdcom.p3600.P3310D.10_7_90_12")
        exp_info = {
                'model': 'P3310D',
                'sta_count': 33,
                'sw_version': '10.1.0F Build 74816',
                'vendor': 'BDCOM'
        }
        exp_stats = {
         'serial_number': '00325001127'
        }
        exp_sta_stats = {
                '1c:ef:03:05:a8:c2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:05:a8:c2',
                                             'name': 'EPON0/2:12',
                                             'serial_number': None},
                '1c:ef:03:05:ab:fa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:05:ab:fa',
                                             'name': 'EPON0/2:9',
                                             'serial_number': None},
                '1c:ef:03:bd:cd:a2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:bd:cd:a2',
                                             'name': 'EPON0/2:15',
                                             'serial_number': None},
                '1c:ef:03:bd:cf:12': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:bd:cf:12',
                                             'name': 'EPON0/2:13',
                                             'serial_number': None},
                '1c:ef:03:d6:88:ad': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d6:88:ad',
                                             'name': 'EPON0/2:10',
                                             'serial_number': None},
                '1c:ef:03:d6:89:4d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d6:89:4d',
                                             'name': 'EPON0/2:11',
                                             'serial_number': None},
                '1c:ef:03:d6:8d:5d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d6:8d:5d',
                                             'name': 'EPON0/1:18',
                                             'serial_number': None},
                '1c:ef:03:d6:9d:5d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d6:9d:5d',
                                             'name': 'EPON0/1:17',
                                             'serial_number': None},
                '6c:68:a4:2c:88:56': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2c:88:56',
                                             'name': 'EPON0/2:14',
                                             'serial_number': None},
                '70:b6:4f:00:0b:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:00:0b:48',
                                             'name': 'EPON0/2:2',
                                             'serial_number': None},
                '70:b6:4f:00:2c:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:00:2c:18',
                                             'name': 'EPON0/1:3',
                                             'serial_number': None},
                '70:b6:4f:4d:4f:58': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:4f:58',
                                             'name': 'EPON0/1:11',
                                             'serial_number': None},
                '70:b6:4f:4d:96:90': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:96:90',
                                             'name': 'EPON0/2:8',
                                             'serial_number': None},
                '70:b6:4f:4d:bb:00': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:bb:00',
                                             'name': 'EPON0/1:4',
                                             'serial_number': None},
                '70:b6:4f:78:cb:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:78:cb:88',
                                             'name': 'EPON0/1:15',
                                             'serial_number': None},
                '70:b6:4f:79:14:a0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:79:14:a0',
                                             'name': 'EPON0/1:10',
                                             'serial_number': None},
                '70:b6:4f:79:55:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:79:55:b8',
                                             'name': 'EPON0/1:14',
                                             'serial_number': None},
                '70:b6:4f:79:57:08': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:79:57:08',
                                             'name': 'EPON0/1:1',
                                             'serial_number': None},
                '70:b6:4f:d1:57:08': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:d1:57:08',
                                             'name': 'EPON0/1:12',
                                             'serial_number': None},
                '70:b6:4f:d1:cf:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:d1:cf:48',
                                             'name': 'EPON0/1:13',
                                             'serial_number': None},
                '80:07:1b:06:e7:38': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '80:07:1b:06:e7:38',
                                             'name': 'EPON0/2:1',
                                             'serial_number': None},
                '80:07:1b:07:24:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '80:07:1b:07:24:18',
                                             'name': 'EPON0/2:3',
                                             'serial_number': None},
                '80:07:1b:07:26:30': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '80:07:1b:07:26:30',
                                             'name': 'EPON0/1:5',
                                             'serial_number': None},
                '80:07:1b:38:00:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '80:07:1b:38:00:e8',
                                             'name': 'EPON0/1:8',
                                             'serial_number': None},
                '80:07:1b:98:b8:58': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '80:07:1b:98:b8:58',
                                             'name': 'EPON0/1:2',
                                             'serial_number': None},
                '98:45:62:9f:3b:ac': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:9f:3b:ac',
                                             'name': 'EPON0/2:5',
                                             'serial_number': None},
                '98:45:62:9f:5a:e4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:9f:5a:e4',
                                             'name': 'EPON0/2:7',
                                             'serial_number': None},
                '98:45:62:aa:5b:e7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:aa:5b:e7',
                                             'name': 'EPON0/2:4',
                                             'serial_number': None},
                '98:45:62:ab:0d:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:ab:0d:ee',
                                             'name': 'EPON0/2:6',
                                             'serial_number': None},
                '98:45:62:ab:20:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:ab:20:f8',
                                             'name': 'EPON0/1:7',
                                             'serial_number': None},
                '98:45:62:d8:37:2a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:d8:37:2a',
                                             'name': 'EPON0/1:16',
                                             'serial_number': None},
                '98:45:62:d8:37:f2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:d8:37:f2',
                                             'name': 'EPON0/1:6',
                                             'serial_number': None},
                '98:45:62:d8:ef:1d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:d8:ef:1d',
                                             'name': 'EPON0/1:9',
                                             'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 32.0,
                                'interfaces': [       {       'admin_up': False,
                                                              'id': '10',
                                                              'mac_address': '98:45:62:96:38:1e',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/2',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MWVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '11',
                                                              'mac_address': '98:45:62:96:38:1f',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/3',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MWZpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '12',
                                                              'mac_address': '98:45:62:96:38:20',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/4',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjBpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '13',
                                                              'mac_address': '98:45:62:96:38:21',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/5',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjFpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '14',
                                                              'mac_address': '98:45:62:96:38:22',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/6',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjJpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '15',
                                                              'mac_address': '98:45:62:96:38:23',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/1',
                                                              'oper_up': True,
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                              'pons': [       {       'id': '15',
                                                                                      'name': 'EPON0/1',
                                                                                      'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '16',
                                                              'mac_address': '98:45:62:96:38:24',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/2',
                                                              'oper_up': True,
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                              'pons': [       {       'id': '16',
                                                                                      'name': 'EPON0/2',
                                                                                      'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '17',
                                                              'mac_address': '98:45:62:96:38:25',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/3',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjVpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '18',
                                                              'mac_address': '98:45:62:96:38:26',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/4',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjZpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '9',
                                                              'mac_address': '98:45:62:96:38:1d',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/1',
                                                              'oper_up': True,
                                                              'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MWRpbnRm',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'BDCOM',
                                'mem': 55.0,
                                'model': 'P3310D',
                                'serial_number': '00325001127',
                                'sw_version': '10.1.0F Build 74816',
                                'system_mac_address': '98:45:62:96:38:1c',
                                'temperature': 50.0},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '33',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/2:1',
                                         'poller_hash': 'ODA6MDc6MWI6MDY6ZTc6MzhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '80:07:1b:06:e7:38'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '34',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'pons': [       {       'id': '34',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'V601',
                                         'name': 'EPON0/2:2',
                                         'poller_hash': 'NzA6YjY6NGY6MDA6MGI6NDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V1.0.5',
                                         'system_mac_address': '70:b6:4f:00:0b:48'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '35',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/2:3',
                                         'poller_hash': 'ODA6MDc6MWI6MDc6MjQ6MThvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '80:07:1b:07:24:18'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '36',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '36',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/1:1',
                                         'poller_hash': 'NzA6YjY6NGY6Nzk6NTc6MDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:79:57:08'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '37',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '37',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'V601',
                                         'name': 'EPON0/1:2',
                                         'poller_hash': 'ODA6MDc6MWI6OTg6Yjg6NThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V1.0.3',
                                         'system_mac_address': '80:07:1b:98:b8:58'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '38',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '38',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'V601',
                                         'name': 'EPON0/1:3',
                                         'poller_hash': 'NzA6YjY6NGY6MDA6MmM6MThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V1.0.5',
                                         'system_mac_address': '70:b6:4f:00:2c:18'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '39',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '39',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/1:4',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6MDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:bb:00'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '40',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'pons': [       {       'id': '40',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'BDCOM',
                                         'model': '6014',
                                         'name': 'EPON0/2:4',
                                         'poller_hash': 'OTg6NDU6NjI6YWE6NWI6ZTdvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '10.0.26B.554',
                                         'system_mac_address': '98:45:62:aa:5b:e7'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '41',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:5',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'pons': [       {       'id': '41',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'BDCOM',
                                         'model': '6014',
                                         'name': 'EPON0/2:5',
                                         'poller_hash': 'OTg6NDU6NjI6OWY6M2I6YWNvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '10.0.26B.554',
                                         'system_mac_address': '98:45:62:9f:3b:ac'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '42',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:6',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/2:6',
                                         'poller_hash': 'OTg6NDU6NjI6YWI6MGQ6ZWVvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '98:45:62:ab:0d:ee'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '43',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:5',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/1:5',
                                         'poller_hash': 'ODA6MDc6MWI6MDc6MjY6MzBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '80:07:1b:07:26:30'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '44',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:6',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/1:6',
                                         'poller_hash': 'OTg6NDU6NjI6ZDg6Mzc6ZjJvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '98:45:62:d8:37:f2'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '45',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:7',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/1:7',
                                         'poller_hash': 'OTg6NDU6NjI6YWI6MjA6ZjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '98:45:62:ab:20:f8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '46',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:7',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/2:7',
                                         'poller_hash': 'OTg6NDU6NjI6OWY6NWE6ZTRvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '98:45:62:9f:5a:e4'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '47',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:8',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'pons': [       {       'id': '47',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/2:8',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6OTY6OTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:96:90'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '48',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:8',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '48',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D201',
                                         'name': 'EPON0/1:8',
                                         'poller_hash': 'ODA6MDc6MWI6Mzg6MDA6ZThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V1.7.5',
                                         'system_mac_address': '80:07:1b:38:00:e8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '49',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:9',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/2:9',
                                         'poller_hash': 'MWM6ZWY6MDM6MDU6YWI6ZmFvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '1c:ef:03:05:ab:fa'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '50',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:9',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/1:9',
                                         'poller_hash': 'OTg6NDU6NjI6ZDg6ZWY6MWRvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '98:45:62:d8:ef:1d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '51',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:10',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '51',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/1:10',
                                         'poller_hash': 'NzA6YjY6NGY6Nzk6MTQ6YTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:79:14:a0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '52',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:11',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/1:11',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6NGY6NThvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '70:b6:4f:4d:4f:58'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '53',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:10',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'pons': [       {       'id': '53',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:10',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDY6ODg6YWRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d6:88:ad'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '54',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:12',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '54',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/1:12',
                                         'poller_hash': 'NzA6YjY6NGY6ZDE6NTc6MDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:d1:57:08'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '55',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:13',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '55',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/1:13',
                                         'poller_hash': 'NzA6YjY6NGY6ZDE6Y2Y6NDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:d1:cf:48'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '56',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:14',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '56',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/1:14',
                                         'poller_hash': 'NzA6YjY6NGY6Nzk6NTU6YjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:79:55:b8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '57',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:15',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '57',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/1:15',
                                         'poller_hash': 'NzA6YjY6NGY6Nzg6Y2I6ODhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:78:cb:88'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '58',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:16',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '58',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'BDCOM',
                                         'model': '6001',
                                         'name': 'EPON0/1:16',
                                         'poller_hash': 'OTg6NDU6NjI6ZDg6Mzc6MmFvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '10.0.26B.711',
                                         'system_mac_address': '98:45:62:d8:37:2a'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '59',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:17',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '59',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/1:17',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDY6OWQ6NWRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d6:9d:5d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '60',
                                                                       'mac_address': '98:45:62:96:38:23',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:18',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNpbnRm',
                                                                       'pons': [       {       'id': '60',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/1:18',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDY6OGQ6NWRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d6:8d:5d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '61',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:11',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'pons': [       {       'id': '61',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:11',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDY6ODk6NGRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d6:89:4d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '62',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:12',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'pons': [       {       'id': '62',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/2:12',
                                         'poller_hash': 'MWM6ZWY6MDM6MDU6YTg6YzJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '1c:ef:03:05:a8:c2'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '63',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:13',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'pons': [       {       'id': '63',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:13',
                                         'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Y6MTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.0.0B0',
                                         'system_mac_address': '1c:ef:03:bd:cf:12'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '64',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:14',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'pons': [       {       'id': '64',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:14',
                                         'poller_hash': 'NmM6Njg6YTQ6MmM6ODg6NTZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:2c:88:56'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '65',
                                                                       'mac_address': '98:45:62:96:38:24',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:15',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRpbnRm',
                                                                       'pons': [       {       'id': '65',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'OTg6NDU6NjI6OTY6Mzg6MjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:15',
                                         'poller_hash': 'MWM6ZWY6MDM6YmQ6Y2Q6YTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:bd:cd:a2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_bdcom_p3600_P3616_2TE_10_144_200_2(self):
        obj = self.run_data("bdcom.p3600.P3616-2TE.10_144_200_2")
        exp_info = {
                'model': 'P3616-2TE',
                'sta_count': 76,
                'sw_version': '10.1.0F Build 84472',
                'vendor': 'BDCOM'
        }
        exp_stats = {
         'serial_number': '00315078920'
        }
        exp_sta_stats = {
                '1c:ef:03:52:8d:70': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:52:8d:70',
                                             'name': 'EPON0/11:4',
                                             'serial_number': None},
                '1c:ef:03:52:cc:20': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:52:cc:20',
                                             'name': 'EPON0/13:1',
                                             'serial_number': None},
                '1c:ef:03:53:42:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:53:42:80',
                                             'name': 'EPON0/13:3',
                                             'serial_number': None},
                '1c:ef:03:53:50:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:53:50:80',
                                             'name': 'EPON0/1:4',
                                             'serial_number': None},
                '1c:ef:03:53:dd:c0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:53:dd:c0',
                                             'name': 'EPON0/13:4',
                                             'serial_number': None},
                '1c:ef:03:54:38:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:54:38:d0',
                                             'name': 'EPON0/10:5',
                                             'serial_number': None},
                '1c:ef:03:54:3f:00': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:54:3f:00',
                                             'name': 'EPON0/2:5',
                                             'serial_number': None},
                '1c:ef:03:54:8a:50': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:54:8a:50',
                                             'name': 'EPON0/13:5',
                                             'serial_number': None},
                '1c:ef:03:55:75:e0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:55:75:e0',
                                             'name': 'EPON0/10:6',
                                             'serial_number': None},
                '1c:ef:03:55:f5:f0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:55:f5:f0',
                                             'name': 'EPON0/1:2',
                                             'serial_number': None},
                '1c:ef:03:56:2b:70': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:56:2b:70',
                                             'name': 'EPON0/13:7',
                                             'serial_number': None},
                '1c:ef:03:56:da:50': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:56:da:50',
                                             'name': 'EPON0/11:5',
                                             'serial_number': None},
                '1c:ef:03:57:0c:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:57:0c:10',
                                             'name': 'EPON0/6:3',
                                             'serial_number': None},
                '1c:ef:03:57:18:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:57:18:d0',
                                             'name': 'EPON0/13:2',
                                             'serial_number': None},
                '1c:ef:03:57:1b:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:57:1b:80',
                                             'name': 'EPON0/11:3',
                                             'serial_number': None},
                '1c:ef:03:57:1d:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:57:1d:d0',
                                             'name': 'EPON0/13:6',
                                             'serial_number': None},
                '1c:ef:03:57:40:40': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:57:40:40',
                                             'name': 'EPON0/10:4',
                                             'serial_number': None},
                '1c:ef:03:76:19:42': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:76:19:42',
                                             'name': 'EPON0/13:11',
                                             'serial_number': None},
                '1c:ef:03:76:38:12': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:76:38:12',
                                             'name': 'EPON0/4:2',
                                             'serial_number': None},
                '1c:ef:03:76:39:52': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:76:39:52',
                                             'name': 'EPON0/13:12',
                                             'serial_number': None},
                '1c:ef:03:76:47:42': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:76:47:42',
                                             'name': 'EPON0/2:8',
                                             'serial_number': None},
                '1c:ef:03:76:e6:92': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:76:e6:92',
                                             'name': 'EPON0/13:10',
                                             'serial_number': None},
                '1c:ef:03:77:1f:92': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:77:1f:92',
                                             'name': 'EPON0/11:7',
                                             'serial_number': None},
                '1c:ef:03:77:39:22': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:77:39:22',
                                             'name': 'EPON0/11:9',
                                             'serial_number': None},
                '1c:ef:03:77:52:32': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:77:52:32',
                                             'name': 'EPON0/2:6',
                                             'serial_number': None},
                '1c:ef:03:77:64:82': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:77:64:82',
                                             'name': 'EPON0/11:8',
                                             'serial_number': None},
                '1c:ef:03:bd:2e:32': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:bd:2e:32',
                                             'name': 'EPON0/11:10',
                                             'serial_number': None},
                '1c:ef:03:d6:9a:2d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d6:9a:2d',
                                             'name': 'EPON0/10:8',
                                             'serial_number': None},
                '1c:ef:03:d7:21:bd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d7:21:bd',
                                             'name': 'EPON0/2:9',
                                             'serial_number': None},
                '1c:ef:03:d7:53:ed': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d7:53:ed',
                                             'name': 'EPON0/12:6',
                                             'serial_number': None},
                '6c:68:a4:1e:a7:0f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:a7:0f',
                                             'name': 'EPON0/6:6',
                                             'serial_number': None},
                '6c:68:a4:1e:e3:2f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:e3:2f',
                                             'name': 'EPON0/8:2',
                                             'serial_number': None},
                '6c:68:a4:1e:e4:5f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1e:e4:5f',
                                             'name': 'EPON0/4:3',
                                             'serial_number': None},
                '6c:68:a4:1f:30:8f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:30:8f',
                                             'name': 'EPON0/14:5',
                                             'serial_number': None},
                '6c:68:a4:1f:5a:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:5a:af',
                                             'name': 'EPON0/2:10',
                                             'serial_number': None},
                '6c:68:a4:1f:eb:0f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:1f:eb:0f',
                                             'name': 'EPON0/13:14',
                                             'serial_number': None},
                '6c:68:a4:20:09:2f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:09:2f',
                                             'name': 'EPON0/13:13',
                                             'serial_number': None},
                '6c:68:a4:20:22:5f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:20:22:5f',
                                             'name': 'EPON0/3:5',
                                             'serial_number': None},
                '6c:68:a4:2c:26:76': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:2c:26:76',
                                             'name': 'EPON0/1:5',
                                             'serial_number': None},
                '6c:68:a4:58:37:0c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:58:37:0c',
                                             'name': 'EPON0/11:11',
                                             'serial_number': None},
                '6c:68:a4:5a:12:bc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '6c:68:a4:5a:12:bc',
                                             'name': 'EPON0/10:9',
                                             'serial_number': None},
                '70:b6:4f:4d:0d:68': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:0d:68',
                                             'name': 'EPON0/12:1',
                                             'serial_number': None},
                '70:b6:4f:4d:2a:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:2a:88',
                                             'name': 'EPON0/10:2',
                                             'serial_number': None},
                '70:b6:4f:4d:32:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:32:10',
                                             'name': 'EPON0/6:2',
                                             'serial_number': None},
                '70:b6:4f:4d:74:d8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:74:d8',
                                             'name': 'EPON0/8:1',
                                             'serial_number': None},
                '70:b6:4f:4d:a1:90': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:a1:90',
                                             'name': 'EPON0/10:3',
                                             'serial_number': None},
                '70:b6:4f:4d:bb:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:4d:bb:b8',
                                             'name': 'EPON0/12:2',
                                             'serial_number': None},
                '70:b6:4f:79:05:60': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:79:05:60',
                                             'name': 'EPON0/13:9',
                                             'serial_number': None},
                '70:b6:4f:d2:29:98': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:d2:29:98',
                                             'name': 'EPON0/11:6',
                                             'serial_number': None},
                '70:b6:4f:d2:29:f0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:d2:29:f0',
                                             'name': 'EPON0/12:4',
                                             'serial_number': None},
                '70:b6:4f:d8:a5:28': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:d8:a5:28',
                                             'name': 'EPON0/13:8',
                                             'serial_number': None},
                '70:b6:4f:e5:95:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e5:95:10',
                                             'name': 'EPON0/6:5',
                                             'serial_number': None},
                '70:b6:4f:e5:c2:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e5:c2:10',
                                             'name': 'EPON0/14:3',
                                             'serial_number': None},
                '70:b6:4f:e5:fb:60': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e5:fb:60',
                                             'name': 'EPON0/2:7',
                                             'serial_number': None},
                '70:b6:4f:e6:02:30': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e6:02:30',
                                             'name': 'EPON0/14:4',
                                             'serial_number': None},
                '70:b6:4f:e6:56:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e6:56:10',
                                             'name': 'EPON0/4:1',
                                             'serial_number': None},
                '70:b6:4f:e6:b4:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e6:b4:80',
                                             'name': 'EPON0/3:3',
                                             'serial_number': None},
                '70:b6:4f:e6:b8:70': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e6:b8:70',
                                             'name': 'EPON0/10:7',
                                             'serial_number': None},
                '70:b6:4f:e7:03:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e7:03:d0',
                                             'name': 'EPON0/6:4',
                                             'serial_number': None},
                '70:b6:4f:e7:10:e0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e7:10:e0',
                                             'name': 'EPON0/3:4',
                                             'serial_number': None},
                '70:b6:4f:fb:44:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:44:e8',
                                             'name': 'EPON0/1:3',
                                             'serial_number': None},
                '70:b6:4f:fb:5f:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:5f:e8',
                                             'name': 'EPON0/2:2',
                                             'serial_number': None},
                '70:b6:4f:fb:68:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:68:88',
                                             'name': 'EPON0/14:1',
                                             'serial_number': None},
                '70:b6:4f:fb:87:a8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:87:a8',
                                             'name': 'EPON0/2:1',
                                             'serial_number': None},
                '70:b6:4f:fb:9b:c8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:9b:c8',
                                             'name': 'EPON0/2:4',
                                             'serial_number': None},
                '70:b6:4f:fb:9d:28': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:9d:28',
                                             'name': 'EPON0/6:1',
                                             'serial_number': None},
                '70:b6:4f:fb:b2:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fb:b2:18',
                                             'name': 'EPON0/14:2',
                                             'serial_number': None},
                '70:b6:4f:fc:06:38': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fc:06:38',
                                             'name': 'EPON0/3:1',
                                             'serial_number': None},
                '70:b6:4f:fc:15:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fc:15:18',
                                             'name': 'EPON0/11:1',
                                             'serial_number': None},
                '70:b6:4f:fc:2f:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fc:2f:f8',
                                             'name': 'EPON0/12:3',
                                             'serial_number': None},
                '70:b6:4f:fc:a6:08': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fc:a6:08',
                                             'name': 'EPON0/10:1',
                                             'serial_number': None},
                '70:b6:4f:fc:a7:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fc:a7:18',
                                             'name': 'EPON0/11:2',
                                             'serial_number': None},
                '70:b6:4f:fd:36:c8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fd:36:c8',
                                             'name': 'EPON0/2:3',
                                             'serial_number': None},
                '70:b6:4f:fd:3e:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:fd:3e:88',
                                             'name': 'EPON0/1:1',
                                             'serial_number': None},
                '80:07:1b:d4:94:40': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '80:07:1b:d4:94:40',
                                             'name': 'EPON0/12:5',
                                             'serial_number': None},
                '98:45:62:f6:43:71': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:f6:43:71',
                                             'name': 'EPON0/3:2',
                                             'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 30.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '65',
                                                              'mac_address': '00:55:b1:45:62:4d',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/1',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NGRpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '66',
                                                              'mac_address': '00:55:b1:45:62:4e',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/2',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NGVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '67',
                                                              'mac_address': '00:55:b1:45:62:4f',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/3',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NGZpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '68',
                                                              'mac_address': '00:55:b1:45:62:50',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/4',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTBpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '69',
                                                              'mac_address': '00:55:b1:45:62:51',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/5',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTFpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '70',
                                                              'mac_address': '00:55:b1:45:62:52',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/6',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTJpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '71',
                                                              'mac_address': '00:55:b1:45:62:53',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/7',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTNpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '72',
                                                              'mac_address': '00:55:b1:45:62:54',
                                                              'mtu': 1700,
                                                              'name': 'GigaEthernet0/8',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTRpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '73',
                                                              'mac_address': '00:55:b1:45:62:55',
                                                              'mtu': 1700,
                                                              'name': 'TGigaEthernet0/1',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTVpbnRm',
                                                              'speed': '10000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '74',
                                                              'mac_address': '00:55:b1:45:62:56',
                                                              'mtu': 1700,
                                                              'name': 'TGigaEthernet0/2',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTZpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '75',
                                                              'mtu': 1500,
                                                              'name': 'FastEthernet0/1',
                                                              'oper_up': False,
                                                              'poller_hash': 'NzVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '76',
                                                              'mac_address': '00:55:b1:45:62:57',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/1',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdpbnRm',
                                                              'pons': [       {       'id': '76',
                                                                                      'name': 'EPON0/1',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '77',
                                                              'mac_address': '00:55:b1:45:62:58',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/2',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                              'pons': [       {       'id': '77',
                                                                                      'name': 'EPON0/2',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '78',
                                                              'mac_address': '00:55:b1:45:62:59',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/3',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTlpbnRm',
                                                              'pons': [       {       'id': '78',
                                                                                      'name': 'EPON0/3',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTllcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '79',
                                                              'mac_address': '00:55:b1:45:62:5a',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/4',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWFpbnRm',
                                                              'pons': [       {       'id': '79',
                                                                                      'name': 'EPON0/4',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWFlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '80',
                                                              'mac_address': '00:55:b1:45:62:5f',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/9',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWZpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '81',
                                                              'mac_address': '00:55:b1:45:62:60',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/10',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                              'pons': [       {       'id': '81',
                                                                                      'name': 'EPON0/10',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '82',
                                                              'mac_address': '00:55:b1:45:62:61',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/11',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                              'pons': [       {       'id': '82',
                                                                                      'name': 'EPON0/11',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '83',
                                                              'mac_address': '00:55:b1:45:62:62',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/12',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm',
                                                              'pons': [       {       'id': '83',
                                                                                      'name': 'EPON0/12',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '84',
                                                              'mac_address': '00:55:b1:45:62:5b',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/5',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWJpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '85',
                                                              'mac_address': '00:55:b1:45:62:5c',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/6',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNpbnRm',
                                                              'pons': [       {       'id': '85',
                                                                                      'name': 'EPON0/6',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '86',
                                                              'mac_address': '00:55:b1:45:62:5d',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/7',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWRpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '87',
                                                              'mac_address': '00:55:b1:45:62:5e',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/8',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWVpbnRm',
                                                              'pons': [       {       'id': '87',
                                                                                      'name': 'EPON0/8',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWVlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '88',
                                                              'mac_address': '00:55:b1:45:62:63',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/13',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                              'pons': [       {       'id': '88',
                                                                                      'name': 'EPON0/13',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '89',
                                                              'mac_address': '00:55:b1:45:62:64',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/14',
                                                              'oper_up': True,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRpbnRm',
                                                              'pons': [       {       'id': '89',
                                                                                      'name': 'EPON0/14',
                                                                                      'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '90',
                                                              'mac_address': '00:55:b1:45:62:65',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/15',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjVpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '91',
                                                              'mac_address': '00:55:b1:45:62:66',
                                                              'mtu': 1700,
                                                              'name': 'EPON0/16',
                                                              'oper_up': False,
                                                              'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjZpbnRm',
                                                              'type': 1}],
                                'manufacturer': 'BDCOM',
                                'mem': 34.0,
                                'model': 'P3616-2TE',
                                'serial_number': '00315078920',
                                'sw_version': '10.1.0F Build 84472',
                                'temperature': 56.0},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '100',
                                                                       'mac_address': '00:55:b1:45:62:60',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/10:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/10:1',
                                         'poller_hash': 'NzA6YjY6NGY6ZmM6YTY6MDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fc:a6:08'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '101',
                                                                       'mac_address': '00:55:b1:45:62:60',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/10:2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/10:2',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6MmE6ODhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:2a:88'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '102',
                                                                       'mac_address': '00:55:b1:45:62:60',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/10:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                                       'pons': [       {       'id': '102',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/10:3',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6YTE6OTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:a1:90'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '103',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'pons': [       {       'id': '103',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/11:1',
                                         'poller_hash': 'NzA6YjY6NGY6ZmM6MTU6MThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fc:15:18'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '104',
                                                                       'mac_address': '00:55:b1:45:62:62',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm',
                                                                       'pons': [       {       'id': '104',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/12:1',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6MGQ6NjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:0d:68'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '105',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/11:2',
                                         'poller_hash': 'NzA6YjY6NGY6ZmM6YTc6MThvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fc:a7:18'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '106',
                                                                       'mac_address': '00:55:b1:45:62:64',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/14:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/14:1',
                                         'poller_hash': 'NzA6YjY6NGY6ZmI6Njg6ODhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fb:68:88'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '107',
                                                                       'mac_address': '00:55:b1:45:62:5e',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/8:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWVpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/8:1',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6NzQ6ZDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:74:d8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '108',
                                                                       'mac_address': '00:55:b1:45:62:62',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm',
                                                                       'pons': [       {       'id': '108',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/12:2',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6YmI6YjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:bb:b8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '109',
                                                                       'mac_address': '00:55:b1:45:62:62',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm',
                                                                       'pons': [       {       'id': '109',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/12:3',
                                         'poller_hash': 'NzA6YjY6NGY6ZmM6MmY6ZjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fc:2f:f8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '110',
                                                                       'mac_address': '00:55:b1:45:62:57',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/1:1',
                                         'poller_hash': 'NzA6YjY6NGY6ZmQ6M2U6ODhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fd:3e:88'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '111',
                                                                       'mac_address': '00:55:b1:45:62:58',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:1',
                                         'poller_hash': 'NzA6YjY6NGY6ZmI6ODc6YThvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fb:87:a8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '112',
                                                                       'mac_address': '00:55:b1:45:62:58',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                                       'pons': [       {       'id': '112',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:2',
                                         'poller_hash': 'NzA6YjY6NGY6ZmI6NWY6ZThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fb:5f:e8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '113',
                                                                       'mac_address': '00:55:b1:45:62:58',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                                       'pons': [       {       'id': '113',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:3',
                                         'poller_hash': 'NzA6YjY6NGY6ZmQ6MzY6YzhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fd:36:c8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '114',
                                                                       'mac_address': '00:55:b1:45:62:58',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                                       'pons': [       {       'id': '114',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:4',
                                         'poller_hash': 'NzA6YjY6NGY6ZmI6OWI6YzhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fb:9b:c8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '115',
                                                                       'mac_address': '00:55:b1:45:62:57',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdpbnRm',
                                                                       'pons': [       {       'id': '115',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/1:2',
                                         'poller_hash': 'MWM6ZWY6MDM6NTU6ZjU6ZjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:55:f5:f0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '116',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/11:3',
                                         'poller_hash': 'MWM6ZWY6MDM6NTc6MWI6ODBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:57:1b:80'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '117',
                                                                       'mac_address': '00:55:b1:45:62:60',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/10:4',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/10:4',
                                         'poller_hash': 'MWM6ZWY6MDM6NTc6NDA6NDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:57:40:40'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '118',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'pons': [       {       'id': '118',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:1',
                                         'poller_hash': 'MWM6ZWY6MDM6NTI6Y2M6MjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:52:cc:20'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '119',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'pons': [       {       'id': '119',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:2',
                                         'poller_hash': 'MWM6ZWY6MDM6NTc6MTg6ZDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:57:18:d0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '120',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'pons': [       {       'id': '120',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/11:4',
                                         'poller_hash': 'MWM6ZWY6MDM6NTI6OGQ6NzBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:52:8d:70'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '121',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:3',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:3',
                                         'poller_hash': 'MWM6ZWY6MDM6NTM6NDI6ODBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:53:42:80'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '122',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'pons': [       {       'id': '122',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:4',
                                         'poller_hash': 'MWM6ZWY6MDM6NTM6ZGQ6YzBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:53:dd:c0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '123',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:5',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/11:5',
                                         'poller_hash': 'MWM6ZWY6MDM6NTY6ZGE6NTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:56:da:50'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '124',
                                                                       'mac_address': '00:55:b1:45:62:59',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/3:2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTlpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'BDCOM',
                                         'model': '6014',
                                         'name': 'EPON0/3:2',
                                         'poller_hash': 'OTg6NDU6NjI6ZjY6NDM6NzFvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': '10.0.26B.711',
                                         'system_mac_address': '98:45:62:f6:43:71'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '125',
                                                                       'mac_address': '00:55:b1:45:62:64',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/14:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRpbnRm',
                                                                       'pons': [       {       'id': '125',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/14:2',
                                         'poller_hash': 'NzA6YjY6NGY6ZmI6YjI6MThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fb:b2:18'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '126',
                                                                       'mac_address': '00:55:b1:45:62:57',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdpbnRm',
                                                                       'pons': [       {       'id': '126',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/1:3',
                                         'poller_hash': 'NzA6YjY6NGY6ZmI6NDQ6ZThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fb:44:e8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '127',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:5',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:5',
                                         'poller_hash': 'MWM6ZWY6MDM6NTQ6OGE6NTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:54:8a:50'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '128',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:6',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'pons': [       {       'id': '128',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/11:6',
                                         'poller_hash': 'NzA6YjY6NGY6ZDI6Mjk6OThvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:d2:29:98'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '129',
                                                                       'mac_address': '00:55:b1:45:62:62',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm',
                                                                       'pons': [       {       'id': '129',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/12:4',
                                         'poller_hash': 'NzA6YjY6NGY6ZDI6Mjk6ZjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:d2:29:f0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '130',
                                                                       'mac_address': '00:55:b1:45:62:57',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdpbnRm',
                                                                       'pons': [       {       'id': '130',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/1:4',
                                         'poller_hash': 'MWM6ZWY6MDM6NTM6NTA6ODBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:53:50:80'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '131',
                                                                       'mac_address': '00:55:b1:45:62:5c',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/6:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNpbnRm',
                                                                       'pons': [       {       'id': '131',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/6:3',
                                         'poller_hash': 'MWM6ZWY6MDM6NTc6MGM6MTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:57:0c:10'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '132',
                                                                       'mac_address': '00:55:b1:45:62:58',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:5',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                                       'pons': [       {       'id': '132',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:5',
                                         'poller_hash': 'MWM6ZWY6MDM6NTQ6M2Y6MDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:54:3f:00'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '133',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:6',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'pons': [       {       'id': '133',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:6',
                                         'poller_hash': 'MWM6ZWY6MDM6NTc6MWQ6ZDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:57:1d:d0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '134',
                                                                       'mac_address': '00:55:b1:45:62:58',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:6',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                                       'pons': [       {       'id': '134',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:6',
                                         'poller_hash': 'MWM6ZWY6MDM6Nzc6NTI6MzJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:77:52:32'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '135',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:7',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/11:7',
                                         'poller_hash': 'MWM6ZWY6MDM6Nzc6MWY6OTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:77:1f:92'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '136',
                                                                       'mac_address': '00:55:b1:45:62:58',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:7',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:7',
                                         'poller_hash': 'NzA6YjY6NGY6ZTU6ZmI6NjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:e5:fb:60'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '137',
                                                                       'mac_address': '00:55:b1:45:62:58',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:8',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                                       'pons': [       {       'id': '137',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:8',
                                         'poller_hash': 'MWM6ZWY6MDM6NzY6NDc6NDJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:76:47:42'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '138',
                                                                       'mac_address': '00:55:b1:45:62:5c',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/6:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNpbnRm',
                                                                       'pons': [       {       'id': '138',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/6:4',
                                         'poller_hash': 'NzA6YjY6NGY6ZTc6MDM6ZDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:e7:03:d0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '139',
                                                                       'mac_address': '00:55:b1:45:62:62',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:5',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm',
                                                                       'pons': [       {       'id': '139',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/12:5',
                                         'poller_hash': 'ODA6MDc6MWI6ZDQ6OTQ6NDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.6P1T8',
                                         'system_mac_address': '80:07:1b:d4:94:40'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '140',
                                                                       'mac_address': '00:55:b1:45:62:64',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/14:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRpbnRm',
                                                                       'pons': [       {       'id': '140',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/14:3',
                                         'poller_hash': 'NzA6YjY6NGY6ZTU6YzI6MTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:e5:c2:10'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '141',
                                                                       'mac_address': '00:55:b1:45:62:5a',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/4:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWFpbnRm',
                                                                       'pons': [       {       'id': '141',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWFlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/4:1',
                                         'poller_hash': 'NzA6YjY6NGY6ZTY6NTY6MTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:e6:56:10'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '142',
                                                                       'mac_address': '00:55:b1:45:62:5a',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/4:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWFpbnRm',
                                                                       'pons': [       {       'id': '142',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWFlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/4:2',
                                         'poller_hash': 'MWM6ZWY6MDM6NzY6Mzg6MTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:76:38:12'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '143',
                                                                       'mac_address': '00:55:b1:45:62:5c',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/6:5',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNpbnRm',
                                                                       'pons': [       {       'id': '143',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/6:5',
                                         'poller_hash': 'NzA6YjY6NGY6ZTU6OTU6MTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:e5:95:10'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '144',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:7',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:7',
                                         'poller_hash': 'MWM6ZWY6MDM6NTY6MmI6NzBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:56:2b:70'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '145',
                                                                       'mac_address': '00:55:b1:45:62:60',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/10:5',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/10:5',
                                         'poller_hash': 'MWM6ZWY6MDM6NTQ6Mzg6ZDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:54:38:d0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '146',
                                                                       'mac_address': '00:55:b1:45:62:60',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/10:6',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/10:6',
                                         'poller_hash': 'MWM6ZWY6MDM6NTU6NzU6ZTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:55:75:e0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '147',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:8',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'pons': [       {       'id': '147',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/11:8',
                                         'poller_hash': 'MWM6ZWY6MDM6Nzc6NjQ6ODJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:77:64:82'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '148',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:8',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:8',
                                         'poller_hash': 'NzA6YjY6NGY6ZDg6YTU6MjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.0.0B0',
                                         'system_mac_address': '70:b6:4f:d8:a5:28'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '149',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:9',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/13:9',
                                         'poller_hash': 'NzA6YjY6NGY6Nzk6MDU6NjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:79:05:60'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '150',
                                                                       'mac_address': '00:55:b1:45:62:64',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/14:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRpbnRm',
                                                                       'pons': [       {       'id': '150',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/14:4',
                                         'poller_hash': 'NzA6YjY6NGY6ZTY6MDI6MzBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:e6:02:30'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '151',
                                                                       'mac_address': '00:55:b1:45:62:59',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/3:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTlpbnRm',
                                                                       'pons': [       {       'id': '151',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTllcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/3:3',
                                         'poller_hash': 'NzA6YjY6NGY6ZTY6YjQ6ODBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:e6:b4:80'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '152',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:10',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'pons': [       {       'id': '152',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:10',
                                         'poller_hash': 'MWM6ZWY6MDM6NzY6ZTY6OTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:76:e6:92'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '153',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:9',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'pons': [       {       'id': '153',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/11:9',
                                         'poller_hash': 'MWM6ZWY6MDM6Nzc6Mzk6MjJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:77:39:22'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '154',
                                                                       'mac_address': '00:55:b1:45:62:59',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/3:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTlpbnRm',
                                                                       'pons': [       {       'id': '154',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTllcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/3:4',
                                         'poller_hash': 'NzA6YjY6NGY6ZTc6MTA6ZTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:e7:10:e0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '155',
                                                                       'mac_address': '00:55:b1:45:62:60',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/10:7',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                                       'pons': [       {       'id': '155',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/10:7',
                                         'poller_hash': 'NzA6YjY6NGY6ZTY6Yjg6NzBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:e6:b8:70'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '156',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:10',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'pons': [       {       'id': '156',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/11:10',
                                         'poller_hash': 'MWM6ZWY6MDM6YmQ6MmU6MzJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:bd:2e:32'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '157',
                                                                       'mac_address': '00:55:b1:45:62:58',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:9',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                                       'pons': [       {       'id': '157',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:9',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDc6MjE6YmRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d7:21:bd'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '158',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:11',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'pons': [       {       'id': '158',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:11',
                                         'poller_hash': 'MWM6ZWY6MDM6NzY6MTk6NDJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:76:19:42'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '159',
                                                                       'mac_address': '00:55:b1:45:62:62',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/12:6',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJpbnRm',
                                                                       'pons': [       {       'id': '159',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjJlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/12:6',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDc6NTM6ZWRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d7:53:ed'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '160',
                                                                       'mac_address': '00:55:b1:45:62:60',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/10:8',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                                       'pons': [       {       'id': '160',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/10:8',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDY6OWE6MmRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d6:9a:2d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '161',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:12',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'pons': [       {       'id': '161',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:12',
                                         'poller_hash': 'MWM6ZWY6MDM6NzY6Mzk6NTJvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:76:39:52'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '162',
                                                                       'mac_address': '00:55:b1:45:62:64',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/14:5',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjRpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/14:5',
                                         'poller_hash': 'NmM6Njg6YTQ6MWY6MzA6OGZvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1f:30:8f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '163',
                                                                       'mac_address': '00:55:b1:45:62:5a',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/4:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWFpbnRm',
                                                                       'pons': [       {       'id': '163',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWFlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/4:3',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6ZTQ6NWZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:e4:5f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '164',
                                                                       'mac_address': '00:55:b1:45:62:5c',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/6:6',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNpbnRm',
                                                                       'pons': [       {       'id': '164',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/6:6',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6YTc6MGZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:a7:0f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '165',
                                                                       'mac_address': '00:55:b1:45:62:5e',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/8:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWVpbnRm',
                                                                       'pons': [       {       'id': '165',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWVlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/8:2',
                                         'poller_hash': 'NmM6Njg6YTQ6MWU6ZTM6MmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1e:e3:2f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '166',
                                                                       'mac_address': '00:55:b1:45:62:59',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/3:5',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTlpbnRm',
                                                                       'pons': [       {       'id': '166',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTllcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/3:5',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6MjI6NWZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:22:5f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '167',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:13',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'pons': [       {       'id': '167',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:13',
                                         'poller_hash': 'NmM6Njg6YTQ6MjA6MDk6MmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:20:09:2f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '168',
                                                                       'mac_address': '00:55:b1:45:62:63',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/13:14',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNpbnRm',
                                                                       'pons': [       {       'id': '168',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/13:14',
                                         'poller_hash': 'NmM6Njg6YTQ6MWY6ZWI6MGZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1f:eb:0f'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '169',
                                                                       'mac_address': '00:55:b1:45:62:61',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/11:11',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjFpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/11:11',
                                         'poller_hash': 'NmM6Njg6YTQ6NTg6Mzc6MGNvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:58:37:0c'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '170',
                                                                       'mac_address': '00:55:b1:45:62:57',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/1:5',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdpbnRm',
                                                                       'pons': [       {       'id': '170',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTdlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/1:5',
                                         'poller_hash': 'NmM6Njg6YTQ6MmM6MjY6NzZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:2c:26:76'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '171',
                                                                       'mac_address': '00:55:b1:45:62:58',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/2:10',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThpbnRm',
                                                                       'pons': [       {       'id': '171',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NThlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/2:10',
                                         'poller_hash': 'NmM6Njg6YTQ6MWY6NWE6YWZvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:1f:5a:af'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '172',
                                                                       'mac_address': '00:55:b1:45:62:60',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/10:9',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NjBpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/10:9',
                                         'poller_hash': 'NmM6Njg6YTQ6NWE6MTI6YmNvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '6c:68:a4:5a:12:bc'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '97',
                                                                       'mac_address': '00:55:b1:45:62:59',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/3:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTlpbnRm',
                                                                       'pons': [       {       'id': '97',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NTllcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/3:1',
                                         'poller_hash': 'NzA6YjY6NGY6ZmM6MDY6MzhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fc:06:38'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '98',
                                                                       'mac_address': '00:55:b1:45:62:5c',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/6:1',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNpbnRm',
                                                                       'pons': [       {       'id': '98',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/6:1',
                                         'poller_hash': 'NzA6YjY6NGY6ZmI6OWQ6MjhvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '70:b6:4f:fb:9d:28'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '99',
                                                                       'mac_address': '00:55:b1:45:62:5c',
                                                                       'mtu': 1700,
                                                                       'name': 'EPON0/6:2',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNpbnRm',
                                                                       'pons': [       {       'id': '99',
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MDA6NTU6YjE6NDU6NjI6NWNlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/6:2',
                                         'poller_hash': 'NzA6YjY6NGY6NGQ6MzI6MTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.7P1T8',
                                         'system_mac_address': '70:b6:4f:4d:32:10'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_bdcom_p3600_P3616_2TE_102_66_117_77(self):
        obj = self.run_data("bdcom.p3600.P3616-2TE.102_66_117_77")
        exp_info = {
                'model': 'P3616-2TE',
                'sta_count': 7,
                'sw_version': '10.1.0F Build 84472',
                'vendor': 'BDCOM'
        }
        exp_stats = {
         'serial_number': '00315076714'
        }
        exp_sta_stats = {
                '00:55:b1:1f:d1:04': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:55:b1:1f:d1:04',
                                             'name': 'EPON0/1:2',
                                             'serial_number': None},
                '1c:ef:03:d7:3a:1d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '1c:ef:03:d7:3a:1d',
                                             'name': 'EPON0/1:4',
                                             'serial_number': None},
                '70:b6:4f:d0:f2:40': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:d0:f2:40',
                                             'name': 'EPON0/1:3',
                                             'serial_number': None},
                '70:b6:4f:e8:e4:a0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '70:b6:4f:e8:e4:a0',
                                             'name': 'EPON0/1:5',
                                             'serial_number': None},
                '80:07:1b:d4:3a:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '80:07:1b:d4:3a:48',
                                             'name': 'EPON0/1:1',
                                             'serial_number': None},
                '98:45:62:9f:45:bf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:9f:45:bf',
                                             'name': 'EPON0/13:1',
                                             'serial_number': None},
                '98:45:62:f6:43:f0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '98:45:62:f6:43:f0',
                                             'name': 'EPON0/1:6',
                                             'serial_number': None}
        }
        exp_ne_msg = {
                'data': {       'cpu': 29.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '65',
                                                              'mac_address': '98:45:62:21:79:9c',
                                                              'mtu': 1500,
                                                              'name': 'GigaEthernet0/1',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6OWNpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '66',
                                                              'mac_address': '98:45:62:21:79:9d',
                                                              'mtu': 1500,
                                                              'name': 'GigaEthernet0/2',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6OWRpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '67',
                                                              'mac_address': '98:45:62:21:79:9e',
                                                              'mtu': 1500,
                                                              'name': 'GigaEthernet0/3',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6OWVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '68',
                                                              'mac_address': '98:45:62:21:79:9f',
                                                              'mtu': 1500,
                                                              'name': 'GigaEthernet0/4',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6OWZpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '69',
                                                              'mac_address': '98:45:62:21:79:a0',
                                                              'mtu': 1500,
                                                              'name': 'GigaEthernet0/5',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTBpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '70',
                                                              'mac_address': '98:45:62:21:79:a1',
                                                              'mtu': 1500,
                                                              'name': 'GigaEthernet0/6',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTFpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '71',
                                                              'mac_address': '98:45:62:21:79:a2',
                                                              'mtu': 1500,
                                                              'name': 'GigaEthernet0/7',
                                                              'oper_up': True,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTJpbnRm',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': False,
                                                              'id': '72',
                                                              'mac_address': '98:45:62:21:79:a3',
                                                              'mtu': 1500,
                                                              'name': 'GigaEthernet0/8',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTNpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '73',
                                                              'mac_address': '98:45:62:21:79:a4',
                                                              'mtu': 1500,
                                                              'name': 'TGigaEthernet0/1',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTRpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '74',
                                                              'mac_address': '98:45:62:21:79:a5',
                                                              'mtu': 1500,
                                                              'name': 'TGigaEthernet0/2',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '75',
                                                              'mtu': 1500,
                                                              'name': 'FastEthernet0/1',
                                                              'oper_up': False,
                                                              'poller_hash': 'NzVpbnRm',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '76',
                                                              'links': [       {       'poller_hash': 'NzA6YjY6NGY6ZDA6ZjI6NDBpbnRm'},
                                                                               {       'poller_hash': 'MWM6ZWY6MDM6ZDc6M2E6MWRpbnRm'}],
                                                              'mac_address': '98:45:62:21:79:a6',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/1',
                                                              'oper_up': True,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTZpbnRm',
                                                              'pons': [       {       'id': '76',
                                                                                      'links': [       {       'poller_hash': 'NzA6YjY6NGY6ZDA6ZjI6NDBlcG9u'},
                                                                                                       {       'poller_hash': 'MWM6ZWY6MDM6ZDc6M2E6MWRlcG9u'}],
                                                                                      'name': 'EPON0/1',
                                                                                      'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTZlcG9u',
                                                                                      'pon_technology': 'EPON'}],
                                                              'speed': '1000000000',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '77',
                                                              'mac_address': '98:45:62:21:79:a7',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/2',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTdpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '78',
                                                              'mac_address': '98:45:62:21:79:a8',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/3',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YThpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '79',
                                                              'mac_address': '98:45:62:21:79:a9',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/4',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTlpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '80',
                                                              'mac_address': '98:45:62:21:79:ae',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/9',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YWVpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '81',
                                                              'mac_address': '98:45:62:21:79:af',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/10',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YWZpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '82',
                                                              'mac_address': '98:45:62:21:79:b0',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/11',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YjBpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '83',
                                                              'mac_address': '98:45:62:21:79:b1',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/12',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YjFpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '84',
                                                              'mac_address': '98:45:62:21:79:b2',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/13',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YjJpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '85',
                                                              'mac_address': '98:45:62:21:79:b3',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/14',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YjNpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '86',
                                                              'mac_address': '98:45:62:21:79:b4',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/15',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YjRpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '87',
                                                              'mac_address': '98:45:62:21:79:b5',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/16',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YjVpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '88',
                                                              'mac_address': '98:45:62:21:79:aa',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/5',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YWFpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '89',
                                                              'mac_address': '98:45:62:21:79:ab',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/6',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YWJpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '90',
                                                              'mac_address': '98:45:62:21:79:ac',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/7',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YWNpbnRm',
                                                              'type': 1},
                                                      {       'admin_up': True,
                                                              'id': '91',
                                                              'mac_address': '98:45:62:21:79:ad',
                                                              'mtu': 1500,
                                                              'name': 'EPON0/8',
                                                              'oper_up': False,
                                                              'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YWRpbnRm',
                                                              'type': 1}],
                                'manufacturer': 'BDCOM',
                                'mem': 34.0,
                                'model': 'P3616-2TE',
                                'serial_number': '00315076714',
                                'sw_version': '10.1.0F Build 84472',
                                'system_mac_address': '98:45:62:21:79:9b',
                                'temperature': 44.0},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '102',
                                                                       'mac_address': '98:45:62:9f:45:bf',
                                                                       'mtu': 1500,
                                                                       'name': 'EPON0/13:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6OWY6NDU6YmZpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/13:1',
                                         'poller_hash': 'OTg6NDU6NjI6OWY6NDU6YmZvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '98:45:62:9f:45:bf'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '103',
                                                                       'mac_address': '00:55:b1:1f:d1:04',
                                                                       'mtu': 1500,
                                                                       'name': 'EPON0/1:2',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'MDA6NTU6YjE6MWY6ZDE6MDRpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'BDCOM',
                                         'model': '1111',
                                         'name': 'EPON0/1:2',
                                         'poller_hash': 'MDA6NTU6YjE6MWY6ZDE6MDRvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': '10.0.22B.730',
                                         'system_mac_address': '00:55:b1:1f:d1:04'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '104',
                                                                       'links': [       {       'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTZpbnRm'}],
                                                                       'mac_address': '70:b6:4f:d0:f2:40',
                                                                       'mtu': 1500,
                                                                       'name': 'EPON0/1:3',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'NzA6YjY6NGY6ZDA6ZjI6NDBpbnRm',
                                                                       'pons': [       {       'id': '104',
                                                                                               'links': [       {       'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTZlcG9u'}],
                                                                                               'name': '1',
                                                                                               'poller_hash': 'NzA6YjY6NGY6ZDA6ZjI6NDBlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'D401',
                                         'name': 'EPON0/1:3',
                                         'poller_hash': 'NzA6YjY6NGY6ZDA6ZjI6NDBvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'V6.0.8P1T8',
                                         'system_mac_address': '70:b6:4f:d0:f2:40'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '105',
                                                                       'links': [       {       'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTZpbnRm'}],
                                                                       'mac_address': '1c:ef:03:d7:3a:1d',
                                                                       'mtu': 1500,
                                                                       'name': 'EPON0/1:4',
                                                                       'oper_up': True,
                                                                       'poller_hash': 'MWM6ZWY6MDM6ZDc6M2E6MWRpbnRm',
                                                                       'pons': [       {       'id': '105',
                                                                                               'links': [       {       'poller_hash': 'OTg6NDU6NjI6MjE6Nzk6YTZlcG9u'}],
                                                                                               'name': '1',
                                                                                               'poller_hash': 'MWM6ZWY6MDM6ZDc6M2E6MWRlcG9u',
                                                                                               'pon_technology': 'EPON'}],
                                                                       'speed': '1000000000',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'H225',
                                         'name': 'EPON0/1:4',
                                         'poller_hash': 'MWM6ZWY6MDM6ZDc6M2E6MWRvbnQ=',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': 'SYNTECH-V2.1',
                                         'system_mac_address': '1c:ef:03:d7:3a:1d'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '106',
                                                                       'mac_address': '70:b6:4f:e8:e4:a0',
                                                                       'mtu': 1500,
                                                                       'name': 'EPON0/1:5',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'NzA6YjY6NGY6ZTg6ZTQ6YTBpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'MONU',
                                         'model': 'V511',
                                         'name': 'EPON0/1:5',
                                         'poller_hash': 'NzA6YjY6NGY6ZTg6ZTQ6YTBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': 'V4.0.00-220402',
                                         'system_mac_address': '70:b6:4f:e8:e4:a0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '107',
                                                                       'mac_address': '98:45:62:f6:43:f0',
                                                                       'mtu': 1500,
                                                                       'name': 'EPON0/1:6',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'OTg6NDU6NjI6ZjY6NDM6ZjBpbnRm',
                                                                       'type': 1}],
                                         'manufacturer': 'BDCOM',
                                         'model': '6014',
                                         'name': 'EPON0/1:6',
                                         'poller_hash': 'OTg6NDU6NjI6ZjY6NDM6ZjBvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'sw_version': '10.0.26B.711',
                                         'system_mac_address': '98:45:62:f6:43:f0'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '97',
                                                                       'mac_address': '80:07:1b:d4:3a:48',
                                                                       'mtu': 1500,
                                                                       'name': 'EPON0/1:1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODA6MDc6MWI6ZDQ6M2E6NDhpbnRm',
                                                                       'type': 1}],
                                         'name': 'EPON0/1:1',
                                         'poller_hash': 'ODA6MDc6MWI6ZDQ6M2E6NDhvbnQ=',
                                         'status': 'ELEMENT_STATUS_OFFLINE',
                                         'system_mac_address': '80:07:1b:d4:3a:48'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))