import os.path
import sys
from tabulate import tabulate

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestRadioStats(DeviceTestCase):

    def test_ligowave_ligowave_LigoWave_AP_1_1_1_01(self):
        obj = self.run_data("ligowave.ligowave.LigoWave AP.1.1.1.01")
        exp_info = {
                'model': 'LigoWave AP',
                'sta_count': 3,
                'sw_version': None,
                'vendor': 'LigoWave'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': None
        }
        exp_sta_stats = {
                '00:19:3b:0e:8a:a4': {       'dev_macs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 3925135873,
                                             'dl_rssi': None,
                                             'ip_address': '10.222.1.41',
                                             'mac_address': '00:19:3b:0e:8a:a4',
                                             'name': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 1967782067,
                                             'ul_rssi': -67},
                '00:19:3b:0e:8a:e6': {       'dev_macs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 316574479,
                                             'dl_rssi': None,
                                             'ip_address': '10.222.1.21',
                                             'mac_address': '00:19:3b:0e:8a:e6',
                                             'name': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 2300226641,
                                             'ul_rssi': -83},
                '00:19:3b:13:27:5c': {       'dev_macs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 986142753,
                                             'dl_rssi': None,
                                             'ip_address': '10.222.1.49',
                                             'mac_address': '00:19:3b:13:27:5c',
                                             'name': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 788578469,
                                             'ul_rssi': -74}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '111229',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '922125841745',
                                                              'in_ucast_pkts': '707383643',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:19:3b:0b:d1:90',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '211949917864',
                                                              'out_ucast_pkts': '301997957',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '241737187493',
                                                              'in_ucast_pkts': '1186000292',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '1967782067',
                                                                                       'mac_address': '00:19:3b:0e:8a:a4',
                                                                                       'out_octets': '3925135873'},
                                                                               {       'in_octets': '2300226641',
                                                                                       'mac_address': '00:19:3b:0e:8a:e6',
                                                                                       'out_octets': '316574479'},
                                                                               {       'in_octets': '788578469',
                                                                                       'mac_address': '00:19:3b:13:27:5c',
                                                                                       'out_octets': '986142753'}],
                                                              'mac_address': '00:19:3b:0b:d1:8f',
                                                              'mtu': 1500,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '989801428613',
                                                              'out_ucast_pkts': '1585278560',
                                                              'radios': [       {       'chan_width': 10,
                                                                                        'frequency': 5155,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:19:3b:0e:8a:a4',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'snr': 28.0},
                                                                                                                                    {       'mac_address': '00:19:3b:0e:8a:e6',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -83.0,
                                                                                                                                            'snr': 12.0},
                                                                                                                                    {       'mac_address': '00:19:3b:13:27:5c',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -74.0,
                                                                                                                                            'snr': 21.0}],
                                                                                                                   'noise_floor': -106.0}],
                                                                                        'tx_link_rate': '86000000',
                                                                                        'tx_power': 16}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Osage '
                                                                                                 'AP '
                                                                                                 'North'}],
                                                              'type': 1}],
                                'manufacturer': 'LigoWave',
                                'model': 'LigoWave AP',
                                'poller_hash': 'ABk7C9GP',
                                'system_mac_address': '00:19:3b:0b:d1:90',
                                'uptime': '3344777'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '3925135873',
                                                                       'links': [       {       'in_octets': '3925135873',
                                                                                                'mac_address': '00:19:3b:0b:d1:8f',
                                                                                                'out_octets': '1967782067'}],
                                                                       'mac_address': '00:19:3b:0e:8a:a4',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_octets': '1967782067',
                                                                       'radios': [       {       'frequency': 5155,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:19:3b:0b:d1:8f'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.222.1.41',
                                         'manufacturer': 'LigoWave',
                                         'poller_hash': 'ABk7Doqk',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '316574479',
                                                                       'links': [       {       'in_octets': '316574479',
                                                                                                'mac_address': '00:19:3b:0b:d1:8f',
                                                                                                'out_octets': '2300226641'}],
                                                                       'mac_address': '00:19:3b:0e:8a:e6',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_octets': '2300226641',
                                                                       'radios': [       {       'frequency': 5155,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:19:3b:0b:d1:8f'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.222.1.21',
                                         'manufacturer': 'LigoWave',
                                         'poller_hash': 'ABk7Dorm',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '986142753',
                                                                       'links': [       {       'in_octets': '986142753',
                                                                                                'mac_address': '00:19:3b:0b:d1:8f',
                                                                                                'out_octets': '788578469'}],
                                                                       'mac_address': '00:19:3b:13:27:5c',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_octets': '788578469',
                                                                       'radios': [       {       'frequency': 5155,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:19:3b:0b:d1:8f'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'management_ip': '10.222.1.49',
                                         'manufacturer': 'LigoWave',
                                         'poller_hash': 'ABk7Eydc',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ligowave_ligowave_LigoWave_AP_None_01(self):
        obj = self.run_data("ligowave.ligowave.LigoWave AP.None.01")
        exp_info = {
                'model': 'LigoWave AP',
                'sta_count': None,
                'sw_version': None,
                'vendor': 'LigoWave'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': None
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '3114702961',
                                                              'in_ucast_pkts': '2716000661',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '00:19:3b:04:70:6a',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4029424375',
                                                              'out_ucast_pkts': '3492854908',
                                                              'speed': '100000000',
                                                              'type': 6}],
                                'manufacturer': 'LigoWave',
                                'model': 'LigoWave AP',
                                'system_mac_address': '00:19:3b:04:70:6a',
                                'uptime': '42317914'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_ligowave_ligowave_LigoWave_AP_None_02(self):
        obj = self.run_data("ligowave.ligowave.LigoWave AP.None.02")
        exp_info = {
                'model': 'LigoWave AP',
                'sta_count': 1,
                'sw_version': None,
                'vendor': 'LigoWave'
        }
        exp_stats = {
                'dl_noise_floor': None,
                'dl_rf_bytes': None,
                'ul_noise_floor': None,
                'ul_rf_bytes': None
        }
        exp_sta_stats = {
                '00:19:3b:0a:80:f1': {       'dev_macs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': 2670621663,
                                             'dl_rssi': None,
                                             'ip_address': None,
                                             'mac_address': '00:19:3b:0a:80:f1',
                                             'name': None,
                                             'ul_noise_floor': -95,
                                             'ul_rf_bytes': 408681721,
                                             'ul_rssi': -47}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '75943885608',
                                                              'in_ucast_pkts': '531495989',
                                                              'in_unknown_protos': '0',
                                                              'mtu': 1500,
                                                              'name': 'eth0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1158709359469',
                                                              'out_ucast_pkts': '834968491',
                                                              'poller_hash': 'AZOwmpG/',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1158876132831',
                                                              'in_ucast_pkts': '834917439',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_octets': '408681721',
                                                                                       'mac_address': '00:19:3b:0a:80:f1',
                                                                                       'out_octets': '2670621663'}],
                                                              'mac_address': '00:19:3b:09:a9:1b',
                                                              'mtu': 1600,
                                                              'name': 'wifi0',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '83330125878',
                                                              'out_ucast_pkts': '487324628',
                                                              'radios': [       {       'chan_width': 20,
                                                                                        'frequency': 5165,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '00:19:3b:0a:80:f1',
                                                                                                                                            'noise_floor': -95.0,
                                                                                                                                            'rssi': -47.0,
                                                                                                                                            'snr': 48.0}],
                                                                                                                   'noise_floor': -95.0}],
                                                                                        'tx_link_rate': '173000000',
                                                                                        'tx_power': 24}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Bluff/KOA'}],
                                                              'type': 1}],
                                'manufacturer': 'LigoWave',
                                'model': 'LigoWave AP',
                                'poller_hash': 'ABk7Cakb',
                                'system_mac_address': '00:19:3b:09:a9:1b',
                                'uptime': '458635'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'in_octets': '2670621663',
                                                                       'links': [       {       'in_octets': '2670621663',
                                                                                                'mac_address': '00:19:3b:09:a9:1b',
                                                                                                'out_octets': '408681721'}],
                                                                       'mac_address': '00:19:3b:0a:80:f1',
                                                                       'name': 'wifi0',
                                                                       'oper_up': True,
                                                                       'out_octets': '408681721',
                                                                       'radios': [       {       'frequency': 5165,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '00:19:3b:09:a9:1b'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA'}]}],
                                         'manufacturer': 'LigoWave',
                                         'poller_hash': 'ABk7CoDx',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
