import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestMikrotikModels(DeviceTestCase):
    def test_mikrotik_mikrotik_60g_CubeG_5ac60ay_7_4_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.CubeG-5ac60ay.7.4.1.01")
        exp_info = {
                'model': 'CubeG-5ac60ay',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'sta_count': 1,
                'sw_version': '7.4.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 282493330855,
                'dl_en_packets': 359934336,
                'dl_noise_floor': None,
                'dl_rf_bytes': 282381732919,
                'dl_rf_packets': 317808191,
                'en_if_speed': 1000000000,
                'mem': 27.8533935546875,
                'serial_number': 'HCR08713BMQ',
                'ssid': 'damon20',
                'system_mac_address': '18:fd:74:3d:d1:05',
                'ul_en_bytes': 69225552014,
                'ul_en_packets': 161227621,
                'ul_noise_floor': None,
                'ul_rf_bytes': 68634069388,
                'ul_rf_packets': 159834417
        }
        exp_sta_stats = {
                '04:ce:14:fa:4b:dd': {       'alt_macs': {       '18:fd:74:3d:d1:ac',
                                                                 '18:fd:74:3d:d1:ad'},
                                             'dev_macs': {       '04:ce:14:fa:4b:df',
                                                                 '18:fd:74:3d:d1:ac',
                                                                 '5c:a6:e6:36:74:05'},
                                             'dl_link_rate': 2502000000,
                                             'dl_mcs': 10,
                                             'dl_noise_floor': -150.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -50.0,
                                             'dl_snr': 100.0,
                                             'ip_address': '10.4.0.125',
                                             'mac_address': '04:ce:14:fa:4b:dd',
                                             'name': '4246 - Chase Austin - (60ghz)',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': 3080000000,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -139.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '13',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '68634069388',
                                                              'in_ucast_pkts': '159834417',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '04:ce:14:fa:4b:df',
                                                                                                                        '18:fd:74:3d:d1:ac',
                                                                                                                        '5c:a6:e6:36:74:05'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '68634069388',
                                                                                       'in_ucast_pkts': '159834417',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:ce:14:fa:4b:dd',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '282381732919',
                                                                                       'out_ucast_pkts': '317808191'}],
                                                              'mac_address': '04:ce:14:fa:4b:df',
                                                              'mtu': 1500,
                                                              'name': 'wlan60',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '282381732919',
                                                              'out_ucast_pkts': '317808191',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 660,
                                                                                                                                            'mac_address': '04:ce:14:fa:4b:dd',
                                                                                                                                            'noise_floor': -139.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_link_rate': '3080000000',
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2502000000',
                                                                                                                                            'tx_mcs': 10}],
                                                                                                                   'noise_floor': -139.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'damon20'}],
                                                              'speed': '2502000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '42063599',
                                                              'in_octets': '282493330855',
                                                              'in_ucast_pkts': '317870737',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '18:fd:74:3d:d1:05',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1369332',
                                                              'out_octets': '69225552014',
                                                              'out_ucast_pkts': '159858289',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 27.853394,
                                'model': 'CubeG-5ac60ay',
                                'poller_hash': 'BM4U+kvf',
                                'serial_number': 'HCR08713BMQ',
                                'sw_version': '7.4.1',
                                'system_mac_address': '18:fd:74:3d:d1:05',
                                'uptime': '2108078'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '282381732919',
                                                                       'in_ucast_pkts': '317808191',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '282381732919',
                                                                                                'in_ucast_pkts': '317808191',
                                                                                                'mac_address': '04:ce:14:fa:4b:df',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '68634069388',
                                                                                                'out_ucast_pkts': '159834417'}],
                                                                       'mac_address': '04:ce:14:fa:4b:dd',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '68634069388',
                                                                       'out_ucast_pkts': '159834417',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 660,
                                                                                                                                                     'mac_address': '04:ce:14:fa:4b:df',
                                                                                                                                                     'noise_floor': -150.0,
                                                                                                                                                     'rssi': -50.0,
                                                                                                                                                     'rx_link_rate': '2502000000',
                                                                                                                                                     'rx_mcs': 10,
                                                                                                                                                     'snr': 100.0,
                                                                                                                                                     'tx_link_rate': '3080000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'damon20'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '68634069388',
                                                                       'in_ucast_pkts': '159834417',
                                                                       'name': 'ether1',
                                                                       'out_octets': '282381732919',
                                                                       'out_ucast_pkts': '317808191',
                                                                       'poller_hash': 'MDRjZTE0ZmE0YmRkZXRoZXIx'}],
                                         'management_ip': '10.4.0.125',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'CubeG-5ac60ay',
                                         'name': '4246 - Chase Austin - (60ghz)',
                                         'poller_hash': 'BM4U+kvd',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.4.1'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_CubeG_5ac60ay_SA_7_4_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.CubeG-5ac60ay-SA.7.4.1.01")
        exp_info = {
                'model': 'CubeG-5ac60ay-SA',
                'rf_chan_width': 2160,
                'rf_freq': 60480,
                'sta_count': 1,
                'sw_version': '7.4.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 223140538414,
                'dl_en_packets': 549017489,
                'dl_noise_floor': None,
                'dl_rf_bytes': 219430335281,
                'dl_rf_packets': 457400547,
                'en_if_speed': 1000000000,
                'mem': 28.96728515625,
                'serial_number': 'HCV080HXV2V',
                'ssid': 'UW_60PRO_AC_NE',
                'system_mac_address': '18:fd:74:5b:9b:a2',
                'ul_en_bytes': 116873546482,
                'ul_en_packets': 220234301,
                'ul_noise_floor': None,
                'ul_rf_bytes': 88733558184,
                'ul_rf_packets': 224186341
        }
        exp_sta_stats = {
                '04:ce:14:fa:4b:82': {       'alt_macs': None,
                                             'dev_macs': {       '04:ce:14:fa:50:6d',
                                                                 '24:5a:4c:e1:24:79'},
                                             'dl_link_rate': 962000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.21.166',
                                             'mac_address': '04:ce:14:fa:4b:82',
                                             'name': 'Conley and Amanda Banman',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 3,
                                             'ul_noise_floor': -103.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -63,
                                             'ul_snr': 40}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '88733558184',
                                                              'in_ucast_pkts': '224186341',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '04:ce:14:fa:50:6d',
                                                                                                                        '24:5a:4c:e1:24:79'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '83174057838',
                                                                                       'in_ucast_pkts': '218320821',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:ce:14:fa:4b:82',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '210528982733',
                                                                                       'out_ucast_pkts': '447277046'}],
                                                              'mac_address': '04:ce:14:fa:50:6d',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '219430335281',
                                                              'out_ucast_pkts': '457400547',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 60480,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 459,
                                                                                                                                            'mac_address': '04:ce:14:fa:4b:82',
                                                                                                                                            'noise_floor': -103.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_mcs': 3,
                                                                                                                                            'snr': 40.0,
                                                                                                                                            'tx_link_rate': '962000000'}],
                                                                                                                   'noise_floor': -103.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'UW_60PRO_AC_NE'}],
                                                              'speed': '962000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '92825114',
                                                              'in_octets': '223140538414',
                                                              'in_ucast_pkts': '456192375',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '18:fd:74:5b:9b:a2',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '236597',
                                                              'out_octets': '116873546482',
                                                              'out_ucast_pkts': '219997704',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 28.967285,
                                'model': 'CubeG-5ac60ay-SA',
                                'poller_hash': 'BM4U+lBt',
                                'serial_number': 'HCV080HXV2V',
                                'sw_version': '7.4.1',
                                'system_mac_address': '18:fd:74:5b:9b:a2',
                                'uptime': '2812862'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '210528982733',
                                                                       'in_ucast_pkts': '447277046',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '210528982733',
                                                                                                'in_ucast_pkts': '447277046',
                                                                                                'mac_address': '04:ce:14:fa:50:6d',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '83174057838',
                                                                                                'out_ucast_pkts': '218320821'}],
                                                                       'mac_address': '04:ce:14:fa:4b:82',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '83174057838',
                                                                       'out_ucast_pkts': '218320821',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 459,
                                                                                                                                                     'mac_address': '04:ce:14:fa:50:6d',
                                                                                                                                                     'rx_link_rate': '962000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'UW_60PRO_AC_NE'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '83174057838',
                                                                       'in_ucast_pkts': '218320821',
                                                                       'name': 'ether1',
                                                                       'out_octets': '210528982733',
                                                                       'out_ucast_pkts': '447277046',
                                                                       'poller_hash': 'MDRjZTE0ZmE0YjgyZXRoZXIx'}],
                                         'management_ip': '10.10.21.166',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'Conley and Amanda Banman',
                                         'poller_hash': 'BM4U+kuC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.4.1'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_Mikrotik_CubeG_5ac60ad_7_1_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.Mikrotik CubeG-5ac60ad.7.1.1.01")
        exp_info = {
                'model': 'CubeG-5ac60ad',
                'rf_chan_width': 2160,
                'rf_freq': 58320,
                'sta_count': 1,
                'sw_version': '7.1.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 3609080896469,
                'dl_en_packets': 3148186979,
                'dl_noise_floor': None,
                'dl_rf_bytes': 3612343681616,
                'dl_rf_packets': 3146733780,
                'en_if_speed': 1000000000,
                'mem': 27.7252197265625,
                'serial_number': 'E2A50D683204',
                'ssid': 'MikroTik-f6083',
                'system_mac_address': '08:55:31:f6:00:83',
                'ul_en_bytes': 260513078614,
                'ul_en_packets': 1365817029,
                'ul_noise_floor': None,
                'ul_rf_bytes': 258929083328,
                'ul_rf_packets': 1471314760
        }
        exp_sta_stats = {
                '08:55:31:f6:01:03': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '08:55:31:f6:01:03',
                                             'name': 'MTik 60ghz Hasley Macdonald '
                                                     'Slave',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -144.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '258929083328',
                                                              'in_ucast_pkts': '1471314760',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '258749789770',
                                                                                       'in_ucast_pkts': '1469318330',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '08:55:31:f6:01:03',
                                                                                       'out_discards': '241',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3612337764252',
                                                                                       'out_ucast_pkts': '3146727667'}],
                                                              'mac_address': '08:55:31:f6:00:84',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '241',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '3612343681616',
                                                              'out_ucast_pkts': '3146733780',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 416,
                                                                                                                                            'mac_address': '08:55:31:f6:01:03',
                                                                                                                                            'noise_floor': -144.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -144.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MikroTik-f6083'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '122710844',
                                                              'in_octets': '3609080896469',
                                                              'in_ucast_pkts': '3025476135',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '08:55:31:f6:00:83',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '16806909',
                                                              'out_octets': '260513078614',
                                                              'out_ucast_pkts': '1349010120',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 27.72522,
                                'model': 'CubeG-5ac60ad',
                                'poller_hash': 'CFUx9gCE',
                                'serial_number': 'E2A50D683204',
                                'sw_version': '7.1.1',
                                'system_mac_address': '08:55:31:f6:00:83',
                                'uptime': '20588963'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '241',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3612337764252',
                                                                       'in_ucast_pkts': '3146727667',
                                                                       'links': [       {       'in_discards': '241',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3612337764252',
                                                                                                'in_ucast_pkts': '3146727667',
                                                                                                'mac_address': '08:55:31:f6:00:84',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '258749789770',
                                                                                                'out_ucast_pkts': '1469318330'}],
                                                                       'mac_address': '08:55:31:f6:01:03',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '258749789770',
                                                                       'out_ucast_pkts': '1469318330',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 416,
                                                                                                                                                     'mac_address': '08:55:31:f6:00:84',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MikroTik-f6083'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '258749789770',
                                                                       'in_ucast_pkts': '1469318330',
                                                                       'name': 'ether1',
                                                                       'out_octets': '3612337764252',
                                                                       'out_ucast_pkts': '3146727667',
                                                                       'poller_hash': 'MDg1NTMxZjYwMTAzZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': 'MTik 60ghz Hasley Macdonald Slave',
                                         'poller_hash': 'CFUx9gED',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.1.1'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_Mikrotik_RB_CubeG_5ac60ad_6_48_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.Mikrotik RB CubeG-5ac60ad.6.48.1.01")
        exp_info = {
                'model': 'RB CubeG-5ac60ad',
                'rf_chan_width': 2160,
                'rf_freq': 62640,
                'sta_count': 1,
                'sw_version': '6.48.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 1,
                'dl_en_bytes': 456167866220,
                'dl_en_packets': 10317422468,
                'dl_noise_floor': None,
                'dl_rf_bytes': 455339172455,
                'dl_rf_packets': 5169057167,
                'en_if_speed': 1000000000,
                'mem': 20.220947265625,
                'serial_number': 'E2A40E8D0F56',
                'ssid': 'MikroTik-4c9b4',
                'system_mac_address': '2c:c8:1b:4c:09:b4',
                'ul_en_bytes': 11778577445,
                'ul_en_packets': 30485052,
                'ul_noise_floor': None,
                'ul_rf_bytes': 9220494582,
                'ul_rf_packets': 103609274
        }
        exp_sta_stats = {
                '2c:c8:1b:4c:09:b2': {       'alt_macs': None,
                                             'dev_macs': set(),
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '192.168.88.3',
                                             'mac_address': '2c:c8:1b:4c:09:b2',
                                             'name': 'CSCD-Client',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -137.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -57,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 1.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '9220494582',
                                                              'in_ucast_pkts': '103609274',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '9215123069',
                                                                                       'in_ucast_pkts': '103350941',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '2c:c8:1b:4c:09:b2',
                                                                                       'out_discards': '4091',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '455203677631',
                                                                                       'out_ucast_pkts': '5167483438'}],
                                                              'mac_address': '2c:c8:1b:4c:09:b5',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '4091',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '455339172455',
                                                              'out_ucast_pkts': '5169057167',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 505,
                                                                                                                                            'mac_address': '2c:c8:1b:4c:09:b2',
                                                                                                                                            'noise_floor': -137.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -137.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MikroTik-4c9b4'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '5140695866',
                                                              'in_octets': '456167866220',
                                                              'in_ucast_pkts': '5176726602',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '2c:c8:1b:4c:09:b4',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '6316196',
                                                              'out_octets': '11778577445',
                                                              'out_ucast_pkts': '24168856',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 20.220947,
                                'model': 'RB CubeG-5ac60ad',
                                'poller_hash': 'LMgbTAm1',
                                'serial_number': 'E2A40E8D0F56',
                                'sw_version': '6.48.1',
                                'system_mac_address': '2c:c8:1b:4c:09:b4',
                                'uptime': '9234400'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '4091',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '455203677631',
                                                                       'in_ucast_pkts': '5167483438',
                                                                       'links': [       {       'in_discards': '4091',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '455203677631',
                                                                                                'in_ucast_pkts': '5167483438',
                                                                                                'mac_address': '2c:c8:1b:4c:09:b5',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '9215123069',
                                                                                                'out_ucast_pkts': '103350941'}],
                                                                       'mac_address': '2c:c8:1b:4c:09:b2',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '9215123069',
                                                                       'out_ucast_pkts': '103350941',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 505,
                                                                                                                                                     'mac_address': '2c:c8:1b:4c:09:b5',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MikroTik-4c9b4'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '9215123069',
                                                                       'in_ucast_pkts': '103350941',
                                                                       'name': 'ether1',
                                                                       'out_octets': '455203677631',
                                                                       'out_ucast_pkts': '5167483438',
                                                                       'poller_hash': 'MmNjODFiNGMwOWIyZXRoZXIx'}],
                                         'management_ip': '192.168.88.3',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'CSCD-Client',
                                         'poller_hash': 'LMgbTAmy',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.48.1'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_nRAYG_60ad_7_3_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.nRAYG-60ad.7.3.1.01")
        exp_info = {
                'model': 'nRAYG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 58320,
                'sta_count': 1,
                'sw_version': '7.3.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 11,
                'dl_en_bytes': 93662988795676,
                'dl_en_packets': 140958190278,
                'dl_noise_floor': None,
                'dl_rf_bytes': 93662033349142,
                'dl_rf_packets': 139973765321,
                'en_if_speed': 1000000000,
                'mem': 54.345703125,
                'serial_number': 'DB8C0D328AEB',
                'ssid': 'AN-CPE-CPW-TIK',
                'system_mac_address': '08:55:31:56:ed:e5',
                'ul_en_bytes': 175220759806802,
                'ul_en_packets': 199046487497,
                'ul_noise_floor': None,
                'ul_rf_bytes': 175215795703673,
                'ul_rf_packets': 198950202522
        }
        exp_sta_stats = {
                '08:55:31:54:d8:e8': {       'alt_macs': {'08:55:31:54:d8:e7'},
                                             'dev_macs': {       '00:0b:78:66:f2:8d',
                                                                 '00:90:0b:4f:de:12',
                                                                 '00:90:0b:4f:de:2a',
                                                                 '00:90:7f:07:c9:ce',
                                                                 '00:c0:b7:74:cd:d8',
                                                                 '00:e0:67:2b:a7:ba',
                                                                 '08:55:31:06:c1:fd',
                                                                 '08:55:31:0c:0f:43',
                                                                 '08:55:31:0c:0f:4a',
                                                                 '08:55:31:42:29:23',
                                                                 '08:55:31:42:29:2a',
                                                                 '08:55:31:56:ed:e6',
                                                                 '08:55:31:91:84:f3',
                                                                 '0c:75:bd:96:ac:85',
                                                                 '18:e8:29:40:f1:6d',
                                                                 '18:fd:74:10:04:51',
                                                                 '18:fd:74:19:78:0e',
                                                                 '24:5a:4c:0e:15:ce',
                                                                 '24:5a:4c:5f:0c:7a',
                                                                 '24:5a:4c:5f:0c:92',
                                                                 '24:5a:4c:e2:71:d2',
                                                                 '24:5a:4c:e2:7a:39',
                                                                 '2c:c8:1b:e1:b4:5b',
                                                                 '2c:c8:1b:e1:b4:61',
                                                                 '48:8f:5a:21:99:41',
                                                                 '48:8f:5a:45:2e:63',
                                                                 '48:8f:5a:45:2e:8a',
                                                                 '48:8f:5a:7e:b0:98',
                                                                 '48:8f:5a:81:6b:27',
                                                                 '64:12:25:4d:bd:70',
                                                                 '70:4c:a5:cf:13:bd',
                                                                 '74:4d:28:f0:c1:f3',
                                                                 '74:83:c2:52:75:a9',
                                                                 '74:83:c2:64:ae:21',
                                                                 '74:83:c2:64:bd:93',
                                                                 '74:ac:b9:47:35:09',
                                                                 '74:ac:b9:fe:a0:bc',
                                                                 '78:8a:20:1c:32:b9',
                                                                 '78:8a:20:ac:16:bd',
                                                                 '78:8a:20:e4:2e:e1',
                                                                 '78:8a:20:e4:95:1b',
                                                                 '80:2a:a8:a4:07:bd',
                                                                 '94:56:41:64:fe:17',
                                                                 '9c:3d:cf:5b:21:c6',
                                                                 'b4:fb:e4:68:0d:05',
                                                                 'cc:2d:e0:9d:ff:7f',
                                                                 'd4:76:a0:52:44:a8',
                                                                 'e0:63:da:62:5f:8e',
                                                                 'e0:63:da:d2:52:82',
                                                                 'e0:63:da:dc:48:80',
                                                                 'ec:13:b2:92:df:e8',
                                                                 'ec:b9:07:02:89:57',
                                                                 'f4:92:bf:32:b2:50',
                                                                 'f4:92:bf:bc:8d:0e',
                                                                 'f4:92:bf:f8:f2:f9',
                                                                 'fc:ec:da:6c:3a:20',
                                                                 'fc:ec:da:dc:94:a5',
                                                                 'fc:ec:da:dc:ff:2b'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '08:55:31:54:d8:e8',
                                             'name': 'CPW-CPE SU',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -131.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -51,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 11.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '974634286',
                                                              'in_octets': '93662988795676',
                                                              'in_ucast_pkts': '139983555992',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '08:55:31:56:ed:e5',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '82750177',
                                                              'out_octets': '175220759806802',
                                                              'out_ucast_pkts': '198963737320',
                                                              'speed': '1000000000',
                                                              'type': 6},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '175215795703673',
                                                              'in_ucast_pkts': '198950202522',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '00:0b:78:66:f2:8d',
                                                                                                                        '00:90:0b:4f:de:12',
                                                                                                                        '00:90:0b:4f:de:2a',
                                                                                                                        '00:90:7f:07:c9:ce',
                                                                                                                        '00:c0:b7:74:cd:d8',
                                                                                                                        '00:e0:67:2b:a7:ba',
                                                                                                                        '08:55:31:06:c1:fd',
                                                                                                                        '08:55:31:0c:0f:43',
                                                                                                                        '08:55:31:0c:0f:4a',
                                                                                                                        '08:55:31:42:29:23',
                                                                                                                        '08:55:31:42:29:2a',
                                                                                                                        '08:55:31:56:ed:e6',
                                                                                                                        '08:55:31:91:84:f3',
                                                                                                                        '0c:75:bd:96:ac:85',
                                                                                                                        '18:e8:29:40:f1:6d',
                                                                                                                        '18:fd:74:10:04:51',
                                                                                                                        '18:fd:74:19:78:0e',
                                                                                                                        '24:5a:4c:0e:15:ce',
                                                                                                                        '24:5a:4c:5f:0c:7a',
                                                                                                                        '24:5a:4c:5f:0c:92',
                                                                                                                        '24:5a:4c:e2:71:d2',
                                                                                                                        '24:5a:4c:e2:7a:39',
                                                                                                                        '2c:c8:1b:e1:b4:5b',
                                                                                                                        '2c:c8:1b:e1:b4:61',
                                                                                                                        '48:8f:5a:21:99:41',
                                                                                                                        '48:8f:5a:45:2e:63',
                                                                                                                        '48:8f:5a:45:2e:8a',
                                                                                                                        '48:8f:5a:7e:b0:98',
                                                                                                                        '48:8f:5a:81:6b:27',
                                                                                                                        '64:12:25:4d:bd:70',
                                                                                                                        '70:4c:a5:cf:13:bd',
                                                                                                                        '74:4d:28:f0:c1:f3',
                                                                                                                        '74:83:c2:52:75:a9',
                                                                                                                        '74:83:c2:64:ae:21',
                                                                                                                        '74:83:c2:64:bd:93',
                                                                                                                        '74:ac:b9:47:35:09',
                                                                                                                        '74:ac:b9:fe:a0:bc',
                                                                                                                        '78:8a:20:1c:32:b9',
                                                                                                                        '78:8a:20:ac:16:bd',
                                                                                                                        '78:8a:20:e4:2e:e1',
                                                                                                                        '78:8a:20:e4:95:1b',
                                                                                                                        '80:2a:a8:a4:07:bd',
                                                                                                                        '94:56:41:64:fe:17',
                                                                                                                        '9c:3d:cf:5b:21:c6',
                                                                                                                        'b4:fb:e4:68:0d:05',
                                                                                                                        'cc:2d:e0:9d:ff:7f',
                                                                                                                        'd4:76:a0:52:44:a8',
                                                                                                                        'e0:63:da:62:5f:8e',
                                                                                                                        'e0:63:da:d2:52:82',
                                                                                                                        'e0:63:da:dc:48:80',
                                                                                                                        'ec:13:b2:92:df:e8',
                                                                                                                        'ec:b9:07:02:89:57',
                                                                                                                        'f4:92:bf:32:b2:50',
                                                                                                                        'f4:92:bf:bc:8d:0e',
                                                                                                                        'f4:92:bf:f8:f2:f9',
                                                                                                                        'fc:ec:da:6c:3a:20',
                                                                                                                        'fc:ec:da:dc:94:a5',
                                                                                                                        'fc:ec:da:dc:ff:2b'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '175215795703673',
                                                                                       'in_ucast_pkts': '198950202522',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '08:55:31:54:d8:e8',
                                                                                       'out_discards': '805',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '93662033349142',
                                                                                       'out_ucast_pkts': '139973765321'}],
                                                              'mac_address': '08:55:31:56:ed:e6',
                                                              'mtu': 1500,
                                                              'name': 'wlan60',
                                                              'oper_up': True,
                                                              'out_discards': '805',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '93662033349142',
                                                              'out_ucast_pkts': '139973765321',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 77,
                                                                                                                                            'mac_address': '08:55:31:54:d8:e8',
                                                                                                                                            'noise_floor': -131.0,
                                                                                                                                            'rssi': -51.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -131.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'AN-CPE-CPW-TIK'}],
                                                              'speed': '2310000000',
                                                              'type': 71}],
                                'manufacturer': 'Mikrotik',
                                'mem': 54.345703,
                                'model': 'nRAYG-60ad',
                                'poller_hash': 'CFUxVu3m',
                                'serial_number': 'DB8C0D328AEB',
                                'sw_version': '7.3.1',
                                'system_mac_address': '08:55:31:56:ed:e5',
                                'uptime': '26927235'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '805',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '93662033349142',
                                                                       'in_ucast_pkts': '139973765321',
                                                                       'links': [       {       'in_discards': '805',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '93662033349142',
                                                                                                'in_ucast_pkts': '139973765321',
                                                                                                'mac_address': '08:55:31:56:ed:e6',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '175215795703673',
                                                                                                'out_ucast_pkts': '198950202522'}],
                                                                       'mac_address': '08:55:31:54:d8:e8',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '175215795703673',
                                                                       'out_ucast_pkts': '198950202522',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 77,
                                                                                                                                                     'mac_address': '08:55:31:56:ed:e6',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'AN-CPE-CPW-TIK'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '175215795703673',
                                                                       'in_ucast_pkts': '198950202522',
                                                                       'mac_address': '08:55:31:54:d8:e7',
                                                                       'name': 'ether1',
                                                                       'out_octets': '93662033349142',
                                                                       'out_ucast_pkts': '139973765321',
                                                                       'poller_hash': 'MDg1NTMxNTRkOGU4ZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': 'CPW-CPE SU',
                                         'poller_hash': 'CFUxVNjo',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '7.3.1',
                                         'system_mac_address': '08:55:31:54:d8:e7'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RB_CubeG_5ac60ay_6_49_6_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RB CubeG-5ac60ay.6.49.6.01")
        exp_info = {
                'model': 'RB CubeG-5ac60ay',
                'rf_chan_width': 2160,
                'rf_freq': 58320,
                'sta_count': 1,
                'sw_version': '6.49.6',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 164409900857,
                'dl_en_packets': 385651643,
                'dl_noise_floor': None,
                'dl_rf_bytes': 164530826600,
                'dl_rf_packets': 268403250,
                'en_if_speed': 1000000000,
                'mem': 22.2564697265625,
                'serial_number': 'HCK083N7KKQ',
                'ssid': 'UW_PTP_3_TO_BIGSTARR',
                'system_mac_address': '18:fd:74:15:c0:df',
                'ul_en_bytes': 20776369030,
                'ul_en_packets': 80855043,
                'ul_noise_floor': None,
                'ul_rf_bytes': 20804124906,
                'ul_rf_packets': 108991554
        }
        exp_sta_stats = {
                '04:ce:14:fc:60:36': {       'alt_macs': None,
                                             'dev_macs': {       '04:ce:14:fc:5f:bd',
                                                                 '18:fd:74:15:c0:e7',
                                                                 '48:8f:5a:ac:f6:28'},
                                             'dl_link_rate': 2502000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.22.33',
                                             'mac_address': '04:ce:14:fc:60:36',
                                             'name': 'UW_PTP_3_TO_BIGSTARR_2',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -118.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -38,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '20804124906',
                                                              'in_ucast_pkts': '108991554',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '04:ce:14:fc:5f:bd',
                                                                                                                        '18:fd:74:15:c0:e7',
                                                                                                                        '48:8f:5a:ac:f6:28'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '20804124906',
                                                                                       'in_ucast_pkts': '108991554',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:ce:14:fc:60:36',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '164530826600',
                                                                                       'out_ucast_pkts': '268403250'}],
                                                              'mac_address': '04:ce:14:fc:5f:bd',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '164530826600',
                                                              'out_ucast_pkts': '268403250',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 48,
                                                                                                                                            'mac_address': '04:ce:14:fc:60:36',
                                                                                                                                            'noise_floor': -118.0,
                                                                                                                                            'rssi': -38.0,
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2502000000'}],
                                                                                                                   'noise_floor': -118.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'UW_PTP_3_TO_BIGSTARR'}],
                                                              'speed': '2502000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '122909164',
                                                              'in_octets': '164409900857',
                                                              'in_ucast_pkts': '262742479',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '18:fd:74:15:c0:df',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '2450263',
                                                              'out_octets': '20776369030',
                                                              'out_ucast_pkts': '78404780',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 22.25647,
                                'model': 'RB CubeG-5ac60ay',
                                'poller_hash': 'BM4U/F+9',
                                'serial_number': 'HCK083N7KKQ',
                                'sw_version': '6.49.6',
                                'system_mac_address': '18:fd:74:15:c0:df',
                                'uptime': '3976582'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '164530826600',
                                                                       'in_ucast_pkts': '268403250',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '164530826600',
                                                                                                'in_ucast_pkts': '268403250',
                                                                                                'mac_address': '04:ce:14:fc:5f:bd',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '20804124906',
                                                                                                'out_ucast_pkts': '108991554'}],
                                                                       'mac_address': '04:ce:14:fc:60:36',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '20804124906',
                                                                       'out_ucast_pkts': '108991554',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 48,
                                                                                                                                                     'mac_address': '04:ce:14:fc:5f:bd',
                                                                                                                                                     'rx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'UW_PTP_3_TO_BIGSTARR'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '20804124906',
                                                                       'in_ucast_pkts': '108991554',
                                                                       'name': 'ether1',
                                                                       'out_octets': '164530826600',
                                                                       'out_ucast_pkts': '268403250',
                                                                       'poller_hash': 'MDRjZTE0ZmM2MDM2ZXRoZXIx'}],
                                         'management_ip': '10.10.22.33',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'UW_PTP_3_TO_BIGSTARR_2',
                                         'poller_hash': 'BM4U/GA2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.49.6'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RB_CubeG_5ac60ay_SA_6_49_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RB CubeG-5ac60ay-SA.6.49.01")
        exp_info = {
                'model': 'RB CubeG-5ac60ay-SA',
                'rf_chan_width': 2160,
                'rf_freq': 62640,
                'sta_count': 6,
                'sw_version': '6.49',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 13633187406697,
                'dl_en_packets': 11128551936,
                'dl_noise_floor': None,
                'dl_rf_bytes': 13813645422772,
                'dl_rf_packets': 13097995126,
                'en_if_speed': 1000000000,
                'mem': 21.80633544921875,
                'serial_number': 'HCW08AZ1DN5',
                'ssid': 'foothills2ay-ap2',
                'system_mac_address': '18:fd:74:61:31:31',
                'ul_en_bytes': 788413175194,
                'ul_en_packets': 4308660950,
                'ul_noise_floor': None,
                'ul_rf_bytes': 802212036390,
                'ul_rf_packets': 4805684355
        }
        exp_sta_stats = {
                '04:ce:14:fa:4b:eb': {       'alt_macs': None,
                                             'dev_macs': {       '08:55:31:2b:9a:b1',
                                                                 '18:fd:74:3d:cf:97'},
                                             'dl_link_rate': 1540000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:ce:14:fa:4b:eb',
                                             'name': '18:FD:74:3D:CF:97 Stevens-42070',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 6,
                                             'ul_noise_floor': -145.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55,
                                             'ul_snr': 90},
                '04:ce:14:fc:62:97': {       'alt_macs': None,
                                             'dev_macs': {       '18:fd:74:14:d0:80',
                                                                 '48:a9:8a:01:0a:4a'},
                                             'dl_link_rate': 2502000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:ce:14:fc:62:97',
                                             'name': '18:FD:74:14:D0:80 Perris-41920',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 9,
                                             'ul_noise_floor': -151.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56,
                                             'ul_snr': 95},
                '08:55:31:75:38:c8': {       'alt_macs': {'08:55:31:75:38:c7'},
                                             'dev_macs': {'dc:2c:6e:b1:ed:33'},
                                             'dl_link_rate': 385000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '08:55:31:75:38:c8',
                                             'name': '08:55:31:75:38:C7 Bigler-41146',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 1,
                                             'ul_noise_floor': -75.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55,
                                             'ul_snr': 20},
                '18:fd:74:89:69:c5': {       'alt_macs': {'18:fd:74:89:69:c4'},
                                             'dev_macs': {'18:fd:74:68:59:e5'},
                                             'dl_link_rate': 385000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '18:fd:74:89:69:c5',
                                             'name': '18:FD:74:89:69:C4 Shakely-41710',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 1,
                                             'ul_noise_floor': -78.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58,
                                             'ul_snr': 20},
                '30:ab:6a:fc:db:69': {       'alt_macs': None,
                                             'dev_macs': {       '04:ce:14:fa:5f:a8',
                                                                 '08:55:31:3e:d4:f7',
                                                                 'dc:2c:6e:b3:c6:26'},
                                             'dl_link_rate': 1925000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '30:ab:6a:fc:db:69',
                                             'name': '08:55:31:3E:D4:F7 Orden-41342',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 7,
                                             'ul_noise_floor': -133.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -53,
                                             'ul_snr': 80},
                '48:8f:5a:e3:97:f8': {       'alt_macs': {'48:8f:5a:e3:97:f7'},
                                             'dev_macs': {'a4:13:4e:dd:09:c9'},
                                             'dl_link_rate': 1155000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '48:8f:5a:e3:97:f8',
                                             'name': '48:8F:5A:E3:97:F7 Takacs-36469',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 4,
                                             'ul_noise_floor': -108.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68,
                                             'ul_snr': 40}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '802212036390',
                                                              'in_ucast_pkts': '4805684355',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '04:ce:14:fa:5f:a8',
                                                                                                                        '08:55:31:3e:d4:f7',
                                                                                                                        'dc:2c:6e:b3:c6:26'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '50986127544',
                                                                                       'in_ucast_pkts': '410228222',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '30:ab:6a:fc:db:69',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1102136665996',
                                                                                       'out_ucast_pkts': '1325201236'},
                                                                               {       'bridged_mac_addresses': [       '18:fd:74:14:d0:80',
                                                                                                                        '48:a9:8a:01:0a:4a'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '49488542926',
                                                                                       'in_ucast_pkts': '539254445',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:ce:14:fc:62:97',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '974841618409',
                                                                                       'out_ucast_pkts': '1134937652'},
                                                                               {       'bridged_mac_addresses': [       '08:55:31:2b:9a:b1',
                                                                                                                        '18:fd:74:3d:cf:97'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '87562104195',
                                                                                       'in_ucast_pkts': '395427327',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:ce:14:fa:4b:eb',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '922150589627',
                                                                                       'out_ucast_pkts': '990451320'},
                                                                               {       'bridged_mac_addresses': [       '18:fd:74:68:59:e5'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '331731905068',
                                                                                       'in_ucast_pkts': '2060173646',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '18:fd:74:89:69:c5',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '6128846024836',
                                                                                       'out_ucast_pkts': '5065155187'},
                                                                               {       'bridged_mac_addresses': [       'a4:13:4e:dd:09:c9'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '154165700548',
                                                                                       'in_ucast_pkts': '971419233',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '48:8f:5a:e3:97:f8',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2844714221536',
                                                                                       'out_ucast_pkts': '2637075641'},
                                                                               {       'bridged_mac_addresses': [       'dc:2c:6e:b1:ed:33'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '90431076006',
                                                                                       'in_ucast_pkts': '340231793',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '08:55:31:75:38:c8',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1519229696952',
                                                                                       'out_ucast_pkts': '1666589828'}],
                                                              'mac_address': '04:ce:14:fa:5f:a8',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '13813645422772',
                                                              'out_ucast_pkts': '13097995126',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 110,
                                                                                                                                            'mac_address': '30:ab:6a:fc:db:69',
                                                                                                                                            'noise_floor': -133.0,
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_mcs': 7,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '1925000000'},
                                                                                                                                    {       'distance': 254,
                                                                                                                                            'mac_address': '04:ce:14:fc:62:97',
                                                                                                                                            'noise_floor': -151.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_mcs': 9,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2502000000'},
                                                                                                                                    {       'distance': 218,
                                                                                                                                            'mac_address': '04:ce:14:fa:4b:eb',
                                                                                                                                            'noise_floor': -145.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_mcs': 6,
                                                                                                                                            'snr': 90.0,
                                                                                                                                            'tx_link_rate': '1540000000'},
                                                                                                                                    {       'distance': 213,
                                                                                                                                            'mac_address': '18:fd:74:89:69:c5',
                                                                                                                                            'noise_floor': -78.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '385000000'},
                                                                                                                                    {       'distance': 675,
                                                                                                                                            'mac_address': '48:8f:5a:e3:97:f8',
                                                                                                                                            'noise_floor': -108.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_mcs': 4,
                                                                                                                                            'snr': 40.0,
                                                                                                                                            'tx_link_rate': '1155000000'},
                                                                                                                                    {       'distance': 675,
                                                                                                                                            'mac_address': '08:55:31:75:38:c8',
                                                                                                                                            'noise_floor': -75.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_mcs': 1,
                                                                                                                                            'snr': 20.0,
                                                                                                                                            'tx_link_rate': '385000000'}],
                                                                                                                   'noise_floor': -75.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'foothills2ay-ap2'}],
                                                              'speed': '2502000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '3',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '626959059',
                                                              'in_octets': '13633187406697',
                                                              'in_ucast_pkts': '10501592877',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '18:fd:74:61:31:31',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '8376875',
                                                              'out_octets': '788413175194',
                                                              'out_ucast_pkts': '4300284075',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.806335,
                                'model': 'RB CubeG-5ac60ay-SA',
                                'poller_hash': 'BM4U+l+o',
                                'serial_number': 'HCW08AZ1DN5',
                                'sw_version': '6.49',
                                'system_mac_address': '18:fd:74:61:31:31',
                                'uptime': '14854545'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1102136665996',
                                                                       'in_ucast_pkts': '1325201236',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1102136665996',
                                                                                                'in_ucast_pkts': '1325201236',
                                                                                                'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '50986127544',
                                                                                                'out_ucast_pkts': '410228222'}],
                                                                       'mac_address': '30:ab:6a:fc:db:69',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '50986127544',
                                                                       'out_ucast_pkts': '410228222',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 110,
                                                                                                                                                     'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                                                                     'rx_link_rate': '1925000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'foothills2ay-ap2'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '50986127544',
                                                                       'in_ucast_pkts': '410228222',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1102136665996',
                                                                       'out_ucast_pkts': '1325201236',
                                                                       'poller_hash': 'MzBhYjZhZmNkYjY5ZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': '08:55:31:3E:D4:F7 Orden-41342',
                                         'poller_hash': 'MKtq/Ntp',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.49'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '974841618409',
                                                                       'in_ucast_pkts': '1134937652',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '974841618409',
                                                                                                'in_ucast_pkts': '1134937652',
                                                                                                'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '49488542926',
                                                                                                'out_ucast_pkts': '539254445'}],
                                                                       'mac_address': '04:ce:14:fc:62:97',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '49488542926',
                                                                       'out_ucast_pkts': '539254445',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 254,
                                                                                                                                                     'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                                                                     'rx_link_rate': '2502000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'foothills2ay-ap2'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '49488542926',
                                                                       'in_ucast_pkts': '539254445',
                                                                       'name': 'ether1',
                                                                       'out_octets': '974841618409',
                                                                       'out_ucast_pkts': '1134937652',
                                                                       'poller_hash': 'MDRjZTE0ZmM2Mjk3ZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': '18:FD:74:14:D0:80 Perris-41920',
                                         'poller_hash': 'BM4U/GKX',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.49.3'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '922150589627',
                                                                       'in_ucast_pkts': '990451320',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '922150589627',
                                                                                                'in_ucast_pkts': '990451320',
                                                                                                'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '87562104195',
                                                                                                'out_ucast_pkts': '395427327'}],
                                                                       'mac_address': '04:ce:14:fa:4b:eb',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '87562104195',
                                                                       'out_ucast_pkts': '395427327',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 218,
                                                                                                                                                     'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                                                                     'rx_link_rate': '1540000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'foothills2ay-ap2'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '87562104195',
                                                                       'in_ucast_pkts': '395427327',
                                                                       'name': 'ether1',
                                                                       'out_octets': '922150589627',
                                                                       'out_ucast_pkts': '990451320',
                                                                       'poller_hash': 'MDRjZTE0ZmE0YmViZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': '18:FD:74:3D:CF:97 Stevens-42070',
                                         'poller_hash': 'BM4U+kvr',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.49'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '6128846024836',
                                                                       'in_ucast_pkts': '5065155187',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '6128846024836',
                                                                                                'in_ucast_pkts': '5065155187',
                                                                                                'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '331731905068',
                                                                                                'out_ucast_pkts': '2060173646'}],
                                                                       'mac_address': '18:fd:74:89:69:c5',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '331731905068',
                                                                       'out_ucast_pkts': '2060173646',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 213,
                                                                                                                                                     'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                                                                     'rx_link_rate': '385000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'foothills2ay-ap2'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '331731905068',
                                                                       'in_ucast_pkts': '2060173646',
                                                                       'mac_address': '18:fd:74:89:69:c4',
                                                                       'name': 'ether1',
                                                                       'out_octets': '6128846024836',
                                                                       'out_ucast_pkts': '5065155187',
                                                                       'poller_hash': 'MThmZDc0ODk2OWM1ZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': '18:FD:74:89:69:C4 Shakely-41710',
                                         'poller_hash': 'GP10iWnF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.49.6',
                                         'system_mac_address': '18:fd:74:89:69:c4'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2844714221536',
                                                                       'in_ucast_pkts': '2637075641',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2844714221536',
                                                                                                'in_ucast_pkts': '2637075641',
                                                                                                'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '154165700548',
                                                                                                'out_ucast_pkts': '971419233'}],
                                                                       'mac_address': '48:8f:5a:e3:97:f8',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '154165700548',
                                                                       'out_ucast_pkts': '971419233',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 675,
                                                                                                                                                     'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                                                                     'rx_link_rate': '1155000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'foothills2ay-ap2'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '154165700548',
                                                                       'in_ucast_pkts': '971419233',
                                                                       'mac_address': '48:8f:5a:e3:97:f7',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2844714221536',
                                                                       'out_ucast_pkts': '2637075641',
                                                                       'poller_hash': 'NDg4ZjVhZTM5N2Y4ZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': '48:8F:5A:E3:97:F7 Takacs-36469',
                                         'poller_hash': 'SI9a45f4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.49',
                                         'system_mac_address': '48:8f:5a:e3:97:f7'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1519229696952',
                                                                       'in_ucast_pkts': '1666589828',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1519229696952',
                                                                                                'in_ucast_pkts': '1666589828',
                                                                                                'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '90431076006',
                                                                                                'out_ucast_pkts': '340231793'}],
                                                                       'mac_address': '08:55:31:75:38:c8',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '90431076006',
                                                                       'out_ucast_pkts': '340231793',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 675,
                                                                                                                                                     'mac_address': '04:ce:14:fa:5f:a8',
                                                                                                                                                     'rx_link_rate': '385000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'foothills2ay-ap2'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '90431076006',
                                                                       'in_ucast_pkts': '340231793',
                                                                       'mac_address': '08:55:31:75:38:c7',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1519229696952',
                                                                       'out_ucast_pkts': '1666589828',
                                                                       'poller_hash': 'MDg1NTMxNzUzOGM4ZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': '08:55:31:75:38:C7 Bigler-41146',
                                         'poller_hash': 'CFUxdTjI',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.49',
                                         'system_mac_address': '08:55:31:75:38:c7'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBLHGG_60ad_6_44_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBLHGG-60ad.6.44.1.01")
        exp_info = {
                'model': 'RBLHGG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 58320,
                'sta_count': 1,
                'sw_version': '6.44.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 1593727279493,
                'dl_en_packets': 1496462907,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1585473194386,
                'dl_rf_packets': 1460876111,
                'en_if_speed': 1000000000,
                'mem': 20.11260986328125,
                'serial_number': '90CB0900EA5E',
                'ssid': 'MikroTik-934cb7',
                'system_mac_address': 'b8:69:f4:93:4c:b7',
                'ul_en_bytes': 142466847457,
                'ul_en_packets': 816657899,
                'ul_noise_floor': None,
                'ul_rf_bytes': 136809976320,
                'ul_rf_packets': 783104687
        }
        exp_sta_stats = {
                'b8:69:f4:93:4c:64': {       'alt_macs': {'b8:69:f4:93:4c:63'},
                                             'dev_macs': {       '00:0b:82:d3:65:46',
                                                                 '00:0b:82:d7:35:64',
                                                                 '00:15:6d:9c:16:09',
                                                                 '00:27:22:06:e0:ef',
                                                                 '18:e8:29:34:d5:d5',
                                                                 '18:e8:29:8c:a9:a8',
                                                                 '60:02:b4:53:a6:1d',
                                                                 '64:d1:54:ef:e1:c5',
                                                                 '64:d1:54:ef:e1:c6',
                                                                 '74:4d:28:2a:b2:36',
                                                                 '74:4d:28:81:1b:40',
                                                                 '74:4d:28:be:f2:7f',
                                                                 '74:4d:28:bf:cf:c3',
                                                                 '74:4d:28:bf:cf:c7',
                                                                 '74:4d:28:bf:da:d6',
                                                                 '76:4d:28:59:83:d9',
                                                                 '80:97:1b:00:cd:57',
                                                                 'b4:fb:e4:19:3e:e0',
                                                                 'b4:fb:e4:4f:04:6f',
                                                                 'b4:fb:e4:6a:5f:7b',
                                                                 'b4:fb:e4:6a:67:c9',
                                                                 'b8:69:f4:0c:3d:58',
                                                                 'b8:69:f4:93:4c:b8',
                                                                 'b8:69:f4:ca:3c:51',
                                                                 'cc:2d:e0:ed:fb:ac',
                                                                 'cc:2d:e0:ed:fb:ad',
                                                                 'fc:ec:da:dc:cb:85'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:69:f4:93:4c:64',
                                             'name': 'GMBH_Morty',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -141.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '136809976320',
                                                              'in_ucast_pkts': '783104687',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '00:0b:82:d3:65:46',
                                                                                                                        '00:0b:82:d7:35:64',
                                                                                                                        '00:15:6d:9c:16:09',
                                                                                                                        '00:27:22:06:e0:ef',
                                                                                                                        '18:e8:29:34:d5:d5',
                                                                                                                        '18:e8:29:8c:a9:a8',
                                                                                                                        '60:02:b4:53:a6:1d',
                                                                                                                        '64:d1:54:ef:e1:c5',
                                                                                                                        '64:d1:54:ef:e1:c6',
                                                                                                                        '74:4d:28:2a:b2:36',
                                                                                                                        '74:4d:28:81:1b:40',
                                                                                                                        '74:4d:28:be:f2:7f',
                                                                                                                        '74:4d:28:bf:cf:c3',
                                                                                                                        '74:4d:28:bf:cf:c7',
                                                                                                                        '74:4d:28:bf:da:d6',
                                                                                                                        '76:4d:28:59:83:d9',
                                                                                                                        '80:97:1b:00:cd:57',
                                                                                                                        'b4:fb:e4:19:3e:e0',
                                                                                                                        'b4:fb:e4:4f:04:6f',
                                                                                                                        'b4:fb:e4:6a:5f:7b',
                                                                                                                        'b4:fb:e4:6a:67:c9',
                                                                                                                        'b8:69:f4:0c:3d:58',
                                                                                                                        'b8:69:f4:93:4c:b8',
                                                                                                                        'b8:69:f4:ca:3c:51',
                                                                                                                        'cc:2d:e0:ed:fb:ac',
                                                                                                                        'cc:2d:e0:ed:fb:ad',
                                                                                                                        'fc:ec:da:dc:cb:85'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '136809976320',
                                                                                       'in_ucast_pkts': '783104687',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': 'b8:69:f4:93:4c:64',
                                                                                       'out_discards': '487',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1585473194386',
                                                                                       'out_ucast_pkts': '1460876111'}],
                                                              'mac_address': 'b8:69:f4:93:4c:b8',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '487',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1585473194386',
                                                              'out_ucast_pkts': '1460876111',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 1286,
                                                                                                                                            'mac_address': 'b8:69:f4:93:4c:64',
                                                                                                                                            'noise_floor': -141.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -141.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MikroTik-934cb7'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1593727279493',
                                                              'in_ucast_pkts': '1496462907',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'b8:69:f4:93:4c:b7',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '142466847457',
                                                              'out_ucast_pkts': '816657899',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 20.11261,
                                'model': 'RBLHGG-60ad',
                                'poller_hash': 'uGn0k0y4',
                                'serial_number': '90CB0900EA5E',
                                'sw_version': '6.44.1',
                                'system_mac_address': 'b8:69:f4:93:4c:b7',
                                'uptime': '5311892'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '487',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1585473194386',
                                                                       'in_ucast_pkts': '1460876111',
                                                                       'links': [       {       'in_discards': '487',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1585473194386',
                                                                                                'in_ucast_pkts': '1460876111',
                                                                                                'mac_address': 'b8:69:f4:93:4c:b8',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '136809976320',
                                                                                                'out_ucast_pkts': '783104687'}],
                                                                       'mac_address': 'b8:69:f4:93:4c:64',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '136809976320',
                                                                       'out_ucast_pkts': '783104687',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 1286,
                                                                                                                                                     'mac_address': 'b8:69:f4:93:4c:b8',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MikroTik-934cb7'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '136809976320',
                                                                       'in_ucast_pkts': '783104687',
                                                                       'mac_address': 'b8:69:f4:93:4c:63',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1585473194386',
                                                                       'out_ucast_pkts': '1460876111',
                                                                       'poller_hash': 'Yjg2OWY0OTM0YzY0ZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': 'GMBH_Morty',
                                         'poller_hash': 'uGn0k0xk',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.44.1',
                                         'system_mac_address': 'b8:69:f4:93:4c:63'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBLHGG_60ad_None_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBLHGG-60ad.None.01")
        exp_info = {
                'model': 'RBLHGG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 62640,
                'sta_count': 1,
                'sw_version': '6.44.1',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 344216361050,
                'dl_en_packets': 1938397108,
                'dl_noise_floor': None,
                'dl_rf_bytes': 343571794449,
                'dl_rf_packets': 1931847940,
                'en_if_speed': 1000000000,
                'mem': 19.78912353515625,
                'serial_number': '9B9D094B966D',
                'ssid': 'MikroTik-544668',
                'system_mac_address': 'b8:69:f4:54:46:68',
                'ul_en_bytes': 351800761603,
                'ul_en_packets': 2013228405,
                'ul_noise_floor': None,
                'ul_rf_bytes': 345626457565,
                'ul_rf_packets': 2004807368
        }
        exp_sta_stats = {
                '24:18:1d:92:0c:d1': {       'alt_macs': None,
                                             'dev_macs': {       '24:18:1d:92:0a:0e',
                                                                 'b8:69:f4:1d:a5:73',
                                                                 'b8:69:f4:54:46:5f'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.0.1.149',
                                             'mac_address': '24:18:1d:92:0c:d1',
                                             'name': 'C1303-PTP-CPE',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -145.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -65,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '345626457565',
                                                              'in_ucast_pkts': '2004807368',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '24:18:1d:92:0a:0e',
                                                                                                                        'b8:69:f4:1d:a5:73',
                                                                                                                        'b8:69:f4:54:46:5f'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '345626457565',
                                                                                       'in_ucast_pkts': '2004807368',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:92:0c:d1',
                                                                                       'out_discards': '4705',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '343571794449',
                                                                                       'out_ucast_pkts': '1931847940'}],
                                                              'mac_address': '24:18:1d:92:0a:0e',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '4705',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '343571794449',
                                                              'out_ucast_pkts': '1931847940',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 548,
                                                                                                                                            'mac_address': '24:18:1d:92:0c:d1',
                                                                                                                                            'noise_floor': -145.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -145.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MikroTik-544668'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '344216361050',
                                                              'in_ucast_pkts': '1938397108',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'b8:69:f4:54:46:68',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '351800761603',
                                                              'out_ucast_pkts': '2013228405',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 19.789124,
                                'model': 'RBLHGG-60ad',
                                'poller_hash': 'JBgdkgoO',
                                'serial_number': '9B9D094B966D',
                                'sw_version': '6.44.1',
                                'system_mac_address': 'b8:69:f4:54:46:68',
                                'uptime': '15074000'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '4705',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '343571794449',
                                                                       'in_ucast_pkts': '1931847940',
                                                                       'links': [       {       'in_discards': '4705',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '343571794449',
                                                                                                'in_ucast_pkts': '1931847940',
                                                                                                'mac_address': '24:18:1d:92:0a:0e',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '345626457565',
                                                                                                'out_ucast_pkts': '2004807368'}],
                                                                       'mac_address': '24:18:1d:92:0c:d1',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '345626457565',
                                                                       'out_ucast_pkts': '2004807368',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 548,
                                                                                                                                                     'mac_address': '24:18:1d:92:0a:0e',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MikroTik-544668'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '345626457565',
                                                                       'in_ucast_pkts': '2004807368',
                                                                       'name': 'ether1',
                                                                       'out_octets': '343571794449',
                                                                       'out_ucast_pkts': '1931847940',
                                                                       'poller_hash': 'MjQxODFkOTIwY2QxZXRoZXIx'}],
                                         'management_ip': '10.0.1.149',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'C1303-PTP-CPE',
                                         'poller_hash': 'JBgdkgzR',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.44.1'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_6_42_12_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad.6.42.12.01")
        exp_info = {
                'model': 'RBwAPG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 62640,
                'sta_count': 2,
                'sw_version': '6.42.12',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 575482089922,
                'dl_en_packets': 4763690380,
                'dl_noise_floor': None,
                'dl_rf_bytes': 11263202233028,
                'dl_rf_packets': 16920802575,
                'en_if_speed': 1000000000,
                'mem': 21.9268798828125,
                'serial_number': '8B94079AD7B4',
                'ssid': 'new60hotness',
                'system_mac_address': '64:d1:54:ee:17:96',
                'ul_en_bytes': 13843331039168,
                'ul_en_packets': 10108908581,
                'ul_noise_floor': None,
                'ul_rf_bytes': 24471313175552,
                'ul_rf_packets': 21718532864
        }
        exp_sta_stats = {
                '04:d6:aa:a8:4c:47': {       'alt_macs': None,
                                             'dev_macs': {       '00:27:22:c6:ef:31',
                                                                 '4c:5e:0c:02:b8:59',
                                                                 '64:d1:54:76:c1:7c',
                                                                 '74:4d:28:4a:d1:64',
                                                                 '80:2a:a8:64:f6:93',
                                                                 'cc:2d:e0:af:6e:09',
                                                                 'ec:13:b2:61:5b:c4',
                                                                 'ec:13:b2:61:8a:be'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a8:4c:47',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -137.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -57,
                                             'ul_snr': 80},
                '30:07:4d:43:04:33': {       'alt_macs': None,
                                             'dev_macs': {       '30:07:4d:7c:94:22',
                                                                 '60:38:e0:87:13:9f',
                                                                 '64:d1:54:ee:17:82',
                                                                 '74:4d:28:a6:c9:0e',
                                                                 'cc:2d:e0:fc:c5:78',
                                                                 'cc:40:d0:0a:29:5f',
                                                                 'ec:13:b2:62:42:9a'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '30:07:4d:43:04:33',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -140.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55,
                                             'ul_snr': 85}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '24471313175552',
                                                              'in_ucast_pkts': '21718532864',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '00:27:22:c6:ef:31',
                                                                                                                        '4c:5e:0c:02:b8:59',
                                                                                                                        '64:d1:54:76:c1:7c',
                                                                                                                        '74:4d:28:4a:d1:64',
                                                                                                                        '80:2a:a8:64:f6:93',
                                                                                                                        'cc:2d:e0:af:6e:09',
                                                                                                                        'ec:13:b2:61:5b:c4',
                                                                                                                        'ec:13:b2:61:8a:be'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '23997969669627',
                                                                                       'in_ucast_pkts': '17456277237',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a8:4c:47',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1056091049647',
                                                                                       'out_ucast_pkts': '8851797036'},
                                                                               {       'bridged_mac_addresses': [       '30:07:4d:7c:94:22',
                                                                                                                        '60:38:e0:87:13:9f',
                                                                                                                        '64:d1:54:ee:17:82',
                                                                                                                        '74:4d:28:a6:c9:0e',
                                                                                                                        'cc:2d:e0:fc:c5:78',
                                                                                                                        'cc:40:d0:0a:29:5f',
                                                                                                                        'ec:13:b2:62:42:9a'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '473343505925',
                                                                                       'in_ucast_pkts': '4262255627',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '30:07:4d:43:04:33',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '10207111183381',
                                                                                       'out_ucast_pkts': '8069005539'}],
                                                              'mac_address': '30:07:4d:7c:94:22',
                                                              'mtu': 1560,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '11263202233028',
                                                              'out_ucast_pkts': '16920802575',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 32,
                                                                                                                                            'mac_address': '04:d6:aa:a8:4c:47',
                                                                                                                                            'noise_floor': -137.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 29,
                                                                                                                                            'mac_address': '30:07:4d:43:04:33',
                                                                                                                                            'noise_floor': -140.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 85.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -137.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'new60hotness'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '575482089922',
                                                              'in_ucast_pkts': '4763690380',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:ee:17:96',
                                                              'mtu': 1560,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '13843331039168',
                                                              'out_ucast_pkts': '10108908581',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.92688,
                                'model': 'RBwAPG-60ad',
                                'poller_hash': 'MAdNfJQi',
                                'serial_number': '8B94079AD7B4',
                                'sw_version': '6.42.12',
                                'system_mac_address': '64:d1:54:ee:17:96',
                                'uptime': '16970168'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1056091049647',
                                                                       'in_ucast_pkts': '8851797036',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1056091049647',
                                                                                                'in_ucast_pkts': '8851797036',
                                                                                                'mac_address': '30:07:4d:7c:94:22',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '23997969669627',
                                                                                                'out_ucast_pkts': '17456277237'}],
                                                                       'mac_address': '04:d6:aa:a8:4c:47',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '23997969669627',
                                                                       'out_ucast_pkts': '17456277237',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 32,
                                                                                                                                                     'mac_address': '30:07:4d:7c:94:22',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'new60hotness'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '23997969669627',
                                                                       'in_ucast_pkts': '17456277237',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1056091049647',
                                                                       'out_ucast_pkts': '8851797036',
                                                                       'poller_hash': 'MDRkNmFhYTg0YzQ3ZXRoZXIx'}],
                                         'poller_hash': 'BNaqqExH',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '10207111183381',
                                                                       'in_ucast_pkts': '8069005539',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '10207111183381',
                                                                                                'in_ucast_pkts': '8069005539',
                                                                                                'mac_address': '30:07:4d:7c:94:22',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '473343505925',
                                                                                                'out_ucast_pkts': '4262255627'}],
                                                                       'mac_address': '30:07:4d:43:04:33',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '473343505925',
                                                                       'out_ucast_pkts': '4262255627',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 29,
                                                                                                                                                     'mac_address': '30:07:4d:7c:94:22',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'new60hotness'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '473343505925',
                                                                       'in_ucast_pkts': '4262255627',
                                                                       'name': 'ether1',
                                                                       'out_octets': '10207111183381',
                                                                       'out_ucast_pkts': '8069005539',
                                                                       'poller_hash': 'MzAwNzRkNDMwNDMzZXRoZXIx'}],
                                         'poller_hash': 'MAdNQwQz',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_6_43_4_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad.6.43.4.01")
        exp_info = {
                'model': 'RBwAPG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'sta_count': 1,
                'sw_version': '6.43.4',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 786269214344,
                'dl_en_packets': 751888796,
                'dl_noise_floor': None,
                'dl_rf_bytes': 806524043545,
                'dl_rf_packets': 1421021594,
                'en_if_speed': 1000000000,
                'mem': 14.970703125000002,
                'serial_number': '8B9408348106',
                'ssid': 'MikroTik-48cb83',
                'system_mac_address': 'cc:2d:e0:48:cb:83',
                'ul_en_bytes': 256372185281,
                'ul_en_packets': 492537642,
                'ul_noise_floor': None,
                'ul_rf_bytes': 277012950504,
                'ul_rf_packets': 1175588713
        }
        exp_sta_stats = {
                '30:07:4d:7f:53:0a': {       'alt_macs': None,
                                             'dev_macs': {       '30:07:4d:7f:53:4d',
                                                                 'cc:2d:e0:48:cb:6f',
                                                                 'ec:13:b2:92:29:f8'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '30:07:4d:7f:53:0a',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -130.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -65,
                                             'ul_snr': 65}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '277012950504',
                                                              'in_ucast_pkts': '1175588713',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '30:07:4d:7f:53:4d',
                                                                                                                        'cc:2d:e0:48:cb:6f',
                                                                                                                        'ec:13:b2:92:29:f8'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '277012950504',
                                                                                       'in_ucast_pkts': '1175588713',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '30:07:4d:7f:53:0a',
                                                                                       'out_discards': '0',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '806524043545',
                                                                                       'out_ucast_pkts': '1421021594'}],
                                                              'mac_address': '30:07:4d:7f:53:4d',
                                                              'mtu': 1560,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '806524043545',
                                                              'out_ucast_pkts': '1421021594',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 170,
                                                                                                                                            'mac_address': '30:07:4d:7f:53:0a',
                                                                                                                                            'noise_floor': -130.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -130.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'MikroTik-48cb83'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '786269214344',
                                                              'in_ucast_pkts': '751888796',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:48:cb:83',
                                                              'mtu': 1560,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '256372185281',
                                                              'out_ucast_pkts': '492537642',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 14.970703,
                                'model': 'RBwAPG-60ad',
                                'poller_hash': 'MAdNf1NN',
                                'serial_number': '8B9408348106',
                                'sw_version': '6.43.4',
                                'system_mac_address': 'cc:2d:e0:48:cb:83',
                                'uptime': '15078913'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '0',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '806524043545',
                                                                       'in_ucast_pkts': '1421021594',
                                                                       'links': [       {       'in_discards': '0',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '806524043545',
                                                                                                'in_ucast_pkts': '1421021594',
                                                                                                'mac_address': '30:07:4d:7f:53:4d',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '277012950504',
                                                                                                'out_ucast_pkts': '1175588713'}],
                                                                       'mac_address': '30:07:4d:7f:53:0a',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '277012950504',
                                                                       'out_ucast_pkts': '1175588713',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 170,
                                                                                                                                                     'mac_address': '30:07:4d:7f:53:4d',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'MikroTik-48cb83'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '277012950504',
                                                                       'in_ucast_pkts': '1175588713',
                                                                       'name': 'ether1',
                                                                       'out_octets': '806524043545',
                                                                       'out_ucast_pkts': '1421021594',
                                                                       'poller_hash': 'MzAwNzRkN2Y1MzBhZXRoZXIx'}],
                                         'poller_hash': 'MAdNf1MK',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_6_44_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad.6.44.01")
        exp_info = {
                'model': 'RBwAPG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 60480,
                'sta_count': 2,
                'sw_version': '6.44',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 46109013089,
                'dl_en_packets': 48063421,
                'dl_noise_floor': None,
                'dl_rf_bytes': 47624807732,
                'dl_rf_packets': 75780693,
                'en_if_speed': 1000000000,
                'mem': 18.42041015625,
                'serial_number': '8B9508552284',
                'ssid': 'NU1-NE60G',
                'system_mac_address': 'cc:2d:e0:e2:ef:1e',
                'ul_en_bytes': 4398012842,
                'ul_en_packets': 28995833,
                'ul_noise_floor': None,
                'ul_rf_bytes': 5360307761,
                'ul_rf_packets': 51456041
        }
        exp_sta_stats = {
                '04:d6:aa:aa:68:e9': {       'alt_macs': None,
                                             'dev_macs': {       '04:d6:aa:a8:0f:26',
                                                                 '64:d1:54:40:08:b4',
                                                                 'b8:69:f4:0e:84:23',
                                                                 'f4:1b:a1:8b:fc:dc'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:aa:68:e9',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -152.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -57,
                                             'ul_snr': 95},
                '04:d6:aa:aa:69:06': {       'alt_macs': None,
                                             'dev_macs': {       '4c:18:9a:83:cc:9f',
                                                                 '64:d1:54:40:08:c0'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:aa:69:06',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -129.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64,
                                             'ul_snr': 65}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '5360307761',
                                                              'in_ucast_pkts': '51456041',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '4c:18:9a:83:cc:9f',
                                                                                                                        '64:d1:54:40:08:c0'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2870904965',
                                                                                       'in_ucast_pkts': '26919026',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:aa:69:06',
                                                                                       'out_discards': '13',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '25480982945',
                                                                                       'out_ucast_pkts': '39290596'},
                                                                               {       'bridged_mac_addresses': [       '04:d6:aa:a8:0f:26',
                                                                                                                        '64:d1:54:40:08:b4',
                                                                                                                        'b8:69:f4:0e:84:23',
                                                                                                                        'f4:1b:a1:8b:fc:dc'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2489402796',
                                                                                       'in_ucast_pkts': '24537015',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:aa:68:e9',
                                                                                       'out_discards': '31',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '22143824787',
                                                                                       'out_ucast_pkts': '36490097'}],
                                                              'mac_address': '04:d6:aa:a8:0f:26',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '44',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '47624807732',
                                                              'out_ucast_pkts': '75780693',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 60480,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 363,
                                                                                                                                            'mac_address': '04:d6:aa:aa:69:06',
                                                                                                                                            'noise_floor': -129.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 237,
                                                                                                                                            'mac_address': '04:d6:aa:aa:68:e9',
                                                                                                                                            'noise_floor': -152.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -129.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'NU1-NE60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '46109013089',
                                                              'in_ucast_pkts': '48063421',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:e2:ef:1e',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4398012842',
                                                              'out_ucast_pkts': '28995833',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 18.42041,
                                'model': 'RBwAPG-60ad',
                                'poller_hash': 'BNaqqA8m',
                                'serial_number': '8B9508552284',
                                'sw_version': '6.44',
                                'system_mac_address': 'cc:2d:e0:e2:ef:1e',
                                'uptime': '1339803'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '13',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '25480982945',
                                                                       'in_ucast_pkts': '39290596',
                                                                       'links': [       {       'in_discards': '13',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '25480982945',
                                                                                                'in_ucast_pkts': '39290596',
                                                                                                'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2870904965',
                                                                                                'out_ucast_pkts': '26919026'}],
                                                                       'mac_address': '04:d6:aa:aa:69:06',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2870904965',
                                                                       'out_ucast_pkts': '26919026',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 363,
                                                                                                                                                     'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2870904965',
                                                                       'in_ucast_pkts': '26919026',
                                                                       'name': 'ether1',
                                                                       'out_octets': '25480982945',
                                                                       'out_ucast_pkts': '39290596',
                                                                       'poller_hash': 'MDRkNmFhYWE2OTA2ZXRoZXIx'}],
                                         'poller_hash': 'BNaqqmkG',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '31',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '22143824787',
                                                                       'in_ucast_pkts': '36490097',
                                                                       'links': [       {       'in_discards': '31',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '22143824787',
                                                                                                'in_ucast_pkts': '36490097',
                                                                                                'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2489402796',
                                                                                                'out_ucast_pkts': '24537015'}],
                                                                       'mac_address': '04:d6:aa:aa:68:e9',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2489402796',
                                                                       'out_ucast_pkts': '24537015',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 237,
                                                                                                                                                     'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2489402796',
                                                                       'in_ucast_pkts': '24537015',
                                                                       'name': 'ether1',
                                                                       'out_octets': '22143824787',
                                                                       'out_ucast_pkts': '36490097',
                                                                       'poller_hash': 'MDRkNmFhYWE2OGU5ZXRoZXIx'}],
                                         'poller_hash': 'BNaqqmjp',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_6_44_2_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad.6.44.2.01")
        exp_info = {
                'model': 'RBwAPG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'sta_count': 1,
                'sw_version': '6.44.2',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 245081705263,
                'dl_en_packets': 199827617,
                'dl_noise_floor': None,
                'dl_rf_bytes': 246005854540,
                'dl_rf_packets': 225428086,
                'en_if_speed': 1000000000,
                'mem': 19.43817138671875,
                'serial_number': '8B9408EF2722',
                'ssid': 'RedOak1',
                'system_mac_address': 'cc:2d:e0:62:2d:ab',
                'ul_en_bytes': 18789202517,
                'ul_en_packets': 135992734,
                'ul_noise_floor': None,
                'ul_rf_bytes': 19899569815,
                'ul_rf_packets': 169920872
        }
        exp_sta_stats = {
                '04:d6:aa:66:3d:76': {       'alt_macs': None,
                                             'dev_macs': {       '28:76:10:1a:0d:58',
                                                                 '30:07:4d:56:70:e9',
                                                                 '84:16:f9:58:f2:42',
                                                                 'cc:2d:e0:62:2d:c3'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:66:3d:76',
                                             'name': 'RedOak-STA-B9',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67,
                                             'ul_snr': 50}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '19899569815',
                                                              'in_ucast_pkts': '169920872',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '28:76:10:1a:0d:58',
                                                                                                                        '30:07:4d:56:70:e9',
                                                                                                                        '84:16:f9:58:f2:42',
                                                                                                                        'cc:2d:e0:62:2d:c3'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '19899569815',
                                                                                       'in_ucast_pkts': '169920872',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:66:3d:76',
                                                                                       'out_discards': '307',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '246005854540',
                                                                                       'out_ucast_pkts': '225428086'}],
                                                              'mac_address': '30:07:4d:56:70:e9',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '307',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '246005854540',
                                                              'out_ucast_pkts': '225428086',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 51,
                                                                                                                                            'mac_address': '04:d6:aa:66:3d:76',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -117.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'RedOak1'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '245081705263',
                                                              'in_ucast_pkts': '199827617',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:62:2d:ab',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '18789202517',
                                                              'out_ucast_pkts': '135992734',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 19.438171,
                                'model': 'RBwAPG-60ad',
                                'poller_hash': 'MAdNVnDp',
                                'serial_number': '8B9408EF2722',
                                'sw_version': '6.44.2',
                                'system_mac_address': 'cc:2d:e0:62:2d:ab',
                                'uptime': '3918420'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '307',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '246005854540',
                                                                       'in_ucast_pkts': '225428086',
                                                                       'links': [       {       'in_discards': '307',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '246005854540',
                                                                                                'in_ucast_pkts': '225428086',
                                                                                                'mac_address': '30:07:4d:56:70:e9',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '19899569815',
                                                                                                'out_ucast_pkts': '169920872'}],
                                                                       'mac_address': '04:d6:aa:66:3d:76',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '19899569815',
                                                                       'out_ucast_pkts': '169920872',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 51,
                                                                                                                                                     'mac_address': '30:07:4d:56:70:e9',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'RedOak1'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '19899569815',
                                                                       'in_ucast_pkts': '169920872',
                                                                       'name': 'ether1',
                                                                       'out_octets': '246005854540',
                                                                       'out_ucast_pkts': '225428086',
                                                                       'poller_hash': 'MDRkNmFhNjYzZDc2ZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': 'RedOak-STA-B9',
                                         'poller_hash': 'BNaqZj12',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.44.2'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_6_45_8_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad.6.45.8.01")
        exp_info = {
                'model': 'RBwAPG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 60480,
                'sta_count': 4,
                'sw_version': '6.45.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 4744312846240,
                'dl_en_packets': 4209938248,
                'dl_noise_floor': None,
                'dl_rf_bytes': 4116848455962,
                'dl_rf_packets': 4270719295,
                'en_if_speed': 1000000000,
                'mem': 21.08917236328125,
                'serial_number': '8B9508552284',
                'ssid': 'NU1-NE60G',
                'system_mac_address': 'cc:2d:e0:e2:ef:1e',
                'ul_en_bytes': 385120841084,
                'ul_en_packets': 2050593648,
                'ul_noise_floor': None,
                'ul_rf_bytes': 301566749484,
                'ul_rf_packets': 2337988936
        }
        exp_sta_stats = {
                '04:d6:aa:aa:68:e9': {       'alt_macs': None,
                                             'dev_macs': {       '64:d1:54:40:08:b4',
                                                                 'b8:69:f4:0e:84:23'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:aa:68:e9',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -153.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58,
                                             'ul_snr': 95},
                '04:d6:aa:aa:69:06': {       'alt_macs': None,
                                             'dev_macs': {       '64:d1:54:40:08:bc',
                                                                 '64:d1:54:40:08:c0'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:aa:69:06',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67,
                                             'ul_snr': 50},
                '24:18:1d:63:63:c4': {       'alt_macs': None,
                                             'dev_macs': {       '00:1d:aa:f1:5e:c2',
                                                                 '04:d6:aa:a8:0f:26',
                                                                 'b8:69:f4:3f:bf:71'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:63:63:c4',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -118.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68,
                                             'ul_snr': 50},
                '24:18:1d:99:68:99': {       'alt_macs': None,
                                             'dev_macs': {       'b8:69:f4:3f:9c:16',
                                                                 'cc:2d:e0:c8:44:69'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:99:68:99',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -139.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '301566749484',
                                                              'in_ucast_pkts': '2337988936',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '64:d1:54:40:08:bc',
                                                                                                                        '64:d1:54:40:08:c0'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '33289763462',
                                                                                       'in_ucast_pkts': '294897673',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:aa:69:06',
                                                                                       'out_discards': '19967',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '167933226272',
                                                                                       'out_ucast_pkts': '391258797'},
                                                                               {       'bridged_mac_addresses': [       'b8:69:f4:3f:9c:16',
                                                                                                                        'cc:2d:e0:c8:44:69'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '12243873781',
                                                                                       'in_ucast_pkts': '216008766',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:68:99',
                                                                                       'out_discards': '8563',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '9630689327',
                                                                                       'out_ucast_pkts': '223489969'},
                                                                               {       'bridged_mac_addresses': [       '00:1d:aa:f1:5e:c2',
                                                                                                                        '04:d6:aa:a8:0f:26',
                                                                                                                        'b8:69:f4:3f:bf:71'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '53623273480',
                                                                                       'in_ucast_pkts': '357248633',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:63:63:c4',
                                                                                       'out_discards': '39098',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '122453554213',
                                                                                       'out_ucast_pkts': '463883812'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:40:08:b4',
                                                                                                                        'b8:69:f4:0e:84:23'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '199663279051',
                                                                                       'in_ucast_pkts': '1457757838',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:aa:68:e9',
                                                                                       'out_discards': '258335',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3786253449736',
                                                                                       'out_ucast_pkts': '3165796979'}],
                                                              'mac_address': '04:d6:aa:a8:0f:26',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '326452',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4116848455962',
                                                              'out_ucast_pkts': '4270719295',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 60480,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 363,
                                                                                                                                            'mac_address': '04:d6:aa:aa:69:06',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 120,
                                                                                                                                            'mac_address': '24:18:1d:99:68:99',
                                                                                                                                            'noise_floor': -139.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'mac_address': '24:18:1d:63:63:c4',
                                                                                                                                            'noise_floor': -118.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'mac_address': '04:d6:aa:aa:68:e9',
                                                                                                                                            'noise_floor': -153.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -117.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'NU1-NE60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '92446711',
                                                              'in_octets': '4744312846240',
                                                              'in_ucast_pkts': '4117491537',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:e2:ef:1e',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '49686079',
                                                              'out_octets': '385120841084',
                                                              'out_ucast_pkts': '2000907569',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.089172,
                                'model': 'RBwAPG-60ad',
                                'poller_hash': 'BNaqqA8m',
                                'serial_number': '8B9508552284',
                                'sw_version': '6.45.8',
                                'system_mac_address': 'cc:2d:e0:e2:ef:1e',
                                'uptime': '20547525'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '19967',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '167933226272',
                                                                       'in_ucast_pkts': '391258797',
                                                                       'links': [       {       'in_discards': '19967',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '167933226272',
                                                                                                'in_ucast_pkts': '391258797',
                                                                                                'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '33289763462',
                                                                                                'out_ucast_pkts': '294897673'}],
                                                                       'mac_address': '04:d6:aa:aa:69:06',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '33289763462',
                                                                       'out_ucast_pkts': '294897673',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 363,
                                                                                                                                                     'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '33289763462',
                                                                       'in_ucast_pkts': '294897673',
                                                                       'name': 'ether1',
                                                                       'out_octets': '167933226272',
                                                                       'out_ucast_pkts': '391258797',
                                                                       'poller_hash': 'MDRkNmFhYWE2OTA2ZXRoZXIx'}],
                                         'poller_hash': 'BNaqqmkG',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '8563',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '9630689327',
                                                                       'in_ucast_pkts': '223489969',
                                                                       'links': [       {       'in_discards': '8563',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '9630689327',
                                                                                                'in_ucast_pkts': '223489969',
                                                                                                'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '12243873781',
                                                                                                'out_ucast_pkts': '216008766'}],
                                                                       'mac_address': '24:18:1d:99:68:99',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '12243873781',
                                                                       'out_ucast_pkts': '216008766',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 120,
                                                                                                                                                     'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '12243873781',
                                                                       'in_ucast_pkts': '216008766',
                                                                       'name': 'ether1',
                                                                       'out_octets': '9630689327',
                                                                       'out_ucast_pkts': '223489969',
                                                                       'poller_hash': 'MjQxODFkOTk2ODk5ZXRoZXIx'}],
                                         'poller_hash': 'JBgdmWiZ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '39098',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '122453554213',
                                                                       'in_ucast_pkts': '463883812',
                                                                       'links': [       {       'in_discards': '39098',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '122453554213',
                                                                                                'in_ucast_pkts': '463883812',
                                                                                                'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '53623273480',
                                                                                                'out_ucast_pkts': '357248633'}],
                                                                       'mac_address': '24:18:1d:63:63:c4',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '53623273480',
                                                                       'out_ucast_pkts': '357248633',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '53623273480',
                                                                       'in_ucast_pkts': '357248633',
                                                                       'name': 'ether1',
                                                                       'out_octets': '122453554213',
                                                                       'out_ucast_pkts': '463883812',
                                                                       'poller_hash': 'MjQxODFkNjM2M2M0ZXRoZXIx'}],
                                         'poller_hash': 'JBgdY2PE',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '258335',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3786253449736',
                                                                       'in_ucast_pkts': '3165796979',
                                                                       'links': [       {       'in_discards': '258335',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3786253449736',
                                                                                                'in_ucast_pkts': '3165796979',
                                                                                                'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '199663279051',
                                                                                                'out_ucast_pkts': '1457757838'}],
                                                                       'mac_address': '04:d6:aa:aa:68:e9',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '199663279051',
                                                                       'out_ucast_pkts': '1457757838',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '04:d6:aa:a8:0f:26',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '199663279051',
                                                                       'in_ucast_pkts': '1457757838',
                                                                       'name': 'ether1',
                                                                       'out_octets': '3786253449736',
                                                                       'out_ucast_pkts': '3165796979',
                                                                       'poller_hash': 'MDRkNmFhYWE2OGU5ZXRoZXIx'}],
                                         'poller_hash': 'BNaqqmjp',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_6_45_8_02(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad.6.45.8.02")
        exp_info = {
                'model': 'RBwAPG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'sta_count': 6,
                'sw_version': '6.45.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 9299369672202,
                'dl_en_packets': 7372147707,
                'dl_noise_floor': None,
                'dl_rf_bytes': 9314221424449,
                'dl_rf_packets': 8384322798,
                'en_if_speed': 1000000000,
                'mem': 22.149658203125,
                'serial_number': '8B9507D3AE06',
                'ssid': 'NU1-SE60G',
                'system_mac_address': '64:d1:54:ee:03:55',
                'ul_en_bytes': 644194460178,
                'ul_en_packets': 3226887839,
                'ul_noise_floor': None,
                'ul_rf_bytes': 671052105141,
                'ul_rf_packets': 4154641582
        }
        exp_sta_stats = {
                '04:d6:aa:a2:2e:1c': {       'alt_macs': None,
                                             'dev_macs': {       '64:d1:54:46:c7:a0',
                                                                 '64:d1:54:9b:37:46'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a2:2e:1c',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -130.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -65,
                                             'ul_snr': 65},
                '04:d6:aa:a8:d4:d8': {       'alt_macs': None,
                                             'dev_macs': {       'b8:69:f4:38:c8:e8',
                                                                 'cc:2d:e0:24:c8:f1'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.102.3.217',
                                             'mac_address': '04:d6:aa:a8:d4:d8',
                                             'name': '6 Warnecke St',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -131.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -66,
                                             'ul_snr': 65},
                '04:d6:aa:aa:69:ef': {       'alt_macs': None,
                                             'dev_macs': {       '64:d1:54:40:08:c8',
                                                                 '64:d1:54:40:08:cc'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:aa:69:ef',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -141.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61,
                                             'ul_snr': 80},
                '24:18:1d:99:62:1a': {       'alt_macs': None,
                                             'dev_macs': {       'b8:69:f4:3f:9c:27',
                                                                 'cc:2d:e0:f7:47:7a'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.102.3.72',
                                             'mac_address': '24:18:1d:99:62:1a',
                                             'name': '1 Orchard Court',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -142.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62,
                                             'ul_snr': 80},
                '24:18:1d:99:66:dc': {       'alt_macs': None,
                                             'dev_macs': {       '30:07:4d:87:87:c1',
                                                                 'b8:69:f4:3f:9b:e6',
                                                                 'cc:2d:e0:22:61:bd'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.102.3.79',
                                             'mac_address': '24:18:1d:99:66:dc',
                                             'name': '10 Murray St',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -129.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64,
                                             'ul_snr': 65},
                '6c:c7:ec:9a:19:54': {       'alt_macs': None,
                                             'dev_macs': {       '64:d1:54:3c:16:5a',
                                                                 'c4:ad:34:18:fb:56'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '6c:c7:ec:9a:19:54',
                                             'name': '15 Gawler St',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -139.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '671052105141',
                                                              'in_ucast_pkts': '4154641582',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '64:d1:54:40:08:c8',
                                                                                                                        '64:d1:54:40:08:cc'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '62697946177',
                                                                                       'in_ucast_pkts': '406806847',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:aa:69:ef',
                                                                                       'out_discards': '5790',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '441481642153',
                                                                                       'out_ucast_pkts': '658117166'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:3c:16:5a',
                                                                                                                        'c4:ad:34:18:fb:56'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '238035800932',
                                                                                       'in_ucast_pkts': '1924354179',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '6c:c7:ec:9a:19:54',
                                                                                       'out_discards': '1794',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4358572574629',
                                                                                       'out_ucast_pkts': '3524135615'},
                                                                               {       'bridged_mac_addresses': [       '30:07:4d:87:87:c1',
                                                                                                                        'b8:69:f4:3f:9b:e6',
                                                                                                                        'cc:2d:e0:22:61:bd'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '16025478008',
                                                                                       'in_ucast_pkts': '233148144',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:66:dc',
                                                                                       'out_discards': '4482',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '51846056492',
                                                                                       'out_ucast_pkts': '260738964'},
                                                                               {       'bridged_mac_addresses': [       'b8:69:f4:3f:9c:27',
                                                                                                                        'cc:2d:e0:f7:47:7a'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '64133272182',
                                                                                       'in_ucast_pkts': '584092074',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:62:1a',
                                                                                       'out_discards': '8890',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2967591051449',
                                                                                       'out_ucast_pkts': '2279504773'},
                                                                               {       'bridged_mac_addresses': [       'b8:69:f4:38:c8:e8',
                                                                                                                        'cc:2d:e0:24:c8:f1'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '219187573963',
                                                                                       'in_ucast_pkts': '592261864',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a8:d4:d8',
                                                                                       'out_discards': '20014',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '975845813288',
                                                                                       'out_ucast_pkts': '1001467901'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:46:c7:a0',
                                                                                                                        '64:d1:54:9b:37:46'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '69587557804',
                                                                                       'in_ucast_pkts': '412563907',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a2:2e:1c',
                                                                                       'out_discards': '8890',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '518883653298',
                                                                                       'out_ucast_pkts': '660347637'}],
                                                              'mac_address': '30:07:4d:87:87:c1',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '50047',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '9314221424449',
                                                              'out_ucast_pkts': '8384322798',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 257,
                                                                                                                                            'mac_address': '04:d6:aa:aa:69:ef',
                                                                                                                                            'noise_floor': -141.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 141,
                                                                                                                                            'mac_address': '6c:c7:ec:9a:19:54',
                                                                                                                                            'noise_floor': -139.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 289,
                                                                                                                                            'mac_address': '24:18:1d:99:66:dc',
                                                                                                                                            'noise_floor': -129.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 214,
                                                                                                                                            'mac_address': '24:18:1d:99:62:1a',
                                                                                                                                            'noise_floor': -142.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'mac_address': '04:d6:aa:a8:d4:d8',
                                                                                                                                            'noise_floor': -131.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 334,
                                                                                                                                            'mac_address': '04:d6:aa:a2:2e:1c',
                                                                                                                                            'noise_floor': -130.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -129.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'NU1-SE60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '81791919',
                                                              'in_octets': '9299369672202',
                                                              'in_ucast_pkts': '7290355788',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '64:d1:54:ee:03:55',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '94286334',
                                                              'out_octets': '644194460178',
                                                              'out_ucast_pkts': '3132601505',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 22.149658,
                                'model': 'RBwAPG-60ad',
                                'poller_hash': 'MAdNh4fB',
                                'serial_number': '8B9507D3AE06',
                                'sw_version': '6.45.8',
                                'system_mac_address': '64:d1:54:ee:03:55',
                                'uptime': '20550400'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '5790',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '441481642153',
                                                                       'in_ucast_pkts': '658117166',
                                                                       'links': [       {       'in_discards': '5790',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '441481642153',
                                                                                                'in_ucast_pkts': '658117166',
                                                                                                'mac_address': '30:07:4d:87:87:c1',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '62697946177',
                                                                                                'out_ucast_pkts': '406806847'}],
                                                                       'mac_address': '04:d6:aa:aa:69:ef',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '62697946177',
                                                                       'out_ucast_pkts': '406806847',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 257,
                                                                                                                                                     'mac_address': '30:07:4d:87:87:c1',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '62697946177',
                                                                       'in_ucast_pkts': '406806847',
                                                                       'name': 'ether1',
                                                                       'out_octets': '441481642153',
                                                                       'out_ucast_pkts': '658117166',
                                                                       'poller_hash': 'MDRkNmFhYWE2OWVmZXRoZXIx'}],
                                         'poller_hash': 'BNaqqmnv',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1794',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4358572574629',
                                                                       'in_ucast_pkts': '3524135615',
                                                                       'links': [       {       'in_discards': '1794',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4358572574629',
                                                                                                'in_ucast_pkts': '3524135615',
                                                                                                'mac_address': '30:07:4d:87:87:c1',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '238035800932',
                                                                                                'out_ucast_pkts': '1924354179'}],
                                                                       'mac_address': '6c:c7:ec:9a:19:54',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '238035800932',
                                                                       'out_ucast_pkts': '1924354179',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 141,
                                                                                                                                                     'mac_address': '30:07:4d:87:87:c1',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '238035800932',
                                                                       'in_ucast_pkts': '1924354179',
                                                                       'name': 'ether1',
                                                                       'out_octets': '4358572574629',
                                                                       'out_ucast_pkts': '3524135615',
                                                                       'poller_hash': 'NmNjN2VjOWExOTU0ZXRoZXIx'}],
                                         'manufacturer': 'Mikrotik',
                                         'name': '15 Gawler St',
                                         'poller_hash': 'bMfsmhlU',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.45.8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '4482',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '51846056492',
                                                                       'in_ucast_pkts': '260738964',
                                                                       'links': [       {       'in_discards': '4482',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '51846056492',
                                                                                                'in_ucast_pkts': '260738964',
                                                                                                'mac_address': '30:07:4d:87:87:c1',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '16025478008',
                                                                                                'out_ucast_pkts': '233148144'}],
                                                                       'mac_address': '24:18:1d:99:66:dc',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '16025478008',
                                                                       'out_ucast_pkts': '233148144',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 289,
                                                                                                                                                     'mac_address': '30:07:4d:87:87:c1',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '16025478008',
                                                                       'in_ucast_pkts': '233148144',
                                                                       'name': 'ether1',
                                                                       'out_octets': '51846056492',
                                                                       'out_ucast_pkts': '260738964',
                                                                       'poller_hash': 'MjQxODFkOTk2NmRjZXRoZXIx'}],
                                         'management_ip': '10.102.3.79',
                                         'manufacturer': 'Mikrotik',
                                         'name': '10 Murray St',
                                         'poller_hash': 'JBgdmWbc',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.45.8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '8890',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2967591051449',
                                                                       'in_ucast_pkts': '2279504773',
                                                                       'links': [       {       'in_discards': '8890',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2967591051449',
                                                                                                'in_ucast_pkts': '2279504773',
                                                                                                'mac_address': '30:07:4d:87:87:c1',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '64133272182',
                                                                                                'out_ucast_pkts': '584092074'}],
                                                                       'mac_address': '24:18:1d:99:62:1a',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '64133272182',
                                                                       'out_ucast_pkts': '584092074',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 214,
                                                                                                                                                     'mac_address': '30:07:4d:87:87:c1',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '64133272182',
                                                                       'in_ucast_pkts': '584092074',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2967591051449',
                                                                       'out_ucast_pkts': '2279504773',
                                                                       'poller_hash': 'MjQxODFkOTk2MjFhZXRoZXIx'}],
                                         'management_ip': '10.102.3.72',
                                         'manufacturer': 'Mikrotik',
                                         'name': '1 Orchard Court',
                                         'poller_hash': 'JBgdmWIa',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.45.8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '20014',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '975845813288',
                                                                       'in_ucast_pkts': '1001467901',
                                                                       'links': [       {       'in_discards': '20014',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '975845813288',
                                                                                                'in_ucast_pkts': '1001467901',
                                                                                                'mac_address': '30:07:4d:87:87:c1',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '219187573963',
                                                                                                'out_ucast_pkts': '592261864'}],
                                                                       'mac_address': '04:d6:aa:a8:d4:d8',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '219187573963',
                                                                       'out_ucast_pkts': '592261864',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '30:07:4d:87:87:c1',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '219187573963',
                                                                       'in_ucast_pkts': '592261864',
                                                                       'name': 'ether1',
                                                                       'out_octets': '975845813288',
                                                                       'out_ucast_pkts': '1001467901',
                                                                       'poller_hash': 'MDRkNmFhYThkNGQ4ZXRoZXIx'}],
                                         'management_ip': '10.102.3.217',
                                         'manufacturer': 'Mikrotik',
                                         'name': '6 Warnecke St',
                                         'poller_hash': 'BNaqqNTY',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.45.8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '8890',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '518883653298',
                                                                       'in_ucast_pkts': '660347637',
                                                                       'links': [       {       'in_discards': '8890',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '518883653298',
                                                                                                'in_ucast_pkts': '660347637',
                                                                                                'mac_address': '30:07:4d:87:87:c1',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '69587557804',
                                                                                                'out_ucast_pkts': '412563907'}],
                                                                       'mac_address': '04:d6:aa:a2:2e:1c',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '69587557804',
                                                                       'out_ucast_pkts': '412563907',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 334,
                                                                                                                                                     'mac_address': '30:07:4d:87:87:c1',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU1-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '69587557804',
                                                                       'in_ucast_pkts': '412563907',
                                                                       'name': 'ether1',
                                                                       'out_octets': '518883653298',
                                                                       'out_ucast_pkts': '660347637',
                                                                       'poller_hash': 'MDRkNmFhYTIyZTFjZXRoZXIx'}],
                                         'poller_hash': 'BNaqoi4c',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_6_45_8_03(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad.6.45.8.03")
        exp_info = {
                'model': 'RBwAPG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 58320,
                'sta_count': 3,
                'sw_version': '6.45.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 1645563249710,
                'dl_en_packets': 1979028625,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1641115927221,
                'dl_rf_packets': 2069050684,
                'en_if_speed': 1000000000,
                'mem': 22.1588134765625,
                'serial_number': '92220863761B',
                'ssid': 'TN2-NW60G',
                'system_mac_address': 'cc:2d:e0:a6:f4:70',
                'ul_en_bytes': 1521895827352,
                'ul_en_packets': 1678841675,
                'ul_noise_floor': None,
                'ul_rf_bytes': 1520023598581,
                'ul_rf_packets': 1775306665
        }
        exp_sta_stats = {
                '08:c5:e1:da:6b:bc': {       'alt_macs': None,
                                             'dev_macs': {       '04:d6:aa:6b:1f:8a',
                                                                 'cc:2d:e0:55:f2:3a'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '08:c5:e1:da:6b:bc',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -151.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56,
                                             'ul_snr': 95},
                '24:18:1d:99:68:01': {       'alt_macs': None,
                                             'dev_macs': {'74:4d:28:17:6d:31'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:99:68:01',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -118.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68,
                                             'ul_snr': 50},
                'b8:69:f4:91:67:e5': {       'alt_macs': None,
                                             'dev_macs': {       '00:0c:29:a2:73:1c',
                                                                 '00:0c:29:e6:56:16',
                                                                 '04:18:d6:00:63:15',
                                                                 '5c:f9:dd:e4:27:2c',
                                                                 '64:d1:54:3a:a9:75',
                                                                 '64:d1:54:3a:a9:78',
                                                                 '80:18:44:f1:89:bc',
                                                                 '98:f2:b3:e9:05:8c',
                                                                 'b0:61:c7:9f:35:0c',
                                                                 'b8:e8:56:4a:47:cc',
                                                                 'f4:ea:67:79:4c:63'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:69:f4:91:67:e5',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -136.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1520023598581',
                                                              'in_ucast_pkts': '1775306665',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '74:4d:28:17:6d:31'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '157586984896',
                                                                                       'in_ucast_pkts': '322274573',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:68:01',
                                                                                       'out_discards': '15130',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '719107312788',
                                                                                       'out_ucast_pkts': '635474776'},
                                                                               {       'bridged_mac_addresses': [       '04:d6:aa:6b:1f:8a',
                                                                                                                        'cc:2d:e0:55:f2:3a'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '123928357757',
                                                                                       'in_ucast_pkts': '323871627',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '08:c5:e1:da:6b:bc',
                                                                                       'out_discards': '1545',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '568227038394',
                                                                                       'out_ucast_pkts': '607913053'},
                                                                               {       'bridged_mac_addresses': [       '00:0c:29:a2:73:1c',
                                                                                                                        '00:0c:29:e6:56:16',
                                                                                                                        '04:18:d6:00:63:15',
                                                                                                                        '5c:f9:dd:e4:27:2c',
                                                                                                                        '64:d1:54:3a:a9:75',
                                                                                                                        '64:d1:54:3a:a9:78',
                                                                                                                        '80:18:44:f1:89:bc',
                                                                                                                        '98:f2:b3:e9:05:8c',
                                                                                                                        'b0:61:c7:9f:35:0c',
                                                                                                                        'b8:e8:56:4a:47:cc',
                                                                                                                        'f4:ea:67:79:4c:63'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '1238508255928',
                                                                                       'in_ucast_pkts': '1129160465',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': 'b8:69:f4:91:67:e5',
                                                                                       'out_discards': '178',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '353781576039',
                                                                                       'out_ucast_pkts': '825662855'}],
                                                              'mac_address': '04:d6:aa:6b:1f:8a',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '16853',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1641115927221',
                                                              'out_ucast_pkts': '2069050684',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '24:18:1d:99:68:01',
                                                                                                                                            'noise_floor': -118.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 135,
                                                                                                                                            'mac_address': '08:c5:e1:da:6b:bc',
                                                                                                                                            'noise_floor': -151.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 133,
                                                                                                                                            'mac_address': 'b8:69:f4:91:67:e5',
                                                                                                                                            'noise_floor': -136.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -118.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TN2-NW60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '26872998',
                                                              'in_octets': '1645563249710',
                                                              'in_ucast_pkts': '1952155627',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:a6:f4:70',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '18907341',
                                                              'out_octets': '1521895827352',
                                                              'out_ucast_pkts': '1659934334',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 22.158813,
                                'model': 'RBwAPG-60ad',
                                'poller_hash': 'BNaqax+K',
                                'serial_number': '92220863761B',
                                'sw_version': '6.45.8',
                                'system_mac_address': 'cc:2d:e0:a6:f4:70',
                                'uptime': '6015533'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '15130',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '719107312788',
                                                                       'in_ucast_pkts': '635474776',
                                                                       'links': [       {       'in_discards': '15130',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '719107312788',
                                                                                                'in_ucast_pkts': '635474776',
                                                                                                'mac_address': '04:d6:aa:6b:1f:8a',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '157586984896',
                                                                                                'out_ucast_pkts': '322274573'}],
                                                                       'mac_address': '24:18:1d:99:68:01',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '157586984896',
                                                                       'out_ucast_pkts': '322274573',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '04:d6:aa:6b:1f:8a',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-NW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '157586984896',
                                                                       'in_ucast_pkts': '322274573',
                                                                       'name': 'ether1',
                                                                       'out_octets': '719107312788',
                                                                       'out_ucast_pkts': '635474776',
                                                                       'poller_hash': 'MjQxODFkOTk2ODAxZXRoZXIx'}],
                                         'poller_hash': 'JBgdmWgB',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1545',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '568227038394',
                                                                       'in_ucast_pkts': '607913053',
                                                                       'links': [       {       'in_discards': '1545',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '568227038394',
                                                                                                'in_ucast_pkts': '607913053',
                                                                                                'mac_address': '04:d6:aa:6b:1f:8a',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '123928357757',
                                                                                                'out_ucast_pkts': '323871627'}],
                                                                       'mac_address': '08:c5:e1:da:6b:bc',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '123928357757',
                                                                       'out_ucast_pkts': '323871627',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 135,
                                                                                                                                                     'mac_address': '04:d6:aa:6b:1f:8a',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-NW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '123928357757',
                                                                       'in_ucast_pkts': '323871627',
                                                                       'name': 'ether1',
                                                                       'out_octets': '568227038394',
                                                                       'out_ucast_pkts': '607913053',
                                                                       'poller_hash': 'MDhjNWUxZGE2YmJjZXRoZXIx'}],
                                         'poller_hash': 'CMXh2mu8',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '178',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '353781576039',
                                                                       'in_ucast_pkts': '825662855',
                                                                       'links': [       {       'in_discards': '178',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '353781576039',
                                                                                                'in_ucast_pkts': '825662855',
                                                                                                'mac_address': '04:d6:aa:6b:1f:8a',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '1238508255928',
                                                                                                'out_ucast_pkts': '1129160465'}],
                                                                       'mac_address': 'b8:69:f4:91:67:e5',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '1238508255928',
                                                                       'out_ucast_pkts': '1129160465',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 133,
                                                                                                                                                     'mac_address': '04:d6:aa:6b:1f:8a',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-NW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '1238508255928',
                                                                       'in_ucast_pkts': '1129160465',
                                                                       'name': 'ether1',
                                                                       'out_octets': '353781576039',
                                                                       'out_ucast_pkts': '825662855',
                                                                       'poller_hash': 'Yjg2OWY0OTE2N2U1ZXRoZXIx'}],
                                         'poller_hash': 'uGn0kWfl',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_6_45_8_04(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad.6.45.8.04")
        exp_info = {
                'model': 'RBwAPG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 62640,
                'sta_count': 8,
                'sw_version': '6.45.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 4366967320168,
                'dl_en_packets': 3544293813,
                'dl_noise_floor': None,
                'dl_rf_bytes': 4369831777435,
                'dl_rf_packets': 3954688354,
                'en_if_speed': 1000000000,
                'mem': 22.46246337890625,
                'serial_number': '92220864C782',
                'ssid': 'TN2-SW60G',
                'system_mac_address': 'cc:2d:e0:a6:f2:f7',
                'ul_en_bytes': 391478926832,
                'ul_en_packets': 1658530198,
                'ul_noise_floor': None,
                'ul_rf_bytes': 396559641871,
                'ul_rf_packets': 2016353415
        }
        exp_sta_stats = {
                '24:18:1d:5a:13:8d': {       'alt_macs': None,
                                             'dev_macs': {'c4:ad:34:f9:8e:57'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:5a:13:8d',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -141.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61,
                                             'ul_snr': 80},
                '24:18:1d:99:67:a9': {       'alt_macs': None,
                                             'dev_macs': {       'b8:69:f4:3f:9c:2c',
                                                                 'c4:ad:34:f9:8e:45'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:99:67:a9',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -147.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67,
                                             'ul_snr': 80},
                '24:18:1d:99:68:6c': {       'alt_macs': None,
                                             'dev_macs': {       '04:d6:aa:6b:1f:ae',
                                                                 '50:c7:bf:45:40:af',
                                                                 'b8:69:f4:3f:9c:13'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:99:68:6c',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -129.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64,
                                             'ul_snr': 65},
                '48:8f:5a:51:c7:13': {       'alt_macs': None,
                                             'dev_macs': {'48:8f:5a:94:00:7f'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '48:8f:5a:51:c7:13',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -129.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64,
                                             'ul_snr': 65},
                '48:8f:5a:80:66:9b': {       'alt_macs': None,
                                             'dev_macs': {'6c:72:20:3f:35:d1'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '48:8f:5a:80:66:9b',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -142.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62,
                                             'ul_snr': 80},
                '6c:c7:ec:92:f6:12': {       'alt_macs': None,
                                             'dev_macs': {'48:8f:5a:83:99:57'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '6c:c7:ec:92:f6:12',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -141.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61,
                                             'ul_snr': 80},
                '6c:c7:ec:92:f9:c1': {       'alt_macs': None,
                                             'dev_macs': {       '74:4d:28:17:82:2c',
                                                                 'c4:ad:34:2a:7c:00'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '6c:c7:ec:92:f9:c1',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -142.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62,
                                             'ul_snr': 80},
                '6c:c7:ec:9a:1b:bd': {       'alt_macs': None,
                                             'dev_macs': {       '74:4d:28:c4:24:6c',
                                                                 'c4:ad:34:16:99:c3'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '6c:c7:ec:9a:1b:bd',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -130.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -65,
                                             'ul_snr': 65}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '396559641871',
                                                              'in_ucast_pkts': '2016353415',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '04:d6:aa:6b:1f:ae',
                                                                                                                        '50:c7:bf:45:40:af',
                                                                                                                        'b8:69:f4:3f:9c:13'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '52868408446',
                                                                                       'in_ucast_pkts': '253503059',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:68:6c',
                                                                                       'out_discards': '141',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '357726950910',
                                                                                       'out_ucast_pkts': '401379486'},
                                                                               {       'bridged_mac_addresses': [       '48:8f:5a:94:00:7f'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '14284028632',
                                                                                       'in_ucast_pkts': '120865317',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '48:8f:5a:51:c7:13',
                                                                                       'out_discards': '204',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '195899630528',
                                                                                       'out_ucast_pkts': '217600027'},
                                                                               {       'bridged_mac_addresses': [       '6c:72:20:3f:35:d1'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '21616391913',
                                                                                       'in_ucast_pkts': '212624922',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '48:8f:5a:80:66:9b',
                                                                                       'out_discards': '140',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '486241186651',
                                                                                       'out_ucast_pkts': '381939391'},
                                                                               {       'bridged_mac_addresses': [       '74:4d:28:17:82:2c',
                                                                                                                        'c4:ad:34:2a:7c:00'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '49548360081',
                                                                                       'in_ucast_pkts': '160333550',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '6c:c7:ec:92:f9:c1',
                                                                                       'out_discards': '259',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '160668866849',
                                                                                       'out_ucast_pkts': '218330373'},
                                                                               {       'bridged_mac_addresses': [       '74:4d:28:c4:24:6c',
                                                                                                                        'c4:ad:34:16:99:c3'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '21218349882',
                                                                                       'in_ucast_pkts': '101412680',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '6c:c7:ec:9a:1b:bd',
                                                                                       'out_discards': '42',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '89355153921',
                                                                                       'out_ucast_pkts': '151382324'},
                                                                               {       'bridged_mac_addresses': [       '48:8f:5a:83:99:57'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '43849481261',
                                                                                       'in_ucast_pkts': '251984310',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '6c:c7:ec:92:f6:12',
                                                                                       'out_discards': '171',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '257209630931',
                                                                                       'out_ucast_pkts': '349618493'},
                                                                               {       'bridged_mac_addresses': [       'c4:ad:34:f9:8e:57'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '25858259739',
                                                                                       'in_ucast_pkts': '110344819',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:5a:13:8d',
                                                                                       'out_discards': '203',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '104123211954',
                                                                                       'out_ucast_pkts': '166611793'},
                                                                               {       'bridged_mac_addresses': [       'b8:69:f4:3f:9c:2c',
                                                                                                                        'c4:ad:34:f9:8e:45'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '167316361917',
                                                                                       'in_ucast_pkts': '805284758',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:67:a9',
                                                                                       'out_discards': '387',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2718607145691',
                                                                                       'out_ucast_pkts': '2067826467'}],
                                                              'mac_address': '04:d6:aa:6b:1f:ae',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '1547',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '4369831777435',
                                                              'out_ucast_pkts': '3954688354',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 381,
                                                                                                                                            'mac_address': '24:18:1d:99:68:6c',
                                                                                                                                            'noise_floor': -129.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 272,
                                                                                                                                            'mac_address': '48:8f:5a:51:c7:13',
                                                                                                                                            'noise_floor': -129.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 208,
                                                                                                                                            'mac_address': '48:8f:5a:80:66:9b',
                                                                                                                                            'noise_floor': -142.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 346,
                                                                                                                                            'mac_address': '6c:c7:ec:92:f9:c1',
                                                                                                                                            'noise_floor': -142.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 273,
                                                                                                                                            'mac_address': '6c:c7:ec:9a:1b:bd',
                                                                                                                                            'noise_floor': -130.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 195,
                                                                                                                                            'mac_address': '6c:c7:ec:92:f6:12',
                                                                                                                                            'noise_floor': -141.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 258,
                                                                                                                                            'mac_address': '24:18:1d:5a:13:8d',
                                                                                                                                            'noise_floor': -141.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 328,
                                                                                                                                            'mac_address': '24:18:1d:99:67:a9',
                                                                                                                                            'noise_floor': -147.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -129.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TN2-SW60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '23364018',
                                                              'in_octets': '4366967320168',
                                                              'in_ucast_pkts': '3520929795',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:a6:f2:f7',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '6521913',
                                                              'out_octets': '391478926832',
                                                              'out_ucast_pkts': '1652008285',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 22.462463,
                                'model': 'RBwAPG-60ad',
                                'poller_hash': 'BNaqax+u',
                                'serial_number': '92220864C782',
                                'sw_version': '6.45.8',
                                'system_mac_address': 'cc:2d:e0:a6:f2:f7',
                                'uptime': '6016687'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '141',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '357726950910',
                                                                       'in_ucast_pkts': '401379486',
                                                                       'links': [       {       'in_discards': '141',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '357726950910',
                                                                                                'in_ucast_pkts': '401379486',
                                                                                                'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '52868408446',
                                                                                                'out_ucast_pkts': '253503059'}],
                                                                       'mac_address': '24:18:1d:99:68:6c',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '52868408446',
                                                                       'out_ucast_pkts': '253503059',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 381,
                                                                                                                                                     'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-SW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '52868408446',
                                                                       'in_ucast_pkts': '253503059',
                                                                       'name': 'ether1',
                                                                       'out_octets': '357726950910',
                                                                       'out_ucast_pkts': '401379486',
                                                                       'poller_hash': 'MjQxODFkOTk2ODZjZXRoZXIx'}],
                                         'poller_hash': 'JBgdmWhs',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '204',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '195899630528',
                                                                       'in_ucast_pkts': '217600027',
                                                                       'links': [       {       'in_discards': '204',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '195899630528',
                                                                                                'in_ucast_pkts': '217600027',
                                                                                                'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '14284028632',
                                                                                                'out_ucast_pkts': '120865317'}],
                                                                       'mac_address': '48:8f:5a:51:c7:13',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '14284028632',
                                                                       'out_ucast_pkts': '120865317',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 272,
                                                                                                                                                     'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-SW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '14284028632',
                                                                       'in_ucast_pkts': '120865317',
                                                                       'name': 'ether1',
                                                                       'out_octets': '195899630528',
                                                                       'out_ucast_pkts': '217600027',
                                                                       'poller_hash': 'NDg4ZjVhNTFjNzEzZXRoZXIx'}],
                                         'poller_hash': 'SI9aUccT',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '140',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '486241186651',
                                                                       'in_ucast_pkts': '381939391',
                                                                       'links': [       {       'in_discards': '140',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '486241186651',
                                                                                                'in_ucast_pkts': '381939391',
                                                                                                'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '21616391913',
                                                                                                'out_ucast_pkts': '212624922'}],
                                                                       'mac_address': '48:8f:5a:80:66:9b',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '21616391913',
                                                                       'out_ucast_pkts': '212624922',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 208,
                                                                                                                                                     'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-SW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '21616391913',
                                                                       'in_ucast_pkts': '212624922',
                                                                       'name': 'ether1',
                                                                       'out_octets': '486241186651',
                                                                       'out_ucast_pkts': '381939391',
                                                                       'poller_hash': 'NDg4ZjVhODA2NjliZXRoZXIx'}],
                                         'poller_hash': 'SI9agGab',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '259',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '160668866849',
                                                                       'in_ucast_pkts': '218330373',
                                                                       'links': [       {       'in_discards': '259',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '160668866849',
                                                                                                'in_ucast_pkts': '218330373',
                                                                                                'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '49548360081',
                                                                                                'out_ucast_pkts': '160333550'}],
                                                                       'mac_address': '6c:c7:ec:92:f9:c1',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '49548360081',
                                                                       'out_ucast_pkts': '160333550',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 346,
                                                                                                                                                     'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-SW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '49548360081',
                                                                       'in_ucast_pkts': '160333550',
                                                                       'name': 'ether1',
                                                                       'out_octets': '160668866849',
                                                                       'out_ucast_pkts': '218330373',
                                                                       'poller_hash': 'NmNjN2VjOTJmOWMxZXRoZXIx'}],
                                         'poller_hash': 'bMfskvnB',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '42',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '89355153921',
                                                                       'in_ucast_pkts': '151382324',
                                                                       'links': [       {       'in_discards': '42',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '89355153921',
                                                                                                'in_ucast_pkts': '151382324',
                                                                                                'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '21218349882',
                                                                                                'out_ucast_pkts': '101412680'}],
                                                                       'mac_address': '6c:c7:ec:9a:1b:bd',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '21218349882',
                                                                       'out_ucast_pkts': '101412680',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 273,
                                                                                                                                                     'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-SW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '21218349882',
                                                                       'in_ucast_pkts': '101412680',
                                                                       'name': 'ether1',
                                                                       'out_octets': '89355153921',
                                                                       'out_ucast_pkts': '151382324',
                                                                       'poller_hash': 'NmNjN2VjOWExYmJkZXRoZXIx'}],
                                         'poller_hash': 'bMfsmhu9',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '171',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '257209630931',
                                                                       'in_ucast_pkts': '349618493',
                                                                       'links': [       {       'in_discards': '171',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '257209630931',
                                                                                                'in_ucast_pkts': '349618493',
                                                                                                'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '43849481261',
                                                                                                'out_ucast_pkts': '251984310'}],
                                                                       'mac_address': '6c:c7:ec:92:f6:12',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '43849481261',
                                                                       'out_ucast_pkts': '251984310',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 195,
                                                                                                                                                     'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-SW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '43849481261',
                                                                       'in_ucast_pkts': '251984310',
                                                                       'name': 'ether1',
                                                                       'out_octets': '257209630931',
                                                                       'out_ucast_pkts': '349618493',
                                                                       'poller_hash': 'NmNjN2VjOTJmNjEyZXRoZXIx'}],
                                         'poller_hash': 'bMfskvYS',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '203',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '104123211954',
                                                                       'in_ucast_pkts': '166611793',
                                                                       'links': [       {       'in_discards': '203',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '104123211954',
                                                                                                'in_ucast_pkts': '166611793',
                                                                                                'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '25858259739',
                                                                                                'out_ucast_pkts': '110344819'}],
                                                                       'mac_address': '24:18:1d:5a:13:8d',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '25858259739',
                                                                       'out_ucast_pkts': '110344819',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 258,
                                                                                                                                                     'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-SW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '25858259739',
                                                                       'in_ucast_pkts': '110344819',
                                                                       'name': 'ether1',
                                                                       'out_octets': '104123211954',
                                                                       'out_ucast_pkts': '166611793',
                                                                       'poller_hash': 'MjQxODFkNWExMzhkZXRoZXIx'}],
                                         'poller_hash': 'JBgdWhON',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '387',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2718607145691',
                                                                       'in_ucast_pkts': '2067826467',
                                                                       'links': [       {       'in_discards': '387',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2718607145691',
                                                                                                'in_ucast_pkts': '2067826467',
                                                                                                'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '167316361917',
                                                                                                'out_ucast_pkts': '805284758'}],
                                                                       'mac_address': '24:18:1d:99:67:a9',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '167316361917',
                                                                       'out_ucast_pkts': '805284758',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 328,
                                                                                                                                                     'mac_address': '04:d6:aa:6b:1f:ae',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN2-SW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '167316361917',
                                                                       'in_ucast_pkts': '805284758',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2718607145691',
                                                                       'out_ucast_pkts': '2067826467',
                                                                       'poller_hash': 'MjQxODFkOTk2N2E5ZXRoZXIx'}],
                                         'poller_hash': 'JBgdmWep',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_6_45_9_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad.6.45.9.01")
        exp_info = {
                'model': 'RBwAPG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 58320,
                'sta_count': 1,
                'sw_version': '6.45.9',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 1062955705997,
                'dl_en_packets': 885394226,
                'dl_noise_floor': None,
                'dl_rf_bytes': 1064531911171,
                'dl_rf_packets': 961274898,
                'en_if_speed': 1000000000,
                'mem': 21.8841552734375,
                'serial_number': 'D68B0DF8D9D6',
                'ssid': 'Main AP',
                'system_mac_address': '08:55:31:0a:d3:56',
                'ul_en_bytes': 68005916372,
                'ul_en_packets': 365348599,
                'ul_noise_floor': None,
                'ul_rf_bytes': 67809815337,
                'ul_rf_packets': 435269797
        }
        exp_sta_stats = {
                '08:55:31:0a:d3:a4': {       'alt_macs': {'08:55:31:0a:d3:a3'},
                                             'dev_macs': {'08:55:31:0a:d3:57'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -152.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -57.0,
                                             'dl_snr': 95.0,
                                             'ip_address': '10.50.66.200',
                                             'mac_address': '08:55:31:0a:d3:a4',
                                             'name': 'Moran to Main Station',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': 2310000000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -150.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55,
                                             'ul_snr': 95}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '67809815337',
                                                              'in_ucast_pkts': '435269797',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '08:55:31:0a:d3:57'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '67809815337',
                                                                                       'in_ucast_pkts': '435269797',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '08:55:31:0a:d3:a4',
                                                                                       'out_discards': '770',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1064531911171',
                                                                                       'out_ucast_pkts': '961274898'}],
                                                              'mac_address': '08:55:31:0a:d3:57',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '770',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '1064531911171',
                                                              'out_ucast_pkts': '961274898',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 51,
                                                                                                                                            'mac_address': '08:55:31:0a:d3:a4',
                                                                                                                                            'noise_floor': -150.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '2310000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000',
                                                                                                                                            'tx_mcs': 8}],
                                                                                                                   'noise_floor': -150.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Main '
                                                                                                 'AP'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '9573141',
                                                              'in_octets': '1062955705997',
                                                              'in_ucast_pkts': '875821085',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '08:55:31:0a:d3:56',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '9835636',
                                                              'out_octets': '68005916372',
                                                              'out_ucast_pkts': '355512963',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.884155,
                                'model': 'RBwAPG-60ad',
                                'poller_hash': 'CFUxCtNX',
                                'serial_number': 'D68B0DF8D9D6',
                                'sw_version': '6.45.9',
                                'system_mac_address': '08:55:31:0a:d3:56',
                                'uptime': '12567492'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '770',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1064531911171',
                                                                       'in_ucast_pkts': '961274898',
                                                                       'links': [       {       'in_discards': '770',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1064531911171',
                                                                                                'in_ucast_pkts': '961274898',
                                                                                                'mac_address': '08:55:31:0a:d3:57',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '67809815337',
                                                                                                'out_ucast_pkts': '435269797'}],
                                                                       'mac_address': '08:55:31:0a:d3:a4',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '67809815337',
                                                                       'out_ucast_pkts': '435269797',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 51,
                                                                                                                                                     'mac_address': '08:55:31:0a:d3:57',
                                                                                                                                                     'noise_floor': -152.0,
                                                                                                                                                     'rssi': -57.0,
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 95.0,
                                                                                                                                                     'tx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Main '
                                                                                                          'AP'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '67809815337',
                                                                       'in_ucast_pkts': '435269797',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1064531911171',
                                                                       'out_ucast_pkts': '961274898',
                                                                       'poller_hash': 'MDg1NTMxMGFkM2E0ZXRoZXIx'}],
                                         'management_ip': '10.50.66.200',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'RBwAPG-60ad',
                                         'name': 'Moran to Main Station',
                                         'poller_hash': 'CFUxCtOk',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.45.9'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_6_46_2_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad.6.46.2.01")
        exp_info = {
                'model': 'RBwAPG-60ad',
                'rf_chan_width': 2160,
                'rf_freq': 58320,
                'sta_count': 1,
                'sw_version': '6.46.2',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 518059662658,
                'dl_en_packets': 564623632,
                'dl_noise_floor': None,
                'dl_rf_bytes': 518507316957,
                'dl_rf_packets': 592150156,
                'en_if_speed': 1000000000,
                'mem': 19.281005859375,
                'serial_number': 'B02F0B957F48',
                'ssid': 'Drew',
                'system_mac_address': 'c4:ad:34:0c:08:31',
                'ul_en_bytes': 452289760428,
                'ul_en_packets': 540697283,
                'ul_noise_floor': None,
                'ul_rf_bytes': 452326263815,
                'ul_rf_packets': 568567127
        }
        exp_sta_stats = {
                'c4:ad:34:0c:07:b1': {       'alt_macs': {'c4:ad:34:0c:07:b0'},
                                             'dev_macs': {       '3c:7c:3f:6a:42:70',
                                                                 'c4:ad:34:0c:08:32'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': 8,
                                             'dl_noise_floor': -148.0,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': -53.0,
                                             'dl_snr': 95.0,
                                             'ip_address': '10.100.2.12',
                                             'mac_address': 'c4:ad:34:0c:07:b1',
                                             'name': 'MikroTik',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': 2310000000,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -150.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55,
                                             'ul_snr': 95}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '452326263815',
                                                              'in_ucast_pkts': '568567127',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '3c:7c:3f:6a:42:70',
                                                                                                                        'c4:ad:34:0c:08:32'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '452326263815',
                                                                                       'in_ucast_pkts': '568567127',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': 'c4:ad:34:0c:07:b1',
                                                                                       'out_discards': '87',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '518507316957',
                                                                                       'out_ucast_pkts': '592150156'}],
                                                              'mac_address': 'c4:ad:34:0c:08:32',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '87',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '518507316957',
                                                              'out_ucast_pkts': '592150156',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 56,
                                                                                                                                            'mac_address': 'c4:ad:34:0c:07:b1',
                                                                                                                                            'noise_floor': -150.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_link_rate': '2310000000',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000',
                                                                                                                                            'tx_mcs': 8}],
                                                                                                                   'noise_floor': -150.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Drew'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '1372637',
                                                              'in_octets': '518059662658',
                                                              'in_ucast_pkts': '563250995',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'c4:ad:34:0c:08:31',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '2563567',
                                                              'out_octets': '452289760428',
                                                              'out_ucast_pkts': '538133716',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 19.281006,
                                'model': 'RBwAPG-60ad',
                                'poller_hash': 'xK00DAgy',
                                'serial_number': 'B02F0B957F48',
                                'sw_version': '6.46.2',
                                'system_mac_address': 'c4:ad:34:0c:08:31',
                                'uptime': '4397822'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '87',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '518507316957',
                                                                       'in_ucast_pkts': '592150156',
                                                                       'links': [       {       'in_discards': '87',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '518507316957',
                                                                                                'in_ucast_pkts': '592150156',
                                                                                                'mac_address': 'c4:ad:34:0c:08:32',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '452326263815',
                                                                                                'out_ucast_pkts': '568567127'}],
                                                                       'mac_address': 'c4:ad:34:0c:07:b1',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '452326263815',
                                                                       'out_ucast_pkts': '568567127',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 56,
                                                                                                                                                     'mac_address': 'c4:ad:34:0c:08:32',
                                                                                                                                                     'noise_floor': -148.0,
                                                                                                                                                     'rssi': -53.0,
                                                                                                                                                     'rx_link_rate': '2310000000',
                                                                                                                                                     'rx_mcs': 8,
                                                                                                                                                     'snr': 95.0,
                                                                                                                                                     'tx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Drew'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '452326263815',
                                                                       'in_ucast_pkts': '568567127',
                                                                       'mac_address': 'c4:ad:34:0c:07:b0',
                                                                       'name': 'ether1',
                                                                       'out_octets': '518507316957',
                                                                       'out_ucast_pkts': '592150156',
                                                                       'poller_hash': 'YzRhZDM0MGMwN2IxZXRoZXIx'}],
                                         'management_ip': '10.100.2.12',
                                         'manufacturer': 'Mikrotik',
                                         'model': 'RBwAPG-60ad',
                                         'name': 'MikroTik',
                                         'poller_hash': 'xK00DAex',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.46.2',
                                         'system_mac_address': 'c4:ad:34:0c:07:b0'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_44_1_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.44.1.01")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 64800,
                'sta_count': 3,
                'sw_version': None,
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 71788721372,
                'dl_en_packets': 95858029,
                'dl_noise_floor': None,
                'dl_rf_bytes': 74063879248,
                'dl_rf_packets': 132918365,
                'en_if_speed': 1000000000,
                'mem': 20.5963134765625,
                'serial_number': None,
                'ssid': 'Tx12.60S',
                'system_mac_address': 'cc:2d:e0:64:b3:f2',
                'ul_en_bytes': 7596960405,
                'ul_en_packets': 30580673,
                'ul_noise_floor': None,
                'ul_rf_bytes': 7228493499,
                'ul_rf_packets': 38436379
        }
        exp_sta_stats = {
                '6c:c7:ec:35:59:14': {       'alt_macs': None,
                                             'dev_macs': {       '48:f8:b3:bf:50:19',
                                                                 '74:4d:28:e0:5e:00'},
                                             'dl_link_rate': None,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '6c:c7:ec:35:59:14',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': None,
                                             'ul_snr': 50},
                '6c:c7:ec:94:e9:43': {       'alt_macs': None,
                                             'dev_macs': {       '04:d6:aa:6b:1b:28',
                                                                 '4c:5e:0c:e0:e6:95',
                                                                 '74:4d:28:e0:3f:6a'},
                                             'dl_link_rate': None,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '6c:c7:ec:94:e9:43',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': None,
                                             'ul_snr': 80},
                '74:4d:28:2e:53:fa': {       'alt_macs': {'74:4d:28:2e:53:f9'},
                                             'dev_macs': {'74:4d:28:81:59:02'},
                                             'dl_link_rate': None,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '74:4d:28:2e:53:fa',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': None,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': None,
                                             'ul_snr': 65}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '7228493499',
                                                              'in_ucast_pkts': '38436379',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '74:4d:28:81:59:02'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '309023747',
                                                                                       'in_ucast_pkts': '5680820',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '74:4d:28:2e:53:fa',
                                                                                       'out_discards': '159',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '3084963382',
                                                                                       'out_ucast_pkts': '27802662'},
                                                                               {       'bridged_mac_addresses': [       '04:d6:aa:6b:1b:28',
                                                                                                                        '4c:5e:0c:e0:e6:95',
                                                                                                                        '74:4d:28:e0:3f:6a'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3422238880',
                                                                                       'in_ucast_pkts': '15046730',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '6c:c7:ec:94:e9:43',
                                                                                       'out_discards': '313',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '25250024028',
                                                                                       'out_ucast_pkts': '46542374'},
                                                                               {       'bridged_mac_addresses': [       '48:f8:b3:bf:50:19',
                                                                                                                        '74:4d:28:e0:5e:00'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3497230872',
                                                                                       'in_ucast_pkts': '17708829',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '6c:c7:ec:35:59:14',
                                                                                       'out_discards': '1335',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '45728891838',
                                                                                       'out_ucast_pkts': '58573329'}],
                                                              'mac_address': '04:d6:aa:6b:1b:28',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '1807',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '74063879248',
                                                              'out_ucast_pkts': '132918365',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 64800,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'mac_address': '74:4d:28:2e:53:fa',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0},
                                                                                                                                    {       'mac_address': '6c:c7:ec:94:e9:43',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0},
                                                                                                                                    {       'mac_address': '6c:c7:ec:35:59:14',
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0}]}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'Tx12.60S'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '71788721372',
                                                              'in_ucast_pkts': '95858029',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:64:b3:f2',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '7596960405',
                                                              'out_ucast_pkts': '30580673',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 20.596313,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'BNaqaxso',
                                'system_mac_address': 'cc:2d:e0:64:b3:f2',
                                'uptime': '682894'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '159',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '3084963382',
                                                                       'in_ucast_pkts': '27802662',
                                                                       'links': [       {       'in_discards': '159',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '3084963382',
                                                                                                'in_ucast_pkts': '27802662',
                                                                                                'mac_address': '04:d6:aa:6b:1b:28',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '309023747',
                                                                                                'out_ucast_pkts': '5680820'}],
                                                                       'mac_address': '74:4d:28:2e:53:fa',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '309023747',
                                                                       'out_ucast_pkts': '5680820',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '04:d6:aa:6b:1b:28'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx12.60S'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '309023747',
                                                                       'in_ucast_pkts': '5680820',
                                                                       'mac_address': '74:4d:28:2e:53:f9',
                                                                       'name': 'ether1',
                                                                       'out_octets': '3084963382',
                                                                       'out_ucast_pkts': '27802662',
                                                                       'poller_hash': 'NzQ0ZDI4MmU1M2ZhZXRoZXIx'}],
                                         'poller_hash': 'dE0oLlP6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '74:4d:28:2e:53:f9'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '313',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '25250024028',
                                                                       'in_ucast_pkts': '46542374',
                                                                       'links': [       {       'in_discards': '313',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '25250024028',
                                                                                                'in_ucast_pkts': '46542374',
                                                                                                'mac_address': '04:d6:aa:6b:1b:28',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3422238880',
                                                                                                'out_ucast_pkts': '15046730'}],
                                                                       'mac_address': '6c:c7:ec:94:e9:43',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3422238880',
                                                                       'out_ucast_pkts': '15046730',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '04:d6:aa:6b:1b:28'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx12.60S'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '3422238880',
                                                                       'in_ucast_pkts': '15046730',
                                                                       'name': 'ether1',
                                                                       'out_octets': '25250024028',
                                                                       'out_ucast_pkts': '46542374',
                                                                       'poller_hash': 'NmNjN2VjOTRlOTQzZXRoZXIx'}],
                                         'poller_hash': 'bMfslOlD',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1335',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '45728891838',
                                                                       'in_ucast_pkts': '58573329',
                                                                       'links': [       {       'in_discards': '1335',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '45728891838',
                                                                                                'in_ucast_pkts': '58573329',
                                                                                                'mac_address': '04:d6:aa:6b:1b:28',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3497230872',
                                                                                                'out_ucast_pkts': '17708829'}],
                                                                       'mac_address': '6c:c7:ec:35:59:14',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3497230872',
                                                                       'out_ucast_pkts': '17708829',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 64800,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'mac_address': '04:d6:aa:6b:1b:28'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'Tx12.60S'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '3497230872',
                                                                       'in_ucast_pkts': '17708829',
                                                                       'name': 'ether1',
                                                                       'out_octets': '45728891838',
                                                                       'out_ucast_pkts': '58573329',
                                                                       'poller_hash': 'NmNjN2VjMzU1OTE0ZXRoZXIx'}],
                                         'poller_hash': 'bMfsNVkU',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_44_5_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.44.5.01")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 60480,
                'sta_count': 2,
                'sw_version': '6.44.5',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 887444822995,
                'dl_en_packets': 818042215,
                'dl_noise_floor': None,
                'dl_rf_bytes': 887903061906,
                'dl_rf_packets': 894876174,
                'en_if_speed': 1000000000,
                'mem': 22.100830078125,
                'serial_number': '8AA50864F3F4',
                'ssid': '324',
                'system_mac_address': 'cc:2d:e0:b9:42:f3',
                'ul_en_bytes': 89996740763,
                'ul_en_packets': 510111957,
                'ul_noise_floor': None,
                'ul_rf_bytes': 88060721730,
                'ul_rf_packets': 582798648
        }
        exp_sta_stats = {
                '24:18:1d:26:d1:ca': {       'alt_macs': None,
                                             'dev_macs': {       '34:42:62:a8:57:8f',
                                                                 '58:c1:7a:9e:46:87',
                                                                 '5c:5f:67:b1:e4:6e',
                                                                 '5c:ea:1d:88:9c:67',
                                                                 '80:5e:c0:2e:9b:28',
                                                                 '88:ae:07:34:24:72',
                                                                 '94:57:a5:9a:f8:29',
                                                                 'cc:2d:e0:bc:40:af',
                                                                 'd4:ca:6d:35:4e:10'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.8.13',
                                             'mac_address': '24:18:1d:26:d1:ca',
                                             'name': 'South Bldg client',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -141.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61,
                                             'ul_snr': 80},
                '24:18:1d:27:c8:67': {       'alt_macs': None,
                                             'dev_macs': {       '00:5b:94:21:5f:4a',
                                                                 '18:65:71:96:73:5d',
                                                                 '24:18:1d:26:d6:86',
                                                                 '58:c1:7a:9d:80:8f',
                                                                 '58:c1:7a:9d:f6:63',
                                                                 '58:c1:7a:9d:f7:38',
                                                                 '58:c1:7a:9e:47:35',
                                                                 '9c:b7:0d:c9:c6:d6',
                                                                 'a4:08:ea:74:66:72',
                                                                 'b8:a1:75:ed:22:d2',
                                                                 'cc:2d:e0:bc:60:35',
                                                                 'd4:ca:6d:87:95:48',
                                                                 'f8:62:14:e5:4e:dd'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': '10.10.8.10',
                                             'mac_address': '24:18:1d:27:c8:67',
                                             'name': 'ManCamp 60ghz client',
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -139.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59,
                                             'ul_snr': 80}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '88060721730',
                                                              'in_ucast_pkts': '582798648',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '34:42:62:a8:57:8f',
                                                                                                                        '58:c1:7a:9e:46:87',
                                                                                                                        '5c:5f:67:b1:e4:6e',
                                                                                                                        '5c:ea:1d:88:9c:67',
                                                                                                                        '80:5e:c0:2e:9b:28',
                                                                                                                        '88:ae:07:34:24:72',
                                                                                                                        '94:57:a5:9a:f8:29',
                                                                                                                        'cc:2d:e0:bc:40:af',
                                                                                                                        'd4:ca:6d:35:4e:10'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '31803912568',
                                                                                       'in_ucast_pkts': '158357604',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:26:d1:ca',
                                                                                       'out_discards': '161',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '109374984801',
                                                                                       'out_ucast_pkts': '197010378'},
                                                                               {       'bridged_mac_addresses': [       '00:5b:94:21:5f:4a',
                                                                                                                        '18:65:71:96:73:5d',
                                                                                                                        '24:18:1d:26:d6:86',
                                                                                                                        '58:c1:7a:9d:80:8f',
                                                                                                                        '58:c1:7a:9d:f6:63',
                                                                                                                        '58:c1:7a:9d:f7:38',
                                                                                                                        '58:c1:7a:9e:47:35',
                                                                                                                        '9c:b7:0d:c9:c6:d6',
                                                                                                                        'a4:08:ea:74:66:72',
                                                                                                                        'b8:a1:75:ed:22:d2',
                                                                                                                        'cc:2d:e0:bc:60:35',
                                                                                                                        'd4:ca:6d:87:95:48',
                                                                                                                        'f8:62:14:e5:4e:dd'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '56256809162',
                                                                                       'in_ucast_pkts': '424441044',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:27:c8:67',
                                                                                       'out_discards': '168',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '778528077105',
                                                                                       'out_ucast_pkts': '697865796'}],
                                                              'mac_address': '24:18:1d:26:d6:86',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '329',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '887903061906',
                                                              'out_ucast_pkts': '894876174',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 60480,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 87,
                                                                                                                                            'mac_address': '24:18:1d:26:d1:ca',
                                                                                                                                            'noise_floor': -141.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 44,
                                                                                                                                            'mac_address': '24:18:1d:27:c8:67',
                                                                                                                                            'noise_floor': -139.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -139.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': '324'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '887444822995',
                                                              'in_ucast_pkts': '818042215',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:b9:42:f3',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '89996740763',
                                                              'out_ucast_pkts': '510111957',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 22.10083,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'JBgdJtaG',
                                'serial_number': '8AA50864F3F4',
                                'sw_version': '6.44.5',
                                'system_mac_address': 'cc:2d:e0:b9:42:f3',
                                'uptime': '7119050'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '161',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '109374984801',
                                                                       'in_ucast_pkts': '197010378',
                                                                       'links': [       {       'in_discards': '161',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '109374984801',
                                                                                                'in_ucast_pkts': '197010378',
                                                                                                'mac_address': '24:18:1d:26:d6:86',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '31803912568',
                                                                                                'out_ucast_pkts': '158357604'}],
                                                                       'mac_address': '24:18:1d:26:d1:ca',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '31803912568',
                                                                       'out_ucast_pkts': '158357604',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 87,
                                                                                                                                                     'mac_address': '24:18:1d:26:d6:86',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '324'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '31803912568',
                                                                       'in_ucast_pkts': '158357604',
                                                                       'name': 'ether1',
                                                                       'out_octets': '109374984801',
                                                                       'out_ucast_pkts': '197010378',
                                                                       'poller_hash': 'MjQxODFkMjZkMWNhZXRoZXIx'}],
                                         'management_ip': '10.10.8.13',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'South Bldg client',
                                         'poller_hash': 'JBgdJtHK',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.44.5'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '168',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '778528077105',
                                                                       'in_ucast_pkts': '697865796',
                                                                       'links': [       {       'in_discards': '168',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '778528077105',
                                                                                                'in_ucast_pkts': '697865796',
                                                                                                'mac_address': '24:18:1d:26:d6:86',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '56256809162',
                                                                                                'out_ucast_pkts': '424441044'}],
                                                                       'mac_address': '24:18:1d:27:c8:67',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '56256809162',
                                                                       'out_ucast_pkts': '424441044',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 44,
                                                                                                                                                     'mac_address': '24:18:1d:26:d6:86',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': '324'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '56256809162',
                                                                       'in_ucast_pkts': '424441044',
                                                                       'name': 'ether1',
                                                                       'out_octets': '778528077105',
                                                                       'out_ucast_pkts': '697865796',
                                                                       'poller_hash': 'MjQxODFkMjdjODY3ZXRoZXIx'}],
                                         'management_ip': '10.10.8.10',
                                         'manufacturer': 'Mikrotik',
                                         'name': 'ManCamp 60ghz client',
                                         'poller_hash': 'JBgdJ8hn',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '6.44.5'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_5_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.5.01")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 58320,
                'sta_count': 0,
                'sw_version': '6.45.5',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 3975571,
                'dl_en_packets': 85064,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'mem': 20.43914794921875,
                'serial_number': '81ED080F7D06',
                'ssid': 'COU-E60G',
                'system_mac_address': 'cc:2d:e0:be:6d:c9',
                'ul_en_bytes': 3634446,
                'ul_en_packets': 45769,
                'ul_noise_floor': None,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '04:d6:aa:b1:19:2d',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'COU-E60G'}],
                                                              'speed': '0',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '39712',
                                                              'in_octets': '3975571',
                                                              'in_ucast_pkts': '45352',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:be:6d:c9',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '20292',
                                                              'out_octets': '3634446',
                                                              'out_ucast_pkts': '25477',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 20.439148,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'BNaqsRkt',
                                'serial_number': '81ED080F7D06',
                                'sw_version': '6.45.5',
                                'system_mac_address': 'cc:2d:e0:be:6d:c9',
                                'uptime': '36925'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_5_02(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.5.02")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 62640,
                'sta_count': 3,
                'sw_version': '6.45.5',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 5541181801243,
                'dl_en_packets': 4692241378,
                'dl_noise_floor': None,
                'dl_rf_bytes': 5543872674683,
                'dl_rf_packets': 5603143633,
                'en_if_speed': 1000000000,
                'mem': 21.40960693359375,
                'serial_number': '81ED08EFF018',
                'ssid': 'COU-N60G',
                'system_mac_address': 'cc:2d:e0:be:6d:9e',
                'ul_en_bytes': 1064486727127,
                'ul_en_packets': 2041269791,
                'ul_noise_floor': None,
                'ul_rf_bytes': 1084396497164,
                'ul_rf_packets': 3059991523
        }
        exp_sta_stats = {
                '04:d6:aa:a8:d6:fc': {       'alt_macs': None,
                                             'dev_macs': {       '04:d6:aa:b1:19:2a',
                                                                 'b8:69:f4:38:c9:d5',
                                                                 'cc:2d:e0:22:62:ab'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a8:d6:fc',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -141.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61,
                                             'ul_snr': 80},
                '24:18:1d:99:67:d0': {       'alt_macs': None,
                                             'dev_macs': {       'b8:69:f4:3f:9b:84',
                                                                 'c4:ad:34:7d:47:8a'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:99:67:d0',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -139.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59,
                                             'ul_snr': 80},
                '6c:c7:ec:97:c5:43': {       'alt_macs': None,
                                             'dev_macs': {'cc:2d:e0:32:08:83'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '6c:c7:ec:97:c5:43',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -129.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64,
                                             'ul_snr': 65}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1084396497164',
                                                              'in_ucast_pkts': '3059991523',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '04:d6:aa:b1:19:2a',
                                                                                                                        'b8:69:f4:38:c9:d5',
                                                                                                                        'cc:2d:e0:22:62:ab'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '62412393012',
                                                                                       'in_ucast_pkts': '725051820',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a8:d6:fc',
                                                                                       'out_discards': '627',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1224535850976',
                                                                                       'out_ucast_pkts': '1378019341'},
                                                                               {       'bridged_mac_addresses': [       'b8:69:f4:3f:9b:84',
                                                                                                                        'c4:ad:34:7d:47:8a'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '317903777595',
                                                                                       'in_ucast_pkts': '610218410',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:67:d0',
                                                                                       'out_discards': '573',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '421095832000',
                                                                                       'out_ucast_pkts': '689170498'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:32:08:83'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '195270735205',
                                                                                       'in_ucast_pkts': '651935557',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '6c:c7:ec:97:c5:43',
                                                                                       'out_discards': '535',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1686700173763',
                                                                                       'out_ucast_pkts': '1470155817'}],
                                                              'mac_address': '04:d6:aa:b1:19:2a',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '2377',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '5543872674683',
                                                              'out_ucast_pkts': '5603143633',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 244,
                                                                                                                                            'mac_address': '04:d6:aa:a8:d6:fc',
                                                                                                                                            'noise_floor': -141.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 210,
                                                                                                                                            'mac_address': '24:18:1d:99:67:d0',
                                                                                                                                            'noise_floor': -139.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 240,
                                                                                                                                            'mac_address': '6c:c7:ec:97:c5:43',
                                                                                                                                            'noise_floor': -129.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -129.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'COU-N60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '127155834',
                                                              'in_octets': '5541181801243',
                                                              'in_ucast_pkts': '4565085544',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:be:6d:9e',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '34683411',
                                                              'out_octets': '1064486727127',
                                                              'out_ucast_pkts': '2006586380',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.409607,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'BNaqsRkq',
                                'serial_number': '81ED08EFF018',
                                'sw_version': '6.45.5',
                                'system_mac_address': 'cc:2d:e0:be:6d:9e',
                                'uptime': '6599619'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '627',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1224535850976',
                                                                       'in_ucast_pkts': '1378019341',
                                                                       'links': [       {       'in_discards': '627',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1224535850976',
                                                                                                'in_ucast_pkts': '1378019341',
                                                                                                'mac_address': '04:d6:aa:b1:19:2a',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '62412393012',
                                                                                                'out_ucast_pkts': '725051820'}],
                                                                       'mac_address': '04:d6:aa:a8:d6:fc',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '62412393012',
                                                                       'out_ucast_pkts': '725051820',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 244,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:19:2a',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'COU-N60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '62412393012',
                                                                       'in_ucast_pkts': '725051820',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1224535850976',
                                                                       'out_ucast_pkts': '1378019341',
                                                                       'poller_hash': 'MDRkNmFhYThkNmZjZXRoZXIx'}],
                                         'poller_hash': 'BNaqqNb8',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '573',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '421095832000',
                                                                       'in_ucast_pkts': '689170498',
                                                                       'links': [       {       'in_discards': '573',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '421095832000',
                                                                                                'in_ucast_pkts': '689170498',
                                                                                                'mac_address': '04:d6:aa:b1:19:2a',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '317903777595',
                                                                                                'out_ucast_pkts': '610218410'}],
                                                                       'mac_address': '24:18:1d:99:67:d0',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '317903777595',
                                                                       'out_ucast_pkts': '610218410',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 210,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:19:2a',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'COU-N60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '317903777595',
                                                                       'in_ucast_pkts': '610218410',
                                                                       'name': 'ether1',
                                                                       'out_octets': '421095832000',
                                                                       'out_ucast_pkts': '689170498',
                                                                       'poller_hash': 'MjQxODFkOTk2N2QwZXRoZXIx'}],
                                         'poller_hash': 'JBgdmWfQ',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '535',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1686700173763',
                                                                       'in_ucast_pkts': '1470155817',
                                                                       'links': [       {       'in_discards': '535',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1686700173763',
                                                                                                'in_ucast_pkts': '1470155817',
                                                                                                'mac_address': '04:d6:aa:b1:19:2a',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '195270735205',
                                                                                                'out_ucast_pkts': '651935557'}],
                                                                       'mac_address': '6c:c7:ec:97:c5:43',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '195270735205',
                                                                       'out_ucast_pkts': '651935557',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 240,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:19:2a',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'COU-N60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '195270735205',
                                                                       'in_ucast_pkts': '651935557',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1686700173763',
                                                                       'out_ucast_pkts': '1470155817',
                                                                       'poller_hash': 'NmNjN2VjOTdjNTQzZXRoZXIx'}],
                                         'poller_hash': 'bMfsl8VD',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_5_03(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.5.03")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 60480,
                'sta_count': 3,
                'sw_version': '6.45.5',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 11207790787312,
                'dl_en_packets': 8214547626,
                'dl_noise_floor': None,
                'dl_rf_bytes': 11197811940675,
                'dl_rf_packets': 8942851066,
                'en_if_speed': 1000000000,
                'mem': 21.1639404296875,
                'serial_number': '81ED08893CEC',
                'ssid': 'COU-S60G',
                'system_mac_address': 'cc:2d:e0:be:6d:68',
                'ul_en_bytes': 537029562641,
                'ul_en_packets': 3870562303,
                'ul_noise_floor': None,
                'ul_rf_bytes': 546407029567,
                'ul_rf_packets': 4721487716
        }
        exp_sta_stats = {
                '04:d6:aa:a4:cb:cc': {       'alt_macs': None,
                                             'dev_macs': {       '04:d6:aa:b1:18:b4',
                                                                 'c4:ad:34:7b:ea:0a'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a4:cb:cc',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -141.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61,
                                             'ul_snr': 80},
                '24:18:1d:57:aa:60': {       'alt_macs': None,
                                             'dev_macs': {       '80:2a:a8:2f:39:64',
                                                                 'b8:69:f4:45:f4:ed'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:57:aa:60',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -153.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58,
                                             'ul_snr': 95},
                '24:18:1d:99:67:97': {       'alt_macs': None,
                                             'dev_macs': {'48:8f:5a:0a:97:27'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:99:67:97',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -119.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69,
                                             'ul_snr': 50}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '546407029567',
                                                              'in_ucast_pkts': '4721487716',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '80:2a:a8:2f:39:64',
                                                                                                                        'b8:69:f4:45:f4:ed'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '84609744358',
                                                                                       'in_ucast_pkts': '727291552',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:57:aa:60',
                                                                                       'out_discards': '1336',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '589342076819',
                                                                                       'out_ucast_pkts': '911806610'},
                                                                               {       'bridged_mac_addresses': [       '04:d6:aa:b1:18:b4',
                                                                                                                        'c4:ad:34:7b:ea:0a'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '200276854279',
                                                                                       'in_ucast_pkts': '2160095094',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a4:cb:cc',
                                                                                       'out_discards': '868',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4834190705511',
                                                                                       'out_ucast_pkts': '3565156338'},
                                                                               {       'bridged_mac_addresses': [       '48:8f:5a:0a:97:27'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '22360143458',
                                                                                       'in_ucast_pkts': '292748361',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:67:97',
                                                                                       'out_discards': '942',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '206250723068',
                                                                                       'out_ucast_pkts': '369993418'}],
                                                              'mac_address': '04:d6:aa:b1:18:b4',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '4363',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '11197811940675',
                                                              'out_ucast_pkts': '8942851066',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 60480,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 221,
                                                                                                                                            'mac_address': '24:18:1d:57:aa:60',
                                                                                                                                            'noise_floor': -153.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 107,
                                                                                                                                            'mac_address': '04:d6:aa:a4:cb:cc',
                                                                                                                                            'noise_floor': -141.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 220,
                                                                                                                                            'mac_address': '24:18:1d:99:67:97',
                                                                                                                                            'noise_floor': -119.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -119.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'COU-S60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '125257995',
                                                              'in_octets': '11207790787312',
                                                              'in_ucast_pkts': '8089289631',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:be:6d:68',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '31315451',
                                                              'out_octets': '537029562641',
                                                              'out_ucast_pkts': '3839246852',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.16394,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'BNaqsRi0',
                                'serial_number': '81ED08893CEC',
                                'sw_version': '6.45.5',
                                'system_mac_address': 'cc:2d:e0:be:6d:68',
                                'uptime': '6599483'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1336',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '589342076819',
                                                                       'in_ucast_pkts': '911806610',
                                                                       'links': [       {       'in_discards': '1336',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '589342076819',
                                                                                                'in_ucast_pkts': '911806610',
                                                                                                'mac_address': '04:d6:aa:b1:18:b4',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '84609744358',
                                                                                                'out_ucast_pkts': '727291552'}],
                                                                       'mac_address': '24:18:1d:57:aa:60',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '84609744358',
                                                                       'out_ucast_pkts': '727291552',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 221,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:18:b4',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'COU-S60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '84609744358',
                                                                       'in_ucast_pkts': '727291552',
                                                                       'name': 'ether1',
                                                                       'out_octets': '589342076819',
                                                                       'out_ucast_pkts': '911806610',
                                                                       'poller_hash': 'MjQxODFkNTdhYTYwZXRoZXIx'}],
                                         'poller_hash': 'JBgdV6pg',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '868',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4834190705511',
                                                                       'in_ucast_pkts': '3565156338',
                                                                       'links': [       {       'in_discards': '868',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4834190705511',
                                                                                                'in_ucast_pkts': '3565156338',
                                                                                                'mac_address': '04:d6:aa:b1:18:b4',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '200276854279',
                                                                                                'out_ucast_pkts': '2160095094'}],
                                                                       'mac_address': '04:d6:aa:a4:cb:cc',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '200276854279',
                                                                       'out_ucast_pkts': '2160095094',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 107,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:18:b4',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'COU-S60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '200276854279',
                                                                       'in_ucast_pkts': '2160095094',
                                                                       'name': 'ether1',
                                                                       'out_octets': '4834190705511',
                                                                       'out_ucast_pkts': '3565156338',
                                                                       'poller_hash': 'MDRkNmFhYTRjYmNjZXRoZXIx'}],
                                         'poller_hash': 'BNaqpMvM',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '942',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '206250723068',
                                                                       'in_ucast_pkts': '369993418',
                                                                       'links': [       {       'in_discards': '942',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '206250723068',
                                                                                                'in_ucast_pkts': '369993418',
                                                                                                'mac_address': '04:d6:aa:b1:18:b4',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '22360143458',
                                                                                                'out_ucast_pkts': '292748361'}],
                                                                       'mac_address': '24:18:1d:99:67:97',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '22360143458',
                                                                       'out_ucast_pkts': '292748361',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 220,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:18:b4',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'COU-S60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '22360143458',
                                                                       'in_ucast_pkts': '292748361',
                                                                       'name': 'ether1',
                                                                       'out_octets': '206250723068',
                                                                       'out_ucast_pkts': '369993418',
                                                                       'poller_hash': 'MjQxODFkOTk2Nzk3ZXRoZXIx'}],
                                         'poller_hash': 'JBgdmWeX',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_5_04(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.5.04")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 62640,
                'sta_count': 5,
                'sw_version': '6.45.5',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 8220918723057,
                'dl_en_packets': 7180307643,
                'dl_noise_floor': None,
                'dl_rf_bytes': 8209343373116,
                'dl_rf_packets': 8345369618,
                'en_if_speed': 1000000000,
                'mem': 22.27020263671875,
                'serial_number': '8AA508C6DC9A',
                'ssid': 'NU5-NE60G',
                'system_mac_address': 'cc:2d:e0:b9:49:4c',
                'ul_en_bytes': 1138804817611,
                'ul_en_packets': 3290827510,
                'ul_noise_floor': None,
                'ul_rf_bytes': 1157636774854,
                'ul_rf_packets': 4512426163
        }
        exp_sta_stats = {
                '04:d6:aa:a8:d3:67': {       'alt_macs': None,
                                             'dev_macs': {       '64:d1:54:b8:e7:f8',
                                                                 'b8:69:f4:33:1d:22'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a8:d3:67',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -136.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -66,
                                             'ul_snr': 70},
                '24:18:1d:57:ab:3c': {       'alt_macs': None,
                                             'dev_macs': {'48:8f:5a:0a:89:00'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:57:ab:3c',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67,
                                             'ul_snr': 50},
                '24:18:1d:5a:12:4b': {       'alt_macs': None,
                                             'dev_macs': {'74:4d:28:c4:34:69'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:5a:12:4b',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -152.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -57,
                                             'ul_snr': 95},
                'b8:69:f4:91:50:e5': {       'alt_macs': None,
                                             'dev_macs': {       '74:4d:28:a0:61:38',
                                                                 '74:4d:28:a0:61:39',
                                                                 'e0:55:3d:77:f0:16'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:69:f4:91:50:e5',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -138.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58,
                                             'ul_snr': 80},
                'b8:69:f4:91:66:03': {       'alt_macs': {'b8:69:f4:91:66:02'},
                                             'dev_macs': {       '04:d6:aa:b1:16:20',
                                                                 'cc:2d:e0:22:76:a1'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:69:f4:91:66:03',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -118.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -68,
                                             'ul_snr': 50}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '1157636774854',
                                                              'in_ucast_pkts': '4512426163',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '64:d1:54:b8:e7:f8',
                                                                                                                        'b8:69:f4:33:1d:22'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '174271110835',
                                                                                       'in_ucast_pkts': '1532818345',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a8:d3:67',
                                                                                       'out_discards': '6791',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '4197141229423',
                                                                                       'out_ucast_pkts': '3423556331'},
                                                                               {       'bridged_mac_addresses': [       '04:d6:aa:b1:16:20',
                                                                                                                        'cc:2d:e0:22:76:a1'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '91036006279',
                                                                                       'in_ucast_pkts': '654435020',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': 'b8:69:f4:91:66:03',
                                                                                       'out_discards': '1671',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '520314053557',
                                                                                       'out_ucast_pkts': '902546426'},
                                                                               {       'bridged_mac_addresses': [       '48:8f:5a:0a:89:00'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '28352640617',
                                                                                       'in_ucast_pkts': '293219063',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:57:ab:3c',
                                                                                       'out_discards': '878',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '243654062992',
                                                                                       'out_ucast_pkts': '426360961'},
                                                                               {       'bridged_mac_addresses': [       '74:4d:28:c4:34:69'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '160073711267',
                                                                                       'in_ucast_pkts': '579794582',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:5a:12:4b',
                                                                                       'out_discards': '228',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '409528781133',
                                                                                       'out_ucast_pkts': '787186699'},
                                                                               {       'bridged_mac_addresses': [       '74:4d:28:a0:61:38',
                                                                                                                        '74:4d:28:a0:61:39',
                                                                                                                        'e0:55:3d:77:f0:16'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '703903305856',
                                                                                       'in_ucast_pkts': '1452159153',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': 'b8:69:f4:91:50:e5',
                                                                                       'out_discards': '368',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2838705246011',
                                                                                       'out_ucast_pkts': '2805719201'}],
                                                              'mac_address': '04:d6:aa:b1:16:20',
                                                              'mtu': 1500,
                                                              'name': 'NU5-NE60G',
                                                              'oper_up': True,
                                                              'out_discards': '9936',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '8209343373116',
                                                              'out_ucast_pkts': '8345369618',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 165,
                                                                                                                                            'mac_address': '04:d6:aa:a8:d3:67',
                                                                                                                                            'noise_floor': -136.0,
                                                                                                                                            'rssi': -66.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 70.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 125,
                                                                                                                                            'mac_address': 'b8:69:f4:91:66:03',
                                                                                                                                            'noise_floor': -118.0,
                                                                                                                                            'rssi': -68.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 387,
                                                                                                                                            'mac_address': '24:18:1d:57:ab:3c',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 135,
                                                                                                                                            'mac_address': '24:18:1d:5a:12:4b',
                                                                                                                                            'noise_floor': -152.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 135,
                                                                                                                                            'mac_address': 'b8:69:f4:91:50:e5',
                                                                                                                                            'noise_floor': -138.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -117.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'NU5-NE60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '87844984',
                                                              'in_octets': '8220918723057',
                                                              'in_ucast_pkts': '7092462659',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:b9:49:4c',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '17532605',
                                                              'out_octets': '1138804817611',
                                                              'out_ucast_pkts': '3273294905',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 22.270203,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'BNaqsRYg',
                                'serial_number': '8AA508C6DC9A',
                                'sw_version': '6.45.5',
                                'system_mac_address': 'cc:2d:e0:b9:49:4c',
                                'uptime': '6458481'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '6791',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '4197141229423',
                                                                       'in_ucast_pkts': '3423556331',
                                                                       'links': [       {       'in_discards': '6791',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '4197141229423',
                                                                                                'in_ucast_pkts': '3423556331',
                                                                                                'mac_address': '04:d6:aa:b1:16:20',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '174271110835',
                                                                                                'out_ucast_pkts': '1532818345'}],
                                                                       'mac_address': '04:d6:aa:a8:d3:67',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '174271110835',
                                                                       'out_ucast_pkts': '1532818345',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 165,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:20',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU5-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '174271110835',
                                                                       'in_ucast_pkts': '1532818345',
                                                                       'name': 'ether1',
                                                                       'out_octets': '4197141229423',
                                                                       'out_ucast_pkts': '3423556331',
                                                                       'poller_hash': 'MDRkNmFhYThkMzY3ZXRoZXIx'}],
                                         'poller_hash': 'BNaqqNNn',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '1671',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '520314053557',
                                                                       'in_ucast_pkts': '902546426',
                                                                       'links': [       {       'in_discards': '1671',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '520314053557',
                                                                                                'in_ucast_pkts': '902546426',
                                                                                                'mac_address': '04:d6:aa:b1:16:20',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '91036006279',
                                                                                                'out_ucast_pkts': '654435020'}],
                                                                       'mac_address': 'b8:69:f4:91:66:03',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '91036006279',
                                                                       'out_ucast_pkts': '654435020',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 125,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:20',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU5-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '91036006279',
                                                                       'in_ucast_pkts': '654435020',
                                                                       'mac_address': 'b8:69:f4:91:66:02',
                                                                       'name': 'ether1',
                                                                       'out_octets': '520314053557',
                                                                       'out_ucast_pkts': '902546426',
                                                                       'poller_hash': 'Yjg2OWY0OTE2NjAzZXRoZXIx'}],
                                         'poller_hash': 'uGn0kWYD',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b8:69:f4:91:66:02'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '878',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '243654062992',
                                                                       'in_ucast_pkts': '426360961',
                                                                       'links': [       {       'in_discards': '878',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '243654062992',
                                                                                                'in_ucast_pkts': '426360961',
                                                                                                'mac_address': '04:d6:aa:b1:16:20',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '28352640617',
                                                                                                'out_ucast_pkts': '293219063'}],
                                                                       'mac_address': '24:18:1d:57:ab:3c',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '28352640617',
                                                                       'out_ucast_pkts': '293219063',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 387,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:20',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU5-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '28352640617',
                                                                       'in_ucast_pkts': '293219063',
                                                                       'name': 'ether1',
                                                                       'out_octets': '243654062992',
                                                                       'out_ucast_pkts': '426360961',
                                                                       'poller_hash': 'MjQxODFkNTdhYjNjZXRoZXIx'}],
                                         'poller_hash': 'JBgdV6s8',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '228',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '409528781133',
                                                                       'in_ucast_pkts': '787186699',
                                                                       'links': [       {       'in_discards': '228',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '409528781133',
                                                                                                'in_ucast_pkts': '787186699',
                                                                                                'mac_address': '04:d6:aa:b1:16:20',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '160073711267',
                                                                                                'out_ucast_pkts': '579794582'}],
                                                                       'mac_address': '24:18:1d:5a:12:4b',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '160073711267',
                                                                       'out_ucast_pkts': '579794582',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 135,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:20',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU5-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '160073711267',
                                                                       'in_ucast_pkts': '579794582',
                                                                       'name': 'ether1',
                                                                       'out_octets': '409528781133',
                                                                       'out_ucast_pkts': '787186699',
                                                                       'poller_hash': 'MjQxODFkNWExMjRiZXRoZXIx'}],
                                         'poller_hash': 'JBgdWhJL',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '368',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2838705246011',
                                                                       'in_ucast_pkts': '2805719201',
                                                                       'links': [       {       'in_discards': '368',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2838705246011',
                                                                                                'in_ucast_pkts': '2805719201',
                                                                                                'mac_address': '04:d6:aa:b1:16:20',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '703903305856',
                                                                                                'out_ucast_pkts': '1452159153'}],
                                                                       'mac_address': 'b8:69:f4:91:50:e5',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '703903305856',
                                                                       'out_ucast_pkts': '1452159153',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 135,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:20',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU5-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '703903305856',
                                                                       'in_ucast_pkts': '1452159153',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2838705246011',
                                                                       'out_ucast_pkts': '2805719201',
                                                                       'poller_hash': 'Yjg2OWY0OTE1MGU1ZXRoZXIx'}],
                                         'poller_hash': 'uGn0kVDl',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_5_05(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.5.05")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 60480,
                'sta_count': 4,
                'sw_version': '6.45.5',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 10566569629644,
                'dl_en_packets': 8000865831,
                'dl_noise_floor': None,
                'dl_rf_bytes': 10555479915664,
                'dl_rf_packets': 8841392561,
                'en_if_speed': 1000000000,
                'mem': 21.56982421875,
                'serial_number': '8AA508C5C6A7',
                'ssid': 'NU5-SE60G',
                'system_mac_address': 'cc:2d:e0:b9:49:e2',
                'ul_en_bytes': 734747165435,
                'ul_en_packets': 2967038894,
                'ul_noise_floor': None,
                'ul_rf_bytes': 746780182005,
                'ul_rf_packets': 3874086908
        }
        exp_sta_stats = {
                '04:d6:aa:a4:cb:ae': {       'alt_macs': None,
                                             'dev_macs': {'48:8f:5a:0a:0f:6e'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a4:cb:ae',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -141.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -61,
                                             'ul_snr': 80},
                '04:d6:aa:a8:d6:de': {       'alt_macs': None,
                                             'dev_macs': {       'b8:69:f4:38:c9:07',
                                                                 'b8:69:f4:99:2f:21'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a8:d6:de',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -139.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -59,
                                             'ul_snr': 80},
                '24:18:1d:99:67:a0': {       'alt_macs': None,
                                             'dev_macs': {       '04:d6:aa:b1:16:2d',
                                                                 '08:55:31:66:35:6a',
                                                                 'b8:69:f4:3f:9b:1d'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:99:67:a0',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -151.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56,
                                             'ul_snr': 95},
                'b8:69:f4:91:66:73': {       'alt_macs': {'b8:69:f4:91:66:72'},
                                             'dev_macs': {'cc:2d:e0:ad:f5:e5'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:69:f4:91:66:73',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -119.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -69,
                                             'ul_snr': 50}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '746780182005',
                                                              'in_ucast_pkts': '3874086908',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       'b8:69:f4:38:c9:07',
                                                                                                                        'b8:69:f4:99:2f:21'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '250386271202',
                                                                                       'in_ucast_pkts': '2115633282',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a8:d6:de',
                                                                                       'out_discards': '694',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '8004395035780',
                                                                                       'out_ucast_pkts': '6055038621'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:ad:f5:e5'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '197955055524',
                                                                                       'in_ucast_pkts': '906293895',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': 'b8:69:f4:91:66:73',
                                                                                       'out_discards': '8735',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1089409059113',
                                                                                       'out_ucast_pkts': '1328600116'},
                                                                               {       'bridged_mac_addresses': [       '48:8f:5a:0a:0f:6e'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '297974746034',
                                                                                       'in_ucast_pkts': '845213371',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a4:cb:ae',
                                                                                       'out_discards': '613',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '1461342172947',
                                                                                       'out_ucast_pkts': '1450597685'},
                                                                               {       'bridged_mac_addresses': [       '04:d6:aa:b1:16:2d',
                                                                                                                        '08:55:31:66:35:6a',
                                                                                                                        'b8:69:f4:3f:9b:1d'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '464109245',
                                                                                       'in_ucast_pkts': '6946360',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:67:a0',
                                                                                       'out_discards': '116',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '333647824',
                                                                                       'out_ucast_pkts': '7156139'}],
                                                              'mac_address': '04:d6:aa:b1:16:2d',
                                                              'mtu': 1500,
                                                              'name': 'NU5-SE60G',
                                                              'oper_up': True,
                                                              'out_discards': '10158',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '10555479915664',
                                                              'out_ucast_pkts': '8841392561',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 60480,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 136,
                                                                                                                                            'mac_address': '04:d6:aa:a8:d6:de',
                                                                                                                                            'noise_floor': -139.0,
                                                                                                                                            'rssi': -59.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 161,
                                                                                                                                            'mac_address': 'b8:69:f4:91:66:73',
                                                                                                                                            'noise_floor': -119.0,
                                                                                                                                            'rssi': -69.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 180,
                                                                                                                                            'mac_address': '04:d6:aa:a4:cb:ae',
                                                                                                                                            'noise_floor': -141.0,
                                                                                                                                            'rssi': -61.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 147,
                                                                                                                                            'mac_address': '24:18:1d:99:67:a0',
                                                                                                                                            'noise_floor': -151.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -119.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'NU5-SE60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '81370317',
                                                              'in_octets': '10566569629644',
                                                              'in_ucast_pkts': '7919495514',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:b9:49:e2',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '24008007',
                                                              'out_octets': '734747165435',
                                                              'out_ucast_pkts': '2943030887',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.569824,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'BNaqsRYt',
                                'serial_number': '8AA508C5C6A7',
                                'sw_version': '6.45.5',
                                'system_mac_address': 'cc:2d:e0:b9:49:e2',
                                'uptime': '6457360'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '694',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '8004395035780',
                                                                       'in_ucast_pkts': '6055038621',
                                                                       'links': [       {       'in_discards': '694',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '8004395035780',
                                                                                                'in_ucast_pkts': '6055038621',
                                                                                                'mac_address': '04:d6:aa:b1:16:2d',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '250386271202',
                                                                                                'out_ucast_pkts': '2115633282'}],
                                                                       'mac_address': '04:d6:aa:a8:d6:de',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '250386271202',
                                                                       'out_ucast_pkts': '2115633282',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 136,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:2d',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU5-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '250386271202',
                                                                       'in_ucast_pkts': '2115633282',
                                                                       'name': 'ether1',
                                                                       'out_octets': '8004395035780',
                                                                       'out_ucast_pkts': '6055038621',
                                                                       'poller_hash': 'MDRkNmFhYThkNmRlZXRoZXIx'}],
                                         'poller_hash': 'BNaqqNbe',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '8735',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1089409059113',
                                                                       'in_ucast_pkts': '1328600116',
                                                                       'links': [       {       'in_discards': '8735',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1089409059113',
                                                                                                'in_ucast_pkts': '1328600116',
                                                                                                'mac_address': '04:d6:aa:b1:16:2d',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '197955055524',
                                                                                                'out_ucast_pkts': '906293895'}],
                                                                       'mac_address': 'b8:69:f4:91:66:73',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '197955055524',
                                                                       'out_ucast_pkts': '906293895',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 161,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:2d',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU5-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '197955055524',
                                                                       'in_ucast_pkts': '906293895',
                                                                       'mac_address': 'b8:69:f4:91:66:72',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1089409059113',
                                                                       'out_ucast_pkts': '1328600116',
                                                                       'poller_hash': 'Yjg2OWY0OTE2NjczZXRoZXIx'}],
                                         'poller_hash': 'uGn0kWZz',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': 'b8:69:f4:91:66:72'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '613',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '1461342172947',
                                                                       'in_ucast_pkts': '1450597685',
                                                                       'links': [       {       'in_discards': '613',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '1461342172947',
                                                                                                'in_ucast_pkts': '1450597685',
                                                                                                'mac_address': '04:d6:aa:b1:16:2d',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '297974746034',
                                                                                                'out_ucast_pkts': '845213371'}],
                                                                       'mac_address': '04:d6:aa:a4:cb:ae',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '297974746034',
                                                                       'out_ucast_pkts': '845213371',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 180,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:2d',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU5-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '297974746034',
                                                                       'in_ucast_pkts': '845213371',
                                                                       'name': 'ether1',
                                                                       'out_octets': '1461342172947',
                                                                       'out_ucast_pkts': '1450597685',
                                                                       'poller_hash': 'MDRkNmFhYTRjYmFlZXRoZXIx'}],
                                         'poller_hash': 'BNaqpMuu',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '116',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '333647824',
                                                                       'in_ucast_pkts': '7156139',
                                                                       'links': [       {       'in_discards': '116',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '333647824',
                                                                                                'in_ucast_pkts': '7156139',
                                                                                                'mac_address': '04:d6:aa:b1:16:2d',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '464109245',
                                                                                                'out_ucast_pkts': '6946360'}],
                                                                       'mac_address': '24:18:1d:99:67:a0',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '464109245',
                                                                       'out_ucast_pkts': '6946360',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 147,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:2d',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'NU5-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '464109245',
                                                                       'in_ucast_pkts': '6946360',
                                                                       'name': 'ether1',
                                                                       'out_octets': '333647824',
                                                                       'out_ucast_pkts': '7156139',
                                                                       'poller_hash': 'MjQxODFkOTk2N2EwZXRoZXIx'}],
                                         'poller_hash': 'JBgdmWeg',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_6_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.6.01")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 60480,
                'sta_count': 5,
                'sw_version': '6.45.6',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 784038343564,
                'dl_en_packets': 619692822,
                'dl_noise_floor': None,
                'dl_rf_bytes': 790832876632,
                'dl_rf_packets': 894313812,
                'en_if_speed': 1000000000,
                'mem': 21.2554931640625,
                'serial_number': '8AA5083A2BC8',
                'ssid': 'TN3-NE60G',
                'system_mac_address': 'cc:2d:e0:b9:4a:42',
                'ul_en_bytes': 76070640089,
                'ul_en_packets': 276051827,
                'ul_noise_floor': None,
                'ul_rf_bytes': 83586598527,
                'ul_rf_packets': 549804257
        }
        exp_sta_stats = {
                '04:d6:aa:a8:d1:87': {       'alt_macs': None,
                                             'dev_macs': {       '64:d1:54:9e:79:7a',
                                                                 'b8:69:f4:32:ee:03'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a8:d1:87',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -142.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62,
                                             'ul_snr': 80},
                '04:d6:aa:a8:d3:8c': {       'alt_macs': None,
                                             'dev_macs': {       '48:8f:5a:93:c0:00',
                                                                 'b8:69:f4:38:c9:73'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a8:d3:8c',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -142.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -62,
                                             'ul_snr': 80},
                '04:d6:aa:a8:d6:83': {       'alt_macs': None,
                                             'dev_macs': {       '64:d1:54:f5:aa:56',
                                                                 'b8:69:f4:33:21:b0'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a8:d6:83',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -128.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -63,
                                             'ul_snr': 65},
                '24:18:1d:64:ec:97': {       'alt_macs': None,
                                             'dev_macs': {       '64:d1:54:90:98:1c',
                                                                 'b8:69:f4:45:f3:99'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:64:ec:97',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -129.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64,
                                             'ul_snr': 65},
                '24:18:1d:64:ed:ec': {       'alt_macs': None,
                                             'dev_macs': {       '04:d6:aa:b1:1c:6e',
                                                                 '64:d1:54:88:7a:2c',
                                                                 'b8:69:f4:45:f1:fc'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:64:ed:ec',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -128.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -63,
                                             'ul_snr': 65}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '83586598527',
                                                              'in_ucast_pkts': '549804257',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '48:8f:5a:93:c0:00',
                                                                                                                        'b8:69:f4:38:c9:73'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '3887938802',
                                                                                       'in_ucast_pkts': '70057308',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a8:d3:8c',
                                                                                       'out_discards': '28',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '74913960953',
                                                                                       'out_ucast_pkts': '113712910'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:f5:aa:56',
                                                                                                                        'b8:69:f4:33:21:b0'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '2345216691',
                                                                                       'in_ucast_pkts': '64432975',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a8:d6:83',
                                                                                       'out_discards': '104',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '2615612368',
                                                                                       'out_ucast_pkts': '67693058'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:9e:79:7a',
                                                                                                                        'b8:69:f4:32:ee:03'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '9364799363',
                                                                                       'in_ucast_pkts': '102011671',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a8:d1:87',
                                                                                       'out_discards': '31',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '82566196769',
                                                                                       'out_ucast_pkts': '123299059'},
                                                                               {       'bridged_mac_addresses': [       '04:d6:aa:b1:1c:6e',
                                                                                                                        '64:d1:54:88:7a:2c',
                                                                                                                        'b8:69:f4:45:f1:fc'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '21002723485',
                                                                                       'in_ucast_pkts': '161861802',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:64:ed:ec',
                                                                                       'out_discards': '86',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '462318379923',
                                                                                       'out_ucast_pkts': '387343155'},
                                                                               {       'bridged_mac_addresses': [       '64:d1:54:90:98:1c',
                                                                                                                        'b8:69:f4:45:f3:99'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '46985920186',
                                                                                       'in_ucast_pkts': '151440501',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:64:ec:97',
                                                                                       'out_discards': '92',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '168418726619',
                                                                                       'out_ucast_pkts': '202265630'}],
                                                              'mac_address': '04:d6:aa:b1:1c:6e',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '341',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '790832876632',
                                                              'out_ucast_pkts': '894313812',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 60480,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 106,
                                                                                                                                            'mac_address': '04:d6:aa:a8:d3:8c',
                                                                                                                                            'noise_floor': -142.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 268,
                                                                                                                                            'mac_address': '04:d6:aa:a8:d6:83',
                                                                                                                                            'noise_floor': -128.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 64,
                                                                                                                                            'mac_address': '04:d6:aa:a8:d1:87',
                                                                                                                                            'noise_floor': -142.0,
                                                                                                                                            'rssi': -62.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 80.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 201,
                                                                                                                                            'mac_address': '24:18:1d:64:ed:ec',
                                                                                                                                            'noise_floor': -128.0,
                                                                                                                                            'rssi': -63.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 262,
                                                                                                                                            'mac_address': '24:18:1d:64:ec:97',
                                                                                                                                            'noise_floor': -129.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -128.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TN3-NE60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '8573660',
                                                              'in_octets': '784038343564',
                                                              'in_ucast_pkts': '611119162',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:b9:4a:42',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '5636195',
                                                              'out_octets': '76070640089',
                                                              'out_ucast_pkts': '270415632',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.255493,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'BNaqsRxu',
                                'serial_number': '8AA5083A2BC8',
                                'sw_version': '6.45.6',
                                'system_mac_address': 'cc:2d:e0:b9:4a:42',
                                'uptime': '6017866'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '28',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '74913960953',
                                                                       'in_ucast_pkts': '113712910',
                                                                       'links': [       {       'in_discards': '28',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '74913960953',
                                                                                                'in_ucast_pkts': '113712910',
                                                                                                'mac_address': '04:d6:aa:b1:1c:6e',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '3887938802',
                                                                                                'out_ucast_pkts': '70057308'}],
                                                                       'mac_address': '04:d6:aa:a8:d3:8c',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '3887938802',
                                                                       'out_ucast_pkts': '70057308',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 106,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:1c:6e',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN3-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '3887938802',
                                                                       'in_ucast_pkts': '70057308',
                                                                       'name': 'ether1',
                                                                       'out_octets': '74913960953',
                                                                       'out_ucast_pkts': '113712910',
                                                                       'poller_hash': 'MDRkNmFhYThkMzhjZXRoZXIx'}],
                                         'poller_hash': 'BNaqqNOM',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '104',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '2615612368',
                                                                       'in_ucast_pkts': '67693058',
                                                                       'links': [       {       'in_discards': '104',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '2615612368',
                                                                                                'in_ucast_pkts': '67693058',
                                                                                                'mac_address': '04:d6:aa:b1:1c:6e',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '2345216691',
                                                                                                'out_ucast_pkts': '64432975'}],
                                                                       'mac_address': '04:d6:aa:a8:d6:83',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '2345216691',
                                                                       'out_ucast_pkts': '64432975',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 268,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:1c:6e',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN3-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '2345216691',
                                                                       'in_ucast_pkts': '64432975',
                                                                       'name': 'ether1',
                                                                       'out_octets': '2615612368',
                                                                       'out_ucast_pkts': '67693058',
                                                                       'poller_hash': 'MDRkNmFhYThkNjgzZXRoZXIx'}],
                                         'poller_hash': 'BNaqqNaD',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '31',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '82566196769',
                                                                       'in_ucast_pkts': '123299059',
                                                                       'links': [       {       'in_discards': '31',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '82566196769',
                                                                                                'in_ucast_pkts': '123299059',
                                                                                                'mac_address': '04:d6:aa:b1:1c:6e',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '9364799363',
                                                                                                'out_ucast_pkts': '102011671'}],
                                                                       'mac_address': '04:d6:aa:a8:d1:87',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '9364799363',
                                                                       'out_ucast_pkts': '102011671',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 64,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:1c:6e',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN3-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '9364799363',
                                                                       'in_ucast_pkts': '102011671',
                                                                       'name': 'ether1',
                                                                       'out_octets': '82566196769',
                                                                       'out_ucast_pkts': '123299059',
                                                                       'poller_hash': 'MDRkNmFhYThkMTg3ZXRoZXIx'}],
                                         'poller_hash': 'BNaqqNGH',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '86',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '462318379923',
                                                                       'in_ucast_pkts': '387343155',
                                                                       'links': [       {       'in_discards': '86',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '462318379923',
                                                                                                'in_ucast_pkts': '387343155',
                                                                                                'mac_address': '04:d6:aa:b1:1c:6e',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '21002723485',
                                                                                                'out_ucast_pkts': '161861802'}],
                                                                       'mac_address': '24:18:1d:64:ed:ec',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '21002723485',
                                                                       'out_ucast_pkts': '161861802',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 201,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:1c:6e',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN3-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '21002723485',
                                                                       'in_ucast_pkts': '161861802',
                                                                       'name': 'ether1',
                                                                       'out_octets': '462318379923',
                                                                       'out_ucast_pkts': '387343155',
                                                                       'poller_hash': 'MjQxODFkNjRlZGVjZXRoZXIx'}],
                                         'poller_hash': 'JBgdZO3s',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '92',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '168418726619',
                                                                       'in_ucast_pkts': '202265630',
                                                                       'links': [       {       'in_discards': '92',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '168418726619',
                                                                                                'in_ucast_pkts': '202265630',
                                                                                                'mac_address': '04:d6:aa:b1:1c:6e',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '46985920186',
                                                                                                'out_ucast_pkts': '151440501'}],
                                                                       'mac_address': '24:18:1d:64:ec:97',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '46985920186',
                                                                       'out_ucast_pkts': '151440501',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 262,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:1c:6e',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN3-NE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '46985920186',
                                                                       'in_ucast_pkts': '151440501',
                                                                       'name': 'ether1',
                                                                       'out_octets': '168418726619',
                                                                       'out_ucast_pkts': '202265630',
                                                                       'poller_hash': 'MjQxODFkNjRlYzk3ZXRoZXIx'}],
                                         'poller_hash': 'JBgdZOyX',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_6_02(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.6.02")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 62640,
                'sta_count': 2,
                'sw_version': '6.45.6',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 304647326492,
                'dl_en_packets': 325412376,
                'dl_noise_floor': None,
                'dl_rf_bytes': 306441808962,
                'dl_rf_packets': 414819015,
                'en_if_speed': 1000000000,
                'mem': 21.38824462890625,
                'serial_number': '8AA508EC1F40',
                'ssid': 'TN3-SE60G',
                'system_mac_address': 'cc:2d:e0:b9:4a:71',
                'ul_en_bytes': 108293473774,
                'ul_en_packets': 228714991,
                'ul_noise_floor': None,
                'ul_rf_bytes': 109889824252,
                'ul_rf_packets': 322545290
        }
        exp_sta_stats = {
                '24:18:1d:64:ec:92': {       'alt_macs': None,
                                             'dev_macs': {       '04:d6:aa:b1:16:21',
                                                                 'b8:69:f4:45:f3:c4',
                                                                 'cc:2d:e0:24:b4:bc'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:64:ec:92',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -152.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -57,
                                             'ul_snr': 95},
                '6c:c7:ec:9a:1a:be': {       'alt_macs': None,
                                             'dev_macs': {'74:4d:28:c4:38:3e'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '6c:c7:ec:9a:1a:be',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -129.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -64,
                                             'ul_snr': 65}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '109889824252',
                                                              'in_ucast_pkts': '322545290',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '04:d6:aa:b1:16:21',
                                                                                                                        'b8:69:f4:45:f3:c4',
                                                                                                                        'cc:2d:e0:24:b4:bc'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '46101371783',
                                                                                       'in_ucast_pkts': '142940464',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:64:ec:92',
                                                                                       'out_discards': '57',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '146618367866',
                                                                                       'out_ucast_pkts': '188959503'},
                                                                               {       'bridged_mac_addresses': [       '74:4d:28:c4:38:3e'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '63788452469',
                                                                                       'in_ucast_pkts': '179604826',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '6c:c7:ec:9a:1a:be',
                                                                                       'out_discards': '34',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '159823441096',
                                                                                       'out_ucast_pkts': '225859512'}],
                                                              'mac_address': '04:d6:aa:b1:16:21',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '91',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '306441808962',
                                                              'out_ucast_pkts': '414819015',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 103,
                                                                                                                                            'mac_address': '24:18:1d:64:ec:92',
                                                                                                                                            'noise_floor': -152.0,
                                                                                                                                            'rssi': -57.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 312,
                                                                                                                                            'mac_address': '6c:c7:ec:9a:1a:be',
                                                                                                                                            'noise_floor': -129.0,
                                                                                                                                            'rssi': -64.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -129.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TN3-SE60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '10289285',
                                                              'in_octets': '304647326492',
                                                              'in_ucast_pkts': '315123091',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:b9:4a:71',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '3920759',
                                                              'out_octets': '108293473774',
                                                              'out_ucast_pkts': '224794232',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.388245,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'BNaqsRYh',
                                'serial_number': '8AA508EC1F40',
                                'sw_version': '6.45.6',
                                'system_mac_address': 'cc:2d:e0:b9:4a:71',
                                'uptime': '6018045'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '57',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '146618367866',
                                                                       'in_ucast_pkts': '188959503',
                                                                       'links': [       {       'in_discards': '57',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '146618367866',
                                                                                                'in_ucast_pkts': '188959503',
                                                                                                'mac_address': '04:d6:aa:b1:16:21',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '46101371783',
                                                                                                'out_ucast_pkts': '142940464'}],
                                                                       'mac_address': '24:18:1d:64:ec:92',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '46101371783',
                                                                       'out_ucast_pkts': '142940464',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 103,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:21',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN3-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '46101371783',
                                                                       'in_ucast_pkts': '142940464',
                                                                       'name': 'ether1',
                                                                       'out_octets': '146618367866',
                                                                       'out_ucast_pkts': '188959503',
                                                                       'poller_hash': 'MjQxODFkNjRlYzkyZXRoZXIx'}],
                                         'poller_hash': 'JBgdZOyS',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '34',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '159823441096',
                                                                       'in_ucast_pkts': '225859512',
                                                                       'links': [       {       'in_discards': '34',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '159823441096',
                                                                                                'in_ucast_pkts': '225859512',
                                                                                                'mac_address': '04:d6:aa:b1:16:21',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '63788452469',
                                                                                                'out_ucast_pkts': '179604826'}],
                                                                       'mac_address': '6c:c7:ec:9a:1a:be',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '63788452469',
                                                                       'out_ucast_pkts': '179604826',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 312,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:16:21',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN3-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '63788452469',
                                                                       'in_ucast_pkts': '179604826',
                                                                       'name': 'ether1',
                                                                       'out_octets': '159823441096',
                                                                       'out_ucast_pkts': '225859512',
                                                                       'poller_hash': 'NmNjN2VjOWExYWJlZXRoZXIx'}],
                                         'poller_hash': 'bMfsmhq+',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_6_03(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.6.03")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 58320,
                'sta_count': 2,
                'sw_version': '6.45.6',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 899574434837,
                'dl_en_packets': 705590411,
                'dl_noise_floor': None,
                'dl_rf_bytes': 899264060558,
                'dl_rf_packets': 787066023,
                'en_if_speed': 1000000000,
                'mem': 20.71380615234375,
                'serial_number': '8AA508DBF0C3',
                'ssid': 'TN3-NW60G',
                'system_mac_address': 'cc:2d:e0:bc:31:09',
                'ul_en_bytes': 80527959882,
                'ul_en_packets': 417146845,
                'ul_noise_floor': None,
                'ul_rf_bytes': 81936716362,
                'ul_rf_packets': 508143943
        }
        exp_sta_stats = {
                '24:18:1d:5a:13:23': {       'alt_macs': None,
                                             'dev_macs': {'c4:ad:34:7d:48:d4'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:5a:13:23',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -150.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55,
                                             'ul_snr': 95},
                '24:18:1d:9a:93:3d': {       'alt_macs': None,
                                             'dev_macs': {       '24:18:1d:26:d2:bb',
                                                                 'b8:69:f4:3f:9a:f0',
                                                                 'd4:ca:6d:a2:87:73'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:9a:93:3d',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -153.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58,
                                             'ul_snr': 95}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '81936716362',
                                                              'in_ucast_pkts': '508143943',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '24:18:1d:26:d2:bb',
                                                                                                                        'b8:69:f4:3f:9a:f0',
                                                                                                                        'd4:ca:6d:a2:87:73'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '41110911649',
                                                                                       'in_ucast_pkts': '275460329',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:9a:93:3d',
                                                                                       'out_discards': '62',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '506801322404',
                                                                                       'out_ucast_pkts': '442636140'},
                                                                               {       'bridged_mac_addresses': [       'c4:ad:34:7d:48:d4'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '40825804713',
                                                                                       'in_ucast_pkts': '232683614',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:5a:13:23',
                                                                                       'out_discards': '160',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '392462738154',
                                                                                       'out_ucast_pkts': '344429883'}],
                                                              'mac_address': '24:18:1d:26:d2:bb',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '222',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '899264060558',
                                                              'out_ucast_pkts': '787066023',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 159,
                                                                                                                                            'mac_address': '24:18:1d:9a:93:3d',
                                                                                                                                            'noise_floor': -153.0,
                                                                                                                                            'rssi': -58.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 79,
                                                                                                                                            'mac_address': '24:18:1d:5a:13:23',
                                                                                                                                            'noise_floor': -150.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -150.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'TN3-NW60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '10289264',
                                                              'in_octets': '899574434837',
                                                              'in_ucast_pkts': '695301147',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:bc:31:09',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '3921701',
                                                              'out_octets': '80527959882',
                                                              'out_ucast_pkts': '413225144',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 20.713806,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'JBgdJtK7',
                                'serial_number': '8AA508DBF0C3',
                                'sw_version': '6.45.6',
                                'system_mac_address': 'cc:2d:e0:bc:31:09',
                                'uptime': '6018156'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '62',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '506801322404',
                                                                       'in_ucast_pkts': '442636140',
                                                                       'links': [       {       'in_discards': '62',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '506801322404',
                                                                                                'in_ucast_pkts': '442636140',
                                                                                                'mac_address': '24:18:1d:26:d2:bb',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '41110911649',
                                                                                                'out_ucast_pkts': '275460329'}],
                                                                       'mac_address': '24:18:1d:9a:93:3d',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '41110911649',
                                                                       'out_ucast_pkts': '275460329',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 159,
                                                                                                                                                     'mac_address': '24:18:1d:26:d2:bb',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN3-NW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '41110911649',
                                                                       'in_ucast_pkts': '275460329',
                                                                       'name': 'ether1',
                                                                       'out_octets': '506801322404',
                                                                       'out_ucast_pkts': '442636140',
                                                                       'poller_hash': 'MjQxODFkOWE5MzNkZXRoZXIx'}],
                                         'poller_hash': 'JBgdmpM9',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '160',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '392462738154',
                                                                       'in_ucast_pkts': '344429883',
                                                                       'links': [       {       'in_discards': '160',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '392462738154',
                                                                                                'in_ucast_pkts': '344429883',
                                                                                                'mac_address': '24:18:1d:26:d2:bb',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '40825804713',
                                                                                                'out_ucast_pkts': '232683614'}],
                                                                       'mac_address': '24:18:1d:5a:13:23',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '40825804713',
                                                                       'out_ucast_pkts': '232683614',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 58320,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 79,
                                                                                                                                                     'mac_address': '24:18:1d:26:d2:bb',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'TN3-NW60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '40825804713',
                                                                       'in_ucast_pkts': '232683614',
                                                                       'name': 'ether1',
                                                                       'out_octets': '392462738154',
                                                                       'out_ucast_pkts': '344429883',
                                                                       'poller_hash': 'MjQxODFkNWExMzIzZXRoZXIx'}],
                                         'poller_hash': 'JBgdWhMj',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_8_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.8.01")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 62640,
                'sta_count': 2,
                'sw_version': '6.45.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 5880838697935,
                'dl_en_packets': 4402841283,
                'dl_noise_floor': None,
                'dl_rf_bytes': 5859910370448,
                'dl_rf_packets': 4732730779,
                'en_if_speed': 1000000000,
                'mem': 21.12884521484375,
                'serial_number': '81ED086CD43A',
                'ssid': 'KP2-N60G',
                'system_mac_address': 'cc:2d:e0:be:6e:3b',
                'ul_en_bytes': 279548658130,
                'ul_en_packets': 1716930989,
                'ul_noise_floor': None,
                'ul_rf_bytes': 272679565954,
                'ul_rf_packets': 2119043705
        }
        exp_sta_stats = {
                '24:18:1d:63:65:83': {       'alt_macs': None,
                                             'dev_macs': {       '04:d6:aa:b1:18:fc',
                                                                 'b8:69:f4:3f:b7:5e',
                                                                 'cc:2d:e0:29:c0:3d'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:63:65:83',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -151.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -56,
                                             'ul_snr': 95},
                '24:18:1d:99:63:9f': {       'alt_macs': None,
                                             'dev_macs': {       'b8:69:f4:3f:b7:5d',
                                                                 'cc:2d:e0:c8:46:45'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:99:63:9f',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -130.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -65,
                                             'ul_snr': 65}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '272679565954',
                                                              'in_ucast_pkts': '2119043705',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       'b8:69:f4:3f:b7:5d',
                                                                                                                        'cc:2d:e0:c8:46:45'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '252507546159',
                                                                                       'in_ucast_pkts': '1784832687',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:63:9f',
                                                                                       'out_discards': '594',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '5518965534656',
                                                                                       'out_ucast_pkts': '4193099844'},
                                                                               {       'bridged_mac_addresses': [       '04:d6:aa:b1:18:fc',
                                                                                                                        'b8:69:f4:3f:b7:5e',
                                                                                                                        'cc:2d:e0:29:c0:3d'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '20172019795',
                                                                                       'in_ucast_pkts': '334211018',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:63:65:83',
                                                                                       'out_discards': '356',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '340944835792',
                                                                                       'out_ucast_pkts': '539630935'}],
                                                              'mac_address': '04:d6:aa:b1:18:fc',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '950',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '5859910370448',
                                                              'out_ucast_pkts': '4732730779',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 62640,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 196,
                                                                                                                                            'mac_address': '24:18:1d:99:63:9f',
                                                                                                                                            'noise_floor': -130.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 54,
                                                                                                                                            'mac_address': '24:18:1d:63:65:83',
                                                                                                                                            'noise_floor': -151.0,
                                                                                                                                            'rssi': -56.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -130.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'KP2-N60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '77163931',
                                                              'in_octets': '5880838697935',
                                                              'in_ucast_pkts': '4325677352',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:be:6e:3b',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '11133152',
                                                              'out_octets': '279548658130',
                                                              'out_ucast_pkts': '1705797837',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.128845,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'BNaqsRj8',
                                'serial_number': '81ED086CD43A',
                                'sw_version': '6.45.8',
                                'system_mac_address': 'cc:2d:e0:be:6e:3b',
                                'uptime': '32108816'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '594',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '5518965534656',
                                                                       'in_ucast_pkts': '4193099844',
                                                                       'links': [       {       'in_discards': '594',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '5518965534656',
                                                                                                'in_ucast_pkts': '4193099844',
                                                                                                'mac_address': '04:d6:aa:b1:18:fc',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '252507546159',
                                                                                                'out_ucast_pkts': '1784832687'}],
                                                                       'mac_address': '24:18:1d:99:63:9f',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '252507546159',
                                                                       'out_ucast_pkts': '1784832687',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 196,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:18:fc',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KP2-N60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '252507546159',
                                                                       'in_ucast_pkts': '1784832687',
                                                                       'name': 'ether1',
                                                                       'out_octets': '5518965534656',
                                                                       'out_ucast_pkts': '4193099844',
                                                                       'poller_hash': 'MjQxODFkOTk2MzlmZXRoZXIx'}],
                                         'poller_hash': 'JBgdmWOf',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '356',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '340944835792',
                                                                       'in_ucast_pkts': '539630935',
                                                                       'links': [       {       'in_discards': '356',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '340944835792',
                                                                                                'in_ucast_pkts': '539630935',
                                                                                                'mac_address': '04:d6:aa:b1:18:fc',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '20172019795',
                                                                                                'out_ucast_pkts': '334211018'}],
                                                                       'mac_address': '24:18:1d:63:65:83',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '20172019795',
                                                                       'out_ucast_pkts': '334211018',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 62640,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 54,
                                                                                                                                                     'mac_address': '04:d6:aa:b1:18:fc',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KP2-N60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '20172019795',
                                                                       'in_ucast_pkts': '334211018',
                                                                       'name': 'ether1',
                                                                       'out_octets': '340944835792',
                                                                       'out_ucast_pkts': '539630935',
                                                                       'poller_hash': 'MjQxODFkNjM2NTgzZXRoZXIx'}],
                                         'poller_hash': 'JBgdY2WD',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_8_02(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.8.02")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 60480,
                'sta_count': 5,
                'sw_version': '6.45.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 8372659498789,
                'dl_en_packets': 6252072691,
                'dl_noise_floor': None,
                'dl_rf_bytes': 8353553768768,
                'dl_rf_packets': 6765356862,
                'en_if_speed': 1000000000,
                'mem': 21.47979736328125,
                'serial_number': '81ED0809497C',
                'ssid': 'KP2-SE60G',
                'system_mac_address': 'cc:2d:e0:be:6c:95',
                'ul_en_bytes': 476326438753,
                'ul_en_packets': 2664974567,
                'ul_noise_floor': None,
                'ul_rf_bytes': 480858267751,
                'ul_rf_packets': 3173032218
        }
        exp_sta_stats = {
                '04:d6:aa:a4:c9:e1': {       'alt_macs': None,
                                             'dev_macs': {'cc:2d:e0:29:c1:fd'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a4:c9:e1',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67,
                                             'ul_snr': 50},
                '24:18:1d:57:ad:09': {       'alt_macs': None,
                                             'dev_macs': {'74:4d:28:bd:4a:60'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:57:ad:09',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -117.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -67,
                                             'ul_snr': 50},
                '24:18:1d:99:68:87': {       'alt_macs': None,
                                             'dev_macs': {'c4:ad:34:f9:8d:82'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '24:18:1d:99:68:87',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -150.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -55,
                                             'ul_snr': 95},
                '48:8f:5a:51:ec:78': {       'alt_macs': None,
                                             'dev_macs': {       '24:18:1d:22:a3:b3',
                                                                 '48:8f:5a:93:cf:60'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '48:8f:5a:51:ec:78',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -148.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -53,
                                             'ul_snr': 95},
                '48:8f:5a:80:66:f9': {       'alt_macs': {'48:8f:5a:80:66:f8'},
                                             'dev_macs': {'48:8f:5a:93:ac:d8'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '48:8f:5a:80:66:f9',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -130.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -65,
                                             'ul_snr': 65}
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '480858267751',
                                                              'in_ucast_pkts': '3173032218',
                                                              'in_unknown_protos': '0',
                                                              'links': [       {       'bridged_mac_addresses': [       '24:18:1d:22:a3:b3',
                                                                                                                        '48:8f:5a:93:cf:60'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '5730360729',
                                                                                       'in_ucast_pkts': '85456230',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '48:8f:5a:51:ec:78',
                                                                                       'out_discards': '141',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '48390924174',
                                                                                       'out_ucast_pkts': '107079743'},
                                                                               {       'bridged_mac_addresses': [       '48:8f:5a:93:ac:d8'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '36689932844',
                                                                                       'in_ucast_pkts': '128005007',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '48:8f:5a:80:66:f9',
                                                                                       'out_discards': '152',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '95009579449',
                                                                                       'out_ucast_pkts': '155958902'},
                                                                               {       'bridged_mac_addresses': [       '74:4d:28:bd:4a:60'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '101063558345',
                                                                                       'in_ucast_pkts': '624216678',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:57:ad:09',
                                                                                       'out_discards': '400',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '782031045261',
                                                                                       'out_ucast_pkts': '928230880'},
                                                                               {       'bridged_mac_addresses': [       'cc:2d:e0:29:c1:fd'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '9663258105',
                                                                                       'in_ucast_pkts': '204370703',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '04:d6:aa:a4:c9:e1',
                                                                                       'out_discards': '598',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '75721651892',
                                                                                       'out_ucast_pkts': '235971803'},
                                                                               {       'bridged_mac_addresses': [       'c4:ad:34:f9:8d:82'],
                                                                                       'in_discards': '0',
                                                                                       'in_errors': '0',
                                                                                       'in_nucast_pkts': '0',
                                                                                       'in_octets': '233524379112',
                                                                                       'in_ucast_pkts': '1510214192',
                                                                                       'in_unknown_protos': '0',
                                                                                       'mac_address': '24:18:1d:99:68:87',
                                                                                       'out_discards': '245',
                                                                                       'out_errors': '0',
                                                                                       'out_nucast_pkts': '0',
                                                                                       'out_octets': '5411502469619',
                                                                                       'out_ucast_pkts': '3907237177'}],
                                                              'mac_address': '24:18:1d:22:a3:b3',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '2506',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '8353553768768',
                                                              'out_ucast_pkts': '6765356862',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 60480,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1',
                                                                                                                   'links': [       {       'distance': 42,
                                                                                                                                            'mac_address': '48:8f:5a:51:ec:78',
                                                                                                                                            'noise_floor': -148.0,
                                                                                                                                            'rssi': -53.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 255,
                                                                                                                                            'mac_address': '48:8f:5a:80:66:f9',
                                                                                                                                            'noise_floor': -130.0,
                                                                                                                                            'rssi': -65.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 65.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 85,
                                                                                                                                            'mac_address': '24:18:1d:57:ad:09',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 271,
                                                                                                                                            'mac_address': '04:d6:aa:a4:c9:e1',
                                                                                                                                            'noise_floor': -117.0,
                                                                                                                                            'rssi': -67.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 50.0,
                                                                                                                                            'tx_link_rate': '2310000000'},
                                                                                                                                    {       'distance': 113,
                                                                                                                                            'mac_address': '24:18:1d:99:68:87',
                                                                                                                                            'noise_floor': -150.0,
                                                                                                                                            'rssi': -55.0,
                                                                                                                                            'rx_mcs': 8,
                                                                                                                                            'snr': 95.0,
                                                                                                                                            'tx_link_rate': '2310000000'}],
                                                                                                                   'noise_floor': -117.0}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'KP2-SE60G'}],
                                                              'speed': '2310000000',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '46112326',
                                                              'in_octets': '8372659498789',
                                                              'in_ucast_pkts': '6205960365',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:be:6c:95',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '42187347',
                                                              'out_octets': '476326438753',
                                                              'out_ucast_pkts': '2622787220',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 21.479797,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'JBgdIqOz',
                                'serial_number': '81ED0809497C',
                                'sw_version': '6.45.8',
                                'system_mac_address': 'cc:2d:e0:be:6c:95',
                                'uptime': '32109443'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '141',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '48390924174',
                                                                       'in_ucast_pkts': '107079743',
                                                                       'links': [       {       'in_discards': '141',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '48390924174',
                                                                                                'in_ucast_pkts': '107079743',
                                                                                                'mac_address': '24:18:1d:22:a3:b3',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '5730360729',
                                                                                                'out_ucast_pkts': '85456230'}],
                                                                       'mac_address': '48:8f:5a:51:ec:78',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '5730360729',
                                                                       'out_ucast_pkts': '85456230',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 42,
                                                                                                                                                     'mac_address': '24:18:1d:22:a3:b3',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KP2-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '5730360729',
                                                                       'in_ucast_pkts': '85456230',
                                                                       'name': 'ether1',
                                                                       'out_octets': '48390924174',
                                                                       'out_ucast_pkts': '107079743',
                                                                       'poller_hash': 'NDg4ZjVhNTFlYzc4ZXRoZXIx'}],
                                         'poller_hash': 'SI9aUex4',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '152',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '95009579449',
                                                                       'in_ucast_pkts': '155958902',
                                                                       'links': [       {       'in_discards': '152',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '95009579449',
                                                                                                'in_ucast_pkts': '155958902',
                                                                                                'mac_address': '24:18:1d:22:a3:b3',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '36689932844',
                                                                                                'out_ucast_pkts': '128005007'}],
                                                                       'mac_address': '48:8f:5a:80:66:f9',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '36689932844',
                                                                       'out_ucast_pkts': '128005007',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 255,
                                                                                                                                                     'mac_address': '24:18:1d:22:a3:b3',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KP2-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '36689932844',
                                                                       'in_ucast_pkts': '128005007',
                                                                       'mac_address': '48:8f:5a:80:66:f8',
                                                                       'name': 'ether1',
                                                                       'out_octets': '95009579449',
                                                                       'out_ucast_pkts': '155958902',
                                                                       'poller_hash': 'NDg4ZjVhODA2NmY5ZXRoZXIx'}],
                                         'poller_hash': 'SI9agGb5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'system_mac_address': '48:8f:5a:80:66:f8'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '400',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '782031045261',
                                                                       'in_ucast_pkts': '928230880',
                                                                       'links': [       {       'in_discards': '400',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '782031045261',
                                                                                                'in_ucast_pkts': '928230880',
                                                                                                'mac_address': '24:18:1d:22:a3:b3',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '101063558345',
                                                                                                'out_ucast_pkts': '624216678'}],
                                                                       'mac_address': '24:18:1d:57:ad:09',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '101063558345',
                                                                       'out_ucast_pkts': '624216678',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 85,
                                                                                                                                                     'mac_address': '24:18:1d:22:a3:b3',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KP2-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '101063558345',
                                                                       'in_ucast_pkts': '624216678',
                                                                       'name': 'ether1',
                                                                       'out_octets': '782031045261',
                                                                       'out_ucast_pkts': '928230880',
                                                                       'poller_hash': 'MjQxODFkNTdhZDA5ZXRoZXIx'}],
                                         'poller_hash': 'JBgdV60J',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '598',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '75721651892',
                                                                       'in_ucast_pkts': '235971803',
                                                                       'links': [       {       'in_discards': '598',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '75721651892',
                                                                                                'in_ucast_pkts': '235971803',
                                                                                                'mac_address': '24:18:1d:22:a3:b3',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '9663258105',
                                                                                                'out_ucast_pkts': '204370703'}],
                                                                       'mac_address': '04:d6:aa:a4:c9:e1',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '9663258105',
                                                                       'out_ucast_pkts': '204370703',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 271,
                                                                                                                                                     'mac_address': '24:18:1d:22:a3:b3',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KP2-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '9663258105',
                                                                       'in_ucast_pkts': '204370703',
                                                                       'name': 'ether1',
                                                                       'out_octets': '75721651892',
                                                                       'out_ucast_pkts': '235971803',
                                                                       'poller_hash': 'MDRkNmFhYTRjOWUxZXRoZXIx'}],
                                         'poller_hash': 'BNaqpMnh',
                                         'status': 'ELEMENT_STATUS_ONLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1',
                                                                       'in_discards': '245',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '5411502469619',
                                                                       'in_ucast_pkts': '3907237177',
                                                                       'links': [       {       'in_discards': '245',
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '5411502469619',
                                                                                                'in_ucast_pkts': '3907237177',
                                                                                                'mac_address': '24:18:1d:22:a3:b3',
                                                                                                'out_discards': '0',
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '233524379112',
                                                                                                'out_ucast_pkts': '1510214192'}],
                                                                       'mac_address': '24:18:1d:99:68:87',
                                                                       'name': 'wlan60-1',
                                                                       'oper_up': True,
                                                                       'out_discards': '0',
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '233524379112',
                                                                       'out_ucast_pkts': '1510214192',
                                                                       'radios': [       {       'chan_width': 2160,
                                                                                                 'framing': 'FLEXIBLE',
                                                                                                 'frequency': 60480,
                                                                                                 'id': '1',
                                                                                                 'streams': [       {       'id': '1',
                                                                                                                            'links': [       {       'distance': 113,
                                                                                                                                                     'mac_address': '24:18:1d:22:a3:b3',
                                                                                                                                                     'rx_link_rate': '2310000000'}]}]}],
                                                                       'sectors': [       {       'mode': 'STA',
                                                                                                  'ssid': 'KP2-SE60G'}]},
                                                               {       'id': '2',
                                                                       'in_octets': '233524379112',
                                                                       'in_ucast_pkts': '1510214192',
                                                                       'name': 'ether1',
                                                                       'out_octets': '5411502469619',
                                                                       'out_ucast_pkts': '3907237177',
                                                                       'poller_hash': 'MjQxODFkOTk2ODg3ZXRoZXIx'}],
                                         'poller_hash': 'JBgdmWiH',
                                         'status': 'ELEMENT_STATUS_ONLINE'}]
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_8_03(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.8.03")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 58320,
                'sta_count': 0,
                'sw_version': '6.45.8',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 13495933222,
                'dl_en_packets': 231335299,
                'dl_noise_floor': None,
                'dl_rf_bytes': 0,
                'dl_rf_packets': 0,
                'en_if_speed': 1000000000,
                'mem': 20.0927734375,
                'serial_number': '8AA5084EB9AC',
                'ssid': 'KP2-SW60G',
                'system_mac_address': 'cc:2d:e0:bc:30:e7',
                'ul_en_bytes': 7426289078,
                'ul_en_packets': 59663192,
                'ul_noise_floor': None,
                'ul_rf_bytes': 0,
                'ul_rf_packets': 0
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'cpu': 0.0,
                                'interfaces': [       {       'admin_up': True,
                                                              'id': '1',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': '24:18:1d:25:97:9a',
                                                              'mtu': 1500,
                                                              'name': 'wlan60-1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '0',
                                                              'out_octets': '0',
                                                              'out_ucast_pkts': '0',
                                                              'radios': [       {       'chan_width': 2160,
                                                                                        'framing': 'FLEXIBLE',
                                                                                        'frequency': 58320,
                                                                                        'id': '1',
                                                                                        'streams': [       {       'id': '1'}]}],
                                                              'sectors': [       {       'mode': 'AP',
                                                                                         'ssid': 'KP2-SW60G'}],
                                                              'speed': '0',
                                                              'type': 71},
                                                      {       'admin_up': True,
                                                              'id': '2',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_nucast_pkts': '86692046',
                                                              'in_octets': '13495933222',
                                                              'in_ucast_pkts': '144643253',
                                                              'in_unknown_protos': '0',
                                                              'mac_address': 'cc:2d:e0:bc:30:e7',
                                                              'mtu': 1500,
                                                              'name': 'ether1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_nucast_pkts': '1605478',
                                                              'out_octets': '7426289078',
                                                              'out_ucast_pkts': '58057714',
                                                              'speed': '1000000000',
                                                              'type': 6}],
                                'manufacturer': 'Mikrotik',
                                'mem': 20.092773,
                                'model': 'RBwAPG-60ad-A',
                                'poller_hash': 'JBgdJZea',
                                'serial_number': '8AA5084EB9AC',
                                'sw_version': '6.45.8',
                                'system_mac_address': 'cc:2d:e0:bc:30:e7',
                                'uptime': '32108920'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_mikrotik_mikrotik_60g_RBwAPG_60ad_A_6_45_9_01(self):
        obj = self.run_data("mikrotik.mikrotik-60g.RBwAPG-60ad-A.6.45.9.01")
        exp_info = {
                'model': 'RBwAPG-60ad-A',
                'rf_chan_width': 2160,
                'rf_freq': 60480,
                'sta_count': 8,
                'sw_version': '6.45.9',
                'vendor': 'Mikrotik'
        }
        exp_stats = {
                'cpu': 0,
                'dl_en_bytes': 6246558244914,
                'dl_en_packets': 5006800272,
                'dl_noise_floor': None,
                'dl_rf_bytes': 6254944947260,
                'dl_rf_packets': 5993983547,
                'en_if_speed': 1000000000,
                'mem': 21.20361328125,
                'serial_number': 'BF950BE4682C',
                'ssid': 'TN1-NW60G',
                'system_mac_address': 'c4:ad:34:7c:d3:a4',
                'ul_en_bytes': 1028818681239,
                'ul_en_packets': 2917569438,
                'ul_noise_floor': None,
                'ul_rf_bytes': 1057224292449,
                'ul_rf_packets': 3840577788
        }
        exp_sta_stats = {
                '04:d6:aa:a4:cb:f8': {       'alt_macs': None,
                                             'dev_macs': {'cc:2d:e0:a4:00:14'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a4:cb:f8',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -148.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -58,
                                             'ul_snr': 90},
                '04:d6:aa:a8:d5:6d': {       'alt_macs': None,
                                             'dev_macs': {       'c4:ad:34:7c:d3:a5',
                                                                 'cc:2d:e0:20:20:17'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl_snr': None,
                                             'ip_address': None,
                                             'mac_address': '04:d6:aa:a8:d5:6d',
                                             'name': None,
                                             'serial_number': None,
                                             'ssid': None,
                                             'system_mac_address': None,
                                             'ul_link_rate': None,
                                             'ul_mcs': 8,
                                             'ul_noise_floor': -148.0,
                                             'ul_rf_bytes': None,
                                             'ul_rf_packets': None,
                                             'ul_rssi': -53,
                                             'ul_snr': 95},
                '04:d6:aa:a8:d5:ed': {       'alt_macs': None,
                                             'dev_macs': {       '74:4d:28:bd:44:69',
                                                                 'b8:69:f4:33:21:79'},
                                             'dl_link_rate': 2310000000,
                                             'dl_mcs': None,
                                             'dl_noise_floor': None,
                                             'dl_rf_bytes': None,
                                             'dl_rf_packets': None,
                                             'dl_rssi': None,
                                             'dl