import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):

    def test_calix_exa_E7_2_EXA_3_4_30_40_01(self):
        obj = self.run_data("calix.exa.E7-2 (EXA).3.4.30.40.01")
        exp_info = {
                'model': 'E7-2 (EXA)',
                'sta_count': 365,
                'sw_version': '3.4.30.40',
                'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '71702970268', 'system_mac_address': None
        }
        exp_sta_stats = {
                None: {       'dev_macs': [],
                              'ip_address': None,
                              'mac_address': None,
                              'name': '7335 ROAD 164',
                              'serial_number': '3FFAB9',
                              'system_mac_address': None},
                '00:06:31:06:38:37': {       'dev_macs': ['78:da:6e:46:5e:e7'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:06:38:37',
                                             'name': 'ont 185',
                                             'serial_number': '7FF5',
                                             'system_mac_address': None},
                '00:06:31:08:4a:08': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4a:08',
                                             'name': '93 Elma Centre',
                                             'serial_number': 'F0F8',
                                             'system_mac_address': None},
                '00:06:31:08:4a:56': {       'dev_macs': ['c0:c9:e3:ab:9a:c5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4a:56',
                                             'name': '140 Monument Rd',
                                             'serial_number': 'F1F8',
                                             'system_mac_address': None},
                '00:06:31:08:4b:82': {       'dev_macs': ['34:98:b5:6d:56:26'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4b:82',
                                             'name': '157 Main St. Atwood',
                                             'serial_number': 'F23A',
                                             'system_mac_address': None},
                '00:06:31:08:4c:8d': {       'dev_macs': ['ac:15:a2:4e:e8:e5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4c:8d',
                                             'name': '108 Blair St. Atwood',
                                             'serial_number': 'F23C',
                                             'system_mac_address': None},
                '00:06:31:08:de:8d': {       'dev_macs': ['e4:6f:13:45:27:eb'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:de:8d',
                                             'name': '281 Main St, Atwood',
                                             'serial_number': '153C3',
                                             'system_mac_address': None},
                '00:06:31:08:e2:95': {       'dev_macs': ['04:42:1a:10:3c:70'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:e2:95',
                                             'name': '7319 ROAD 164',
                                             'serial_number': '15452',
                                             'system_mac_address': None},
                '00:06:31:08:e2:e6': {       'dev_macs': ['b0:be:76:94:41:25'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:e2:e6',
                                             'name': '231 Main St. Atwood',
                                             'serial_number': '1545D',
                                             'system_mac_address': None},
                '00:06:31:11:f0:4e': {       'dev_macs': ['10:be:f5:d3:4f:4b'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f0:4e',
                                             'name': '210B Main St. Atwood',
                                             'serial_number': '1303D',
                                             'system_mac_address': None},
                '00:06:31:11:f6:cc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f6:cc',
                                             'name': '185 Main St. Atwood',
                                             'serial_number': '13538',
                                             'system_mac_address': None},
                '00:06:31:11:f7:7d': {       'dev_macs': ['c0:8c:60:0f:dd:00'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f7:7d',
                                             'name': '218A Main St. Atwood',
                                             'serial_number': '13548',
                                             'system_mac_address': None},
                '00:06:31:15:a1:e0': {       'dev_macs': ['14:59:c0:b8:c4:11'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a1:e0',
                                             'name': '171 Main St. Atwood',
                                             'serial_number': '3CC08',
                                             'system_mac_address': None},
                '00:06:31:15:a8:61': {       'dev_macs': [       '00:23:69:a6:8c:09',
                                                                 '00:03:e6:5e:77:76',
                                                                 '00:03:e6:5e:77:e6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a8:61',
                                             'name': '138 King St. Atwood',
                                             'serial_number': '3CFA8',
                                             'system_mac_address': None},
                '00:06:31:15:a8:b0': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a8:b0',
                                             'name': '93 Arthur St. Atwood',
                                             'serial_number': '3CFA6',
                                             'system_mac_address': None},
                '00:06:31:15:a9:1e': {       'dev_macs': ['c8:d3:a3:5c:39:af'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:1e',
                                             'name': '127 Main St. Atwood',
                                             'serial_number': '3CF4A',
                                             'system_mac_address': None},
                '00:06:31:15:a9:2d': {       'dev_macs': [       '04:7c:16:e8:46:88',
                                                                 '00:03:e6:9b:3d:64'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:2d',
                                             'name': '151 Queen St. Atwood',
                                             'serial_number': '3D0FA',
                                             'system_mac_address': None},
                '00:06:31:15:a9:32': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:32',
                                             'name': '7434 ROAD 164',
                                             'serial_number': '3D0FC',
                                             'system_mac_address': None},
                '00:06:31:15:a9:37': {       'dev_macs': ['10:62:eb:9b:c8:3b'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:37',
                                             'name': '7418 Rd. 164 Atwood',
                                             'serial_number': '3D0F2',
                                             'system_mac_address': None},
                '00:06:31:15:a9:46': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:46',
                                             'name': '7272 Rd. 164 Atwood',
                                             'serial_number': '3D0F4',
                                             'system_mac_address': None},
                '00:06:31:15:a9:64': {       'dev_macs': ['28:87:ba:bd:b8:55'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:64',
                                             'name': '7480 Rd. 164 Atwood',
                                             'serial_number': '3D0EF',
                                             'system_mac_address': None},
                '00:06:31:18:c1:01': {       'dev_macs': ['70:3a:cb:43:d6:35'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c1:01',
                                             'name': '184 Main St. Atwood',
                                             'serial_number': '3CF4E',
                                             'system_mac_address': None},
                '00:06:31:18:c1:ce': {       'dev_macs': [       '24:4b:fe:0a:f8:e8',
                                                                 '00:03:e6:31:45:e6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c1:ce',
                                             'name': '136 King St. Atwood',
                                             'serial_number': '3CF9D',
                                             'system_mac_address': None},
                '00:06:31:18:c2:fa': {       'dev_macs': ['c8:78:7d:ea:2b:3e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c2:fa',
                                             'name': '90 Baker St. Atwood',
                                             'serial_number': '3CFAA',
                                             'system_mac_address': None},
                '00:06:31:18:c2:ff': {       'dev_macs': ['c0:06:c3:07:a6:a9'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c2:ff',
                                             'name': '236 Main St. Atwood',
                                             'serial_number': '3CFA0',
                                             'system_mac_address': None},
                '00:06:31:1e:52:10': {       'dev_macs': [       '98:fc:11:45:a0:e9',
                                                                 '00:03:e6:30:ec:d0',
                                                                 '00:03:e6:60:30:f8'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1e:52:10',
                                             'name': '7428 Road 164',
                                             'serial_number': '3D0E9',
                                             'system_mac_address': None},
                '00:06:31:1e:56:75': {       'dev_macs': ['94:56:41:2b:48:10'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1e:56:75',
                                             'name': '7412 Rd. 164 Atwood',
                                             'serial_number': '3D0F6',
                                             'system_mac_address': None},
                '00:06:31:1f:06:f6': {       'dev_macs': ['c8:d7:19:8a:7d:58'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:06:f6',
                                             'name': '219 Queen St. Atwood',
                                             'serial_number': '41542',
                                             'system_mac_address': None},
                '00:06:31:1f:07:23': {       'dev_macs': ['c0:a0:bb:c6:c7:67'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:23',
                                             'name': '7470 Rd. 164 Atwood',
                                             'serial_number': '41522',
                                             'system_mac_address': None},
                '00:06:31:1f:07:55': {       'dev_macs': ['c8:d3:a3:66:49:00'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:55',
                                             'name': '171 Monument Rd. Atwood',
                                             'serial_number': '41530',
                                             'system_mac_address': None},
                '00:06:31:1f:07:82': {       'dev_macs': ['f0:2f:74:7a:d2:d0'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:82',
                                             'name': '7333 Road 164',
                                             'serial_number': '41585',
                                             'system_mac_address': None},
                '00:06:31:1f:08:4f': {       'dev_macs': ['78:98:e8:4a:f8:3a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:08:4f',
                                             'name': '130 Monument Road',
                                             'serial_number': '41591',
                                             'system_mac_address': None},
                '00:06:31:1f:08:d6': {       'dev_macs': ['00:03:e6:a5:6b:b8'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:08:d6',
                                             'name': '243 Main St. Atwood',
                                             'serial_number': '41549',
                                             'system_mac_address': None},
                '00:06:31:20:00:37': {       'dev_macs': ['b8:38:61:b6:0b:fa'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:37',
                                             'name': '246 Queen St. Atwood',
                                             'serial_number': '4157E',
                                             'system_mac_address': None},
                '00:06:31:20:00:64': {       'dev_macs': [       '34:97:f6:a7:2c:b8',
                                                                 '00:03:e6:5e:94:fa',
                                                                 '00:03:e6:5e:9f:1e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:64',
                                             'name': '139 Queen St. Atwood',
                                             'serial_number': '41535',
                                             'system_mac_address': None},
                '00:06:31:20:00:69': {       'dev_macs': ['24:4b:fe:ad:ce:00'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:69',
                                             'name': '129 Main St. Atwood',
                                             'serial_number': '415B0',
                                             'system_mac_address': None},
                '00:06:31:20:01:45': {       'dev_macs': [       '00:1a:79:45:5f:4d',
                                                                 '00:1a:79:6c:0b:24',
                                                                 '08:bf:b8:b5:1f:f8'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:45',
                                             'name': '247 Queen St. Atwood',
                                             'serial_number': '415AB',
                                             'system_mac_address': None},
                '00:06:31:20:01:5e': {       'dev_macs': [       '60:38:e0:72:6a:53',
                                                                 '00:03:e6:65:05:e4',
                                                                 '00:03:e6:6b:b6:8c'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:5e',
                                             'name': '7475 Rd. 164 Atwood',
                                             'serial_number': '4153F',
                                             'system_mac_address': None},
                '00:06:31:20:01:6d': {       'dev_macs': [       '00:97:f6:d0:2f:0a',
                                                                 '00:03:e6:5e:77:f0',
                                                                 '00:03:e6:5e:78:56'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:6d',
                                             'name': '218 King St. Atwood',
                                             'serial_number': '418B8',
                                             'system_mac_address': None},
                '00:06:31:20:01:81': {       'dev_macs': ['00:5f:67:a4:74:95'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:81',
                                             'name': '190 KING STREET ATWOOD',
                                             'serial_number': '418B7',
                                             'system_mac_address': None},
                '00:06:31:20:01:b8': {       'dev_macs': ['d0:17:c2:5a:01:48'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:b8',
                                             'name': '220 Queen St.',
                                             'serial_number': '4152F',
                                             'system_mac_address': None},
                '00:06:31:20:02:3a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:3a',
                                             'name': '215 KING STREET ATWOOD',
                                             'serial_number': '4153C',
                                             'system_mac_address': None},
                '00:06:31:20:02:5d': {       'dev_macs': ['0c:0e:76:e9:25:1a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:5d',
                                             'name': '128 King St. Atwood',
                                             'serial_number': '415FE',
                                             'system_mac_address': None},
                '00:06:31:20:03:2a': {       'dev_macs': ['64:29:43:08:35:6c'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:03:2a',
                                             'name': '169 Main St. Atwood',
                                             'serial_number': '418AC',
                                             'system_mac_address': None},
                '00:06:31:20:03:61': {       'dev_macs': [       'c8:7f:54:23:67:38',
                                                                 '00:03:e6:31:1a:2c',
                                                                 '00:03:e6:5f:26:90'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:03:61',
                                             'name': '252 Main St. Atwood',
                                             'serial_number': '418B5',
                                             'system_mac_address': None},
                '00:06:31:20:a1:a2': {       'dev_macs': [       '48:77:46:9a:61:95',
                                                                 '00:03:e6:db:52:24',
                                                                 '60:db:98:09:3a:86',
                                                                 'b8:94:70:f3:e0:78',
                                                                 '0c:0e:76:4a:a6:ad',
                                                                 '40:9b:cd:2c:e9:b3'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:a1:a2',
                                             'name': '7429 ROAD 164',
                                             'serial_number': '49340',
                                             'system_mac_address': None},
                '00:06:31:34:38:18': {       'dev_macs': ['c4:e9:0a:4e:e9:d4'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:18',
                                             'name': '87 Baker St. Atwood',
                                             'serial_number': '757AC',
                                             'system_mac_address': None},
                '00:06:31:34:38:27': {       'dev_macs': ['28:87:ba:bd:a2:69'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:27',
                                             'name': '153 Queen St. Atwood',
                                             'serial_number': '757BB',
                                             'system_mac_address': None},
                '00:06:31:34:38:28': {       'dev_macs': ['0c:b6:d2:50:99:de'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:28',
                                             'name': '167 Fisher Ave',
                                             'serial_number': '757BC',
                                             'system_mac_address': None},
                '00:06:31:3c:5f:10': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:5f:10',
                                             'name': '192 WOODVIEW ATWOOD',
                                             'serial_number': '7FE2A',
                                             'system_mac_address': None},
                '00:06:31:3c:5f:6a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:5f:6a',
                                             'name': '133 Bowman Ct',
                                             'serial_number': '7FE84',
                                             'system_mac_address': None},
                '00:06:31:3c:cc:73': {       'dev_macs': ['48:f8:b3:8f:00:da'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:cc:73',
                                             'name': '142 JOHN STREET ATWOOD',
                                             'serial_number': '86B8B',
                                             'system_mac_address': None},
                '00:06:31:3c:cc:a6': {       'dev_macs': ['18:a6:f7:e2:9e:f3'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:cc:a6',
                                             'name': '137 King St. Atwood',
                                             'serial_number': '86BBE',
                                             'system_mac_address': None},
                '00:06:31:3c:d5:37': {       'dev_macs': ['60:45:cb:66:ac:68'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:d5:37',
                                             'name': '169 Fisher Ave. Atwood',
                                             'serial_number': '8744F',
                                             'system_mac_address': None},
                '00:06:31:3c:ea:9c': {       'dev_macs': ['ec:4f:82:a4:90:bc'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:ea:9c',
                                             'name': '7462 ROAD 164',
                                             'serial_number': '889B4',
                                             'system_mac_address': None},
                '00:06:31:47:4b:6c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:47:4b:6c',
                                             'name': '278 QUEEN STREET ATWOOD',
                                             'serial_number': '8A280',
                                             'system_mac_address': None},
                '00:06:31:57:b0:79': {       'dev_macs': ['e0:46:ee:35:a4:40'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:57:b0:79',
                                             'name': '247 Woodview Dr. Atwood',
                                             'serial_number': 'A9FB9',
                                             'system_mac_address': None},
                '00:06:31:5f:60:b4': {       'dev_macs': [       'ec:4f:82:ac:eb:ec',
                                                                 '00:03:e6:a2:15:b8',
                                                                 '00:03:e6:a4:ce:27'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:60:b4',
                                             'name': '250 Woodview Atwood',
                                             'serial_number': 'C4FF4',
                                             'system_mac_address': None},
                '00:06:31:5f:60:d0': {       'dev_macs': ['a8:63:7d:4e:f7:4c'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:60:d0',
                                             'name': '128 James St. Atwood',
                                             'serial_number': 'C5010',
                                             'system_mac_address': None},
                '00:06:31:5f:68:8d': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:68:8d',
                                             'name': '136 Main St. Atwood',
                                             'serial_number': 'C57CD',
                                             'system_mac_address': None},
                '00:06:31:5f:69:10': {       'dev_macs': ['d0:76:8f:02:f3:7a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:69:10',
                                             'name': '194 Main St. Atwood (Upper)',
                                             'serial_number': 'C5850',
                                             'system_mac_address': None},
                '00:06:31:5f:69:2b': {       'dev_macs': ['84:d3:43:6d:ec:45'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:69:2b',
                                             'name': '176 Main St. Atwood',
                                             'serial_number': 'C586B',
                                             'system_mac_address': None},
                '00:06:31:5f:d1:76': {       'dev_macs': ['a0:36:bc:15:e3:08'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:d1:76',
                                             'name': '225 Queen St',
                                             'serial_number': 'CC0B6',
                                             'system_mac_address': None},
                '00:06:31:6f:c4:65': {       'dev_macs': ['c8:e3:06:44:27:20'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:6f:c4:65',
                                             'name': '211 King St. Atwood',
                                             'serial_number': 'F23A5',
                                             'system_mac_address': None},
                '00:06:31:90:39:05': {       'dev_macs': ['cc:be:59:2d:a9:3a'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:39:05',
                                             'name': '207 KING STREET ATWOOD',
                                             'serial_number': '124845',
                                             'system_mac_address': None},
                '00:06:31:90:f0:9d': {       'dev_macs': ['ec:4f:82:2d:78:46'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f0:9d',
                                             'name': '152 Queen St. Atwood',
                                             'serial_number': '12FFDD',
                                             'system_mac_address': None},
                '00:06:31:90:f0:ae': {       'dev_macs': ['28:87:ba:87:1b:b3'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f0:ae',
                                             'name': '134 BOWMAN CT',
                                             'serial_number': '12FFEE',
                                             'system_mac_address': None},
                '00:06:31:90:f1:1f': {       'dev_macs': [       'd0:76:8f:91:11:92',
                                                                 '00:03:e6:db:4d:b3'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:1f',
                                             'name': '101 PARKVIEW CR',
                                             'serial_number': '13005F',
                                             'system_mac_address': None},
                '00:06:31:90:f1:4b': {       'dev_macs': ['84:d3:43:0f:62:41'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:4b',
                                             'name': '184 King St. Atwood',
                                             'serial_number': '13008B',
                                             'system_mac_address': None},
                '00:06:31:90:f1:4d': {       'dev_macs': [       '04:92:26:66:10:dc',
                                                                 '28:87:ba:bd:b9:21',
                                                                 '3c:37:86:90:9f:42'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:4d',
                                             'name': '170 John St. Atwood',
                                             'serial_number': '13008D',
                                             'system_mac_address': None},
                '00:06:31:90:f1:5a': {       'dev_macs': ['00:5f:67:f1:36:8b'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:5a',
                                             'name': '159 Main St. Atwood',
                                             'serial_number': '13009A',
                                             'system_mac_address': None},
                '00:06:31:b7:29:e8': {       'dev_macs': [       'bc:22:28:af:2f:0b',
                                                                 '6c:5a:b0:21:bd:b6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:29:e8',
                                             'name': '200B Main St. Atwood',
                                             'serial_number': '161021',
                                             'system_mac_address': None},
                '00:06:31:b7:5c:3e': {       'dev_macs': ['e4:c3:2a:85:66:41'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:5c:3e',
                                             'name': '201 Ellen St. Atwood',
                                             'serial_number': '164277',
                                             'system_mac_address': None},
                '00:06:31:b7:5c:48': {       'dev_macs': ['70:4f:57:be:53:1c'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:5c:48',
                                             'name': '136 Queen St. Atwood',
                                             'serial_number': '164281',
                                             'system_mac_address': None},
                '00:06:31:dd:56:87': {       'dev_macs': ['f8:e9:03:bb:4d:c5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:56:87',
                                             'name': '145 King St. Atwood',
                                             'serial_number': '175E66',
                                             'system_mac_address': None},
                '00:06:31:dd:56:bf': {       'dev_macs': ['d0:76:8f:91:d4:6f'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:56:bf',
                                             'name': '96 ARTHUR STREET EAST ATWOOD',
                                             'serial_number': '175E6D',
                                             'system_mac_address': None},
                '00:06:31:dd:73:d7': {       'dev_macs': ['d0:76:8f:91:d3:9e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:73:d7',
                                             'name': '209 QUEEN STREET ATWOOD',
                                             'serial_number': '176210',
                                             'system_mac_address': None},
                '00:06:31:e3:f9:63': {       'dev_macs': ['60:db:98:57:b5:0e'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:f9:63',
                                             'name': '123 Queen St. Atwood',
                                             'serial_number': '1999C5',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:43': {       'dev_macs': ['f8:1a:2b:04:bc:e1'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:43',
                                             'name': '141&143 John St. Atwood',
                                             'serial_number': '1999E1',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:53': {       'dev_macs': ['cc:be:59:2d:a8:fb'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:53',
                                             'name': '7422 Road 164',
                                             'serial_number': '1999E3',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:83': {       'dev_macs': ['14:91:82:c1:9e:b6'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:83',
                                             'name': '220B Main St. Atwood',
                                             'serial_number': '1999E9',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:eb': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:eb',
                                             'name': '168 John St. Atwood',
                                             'serial_number': '1999F6',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:f3': {       'dev_macs': ['0c:b6:d2:3f:42:f7'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:f3',
                                             'name': '209 King St. Atwood',
                                             'serial_number': '1999F7',
                                             'system_mac_address': None},
                '00:06:31:e3:fb:3b': {       'dev_macs': ['5c:e9:31:72:5c:41'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fb:3b',
                                             'name': '266 Main St. Atwood',
                                             'serial_number': '199A00',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:13': {       'dev_macs': [       '60:38:e0:12:de:ad',
                                                                 '00:03:e6:a2:74:84'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:13',
                                             'name': '203 Main St. Atwood',
                                             'serial_number': '199A1B',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:63': {       'dev_macs': ['44:65:7f:89:0f:54'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:63',
                                             'name': '190 Main St. Atwood',
                                             'serial_number': '199A25',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:a3': {       'dev_macs': ['c8:f7:50:64:96:52'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:a3',
                                             'name': '141 Arthur St. Atwood',
                                             'serial_number': '199A2D',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:c3': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:c3',
                                             'name': '7433 Road 164',
                                             'serial_number': '199A31',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:cb': {       'dev_macs': ['08:62:66:9b:79:ac'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:cb',
                                             'name': '132 FISHER AV',
                                             'serial_number': '199A32',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:eb': {       'dev_macs': ['60:db:98:08:f2:b9'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:eb',
                                             'name': '7442 Rd. 164 Atwood',
                                             'serial_number': '199A36',
                                             'system_mac_address': None},
                '00:06:31:e3:fd:03': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fd:03',
                                             'name': '177 Main St. Atwood',
                                             'serial_number': '199A39',
                                             'system_mac_address': None},
                '00:06:31:ff:48:34': {       'dev_macs': ['08:b4:b1:e6:44:f5'],
                                             'ip_address': None,
                                             'mac_address': '00:06:31:ff:48:34',
                                             'name': '163 Queen St. Atwood',
                                             'serial_number': '1C4DA9',
                                             'system_mac_address': None},
                '04:bc:9f:00:17:d9': {       'dev_macs': [       '04:a1:51:cd:4a:03',
                                                                 'd0:76:58:e0:09:76'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:00:17:d9',
                                             'name': '161 John St. Atwood',
                                             'serial_number': 'EBC2EE',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1a:89': {       'dev_macs': ['b8:94:70:f3:df:de'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1a:89',
                                             'name': '192 KING STREET ATWOOD',
                                             'serial_number': '12749D1',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1d:81': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1d:81',
                                             'name': '302 WOODVIEW DR ATWOOD',
                                             'serial_number': '1274A30',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1e:19': {       'dev_macs': ['b8:94:70:f3:e9:05'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1e:19',
                                             'name': '260 MAIN STREET ATWOOD',
                                             'serial_number': '1274A43',
                                             'system_mac_address': None},
                '04:bc:9f:5c:21:31': {       'dev_macs': [       '44:65:7f:88:46:a8',
                                                                 '00:03:e6:f9:fa:e6'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:21:31',
                                             'name': '183 KING STREET',
                                             'serial_number': '1274AA6',
                                             'system_mac_address': None},
                '04:bc:9f:5c:3f:a1': {       'dev_macs': [       'b8:94:70:f3:e8:13',
                                                                 '5c:0f:fb:37:46:30'],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:3f:a1',
                                             'name': '276 QUEEN STREET ATWOOD',
                                             'serial_number': '1274E74',
                                             'system_mac_address': None},
                '04:bc:9f:5c:52:99': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:52:99',
                                             'name': '185 ELLEN STREET',
                                             'serial_number': '12750D3',
                                             'system_mac_address': None},
                '04:bc:9f:5c:58:61': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:58:61',
                                             'name': '156 JAMES STREET ATWOOD',
                                             'serial_number': '127518C',
                                             'system_mac_address': None},
                '44:65:7f:33:20:d4': {       'dev_macs': ['c4:b3:01:da:29:df'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:20:d4',
                                             'name': '279 McCourt Pl Atwood',
                                             'serial_number': '640AE4',
                                             'system_mac_address': None},
                '44:65:7f:33:20:e8': {       'dev_macs': ['60:db:98:09:3c:d8'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:20:e8',
                                             'name': '270 MCCOURT PL',
                                             'serial_number': '640AED',
                                             'system_mac_address': None},
                '44:65:7f:33:21:6e': {       'dev_macs': ['44:65:7f:88:d1:23'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:21:6e',
                                             'name': '277 McCourt Pl Atwood',
                                             'serial_number': '640B2F',
                                             'system_mac_address': None},
                '44:65:7f:33:21:ae': {       'dev_macs': ['44:65:7f:89:0c:d5'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:21:ae',
                                             'name': '116B Monument Rd Atwood',
                                             'serial_number': '640B4F',
                                             'system_mac_address': None},
                '44:65:7f:7b:d3:fa': {       'dev_macs': ['d0:76:8f:02:ee:f7'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d3:fa',
                                             'name': '152 MAIN STREET ATWOOD',
                                             'serial_number': '5A6B99',
                                             'system_mac_address': None},
                '44:65:7f:7b:d6:2b': {       'dev_macs': ['a8:5e:45:da:7a:cc'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d6:2b',
                                             'name': '130 JAMES STREET ATWOOD',
                                             'serial_number': '5A6C54',
                                             'system_mac_address': None},
                '44:65:7f:7b:d6:e5': {       'dev_macs': ['d0:76:8f:02:f2:04'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d6:e5',
                                             'name': '182 QUEEN STREET ATWOOD',
                                             'serial_number': '5A6C92',
                                             'system_mac_address': None},
                '44:65:7f:7b:d7:15': {       'dev_macs': ['60:db:98:09:3a:02'],
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d7:15',
                                             'name': '278 MCCOURT PL',
                                             'serial_number': '5A6CA2',
                                             'system_mac_address': None},
                '48:77:46:07:b2:49': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:07:b2:49',
                                             'name': '242 Main St. Atwood',
                                             'serial_number': '6AC2C7',
                                             'system_mac_address': None},
                '48:77:46:08:95:89': {       'dev_macs': [       'cc:be:59:c3:46:af',
                                                                 '00:03:e6:db:51:ce',
                                                                 '00:03:e6:dd:43:e8'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:08:95:89',
                                             'name': '7416 Rd. 164 Atwood',
                                             'serial_number': '6DBC98',
                                             'system_mac_address': None},
                '48:77:46:3a:58:0a': {       'dev_macs': ['68:ff:7b:33:bb:d5'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:58:0a',
                                             'name': '166 Queen St. Atwood',
                                             'serial_number': '721D1C',
                                             'system_mac_address': None},
                '48:77:46:3a:71:12': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:71:12',
                                             'name': '7616 Rd 164 Atwood',
                                             'serial_number': '72203D',
                                             'system_mac_address': None},
                '48:77:46:3a:71:32': {       'dev_macs': ['44:65:7f:88:45:88'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:71:32',
                                             'name': '210 King St. Atwood',
                                             'serial_number': '722041',
                                             'system_mac_address': None},
                '48:77:46:3a:72:52': {       'dev_macs': ['ec:4f:82:2c:6f:95'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:72:52',
                                             'name': '133 Main St Atwood',
                                             'serial_number': '722065',
                                             'system_mac_address': None},
                '48:77:46:3a:7f:c2': {       'dev_macs': ['60:db:98:09:1e:ae'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:7f:c2',
                                             'name': '288 Woodview Dr. Atwood',
                                             'serial_number': '722213',
                                             'system_mac_address': None},
                '48:77:46:3b:21:9a': {       'dev_macs': ['ec:4f:82:2d:6c:25'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3b:21:9a',
                                             'name': '186 Queen St. Atwood',
                                             'serial_number': '72364E',
                                             'system_mac_address': None},
                '48:77:46:3b:3f:aa': {       'dev_macs': ['d0:76:8f:91:4f:93'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3b:3f:aa',
                                             'name': '84 PARKVIEW CR',
                                             'serial_number': '723A10',
                                             'system_mac_address': None},
                '48:77:46:8c:12:34': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:8c:12:34',
                                             'name': '197 Ellen St. Atwood',
                                             'serial_number': '76ACE8',
                                             'system_mac_address': None},
                '48:77:46:a2:1b:1c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a2:1b:1c',
                                             'name': '7482 Rd. 164 Atwood',
                                             'serial_number': '71A492',
                                             'system_mac_address': None},
                '48:77:46:a2:1d:64': {       'dev_macs': ['60:db:98:09:38:b8'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a2:1d:64',
                                             'name': '86 BAKER ST',
                                             'serial_number': '71A4DB',
                                             'system_mac_address': None},
                '48:77:46:a3:8d:b4': {       'dev_macs': ['60:db:98:09:37:2c'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:8d:b4',
                                             'name': '7474 Rd. 164 Atwood',
                                             'serial_number': '71D2E5',
                                             'system_mac_address': None},
                '48:77:46:a3:b6:dc': {       'dev_macs': ['c8:7f:54:b6:58:a8'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:b6:dc',
                                             'name': '197 Main St. Atwood',
                                             'serial_number': '71D80A',
                                             'system_mac_address': None},
                '48:77:46:a3:bb:44': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:bb:44',
                                             'name': '999-100-3053',
                                             'serial_number': '71D897',
                                             'system_mac_address': None},
                '48:77:46:a3:bb:8c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:bb:8c',
                                             'name': '216B Main St. Atwood',
                                             'serial_number': '71D8A0',
                                             'system_mac_address': None},
                '48:77:46:cd:52:5e': {       'dev_macs': [       '28:3b:82:35:8a:4d',
                                                                 '00:03:e6:60:41:58',
                                                                 '00:03:e6:6b:ba:d8',
                                                                 '00:03:e6:a5:6f:d8',
                                                                 '5c:0f:fb:14:37:76'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:cd:52:5e',
                                             'name': '5994 Line 77 Atwood',
                                             'serial_number': '76CFF8',
                                             'system_mac_address': None},
                '48:77:46:ce:1f:1e': {       'dev_macs': ['00:ad:24:60:e3:af'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:1f:1e',
                                             'name': '325 Main St. Atwood',
                                             'serial_number': '76E990',
                                             'system_mac_address': None},
                '48:77:46:ce:20:6e': {       'dev_macs': ['a0:ab:1b:81:fa:0b'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:20:6e',
                                             'name': '208 Queen St. Atwood',
                                             'serial_number': '76E9BA',
                                             'system_mac_address': None},
                '48:77:46:ce:63:7e': {       'dev_macs': ['bc:ae:c5:a5:70:8c'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:63:7e',
                                             'name': '131 Fisher Ave Atwood',
                                             'serial_number': '76F21C',
                                             'system_mac_address': None},
                '48:77:46:f8:75:8c': {       'dev_macs': ['74:b6:b6:a0:82:61'],
                                             'ip_address': None,
                                             'mac_address': '48:77:46:f8:75:8c',
                                             'name': '271 WOODVIEW DR',
                                             'serial_number': '82A55A',
                                             'system_mac_address': None},
                '60:db:98:4e:6b:64': {       'dev_macs': ['60:db:98:09:1d:43'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:6b:64',
                                             'name': '281 QUEEN STREET ATWOOD',
                                             'serial_number': 'A9C32C',
                                             'system_mac_address': None},
                '60:db:98:4e:8e:34': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:8e:34',
                                             'name': '151 MAIN STREET ATWOOD',
                                             'serial_number': 'A9C786',
                                             'system_mac_address': None},
                '60:db:98:4e:90:0c': {       'dev_macs': ['60:db:98:55:b5:57'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:90:0c',
                                             'name': '277 QUEEN STREET ATWOOD',
                                             'serial_number': 'A9C7C1',
                                             'system_mac_address': None},
                '60:db:98:4e:96:cc': {       'dev_macs': ['60:db:98:55:b7:7d'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:96:cc',
                                             'name': '140 MAIN STREET ATWOOD',
                                             'serial_number': 'A9C899',
                                             'system_mac_address': None},
                '60:db:98:4e:99:cc': {       'dev_macs': ['18:e7:28:04:0d:84'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:99:cc',
                                             'name': '269 Main St. Atwood',
                                             'serial_number': 'A9C8F9',
                                             'system_mac_address': None},
                '60:db:98:4e:9b:8c': {       'dev_macs': [       '84:d3:43:0f:bb:5f',
                                                                 '5c:0f:fb:17:69:f0',
                                                                 '5c:0f:fb:17:6d:b7',
                                                                 '5c:0f:fb:17:6e:7b',
                                                                 '5c:0f:fb:17:6f:60'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:9b:8c',
                                             'name': '150 KING STREET ATWOOD',
                                             'serial_number': 'A9C931',
                                             'system_mac_address': None},
                '60:db:98:73:9c:74': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:73:9c:74',
                                             'name': '150 MAIN STREET ATWOOD',
                                             'serial_number': 'B0A2A0',
                                             'system_mac_address': None},
                '60:db:98:8e:fe:5a': {       'dev_macs': ['b8:94:70:9e:ce:59'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:fe:5a',
                                             'name': '158 Main St. Atwood',
                                             'serial_number': 'B510E2',
                                             'system_mac_address': None},
                '60:db:98:8e:ff:a7': {       'dev_macs': ['60:db:98:81:fc:1a'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:ff:a7',
                                             'name': '232 WOODVIEW DR',
                                             'serial_number': 'B51151',
                                             'system_mac_address': None},
                '60:db:98:8f:01:6f': {       'dev_macs': ['60:db:98:09:3b:d0'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:01:6f',
                                             'name': '271 QUEEN STREET ATWOOD',
                                             'serial_number': 'B511E9',
                                             'system_mac_address': None},
                '60:db:98:8f:01:d5': {       'dev_macs': ['08:5a:11:ba:2d:aa'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:01:d5',
                                             'name': '279 QUEEN STREET ATWOOD',
                                             'serial_number': 'B5120B',
                                             'system_mac_address': None},
                '60:db:98:8f:02:05': {       'dev_macs': [       '84:d3:43:0f:ba:36',
                                                                 '5c:0f:fb:17:69:9d'],
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:02:05',
                                             'name': '273 QUEEN STREET ATWOOD',
                                             'serial_number': 'B5121B',
                                             'system_mac_address': None},
                '84:d3:43:7c:e3:b7': {       'dev_macs': ['44:65:7f:88:cc:01'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7c:e3:b7',
                                             'name': '251 MAIN STREET ATWOOD',
                                             'serial_number': 'C811E0',
                                             'system_mac_address': None},
                '84:d3:43:7d:04:3f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:04:3f',
                                             'name': '165 MAIN STREET ATWOOD',
                                             'serial_number': 'C815F1',
                                             'system_mac_address': None},
                '84:d3:43:7d:1d:57': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:1d:57',
                                             'name': '354 MAIN STREET ATWOOD',
                                             'serial_number': 'C81914',
                                             'system_mac_address': None},
                '84:d3:43:7d:36:97': {       'dev_macs': ['54:af:97:59:9d:c0'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:36:97',
                                             'name': '280 MCCOURT PLACE',
                                             'serial_number': 'C81C3C',
                                             'system_mac_address': None},
                '84:d3:43:7d:36:af': {       'dev_macs': ['ec:4f:82:ac:d0:1d'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:36:af',
                                             'name': '252 King St. Atwood',
                                             'serial_number': 'C81C3F',
                                             'system_mac_address': None},
                '84:d3:43:7d:38:8f': {       'dev_macs': ['b8:94:70:bc:c5:74'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:38:8f',
                                             'name': '133 GEORGE AVENUE ATWOOD',
                                             'serial_number': 'C81C7B',
                                             'system_mac_address': None},
                '84:d3:43:7d:3a:a7': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:3a:a7',
                                             'name': '150 MONUMENT RD',
                                             'serial_number': 'C81CBE',
                                             'system_mac_address': None},
                '84:d3:43:7d:40:2f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:40:2f',
                                             'name': '269 MAIN STREET ATWOOD',
                                             'serial_number': 'C81D6F',
                                             'system_mac_address': None},
                '84:d3:43:7d:42:6f': {       'dev_macs': ['d0:76:8f:02:f5:e2'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:42:6f',
                                             'name': '137 QUEEN STREET ATWOOD',
                                             'serial_number': 'C81DB7',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:37',
                                             'name': '7444 ROAD 164',
                                             'serial_number': 'C81DD0',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:47': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:47',
                                             'name': '153 King St. Atwood',
                                             'serial_number': 'C81DD2',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:8f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:8f',
                                             'name': '219 KING STREET ATWOOD',
                                             'serial_number': 'C81DDB',
                                             'system_mac_address': None},
                '84:d3:43:7d:44:bf': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:44:bf',
                                             'name': '135 FISHER AV',
                                             'serial_number': 'C81E01',
                                             'system_mac_address': None},
                '84:d3:43:7d:46:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:46:37',
                                             'name': '278 MAIN STREET ATWOOD',
                                             'serial_number': 'C81E30',
                                             'system_mac_address': None},
                '84:d3:43:7d:46:af': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:46:af',
                                             'name': '145 ARTHUR STREET E ATWOOD',
                                             'serial_number': 'C81E3F',
                                             'system_mac_address': None},
                '84:d3:43:7d:4e:c7': {       'dev_macs': ['60:db:98:09:1b:d8'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:4e:c7',
                                             'name': '216 King St. Atwood',
                                             'serial_number': 'C81F42',
                                             'system_mac_address': None},
                '84:d3:43:7d:5e:3f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:5e:3f',
                                             'name': '143 MONUMENT RD',
                                             'serial_number': 'C82131',
                                             'system_mac_address': None},
                '84:d3:43:7d:d9:4f': {       'dev_macs': ['cc:be:59:c3:46:dc'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:d9:4f',
                                             'name': '205 Queen St. Atwood',
                                             'serial_number': 'C83093',
                                             'system_mac_address': None},
                '84:d3:43:7d:e5:47': {       'dev_macs': ['ac:9e:17:e1:df:fc'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:e5:47',
                                             'name': '189 Main St. Atwood',
                                             'serial_number': 'C83212',
                                             'system_mac_address': None},
                '84:d3:43:7e:15:87': {       'dev_macs': ['60:db:98:09:1c:bf'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:15:87',
                                             'name': '257 KING STREET ATWOOD',
                                             'serial_number': 'C8381A',
                                             'system_mac_address': None},
                '84:d3:43:7e:30:27': {       'dev_macs': ['60:db:98:09:39:52'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:30:27',
                                             'name': '171 KING STREET ATWOOD',
                                             'serial_number': 'C83B6E',
                                             'system_mac_address': None},
                '84:d3:43:7e:30:d7': {       'dev_macs': [       '00:1a:79:77:d4:ba',
                                                                 'd0:76:8f:02:ed:34',
                                                                 '5c:0f:fb:15:8d:44'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:30:d7',
                                             'name': '280 QUEEN STREET ATWOOD',
                                             'serial_number': 'C83B84',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:6f': {       'dev_macs': ['60:db:98:55:b5:a4'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:6f',
                                             'name': '113 MONUMENT RD',
                                             'serial_number': 'C83B97',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:77': {       'dev_macs': ['ec:4f:82:a5:05:2c'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:77',
                                             'name': 'RIKI DOIG',
                                             'serial_number': 'C83B98',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:97': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:97',
                                             'name': '291 WOODVIEW DR',
                                             'serial_number': 'C83B9C',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:cf': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:cf',
                                             'name': '160 JOHN STREET ATWOOD',
                                             'serial_number': 'C83BA3',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:0f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:0f',
                                             'name': '158 KING STREET',
                                             'serial_number': 'C83BAB',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:27': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:27',
                                             'name': '196 MAIN STREET ATWOOD',
                                             'serial_number': 'C83BAE',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:37': {       'dev_macs': ['54:99:63:a4:94:0a'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:37',
                                             'name': '129 Bowman Ct',
                                             'serial_number': 'C83BB0',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:8f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:8f',
                                             'name': '131 MAIN STREET ATWOOD',
                                             'serial_number': 'C83BBB',
                                             'system_mac_address': None},
                '84:d3:43:7e:33:17': {       'dev_macs': [       'f8:85:f9:a3:99:14',
                                                                 '5c:0f:fb:14:3b:f8',
                                                                 '5c:0f:fb:17:6c:3b'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:33:17',
                                             'name': '204 ELLEN ST',
                                             'serial_number': 'C83BCC',
                                             'system_mac_address': None},
                '84:d3:43:7e:33:87': {       'dev_macs': ['60:db:98:09:39:d6'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:33:87',
                                             'name': '273 WOODVIEW DR',
                                             'serial_number': 'C83BDA',
                                             'system_mac_address': None},
                '84:d3:43:7e:34:4f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:34:4f',
                                             'name': '171 James St. Atwood',
                                             'serial_number': 'C83BF3',
                                             'system_mac_address': None},
                '84:d3:43:7e:35:17': {       'dev_macs': ['ec:ce:13:54:1e:99'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:35:17',
                                             'name': '235 MAIN STREET ATWOOD',
                                             'serial_number': 'C83C0C',
                                             'system_mac_address': None},
                '84:d3:43:7e:45:07': {       'dev_macs': ['d0:76:8f:91:d3:f6'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:45:07',
                                             'name': '164 King Street Atwood',
                                             'serial_number': 'C83E0A',
                                             'system_mac_address': None},
                '84:d3:43:95:93:da': {       'dev_macs': [       'd0:76:8f:02:ed:ef',
                                                                 '00:03:e6:a2:18:68',
                                                                 '00:03:e6:da:ba:b7'],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:95:93:da',
                                             'name': '280 WOODVIEW DR.',
                                             'serial_number': 'CBD29A',
                                             'system_mac_address': None},
                '84:d3:43:96:01:9a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:96:01:9a',
                                             'name': '7452 ROAD 164',
                                             'serial_number': 'CBE052',
                                             'system_mac_address': None},
                'b8:94:70:ba:e1:a5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e1:a5',
                                             'name': 'BUCHANAN JEFF & CATHY',
                                             'serial_number': '1195149',
                                             'system_mac_address': None},
                'b8:94:70:ba:e1:e5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e1:e5',
                                             'name': '127 MONUMENT RD',
                                             'serial_number': '1195151',
                                             'system_mac_address': None},
                'b8:94:70:ba:e2:35': {       'dev_macs': [       '04:bc:9f:46:8f:4c',
                                                                 '5c:0f:fb:15:5a:4a',
                                                                 '5c:0f:fb:24:54:8a',
                                                                 '5c:0f:fb:2f:d0:cd'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e2:35',
                                             'name': '163 KING ST ATWOOD',
                                             'serial_number': '119515B',
                                             'system_mac_address': None},
                'b8:94:70:ba:e4:a5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e4:a5',
                                             'name': '134 MAIN STREET ATWOOD',
                                             'serial_number': '11951A9',
                                             'system_mac_address': None},
                'b8:94:70:c6:e9:57': {       'dev_macs': ['04:bc:9f:46:91:25'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c6:e9:57',
                                             'name': '159 FISHER AV',
                                             'serial_number': '11B2235',
                                             'system_mac_address': None},
                'b8:94:70:c6:ed:97': {       'dev_macs': ['cc:be:59:2d:a9:af'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c6:ed:97',
                                             'name': '179 MAIN STREET ATWOOD',
                                             'serial_number': '11B22BD',
                                             'system_mac_address': None},
                'b8:94:70:c7:04:f7': {       'dev_macs': ['04:bc:9f:46:92:b1'],
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c7:04:f7',
                                             'name': '210 QUEEN STREET ATWOOD',
                                             'serial_number': '11B25A9',
                                             'system_mac_address': None},
                'cc:be:59:04:29:90': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:04:29:90',
                                             'name': '7430 Rd. 164 Atwood',
                                             'serial_number': '3EBA19',
                                             'system_mac_address': None},
                'cc:be:59:04:2b:60': {       'dev_macs': ['ec:4f:82:ad:0e:69'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:04:2b:60',
                                             'name': '222B Main St. Lower',
                                             'serial_number': '3EBA53',
                                             'system_mac_address': None},
                'cc:be:59:0c:b5:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0c:b5:b4',
                                             'name': '202 MAIN STREET ATWOOD',
                                             'serial_number': '3ADD6E',
                                             'system_mac_address': None},
                'cc:be:59:0c:b5:cc': {       'dev_macs': [       'cc:be:59:2d:a5:ec',
                                                                 '00:03:e6:31:3f:30'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0c:b5:cc',
                                             'name': '189 King St. Atwood',
                                             'serial_number': '3ADD71',
                                             'system_mac_address': None},
                'cc:be:59:0d:27:04': {       'dev_macs': ['b4:0f:3b:8a:b5:09'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:27:04',
                                             'name': '214 MAIN STREET ATWOOD',
                                             'serial_number': '3AEB98',
                                             'system_mac_address': None},
                'cc:be:59:0d:27:f4': {       'dev_macs': ['ec:4f:82:a8:83:a7'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:27:f4',
                                             'name': '143 James St. Atwood',
                                             'serial_number': '3AEBB6',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:2c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:2c',
                                             'name': '275 WOODVIEW DR',
                                             'serial_number': '3AEBBD',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:44': {       'dev_macs': [       'b8:94:70:bc:b8:17',
                                                                 '5c:0f:fb:2f:cd:35'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:44',
                                             'name': '141 BOWMAN CT',
                                             'serial_number': '3AEBC0',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:84': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:84',
                                             'name': '112 BLAIR ST',
                                             'serial_number': '3AEBC8',
                                             'system_mac_address': None},
                'cc:be:59:0d:2b:3c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:2b:3c',
                                             'name': '189 Ellen St. Atwood',
                                             'serial_number': '3AEC1F',
                                             'system_mac_address': None},
                'cc:be:59:0d:2b:4c': {       'dev_macs': ['60:db:98:09:3b:af'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:2b:4c',
                                             'name': '240 WOODVIEW DR',
                                             'serial_number': '3AEC21',
                                             'system_mac_address': None},
                'cc:be:59:2b:a9:47': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:2b:a9:47',
                                             'name': '123 Main St. N. Atwood',
                                             'serial_number': '3FB35D',
                                             'system_mac_address': None},
                'cc:be:59:46:c9:cf': {       'dev_macs': ['3c:97:0e:5c:68:9b'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:46:c9:cf',
                                             'name': '246 King St. Atwood',
                                             'serial_number': '39507A',
                                             'system_mac_address': None},
                'cc:be:59:47:32:bf': {       'dev_macs': ['9c:3d:cf:f0:22:48'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:47:32:bf',
                                             'name': '169 James St. Atwood',
                                             'serial_number': '433E5F',
                                             'system_mac_address': None},
                'cc:be:59:50:17:31': {       'dev_macs': ['cc:be:59:2f:2d:99'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:17:31',
                                             'name': '163 Fisher Ave Atwood',
                                             'serial_number': '43C21A',
                                             'system_mac_address': None},
                'cc:be:59:50:17:95': {       'dev_macs': ['38:d5:47:c5:be:68'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:17:95',
                                             'name': '202 Ellen St Atwood',
                                             'serial_number': '43C24C',
                                             'system_mac_address': None},
                'cc:be:59:50:1a:b7': {       'dev_macs': ['cc:be:59:2d:a8:7d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:1a:b7',
                                             'name': '155 Queen St Atwood',
                                             'serial_number': '43C3DD',
                                             'system_mac_address': None},
                'cc:be:59:52:6d:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:52:6d:37',
                                             'name': '7306 Rd 164 Atwood',
                                             'serial_number': '3FC3C2',
                                             'system_mac_address': None},
                'cc:be:59:5f:16:62': {       'dev_macs': ['60:db:98:59:a4:87'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:5f:16:62',
                                             'name': '104 MONUMENT RD',
                                             'serial_number': '455673',
                                             'system_mac_address': None},
                'cc:be:59:6a:dd:5e': {       'dev_macs': [       '74:ea:3a:a7:d7:05',
                                                                 'd8:07:b6:e3:1e:1f'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6a:dd:5e',
                                             'name': '182 Ellen St. Atwood',
                                             'serial_number': '46CE0A',
                                             'system_mac_address': None},
                'cc:be:59:6d:3d:5e': {       'dev_macs': ['20:aa:4b:72:5d:90'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:3d:5e',
                                             'name': '130 John St. Atwood',
                                             'serial_number': '3FFFE3',
                                             'system_mac_address': None},
                'cc:be:59:6d:5a:be': {       'dev_macs': ['78:32:1b:41:9b:28'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:5a:be',
                                             'name': '129 King St. Atwood',
                                             'serial_number': '40038F',
                                             'system_mac_address': None},
                'cc:be:59:6d:5c:e6': {       'dev_macs': ['f0:2f:74:e9:8a:30'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:5c:e6',
                                             'name': '151 King St. Atwood',
                                             'serial_number': '4003D4',
                                             'system_mac_address': None},
                'cc:be:59:6d:60:ee': {       'dev_macs': ['10:7b:44:3f:13:74'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:60:ee',
                                             'name': '148 King St. Atwood',
                                             'serial_number': '400455',
                                             'system_mac_address': None},
                'cc:be:59:6d:7e:3e': {       'dev_macs': ['d0:76:8f:1f:58:38'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:7e:3e',
                                             'name': '208 KING STREET ATWOOD',
                                             'serial_number': '4007FF',
                                             'system_mac_address': None},
                'cc:be:59:6d:85:26': {       'dev_macs': [       '60:db:98:09:1b:ac',
                                                                 '00:03:e6:f0:ee:34',
                                                                 '00:03:e6:f0:fa:ee',
                                                                 '5c:0f:fb:2f:ca:9b'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:85:26',
                                             'name': '279 WOODVIEW DR',
                                             'serial_number': '4008DC',
                                             'system_mac_address': None},
                'cc:be:59:6d:b9:be': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:b9:be',
                                             'name': '233 Woodview Dr. Atwood',
                                             'serial_number': '400F64',
                                             'system_mac_address': None},
                'cc:be:59:6d:e8:d6': {       'dev_macs': ['60:63:4c:62:8e:f6'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:e8:d6',
                                             'name': '254 Queen St. Atwood',
                                             'serial_number': '4703AF',
                                             'system_mac_address': None},
                'cc:be:59:6e:14:ca': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:14:ca',
                                             'name': '135 Queen St. Atwood',
                                             'serial_number': '47092C',
                                             'system_mac_address': None},
                'cc:be:59:6e:6e:da': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:6e:da',
                                             'name': '256 Main St. Atwood',
                                             'serial_number': '47146E',
                                             'system_mac_address': None},
                'cc:be:59:6e:ae:96': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:ae:96',
                                             'name': '186 MAIN STREET',
                                             'serial_number': '471C63',
                                             'system_mac_address': None},
                'cc:be:59:6f:1d:c2': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:1d:c2',
                                             'name': '250 MAIN STREET ATWOOD',
                                             'serial_number': '55DFB1',
                                             'system_mac_address': None},
                'cc:be:59:6f:29:52': {       'dev_macs': ['e0:1c:fc:80:86:fc'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:29:52',
                                             'name': '146 Monument Rd',
                                             'serial_number': '55E123',
                                             'system_mac_address': None},
                'cc:be:59:6f:74:d2': {       'dev_macs': ['44:65:7f:41:8d:d9'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:74:d2',
                                             'name': '186 Ellen St. Atwood',
                                             'serial_number': '55EA90',
                                             'system_mac_address': None},
                'cc:be:59:6f:fd:92': {       'dev_macs': ['00:0e:c6:80:85:24'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:fd:92',
                                             'name': '154 Monument Rd',
                                             'serial_number': '55FBA5',
                                             'system_mac_address': None},
                'cc:be:59:6f:ff:1a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:ff:1a',
                                             'name': '208 Main St. Atwood',
                                             'serial_number': '55FBD6',
                                             'system_mac_address': None},
                'cc:be:59:70:33:7e': {       'dev_macs': [       'a8:63:7d:7a:84:91',
                                                                 '78:32:1b:6e:4d:d6'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:33:7e',
                                             'name': '220 MAIN STREET ATWOOD',
                                             'serial_number': '560262',
                                             'system_mac_address': None},
                'cc:be:59:70:33:86': {       'dev_macs': ['ec:4f:82:2d:61:e1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:33:86',
                                             'name': '7436 Rd. 164 Atwood',
                                             'serial_number': '560263',
                                             'system_mac_address': None},
                'cc:be:59:70:81:36': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:81:36',
                                             'name': '7446 ROAD 164',
                                             'serial_number': '560C19',
                                             'system_mac_address': None},
                'cc:be:59:af:a5:9b': {       'dev_macs': ['60:db:98:09:3b:20'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:af:a5:9b',
                                             'name': '137 MAIN STREET ATWOOD',
                                             'serial_number': '4E36A8',
                                             'system_mac_address': None},
                'cc:be:59:af:d8:7b': {       'dev_macs': ['68:ff:7b:32:2b:d1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:af:d8:7b',
                                             'name': '62 PARKVIEW CR',
                                             'serial_number': '4E3D04',
                                             'system_mac_address': None},
                'cc:be:59:b3:7c:9b': {       'dev_macs': ['c8:4f:86:1b:44:8f'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:b3:7c:9b',
                                             'name': '269 Main St. Atwood',
                                             'serial_number': '4EB17D',
                                             'system_mac_address': None},
                'cc:be:59:b7:3b:67': {       'dev_macs': ['ec:08:6b:5a:b4:e1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:b7:3b:67',
                                             'name': '253 Queen St.',
                                             'serial_number': '4D111F',
                                             'system_mac_address': None},
                'cc:be:59:ca:db:7a': {       'dev_macs': ['44:65:7f:37:fe:45'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:db:7a',
                                             'name': '129 James St. Atwood',
                                             'serial_number': '42816E',
                                             'system_mac_address': None},
                'cc:be:59:ca:dc:92': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:dc:92',
                                             'name': '164 FISHER AV',
                                             'serial_number': '428191',
                                             'system_mac_address': None},
                'cc:be:59:ca:de:8a': {       'dev_macs': ['cc:be:59:c3:47:d8'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:de:8a',
                                             'name': '145 Queen St Atwood',
                                             'serial_number': '4281D0',
                                             'system_mac_address': None},
                'cc:be:59:cb:43:da': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:43:da',
                                             'name': '261 King St Atwood',
                                             'serial_number': '42B9D3',
                                             'system_mac_address': None},
                'cc:be:59:cb:44:72': {       'dev_macs': ['44:65:7f:37:fd:64'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:44:72',
                                             'name': '7464 Rd 164 Atwood',
                                             'serial_number': '42B9E6',
                                             'system_mac_address': None},
                'cc:be:59:cb:6c:5a': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:6c:5a',
                                             'name': '272 McCourt Place Atwood',
                                             'serial_number': '42BEE3',
                                             'system_mac_address': None},
                'cc:be:59:cb:7e:02': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:7e:02',
                                             'name': '275 MCCOURT PL',
                                             'serial_number': '42C118',
                                             'system_mac_address': None},
                'cc:be:59:cb:95:e2': {       'dev_macs': [       '44:65:7f:37:fe:21',
                                                                 '00:03:e6:a2:75:ce',
                                                                 '00:03:e6:da:2f:b7'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:95:e2',
                                             'name': '167 Queen St, Atwood',
                                             'serial_number': '42C414',
                                             'system_mac_address': None},
                'cc:be:59:cb:bb:ba': {       'dev_macs': ['b8:94:70:bc:c3:f3'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bb:ba',
                                             'name': '98 ELMA CENTRE ST',
                                             'serial_number': '42C8CF',
                                             'system_mac_address': None},
                'cc:be:59:cb:bd:12': {       'dev_macs': ['cc:be:59:2d:a9:94'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bd:12',
                                             'name': '94 Elma Centre Atwood',
                                             'serial_number': '42C8FA',
                                             'system_mac_address': None},
                'cc:be:59:cb:bf:3a': {       'dev_macs': ['cc:be:59:c3:c8:f0'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bf:3a',
                                             'name': '273 McCourt Pl Atwood',
                                             'serial_number': '42C93F',
                                             'system_mac_address': None},
                'cc:be:59:cb:ea:02': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:ea:02',
                                             'name': '7426 Road 164 Atwood',
                                             'serial_number': '42CE98',
                                             'system_mac_address': None},
                'cc:be:59:cc:03:2a': {       'dev_macs': ['14:59:c0:c0:f0:6d'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:03:2a',
                                             'name': '182 King St Atwood',
                                             'serial_number': '42D1BD',
                                             'system_mac_address': None},
                'cc:be:59:cc:0b:1a': {       'dev_macs': ['44:65:7f:3e:ab:7f'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:0b:1a',
                                             'name': '155 Fischer Ave Atwood',
                                             'serial_number': '42D2BB',
                                             'system_mac_address': None},
                'cc:be:59:cc:11:3a': {       'dev_macs': ['44:65:7f:88:45:be'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:11:3a',
                                             'name': '134 King St Atwood',
                                             'serial_number': '42D37F',
                                             'system_mac_address': None},
                'cc:be:59:cc:11:ba': {       'dev_macs': ['48:77:46:9a:55:a1'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:11:ba',
                                             'name': '187 King St Atwood',
                                             'serial_number': '42D38F',
                                             'system_mac_address': None},
                'cc:be:59:eb:39:ae': {       'dev_macs': ['3c:7c:3f:cb:7b:60'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:39:ae',
                                             'name': '154 King St. Atwood',
                                             'serial_number': '5563AB',
                                             'system_mac_address': None},
                'cc:be:59:eb:39:be': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:39:be',
                                             'name': '7456 ROAD 164',
                                             'serial_number': '5563AD',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:06': {       'dev_macs': ['74:ea:3a:a1:63:97'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:06',
                                             'name': '190 Ellen St. Atwood',
                                             'serial_number': '5563B6',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:de': {       'dev_macs': ['cc:be:59:32:9a:92'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:de',
                                             'name': '167 John St. Atwood',
                                             'serial_number': '5563D1',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:ee': {       'dev_macs': ['70:4f:57:be:6c:6c'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:ee',
                                             'name': '205 Ellen St. Atwood',
                                             'serial_number': '5563D3',
                                             'system_mac_address': None},
                'cc:be:59:eb:3b:d6': {       'dev_macs': ['d0:76:8f:02:f3:17'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3b:d6',
                                             'name': '171 QUEEN STREET ATWOOD',
                                             'serial_number': '5563F0',
                                             'system_mac_address': None},
                'cc:be:59:ef:f4:de': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f4:de',
                                             'name': '106 BLAIR ST',
                                             'serial_number': '4D41EE',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:0e': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:0e',
                                             'name': '207 Main St. Atwood',
                                             'serial_number': '4D41F4',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:16': {       'dev_macs': ['cc:be:59:c3:c8:06'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:16',
                                             'name': '283 Woodview Dr. Atwood',
                                             'serial_number': '4D41F5',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:26': {       'dev_macs': ['c4:41:1e:a9:9e:28'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:26',
                                             'name': '170 King St. Atwood',
                                             'serial_number': '4D41F7',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:56': {       'dev_macs': ['d0:76:8f:1f:55:36'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:56',
                                             'name': '169 King St. Atwood',
                                             'serial_number': '4D423D',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:7e': {       'dev_macs': ['f8:e9:03:b8:be:91'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:7e',
                                             'name': '204 King St. Atwood',
                                             'serial_number': '4D4242',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:d6': {       'dev_macs': ['bc:0f:9a:77:c2:bd'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:d6',
                                             'name': '217 Queen St. Atwood',
                                             'serial_number': '4D424D',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:e6': {       'dev_macs': ['d0:76:8f:1f:54:c8'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:e6',
                                             'name': '127 KING STREET ATWOOD',
                                             'serial_number': '4D424F',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:ee': {       'dev_macs': ['70:4c:a5:6e:2c:96'],
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:ee',
                                             'name': '5972 Perth Line 72',
                                             'serial_number': '4D4250',
                                             'system_mac_address': None},
                'd0:76:8f:06:e5:fe': {       'dev_macs': ['60:32:b1:41:b1:b1'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:06:e5:fe',
                                             'name': '165 JOHN STREET ATWOOD',
                                             'serial_number': '844BE5',
                                             'system_mac_address': None},
                'd0:76:8f:07:19:91': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:07:19:91',
                                             'name': '170 Main St. Unit B',
                                             'serial_number': '8678B6',
                                             'system_mac_address': None},
                'd0:76:8f:08:14:ab': {       'dev_macs': ['84:d3:43:0f:bc:5c'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:14:ab',
                                             'name': '119 PARKVIEW CR',
                                             'serial_number': '86938B',
                                             'system_mac_address': None},
                'd0:76:8f:08:15:33': {       'dev_macs': [       'd0:76:8f:02:ef:5a',
                                                                 '00:03:e6:dd:2e:f3',
                                                                 '00:03:e6:dd:31:31',
                                                                 '00:03:e6:dd:32:0c'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:15:33',
                                             'name': '236 WOODVIEW DR',
                                             'serial_number': '86939C',
                                             'system_mac_address': None},
                'd0:76:8f:08:16:83': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:16:83',
                                             'name': '135 KING STREET ATWOOD',
                                             'serial_number': '8693C6',
                                             'system_mac_address': None},
                'd0:76:8f:08:17:4b': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:17:4b',
                                             'name': '215 QUEEN STREET ATWOOD',
                                             'serial_number': '8693DF',
                                             'system_mac_address': None},
                'd0:76:8f:08:18:33': {       'dev_macs': ['d0:76:8f:1f:64:40'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:18:33',
                                             'name': '276 MCCOURT PL',
                                             'serial_number': '8693FC',
                                             'system_mac_address': None},
                'd0:76:8f:08:19:1b': {       'dev_macs': ['68:9c:e2:a1:d4:22'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:19:1b',
                                             'name': '7495 ROAD 164',
                                             'serial_number': '869419',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:6b': {       'dev_macs': ['cc:be:59:32:94:2c'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:6b',
                                             'name': '138 Main St Atwood',
                                             'serial_number': '87241B',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:bb': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:bb',
                                             'name': '241 WOODVIEW DR',
                                             'serial_number': '872425',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:e3': {       'dev_macs': ['cc:be:59:32:95:f7'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:e3',
                                             'name': '166 FISHER AV',
                                             'serial_number': '87242A',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a0:83': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a0:83',
                                             'name': '265 Queen St. Atwood',
                                             'serial_number': '87245E',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a1:13': {       'dev_macs': ['ec:08:6b:46:40:b9'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a1:13',
                                             'name': '7497 Rd. 164 Atwood',
                                             'serial_number': '872470',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a1:1b': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a1:1b',
                                             'name': '124 MAIN STREET ATWOOD',
                                             'serial_number': '872471',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a5:73': {       'dev_macs': ['ec:4f:82:2b:47:52'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a5:73',
                                             'name': '202 Queen St. Atwood',
                                             'serial_number': '8724FC',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a7:3b': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a7:3b',
                                             'name': '155 Main St. Atwood',
                                             'serial_number': '872535',
                                             'system_mac_address': None},
                'd0:76:8f:a9:53:88': {       'dev_macs': ['d0:76:8f:1f:61:b7'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:a9:53:88',
                                             'name': '162 FISHER AV',
                                             'serial_number': '954F45',
                                             'system_mac_address': None},
                'd0:76:8f:aa:4e:f4': {       'dev_macs': ['d0:76:8f:91:d2:6a'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:4e:f4',
                                             'name': '139 MONUMENT RD ATWOOD',
                                             'serial_number': '956F04',
                                             'system_mac_address': None},
                'd0:76:8f:aa:4f:e4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:4f:e4',
                                             'name': '222 King St. Atwood',
                                             'serial_number': '956F22',
                                             'system_mac_address': None},
                'd0:76:8f:aa:50:04': {       'dev_macs': [       'd0:76:8f:02:f1:d8',
                                                                 '00:03:e6:db:aa:5d',
                                                                 '00:03:e6:dd:46:d3'],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:50:04',
                                             'name': '166 MAIN ST ATWOOD',
                                             'serial_number': '956F26',
                                             'system_mac_address': None},
                'd0:76:8f:aa:54:0c': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:54:0c',
                                             'name': '100 ARTHUR ST EAST ATWOOD',
                                             'serial_number': '956FA7',
                                             'system_mac_address': None},
                'ec:4f:82:02:06:79': {       'dev_macs': ['d8:50:e6:d6:6f:cc'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:02:06:79',
                                             'name': '91 Arthur St. Atwood',
                                             'serial_number': '1F7DA1',
                                             'system_mac_address': None},
                'ec:4f:82:08:2e:cd': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:08:2e:cd',
                                             'name': '112 Arthur Street, Atwood',
                                             'serial_number': '1C5DCF',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:97': {       'dev_macs': [       'cc:be:59:c3:c8:45',
                                                                 '00:03:e6:a5:70:b1'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:97',
                                             'name': '256 Woodview Dr.',
                                             'serial_number': '248AC3',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:af': {       'dev_macs': ['ec:4f:82:ac:ec:2b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:af',
                                             'name': '274 Woodview Dr. Atwood',
                                             'serial_number': '248AC6',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:0f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:0f',
                                             'name': '194 Queen St. Atwood',
                                             'serial_number': '248AD2',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:37': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:37',
                                             'name': '215 Main St. Atwood',
                                             'serial_number': '248AD7',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:97': {       'dev_macs': ['ec:4f:82:a5:13:d5'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:97',
                                             'name': '144 King St. Atwood',
                                             'serial_number': '248AE3',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:af': {       'dev_macs': ['d0:76:8f:1f:5f:44'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:af',
                                             'name': '209 Main St. Atwood',
                                             'serial_number': '248AE6',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:cf': {       'dev_macs': [       '24:4b:fe:1e:92:58',
                                                                 '00:03:e6:9b:3b:f8'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:cf',
                                             'name': '129 Parkview Cr. Atwood',
                                             'serial_number': '248AEA',
                                             'system_mac_address': None},
                'ec:4f:82:32:27:1f': {       'dev_macs': ['b8:94:70:f3:e4:40'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:27:1f',
                                             'name': '193 ELLEN  ST',
                                             'serial_number': '248AF4',
                                             'system_mac_address': None},
                'ec:4f:82:33:d5:0f': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:33:d5:0f',
                                             'name': '157 Monument Rd',
                                             'serial_number': '1FC4EF',
                                             'system_mac_address': None},
                'ec:4f:82:44:18:1f': {       'dev_macs': ['cc:be:59:c3:c2:54'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:44:18:1f',
                                             'name': '194 KING STREET ATWOOD',
                                             'serial_number': '23A003',
                                             'system_mac_address': None},
                'ec:4f:82:4c:a5:67': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:4c:a5:67',
                                             'name': '147 KING STREET ATWOOD',
                                             'serial_number': '25B5F9',
                                             'system_mac_address': None},
                'ec:4f:82:59:55:07': {       'dev_macs': ['98:ed:7e:e2:f9:00'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:59:55:07',
                                             'name': '287 WOODVIEW DR',
                                             'serial_number': '2AA878',
                                             'system_mac_address': None},
                'ec:4f:82:59:5b:77': {       'dev_macs': ['14:59:c0:4e:56:a7'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:59:5b:77',
                                             'name': '252 Woodview Dr. Atwood',
                                             'serial_number': '2AA946',
                                             'system_mac_address': None},
                'ec:4f:82:67:6d:cd': {       'dev_macs': ['ec:4f:82:2a:b0:02'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:6d:cd',
                                             'name': '217 KING STREET ATWOOD',
                                             'serial_number': '25D8AE',
                                             'system_mac_address': None},
                'ec:4f:82:67:71:b5': {       'dev_macs': ['30:de:4b:ee:0c:42'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:71:b5',
                                             'name': '237 WOODVIEW DR',
                                             'serial_number': '25D92B',
                                             'system_mac_address': None},
                'ec:4f:82:67:71:fd': {       'dev_macs': ['90:9a:4a:80:de:2b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:71:fd',
                                             'name': '136 MONUMENT RD',
                                             'serial_number': '25D934',
                                             'system_mac_address': None},
                'ec:4f:82:7a:23:67': {       'dev_macs': ['a8:5e:45:77:90:9c'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:7a:23:67',
                                             'name': '165 Fisher Ave',
                                             'serial_number': '2F3AD9',
                                             'system_mac_address': None},
                'ec:4f:82:8d:3f:60': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:3f:60',
                                             'name': '154 Main St. Atwood',
                                             'serial_number': '321033',
                                             'system_mac_address': None},
                'ec:4f:82:8d:4b:60': {       'dev_macs': [       'b0:e4:d5:25:60:b8',
                                                                 'b0:e4:d5:53:dc:d4'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:4b:60',
                                             'name': '256 KING STREET ATWOOD',
                                             'serial_number': '3211B3',
                                             'system_mac_address': None},
                'ec:4f:82:8d:76:88': {       'dev_macs': ['cc:be:59:2f:2d:51'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:76:88',
                                             'name': '98 Parkview Cr Atwood',
                                             'serial_number': '321718',
                                             'system_mac_address': None},
                'ec:4f:82:8d:7a:d8': {       'dev_macs': ['cc:be:59:2f:2d:d8'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:7a:d8',
                                             'name': '162 Queen St Atwood',
                                             'serial_number': '3217A2',
                                             'system_mac_address': None},
                'ec:4f:82:8d:7c:18': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:7c:18',
                                             'name': '159 John St',
                                             'serial_number': '3217CA',
                                             'system_mac_address': None},
                'ec:4f:82:8d:88:88': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:88:88',
                                             'name': '145 Bowman Ct. Atwwod',
                                             'serial_number': '321958',
                                             'system_mac_address': None},
                'ec:4f:82:8d:dc:60': {       'dev_macs': [       '48:77:46:f8:b1:52',
                                                                 '00:03:e6:a2:18:14',
                                                                 '00:03:e6:da:34:39',
                                                                 '00:03:e6:da:35:7f'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:dc:60',
                                             'name': '157 Fisher Ave Atwood',
                                             'serial_number': '3223D3',
                                             'system_mac_address': None},
                'ec:4f:82:8d:dd:90': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:dd:90',
                                             'name': '211 Main St Atwood',
                                             'serial_number': '3223F9',
                                             'system_mac_address': None},
                'ec:4f:82:8e:00:f0': {       'dev_macs': ['50:91:e3:bc:40:14'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8e:00:f0',
                                             'name': '123 PARKVIEW CR',
                                             'serial_number': '322865',
                                             'system_mac_address': None},
                'ec:4f:82:8e:05:d0': {       'dev_macs': ['cc:be:59:2d:a8:6b'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8e:05:d0',
                                             'name': '124 Queen St Atwood',
                                             'serial_number': '322901',
                                             'system_mac_address': None},
                'ec:4f:82:92:f6:18': {       'dev_macs': ['e4:6f:13:fa:d2:a7'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:f6:18',
                                             'name': '216A Main St. Atwood',
                                             'serial_number': '32954F',
                                             'system_mac_address': None},
                'ec:4f:82:92:fa:80': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fa:80',
                                             'name': '132 BOWMAN CT',
                                             'serial_number': '3295DC',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:50': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:50',
                                             'name': '158 James St. Atwood',
                                             'serial_number': '329636',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:68': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:68',
                                             'name': '272 Main St. Atwood',
                                             'serial_number': '329639',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:80': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:80',
                                             'name': '94 Baker St. Atwood',
                                             'serial_number': '32963C',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:b0': {       'dev_macs': ['d0:76:8f:02:f4:61'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:b0',
                                             'name': '167 MAIN STREET ATWOOD',
                                             'serial_number': '329642',
                                             'system_mac_address': None},
                'ec:4f:82:9b:b6:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:9b:b6:b4',
                                             'name': '266 Woodview Dr. Atwood',
                                             'serial_number': '33AD09',
                                             'system_mac_address': None},
                'ec:4f:82:9c:fa:6c': {       'dev_macs': ['60:db:98:57:a7:59'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:9c:fa:6c',
                                             'name': '156 QUEEN STREET ATWOOD',
                                             'serial_number': '33D580',
                                             'system_mac_address': None},
                'ec:4f:82:a2:ae:49': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:a2:ae:49',
                                             'name': '170 MAIN STREET ATWOOD',
                                             'serial_number': '349D6E',
                                             'system_mac_address': None},
                'ec:4f:82:b8:2c:40': {       'dev_macs': ['04:bc:9f:46:91:51'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:2c:40',
                                             'name': '88 Parkview Cr. Atwood',
                                             'serial_number': '2FCC31',
                                             'system_mac_address': None},
                'ec:4f:82:b8:2c:78': {       'dev_macs': ['ec:4f:82:a8:88:15'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:2c:78',
                                             'name': '122 King St. Atwood',
                                             'serial_number': '2FCC38',
                                             'system_mac_address': None},
                'ec:4f:82:b8:31:c0': {       'dev_macs': ['d8:47:32:21:92:dd'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:31:c0',
                                             'name': '193 Main St. Atwood',
                                             'serial_number': '2FCCE1',
                                             'system_mac_address': None},
                'ec:4f:82:b9:18:80': {       'dev_macs': [       '70:4d:7b:d4:71:fc',
                                                                 '00:03:e6:da:b2:fc',
                                                                 '00:03:e6:dd:30:1e'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:18:80',
                                             'name': '137 Bowman Ct',
                                             'serial_number': '2FE9BA',
                                             'system_mac_address': None},
                'ec:4f:82:b9:1a:48': {       'dev_macs': ['60:db:98:55:b5:62'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:1a:48',
                                             'name': '132 QUEEN STREET ATWOOD',
                                             'serial_number': '2FE9F3',
                                             'system_mac_address': None},
                'ec:4f:82:b9:1a:c8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:1a:c8',
                                             'name': '264 MAIN STREET ATWOOD',
                                             'serial_number': '2FEA03',
                                             'system_mac_address': None},
                'ec:4f:82:be:ac:21': {       'dev_macs': ['2c:b8:ed:43:0e:71'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:be:ac:21',
                                             'name': '217 MAIN STREET ATWOOD',
                                             'serial_number': '3788C1',
                                             'system_mac_address': None},
                'ec:4f:82:c0:c3:b0': {       'dev_macs': ['84:16:f9:25:86:23'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:c0:c3:b0',
                                             'name': '145 John St.',
                                             'serial_number': '3655A9',
                                             'system_mac_address': None},
                'ec:4f:82:cb:05:18': {       'dev_macs': [       '14:91:82:2e:68:01',
                                                                 'c4:e9:0a:56:61:4e',
                                                                 '00:03:e6:60:14:92'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:05:18',
                                             'name': '164 John St. Atwood',
                                             'serial_number': '2C9A0E',
                                             'system_mac_address': None},
                'ec:4f:82:cb:2b:48': {       'dev_macs': ['bc:0f:9a:66:68:50'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:2b:48',
                                             'name': '130 Main St. Atwood',
                                             'serial_number': '2C9ED4',
                                             'system_mac_address': None},
                'ec:4f:82:cb:4d:14': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:4d:14',
                                             'name': '130 ARTHUR STREET ATWOOD',
                                             'serial_number': '2CA30D',
                                             'system_mac_address': None},
                'ec:4f:82:cb:9e:b8': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:9e:b8',
                                             'name': '229 WOODVIEW DR',
                                             'serial_number': '38F111',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a2:88': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a2:88',
                                             'name': '140 Queen St. Atwood',
                                             'serial_number': '38F18B',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a5:80': {       'dev_macs': ['40:b0:76:05:6e:34'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a5:80',
                                             'name': '146 Queen St. Atwood',
                                             'serial_number': '38F1EA',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a6:18': {       'dev_macs': ['44:65:7f:88:47:4a'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a6:18',
                                             'name': '134 Monument Rd',
                                             'serial_number': '38F1FD',
                                             'system_mac_address': None},
                'ec:4f:82:cc:6c:04': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cc:6c:04',
                                             'name': '144 Bowman Ct',
                                             'serial_number': '390AB8',
                                             'system_mac_address': None},
                'ec:4f:82:da:ad:58': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:da:ad:58',
                                             'name': '153 MAIN STREET ATWOOD',
                                             'serial_number': '2E914A',
                                             'system_mac_address': None},
                'ec:4f:82:db:f0:ec': {       'dev_macs': ['cc:be:59:33:61:a0'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:db:f0:ec',
                                             'name': '298 Woodview Dr.',
                                             'serial_number': '2EB9B8',
                                             'system_mac_address': None},
                'ec:4f:82:dc:a5:2c': {       'dev_macs': ['74:da:da:d0:fb:96'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:a5:2c',
                                             'name': '147 Queen St. Atwood',
                                             'serial_number': '2ED03F',
                                             'system_mac_address': None},
                'ec:4f:82:dc:f1:b4': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:f1:b4',
                                             'name': '161 MONUMENT RD',
                                             'serial_number': '2ED9D0',
                                             'system_mac_address': None},
                'ec:4f:82:dc:f2:dc': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:f2:dc',
                                             'name': '130 King St. Atwood',
                                             'serial_number': '2ED9F5',
                                             'system_mac_address': None},
                'ec:4f:82:e0:0a:e0': {       'dev_macs': [       '44:65:7f:88:d1:b3',
                                                                 'c8:78:7d:65:b1:70'],
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:e0:0a:e0',
                                             'name': '200A MAIN STREET ATWOOD',
                                             'serial_number': '3961A9',
                                             'system_mac_address': None},
                'f8:85:f9:06:4e:64': {       'dev_macs': ['a8:5e:45:ca:b9:68'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:4e:64',
                                             'name': '176 King St. Atwood',
                                             'serial_number': 'BF1E1B',
                                             'system_mac_address': None},
                'f8:85:f9:06:6c:cc': {       'dev_macs': ['48:f8:b3:8f:10:d9'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:6c:cc',
                                             'name': '182 MAIN STREET',
                                             'serial_number': 'BF21E8',
                                             'system_mac_address': None},
                'f8:85:f9:06:77:e4': {       'dev_macs': [       '60:db:98:09:1b:5f',
                                                                 '00:03:e6:dd:44:ab',
                                                                 '00:03:e6:ec:0b:a6'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:77:e4',
                                             'name': '128 Main St. Atwood',
                                             'serial_number': 'BF234B',
                                             'system_mac_address': None},
                'f8:85:f9:6f:1b:dd': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:1b:dd',
                                             'name': '186 King St. Atwood',
                                             'serial_number': 'BF242A',
                                             'system_mac_address': None},
                'f8:85:f9:6f:20:25': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:20:25',
                                             'name': '161 Fisher Ave',
                                             'serial_number': 'BF24B4',
                                             'system_mac_address': None},
                'f8:85:f9:6f:21:0d': {       'dev_macs': [       '3c:7c:3f:6d:e1:58',
                                                                 '00:03:e6:5e:8d:7c',
                                                                 '00:03:e6:5e:8d:86',
                                                                 '00:03:e6:5e:8d:94'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:21:0d',
                                             'name': '7488 ROAD 164',
                                             'serial_number': 'BF24D1',
                                             'system_mac_address': None},
                'f8:85:f9:6f:22:05': {       'dev_macs': ['54:b8:0a:0f:4d:a3'],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:22:05',
                                             'name': '194 Ellen St. Atwood',
                                             'serial_number': 'BF24F1',
                                             'system_mac_address': None},
                'f8:85:f9:6f:22:a5': {       'dev_macs': [],
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:22:a5',
                                             'name': '248 Queen St. Atwood',
                                             'serial_number': 'BF2505',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'front',
                                                              'mac_address': 'cc:be:59:12:6a:c8',
                                                              'name': 'Craft-FE: front',
                                                              'oper_up': True,
                                                              'poller_hash': 'NzE3MDI5NzAyNjhmcm9udA=='},
                                                      {       'admin_up': False,
                                                              'id': 'rear',
                                                              'name': 'Craft-FE: rear',
                                                              'oper_up': False,
                                                              'poller_hash': 'NzE3MDI5NzAyNjhyZWFy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2 (EXA)',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1/x3',
                                                                                         'in_discards': '21746180',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2009698925',
                                                                                         'in_octets': '3203197839539376',
                                                                                         'in_ucast_pkts': '7839168241514',
                                                                                         'mac_address': 'cc:be:59:12:6a:d7',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-10G-DAC',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '10790170802497',
                                                                                         'out_octets': '36792262944623630',
                                                                                         'out_ucast_pkts': '17383740106177',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/x4',
                                                                                         'in_discards': '2759025',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '25446436',
                                                                                         'in_octets': '1181429756823574',
                                                                                         'in_ucast_pkts': '876579766521',
                                                                                         'mac_address': 'cc:be:59:12:6a:d8',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC02',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 '1/x4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '42974334',
                                                                                         'out_octets': '39097737387555',
                                                                                         'out_ucast_pkts': '161145087361',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4TUNDTC1TVUJTIDEveDQ=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2564',
                                                                                         'in_octets': '682781',
                                                                                         'in_ucast_pkts': '3781',
                                                                                         'mac_address': 'cc:be:59:12:6a:c9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01669',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '365241799',
                                                                                         'out_octets': '25892593606',
                                                                                         'out_ucast_pkts': '1097653',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g2',
                                                                                         'mac_address': 'cc:be:59:12:6a:ca',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g3',
                                                                                         'mac_address': 'cc:be:59:12:6a:cb',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g4',
                                                                                         'mac_address': 'cc:be:59:12:6a:cc',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nNA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/1',
                                                                                         'in_discards': '170604',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23309068',
                                                                                         'in_octets': '19033336863003',
                                                                                         'in_ucast_pkts': '73856651506',
                                                                                         'links': [       {       'in_nucast_pkts': '14426361',
                                                                                                                  'in_octets': '60309678501',
                                                                                                                  'in_ucast_pkts': '223227841',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4061446793',
                                                                                                                  'out_octets': '5750152080487',
                                                                                                                  'out_ucast_pkts': '573349918',
                                                                                                                  'poller_hash': 'MzIyOTAxcGVlcmludGZwb24gMw=='},
                                                                                                          {       'in_nucast_pkts': '152',
                                                                                                                  'in_octets': '163114766',
                                                                                                                  'in_ucast_pkts': '757656',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5688',
                                                                                                                  'out_octets': '5144905196',
                                                                                                                  'out_ucast_pkts': '3485813',
                                                                                                                  'poller_hash': 'OTU2RjA0cGVlcmludGZwb24gMjA='},
                                                                                                          {       'in_nucast_pkts': '2725',
                                                                                                                  'in_octets': '762715',
                                                                                                                  'in_ucast_pkts': '2439',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5260889',
                                                                                                                  'out_octets': '6931288062',
                                                                                                                  'out_ucast_pkts': '2037',
                                                                                                                  'poller_hash': 'MUZDNEVGcGVlcmludGZwb24gNzI='},
                                                                                                          {       'in_nucast_pkts': '24731224',
                                                                                                                  'in_octets': '27636893073',
                                                                                                                  'in_ucast_pkts': '116993278',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11657626815',
                                                                                                                  'out_octets': '15385392682423',
                                                                                                                  'out_ucast_pkts': '325640979',
                                                                                                                  'poller_hash': 'NTVGQkE1cGVlcmludGZwb24gNzM='},
                                                                                                          {       'in_nucast_pkts': '21023108',
                                                                                                                  'in_octets': '236755723904',
                                                                                                                  'in_ucast_pkts': '515490044',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18685913074',
                                                                                                                  'out_octets': '26214887731213',
                                                                                                                  'out_ucast_pkts': '1419317475',
                                                                                                                  'poller_hash': 'MkVEOUQwcGVlcmludGZwb24gNzQ='},
                                                                                                          {       'in_nucast_pkts': '4074',
                                                                                                                  'in_octets': '2125191094',
                                                                                                                  'in_ucast_pkts': '9708788',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1100054',
                                                                                                                  'out_octets': '12179722366',
                                                                                                                  'out_ucast_pkts': '13469805',
                                                                                                                  'poller_hash': 'NDE1MzBwZWVyaW50ZnBvbiA3NQ=='},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '1768619',
                                                                                                                  'in_ucast_pkts': '4485',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2460',
                                                                                                                  'out_octets': '14303731',
                                                                                                                  'out_ucast_pkts': '12300',
                                                                                                                  'poller_hash': 'NjQwQjRGcGVlcmludGZwb24gODc='},
                                                                                                          {       'in_nucast_pkts': '771797',
                                                                                                                  'in_octets': '115229887604',
                                                                                                                  'in_ucast_pkts': '129184341',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386374',
                                                                                                                  'out_octets': '150720910231',
                                                                                                                  'out_ucast_pkts': '1035254528667',
                                                                                                                  'poller_hash': 'RjFGOHBlZXJpbnRmcG9uIDEwNw=='},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '58011461589',
                                                                                                                  'in_ucast_pkts': '232174000',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1100028',
                                                                                                                  'out_octets': '1098910241265',
                                                                                                                  'out_ucast_pkts': '841759606',
                                                                                                                  'poller_hash': 'MzhGMUZEcGVlcmludGZwb24gMTA5'},
                                                                                                          {       'in_nucast_pkts': '4971',
                                                                                                                  'in_octets': '62217170777',
                                                                                                                  'in_ucast_pkts': '128864785',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1099432',
                                                                                                                  'out_octets': '416820855431',
                                                                                                                  'out_ucast_pkts': '346127511',
                                                                                                                  'poller_hash': 'MjVEOTM0cGVlcmludGZwb24gMTEw'},
                                                                                                          {       'in_nucast_pkts': '17046341',
                                                                                                                  'in_octets': '120771042419',
                                                                                                                  'in_ucast_pkts': '449155485',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13117920469',
                                                                                                                  'out_octets': '18492475385804',
                                                                                                                  'out_ucast_pkts': '978905359',
                                                                                                                  'poller_hash': 'NTVFMTIzcGVlcmludGZwb24gMTEx'},
                                                                                                          {       'in_nucast_pkts': '4918344',
                                                                                                                  'in_octets': '7262840385',
                                                                                                                  'in_ucast_pkts': '20199630',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6087535562',
                                                                                                                  'out_octets': '8131122821961',
                                                                                                                  'out_ucast_pkts': '65215871',
                                                                                                                  'poller_hash': 'MTk5OUM1cGVlcmludGZwb24gMTEy'},
                                                                                                          {       'in_nucast_pkts': '144',
                                                                                                                  'in_octets': '1646891',
                                                                                                                  'in_ucast_pkts': '7968',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2474',
                                                                                                                  'out_octets': '1229947',
                                                                                                                  'out_ucast_pkts': '7384',
                                                                                                                  'poller_hash': 'NDU1NjczcGVlcmludGZwb24gMTEz'},
                                                                                                          {       'in_nucast_pkts': '1478',
                                                                                                                  'in_octets': '51950219',
                                                                                                                  'in_ucast_pkts': '688591',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4839',
                                                                                                                  'out_octets': '59972785',
                                                                                                                  'out_ucast_pkts': '865621',
                                                                                                                  'poller_hash': 'QTlDOEY5cGVlcmludGZwb24gMTE0'},
                                                                                                          {       'in_nucast_pkts': '2330',
                                                                                                                  'in_octets': '2170596',
                                                                                                                  'in_ucast_pkts': '6028',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5356676',
                                                                                                                  'out_octets': '7065998465',
                                                                                                                  'out_ucast_pkts': '7667',
                                                                                                                  'poller_hash': 'MkZDQzM4cGVlcmludGZwb24gMTc2'},
                                                                                                          {       'in_nucast_pkts': '14',
                                                                                                                  'in_octets': '1677003',
                                                                                                                  'in_ucast_pkts': '5536',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3621',
                                                                                                                  'out_octets': '2702604',
                                                                                                                  'out_ucast_pkts': '4829',
                                                                                                                  'poller_hash': 'QzgyMTMxcGVlcmludGZwb24gMTYxNjU3'},
                                                                                                          {       'in_nucast_pkts': '152',
                                                                                                                  'in_octets': '2270507',
                                                                                                                  'in_ucast_pkts': '10372',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5885',
                                                                                                                  'out_octets': '3847837',
                                                                                                                  'out_ucast_pkts': '10691',
                                                                                                                  'poller_hash': 'QzgzQjk3cGVlcmludGZwb24gMTcwNzEy'},
                                                                                                          {       'in_nucast_pkts': '4772196',
                                                                                                                  'in_octets': '1546502614',
                                                                                                                  'in_ucast_pkts': '5853370',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14034473257',
                                                                                                                  'out_octets': '18674366632405',
                                                                                                                  'out_ucast_pkts': '4304423',
                                                                                                                  'poller_hash': 'QzgxQ0JFcGVlcmludGZwb24gMjA2Njgw'},
                                                                                                          {       'in_nucast_pkts': '1729',
                                                                                                                  'in_octets': '26637567874',
                                                                                                                  'in_ucast_pkts': '158650509',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9326112',
                                                                                                                  'out_octets': '1094810714962',
                                                                                                                  'out_ucast_pkts': '787464700',
                                                                                                                  'poller_hash': 'MTE5NTE1MXBlZXJpbnRmcG9uIDIxNDYyMA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '653527657019',
                                                                                         'out_octets': '1147706645361438',
                                                                                         'out_ucast_pkts': '200366150610',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzE=',
                                                                                         'pons': [       {       'id': '1/1',
                                                                                                                 'links': [       {       'connected_time': '19405459',
                                                                                                                                          'fiber_length': 1957,
                                                                                                                                          'poller_hash': 'MzIyOTAxcGVlcnBvbnBvbiAz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6503',
                                                                                                                                          'fiber_length': 1818,
                                                                                                                                          'poller_hash': 'OTU2RjA0cGVlcnBvbnBvbiAyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6535',
                                                                                                                                          'fiber_length': 1840,
                                                                                                                                          'poller_hash': 'MUZDNEVGcGVlcnBvbnBvbiA3Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '19390586',
                                                                                                                                          'fiber_length': 1895,
                                                                                                                                          'poller_hash': 'NTVGQkE1cGVlcnBvbnBvbiA3Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '19390423',
                                                                                                                                          'fiber_length': 1848,
                                                                                                                                          'poller_hash': 'MkVEOUQwcGVlcnBvbnBvbiA3NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '3934507',
                                                                                                                                          'fiber_length': 1837,
                                                                                                                                          'poller_hash': 'NDE1MzBwZWVycG9ucG9uIDc1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6550',
                                                                                                                                          'fiber_length': 1476,
                                                                                                                                          'poller_hash': 'NjQwQjRGcGVlcnBvbnBvbiA4Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '19390022',
                                                                                                                                          'fiber_length': 1677,
                                                                                                                                          'poller_hash': 'RjFGOHBlZXJwb25wb24gMTA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '3934557',
                                                                                                                                          'fiber_length': 1731,
                                                                                                                                          'poller_hash': 'MzhGMUZEcGVlcnBvbnBvbiAxMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '3934539',
                                                                                                                                          'fiber_length': 1740,
                                                                                                                                          'poller_hash': 'MjVEOTM0cGVlcnBvbnBvbiAxMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '19390195',
                                                                                                                                          'fiber_length': 1735,
                                                                                                                                          'poller_hash': 'NTVFMTIzcGVlcnBvbnBvbiAxMTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '3934592',
                                                                                                                                          'fiber_length': 1714,
                                                                                                                                          'poller_hash': 'MTk5OUM1cGVlcnBvbnBvbiAxMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6561',
                                                                                                                                          'fiber_length': 1670,
                                                                                                                                          'poller_hash': 'NDU1NjczcGVlcnBvbnBvbiAxMTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6570',
                                                                                                                                          'fiber_length': 1876,
                                                                                                                                          'poller_hash': 'QTlDOEY5cGVlcnBvbnBvbiAxMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6594',
                                                                                                                                          'fiber_length': 1677,
                                                                                                                                          'poller_hash': 'MkZDQzM4cGVlcnBvbnBvbiAxNzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6720',
                                                                                                                                          'fiber_length': 1800,
                                                                                                                                          'poller_hash': 'QzgyMTMxcGVlcnBvbnBvbiAxNjE2NTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '6725',
                                                                                                                                          'fiber_length': 1526,
                                                                                                                                          'poller_hash': 'QzgzQjk3cGVlcnBvbnBvbiAxNzA3MTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '19405627',
                                                                                                                                          'fiber_length': 1970,
                                                                                                                                          'poller_hash': 'QzgxQ0JFcGVlcnBvbnBvbiAyMDY2ODA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697},
                                                                                                                                  {       'connected_time': '18078923',
                                                                                                                                          'fiber_length': 1831,
                                                                                                                                          'poller_hash': 'MTE5NTE1MXBlZXJwb25wb24gMjE0NjIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.697}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/1',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/2',
                                                                                         'in_discards': '3126',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17072804',
                                                                                         'in_octets': '16065984389647',
                                                                                         'in_ucast_pkts': '84749664772',
                                                                                         'links': [       {       'in_nucast_pkts': '24905017',
                                                                                                                  'in_octets': '1725857808563',
                                                                                                                  'in_ucast_pkts': '2754254689',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '30816406695',
                                                                                                                  'out_octets': '47150047846312',
                                                                                                                  'out_ucast_pkts': '4766686018',
                                                                                                                  'poller_hash': 'M0ZCMzVEcGVlcmludGZwb24gMjg='},
                                                                                                          {       'in_nucast_pkts': '10',
                                                                                                                  'in_octets': '67191506',
                                                                                                                  'in_ucast_pkts': '673202',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '117',
                                                                                                                  'out_octets': '4260141010',
                                                                                                                  'out_ucast_pkts': '2842082',
                                                                                                                  'poller_hash': 'QzU3Q0RwZWVyaW50ZnBvbiA0OQ=='},
                                                                                                          {       'in_nucast_pkts': '24245164',
                                                                                                                  'in_octets': '29966802131',
                                                                                                                  'in_ucast_pkts': '74110193',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '25262168755',
                                                                                                                  'out_octets': '34240677910116',
                                                                                                                  'out_ucast_pkts': '184700328',
                                                                                                                  'poller_hash': 'QkYyMzRCcGVlcmludGZwb24gMTE2'},
                                                                                                          {       'in_nucast_pkts': '10182429',
                                                                                                                  'in_octets': '107416091887',
                                                                                                                  'in_ucast_pkts': '359487562',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2738549422',
                                                                                                                  'out_octets': '4169320638795',
                                                                                                                  'out_ucast_pkts': '1119353210',
                                                                                                                  'poller_hash': 'MkM5RUQ0cGVlcmludGZwb24gMTE3'},
                                                                                                          {       'in_nucast_pkts': '11',
                                                                                                                  'in_octets': '955099',
                                                                                                                  'in_ucast_pkts': '1177',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5940',
                                                                                                                  'out_octets': '647993',
                                                                                                                  'out_ucast_pkts': '1489',
                                                                                                                  'poller_hash': 'QzgzQjk4cGVlcmludGZwb24gMTcxNzA5'},
                                                                                                          {       'in_nucast_pkts': '3838',
                                                                                                                  'in_octets': '6973039',
                                                                                                                  'in_ucast_pkts': '28443',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9375833',
                                                                                                                  'out_octets': '12391258919',
                                                                                                                  'out_ucast_pkts': '91264',
                                                                                                                  'poller_hash': 'MTE5NTFBOXBlZXJpbnRmcG9uIDIxNjAwOQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '709141466335',
                                                                                         'out_octets': '1188027186317738',
                                                                                         'out_ucast_pkts': '190345644998',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzI=',
                                                                                         'pons': [       {       'id': '1/2',
                                                                                                                 'links': [       {       'connected_time': '19390357',
                                                                                                                                          'fiber_length': 1169,
                                                                                                                                          'poller_hash': 'M0ZCMzVEcGVlcnBvbnBvbiAyOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798},
                                                                                                                                  {       'connected_time': '6522',
                                                                                                                                          'fiber_length': 1162,
                                                                                                                                          'poller_hash': 'QzU3Q0RwZWVycG9ucG9uIDQ5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798},
                                                                                                                                  {       'connected_time': '19390244',
                                                                                                                                          'fiber_length': 1117,
                                                                                                                                          'poller_hash': 'QkYyMzRCcGVlcnBvbnBvbiAxMTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798},
                                                                                                                                  {       'connected_time': '19390274',
                                                                                                                                          'fiber_length': 1104,
                                                                                                                                          'poller_hash': 'MkM5RUQ0cGVlcnBvbnBvbiAxMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798},
                                                                                                                                  {       'connected_time': '6727',
                                                                                                                                          'fiber_length': 499,
                                                                                                                                          'poller_hash': 'QzgzQjk4cGVlcnBvbnBvbiAxNzE3MDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798},
                                                                                                                                  {       'connected_time': '6736',
                                                                                                                                          'fiber_length': 1189,
                                                                                                                                          'poller_hash': 'MTE5NTFBOXBlZXJwb25wb24gMjE2MDA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.798}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/2',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/3',
                                                                                         'in_discards': '20186',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '4561798',
                                                                                         'in_octets': '16196359150521',
                                                                                         'in_ucast_pkts': '78693101583',
                                                                                         'links': [       {       'in_nucast_pkts': '9',
                                                                                                                  'in_octets': '3116759',
                                                                                                                  'in_ucast_pkts': '9732',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5713',
                                                                                                                  'out_octets': '21385516',
                                                                                                                  'out_ucast_pkts': '19880',
                                                                                                                  'poller_hash': 'ODcyNDFCcGVlcmludGZwb24gMzE='},
                                                                                                          {       'in_nucast_pkts': '121',
                                                                                                                  'in_octets': '9489788',
                                                                                                                  'in_ucast_pkts': '29558',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5617',
                                                                                                                  'out_octets': '21335116',
                                                                                                                  'out_ucast_pkts': '33844',
                                                                                                                  'poller_hash': 'QjUxMEUycGVlcmludGZwb24gMzY='},
                                                                                                          {       'in_nucast_pkts': '4940713',
                                                                                                                  'in_octets': '24088163307',
                                                                                                                  'in_ucast_pkts': '217954469',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1167923318',
                                                                                                                  'out_octets': '2870596401544',
                                                                                                                  'out_ucast_pkts': '993942311',
                                                                                                                  'poller_hash': 'MzIxMDMzcGVlcmludGZwb24gNDQ='},
                                                                                                          {       'in_nucast_pkts': '302866',
                                                                                                                  'in_octets': '601220944816',
                                                                                                                  'in_ucast_pkts': '1477766145',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10016060',
                                                                                                                  'out_octets': '4826003747146',
                                                                                                                  'out_ucast_pkts': '3577019255',
                                                                                                                  'poller_hash': 'QTlDNzg2cGVlcmludGZwb24gODU='},
                                                                                                          {       'in_nucast_pkts': '4046',
                                                                                                                  'in_octets': '61144526811',
                                                                                                                  'in_ucast_pkts': '511222990',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386233',
                                                                                                                  'out_octets': '1962944481468',
                                                                                                                  'out_ucast_pkts': '5673115796',
                                                                                                                  'poller_hash': 'M0NGNEFwZWVyaW50ZnBvbiAxMjE='},
                                                                                                          {       'in_nucast_pkts': '17246',
                                                                                                                  'in_octets': '405453546508',
                                                                                                                  'in_ucast_pkts': '3074058263',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1384716',
                                                                                                                  'out_octets': '10889826294103',
                                                                                                                  'out_ucast_pkts': '12003556838',
                                                                                                                  'poller_hash': 'NDE1QjBwZWVyaW50ZnBvbiAxMjI='},
                                                                                                          {       'in_nucast_pkts': '6930',
                                                                                                                  'in_octets': '38381220809',
                                                                                                                  'in_ucast_pkts': '98348307',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1367399',
                                                                                                                  'out_octets': '577357822511',
                                                                                                                  'out_ucast_pkts': '457969456',
                                                                                                                  'poller_hash': 'NzIyMDY1cGVlcmludGZwb24gMTI0'},
                                                                                                          {       'in_nucast_pkts': '146267',
                                                                                                                  'in_octets': '100199613789',
                                                                                                                  'in_ucast_pkts': '499458682',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386805',
                                                                                                                  'out_octets': '2766932658742',
                                                                                                                  'out_ucast_pkts': '2068951490',
                                                                                                                  'poller_hash': 'NEUzNkE4cGVlcmludGZwb24gMTI2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MkU5MTRBcGVlcmludGZwb24gMTM1'},
                                                                                                          {       'in_nucast_pkts': '2685545',
                                                                                                                  'in_octets': '36905156693',
                                                                                                                  'in_ucast_pkts': '133032087',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1604450293',
                                                                                                                  'out_octets': '2791936920109',
                                                                                                                  'out_ucast_pkts': '697322558',
                                                                                                                  'poller_hash': 'ODcyNTM1cGVlcmludGZwb24gMTM2'},
                                                                                                          {       'in_nucast_pkts': '14',
                                                                                                                  'in_octets': '27403847',
                                                                                                                  'in_ucast_pkts': '51305',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2479',
                                                                                                                  'out_octets': '9753789',
                                                                                                                  'out_ucast_pkts': '34338',
                                                                                                                  'poller_hash': 'MTMwMDlBcGVlcmludGZwb24gMTM4'},
                                                                                                          {       'in_nucast_pkts': '32',
                                                                                                                  'in_octets': '13575608995',
                                                                                                                  'in_ucast_pkts': '161357185',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1099953',
                                                                                                                  'out_octets': '402269755613',
                                                                                                                  'out_ucast_pkts': '275161768',
                                                                                                                  'poller_hash': 'RjIzQXBlZXJpbnRmcG9uIDEzOQ=='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'M0NGMzNwZWVyaW50ZnBvbiAxNDA='},
                                                                                                          {       'in_nucast_pkts': '137545',
                                                                                                                  'in_octets': '599234933988',
                                                                                                                  'in_ucast_pkts': '1561093028',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386729',
                                                                                                                  'out_octets': '8048291992664',
                                                                                                                  'out_ucast_pkts': '6106967496',
                                                                                                                  'poller_hash': 'MzI5NjQycGVlcmludGZwb24gMTQy'},
                                                                                                          {       'in_nucast_pkts': '348985',
                                                                                                                  'in_octets': '170551943099',
                                                                                                                  'in_ucast_pkts': '4996031275',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386183',
                                                                                                                  'out_octets': '3422787394021',
                                                                                                                  'out_ucast_pkts': '6893084140',
                                                                                                                  'poller_hash': 'NDE4QUNwZWVyaW50ZnBvbiAxNDM='},
                                                                                                          {       'in_nucast_pkts': '18753',
                                                                                                                  'in_octets': '98908602951',
                                                                                                                  'in_ucast_pkts': '682698886',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386215',
                                                                                                                  'out_octets': '3575790593083',
                                                                                                                  'out_ucast_pkts': '6815985420',
                                                                                                                  'poller_hash': 'M0NDMDhwZWVyaW50ZnBvbiAxNDQ='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'RjEwNnBlZXJpbnRmcG9uIDE0NQ=='},
                                                                                                          {       'in_nucast_pkts': '105893',
                                                                                                                  'in_octets': '8132787662',
                                                                                                                  'in_ucast_pkts': '42189952',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1099951',
                                                                                                                  'out_octets': '248681671933',
                                                                                                                  'out_ucast_pkts': '181820855',
                                                                                                                  'poller_hash': 'QzU4NkJwZWVyaW50ZnBvbiAxNDY='},
                                                                                                          {       'in_nucast_pkts': '86723',
                                                                                                                  'in_octets': '285029426390',
                                                                                                                  'in_ucast_pkts': '649496464',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1387831',
                                                                                                                  'out_octets': '3507390340013',
                                                                                                                  'out_ucast_pkts': '6889596465',
                                                                                                                  'poller_hash': 'M0NGNEVwZWVyaW50ZnBvbiAxNDg='},
                                                                                                          {       'in_nucast_pkts': '9683',
                                                                                                                  'in_octets': '52833084913',
                                                                                                                  'in_ucast_pkts': '336634022',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386144',
                                                                                                                  'out_octets': '2615194154140',
                                                                                                                  'out_ucast_pkts': '1824473385',
                                                                                                                  'poller_hash': 'MTk5QTI1cGVlcmludGZwb24gMTUw'},
                                                                                                          {       'in_nucast_pkts': '11002152',
                                                                                                                  'in_octets': '50861917711',
                                                                                                                  'in_ucast_pkts': '142857423',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12349656799',
                                                                                                                  'out_octets': '16616507692124',
                                                                                                                  'out_ucast_pkts': '520423219',
                                                                                                                  'poller_hash': 'MTk5QTM5cGVlcmludGZwb24gMTUx'},
                                                                                                          {       'in_nucast_pkts': '28339',
                                                                                                                  'in_octets': '1377698258',
                                                                                                                  'in_ucast_pkts': '3608864',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11090259',
                                                                                                                  'out_octets': '9952070738',
                                                                                                                  'out_ucast_pkts': '11547558',
                                                                                                                  'poller_hash': 'QzgzMjEycGVlcmludGZwb24gMTUz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTM1MzhwZWVyaW50ZnBvbiAxNTQ='},
                                                                                                          {       'in_nucast_pkts': '22382442',
                                                                                                                  'in_octets': '563047437996',
                                                                                                                  'in_ucast_pkts': '927589655',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '31291058047',
                                                                                                                  'out_octets': '45925718639665',
                                                                                                                  'out_ucast_pkts': '3168337373',
                                                                                                                  'poller_hash': 'NzFEODBBcGVlcmludGZwb24gMTU1'},
                                                                                                          {       'in_nucast_pkts': '5079',
                                                                                                                  'in_octets': '5395898',
                                                                                                                  'in_ucast_pkts': '26563',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '926199',
                                                                                                                  'out_octets': '1051863040',
                                                                                                                  'out_ucast_pkts': '38335',
                                                                                                                  'poller_hash': 'QjBBMkEwcGVlcmludGZwb24gMTUwODcy'},
                                                                                                          {       'in_nucast_pkts': '18260231',
                                                                                                                  'in_octets': '229166762218',
                                                                                                                  'in_ucast_pkts': '1282483864',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '16612994304',
                                                                                                                  'out_octets': '27534570097849',
                                                                                                                  'out_ucast_pkts': '3832164023',
                                                                                                                  'poller_hash': 'QkYyMUU4cGVlcmludGZwb24gMTY0MDYz'},
                                                                                                          {       'in_nucast_pkts': '6',
                                                                                                                  'in_octets': '123004',
                                                                                                                  'in_ucast_pkts': '1421',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3627',
                                                                                                                  'out_octets': '568290',
                                                                                                                  'out_ucast_pkts': '1366',
                                                                                                                  'poller_hash': 'QzgzQkJCcGVlcmludGZwb24gMTcyMzA5'},
                                                                                                          {       'in_nucast_pkts': '5021835',
                                                                                                                  'in_octets': '28903638561',
                                                                                                                  'in_ucast_pkts': '206091604',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7459536351',
                                                                                                                  'out_octets': '10326906505788',
                                                                                                                  'out_ucast_pkts': '454034474',
                                                                                                                  'poller_hash': 'QzgxNUYxcGVlcmludGZwb24gMjA3MzUy'},
                                                                                                          {       'in_nucast_pkts': '11',
                                                                                                                  'in_octets': '5612380',
                                                                                                                  'in_ucast_pkts': '15063',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5947',
                                                                                                                  'out_octets': '9258942',
                                                                                                                  'out_ucast_pkts': '15368',
                                                                                                                  'poller_hash': 'MTFCMjJCRHBlZXJpbnRmcG9uIDIxMjA4OA=='},
                                                                                                          {       'in_nucast_pkts': '8753',
                                                                                                                  'in_octets': '40757090866',
                                                                                                                  'in_ucast_pkts': '355013977',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '78618',
                                                                                                                  'out_octets': '1612502543011',
                                                                                                                  'out_ucast_pkts': '1125759672',
                                                                                                                  'poller_hash': 'NDcxQzYzcGVlcmludGZwb24gMjI0Njc5'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '469978994322',
                                                                                         'out_octets': '993447312171218',
                                                                                         'out_ucast_pkts': '255187014744',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzM=',
                                                                                         'pons': [       {       'id': '1/3',
                                                                                                                 'links': [       {       'connected_time': '6513',
                                                                                                                                          'fiber_length': 1138,
                                                                                                                                          'poller_hash': 'ODcyNDFCcGVlcnBvbnBvbiAzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6513',
                                                                                                                                          'fiber_length': 1009,
                                                                                                                                          'poller_hash': 'QjUxMEUycGVlcnBvbnBvbiAzNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6717227',
                                                                                                                                          'fiber_length': 982,
                                                                                                                                          'poller_hash': 'MzIxMDMzcGVlcnBvbnBvbiA0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19405583',
                                                                                                                                          'fiber_length': 1125,
                                                                                                                                          'poller_hash': 'QTlDNzg2cGVlcnBvbnBvbiA4NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390157',
                                                                                                                                          'fiber_length': 1090,
                                                                                                                                          'poller_hash': 'M0NGNEFwZWVycG9ucG9uIDEyMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390138',
                                                                                                                                          'fiber_length': 1070,
                                                                                                                                          'poller_hash': 'NDE1QjBwZWVycG9ucG9uIDEyMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390454',
                                                                                                                                          'fiber_length': 1128,
                                                                                                                                          'poller_hash': 'NzIyMDY1cGVlcnBvbnBvbiAxMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390358',
                                                                                                                                          'fiber_length': 1156,
                                                                                                                                          'poller_hash': 'NEUzNkE4cGVlcnBvbnBvbiAxMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390365',
                                                                                                                                          'fiber_length': 956,
                                                                                                                                          'poller_hash': 'MkU5MTRBcGVlcnBvbnBvbiAxMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '15001651',
                                                                                                                                          'fiber_length': 1017,
                                                                                                                                          'poller_hash': 'ODcyNTM1cGVlcnBvbnBvbiAxMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6576',
                                                                                                                                          'fiber_length': 958,
                                                                                                                                          'poller_hash': 'MTMwMDlBcGVlcnBvbnBvbiAxMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '3934596',
                                                                                                                                          'fiber_length': 825,
                                                                                                                                          'poller_hash': 'RjIzQXBlZXJwb25wb24gMTM5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'poller_hash': 'M0NGMzNwZWVycG9ucG9uIDE0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390523',
                                                                                                                                          'fiber_length': 837,
                                                                                                                                          'poller_hash': 'MzI5NjQycGVlcnBvbnBvbiAxNDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390309',
                                                                                                                                          'fiber_length': 755,
                                                                                                                                          'poller_hash': 'NDE4QUNwZWVycG9ucG9uIDE0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390248',
                                                                                                                                          'fiber_length': 708,
                                                                                                                                          'poller_hash': 'M0NDMDhwZWVycG9ucG9uIDE0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'poller_hash': 'RjEwNnBlZXJwb25wb24gMTQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '3934552',
                                                                                                                                          'fiber_length': 726,
                                                                                                                                          'poller_hash': 'QzU4NkJwZWVycG9ucG9uIDE0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390238',
                                                                                                                                          'fiber_length': 571,
                                                                                                                                          'poller_hash': 'M0NGNEVwZWVycG9ucG9uIDE0OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390434',
                                                                                                                                          'fiber_length': 614,
                                                                                                                                          'poller_hash': 'MTk5QTI1cGVlcnBvbnBvbiAxNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390383',
                                                                                                                                          'fiber_length': 751,
                                                                                                                                          'poller_hash': 'MTk5QTM5cGVlcnBvbnBvbiAxNTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19405243',
                                                                                                                                          'fiber_length': 742,
                                                                                                                                          'poller_hash': 'QzgzMjEycGVlcnBvbnBvbiAxNTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '3934466',
                                                                                                                                          'fiber_length': 608,
                                                                                                                                          'poller_hash': 'MTM1MzhwZWVycG9ucG9uIDE1NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390331',
                                                                                                                                          'fiber_length': 672,
                                                                                                                                          'poller_hash': 'NzFEODBBcGVlcnBvbnBvbiAxNTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6714',
                                                                                                                                          'fiber_length': 1024,
                                                                                                                                          'poller_hash': 'QjBBMkEwcGVlcnBvbnBvbiAxNTA4NzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19390601',
                                                                                                                                          'fiber_length': 682,
                                                                                                                                          'poller_hash': 'QkYyMUU4cGVlcnBvbnBvbiAxNjQwNjM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6729',
                                                                                                                                          'fiber_length': 1206,
                                                                                                                                          'poller_hash': 'QzgzQkJCcGVlcnBvbnBvbiAxNzIzMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '19405770',
                                                                                                                                          'fiber_length': 930,
                                                                                                                                          'poller_hash': 'QzgxNUYxcGVlcnBvbnBvbiAyMDczNTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '6733',
                                                                                                                                          'fiber_length': 855,
                                                                                                                                          'poller_hash': 'MTFCMjJCRHBlZXJwb25wb24gMjEyMDg4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737},
                                                                                                                                  {       'connected_time': '9408957',
                                                                                                                                          'fiber_length': 657,
                                                                                                                                          'poller_hash': 'NDcxQzYzcGVlcnBvbnBvbiAyMjQ2Nzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/3',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/4',
                                                                                         'in_discards': '175610',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1843041',
                                                                                         'in_octets': '12913142133057',
                                                                                         'in_ucast_pkts': '52147557426',
                                                                                         'links': [       {       'in_nucast_pkts': '14766525',
                                                                                                                  'in_octets': '4667171082',
                                                                                                                  'in_ucast_pkts': '17501186',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '34375659601',
                                                                                                                  'out_octets': '45437220166811',
                                                                                                                  'out_ucast_pkts': '12946276',
                                                                                                                  'poller_hash': 'MzIyM0Y5cGVlcmludGZwb24gOQ=='},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '64123943',
                                                                                                                  'in_ucast_pkts': '230121',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '120',
                                                                                                                  'out_octets': '2345339333',
                                                                                                                  'out_ucast_pkts': '1639823',
                                                                                                                  'poller_hash': 'M0FERDZFcGVlcmludGZwb24gMTc='},
                                                                                                          {       'in_nucast_pkts': '18634',
                                                                                                                  'in_octets': '704042675369',
                                                                                                                  'in_ucast_pkts': '2298933884',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '162619',
                                                                                                                  'out_octets': '6895644341453',
                                                                                                                  'out_ucast_pkts': '5080391620',
                                                                                                                  'poller_hash': 'NEQ0MUY0cGVlcmludGZwb24gMjk='},
                                                                                                          {       'in_nucast_pkts': '16022086',
                                                                                                                  'in_octets': '612880030550',
                                                                                                                  'in_ucast_pkts': '2363601698',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8912643048',
                                                                                                                  'out_octets': '21544993819067',
                                                                                                                  'out_ucast_pkts': '7090104502',
                                                                                                                  'poller_hash': 'Mzk2MUE5cGVlcmludGZwb24gNTA='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MUM1RENGcGVlcmludGZwb24gOTM='},
                                                                                                          {       'in_nucast_pkts': '2875',
                                                                                                                  'in_octets': '3950815',
                                                                                                                  'in_ucast_pkts': '13008',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1841066',
                                                                                                                  'out_octets': '2276297323',
                                                                                                                  'out_ucast_pkts': '12667',
                                                                                                                  'poller_hash': 'QzU4NTBwZWVyaW50ZnBvbiAxNTc='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODcyNDY2cGVlcmludGZwb24gMTU4'},
                                                                                                          {       'in_nucast_pkts': '16055108',
                                                                                                                  'in_octets': '273455373420',
                                                                                                                  'in_ucast_pkts': '1342556711',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9446551768',
                                                                                                                  'out_octets': '16835443332332',
                                                                                                                  'out_ucast_pkts': '3442710019',
                                                                                                                  'poller_hash': 'NTVGQkQ2cGVlcmludGZwb24gMTU5'},
                                                                                                          {       'in_nucast_pkts': '8184',
                                                                                                                  'in_octets': '61853897867',
                                                                                                                  'in_ucast_pkts': '580481683',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1390005',
                                                                                                                  'out_octets': '2539153668262',
                                                                                                                  'out_ucast_pkts': '1036867013103',
                                                                                                                  'poller_hash': 'MTMwM0RwZWVyaW50ZnBvbiAxNjA='},
                                                                                                          {       'in_nucast_pkts': '3682257',
                                                                                                                  'in_octets': '55641856044',
                                                                                                                  'in_ucast_pkts': '174418514',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1114413728',
                                                                                                                  'out_octets': '1757347867191',
                                                                                                                  'out_ucast_pkts': '318037054',
                                                                                                                  'poller_hash': 'MTk5QTFCcGVlcmludGZwb24gMTYx'},
                                                                                                          {       'in_nucast_pkts': '153896',
                                                                                                                  'in_octets': '106273570681',
                                                                                                                  'in_ucast_pkts': '570938064',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386681',
                                                                                                                  'out_octets': '3106788220373',
                                                                                                                  'out_ucast_pkts': '2203513848',
                                                                                                                  'poller_hash': 'MjQ4QUU2cGVlcmludGZwb24gMTYy'},
                                                                                                          {       'in_nucast_pkts': '3940888',
                                                                                                                  'in_octets': '244620591467',
                                                                                                                  'in_ucast_pkts': '1301187165',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2772231',
                                                                                                                  'out_octets': '6399897404892',
                                                                                                                  'out_ucast_pkts': '4681323209',
                                                                                                                  'poller_hash': 'MTYxMDIxcGVlcmludGZwb24gMTYz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MjQ4QUQ3cGVlcmludGZwb24gMTY0'},
                                                                                                          {       'in_nucast_pkts': '63434',
                                                                                                                  'in_octets': '93619764910',
                                                                                                                  'in_ucast_pkts': '376057059',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386092',
                                                                                                                  'out_octets': '798574098607',
                                                                                                                  'out_ucast_pkts': '725262283',
                                                                                                                  'poller_hash': 'Mzc4OEMxcGVlcmludGZwb24gMTY1'},
                                                                                                          {       'in_nucast_pkts': '25',
                                                                                                                  'in_octets': '40387247',
                                                                                                                  'in_ucast_pkts': '76758',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2486',
                                                                                                                  'out_octets': '111954275',
                                                                                                                  'out_ucast_pkts': '99398',
                                                                                                                  'poller_hash': 'MkZDQ0UxcGVlcmludGZwb24gMTY2'},
                                                                                                          {       'in_nucast_pkts': '5078939',
                                                                                                                  'in_octets': '103510214833',
                                                                                                                  'in_ucast_pkts': '501449826',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12663043525',
                                                                                                                  'out_octets': '19993512958248',
                                                                                                                  'out_ucast_pkts': '2284179464',
                                                                                                                  'poller_hash': 'QzgzQkFFcGVlcmludGZwb24gMTY2MTIx'},
                                                                                                          {       'in_nucast_pkts': '469',
                                                                                                                  'in_octets': '9224060',
                                                                                                                  'in_ucast_pkts': '11359',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3635',
                                                                                                                  'out_octets': '1457864',
                                                                                                                  'out_ucast_pkts': '9158',
                                                                                                                  'poller_hash': 'QzgxRDZGcGVlcmludGZwb24gMjExNjUz'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '331061945463',
                                                                                         'out_octets': '650061634981684',
                                                                                         'out_ucast_pkts': '148022435795',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzQ=',
                                                                                         'pons': [       {       'id': '1/4',
                                                                                                                 'links': [       {       'connected_time': '19405519',
                                                                                                                                          'fiber_length': 662,
                                                                                                                                          'poller_hash': 'MzIyM0Y5cGVlcnBvbnBvbiA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '6500',
                                                                                                                                          'fiber_length': 519,
                                                                                                                                          'poller_hash': 'M0FERDZFcGVlcnBvbnBvbiAxNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390538',
                                                                                                                                          'fiber_length': 545,
                                                                                                                                          'poller_hash': 'NEQ0MUY0cGVlcnBvbnBvbiAyOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390525',
                                                                                                                                          'fiber_length': 536,
                                                                                                                                          'poller_hash': 'Mzk2MUE5cGVlcnBvbnBvbiA1MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390348',
                                                                                                                                          'fiber_length': 166,
                                                                                                                                          'poller_hash': 'MUM1RENGcGVlcnBvbnBvbiA5Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '6585',
                                                                                                                                          'fiber_length': 593,
                                                                                                                                          'poller_hash': 'QzU4NTBwZWVycG9ucG9uIDE1Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'poller_hash': 'ODcyNDY2cGVlcnBvbnBvbiAxNTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390443',
                                                                                                                                          'fiber_length': 484,
                                                                                                                                          'poller_hash': 'NTVGQkQ2cGVlcnBvbnBvbiAxNTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19389854',
                                                                                                                                          'fiber_length': 358,
                                                                                                                                          'poller_hash': 'MTMwM0RwZWVycG9ucG9uIDE2MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '3934641',
                                                                                                                                          'fiber_length': 539,
                                                                                                                                          'poller_hash': 'MTk5QTFCcGVlcnBvbnBvbiAxNjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390507',
                                                                                                                                          'fiber_length': 573,
                                                                                                                                          'poller_hash': 'MjQ4QUU2cGVlcnBvbnBvbiAxNjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390558',
                                                                                                                                          'fiber_length': 514,
                                                                                                                                          'poller_hash': 'MTYxMDIxcGVlcnBvbnBvbiAxNjM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '3934638',
                                                                                                                                          'fiber_length': 582,
                                                                                                                                          'poller_hash': 'MjQ4QUQ3cGVlcnBvbnBvbiAxNjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19390412',
                                                                                                                                          'fiber_length': 612,
                                                                                                                                          'poller_hash': 'Mzc4OEMxcGVlcnBvbnBvbiAxNjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '6592',
                                                                                                                                          'fiber_length': 647,
                                                                                                                                          'poller_hash': 'MkZDQ0UxcGVlcnBvbnBvbiAxNjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '19405835',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'QzgzQkFFcGVlcnBvbnBvbiAxNjYxMjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '6733',
                                                                                                                                          'fiber_length': 1018,
                                                                                                                                          'poller_hash': 'QzgxRDZGcGVlcnBvbnBvbiAyMTE2NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/4',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/5',
                                                                                         'in_discards': '9354',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '54861940',
                                                                                         'in_octets': '34541443029974',
                                                                                         'in_ucast_pkts': '107969692978',
                                                                                         'links': [       {       'in_nucast_pkts': '76648',
                                                                                                                  'in_octets': '6706222216880',
                                                                                                                  'in_ucast_pkts': '8862398649',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6588',
                                                                                                                  'out_octets': '21029169923618',
                                                                                                                  'out_ucast_pkts': '17799433632',
                                                                                                                  'poller_hash': 'NEQ0MjUwcGVlcmludGZwb24gNg=='},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '664858',
                                                                                                                  'in_ucast_pkts': '1342',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2426',
                                                                                                                  'out_octets': '506156',
                                                                                                                  'out_ucast_pkts': '1853',
                                                                                                                  'poller_hash': 'NDNDMjFBcGVlcmludGZwb24gMTM='},
                                                                                                          {       'in_nucast_pkts': '2495',
                                                                                                                  'in_octets': '101600777213',
                                                                                                                  'in_ucast_pkts': '496716650',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '161540',
                                                                                                                  'out_octets': '1441733798363',
                                                                                                                  'out_ucast_pkts': '1061259499',
                                                                                                                  'poller_hash': 'MkZFQTAzcGVlcmludGZwb24gMjQ='},
                                                                                                          {       'in_nucast_pkts': '4037980',
                                                                                                                  'in_octets': '15760568328',
                                                                                                                  'in_ucast_pkts': '55832427',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1956936500',
                                                                                                                  'out_octets': '2706081227818',
                                                                                                                  'out_ucast_pkts': '138188864',
                                                                                                                  'poller_hash': 'NkFDMkM3cGVlcmludGZwb24gNDA='},
                                                                                                          {       'in_nucast_pkts': '358',
                                                                                                                  'in_octets': '10656018811',
                                                                                                                  'in_ucast_pkts': '42236528',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '32599',
                                                                                                                  'out_octets': '301319411713',
                                                                                                                  'out_ucast_pkts': '225977576',
                                                                                                                  'poller_hash': 'NTVERkIxcGVlcmludGZwb24gOTk='},
                                                                                                          {       'in_nucast_pkts': '20554050',
                                                                                                                  'in_octets': '1708728012025',
                                                                                                                  'in_ucast_pkts': '3264311713',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '37805846855',
                                                                                                                  'out_octets': '56109813674033',
                                                                                                                  'out_ucast_pkts': '5571141513',
                                                                                                                  'poller_hash': 'NzZFOTkwcGVlcmludGZwb24gMTgy'},
                                                                                                          {       'in_nucast_pkts': '124',
                                                                                                                  'in_octets': '7353304034',
                                                                                                                  'in_ucast_pkts': '33329601',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1099387',
                                                                                                                  'out_octets': '50215859465',
                                                                                                                  'out_ucast_pkts': '54282931',
                                                                                                                  'poller_hash': 'MTUzQzNwZWVyaW50ZnBvbiAxODM='},
                                                                                                          {       'in_nucast_pkts': '4191298',
                                                                                                                  'in_octets': '127902658074',
                                                                                                                  'in_ucast_pkts': '1673452807',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4188179',
                                                                                                                  'out_octets': '147853446342',
                                                                                                                  'out_ucast_pkts': '2143135121',
                                                                                                                  'poller_hash': 'N0ZGNXBlZXJpbnRmcG9uIDE4NQ=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MzI5NjM5cGVlcmludGZwb24gMTg3'},
                                                                                                          {       'in_nucast_pkts': '16423',
                                                                                                                  'in_octets': '783969764314',
                                                                                                                  'in_ucast_pkts': '4401458227',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1383732',
                                                                                                                  'out_octets': '12731032645353',
                                                                                                                  'out_ucast_pkts': '9920974618',
                                                                                                                  'poller_hash': 'MTk5QTAwcGVlcmludGZwb24gMTg4'},
                                                                                                          {       'in_nucast_pkts': '15383',
                                                                                                                  'in_octets': '36647451113',
                                                                                                                  'in_ucast_pkts': '129445477',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1195470',
                                                                                                                  'out_octets': '419600402448',
                                                                                                                  'out_ucast_pkts': '4619621729',
                                                                                                                  'poller_hash': 'M0NGQTBwZWVyaW50ZnBvbiAxOTA='},
                                                                                                          {       'in_nucast_pkts': '90358',
                                                                                                                  'in_octets': '155069479497',
                                                                                                                  'in_ucast_pkts': '477465281',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '161671',
                                                                                                                  'out_octets': '1935277873487',
                                                                                                                  'out_ucast_pkts': '1482722663',
                                                                                                                  'poller_hash': 'NDcxNDZFcGVlcmludGZwb24gMTkx'},
                                                                                                          {       'in_nucast_pkts': '17924465',
                                                                                                                  'in_octets': '95413601896',
                                                                                                                  'in_ucast_pkts': '479199069',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13779772295',
                                                                                                                  'out_octets': '19803353682131',
                                                                                                                  'out_ucast_pkts': '31347054441',
                                                                                                                  'poller_hash': 'NDE4QjVwZWVyaW50ZnBvbiAxOTI='},
                                                                                                          {       'in_nucast_pkts': '7521695',
                                                                                                                  'in_octets': '5386103805',
                                                                                                                  'in_ucast_pkts': '8615479107',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14603224547',
                                                                                                                  'out_octets': '19478649738920',
                                                                                                                  'out_ucast_pkts': '42988401390',
                                                                                                                  'poller_hash': 'NDE1NDlwZWVyaW50ZnBvbiAxOTQ='},
                                                                                                          {       'in_nucast_pkts': '43',
                                                                                                                  'in_octets': '41261268809',
                                                                                                                  'in_ucast_pkts': '138751939',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1239974',
                                                                                                                  'out_octets': '153499824116',
                                                                                                                  'out_ucast_pkts': '158214066',
                                                                                                                  'poller_hash': 'NEVCMTdEcGVlcmludGZwb24gMTk1'},
                                                                                                          {       'in_nucast_pkts': '18788849',
                                                                                                                  'in_octets': '30829213022',
                                                                                                                  'in_ucast_pkts': '117449246',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '27970573552',
                                                                                                                  'out_octets': '38155847999041',
                                                                                                                  'out_ucast_pkts': '377119525',
                                                                                                                  'poller_hash': 'QkYyNEI0cGVlcmludGZwb24gMTk2'},
                                                                                                          {       'in_nucast_pkts': '3093',
                                                                                                                  'in_octets': '313175202109',
                                                                                                                  'in_ucast_pkts': '1077617375',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386224',
                                                                                                                  'out_octets': '4426017396835',
                                                                                                                  'out_ucast_pkts': '3417133255',
                                                                                                                  'poller_hash': 'MkYzQUQ5cGVlcmludGZwb24gMTk3'},
                                                                                                          {       'in_nucast_pkts': '16033335',
                                                                                                                  'in_octets': '185872446437',
                                                                                                                  'in_ucast_pkts': '704132694',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13846294440',
                                                                                                                  'out_octets': '21277671333267',
                                                                                                                  'out_ucast_pkts': '2122786133',
                                                                                                                  'poller_hash': 'NzU3QkNwZWVyaW50ZnBvbiAxOTg='},
                                                                                                          {       'in_nucast_pkts': '8358',
                                                                                                                  'in_octets': '12035487568',
                                                                                                                  'in_ucast_pkts': '32274899',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11080807',
                                                                                                                  'out_octets': '95069621511',
                                                                                                                  'out_ucast_pkts': '78792194',
                                                                                                                  'poller_hash': 'QzgxMUUwcGVlcmludGZwb24gMTU3NzUz'},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '21742553599',
                                                                                                                  'in_ucast_pkts': '82110616',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3067156',
                                                                                                                  'out_octets': '164589208812',
                                                                                                                  'out_ucast_pkts': '178320166',
                                                                                                                  'poller_hash': 'QzgzQzBDcGVlcmludGZwb24gMTc0NDY0'},
                                                                                                          {       'in_nucast_pkts': '5',
                                                                                                                  'in_octets': '62860902',
                                                                                                                  'in_ucast_pkts': '453911',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3630',
                                                                                                                  'out_octets': '4864885612',
                                                                                                                  'out_ucast_pkts': '3384257',
                                                                                                                  'poller_hash': 'QzgxRTMwcGVlcmludGZwb24gMjA2NDkw'},
                                                                                                          {       'in_nucast_pkts': '118',
                                                                                                                  'in_octets': '1525385',
                                                                                                                  'in_ucast_pkts': '4087',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5896',
                                                                                                                  'out_octets': '4292994',
                                                                                                                  'out_ucast_pkts': '4935',
                                                                                                                  'poller_hash': 'MTI3NEE0M3BlZXJpbnRmcG9uIDIzNTA4Mg=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '643090205895',
                                                                                         'out_octets': '1130198444520889',
                                                                                         'out_ucast_pkts': '230891808443',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzU=',
                                                                                         'pons': [       {       'id': '1/5',
                                                                                                                 'links': [       {       'connected_time': '19390661',
                                                                                                                                          'fiber_length': 1529,
                                                                                                                                          'poller_hash': 'NEQ0MjUwcGVlcnBvbnBvbiA2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6501',
                                                                                                                                          'fiber_length': 1307,
                                                                                                                                          'poller_hash': 'NDNDMjFBcGVlcnBvbnBvbiAxMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390781',
                                                                                                                                          'fiber_length': 670,
                                                                                                                                          'poller_hash': 'MkZFQTAzcGVlcnBvbnBvbiAyNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934517',
                                                                                                                                          'fiber_length': 691,
                                                                                                                                          'poller_hash': 'NkFDMkM3cGVlcnBvbnBvbiA0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934581',
                                                                                                                                          'fiber_length': 614,
                                                                                                                                          'poller_hash': 'NTVERkIxcGVlcnBvbnBvbiA5OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390456',
                                                                                                                                          'fiber_length': 1441,
                                                                                                                                          'poller_hash': 'NzZFOTkwcGVlcnBvbnBvbiAxODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934487',
                                                                                                                                          'fiber_length': 881,
                                                                                                                                          'poller_hash': 'MTUzQzNwZWVycG9ucG9uIDE4Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19389542',
                                                                                                                                          'fiber_length': 834,
                                                                                                                                          'poller_hash': 'N0ZGNXBlZXJwb25wb24gMTg1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3190884',
                                                                                                                                          'fiber_length': 938,
                                                                                                                                          'poller_hash': 'MzI5NjM5cGVlcnBvbnBvbiAxODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390446',
                                                                                                                                          'fiber_length': 953,
                                                                                                                                          'poller_hash': 'MTk5QTAwcGVlcnBvbnBvbiAxODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6545165',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'M0NGQTBwZWVycG9ucG9uIDE5MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390788',
                                                                                                                                          'fiber_length': 578,
                                                                                                                                          'poller_hash': 'NDcxNDZFcGVlcnBvbnBvbiAxOTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390325',
                                                                                                                                          'fiber_length': 511,
                                                                                                                                          'poller_hash': 'NDE4QjVwZWVycG9ucG9uIDE5Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390404',
                                                                                                                                          'fiber_length': 705,
                                                                                                                                          'poller_hash': 'NDE1NDlwZWVycG9ucG9uIDE5NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '9534047',
                                                                                                                                          'fiber_length': 761,
                                                                                                                                          'poller_hash': 'NEVCMTdEcGVlcnBvbnBvbiAxOTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14966086',
                                                                                                                                          'fiber_length': 1360,
                                                                                                                                          'poller_hash': 'QkYyNEI0cGVlcnBvbnBvbiAxOTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390255',
                                                                                                                                          'fiber_length': 1317,
                                                                                                                                          'poller_hash': 'MkYzQUQ5cGVlcnBvbnBvbiAxOTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390894',
                                                                                                                                          'fiber_length': 1356,
                                                                                                                                          'poller_hash': 'NzU3QkNwZWVycG9ucG9uIDE5OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19405775',
                                                                                                                                          'fiber_length': 1022,
                                                                                                                                          'poller_hash': 'QzgxMUUwcGVlcnBvbnBvbiAxNTc3NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934746',
                                                                                                                                          'fiber_length': 971,
                                                                                                                                          'poller_hash': 'QzgzQzBDcGVlcnBvbnBvbiAxNzQ0NjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6731',
                                                                                                                                          'fiber_length': 896,
                                                                                                                                          'poller_hash': 'QzgxRTMwcGVlcnBvbnBvbiAyMDY0OTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6741',
                                                                                                                                          'fiber_length': 712,
                                                                                                                                          'poller_hash': 'MTI3NEE0M3BlZXJwb25wb24gMjM1MDgy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/5',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/6',
                                                                                         'in_discards': '69581',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23381187',
                                                                                         'in_octets': '23025238037254',
                                                                                         'in_ucast_pkts': '105799694860',
                                                                                         'links': [       {       'in_nucast_pkts': '28526120',
                                                                                                                  'in_octets': '568154610771',
                                                                                                                  'in_ucast_pkts': '1350865412',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '51995420168',
                                                                                                                  'out_octets': '73518102627770',
                                                                                                                  'out_ucast_pkts': '3255313107',
                                                                                                                  'poller_hash': 'MzIxMUIzcGVlcmludGZwb24gNA=='},
                                                                                                          {       'in_nucast_pkts': '65',
                                                                                                                  'in_octets': '4368623',
                                                                                                                  'in_ucast_pkts': '19671',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4751',
                                                                                                                  'out_octets': '28484047',
                                                                                                                  'out_ucast_pkts': '27957',
                                                                                                                  'poller_hash': 'NDJCOUQzcGVlcmludGZwb24gMTA='},
                                                                                                          {       'in_nucast_pkts': '5343629',
                                                                                                                  'in_octets': '95077221746',
                                                                                                                  'in_ucast_pkts': '529741166',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5927147649',
                                                                                                                  'out_octets': '12025967720167',
                                                                                                                  'out_ucast_pkts': '3140085217',
                                                                                                                  'poller_hash': 'ODcyNDJBcGVlcmludGZwb24gMTU='},
                                                                                                          {       'in_nucast_pkts': '7932343',
                                                                                                                  'in_octets': '379427203754',
                                                                                                                  'in_ucast_pkts': '1375510644',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '21102418876',
                                                                                                                  'out_octets': '32511333686372',
                                                                                                                  'out_ucast_pkts': '3495427169',
                                                                                                                  'poller_hash': 'NDI4MTkxcGVlcmludGZwb24gMzU='},
                                                                                                          {       'in_nucast_pkts': '9067',
                                                                                                                  'in_octets': '12084736',
                                                                                                                  'in_ucast_pkts': '45554',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5264533',
                                                                                                                  'out_octets': '7006867797',
                                                                                                                  'out_ucast_pkts': '65232',
                                                                                                                  'poller_hash': 'MzIyM0QzcGVlcmludGZwb24gNDM='},
                                                                                                          {       'in_nucast_pkts': '11',
                                                                                                                  'in_octets': '2902884',
                                                                                                                  'in_ucast_pkts': '9128',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5743',
                                                                                                                  'out_octets': '14491974',
                                                                                                                  'out_ucast_pkts': '14937',
                                                                                                                  'poller_hash': 'NDJEMkJCcGVlcmludGZwb24gODM='},
                                                                                                          {       'in_nucast_pkts': '5621',
                                                                                                                  'in_octets': '457235585891',
                                                                                                                  'in_ucast_pkts': '3934417804',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1385708',
                                                                                                                  'out_octets': '12280732556853',
                                                                                                                  'out_ucast_pkts': '8573524412',
                                                                                                                  'poller_hash': 'ODc0NEZwZWVyaW50ZnBvbiAxMjc='},
                                                                                                          {       'in_nucast_pkts': '5008464',
                                                                                                                  'in_octets': '9569087222',
                                                                                                                  'in_ucast_pkts': '44964954',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8669241530',
                                                                                                                  'out_octets': '11431962414901',
                                                                                                                  'out_ucast_pkts': '67922248',
                                                                                                                  'poller_hash': 'NEQxMTFGcGVlcmludGZwb24gMjAz'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'MkZDQzMycGVlcmludGZwb24gMjA0'},
                                                                                                          {       'in_nucast_pkts': '4191592',
                                                                                                                  'in_octets': '133115653890',
                                                                                                                  'in_ucast_pkts': '1343537907',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4188282',
                                                                                                                  'out_octets': '117561543729',
                                                                                                                  'out_ucast_pkts': '1699545451',
                                                                                                                  'poller_hash': 'NDE1N0VwZWVyaW50ZnBvbiAyMDY='},
                                                                                                          {       'in_nucast_pkts': '106396',
                                                                                                                  'in_octets': '168056082339',
                                                                                                                  'in_ucast_pkts': '1742969445',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386371',
                                                                                                                  'out_octets': '7353602929133',
                                                                                                                  'out_ucast_pkts': '9273460053',
                                                                                                                  'poller_hash': 'NDE1QUJwZWVyaW50ZnBvbiAyMDc='},
                                                                                                          {       'in_nucast_pkts': '879739',
                                                                                                                  'in_octets': '177959208670',
                                                                                                                  'in_ucast_pkts': '1265089313',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '161552',
                                                                                                                  'out_octets': '6897593984919',
                                                                                                                  'out_ucast_pkts': '4771688594',
                                                                                                                  'poller_hash': 'QkYyNTA1cGVlcmludGZwb24gMjA4'},
                                                                                                          {       'in_nucast_pkts': '1194938',
                                                                                                                  'in_octets': '300591692965',
                                                                                                                  'in_ucast_pkts': '1683242525',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1396438',
                                                                                                                  'out_octets': '7807776397156',
                                                                                                                  'out_ucast_pkts': '5739639267',
                                                                                                                  'poller_hash': 'NDcwM0FGcGVlcmludGZwb24gMjA5'},
                                                                                                          {       'in_nucast_pkts': '3974',
                                                                                                                  'in_octets': '88679893',
                                                                                                                  'in_ucast_pkts': '285470',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10587684',
                                                                                                                  'out_octets': '14506395541',
                                                                                                                  'out_ucast_pkts': '555126',
                                                                                                                  'poller_hash': 'ODcyNDVFcGVlcmludGZwb24gMjEw'},
                                                                                                          {       'in_nucast_pkts': '547077',
                                                                                                                  'in_octets': '48997048',
                                                                                                                  'in_ucast_pkts': '121237',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '702030655',
                                                                                                                  'out_octets': '901314821648',
                                                                                                                  'out_ucast_pkts': '50641',
                                                                                                                  'poller_hash': 'Mzk1MDdBcGVlcmludGZwb24gMjEx'},
                                                                                                          {       'in_nucast_pkts': '13',
                                                                                                                  'in_octets': '13448712',
                                                                                                                  'in_ucast_pkts': '45247',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5807',
                                                                                                                  'out_octets': '102004522',
                                                                                                                  'out_ucast_pkts': '89515',
                                                                                                                  'poller_hash': 'QzgxQzNGcGVlcmludGZwb24gMjEy'},
                                                                                                          {       'in_nucast_pkts': '8725',
                                                                                                                  'in_octets': '445237972309',
                                                                                                                  'in_ucast_pkts': '1789264096',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386186',
                                                                                                                  'out_octets': '7580893671797',
                                                                                                                  'out_ucast_pkts': '5463039243',
                                                                                                                  'poller_hash': 'MTk5QTMycGVlcmludGZwb24gMjE0'},
                                                                                                          {       'in_nucast_pkts': '19614569',
                                                                                                                  'in_octets': '8924615687',
                                                                                                                  'in_ucast_pkts': '43832288',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '32527275166',
                                                                                                                  'out_octets': '43045622886244',
                                                                                                                  'out_ucast_pkts': '97496231',
                                                                                                                  'poller_hash': 'NzZGMjFDcGVlcmludGZwb24gMjE3'},
                                                                                                          {       'in_nucast_pkts': '141865',
                                                                                                                  'in_octets': '298537094010',
                                                                                                                  'in_ucast_pkts': '819241090',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386735',
                                                                                                                  'out_octets': '6671076853108',
                                                                                                                  'out_ucast_pkts': '4753375244',
                                                                                                                  'poller_hash': 'NEQ0MjRGcGVlcmludGZwb24gMjE4'},
                                                                                                          {       'in_nucast_pkts': '15279728',
                                                                                                                  'in_octets': '78993986421',
                                                                                                                  'in_ucast_pkts': '348930806',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4883067820',
                                                                                                                  'out_octets': '7691316761838',
                                                                                                                  'out_ucast_pkts': '1147039084',
                                                                                                                  'poller_hash': 'NDAwMzhGcGVlcmludGZwb24gMjE5'},
                                                                                                          {       'in_nucast_pkts': '17254741',
                                                                                                                  'in_octets': '31335367609',
                                                                                                                  'in_ucast_pkts': '132428569',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4838994595',
                                                                                                                  'out_octets': '6798783089236',
                                                                                                                  'out_ucast_pkts': '552297618',
                                                                                                                  'poller_hash': 'ODZCQkVwZWVyaW50ZnBvbiAyMjA='},
                                                                                                          {       'in_nucast_pkts': '117',
                                                                                                                  'in_octets': '56174164',
                                                                                                                  'in_ucast_pkts': '700367',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5868',
                                                                                                                  'out_octets': '7099287088',
                                                                                                                  'out_ucast_pkts': '5134064',
                                                                                                                  'poller_hash': 'OTU0RjQ1cGVlcmludGZwb24gMTQzODgy'},
                                                                                                          {       'in_nucast_pkts': '6205',
                                                                                                                  'in_octets': '15955044',
                                                                                                                  'in_ucast_pkts': '51100',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11731833',
                                                                                                                  'out_octets': '15327352364',
                                                                                                                  'out_ucast_pkts': '84554',
                                                                                                                  'poller_hash': 'QzgzODFBcGVlcmludGZwb24gMTYwOTk2'},
                                                                                                          {       'in_nucast_pkts': '72',
                                                                                                                  'in_octets': '10595188',
                                                                                                                  'in_ucast_pkts': '66927',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3629',
                                                                                                                  'out_octets': '214175425',
                                                                                                                  'out_ucast_pkts': '162025',
                                                                                                                  'poller_hash': 'QzgxRTAxcGVlcmludGZwb24gMjA1NDU2'},
                                                                                                          {       'in_nucast_pkts': '2338834',
                                                                                                                  'in_octets': '11882242199',
                                                                                                                  'in_ucast_pkts': '35982567',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2196929415',
                                                                                                                  'out_octets': '2994730567182',
                                                                                                                  'out_ucast_pkts': '136342500',
                                                                                                                  'poller_hash': 'MTE5NTE0OXBlZXJpbnRmcG9uIDIxNTk2OQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '961651137666',
                                                                                         'out_octets': '1723828697957576',
                                                                                         'out_ucast_pkts': '306256689816',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzY=',
                                                                                         'pons': [       {       'id': '1/6',
                                                                                                                 'links': [       {       'connected_time': '19405327',
                                                                                                                                          'fiber_length': 1274,
                                                                                                                                          'poller_hash': 'MzIxMUIzcGVlcnBvbnBvbiA0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6498',
                                                                                                                                          'fiber_length': 1321,
                                                                                                                                          'poller_hash': 'NDJCOUQzcGVlcnBvbnBvbiAxMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19405350',
                                                                                                                                          'fiber_length': 1491,
                                                                                                                                          'poller_hash': 'ODcyNDJBcGVlcnBvbnBvbiAxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19405580',
                                                                                                                                          'fiber_length': 1490,
                                                                                                                                          'poller_hash': 'NDI4MTkxcGVlcnBvbnBvbiAzNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6521',
                                                                                                                                          'fiber_length': 1451,
                                                                                                                                          'poller_hash': 'MzIyM0QzcGVlcnBvbnBvbiA0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6544',
                                                                                                                                          'fiber_length': 1338,
                                                                                                                                          'poller_hash': 'NDJEMkJCcGVlcnBvbnBvbiA4Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390480',
                                                                                                                                          'fiber_length': 1387,
                                                                                                                                          'poller_hash': 'ODc0NEZwZWVycG9ucG9uIDEyNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390403',
                                                                                                                                          'fiber_length': 1329,
                                                                                                                                          'poller_hash': 'NEQxMTFGcGVlcnBvbnBvbiAyMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'poller_hash': 'MkZDQzMycGVlcnBvbnBvbiAyMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390355',
                                                                                                                                          'fiber_length': 1247,
                                                                                                                                          'poller_hash': 'NDE1N0VwZWVycG9ucG9uIDIwNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390381',
                                                                                                                                          'fiber_length': 1273,
                                                                                                                                          'poller_hash': 'NDE1QUJwZWVycG9ucG9uIDIwNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19389821',
                                                                                                                                          'fiber_length': 1353,
                                                                                                                                          'poller_hash': 'QkYyNTA1cGVlcnBvbnBvbiAyMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390191',
                                                                                                                                          'fiber_length': 1330,
                                                                                                                                          'poller_hash': 'NDcwM0FGcGVlcnBvbnBvbiAyMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6613',
                                                                                                                                          'fiber_length': 1476,
                                                                                                                                          'poller_hash': 'ODcyNDVFcGVlcnBvbnBvbiAyMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '1816548',
                                                                                                                                          'fiber_length': 1207,
                                                                                                                                          'poller_hash': 'Mzk1MDdBcGVlcnBvbnBvbiAyMTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6615',
                                                                                                                                          'fiber_length': 1300,
                                                                                                                                          'poller_hash': 'QzgxQzNGcGVlcnBvbnBvbiAyMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390326',
                                                                                                                                          'fiber_length': 1074,
                                                                                                                                          'poller_hash': 'MTk5QTMycGVlcnBvbnBvbiAyMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390476',
                                                                                                                                          'fiber_length': 1007,
                                                                                                                                          'poller_hash': 'NzZGMjFDcGVlcnBvbnBvbiAyMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390588',
                                                                                                                                          'fiber_length': 1327,
                                                                                                                                          'poller_hash': 'NEQ0MjRGcGVlcnBvbnBvbiAyMTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390361',
                                                                                                                                          'fiber_length': 1198,
                                                                                                                                          'poller_hash': 'NDAwMzhGcGVlcnBvbnBvbiAyMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '19390377',
                                                                                                                                          'fiber_length': 1227,
                                                                                                                                          'poller_hash': 'ODZCQkVwZWVycG9ucG9uIDIyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6711',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'OTU0RjQ1cGVlcnBvbnBvbiAxNDM4ODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6719',
                                                                                                                                          'fiber_length': 1226,
                                                                                                                                          'poller_hash': 'QzgzODFBcGVlcnBvbnBvbiAxNjA5OTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '6731',
                                                                                                                                          'fiber_length': 1090,
                                                                                                                                          'poller_hash': 'QzgxRTAxcGVlcnBvbnBvbiAyMDU0NTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926},
                                                                                                                                  {       'connected_time': '2501535',
                                                                                                                                          'fiber_length': 1180,
                                                                                                                                          'poller_hash': 'MTE5NTE0OXBlZXJwb25wb24gMjE1OTY5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.926}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/6',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/7',
                                                                                         'in_discards': '5687',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '8615312',
                                                                                         'in_octets': '19748960127457',
                                                                                         'in_ucast_pkts': '84657184128',
                                                                                         'links': [       {       'in_nucast_pkts': '20611983',
                                                                                                                  'in_octets': '66815460194',
                                                                                                                  'in_ucast_pkts': '229298584',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9029425587',
                                                                                                                  'out_octets': '12751033241806',
                                                                                                                  'out_ucast_pkts': '872294377',
                                                                                                                  'poller_hash': 'M0FERDcxcGVlcmludGZwb24gMQ=='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'MzNENTgwcGVlcmludGZwb24gMg=='},
                                                                                                          {       'in_nucast_pkts': '7807',
                                                                                                                  'in_octets': '48422121',
                                                                                                                  'in_ucast_pkts': '498337',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6577513',
                                                                                                                  'out_octets': '10617099496',
                                                                                                                  'out_ucast_pkts': '1272692',
                                                                                                                  'poller_hash': 'NDJDNDE0cGVlcmludGZwb24gNQ=='},
                                                                                                          {       'in_nucast_pkts': '28',
                                                                                                                  'in_octets': '1391564',
                                                                                                                  'in_ucast_pkts': '10495',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2433',
                                                                                                                  'out_octets': '40416419',
                                                                                                                  'out_ucast_pkts': '30366',
                                                                                                                  'poller_hash': 'NDNDMjRDcGVlcmludGZwb24gOA=='},
                                                                                                          {       'in_nucast_pkts': '4645101',
                                                                                                                  'in_octets': '135186205435',
                                                                                                                  'in_ucast_pkts': '1117957722',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12116619288',
                                                                                                                  'out_octets': '20057041271207',
                                                                                                                  'out_ucast_pkts': '3185376480',
                                                                                                                  'poller_hash': 'MzIxN0NBcGVlcmludGZwb24gMTE='},
                                                                                                          {       'in_nucast_pkts': '9303368',
                                                                                                                  'in_octets': '208512835380',
                                                                                                                  'in_ucast_pkts': '310716474',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14523695190',
                                                                                                                  'out_octets': '19986013509389',
                                                                                                                  'out_ucast_pkts': '855090377',
                                                                                                                  'poller_hash': 'MzIxNzE4cGVlcmludGZwb24gMTI='},
                                                                                                          {       'in_nucast_pkts': '5147',
                                                                                                                  'in_octets': '45632785',
                                                                                                                  'in_ucast_pkts': '456297',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3771645',
                                                                                                                  'out_octets': '10073193945',
                                                                                                                  'out_ucast_pkts': '3445461',
                                                                                                                  'poller_hash': 'MzIxN0EycGVlcmludGZwb24gMTQ='},
                                                                                                          {       'in_nucast_pkts': '100720',
                                                                                                                  'in_octets': '21907996798',
                                                                                                                  'in_ucast_pkts': '62319548',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1099785',
                                                                                                                  'out_octets': '323697914887',
                                                                                                                  'out_ucast_pkts': '261046695',
                                                                                                                  'poller_hash': 'M0FFQzIxcGVlcmludGZwb24gMTY='},
                                                                                                          {       'in_nucast_pkts': '17637050',
                                                                                                                  'in_octets': '252750089834',
                                                                                                                  'in_ucast_pkts': '805936977',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '51633485573',
                                                                                                                  'out_octets': '72164273742945',
                                                                                                                  'out_ucast_pkts': '2515625494',
                                                                                                                  'poller_hash': 'NDJEMzhGcGVlcmludGZwb24gMTk='},
                                                                                                          {       'in_nucast_pkts': '10251',
                                                                                                                  'in_octets': '13322787152',
                                                                                                                  'in_ucast_pkts': '39446476',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '161875',
                                                                                                                  'out_octets': '114761466749',
                                                                                                                  'out_ucast_pkts': '91497303',
                                                                                                                  'poller_hash': 'NzFEODk3cGVlcmludGZwb24gMjI='},
                                                                                                          {       'in_nucast_pkts': '26002259',
                                                                                                                  'in_octets': '70694525391',
                                                                                                                  'in_ucast_pkts': '247604068',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '24486208479',
                                                                                                                  'out_octets': '32680990673568',
                                                                                                                  'out_ucast_pkts': '534406828',
                                                                                                                  'poller_hash': 'MkVCOUI4cGVlcmludGZwb24gMjU='},
                                                                                                          {       'in_nucast_pkts': '31439710',
                                                                                                                  'in_octets': '375963726550',
                                                                                                                  'in_ucast_pkts': '512426742',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '45366106319',
                                                                                                                  'out_octets': '62552444326699',
                                                                                                                  'out_ucast_pkts': '1593227107',
                                                                                                                  'poller_hash': 'NTU2M0QxcGVlcmludGZwb24gMjY='},
                                                                                                          {       'in_nucast_pkts': '7473229',
                                                                                                                  'in_octets': '101104236243',
                                                                                                                  'in_ucast_pkts': '517223946',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13770992135',
                                                                                                                  'out_octets': '20389219130914',
                                                                                                                  'out_ucast_pkts': '1630008780',
                                                                                                                  'poller_hash': 'MTc1RTZEcGVlcmludGZwb24gMjc='},
                                                                                                          {       'in_nucast_pkts': '10',
                                                                                                                  'in_octets': '15866162',
                                                                                                                  'in_ucast_pkts': '68434',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5708',
                                                                                                                  'out_octets': '133912769',
                                                                                                                  'out_ucast_pkts': '113183',
                                                                                                                  'poller_hash': 'NDJEMzdGcGVlcmludGZwb24gODI='},
                                                                                                          {       'in_nucast_pkts': '5170',
                                                                                                                  'in_octets': '41827620',
                                                                                                                  'in_ucast_pkts': '118402',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5277097',
                                                                                                                  'out_octets': '7279674590',
                                                                                                                  'out_ucast_pkts': '307961',
                                                                                                                  'poller_hash': 'NDJEMUJEcGVlcmludGZwb24gODk='},
                                                                                                          {       'in_nucast_pkts': '13242',
                                                                                                                  'in_octets': '167717687213',
                                                                                                                  'in_ucast_pkts': '405667078',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1274850',
                                                                                                                  'out_octets': '1622852954531',
                                                                                                                  'out_ucast_pkts': '1241294665',
                                                                                                                  'poller_hash': 'NEUzRDA0cGVlcmludGZwb24gMTE5'},
                                                                                                          {       'in_nucast_pkts': '13697926',
                                                                                                                  'in_octets': '16512263262',
                                                                                                                  'in_ucast_pkts': '87767960',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '36942812238',
                                                                                                                  'out_octets': '49649692841896',
                                                                                                                  'out_ucast_pkts': '201659236',
                                                                                                                  'poller_hash': 'NzIyMjEzcGVlcmludGZwb24gMTIw'},
                                                                                                          {       'in_nucast_pkts': '58507',
                                                                                                                  'in_octets': '102865572287',
                                                                                                                  'in_ucast_pkts': '753896581',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1387334',
                                                                                                                  'out_octets': '4092020178143',
                                                                                                                  'out_ucast_pkts': '2915630614',
                                                                                                                  'poller_hash': 'MTk5OUU5cGVlcmludGZwb24gMTI1'},
                                                                                                          {       'in_nucast_pkts': '2433',
                                                                                                                  'in_octets': '31658585768',
                                                                                                                  'in_ucast_pkts': '221431408',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '621315',
                                                                                                                  'out_octets': '1041916188098',
                                                                                                                  'out_ucast_pkts': '729660023',
                                                                                                                  'poller_hash': 'QTlGQjlwZWVyaW50ZnBvbiAxMzE='},
                                                                                                          {       'in_nucast_pkts': '10415883',
                                                                                                                  'in_octets': '24462586482',
                                                                                                                  'in_ucast_pkts': '156647134',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5785320389',
                                                                                                                  'out_octets': '7451728654301',
                                                                                                                  'out_ucast_pkts': '353011766',
                                                                                                                  'poller_hash': 'QkYyNEYxcGVlcmludGZwb24gMTM0'},
                                                                                                          {       'in_nucast_pkts': '14397568',
                                                                                                                  'in_octets': '360319380506',
                                                                                                                  'in_ucast_pkts': '2263021855',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8480576754',
                                                                                                                  'out_octets': '18552725103728',
                                                                                                                  'out_ucast_pkts': '5631224424',
                                                                                                                  'poller_hash': 'MkVEOUY1cGVlcmludGZwb24gMjIy'},
                                                                                                          {       'in_nucast_pkts': '15603',
                                                                                                                  'in_octets': '33047153879',
                                                                                                                  'in_ucast_pkts': '226808466',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1100025',
                                                                                                                  'out_octets': '101689714820',
                                                                                                                  'out_ucast_pkts': '181092042',
                                                                                                                  'poller_hash': 'NDE1RkVwZWVyaW50ZnBvbiAyMjM='},
                                                                                                          {       'in_nucast_pkts': '15213580',
                                                                                                                  'in_octets': '236577735883',
                                                                                                                  'in_ucast_pkts': '5008808135',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5427735359',
                                                                                                                  'out_octets': '9211754765220',
                                                                                                                  'out_ucast_pkts': '40424241097',
                                                                                                                  'poller_hash': 'M0NGOURwZWVyaW50ZnBvbiAyMjQ='},
                                                                                                          {       'in_nucast_pkts': '8134353',
                                                                                                                  'in_octets': '39581612570',
                                                                                                                  'in_ucast_pkts': '117434322',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '19233897739',
                                                                                                                  'out_octets': '25932430754927',
                                                                                                                  'out_ucast_pkts': '129032080722',
                                                                                                                  'poller_hash': 'M0NGQThwZWVyaW50ZnBvbiAyMjU='},
                                                                                                          {       'in_nucast_pkts': '46',
                                                                                                                  'in_octets': '102393820',
                                                                                                                  'in_ucast_pkts': '863450',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2504',
                                                                                                                  'out_octets': '6709381797',
                                                                                                                  'out_ucast_pkts': '4678160',
                                                                                                                  'poller_hash': 'MTc1RTY2cGVlcmludGZwb24gMjI2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MjVCNUY5cGVlcmludGZwb24gMjI3'},
                                                                                                          {       'in_nucast_pkts': '12282177',
                                                                                                                  'in_octets': '23233885117',
                                                                                                                  'in_ucast_pkts': '92183589',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '22652912392',
                                                                                                                  'out_octets': '30377741608662',
                                                                                                                  'out_ucast_pkts': '346620121',
                                                                                                                  'poller_hash': 'NDAwM0Q0cGVlcmludGZwb24gMjI4'},
                                                                                                          {       'in_nucast_pkts': '12840311',
                                                                                                                  'in_octets': '488944063944',
                                                                                                                  'in_ucast_pkts': '749156825',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '33151357354',
                                                                                                                  'out_octets': '46829043942086',
                                                                                                                  'out_ucast_pkts': '1857975008',
                                                                                                                  'poller_hash': 'QzgxREQycGVlcmludGZwb24gMjI5'},
                                                                                                          {       'in_nucast_pkts': '13',
                                                                                                                  'in_octets': '1434306',
                                                                                                                  'in_ucast_pkts': '3651',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5849',
                                                                                                                  'out_octets': '1949311',
                                                                                                                  'out_ucast_pkts': '4252',
                                                                                                                  'poller_hash': 'NUE2QzU0cGVlcmludGZwb24gMTM4Njk0'},
                                                                                                          {       'in_nucast_pkts': '252',
                                                                                                                  'in_octets': '88603654',
                                                                                                                  'in_ucast_pkts': '187836',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5852',
                                                                                                                  'out_octets': '498722948',
                                                                                                                  'out_ucast_pkts': '429484',
                                                                                                                  'poller_hash': 'ODJBNTVBcGVlcmludGZwb24gMTQwOTM5'},
                                                                                                          {       'in_nucast_pkts': '22',
                                                                                                                  'in_octets': '43428211',
                                                                                                                  'in_ucast_pkts': '207225',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3629',
                                                                                                                  'out_octets': '537911317',
                                                                                                                  'out_ucast_pkts': '420299',
                                                                                                                  'poller_hash': 'QzgxOTE0cGVlcmludGZwb24gMTk2MjI0'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '999004178695',
                                                                                         'out_octets': '1688792308824471',
                                                                                         'out_ucast_pkts': '243773623366',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzc=',
                                                                                         'pons': [       {       'id': '1/7',
                                                                                                                 'links': [       {       'connected_time': '19390183',
                                                                                                                                          'fiber_length': 757,
                                                                                                                                          'poller_hash': 'M0FERDcxcGVlcnBvbnBvbiAx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '6494',
                                                                                                                                          'fiber_length': 1250,
                                                                                                                                          'poller_hash': 'MzNENTgwcGVlcnBvbnBvbiAy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '6496',
                                                                                                                                          'fiber_length': 1181,
                                                                                                                                          'poller_hash': 'NDJDNDE0cGVlcnBvbnBvbiA1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '6499',
                                                                                                                                          'fiber_length': 431,
                                                                                                                                          'poller_hash': 'NDNDMjRDcGVlcnBvbnBvbiA4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19119362',
                                                                                                                                          'fiber_length': 1048,
                                                                                                                                          'poller_hash': 'MzIxN0NBcGVlcnBvbnBvbiAxMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19405639',
                                                                                                                                          'fiber_length': 1083,
                                                                                                                                          'poller_hash': 'MzIxNzE4cGVlcnBvbnBvbiAxMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '6499',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'MzIxN0EycGVlcnBvbnBvbiAxNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '3934557',
                                                                                                                                          'fiber_length': 819,
                                                                                                                                          'poller_hash': 'M0FFQzIxcGVlcnBvbnBvbiAxNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19405265',
                                                                                                                                          'fiber_length': 853,
                                                                                                                                          'poller_hash': 'NDJEMzhGcGVlcnBvbnBvbiAxOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19390310',
                                                                                                                                          'fiber_length': 621,
                                                                                                                                          'poller_hash': 'NzFEODk3cGVlcnBvbnBvbiAyMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19390263',
                                                                                                                                          'fiber_length': 1135,
                                                                                                                                          'poller_hash': 'MkVCOUI4cGVlcnBvbnBvbiAyNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19390000',
                                                                                                                                          'fiber_length': 1050,
                                                                                                                                          'poller_hash': 'NTU2M0QxcGVlcnBvbnBvbiAyNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19390216',
                                                                                                                                          'fiber_length': 444,
                                                                                                                                          'poller_hash': 'MTc1RTZEcGVlcnBvbnBvbiAyNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '6544',
                                                                                                                                          'fiber_length': 1283,
                                                                                                                                          'poller_hash': 'NDJEMzdGcGVlcnBvbnBvbiA4Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '6547',
                                                                                                                                          'fiber_length': 893,
                                                                                                                                          'poller_hash': 'NDJEMUJEcGVlcnBvbnBvbiA4OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '12094501',
                                                                                                                                          'fiber_length': 1174,
                                                                                                                                          'poller_hash': 'NEUzRDA0cGVlcnBvbnBvbiAxMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19390466',
                                                                                                                                          'fiber_length': 1259,
                                                                                                                                          'poller_hash': 'NzIyMjEzcGVlcnBvbnBvbiAxMjA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19390432',
                                                                                                                                          'fiber_length': 428,
                                                                                                                                          'poller_hash': 'MTk5OUU5cGVlcnBvbnBvbiAxMjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '2153591',
                                                                                                                                          'fiber_length': 890,
                                                                                                                                          'poller_hash': 'QTlGQjlwZWVycG9ucG9uIDEzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19390502',
                                                                                                                                          'fiber_length': 607,
                                                                                                                                          'poller_hash': 'QkYyNEYxcGVlcnBvbnBvbiAxMzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19389984',
                                                                                                                                          'fiber_length': 1200,
                                                                                                                                          'poller_hash': 'MkVEOUY1cGVlcnBvbnBvbiAyMjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '3934570',
                                                                                                                                          'fiber_length': 1137,
                                                                                                                                          'poller_hash': 'NDE1RkVwZWVycG9ucG9uIDIyMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19390304',
                                                                                                                                          'fiber_length': 1161,
                                                                                                                                          'poller_hash': 'M0NGOURwZWVycG9ucG9uIDIyNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19390304',
                                                                                                                                          'fiber_length': 1169,
                                                                                                                                          'poller_hash': 'M0NGQThwZWVycG9ucG9uIDIyNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '6620',
                                                                                                                                          'fiber_length': 1108,
                                                                                                                                          'poller_hash': 'MTc1RTY2cGVlcnBvbnBvbiAyMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19389993',
                                                                                                                                          'fiber_length': 1081,
                                                                                                                                          'poller_hash': 'MjVCNUY5cGVlcnBvbnBvbiAyMjc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19390619',
                                                                                                                                          'fiber_length': 1034,
                                                                                                                                          'poller_hash': 'NDAwM0Q0cGVlcnBvbnBvbiAyMjg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '19405605',
                                                                                                                                          'fiber_length': 1118,
                                                                                                                                          'poller_hash': 'QzgxREQycGVlcnBvbnBvbiAyMjk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '6705',
                                                                                                                                          'fiber_length': 1038,
                                                                                                                                          'poller_hash': 'NUE2QzU0cGVlcnBvbnBvbiAxMzg2OTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '6707',
                                                                                                                                          'fiber_length': 1371,
                                                                                                                                          'poller_hash': 'ODJBNTVBcGVlcnBvbnBvbiAxNDA5Mzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55},
                                                                                                                                  {       'connected_time': '6730',
                                                                                                                                          'fiber_length': 1557,
                                                                                                                                          'poller_hash': 'QzgxOTE0cGVlcnBvbnBvbiAxOTYyMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.55}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/7',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/8',
                                                                                         'in_discards': '142892',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '6209592',
                                                                                         'in_octets': '18106564412133',
                                                                                         'in_ucast_pkts': '80689101893',
                                                                                         'links': [       {       'in_nucast_pkts': '7187',
                                                                                                                  'in_octets': '7672515',
                                                                                                                  'in_ucast_pkts': '18187',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9728734',
                                                                                                                  'out_octets': '12778881693',
                                                                                                                  'out_ucast_pkts': '18472',
                                                                                                                  'poller_hash': 'NDI4MUQwcGVlcmludGZwb24gMzI='},
                                                                                                          {       'in_nucast_pkts': '16908993',
                                                                                                                  'in_octets': '525356592226',
                                                                                                                  'in_ucast_pkts': '3225227176',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12326487505',
                                                                                                                  'out_octets': '26466985383686',
                                                                                                                  'out_ucast_pkts': '7188282699',
                                                                                                                  'poller_hash': 'NDcwOTJDcGVlcmludGZwb24gMzM='},
                                                                                                          {       'in_nucast_pkts': '645603',
                                                                                                                  'in_octets': '28502081004',
                                                                                                                  'in_ucast_pkts': '53184131',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '237911760',
                                                                                                                  'out_octets': '494649658102',
                                                                                                                  'out_ucast_pkts': '141987644',
                                                                                                                  'poller_hash': 'MjQ4QUMzcGVlcmludGZwb24gMzQ='},
                                                                                                          {       'in_nucast_pkts': '61601',
                                                                                                                  'in_octets': '105048857061',
                                                                                                                  'in_ucast_pkts': '548529639',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2202050',
                                                                                                                  'out_octets': '1784287728456',
                                                                                                                  'out_ucast_pkts': '1286665063',
                                                                                                                  'poller_hash': 'NTYwMjYycGVlcmludGZwb24gMzg='},
                                                                                                          {       'in_nucast_pkts': '6641940',
                                                                                                                  'in_octets': '17235483285',
                                                                                                                  'in_ucast_pkts': '70040737',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5675316866',
                                                                                                                  'out_octets': '7414296248324',
                                                                                                                  'out_ucast_pkts': '117847452',
                                                                                                                  'poller_hash': 'MzI5NjNDcGVlcmludGZwb24gMzk='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'NEQ0MUVFcGVlcmludGZwb24gNDI='},
                                                                                                          {       'in_nucast_pkts': '4838829',
                                                                                                                  'in_octets': '20896282126',
                                                                                                                  'in_ucast_pkts': '82076032',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '939690502',
                                                                                                                  'out_octets': '1786793428109',
                                                                                                                  'out_ucast_pkts': '445271301',
                                                                                                                  'poller_hash': 'QzRGRjRwZWVyaW50ZnBvbiA0NQ=='},
                                                                                                          {       'in_nucast_pkts': '10',
                                                                                                                  'in_octets': '13109141251',
                                                                                                                  'in_ucast_pkts': '73578476',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6356',
                                                                                                                  'out_octets': '486417391029',
                                                                                                                  'out_ucast_pkts': '337416599',
                                                                                                                  'poller_hash': 'NTVFQTkwcGVlcmludGZwb24gNDc='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'N0ZFMkFwZWVyaW50ZnBvbiA1MQ=='},
                                                                                                          {       'in_nucast_pkts': '5858',
                                                                                                                  'in_octets': '14340617',
                                                                                                                  'in_ucast_pkts': '33383',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5360353',
                                                                                                                  'out_octets': '6606030474',
                                                                                                                  'out_ucast_pkts': '34548',
                                                                                                                  'poller_hash': 'NDJDOENGcGVlcmludGZwb24gNzY='},
                                                                                                          {       'in_nucast_pkts': '5312',
                                                                                                                  'in_octets': '126277842',
                                                                                                                  'in_ucast_pkts': '291196',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5173685',
                                                                                                                  'out_octets': '7628529051',
                                                                                                                  'out_ucast_pkts': '955581',
                                                                                                                  'poller_hash': 'ODY5M0RGcGVlcmludGZwb24gOTA='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'QUMzRTRwZWVyaW50ZnBvbiAxMzc='},
                                                                                                          {       'in_nucast_pkts': '112032',
                                                                                                                  'in_octets': '71412328164',
                                                                                                                  'in_ucast_pkts': '180883370',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1108806',
                                                                                                                  'out_octets': '378099648464',
                                                                                                                  'out_ucast_pkts': '326714629',
                                                                                                                  'poller_hash': 'NDE1NDJwZWVyaW50ZnBvbiAxOTk='},
                                                                                                          {       'in_nucast_pkts': '3770',
                                                                                                                  'in_octets': '1102892032011',
                                                                                                                  'in_ucast_pkts': '2845306965',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1378528',
                                                                                                                  'out_octets': '4617659320910',
                                                                                                                  'out_ucast_pkts': '3704581924',
                                                                                                                  'poller_hash': 'Q0MwQjZwZWVyaW50ZnBvbiAyMDA='},
                                                                                                          {       'in_nucast_pkts': '11208188',
                                                                                                                  'in_octets': '30012131161',
                                                                                                                  'in_ucast_pkts': '178519456',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15794912268',
                                                                                                                  'out_octets': '21538392428969',
                                                                                                                  'out_ucast_pkts': '685312579',
                                                                                                                  'poller_hash': 'MzY1NUE5cGVlcmludGZwb24gMjAx'},
                                                                                                          {       'in_nucast_pkts': '8308',
                                                                                                                  'in_octets': '222148745818',
                                                                                                                  'in_ucast_pkts': '874766636',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1386071',
                                                                                                                  'out_octets': '2684757616744',
                                                                                                                  'out_ucast_pkts': '2090331332',
                                                                                                                  'poller_hash': 'NDE1MkZwZWVyaW50ZnBvbiAyMDI='},
                                                                                                          {       'in_nucast_pkts': '6',
                                                                                                                  'in_octets': '64206358',
                                                                                                                  'in_ucast_pkts': '246024',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2483',
                                                                                                                  'out_octets': '720352138',
                                                                                                                  'out_ucast_pkts': '569783',
                                                                                                                  'poller_hash': 'M0VCQTUzcGVlcmludGZwb24gMjMw'},
                                                                                                          {       'in_nucast_pkts': '81',
                                                                                                                  'in_octets': '145279195',
                                                                                                                  'in_ucast_pkts': '559218',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '113',
                                                                                                                  'out_octets': '2195518758',
                                                                                                                  'out_ucast_pkts': '1792682',
                                                                                                                  'poller_hash': 'M0FFQkJEcGVlcmludGZwb24gMjM4'},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '40719958',
                                                                                                                  'in_ucast_pkts': '431375',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2489',
                                                                                                                  'out_octets': '1332110539',
                                                                                                                  'out_ucast_pkts': '912684',
                                                                                                                  'poller_hash': 'M0FFQkI2cGVlcmludGZwb24gMjM5'},
                                                                                                          {       'in_nucast_pkts': '10',
                                                                                                                  'in_octets': '974362',
                                                                                                                  'in_ucast_pkts': '3496',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2230',
                                                                                                                  'out_octets': '2331115',
                                                                                                                  'out_ucast_pkts': '3936',
                                                                                                                  'poller_hash': 'M0FFQjk4cGVlcmludGZwb24gMjQw'},
                                                                                                          {       'in_nucast_pkts': '2753',
                                                                                                                  'in_octets': '43471959',
                                                                                                                  'in_ucast_pkts': '104102',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3829883',
                                                                                                                  'out_octets': '5066954127',
                                                                                                                  'out_ucast_pkts': '115246',
                                                                                                                  'poller_hash': 'MTMwMDVGcGVlcmludGZwb24gMjQx'},
                                                                                                          {       'in_nucast_pkts': '1506473',
                                                                                                                  'in_octets': '2138921908',
                                                                                                                  'in_ucast_pkts': '10144205',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1241701935',
                                                                                                                  'out_octets': '1624172165210',
                                                                                                                  'out_ucast_pkts': '41435257',
                                                                                                                  'poller_hash': 'MTMwMDhCcGVlcmludGZwb24gMjQy'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'NDAwRjY0cGVlcmludGZwb24gMjQz'},
                                                                                                          {       'in_nucast_pkts': '313',
                                                                                                                  'in_octets': '19608264630',
                                                                                                                  'in_ucast_pkts': '194515805',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15353',
                                                                                                                  'out_octets': '574789519780',
                                                                                                                  'out_ucast_pkts': '390567911',
                                                                                                                  'poller_hash': 'NzFEOEEwcGVlcmludGZwb24gMjQ0'},
                                                                                                          {       'in_nucast_pkts': '16044',
                                                                                                                  'in_octets': '16269321197',
                                                                                                                  'in_ucast_pkts': '75643338',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1380568',
                                                                                                                  'out_octets': '229035069814',
                                                                                                                  'out_ucast_pkts': '203457420',
                                                                                                                  'poller_hash': 'NTU2M0I2cGVlcmludGZwb24gMjQ1'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODczMjNwZWVyaW50ZnBvbiAyNDY='},
                                                                                                          {       'in_nucast_pkts': '12406066',
                                                                                                                  'in_octets': '287903681858',
                                                                                                                  'in_ucast_pkts': '2159341263',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '24868367819',
                                                                                                                  'out_octets': '39530809714948',
                                                                                                                  'out_ucast_pkts': '4538547045',
                                                                                                                  'poller_hash': 'NEQ0MUY1cGVlcmludGZwb24gMjQ3'},
                                                                                                          {       'in_nucast_pkts': '26327836',
                                                                                                                  'in_octets': '17579372964',
                                                                                                                  'in_ucast_pkts': '47249434',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12218383379',
                                                                                                                  'out_octets': '15431519369411',
                                                                                                                  'out_ucast_pkts': '135976748',
                                                                                                                  'poller_hash': 'MjQ4QUUzcGVlcmludGZwb24gMjQ4'},
                                                                                                          {       'in_nucast_pkts': '14',
                                                                                                                  'in_octets': '37204002859',
                                                                                                                  'in_ucast_pkts': '243571494',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1100078',
                                                                                                                  'out_octets': '899827533742',
                                                                                                                  'out_ucast_pkts': '633095827',
                                                                                                                  'poller_hash': 'NDAwNDU1cGVlcmludGZwb24gMjQ5'},
                                                                                                          {       'in_nucast_pkts': '5504',
                                                                                                                  'in_octets': '3449739',
                                                                                                                  'in_ucast_pkts': '11046',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1841525',
                                                                                                                  'out_octets': '2272918200',
                                                                                                                  'out_ucast_pkts': '9852',
                                                                                                                  'poller_hash': 'ODY5MzlDcGVlcmludGZwb24gMTM4ODgx'},
                                                                                                          {       'in_nucast_pkts': '2566',
                                                                                                                  'in_octets': '6673844',
                                                                                                                  'in_ucast_pkts': '34549',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5846',
                                                                                                                  'out_octets': '68990816',
                                                                                                                  'out_ucast_pkts': '61728',
                                                                                                                  'poller_hash': 'ODQ0QkU1cGVlcmludGZwb24gMTQwODUz'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '706304090394',
                                                                                         'out_octets': '1248978707498205',
                                                                                         'out_ucast_pkts': '212943817703',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzg=',
                                                                                         'pons': [       {       'id': '1/8',
                                                                                                                 'links': [       {       'connected_time': '6513',
                                                                                                                                          'fiber_length': 1372,
                                                                                                                                          'poller_hash': 'NDI4MUQwcGVlcnBvbnBvbiAzMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390422',
                                                                                                                                          'fiber_length': 1354,
                                                                                                                                          'poller_hash': 'NDcwOTJDcGVlcnBvbnBvbiAzMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934589',
                                                                                                                                          'fiber_length': 951,
                                                                                                                                          'poller_hash': 'MjQ4QUMzcGVlcnBvbnBvbiAzNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934503',
                                                                                                                                          'fiber_length': 450,
                                                                                                                                          'poller_hash': 'NTYwMjYycGVlcnBvbnBvbiAzOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390482',
                                                                                                                                          'fiber_length': 599,
                                                                                                                                          'poller_hash': 'MzI5NjNDcGVlcnBvbnBvbiAzOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390323',
                                                                                                                                          'fiber_length': 457,
                                                                                                                                          'poller_hash': 'NEQ0MUVFcGVlcnBvbnBvbiA0Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934508',
                                                                                                                                          'fiber_length': 940,
                                                                                                                                          'poller_hash': 'QzRGRjRwZWVycG9ucG9uIDQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934523',
                                                                                                                                          'fiber_length': 589,
                                                                                                                                          'poller_hash': 'NTVFQTkwcGVlcnBvbnBvbiA0Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390382',
                                                                                                                                          'fiber_length': 1139,
                                                                                                                                          'poller_hash': 'N0ZFMkFwZWVycG9ucG9uIDUx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6540',
                                                                                                                                          'fiber_length': 982,
                                                                                                                                          'poller_hash': 'NDJDOENGcGVlcnBvbnBvbiA3Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6547',
                                                                                                                                          'fiber_length': 791,
                                                                                                                                          'poller_hash': 'ODY5M0RGcGVlcnBvbnBvbiA5MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'poller_hash': 'QUMzRTRwZWVycG9ucG9uIDEzNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934556',
                                                                                                                                          'fiber_length': 656,
                                                                                                                                          'poller_hash': 'NDE1NDJwZWVycG9ucG9uIDE5OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19125406',
                                                                                                                                          'fiber_length': 726,
                                                                                                                                          'poller_hash': 'Q0MwQjZwZWVycG9ucG9uIDIwMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390227',
                                                                                                                                          'fiber_length': 836,
                                                                                                                                          'poller_hash': 'MzY1NUE5cGVlcnBvbnBvbiAyMDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390393',
                                                                                                                                          'fiber_length': 699,
                                                                                                                                          'poller_hash': 'NDE1MkZwZWVycG9ucG9uIDIwMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6623',
                                                                                                                                          'fiber_length': 406,
                                                                                                                                          'poller_hash': 'M0VCQTUzcGVlcnBvbnBvbiAyMzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6631',
                                                                                                                                          'fiber_length': 1235,
                                                                                                                                          'poller_hash': 'M0FFQkJEcGVlcnBvbnBvbiAyMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6632',
                                                                                                                                          'fiber_length': 946,
                                                                                                                                          'poller_hash': 'M0FFQkI2cGVlcnBvbnBvbiAyMzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6578',
                                                                                                                                          'fiber_length': 493,
                                                                                                                                          'poller_hash': 'M0FFQjk4cGVlcnBvbnBvbiAyNDA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6634',
                                                                                                                                          'fiber_length': 1057,
                                                                                                                                          'poller_hash': 'MTMwMDVGcGVlcnBvbnBvbiAyNDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934624',
                                                                                                                                          'fiber_length': 783,
                                                                                                                                          'poller_hash': 'MTMwMDhCcGVlcnBvbnBvbiAyNDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6637',
                                                                                                                                          'fiber_length': 893,
                                                                                                                                          'poller_hash': 'NDAwRjY0cGVlcnBvbnBvbiAyNDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '1831713',
                                                                                                                                          'fiber_length': 468,
                                                                                                                                          'poller_hash': 'NzFEOEEwcGVlcnBvbnBvbiAyNDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390716',
                                                                                                                                          'fiber_length': 580,
                                                                                                                                          'poller_hash': 'NTU2M0I2cGVlcnBvbnBvbiAyNDU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'poller_hash': 'ODczMjNwZWVycG9ucG9uIDI0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390530',
                                                                                                                                          'fiber_length': 1181,
                                                                                                                                          'poller_hash': 'NEQ0MUY1cGVlcnBvbnBvbiAyNDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '19390459',
                                                                                                                                          'fiber_length': 1099,
                                                                                                                                          'poller_hash': 'MjQ4QUUzcGVlcnBvbnBvbiAyNDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3934691',
                                                                                                                                          'fiber_length': 1110,
                                                                                                                                          'poller_hash': 'NDAwNDU1cGVlcnBvbnBvbiAyNDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6708',
                                                                                                                                          'fiber_length': 977,
                                                                                                                                          'poller_hash': 'ODY5MzlDcGVlcnBvbnBvbiAxMzg4ODE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6706',
                                                                                                                                          'fiber_length': 1108,
                                                                                                                                          'poller_hash': 'ODQ0QkU1cGVlcnBvbnBvbiAxNDA4NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/8',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzg=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03006',
                                                           'name': 'GPON-8',
                                                           'poller_hash': 'MjExNzAzNjAxMTg4',
                                                           'serial_number': '211703601188',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '81689643'},
                                                   {       'id': '2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '2/x3',
                                                                                         'in_discards': '464143961',
                                                                                         'in_errors': '1521',
                                                                                         'in_nucast_pkts': '10790007324733',
                                                                                         'in_octets': '39951337065701683',
                                                                                         'in_ucast_pkts': '19789817985313',
                                                                                         'mac_address': 'cc:be:59:12:6a:8f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01511',
                                                                                         'name': 'ethernet '
                                                                                                 '2/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '2196205562',
                                                                                         'out_octets': '3415899742449656',
                                                                                         'out_ucast_pkts': '8739518225968',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/x4',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23551087',
                                                                                         'in_octets': '3198749985',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': 'cc:be:59:12:6a:90',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC02',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 '2/x4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '36583572',
                                                                                         'out_octets': '45737730673955',
                                                                                         'out_ucast_pkts': '151389742130',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0TUNDTC1TVUJTIDIveDQ=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2421807',
                                                                                         'in_octets': '928835349',
                                                                                         'in_ucast_pkts': '9895799',
                                                                                         'mac_address': 'cc:be:59:12:6a:81',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-GB-GE-T',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '865926964',
                                                                                         'out_octets': '121072637805',
                                                                                         'out_ucast_pkts': '9179003',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMQ==',
                                                                                         'speed': '100000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '2/g2',
                                                                                         'mac_address': 'cc:be:59:12:6a:82',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '2/g3',
                                                                                         'mac_address': 'cc:be:59:12:6a:83',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMw=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g4',
                                                                                         'in_discards': '123',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '92211',
                                                                                         'in_octets': '6854860086',
                                                                                         'in_ucast_pkts': '30924797',
                                                                                         'mac_address': 'cc:be:59:12:6a:84',
                                                                                         'manufacturer': 'BROCADE',
                                                                                         'model': '57-1000042-01',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '106406497',
                                                                                         'out_octets': '16700137992',
                                                                                         'out_ucast_pkts': '69010693',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/1',
                                                                                         'in_discards': '128255',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '6253569',
                                                                                         'in_octets': '22664997558156',
                                                                                         'in_ucast_pkts': '107609056435',
                                                                                         'links': [       {       'in_nucast_pkts': '2448',
                                                                                                                  'in_octets': '193519526762',
                                                                                                                  'in_ucast_pkts': '933468971',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1692357',
                                                                                                                  'out_octets': '2724444853554',
                                                                                                                  'out_ucast_pkts': '2061853425',
                                                                                                                  'poller_hash': 'NTU2M0FCcGVlcmludGZwb24gMjUw'},
                                                                                                          {       'in_nucast_pkts': '186289',
                                                                                                                  'in_octets': '475089573651',
                                                                                                                  'in_ucast_pkts': '4350403066',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1796076',
                                                                                                                  'out_octets': '8570274760364',
                                                                                                                  'out_ucast_pkts': '5976022603',
                                                                                                                  'poller_hash': 'NEQ0MjNEcGVlcmludGZwb24gMjUz'},
                                                                                                          {       'in_nucast_pkts': '9008',
                                                                                                                  'in_octets': '69347382396',
                                                                                                                  'in_ucast_pkts': '637350184',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1779300',
                                                                                                                  'out_octets': '2446248858158',
                                                                                                                  'out_ucast_pkts': '1729081528',
                                                                                                                  'poller_hash': 'QzUwMTBwZWVyaW50ZnBvbiAyNTQ='},
                                                                                                          {       'in_nucast_pkts': '964105',
                                                                                                                  'in_octets': '66007373801',
                                                                                                                  'in_ucast_pkts': '358561702',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1708765',
                                                                                                                  'out_octets': '1711434568466',
                                                                                                                  'out_ucast_pkts': '1187602670',
                                                                                                                  'poller_hash': 'NEQ0MUY3cGVlcmludGZwb24gMjU3'},
                                                                                                          {       'in_nucast_pkts': '14665643',
                                                                                                                  'in_octets': '60584985817',
                                                                                                                  'in_ucast_pkts': '197597993',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6676750919',
                                                                                                                  'out_octets': '9363617819215',
                                                                                                                  'out_ucast_pkts': '607500684',
                                                                                                                  'poller_hash': 'QkYxRTFCcGVlcmludGZwb24gMjU4'},
                                                                                                          {       'in_nucast_pkts': '5791510',
                                                                                                                  'in_octets': '299811737599',
                                                                                                                  'in_ucast_pkts': '1254947034',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6470069381',
                                                                                                                  'out_octets': '12903135412965',
                                                                                                                  'out_ucast_pkts': '3555952462',
                                                                                                                  'poller_hash': 'M0ZGRkUzcGVlcmludGZwb24gMjYx'},
                                                                                                          {       'in_nucast_pkts': '24484449',
                                                                                                                  'in_octets': '313527586978',
                                                                                                                  'in_ucast_pkts': '2453101843',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1796008',
                                                                                                                  'out_octets': '6640720180906',
                                                                                                                  'out_ucast_pkts': '9015162282',
                                                                                                                  'poller_hash': 'NDE4QjdwZWVyaW50ZnBvbiAyNjM='},
                                                                                                          {       'in_nucast_pkts': '13',
                                                                                                                  'in_octets': '67230851618',
                                                                                                                  'in_ucast_pkts': '569831942',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1211302',
                                                                                                                  'out_octets': '2168342368258',
                                                                                                                  'out_ucast_pkts': '1512097852',
                                                                                                                  'poller_hash': 'MjNBMDAzcGVlcmludGZwb24gMjY1'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'NTU1Q0I4cGVlcmludGZwb24gMjY5'},
                                                                                                          {       'in_nucast_pkts': '10479851',
                                                                                                                  'in_octets': '13487905280',
                                                                                                                  'in_ucast_pkts': '64251692',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '19373570116',
                                                                                                                  'out_octets': '25859541246871',
                                                                                                                  'out_ucast_pkts': '287548913',
                                                                                                                  'poller_hash': 'MkZDQzMxcGVlcmludGZwb24gMjcw'},
                                                                                                          {       'in_nucast_pkts': '1330608',
                                                                                                                  'in_octets': '752414042218',
                                                                                                                  'in_ucast_pkts': '2031355791',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1858309',
                                                                                                                  'out_octets': '5752950486850',
                                                                                                                  'out_ucast_pkts': '4984327480',
                                                                                                                  'poller_hash': 'RjIzQTVwZWVyaW50ZnBvbiAyNzE='},
                                                                                                          {       'in_nucast_pkts': '225074',
                                                                                                                  'in_octets': '415958469123',
                                                                                                                  'in_ucast_pkts': '2380893429',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1797716',
                                                                                                                  'out_octets': '8602854386487',
                                                                                                                  'out_ucast_pkts': '6107344196',
                                                                                                                  'poller_hash': 'MTk5OUY3cGVlcmludGZwb24gMjcy'},
                                                                                                          {       'in_nucast_pkts': '11',
                                                                                                                  'in_octets': '16103915285',
                                                                                                                  'in_ucast_pkts': '65602093',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1204793',
                                                                                                                  'out_octets': '656683708990',
                                                                                                                  'out_ucast_pkts': '468649107',
                                                                                                                  'poller_hash': 'MTI0ODQ1cGVlcmludGZwb24gMjcz'},
                                                                                                          {       'in_nucast_pkts': '29384',
                                                                                                                  'in_octets': '293484398122',
                                                                                                                  'in_ucast_pkts': '722849985',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1796180',
                                                                                                                  'out_octets': '2871885419766',
                                                                                                                  'out_ucast_pkts': '2249631650',
                                                                                                                  'poller_hash': 'MTk5OUUxcGVlcmludGZwb24gMjc0'},
                                                                                                          {       'in_nucast_pkts': '13174291',
                                                                                                                  'in_octets': '14143289951',
                                                                                                                  'in_ucast_pkts': '43912614',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18807338688',
                                                                                                                  'out_octets': '25055653090606',
                                                                                                                  'out_ucast_pkts': '71072329',
                                                                                                                  'poller_hash': 'NEQ0MjQycGVlcmludGZwb24gMjc1'},
                                                                                                          {       'in_nucast_pkts': '144480',
                                                                                                                  'in_octets': '257891199634',
                                                                                                                  'in_ucast_pkts': '1112664348',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1795872',
                                                                                                                  'out_octets': '3439994956891',
                                                                                                                  'out_ucast_pkts': '2510597201',
                                                                                                                  'poller_hash': 'NDAwN0ZGcGVlcmludGZwb24gMjc2'},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '25307921296',
                                                                                                                  'in_ucast_pkts': '77167844',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1211304',
                                                                                                                  'out_octets': '795440912979',
                                                                                                                  'out_ucast_pkts': '568819931',
                                                                                                                  'poller_hash': 'NzIyMDQxcGVlcmludGZwb24gMjc3'},
                                                                                                          {       'in_nucast_pkts': '17983615',
                                                                                                                  'in_octets': '70920967347',
                                                                                                                  'in_ucast_pkts': '539151275',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '34675104135',
                                                                                                                  'out_octets': '49420848139687',
                                                                                                                  'out_ucast_pkts': '1855453332',
                                                                                                                  'poller_hash': 'QTlDOTMxcGVlcmludGZwb24gMTU2NDU2'},
                                                                                                          {       'in_nucast_pkts': '150665',
                                                                                                                  'in_octets': '115743961423',
                                                                                                                  'in_ucast_pkts': '1011617745',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11484560',
                                                                                                                  'out_octets': '3894731362323',
                                                                                                                  'out_ucast_pkts': '2749519127',
                                                                                                                  'poller_hash': 'QzgzRTBBcGVlcmludGZwb24gMTYxNjA3'},
                                                                                                          {       'in_nucast_pkts': '5417',
                                                                                                                  'in_octets': '17201542',
                                                                                                                  'in_ucast_pkts': '43176',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3614',
                                                                                                                  'out_octets': '61686678',
                                                                                                                  'out_ucast_pkts': '61064',
                                                                                                                  'poller_hash': 'QzgzQkFCcGVlcmludGZwb24gMTY0MjA3'},
                                                                                                          {       'in_nucast_pkts': '6891',
                                                                                                                  'in_octets': '97075121',
                                                                                                                  'in_ucast_pkts': '927792',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3909686',
                                                                                                                  'out_octets': '7805544508',
                                                                                                                  'out_ucast_pkts': '1848861',
                                                                                                                  'poller_hash': 'MTE5NTE1QnBlZXJpbnRmcG9uIDIxMjYyMA=='},
                                                                                                          {       'in_nucast_pkts': '4890',
                                                                                                                  'in_octets': '72255404135',
                                                                                                                  'in_ucast_pkts': '490107433',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '31247',
                                                                                                                  'out_octets': '2534017611872',
                                                                                                                  'out_ucast_pkts': '1787530247',
                                                                                                                  'poller_hash': 'QkYyNDJBcGVlcmludGZwb24gMjEzMjM4'},
                                                                                                          {       'in_nucast_pkts': '103',
                                                                                                                  'in_octets': '662632',
                                                                                                                  'in_ucast_pkts': '1427',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5964',
                                                                                                                  'out_octets': '922807',
                                                                                                                  'out_ucast_pkts': '1816',
                                                                                                                  'poller_hash': 'MTI3NDlEMXBlZXJpbnRmcG9uIDIzMjMyOQ=='},
                                                                                                          {       'in_nucast_pkts': '133391',
                                                                                                                  'in_octets': '13815649238',
                                                                                                                  'in_ucast_pkts': '144368107',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1474839',
                                                                                                                  'out_octets': '890164622265',
                                                                                                                  'out_ucast_pkts': '595935909',
                                                                                                                  'poller_hash': 'MTI3NEFBNnBlZXJpbnRmcG9uIDIzNDg2NA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '523918719283',
                                                                                         'out_octets': '1102225091885201',
                                                                                         'out_ucast_pkts': '285328650861',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzE=',
                                                                                         'pons': [       {       'id': '2/1',
                                                                                                                 'links': [       {       'connected_time': '15837866',
                                                                                                                                          'fiber_length': 1149,
                                                                                                                                          'poller_hash': 'NTU2M0FCcGVlcnBvbnBvbiAyNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19390487',
                                                                                                                                          'fiber_length': 906,
                                                                                                                                          'poller_hash': 'NEQ0MjNEcGVlcnBvbnBvbiAyNTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19390476',
                                                                                                                                          'fiber_length': 985,
                                                                                                                                          'poller_hash': 'QzUwMTBwZWVycG9ucG9uIDI1NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '16262824',
                                                                                                                                          'fiber_length': 911,
                                                                                                                                          'poller_hash': 'NEQ0MUY3cGVlcnBvbnBvbiAyNTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19390425',
                                                                                                                                          'fiber_length': 949,
                                                                                                                                          'poller_hash': 'QkYxRTFCcGVlcnBvbnBvbiAyNTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19390536',
                                                                                                                                          'fiber_length': 805,
                                                                                                                                          'poller_hash': 'M0ZGRkUzcGVlcnBvbnBvbiAyNjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19390498',
                                                                                                                                          'fiber_length': 712,
                                                                                                                                          'poller_hash': 'NDE4QjdwZWVycG9ucG9uIDI2Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '3934647',
                                                                                                                                          'fiber_length': 841,
                                                                                                                                          'poller_hash': 'MjNBMDAzcGVlcnBvbnBvbiAyNjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'poller_hash': 'NTU1Q0I4cGVlcnBvbnBvbiAyNjk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19390629',
                                                                                                                                          'fiber_length': 967,
                                                                                                                                          'poller_hash': 'MkZDQzMxcGVlcnBvbnBvbiAyNzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19390230',
                                                                                                                                          'fiber_length': 611,
                                                                                                                                          'poller_hash': 'RjIzQTVwZWVycG9ucG9uIDI3MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19390479',
                                                                                                                                          'fiber_length': 588,
                                                                                                                                          'poller_hash': 'MTk5OUY3cGVlcnBvbnBvbiAyNzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '3934631',
                                                                                                                                          'fiber_length': 588,
                                                                                                                                          'poller_hash': 'MTI0ODQ1cGVlcnBvbnBvbiAyNzM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19390420',
                                                                                                                                          'fiber_length': 736,
                                                                                                                                          'poller_hash': 'MTk5OUUxcGVlcnBvbnBvbiAyNzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '11335839',
                                                                                                                                          'fiber_length': 623,
                                                                                                                                          'poller_hash': 'NEQ0MjQycGVlcnBvbnBvbiAyNzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19390449',
                                                                                                                                          'fiber_length': 630,
                                                                                                                                          'poller_hash': 'NDAwN0ZGcGVlcnBvbnBvbiAyNzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '3934673',
                                                                                                                                          'fiber_length': 628,
                                                                                                                                          'poller_hash': 'NzIyMDQxcGVlcnBvbnBvbiAyNzc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19405615',
                                                                                                                                          'fiber_length': 1215,
                                                                                                                                          'poller_hash': 'QTlDOTMxcGVlcnBvbnBvbiAxNTY0NTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '19405599',
                                                                                                                                          'fiber_length': 1042,
                                                                                                                                          'poller_hash': 'QzgzRTBBcGVlcnBvbnBvbiAxNjE2MDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '6721',
                                                                                                                                          'fiber_length': 1256,
                                                                                                                                          'poller_hash': 'QzgzQkFCcGVlcnBvbnBvbiAxNjQyMDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '6734',
                                                                                                                                          'fiber_length': 1018,
                                                                                                                                          'poller_hash': 'MTE5NTE1QnBlZXJwb25wb24gMjEyNjIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '3732203',
                                                                                                                                          'fiber_length': 777,
                                                                                                                                          'poller_hash': 'QkYyNDJBcGVlcnBvbnBvbiAyMTMyMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '6740',
                                                                                                                                          'fiber_length': 903,
                                                                                                                                          'poller_hash': 'MTI3NDlEMXBlZXJwb25wb24gMjMyMzI5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76},
                                                                                                                                  {       'connected_time': '950552',
                                                                                                                                          'fiber_length': 907,
                                                                                                                                          'poller_hash': 'MTI3NEFBNnBlZXJwb25wb24gMjM0ODY0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.76}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/1',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/2',
                                                                                         'in_discards': '134924',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16305443',
                                                                                         'in_octets': '18777330039607',
                                                                                         'in_ucast_pkts': '91126790035',
                                                                                         'links': [       {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '1307374',
                                                                                                                  'in_ucast_pkts': '2937',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2597',
                                                                                                                  'out_octets': '3652864',
                                                                                                                  'out_ucast_pkts': '4135',
                                                                                                                  'poller_hash': 'NDNDM0REcGVlcmludGZwb24gNw=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'NDE1M0NwZWVyaW50ZnBvbiAyNzg='},
                                                                                                          {       'in_nucast_pkts': '21801275',
                                                                                                                  'in_octets': '311955155509',
                                                                                                                  'in_ucast_pkts': '2015351657',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '24655955005',
                                                                                                                  'out_octets': '41946591535655',
                                                                                                                  'out_ucast_pkts': '6805276977',
                                                                                                                  'poller_hash': 'MjVEOEFFcGVlcmludGZwb24gMjc5'},
                                                                                                          {       'in_nucast_pkts': '162',
                                                                                                                  'in_octets': '24020581',
                                                                                                                  'in_ucast_pkts': '118115',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5992',
                                                                                                                  'out_octets': '824961242',
                                                                                                                  'out_ucast_pkts': '622990',
                                                                                                                  'poller_hash': 'QzgxRjQycGVlcmludGZwb24gMjgw'},
                                                                                                          {       'in_nucast_pkts': '15156484',
                                                                                                                  'in_octets': '86000992107',
                                                                                                                  'in_ucast_pkts': '9055557357',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2466636894',
                                                                                                                  'out_octets': '4356489168224',
                                                                                                                  'out_ucast_pkts': '99900129287',
                                                                                                                  'poller_hash': 'NDE4QjhwZWVyaW50ZnBvbiAyODE='},
                                                                                                          {       'in_nucast_pkts': '516437',
                                                                                                                  'in_octets': '137389736777',
                                                                                                                  'in_ucast_pkts': '669302184',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10008488',
                                                                                                                  'out_octets': '4265159692705',
                                                                                                                  'out_ucast_pkts': '3218867203',
                                                                                                                  'poller_hash': 'OTU2RjIycGVlcmludGZwb24gMjgy'},
                                                                                                          {       'in_nucast_pkts': '24505647',
                                                                                                                  'in_octets': '197995437248',
                                                                                                                  'in_ucast_pkts': '1340123825',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '24689151',
                                                                                                                  'out_octets': '4449987972120',
                                                                                                                  'out_ucast_pkts': '3139071004',
                                                                                                                  'poller_hash': 'MkNBMzBEcGVlcmludGZwb24gMjg0'},
                                                                                                          {       'in_nucast_pkts': '5380',
                                                                                                                  'in_octets': '142098873071',
                                                                                                                  'in_ucast_pkts': '1001844999',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1774069',
                                                                                                                  'out_octets': '4011212797549',
                                                                                                                  'out_ucast_pkts': '2900704639',
                                                                                                                  'poller_hash': 'MzI5NTRGcGVlcmludGZwb24gMjg1'},
                                                                                                          {       'in_nucast_pkts': '15',
                                                                                                                  'in_octets': '4319470911',
                                                                                                                  'in_ucast_pkts': '23630517',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1211343',
                                                                                                                  'out_octets': '44071178827',
                                                                                                                  'out_ucast_pkts': '39984799',
                                                                                                                  'poller_hash': 'MTk5QTJEcGVlcmludGZwb24gMjg3'},
                                                                                                          {       'in_nucast_pkts': '147595',
                                                                                                                  'in_octets': '189871096479',
                                                                                                                  'in_ucast_pkts': '743566811',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1796026',
                                                                                                                  'out_octets': '4575313349193',
                                                                                                                  'out_ucast_pkts': '3329722576',
                                                                                                                  'poller_hash': 'MkZFOUYzcGVlcmludGZwb24gMjg4'},
                                                                                                          {       'in_nucast_pkts': '19648811',
                                                                                                                  'in_octets': '66479971072',
                                                                                                                  'in_ucast_pkts': '363976217',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '21488789138',
                                                                                                                  'out_octets': '30418061490747',
                                                                                                                  'out_ucast_pkts': '1173017308',
                                                                                                                  'poller_hash': 'MTY0MjgxcGVlcmludGZwb24gMjg5'},
                                                                                                          {       'in_nucast_pkts': '2967',
                                                                                                                  'in_octets': '1831276',
                                                                                                                  'in_ucast_pkts': '9272',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3891920',
                                                                                                                  'out_octets': '5092443151',
                                                                                                                  'out_ucast_pkts': '32113',
                                                                                                                  'poller_hash': 'NDE1MzVwZWVyaW50ZnBvbiAyOTE='},
                                                                                                          {       'in_nucast_pkts': '203',
                                                                                                                  'in_octets': '270382787191',
                                                                                                                  'in_ucast_pkts': '880254360',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1614785',
                                                                                                                  'out_octets': '3071502914925',
                                                                                                                  'out_ucast_pkts': '2300993401',
                                                                                                                  'poller_hash': 'MzhGMUVBcGVlcmludGZwb24gMjkz'},
                                                                                                          {       'in_nucast_pkts': '63865',
                                                                                                                  'in_octets': '379657399311',
                                                                                                                  'in_ucast_pkts': '2283387458',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1795262',
                                                                                                                  'out_octets': '6744805511674',
                                                                                                                  'out_ucast_pkts': '5132592438',
                                                                                                                  'poller_hash': 'MkVEMDNGcGVlcmludGZwb24gMjk0'},
                                                                                                          {       'in_nucast_pkts': '6040597',
                                                                                                                  'in_octets': '14594691448',
                                                                                                                  'in_ucast_pkts': '165316866',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12925285197',
                                                                                                                  'out_octets': '18360901989696',
                                                                                                                  'out_ucast_pkts': '65227572696',
                                                                                                                  'poller_hash': 'M0QwRkFwZWVyaW50ZnBvbiAyOTU='},
                                                                                                          {       'in_nucast_pkts': '33',
                                                                                                                  'in_octets': '6603152412',
                                                                                                                  'in_ucast_pkts': '28087079',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '56090',
                                                                                                                  'out_octets': '126355089257',
                                                                                                                  'out_ucast_pkts': '91005725',
                                                                                                                  'poller_hash': 'MTJGRkREcGVlcmludGZwb24gMjk2'},
                                                                                                          {       'in_nucast_pkts': '10431',
                                                                                                                  'in_octets': '50507099118',
                                                                                                                  'in_ucast_pkts': '160552554',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1210887',
                                                                                                                  'out_octets': '806143238888',
                                                                                                                  'out_ucast_pkts': '604286210',
                                                                                                                  'poller_hash': 'NzU3QkJwZWVyaW50ZnBvbiAyOTc='},
                                                                                                          {       'in_nucast_pkts': '63376',
                                                                                                                  'in_octets': '42367443294',
                                                                                                                  'in_ucast_pkts': '204842932',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10012177',
                                                                                                                  'out_octets': '585713566340',
                                                                                                                  'out_ucast_pkts': '476657763',
                                                                                                                  'poller_hash': 'QzgzQkYzcGVlcmludGZwb24gMjk4'},
                                                                                                          {       'in_nucast_pkts': '2206806',
                                                                                                                  'in_octets': '25914454643',
                                                                                                                  'in_ucast_pkts': '85855682',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1944988002',
                                                                                                                  'out_octets': '2813429512932',
                                                                                                                  'out_ucast_pkts': '305370113',
                                                                                                                  'poller_hash': 'NDMzRTVGcGVlcmludGZwb24gMjk5'},
                                                                                                          {       'in_nucast_pkts': '17853583',
                                                                                                                  'in_octets': '79222618010',
                                                                                                                  'in_ucast_pkts': '186644321',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '30198972924',
                                                                                                                  'out_octets': '41492348081005',
                                                                                                                  'out_ucast_pkts': '987027839',
                                                                                                                  'poller_hash': 'MzI5NjM2cGVlcmludGZwb24gMzAw'},
                                                                                                          {       'in_nucast_pkts': '57',
                                                                                                                  'in_octets': '21144634',
                                                                                                                  'in_ucast_pkts': '53361',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2645',
                                                                                                                  'out_octets': '82398773',
                                                                                                                  'out_ucast_pkts': '71585',
                                                                                                                  'poller_hash': 'MUM0REE5cGVlcmludGZwb24gMzAy'},
                                                                                                          {       'in_nucast_pkts': '2878247',
                                                                                                                  'in_octets': '87063234176',
                                                                                                                  'in_ucast_pkts': '554546548',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1795490',
                                                                                                                  'out_octets': '1655859910882',
                                                                                                                  'out_ucast_pkts': '1184781852',
                                                                                                                  'poller_hash': 'NzIxRDFDcGVlcmludGZwb24gMzAz'},
                                                                                                          {       'in_nucast_pkts': '150229',
                                                                                                                  'in_octets': '163606364546',
                                                                                                                  'in_ucast_pkts': '754818603',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1775699',
                                                                                                                  'out_octets': '3821601755878',
                                                                                                                  'out_ucast_pkts': '2820763717',
                                                                                                                  'poller_hash': 'NTU2M0YwcGVlcmludGZwb24gMzA0'},
                                                                                                          {       'in_nucast_pkts': '5962',
                                                                                                                  'in_octets': '25154886',
                                                                                                                  'in_ucast_pkts': '90390',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13069095',
                                                                                                                  'out_octets': '17376106460',
                                                                                                                  'out_ucast_pkts': '236630',
                                                                                                                  'poller_hash': 'QzgxRERCcGVlcmludGZwb24gMTM4MDA3'},
                                                                                                          {       'in_nucast_pkts': '3351875',
                                                                                                                  'in_octets': '127511511418',
                                                                                                                  'in_ucast_pkts': '463063344',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '161472',
                                                                                                                  'out_octets': '2119517783197',
                                                                                                                  'out_ucast_pkts': '1594713218',
                                                                                                                  'poller_hash': 'MzhGMThCcGVlcmludGZwb24gMTY2NzY4'},
                                                                                                          {       'in_nucast_pkts': '168255',
                                                                                                                  'in_octets': '13100541',
                                                                                                                  'in_ucast_pkts': '18178',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1737578',
                                                                                                                  'out_octets': '2207042566',
                                                                                                                  'out_ucast_pkts': '66469',
                                                                                                                  'poller_hash': 'QzgxRTNGcGVlcmludGZwb24gMjA3MzYy'},
                                                                                                          {       'in_nucast_pkts': '18355309',
                                                                                                                  'in_octets': '290615649642',
                                                                                                                  'in_ucast_pkts': '541303528',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5067286309',
                                                                                                                  'out_octets': '7491036985471',
                                                                                                                  'out_ucast_pkts': '1184831519',
                                                                                                                  'poller_hash': 'QzgxREI3cGVlcmludGZwb24gMjA3ODMw'},
                                                                                                          {       'in_nucast_pkts': '3060012',
                                                                                                                  'in_octets': '928681346',
                                                                                                                  'in_ucast_pkts': '3407962',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9350202451',
                                                                                                                  'out_octets': '12404096297012',
                                                                                                                  'out_ucast_pkts': '2504845',
                                                                                                                  'poller_hash': 'MTI3NTE4Q3BlZXJpbnRmcG9uIDIyMTExMA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '535988060477',
                                                                                         'out_octets': '1093265071724613',
                                                                                         'out_ucast_pkts': '267703082541',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzI=',
                                                                                         'pons': [       {       'id': '2/2',
                                                                                                                 'links': [       {       'connected_time': '6499',
                                                                                                                                          'fiber_length': 1303,
                                                                                                                                          'poller_hash': 'NDNDM0REcGVlcnBvbnBvbiA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390507',
                                                                                                                                          'fiber_length': 432,
                                                                                                                                          'poller_hash': 'NDE1M0NwZWVycG9ucG9uIDI3OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390135',
                                                                                                                                          'fiber_length': 519,
                                                                                                                                          'poller_hash': 'MjVEOEFFcGVlcnBvbnBvbiAyNzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '6663',
                                                                                                                                          'fiber_length': 599,
                                                                                                                                          'poller_hash': 'QzgxRjQycGVlcnBvbnBvbiAyODA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390496',
                                                                                                                                          'fiber_length': 432,
                                                                                                                                          'poller_hash': 'NDE4QjhwZWVycG9ucG9uIDI4MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19405695',
                                                                                                                                          'fiber_length': 644,
                                                                                                                                          'poller_hash': 'OTU2RjIycGVlcnBvbnBvbiAyODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390226',
                                                                                                                                          'fiber_length': 445,
                                                                                                                                          'poller_hash': 'MkNBMzBEcGVlcnBvbnBvbiAyODQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390508',
                                                                                                                                          'fiber_length': 469,
                                                                                                                                          'poller_hash': 'MzI5NTRGcGVlcnBvbnBvbiAyODU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '3934713',
                                                                                                                                          'fiber_length': 542,
                                                                                                                                          'poller_hash': 'MTk5QTJEcGVlcnBvbnBvbiAyODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390559',
                                                                                                                                          'fiber_length': 1385,
                                                                                                                                          'poller_hash': 'MkZFOUYzcGVlcnBvbnBvbiAyODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390588',
                                                                                                                                          'fiber_length': 1386,
                                                                                                                                          'poller_hash': 'MTY0MjgxcGVlcnBvbnBvbiAyODk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '6660',
                                                                                                                                          'fiber_length': 1308,
                                                                                                                                          'poller_hash': 'NDE1MzVwZWVycG9ucG9uIDI5MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '13389813',
                                                                                                                                          'fiber_length': 1246,
                                                                                                                                          'poller_hash': 'MzhGMUVBcGVlcnBvbnBvbiAyOTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19378214',
                                                                                                                                          'fiber_length': 1254,
                                                                                                                                          'poller_hash': 'MkVEMDNGcGVlcnBvbnBvbiAyOTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390263',
                                                                                                                                          'fiber_length': 1144,
                                                                                                                                          'poller_hash': 'M0QwRkFwZWVycG9ucG9uIDI5NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '182063',
                                                                                                                                          'fiber_length': 1263,
                                                                                                                                          'poller_hash': 'MTJGRkREcGVlcnBvbnBvbiAyOTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '3934810',
                                                                                                                                          'fiber_length': 1209,
                                                                                                                                          'poller_hash': 'NzU3QkJwZWVycG9ucG9uIDI5Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19405698',
                                                                                                                                          'fiber_length': 1469,
                                                                                                                                          'poller_hash': 'QzgzQkYzcGVlcnBvbnBvbiAyOTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '3934754',
                                                                                                                                          'fiber_length': 1380,
                                                                                                                                          'poller_hash': 'NDMzRTVGcGVlcnBvbnBvbiAyOTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390560',
                                                                                                                                          'fiber_length': 1436,
                                                                                                                                          'poller_hash': 'MzI5NjM2cGVlcnBvbnBvbiAzMDA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '6676',
                                                                                                                                          'fiber_length': 1130,
                                                                                                                                          'poller_hash': 'MUM0REE5cGVlcnBvbnBvbiAzMDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390299',
                                                                                                                                          'fiber_length': 1075,
                                                                                                                                          'poller_hash': 'NzIxRDFDcGVlcnBvbnBvbiAzMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19136257',
                                                                                                                                          'fiber_length': 1080,
                                                                                                                                          'poller_hash': 'NTU2M0YwcGVlcnBvbnBvbiAzMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '6707',
                                                                                                                                          'fiber_length': 577,
                                                                                                                                          'poller_hash': 'QzgxRERCcGVlcnBvbnBvbiAxMzgwMDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19390424',
                                                                                                                                          'fiber_length': 1421,
                                                                                                                                          'poller_hash': 'MzhGMThCcGVlcnBvbnBvbiAxNjY3Njg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '6733',
                                                                                                                                          'fiber_length': 687,
                                                                                                                                          'poller_hash': 'QzgxRTNGcGVlcnBvbnBvbiAyMDczNjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '19405760',
                                                                                                                                          'fiber_length': 1454,
                                                                                                                                          'poller_hash': 'QzgxREI3cGVlcnBvbnBvbiAyMDc4MzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56},
                                                                                                                                  {       'connected_time': '11582373',
                                                                                                                                          'fiber_length': 1569,
                                                                                                                                          'poller_hash': 'MTI3NTE4Q3BlZXJwb25wb24gMjIxMTEw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.56}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/2',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/3',
                                                                                         'in_discards': '131790',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '25134160',
                                                                                         'in_octets': '24738111874639',
                                                                                         'in_ucast_pkts': '96018505693',
                                                                                         'links': [       {       'oper_up': False,
                                                                                                                  'poller_hash': 'NTEyNTg5cGVlcmludGZwb24gNDE='},
                                                                                                          {       'in_nucast_pkts': '253',
                                                                                                                  'in_octets': '170802052',
                                                                                                                  'in_ucast_pkts': '593439',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2676',
                                                                                                                  'out_octets': '1832463179',
                                                                                                                  'out_ucast_pkts': '1666268',
                                                                                                                  'poller_hash': 'MkFBODc4cGVlcmludGZwb24gMjM0'},
                                                                                                          {       'in_nucast_pkts': '929889',
                                                                                                                  'in_octets': '11947494846',
                                                                                                                  'in_ucast_pkts': '8628691512',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1770218',
                                                                                                                  'out_octets': '64601639033',
                                                                                                                  'out_ucast_pkts': '62821130',
                                                                                                                  'poller_hash': 'MTM1NDhwZWVyaW50ZnBvbiAyODY='},
                                                                                                          {       'in_nucast_pkts': '20658064',
                                                                                                                  'in_octets': '188725167571',
                                                                                                                  'in_ucast_pkts': '723635535',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '27263990910',
                                                                                                                  'out_octets': '38842257337939',
                                                                                                                  'out_ucast_pkts': '1960086094',
                                                                                                                  'poller_hash': 'MzhGMTExcGVlcmludGZwb24gMzA2'},
                                                                                                          {       'in_nucast_pkts': '3872887',
                                                                                                                  'in_octets': '8998916493',
                                                                                                                  'in_ucast_pkts': '25459813',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6187734927',
                                                                                                                  'out_octets': '8392029450276',
                                                                                                                  'out_ucast_pkts': '55999496',
                                                                                                                  'poller_hash': 'NDAwOERDcGVlcmludGZwb24gMzA3'},
                                                                                                          {       'in_nucast_pkts': '5676860',
                                                                                                                  'in_octets': '306482579498',
                                                                                                                  'in_ucast_pkts': '2090872194',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14441545005',
                                                                                                                  'out_octets': '27156859106746',
                                                                                                                  'out_ucast_pkts': '5705991080',
                                                                                                                  'poller_hash': 'MTMwMDhEcGVlcmludGZwb24gMzA4'},
                                                                                                          {       'in_nucast_pkts': '860796',
                                                                                                                  'in_octets': '214424113',
                                                                                                                  'in_ucast_pkts': '806482',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '390843135',
                                                                                                                  'out_octets': '458706087961',
                                                                                                                  'out_ucast_pkts': '597657',
                                                                                                                  'poller_hash': 'MTk5OUY2cGVlcmludGZwb24gMzA5'},
                                                                                                          {       'in_nucast_pkts': '8042334',
                                                                                                                  'in_octets': '244201916993',
                                                                                                                  'in_ucast_pkts': '1808128021',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1269188683',
                                                                                                                  'out_octets': '6468917095396',
                                                                                                                  'out_ucast_pkts': '3865480877',
                                                                                                                  'poller_hash': 'MkM5QTBFcGVlcmludGZwb24gMzEw'},
                                                                                                          {       'in_nucast_pkts': '18217',
                                                                                                                  'in_octets': '1173872597785',
                                                                                                                  'in_ucast_pkts': '2458906468',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '131462',
                                                                                                                  'out_octets': '6325934795985',
                                                                                                                  'out_ucast_pkts': '5008128834',
                                                                                                                  'poller_hash': 'MjQ4QUQycGVlcmludGZwb24gMzEy'},
                                                                                                          {       'in_nucast_pkts': '9766778',
                                                                                                                  'in_octets': '19910732650',
                                                                                                                  'in_ucast_pkts': '130152254',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '28169619805',
                                                                                                                  'out_octets': '38145939495360',
                                                                                                                  'out_ucast_pkts': '488426845',
                                                                                                                  'poller_hash': 'QzgzMDkzcGVlcmludGZwb24gMzEz'},
                                                                                                          {       'in_nucast_pkts': '10',
                                                                                                                  'in_octets': '9462553',
                                                                                                                  'in_ucast_pkts': '80212',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6011',
                                                                                                                  'out_octets': '478721031',
                                                                                                                  'out_ucast_pkts': '337548',
                                                                                                                  'poller_hash': 'ODcyNEZDcGVlcmludGZwb24gMzE0'},
                                                                                                          {       'in_nucast_pkts': '10745104',
                                                                                                                  'in_octets': '396154933578',
                                                                                                                  'in_ucast_pkts': '1514991685',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5764532551',
                                                                                                                  'out_octets': '11906544704106',
                                                                                                                  'out_ucast_pkts': '3747742655',
                                                                                                                  'poller_hash': 'ODZCOEJwZWVyaW50ZnBvbiAzMTU='},
                                                                                                          {       'in_nucast_pkts': '9679',
                                                                                                                  'in_octets': '96410111662',
                                                                                                                  'in_ucast_pkts': '429851685',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1796631',
                                                                                                                  'out_octets': '2079463342133',
                                                                                                                  'out_ucast_pkts': '1528206771',
                                                                                                                  'poller_hash': 'NzIzNjRFcGVlcmludGZwb24gMzE2'},
                                                                                                          {       'in_nucast_pkts': '96613',
                                                                                                                  'in_octets': '24240514585',
                                                                                                                  'in_ucast_pkts': '114289857',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1211254',
                                                                                                                  'out_octets': '893291469891',
                                                                                                                  'out_ucast_pkts': '668250847',
                                                                                                                  'poller_hash': 'MTc2MjEwcGVlcmludGZwb24gMzE3'},
                                                                                                          {       'in_nucast_pkts': '6091772',
                                                                                                                  'in_octets': '1142901481597',
                                                                                                                  'in_ucast_pkts': '2004765165',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10561500851',
                                                                                                                  'out_octets': '19601662196897',
                                                                                                                  'out_ucast_pkts': '4181779246',
                                                                                                                  'poller_hash': 'NzZFOUJBcGVlcmludGZwb24gMzE4'},
                                                                                                          {       'in_nucast_pkts': '5605685',
                                                                                                                  'in_octets': '10890455903',
                                                                                                                  'in_ucast_pkts': '44819475',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13016674553',
                                                                                                                  'out_octets': '17375420056144',
                                                                                                                  'out_ucast_pkts': '97711529',
                                                                                                                  'poller_hash': 'NEQ0MjREcGVlcmludGZwb24gMzE5'},
                                                                                                          {       'in_nucast_pkts': '6650',
                                                                                                                  'in_octets': '321368511711',
                                                                                                                  'in_ucast_pkts': '1356378491',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1795304',
                                                                                                                  'out_octets': '6027640647676',
                                                                                                                  'out_ucast_pkts': '4636614720',
                                                                                                                  'poller_hash': 'MjQ4QUM2cGVlcmludGZwb24gMzIw'},
                                                                                                          {       'in_nucast_pkts': '116',
                                                                                                                  'in_octets': '633616228',
                                                                                                                  'in_ucast_pkts': '789031',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5975',
                                                                                                                  'out_octets': '685521989',
                                                                                                                  'out_ucast_pkts': '769949',
                                                                                                                  'poller_hash': 'NUE2QzkycGVlcmludGZwb24gMTM5MTkw'},
                                                                                                          {       'in_nucast_pkts': '3735',
                                                                                                                  'in_octets': '19462801',
                                                                                                                  'in_ucast_pkts': '38274',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5348745',
                                                                                                                  'out_octets': '7072172115',
                                                                                                                  'out_ucast_pkts': '31106',
                                                                                                                  'poller_hash': 'Q0JEMjlBcGVlcmludGZwb24gMTY1MDUw'},
                                                                                                          {       'in_nucast_pkts': '64669',
                                                                                                                  'in_octets': '50965696903',
                                                                                                                  'in_ucast_pkts': '308802842',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4139650',
                                                                                                                  'out_octets': '890783133858',
                                                                                                                  'out_ucast_pkts': '646874580',
                                                                                                                  'poller_hash': 'QzgzQkEzcGVlcmludGZwb24gMTY4NTY0'},
                                                                                                          {       'in_nucast_pkts': '94279',
                                                                                                                  'in_octets': '7337300732',
                                                                                                                  'in_ucast_pkts': '30814978',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1211309',
                                                                                                                  'out_octets': '209506941914',
                                                                                                                  'out_ucast_pkts': '173670528',
                                                                                                                  'poller_hash': 'NzIzQTEwcGVlcmludGZwb24gMTcxNzE5'},
                                                                                                          {       'in_nucast_pkts': '2104',
                                                                                                                  'in_octets': '26605757',
                                                                                                                  'in_ucast_pkts': '83113',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3921812',
                                                                                                                  'out_octets': '5550642457',
                                                                                                                  'out_ucast_pkts': '359996',
                                                                                                                  'poller_hash': 'QzgzQkRBcGVlcmludGZwb24gMTcxOTg3'},
                                                                                                          {       'in_nucast_pkts': '3884',
                                                                                                                  'in_octets': '10169215',
                                                                                                                  'in_ucast_pkts': '51555',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7850292',
                                                                                                                  'out_octets': '10281436319',
                                                                                                                  'out_ucast_pkts': '77975',
                                                                                                                  'poller_hash': 'QzgzQjlDcGVlcmludGZwb24gMTkzNjIy'},
                                                                                                          {       'in_nucast_pkts': '126',
                                                                                                                  'in_octets': '152851416',
                                                                                                                  'in_ucast_pkts': '1492304',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5988',
                                                                                                                  'out_octets': '4792654911',
                                                                                                                  'out_ucast_pkts': '3234660',
                                                                                                                  'poller_hash': 'MTFCMjVBOXBlZXJpbnRmcG9uIDIxNTc4Mw=='},
                                                                                                          {       'in_nucast_pkts': '28129',
                                                                                                                  'in_octets': '48968436913',
                                                                                                                  'in_ucast_pkts': '304402641',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4068498',
                                                                                                                  'out_octets': '2239498564424',
                                                                                                                  'out_ucast_pkts': '1560952084',
                                                                                                                  'poller_hash': 'RUJDMkVFcGVlcmludGZwb24gMjMxMzg4'},
                                                                                                          {       'in_nucast_pkts': '6',
                                                                                                                  'in_octets': '3911113',
                                                                                                                  'in_ucast_pkts': '18728',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3633',
                                                                                                                  'out_octets': '19524241',
                                                                                                                  'out_ucast_pkts': '23142',
                                                                                                                  'poller_hash': 'MTI3NEEzMHBlZXJpbnRmcG9uIDIzNDgyNA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '444734828686',
                                                                                         'out_octets': '967320141088931',
                                                                                         'out_ucast_pkts': '267965607976',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzM=',
                                                                                         'pons': [       {       'id': '2/3',
                                                                                                                 'links': [       {       'poller_hash': 'NTEyNTg5cGVlcnBvbnBvbiA0MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '6628',
                                                                                                                                          'fiber_length': 1156,
                                                                                                                                          'poller_hash': 'MkFBODc4cGVlcnBvbnBvbiAyMzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '3934614',
                                                                                                                                          'fiber_length': 384,
                                                                                                                                          'poller_hash': 'MTM1NDhwZWVycG9ucG9uIDI4Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '19390417',
                                                                                                                                          'fiber_length': 924,
                                                                                                                                          'poller_hash': 'MzhGMTExcGVlcnBvbnBvbiAzMDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '3934705',
                                                                                                                                          'fiber_length': 1238,
                                                                                                                                          'poller_hash': 'NDAwOERDcGVlcnBvbnBvbiAzMDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '19390734',
                                                                                                                                          'fiber_length': 1016,
                                                                                                                                          'poller_hash': 'MTMwMDhEcGVlcnBvbnBvbiAzMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '2432075',
                                                                                                                                          'fiber_length': 996,
                                                                                                                                          'poller_hash': 'MTk5OUY2cGVlcnBvbnBvbiAzMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '19390512',
                                                                                                                                          'fiber_length': 985,
                                                                                                                                          'poller_hash': 'MkM5QTBFcGVlcnBvbnBvbiAzMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '15738139',
                                                                                                                                          'fiber_length': 859,
                                                                                                                                          'poller_hash': 'MjQ4QUQycGVlcnBvbnBvbiAzMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '19405631',
                                                                                                                                          'fiber_length': 952,
                                                                                                                                          'poller_hash': 'QzgzMDkzcGVlcnBvbnBvbiAzMTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '6686',
                                                                                                                                          'fiber_length': 1001,
                                                                                                                                          'poller_hash': 'ODcyNEZDcGVlcnBvbnBvbiAzMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '19390424',
                                                                                                                                          'fiber_length': 824,
                                                                                                                                          'poller_hash': 'ODZCOEJwZWVycG9ucG9uIDMxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '19390558',
                                                                                                                                          'fiber_length': 899,
                                                                                                                                          'poller_hash': 'NzIzNjRFcGVlcnBvbnBvbiAzMTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '3934692',
                                                                                                                                          'fiber_length': 717,
                                                                                                                                          'poller_hash': 'MTc2MjEwcGVlcnBvbnBvbiAzMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '19390480',
                                                                                                                                          'fiber_length': 780,
                                                                                                                                          'poller_hash': 'NzZFOUJBcGVlcnBvbnBvbiAzMTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '19390586',
                                                                                                                                          'fiber_length': 666,
                                                                                                                                          'poller_hash': 'NEQ0MjREcGVlcnBvbnBvbiAzMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '19390864',
                                                                                                                                          'fiber_length': 1276,
                                                                                                                                          'poller_hash': 'MjQ4QUM2cGVlcnBvbnBvbiAzMjA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '6706',
                                                                                                                                          'fiber_length': 1054,
                                                                                                                                          'poller_hash': 'NUE2QzkycGVlcnBvbnBvbiAxMzkxOTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '6721',
                                                                                                                                          'fiber_length': 1326,
                                                                                                                                          'poller_hash': 'Q0JEMjlBcGVlcnBvbnBvbiAxNjUwNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '8034416',
                                                                                                                                          'fiber_length': 1019,
                                                                                                                                          'poller_hash': 'QzgzQkEzcGVlcnBvbnBvbiAxNjg1NjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '3934764',
                                                                                                                                          'fiber_length': 1006,
                                                                                                                                          'poller_hash': 'NzIzQTEwcGVlcnBvbnBvbiAxNzE3MTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '6728',
                                                                                                                                          'fiber_length': 1384,
                                                                                                                                          'poller_hash': 'QzgzQkRBcGVlcnBvbnBvbiAxNzE5ODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '6729',
                                                                                                                                          'fiber_length': 1245,
                                                                                                                                          'poller_hash': 'QzgzQjlDcGVlcnBvbnBvbiAxOTM2MjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '6736',
                                                                                                                                          'fiber_length': 889,
                                                                                                                                          'poller_hash': 'MTFCMjVBOXBlZXJwb25wb24gMjE1Nzgz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '5775457',
                                                                                                                                          'fiber_length': 1055,
                                                                                                                                          'poller_hash': 'RUJDMkVFcGVlcnBvbnBvbiAyMzEzODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03},
                                                                                                                                  {       'connected_time': '6740',
                                                                                                                                          'fiber_length': 1256,
                                                                                                                                          'poller_hash': 'MTI3NEEzMHBlZXJwb25wb24gMjM0ODI0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.03}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/3',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/4',
                                                                                         'in_discards': '153031',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '7606446',
                                                                                         'in_octets': '24579055106510',
                                                                                         'in_ucast_pkts': '81503305038',
                                                                                         'links': [       {       'in_nucast_pkts': '19287',
                                                                                                                  'in_octets': '30787884715',
                                                                                                                  'in_ucast_pkts': '232265167',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6023026',
                                                                                                                  'out_octets': '1150743813311',
                                                                                                                  'out_ucast_pkts': '792266529',
                                                                                                                  'poller_hash': 'MzIyODY1cGVlcmludGZwb24gMjM='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'RjBGOHBlZXJpbnRmcG9uIDEyMw=='},
                                                                                                          {       'in_nucast_pkts': '6551',
                                                                                                                  'in_octets': '22940297',
                                                                                                                  'in_ucast_pkts': '28119',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10736023',
                                                                                                                  'out_octets': '14147961673',
                                                                                                                  'out_ucast_pkts': '17017',
                                                                                                                  'poller_hash': 'NDI4MTZFcGVlcmludGZwb24gMjMx'},
                                                                                                          {       'in_nucast_pkts': '1256239',
                                                                                                                  'in_octets': '1388074469',
                                                                                                                  'in_ucast_pkts': '5327340',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '325758649',
                                                                                                                  'out_octets': '337206193596',
                                                                                                                  'out_ucast_pkts': '12046504',
                                                                                                                  'poller_hash': 'MUY3REExcGVlcmludGZwb24gMjMy'},
                                                                                                          {       'in_nucast_pkts': '49',
                                                                                                                  'in_octets': '16480843',
                                                                                                                  'in_ucast_pkts': '49782',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2338',
                                                                                                                  'out_octets': '84973704',
                                                                                                                  'out_ucast_pkts': '83819',
                                                                                                                  'poller_hash': 'MkFBOTQ2cGVlcmludGZwb24gMjMz'},
                                                                                                          {       'in_nucast_pkts': '37',
                                                                                                                  'in_octets': '531391503',
                                                                                                                  'in_ucast_pkts': '1029760',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '120',
                                                                                                                  'out_octets': '2144274355',
                                                                                                                  'out_ucast_pkts': '2016822',
                                                                                                                  'poller_hash': 'MzNBRDA5cGVlcmludGZwb24gMjM1'},
                                                                                                          {       'in_nucast_pkts': '6063804',
                                                                                                                  'in_octets': '160591706135',
                                                                                                                  'in_ucast_pkts': '1239587452',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6555258001',
                                                                                                                  'out_octets': '14695716964259',
                                                                                                                  'out_ucast_pkts': '4372807076',
                                                                                                                  'poller_hash': 'M0FFQzFGcGVlcmludGZwb24gMjM2'},
                                                                                                          {       'in_nucast_pkts': '139',
                                                                                                                  'in_octets': '3668900',
                                                                                                                  'in_ucast_pkts': '23796',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '114',
                                                                                                                  'out_octets': '80453298',
                                                                                                                  'out_ucast_pkts': '58267',
                                                                                                                  'poller_hash': 'M0FFQkM4cGVlcmludGZwb24gMjM3'},
                                                                                                          {       'in_nucast_pkts': '20003',
                                                                                                                  'in_octets': '228472421465',
                                                                                                                  'in_ucast_pkts': '630446986',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1211307',
                                                                                                                  'out_octets': '1131625907871',
                                                                                                                  'out_ucast_pkts': '933245760',
                                                                                                                  'poller_hash': 'MjVEOTJCcGVlcmludGZwb24gMzI0'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'MzI5NjM3cGVlcmludGZwb24gMzI1'},
                                                                                                          {       'in_nucast_pkts': '1944',
                                                                                                                  'in_octets': '20164724',
                                                                                                                  'in_ucast_pkts': '94843',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3867330',
                                                                                                                  'out_octets': '5778892593',
                                                                                                                  'out_ucast_pkts': '618905',
                                                                                                                  'poller_hash': 'NDJDOEZBcGVlcmludGZwb24gMzI2'},
                                                                                                          {       'in_nucast_pkts': '1056192',
                                                                                                                  'in_octets': '26365771401',
                                                                                                                  'in_ucast_pkts': '113952015',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '743337601',
                                                                                                                  'out_octets': '1642295357556',
                                                                                                                  'out_ucast_pkts': '534608490',
                                                                                                                  'poller_hash': 'MjQ4QUVBcGVlcmludGZwb24gMzI3'},
                                                                                                          {       'in_nucast_pkts': '8824',
                                                                                                                  'in_octets': '53198956754',
                                                                                                                  'in_ucast_pkts': '239196633',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1211308',
                                                                                                                  'out_octets': '909439560924',
                                                                                                                  'out_ucast_pkts': '661383837',
                                                                                                                  'poller_hash': 'NDZDRTBBcGVlcmludGZwb24gMzI4'},
                                                                                                          {       'in_nucast_pkts': '90950',
                                                                                                                  'in_octets': '59448885386',
                                                                                                                  'in_ucast_pkts': '182887204',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1111663',
                                                                                                                  'out_octets': '789917239027',
                                                                                                                  'out_ucast_pkts': '581034262',
                                                                                                                  'poller_hash': 'MjQ4QUY0cGVlcmludGZwb24gMzI5'},
                                                                                                          {       'in_nucast_pkts': '322',
                                                                                                                  'in_octets': '47717875942',
                                                                                                                  'in_ucast_pkts': '196964991',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '32887',
                                                                                                                  'out_octets': '792377596220',
                                                                                                                  'out_ucast_pkts': '569578065',
                                                                                                                  'poller_hash': 'NzZBQ0U4cGVlcmludGZwb24gMzMw'},
                                                                                                          {       'in_nucast_pkts': '113279',
                                                                                                                  'in_octets': '194117393223',
                                                                                                                  'in_ucast_pkts': '1038358572',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1589310',
                                                                                                                  'out_octets': '4311319537400',
                                                                                                                  'out_ucast_pkts': '3185021365',
                                                                                                                  'poller_hash': 'NzU3QUNwZWVyaW50ZnBvbiAzMzE='},
                                                                                                          {       'in_nucast_pkts': '150697',
                                                                                                                  'in_octets': '177238807980',
                                                                                                                  'in_ucast_pkts': '575607041',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1797257',
                                                                                                                  'out_octets': '2412957082437',
                                                                                                                  'out_ucast_pkts': '1938919251',
                                                                                                                  'poller_hash': 'NzFBNERCcGVlcmludGZwb24gMzMy'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'M0NGQUFwZWVyaW50ZnBvbiAzMzM='},
                                                                                                          {       'in_nucast_pkts': '1490229',
                                                                                                                  'in_octets': '19954899302',
                                                                                                                  'in_ucast_pkts': '78667084',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1210118',
                                                                                                                  'out_octets': '468285510860',
                                                                                                                  'out_ucast_pkts': '343001860',
                                                                                                                  'poller_hash': 'RjIzQ3BlZXJpbnRmcG9uIDMzNA=='},
                                                                                                          {       'in_nucast_pkts': '36948',
                                                                                                                  'in_octets': '251469770297',
                                                                                                                  'in_ucast_pkts': '1398339481',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1795350',
                                                                                                                  'out_octets': '6058710514711',
                                                                                                                  'out_ucast_pkts': '4653863202',
                                                                                                                  'poller_hash': 'MTY0Mjc3cGVlcmludGZwb24gMzM1'},
                                                                                                          {       'in_nucast_pkts': '19012541',
                                                                                                                  'in_octets': '94960021055',
                                                                                                                  'in_ucast_pkts': '350722652',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13147146715',
                                                                                                                  'out_octets': '18678310559591',
                                                                                                                  'out_ucast_pkts': '968575113',
                                                                                                                  'poller_hash': 'NTU2M0QzcGVlcmludGZwb24gMzM2'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'M0NGQTZwZWVyaW50ZnBvbiAzMzg='},
                                                                                                          {       'in_nucast_pkts': '8253',
                                                                                                                  'in_octets': '165374421301',
                                                                                                                  'in_ucast_pkts': '351092938',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1796522',
                                                                                                                  'out_octets': '435455582826',
                                                                                                                  'out_ucast_pkts': '1666939416014',
                                                                                                                  'poller_hash': 'MTU0NURwZWVyaW50ZnBvbiAzMzk='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODY3OEI2cGVlcmludGZwb24gMzQ3'},
                                                                                                          {       'in_nucast_pkts': '166',
                                                                                                                  'in_octets': '89682885',
                                                                                                                  'in_ucast_pkts': '267193',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5970',
                                                                                                                  'out_octets': '178698641',
                                                                                                                  'out_ucast_pkts': '285732',
                                                                                                                  'poller_hash': 'NUE2Qjk5cGVlcmludGZwb24gMTM5MTk4'},
                                                                                                          {       'in_nucast_pkts': '127',
                                                                                                                  'in_octets': '44964449',
                                                                                                                  'in_ucast_pkts': '64450',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3619',
                                                                                                                  'out_octets': '121980786',
                                                                                                                  'out_ucast_pkts': '105476',
                                                                                                                  'poller_hash': 'ODY5M0M2cGVlcmludGZwb24gMTQyMzU2'},
                                                                                                          {       'in_nucast_pkts': '2027',
                                                                                                                  'in_octets': '21948636',
                                                                                                                  'in_ucast_pkts': '83941',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5023827',
                                                                                                                  'out_octets': '6845382029',
                                                                                                                  'out_ucast_pkts': '225695',
                                                                                                                  'poller_hash': 'MzQ5RDZFcGVlcmludGZwb24gMTQ4MTI1'},
                                                                                                          {       'in_nucast_pkts': '19768465',
                                                                                                                  'in_octets': '110706912233',
                                                                                                                  'in_ucast_pkts': '517452217',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26467589695',
                                                                                                                  'out_octets': '39060079528207',
                                                                                                                  'out_ucast_pkts': '2393069937',
                                                                                                                  'poller_hash': 'QzgzQkNDcGVlcmludGZwb24gMTY2NjU4'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTI3NTBEM3BlZXJpbnRmcG9uIDIxNzcxNg=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '520418641877',
                                                                                         'out_octets': '978133959204303',
                                                                                         'out_ucast_pkts': '205304006253',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzQ=',
                                                                                         'pons': [       {       'id': '2/4',
                                                                                                                 'links': [       {       'connected_time': '9134549',
                                                                                                                                          'fiber_length': 1082,
                                                                                                                                          'poller_hash': 'MzIyODY1cGVlcnBvbnBvbiAyMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '1009362',
                                                                                                                                          'fiber_length': 795,
                                                                                                                                          'poller_hash': 'RjBGOHBlZXJwb25wb24gMTIz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6626',
                                                                                                                                          'fiber_length': 930,
                                                                                                                                          'poller_hash': 'NDI4MTZFcGVlcnBvbnBvbiAyMzE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '3934616',
                                                                                                                                          'fiber_length': 576,
                                                                                                                                          'poller_hash': 'MUY3REExcGVlcnBvbnBvbiAyMzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6516',
                                                                                                                                          'fiber_length': 936,
                                                                                                                                          'poller_hash': 'MkFBOTQ2cGVlcnBvbnBvbiAyMzM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6628',
                                                                                                                                          'fiber_length': 959,
                                                                                                                                          'poller_hash': 'MzNBRDA5cGVlcnBvbnBvbiAyMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '19374449',
                                                                                                                                          'fiber_length': 598,
                                                                                                                                          'poller_hash': 'M0FFQzFGcGVlcnBvbnBvbiAyMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6630',
                                                                                                                                          'fiber_length': 573,
                                                                                                                                          'poller_hash': 'M0FFQkM4cGVlcnBvbnBvbiAyMzc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '3934728',
                                                                                                                                          'fiber_length': 865,
                                                                                                                                          'poller_hash': 'MjVEOTJCcGVlcnBvbnBvbiAzMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'poller_hash': 'MzI5NjM3cGVlcnBvbnBvbiAzMjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6694',
                                                                                                                                          'fiber_length': 938,
                                                                                                                                          'poller_hash': 'NDJDOEZBcGVlcnBvbnBvbiAzMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '3934754',
                                                                                                                                          'fiber_length': 861,
                                                                                                                                          'poller_hash': 'MjQ4QUVBcGVlcnBvbnBvbiAzMjc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '3934715',
                                                                                                                                          'fiber_length': 572,
                                                                                                                                          'poller_hash': 'NDZDRTBBcGVlcnBvbnBvbiAzMjg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '3934597',
                                                                                                                                          'fiber_length': 487,
                                                                                                                                          'poller_hash': 'MjQ4QUY0cGVlcnBvbnBvbiAzMjk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '3934706',
                                                                                                                                          'fiber_length': 462,
                                                                                                                                          'poller_hash': 'NzZBQ0U4cGVlcnBvbnBvbiAzMzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '12776379',
                                                                                                                                          'fiber_length': 553,
                                                                                                                                          'poller_hash': 'NzU3QUNwZWVycG9ucG9uIDMzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '19390509',
                                                                                                                                          'fiber_length': 640,
                                                                                                                                          'poller_hash': 'NzFBNERCcGVlcnBvbnBvbiAzMzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6692',
                                                                                                                                          'fiber_length': 497,
                                                                                                                                          'poller_hash': 'M0NGQUFwZWVycG9ucG9uIDMzMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '3934631',
                                                                                                                                          'fiber_length': 480,
                                                                                                                                          'poller_hash': 'RjIzQ3BlZXJwb25wb24gMzM0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '19390501',
                                                                                                                                          'fiber_length': 395,
                                                                                                                                          'poller_hash': 'MTY0Mjc3cGVlcnBvbnBvbiAzMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '19390739',
                                                                                                                                          'fiber_length': 368,
                                                                                                                                          'poller_hash': 'NTU2M0QzcGVlcnBvbnBvbiAzMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '3934641',
                                                                                                                                          'fiber_length': 440,
                                                                                                                                          'poller_hash': 'M0NGQTZwZWVycG9ucG9uIDMzOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '19390108',
                                                                                                                                          'fiber_length': 495,
                                                                                                                                          'poller_hash': 'MTU0NURwZWVycG9ucG9uIDMzOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6706',
                                                                                                                                          'fiber_length': 878,
                                                                                                                                          'poller_hash': 'ODY3OEI2cGVlcnBvbnBvbiAzNDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6706',
                                                                                                                                          'fiber_length': 1023,
                                                                                                                                          'poller_hash': 'NUE2Qjk5cGVlcnBvbnBvbiAxMzkxOTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6711',
                                                                                                                                          'fiber_length': 1290,
                                                                                                                                          'poller_hash': 'ODY5M0M2cGVlcnBvbnBvbiAxNDIzNTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6714',
                                                                                                                                          'fiber_length': 883,
                                                                                                                                          'poller_hash': 'MzQ5RDZFcGVlcnBvbnBvbiAxNDgxMjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '19405712',
                                                                                                                                          'fiber_length': 469,
                                                                                                                                          'poller_hash': 'QzgzQkNDcGVlcnBvbnBvbiAxNjY2NTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843},
                                                                                                                                  {       'connected_time': '6737',
                                                                                                                                          'fiber_length': 707,
                                                                                                                                          'poller_hash': 'MTI3NTBEM3BlZXJwb25wb24gMjE3NzE2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.843}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/4',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/5',
                                                                                         'in_discards': '194255',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '3061585',
                                                                                         'in_octets': '10792998494017',
                                                                                         'in_ucast_pkts': '24750907088',
                                                                                         'links': [       {       'in_nucast_pkts': '4967',
                                                                                                                  'in_octets': '199077912210',
                                                                                                                  'in_ucast_pkts': '974942427',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '164738',
                                                                                                                  'out_octets': '3943040091494',
                                                                                                                  'out_ucast_pkts': '3128830072',
                                                                                                                  'poller_hash': 'M0VCQTE5cGVlcmludGZwb24gMTg='},
                                                                                                          {       'in_nucast_pkts': '8931',
                                                                                                                  'in_octets': '7407655',
                                                                                                                  'in_ucast_pkts': '21604',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13462271',
                                                                                                                  'out_octets': '17643587985',
                                                                                                                  'out_ucast_pkts': '28629',
                                                                                                                  'poller_hash': 'NDJCOUU2cGVlcmludGZwb24gNDY='},
                                                                                                          {       'in_nucast_pkts': '105538',
                                                                                                                  'in_octets': '29518562316',
                                                                                                                  'in_ucast_pkts': '97243718',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11474314',
                                                                                                                  'out_octets': '249165005838',
                                                                                                                  'out_ucast_pkts': '220798104',
                                                                                                                  'poller_hash': 'ODcyNDcwcGVlcmludGZwb24gNTM='},
                                                                                                          {       'in_nucast_pkts': '3235',
                                                                                                                  'in_octets': '2746128',
                                                                                                                  'in_ucast_pkts': '12792',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5313380',
                                                                                                                  'out_octets': '7008125121',
                                                                                                                  'out_ucast_pkts': '14568',
                                                                                                                  'poller_hash': 'NDE1M0ZwZWVyaW50ZnBvbiA1NA=='},
                                                                                                          {       'in_nucast_pkts': '3043941',
                                                                                                                  'in_octets': '17516368498',
                                                                                                                  'in_ucast_pkts': '46714267',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1086618943',
                                                                                                                  'out_octets': '1557933653161',
                                                                                                                  'out_ucast_pkts': '162471652',
                                                                                                                  'poller_hash': 'NzFBNDkycGVlcmludGZwb24gNTU='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'M0QwRkNwZWVyaW50ZnBvbiA1Nw=='},
                                                                                                          {       'in_nucast_pkts': '231658',
                                                                                                                  'in_octets': '458438948513',
                                                                                                                  'in_ucast_pkts': '908287996',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1793486',
                                                                                                                  'out_octets': '2891963132678',
                                                                                                                  'out_ucast_pkts': '10908364901',
                                                                                                                  'poller_hash': 'M0QwRUZwZWVyaW50ZnBvbiA1OA=='},
                                                                                                          {       'in_nucast_pkts': '9882114',
                                                                                                                  'in_octets': '30573758083',
                                                                                                                  'in_ucast_pkts': '101695327',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10585594693',
                                                                                                                  'out_octets': '13780927990643',
                                                                                                                  'out_ucast_pkts': '204186118',
                                                                                                                  'poller_hash': 'NzFEMkU1cGVlcmludGZwb24gNTk='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'M0QwRjRwZWVyaW50ZnBvbiA2MA=='},
                                                                                                          {       'in_nucast_pkts': '52578',
                                                                                                                  'in_octets': '11819926661',
                                                                                                                  'in_ucast_pkts': '38198543',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1376081',
                                                                                                                  'out_octets': '56658638949',
                                                                                                                  'out_ucast_pkts': '59311845',
                                                                                                                  'poller_hash': 'NDE1MjJwZWVyaW50ZnBvbiA2MQ=='},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '5707712',
                                                                                                                  'in_ucast_pkts': '17439',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2525',
                                                                                                                  'out_octets': '56224578',
                                                                                                                  'out_ucast_pkts': '53106',
                                                                                                                  'poller_hash': 'ODg5QjRwZWVyaW50ZnBvbiA2Mw=='},
                                                                                                          {       'in_nucast_pkts': '15874',
                                                                                                                  'in_octets': '310149235454',
                                                                                                                  'in_ucast_pkts': '1078255681',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1795872',
                                                                                                                  'out_octets': '5979091786543',
                                                                                                                  'out_ucast_pkts': '4437189893',
                                                                                                                  'poller_hash': 'MTk5QTM2cGVlcmludGZwb24gNjQ='},
                                                                                                          {       'in_nucast_pkts': '4087914',
                                                                                                                  'in_octets': '6231881135',
                                                                                                                  'in_ucast_pkts': '10454860',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4140891415',
                                                                                                                  'out_octets': '5490466688046',
                                                                                                                  'out_ucast_pkts': '33958208',
                                                                                                                  'poller_hash': 'NTU2M0FEcGVlcmludGZwb24gNjU='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'NTYwQzE5cGVlcmludGZwb24gNjc='},
                                                                                                          {       'in_nucast_pkts': '17198453',
                                                                                                                  'in_octets': '312914354630',
                                                                                                                  'in_ucast_pkts': '1309348059',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5764745179',
                                                                                                                  'out_octets': '12532499690435',
                                                                                                                  'out_ucast_pkts': '3782851554',
                                                                                                                  'poller_hash': 'NTYwMjYzcGVlcmludGZwb24gNzA='},
                                                                                                          {       'in_nucast_pkts': '49529151',
                                                                                                                  'in_octets': '206568648532',
                                                                                                                  'in_ucast_pkts': '896174236',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '411126',
                                                                                                                  'out_octets': '3627067722864',
                                                                                                                  'out_ucast_pkts': '2654590325',
                                                                                                                  'poller_hash': 'MTk5QTMxcGVlcmludGZwb24gOTQ='},
                                                                                                          {       'in_nucast_pkts': '9038889',
                                                                                                                  'in_octets': '206435337897',
                                                                                                                  'in_ucast_pkts': '1187125904',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13617298717',
                                                                                                                  'out_octets': '24474589716615',
                                                                                                                  'out_ucast_pkts': '4645939368',
                                                                                                                  'poller_hash': 'NDkzNDBwZWVyaW50ZnBvbiA5OA=='},
                                                                                                          {       'in_nucast_pkts': '45326',
                                                                                                                  'in_octets': '2939733014291',
                                                                                                                  'in_ucast_pkts': '2086768738',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11480422',
                                                                                                                  'out_octets': '399215797182',
                                                                                                                  'out_ucast_pkts': '629881258',
                                                                                                                  'poller_hash': 'ODY5NDE5cGVlcmludGZwb24gMTQyMzI2'},
                                                                                                          {       'in_nucast_pkts': '10106148',
                                                                                                                  'in_octets': '10256248278',
                                                                                                                  'in_ucast_pkts': '38926735',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '20876090603',
                                                                                                                  'out_octets': '28149423571814',
                                                                                                                  'out_ucast_pkts': '149191352',
                                                                                                                  'poller_hash': 'QkYyNEQxcGVlcmludGZwb24gMTY2NzE4'},
                                                                                                          {       'in_nucast_pkts': '4507344',
                                                                                                                  'in_octets': '425820513801',
                                                                                                                  'in_ucast_pkts': '1568274732',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5382783347',
                                                                                                                  'out_octets': '12330013493073',
                                                                                                                  'out_ucast_pkts': '4063338891',
                                                                                                                  'poller_hash': 'Q0JFMDUycGVlcmludGZwb24gMTY4NDU5'},
                                                                                                          {       'in_nucast_pkts': '7645',
                                                                                                                  'in_octets': '27431912',
                                                                                                                  'in_ucast_pkts': '177053',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9506737',
                                                                                                                  'out_octets': '14223277207',
                                                                                                                  'out_ucast_pkts': '1288135',
                                                                                                                  'poller_hash': 'QzgxREQwcGVlcmludGZwb24gMTk4MjI0'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '311082589444',
                                                                                         'out_octets': '507848355827366',
                                                                                         'out_ucast_pkts': '65143131995',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzU=',
                                                                                         'pons': [       {       'id': '2/5',
                                                                                                                 'links': [       {       'connected_time': '19390322',
                                                                                                                                          'fiber_length': 2650,
                                                                                                                                          'poller_hash': 'M0VCQTE5cGVlcnBvbnBvbiAxOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '6522',
                                                                                                                                          'fiber_length': 3056,
                                                                                                                                          'poller_hash': 'NDJCOUU2cGVlcnBvbnBvbiA0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19405511',
                                                                                                                                          'fiber_length': 3561,
                                                                                                                                          'poller_hash': 'ODcyNDcwcGVlcnBvbnBvbiA1Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '6517',
                                                                                                                                          'fiber_length': 3519,
                                                                                                                                          'poller_hash': 'NDE1M0ZwZWVycG9ucG9uIDU0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '3934516',
                                                                                                                                          'fiber_length': 3183,
                                                                                                                                          'poller_hash': 'NzFBNDkycGVlcnBvbnBvbiA1NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '3021743',
                                                                                                                                          'fiber_length': 2568,
                                                                                                                                          'poller_hash': 'M0QwRkNwZWVycG9ucG9uIDU3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19390238',
                                                                                                                                          'fiber_length': 3038,
                                                                                                                                          'poller_hash': 'M0QwRUZwZWVycG9ucG9uIDU4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19390483',
                                                                                                                                          'fiber_length': 3122,
                                                                                                                                          'poller_hash': 'NzFEMkU1cGVlcnBvbnBvbiA1OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19390209',
                                                                                                                                          'fiber_length': 3119,
                                                                                                                                          'poller_hash': 'M0QwRjRwZWVycG9ucG9uIDYw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '6935055',
                                                                                                                                          'fiber_length': 3121,
                                                                                                                                          'poller_hash': 'NDE1MjJwZWVycG9ucG9uIDYx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '6529',
                                                                                                                                          'fiber_length': 2956,
                                                                                                                                          'poller_hash': 'ODg5QjRwZWVycG9ucG9uIDYz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19390213',
                                                                                                                                          'fiber_length': 2731,
                                                                                                                                          'poller_hash': 'MTk5QTM2cGVlcnBvbnBvbiA2NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '3012622',
                                                                                                                                          'fiber_length': 2848,
                                                                                                                                          'poller_hash': 'NTU2M0FEcGVlcnBvbnBvbiA2NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19389917',
                                                                                                                                          'fiber_length': 2932,
                                                                                                                                          'poller_hash': 'NTYwQzE5cGVlcnBvbnBvbiA2Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19390285',
                                                                                                                                          'fiber_length': 2659,
                                                                                                                                          'poller_hash': 'NTYwMjYzcGVlcnBvbnBvbiA3MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19390347',
                                                                                                                                          'fiber_length': 2654,
                                                                                                                                          'poller_hash': 'MTk5QTMxcGVlcnBvbnBvbiA5NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19389958',
                                                                                                                                          'fiber_length': 3090,
                                                                                                                                          'poller_hash': 'NDkzNDBwZWVycG9ucG9uIDk4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19405769',
                                                                                                                                          'fiber_length': 3459,
                                                                                                                                          'poller_hash': 'ODY5NDE5cGVlcnBvbnBvbiAxNDIzMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19390761',
                                                                                                                                          'fiber_length': 3182,
                                                                                                                                          'poller_hash': 'QkYyNEQxcGVlcnBvbnBvbiAxNjY3MTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '19405610',
                                                                                                                                          'fiber_length': 2973,
                                                                                                                                          'poller_hash': 'Q0JFMDUycGVlcnBvbnBvbiAxNjg0NTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681},
                                                                                                                                  {       'connected_time': '6730',
                                                                                                                                          'fiber_length': 3062,
                                                                                                                                          'poller_hash': 'QzgxREQwcGVlcnBvbnBvbiAxOTgyMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.681}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/5',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/6',
                                                                                         'in_discards': '132075',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '872366',
                                                                                         'in_octets': '6229982859733',
                                                                                         'in_ucast_pkts': '25401965520',
                                                                                         'links': [       {       'in_nucast_pkts': '145',
                                                                                                                  'in_octets': '141033217',
                                                                                                                  'in_ucast_pkts': '703359',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3616',
                                                                                                                  'out_octets': '2142428688',
                                                                                                                  'out_ucast_pkts': '1629847',
                                                                                                                  'poller_hash': 'ODcyNDI1cGVlcmludGZwb24gMTQzMDQz'},
                                                                                                          {       'in_nucast_pkts': '778',
                                                                                                                  'in_octets': '362314599',
                                                                                                                  'in_ucast_pkts': '595716',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3616',
                                                                                                                  'out_octets': '397293828',
                                                                                                                  'out_ucast_pkts': '588742',
                                                                                                                  'poller_hash': 'ODcyNDcxcGVlcmludGZwb24gMTQ0NDQ2'},
                                                                                                          {       'in_nucast_pkts': '5761',
                                                                                                                  'in_octets': '9503643',
                                                                                                                  'in_ucast_pkts': '52431',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '16230036',
                                                                                                                  'out_octets': '21414830556',
                                                                                                                  'out_ucast_pkts': '53294',
                                                                                                                  'poller_hash': 'OTU2RkE3cGVlcmludGZwb24gMTQ1NjMw'},
                                                                                                          {       'in_nucast_pkts': '3749',
                                                                                                                  'in_octets': '8423273',
                                                                                                                  'in_ucast_pkts': '38857',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10344472',
                                                                                                                  'out_octets': '13919156486',
                                                                                                                  'out_ucast_pkts': '44833',
                                                                                                                  'poller_hash': 'OTU2RjI2cGVlcmludGZwb24gMTQ2MDAx'},
                                                                                                          {       'in_nucast_pkts': '243',
                                                                                                                  'in_octets': '5293870',
                                                                                                                  'in_ucast_pkts': '12351',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5967',
                                                                                                                  'out_octets': '20648787',
                                                                                                                  'out_ucast_pkts': '20994',
                                                                                                                  'poller_hash': 'QTlDODk5cGVlcmludGZwb24gMTQ3Mzk3'},
                                                                                                          {       'in_nucast_pkts': '164',
                                                                                                                  'in_octets': '48927886',
                                                                                                                  'in_ucast_pkts': '318707',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5981',
                                                                                                                  'out_octets': '1240908885',
                                                                                                                  'out_ucast_pkts': '948852',
                                                                                                                  'poller_hash': 'QjUxMTUxcGVlcmludGZwb24gMTUxMjAy'},
                                                                                                          {       'in_nucast_pkts': '20996295',
                                                                                                                  'in_octets': '49543894757',
                                                                                                                  'in_ucast_pkts': '107215975',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5059824249',
                                                                                                                  'out_octets': '5770163394823',
                                                                                                                  'out_ucast_pkts': '259558623',
                                                                                                                  'poller_hash': 'ODY5MzhCcGVlcmludGZwb24gMTU2NDMw'},
                                                                                                          {       'in_nucast_pkts': '159',
                                                                                                                  'in_octets': '39639123',
                                                                                                                  'in_ucast_pkts': '290779',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6073',
                                                                                                                  'out_octets': '1753973591',
                                                                                                                  'out_ucast_pkts': '1235947',
                                                                                                                  'poller_hash': 'QzgzQjZFcGVlcmludGZwb24gMTcwNzIy'},
                                                                                                          {       'in_nucast_pkts': '173',
                                                                                                                  'in_octets': '91961479',
                                                                                                                  'in_ucast_pkts': '301388',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6070',
                                                                                                                  'out_octets': '870870731',
                                                                                                                  'out_ucast_pkts': '788332',
                                                                                                                  'poller_hash': 'QzgxQzdCcGVlcmludGZwb24gMjA3MTQ5'},
                                                                                                          {       'in_nucast_pkts': '165',
                                                                                                                  'in_octets': '121851568',
                                                                                                                  'in_ucast_pkts': '686614',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5988',
                                                                                                                  'out_octets': '1646892597',
                                                                                                                  'out_ucast_pkts': '1640012',
                                                                                                                  'poller_hash': 'MTFCMjIzNXBlZXJpbnRmcG9uIDIxMjU4MA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '2/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '240108607731',
                                                                                         'out_octets': '428355461265377',
                                                                                         'out_ucast_pkts': '76707269289',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzY=',
                                                                                         'pons': [       {       'id': '2/6',
                                                                                                                 'links': [       {       'connected_time': '6711',
                                                                                                                                          'fiber_length': 1000,
                                                                                                                                          'poller_hash': 'ODcyNDI1cGVlcnBvbnBvbiAxNDMwNDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '6712',
                                                                                                                                          'fiber_length': 1233,
                                                                                                                                          'poller_hash': 'ODcyNDcxcGVlcnBvbnBvbiAxNDQ0NDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '6712',
                                                                                                                                          'fiber_length': 396,
                                                                                                                                          'poller_hash': 'OTU2RkE3cGVlcnBvbnBvbiAxNDU2MzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '6713',
                                                                                                                                          'fiber_length': 922,
                                                                                                                                          'poller_hash': 'OTU2RjI2cGVlcnBvbnBvbiAxNDYwMDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '6714',
                                                                                                                                          'fiber_length': 1119,
                                                                                                                                          'poller_hash': 'QTlDODk5cGVlcnBvbnBvbiAxNDczOTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '6712',
                                                                                                                                          'fiber_length': 1018,
                                                                                                                                          'poller_hash': 'QjUxMTUxcGVlcnBvbnBvbiAxNTEyMDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '19405659',
                                                                                                                                          'fiber_length': 1062,
                                                                                                                                          'poller_hash': 'ODY5MzhCcGVlcnBvbnBvbiAxNTY0MzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '6726',
                                                                                                                                          'fiber_length': 990,
                                                                                                                                          'poller_hash': 'QzgzQjZFcGVlcnBvbnBvbiAxNzA3MjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '6732',
                                                                                                                                          'fiber_length': 561,
                                                                                                                                          'poller_hash': 'QzgxQzdCcGVlcnBvbnBvbiAyMDcxNDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '6733',
                                                                                                                                          'fiber_length': 1456,
                                                                                                                                          'poller_hash': 'MTFCMjIzNXBlZXJwb25wb24gMjEyNTgw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/6',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/7',
                                                                                         'in_discards': '1453',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2149546',
                                                                                         'in_octets': '6563500558977',
                                                                                         'in_ucast_pkts': '23784887593',
                                                                                         'links': [       {       'in_nucast_pkts': '2724862',
                                                                                                                  'in_octets': '18791795923',
                                                                                                                  'in_ucast_pkts': '98204633',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3447262667',
                                                                                                                  'out_octets': '4898570671575',
                                                                                                                  'out_ucast_pkts': '334178814',
                                                                                                                  'poller_hash': 'M0ZDM0MycGVlcmludGZwb24gMjE='},
                                                                                                          {       'in_nucast_pkts': '1927',
                                                                                                                  'in_octets': '1297577',
                                                                                                                  'in_ucast_pkts': '6236',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5249341',
                                                                                                                  'out_octets': '6917382885',
                                                                                                                  'out_ucast_pkts': '6659',
                                                                                                                  'poller_hash': 'MzIxOTU4cGVlcmludGZwb24gMzA='},
                                                                                                          {       'in_nucast_pkts': '49240',
                                                                                                                  'in_octets': '98284041108',
                                                                                                                  'in_ucast_pkts': '466792414',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1531437',
                                                                                                                  'out_octets': '1415721223441',
                                                                                                                  'out_ucast_pkts': '1093227414',
                                                                                                                  'poller_hash': 'MTJGRkVFcGVlcmludGZwb24gNjk='},
                                                                                                          {       'in_nucast_pkts': '9704',
                                                                                                                  'in_octets': '18129532171',
                                                                                                                  'in_ucast_pkts': '128720073',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1790574',
                                                                                                                  'out_octets': '410646941652',
                                                                                                                  'out_ucast_pkts': '313014434',
                                                                                                                  'poller_hash': 'MTk5OUUzcGVlcmludGZwb24gNzc='},
                                                                                                          {       'in_nucast_pkts': '4708',
                                                                                                                  'in_octets': '34019108580',
                                                                                                                  'in_ucast_pkts': '125503088',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1796815',
                                                                                                                  'out_octets': '943844647545',
                                                                                                                  'out_ucast_pkts': '9352920483',
                                                                                                                  'poller_hash': 'M0QwRjJwZWVyaW50ZnBvbiA3OA=='},
                                                                                                          {       'in_nucast_pkts': '3434054',
                                                                                                                  'in_octets': '9153838713',
                                                                                                                  'in_ucast_pkts': '44964825',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4119829277',
                                                                                                                  'out_octets': '5690741967537',
                                                                                                                  'out_ucast_pkts': '141758033',
                                                                                                                  'poller_hash': 'NkRCQzk4cGVlcmludGZwb24gNzk='},
                                                                                                          {       'in_nucast_pkts': '109073',
                                                                                                                  'in_octets': '138831145832',
                                                                                                                  'in_ucast_pkts': '428932038',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5023',
                                                                                                                  'out_octets': '402960533959',
                                                                                                                  'out_ucast_pkts': '485073269',
                                                                                                                  'poller_hash': 'M0QwRjZwZWVyaW50ZnBvbiA4MA=='},
                                                                                                          {       'in_nucast_pkts': '22030156',
                                                                                                                  'in_octets': '247470110817',
                                                                                                                  'in_ucast_pkts': '891407577',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5839997213',
                                                                                                                  'out_octets': '10257028689171',
                                                                                                                  'out_ucast_pkts': '2063259650',
                                                                                                                  'poller_hash': 'NzZDRkY4cGVlcmludGZwb24gODE='},
                                                                                                          {       'in_nucast_pkts': '3923',
                                                                                                                  'in_octets': '42031389',
                                                                                                                  'in_ucast_pkts': '172554',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10581687',
                                                                                                                  'out_octets': '14482137447',
                                                                                                                  'out_ucast_pkts': '446618',
                                                                                                                  'poller_hash': 'NDJDRTk4cGVlcmludGZwb24gODY='},
                                                                                                          {       'in_nucast_pkts': '172',
                                                                                                                  'in_octets': '1811872594',
                                                                                                                  'in_ucast_pkts': '7176739',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '27302',
                                                                                                                  'out_octets': '23343509861',
                                                                                                                  'out_ucast_pkts': '19599516',
                                                                                                                  'poller_hash': 'NzIyMDNEcGVlcmludGZwb24gODg='},
                                                                                                          {       'in_nucast_pkts': '6311913',
                                                                                                                  'in_octets': '32871544314',
                                                                                                                  'in_ucast_pkts': '233634726',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5406897019',
                                                                                                                  'out_octets': '7887200773789',
                                                                                                                  'out_ucast_pkts': '17698590769',
                                                                                                                  'poller_hash': 'M0QwRTlwZWVyaW50ZnBvbiA5NQ=='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'M0ZGQUI5cGVlcmludGZwb24gOTY='},
                                                                                                          {       'in_nucast_pkts': '2988',
                                                                                                                  'in_octets': '25547899893',
                                                                                                                  'in_ucast_pkts': '187550573',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1796628',
                                                                                                                  'out_octets': '804752660474',
                                                                                                                  'out_ucast_pkts': '591480001',
                                                                                                                  'poller_hash': 'NDE1ODVwZWVyaW50ZnBvbiA5Nw=='},
                                                                                                          {       'in_nucast_pkts': '11321',
                                                                                                                  'in_octets': '843720676436',
                                                                                                                  'in_ucast_pkts': '1388059252',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1795376',
                                                                                                                  'out_octets': '2747320271733',
                                                                                                                  'out_ucast_pkts': '2620921840',
                                                                                                                  'poller_hash': 'MTU0NTJwZWVyaW50ZnBvbiAxMDA='},
                                                                                                          {       'in_nucast_pkts': '92295',
                                                                                                                  'in_octets': '49052962554',
                                                                                                                  'in_ucast_pkts': '337735568',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1215400',
                                                                                                                  'out_octets': '964579006420',
                                                                                                                  'out_ucast_pkts': '681524452',
                                                                                                                  'poller_hash': 'NDE1OTFwZWVyaW50ZnBvbiAxMDE='},
                                                                                                          {       'in_nucast_pkts': '27079969',
                                                                                                                  'in_octets': '132189572690',
                                                                                                                  'in_ucast_pkts': '513282463',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '44367266502',
                                                                                                                  'out_octets': '60739290758320',
                                                                                                                  'out_ucast_pkts': '1221829535',
                                                                                                                  'poller_hash': 'N0ZFODRwZWVyaW50ZnBvbiAxMDI='},
                                                                                                          {       'in_nucast_pkts': '6355786',
                                                                                                                  'in_octets': '125637919680',
                                                                                                                  'in_ucast_pkts': '1153165047',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8817307364',
                                                                                                                  'out_octets': '15381091276277',
                                                                                                                  'out_ucast_pkts': '2653711341',
                                                                                                                  'poller_hash': 'MzkwQUI4cGVlcmludGZwb24gMTAz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MzI5NURDcGVlcmludGZwb24gMTA0'},
                                                                                                          {       'in_nucast_pkts': '7492881',
                                                                                                                  'in_octets': '103834876509',
                                                                                                                  'in_ucast_pkts': '416797346',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14972833210',
                                                                                                                  'out_octets': '21570790398664',
                                                                                                                  'out_ucast_pkts': '1284133966',
                                                                                                                  'poller_hash': 'MkZFOUJBcGVlcmludGZwb24gMTA1'},
                                                                                                          {       'in_nucast_pkts': '10066828',
                                                                                                                  'in_octets': '260473853712',
                                                                                                                  'in_ucast_pkts': '1912526628',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26066332712',
                                                                                                                  'out_octets': '40640590782494',
                                                                                                                  'out_ucast_pkts': '3985804602',
                                                                                                                  'poller_hash': 'QzgzQkIwcGVlcmludGZwb24gMTA2'},
                                                                                                          {       'in_nucast_pkts': '2227',
                                                                                                                  'in_octets': '112881147',
                                                                                                                  'in_ucast_pkts': '238899',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3761515',
                                                                                                                  'out_octets': '5411172892',
                                                                                                                  'out_ucast_pkts': '456429',
                                                                                                                  'poller_hash': 'M0FFQkMwcGVlcmludGZwb24gMTA4'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '2/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '260522256062',
                                                                                         'out_octets': '417847453167347',
                                                                                         'out_ucast_pkts': '50006458017',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzc=',
                                                                                         'pons': [       {       'id': '2/7',
                                                                                                                 'links': [       {       'connected_time': '3934545',
                                                                                                                                          'fiber_length': 1287,
                                                                                                                                          'poller_hash': 'M0ZDM0MycGVlcnBvbnBvbiAyMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '6512',
                                                                                                                                          'fiber_length': 2218,
                                                                                                                                          'poller_hash': 'MzIxOTU4cGVlcnBvbnBvbiAzMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '11318790',
                                                                                                                                          'fiber_length': 2078,
                                                                                                                                          'poller_hash': 'MTJGRkVFcGVlcnBvbnBvbiA2OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '19390513',
                                                                                                                                          'fiber_length': 2481,
                                                                                                                                          'poller_hash': 'MTk5OUUzcGVlcnBvbnBvbiA3Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '19390185',
                                                                                                                                          'fiber_length': 2400,
                                                                                                                                          'poller_hash': 'M0QwRjJwZWVycG9ucG9uIDc4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '3934601',
                                                                                                                                          'fiber_length': 2449,
                                                                                                                                          'poller_hash': 'NkRCQzk4cGVlcnBvbnBvbiA3OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '3020836',
                                                                                                                                          'fiber_length': 2359,
                                                                                                                                          'poller_hash': 'M0QwRjZwZWVycG9ucG9uIDgw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '19390394',
                                                                                                                                          'fiber_length': 2358,
                                                                                                                                          'poller_hash': 'NzZDRkY4cGVlcnBvbnBvbiA4MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '6545',
                                                                                                                                          'fiber_length': 2810,
                                                                                                                                          'poller_hash': 'NDJDRTk4cGVlcnBvbnBvbiA4Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '3934580',
                                                                                                                                          'fiber_length': 1378,
                                                                                                                                          'poller_hash': 'NzIyMDNEcGVlcnBvbnBvbiA4OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '5979100',
                                                                                                                                          'fiber_length': 2611,
                                                                                                                                          'poller_hash': 'M0QwRTlwZWVycG9ucG9uIDk1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'poller_hash': 'M0ZGQUI5cGVlcnBvbnBvbiA5Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '19390058',
                                                                                                                                          'fiber_length': 1801,
                                                                                                                                          'poller_hash': 'NDE1ODVwZWVycG9ucG9uIDk3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '19389973',
                                                                                                                                          'fiber_length': 1314,
                                                                                                                                          'poller_hash': 'MTU0NTJwZWVycG9ucG9uIDEwMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '3934505',
                                                                                                                                          'fiber_length': 1228,
                                                                                                                                          'poller_hash': 'NDE1OTFwZWVycG9ucG9uIDEwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '19390480',
                                                                                                                                          'fiber_length': 1998,
                                                                                                                                          'poller_hash': 'N0ZFODRwZWVycG9ucG9uIDEwMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '19390069',
                                                                                                                                          'fiber_length': 2109,
                                                                                                                                          'poller_hash': 'MzkwQUI4cGVlcnBvbnBvbiAxMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '19390530',
                                                                                                                                          'fiber_length': 2039,
                                                                                                                                          'poller_hash': 'MzI5NURDcGVlcnBvbnBvbiAxMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '19390442',
                                                                                                                                          'fiber_length': 2020,
                                                                                                                                          'poller_hash': 'MkZFOUJBcGVlcnBvbnBvbiAxMDU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '19405377',
                                                                                                                                          'fiber_length': 2109,
                                                                                                                                          'poller_hash': 'QzgzQkIwcGVlcnBvbnBvbiAxMDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.662},
                                                                                                                                  {       'connected_time': '6556',
                                                                                                                                          'fiber_length': 2135,
                                                                                                                                          'poller_hash': 'M0FFQkMwcGVlcnBvbnBvbiAxMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                           