import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):
    def test_calix_exa_E7_2_EXA_3_4_30_40_01(self):
        obj = self.run_data("calix.exa.E7-2 (EXA).3.4.30.40.01")
        exp_info = {
                'model': 'E7-2 (EXA)',
                'sta_count': 365,
                'sw_version': '3.4.30.40',
                'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '71702970268', 'system_mac_address': None
        }
        exp_sta_stats = {
                None: {       'dev_macs': None,
                              'ip_address': None,
                              'mac_address': None,
                              'name': 'ont 96',
                              'serial_number': '3FFAB9',
                              'system_mac_address': None},
                '00:06:31:06:38:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:06:38:37',
                                             'name': 'ont 185',
                                             'serial_number': '7FF5',
                                             'system_mac_address': None},
                '00:06:31:08:4a:08': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4a:08',
                                             'name': 'ont 123',
                                             'serial_number': 'F0F8',
                                             'system_mac_address': None},
                '00:06:31:08:4a:56': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4a:56',
                                             'name': 'ont 107',
                                             'serial_number': 'F1F8',
                                             'system_mac_address': None},
                '00:06:31:08:4b:82': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4b:82',
                                             'name': 'ont 139',
                                             'serial_number': 'F23A',
                                             'system_mac_address': None},
                '00:06:31:08:4c:8d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4c:8d',
                                             'name': 'ont 334',
                                             'serial_number': 'F23C',
                                             'system_mac_address': None},
                '00:06:31:08:de:8d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:de:8d',
                                             'name': 'ont 183',
                                             'serial_number': '153C3',
                                             'system_mac_address': None},
                '00:06:31:08:e2:95': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:e2:95',
                                             'name': 'ont 100',
                                             'serial_number': '15452',
                                             'system_mac_address': None},
                '00:06:31:08:e2:e6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:e2:e6',
                                             'name': 'ont 339',
                                             'serial_number': '1545D',
                                             'system_mac_address': None},
                '00:06:31:11:f0:4e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f0:4e',
                                             'name': 'ont 160',
                                             'serial_number': '1303D',
                                             'system_mac_address': None},
                '00:06:31:11:f6:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f6:cc',
                                             'name': 'ont 154',
                                             'serial_number': '13538',
                                             'system_mac_address': None},
                '00:06:31:11:f7:7d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f7:7d',
                                             'name': 'ont 286',
                                             'serial_number': '13548',
                                             'system_mac_address': None},
                '00:06:31:15:a1:e0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a1:e0',
                                             'name': 'ont 144',
                                             'serial_number': '3CC08',
                                             'system_mac_address': None},
                '00:06:31:15:a8:61': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a8:61',
                                             'name': 'ont 225',
                                             'serial_number': '3CFA8',
                                             'system_mac_address': None},
                '00:06:31:15:a8:b0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a8:b0',
                                             'name': 'ont 338',
                                             'serial_number': '3CFA6',
                                             'system_mac_address': None},
                '00:06:31:15:a9:1e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:1e',
                                             'name': 'ont 121',
                                             'serial_number': '3CF4A',
                                             'system_mac_address': None},
                '00:06:31:15:a9:2d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:2d',
                                             'name': 'ont 295',
                                             'serial_number': '3D0FA',
                                             'system_mac_address': None},
                '00:06:31:15:a9:32': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:32',
                                             'name': 'ont 57',
                                             'serial_number': '3D0FC',
                                             'system_mac_address': None},
                '00:06:31:15:a9:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:37',
                                             'name': 'ont 78',
                                             'serial_number': '3D0F2',
                                             'system_mac_address': None},
                '00:06:31:15:a9:46': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:46',
                                             'name': 'ont 60',
                                             'serial_number': '3D0F4',
                                             'system_mac_address': None},
                '00:06:31:15:a9:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:64',
                                             'name': 'ont 58',
                                             'serial_number': '3D0EF',
                                             'system_mac_address': None},
                '00:06:31:18:c1:01': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c1:01',
                                             'name': 'ont 148',
                                             'serial_number': '3CF4E',
                                             'system_mac_address': None},
                '00:06:31:18:c1:ce': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c1:ce',
                                             'name': 'ont 224',
                                             'serial_number': '3CF9D',
                                             'system_mac_address': None},
                '00:06:31:18:c2:fa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c2:fa',
                                             'name': 'ont 333',
                                             'serial_number': '3CFAA',
                                             'system_mac_address': None},
                '00:06:31:18:c2:ff': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c2:ff',
                                             'name': 'ont 190',
                                             'serial_number': '3CFA0',
                                             'system_mac_address': None},
                '00:06:31:1e:52:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1e:52:10',
                                             'name': 'ont 95',
                                             'serial_number': '3D0E9',
                                             'system_mac_address': None},
                '00:06:31:1e:56:75': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1e:56:75',
                                             'name': 'ont 80',
                                             'serial_number': '3D0F6',
                                             'system_mac_address': None},
                '00:06:31:1f:06:f6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:06:f6',
                                             'name': 'ont 199',
                                             'serial_number': '41542',
                                             'system_mac_address': None},
                '00:06:31:1f:07:23': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:23',
                                             'name': 'ont 61',
                                             'serial_number': '41522',
                                             'system_mac_address': None},
                '00:06:31:1f:07:55': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:55',
                                             'name': 'ont 75',
                                             'serial_number': '41530',
                                             'system_mac_address': None},
                '00:06:31:1f:07:82': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:82',
                                             'name': 'ont 97',
                                             'serial_number': '41585',
                                             'system_mac_address': None},
                '00:06:31:1f:08:4f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:08:4f',
                                             'name': 'ont 101',
                                             'serial_number': '41591',
                                             'system_mac_address': None},
                '00:06:31:1f:08:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:08:d6',
                                             'name': 'ont 194',
                                             'serial_number': '41549',
                                             'system_mac_address': None},
                '00:06:31:20:00:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:37',
                                             'name': 'ont 206',
                                             'serial_number': '4157E',
                                             'system_mac_address': None},
                '00:06:31:20:00:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:64',
                                             'name': 'ont 291',
                                             'serial_number': '41535',
                                             'system_mac_address': None},
                '00:06:31:20:00:69': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:69',
                                             'name': 'ont 122',
                                             'serial_number': '415B0',
                                             'system_mac_address': None},
                '00:06:31:20:01:45': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:45',
                                             'name': 'ont 207',
                                             'serial_number': '415AB',
                                             'system_mac_address': None},
                '00:06:31:20:01:5e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:5e',
                                             'name': 'ont 54',
                                             'serial_number': '4153F',
                                             'system_mac_address': None},
                '00:06:31:20:01:6d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:6d',
                                             'name': 'ont 281',
                                             'serial_number': '418B8',
                                             'system_mac_address': None},
                '00:06:31:20:01:81': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:81',
                                             'name': 'ont 263',
                                             'serial_number': '418B7',
                                             'system_mac_address': None},
                '00:06:31:20:01:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:b8',
                                             'name': 'ont 202',
                                             'serial_number': '4152F',
                                             'system_mac_address': None},
                '00:06:31:20:02:3a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:3a',
                                             'name': 'ont 278',
                                             'serial_number': '4153C',
                                             'system_mac_address': None},
                '00:06:31:20:02:5d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:5d',
                                             'name': 'ont 223',
                                             'serial_number': '415FE',
                                             'system_mac_address': None},
                '00:06:31:20:02:fd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:fd',
                                             'name': 'ont 189',
                                             'serial_number': '418B3',
                                             'system_mac_address': None},
                '00:06:31:20:03:2a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:03:2a',
                                             'name': 'ont 143',
                                             'serial_number': '418AC',
                                             'system_mac_address': None},
                '00:06:31:20:03:61': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:03:61',
                                             'name': 'ont 192',
                                             'serial_number': '418B5',
                                             'system_mac_address': None},
                '00:06:31:20:a1:a2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:a1:a2',
                                             'name': 'ont 98',
                                             'serial_number': '49340',
                                             'system_mac_address': None},
                '00:06:31:34:38:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:18',
                                             'name': 'ont 331',
                                             'serial_number': '757AC',
                                             'system_mac_address': None},
                '00:06:31:34:38:27': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:27',
                                             'name': 'ont 297',
                                             'serial_number': '757BB',
                                             'system_mac_address': None},
                '00:06:31:34:38:28': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:28',
                                             'name': 'ont 198',
                                             'serial_number': '757BC',
                                             'system_mac_address': None},
                '00:06:31:3c:5f:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:5f:10',
                                             'name': 'ont 51',
                                             'serial_number': '7FE2A',
                                             'system_mac_address': None},
                '00:06:31:3c:5f:6a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:5f:6a',
                                             'name': 'ont 102',
                                             'serial_number': '7FE84',
                                             'system_mac_address': None},
                '00:06:31:3c:cc:73': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:cc:73',
                                             'name': 'ont 315',
                                             'serial_number': '86B8B',
                                             'system_mac_address': None},
                '00:06:31:3c:cc:a6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:cc:a6',
                                             'name': 'ont 220',
                                             'serial_number': '86BBE',
                                             'system_mac_address': None},
                '00:06:31:3c:d5:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:d5:37',
                                             'name': 'ont 127',
                                             'serial_number': '8744F',
                                             'system_mac_address': None},
                '00:06:31:3c:ea:9c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:ea:9c',
                                             'name': 'ont 63',
                                             'serial_number': '889B4',
                                             'system_mac_address': None},
                '00:06:31:47:4b:6c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:47:4b:6c',
                                             'name': 'ont 170752',
                                             'serial_number': '8A280',
                                             'system_mac_address': None},
                '00:06:31:57:b0:79': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:57:b0:79',
                                             'name': 'ont 131',
                                             'serial_number': 'A9FB9',
                                             'system_mac_address': None},
                '00:06:31:5f:60:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:60:b4',
                                             'name': 'ont 45',
                                             'serial_number': 'C4FF4',
                                             'system_mac_address': None},
                '00:06:31:5f:60:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:60:d0',
                                             'name': 'ont 254',
                                             'serial_number': 'C5010',
                                             'system_mac_address': None},
                '00:06:31:5f:68:8d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:68:8d',
                                             'name': 'ont 49',
                                             'serial_number': 'C57CD',
                                             'system_mac_address': None},
                '00:06:31:5f:69:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:69:10',
                                             'name': 'ont 157',
                                             'serial_number': 'C5850',
                                             'system_mac_address': None},
                '00:06:31:5f:69:2b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:69:2b',
                                             'name': 'ont 146',
                                             'serial_number': 'C586B',
                                             'system_mac_address': None},
                '00:06:31:5f:d1:76': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:d1:76',
                                             'name': 'ont 200',
                                             'serial_number': 'CC0B6',
                                             'system_mac_address': None},
                '00:06:31:6f:c4:65': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:6f:c4:65',
                                             'name': 'ont 271',
                                             'serial_number': 'F23A5',
                                             'system_mac_address': None},
                '00:06:31:90:39:05': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:39:05',
                                             'name': 'ont 273',
                                             'serial_number': '124845',
                                             'system_mac_address': None},
                '00:06:31:90:f0:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f0:9d',
                                             'name': 'ont 296',
                                             'serial_number': '12FFDD',
                                             'system_mac_address': None},
                '00:06:31:90:f0:ae': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f0:ae',
                                             'name': 'ont 69',
                                             'serial_number': '12FFEE',
                                             'system_mac_address': None},
                '00:06:31:90:f1:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:1f',
                                             'name': 'ont 241',
                                             'serial_number': '13005F',
                                             'system_mac_address': None},
                '00:06:31:90:f1:4b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:4b',
                                             'name': 'ont 242',
                                             'serial_number': '13008B',
                                             'system_mac_address': None},
                '00:06:31:90:f1:4d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:4d',
                                             'name': 'ont 308',
                                             'serial_number': '13008D',
                                             'system_mac_address': None},
                '00:06:31:90:f1:5a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:5a',
                                             'name': 'ont 138',
                                             'serial_number': '13009A',
                                             'system_mac_address': None},
                '00:06:31:b7:29:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:29:e8',
                                             'name': 'ont 163',
                                             'serial_number': '161021',
                                             'system_mac_address': None},
                '00:06:31:b7:5c:3e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:5c:3e',
                                             'name': 'ont 335',
                                             'serial_number': '164277',
                                             'system_mac_address': None},
                '00:06:31:b7:5c:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:5c:48',
                                             'name': 'ont 289',
                                             'serial_number': '164281',
                                             'system_mac_address': None},
                '00:06:31:dd:56:87': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:56:87',
                                             'name': 'ont 226',
                                             'serial_number': '175E66',
                                             'system_mac_address': None},
                '00:06:31:dd:56:bf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:56:bf',
                                             'name': 'ont 27',
                                             'serial_number': '175E6D',
                                             'system_mac_address': None},
                '00:06:31:dd:73:d7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:73:d7',
                                             'name': 'ont 317',
                                             'serial_number': '176210',
                                             'system_mac_address': None},
                '00:06:31:e3:f9:63': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:f9:63',
                                             'name': 'ont 112',
                                             'serial_number': '1999C5',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:43': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:43',
                                             'name': 'ont 274',
                                             'serial_number': '1999E1',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:53': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:53',
                                             'name': 'ont 77',
                                             'serial_number': '1999E3',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:83': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:83',
                                             'name': 'ont 125',
                                             'serial_number': '1999E9',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:eb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:eb',
                                             'name': 'ont 309',
                                             'serial_number': '1999F6',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:f3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:f3',
                                             'name': 'ont 272',
                                             'serial_number': '1999F7',
                                             'system_mac_address': None},
                '00:06:31:e3:fb:3b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fb:3b',
                                             'name': 'ont 188',
                                             'serial_number': '199A00',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:13': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:13',
                                             'name': 'ont 161',
                                             'serial_number': '199A1B',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:63': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:63',
                                             'name': 'ont 150',
                                             'serial_number': '199A25',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:a3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:a3',
                                             'name': 'ont 287',
                                             'serial_number': '199A2D',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:c3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:c3',
                                             'name': 'ont 94',
                                             'serial_number': '199A31',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:cb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:cb',
                                             'name': 'ont 214',
                                             'serial_number': '199A32',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:eb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:eb',
                                             'name': 'ont 64',
                                             'serial_number': '199A36',
                                             'system_mac_address': None},
                '00:06:31:e3:fd:03': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fd:03',
                                             'name': 'ont 151',
                                             'serial_number': '199A39',
                                             'system_mac_address': None},
                '00:06:31:ff:48:34': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:ff:48:34',
                                             'name': 'ont 302',
                                             'serial_number': '1C4DA9',
                                             'system_mac_address': None},
                '04:bc:9f:00:17:d9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:00:17:d9',
                                             'name': 'ont 231388',
                                             'serial_number': 'EBC2EE',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1a:89': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1a:89',
                                             'name': 'ont 232329',
                                             'serial_number': '12749D1',
                                             'system_mac_address': None},
                '04:bc:9f:5c:1d:81': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:1d:81',
                                             'name': 'ont 234824',
                                             'serial_number': '1274A30',
                                             'system_mac_address': None},
                '04:bc:9f:5c:21:31': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:21:31',
                                             'name': 'ont 234864',
                                             'serial_number': '1274AA6',
                                             'system_mac_address': None},
                '04:bc:9f:5c:3f:a1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:3f:a1',
                                             'name': 'ont 218217',
                                             'serial_number': '1274E74',
                                             'system_mac_address': None},
                '04:bc:9f:5c:52:99': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:52:99',
                                             'name': 'ont 217716',
                                             'serial_number': '12750D3',
                                             'system_mac_address': None},
                '04:bc:9f:5c:58:61': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:58:61',
                                             'name': 'ont 221110',
                                             'serial_number': '127518C',
                                             'system_mac_address': None},
                '44:65:7f:33:20:d4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:20:d4',
                                             'name': 'ont 343',
                                             'serial_number': '640AE4',
                                             'system_mac_address': None},
                '44:65:7f:33:20:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:20:e8',
                                             'name': 'ont 341',
                                             'serial_number': '640AED',
                                             'system_mac_address': None},
                '44:65:7f:33:21:6e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:21:6e',
                                             'name': 'ont 344',
                                             'serial_number': '640B2F',
                                             'system_mac_address': None},
                '44:65:7f:33:21:ae': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:21:ae',
                                             'name': 'ont 87',
                                             'serial_number': '640B4F',
                                             'system_mac_address': None},
                '44:65:7f:7b:d3:fa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d3:fa',
                                             'name': 'ont 139198',
                                             'serial_number': '5A6B99',
                                             'system_mac_address': None},
                '44:65:7f:7b:d6:2b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d6:2b',
                                             'name': 'ont 138694',
                                             'serial_number': '5A6C54',
                                             'system_mac_address': None},
                '44:65:7f:7b:d6:e5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d6:e5',
                                             'name': 'ont 139190',
                                             'serial_number': '5A6C92',
                                             'system_mac_address': None},
                '44:65:7f:7b:d7:15': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d7:15',
                                             'name': 'ont 138690',
                                             'serial_number': '5A6CA2',
                                             'system_mac_address': None},
                '48:77:46:07:b2:49': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:07:b2:49',
                                             'name': 'ont 40',
                                             'serial_number': '6AC2C7',
                                             'system_mac_address': None},
                '48:77:46:08:95:89': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:08:95:89',
                                             'name': 'ont 79',
                                             'serial_number': '6DBC98',
                                             'system_mac_address': None},
                '48:77:46:3a:58:0a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:58:0a',
                                             'name': 'ont 303',
                                             'serial_number': '721D1C',
                                             'system_mac_address': None},
                '48:77:46:3a:71:12': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:71:12',
                                             'name': 'ont 88',
                                             'serial_number': '72203D',
                                             'system_mac_address': None},
                '48:77:46:3a:71:32': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:71:32',
                                             'name': 'ont 277',
                                             'serial_number': '722041',
                                             'system_mac_address': None},
                '48:77:46:3a:72:52': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:72:52',
                                             'name': 'ont 124',
                                             'serial_number': '722065',
                                             'system_mac_address': None},
                '48:77:46:3a:7f:c2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:7f:c2',
                                             'name': 'ont 120',
                                             'serial_number': '722213',
                                             'system_mac_address': None},
                '48:77:46:3b:21:9a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3b:21:9a',
                                             'name': 'ont 316',
                                             'serial_number': '72364E',
                                             'system_mac_address': None},
                '48:77:46:3b:3f:aa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3b:3f:aa',
                                             'name': 'ont 171719',
                                             'serial_number': '723A10',
                                             'system_mac_address': None},
                '48:77:46:8c:12:34': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:8c:12:34',
                                             'name': 'ont 330',
                                             'serial_number': '76ACE8',
                                             'system_mac_address': None},
                '48:77:46:a2:1b:1c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a2:1b:1c',
                                             'name': 'ont 55',
                                             'serial_number': '71A492',
                                             'system_mac_address': None},
                '48:77:46:a2:1d:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a2:1d:64',
                                             'name': 'ont 332',
                                             'serial_number': '71A4DB',
                                             'system_mac_address': None},
                '48:77:46:a3:8d:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:8d:b4',
                                             'name': 'ont 59',
                                             'serial_number': '71D2E5',
                                             'system_mac_address': None},
                '48:77:46:a3:b6:dc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:b6:dc',
                                             'name': 'ont 155',
                                             'serial_number': '71D80A',
                                             'system_mac_address': None},
                '48:77:46:a3:bb:44': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:bb:44',
                                             'name': 'ont 22',
                                             'serial_number': '71D897',
                                             'system_mac_address': None},
                '48:77:46:a3:bb:8c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:bb:8c',
                                             'name': 'ont 244',
                                             'serial_number': '71D8A0',
                                             'system_mac_address': None},
                '48:77:46:cd:52:5e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:cd:52:5e',
                                             'name': 'ont 81',
                                             'serial_number': '76CFF8',
                                             'system_mac_address': None},
                '48:77:46:ce:1f:1e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:1f:1e',
                                             'name': 'ont 182',
                                             'serial_number': '76E990',
                                             'system_mac_address': None},
                '48:77:46:ce:20:6e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:20:6e',
                                             'name': 'ont 318',
                                             'serial_number': '76E9BA',
                                             'system_mac_address': None},
                '48:77:46:ce:63:7e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:63:7e',
                                             'name': 'ont 217',
                                             'serial_number': '76F21C',
                                             'system_mac_address': None},
                '48:77:46:f8:75:8c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:f8:75:8c',
                                             'name': 'ont 140939',
                                             'serial_number': '82A55A',
                                             'system_mac_address': None},
                '60:db:98:4e:6b:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:6b:64',
                                             'name': 'ont 146196',
                                             'serial_number': 'A9C32C',
                                             'system_mac_address': None},
                '60:db:98:4e:8e:34': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:8e:34',
                                             'name': 'ont 85',
                                             'serial_number': 'A9C786',
                                             'system_mac_address': None},
                '60:db:98:4e:90:0c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:90:0c',
                                             'name': 'ont 147376',
                                             'serial_number': 'A9C7C1',
                                             'system_mac_address': None},
                '60:db:98:4e:96:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:96:cc',
                                             'name': 'ont 147397',
                                             'serial_number': 'A9C899',
                                             'system_mac_address': None},
                '60:db:98:4e:99:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:99:cc',
                                             'name': 'ont 114',
                                             'serial_number': 'A9C8F9',
                                             'system_mac_address': None},
                '60:db:98:4e:9b:8c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:9b:8c',
                                             'name': 'ont 156456',
                                             'serial_number': 'A9C931',
                                             'system_mac_address': None},
                '60:db:98:73:9c:74': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:73:9c:74',
                                             'name': 'ont 150872',
                                             'serial_number': 'B0A2A0',
                                             'system_mac_address': None},
                '60:db:98:8e:fe:5a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:fe:5a',
                                             'name': 'ont 36',
                                             'serial_number': 'B510E2',
                                             'system_mac_address': None},
                '60:db:98:8e:ff:a7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:ff:a7',
                                             'name': 'ont 151202',
                                             'serial_number': 'B51151',
                                             'system_mac_address': None},
                '60:db:98:8f:01:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:01:6f',
                                             'name': 'ont 152349',
                                             'serial_number': 'B511E9',
                                             'system_mac_address': None},
                '60:db:98:8f:01:d5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:01:d5',
                                             'name': 'ont 154903',
                                             'serial_number': 'B5120B',
                                             'system_mac_address': None},
                '60:db:98:8f:02:05': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:02:05',
                                             'name': 'ont 156418',
                                             'serial_number': 'B5121B',
                                             'system_mac_address': None},
                '84:d3:43:7c:e3:b7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7c:e3:b7',
                                             'name': 'ont 157753',
                                             'serial_number': 'C811E0',
                                             'system_mac_address': None},
                '84:d3:43:7d:04:3f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:04:3f',
                                             'name': 'ont 207352',
                                             'serial_number': 'C815F1',
                                             'system_mac_address': None},
                '84:d3:43:7d:1d:57': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:1d:57',
                                             'name': 'ont 196224',
                                             'serial_number': 'C81914',
                                             'system_mac_address': None},
                '84:d3:43:7d:36:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:36:97',
                                             'name': 'ont 205251',
                                             'serial_number': 'C81C3C',
                                             'system_mac_address': None},
                '84:d3:43:7d:36:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:36:af',
                                             'name': 'ont 212',
                                             'serial_number': 'C81C3F',
                                             'system_mac_address': None},
                '84:d3:43:7d:38:8f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:38:8f',
                                             'name': 'ont 207149',
                                             'serial_number': 'C81C7B',
                                             'system_mac_address': None},
                '84:d3:43:7d:3a:a7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:3a:a7',
                                             'name': 'ont 206680',
                                             'serial_number': 'C81CBE',
                                             'system_mac_address': None},
                '84:d3:43:7d:40:2f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:40:2f',
                                             'name': 'ont 211653',
                                             'serial_number': 'C81D6F',
                                             'system_mac_address': None},
                '84:d3:43:7d:42:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:42:6f',
                                             'name': 'ont 207830',
                                             'serial_number': 'C81DB7',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:37',
                                             'name': 'ont 198224',
                                             'serial_number': 'C81DD0',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:47': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:47',
                                             'name': 'ont 229',
                                             'serial_number': 'C81DD2',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:8f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:8f',
                                             'name': 'ont 138007',
                                             'serial_number': 'C81DDB',
                                             'system_mac_address': None},
                '84:d3:43:7d:44:bf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:44:bf',
                                             'name': 'ont 205456',
                                             'serial_number': 'C81E01',
                                             'system_mac_address': None},
                '84:d3:43:7d:46:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:46:37',
                                             'name': 'ont 206490',
                                             'serial_number': 'C81E30',
                                             'system_mac_address': None},
                '84:d3:43:7d:46:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:46:af',
                                             'name': 'ont 207362',
                                             'serial_number': 'C81E3F',
                                             'system_mac_address': None},
                '84:d3:43:7d:4e:c7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:4e:c7',
                                             'name': 'ont 280',
                                             'serial_number': 'C81F42',
                                             'system_mac_address': None},
                '84:d3:43:7d:5e:3f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:5e:3f',
                                             'name': 'ont 161657',
                                             'serial_number': 'C82131',
                                             'system_mac_address': None},
                '84:d3:43:7d:d9:4f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:d9:4f',
                                             'name': 'ont 313',
                                             'serial_number': 'C83093',
                                             'system_mac_address': None},
                '84:d3:43:7d:e5:47': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:e5:47',
                                             'name': 'ont 153',
                                             'serial_number': 'C83212',
                                             'system_mac_address': None},
                '84:d3:43:7e:15:87': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:15:87',
                                             'name': 'ont 160996',
                                             'serial_number': 'C8381A',
                                             'system_mac_address': None},
                '84:d3:43:7e:30:27': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:30:27',
                                             'name': 'ont 170722',
                                             'serial_number': 'C83B6E',
                                             'system_mac_address': None},
                '84:d3:43:7e:30:d7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:30:d7',
                                             'name': 'ont 170672',
                                             'serial_number': 'C83B84',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:6f',
                                             'name': 'ont 170712',
                                             'serial_number': 'C83B97',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:77': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:77',
                                             'name': 'ont 171709',
                                             'serial_number': 'C83B98',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:97',
                                             'name': 'ont 193622',
                                             'serial_number': 'C83B9C',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:cf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:cf',
                                             'name': 'ont 168564',
                                             'serial_number': 'C83BA3',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:0f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:0f',
                                             'name': 'ont 164207',
                                             'serial_number': 'C83BAB',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:27': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:27',
                                             'name': 'ont 166121',
                                             'serial_number': 'C83BAE',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:37',
                                             'name': 'ont 106',
                                             'serial_number': 'C83BB0',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:8f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:8f',
                                             'name': 'ont 172309',
                                             'serial_number': 'C83BBB',
                                             'system_mac_address': None},
                '84:d3:43:7e:33:17': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:33:17',
                                             'name': 'ont 166658',
                                             'serial_number': 'C83BCC',
                                             'system_mac_address': None},
                '84:d3:43:7e:33:87': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:33:87',
                                             'name': 'ont 171987',
                                             'serial_number': 'C83BDA',
                                             'system_mac_address': None},
                '84:d3:43:7e:34:4f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:34:4f',
                                             'name': 'ont 298',
                                             'serial_number': 'C83BF3',
                                             'system_mac_address': None},
                '84:d3:43:7e:35:17': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:35:17',
                                             'name': 'ont 174464',
                                             'serial_number': 'C83C0C',
                                             'system_mac_address': None},
                '84:d3:43:7e:45:07': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:45:07',
                                             'name': 'ont 161607',
                                             'serial_number': 'C83E0A',
                                             'system_mac_address': None},
                '84:d3:43:95:93:da': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:95:93:da',
                                             'name': 'ont 165050',
                                             'serial_number': 'CBD29A',
                                             'system_mac_address': None},
                '84:d3:43:96:01:9a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:96:01:9a',
                                             'name': 'ont 168459',
                                             'serial_number': 'CBE052',
                                             'system_mac_address': None},
                'b8:94:70:ba:e1:a5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e1:a5',
                                             'name': 'ont 215969',
                                             'serial_number': '1195149',
                                             'system_mac_address': None},
                'b8:94:70:ba:e1:e5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e1:e5',
                                             'name': 'ont 214620',
                                             'serial_number': '1195151',
                                             'system_mac_address': None},
                'b8:94:70:ba:e2:35': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e2:35',
                                             'name': 'ont 212620',
                                             'serial_number': '119515B',
                                             'system_mac_address': None},
                'b8:94:70:ba:e4:a5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e4:a5',
                                             'name': 'ont 216009',
                                             'serial_number': '11951A9',
                                             'system_mac_address': None},
                'b8:94:70:c6:e9:57': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c6:e9:57',
                                             'name': 'ont 212580',
                                             'serial_number': '11B2235',
                                             'system_mac_address': None},
                'b8:94:70:c6:ed:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c6:ed:97',
                                             'name': 'ont 212088',
                                             'serial_number': '11B22BD',
                                             'system_mac_address': None},
                'b8:94:70:c7:04:f7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c7:04:f7',
                                             'name': 'ont 215783',
                                             'serial_number': '11B25A9',
                                             'system_mac_address': None},
                'cc:be:59:04:29:90': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:04:29:90',
                                             'name': 'ont 18',
                                             'serial_number': '3EBA19',
                                             'system_mac_address': None},
                'cc:be:59:04:2b:60': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:04:2b:60',
                                             'name': 'ont 230',
                                             'serial_number': '3EBA53',
                                             'system_mac_address': None},
                'cc:be:59:0c:b5:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0c:b5:b4',
                                             'name': 'ont 17',
                                             'serial_number': '3ADD6E',
                                             'system_mac_address': None},
                'cc:be:59:0c:b5:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0c:b5:cc',
                                             'name': 'ont 1',
                                             'serial_number': '3ADD71',
                                             'system_mac_address': None},
                'cc:be:59:0d:27:04': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:27:04',
                                             'name': 'ont 240',
                                             'serial_number': '3AEB98',
                                             'system_mac_address': None},
                'cc:be:59:0d:27:f4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:27:f4',
                                             'name': 'ont 239',
                                             'serial_number': '3AEBB6',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:2c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:2c',
                                             'name': 'ont 238',
                                             'serial_number': '3AEBBD',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:44': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:44',
                                             'name': 'ont 108',
                                             'serial_number': '3AEBC0',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:84': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:84',
                                             'name': 'ont 237',
                                             'serial_number': '3AEBC8',
                                             'system_mac_address': None},
                'cc:be:59:0d:2b:3c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:2b:3c',
                                             'name': 'ont 236',
                                             'serial_number': '3AEC1F',
                                             'system_mac_address': None},
                'cc:be:59:0d:2b:4c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:2b:4c',
                                             'name': 'ont 16',
                                             'serial_number': '3AEC21',
                                             'system_mac_address': None},
                'cc:be:59:2b:a9:47': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:2b:a9:47',
                                             'name': 'ont 28',
                                             'serial_number': '3FB35D',
                                             'system_mac_address': None},
                'cc:be:59:46:c9:cf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:46:c9:cf',
                                             'name': 'ont 211',
                                             'serial_number': '39507A',
                                             'system_mac_address': None},
                'cc:be:59:47:32:bf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:47:32:bf',
                                             'name': 'ont 299',
                                             'serial_number': '433E5F',
                                             'system_mac_address': None},
                'cc:be:59:50:17:31': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:17:31',
                                             'name': 'ont 13',
                                             'serial_number': '43C21A',
                                             'system_mac_address': None},
                'cc:be:59:50:17:95': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:17:95',
                                             'name': 'ont 8',
                                             'serial_number': '43C24C',
                                             'system_mac_address': None},
                'cc:be:59:50:1a:b7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:1a:b7',
                                             'name': 'ont 7',
                                             'serial_number': '43C3DD',
                                             'system_mac_address': None},
                'cc:be:59:52:6d:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:52:6d:37',
                                             'name': 'ont 21',
                                             'serial_number': '3FC3C2',
                                             'system_mac_address': None},
                'cc:be:59:5f:16:62': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:5f:16:62',
                                             'name': 'ont 113',
                                             'serial_number': '455673',
                                             'system_mac_address': None},
                'cc:be:59:6a:dd:5e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6a:dd:5e',
                                             'name': 'ont 328',
                                             'serial_number': '46CE0A',
                                             'system_mac_address': None},
                'cc:be:59:6d:3d:5e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:3d:5e',
                                             'name': 'ont 261',
                                             'serial_number': '3FFFE3',
                                             'system_mac_address': None},
                'cc:be:59:6d:5a:be': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:5a:be',
                                             'name': 'ont 219',
                                             'serial_number': '40038F',
                                             'system_mac_address': None},
                'cc:be:59:6d:5c:e6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:5c:e6',
                                             'name': 'ont 228',
                                             'serial_number': '4003D4',
                                             'system_mac_address': None},
                'cc:be:59:6d:60:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:60:ee',
                                             'name': 'ont 249',
                                             'serial_number': '400455',
                                             'system_mac_address': None},
                'cc:be:59:6d:7e:3e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:7e:3e',
                                             'name': 'ont 276',
                                             'serial_number': '4007FF',
                                             'system_mac_address': None},
                'cc:be:59:6d:85:26': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:85:26',
                                             'name': 'ont 307',
                                             'serial_number': '4008DC',
                                             'system_mac_address': None},
                'cc:be:59:6d:b9:be': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:b9:be',
                                             'name': 'ont 243',
                                             'serial_number': '400F64',
                                             'system_mac_address': None},
                'cc:be:59:6d:e8:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:e8:d6',
                                             'name': 'ont 209',
                                             'serial_number': '4703AF',
                                             'system_mac_address': None},
                'cc:be:59:6e:14:ca': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:14:ca',
                                             'name': 'ont 33',
                                             'serial_number': '47092C',
                                             'system_mac_address': None},
                'cc:be:59:6e:6e:da': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:6e:da',
                                             'name': 'ont 191',
                                             'serial_number': '47146E',
                                             'system_mac_address': None},
                'cc:be:59:6e:ae:96': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:ae:96',
                                             'name': 'ont 224679',
                                             'serial_number': '471C63',
                                             'system_mac_address': None},
                'cc:be:59:6f:1d:c2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:1d:c2',
                                             'name': 'ont 99',
                                             'serial_number': '55DFB1',
                                             'system_mac_address': None},
                'cc:be:59:6f:29:52': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:29:52',
                                             'name': 'ont 111',
                                             'serial_number': '55E123',
                                             'system_mac_address': None},
                'cc:be:59:6f:74:d2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:74:d2',
                                             'name': 'ont 47',
                                             'serial_number': '55EA90',
                                             'system_mac_address': None},
                'cc:be:59:6f:fd:92': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:fd:92',
                                             'name': 'ont 73',
                                             'serial_number': '55FBA5',
                                             'system_mac_address': None},
                'cc:be:59:6f:ff:1a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:ff:1a',
                                             'name': 'ont 159',
                                             'serial_number': '55FBD6',
                                             'system_mac_address': None},
                'cc:be:59:70:33:7e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:33:7e',
                                             'name': 'ont 38',
                                             'serial_number': '560262',
                                             'system_mac_address': None},
                'cc:be:59:70:33:86': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:33:86',
                                             'name': 'ont 70',
                                             'serial_number': '560263',
                                             'system_mac_address': None},
                'cc:be:59:70:81:36': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:81:36',
                                             'name': 'ont 67',
                                             'serial_number': '560C19',
                                             'system_mac_address': None},
                'cc:be:59:af:a5:9b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:af:a5:9b',
                                             'name': 'ont 126',
                                             'serial_number': '4E36A8',
                                             'system_mac_address': None},
                'cc:be:59:af:d8:7b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:af:d8:7b',
                                             'name': 'ont 119',
                                             'serial_number': '4E3D04',
                                             'system_mac_address': None},
                'cc:be:59:b3:7c:9b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:b3:7c:9b',
                                             'name': 'ont 195',
                                             'serial_number': '4EB17D',
                                             'system_mac_address': None},
                'cc:be:59:b7:3b:67': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:b7:3b:67',
                                             'name': 'ont 203',
                                             'serial_number': '4D111F',
                                             'system_mac_address': None},
                'cc:be:59:ca:db:7a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:db:7a',
                                             'name': 'ont 231',
                                             'serial_number': '42816E',
                                             'system_mac_address': None},
                'cc:be:59:ca:dc:92': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:dc:92',
                                             'name': 'ont 35',
                                             'serial_number': '428191',
                                             'system_mac_address': None},
                'cc:be:59:ca:de:8a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:de:8a',
                                             'name': 'ont 32',
                                             'serial_number': '4281D0',
                                             'system_mac_address': None},
                'cc:be:59:cb:43:da': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:43:da',
                                             'name': 'ont 10',
                                             'serial_number': '42B9D3',
                                             'system_mac_address': None},
                'cc:be:59:cb:44:72': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:44:72',
                                             'name': 'ont 46',
                                             'serial_number': '42B9E6',
                                             'system_mac_address': None},
                'cc:be:59:cb:6c:5a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:6c:5a',
                                             'name': 'ont 345',
                                             'serial_number': '42BEE3',
                                             'system_mac_address': None},
                'cc:be:59:cb:7e:02': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:7e:02',
                                             'name': 'ont 91',
                                             'serial_number': '42C118',
                                             'system_mac_address': None},
                'cc:be:59:cb:95:e2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:95:e2',
                                             'name': 'ont 5',
                                             'serial_number': '42C414',
                                             'system_mac_address': None},
                'cc:be:59:cb:bb:ba': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bb:ba',
                                             'name': 'ont 76',
                                             'serial_number': '42C8CF',
                                             'system_mac_address': None},
                'cc:be:59:cb:bd:12': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bd:12',
                                             'name': 'ont 326',
                                             'serial_number': '42C8FA',
                                             'system_mac_address': None},
                'cc:be:59:cb:bf:3a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bf:3a',
                                             'name': 'ont 92',
                                             'serial_number': '42C93F',
                                             'system_mac_address': None},
                'cc:be:59:cb:ea:02': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:ea:02',
                                             'name': 'ont 86',
                                             'serial_number': '42CE98',
                                             'system_mac_address': None},
                'cc:be:59:cc:03:2a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:03:2a',
                                             'name': 'ont 89',
                                             'serial_number': '42D1BD',
                                             'system_mac_address': None},
                'cc:be:59:cc:0b:1a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:0b:1a',
                                             'name': 'ont 83',
                                             'serial_number': '42D2BB',
                                             'system_mac_address': None},
                'cc:be:59:cc:11:3a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:11:3a',
                                             'name': 'ont 82',
                                             'serial_number': '42D37F',
                                             'system_mac_address': None},
                'cc:be:59:cc:11:ba': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:11:ba',
                                             'name': 'ont 19',
                                             'serial_number': '42D38F',
                                             'system_mac_address': None},
                'cc:be:59:eb:02:16': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:02:16',
                                             'name': 'ont 269',
                                             'serial_number': '555CB8',
                                             'system_mac_address': None},
                'cc:be:59:eb:39:ae': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:39:ae',
                                             'name': 'ont 250',
                                             'serial_number': '5563AB',
                                             'system_mac_address': None},
                'cc:be:59:eb:39:be': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:39:be',
                                             'name': 'ont 65',
                                             'serial_number': '5563AD',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:06': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:06',
                                             'name': 'ont 245',
                                             'serial_number': '5563B6',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:de': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:de',
                                             'name': 'ont 26',
                                             'serial_number': '5563D1',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:ee',
                                             'name': 'ont 336',
                                             'serial_number': '5563D3',
                                             'system_mac_address': None},
                'cc:be:59:eb:3b:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3b:d6',
                                             'name': 'ont 304',
                                             'serial_number': '5563F0',
                                             'system_mac_address': None},
                'cc:be:59:ef:f4:de': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f4:de',
                                             'name': 'ont 42',
                                             'serial_number': '4D41EE',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:0e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:0e',
                                             'name': 'ont 29',
                                             'serial_number': '4D41F4',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:16': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:16',
                                             'name': 'ont 247',
                                             'serial_number': '4D41F5',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:26': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:26',
                                             'name': 'ont 257',
                                             'serial_number': '4D41F7',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:56': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:56',
                                             'name': 'ont 253',
                                             'serial_number': '4D423D',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:7e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:7e',
                                             'name': 'ont 275',
                                             'serial_number': '4D4242',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:d6',
                                             'name': 'ont 319',
                                             'serial_number': '4D424D',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:e6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:e6',
                                             'name': 'ont 218',
                                             'serial_number': '4D424F',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:ee',
                                             'name': 'ont 6',
                                             'serial_number': '4D4250',
                                             'system_mac_address': None},
                'd0:76:8f:06:e5:fe': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:06:e5:fe',
                                             'name': 'ont 140853',
                                             'serial_number': '844BE5',
                                             'system_mac_address': None},
                'd0:76:8f:07:19:91': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:07:19:91',
                                             'name': 'ont 347',
                                             'serial_number': '8678B6',
                                             'system_mac_address': None},
                'd0:76:8f:08:14:ab': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:14:ab',
                                             'name': 'ont 156430',
                                             'serial_number': '86938B',
                                             'system_mac_address': None},
                'd0:76:8f:08:15:33': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:15:33',
                                             'name': 'ont 138881',
                                             'serial_number': '86939C',
                                             'system_mac_address': None},
                'd0:76:8f:08:16:83': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:16:83',
                                             'name': 'ont 142356',
                                             'serial_number': '8693C6',
                                             'system_mac_address': None},
                'd0:76:8f:08:17:4b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:17:4b',
                                             'name': 'ont 90',
                                             'serial_number': '8693DF',
                                             'system_mac_address': None},
                'd0:76:8f:08:18:33': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:18:33',
                                             'name': 'ont 138680',
                                             'serial_number': '8693FC',
                                             'system_mac_address': None},
                'd0:76:8f:08:19:1b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:19:1b',
                                             'name': 'ont 142326',
                                             'serial_number': '869419',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:6b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:6b',
                                             'name': 'ont 31',
                                             'serial_number': '87241B',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:bb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:bb',
                                             'name': 'ont 143043',
                                             'serial_number': '872425',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:e3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:e3',
                                             'name': 'ont 15',
                                             'serial_number': '87242A',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a0:83': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a0:83',
                                             'name': 'ont 210',
                                             'serial_number': '87245E',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a1:13': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a1:13',
                                             'name': 'ont 53',
                                             'serial_number': '872470',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a1:1b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a1:1b',
                                             'name': 'ont 144446',
                                             'serial_number': '872471',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a5:73': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a5:73',
                                             'name': 'ont 314',
                                             'serial_number': '8724FC',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a7:3b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a7:3b',
                                             'name': 'ont 136',
                                             'serial_number': '872535',
                                             'system_mac_address': None},
                'd0:76:8f:a9:53:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:a9:53:88',
                                             'name': 'ont 143882',
                                             'serial_number': '954F45',
                                             'system_mac_address': None},
                'd0:76:8f:aa:4e:f4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:4e:f4',
                                             'name': 'ont 20',
                                             'serial_number': '956F04',
                                             'system_mac_address': None},
                'd0:76:8f:aa:4f:e4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:4f:e4',
                                             'name': 'ont 282',
                                             'serial_number': '956F22',
                                             'system_mac_address': None},
                'd0:76:8f:aa:50:04': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:50:04',
                                             'name': 'ont 146001',
                                             'serial_number': '956F26',
                                             'system_mac_address': None},
                'd0:76:8f:aa:54:0c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:54:0c',
                                             'name': 'ont 145630',
                                             'serial_number': '956FA7',
                                             'system_mac_address': None},
                'ec:4f:82:02:06:79': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:02:06:79',
                                             'name': 'ont 232',
                                             'serial_number': '1F7DA1',
                                             'system_mac_address': None},
                'ec:4f:82:08:2e:cd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:08:2e:cd',
                                             'name': 'ont 93',
                                             'serial_number': '1C5DCF',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:97',
                                             'name': 'ont 34',
                                             'serial_number': '248AC3',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:af',
                                             'name': 'ont 320',
                                             'serial_number': '248AC6',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:0f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:0f',
                                             'name': 'ont 312',
                                             'serial_number': '248AD2',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:37',
                                             'name': 'ont 164',
                                             'serial_number': '248AD7',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:97',
                                             'name': 'ont 248',
                                             'serial_number': '248AE3',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:af',
                                             'name': 'ont 162',
                                             'serial_number': '248AE6',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:cf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:cf',
                                             'name': 'ont 327',
                                             'serial_number': '248AEA',
                                             'system_mac_address': None},
                'ec:4f:82:32:27:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:27:1f',
                                             'name': 'ont 329',
                                             'serial_number': '248AF4',
                                             'system_mac_address': None},
                'ec:4f:82:33:d5:0f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:33:d5:0f',
                                             'name': 'ont 72',
                                             'serial_number': '1FC4EF',
                                             'system_mac_address': None},
                'ec:4f:82:44:18:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:44:18:1f',
                                             'name': 'ont 265',
                                             'serial_number': '23A003',
                                             'system_mac_address': None},
                'ec:4f:82:4c:a5:67': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:4c:a5:67',
                                             'name': 'ont 227',
                                             'serial_number': '25B5F9',
                                             'system_mac_address': None},
                'ec:4f:82:59:55:07': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:59:55:07',
                                             'name': 'ont 234',
                                             'serial_number': '2AA878',
                                             'system_mac_address': None},
                'ec:4f:82:59:5b:77': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:59:5b:77',
                                             'name': 'ont 233',
                                             'serial_number': '2AA946',
                                             'system_mac_address': None},
                'ec:4f:82:67:6d:cd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:6d:cd',
                                             'name': 'ont 279',
                                             'serial_number': '25D8AE',
                                             'system_mac_address': None},
                'ec:4f:82:67:71:b5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:71:b5',
                                             'name': 'ont 324',
                                             'serial_number': '25D92B',
                                             'system_mac_address': None},
                'ec:4f:82:67:71:fd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:71:fd',
                                             'name': 'ont 110',
                                             'serial_number': '25D934',
                                             'system_mac_address': None},
                'ec:4f:82:7a:23:67': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:7a:23:67',
                                             'name': 'ont 197',
                                             'serial_number': '2F3AD9',
                                             'system_mac_address': None},
                'ec:4f:82:8d:3f:60': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:3f:60',
                                             'name': 'ont 44',
                                             'serial_number': '321033',
                                             'system_mac_address': None},
                'ec:4f:82:8d:4b:60': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:4b:60',
                                             'name': 'ont 4',
                                             'serial_number': '3211B3',
                                             'system_mac_address': None},
                'ec:4f:82:8d:76:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:76:88',
                                             'name': 'ont 12',
                                             'serial_number': '321718',
                                             'system_mac_address': None},
                'ec:4f:82:8d:7a:d8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:7a:d8',
                                             'name': 'ont 14',
                                             'serial_number': '3217A2',
                                             'system_mac_address': None},
                'ec:4f:82:8d:7c:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:7c:18',
                                             'name': 'ont 11',
                                             'serial_number': '3217CA',
                                             'system_mac_address': None},
                'ec:4f:82:8d:88:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:88:88',
                                             'name': 'ont 30',
                                             'serial_number': '321958',
                                             'system_mac_address': None},
                'ec:4f:82:8d:dc:60': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:dc:60',
                                             'name': 'ont 43',
                                             'serial_number': '3223D3',
                                             'system_mac_address': None},
                'ec:4f:82:8d:dd:90': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:dd:90',
                                             'name': 'ont 9',
                                             'serial_number': '3223F9',
                                             'system_mac_address': None},
                'ec:4f:82:8e:00:f0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8e:00:f0',
                                             'name': 'ont 23',
                                             'serial_number': '322865',
                                             'system_mac_address': None},
                'ec:4f:82:8e:05:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8e:05:d0',
                                             'name': 'ont 3',
                                             'serial_number': '322901',
                                             'system_mac_address': None},
                'ec:4f:82:92:f6:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:f6:18',
                                             'name': 'ont 285',
                                             'serial_number': '32954F',
                                             'system_mac_address': None},
                'ec:4f:82:92:fa:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fa:80',
                                             'name': 'ont 104',
                                             'serial_number': '3295DC',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:50': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:50',
                                             'name': 'ont 300',
                                             'serial_number': '329636',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:68': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:68',
                                             'name': 'ont 187',
                                             'serial_number': '329639',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:80',
                                             'name': 'ont 39',
                                             'serial_number': '32963C',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:b0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:b0',
                                             'name': 'ont 142',
                                             'serial_number': '329642',
                                             'system_mac_address': None},
                'ec:4f:82:9b:b6:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:9b:b6:b4',
                                             'name': 'ont 235',
                                             'serial_number': '33AD09',
                                             'system_mac_address': None},
                'ec:4f:82:9c:fa:6c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:9c:fa:6c',
                                             'name': 'ont 2',
                                             'serial_number': '33D580',
                                             'system_mac_address': None},
                'ec:4f:82:a2:ae:49': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:a2:ae:49',
                                             'name': 'ont 148125',
                                             'serial_number': '349D6E',
                                             'system_mac_address': None},
                'ec:4f:82:b8:2c:40': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:2c:40',
                                             'name': 'ont 270',
                                             'serial_number': '2FCC31',
                                             'system_mac_address': None},
                'ec:4f:82:b8:2c:78': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:2c:78',
                                             'name': 'ont 176',
                                             'serial_number': '2FCC38',
                                             'system_mac_address': None},
                'ec:4f:82:b8:31:c0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:31:c0',
                                             'name': 'ont 166',
                                             'serial_number': '2FCCE1',
                                             'system_mac_address': None},
                'ec:4f:82:b9:18:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:18:80',
                                             'name': 'ont 105',
                                             'serial_number': '2FE9BA',
                                             'system_mac_address': None},
                'ec:4f:82:b9:1a:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:1a:48',
                                             'name': 'ont 288',
                                             'serial_number': '2FE9F3',
                                             'system_mac_address': None},
                'ec:4f:82:b9:1a:c8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:1a:c8',
                                             'name': 'ont 24',
                                             'serial_number': '2FEA03',
                                             'system_mac_address': None},
                'ec:4f:82:be:ac:21': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:be:ac:21',
                                             'name': 'ont 165',
                                             'serial_number': '3788C1',
                                             'system_mac_address': None},
                'ec:4f:82:c0:c3:b0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:c0:c3:b0',
                                             'name': 'ont 201',
                                             'serial_number': '3655A9',
                                             'system_mac_address': None},
                'ec:4f:82:cb:05:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:05:18',
                                             'name': 'ont 310',
                                             'serial_number': '2C9A0E',
                                             'system_mac_address': None},
                'ec:4f:82:cb:2b:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:2b:48',
                                             'name': 'ont 117',
                                             'serial_number': '2C9ED4',
                                             'system_mac_address': None},
                'ec:4f:82:cb:4d:14': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:4d:14',
                                             'name': 'ont 284',
                                             'serial_number': '2CA30D',
                                             'system_mac_address': None},
                'ec:4f:82:cb:9e:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:9e:b8',
                                             'name': 'ont 306',
                                             'serial_number': '38F111',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a2:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a2:88',
                                             'name': 'ont 166768',
                                             'serial_number': '38F18B',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a5:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a5:80',
                                             'name': 'ont 293',
                                             'serial_number': '38F1EA',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a6:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a6:18',
                                             'name': 'ont 109',
                                             'serial_number': '38F1FD',
                                             'system_mac_address': None},
                'ec:4f:82:cc:6c:04': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cc:6c:04',
                                             'name': 'ont 103',
                                             'serial_number': '390AB8',
                                             'system_mac_address': None},
                'ec:4f:82:da:ad:58': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:da:ad:58',
                                             'name': 'ont 135',
                                             'serial_number': '2E914A',
                                             'system_mac_address': None},
                'ec:4f:82:db:f0:ec': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:db:f0:ec',
                                             'name': 'ont 25',
                                             'serial_number': '2EB9B8',
                                             'system_mac_address': None},
                'ec:4f:82:dc:a5:2c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:a5:2c',
                                             'name': 'ont 294',
                                             'serial_number': '2ED03F',
                                             'system_mac_address': None},
                'ec:4f:82:dc:f1:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:f1:b4',
                                             'name': 'ont 74',
                                             'serial_number': '2ED9D0',
                                             'system_mac_address': None},
                'ec:4f:82:dc:f2:dc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:f2:dc',
                                             'name': 'ont 222',
                                             'serial_number': '2ED9F5',
                                             'system_mac_address': None},
                'ec:4f:82:e0:0a:e0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:e0:0a:e0',
                                             'name': 'ont 50',
                                             'serial_number': '3961A9',
                                             'system_mac_address': None},
                'f8:85:f9:06:4e:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:4e:64',
                                             'name': 'ont 258',
                                             'serial_number': 'BF1E1B',
                                             'system_mac_address': None},
                'f8:85:f9:06:6c:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:6c:cc',
                                             'name': 'ont 164063',
                                             'serial_number': 'BF21E8',
                                             'system_mac_address': None},
                'f8:85:f9:06:77:e4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:77:e4',
                                             'name': 'ont 116',
                                             'serial_number': 'BF234B',
                                             'system_mac_address': None},
                'f8:85:f9:6f:1b:dd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:1b:dd',
                                             'name': 'ont 213238',
                                             'serial_number': 'BF242A',
                                             'system_mac_address': None},
                'f8:85:f9:6f:20:25': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:20:25',
                                             'name': 'ont 196',
                                             'serial_number': 'BF24B4',
                                             'system_mac_address': None},
                'f8:85:f9:6f:21:0d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:21:0d',
                                             'name': 'ont 166718',
                                             'serial_number': 'BF24D1',
                                             'system_mac_address': None},
                'f8:85:f9:6f:22:05': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:22:05',
                                             'name': 'ont 134',
                                             'serial_number': 'BF24F1',
                                             'system_mac_address': None},
                'f8:85:f9:6f:22:a5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:22:a5',
                                             'name': 'ont 208',
                                             'serial_number': 'BF2505',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'front',
                                                              'mac_address': 'cc:be:59:12:6a:c8',
                                                              'name': 'Craft-FE: front',
                                                              'oper_up': True,
                                                              'poller_hash': 'NzE3MDI5NzAyNjhmcm9udA=='},
                                                      {       'admin_up': False,
                                                              'id': 'rear',
                                                              'name': 'Craft-FE: rear',
                                                              'oper_up': False,
                                                              'poller_hash': 'NzE3MDI5NzAyNjhyZWFy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2 (EXA)',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1/x3',
                                                                                         'in_discards': '21697584',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2002698942',
                                                                                         'in_octets': '3193749123865884',
                                                                                         'in_ucast_pkts': '7817576615514',
                                                                                         'mac_address': 'cc:be:59:12:6a:d7',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-10G-DAC',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '10729708171472',
                                                                                         'out_octets': '36650296960490269',
                                                                                         'out_ucast_pkts': '17336223633998',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/x4',
                                                                                         'in_discards': '2697756',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '24769407',
                                                                                         'in_octets': '1153224162623770',
                                                                                         'in_ucast_pkts': '855641602377',
                                                                                         'mac_address': 'cc:be:59:12:6a:d8',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC02',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 '1/x4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '42308667',
                                                                                         'out_octets': '38241112682669',
                                                                                         'out_ucast_pkts': '157723855663',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4TUNDTC1TVUJTIDEveDQ=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2564',
                                                                                         'in_octets': '682781',
                                                                                         'in_ucast_pkts': '3781',
                                                                                         'mac_address': 'cc:be:59:12:6a:c9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01669',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '357602457',
                                                                                         'out_octets': '25359089422',
                                                                                         'out_ucast_pkts': '1096281',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g2',
                                                                                         'mac_address': 'cc:be:59:12:6a:ca',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g3',
                                                                                         'mac_address': 'cc:be:59:12:6a:cb',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g4',
                                                                                         'mac_address': 'cc:be:59:12:6a:cc',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nNA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/1',
                                                                                         'in_discards': '170552',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23121585',
                                                                                         'in_octets': '18966994710819',
                                                                                         'in_ucast_pkts': '73556952837',
                                                                                         'links': [       {       'in_nucast_pkts': '14069242',
                                                                                                                  'in_octets': '59063013270',
                                                                                                                  'in_ucast_pkts': '218514818',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3957128179',
                                                                                                                  'out_octets': '5611597174418',
                                                                                                                  'out_ucast_pkts': '562869856',
                                                                                                                  'poller_hash': 'MzIyOTAxcGVlcmludGZwb24gMw=='},
                                                                                                          {       'in_nucast_pkts': '90841',
                                                                                                                  'in_octets': '33895330522',
                                                                                                                  'in_ucast_pkts': '113276346',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673633',
                                                                                                                  'out_octets': '745306099929',
                                                                                                                  'out_ucast_pkts': '534382384',
                                                                                                                  'poller_hash': 'OTU2RjA0cGVlcmludGZwb24gMjA='},
                                                                                                          {       'in_nucast_pkts': '1318514',
                                                                                                                  'in_octets': '51604936970',
                                                                                                                  'in_ucast_pkts': '115119527',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2157176568',
                                                                                                                  'out_octets': '3229927341111',
                                                                                                                  'out_ucast_pkts': '329453084',
                                                                                                                  'poller_hash': 'MUZDNEVGcGVlcmludGZwb24gNzI='},
                                                                                                          {       'in_nucast_pkts': '20585856',
                                                                                                                  'in_octets': '3009314121',
                                                                                                                  'in_ucast_pkts': '3530496',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11414691962',
                                                                                                                  'out_octets': '14697889834413',
                                                                                                                  'out_ucast_pkts': '4297451',
                                                                                                                  'poller_hash': 'NTVGQkE1cGVlcmludGZwb24gNzM='},
                                                                                                          {       'in_nucast_pkts': '20481301',
                                                                                                                  'in_octets': '232307344044',
                                                                                                                  'in_ucast_pkts': '501713120',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18201873051',
                                                                                                                  'out_octets': '25543553135809',
                                                                                                                  'out_ucast_pkts': '1381446414',
                                                                                                                  'poller_hash': 'MkVEOUQwcGVlcmludGZwb24gNzQ='},
                                                                                                          {       'in_nucast_pkts': '3563',
                                                                                                                  'in_octets': '1826632264',
                                                                                                                  'in_ucast_pkts': '8502288',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949595',
                                                                                                                  'out_octets': '10928395954',
                                                                                                                  'out_ucast_pkts': '11921346',
                                                                                                                  'poller_hash': 'NDE1MzBwZWVyaW50ZnBvbiA3NQ=='},
                                                                                                          {       'in_nucast_pkts': '6',
                                                                                                                  'in_octets': '28203883610',
                                                                                                                  'in_ucast_pkts': '217440646',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '947335',
                                                                                                                  'out_octets': '1339640915840',
                                                                                                                  'out_ucast_pkts': '943563819',
                                                                                                                  'poller_hash': 'NjQwQjRGcGVlcmludGZwb24gODc='},
                                                                                                          {       'in_nucast_pkts': '751035',
                                                                                                                  'in_octets': '108086681878',
                                                                                                                  'in_ucast_pkts': '122645729',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1236003',
                                                                                                                  'out_octets': '145932193005',
                                                                                                                  'out_ucast_pkts': '1035248157501',
                                                                                                                  'poller_hash': 'RjFGOHBlZXJpbnRmcG9uIDEwNw=='},
                                                                                                          {       'in_nucast_pkts': '3',
                                                                                                                  'in_octets': '49513817619',
                                                                                                                  'in_ucast_pkts': '198975025',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949555',
                                                                                                                  'out_octets': '948196264297',
                                                                                                                  'out_ucast_pkts': '727644744',
                                                                                                                  'poller_hash': 'MzhGMUZEcGVlcmludGZwb24gMTA5'},
                                                                                                          {       'in_nucast_pkts': '4349',
                                                                                                                  'in_octets': '55250289569',
                                                                                                                  'in_ucast_pkts': '113469408',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '948957',
                                                                                                                  'out_octets': '360637501340',
                                                                                                                  'out_ucast_pkts': '301529495',
                                                                                                                  'poller_hash': 'MjVEOTM0cGVlcmludGZwb24gMTEw'},
                                                                                                          {       'in_nucast_pkts': '16611691',
                                                                                                                  'in_octets': '117802388104',
                                                                                                                  'in_ucast_pkts': '438259149',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12790968379',
                                                                                                                  'out_octets': '18022057538837',
                                                                                                                  'out_ucast_pkts': '945368426',
                                                                                                                  'poller_hash': 'NTVFMTIzcGVlcmludGZwb24gMTEx'},
                                                                                                          {       'in_nucast_pkts': '4309067',
                                                                                                                  'in_octets': '6600833744',
                                                                                                                  'in_ucast_pkts': '16720838',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5326109269',
                                                                                                                  'out_octets': '7115535022680',
                                                                                                                  'out_ucast_pkts': '58044652',
                                                                                                                  'poller_hash': 'MTk5OUM1cGVlcmludGZwb24gMTEy'},
                                                                                                          {       'in_nucast_pkts': '81909',
                                                                                                                  'in_octets': '30914805757',
                                                                                                                  'in_ucast_pkts': '110371040',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949528',
                                                                                                                  'out_octets': '378585414491',
                                                                                                                  'out_ucast_pkts': '293020755',
                                                                                                                  'poller_hash': 'NDU1NjczcGVlcmludGZwb24gMTEz'},
                                                                                                          {       'in_nucast_pkts': '748963',
                                                                                                                  'in_octets': '27140393953',
                                                                                                                  'in_ucast_pkts': '359627736',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2481865',
                                                                                                                  'out_octets': '31128456007',
                                                                                                                  'out_ucast_pkts': '449041433',
                                                                                                                  'poller_hash': 'QTlDOEY5cGVlcmludGZwb24gMTE0'},
                                                                                                          {       'in_nucast_pkts': '1145847',
                                                                                                                  'in_octets': '10417712770',
                                                                                                                  'in_ucast_pkts': '66255898',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1849900569',
                                                                                                                  'out_octets': '2797396984616',
                                                                                                                  'out_ucast_pkts': '267852363',
                                                                                                                  'poller_hash': 'MkZDQzM4cGVlcmludGZwb24gMTc2'},
                                                                                                          {       'in_nucast_pkts': '49',
                                                                                                                  'in_octets': '33797575015',
                                                                                                                  'in_ucast_pkts': '94512933',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1669699',
                                                                                                                  'out_octets': '645815705901',
                                                                                                                  'out_ucast_pkts': '467732380',
                                                                                                                  'poller_hash': 'QzgyMTMxcGVlcmludGZwb24gMTYxNjU3'},
                                                                                                          {       'in_nucast_pkts': '80091',
                                                                                                                  'in_octets': '14057917987',
                                                                                                                  'in_ucast_pkts': '79888037',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673784',
                                                                                                                  'out_octets': '375329903972',
                                                                                                                  'out_ucast_pkts': '281701041',
                                                                                                                  'poller_hash': 'QzgzQjk3cGVlcmludGZwb24gMTcwNzEy'},
                                                                                                          {       'in_nucast_pkts': '4643376',
                                                                                                                  'in_octets': '1505744235',
                                                                                                                  'in_ucast_pkts': '5698264',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13677242045',
                                                                                                                  'out_octets': '18202544958745',
                                                                                                                  'out_ucast_pkts': '4189913',
                                                                                                                  'poller_hash': 'QzgxQ0JFcGVlcmludGZwb24gMjA2Njgw'},
                                                                                                          {       'in_nucast_pkts': '1672',
                                                                                                                  'in_octets': '25923273383',
                                                                                                                  'in_ucast_pkts': '150614613',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9074881',
                                                                                                                  'out_octets': '1032664135510',
                                                                                                                  'out_ucast_pkts': '745432124',
                                                                                                                  'poller_hash': 'MTE5NTE1MXBlZXJpbnRmcG9uIDIxNDYyMA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '651021276339',
                                                                                         'out_octets': '1143027285685249',
                                                                                         'out_ucast_pkts': '199363661470',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzE=',
                                                                                         'pons': [       {       'id': '1/1',
                                                                                                                 'links': [       {       'connected_time': '18919036',
                                                                                                                                          'fiber_length': 1957,
                                                                                                                                          'poller_hash': 'MzIyOTAxcGVlcnBvbnBvbiAz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3448142',
                                                                                                                                          'fiber_length': 1818,
                                                                                                                                          'poller_hash': 'OTU2RjA0cGVlcnBvbnBvbiAyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3448160',
                                                                                                                                          'fiber_length': 1841,
                                                                                                                                          'poller_hash': 'MUZDNEVGcGVlcnBvbnBvbiA3Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '18904167',
                                                                                                                                          'fiber_length': 1895,
                                                                                                                                          'poller_hash': 'NTVGQkE1cGVlcnBvbnBvbiA3Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '18904007',
                                                                                                                                          'fiber_length': 1848,
                                                                                                                                          'poller_hash': 'MkVEOUQwcGVlcnBvbnBvbiA3NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3448093',
                                                                                                                                          'fiber_length': 1837,
                                                                                                                                          'poller_hash': 'NDE1MzBwZWVycG9ucG9uIDc1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3448136',
                                                                                                                                          'fiber_length': 1476,
                                                                                                                                          'poller_hash': 'NjQwQjRGcGVlcnBvbnBvbiA4Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '18903614',
                                                                                                                                          'fiber_length': 1677,
                                                                                                                                          'poller_hash': 'RjFGOHBlZXJwb25wb24gMTA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3448140',
                                                                                                                                          'fiber_length': 1731,
                                                                                                                                          'poller_hash': 'MzhGMUZEcGVlcnBvbnBvbiAxMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3448125',
                                                                                                                                          'fiber_length': 1740,
                                                                                                                                          'poller_hash': 'MjVEOTM0cGVlcnBvbnBvbiAxMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '18903782',
                                                                                                                                          'fiber_length': 1735,
                                                                                                                                          'poller_hash': 'NTVFMTIzcGVlcnBvbnBvbiAxMTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3448172',
                                                                                                                                          'fiber_length': 1714,
                                                                                                                                          'poller_hash': 'MTk5OUM1cGVlcnBvbnBvbiAxMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3448189',
                                                                                                                                          'fiber_length': 1671,
                                                                                                                                          'poller_hash': 'NDU1NjczcGVlcnBvbnBvbiAxMTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3465310',
                                                                                                                                          'fiber_length': 1876,
                                                                                                                                          'poller_hash': 'QTlDOEY5cGVlcnBvbnBvbiAxMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3448207',
                                                                                                                                          'fiber_length': 1677,
                                                                                                                                          'poller_hash': 'MkZDQzM4cGVlcnBvbnBvbiAxNzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3233483',
                                                                                                                                          'fiber_length': 1799,
                                                                                                                                          'poller_hash': 'QzgyMTMxcGVlcnBvbnBvbiAxNjE2NTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '3448381',
                                                                                                                                          'fiber_length': 1527,
                                                                                                                                          'poller_hash': 'QzgzQjk3cGVlcnBvbnBvbiAxNzA3MTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '18919207',
                                                                                                                                          'fiber_length': 1970,
                                                                                                                                          'poller_hash': 'QzgxQ0JFcGVlcnBvbnBvbiAyMDY2ODA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808},
                                                                                                                                  {       'connected_time': '17592497',
                                                                                                                                          'fiber_length': 1831,
                                                                                                                                          'poller_hash': 'MTE5NTE1MXBlZXJwb25wb24gMjE0NjIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.808}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/1',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/2',
                                                                                         'in_discards': '3125',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17049341',
                                                                                         'in_octets': '16045106731120',
                                                                                         'in_ucast_pkts': '84638964916',
                                                                                         'links': [       {       'in_nucast_pkts': '24272211',
                                                                                                                  'in_octets': '1640611832075',
                                                                                                                  'in_ucast_pkts': '2653686065',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '30027918463',
                                                                                                                  'out_octets': '45905528178104',
                                                                                                                  'out_ucast_pkts': '4614828670',
                                                                                                                  'poller_hash': 'M0ZCMzVEcGVlcmludGZwb24gMjg='},
                                                                                                          {       'in_nucast_pkts': '331',
                                                                                                                  'in_octets': '24732794490',
                                                                                                                  'in_ucast_pkts': '125905148',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '28798',
                                                                                                                  'out_octets': '317086102149',
                                                                                                                  'out_ucast_pkts': '243402125',
                                                                                                                  'poller_hash': 'QzU3Q0RwZWVyaW50ZnBvbiA0OQ=='},
                                                                                                          {       'in_nucast_pkts': '23619810',
                                                                                                                  'in_octets': '29491588815',
                                                                                                                  'in_ucast_pkts': '72847261',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '24569298171',
                                                                                                                  'out_octets': '33307798354019',
                                                                                                                  'out_ucast_pkts': '181770962',
                                                                                                                  'poller_hash': 'QkYyMzRCcGVlcmludGZwb24gMTE2'},
                                                                                                          {       'in_nucast_pkts': '9907411',
                                                                                                                  'in_octets': '104062585484',
                                                                                                                  'in_ucast_pkts': '348775259',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2651764168',
                                                                                                                  'out_octets': '4044446090773',
                                                                                                                  'out_ucast_pkts': '1088104884',
                                                                                                                  'poller_hash': 'MkM5RUQ0cGVlcmludGZwb24gMTE3'},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '20965801150',
                                                                                                                  'in_ucast_pkts': '195428459',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2565880',
                                                                                                                  'out_octets': '645174078078',
                                                                                                                  'out_ucast_pkts': '446025984',
                                                                                                                  'poller_hash': 'QzgzQjk4cGVlcmludGZwb24gMTcxNzA5'},
                                                                                                          {       'in_nucast_pkts': '1774329',
                                                                                                                  'in_octets': '4762629472',
                                                                                                                  'in_ucast_pkts': '11408095',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5908830066',
                                                                                                                  'out_octets': '7848473984022',
                                                                                                                  'out_ucast_pkts': '15537637',
                                                                                                                  'poller_hash': 'MTE5NTFBOXBlZXJpbnRmcG9uIDIxNjAwOQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '707132291998',
                                                                                         'out_octets': '1184983350438365',
                                                                                         'out_ucast_pkts': '190103611765',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzI=',
                                                                                         'pons': [       {       'id': '1/2',
                                                                                                                 'links': [       {       'connected_time': '18903936',
                                                                                                                                          'fiber_length': 1169,
                                                                                                                                          'poller_hash': 'M0ZCMzVEcGVlcnBvbnBvbiAyOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.829},
                                                                                                                                  {       'connected_time': '3448114',
                                                                                                                                          'fiber_length': 1161,
                                                                                                                                          'poller_hash': 'QzU3Q0RwZWVycG9ucG9uIDQ5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.829},
                                                                                                                                  {       'connected_time': '18903824',
                                                                                                                                          'fiber_length': 1117,
                                                                                                                                          'poller_hash': 'QkYyMzRCcGVlcnBvbnBvbiAxMTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.829},
                                                                                                                                  {       'connected_time': '18903857',
                                                                                                                                          'fiber_length': 1104,
                                                                                                                                          'poller_hash': 'MkM5RUQ0cGVlcnBvbnBvbiAxMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.829},
                                                                                                                                  {       'connected_time': '3308104',
                                                                                                                                          'fiber_length': 499,
                                                                                                                                          'poller_hash': 'QzgzQjk4cGVlcnBvbnBvbiAxNzE3MDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.829},
                                                                                                                                  {       'connected_time': '3448381',
                                                                                                                                          'fiber_length': 1188,
                                                                                                                                          'poller_hash': 'MTE5NTFBOXBlZXJwb25wb24gMjE2MDA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.829}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/2',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/3',
                                                                                         'in_discards': '19769',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '4511544',
                                                                                         'in_octets': '16092233535294',
                                                                                         'in_ucast_pkts': '78321228431',
                                                                                         'links': [       {       'in_nucast_pkts': '9',
                                                                                                                  'in_octets': '3130247958',
                                                                                                                  'in_ucast_pkts': '13997274',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673600',
                                                                                                                  'out_octets': '95631131816',
                                                                                                                  'out_ucast_pkts': '74630683',
                                                                                                                  'poller_hash': 'ODcyNDFCcGVlcmludGZwb24gMzE='},
                                                                                                          {       'in_nucast_pkts': '32700',
                                                                                                                  'in_octets': '44238542725',
                                                                                                                  'in_ucast_pkts': '200851210',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673523',
                                                                                                                  'out_octets': '961084436846',
                                                                                                                  'out_ucast_pkts': '694649423',
                                                                                                                  'poller_hash': 'QjUxMEUycGVlcmludGZwb24gMzY='},
                                                                                                          {       'in_nucast_pkts': '4582829',
                                                                                                                  'in_octets': '23278875911',
                                                                                                                  'in_ucast_pkts': '211636910',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1102071021',
                                                                                                                  'out_octets': '2756406054617',
                                                                                                                  'out_ucast_pkts': '966962103',
                                                                                                                  'poller_hash': 'MzIxMDMzcGVlcmludGZwb24gNDQ='},
                                                                                                          {       'in_nucast_pkts': '302832',
                                                                                                                  'in_octets': '589248927178',
                                                                                                                  'in_ucast_pkts': '1452178931',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9764930',
                                                                                                                  'out_octets': '4731271191205',
                                                                                                                  'out_ucast_pkts': '3505674123',
                                                                                                                  'poller_hash': 'QTlDNzg2cGVlcmludGZwb24gODU='},
                                                                                                          {       'in_nucast_pkts': '4034',
                                                                                                                  'in_octets': '60024927281',
                                                                                                                  'in_ucast_pkts': '501197499',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1235733',
                                                                                                                  'out_octets': '1918185642062',
                                                                                                                  'out_ucast_pkts': '5642115066',
                                                                                                                  'poller_hash': 'M0NGNEFwZWVyaW50ZnBvbiAxMjE='},
                                                                                                          {       'in_nucast_pkts': '17173',
                                                                                                                  'in_octets': '393452293429',
                                                                                                                  'in_ucast_pkts': '3031418270',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1234359',
                                                                                                                  'out_octets': '10742813464803',
                                                                                                                  'out_ucast_pkts': '11895659880',
                                                                                                                  'poller_hash': 'NDE1QjBwZWVyaW50ZnBvbiAxMjI='},
                                                                                                          {       'in_nucast_pkts': '6898',
                                                                                                                  'in_octets': '37928818786',
                                                                                                                  'in_ucast_pkts': '96556430',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1216982',
                                                                                                                  'out_octets': '565803381794',
                                                                                                                  'out_ucast_pkts': '448561907',
                                                                                                                  'poller_hash': 'NzIyMDY1cGVlcmludGZwb24gMTI0'},
                                                                                                          {       'in_nucast_pkts': '132329',
                                                                                                                  'in_octets': '97902937015',
                                                                                                                  'in_ucast_pkts': '488462179',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1236306',
                                                                                                                  'out_octets': '2698138150809',
                                                                                                                  'out_ucast_pkts': '2017814948',
                                                                                                                  'poller_hash': 'NEUzNkE4cGVlcmludGZwb24gMTI2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MkU5MTRBcGVlcmludGZwb24gMTM1'},
                                                                                                          {       'in_nucast_pkts': '2591675',
                                                                                                                  'in_octets': '35497110336',
                                                                                                                  'in_ucast_pkts': '126566598',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1518081571',
                                                                                                                  'out_octets': '2641973795528',
                                                                                                                  'out_ucast_pkts': '664662747',
                                                                                                                  'poller_hash': 'ODcyNTM1cGVlcmludGZwb24gMTM2'},
                                                                                                          {       'in_nucast_pkts': '1483',
                                                                                                                  'in_octets': '1862945454',
                                                                                                                  'in_ucast_pkts': '7082194',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '375105',
                                                                                                                  'out_octets': '656594834',
                                                                                                                  'out_ucast_pkts': '4852724',
                                                                                                                  'poller_hash': 'MTMwMDlBcGVlcmludGZwb24gMTM4'},
                                                                                                          {       'in_nucast_pkts': '17',
                                                                                                                  'in_octets': '13412736789',
                                                                                                                  'in_ucast_pkts': '160480543',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949574',
                                                                                                                  'out_octets': '398587280228',
                                                                                                                  'out_ucast_pkts': '272025121',
                                                                                                                  'poller_hash': 'RjIzQXBlZXJpbnRmcG9uIDEzOQ=='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'M0NGMzNwZWVyaW50ZnBvbiAxNDA='},
                                                                                                          {       'in_nucast_pkts': '124963',
                                                                                                                  'in_octets': '579272063360',
                                                                                                                  'in_ucast_pkts': '1515958637',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1236323',
                                                                                                                  'out_octets': '7851102536217',
                                                                                                                  'out_ucast_pkts': '5953723692',
                                                                                                                  'poller_hash': 'MzI5NjQycGVlcmludGZwb24gMTQy'},
                                                                                                          {       'in_nucast_pkts': '348935',
                                                                                                                  'in_octets': '167098174428',
                                                                                                                  'in_ucast_pkts': '4983569540',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1235724',
                                                                                                                  'out_octets': '3356797193266',
                                                                                                                  'out_ucast_pkts': '6840497004',
                                                                                                                  'poller_hash': 'NDE4QUNwZWVyaW50ZnBvbiAxNDM='},
                                                                                                          {       'in_nucast_pkts': '18209',
                                                                                                                  'in_octets': '95041970763',
                                                                                                                  'in_ucast_pkts': '663440513',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1235726',
                                                                                                                  'out_octets': '3447106148201',
                                                                                                                  'out_ucast_pkts': '6724711428',
                                                                                                                  'poller_hash': 'M0NDMDhwZWVyaW50ZnBvbiAxNDQ='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'RjEwNnBlZXJpbnRmcG9uIDE0NQ=='},
                                                                                                          {       'in_nucast_pkts': '92089',
                                                                                                                  'in_octets': '6541032249',
                                                                                                                  'in_ucast_pkts': '30225735',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949537',
                                                                                                                  'out_octets': '205144811662',
                                                                                                                  'out_ucast_pkts': '151213142',
                                                                                                                  'poller_hash': 'QzU4NkJwZWVyaW50ZnBvbiAxNDY='},
                                                                                                          {       'in_nucast_pkts': '85720',
                                                                                                                  'in_octets': '279590126302',
                                                                                                                  'in_ucast_pkts': '635463886',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1237345',
                                                                                                                  'out_octets': '3431245446760',
                                                                                                                  'out_ucast_pkts': '6832115370',
                                                                                                                  'poller_hash': 'M0NGNEVwZWVyaW50ZnBvbiAxNDg='},
                                                                                                          {       'in_nucast_pkts': '9679',
                                                                                                                  'in_octets': '51871190947',
                                                                                                                  'in_ucast_pkts': '331878309',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1235661',
                                                                                                                  'out_octets': '2560508582238',
                                                                                                                  'out_ucast_pkts': '1786403619',
                                                                                                                  'poller_hash': 'MTk5QTI1cGVlcmludGZwb24gMTUw'},
                                                                                                          {       'in_nucast_pkts': '10682650',
                                                                                                                  'in_octets': '47557033442',
                                                                                                                  'in_ucast_pkts': '135011692',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11948472384',
                                                                                                                  'out_octets': '16071157190313',
                                                                                                                  'out_ucast_pkts': '498173635',
                                                                                                                  'poller_hash': 'MTk5QTM5cGVlcmludGZwb24gMTUx'},
                                                                                                          {       'in_nucast_pkts': '27766',
                                                                                                                  'in_octets': '1377421053',
                                                                                                                  'in_ucast_pkts': '3607647',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10696602',
                                                                                                                  'out_octets': '9915140131',
                                                                                                                  'out_ucast_pkts': '11471032',
                                                                                                                  'poller_hash': 'QzgzMjEycGVlcmludGZwb24gMTUz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTM1MzhwZWVyaW50ZnBvbiAxNTQ='},
                                                                                                          {       'in_nucast_pkts': '21787031',
                                                                                                                  'in_octets': '547455672466',
                                                                                                                  'in_ucast_pkts': '896064235',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '30558122105',
                                                                                                                  'out_octets': '44858350559641',
                                                                                                                  'out_ucast_pkts': '3092294120',
                                                                                                                  'poller_hash': 'NzFEODBBcGVlcmludGZwb24gMTU1'},
                                                                                                          {       'in_nucast_pkts': '2637003',
                                                                                                                  'in_octets': '31222201734',
                                                                                                                  'in_ucast_pkts': '119798590',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2177698205',
                                                                                                                  'out_octets': '3282503288592',
                                                                                                                  'out_ucast_pkts': '307825424',
                                                                                                                  'poller_hash': 'QjBBMkEwcGVlcmludGZwb24gMTUwODcy'},
                                                                                                          {       'in_nucast_pkts': '17810847',
                                                                                                                  'in_octets': '224789897128',
                                                                                                                  'in_ucast_pkts': '1267148974',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '16396007272',
                                                                                                                  'out_octets': '27175970672576',
                                                                                                                  'out_ucast_pkts': '3771979108',
                                                                                                                  'poller_hash': 'QkYyMUU4cGVlcmludGZwb24gMTY0MDYz'},
                                                                                                          {       'in_nucast_pkts': '259',
                                                                                                                  'in_octets': '12573168922',
                                                                                                                  'in_ucast_pkts': '38318660',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1780730',
                                                                                                                  'out_octets': '147641486851',
                                                                                                                  'out_ucast_pkts': '112184391',
                                                                                                                  'poller_hash': 'QzgzQkJCcGVlcmludGZwb24gMTcyMzA5'},
                                                                                                          {       'in_nucast_pkts': '4888364',
                                                                                                                  'in_octets': '28310532327',
                                                                                                                  'in_ucast_pkts': '202806041',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7214247914',
                                                                                                                  'out_octets': '9999129504079',
                                                                                                                  'out_ucast_pkts': '447276634',
                                                                                                                  'poller_hash': 'QzgxNUYxcGVlcmludGZwb24gMjA3MzUy'},
                                                                                                          {       'in_nucast_pkts': '8',
                                                                                                                  'in_octets': '74709421743',
                                                                                                                  'in_ucast_pkts': '292699593',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673866',
                                                                                                                  'out_octets': '1632541262477',
                                                                                                                  'out_ucast_pkts': '1168704319',
                                                                                                                  'poller_hash': 'MTFCMjJCRHBlZXJpbnRmcG9uIDIxMjA4OA=='},
                                                                                                          {       'in_nucast_pkts': '8201',
                                                                                                                  'in_octets': '38746677527',
                                                                                                                  'in_ucast_pkts': '338766877',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '74522',
                                                                                                                  'out_octets': '1529502003628',
                                                                                                                  'out_ucast_pkts': '1067262845',
                                                                                                                  'poller_hash': 'NDcxQzYzcGVlcmludGZwb24gMjI0Njc5'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '468166940106',
                                                                                         'out_octets': '989238909088859',
                                                                                         'out_ucast_pkts': '253883223175',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzM=',
                                                                                         'pons': [       {       'id': '1/3',
                                                                                                                 'links': [       {       'connected_time': '3448119',
                                                                                                                                          'fiber_length': 1137,
                                                                                                                                          'poller_hash': 'ODcyNDFCcGVlcnBvbnBvbiAzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '3448270',
                                                                                                                                          'fiber_length': 1009,
                                                                                                                                          'poller_hash': 'QjUxMEUycGVlcnBvbnBvbiAzNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '6230802',
                                                                                                                                          'fiber_length': 982,
                                                                                                                                          'poller_hash': 'MzIxMDMzcGVlcnBvbnBvbiA0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18919156',
                                                                                                                                          'fiber_length': 1125,
                                                                                                                                          'poller_hash': 'QTlDNzg2cGVlcnBvbnBvbiA4NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18903745',
                                                                                                                                          'fiber_length': 1090,
                                                                                                                                          'poller_hash': 'M0NGNEFwZWVycG9ucG9uIDEyMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18903727',
                                                                                                                                          'fiber_length': 1070,
                                                                                                                                          'poller_hash': 'NDE1QjBwZWVycG9ucG9uIDEyMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18904031',
                                                                                                                                          'fiber_length': 1128,
                                                                                                                                          'poller_hash': 'NzIyMDY1cGVlcnBvbnBvbiAxMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18903937',
                                                                                                                                          'fiber_length': 1156,
                                                                                                                                          'poller_hash': 'NEUzNkE4cGVlcnBvbnBvbiAxMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18903944',
                                                                                                                                          'fiber_length': 956,
                                                                                                                                          'poller_hash': 'MkU5MTRBcGVlcnBvbnBvbiAxMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '14515227',
                                                                                                                                          'fiber_length': 1017,
                                                                                                                                          'poller_hash': 'ODcyNTM1cGVlcnBvbnBvbiAxMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '1314956',
                                                                                                                                          'fiber_length': 958,
                                                                                                                                          'poller_hash': 'MTMwMDlBcGVlcnBvbnBvbiAxMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '3448176',
                                                                                                                                          'fiber_length': 825,
                                                                                                                                          'poller_hash': 'RjIzQXBlZXJwb25wb24gMTM5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'poller_hash': 'M0NGMzNwZWVycG9ucG9uIDE0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18904099',
                                                                                                                                          'fiber_length': 837,
                                                                                                                                          'poller_hash': 'MzI5NjQycGVlcnBvbnBvbiAxNDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18903897',
                                                                                                                                          'fiber_length': 755,
                                                                                                                                          'poller_hash': 'NDE4QUNwZWVycG9ucG9uIDE0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18903838',
                                                                                                                                          'fiber_length': 708,
                                                                                                                                          'poller_hash': 'M0NDMDhwZWVycG9ucG9uIDE0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'poller_hash': 'RjEwNnBlZXJwb25wb24gMTQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '3448138',
                                                                                                                                          'fiber_length': 726,
                                                                                                                                          'poller_hash': 'QzU4NkJwZWVycG9ucG9uIDE0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18903827',
                                                                                                                                          'fiber_length': 571,
                                                                                                                                          'poller_hash': 'M0NGNEVwZWVycG9ucG9uIDE0OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18904014',
                                                                                                                                          'fiber_length': 614,
                                                                                                                                          'poller_hash': 'MTk5QTI1cGVlcnBvbnBvbiAxNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18903962',
                                                                                                                                          'fiber_length': 751,
                                                                                                                                          'poller_hash': 'MTk5QTM5cGVlcnBvbnBvbiAxNTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18918828',
                                                                                                                                          'fiber_length': 742,
                                                                                                                                          'poller_hash': 'QzgzMjEycGVlcnBvbnBvbiAxNTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '3448063',
                                                                                                                                          'fiber_length': 608,
                                                                                                                                          'poller_hash': 'MTM1MzhwZWVycG9ucG9uIDE1NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18903914',
                                                                                                                                          'fiber_length': 672,
                                                                                                                                          'poller_hash': 'NzFEODBBcGVlcnBvbnBvbiAxNTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '3448357',
                                                                                                                                          'fiber_length': 1025,
                                                                                                                                          'poller_hash': 'QjBBMkEwcGVlcnBvbnBvbiAxNTA4NzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18904186',
                                                                                                                                          'fiber_length': 682,
                                                                                                                                          'poller_hash': 'QkYyMUU4cGVlcnBvbnBvbiAxNjQwNjM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '3448334',
                                                                                                                                          'fiber_length': 1205,
                                                                                                                                          'poller_hash': 'QzgzQkJCcGVlcnBvbnBvbiAxNzIzMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '18919346',
                                                                                                                                          'fiber_length': 930,
                                                                                                                                          'poller_hash': 'QzgxNUYxcGVlcnBvbnBvbiAyMDczNTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '3448382',
                                                                                                                                          'fiber_length': 856,
                                                                                                                                          'poller_hash': 'MTFCMjJCRHBlZXJwb25wb24gMjEyMDg4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777},
                                                                                                                                  {       'connected_time': '8922539',
                                                                                                                                          'fiber_length': 657,
                                                                                                                                          'poller_hash': 'NDcxQzYzcGVlcnBvbnBvbiAyMjQ2Nzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.777}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/3',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/4',
                                                                                         'in_discards': '175608',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1811855',
                                                                                         'in_octets': '12775056001546',
                                                                                         'in_ucast_pkts': '51654548146',
                                                                                         'links': [       {       'in_nucast_pkts': '14381578',
                                                                                                                  'in_octets': '4550794976',
                                                                                                                  'in_ucast_pkts': '17081406',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '33455877146',
                                                                                                                  'out_octets': '44229120466897',
                                                                                                                  'out_ucast_pkts': '12635567',
                                                                                                                  'poller_hash': 'MzIyM0Y5cGVlcmludGZwb24gOQ=='},
                                                                                                          {       'in_nucast_pkts': '69',
                                                                                                                  'in_octets': '32421156052',
                                                                                                                  'in_ucast_pkts': '255838594',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '23520',
                                                                                                                  'out_octets': '829912386716',
                                                                                                                  'out_ucast_pkts': '586002533',
                                                                                                                  'poller_hash': 'M0FERDZFcGVlcmludGZwb24gMTc='},
                                                                                                          {       'in_nucast_pkts': '18320',
                                                                                                                  'in_octets': '686011693856',
                                                                                                                  'in_ucast_pkts': '2219593340',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '158483',
                                                                                                                  'out_octets': '6653131693954',
                                                                                                                  'out_ucast_pkts': '4905925207',
                                                                                                                  'poller_hash': 'NEQ0MUY0cGVlcmludGZwb24gMjk='},
                                                                                                          {       'in_nucast_pkts': '15975084',
                                                                                                                  'in_octets': '566760962269',
                                                                                                                  'in_ucast_pkts': '2280000154',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8912163224',
                                                                                                                  'out_octets': '21233789233487',
                                                                                                                  'out_ucast_pkts': '6861722500',
                                                                                                                  'poller_hash': 'Mzk2MUE5cGVlcmludGZwb24gNTA='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MUM1RENGcGVlcmludGZwb24gOTM='},
                                                                                                          {       'in_nucast_pkts': '1451329',
                                                                                                                  'in_octets': '3004105784',
                                                                                                                  'in_ucast_pkts': '9745761',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1906064176',
                                                                                                                  'out_octets': '2525420685201',
                                                                                                                  'out_ucast_pkts': '31593717',
                                                                                                                  'poller_hash': 'QzU4NTBwZWVyaW50ZnBvbiAxNTc='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODcyNDY2cGVlcmludGZwb24gMTU4'},
                                                                                                          {       'in_nucast_pkts': '15625704',
                                                                                                                  'in_octets': '261905366375',
                                                                                                                  'in_ucast_pkts': '1241606166',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9130207519',
                                                                                                                  'out_octets': '16147586430784',
                                                                                                                  'out_ucast_pkts': '3249904920',
                                                                                                                  'poller_hash': 'NTVGQkQ2cGVlcmludGZwb24gMTU5'},
                                                                                                          {       'in_nucast_pkts': '7738',
                                                                                                                  'in_octets': '60138987826',
                                                                                                                  'in_ucast_pkts': '565162260',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1239517',
                                                                                                                  'out_octets': '2472770592646',
                                                                                                                  'out_ucast_pkts': '1036820674778',
                                                                                                                  'poller_hash': 'MTMwM0RwZWVyaW50ZnBvbiAxNjA='},
                                                                                                          {       'in_nucast_pkts': '3237759',
                                                                                                                  'in_octets': '44161357054',
                                                                                                                  'in_ucast_pkts': '140751721',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1002361163',
                                                                                                                  'out_octets': '1562876643796',
                                                                                                                  'out_ucast_pkts': '269663099',
                                                                                                                  'poller_hash': 'MTk5QTFCcGVlcmludGZwb24gMTYx'},
                                                                                                          {       'in_nucast_pkts': '141829',
                                                                                                                  'in_octets': '101990646692',
                                                                                                                  'in_ucast_pkts': '554984666',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1236289',
                                                                                                                  'out_octets': '3035046083057',
                                                                                                                  'out_ucast_pkts': '2150826357',
                                                                                                                  'poller_hash': 'MjQ4QUU2cGVlcmludGZwb24gMTYy'},
                                                                                                          {       'in_nucast_pkts': '3931623',
                                                                                                                  'in_octets': '238189367531',
                                                                                                                  'in_ucast_pkts': '1256295432',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2471316',
                                                                                                                  'out_octets': '6117437840901',
                                                                                                                  'out_ucast_pkts': '4484519826',
                                                                                                                  'poller_hash': 'MTYxMDIxcGVlcmludGZwb24gMTYz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MjQ4QUQ3cGVlcmludGZwb24gMTY0'},
                                                                                                          {       'in_nucast_pkts': '61608',
                                                                                                                  'in_octets': '90342423578',
                                                                                                                  'in_ucast_pkts': '363510233',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1235650',
                                                                                                                  'out_octets': '772077874715',
                                                                                                                  'out_ucast_pkts': '700319079',
                                                                                                                  'poller_hash': 'Mzc4OEMxcGVlcmludGZwb24gMTY1'},
                                                                                                          {       'in_nucast_pkts': '6029',
                                                                                                                  'in_octets': '23179756935',
                                                                                                                  'in_ucast_pkts': '102626344',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949549',
                                                                                                                  'out_octets': '547507507699',
                                                                                                                  'out_ucast_pkts': '395763298',
                                                                                                                  'poller_hash': 'MkZDQ0UxcGVlcmludGZwb24gMTY2'},
                                                                                                          {       'in_nucast_pkts': '4946621',
                                                                                                                  'in_octets': '99959720921',
                                                                                                                  'in_ucast_pkts': '481506927',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12370066426',
                                                                                                                  'out_octets': '19503857461548',
                                                                                                                  'out_ucast_pkts': '2209267933',
                                                                                                                  'poller_hash': 'QzgzQkFFcGVlcmludGZwb24gMTY2MTIx'},
                                                                                                          {       'in_nucast_pkts': '213032',
                                                                                                                  'in_octets': '179745763401',
                                                                                                                  'in_ucast_pkts': '209964699',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1814935',
                                                                                                                  'out_octets': '14764103976',
                                                                                                                  'out_ucast_pkts': '171663669',
                                                                                                                  'poller_hash': 'QzgxRDZGcGVlcmludGZwb24gMjExNjUz'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '329368485221',
                                                                                         'out_octets': '646059500702309',
                                                                                         'out_ucast_pkts': '146762947022',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzQ=',
                                                                                         'pons': [       {       'id': '1/4',
                                                                                                                 'links': [       {       'connected_time': '18919094',
                                                                                                                                          'fiber_length': 662,
                                                                                                                                          'poller_hash': 'MzIyM0Y5cGVlcnBvbnBvbiA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '2814660',
                                                                                                                                          'fiber_length': 518,
                                                                                                                                          'poller_hash': 'M0FERDZFcGVlcnBvbnBvbiAxNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '18904117',
                                                                                                                                          'fiber_length': 545,
                                                                                                                                          'poller_hash': 'NEQ0MUY0cGVlcnBvbnBvbiAyOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '18904104',
                                                                                                                                          'fiber_length': 536,
                                                                                                                                          'poller_hash': 'Mzk2MUE5cGVlcnBvbnBvbiA1MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '18903929',
                                                                                                                                          'fiber_length': 166,
                                                                                                                                          'poller_hash': 'MUM1RENGcGVlcnBvbnBvbiA5Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '3448169',
                                                                                                                                          'fiber_length': 592,
                                                                                                                                          'poller_hash': 'QzU4NTBwZWVycG9ucG9uIDE1Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'poller_hash': 'ODcyNDY2cGVlcnBvbnBvbiAxNTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '18904027',
                                                                                                                                          'fiber_length': 484,
                                                                                                                                          'poller_hash': 'NTVGQkQ2cGVlcnBvbnBvbiAxNTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '18903453',
                                                                                                                                          'fiber_length': 358,
                                                                                                                                          'poller_hash': 'MTMwM0RwZWVycG9ucG9uIDE2MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '3448218',
                                                                                                                                          'fiber_length': 539,
                                                                                                                                          'poller_hash': 'MTk5QTFCcGVlcnBvbnBvbiAxNjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '18904088',
                                                                                                                                          'fiber_length': 573,
                                                                                                                                          'poller_hash': 'MjQ4QUU2cGVlcnBvbnBvbiAxNjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '18904135',
                                                                                                                                          'fiber_length': 514,
                                                                                                                                          'poller_hash': 'MTYxMDIxcGVlcnBvbnBvbiAxNjM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '3448216',
                                                                                                                                          'fiber_length': 582,
                                                                                                                                          'poller_hash': 'MjQ4QUQ3cGVlcnBvbnBvbiAxNjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '18903994',
                                                                                                                                          'fiber_length': 612,
                                                                                                                                          'poller_hash': 'Mzc4OEMxcGVlcnBvbnBvbiAxNjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '3448199',
                                                                                                                                          'fiber_length': 648,
                                                                                                                                          'poller_hash': 'MkZDQ0UxcGVlcnBvbnBvbiAxNjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '18919407',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'QzgzQkFFcGVlcnBvbnBvbiAxNjYxMjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '3448392',
                                                                                                                                          'fiber_length': 1018,
                                                                                                                                          'poller_hash': 'QzgxRDZGcGVlcnBvbnBvbiAyMTE2NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/4',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/5',
                                                                                         'in_discards': '9321',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '54712088',
                                                                                         'in_octets': '34376537665936',
                                                                                         'in_ucast_pkts': '107343467569',
                                                                                         'links': [       {       'in_nucast_pkts': '73982',
                                                                                                                  'in_octets': '6651829377836',
                                                                                                                  'in_ucast_pkts': '8691785686',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5774',
                                                                                                                  'out_octets': '20340299710792',
                                                                                                                  'out_ucast_pkts': '17251675215',
                                                                                                                  'poller_hash': 'NEQ0MjUwcGVlcmludGZwb24gNg=='},
                                                                                                          {       'in_nucast_pkts': '13',
                                                                                                                  'in_octets': '37176522126',
                                                                                                                  'in_ucast_pkts': '44598281',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '286373',
                                                                                                                  'out_octets': '86571986474',
                                                                                                                  'out_ucast_pkts': '71712128',
                                                                                                                  'poller_hash': 'NDNDMjFBcGVlcmludGZwb24gMTM='},
                                                                                                          {       'in_nucast_pkts': '2474',
                                                                                                                  'in_octets': '97947994913',
                                                                                                                  'in_ucast_pkts': '463323141',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '157625',
                                                                                                                  'out_octets': '1326040764265',
                                                                                                                  'out_ucast_pkts': '981577576',
                                                                                                                  'poller_hash': 'MkZFQTAzcGVlcmludGZwb24gMjQ='},
                                                                                                          {       'in_nucast_pkts': '3545096',
                                                                                                                  'in_octets': '13872906944',
                                                                                                                  'in_ucast_pkts': '49958076',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1787067043',
                                                                                                                  'out_octets': '2474368426426',
                                                                                                                  'out_ucast_pkts': '125045385',
                                                                                                                  'poller_hash': 'NkFDMkM3cGVlcmludGZwb24gNDA='},
                                                                                                          {       'in_nucast_pkts': '313',
                                                                                                                  'in_octets': '8721897209',
                                                                                                                  'in_ucast_pkts': '37141859',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '28540',
                                                                                                                  'out_octets': '261180871373',
                                                                                                                  'out_ucast_pkts': '196534575',
                                                                                                                  'poller_hash': 'NTVERkIxcGVlcmludGZwb24gOTk='},
                                                                                                          {       'in_nucast_pkts': '20010280',
                                                                                                                  'in_octets': '1666394302497',
                                                                                                                  'in_ucast_pkts': '3149343950',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '36650766576',
                                                                                                                  'out_octets': '54348714245262',
                                                                                                                  'out_ucast_pkts': '5376324684',
                                                                                                                  'poller_hash': 'NzZFOTkwcGVlcmludGZwb24gMTgy'},
                                                                                                          {       'in_nucast_pkts': '106',
                                                                                                                  'in_octets': '6768617461',
                                                                                                                  'in_ucast_pkts': '30077759',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '948887',
                                                                                                                  'out_octets': '41928614384',
                                                                                                                  'out_ucast_pkts': '46840414',
                                                                                                                  'poller_hash': 'MTUzQzNwZWVyaW50ZnBvbiAxODM='},
                                                                                                          {       'in_nucast_pkts': '4086161',
                                                                                                                  'in_octets': '124800971563',
                                                                                                                  'in_ucast_pkts': '1632961581',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4083000',
                                                                                                                  'out_octets': '144395290656',
                                                                                                                  'out_ucast_pkts': '2093156039',
                                                                                                                  'poller_hash': 'N0ZGNXBlZXJpbnRmcG9uIDE4NQ=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MzI5NjM5cGVlcmludGZwb24gMTg3'},
                                                                                                          {       'in_nucast_pkts': '15333',
                                                                                                                  'in_octets': '763336593474',
                                                                                                                  'in_ucast_pkts': '4289795387',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1233555',
                                                                                                                  'out_octets': '12453189682242',
                                                                                                                  'out_ucast_pkts': '9687063592',
                                                                                                                  'poller_hash': 'MTk5QTAwcGVlcmludGZwb24gMTg4'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'NDE4QjNwZWVyaW50ZnBvbiAxODk='},
                                                                                                          {       'in_nucast_pkts': '14279',
                                                                                                                  'in_octets': '33326238426',
                                                                                                                  'in_ucast_pkts': '117951287',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1045117',
                                                                                                                  'out_octets': '383634403448',
                                                                                                                  'out_ucast_pkts': '4591471534',
                                                                                                                  'poller_hash': 'M0NGQTBwZWVyaW50ZnBvbiAxOTA='},
                                                                                                          {       'in_nucast_pkts': '87340',
                                                                                                                  'in_octets': '152402070535',
                                                                                                                  'in_ucast_pkts': '461274355',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '157627',
                                                                                                                  'out_octets': '1839434478064',
                                                                                                                  'out_ucast_pkts': '1415507141',
                                                                                                                  'poller_hash': 'NDcxNDZFcGVlcmludGZwb24gMTkx'},
                                                                                                          {       'in_nucast_pkts': '17472243',
                                                                                                                  'in_octets': '92458417442',
                                                                                                                  'in_ucast_pkts': '465039323',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13403814370',
                                                                                                                  'out_octets': '19267254742902',
                                                                                                                  'out_ucast_pkts': '31312453869',
                                                                                                                  'poller_hash': 'NDE4QjVwZWVyaW50ZnBvbiAxOTI='},
                                                                                                          {       'in_nucast_pkts': '7323212',
                                                                                                                  'in_octets': '5210847649',
                                                                                                                  'in_ucast_pkts': '8614718567',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14251970481',
                                                                                                                  'out_octets': '19013780537424',
                                                                                                                  'out_ucast_pkts': '42987233812',
                                                                                                                  'poller_hash': 'NDE1NDlwZWVyaW50ZnBvbiAxOTQ='},
                                                                                                          {       'in_nucast_pkts': '43',
                                                                                                                  'in_octets': '39495780740',
                                                                                                                  'in_ucast_pkts': '131781497',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1089465',
                                                                                                                  'out_octets': '143020449883',
                                                                                                                  'out_ucast_pkts': '148311687',
                                                                                                                  'poller_hash': 'NEVCMTdEcGVlcmludGZwb24gMTk1'},
                                                                                                          {       'in_nucast_pkts': '18134807',
                                                                                                                  'in_octets': '29688610669',
                                                                                                                  'in_ucast_pkts': '112515558',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26918567604',
                                                                                                                  'out_octets': '36716791774284',
                                                                                                                  'out_ucast_pkts': '359470925',
                                                                                                                  'poller_hash': 'QkYyNEI0cGVlcmludGZwb24gMTk2'},
                                                                                                          {       'in_nucast_pkts': '3075',
                                                                                                                  'in_octets': '306223132075',
                                                                                                                  'in_ucast_pkts': '1050504097',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1235721',
                                                                                                                  'out_octets': '4310130760165',
                                                                                                                  'out_ucast_pkts': '3327705251',
                                                                                                                  'poller_hash': 'MkYzQUQ5cGVlcmludGZwb24gMTk3'},
                                                                                                          {       'in_nucast_pkts': '15625853',
                                                                                                                  'in_octets': '179408790720',
                                                                                                                  'in_ucast_pkts': '690083987',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13456648742',
                                                                                                                  'out_octets': '20717870674344',
                                                                                                                  'out_ucast_pkts': '2088032437',
                                                                                                                  'poller_hash': 'NzU3QkNwZWVyaW50ZnBvbiAxOTg='},
                                                                                                          {       'in_nucast_pkts': '8336',
                                                                                                                  'in_octets': '12015228328',
                                                                                                                  'in_ucast_pkts': '32237608',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10687159',
                                                                                                                  'out_octets': '95029829080',
                                                                                                                  'out_ucast_pkts': '78684364',
                                                                                                                  'poller_hash': 'QzgxMUUwcGVlcmludGZwb24gMTU3NzUz'},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '18657816873',
                                                                                                                  'in_ucast_pkts': '70249904',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673459',
                                                                                                                  'out_octets': '142485066823',
                                                                                                                  'out_ucast_pkts': '152965424',
                                                                                                                  'poller_hash': 'QzgzQzBDcGVlcmludGZwb24gMTc0NDY0'},
                                                                                                          {       'in_nucast_pkts': '105',
                                                                                                                  'in_octets': '21783595314',
                                                                                                                  'in_ucast_pkts': '117024341',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1780662',
                                                                                                                  'out_octets': '960102826591',
                                                                                                                  'out_ucast_pkts': '686058819',
                                                                                                                  'poller_hash': 'QzgxRTMwcGVlcmludGZwb24gMjA2NDkw'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '640116620556',
                                                                                         'out_octets': '1124098030092687',
                                                                                         'out_ucast_pkts': '229225223621',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzU=',
                                                                                         'pons': [       {       'id': '1/5',
                                                                                                                 'links': [       {       'connected_time': '18904237',
                                                                                                                                          'fiber_length': 1529,
                                                                                                                                          'poller_hash': 'NEQ0MjUwcGVlcnBvbnBvbiA2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '990935',
                                                                                                                                          'fiber_length': 1307,
                                                                                                                                          'poller_hash': 'NDNDMjFBcGVlcnBvbnBvbiAxMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '18904356',
                                                                                                                                          'fiber_length': 670,
                                                                                                                                          'poller_hash': 'MkZFQTAzcGVlcnBvbnBvbiAyNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3448100',
                                                                                                                                          'fiber_length': 691,
                                                                                                                                          'poller_hash': 'NkFDMkM3cGVlcnBvbnBvbiA0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3448161',
                                                                                                                                          'fiber_length': 614,
                                                                                                                                          'poller_hash': 'NTVERkIxcGVlcnBvbnBvbiA5OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '18904035',
                                                                                                                                          'fiber_length': 1441,
                                                                                                                                          'poller_hash': 'NzZFOTkwcGVlcnBvbnBvbiAxODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3448083',
                                                                                                                                          'fiber_length': 881,
                                                                                                                                          'poller_hash': 'MTUzQzNwZWVycG9ucG9uIDE4Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '18903138',
                                                                                                                                          'fiber_length': 834,
                                                                                                                                          'poller_hash': 'N0ZGNXBlZXJwb25wb24gMTg1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '2704464',
                                                                                                                                          'fiber_length': 938,
                                                                                                                                          'poller_hash': 'MzI5NjM5cGVlcnBvbnBvbiAxODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '18904026',
                                                                                                                                          'fiber_length': 953,
                                                                                                                                          'poller_hash': 'MTk5QTAwcGVlcnBvbnBvbiAxODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '964664',
                                                                                                                                          'fiber_length': 539,
                                                                                                                                          'poller_hash': 'NDE4QjNwZWVycG9ucG9uIDE4OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '6058757',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'M0NGQTBwZWVycG9ucG9uIDE5MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '18904362',
                                                                                                                                          'fiber_length': 578,
                                                                                                                                          'poller_hash': 'NDcxNDZFcGVlcnBvbnBvbiAxOTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '18903914',
                                                                                                                                          'fiber_length': 511,
                                                                                                                                          'poller_hash': 'NDE4QjVwZWVycG9ucG9uIDE5Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '18903991',
                                                                                                                                          'fiber_length': 705,
                                                                                                                                          'poller_hash': 'NDE1NDlwZWVycG9ucG9uIDE5NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '9047632',
                                                                                                                                          'fiber_length': 761,
                                                                                                                                          'poller_hash': 'NEVCMTdEcGVlcnBvbnBvbiAxOTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14479672',
                                                                                                                                          'fiber_length': 1360,
                                                                                                                                          'poller_hash': 'QkYyNEI0cGVlcnBvbnBvbiAxOTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '18903841',
                                                                                                                                          'fiber_length': 1317,
                                                                                                                                          'poller_hash': 'MkYzQUQ5cGVlcnBvbnBvbiAxOTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '18904462',
                                                                                                                                          'fiber_length': 1356,
                                                                                                                                          'poller_hash': 'NzU3QkNwZWVycG9ucG9uIDE5OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '18919348',
                                                                                                                                          'fiber_length': 1022,
                                                                                                                                          'poller_hash': 'QzgxMUUwcGVlcnBvbnBvbiAxNTc3NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3448327',
                                                                                                                                          'fiber_length': 971,
                                                                                                                                          'poller_hash': 'QzgzQzBDcGVlcnBvbnBvbiAxNzQ0NjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '3448368',
                                                                                                                                          'fiber_length': 896,
                                                                                                                                          'poller_hash': 'QzgxRTMwcGVlcnBvbnBvbiAyMDY0OTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/5',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/6',
                                                                                         'in_discards': '69499',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23191440',
                                                                                         'in_octets': '22907559863740',
                                                                                         'in_ucast_pkts': '105141962550',
                                                                                         'links': [       {       'in_nucast_pkts': '27821536',
                                                                                                                  'in_octets': '555256431925',
                                                                                                                  'in_ucast_pkts': '1324573654',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '50824552178',
                                                                                                                  'out_octets': '71902751138927',
                                                                                                                  'out_ucast_pkts': '3197805848',
                                                                                                                  'poller_hash': 'MzIxMUIzcGVlcmludGZwb24gNA=='},
                                                                                                          {       'in_nucast_pkts': '12742',
                                                                                                                  'in_octets': '38047552287',
                                                                                                                  'in_ucast_pkts': '274340395',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2893506',
                                                                                                                  'out_octets': '907721271447',
                                                                                                                  'out_ucast_pkts': '658693034',
                                                                                                                  'poller_hash': 'NDJCOUQzcGVlcmludGZwb24gMTA='},
                                                                                                          {       'in_nucast_pkts': '5341349',
                                                                                                                  'in_octets': '92891946332',
                                                                                                                  'in_ucast_pkts': '511187714',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5926754037',
                                                                                                                  'out_octets': '11830883150333',
                                                                                                                  'out_ucast_pkts': '3006493426',
                                                                                                                  'poller_hash': 'ODcyNDJBcGVlcmludGZwb24gMTU='},
                                                                                                          {       'in_nucast_pkts': '7727536',
                                                                                                                  'in_octets': '367749842167',
                                                                                                                  'in_ucast_pkts': '1344737882',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '20475567224',
                                                                                                                  'out_octets': '31575324405800',
                                                                                                                  'out_ucast_pkts': '3412713495',
                                                                                                                  'poller_hash': 'NDI4MTkxcGVlcmludGZwb24gMzU='},
                                                                                                          {       'in_nucast_pkts': '4535168',
                                                                                                                  'in_octets': '19037305942',
                                                                                                                  'in_ucast_pkts': '66433572',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6013712919',
                                                                                                                  'out_octets': '8474943269914',
                                                                                                                  'out_ucast_pkts': '280948806',
                                                                                                                  'poller_hash': 'MzIyM0QzcGVlcmludGZwb24gNDM='},
                                                                                                          {       'in_nucast_pkts': '6',
                                                                                                                  'in_octets': '24180112784',
                                                                                                                  'in_ucast_pkts': '221256751',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673676',
                                                                                                                  'out_octets': '845590323353',
                                                                                                                  'out_ucast_pkts': '583969076',
                                                                                                                  'poller_hash': 'NDJEMkJCcGVlcmludGZwb24gODM='},
                                                                                                          {       'in_nucast_pkts': '5616',
                                                                                                                  'in_octets': '446179543163',
                                                                                                                  'in_ucast_pkts': '3821131815',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1235307',
                                                                                                                  'out_octets': '11945159643826',
                                                                                                                  'out_ucast_pkts': '8341834767',
                                                                                                                  'poller_hash': 'ODc0NEZwZWVyaW50ZnBvbiAxMjc='},
                                                                                                          {       'in_nucast_pkts': '4877014',
                                                                                                                  'in_octets': '9271708103',
                                                                                                                  'in_ucast_pkts': '43693433',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8500034572',
                                                                                                                  'out_octets': '11214555850457',
                                                                                                                  'out_ucast_pkts': '66182473',
                                                                                                                  'poller_hash': 'NEQxMTFGcGVlcmludGZwb24gMjAz'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'MkZDQzMycGVlcmludGZwb24gMjA0'},
                                                                                                          {       'in_nucast_pkts': '4086501',
                                                                                                                  'in_octets': '128697560182',
                                                                                                                  'in_ucast_pkts': '1300081769',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4083104',
                                                                                                                  'out_octets': '113870464851',
                                                                                                                  'out_ucast_pkts': '1646236663',
                                                                                                                  'poller_hash': 'NDE1N0VwZWVyaW50ZnBvbiAyMDY='},
                                                                                                          {       'in_nucast_pkts': '106383',
                                                                                                                  'in_octets': '164660100281',
                                                                                                                  'in_ucast_pkts': '1704460198',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1235870',
                                                                                                                  'out_octets': '7191804570004',
                                                                                                                  'out_ucast_pkts': '9163440096',
                                                                                                                  'poller_hash': 'NDE1QUJwZWVyaW50ZnBvbiAyMDc='},
                                                                                                          {       'in_nucast_pkts': '862386',
                                                                                                                  'in_octets': '175238946121',
                                                                                                                  'in_ucast_pkts': '1246783991',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '157492',
                                                                                                                  'out_octets': '6778435963734',
                                                                                                                  'out_ucast_pkts': '4689547340',
                                                                                                                  'poller_hash': 'QkYyNTA1cGVlcmludGZwb24gMjA4'},
                                                                                                          {       'in_nucast_pkts': '1140587',
                                                                                                                  'in_octets': '291870810583',
                                                                                                                  'in_ucast_pkts': '1640557549',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1245110',
                                                                                                                  'out_octets': '7576731950987',
                                                                                                                  'out_ucast_pkts': '5568990374',
                                                                                                                  'poller_hash': 'NDcwM0FGcGVlcmludGZwb24gMjA5'},
                                                                                                          {       'in_nucast_pkts': '1884090',
                                                                                                                  'in_octets': '95193473909',
                                                                                                                  'in_ucast_pkts': '418756495',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5095761392',
                                                                                                                  'out_octets': '7847820514167',
                                                                                                                  'out_ucast_pkts': '813686642',
                                                                                                                  'poller_hash': 'ODcyNDVFcGVlcmludGZwb24gMjEw'},
                                                                                                          {       'in_nucast_pkts': '400708',
                                                                                                                  'in_octets': '35855994',
                                                                                                                  'in_ucast_pkts': '88534',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '519277336',
                                                                                                                  'out_octets': '666842548358',
                                                                                                                  'out_ucast_pkts': '37077',
                                                                                                                  'poller_hash': 'Mzk1MDdBcGVlcmludGZwb24gMjEx'},
                                                                                                          {       'in_nucast_pkts': '6',
                                                                                                                  'in_octets': '25249966904',
                                                                                                                  'in_ucast_pkts': '128141064',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673728',
                                                                                                                  'out_octets': '832903945834',
                                                                                                                  'out_ucast_pkts': '594978348',
                                                                                                                  'poller_hash': 'QzgxQzNGcGVlcmludGZwb24gMjEy'},
                                                                                                          {       'in_nucast_pkts': '8695',
                                                                                                                  'in_octets': '435916051213',
                                                                                                                  'in_ucast_pkts': '1717878065',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1235739',
                                                                                                                  'out_octets': '7292349250332',
                                                                                                                  'out_ucast_pkts': '5261757985',
                                                                                                                  'poller_hash': 'MTk5QTMycGVlcmludGZwb24gMjE0'},
                                                                                                          {       'in_nucast_pkts': '19099697',
                                                                                                                  'in_octets': '8741328694',
                                                                                                                  'in_ucast_pkts': '43172530',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '31486416347',
                                                                                                                  'out_octets': '41670892643389',
                                                                                                                  'out_ucast_pkts': '96181866',
                                                                                                                  'poller_hash': 'NzZGMjFDcGVlcmludGZwb24gMjE3'},
                                                                                                          {       'in_nucast_pkts': '130014',
                                                                                                                  'in_octets': '288227105398',
                                                                                                                  'in_ucast_pkts': '787813467',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1236308',
                                                                                                                  'out_octets': '6416827743126',
                                                                                                                  'out_ucast_pkts': '4572177128',
                                                                                                                  'poller_hash': 'NEQ0MjRGcGVlcmludGZwb24gMjE4'},
                                                                                                          {       'in_nucast_pkts': '14895258',
                                                                                                                  'in_octets': '77176752110',
                                                                                                                  'in_ucast_pkts': '340709041',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4727161231',
                                                                                                                  'out_octets': '7459784591263',
                                                                                                                  'out_ucast_pkts': '1123176417',
                                                                                                                  'poller_hash': 'NDAwMzhGcGVlcmludGZwb24gMjE5'},
                                                                                                          {       'in_nucast_pkts': '16812390',
                                                                                                                  'in_octets': '30566341054',
                                                                                                                  'in_ucast_pkts': '129123397',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4756227063',
                                                                                                                  'out_octets': '6684308572403',
                                                                                                                  'out_ucast_pkts': '538673175',
                                                                                                                  'poller_hash': 'ODZCQkVwZWVyaW50ZnBvbiAyMjA='},
                                                                                                          {       'in_nucast_pkts': '87585',
                                                                                                                  'in_octets': '31413325378',
                                                                                                                  'in_ucast_pkts': '107470056',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673701',
                                                                                                                  'out_octets': '669207366446',
                                                                                                                  'out_ucast_pkts': '488263183',
                                                                                                                  'poller_hash': 'OTU0RjQ1cGVlcmludGZwb24gMTQzODgy'},
                                                                                                          {       'in_nucast_pkts': '2111687',
                                                                                                                  'in_octets': '12368531473',
                                                                                                                  'in_ucast_pkts': '70436090',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4682726672',
                                                                                                                  'out_octets': '6399093821996',
                                                                                                                  'out_ucast_pkts': '207626403',
                                                                                                                  'poller_hash': 'QzgzODFBcGVlcmludGZwb24gMTYwOTk2'},
                                                                                                          {       'in_nucast_pkts': '38889',
                                                                                                                  'in_octets': '62419636152',
                                                                                                                  'in_ucast_pkts': '287596442',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1778949',
                                                                                                                  'out_octets': '1098826366923',
                                                                                                                  'out_ucast_pkts': '825196329',
                                                                                                                  'poller_hash': 'QzgxRTAxcGVlcmludGZwb24gMjA1NDU2'},
                                                                                                          {       'in_nucast_pkts': '1885060',
                                                                                                                  'in_octets': '8360985069',
                                                                                                                  'in_ucast_pkts': '27664597',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1753737682',
                                                                                                                  'out_octets': '2385364158320',
                                                                                                                  'out_ucast_pkts': '106418855',
                                                                                                                  'poller_hash': 'MTE5NTE0OXBlZXJpbnRmcG9uIDIxNTk2OQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '957166906947',
                                                                                         'out_octets': '1715111565293784',
                                                                                         'out_ucast_pkts': '304322755085',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzY=',
                                                                                         'pons': [       {       'id': '1/6',
                                                                                                                 'links': [       {       'connected_time': '18918905',
                                                                                                                                          'fiber_length': 1274,
                                                                                                                                          'poller_hash': 'MzIxMUIzcGVlcnBvbnBvbiA0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '3448135',
                                                                                                                                          'fiber_length': 1320,
                                                                                                                                          'poller_hash': 'NDJCOUQzcGVlcnBvbnBvbiAxMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18918928',
                                                                                                                                          'fiber_length': 1491,
                                                                                                                                          'poller_hash': 'ODcyNDJBcGVlcnBvbnBvbiAxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18919154',
                                                                                                                                          'fiber_length': 1490,
                                                                                                                                          'poller_hash': 'NDI4MTkxcGVlcnBvbnBvbiAzNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '3464977',
                                                                                                                                          'fiber_length': 1451,
                                                                                                                                          'poller_hash': 'MzIyM0QzcGVlcnBvbnBvbiA0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '3448171',
                                                                                                                                          'fiber_length': 1339,
                                                                                                                                          'poller_hash': 'NDJEMkJCcGVlcnBvbnBvbiA4Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18904062',
                                                                                                                                          'fiber_length': 1387,
                                                                                                                                          'poller_hash': 'ODc0NEZwZWVycG9ucG9uIDEyNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18903986',
                                                                                                                                          'fiber_length': 1329,
                                                                                                                                          'poller_hash': 'NEQxMTFGcGVlcnBvbnBvbiAyMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'poller_hash': 'MkZDQzMycGVlcnBvbnBvbiAyMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18903944',
                                                                                                                                          'fiber_length': 1247,
                                                                                                                                          'poller_hash': 'NDE1N0VwZWVycG9ucG9uIDIwNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18903967',
                                                                                                                                          'fiber_length': 1273,
                                                                                                                                          'poller_hash': 'NDE1QUJwZWVycG9ucG9uIDIwNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18903409',
                                                                                                                                          'fiber_length': 1353,
                                                                                                                                          'poller_hash': 'QkYyNTA1cGVlcnBvbnBvbiAyMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18903776',
                                                                                                                                          'fiber_length': 1330,
                                                                                                                                          'poller_hash': 'NDcwM0FGcGVlcnBvbnBvbiAyMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '3448238',
                                                                                                                                          'fiber_length': 1477,
                                                                                                                                          'poller_hash': 'ODcyNDVFcGVlcnBvbnBvbiAyMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '1330128',
                                                                                                                                          'fiber_length': 1207,
                                                                                                                                          'poller_hash': 'Mzk1MDdBcGVlcnBvbnBvbiAyMTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '3448236',
                                                                                                                                          'fiber_length': 1300,
                                                                                                                                          'poller_hash': 'QzgxQzNGcGVlcnBvbnBvbiAyMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18903905',
                                                                                                                                          'fiber_length': 1074,
                                                                                                                                          'poller_hash': 'MTk5QTMycGVlcnBvbnBvbiAyMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18904055',
                                                                                                                                          'fiber_length': 1007,
                                                                                                                                          'poller_hash': 'NzZGMjFDcGVlcnBvbnBvbiAyMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18904165',
                                                                                                                                          'fiber_length': 1327,
                                                                                                                                          'poller_hash': 'NEQ0MjRGcGVlcnBvbnBvbiAyMTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18903941',
                                                                                                                                          'fiber_length': 1198,
                                                                                                                                          'poller_hash': 'NDAwMzhGcGVlcnBvbnBvbiAyMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '18903959',
                                                                                                                                          'fiber_length': 1227,
                                                                                                                                          'poller_hash': 'ODZCQkVwZWVycG9ucG9uIDIyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '3448347',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'OTU0RjQ1cGVlcnBvbnBvbiAxNDM4ODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '2563275',
                                                                                                                                          'fiber_length': 1226,
                                                                                                                                          'poller_hash': 'QzgzODFBcGVlcnBvbnBvbiAxNjA5OTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '3444985',
                                                                                                                                          'fiber_length': 1089,
                                                                                                                                          'poller_hash': 'QzgxRTAxcGVlcnBvbnBvbiAyMDU0NTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005},
                                                                                                                                  {       'connected_time': '2015109',
                                                                                                                                          'fiber_length': 1180,
                                                                                                                                          'poller_hash': 'MTE5NTE0OXBlZXJwb25wb24gMjE1OTY5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.005}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/6',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/7',
                                                                                         'in_discards': '5680',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '8527629',
                                                                                         'in_octets': '19638185160447',
                                                                                         'in_ucast_pkts': '84197443733',
                                                                                         'links': [       {       'in_nucast_pkts': '20175072',
                                                                                                                  'in_octets': '65407056301',
                                                                                                                  'in_ucast_pkts': '224099473',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8863564083',
                                                                                                                  'out_octets': '12514128824106',
                                                                                                                  'out_ucast_pkts': '851587458',
                                                                                                                  'poller_hash': 'M0FERDcxcGVlcmludGZwb24gMQ=='},
                                                                                                          {       'in_nucast_pkts': '81518',
                                                                                                                  'in_octets': '73766242784',
                                                                                                                  'in_ucast_pkts': '214717338',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949542',
                                                                                                                  'out_octets': '764979438489',
                                                                                                                  'out_ucast_pkts': '576649678',
                                                                                                                  'poller_hash': 'MzNENTgwcGVlcmludGZwb24gMg=='},
                                                                                                          {       'in_nucast_pkts': '3772096',
                                                                                                                  'in_octets': '19596778635',
                                                                                                                  'in_ucast_pkts': '141685957',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1879786541',
                                                                                                                  'out_octets': '2933647771277',
                                                                                                                  'out_ucast_pkts': '336000993',
                                                                                                                  'poller_hash': 'NDJDNDE0cGVlcmludGZwb24gNQ=='},
                                                                                                          {       'in_nucast_pkts': '5446',
                                                                                                                  'in_octets': '12587851273',
                                                                                                                  'in_ucast_pkts': '39456648',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949570',
                                                                                                                  'out_octets': '129201364730',
                                                                                                                  'out_ucast_pkts': '100177444',
                                                                                                                  'poller_hash': 'NDNDMjRDcGVlcmludGZwb24gOA=='},
                                                                                                          {       'in_nucast_pkts': '4519025',
                                                                                                                  'in_octets': '132674537545',
                                                                                                                  'in_ucast_pkts': '1093440323',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11775991098',
                                                                                                                  'out_octets': '19528287586641',
                                                                                                                  'out_ucast_pkts': '3127381205',
                                                                                                                  'poller_hash': 'MzIxN0NBcGVlcmludGZwb24gMTE='},
                                                                                                          {       'in_nucast_pkts': '9062358',
                                                                                                                  'in_octets': '203547406854',
                                                                                                                  'in_ucast_pkts': '302145657',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14215512705',
                                                                                                                  'out_octets': '19559896394194',
                                                                                                                  'out_ucast_pkts': '827976201',
                                                                                                                  'poller_hash': 'MzIxNzE4cGVlcmludGZwb24gMTI='},
                                                                                                          {       'in_nucast_pkts': '2547865',
                                                                                                                  'in_octets': '174306367432',
                                                                                                                  'in_ucast_pkts': '230854048',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1283343115',
                                                                                                                  'out_octets': '2312154329026',
                                                                                                                  'out_ucast_pkts': '547890803',
                                                                                                                  'poller_hash': 'MzIxN0EycGVlcmludGZwb24gMTQ='},
                                                                                                          {       'in_nucast_pkts': '89096',
                                                                                                                  'in_octets': '17994893787',
                                                                                                                  'in_ucast_pkts': '54158608',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949489',
                                                                                                                  'out_octets': '290697636648',
                                                                                                                  'out_ucast_pkts': '234109851',
                                                                                                                  'poller_hash': 'M0FFQzIxcGVlcmludGZwb24gMTY='},
                                                                                                          {       'in_nucast_pkts': '17174448',
                                                                                                                  'in_octets': '247698992568',
                                                                                                                  'in_ucast_pkts': '793351426',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '50459047121',
                                                                                                                  'out_octets': '70556003654004',
                                                                                                                  'out_ucast_pkts': '2472038943',
                                                                                                                  'poller_hash': 'NDJEMzhGcGVlcmludGZwb24gMTk='},
                                                                                                          {       'in_nucast_pkts': '6865',
                                                                                                                  'in_octets': '12209560389',
                                                                                                                  'in_ucast_pkts': '37475001',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '157791',
                                                                                                                  'out_octets': '111449188176',
                                                                                                                  'out_ucast_pkts': '87775792',
                                                                                                                  'poller_hash': 'NzFEODk3cGVlcmludGZwb24gMjI='},
                                                                                                          {       'in_nucast_pkts': '25265227',
                                                                                                                  'in_octets': '68323045684',
                                                                                                                  'in_ucast_pkts': '241235700',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '23951715734',
                                                                                                                  'out_octets': '31985063186745',
                                                                                                                  'out_ucast_pkts': '522059004',
                                                                                                                  'poller_hash': 'MkVCOUI4cGVlcmludGZwb24gMjU='},
                                                                                                          {       'in_nucast_pkts': '30619713',
                                                                                                                  'in_octets': '372931579762',
                                                                                                                  'in_ucast_pkts': '504105453',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '44143859793',
                                                                                                                  'out_octets': '60857004183553',
                                                                                                                  'out_ucast_pkts': '1542281039',
                                                                                                                  'poller_hash': 'NTU2M0QxcGVlcmludGZwb24gMjY='},
                                                                                                          {       'in_nucast_pkts': '7269323',
                                                                                                                  'in_octets': '98666232789',
                                                                                                                  'in_ucast_pkts': '507659224',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13423106523',
                                                                                                                  'out_octets': '19880917085182',
                                                                                                                  'out_ucast_pkts': '1590721638',
                                                                                                                  'poller_hash': 'MTc1RTZEcGVlcmludGZwb24gMjc='},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '14870070864',
                                                                                                                  'in_ucast_pkts': '51676725',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1438751',
                                                                                                                  'out_octets': '221936364435',
                                                                                                                  'out_ucast_pkts': '170063880',
                                                                                                                  'poller_hash': 'NDJEMzdGcGVlcmludGZwb24gODI='},
                                                                                                          {       'in_nucast_pkts': '2599927',
                                                                                                                  'in_octets': '60571387278',
                                                                                                                  'in_ucast_pkts': '218072579',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1576143641',
                                                                                                                  'out_octets': '2970312578872',
                                                                                                                  'out_ucast_pkts': '671687228',
                                                                                                                  'poller_hash': 'NDJEMUJEcGVlcmludGZwb24gODk='},
                                                                                                          {       'in_nucast_pkts': '12651',
                                                                                                                  'in_octets': '160664752356',
                                                                                                                  'in_ucast_pkts': '390012421',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1124501',
                                                                                                                  'out_octets': '1553722753277',
                                                                                                                  'out_ucast_pkts': '1187866251',
                                                                                                                  'poller_hash': 'NEUzRDA0cGVlcmludGZwb24gMTE5'},
                                                                                                          {       'in_nucast_pkts': '13330926',
                                                                                                                  'in_octets': '16194888758',
                                                                                                                  'in_ucast_pkts': '86157036',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '36000644261',
                                                                                                                  'out_octets': '48389188700587',
                                                                                                                  'out_ucast_pkts': '195918939',
                                                                                                                  'poller_hash': 'NzIyMjEzcGVlcmludGZwb24gMTIw'},
                                                                                                          {       'in_nucast_pkts': '57407',
                                                                                                                  'in_octets': '100874272482',
                                                                                                                  'in_ucast_pkts': '736535926',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1236842',
                                                                                                                  'out_octets': '3998770635326',
                                                                                                                  'out_ucast_pkts': '2851452387',
                                                                                                                  'poller_hash': 'MTk5OUU5cGVlcmludGZwb24gMTI1'},
                                                                                                          {       'in_nucast_pkts': '1878',
                                                                                                                  'in_octets': '24346389918',
                                                                                                                  'in_ucast_pkts': '167111491',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '470865',
                                                                                                                  'out_octets': '799067413730',
                                                                                                                  'out_ucast_pkts': '560527432',
                                                                                                                  'poller_hash': 'QTlGQjlwZWVyaW50ZnBvbiAxMzE='},
                                                                                                          {       'in_nucast_pkts': '10136864',
                                                                                                                  'in_octets': '23776657876',
                                                                                                                  'in_ucast_pkts': '151355495',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5634436449',
                                                                                                                  'out_octets': '7261579325543',
                                                                                                                  'out_ucast_pkts': '342852859',
                                                                                                                  'poller_hash': 'QkYyNEYxcGVlcmludGZwb24gMTM0'},
                                                                                                          {       'in_nucast_pkts': '14040322',
                                                                                                                  'in_octets': '353219072690',
                                                                                                                  'in_ucast_pkts': '2229026965',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8291315903',
                                                                                                                  'out_octets': '18147845519694',
                                                                                                                  'out_ucast_pkts': '5510101289',
                                                                                                                  'poller_hash': 'MkVEOUY1cGVlcmludGZwb24gMjIy'},
                                                                                                          {       'in_nucast_pkts': '14869',
                                                                                                                  'in_octets': '28387054847',
                                                                                                                  'in_ucast_pkts': '188989903',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949586',
                                                                                                                  'out_octets': '86973374618',
                                                                                                                  'out_ucast_pkts': '152509208',
                                                                                                                  'poller_hash': 'NDE1RkVwZWVyaW50ZnBvbiAyMjM='},
                                                                                                          {       'in_nucast_pkts': '14830250',
                                                                                                                  'in_octets': '235230379844',
                                                                                                                  'in_ucast_pkts': '5004672315',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5321860189',
                                                                                                                  'out_octets': '9064829650708',
                                                                                                                  'out_ucast_pkts': '27525136941',
                                                                                                                  'poller_hash': 'M0NGOURwZWVyaW50ZnBvbiAyMjQ='},
                                                                                                          {       'in_nucast_pkts': '7887568',
                                                                                                                  'in_octets': '39002720684',
                                                                                                                  'in_ucast_pkts': '115175427',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18542740491',
                                                                                                                  'out_octets': '24997535575799',
                                                                                                                  'out_ucast_pkts': '129024371296',
                                                                                                                  'poller_hash': 'M0NGQThwZWVyaW50ZnBvbiAyMjU='},
                                                                                                          {       'in_nucast_pkts': '3234',
                                                                                                                  'in_octets': '3687012811',
                                                                                                                  'in_ucast_pkts': '26261978',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '115171',
                                                                                                                  'out_octets': '193875789577',
                                                                                                                  'out_ucast_pkts': '136841744',
                                                                                                                  'poller_hash': 'MTc1RTY2cGVlcmludGZwb24gMjI2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MjVCNUY5cGVlcmludGZwb24gMjI3'},
                                                                                                          {       'in_nucast_pkts': '11963899',
                                                                                                                  'in_octets': '22653026631',
                                                                                                                  'in_ucast_pkts': '89237699',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '22028877039',
                                                                                                                  'out_octets': '29543618125281',
                                                                                                                  'out_ucast_pkts': '336743787',
                                                                                                                  'poller_hash': 'NDAwM0Q0cGVlcmludGZwb24gMjI4'},
                                                                                                          {       'in_nucast_pkts': '12524140',
                                                                                                                  'in_octets': '480743110393',
                                                                                                                  'in_ucast_pkts': '735551902',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '32485898378',
                                                                                                                  'out_octets': '45890844711452',
                                                                                                                  'out_ucast_pkts': '1818744294',
                                                                                                                  'poller_hash': 'QzgxREQycGVlcmludGZwb24gMjI5'},
                                                                                                          {       'in_nucast_pkts': '1707',
                                                                                                                  'in_octets': '4420118666',
                                                                                                                  'in_ucast_pkts': '19648310',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673795',
                                                                                                                  'out_octets': '53525266369',
                                                                                                                  'out_ucast_pkts': '45875140',
                                                                                                                  'poller_hash': 'NUE2QzU0cGVlcmludGZwb24gMTM4Njk0'},
                                                                                                          {       'in_nucast_pkts': '114912',
                                                                                                                  'in_octets': '29375569933',
                                                                                                                  'in_ucast_pkts': '205976495',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673809',
                                                                                                                  'out_octets': '666284691190',
                                                                                                                  'out_ucast_pkts': '482763895',
                                                                                                                  'poller_hash': 'ODJBNTVBcGVlcmludGZwb24gMTQwOTM5'},
                                                                                                          {       'in_nucast_pkts': '56146',
                                                                                                                  'in_octets': '102717509814',
                                                                                                                  'in_ucast_pkts': '524415455',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1541768',
                                                                                                                  'out_octets': '1941716306007',
                                                                                                                  'out_ucast_pkts': '1417762985',
                                                                                                                  'poller_hash': 'QzgxOTE0cGVlcmludGZwb24gMTk2MjI0'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '993271370595',
                                                                                         'out_octets': '1679041234868624',
                                                                                         'out_ucast_pkts': '242310828345',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzc=',
                                                                                         'pons': [       {       'id': '1/7',
                                                                                                                 'links': [       {       'connected_time': '18903764',
                                                                                                                                          'fiber_length': 757,
                                                                                                                                          'poller_hash': 'M0FERDcxcGVlcnBvbnBvbiAx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '3448132',
                                                                                                                                          'fiber_length': 1251,
                                                                                                                                          'poller_hash': 'MzNENTgwcGVlcnBvbnBvbiAy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '3448112',
                                                                                                                                          'fiber_length': 1180,
                                                                                                                                          'poller_hash': 'NDJDNDE0cGVlcnBvbnBvbiA1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '3448077',
                                                                                                                                          'fiber_length': 432,
                                                                                                                                          'poller_hash': 'NDNDMjRDcGVlcnBvbnBvbiA4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18632937',
                                                                                                                                          'fiber_length': 1048,
                                                                                                                                          'poller_hash': 'MzIxN0NBcGVlcnBvbnBvbiAxMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18919212',
                                                                                                                                          'fiber_length': 1083,
                                                                                                                                          'poller_hash': 'MzIxNzE4cGVlcnBvbnBvbiAxMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '3448120',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'MzIxN0EycGVlcnBvbnBvbiAxNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '3448132',
                                                                                                                                          'fiber_length': 819,
                                                                                                                                          'poller_hash': 'M0FFQzIxcGVlcnBvbnBvbiAxNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18918844',
                                                                                                                                          'fiber_length': 853,
                                                                                                                                          'poller_hash': 'NDJEMzhGcGVlcnBvbnBvbiAxOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18903892',
                                                                                                                                          'fiber_length': 621,
                                                                                                                                          'poller_hash': 'NzFEODk3cGVlcnBvbnBvbiAyMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18903847',
                                                                                                                                          'fiber_length': 1135,
                                                                                                                                          'poller_hash': 'MkVCOUI4cGVlcnBvbnBvbiAyNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18903581',
                                                                                                                                          'fiber_length': 1050,
                                                                                                                                          'poller_hash': 'NTU2M0QxcGVlcnBvbnBvbiAyNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18903798',
                                                                                                                                          'fiber_length': 444,
                                                                                                                                          'poller_hash': 'MTc1RTZEcGVlcnBvbnBvbiAyNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '1837203',
                                                                                                                                          'fiber_length': 1283,
                                                                                                                                          'poller_hash': 'NDJEMzdGcGVlcnBvbnBvbiA4Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '3448182',
                                                                                                                                          'fiber_length': 893,
                                                                                                                                          'poller_hash': 'NDJEMUJEcGVlcnBvbnBvbiA4OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '11608081',
                                                                                                                                          'fiber_length': 1174,
                                                                                                                                          'poller_hash': 'NEUzRDA0cGVlcnBvbnBvbiAxMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18904048',
                                                                                                                                          'fiber_length': 1259,
                                                                                                                                          'poller_hash': 'NzIyMjEzcGVlcnBvbnBvbiAxMjA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18904010',
                                                                                                                                          'fiber_length': 428,
                                                                                                                                          'poller_hash': 'MTk5OUU5cGVlcnBvbnBvbiAxMjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '1667175',
                                                                                                                                          'fiber_length': 890,
                                                                                                                                          'poller_hash': 'QTlGQjlwZWVycG9ucG9uIDEzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18904078',
                                                                                                                                          'fiber_length': 607,
                                                                                                                                          'poller_hash': 'QkYyNEYxcGVlcnBvbnBvbiAxMzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18903574',
                                                                                                                                          'fiber_length': 1200,
                                                                                                                                          'poller_hash': 'MkVEOUY1cGVlcnBvbnBvbiAyMjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '3448159',
                                                                                                                                          'fiber_length': 1137,
                                                                                                                                          'poller_hash': 'NDE1RkVwZWVycG9ucG9uIDIyMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18903892',
                                                                                                                                          'fiber_length': 1161,
                                                                                                                                          'poller_hash': 'M0NGOURwZWVycG9ucG9uIDIyNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18903894',
                                                                                                                                          'fiber_length': 1169,
                                                                                                                                          'poller_hash': 'M0NGQThwZWVycG9ucG9uIDIyNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '376431',
                                                                                                                                          'fiber_length': 1108,
                                                                                                                                          'poller_hash': 'MTc1RTY2cGVlcnBvbnBvbiAyMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18903578',
                                                                                                                                          'fiber_length': 1081,
                                                                                                                                          'poller_hash': 'MjVCNUY5cGVlcnBvbnBvbiAyMjc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18904196',
                                                                                                                                          'fiber_length': 1034,
                                                                                                                                          'poller_hash': 'NDAwM0Q0cGVlcnBvbnBvbiAyMjg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '18919180',
                                                                                                                                          'fiber_length': 1118,
                                                                                                                                          'poller_hash': 'QzgxREQycGVlcnBvbnBvbiAyMjk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '3448443',
                                                                                                                                          'fiber_length': 1038,
                                                                                                                                          'poller_hash': 'NUE2QzU0cGVlcnBvbnBvbiAxMzg2OTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '3448464',
                                                                                                                                          'fiber_length': 1370,
                                                                                                                                          'poller_hash': 'ODJBNTVBcGVlcnBvbnBvbiAxNDA5Mzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509},
                                                                                                                                  {       'connected_time': '2985894',
                                                                                                                                          'fiber_length': 1557,
                                                                                                                                          'poller_hash': 'QzgxOTE0cGVlcnBvbnBvbiAxOTYyMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.509}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/7',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/8',
                                                                                         'in_discards': '142774',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '6127762',
                                                                                         'in_octets': '17985582896034',
                                                                                         'in_ucast_pkts': '80169869167',
                                                                                         'links': [       {       'in_nucast_pkts': '3560856',
                                                                                                                  'in_octets': '78060904312',
                                                                                                                  'in_ucast_pkts': '113542740',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5443486580',
                                                                                                                  'out_octets': '7610315965446',
                                                                                                                  'out_ucast_pkts': '306507544',
                                                                                                                  'poller_hash': 'NDI4MUQwcGVlcmludGZwb24gMzI='},
                                                                                                          {       'in_nucast_pkts': '16493683',
                                                                                                                  'in_octets': '512571960489',
                                                                                                                  'in_ucast_pkts': '3135670776',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12165864719',
                                                                                                                  'out_octets': '25984319779871',
                                                                                                                  'out_ucast_pkts': '6989130037',
                                                                                                                  'poller_hash': 'NDcwOTJDcGVlcmludGZwb24gMzM='},
                                                                                                          {       'in_nucast_pkts': '584146',
                                                                                                                  'in_octets': '26603251286',
                                                                                                                  'in_ucast_pkts': '49350647',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '228213693',
                                                                                                                  'out_octets': '468676144602',
                                                                                                                  'out_ucast_pkts': '131070990',
                                                                                                                  'poller_hash': 'MjQ4QUMzcGVlcmludGZwb24gMzQ='},
                                                                                                          {       'in_nucast_pkts': '52769',
                                                                                                                  'in_octets': '96322080907',
                                                                                                                  'in_ucast_pkts': '515657058',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1900898',
                                                                                                                  'out_octets': '1633367107840',
                                                                                                                  'out_ucast_pkts': '1172546128',
                                                                                                                  'poller_hash': 'NTYwMjYycGVlcmludGZwb24gMzg='},
                                                                                                          {       'in_nucast_pkts': '6471568',
                                                                                                                  'in_octets': '16755138965',
                                                                                                                  'in_ucast_pkts': '67898192',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5531774151',
                                                                                                                  'out_octets': '7227259306385',
                                                                                                                  'out_ucast_pkts': '113991922',
                                                                                                                  'poller_hash': 'MzI5NjNDcGVlcmludGZwb24gMzk='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'NEQ0MUVFcGVlcmludGZwb24gNDI='},
                                                                                                          {       'in_nucast_pkts': '4182722',
                                                                                                                  'in_octets': '18557548489',
                                                                                                                  'in_ucast_pkts': '73507537',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '853320231',
                                                                                                                  'out_octets': '1631247441987',
                                                                                                                  'out_ucast_pkts': '406664686',
                                                                                                                  'poller_hash': 'QzRGRjRwZWVyaW50ZnBvbiA0NQ=='},
                                                                                                          {       'in_nucast_pkts': '6',
                                                                                                                  'in_octets': '12896366594',
                                                                                                                  'in_ucast_pkts': '72442340',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5542',
                                                                                                                  'out_octets': '484878957860',
                                                                                                                  'out_ucast_pkts': '335596118',
                                                                                                                  'poller_hash': 'NTVFQTkwcGVlcmludGZwb24gNDc='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'N0ZFMkFwZWVyaW50ZnBvbiA1MQ=='},
                                                                                                          {       'in_nucast_pkts': '2836375',
                                                                                                                  'in_octets': '10057423210',
                                                                                                                  'in_ucast_pkts': '24101403',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4419821019',
                                                                                                                  'out_octets': '5733404579928',
                                                                                                                  'out_ucast_pkts': '42675019',
                                                                                                                  'poller_hash': 'NDJDOENGcGVlcmludGZwb24gNzY='},
                                                                                                          {       'in_nucast_pkts': '2646935',
                                                                                                                  'in_octets': '49093806398',
                                                                                                                  'in_ucast_pkts': '255359906',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2674019647',
                                                                                                                  'out_octets': '4732001063155',
                                                                                                                  'out_ucast_pkts': '836799908',
                                                                                                                  'poller_hash': 'ODY5M0RGcGVlcmludGZwb24gOTA='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'QUMzRTRwZWVyaW50ZnBvbiAxMzc='},
                                                                                                          {       'in_nucast_pkts': '98261',
                                                                                                                  'in_octets': '51625419267',
                                                                                                                  'in_ucast_pkts': '152941720',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '957239',
                                                                                                                  'out_octets': '338386428368',
                                                                                                                  'out_ucast_pkts': '285719023',
                                                                                                                  'poller_hash': 'NDE1NDJwZWVyaW50ZnBvbiAxOTk='},
                                                                                                          {       'in_nucast_pkts': '3751',
                                                                                                                  'in_octets': '1092230887497',
                                                                                                                  'in_ucast_pkts': '2812453047',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1228062',
                                                                                                                  'out_octets': '4540088257892',
                                                                                                                  'out_ucast_pkts': '3638848185',
                                                                                                                  'poller_hash': 'Q0MwQjZwZWVyaW50ZnBvbiAyMDA='},
                                                                                                          {       'in_nucast_pkts': '10912087',
                                                                                                                  'in_octets': '29416978095',
                                                                                                                  'in_ucast_pkts': '175868101',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15459599816',
                                                                                                                  'out_octets': '21101602846725',
                                                                                                                  'out_ucast_pkts': '677157004',
                                                                                                                  'poller_hash': 'MzY1NUE5cGVlcmludGZwb24gMjAx'},
                                                                                                          {       'in_nucast_pkts': '8304',
                                                                                                                  'in_octets': '215947419767',
                                                                                                                  'in_ucast_pkts': '851876872',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1235620',
                                                                                                                  'out_octets': '2593984515804',
                                                                                                                  'out_ucast_pkts': '2020754590',
                                                                                                                  'poller_hash': 'NDE1MkZwZWVyaW50ZnBvbiAyMDI='},
                                                                                                          {       'in_nucast_pkts': '4',
                                                                                                                  'in_octets': '14581638209',
                                                                                                                  'in_ucast_pkts': '48137333',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949571',
                                                                                                                  'out_octets': '66026243462',
                                                                                                                  'out_ucast_pkts': '73515378',
                                                                                                                  'poller_hash': 'M0VCQTUzcGVlcmludGZwb24gMjMw'},
                                                                                                          {       'in_nucast_pkts': '778',
                                                                                                                  'in_octets': '600162773',
                                                                                                                  'in_ucast_pkts': '3795874',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '813',
                                                                                                                  'out_octets': '20280465745',
                                                                                                                  'out_ucast_pkts': '14605152',
                                                                                                                  'poller_hash': 'M0FFQkJEcGVlcmludGZwb24gMjM4'},
                                                                                                          {       'in_nucast_pkts': '28',
                                                                                                                  'in_octets': '46851669616',
                                                                                                                  'in_ucast_pkts': '275875482',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949575',
                                                                                                                  'out_octets': '809110330676',
                                                                                                                  'out_ucast_pkts': '634138804',
                                                                                                                  'poller_hash': 'M0FFQkI2cGVlcmludGZwb24gMjM5'},
                                                                                                          {       'in_nucast_pkts': '73',
                                                                                                                  'in_octets': '5441386460',
                                                                                                                  'in_ucast_pkts': '43863379',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '453063',
                                                                                                                  'out_octets': '154411648321',
                                                                                                                  'out_ucast_pkts': '110868836',
                                                                                                                  'poller_hash': 'M0FFQjk4cGVlcmludGZwb24gMjQw'},
                                                                                                          {       'in_nucast_pkts': '1446238',
                                                                                                                  'in_octets': '45800976059',
                                                                                                                  'in_ucast_pkts': '84770748',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1735273271',
                                                                                                                  'out_octets': '2512979334839',
                                                                                                                  'out_ucast_pkts': '226703259',
                                                                                                                  'poller_hash': 'MTMwMDVGcGVlcmludGZwb24gMjQx'},
                                                                                                          {       'in_nucast_pkts': '1319433',
                                                                                                                  'in_octets': '1834273758',
                                                                                                                  'in_ucast_pkts': '8694203',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1114653583',
                                                                                                                  'out_octets': '1458300368280',
                                                                                                                  'out_ucast_pkts': '35487757',
                                                                                                                  'poller_hash': 'MTMwMDhCcGVlcmludGZwb24gMjQy'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'NDAwRjY0cGVlcmludGZwb24gMjQz'},
                                                                                                          {       'in_nucast_pkts': '168',
                                                                                                                  'in_octets': '16750886017',
                                                                                                                  'in_ucast_pkts': '170126835',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11281',
                                                                                                                  'out_octets': '501927179513',
                                                                                                                  'out_ucast_pkts': '340065137',
                                                                                                                  'poller_hash': 'NzFEOEEwcGVlcmludGZwb24gMjQ0'},
                                                                                                          {       'in_nucast_pkts': '15500',
                                                                                                                  'in_octets': '15884260820',
                                                                                                                  'in_ucast_pkts': '73943828',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1230082',
                                                                                                                  'out_octets': '224319331871',
                                                                                                                  'out_ucast_pkts': '199180298',
                                                                                                                  'poller_hash': 'NTU2M0I2cGVlcmludGZwb24gMjQ1'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODczMjNwZWVyaW50ZnBvbiAyNDY='},
                                                                                                          {       'in_nucast_pkts': '12153403',
                                                                                                                  'in_octets': '280746782656',
                                                                                                                  'in_ucast_pkts': '2106025832',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '24111814741',
                                                                                                                  'out_octets': '38342782415788',
                                                                                                                  'out_ucast_pkts': '4407059906',
                                                                                                                  'poller_hash': 'NEQ0MUY1cGVlcmludGZwb24gMjQ3'},
                                                                                                          {       'in_nucast_pkts': '25627296',
                                                                                                                  'in_octets': '17159640914',
                                                                                                                  'in_ucast_pkts': '46215262',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11737918657',
                                                                                                                  'out_octets': '14819048287963',
                                                                                                                  'out_ucast_pkts': '133348710',
                                                                                                                  'poller_hash': 'MjQ4QUUzcGVlcmludGZwb24gMjQ4'},
                                                                                                          {       'in_nucast_pkts': '6',
                                                                                                                  'in_octets': '26641018847',
                                                                                                                  'in_ucast_pkts': '185615035',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '949576',
                                                                                                                  'out_octets': '688996892014',
                                                                                                                  'out_ucast_pkts': '483752095',
                                                                                                                  'poller_hash': 'NDAwNDU1cGVlcmludGZwb24gMjQ5'},
                                                                                                          {       'in_nucast_pkts': '2693132',
                                                                                                                  'in_octets': '4585366100',
                                                                                                                  'in_ucast_pkts': '18185113',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4813911453',
                                                                                                                  'out_octets': '6553458724330',
                                                                                                                  'out_ucast_pkts': '79665771',
                                                                                                                  'poller_hash': 'ODY5MzlDcGVlcmludGZwb24gMTM4ODgx'},
                                                                                                          {       'in_nucast_pkts': '1405893',
                                                                                                                  'in_octets': '17169228210',
                                                                                                                  'in_ucast_pkts': '123675081',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2673827',
                                                                                                                  'out_octets': '654852794985',
                                                                                                                  'out_ucast_pkts': '455557786',
                                                                                                                  'poller_hash': 'ODQ0QkU1cGVlcmludGZwb24gMTQwODUz'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '702482311807',
                                                                                         'out_octets': '1241866060006700',
                                                                                         'out_ucast_pkts': '211500183984',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzg=',
                                                                                         'pons': [       {       'id': '1/8',
                                                                                                                 'links': [       {       'connected_time': '3447777',
                                                                                                                                          'fiber_length': 1372,
                                                                                                                                          'poller_hash': 'NDI4MUQwcGVlcnBvbnBvbiAzMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '18903997',
                                                                                                                                          'fiber_length': 1354,
                                                                                                                                          'poller_hash': 'NDcwOTJDcGVlcnBvbnBvbiAzMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448162',
                                                                                                                                          'fiber_length': 951,
                                                                                                                                          'poller_hash': 'MjQ4QUMzcGVlcnBvbnBvbiAzNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448087',
                                                                                                                                          'fiber_length': 450,
                                                                                                                                          'poller_hash': 'NTYwMjYycGVlcnBvbnBvbiAzOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '18904058',
                                                                                                                                          'fiber_length': 599,
                                                                                                                                          'poller_hash': 'MzI5NjNDcGVlcnBvbnBvbiAzOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '18903902',
                                                                                                                                          'fiber_length': 457,
                                                                                                                                          'poller_hash': 'NEQ0MUVFcGVlcnBvbnBvbiA0Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448092',
                                                                                                                                          'fiber_length': 940,
                                                                                                                                          'poller_hash': 'QzRGRjRwZWVycG9ucG9uIDQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448106',
                                                                                                                                          'fiber_length': 589,
                                                                                                                                          'poller_hash': 'NTVFQTkwcGVlcnBvbnBvbiA0Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '18903960',
                                                                                                                                          'fiber_length': 1139,
                                                                                                                                          'poller_hash': 'N0ZFMkFwZWVycG9ucG9uIDUx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448174',
                                                                                                                                          'fiber_length': 982,
                                                                                                                                          'poller_hash': 'NDJDOENGcGVlcnBvbnBvbiA3Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3379196',
                                                                                                                                          'fiber_length': 791,
                                                                                                                                          'poller_hash': 'ODY5M0RGcGVlcnBvbnBvbiA5MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'poller_hash': 'QUMzRTRwZWVycG9ucG9uIDEzNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448145',
                                                                                                                                          'fiber_length': 656,
                                                                                                                                          'poller_hash': 'NDE1NDJwZWVycG9ucG9uIDE5OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '18638990',
                                                                                                                                          'fiber_length': 726,
                                                                                                                                          'poller_hash': 'Q0MwQjZwZWVycG9ucG9uIDIwMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '18903810',
                                                                                                                                          'fiber_length': 836,
                                                                                                                                          'poller_hash': 'MzY1NUE5cGVlcnBvbnBvbiAyMDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '18903980',
                                                                                                                                          'fiber_length': 699,
                                                                                                                                          'poller_hash': 'NDE1MkZwZWVycG9ucG9uIDIwMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448242',
                                                                                                                                          'fiber_length': 405,
                                                                                                                                          'poller_hash': 'M0VCQTUzcGVlcnBvbnBvbiAyMzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '90410',
                                                                                                                                          'fiber_length': 1234,
                                                                                                                                          'poller_hash': 'M0FFQkJEcGVlcnBvbnBvbiAyMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448207',
                                                                                                                                          'fiber_length': 946,
                                                                                                                                          'poller_hash': 'M0FFQkI2cGVlcnBvbnBvbiAyMzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448269',
                                                                                                                                          'fiber_length': 492,
                                                                                                                                          'poller_hash': 'M0FFQjk4cGVlcnBvbnBvbiAyNDA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448211',
                                                                                                                                          'fiber_length': 1058,
                                                                                                                                          'poller_hash': 'MTMwMDVGcGVlcnBvbnBvbiAyNDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448209',
                                                                                                                                          'fiber_length': 783,
                                                                                                                                          'poller_hash': 'MTMwMDhCcGVlcnBvbnBvbiAyNDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448236',
                                                                                                                                          'fiber_length': 894,
                                                                                                                                          'poller_hash': 'NDAwRjY0cGVlcnBvbnBvbiAyNDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '1345297',
                                                                                                                                          'fiber_length': 468,
                                                                                                                                          'poller_hash': 'NzFEOEEwcGVlcnBvbnBvbiAyNDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '18904296',
                                                                                                                                          'fiber_length': 580,
                                                                                                                                          'poller_hash': 'NTU2M0I2cGVlcnBvbnBvbiAyNDU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'poller_hash': 'ODczMjNwZWVycG9ucG9uIDI0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '18904112',
                                                                                                                                          'fiber_length': 1181,
                                                                                                                                          'poller_hash': 'NEQ0MUY1cGVlcnBvbnBvbiAyNDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '18904037',
                                                                                                                                          'fiber_length': 1099,
                                                                                                                                          'poller_hash': 'MjQ4QUUzcGVlcnBvbnBvbiAyNDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448269',
                                                                                                                                          'fiber_length': 1110,
                                                                                                                                          'poller_hash': 'NDAwNDU1cGVlcnBvbnBvbiAyNDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3442121',
                                                                                                                                          'fiber_length': 976,
                                                                                                                                          'poller_hash': 'ODY5MzlDcGVlcnBvbnBvbiAxMzg4ODE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601},
                                                                                                                                  {       'connected_time': '3448499',
                                                                                                                                          'fiber_length': 1108,
                                                                                                                                          'poller_hash': 'ODQ0QkU1cGVlcnBvbnBvbiAxNDA4NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.601}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/8',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzg=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03006',
                                                           'name': 'GPON-8',
                                                           'poller_hash': 'MjExNzAzNjAxMTg4',
                                                           'serial_number': '211703601188',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '81203216'},
                                                   {       'id': '2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '2/x3',
                                                                                         'in_discards': '463243244',
                                                                                         'in_errors': '1521',
                                                                                         'in_nucast_pkts': '10729544730477',
                                                                                         'in_octets': '39809341046314363',
                                                                                         'in_ucast_pkts': '19742081112701',
                                                                                         'mac_address': 'cc:be:59:12:6a:8f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01511',
                                                                                         'name': 'ethernet '
                                                                                                 '2/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '2188452047',
                                                                                         'out_octets': '3406423092794249',
                                                                                         'out_ucast_pkts': '8717722587301',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/x4',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23049162',
                                                                                         'in_octets': '3130580001',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': 'cc:be:59:12:6a:90',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC02',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 '2/x4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '35889015',
                                                                                         'out_octets': '44831818310185',
                                                                                         'out_ucast_pkts': '147731629958',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0TUNDTC1TVUJTIDIveDQ=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2421807',
                                                                                         'in_octets': '926675612',
                                                                                         'in_ucast_pkts': '9869738',
                                                                                         'mac_address': 'cc:be:59:12:6a:81',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-GB-GE-T',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '860351778',
                                                                                         'out_octets': '120398020269',
                                                                                         'out_ucast_pkts': '9157525',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMQ==',
                                                                                         'speed': '100000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '2/g2',
                                                                                         'mac_address': 'cc:be:59:12:6a:82',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '2/g3',
                                                                                         'mac_address': 'cc:be:59:12:6a:83',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMw=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g4',
                                                                                         'in_discards': '123',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '90669',
                                                                                         'in_octets': '6673625783',
                                                                                         'in_ucast_pkts': '30305585',
                                                                                         'mac_address': 'cc:be:59:12:6a:84',
                                                                                         'manufacturer': 'BROCADE',
                                                                                         'model': '57-1000042-01',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '103789022',
                                                                                         'out_octets': '16372176893',
                                                                                         'out_ucast_pkts': '68153771',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/1',
                                                                                         'in_discards': '128137',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '6139155',
                                                                                         'in_octets': '22530068056461',
                                                                                         'in_ucast_pkts': '106907502684',
                                                                                         'links': [       {       'in_nucast_pkts': '2164',
                                                                                                                  'in_octets': '186652232175',
                                                                                                                  'in_ucast_pkts': '908016002',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1543612',
                                                                                                                  'out_octets': '2654009326968',
                                                                                                                  'out_ucast_pkts': '2006384142',
                                                                                                                  'poller_hash': 'NTU2M0FCcGVlcmludGZwb24gMjUw'},
                                                                                                          {       'in_nucast_pkts': '174832',
                                                                                                                  'in_octets': '465974548413',
                                                                                                                  'in_ucast_pkts': '4268534121',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1647367',
                                                                                                                  'out_octets': '8339743890212',
                                                                                                                  'out_ucast_pkts': '5815289934',
                                                                                                                  'poller_hash': 'NEQ0MjNEcGVlcmludGZwb24gMjUz'},
                                                                                                          {       'in_nucast_pkts': '8951',
                                                                                                                  'in_octets': '67997015452',
                                                                                                                  'in_ucast_pkts': '626880250',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1630560',
                                                                                                                  'out_octets': '2396411998563',
                                                                                                                  'out_ucast_pkts': '1690805886',
                                                                                                                  'poller_hash': 'QzUwMTBwZWVyaW50ZnBvbiAyNTQ='},
                                                                                                          {       'in_nucast_pkts': '935024',
                                                                                                                  'in_octets': '63013362874',
                                                                                                                  'in_ucast_pkts': '346169737',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1560011',
                                                                                                                  'out_octets': '1663766793351',
                                                                                                                  'out_ucast_pkts': '1154147855',
                                                                                                                  'poller_hash': 'NEQ0MUY3cGVlcmludGZwb24gMjU3'},
                                                                                                          {       'in_nucast_pkts': '14304180',
                                                                                                                  'in_octets': '59328412199',
                                                                                                                  'in_ucast_pkts': '192658017',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6522453596',
                                                                                                                  'out_octets': '9141526255650',
                                                                                                                  'out_ucast_pkts': '586781783',
                                                                                                                  'poller_hash': 'QkYxRTFCcGVlcmludGZwb24gMjU4'},
                                                                                                          {       'in_nucast_pkts': '5648847',
                                                                                                                  'in_octets': '291220883148',
                                                                                                                  'in_ucast_pkts': '1225073955',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6342826217',
                                                                                                                  'out_octets': '12642633516721',
                                                                                                                  'out_ucast_pkts': '3476453196',
                                                                                                                  'poller_hash': 'M0ZGRkUzcGVlcmludGZwb24gMjYx'},
                                                                                                          {       'in_nucast_pkts': '23750744',
                                                                                                                  'in_octets': '305711488665',
                                                                                                                  'in_ucast_pkts': '2387032715',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1647235',
                                                                                                                  'out_octets': '6484128702205',
                                                                                                                  'out_ucast_pkts': '8905780215',
                                                                                                                  'poller_hash': 'NDE4QjdwZWVyaW50ZnBvbiAyNjM='},
                                                                                                          {       'in_nucast_pkts': '3',
                                                                                                                  'in_octets': '60673215444',
                                                                                                                  'in_ucast_pkts': '520816717',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062566',
                                                                                                                  'out_octets': '1961938448164',
                                                                                                                  'out_ucast_pkts': '1365981196',
                                                                                                                  'poller_hash': 'MjNBMDAzcGVlcmludGZwb24gMjY1'},
                                                                                                          {       'in_nucast_pkts': '2391614',
                                                                                                                  'in_octets': '50715693320',
                                                                                                                  'in_ucast_pkts': '102923777',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2102134856',
                                                                                                                  'out_octets': '3085016546884',
                                                                                                                  'out_ucast_pkts': '334689655',
                                                                                                                  'poller_hash': 'NTU1Q0I4cGVlcmludGZwb24gMjY5'},
                                                                                                          {       'in_nucast_pkts': '10231329',
                                                                                                                  'in_octets': '12907421357',
                                                                                                                  'in_ucast_pkts': '61799963',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18912268308',
                                                                                                                  'out_octets': '25251273849726',
                                                                                                                  'out_ucast_pkts': '279841508',
                                                                                                                  'poller_hash': 'MkZDQzMxcGVlcmludGZwb24gMjcw'},
                                                                                                          {       'in_nucast_pkts': '1313964',
                                                                                                                  'in_octets': '727024997642',
                                                                                                                  'in_ucast_pkts': '1965413875',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1709646',
                                                                                                                  'out_octets': '5519026070118',
                                                                                                                  'out_ucast_pkts': '4785355771',
                                                                                                                  'poller_hash': 'RjIzQTVwZWVyaW50ZnBvbiAyNzE='},
                                                                                                          {       'in_nucast_pkts': '220996',
                                                                                                                  'in_octets': '406665001253',
                                                                                                                  'in_ucast_pkts': '2323842343',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1649010',
                                                                                                                  'out_octets': '8392404691241',
                                                                                                                  'out_ucast_pkts': '5957542334',
                                                                                                                  'poller_hash': 'MTk5OUY3cGVlcmludGZwb24gMjcy'},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '13749519587',
                                                                                                                  'in_ucast_pkts': '56764064',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1056178',
                                                                                                                  'out_octets': '580929566461',
                                                                                                                  'out_ucast_pkts': '413990748',
                                                                                                                  'poller_hash': 'MTI0ODQ1cGVlcmludGZwb24gMjcz'},
                                                                                                          {       'in_nucast_pkts': '28825',
                                                                                                                  'in_octets': '286006093995',
                                                                                                                  'in_ucast_pkts': '701446148',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1647439',
                                                                                                                  'out_octets': '2760451685015',
                                                                                                                  'out_ucast_pkts': '2163992054',
                                                                                                                  'poller_hash': 'MTk5OUUxcGVlcmludGZwb24gMjc0'},
                                                                                                          {       'in_nucast_pkts': '12639953',
                                                                                                                  'in_octets': '13864615560',
                                                                                                                  'in_ucast_pkts': '43026258',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '17954277360',
                                                                                                                  'out_octets': '23921387925096',
                                                                                                                  'out_ucast_pkts': '69434971',
                                                                                                                  'poller_hash': 'NEQ0MjQycGVlcmludGZwb24gMjc1'},
                                                                                                          {       'in_nucast_pkts': '130349',
                                                                                                                  'in_octets': '252191063423',
                                                                                                                  'in_ucast_pkts': '1086621245',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1647262',
                                                                                                                  'out_octets': '3338836889824',
                                                                                                                  'out_ucast_pkts': '2437891569',
                                                                                                                  'poller_hash': 'NDAwN0ZGcGVlcmludGZwb24gMjc2'},
                                                                                                          {       'in_nucast_pkts': '3',
                                                                                                                  'in_octets': '22620209441',
                                                                                                                  'in_ucast_pkts': '68608439',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062572',
                                                                                                                  'out_octets': '703168533058',
                                                                                                                  'out_ucast_pkts': '503720655',
                                                                                                                  'poller_hash': 'NzIyMDQxcGVlcmludGZwb24gMjc3'},
                                                                                                          {       'in_nucast_pkts': '17502119',
                                                                                                                  'in_octets': '67874778138',
                                                                                                                  'in_ucast_pkts': '515784939',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '33815322246',
                                                                                                                  'out_octets': '48155618090992',
                                                                                                                  'out_ucast_pkts': '1776361993',
                                                                                                                  'poller_hash': 'QTlDOTMxcGVlcmludGZwb24gMTU2NDU2'},
                                                                                                          {       'in_nucast_pkts': '138149',
                                                                                                                  'in_octets': '113226255661',
                                                                                                                  'in_ucast_pkts': '992065812',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11092704',
                                                                                                                  'out_octets': '3815437596768',
                                                                                                                  'out_ucast_pkts': '2692293965',
                                                                                                                  'poller_hash': 'QzgzRTBBcGVlcmludGZwb24gMTYxNjA3'},
                                                                                                          {       'in_nucast_pkts': '3981158',
                                                                                                                  'in_octets': '42130896974',
                                                                                                                  'in_ucast_pkts': '172860700',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1780522',
                                                                                                                  'out_octets': '680384117850',
                                                                                                                  'out_ucast_pkts': '487041086',
                                                                                                                  'poller_hash': 'QzgzQkFCcGVlcmludGZwb24gMTY0MjA3'},
                                                                                                          {       'in_nucast_pkts': '3250655',
                                                                                                                  'in_octets': '67641549048',
                                                                                                                  'in_ucast_pkts': '392348389',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2301538420',
                                                                                                                  'out_octets': '4434868661347',
                                                                                                                  'out_ucast_pkts': '1003391866',
                                                                                                                  'poller_hash': 'MTE5NTE1QnBlZXJpbnRmcG9uIDIxMjYyMA=='},
                                                                                                          {       'in_nucast_pkts': '4537',
                                                                                                                  'in_octets': '62880495403',
                                                                                                                  'in_ucast_pkts': '431543762',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '27178',
                                                                                                                  'out_octets': '2258755300996',
                                                                                                                  'out_ucast_pkts': '1592294960',
                                                                                                                  'poller_hash': 'QkYyNDJBcGVlcmludGZwb24gMjEzMjM4'},
                                                                                                          {       'in_nucast_pkts': '84025',
                                                                                                                  'in_octets': '7939589484',
                                                                                                                  'in_ucast_pkts': '17104345',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2786794',
                                                                                                                  'out_octets': '115520903609',
                                                                                                                  'out_ucast_pkts': '94785870',
                                                                                                                  'poller_hash': 'MTI3NDlEMXBlZXJpbnRmcG9uIDIzMjMyOQ=='},
                                                                                                          {       'in_nucast_pkts': '70143',
                                                                                                                  'in_octets': '6970092757',
                                                                                                                  'in_ucast_pkts': '75585194',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '691022',
                                                                                                                  'out_octets': '466131230503',
                                                                                                                  'out_ucast_pkts': '312131632',
                                                                                                                  'poller_hash': 'MTI3NEFBNnBlZXJpbnRmcG9uIDIzNDg2NA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '521541249743',
                                                                                         'out_octets': '1096092688140519',
                                                                                         'out_ucast_pkts': '283213548039',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzE=',
                                                                                         'pons': [       {       'id': '2/1',
                                                                                                                 'links': [       {       'connected_time': '15351444',
                                                                                                                                          'fiber_length': 1149,
                                                                                                                                          'poller_hash': 'NTU2M0FCcGVlcnBvbnBvbiAyNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18904068',
                                                                                                                                          'fiber_length': 906,
                                                                                                                                          'poller_hash': 'NEQ0MjNEcGVlcnBvbnBvbiAyNTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18904060',
                                                                                                                                          'fiber_length': 985,
                                                                                                                                          'poller_hash': 'QzUwMTBwZWVycG9ucG9uIDI1NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '15776407',
                                                                                                                                          'fiber_length': 911,
                                                                                                                                          'poller_hash': 'NEQ0MUY3cGVlcnBvbnBvbiAyNTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18904004',
                                                                                                                                          'fiber_length': 949,
                                                                                                                                          'poller_hash': 'QkYxRTFCcGVlcnBvbnBvbiAyNTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18904116',
                                                                                                                                          'fiber_length': 805,
                                                                                                                                          'poller_hash': 'M0ZGRkUzcGVlcnBvbnBvbiAyNjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18904085',
                                                                                                                                          'fiber_length': 712,
                                                                                                                                          'poller_hash': 'NDE4QjdwZWVycG9ucG9uIDI2Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '3448231',
                                                                                                                                          'fiber_length': 841,
                                                                                                                                          'poller_hash': 'MjNBMDAzcGVlcnBvbnBvbiAyNjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '3448262',
                                                                                                                                          'fiber_length': 1421,
                                                                                                                                          'poller_hash': 'NTU1Q0I4cGVlcnBvbnBvbiAyNjk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18904210',
                                                                                                                                          'fiber_length': 967,
                                                                                                                                          'poller_hash': 'MkZDQzMxcGVlcnBvbnBvbiAyNzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18903818',
                                                                                                                                          'fiber_length': 611,
                                                                                                                                          'poller_hash': 'RjIzQTVwZWVycG9ucG9uIDI3MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18904062',
                                                                                                                                          'fiber_length': 588,
                                                                                                                                          'poller_hash': 'MTk5OUY3cGVlcnBvbnBvbiAyNzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '3448218',
                                                                                                                                          'fiber_length': 588,
                                                                                                                                          'poller_hash': 'MTI0ODQ1cGVlcnBvbnBvbiAyNzM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18904003',
                                                                                                                                          'fiber_length': 736,
                                                                                                                                          'poller_hash': 'MTk5OUUxcGVlcnBvbnBvbiAyNzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '10849425',
                                                                                                                                          'fiber_length': 623,
                                                                                                                                          'poller_hash': 'NEQ0MjQycGVlcnBvbnBvbiAyNzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18904038',
                                                                                                                                          'fiber_length': 630,
                                                                                                                                          'poller_hash': 'NDAwN0ZGcGVlcnBvbnBvbiAyNzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '3448256',
                                                                                                                                          'fiber_length': 628,
                                                                                                                                          'poller_hash': 'NzIyMDQxcGVlcnBvbnBvbiAyNzc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18919192',
                                                                                                                                          'fiber_length': 1215,
                                                                                                                                          'poller_hash': 'QTlDOTMxcGVlcnBvbnBvbiAxNTY0NTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '18919176',
                                                                                                                                          'fiber_length': 1042,
                                                                                                                                          'poller_hash': 'QzgzRTBBcGVlcnBvbnBvbiAxNjE2MDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '3448340',
                                                                                                                                          'fiber_length': 1256,
                                                                                                                                          'poller_hash': 'QzgzQkFCcGVlcnBvbnBvbiAxNjQyMDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '3448376',
                                                                                                                                          'fiber_length': 1017,
                                                                                                                                          'poller_hash': 'MTE5NTE1QnBlZXJwb25wb24gMjEyNjIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '3245793',
                                                                                                                                          'fiber_length': 777,
                                                                                                                                          'poller_hash': 'QkYyNDJBcGVlcnBvbnBvbiAyMTMyMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '3448385',
                                                                                                                                          'fiber_length': 904,
                                                                                                                                          'poller_hash': 'MTI3NDlEMXBlZXJwb25wb24gMjMyMzI5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64},
                                                                                                                                  {       'connected_time': '464130',
                                                                                                                                          'fiber_length': 907,
                                                                                                                                          'poller_hash': 'MTI3NEFBNnBlZXJwb25wb24gMjM0ODY0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.64}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/1',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/2',
                                                                                         'in_discards': '134874',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16233212',
                                                                                         'in_octets': '18626921362516',
                                                                                         'in_ucast_pkts': '90499365003',
                                                                                         'links': [       {       'in_nucast_pkts': '10',
                                                                                                                  'in_octets': '18315581975',
                                                                                                                  'in_ucast_pkts': '99317708',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062465',
                                                                                                                  'out_octets': '383804204597',
                                                                                                                  'out_ucast_pkts': '276082426',
                                                                                                                  'poller_hash': 'NDNDM0REcGVlcmludGZwb24gNw=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'NDE1M0NwZWVyaW50ZnBvbiAyNzg='},
                                                                                                          {       'in_nucast_pkts': '21266752',
                                                                                                                  'in_octets': '295568613030',
                                                                                                                  'in_ucast_pkts': '1961733117',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '24137541680',
                                                                                                                  'out_octets': '41067321058551',
                                                                                                                  'out_ucast_pkts': '6653645464',
                                                                                                                  'poller_hash': 'MjVEOEFFcGVlcmludGZwb24gMjc5'},
                                                                                                          {       'in_nucast_pkts': '62868',
                                                                                                                  'in_octets': '75412852040',
                                                                                                                  'in_ucast_pkts': '425687963',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1971055',
                                                                                                                  'out_octets': '1600010829722',
                                                                                                                  'out_ucast_pkts': '1103400634',
                                                                                                                  'poller_hash': 'QzgxRjQycGVlcmludGZwb24gMjgw'},
                                                                                                          {       'in_nucast_pkts': '14742315',
                                                                                                                  'in_octets': '83601629371',
                                                                                                                  'in_ucast_pkts': '9041301373',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2377912301',
                                                                                                                  'out_octets': '4206416097087',
                                                                                                                  'out_ucast_pkts': '91276510088',
                                                                                                                  'poller_hash': 'NDE4QjhwZWVyaW50ZnBvbiAyODE='},
                                                                                                          {       'in_nucast_pkts': '503438',
                                                                                                                  'in_octets': '134725127869',
                                                                                                                  'in_ucast_pkts': '651111701',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9757297',
                                                                                                                  'out_octets': '4140016260523',
                                                                                                                  'out_ucast_pkts': '3124639095',
                                                                                                                  'poller_hash': 'OTU2RjIycGVlcmludGZwb24gMjgy'},
                                                                                                          {       'in_nucast_pkts': '23955965',
                                                                                                                  'in_octets': '192253128279',
                                                                                                                  'in_ucast_pkts': '1299080967',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '24135349',
                                                                                                                  'out_octets': '4310743025779',
                                                                                                                  'out_ucast_pkts': '3042515893',
                                                                                                                  'poller_hash': 'MkNBMzBEcGVlcmludGZwb24gMjg0'},
                                                                                                          {       'in_nucast_pkts': '5231',
                                                                                                                  'in_octets': '139302966986',
                                                                                                                  'in_ucast_pkts': '979223715',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1625323',
                                                                                                                  'out_octets': '3929524434422',
                                                                                                                  'out_ucast_pkts': '2841494411',
                                                                                                                  'poller_hash': 'MzI5NTRGcGVlcmludGZwb24gMjg1'},
                                                                                                          {       'in_nucast_pkts': '15',
                                                                                                                  'in_octets': '3496457147',
                                                                                                                  'in_ucast_pkts': '18544508',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062593',
                                                                                                                  'out_octets': '32275609415',
                                                                                                                  'out_ucast_pkts': '30858081',
                                                                                                                  'poller_hash': 'MTk5QTJEcGVlcmludGZwb24gMjg3'},
                                                                                                          {       'in_nucast_pkts': '137535',
                                                                                                                  'in_octets': '186078376390',
                                                                                                                  'in_ucast_pkts': '725641435',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1647317',
                                                                                                                  'out_octets': '4490614597654',
                                                                                                                  'out_ucast_pkts': '3266415621',
                                                                                                                  'poller_hash': 'MkZFOUYzcGVlcmludGZwb24gMjg4'},
                                                                                                          {       'in_nucast_pkts': '19169412',
                                                                                                                  'in_octets': '64947371029',
                                                                                                                  'in_ucast_pkts': '355492873',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '21087296537',
                                                                                                                  'out_octets': '29854278894983',
                                                                                                                  'out_ucast_pkts': '1149326388',
                                                                                                                  'poller_hash': 'MTY0MjgxcGVlcmludGZwb24gMjg5'},
                                                                                                          {       'in_nucast_pkts': '1339287',
                                                                                                                  'in_octets': '10323625703',
                                                                                                                  'in_ucast_pkts': '36769884',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '596483475',
                                                                                                                  'out_octets': '896721763252',
                                                                                                                  'out_ucast_pkts': '4435481629',
                                                                                                                  'poller_hash': 'NDE1MzVwZWVyaW50ZnBvbiAyOTE='},
                                                                                                          {       'in_nucast_pkts': '193',
                                                                                                                  'in_octets': '248871873079',
                                                                                                                  'in_ucast_pkts': '798075032',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1466061',
                                                                                                                  'out_octets': '2734231310454',
                                                                                                                  'out_ucast_pkts': '2053559053',
                                                                                                                  'poller_hash': 'MzhGMUVBcGVlcmludGZwb24gMjkz'},
                                                                                                          {       'in_nucast_pkts': '60624',
                                                                                                                  'in_octets': '371487027332',
                                                                                                                  'in_ucast_pkts': '2241116832',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1646524',
                                                                                                                  'out_octets': '6604502997468',
                                                                                                                  'out_ucast_pkts': '5024909386',
                                                                                                                  'poller_hash': 'MkVEMDNGcGVlcmludGZwb24gMjk0'},
                                                                                                          {       'in_nucast_pkts': '5890491',
                                                                                                                  'in_octets': '13989262136',
                                                                                                                  'in_ucast_pkts': '158063671',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12540248117',
                                                                                                                  'out_octets': '17829849641168',
                                                                                                                  'out_ucast_pkts': '64424509440',
                                                                                                                  'poller_hash': 'M0QwRkFwZWVyaW50ZnBvbiAyOTU='},
                                                                                                          {       'in_nucast_pkts': '9660',
                                                                                                                  'in_octets': '585484276364',
                                                                                                                  'in_ucast_pkts': '3247590118',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1647916',
                                                                                                                  'out_octets': '15845564209355',
                                                                                                                  'out_ucast_pkts': '10931126039',
                                                                                                                  'poller_hash': 'MTJGRkREcGVlcmludGZwb24gMjk2'},
                                                                                                          {       'in_nucast_pkts': '9130',
                                                                                                                  'in_octets': '44739611140',
                                                                                                                  'in_ucast_pkts': '137480533',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062379',
                                                                                                                  'out_octets': '718036726499',
                                                                                                                  'out_ucast_pkts': '535599617',
                                                                                                                  'poller_hash': 'NzU3QkJwZWVyaW50ZnBvbiAyOTc='},
                                                                                                          {       'in_nucast_pkts': '61679',
                                                                                                                  'in_octets': '40813066865',
                                                                                                                  'in_ucast_pkts': '195763057',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9760959',
                                                                                                                  'out_octets': '563055545003',
                                                                                                                  'out_ucast_pkts': '458903294',
                                                                                                                  'poller_hash': 'QzgzQkYzcGVlcmludGZwb24gMjk4'},
                                                                                                          {       'in_nucast_pkts': '1948994',
                                                                                                                  'in_octets': '22300151276',
                                                                                                                  'in_ucast_pkts': '73015227',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1733905199',
                                                                                                                  'out_octets': '2492150408815',
                                                                                                                  'out_ucast_pkts': '255883163',
                                                                                                                  'poller_hash': 'NDMzRTVGcGVlcmludGZwb24gMjk5'},
                                                                                                          {       'in_nucast_pkts': '17300849',
                                                                                                                  'in_octets': '76848369437',
                                                                                                                  'in_ucast_pkts': '181572020',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '29427260794',
                                                                                                                  'out_octets': '40437659831950',
                                                                                                                  'out_ucast_pkts': '961014393',
                                                                                                                  'poller_hash': 'MzI5NjM2cGVlcmludGZwb24gMzAw'},
                                                                                                          {       'in_nucast_pkts': '4787',
                                                                                                                  'in_octets': '34734627967',
                                                                                                                  'in_ucast_pkts': '105772555',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1053164',
                                                                                                                  'out_octets': '311012127635',
                                                                                                                  'out_ucast_pkts': '238960925',
                                                                                                                  'poller_hash': 'MUM0REE5cGVlcmludGZwb24gMzAy'},
                                                                                                          {       'in_nucast_pkts': '2832992',
                                                                                                                  'in_octets': '84793888340',
                                                                                                                  'in_ucast_pkts': '536254835',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1646762',
                                                                                                                  'out_octets': '1614199484183',
                                                                                                                  'out_ucast_pkts': '1155251793',
                                                                                                                  'poller_hash': 'NzIxRDFDcGVlcmludGZwb24gMzAz'},
                                                                                                          {       'in_nucast_pkts': '137713',
                                                                                                                  'in_octets': '158459589746',
                                                                                                                  'in_ucast_pkts': '736852457',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1626952',
                                                                                                                  'out_octets': '3749563322401',
                                                                                                                  'out_ucast_pkts': '2765400844',
                                                                                                                  'poller_hash': 'NTU2M0YwcGVlcmludGZwb24gMzA0'},
                                                                                                          {       'in_nucast_pkts': '2811679',
                                                                                                                  'in_octets': '42689955638',
                                                                                                                  'in_ucast_pkts': '171879406',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7198641622',
                                                                                                                  'out_octets': '9937333651004',
                                                                                                                  'out_ucast_pkts': '371173140',
                                                                                                                  'poller_hash': 'QzgxRERCcGVlcmludGZwb24gMTM4MDA3'},
                                                                                                          {       'in_nucast_pkts': '3250323',
                                                                                                                  'in_octets': '124789639464',
                                                                                                                  'in_ucast_pkts': '450668320',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '157418',
                                                                                                                  'out_octets': '2036137670445',
                                                                                                                  'out_ucast_pkts': '1536177191',
                                                                                                                  'poller_hash': 'MzhGMThCcGVlcmludGZwb24gMTY2NzY4'},
                                                                                                          {       'in_nucast_pkts': '83207199',
                                                                                                                  'in_octets': '15195208833',
                                                                                                                  'in_ucast_pkts': '31354736',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1105074237',
                                                                                                                  'out_octets': '1468447328691',
                                                                                                                  'out_ucast_pkts': '64157156',
                                                                                                                  'poller_hash': 'QzgxRTNGcGVlcmludGZwb24gMjA3MzYy'},
                                                                                                          {       'in_nucast_pkts': '17880077',
                                                                                                                  'in_octets': '286765716617',
                                                                                                                  'in_ucast_pkts': '530809369',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4984557443',
                                                                                                                  'out_octets': '7378116326338',
                                                                                                                  'out_ucast_pkts': '1161302292',
                                                                                                                  'poller_hash': 'QzgxREI3cGVlcmludGZwb24gMjA3ODMw'},
                                                                                                          {       'in_nucast_pkts': '2931810',
                                                                                                                  'in_octets': '888480923',
                                                                                                                  'in_ucast_pkts': '3253011',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8986594508',
                                                                                                                  'out_octets': '11923618420906',
                                                                                                                  'out_ucast_pkts': '2390343',
                                                                                                                  'poller_hash': 'MTI3NTE4Q3BlZXJpbnRmcG9uIDIyMTExMA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '532706384289',
                                                                                         'out_octets': '1086358943883547',
                                                                                         'out_ucast_pkts': '265893161528',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzI=',
                                                                                         'pons': [       {       'id': '2/2',
                                                                                                                 'links': [       {       'connected_time': '3448070',
                                                                                                                                          'fiber_length': 1302,
                                                                                                                                          'poller_hash': 'NDNDM0REcGVlcnBvbnBvbiA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18904094',
                                                                                                                                          'fiber_length': 432,
                                                                                                                                          'poller_hash': 'NDE1M0NwZWVycG9ucG9uIDI3OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18903722',
                                                                                                                                          'fiber_length': 519,
                                                                                                                                          'poller_hash': 'MjVEOEFFcGVlcnBvbnBvbiAyNzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '2442708',
                                                                                                                                          'fiber_length': 600,
                                                                                                                                          'poller_hash': 'QzgxRjQycGVlcnBvbnBvbiAyODA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18904083',
                                                                                                                                          'fiber_length': 432,
                                                                                                                                          'poller_hash': 'NDE4QjhwZWVycG9ucG9uIDI4MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18919269',
                                                                                                                                          'fiber_length': 644,
                                                                                                                                          'poller_hash': 'OTU2RjIycGVlcnBvbnBvbiAyODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18903813',
                                                                                                                                          'fiber_length': 445,
                                                                                                                                          'poller_hash': 'MkNBMzBEcGVlcnBvbnBvbiAyODQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18904088',
                                                                                                                                          'fiber_length': 469,
                                                                                                                                          'poller_hash': 'MzI5NTRGcGVlcnBvbnBvbiAyODU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '3448292',
                                                                                                                                          'fiber_length': 542,
                                                                                                                                          'poller_hash': 'MTk5QTJEcGVlcnBvbnBvbiAyODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18904137',
                                                                                                                                          'fiber_length': 1385,
                                                                                                                                          'poller_hash': 'MkZFOUYzcGVlcnBvbnBvbiAyODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18904170',
                                                                                                                                          'fiber_length': 1386,
                                                                                                                                          'poller_hash': 'MTY0MjgxcGVlcnBvbnBvbiAyODk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '3448243',
                                                                                                                                          'fiber_length': 1310,
                                                                                                                                          'poller_hash': 'NDE1MzVwZWVycG9ucG9uIDI5MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '12903395',
                                                                                                                                          'fiber_length': 1246,
                                                                                                                                          'poller_hash': 'MzhGMUVBcGVlcnBvbnBvbiAyOTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18891800',
                                                                                                                                          'fiber_length': 1254,
                                                                                                                                          'poller_hash': 'MkVEMDNGcGVlcnBvbnBvbiAyOTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18903854',
                                                                                                                                          'fiber_length': 1144,
                                                                                                                                          'poller_hash': 'M0QwRkFwZWVycG9ucG9uIDI5NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18903971',
                                                                                                                                          'fiber_length': 1262,
                                                                                                                                          'poller_hash': 'MTJGRkREcGVlcnBvbnBvbiAyOTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '3448378',
                                                                                                                                          'fiber_length': 1209,
                                                                                                                                          'poller_hash': 'NzU3QkJwZWVycG9ucG9uIDI5Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18919276',
                                                                                                                                          'fiber_length': 1469,
                                                                                                                                          'poller_hash': 'QzgzQkYzcGVlcnBvbnBvbiAyOTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '3448328',
                                                                                                                                          'fiber_length': 1380,
                                                                                                                                          'poller_hash': 'NDMzRTVGcGVlcnBvbnBvbiAyOTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18904138',
                                                                                                                                          'fiber_length': 1436,
                                                                                                                                          'poller_hash': 'MzI5NjM2cGVlcnBvbnBvbiAzMDA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '3415281',
                                                                                                                                          'fiber_length': 1129,
                                                                                                                                          'poller_hash': 'MUM0REE5cGVlcnBvbnBvbiAzMDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18903887',
                                                                                                                                          'fiber_length': 1075,
                                                                                                                                          'poller_hash': 'NzIxRDFDcGVlcnBvbnBvbiAzMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18649838',
                                                                                                                                          'fiber_length': 1080,
                                                                                                                                          'poller_hash': 'NTU2M0YwcGVlcnBvbnBvbiAzMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '3448371',
                                                                                                                                          'fiber_length': 577,
                                                                                                                                          'poller_hash': 'QzgxRERCcGVlcnBvbnBvbiAxMzgwMDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18904009',
                                                                                                                                          'fiber_length': 1421,
                                                                                                                                          'poller_hash': 'MzhGMThCcGVlcnBvbnBvbiAxNjY3Njg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '3448345',
                                                                                                                                          'fiber_length': 688,
                                                                                                                                          'poller_hash': 'QzgxRTNGcGVlcnBvbnBvbiAyMDczNjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '18919337',
                                                                                                                                          'fiber_length': 1454,
                                                                                                                                          'poller_hash': 'QzgxREI3cGVlcnBvbnBvbiAyMDc4MzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711},
                                                                                                                                  {       'connected_time': '11095950',
                                                                                                                                          'fiber_length': 1569,
                                                                                                                                          'poller_hash': 'MTI3NTE4Q3BlZXJwb25wb24gMjIxMTEw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.711}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/2',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/3',
                                                                                         'in_discards': '131283',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '24912873',
                                                                                         'in_octets': '24582239667651',
                                                                                         'in_ucast_pkts': '95320749784',
                                                                                         'links': [       {       'oper_up': False,
                                                                                                                  'poller_hash': 'NTEyNTg5cGVlcmludGZwb24gNDE='},
                                                                                                          {       'in_nucast_pkts': '117958',
                                                                                                                  'in_octets': '104002344971',
                                                                                                                  'in_ucast_pkts': '329684209',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062569',
                                                                                                                  'out_octets': '1176562324094',
                                                                                                                  'out_ucast_pkts': '933128248',
                                                                                                                  'poller_hash': 'MkFBODc4cGVlcmludGZwb24gMjM0'},
                                                                                                          {       'in_nucast_pkts': '814930',
                                                                                                                  'in_octets': '10774613826',
                                                                                                                  'in_ucast_pkts': '8624595774',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1550998',
                                                                                                                  'out_octets': '59105176993',
                                                                                                                  'out_ucast_pkts': '56807058',
                                                                                                                  'poller_hash': 'MTM1NDhwZWVyaW50ZnBvbiAyODY='},
                                                                                                          {       'in_nucast_pkts': '20152496',
                                                                                                                  'in_octets': '182737681880',
                                                                                                                  'in_ucast_pkts': '702214679',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26535535877',
                                                                                                                  'out_octets': '37819108060514',
                                                                                                                  'out_ucast_pkts': '1914002933',
                                                                                                                  'poller_hash': 'MzhGMTExcGVlcmludGZwb24gMzA2'},
                                                                                                          {       'in_nucast_pkts': '3456088',
                                                                                                                  'in_octets': '8312622769',
                                                                                                                  'in_ucast_pkts': '23158330',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5567791811',
                                                                                                                  'out_octets': '7554479799768',
                                                                                                                  'out_ucast_pkts': '51066563',
                                                                                                                  'poller_hash': 'NDAwOERDcGVlcmludGZwb24gMzA3'},
                                                                                                          {       'in_nucast_pkts': '5540840',
                                                                                                                  'in_octets': '299836027156',
                                                                                                                  'in_ucast_pkts': '2040392991',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14126458599',
                                                                                                                  'out_octets': '26525014613008',
                                                                                                                  'out_ucast_pkts': '5551108251',
                                                                                                                  'poller_hash': 'MTMwMDhEcGVlcmludGZwb24gMzA4'},
                                                                                                          {       'in_nucast_pkts': '703542',
                                                                                                                  'in_octets': '171295580',
                                                                                                                  'in_ucast_pkts': '640721',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '312206808',
                                                                                                                  'out_octets': '366013766997',
                                                                                                                  'out_ucast_pkts': '475045',
                                                                                                                  'poller_hash': 'MTk5OUY2cGVlcmludGZwb24gMzA5'},
                                                                                                          {       'in_nucast_pkts': '7838751',
                                                                                                                  'in_octets': '236938638717',
                                                                                                                  'in_ucast_pkts': '1762101147',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1247694671',
                                                                                                                  'out_octets': '6331036871488',
                                                                                                                  'out_ucast_pkts': '3773149623',
                                                                                                                  'poller_hash': 'MkM5QTBFcGVlcmludGZwb24gMzEw'},
                                                                                                          {       'in_nucast_pkts': '17884',
                                                                                                                  'in_octets': '1136692943566',
                                                                                                                  'in_ucast_pkts': '2373808768',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '127385',
                                                                                                                  'out_octets': '6142169215693',
                                                                                                                  'out_ucast_pkts': '4856928698',
                                                                                                                  'poller_hash': 'MjQ4QUQycGVlcmludGZwb24gMzEy'},
                                                                                                          {       'in_nucast_pkts': '9510897',
                                                                                                                  'in_octets': '19441417901',
                                                                                                                  'in_ucast_pkts': '126562112',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '27461521765',
                                                                                                                  'out_octets': '37188768262218',
                                                                                                                  'out_ucast_pkts': '472782593',
                                                                                                                  'poller_hash': 'QzgzMDkzcGVlcmludGZwb24gMzEz'},
                                                                                                          {       'in_nucast_pkts': '33',
                                                                                                                  'in_octets': '12649722671',
                                                                                                                  'in_ucast_pkts': '40266338',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2784697',
                                                                                                                  'out_octets': '198228666725',
                                                                                                                  'out_ucast_pkts': '155318662',
                                                                                                                  'poller_hash': 'ODcyNEZDcGVlcmludGZwb24gMzE0'},
                                                                                                          {       'in_nucast_pkts': '10494443',
                                                                                                                  'in_octets': '384606822066',
                                                                                                                  'in_ucast_pkts': '1422017217',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5579069813',
                                                                                                                  'out_octets': '11478891783830',
                                                                                                                  'out_ucast_pkts': '3606317208',
                                                                                                                  'poller_hash': 'ODZCOEJwZWVyaW50ZnBvbiAzMTU='},
                                                                                                          {       'in_nucast_pkts': '9666',
                                                                                                                  'in_octets': '93387490707',
                                                                                                                  'in_ucast_pkts': '416039753',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1647908',
                                                                                                                  'out_octets': '2016872774789',
                                                                                                                  'out_ucast_pkts': '1482198610',
                                                                                                                  'poller_hash': 'NzIzNjRFcGVlcmludGZwb24gMzE2'},
                                                                                                          {       'in_nucast_pkts': '85314',
                                                                                                                  'in_octets': '20945408397',
                                                                                                                  'in_ucast_pkts': '97807228',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062540',
                                                                                                                  'out_octets': '780221489785',
                                                                                                                  'out_ucast_pkts': '582470823',
                                                                                                                  'poller_hash': 'MTc2MjEwcGVlcmludGZwb24gMzE3'},
                                                                                                          {       'in_nucast_pkts': '5933725',
                                                                                                                  'in_octets': '1123199176671',
                                                                                                                  'in_ucast_pkts': '1963593835',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10265101590',
                                                                                                                  'out_octets': '19067006279571',
                                                                                                                  'out_ucast_pkts': '4076045063',
                                                                                                                  'poller_hash': 'NzZFOUJBcGVlcmludGZwb24gMzE4'},
                                                                                                          {       'in_nucast_pkts': '5466915',
                                                                                                                  'in_octets': '10571753299',
                                                                                                                  'in_ucast_pkts': '43717577',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12629531136',
                                                                                                                  'out_octets': '16861671901750',
                                                                                                                  'out_ucast_pkts': '95510512',
                                                                                                                  'poller_hash': 'NEQ0MjREcGVlcmludGZwb24gMzE5'},
                                                                                                          {       'in_nucast_pkts': '6643',
                                                                                                                  'in_octets': '311393252545',
                                                                                                                  'in_ucast_pkts': '1310090036',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1646578',
                                                                                                                  'out_octets': '5849703235564',
                                                                                                                  'out_ucast_pkts': '4496221182',
                                                                                                                  'poller_hash': 'MjQ4QUM2cGVlcmludGZwb24gMzIw'},
                                                                                                          {       'in_nucast_pkts': '82287',
                                                                                                                  'in_octets': '44002090014',
                                                                                                                  'in_ucast_pkts': '164630607',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2786732',
                                                                                                                  'out_octets': '800499672737',
                                                                                                                  'out_ucast_pkts': '598840749',
                                                                                                                  'poller_hash': 'NUE2QzkycGVlcmludGZwb24gMTM5MTkw'},
                                                                                                          {       'in_nucast_pkts': '922650',
                                                                                                                  'in_octets': '27158937149',
                                                                                                                  'in_ucast_pkts': '142671663',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2633576173',
                                                                                                                  'out_octets': '3944938392444',
                                                                                                                  'out_ucast_pkts': '299919063',
                                                                                                                  'poller_hash': 'Q0JEMjlBcGVlcmludGZwb24gMTY1MDUw'},
                                                                                                          {       'in_nucast_pkts': '60744',
                                                                                                                  'in_octets': '48282960956',
                                                                                                                  'in_ucast_pkts': '288971490',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3888508',
                                                                                                                  'out_octets': '833541946025',
                                                                                                                  'out_ucast_pkts': '606196942',
                                                                                                                  'poller_hash': 'QzgzQkEzcGVlcmludGZwb24gMTY4NTY0'},
                                                                                                          {       'in_nucast_pkts': '81302',
                                                                                                                  'in_octets': '6788625957',
                                                                                                                  'in_ucast_pkts': '28583755',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062595',
                                                                                                                  'out_octets': '186603821658',
                                                                                                                  'out_ucast_pkts': '155084882',
                                                                                                                  'poller_hash': 'NzIzQTEwcGVlcmludGZwb24gMTcxNzE5'},
                                                                                                          {       'in_nucast_pkts': '846238',
                                                                                                                  'in_octets': '6709686678',
                                                                                                                  'in_ucast_pkts': '45756261',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '245938631',
                                                                                                                  'out_octets': '507881190044',
                                                                                                                  'out_ucast_pkts': '199850661',
                                                                                                                  'poller_hash': 'QzgzQkRBcGVlcmludGZwb24gMTcxOTg3'},
                                                                                                          {       'in_nucast_pkts': '1824306',
                                                                                                                  'in_octets': '97566503159',
                                                                                                                  'in_ucast_pkts': '296749642',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4515158777',
                                                                                                                  'out_octets': '7026797879671',
                                                                                                                  'out_ucast_pkts': '811846789',
                                                                                                                  'poller_hash': 'QzgzQjlDcGVlcmludGZwb24gMTkzNjIy'},
                                                                                                          {       'in_nucast_pkts': '8601',
                                                                                                                  'in_octets': '7244494459',
                                                                                                                  'in_ucast_pkts': '43091878',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '309559',
                                                                                                                  'out_octets': '145852554563',
                                                                                                                  'out_ucast_pkts': '106356523',
                                                                                                                  'poller_hash': 'MTFCMjVBOXBlZXJpbnRmcG9uIDIxNTc4Mw=='},
                                                                                                          {       'in_nucast_pkts': '20098',
                                                                                                                  'in_octets': '46657288650',
                                                                                                                  'in_ucast_pkts': '287478343',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3740684',
                                                                                                                  'out_octets': '2028346328093',
                                                                                                                  'out_ucast_pkts': '1417773968',
                                                                                                                  'poller_hash': 'RUJDMkVFcGVlcmludGZwb24gMjMxMzg4'},
                                                                                                          {       'in_nucast_pkts': '46668',
                                                                                                                  'in_octets': '1234771858',
                                                                                                                  'in_ucast_pkts': '2130312',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '100727',
                                                                                                                  'out_octets': '6395057614',
                                                                                                                  'out_ucast_pkts': '4511532',
                                                                                                                  'poller_hash': 'MTI3NEEzMHBlZXJpbnRmcG9uIDIzNDgyNA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '440902427736',
                                                                                         'out_octets': '959554986542204',
                                                                                         'out_ucast_pkts': '266080625295',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzM=',
                                                                                         'pons': [       {       'id': '2/3',
                                                                                                                 'links': [       {       'poller_hash': 'NTEyNTg5cGVlcnBvbnBvbiA0MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '3448232',
                                                                                                                                          'fiber_length': 1157,
                                                                                                                                          'poller_hash': 'MkFBODc4cGVlcnBvbnBvbiAyMzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '3448204',
                                                                                                                                          'fiber_length': 384,
                                                                                                                                          'poller_hash': 'MTM1NDhwZWVycG9ucG9uIDI4Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '18903999',
                                                                                                                                          'fiber_length': 924,
                                                                                                                                          'poller_hash': 'MzhGMTExcGVlcnBvbnBvbiAzMDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '3448286',
                                                                                                                                          'fiber_length': 1238,
                                                                                                                                          'poller_hash': 'NDAwOERDcGVlcnBvbnBvbiAzMDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '18904313',
                                                                                                                                          'fiber_length': 1016,
                                                                                                                                          'poller_hash': 'MTMwMDhEcGVlcnBvbnBvbiAzMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '1945662',
                                                                                                                                          'fiber_length': 996,
                                                                                                                                          'poller_hash': 'MTk5OUY2cGVlcnBvbnBvbiAzMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '18904093',
                                                                                                                                          'fiber_length': 985,
                                                                                                                                          'poller_hash': 'MkM5QTBFcGVlcnBvbnBvbiAzMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '15251720',
                                                                                                                                          'fiber_length': 859,
                                                                                                                                          'poller_hash': 'MjQ4QUQycGVlcnBvbnBvbiAzMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '18919207',
                                                                                                                                          'fiber_length': 952,
                                                                                                                                          'poller_hash': 'QzgzMDkzcGVlcnBvbnBvbiAzMTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '3448319',
                                                                                                                                          'fiber_length': 1002,
                                                                                                                                          'poller_hash': 'ODcyNEZDcGVlcnBvbnBvbiAzMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '18904008',
                                                                                                                                          'fiber_length': 824,
                                                                                                                                          'poller_hash': 'ODZCOEJwZWVycG9ucG9uIDMxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '18904139',
                                                                                                                                          'fiber_length': 899,
                                                                                                                                          'poller_hash': 'NzIzNjRFcGVlcnBvbnBvbiAzMTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '3448275',
                                                                                                                                          'fiber_length': 717,
                                                                                                                                          'poller_hash': 'MTc2MjEwcGVlcnBvbnBvbiAzMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '18904060',
                                                                                                                                          'fiber_length': 780,
                                                                                                                                          'poller_hash': 'NzZFOUJBcGVlcnBvbnBvbiAzMTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '18904168',
                                                                                                                                          'fiber_length': 666,
                                                                                                                                          'poller_hash': 'NEQ0MjREcGVlcnBvbnBvbiAzMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '18904441',
                                                                                                                                          'fiber_length': 1276,
                                                                                                                                          'poller_hash': 'MjQ4QUM2cGVlcnBvbnBvbiAzMjA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '3448429',
                                                                                                                                          'fiber_length': 1054,
                                                                                                                                          'poller_hash': 'NUE2QzkycGVlcnBvbnBvbiAxMzkxOTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '1739818',
                                                                                                                                          'fiber_length': 1326,
                                                                                                                                          'poller_hash': 'Q0JEMjlBcGVlcnBvbnBvbiAxNjUwNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '7547994',
                                                                                                                                          'fiber_length': 1019,
                                                                                                                                          'poller_hash': 'QzgzQkEzcGVlcnBvbnBvbiAxNjg1NjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '3448344',
                                                                                                                                          'fiber_length': 1006,
                                                                                                                                          'poller_hash': 'NzIzQTEwcGVlcnBvbnBvbiAxNzE3MTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '3448351',
                                                                                                                                          'fiber_length': 1384,
                                                                                                                                          'poller_hash': 'QzgzQkRBcGVlcnBvbnBvbiAxNzE5ODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '3448411',
                                                                                                                                          'fiber_length': 1244,
                                                                                                                                          'poller_hash': 'QzgzQjlDcGVlcnBvbnBvbiAxOTM2MjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '382651',
                                                                                                                                          'fiber_length': 889,
                                                                                                                                          'poller_hash': 'MTFCMjVBOXBlZXJwb25wb24gMjE1Nzgz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '5289041',
                                                                                                                                          'fiber_length': 1055,
                                                                                                                                          'poller_hash': 'RUJDMkVFcGVlcnBvbnBvbiAyMzEzODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998},
                                                                                                                                  {       'connected_time': '548551',
                                                                                                                                          'fiber_length': 1256,
                                                                                                                                          'poller_hash': 'MTI3NEEzMHBlZXJwb25wb24gMjM0ODI0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.998}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/3',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/4',
                                                                                         'in_discards': '152346',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '7548886',
                                                                                         'in_octets': '24436563363764',
                                                                                         'in_ucast_pkts': '81051920024',
                                                                                         'links': [       {       'in_nucast_pkts': '18560',
                                                                                                                  'in_octets': '29739080971',
                                                                                                                  'in_ucast_pkts': '225324709',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5631296',
                                                                                                                  'out_octets': '1112215632120',
                                                                                                                  'out_ucast_pkts': '765362833',
                                                                                                                  'poller_hash': 'MzIyODY1cGVlcmludGZwb24gMjM='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'RjBGOHBlZXJpbnRmcG9uIDEyMw=='},
                                                                                                          {       'in_nucast_pkts': '3267561',
                                                                                                                  'in_octets': '31345001088',
                                                                                                                  'in_ucast_pkts': '123443736',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3884215192',
                                                                                                                  'out_octets': '5467686800602',
                                                                                                                  'out_ucast_pkts': '290177945',
                                                                                                                  'poller_hash': 'NDI4MTZFcGVlcmludGZwb24gMjMx'},
                                                                                                          {       'in_nucast_pkts': '1121220',
                                                                                                                  'in_octets': '1349909845',
                                                                                                                  'in_ucast_pkts': '5187452',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '304281227',
                                                                                                                  'out_octets': '322504014659',
                                                                                                                  'out_ucast_pkts': '11866118',
                                                                                                                  'poller_hash': 'MUY3REExcGVlcmludGZwb24gMjMy'},
                                                                                                          {       'in_nucast_pkts': '3880',
                                                                                                                  'in_octets': '6528237628',
                                                                                                                  'in_ucast_pkts': '34082202',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062542',
                                                                                                                  'out_octets': '254746884017',
                                                                                                                  'out_ucast_pkts': '179418301',
                                                                                                                  'poller_hash': 'MkFBOTQ2cGVlcmludGZwb24gMjMz'},
                                                                                                          {       'in_nucast_pkts': '189',
                                                                                                                  'in_octets': '27806397977',
                                                                                                                  'in_ucast_pkts': '53646487',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2470',
                                                                                                                  'out_octets': '199455608319',
                                                                                                                  'out_ucast_pkts': '145291499',
                                                                                                                  'poller_hash': 'MzNBRDA5cGVlcmludGZwb24gMjM1'},
                                                                                                          {       'in_nucast_pkts': '5923807',
                                                                                                                  'in_octets': '157893673082',
                                                                                                                  'in_ucast_pkts': '1222409031',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6464989365',
                                                                                                                  'out_octets': '14460462621464',
                                                                                                                  'out_ucast_pkts': '4280298975',
                                                                                                                  'poller_hash': 'M0FFQzFGcGVlcmludGZwb24gMjM2'},
                                                                                                          {       'in_nucast_pkts': '42368',
                                                                                                                  'in_octets': '14960770221',
                                                                                                                  'in_ucast_pkts': '150253057',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '29068',
                                                                                                                  'out_octets': '564272354835',
                                                                                                                  'out_ucast_pkts': '382734054',
                                                                                                                  'poller_hash': 'M0FFQkM4cGVlcmludGZwb24gMjM3'},
                                                                                                          {       'in_nucast_pkts': '17633',
                                                                                                                  'in_octets': '200260268696',
                                                                                                                  'in_ucast_pkts': '556465102',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062569',
                                                                                                                  'out_octets': '1010161066356',
                                                                                                                  'out_ucast_pkts': '827945750',
                                                                                                                  'poller_hash': 'MjVEOTJCcGVlcmludGZwb24gMzI0'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'MzI5NjM3cGVlcmludGZwb24gMzI1'},
                                                                                                          {       'in_nucast_pkts': '828842',
                                                                                                                  'in_octets': '6932089789',
                                                                                                                  'in_ucast_pkts': '24505984',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1034794604',
                                                                                                                  'out_octets': '1417596089941',
                                                                                                                  'out_ucast_pkts': '97826385',
                                                                                                                  'poller_hash': 'NDJDOEZBcGVlcmludGZwb24gMzI2'},
                                                                                                          {       'in_nucast_pkts': '943369',
                                                                                                                  'in_octets': '23432265633',
                                                                                                                  'in_ucast_pkts': '102096860',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '668498727',
                                                                                                                  'out_octets': '1476080967865',
                                                                                                                  'out_ucast_pkts': '479016010',
                                                                                                                  'poller_hash': 'MjQ4QUVBcGVlcmludGZwb24gMzI3'},
                                                                                                          {       'in_nucast_pkts': '7716',
                                                                                                                  'in_octets': '47321751568',
                                                                                                                  'in_ucast_pkts': '206480006',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062561',
                                                                                                                  'out_octets': '781040048336',
                                                                                                                  'out_ucast_pkts': '567258192',
                                                                                                                  'poller_hash': 'NDZDRTBBcGVlcmludGZwb24gMzI4'},
                                                                                                          {       'in_nucast_pkts': '80754',
                                                                                                                  'in_octets': '48076043825',
                                                                                                                  'in_ucast_pkts': '146340126',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '962940',
                                                                                                                  'out_octets': '648014291252',
                                                                                                                  'out_ucast_pkts': '478790415',
                                                                                                                  'poller_hash': 'MjQ4QUY0cGVlcmludGZwb24gMzI5'},
                                                                                                          {       'in_nucast_pkts': '277',
                                                                                                                  'in_octets': '38630918816',
                                                                                                                  'in_ucast_pkts': '190297771',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '28815',
                                                                                                                  'out_octets': '788846394354',
                                                                                                                  'out_ucast_pkts': '564528328',
                                                                                                                  'poller_hash': 'NzZBQ0U4cGVlcmludGZwb24gMzMw'},
                                                                                                          {       'in_nucast_pkts': '109202',
                                                                                                                  'in_octets': '189202368157',
                                                                                                                  'in_ucast_pkts': '1011416363',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1440557',
                                                                                                                  'out_octets': '4185427358259',
                                                                                                                  'out_ucast_pkts': '3091076020',
                                                                                                                  'poller_hash': 'NzU3QUNwZWVyaW50ZnBvbiAzMzE='},
                                                                                                          {       'in_nucast_pkts': '139327',
                                                                                                                  'in_octets': '174595663223',
                                                                                                                  'in_ucast_pkts': '562698954',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1648548',
                                                                                                                  'out_octets': '2343971599181',
                                                                                                                  'out_ucast_pkts': '1884452613',
                                                                                                                  'poller_hash': 'NzFBNERCcGVlcmludGZwb24gMzMy'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'M0NGQUFwZWVyaW50ZnBvbiAzMzM='},
                                                                                                          {       'in_nucast_pkts': '1351769',
                                                                                                                  'in_octets': '18847654058',
                                                                                                                  'in_ucast_pkts': '73372408',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1061891',
                                                                                                                  'out_octets': '437140074650',
                                                                                                                  'out_ucast_pkts': '320750432',
                                                                                                                  'poller_hash': 'RjIzQ3BlZXJpbnRmcG9uIDMzNA=='},
                                                                                                          {       'in_nucast_pkts': '35741',
                                                                                                                  'in_octets': '246690136900',
                                                                                                                  'in_ucast_pkts': '1370528634',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1646666',
                                                                                                                  'out_octets': '5916152423394',
                                                                                                                  'out_ucast_pkts': '4545264483',
                                                                                                                  'poller_hash': 'MTY0Mjc3cGVlcmludGZwb24gMzM1'},
                                                                                                          {       'in_nucast_pkts': '18552312',
                                                                                                                  'in_octets': '91871385710',
                                                                                                                  'in_ucast_pkts': '341412815',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12898664522',
                                                                                                                  'out_octets': '18325161580075',
                                                                                                                  'out_ucast_pkts': '944878460',
                                                                                                                  'poller_hash': 'NTU2M0QzcGVlcmludGZwb24gMzM2'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'M0NGQTZwZWVyaW50ZnBvbiAzMzg='},
                                                                                                          {       'in_nucast_pkts': '8246',
                                                                                                                  'in_octets': '161490901629',
                                                                                                                  'in_ucast_pkts': '343159711',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1647819',
                                                                                                                  'out_octets': '427950325022',
                                                                                                                  'out_ucast_pkts': '1666929603373',
                                                                                                                  'poller_hash': 'MTU0NURwZWVyaW50ZnBvbiAzMzk='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODY3OEI2cGVlcmludGZwb24gMzQ3'},
                                                                                                          {       'in_nucast_pkts': '85555',
                                                                                                                  'in_octets': '26113815142',
                                                                                                                  'in_ucast_pkts': '175887441',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2786447',
                                                                                                                  'out_octets': '753037300615',
                                                                                                                  'out_ucast_pkts': '544170040',
                                                                                                                  'poller_hash': 'NUE2Qjk5cGVlcmludGZwb24gMTM5MTk4'},
                                                                                                          {       'in_nucast_pkts': '27779',
                                                                                                                  'in_octets': '85640418831',
                                                                                                                  'in_ucast_pkts': '109366189',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1780647',
                                                                                                                  'out_octets': '299674810477',
                                                                                                                  'out_ucast_pkts': '234886128',
                                                                                                                  'poller_hash': 'ODY5M0M2cGVlcmludGZwb24gMTQyMzU2'},
                                                                                                          {       'in_nucast_pkts': '911506',
                                                                                                                  'in_octets': '13134085338',
                                                                                                                  'in_ucast_pkts': '42750747',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2453354966',
                                                                                                                  'out_octets': '3313027312148',
                                                                                                                  'out_ucast_pkts': '76965670',
                                                                                                                  'poller_hash': 'MzQ5RDZFcGVlcmludGZwb24gMTQ4MTI1'},
                                                                                                          {       'in_nucast_pkts': '19257915',
                                                                                                                  'in_octets': '108292296154',
                                                                                                                  'in_ucast_pkts': '506394369',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '25750571684',
                                                                                                                  'out_octets': '38005821854538',
                                                                                                                  'out_ucast_pkts': '2328022804',
                                                                                                                  'poller_hash': 'QzgzQkNDcGVlcmludGZwb24gMTY2NjU4'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTI3NTBEM3BlZXJpbnRmcG9uIDIxNzcxNg=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '518493392466',
                                                                                         'out_octets': '973812654461091',
                                                                                         'out_ucast_pkts': '204012653395',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzQ=',
                                                                                         'pons': [       {       'id': '2/4',
                                                                                                                 'links': [       {       'connected_time': '8648128',
                                                                                                                                          'fiber_length': 1082,
                                                                                                                                          'poller_hash': 'MzIyODY1cGVlcnBvbnBvbiAyMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '522953',
                                                                                                                                          'fiber_length': 795,
                                                                                                                                          'poller_hash': 'RjBGOHBlZXJwb25wb24gMTIz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448236',
                                                                                                                                          'fiber_length': 929,
                                                                                                                                          'poller_hash': 'NDI4MTZFcGVlcnBvbnBvbiAyMzE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448200',
                                                                                                                                          'fiber_length': 576,
                                                                                                                                          'poller_hash': 'MUY3REExcGVlcnBvbnBvbiAyMzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448193',
                                                                                                                                          'fiber_length': 938,
                                                                                                                                          'poller_hash': 'MkFBOTQ2cGVlcnBvbnBvbiAyMzM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '288024',
                                                                                                                                          'fiber_length': 958,
                                                                                                                                          'poller_hash': 'MzNBRDA5cGVlcnBvbnBvbiAyMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '18888031',
                                                                                                                                          'fiber_length': 598,
                                                                                                                                          'poller_hash': 'M0FFQzFGcGVlcnBvbnBvbiAyMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448238',
                                                                                                                                          'fiber_length': 574,
                                                                                                                                          'poller_hash': 'M0FFQkM4cGVlcnBvbnBvbiAyMzc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448307',
                                                                                                                                          'fiber_length': 865,
                                                                                                                                          'poller_hash': 'MjVEOTJCcGVlcnBvbnBvbiAzMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'poller_hash': 'MzI5NjM3cGVlcnBvbnBvbiAzMjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448309',
                                                                                                                                          'fiber_length': 936,
                                                                                                                                          'poller_hash': 'NDJDOEZBcGVlcnBvbnBvbiAzMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448331',
                                                                                                                                          'fiber_length': 861,
                                                                                                                                          'poller_hash': 'MjQ4QUVBcGVlcnBvbnBvbiAzMjc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448297',
                                                                                                                                          'fiber_length': 572,
                                                                                                                                          'poller_hash': 'NDZDRTBBcGVlcnBvbnBvbiAzMjg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448181',
                                                                                                                                          'fiber_length': 487,
                                                                                                                                          'poller_hash': 'MjQ4QUY0cGVlcnBvbnBvbiAzMjk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448290',
                                                                                                                                          'fiber_length': 462,
                                                                                                                                          'poller_hash': 'NzZBQ0U4cGVlcnBvbnBvbiAzMzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '12289948',
                                                                                                                                          'fiber_length': 553,
                                                                                                                                          'poller_hash': 'NzU3QUNwZWVycG9ucG9uIDMzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '18904091',
                                                                                                                                          'fiber_length': 640,
                                                                                                                                          'poller_hash': 'NzFBNERCcGVlcnBvbnBvbiAzMzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448230',
                                                                                                                                          'fiber_length': 498,
                                                                                                                                          'poller_hash': 'M0NGQUFwZWVycG9ucG9uIDMzMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448221',
                                                                                                                                          'fiber_length': 480,
                                                                                                                                          'poller_hash': 'RjIzQ3BlZXJwb25wb24gMzM0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '18904081',
                                                                                                                                          'fiber_length': 395,
                                                                                                                                          'poller_hash': 'MTY0Mjc3cGVlcnBvbnBvbiAzMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '18904321',
                                                                                                                                          'fiber_length': 368,
                                                                                                                                          'poller_hash': 'NTU2M0QzcGVlcnBvbnBvbiAzMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448232',
                                                                                                                                          'fiber_length': 440,
                                                                                                                                          'poller_hash': 'M0NGQTZwZWVycG9ucG9uIDMzOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '18903704',
                                                                                                                                          'fiber_length': 495,
                                                                                                                                          'poller_hash': 'MTU0NURwZWVycG9ucG9uIDMzOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448394',
                                                                                                                                          'fiber_length': 877,
                                                                                                                                          'poller_hash': 'ODY3OEI2cGVlcnBvbnBvbiAzNDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448417',
                                                                                                                                          'fiber_length': 1023,
                                                                                                                                          'poller_hash': 'NUE2Qjk5cGVlcnBvbnBvbiAxMzkxOTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448337',
                                                                                                                                          'fiber_length': 1290,
                                                                                                                                          'poller_hash': 'ODY5M0M2cGVlcnBvbnBvbiAxNDIzNTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448388',
                                                                                                                                          'fiber_length': 882,
                                                                                                                                          'poller_hash': 'MzQ5RDZFcGVlcnBvbnBvbiAxNDgxMjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '18919286',
                                                                                                                                          'fiber_length': 469,
                                                                                                                                          'poller_hash': 'QzgzQkNDcGVlcnBvbnBvbiAxNjY2NTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752},
                                                                                                                                  {       'connected_time': '3448363',
                                                                                                                                          'fiber_length': 706,
                                                                                                                                          'poller_hash': 'MTI3NTBEM3BlZXJwb25wb24gMjE3NzE2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.752}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/4',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/5',
                                                                                         'in_discards': '192100',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2993586',
                                                                                         'in_octets': '10686797292148',
                                                                                         'in_ucast_pkts': '24492299090',
                                                                                         'links': [       {       'in_nucast_pkts': '4949',
                                                                                                                  'in_octets': '196181906035',
                                                                                                                  'in_ucast_pkts': '959585497',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '161137',
                                                                                                                  'out_octets': '3851356207605',
                                                                                                                  'out_ucast_pkts': '3056065287',
                                                                                                                  'poller_hash': 'M0VCQTE5cGVlcmludGZwb24gMTg='},
                                                                                                          {       'in_nucast_pkts': '3222457',
                                                                                                                  'in_octets': '4099235514',
                                                                                                                  'in_ucast_pkts': '20078877',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4277252506',
                                                                                                                  'out_octets': '5669043322984',
                                                                                                                  'out_ucast_pkts': '68402822',
                                                                                                                  'poller_hash': 'NDJCOUU2cGVlcmludGZwb24gNDY='},
                                                                                                          {       'in_nucast_pkts': '102831',
                                                                                                                  'in_octets': '28413818616',
                                                                                                                  'in_ucast_pkts': '93576998',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11085556',
                                                                                                                  'out_octets': '236685749306',
                                                                                                                  'out_ucast_pkts': '210495812',
                                                                                                                  'poller_hash': 'ODcyNDcwcGVlcmludGZwb24gNTM='},
                                                                                                          {       'in_nucast_pkts': '1573917',
                                                                                                                  'in_octets': '44370760564',
                                                                                                                  'in_ucast_pkts': '99093408',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3246939733',
                                                                                                                  'out_octets': '4709916039040',
                                                                                                                  'out_ucast_pkts': '292115507',
                                                                                                                  'poller_hash': 'NDE1M0ZwZWVyaW50ZnBvbiA1NA=='},
                                                                                                          {       'in_nucast_pkts': '2683689',
                                                                                                                  'in_octets': '15212719392',
                                                                                                                  'in_ucast_pkts': '39608750',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '969519253',
                                                                                                                  'out_octets': '1383516577322',
                                                                                                                  'out_ucast_pkts': '137959547',
                                                                                                                  'poller_hash': 'NzFBNDkycGVlcmludGZwb24gNTU='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'M0QwRkNwZWVyaW50ZnBvbiA1Nw=='},
                                                                                                          {       'in_nucast_pkts': '230569',
                                                                                                                  'in_octets': '442843135611',
                                                                                                                  'in_ucast_pkts': '886435948',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1644755',
                                                                                                                  'out_octets': '2847345579457',
                                                                                                                  'out_ucast_pkts': '10869594360',
                                                                                                                  'poller_hash': 'M0QwRUZwZWVyaW50ZnBvbiA1OA=='},
                                                                                                          {       'in_nucast_pkts': '9632961',
                                                                                                                  'in_octets': '29554308561',
                                                                                                                  'in_ucast_pkts': '97491038',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10321262534',
                                                                                                                  'out_octets': '13440503040303',
                                                                                                                  'out_ucast_pkts': '196207561',
                                                                                                                  'poller_hash': 'NzFEMkU1cGVlcmludGZwb24gNTk='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'M0QwRjRwZWVyaW50ZnBvbiA2MA=='},
                                                                                                          {       'in_nucast_pkts': '47369',
                                                                                                                  'in_octets': '11014196349',
                                                                                                                  'in_ucast_pkts': '35352971',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1227359',
                                                                                                                  'out_octets': '51795594638',
                                                                                                                  'out_ucast_pkts': '54509535',
                                                                                                                  'poller_hash': 'NDE1MjJwZWVyaW50ZnBvbiA2MQ=='},
                                                                                                          {       'in_nucast_pkts': '3',
                                                                                                                  'in_octets': '8984314313',
                                                                                                                  'in_ucast_pkts': '43774091',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '778100',
                                                                                                                  'out_octets': '212248880765',
                                                                                                                  'out_ucast_pkts': '170910344',
                                                                                                                  'poller_hash': 'ODg5QjRwZWVyaW50ZnBvbiA2Mw=='},
                                                                                                          {       'in_nucast_pkts': '15816',
                                                                                                                  'in_octets': '303338287829',
                                                                                                                  'in_ucast_pkts': '1052279735',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1647161',
                                                                                                                  'out_octets': '5829047736810',
                                                                                                                  'out_ucast_pkts': '4327185524',
                                                                                                                  'poller_hash': 'MTk5QTM2cGVlcmludGZwb24gNjQ='},
                                                                                                          {       'in_nucast_pkts': '3499314',
                                                                                                                  'in_octets': '6140535895',
                                                                                                                  'in_ucast_pkts': '10258487',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3368410241',
                                                                                                                  'out_octets': '4467938549953',
                                                                                                                  'out_ucast_pkts': '33747491',
                                                                                                                  'poller_hash': 'NTU2M0FEcGVlcmludGZwb24gNjU='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'NTYwQzE5cGVlcmludGZwb24gNjc='},
                                                                                                          {       'in_nucast_pkts': '16773640',
                                                                                                                  'in_octets': '305005791816',
                                                                                                                  'in_ucast_pkts': '1269558359',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5552945975',
                                                                                                                  'out_octets': '12092751663051',
                                                                                                                  'out_ucast_pkts': '3662758208',
                                                                                                                  'poller_hash': 'NTYwMjYzcGVlcmludGZwb24gNzA='},
                                                                                                          {       'in_nucast_pkts': '48465590',
                                                                                                                  'in_octets': '201238186855',
                                                                                                                  'in_ucast_pkts': '870091903',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '399412',
                                                                                                                  'out_octets': '3509990350213',
                                                                                                                  'out_ucast_pkts': '2570952406',
                                                                                                                  'poller_hash': 'MTk5QTMxcGVlcmludGZwb24gOTQ='},
                                                                                                          {       'in_nucast_pkts': '8803833',
                                                                                                                  'in_octets': '201694783735',
                                                                                                                  'in_ucast_pkts': '1156420047',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13231927337',
                                                                                                                  'out_octets': '23746582855553',
                                                                                                                  'out_ucast_pkts': '4489670944',
                                                                                                                  'poller_hash': 'NDkzNDBwZWVyaW50ZnBvbiA5OA=='},
                                                                                                          {       'in_nucast_pkts': '44889',
                                                                                                                  'in_octets': '2905414944209',
                                                                                                                  'in_ucast_pkts': '2061267862',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11088463',
                                                                                                                  'out_octets': '389773747398',
                                                                                                                  'out_ucast_pkts': '618928038',
                                                                                                                  'poller_hash': 'ODY5NDE5cGVlcmludGZwb24gMTQyMzI2'},
                                                                                                          {       'in_nucast_pkts': '9853764',
                                                                                                                  'in_octets': '10005209947',
                                                                                                                  'in_ucast_pkts': '38017911',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '20377564710',
                                                                                                                  'out_octets': '27481772373567',
                                                                                                                  'out_ucast_pkts': '146280562',
                                                                                                                  'poller_hash': 'QkYyNEQxcGVlcmludGZwb24gMTY2NzE4'},
                                                                                                          {       'in_nucast_pkts': '4384469',
                                                                                                                  'in_octets': '405661285654',
                                                                                                                  'in_ucast_pkts': '1534467769',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5177640904',
                                                                                                                  'out_octets': '12017163930514',
                                                                                                                  'out_ucast_pkts': '4018429206',
                                                                                                                  'poller_hash': 'Q0JFMDUycGVlcmludGZwb24gMTY4NDU5'},
                                                                                                          {       'in_nucast_pkts': '2779242',
                                                                                                                  'in_octets': '2221630227',
                                                                                                                  'in_ucast_pkts': '8044603',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3878628208',
                                                                                                                  'out_octets': '5149362387433',
                                                                                                                  'out_ucast_pkts': '25789368',
                                                                                                                  'poller_hash': 'QzgxREQwcGVlcmludGZwb24gMTk4MjI0'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '308088638248',
                                                                                         'out_octets': '502785189082796',
                                                                                         'out_ucast_pkts': '64383983623',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzU=',
                                                                                         'pons': [       {       'id': '2/5',
                                                                                                                 'links': [       {       'connected_time': '18903901',
                                                                                                                                          'fiber_length': 2650,
                                                                                                                                          'poller_hash': 'M0VCQTE5cGVlcnBvbnBvbiAxOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '2550572',
                                                                                                                                          'fiber_length': 3056,
                                                                                                                                          'poller_hash': 'NDJCOUU2cGVlcnBvbnBvbiA0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18919088',
                                                                                                                                          'fiber_length': 3561,
                                                                                                                                          'poller_hash': 'ODcyNDcwcGVlcnBvbnBvbiA1Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '2535338',
                                                                                                                                          'fiber_length': 3519,
                                                                                                                                          'poller_hash': 'NDE1M0ZwZWVycG9ucG9uIDU0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '3448100',
                                                                                                                                          'fiber_length': 3183,
                                                                                                                                          'poller_hash': 'NzFBNDkycGVlcnBvbnBvbiA1NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '2535332',
                                                                                                                                          'fiber_length': 2568,
                                                                                                                                          'poller_hash': 'M0QwRkNwZWVycG9ucG9uIDU3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18903826',
                                                                                                                                          'fiber_length': 3038,
                                                                                                                                          'poller_hash': 'M0QwRUZwZWVycG9ucG9uIDU4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18904063',
                                                                                                                                          'fiber_length': 3122,
                                                                                                                                          'poller_hash': 'NzFEMkU1cGVlcnBvbnBvbiA1OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18903797',
                                                                                                                                          'fiber_length': 3119,
                                                                                                                                          'poller_hash': 'M0QwRjRwZWVycG9ucG9uIDYw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '6448643',
                                                                                                                                          'fiber_length': 3121,
                                                                                                                                          'poller_hash': 'NDE1MjJwZWVycG9ucG9uIDYx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '2535380',
                                                                                                                                          'fiber_length': 2956,
                                                                                                                                          'poller_hash': 'ODg5QjRwZWVycG9ucG9uIDYz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18903797',
                                                                                                                                          'fiber_length': 2731,
                                                                                                                                          'poller_hash': 'MTk5QTM2cGVlcnBvbnBvbiA2NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '2526198',
                                                                                                                                          'fiber_length': 2848,
                                                                                                                                          'poller_hash': 'NTU2M0FEcGVlcnBvbnBvbiA2NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18903502',
                                                                                                                                          'fiber_length': 2932,
                                                                                                                                          'poller_hash': 'NTYwQzE5cGVlcnBvbnBvbiA2Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18903868',
                                                                                                                                          'fiber_length': 2659,
                                                                                                                                          'poller_hash': 'NTYwMjYzcGVlcnBvbnBvbiA3MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18903927',
                                                                                                                                          'fiber_length': 2654,
                                                                                                                                          'poller_hash': 'MTk5QTMxcGVlcnBvbnBvbiA5NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18903547',
                                                                                                                                          'fiber_length': 3090,
                                                                                                                                          'poller_hash': 'NDkzNDBwZWVycG9ucG9uIDk4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18919345',
                                                                                                                                          'fiber_length': 3459,
                                                                                                                                          'poller_hash': 'ODY5NDE5cGVlcnBvbnBvbiAxNDIzMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18904341',
                                                                                                                                          'fiber_length': 3182,
                                                                                                                                          'poller_hash': 'QkYyNEQxcGVlcnBvbnBvbiAxNjY3MTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '18919189',
                                                                                                                                          'fiber_length': 2973,
                                                                                                                                          'poller_hash': 'Q0JFMDUycGVlcnBvbnBvbiAxNjg0NTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567},
                                                                                                                                  {       'connected_time': '2535617',
                                                                                                                                          'fiber_length': 3061,
                                                                                                                                          'poller_hash': 'QzgxREQwcGVlcnBvbnBvbiAxOTgyMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.567}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/5',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/6',
                                                                                         'in_discards': '131310',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '801398',
                                                                                         'in_octets': '6167283823445',
                                                                                         'in_ucast_pkts': '25221720226',
                                                                                         'links': [       {       'in_nucast_pkts': '57115',
                                                                                                                  'in_octets': '46103263942',
                                                                                                                  'in_ucast_pkts': '200556743',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1780637',
                                                                                                                  'out_octets': '725709116527',
                                                                                                                  'out_ucast_pkts': '576191147',
                                                                                                                  'poller_hash': 'ODcyNDI1cGVlcmludGZwb24gMTQzMDQz'},
                                                                                                          {       'in_nucast_pkts': '531141',
                                                                                                                  'in_octets': '35510589026',
                                                                                                                  'in_ucast_pkts': '86159489',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1780517',
                                                                                                                  'out_octets': '208777425593',
                                                                                                                  'out_ucast_pkts': '190504676',
                                                                                                                  'poller_hash': 'ODcyNDcxcGVlcmludGZwb24gMTQ0NDQ2'},
                                                                                                          {       'in_nucast_pkts': '2760144',
                                                                                                                  'in_octets': '11220925740',
                                                                                                                  'in_ucast_pkts': '88798873',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7288428543',
                                                                                                                  'out_octets': '10065298281396',
                                                                                                                  'out_ucast_pkts': '319410402',
                                                                                                                  'poller_hash': 'OTU2RkE3cGVlcmludGZwb24gMTQ1NjMw'},
                                                                                                          {       'in_nucast_pkts': '1706962',
                                                                                                                  'in_octets': '84097916882',
                                                                                                                  'in_ucast_pkts': '160567838',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4679641530',
                                                                                                                  'out_octets': '6727316780391',
                                                                                                                  'out_ucast_pkts': '353895882',
                                                                                                                  'poller_hash': 'OTU2RjI2cGVlcmludGZwb24gMTQ2MDAx'},
                                                                                                          {       'in_nucast_pkts': '81907',
                                                                                                                  'in_octets': '3623686092',
                                                                                                                  'in_ucast_pkts': '22032682',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2786716',
                                                                                                                  'out_octets': '122965099071',
                                                                                                                  'out_ucast_pkts': '94013533',
                                                                                                                  'poller_hash': 'QTlDODk5cGVlcmludGZwb24gMTQ3Mzk3'},
                                                                                                          {       'in_nucast_pkts': '84664',
                                                                                                                  'in_octets': '41800554458',
                                                                                                                  'in_ucast_pkts': '348452495',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2786749',
                                                                                                                  'out_octets': '1430096465635',
                                                                                                                  'out_ucast_pkts': '994803818',
                                                                                                                  'poller_hash': 'QjUxMTUxcGVlcmludGZwb24gMTUxMjAy'},
                                                                                                          {       'in_nucast_pkts': '20451161',
                                                                                                                  'in_octets': '48722266413',
                                                                                                                  'in_ucast_pkts': '105343825',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4959786411',
                                                                                                                  'out_octets': '5673731759126',
                                                                                                                  'out_ucast_pkts': '254538551',
                                                                                                                  'poller_hash': 'ODY5MzhCcGVlcmludGZwb24gMTU2NDMw'},
                                                                                                          {       'in_nucast_pkts': '82344',
                                                                                                                  'in_octets': '15680286063',
                                                                                                                  'in_ucast_pkts': '59896203',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2786650',
                                                                                                                  'out_octets': '349767186318',
                                                                                                                  'out_ucast_pkts': '249237441',
                                                                                                                  'poller_hash': 'QzgzQjZFcGVlcmludGZwb24gMTcwNzIy'},
                                                                                                          {       'in_nucast_pkts': '40728',
                                                                                                                  'in_octets': '23189699843',
                                                                                                                  'in_ucast_pkts': '119480687',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1298349',
                                                                                                                  'out_octets': '516786790473',
                                                                                                                  'out_ucast_pkts': '389966338',
                                                                                                                  'poller_hash': 'QzgxQzdCcGVlcmludGZwb24gMjA3MTQ5'},
                                                                                                          {       'in_nucast_pkts': '76401',
                                                                                                                  'in_octets': '89698664232',
                                                                                                                  'in_ucast_pkts': '230198657',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2786815',
                                                                                                                  'out_octets': '658518229621',
                                                                                                                  'out_ucast_pkts': '595419291',
                                                                                                                  'poller_hash': 'MTFCMjIzNXBlZXJpbnRmcG9uIDIxMjU4MA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '2/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '238756757317',
                                                                                         'out_octets': '425862580841327',
                                                                                         'out_ucast_pkts': '76184885864',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzY=',
                                                                                         'pons': [       {       'id': '2/6',
                                                                                                                 'links': [       {       'connected_time': '3448326',
                                                                                                                                          'fiber_length': 1000,
                                                                                                                                          'poller_hash': 'ODcyNDI1cGVlcnBvbnBvbiAxNDMwNDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '3448368',
                                                                                                                                          'fiber_length': 1233,
                                                                                                                                          'poller_hash': 'ODcyNDcxcGVlcnBvbnBvbiAxNDQ0NDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '3465129',
                                                                                                                                          'fiber_length': 395,
                                                                                                                                          'poller_hash': 'OTU2RkE3cGVlcnBvbnBvbiAxNDU2MzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '3448357',
                                                                                                                                          'fiber_length': 921,
                                                                                                                                          'poller_hash': 'OTU2RjI2cGVlcnBvbnBvbiAxNDYwMDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '3448339',
                                                                                                                                          'fiber_length': 1119,
                                                                                                                                          'poller_hash': 'QTlDODk5cGVlcnBvbnBvbiAxNDczOTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '3448456',
                                                                                                                                          'fiber_length': 1019,
                                                                                                                                          'poller_hash': 'QjUxMTUxcGVlcnBvbnBvbiAxNTEyMDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '18919237',
                                                                                                                                          'fiber_length': 1062,
                                                                                                                                          'poller_hash': 'ODY5MzhCcGVlcnBvbnBvbiAxNTY0MzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '3448341',
                                                                                                                                          'fiber_length': 989,
                                                                                                                                          'poller_hash': 'QzgzQjZFcGVlcnBvbnBvbiAxNzA3MjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '1608147',
                                                                                                                                          'fiber_length': 561,
                                                                                                                                          'poller_hash': 'QzgxQzdCcGVlcnBvbnBvbiAyMDcxNDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '3448375',
                                                                                                                                          'fiber_length': 1456,
                                                                                                                                          'poller_hash': 'MTFCMjIzNXBlZXJwb25wb24gMjEyNTgw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/6',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/7',
                                                                                         'in_discards': '1425',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2108401',
                                                                                         'in_octets': '6495886583846',
                                                                                         'in_ucast_pkts': '23487897238',
                                                                                         'links': [       {       'in_nucast_pkts': '2329069',
                                                                                                                  'in_octets': '16975591475',
                                                                                                                  'in_ucast_pkts': '89393115',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2929743518',
                                                                                                                  'out_octets': '4199226878686',
                                                                                                                  'out_ucast_pkts': '305898624',
                                                                                                                  'poller_hash': 'M0ZDM0MycGVlcmludGZwb24gMjE='},
                                                                                                          {       'in_nucast_pkts': '853415',
                                                                                                                  'in_octets': '5374439511',
                                                                                                                  'in_ucast_pkts': '25981203',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '850080438',
                                                                                                                  'out_octets': '1163952946808',
                                                                                                                  'out_ucast_pkts': '86362995',
                                                                                                                  'poller_hash': 'MzIxOTU4cGVlcmludGZwb24gMzA='},
                                                                                                          {       'in_nucast_pkts': '47963',
                                                                                                                  'in_octets': '95605009866',
                                                                                                                  'in_ucast_pkts': '453887760',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1382705',
                                                                                                                  'out_octets': '1373499124834',
                                                                                                                  'out_ucast_pkts': '1059176859',
                                                                                                                  'poller_hash': 'MTJGRkVFcGVlcmludGZwb24gNjk='},
                                                                                                          {       'in_nucast_pkts': '9699',
                                                                                                                  'in_octets': '17717879743',
                                                                                                                  'in_ucast_pkts': '125760180',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1641849',
                                                                                                                  'out_octets': '401714843360',
                                                                                                                  'out_ucast_pkts': '305725291',
                                                                                                                  'poller_hash': 'MTk5OUUzcGVlcmludGZwb24gNzc='},
                                                                                                          {       'in_nucast_pkts': '4698',
                                                                                                                  'in_octets': '33222442327',
                                                                                                                  'in_ucast_pkts': '122236296',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1648073',
                                                                                                                  'out_octets': '920075449553',
                                                                                                                  'out_ucast_pkts': '9333695135',
                                                                                                                  'poller_hash': 'M0QwRjJwZWVyaW50ZnBvbiA3OA=='},
                                                                                                          {       'in_nucast_pkts': '3051293',
                                                                                                                  'in_octets': '7917825513',
                                                                                                                  'in_ucast_pkts': '39051067',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3607771554',
                                                                                                                  'out_octets': '4982525597079',
                                                                                                                  'out_ucast_pkts': '123740654',
                                                                                                                  'poller_hash': 'NkRCQzk4cGVlcmludGZwb24gNzk='},
                                                                                                          {       'in_nucast_pkts': '91508',
                                                                                                                  'in_octets': '114950890939',
                                                                                                                  'in_ucast_pkts': '359527170',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4210',
                                                                                                                  'out_octets': '341382854127',
                                                                                                                  'out_ucast_pkts': '407788472',
                                                                                                                  'poller_hash': 'M0QwRjZwZWVyaW50ZnBvbiA4MA=='},
                                                                                                          {       'in_nucast_pkts': '21475214',
                                                                                                                  'in_octets': '243723028186',
                                                                                                                  'in_ucast_pkts': '876770986',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5770782715',
                                                                                                                  'out_octets': '10117593097958',
                                                                                                                  'out_ucast_pkts': '2018693296',
                                                                                                                  'poller_hash': 'NzZDRkY4cGVlcmludGZwb24gODE='},
                                                                                                          {       'in_nucast_pkts': '1241166',
                                                                                                                  'in_octets': '9138154962',
                                                                                                                  'in_ucast_pkts': '33014999',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1430152749',
                                                                                                                  'out_octets': '1858130699922',
                                                                                                                  'out_ucast_pkts': '63244875',
                                                                                                                  'poller_hash': 'NDJDRTk4cGVlcmludGZwb24gODY='},
                                                                                                          {       'in_nucast_pkts': '158',
                                                                                                                  'in_octets': '1712107919',
                                                                                                                  'in_ucast_pkts': '6619435',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '23240',
                                                                                                                  'out_octets': '22323084316',
                                                                                                                  'out_ucast_pkts': '18619568',
                                                                                                                  'poller_hash': 'NzIyMDNEcGVlcmludGZwb24gODg='},
                                                                                                          {       'in_nucast_pkts': '5806505',
                                                                                                                  'in_octets': '30261145217',
                                                                                                                  'in_ucast_pkts': '212462117',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4815926759',
                                                                                                                  'out_octets': '7036781951766',
                                                                                                                  'out_ucast_pkts': '17656749049',
                                                                                                                  'poller_hash': 'M0QwRTlwZWVyaW50ZnBvbiA5NQ=='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'M0ZGQUI5cGVlcmludGZwb24gOTY='},
                                                                                                          {       'in_nucast_pkts': '2983',
                                                                                                                  'in_octets': '24847634514',
                                                                                                                  'in_ucast_pkts': '181949644',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1647891',
                                                                                                                  'out_octets': '780402943788',
                                                                                                                  'out_ucast_pkts': '573897043',
                                                                                                                  'poller_hash': 'NDE1ODVwZWVyaW50ZnBvbiA5Nw=='},
                                                                                                          {       'in_nucast_pkts': '11303',
                                                                                                                  'in_octets': '834965874403',
                                                                                                                  'in_ucast_pkts': '1368245186',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1646637',
                                                                                                                  'out_octets': '2690345823188',
                                                                                                                  'out_ucast_pkts': '2569521589',
                                                                                                                  'poller_hash': 'MTU0NTJwZWVyaW50ZnBvbiAxMDA='},
                                                                                                          {       'in_nucast_pkts': '80889',
                                                                                                                  'in_octets': '41756871722',
                                                                                                                  'in_ucast_pkts': '295641564',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1066147',
                                                                                                                  'out_octets': '837846830549',
                                                                                                                  'out_ucast_pkts': '591908569',
                                                                                                                  'poller_hash': 'NDE1OTFwZWVyaW50ZnBvbiAxMDE='},
                                                                                                          {       'in_nucast_pkts': '26425585',
                                                                                                                  'in_octets': '131960975612',
                                                                                                                  'in_ucast_pkts': '512507436',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '43573327799',
                                                                                                                  'out_octets': '59701225378143',
                                                                                                                  'out_ucast_pkts': '1220629285',
                                                                                                                  'poller_hash': 'N0ZFODRwZWVyaW50ZnBvbiAxMDI='},
                                                                                                          {       'in_nucast_pkts': '6200580',
                                                                                                                  'in_octets': '123715208199',
                                                                                                                  'in_ucast_pkts': '1137840824',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8590752691',
                                                                                                                  'out_octets': '15026073740634',
                                                                                                                  'out_ucast_pkts': '2608491631',
                                                                                                                  'poller_hash': 'MzkwQUI4cGVlcmludGZwb24gMTAz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MzI5NURDcGVlcmludGZwb24gMTA0'},
                                                                                                          {       'in_nucast_pkts': '7244896',
                                                                                                                  'in_octets': '101963101094',
                                                                                                                  'in_ucast_pkts': '408340395',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14481946527',
                                                                                                                  'out_octets': '20896012272772',
                                                                                                                  'out_ucast_pkts': '1268587481',
                                                                                                                  'poller_hash': 'MkZFOUJBcGVlcmludGZwb24gMTA1'},
                                                                                                          {       'in_nucast_pkts': '9842917',
                                                                                                                  'in_octets': '255749325188',
                                                                                                                  'in_ucast_pkts': '1877937330',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '25677688944',
                                                                                                                  'out_octets': '40032557268902',
                                                                                                                  'out_ucast_pkts': '3915490178',
                                                                                                                  'poller_hash': 'QzgzQkIwcGVlcmludGZwb24gMTA2'},
                                                                                                          {       'in_nucast_pkts': '1104052',
                                                                                                                  'in_octets': '15878355744',
                                                                                                                  'in_ucast_pkts': '104575347',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1541223451',
                                                                                                                  'out_octets': '2391746167074',
                                                                                                                  'out_ucast_pkts': '266948291',
                                                                                                                  'poller_hash': 'M0FFQkMwcGVlcmludGZwb24gMTA4'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '2/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '257234650414',
                                                                                         'out_octets': '412553591281088',
                                                                                         'out_ucast_pkts': '49357555150',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzc=',
                                                                                         'pons': [       {       'id': '2/7',
                                                                                                                 'links': [       {       'connected_time': '3448123',
                                                                                                                                          'fiber_length': 1287,
                                                                                                                                          'poller_hash': 'M0ZDM0MycGVlcnBvbnBvbiAyMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '3448018',
                                                                                                                                          'fiber_length': 2217,
                                                                                                                                          'poller_hash': 'MzIxOTU4cGVlcnBvbnBvbiAzMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '10832382',
                                                                                                                                          'fiber_length': 2078,
                                                                                                                                          'poller_hash': 'MTJGRkVFcGVlcnBvbnBvbiA2OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '18904095',
                                                                                                                                          'fiber_length': 2481,
                                                                                                                                          'poller_hash': 'MTk5OUUzcGVlcnBvbnBvbiA3Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '18903774',
                                                                                                                                          'fiber_length': 2400,
                                                                                                                                          'poller_hash': 'M0QwRjJwZWVycG9ucG9uIDc4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '3448177',
                                                                                                                                          'fiber_length': 2449,
                                                                                                                                          'poller_hash': 'NkRCQzk4cGVlcnBvbnBvbiA3OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '2534426',
                                                                                                                                          'fiber_length': 2359,
                                                                                                                                          'poller_hash': 'M0QwRjZwZWVycG9ucG9uIDgw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '18903977',
                                                                                                                                          'fiber_length': 2358,
                                                                                                                                          'poller_hash': 'NzZDRkY4cGVlcnBvbnBvbiA4MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '2535397',
                                                                                                                                          'fiber_length': 2811,
                                                                                                                                          'poller_hash': 'NDJDRTk4cGVlcnBvbnBvbiA4Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '3448159',
                                                                                                                                          'fiber_length': 1378,
                                                                                                                                          'poller_hash': 'NzIyMDNEcGVlcnBvbnBvbiA4OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '5492690',
                                                                                                                                          'fiber_length': 2611,
                                                                                                                                          'poller_hash': 'M0QwRTlwZWVycG9ucG9uIDk1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'poller_hash': 'M0ZGQUI5cGVlcnBvbnBvbiA5Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '18903648',
                                                                                                                                          'fiber_length': 1801,
                                                                                                                                          'poller_hash': 'NDE1ODVwZWVycG9ucG9uIDk3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '18903564',
                                                                                                                                          'fiber_length': 1314,
                                                                                                                                          'poller_hash': 'MTU0NTJwZWVycG9ucG9uIDEwMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '3448093',
                                                                                                                                          'fiber_length': 1228,
                                                                                                                                          'poller_hash': 'NDE1OTFwZWVycG9ucG9uIDEwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '18904059',
                                                                                                                                          'fiber_length': 1998,
                                                                                                                                          'poller_hash': 'N0ZFODRwZWVycG9ucG9uIDEwMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '18903650',
                                                                                                                                          'fiber_length': 2109,
                                                                                                                                          'poller_hash': 'MzkwQUI4cGVlcnBvbnBvbiAxMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '18904106',
                                                                                                                                          'fiber_length': 2039,
                                                                                                                                          'poller_hash': 'MzI5NURDcGVlcnBvbnBvbiAxMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '18904021',
                                                                                                                                          'fiber_length': 2020,
                                                                                                                                          'poller_hash': 'MkZFOUJBcGVlcnBvbnBvbiAxMDU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '18918955',
                                                                                                                                          'fiber_length': 2109,
                                                                                                                                          'poller_hash': 'QzgzQkIwcGVlcnBvbnBvbiAxMDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644},
                                                                                                                                  {       'connected_time': '2618693',
                                                                                                                                          'fiber_length': 2135,
                                                                                                                                          'poller_hash': 'M0FFQkMwcGVlcnBvbnBvbiAxMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.644}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/7',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/8',
                                                                                         'in_discards': '378988',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1539289',
                                                                                         'in_octets': '23674017366847',
                                                                                         'in_ucast_pkts': '96488071728',
                                                                                         'links': [       {       'in_nucast_pkts': '28458',
                                                                                                                  'in_octets': '81715468768',
                                                                                                                  'in_ucast_pkts': '435104228',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1779712',
                                                                                                                  'out_octets': '1354927819233',
                                                                                                                  'out_ucast_pkts': '980932110',
                                                                                                                  'poller_hash': 'NDJDMTE4cGVlcmludGZwb24gOTE='},
                                                                                                          {       'in_nucast_pkts': '755054',
                                                                                                                  'in_octets': '2195630341',
                                                                                                                  'in_ucast_pkts': '12401328',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2150848817',
                                                                                                                  'out_octets': '2937921687809',
                                                                                                                  'out_ucast_pkts': '70152854',
                                                                                                                  'poller_hash': 'NDJDOTNGcGVlcmludGZwb24gOTI='},
                                                                                                          {       'in_nucast_pkts': '79604',
                                                                                                                  'in_octets': '14897592352',
                                                                                                                  'in_ucast_pkts': '128266964',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062591',
                                                                                                                  'out_octets': '417023331276',
                                                                                                                  'out_ucast_pkts': '294172113',
                                                                                                                  'poller_hash': 'NjQwQUVEcGVlcmludGZwb24gMzQx'},
                                                                                                          {       'in_nucast_pkts': '3070',
                                                                                                                  'in_octets': '18559082746',
                                                                                                                  'in_ucast_pkts': '147113919',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062585',
                                                                                                                  'out_octets': '694553948516',
                                                                                                                  'out_ucast_pkts': '482194573',
                                                                                                                  'poller_hash': 'NjQwQUU0cGVlcmludGZwb24gMzQz'},
                                                                                                          {       'in_nucast_pkts': '3',
                                                                                                                  'in_octets': '5419750171',
                                                                                                                  'in_ucast_pkts': '30837670',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1062596',
                                                                                                                  'out_octets': '160252567484',
                                                                                                                  'out_ucast_pkts': '123397205',
                                                                                                                  'poller_hash': 'NjQwQjJGcGVlcmludGZwb24gMzQ0'},
                                                                                                          {       'in_nucast_pkts': '1831884',
                                                                                                                  'in_octets': '16378697256',
                                                                                                                  'in_ucast_pkts': '54654117',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5523526600',
                                                                                                                  'out_octets': '7560056067907',
                                                                                                                  'out_ucast_pkts': '192964720',
                                                                                                                  'poller_hash': 'NDJCRUUzcGVlcmludGZwb24gMzQ1'},
                                                                                                          {       'in_nucast_pkts': '92444',
                                                                                                                  'in_octets': '116101263258',
                                                                                                                  'in_ucast_pkts': '950864294',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2786631',
                                                                                                                  'out_octets': '3770389580305',
                                                                                                                  'out_ucast_pkts': '2655569960',
                                                                                                                  'poller_hash': 'ODY5M0ZDcGVlcmludGZwb24gMTM4Njgw'},
                                                                                                          {       'in_nucast_pkts': '31734',
                                                                                                                  'in_octets': '73902087732',
                              