import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):

    def test_calix_exa_E7_2_EXA_3_4_30_40_01(self):
        obj = self.run_data("calix.exa.E7-2 (EXA).3.4.30.40.01")
        exp_info = {
                'model': 'E7-2 (EXA)',
                'sta_count': 369,
                'sw_version': '3.4.30.40',
                'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': None, 'system_mac_address': None
        }
        exp_sta_stats = {
                None: {       'dev_macs': None,
                              'ip_address': None,
                              'mac_address': None,
                              'name': 'ont 41',
                              'serial_number': '512589',
                              'system_mac_address': None},
                '00:06:31:06:38:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:06:38:37',
                                             'name': 'ont 185',
                                             'serial_number': '7FF5',
                                             'system_mac_address': None},
                '00:06:31:08:4a:08': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4a:08',
                                             'name': 'ont 123',
                                             'serial_number': 'F0F8',
                                             'system_mac_address': None},
                '00:06:31:08:4a:56': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4a:56',
                                             'name': 'ont 107',
                                             'serial_number': 'F1F8',
                                             'system_mac_address': None},
                '00:06:31:08:4b:82': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4b:82',
                                             'name': 'ont 139',
                                             'serial_number': 'F23A',
                                             'system_mac_address': None},
                '00:06:31:08:4c:8d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:4c:8d',
                                             'name': 'ont 334',
                                             'serial_number': 'F23C',
                                             'system_mac_address': None},
                '00:06:31:08:de:8d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:de:8d',
                                             'name': 'ont 183',
                                             'serial_number': '153C3',
                                             'system_mac_address': None},
                '00:06:31:08:e2:95': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:e2:95',
                                             'name': 'ont 100',
                                             'serial_number': '15452',
                                             'system_mac_address': None},
                '00:06:31:08:e2:e6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:08:e2:e6',
                                             'name': 'ont 339',
                                             'serial_number': '1545D',
                                             'system_mac_address': None},
                '00:06:31:11:f0:4e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f0:4e',
                                             'name': 'ont 160',
                                             'serial_number': '1303D',
                                             'system_mac_address': None},
                '00:06:31:11:f6:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f6:cc',
                                             'name': 'ont 154',
                                             'serial_number': '13538',
                                             'system_mac_address': None},
                '00:06:31:11:f7:7d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:11:f7:7d',
                                             'name': 'ont 286',
                                             'serial_number': '13548',
                                             'system_mac_address': None},
                '00:06:31:15:a1:e0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a1:e0',
                                             'name': 'ont 144',
                                             'serial_number': '3CC08',
                                             'system_mac_address': None},
                '00:06:31:15:a8:61': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a8:61',
                                             'name': 'ont 225',
                                             'serial_number': '3CFA8',
                                             'system_mac_address': None},
                '00:06:31:15:a8:b0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a8:b0',
                                             'name': 'ont 338',
                                             'serial_number': '3CFA6',
                                             'system_mac_address': None},
                '00:06:31:15:a9:1e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:1e',
                                             'name': 'ont 121',
                                             'serial_number': '3CF4A',
                                             'system_mac_address': None},
                '00:06:31:15:a9:2d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:2d',
                                             'name': 'ont 295',
                                             'serial_number': '3D0FA',
                                             'system_mac_address': None},
                '00:06:31:15:a9:32': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:32',
                                             'name': 'ont 57',
                                             'serial_number': '3D0FC',
                                             'system_mac_address': None},
                '00:06:31:15:a9:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:37',
                                             'name': 'ont 78',
                                             'serial_number': '3D0F2',
                                             'system_mac_address': None},
                '00:06:31:15:a9:46': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:46',
                                             'name': 'ont 60',
                                             'serial_number': '3D0F4',
                                             'system_mac_address': None},
                '00:06:31:15:a9:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:15:a9:64',
                                             'name': 'ont 58',
                                             'serial_number': '3D0EF',
                                             'system_mac_address': None},
                '00:06:31:18:c1:01': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c1:01',
                                             'name': 'ont 148',
                                             'serial_number': '3CF4E',
                                             'system_mac_address': None},
                '00:06:31:18:c1:ce': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c1:ce',
                                             'name': 'ont 224',
                                             'serial_number': '3CF9D',
                                             'system_mac_address': None},
                '00:06:31:18:c2:fa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c2:fa',
                                             'name': 'ont 333',
                                             'serial_number': '3CFAA',
                                             'system_mac_address': None},
                '00:06:31:18:c2:ff': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:18:c2:ff',
                                             'name': 'ont 190',
                                             'serial_number': '3CFA0',
                                             'system_mac_address': None},
                '00:06:31:1e:52:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1e:52:10',
                                             'name': 'ont 95',
                                             'serial_number': '3D0E9',
                                             'system_mac_address': None},
                '00:06:31:1e:56:75': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1e:56:75',
                                             'name': 'ont 80',
                                             'serial_number': '3D0F6',
                                             'system_mac_address': None},
                '00:06:31:1f:06:f6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:06:f6',
                                             'name': 'ont 199',
                                             'serial_number': '41542',
                                             'system_mac_address': None},
                '00:06:31:1f:07:23': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:23',
                                             'name': 'ont 61',
                                             'serial_number': '41522',
                                             'system_mac_address': None},
                '00:06:31:1f:07:55': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:55',
                                             'name': 'ont 75',
                                             'serial_number': '41530',
                                             'system_mac_address': None},
                '00:06:31:1f:07:82': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:07:82',
                                             'name': 'ont 97',
                                             'serial_number': '41585',
                                             'system_mac_address': None},
                '00:06:31:1f:08:4f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:08:4f',
                                             'name': 'ont 101',
                                             'serial_number': '41591',
                                             'system_mac_address': None},
                '00:06:31:1f:08:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:1f:08:d6',
                                             'name': 'ont 194',
                                             'serial_number': '41549',
                                             'system_mac_address': None},
                '00:06:31:20:00:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:37',
                                             'name': 'ont 206',
                                             'serial_number': '4157E',
                                             'system_mac_address': None},
                '00:06:31:20:00:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:64',
                                             'name': 'ont 291',
                                             'serial_number': '41535',
                                             'system_mac_address': None},
                '00:06:31:20:00:69': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:00:69',
                                             'name': 'ont 122',
                                             'serial_number': '415B0',
                                             'system_mac_address': None},
                '00:06:31:20:01:45': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:45',
                                             'name': 'ont 207',
                                             'serial_number': '415AB',
                                             'system_mac_address': None},
                '00:06:31:20:01:5e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:5e',
                                             'name': 'ont 54',
                                             'serial_number': '4153F',
                                             'system_mac_address': None},
                '00:06:31:20:01:6d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:6d',
                                             'name': 'ont 281',
                                             'serial_number': '418B8',
                                             'system_mac_address': None},
                '00:06:31:20:01:81': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:81',
                                             'name': 'ont 263',
                                             'serial_number': '418B7',
                                             'system_mac_address': None},
                '00:06:31:20:01:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:01:b8',
                                             'name': 'ont 202',
                                             'serial_number': '4152F',
                                             'system_mac_address': None},
                '00:06:31:20:02:3a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:3a',
                                             'name': 'ont 278',
                                             'serial_number': '4153C',
                                             'system_mac_address': None},
                '00:06:31:20:02:5d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:02:5d',
                                             'name': 'ont 223',
                                             'serial_number': '415FE',
                                             'system_mac_address': None},
                '00:06:31:20:03:2a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:03:2a',
                                             'name': 'ont 143',
                                             'serial_number': '418AC',
                                             'system_mac_address': None},
                '00:06:31:20:03:61': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:03:61',
                                             'name': 'ont 192',
                                             'serial_number': '418B5',
                                             'system_mac_address': None},
                '00:06:31:20:a1:a2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:20:a1:a2',
                                             'name': 'ont 98',
                                             'serial_number': '49340',
                                             'system_mac_address': None},
                '00:06:31:34:38:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:18',
                                             'name': 'ont 331',
                                             'serial_number': '757AC',
                                             'system_mac_address': None},
                '00:06:31:34:38:27': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:27',
                                             'name': 'ont 297',
                                             'serial_number': '757BB',
                                             'system_mac_address': None},
                '00:06:31:34:38:28': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:34:38:28',
                                             'name': 'ont 198',
                                             'serial_number': '757BC',
                                             'system_mac_address': None},
                '00:06:31:3c:5f:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:5f:10',
                                             'name': 'ont 51',
                                             'serial_number': '7FE2A',
                                             'system_mac_address': None},
                '00:06:31:3c:5f:6a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:5f:6a',
                                             'name': 'ont 102',
                                             'serial_number': '7FE84',
                                             'system_mac_address': None},
                '00:06:31:3c:cc:73': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:cc:73',
                                             'name': 'ont 315',
                                             'serial_number': '86B8B',
                                             'system_mac_address': None},
                '00:06:31:3c:cc:a6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:cc:a6',
                                             'name': 'ont 220',
                                             'serial_number': '86BBE',
                                             'system_mac_address': None},
                '00:06:31:3c:d4:0b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:d4:0b',
                                             'name': 'ont 246',
                                             'serial_number': '87323',
                                             'system_mac_address': None},
                '00:06:31:3c:d5:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:d5:37',
                                             'name': 'ont 127',
                                             'serial_number': '8744F',
                                             'system_mac_address': None},
                '00:06:31:3c:ea:9c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:3c:ea:9c',
                                             'name': 'ont 63',
                                             'serial_number': '889B4',
                                             'system_mac_address': None},
                '00:06:31:47:4b:6c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:47:4b:6c',
                                             'name': 'ont 170752',
                                             'serial_number': '8A280',
                                             'system_mac_address': None},
                '00:06:31:57:b0:79': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:57:b0:79',
                                             'name': 'ont 131',
                                             'serial_number': 'A9FB9',
                                             'system_mac_address': None},
                '00:06:31:5f:60:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:60:b4',
                                             'name': 'ont 45',
                                             'serial_number': 'C4FF4',
                                             'system_mac_address': None},
                '00:06:31:5f:60:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:60:d0',
                                             'name': 'ont 254',
                                             'serial_number': 'C5010',
                                             'system_mac_address': None},
                '00:06:31:5f:68:8d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:68:8d',
                                             'name': 'ont 49',
                                             'serial_number': 'C57CD',
                                             'system_mac_address': None},
                '00:06:31:5f:69:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:69:10',
                                             'name': 'ont 157',
                                             'serial_number': 'C5850',
                                             'system_mac_address': None},
                '00:06:31:5f:69:2b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:69:2b',
                                             'name': 'ont 146',
                                             'serial_number': 'C586B',
                                             'system_mac_address': None},
                '00:06:31:5f:d1:76': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:5f:d1:76',
                                             'name': 'ont 200',
                                             'serial_number': 'CC0B6',
                                             'system_mac_address': None},
                '00:06:31:6f:c4:65': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:6f:c4:65',
                                             'name': 'ont 271',
                                             'serial_number': 'F23A5',
                                             'system_mac_address': None},
                '00:06:31:90:39:05': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:39:05',
                                             'name': 'ont 273',
                                             'serial_number': '124845',
                                             'system_mac_address': None},
                '00:06:31:90:f0:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f0:9d',
                                             'name': 'ont 296',
                                             'serial_number': '12FFDD',
                                             'system_mac_address': None},
                '00:06:31:90:f0:ae': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f0:ae',
                                             'name': 'ont 69',
                                             'serial_number': '12FFEE',
                                             'system_mac_address': None},
                '00:06:31:90:f1:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:1f',
                                             'name': 'ont 241',
                                             'serial_number': '13005F',
                                             'system_mac_address': None},
                '00:06:31:90:f1:4b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:4b',
                                             'name': 'ont 242',
                                             'serial_number': '13008B',
                                             'system_mac_address': None},
                '00:06:31:90:f1:4d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:4d',
                                             'name': 'ont 308',
                                             'serial_number': '13008D',
                                             'system_mac_address': None},
                '00:06:31:90:f1:5a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:90:f1:5a',
                                             'name': 'ont 138',
                                             'serial_number': '13009A',
                                             'system_mac_address': None},
                '00:06:31:b7:29:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:29:e8',
                                             'name': 'ont 163',
                                             'serial_number': '161021',
                                             'system_mac_address': None},
                '00:06:31:b7:5c:3e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:5c:3e',
                                             'name': 'ont 335',
                                             'serial_number': '164277',
                                             'system_mac_address': None},
                '00:06:31:b7:5c:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:b7:5c:48',
                                             'name': 'ont 289',
                                             'serial_number': '164281',
                                             'system_mac_address': None},
                '00:06:31:dd:56:87': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:56:87',
                                             'name': 'ont 226',
                                             'serial_number': '175E66',
                                             'system_mac_address': None},
                '00:06:31:dd:56:bf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:56:bf',
                                             'name': 'ont 27',
                                             'serial_number': '175E6D',
                                             'system_mac_address': None},
                '00:06:31:dd:73:d7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:dd:73:d7',
                                             'name': 'ont 317',
                                             'serial_number': '176210',
                                             'system_mac_address': None},
                '00:06:31:e3:f9:63': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:f9:63',
                                             'name': 'ont 112',
                                             'serial_number': '1999C5',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:43': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:43',
                                             'name': 'ont 274',
                                             'serial_number': '1999E1',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:53': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:53',
                                             'name': 'ont 77',
                                             'serial_number': '1999E3',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:83': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:83',
                                             'name': 'ont 125',
                                             'serial_number': '1999E9',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:eb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:eb',
                                             'name': 'ont 309',
                                             'serial_number': '1999F6',
                                             'system_mac_address': None},
                '00:06:31:e3:fa:f3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fa:f3',
                                             'name': 'ont 272',
                                             'serial_number': '1999F7',
                                             'system_mac_address': None},
                '00:06:31:e3:fb:3b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fb:3b',
                                             'name': 'ont 188',
                                             'serial_number': '199A00',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:13': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:13',
                                             'name': 'ont 161',
                                             'serial_number': '199A1B',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:63': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:63',
                                             'name': 'ont 150',
                                             'serial_number': '199A25',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:a3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:a3',
                                             'name': 'ont 287',
                                             'serial_number': '199A2D',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:c3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:c3',
                                             'name': 'ont 94',
                                             'serial_number': '199A31',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:cb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:cb',
                                             'name': 'ont 214',
                                             'serial_number': '199A32',
                                             'system_mac_address': None},
                '00:06:31:e3:fc:eb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fc:eb',
                                             'name': 'ont 64',
                                             'serial_number': '199A36',
                                             'system_mac_address': None},
                '00:06:31:e3:fd:03': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:e3:fd:03',
                                             'name': 'ont 151',
                                             'serial_number': '199A39',
                                             'system_mac_address': None},
                '00:06:31:ff:48:34': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '00:06:31:ff:48:34',
                                             'name': 'ont 302',
                                             'serial_number': '1C4DA9',
                                             'system_mac_address': None},
                '04:bc:9f:00:17:d9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:00:17:d9',
                                             'name': 'ont 231388',
                                             'serial_number': 'EBC2EE',
                                             'system_mac_address': None},
                '04:bc:9f:5c:3f:a1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:3f:a1',
                                             'name': 'ont 218217',
                                             'serial_number': '1274E74',
                                             'system_mac_address': None},
                '04:bc:9f:5c:52:99': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:52:99',
                                             'name': 'ont 217716',
                                             'serial_number': '12750D3',
                                             'system_mac_address': None},
                '04:bc:9f:5c:58:61': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '04:bc:9f:5c:58:61',
                                             'name': 'ont 221110',
                                             'serial_number': '127518C',
                                             'system_mac_address': None},
                '44:65:7f:33:20:d4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:20:d4',
                                             'name': 'ont 343',
                                             'serial_number': '640AE4',
                                             'system_mac_address': None},
                '44:65:7f:33:20:e8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:20:e8',
                                             'name': 'ont 341',
                                             'serial_number': '640AED',
                                             'system_mac_address': None},
                '44:65:7f:33:21:6e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:21:6e',
                                             'name': 'ont 344',
                                             'serial_number': '640B2F',
                                             'system_mac_address': None},
                '44:65:7f:33:21:ae': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:33:21:ae',
                                             'name': 'ont 87',
                                             'serial_number': '640B4F',
                                             'system_mac_address': None},
                '44:65:7f:7b:d3:fa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d3:fa',
                                             'name': 'ont 139198',
                                             'serial_number': '5A6B99',
                                             'system_mac_address': None},
                '44:65:7f:7b:d6:2b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d6:2b',
                                             'name': 'ont 138694',
                                             'serial_number': '5A6C54',
                                             'system_mac_address': None},
                '44:65:7f:7b:d6:e5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d6:e5',
                                             'name': 'ont 139190',
                                             'serial_number': '5A6C92',
                                             'system_mac_address': None},
                '44:65:7f:7b:d7:15': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '44:65:7f:7b:d7:15',
                                             'name': 'ont 138690',
                                             'serial_number': '5A6CA2',
                                             'system_mac_address': None},
                '48:77:46:07:b2:49': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:07:b2:49',
                                             'name': 'ont 40',
                                             'serial_number': '6AC2C7',
                                             'system_mac_address': None},
                '48:77:46:08:95:89': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:08:95:89',
                                             'name': 'ont 79',
                                             'serial_number': '6DBC98',
                                             'system_mac_address': None},
                '48:77:46:3a:58:0a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:58:0a',
                                             'name': 'ont 303',
                                             'serial_number': '721D1C',
                                             'system_mac_address': None},
                '48:77:46:3a:71:12': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:71:12',
                                             'name': 'ont 88',
                                             'serial_number': '72203D',
                                             'system_mac_address': None},
                '48:77:46:3a:71:32': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:71:32',
                                             'name': 'ont 277',
                                             'serial_number': '722041',
                                             'system_mac_address': None},
                '48:77:46:3a:72:52': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:72:52',
                                             'name': 'ont 124',
                                             'serial_number': '722065',
                                             'system_mac_address': None},
                '48:77:46:3a:7f:c2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3a:7f:c2',
                                             'name': 'ont 120',
                                             'serial_number': '722213',
                                             'system_mac_address': None},
                '48:77:46:3b:21:9a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3b:21:9a',
                                             'name': 'ont 316',
                                             'serial_number': '72364E',
                                             'system_mac_address': None},
                '48:77:46:3b:3f:aa': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:3b:3f:aa',
                                             'name': 'ont 171719',
                                             'serial_number': '723A10',
                                             'system_mac_address': None},
                '48:77:46:8c:12:34': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:8c:12:34',
                                             'name': 'ont 330',
                                             'serial_number': '76ACE8',
                                             'system_mac_address': None},
                '48:77:46:a2:1b:1c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a2:1b:1c',
                                             'name': 'ont 55',
                                             'serial_number': '71A492',
                                             'system_mac_address': None},
                '48:77:46:a2:1d:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a2:1d:64',
                                             'name': 'ont 332',
                                             'serial_number': '71A4DB',
                                             'system_mac_address': None},
                '48:77:46:a3:8d:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:8d:b4',
                                             'name': 'ont 59',
                                             'serial_number': '71D2E5',
                                             'system_mac_address': None},
                '48:77:46:a3:b6:dc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:b6:dc',
                                             'name': 'ont 155',
                                             'serial_number': '71D80A',
                                             'system_mac_address': None},
                '48:77:46:a3:bb:44': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:bb:44',
                                             'name': 'ont 22',
                                             'serial_number': '71D897',
                                             'system_mac_address': None},
                '48:77:46:a3:bb:8c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:a3:bb:8c',
                                             'name': 'ont 244',
                                             'serial_number': '71D8A0',
                                             'system_mac_address': None},
                '48:77:46:cd:52:5e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:cd:52:5e',
                                             'name': 'ont 81',
                                             'serial_number': '76CFF8',
                                             'system_mac_address': None},
                '48:77:46:ce:1f:1e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:1f:1e',
                                             'name': 'ont 182',
                                             'serial_number': '76E990',
                                             'system_mac_address': None},
                '48:77:46:ce:20:6e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:20:6e',
                                             'name': 'ont 318',
                                             'serial_number': '76E9BA',
                                             'system_mac_address': None},
                '48:77:46:ce:63:7e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:ce:63:7e',
                                             'name': 'ont 217',
                                             'serial_number': '76F21C',
                                             'system_mac_address': None},
                '48:77:46:f8:75:8c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:f8:75:8c',
                                             'name': 'ont 140939',
                                             'serial_number': '82A55A',
                                             'system_mac_address': None},
                '60:db:98:4e:6b:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:6b:64',
                                             'name': 'ont 146196',
                                             'serial_number': 'A9C32C',
                                             'system_mac_address': None},
                '60:db:98:4e:8e:34': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:8e:34',
                                             'name': 'ont 85',
                                             'serial_number': 'A9C786',
                                             'system_mac_address': None},
                '60:db:98:4e:90:0c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:90:0c',
                                             'name': 'ont 147376',
                                             'serial_number': 'A9C7C1',
                                             'system_mac_address': None},
                '60:db:98:4e:96:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:96:cc',
                                             'name': 'ont 147397',
                                             'serial_number': 'A9C899',
                                             'system_mac_address': None},
                '60:db:98:4e:99:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:99:cc',
                                             'name': 'ont 114',
                                             'serial_number': 'A9C8F9',
                                             'system_mac_address': None},
                '60:db:98:4e:9b:8c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:4e:9b:8c',
                                             'name': 'ont 156456',
                                             'serial_number': 'A9C931',
                                             'system_mac_address': None},
                '60:db:98:73:9c:74': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:73:9c:74',
                                             'name': 'ont 150872',
                                             'serial_number': 'B0A2A0',
                                             'system_mac_address': None},
                '60:db:98:8e:fe:5a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:fe:5a',
                                             'name': 'ont 36',
                                             'serial_number': 'B510E2',
                                             'system_mac_address': None},
                '60:db:98:8e:ff:a7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8e:ff:a7',
                                             'name': 'ont 151202',
                                             'serial_number': 'B51151',
                                             'system_mac_address': None},
                '60:db:98:8f:01:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:01:6f',
                                             'name': 'ont 152349',
                                             'serial_number': 'B511E9',
                                             'system_mac_address': None},
                '60:db:98:8f:01:d5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:01:d5',
                                             'name': 'ont 154903',
                                             'serial_number': 'B5120B',
                                             'system_mac_address': None},
                '60:db:98:8f:02:05': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '60:db:98:8f:02:05',
                                             'name': 'ont 156418',
                                             'serial_number': 'B5121B',
                                             'system_mac_address': None},
                '84:d3:43:7c:e3:b7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7c:e3:b7',
                                             'name': 'ont 157753',
                                             'serial_number': 'C811E0',
                                             'system_mac_address': None},
                '84:d3:43:7d:04:3f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:04:3f',
                                             'name': 'ont 207352',
                                             'serial_number': 'C815F1',
                                             'system_mac_address': None},
                '84:d3:43:7d:1d:57': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:1d:57',
                                             'name': 'ont 196224',
                                             'serial_number': 'C81914',
                                             'system_mac_address': None},
                '84:d3:43:7d:36:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:36:97',
                                             'name': 'ont 205251',
                                             'serial_number': 'C81C3C',
                                             'system_mac_address': None},
                '84:d3:43:7d:36:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:36:af',
                                             'name': 'ont 212',
                                             'serial_number': 'C81C3F',
                                             'system_mac_address': None},
                '84:d3:43:7d:38:8f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:38:8f',
                                             'name': 'ont 207149',
                                             'serial_number': 'C81C7B',
                                             'system_mac_address': None},
                '84:d3:43:7d:3a:a7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:3a:a7',
                                             'name': 'ont 206680',
                                             'serial_number': 'C81CBE',
                                             'system_mac_address': None},
                '84:d3:43:7d:40:2f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:40:2f',
                                             'name': 'ont 211653',
                                             'serial_number': 'C81D6F',
                                             'system_mac_address': None},
                '84:d3:43:7d:42:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:42:6f',
                                             'name': 'ont 207830',
                                             'serial_number': 'C81DB7',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:37',
                                             'name': 'ont 198224',
                                             'serial_number': 'C81DD0',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:47': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:47',
                                             'name': 'ont 229',
                                             'serial_number': 'C81DD2',
                                             'system_mac_address': None},
                '84:d3:43:7d:43:8f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:43:8f',
                                             'name': 'ont 138007',
                                             'serial_number': 'C81DDB',
                                             'system_mac_address': None},
                '84:d3:43:7d:44:bf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:44:bf',
                                             'name': 'ont 205456',
                                             'serial_number': 'C81E01',
                                             'system_mac_address': None},
                '84:d3:43:7d:46:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:46:37',
                                             'name': 'ont 206490',
                                             'serial_number': 'C81E30',
                                             'system_mac_address': None},
                '84:d3:43:7d:46:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:46:af',
                                             'name': 'ont 207362',
                                             'serial_number': 'C81E3F',
                                             'system_mac_address': None},
                '84:d3:43:7d:4e:c7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:4e:c7',
                                             'name': 'ont 280',
                                             'serial_number': 'C81F42',
                                             'system_mac_address': None},
                '84:d3:43:7d:5e:3f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:5e:3f',
                                             'name': 'ont 161657',
                                             'serial_number': 'C82131',
                                             'system_mac_address': None},
                '84:d3:43:7d:d9:4f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:d9:4f',
                                             'name': 'ont 313',
                                             'serial_number': 'C83093',
                                             'system_mac_address': None},
                '84:d3:43:7d:e5:47': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7d:e5:47',
                                             'name': 'ont 153',
                                             'serial_number': 'C83212',
                                             'system_mac_address': None},
                '84:d3:43:7e:15:87': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:15:87',
                                             'name': 'ont 160996',
                                             'serial_number': 'C8381A',
                                             'system_mac_address': None},
                '84:d3:43:7e:30:27': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:30:27',
                                             'name': 'ont 170722',
                                             'serial_number': 'C83B6E',
                                             'system_mac_address': None},
                '84:d3:43:7e:30:d7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:30:d7',
                                             'name': 'ont 170672',
                                             'serial_number': 'C83B84',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:6f',
                                             'name': 'ont 170712',
                                             'serial_number': 'C83B97',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:77': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:77',
                                             'name': 'ont 171709',
                                             'serial_number': 'C83B98',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:97',
                                             'name': 'ont 193622',
                                             'serial_number': 'C83B9C',
                                             'system_mac_address': None},
                '84:d3:43:7e:31:cf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:31:cf',
                                             'name': 'ont 168564',
                                             'serial_number': 'C83BA3',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:0f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:0f',
                                             'name': 'ont 164207',
                                             'serial_number': 'C83BAB',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:27': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:27',
                                             'name': 'ont 166121',
                                             'serial_number': 'C83BAE',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:37',
                                             'name': 'ont 106',
                                             'serial_number': 'C83BB0',
                                             'system_mac_address': None},
                '84:d3:43:7e:32:8f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:32:8f',
                                             'name': 'ont 172309',
                                             'serial_number': 'C83BBB',
                                             'system_mac_address': None},
                '84:d3:43:7e:33:17': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:33:17',
                                             'name': 'ont 166658',
                                             'serial_number': 'C83BCC',
                                             'system_mac_address': None},
                '84:d3:43:7e:33:87': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:33:87',
                                             'name': 'ont 171987',
                                             'serial_number': 'C83BDA',
                                             'system_mac_address': None},
                '84:d3:43:7e:34:4f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:34:4f',
                                             'name': 'ont 298',
                                             'serial_number': 'C83BF3',
                                             'system_mac_address': None},
                '84:d3:43:7e:34:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:34:97',
                                             'name': 'ont 161647',
                                             'serial_number': 'C83BFC',
                                             'system_mac_address': None},
                '84:d3:43:7e:35:17': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:35:17',
                                             'name': 'ont 174464',
                                             'serial_number': 'C83C0C',
                                             'system_mac_address': None},
                '84:d3:43:7e:45:07': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:7e:45:07',
                                             'name': 'ont 161607',
                                             'serial_number': 'C83E0A',
                                             'system_mac_address': None},
                '84:d3:43:95:93:da': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:95:93:da',
                                             'name': 'ont 165050',
                                             'serial_number': 'CBD29A',
                                             'system_mac_address': None},
                '84:d3:43:96:01:9a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '84:d3:43:96:01:9a',
                                             'name': 'ont 168459',
                                             'serial_number': 'CBE052',
                                             'system_mac_address': None},
                'b8:94:70:ba:e1:a5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e1:a5',
                                             'name': 'ont 215969',
                                             'serial_number': '1195149',
                                             'system_mac_address': None},
                'b8:94:70:ba:e1:e5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e1:e5',
                                             'name': 'ont 214620',
                                             'serial_number': '1195151',
                                             'system_mac_address': None},
                'b8:94:70:ba:e2:35': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e2:35',
                                             'name': 'ont 212620',
                                             'serial_number': '119515B',
                                             'system_mac_address': None},
                'b8:94:70:ba:e4:a5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:ba:e4:a5',
                                             'name': 'ont 216009',
                                             'serial_number': '11951A9',
                                             'system_mac_address': None},
                'b8:94:70:c6:e9:57': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c6:e9:57',
                                             'name': 'ont 212580',
                                             'serial_number': '11B2235',
                                             'system_mac_address': None},
                'b8:94:70:c6:ed:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c6:ed:97',
                                             'name': 'ont 212088',
                                             'serial_number': '11B22BD',
                                             'system_mac_address': None},
                'b8:94:70:c7:04:f7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'b8:94:70:c7:04:f7',
                                             'name': 'ont 215783',
                                             'serial_number': '11B25A9',
                                             'system_mac_address': None},
                'cc:be:59:04:29:90': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:04:29:90',
                                             'name': 'ont 18',
                                             'serial_number': '3EBA19',
                                             'system_mac_address': None},
                'cc:be:59:04:2b:60': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:04:2b:60',
                                             'name': 'ont 230',
                                             'serial_number': '3EBA53',
                                             'system_mac_address': None},
                'cc:be:59:0c:b5:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0c:b5:b4',
                                             'name': 'ont 17',
                                             'serial_number': '3ADD6E',
                                             'system_mac_address': None},
                'cc:be:59:0c:b5:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0c:b5:cc',
                                             'name': 'ont 1',
                                             'serial_number': '3ADD71',
                                             'system_mac_address': None},
                'cc:be:59:0d:27:04': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:27:04',
                                             'name': 'ont 240',
                                             'serial_number': '3AEB98',
                                             'system_mac_address': None},
                'cc:be:59:0d:27:f4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:27:f4',
                                             'name': 'ont 239',
                                             'serial_number': '3AEBB6',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:2c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:2c',
                                             'name': 'ont 238',
                                             'serial_number': '3AEBBD',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:44': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:44',
                                             'name': 'ont 108',
                                             'serial_number': '3AEBC0',
                                             'system_mac_address': None},
                'cc:be:59:0d:28:84': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:28:84',
                                             'name': 'ont 237',
                                             'serial_number': '3AEBC8',
                                             'system_mac_address': None},
                'cc:be:59:0d:2b:3c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:2b:3c',
                                             'name': 'ont 236',
                                             'serial_number': '3AEC1F',
                                             'system_mac_address': None},
                'cc:be:59:0d:2b:4c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:0d:2b:4c',
                                             'name': 'ont 16',
                                             'serial_number': '3AEC21',
                                             'system_mac_address': None},
                'cc:be:59:2b:a9:47': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:2b:a9:47',
                                             'name': 'ont 28',
                                             'serial_number': '3FB35D',
                                             'system_mac_address': None},
                'cc:be:59:46:c9:cf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:46:c9:cf',
                                             'name': 'ont 211',
                                             'serial_number': '39507A',
                                             'system_mac_address': None},
                'cc:be:59:47:32:bf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:47:32:bf',
                                             'name': 'ont 299',
                                             'serial_number': '433E5F',
                                             'system_mac_address': None},
                'cc:be:59:50:17:31': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:17:31',
                                             'name': 'ont 13',
                                             'serial_number': '43C21A',
                                             'system_mac_address': None},
                'cc:be:59:50:17:95': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:17:95',
                                             'name': 'ont 8',
                                             'serial_number': '43C24C',
                                             'system_mac_address': None},
                'cc:be:59:50:1a:b7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:50:1a:b7',
                                             'name': 'ont 7',
                                             'serial_number': '43C3DD',
                                             'system_mac_address': None},
                'cc:be:59:52:6d:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:52:6d:37',
                                             'name': 'ont 21',
                                             'serial_number': '3FC3C2',
                                             'system_mac_address': None},
                'cc:be:59:54:25:2f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:54:25:2f',
                                             'name': 'ont 96',
                                             'serial_number': '3FFAB9',
                                             'system_mac_address': None},
                'cc:be:59:5f:16:62': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:5f:16:62',
                                             'name': 'ont 113',
                                             'serial_number': '455673',
                                             'system_mac_address': None},
                'cc:be:59:6a:dd:5e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6a:dd:5e',
                                             'name': 'ont 328',
                                             'serial_number': '46CE0A',
                                             'system_mac_address': None},
                'cc:be:59:6d:3d:5e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:3d:5e',
                                             'name': 'ont 261',
                                             'serial_number': '3FFFE3',
                                             'system_mac_address': None},
                'cc:be:59:6d:5a:be': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:5a:be',
                                             'name': 'ont 219',
                                             'serial_number': '40038F',
                                             'system_mac_address': None},
                'cc:be:59:6d:5c:e6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:5c:e6',
                                             'name': 'ont 228',
                                             'serial_number': '4003D4',
                                             'system_mac_address': None},
                'cc:be:59:6d:60:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:60:ee',
                                             'name': 'ont 249',
                                             'serial_number': '400455',
                                             'system_mac_address': None},
                'cc:be:59:6d:7e:3e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:7e:3e',
                                             'name': 'ont 276',
                                             'serial_number': '4007FF',
                                             'system_mac_address': None},
                'cc:be:59:6d:85:26': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:85:26',
                                             'name': 'ont 307',
                                             'serial_number': '4008DC',
                                             'system_mac_address': None},
                'cc:be:59:6d:b9:be': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:b9:be',
                                             'name': 'ont 243',
                                             'serial_number': '400F64',
                                             'system_mac_address': None},
                'cc:be:59:6d:e8:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:e8:d6',
                                             'name': 'ont 209',
                                             'serial_number': '4703AF',
                                             'system_mac_address': None},
                'cc:be:59:6d:fa:d2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6d:fa:d2',
                                             'name': 'ont 193',
                                             'serial_number': '4705ED',
                                             'system_mac_address': None},
                'cc:be:59:6e:14:ca': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:14:ca',
                                             'name': 'ont 33',
                                             'serial_number': '47092C',
                                             'system_mac_address': None},
                'cc:be:59:6e:6e:da': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:6e:da',
                                             'name': 'ont 191',
                                             'serial_number': '47146E',
                                             'system_mac_address': None},
                'cc:be:59:6e:ae:96': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6e:ae:96',
                                             'name': 'ont 224679',
                                             'serial_number': '471C63',
                                             'system_mac_address': None},
                'cc:be:59:6f:1d:c2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:1d:c2',
                                             'name': 'ont 99',
                                             'serial_number': '55DFB1',
                                             'system_mac_address': None},
                'cc:be:59:6f:29:52': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:29:52',
                                             'name': 'ont 111',
                                             'serial_number': '55E123',
                                             'system_mac_address': None},
                'cc:be:59:6f:74:d2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:74:d2',
                                             'name': 'ont 47',
                                             'serial_number': '55EA90',
                                             'system_mac_address': None},
                'cc:be:59:6f:fd:92': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:fd:92',
                                             'name': 'ont 73',
                                             'serial_number': '55FBA5',
                                             'system_mac_address': None},
                'cc:be:59:6f:ff:1a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:6f:ff:1a',
                                             'name': 'ont 159',
                                             'serial_number': '55FBD6',
                                             'system_mac_address': None},
                'cc:be:59:70:33:7e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:33:7e',
                                             'name': 'ont 38',
                                             'serial_number': '560262',
                                             'system_mac_address': None},
                'cc:be:59:70:33:86': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:33:86',
                                             'name': 'ont 70',
                                             'serial_number': '560263',
                                             'system_mac_address': None},
                'cc:be:59:70:81:36': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:70:81:36',
                                             'name': 'ont 67',
                                             'serial_number': '560C19',
                                             'system_mac_address': None},
                'cc:be:59:af:a5:9b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:af:a5:9b',
                                             'name': 'ont 126',
                                             'serial_number': '4E36A8',
                                             'system_mac_address': None},
                'cc:be:59:af:d8:7b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:af:d8:7b',
                                             'name': 'ont 119',
                                             'serial_number': '4E3D04',
                                             'system_mac_address': None},
                'cc:be:59:b3:7c:9b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:b3:7c:9b',
                                             'name': 'ont 195',
                                             'serial_number': '4EB17D',
                                             'system_mac_address': None},
                'cc:be:59:b7:3b:67': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:b7:3b:67',
                                             'name': 'ont 203',
                                             'serial_number': '4D111F',
                                             'system_mac_address': None},
                'cc:be:59:ca:db:7a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:db:7a',
                                             'name': 'ont 231',
                                             'serial_number': '42816E',
                                             'system_mac_address': None},
                'cc:be:59:ca:dc:92': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:dc:92',
                                             'name': 'ont 35',
                                             'serial_number': '428191',
                                             'system_mac_address': None},
                'cc:be:59:ca:de:8a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ca:de:8a',
                                             'name': 'ont 32',
                                             'serial_number': '4281D0',
                                             'system_mac_address': None},
                'cc:be:59:cb:43:da': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:43:da',
                                             'name': 'ont 10',
                                             'serial_number': '42B9D3',
                                             'system_mac_address': None},
                'cc:be:59:cb:44:72': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:44:72',
                                             'name': 'ont 46',
                                             'serial_number': '42B9E6',
                                             'system_mac_address': None},
                'cc:be:59:cb:6c:5a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:6c:5a',
                                             'name': 'ont 345',
                                             'serial_number': '42BEE3',
                                             'system_mac_address': None},
                'cc:be:59:cb:7e:02': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:7e:02',
                                             'name': 'ont 91',
                                             'serial_number': '42C118',
                                             'system_mac_address': None},
                'cc:be:59:cb:95:e2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:95:e2',
                                             'name': 'ont 5',
                                             'serial_number': '42C414',
                                             'system_mac_address': None},
                'cc:be:59:cb:bb:ba': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bb:ba',
                                             'name': 'ont 76',
                                             'serial_number': '42C8CF',
                                             'system_mac_address': None},
                'cc:be:59:cb:bd:12': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bd:12',
                                             'name': 'ont 326',
                                             'serial_number': '42C8FA',
                                             'system_mac_address': None},
                'cc:be:59:cb:bf:3a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:bf:3a',
                                             'name': 'ont 92',
                                             'serial_number': '42C93F',
                                             'system_mac_address': None},
                'cc:be:59:cb:ea:02': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cb:ea:02',
                                             'name': 'ont 86',
                                             'serial_number': '42CE98',
                                             'system_mac_address': None},
                'cc:be:59:cc:03:2a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:03:2a',
                                             'name': 'ont 89',
                                             'serial_number': '42D1BD',
                                             'system_mac_address': None},
                'cc:be:59:cc:0b:1a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:0b:1a',
                                             'name': 'ont 83',
                                             'serial_number': '42D2BB',
                                             'system_mac_address': None},
                'cc:be:59:cc:11:3a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:11:3a',
                                             'name': 'ont 82',
                                             'serial_number': '42D37F',
                                             'system_mac_address': None},
                'cc:be:59:cc:11:ba': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:cc:11:ba',
                                             'name': 'ont 19',
                                             'serial_number': '42D38F',
                                             'system_mac_address': None},
                'cc:be:59:eb:02:16': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:02:16',
                                             'name': 'ont 269',
                                             'serial_number': '555CB8',
                                             'system_mac_address': None},
                'cc:be:59:eb:39:ae': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:39:ae',
                                             'name': 'ont 250',
                                             'serial_number': '5563AB',
                                             'system_mac_address': None},
                'cc:be:59:eb:39:be': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:39:be',
                                             'name': 'ont 65',
                                             'serial_number': '5563AD',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:06': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:06',
                                             'name': 'ont 245',
                                             'serial_number': '5563B6',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:de': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:de',
                                             'name': 'ont 26',
                                             'serial_number': '5563D1',
                                             'system_mac_address': None},
                'cc:be:59:eb:3a:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3a:ee',
                                             'name': 'ont 336',
                                             'serial_number': '5563D3',
                                             'system_mac_address': None},
                'cc:be:59:eb:3b:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:eb:3b:d6',
                                             'name': 'ont 304',
                                             'serial_number': '5563F0',
                                             'system_mac_address': None},
                'cc:be:59:ef:f4:de': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f4:de',
                                             'name': 'ont 42',
                                             'serial_number': '4D41EE',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:0e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:0e',
                                             'name': 'ont 29',
                                             'serial_number': '4D41F4',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:16': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:16',
                                             'name': 'ont 247',
                                             'serial_number': '4D41F5',
                                             'system_mac_address': None},
                'cc:be:59:ef:f5:26': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f5:26',
                                             'name': 'ont 257',
                                             'serial_number': '4D41F7',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:56': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:56',
                                             'name': 'ont 253',
                                             'serial_number': '4D423D',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:7e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:7e',
                                             'name': 'ont 275',
                                             'serial_number': '4D4242',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:d6',
                                             'name': 'ont 319',
                                             'serial_number': '4D424D',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:e6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:e6',
                                             'name': 'ont 218',
                                             'serial_number': '4D424F',
                                             'system_mac_address': None},
                'cc:be:59:ef:f7:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'cc:be:59:ef:f7:ee',
                                             'name': 'ont 6',
                                             'serial_number': '4D4250',
                                             'system_mac_address': None},
                'd0:76:8f:06:e5:fe': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:06:e5:fe',
                                             'name': 'ont 140853',
                                             'serial_number': '844BE5',
                                             'system_mac_address': None},
                'd0:76:8f:07:19:91': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:07:19:91',
                                             'name': 'ont 347',
                                             'serial_number': '8678B6',
                                             'system_mac_address': None},
                'd0:76:8f:08:14:ab': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:14:ab',
                                             'name': 'ont 156430',
                                             'serial_number': '86938B',
                                             'system_mac_address': None},
                'd0:76:8f:08:15:33': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:15:33',
                                             'name': 'ont 138881',
                                             'serial_number': '86939C',
                                             'system_mac_address': None},
                'd0:76:8f:08:16:83': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:16:83',
                                             'name': 'ont 142356',
                                             'serial_number': '8693C6',
                                             'system_mac_address': None},
                'd0:76:8f:08:17:4b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:17:4b',
                                             'name': 'ont 90',
                                             'serial_number': '8693DF',
                                             'system_mac_address': None},
                'd0:76:8f:08:18:33': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:18:33',
                                             'name': 'ont 138680',
                                             'serial_number': '8693FC',
                                             'system_mac_address': None},
                'd0:76:8f:08:19:1b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:08:19:1b',
                                             'name': 'ont 142326',
                                             'serial_number': '869419',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:6b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:6b',
                                             'name': 'ont 31',
                                             'serial_number': '87241B',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:bb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:bb',
                                             'name': 'ont 143043',
                                             'serial_number': '872425',
                                             'system_mac_address': None},
                'd0:76:8f:1b:9e:e3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:9e:e3',
                                             'name': 'ont 15',
                                             'serial_number': '87242A',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a0:83': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a0:83',
                                             'name': 'ont 210',
                                             'serial_number': '87245E',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a1:13': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a1:13',
                                             'name': 'ont 53',
                                             'serial_number': '872470',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a1:1b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a1:1b',
                                             'name': 'ont 144446',
                                             'serial_number': '872471',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a5:73': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a5:73',
                                             'name': 'ont 314',
                                             'serial_number': '8724FC',
                                             'system_mac_address': None},
                'd0:76:8f:1b:a7:3b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1b:a7:3b',
                                             'name': 'ont 136',
                                             'serial_number': '872535',
                                             'system_mac_address': None},
                'd0:76:8f:a9:53:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:a9:53:88',
                                             'name': 'ont 143882',
                                             'serial_number': '954F45',
                                             'system_mac_address': None},
                'd0:76:8f:aa:4e:f4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:4e:f4',
                                             'name': 'ont 20',
                                             'serial_number': '956F04',
                                             'system_mac_address': None},
                'd0:76:8f:aa:4f:e4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:4f:e4',
                                             'name': 'ont 282',
                                             'serial_number': '956F22',
                                             'system_mac_address': None},
                'd0:76:8f:aa:50:04': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:50:04',
                                             'name': 'ont 146001',
                                             'serial_number': '956F26',
                                             'system_mac_address': None},
                'd0:76:8f:aa:54:0c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:aa:54:0c',
                                             'name': 'ont 145630',
                                             'serial_number': '956FA7',
                                             'system_mac_address': None},
                'ec:4f:82:02:06:79': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:02:06:79',
                                             'name': 'ont 232',
                                             'serial_number': '1F7DA1',
                                             'system_mac_address': None},
                'ec:4f:82:08:2e:cd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:08:2e:cd',
                                             'name': 'ont 93',
                                             'serial_number': '1C5DCF',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:97',
                                             'name': 'ont 34',
                                             'serial_number': '248AC3',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:a7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:a7',
                                             'name': 'ont 260',
                                             'serial_number': '248AC5',
                                             'system_mac_address': None},
                'ec:4f:82:32:25:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:25:af',
                                             'name': 'ont 320',
                                             'serial_number': '248AC6',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:0f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:0f',
                                             'name': 'ont 312',
                                             'serial_number': '248AD2',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:37': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:37',
                                             'name': 'ont 164',
                                             'serial_number': '248AD7',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:97': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:97',
                                             'name': 'ont 248',
                                             'serial_number': '248AE3',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:af',
                                             'name': 'ont 162',
                                             'serial_number': '248AE6',
                                             'system_mac_address': None},
                'ec:4f:82:32:26:cf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:26:cf',
                                             'name': 'ont 327',
                                             'serial_number': '248AEA',
                                             'system_mac_address': None},
                'ec:4f:82:32:27:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:32:27:1f',
                                             'name': 'ont 329',
                                             'serial_number': '248AF4',
                                             'system_mac_address': None},
                'ec:4f:82:33:d5:0f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:33:d5:0f',
                                             'name': 'ont 72',
                                             'serial_number': '1FC4EF',
                                             'system_mac_address': None},
                'ec:4f:82:44:18:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:44:18:1f',
                                             'name': 'ont 265',
                                             'serial_number': '23A003',
                                             'system_mac_address': None},
                'ec:4f:82:4c:a5:67': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:4c:a5:67',
                                             'name': 'ont 227',
                                             'serial_number': '25B5F9',
                                             'system_mac_address': None},
                'ec:4f:82:59:55:07': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:59:55:07',
                                             'name': 'ont 234',
                                             'serial_number': '2AA878',
                                             'system_mac_address': None},
                'ec:4f:82:59:5b:77': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:59:5b:77',
                                             'name': 'ont 233',
                                             'serial_number': '2AA946',
                                             'system_mac_address': None},
                'ec:4f:82:67:6d:cd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:6d:cd',
                                             'name': 'ont 279',
                                             'serial_number': '25D8AE',
                                             'system_mac_address': None},
                'ec:4f:82:67:71:b5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:71:b5',
                                             'name': 'ont 324',
                                             'serial_number': '25D92B',
                                             'system_mac_address': None},
                'ec:4f:82:67:71:fd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:67:71:fd',
                                             'name': 'ont 110',
                                             'serial_number': '25D934',
                                             'system_mac_address': None},
                'ec:4f:82:7a:23:67': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:7a:23:67',
                                             'name': 'ont 197',
                                             'serial_number': '2F3AD9',
                                             'system_mac_address': None},
                'ec:4f:82:8d:3f:60': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:3f:60',
                                             'name': 'ont 44',
                                             'serial_number': '321033',
                                             'system_mac_address': None},
                'ec:4f:82:8d:4b:60': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:4b:60',
                                             'name': 'ont 4',
                                             'serial_number': '3211B3',
                                             'system_mac_address': None},
                'ec:4f:82:8d:76:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:76:88',
                                             'name': 'ont 12',
                                             'serial_number': '321718',
                                             'system_mac_address': None},
                'ec:4f:82:8d:7a:d8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:7a:d8',
                                             'name': 'ont 14',
                                             'serial_number': '3217A2',
                                             'system_mac_address': None},
                'ec:4f:82:8d:7c:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:7c:18',
                                             'name': 'ont 11',
                                             'serial_number': '3217CA',
                                             'system_mac_address': None},
                'ec:4f:82:8d:88:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:88:88',
                                             'name': 'ont 30',
                                             'serial_number': '321958',
                                             'system_mac_address': None},
                'ec:4f:82:8d:dc:60': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:dc:60',
                                             'name': 'ont 43',
                                             'serial_number': '3223D3',
                                             'system_mac_address': None},
                'ec:4f:82:8d:dd:90': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8d:dd:90',
                                             'name': 'ont 9',
                                             'serial_number': '3223F9',
                                             'system_mac_address': None},
                'ec:4f:82:8e:00:f0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8e:00:f0',
                                             'name': 'ont 23',
                                             'serial_number': '322865',
                                             'system_mac_address': None},
                'ec:4f:82:8e:05:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:8e:05:d0',
                                             'name': 'ont 3',
                                             'serial_number': '322901',
                                             'system_mac_address': None},
                'ec:4f:82:92:f6:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:f6:18',
                                             'name': 'ont 285',
                                             'serial_number': '32954F',
                                             'system_mac_address': None},
                'ec:4f:82:92:fa:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fa:80',
                                             'name': 'ont 104',
                                             'serial_number': '3295DC',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:50': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:50',
                                             'name': 'ont 300',
                                             'serial_number': '329636',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:80',
                                             'name': 'ont 39',
                                             'serial_number': '32963C',
                                             'system_mac_address': None},
                'ec:4f:82:92:fd:b0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:92:fd:b0',
                                             'name': 'ont 142',
                                             'serial_number': '329642',
                                             'system_mac_address': None},
                'ec:4f:82:9b:b6:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:9b:b6:b4',
                                             'name': 'ont 235',
                                             'serial_number': '33AD09',
                                             'system_mac_address': None},
                'ec:4f:82:9c:fa:6c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:9c:fa:6c',
                                             'name': 'ont 2',
                                             'serial_number': '33D580',
                                             'system_mac_address': None},
                'ec:4f:82:a2:ae:49': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:a2:ae:49',
                                             'name': 'ont 148125',
                                             'serial_number': '349D6E',
                                             'system_mac_address': None},
                'ec:4f:82:b8:2c:40': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:2c:40',
                                             'name': 'ont 270',
                                             'serial_number': '2FCC31',
                                             'system_mac_address': None},
                'ec:4f:82:b8:2c:78': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:2c:78',
                                             'name': 'ont 176',
                                             'serial_number': '2FCC38',
                                             'system_mac_address': None},
                'ec:4f:82:b8:31:c0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b8:31:c0',
                                             'name': 'ont 166',
                                             'serial_number': '2FCCE1',
                                             'system_mac_address': None},
                'ec:4f:82:b9:18:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:18:80',
                                             'name': 'ont 105',
                                             'serial_number': '2FE9BA',
                                             'system_mac_address': None},
                'ec:4f:82:b9:1a:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:1a:48',
                                             'name': 'ont 288',
                                             'serial_number': '2FE9F3',
                                             'system_mac_address': None},
                'ec:4f:82:b9:1a:c8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:b9:1a:c8',
                                             'name': 'ont 24',
                                             'serial_number': '2FEA03',
                                             'system_mac_address': None},
                'ec:4f:82:be:ac:21': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:be:ac:21',
                                             'name': 'ont 165',
                                             'serial_number': '3788C1',
                                             'system_mac_address': None},
                'ec:4f:82:c0:c3:b0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:c0:c3:b0',
                                             'name': 'ont 201',
                                             'serial_number': '3655A9',
                                             'system_mac_address': None},
                'ec:4f:82:cb:05:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:05:18',
                                             'name': 'ont 310',
                                             'serial_number': '2C9A0E',
                                             'system_mac_address': None},
                'ec:4f:82:cb:2b:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:2b:48',
                                             'name': 'ont 117',
                                             'serial_number': '2C9ED4',
                                             'system_mac_address': None},
                'ec:4f:82:cb:4d:14': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:4d:14',
                                             'name': 'ont 284',
                                             'serial_number': '2CA30D',
                                             'system_mac_address': None},
                'ec:4f:82:cb:9e:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:9e:b8',
                                             'name': 'ont 306',
                                             'serial_number': '38F111',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a2:88': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a2:88',
                                             'name': 'ont 166768',
                                             'serial_number': '38F18B',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a5:80': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a5:80',
                                             'name': 'ont 293',
                                             'serial_number': '38F1EA',
                                             'system_mac_address': None},
                'ec:4f:82:cb:a6:18': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cb:a6:18',
                                             'name': 'ont 109',
                                             'serial_number': '38F1FD',
                                             'system_mac_address': None},
                'ec:4f:82:cc:6c:04': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:cc:6c:04',
                                             'name': 'ont 103',
                                             'serial_number': '390AB8',
                                             'system_mac_address': None},
                'ec:4f:82:da:ad:58': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:da:ad:58',
                                             'name': 'ont 135',
                                             'serial_number': '2E914A',
                                             'system_mac_address': None},
                'ec:4f:82:db:f0:ec': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:db:f0:ec',
                                             'name': 'ont 25',
                                             'serial_number': '2EB9B8',
                                             'system_mac_address': None},
                'ec:4f:82:dc:a5:2c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:a5:2c',
                                             'name': 'ont 294',
                                             'serial_number': '2ED03F',
                                             'system_mac_address': None},
                'ec:4f:82:dc:f1:b4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:f1:b4',
                                             'name': 'ont 74',
                                             'serial_number': '2ED9D0',
                                             'system_mac_address': None},
                'ec:4f:82:dc:f2:dc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:dc:f2:dc',
                                             'name': 'ont 222',
                                             'serial_number': '2ED9F5',
                                             'system_mac_address': None},
                'ec:4f:82:e0:0a:e0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'ec:4f:82:e0:0a:e0',
                                             'name': 'ont 50',
                                             'serial_number': '3961A9',
                                             'system_mac_address': None},
                'f8:85:f9:06:4e:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:4e:64',
                                             'name': 'ont 258',
                                             'serial_number': 'BF1E1B',
                                             'system_mac_address': None},
                'f8:85:f9:06:6c:cc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:6c:cc',
                                             'name': 'ont 164063',
                                             'serial_number': 'BF21E8',
                                             'system_mac_address': None},
                'f8:85:f9:06:77:e4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:06:77:e4',
                                             'name': 'ont 116',
                                             'serial_number': 'BF234B',
                                             'system_mac_address': None},
                'f8:85:f9:6f:20:25': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:20:25',
                                             'name': 'ont 196',
                                             'serial_number': 'BF24B4',
                                             'system_mac_address': None},
                'f8:85:f9:6f:21:0d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:21:0d',
                                             'name': 'ont 166718',
                                             'serial_number': 'BF24D1',
                                             'system_mac_address': None},
                'f8:85:f9:6f:21:1d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:21:1d',
                                             'name': 'ont 213238',
                                             'serial_number': 'BF24D3',
                                             'system_mac_address': None},
                'f8:85:f9:6f:22:05': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:22:05',
                                             'name': 'ont 134',
                                             'serial_number': 'BF24F1',
                                             'system_mac_address': None},
                'f8:85:f9:6f:22:a5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'f8:85:f9:6f:22:a5',
                                             'name': 'ont 208',
                                             'serial_number': 'BF2505',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': 'front',
                                                              'mac_address': 'cc:be:59:12:6a:c8',
                                                              'name': 'Craft-FE: front',
                                                              'oper_up': True,
                                                              'poller_hash': 'Tm9uZWZyb250'},
                                                      {       'admin_up': False,
                                                              'id': 'rear',
                                                              'mac_address': 'cc:be:59:12:6a:c8',
                                                              'name': 'Craft-FE: rear',
                                                              'oper_up': False,
                                                              'poller_hash': 'Tm9uZXJlYXI='}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2 (EXA)',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1/x3',
                                                                                         'in_discards': '21083233',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1903899356',
                                                                                         'in_octets': '3109231593921228',
                                                                                         'in_ucast_pkts': '7617077940258',
                                                                                         'mac_address': 'cc:be:59:12:6a:d7',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-10G-DAC',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '10172010904461',
                                                                                         'out_octets': '35318241904725422',
                                                                                         'out_ucast_pkts': '16880060851130',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/x4',
                                                                                         'in_discards': '1885216',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18988353',
                                                                                         'in_octets': '893161294121630',
                                                                                         'in_ucast_pkts': '662670078953',
                                                                                         'mac_address': 'cc:be:59:12:6a:d8',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC02',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 '1/x4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '36241502',
                                                                                         'out_octets': '29937607384745',
                                                                                         'out_ucast_pkts': '125045248255',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4TUNDTC1TVUJTIDEveDQ=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2564',
                                                                                         'in_octets': '682781',
                                                                                         'in_ucast_pkts': '3781',
                                                                                         'mac_address': 'cc:be:59:12:6a:c9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01669',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '292587368',
                                                                                         'out_octets': '20813281492',
                                                                                         'out_ucast_pkts': '1081031',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g2',
                                                                                         'mac_address': 'cc:be:59:12:6a:ca',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g3',
                                                                                         'mac_address': 'cc:be:59:12:6a:cb',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g4',
                                                                                         'mac_address': 'cc:be:59:12:6a:cc',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nNA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/1',
                                                                                         'in_discards': '170068',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '21532141',
                                                                                         'in_octets': '18381357135502',
                                                                                         'in_ucast_pkts': '71152012994',
                                                                                         'links': [       {       'in_nucast_pkts': '10907258',
                                                                                                                  'in_octets': '47232193657',
                                                                                                                  'in_ucast_pkts': '175143301',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2959018183',
                                                                                                                  'out_octets': '4277047974318',
                                                                                                                  'out_ucast_pkts': '466196842',
                                                                                                                  'poller_hash': 'MzIyOTAxcGVlcmludGZwb24gMw=='},
                                                                                                          {       'in_nucast_pkts': '46572',
                                                                                                                  'in_octets': '251771257336',
                                                                                                                  'in_ucast_pkts': '632874828',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7468410',
                                                                                                                  'out_octets': '3896148647042',
                                                                                                                  'out_ucast_pkts': '2768277268',
                                                                                                                  'poller_hash': 'OTU2RjA0cGVlcmludGZwb24gMjA='},
                                                                                                          {       'in_nucast_pkts': '5232973',
                                                                                                                  'in_octets': '185806276361',
                                                                                                                  'in_ucast_pkts': '414065748',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8794737146',
                                                                                                                  'out_octets': '13007289187149',
                                                                                                                  'out_ucast_pkts': '1112028243',
                                                                                                                  'poller_hash': 'MUZDNEVGcGVlcmludGZwb24gNzI='},
                                                                                                          {       'in_nucast_pkts': '18141159',
                                                                                                                  'in_octets': '19880415597',
                                                                                                                  'in_ucast_pkts': '86429246',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8455798127',
                                                                                                                  'out_octets': '11206747031026',
                                                                                                                  'out_ucast_pkts': '241686823',
                                                                                                                  'poller_hash': 'NTVGQkE1cGVlcmludGZwb24gNzM='},
                                                                                                          {       'in_nucast_pkts': '15729662',
                                                                                                                  'in_octets': '180667655408',
                                                                                                                  'in_ucast_pkts': '374974664',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13963581924',
                                                                                                                  'out_octets': '19590153437696',
                                                                                                                  'out_ucast_pkts': '1015873399',
                                                                                                                  'poller_hash': 'MkVEOUQwcGVlcmludGZwb24gNzQ='},
                                                                                                          {       'in_nucast_pkts': '8134',
                                                                                                                  'in_octets': '6479291383',
                                                                                                                  'in_ucast_pkts': '32127879',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270601',
                                                                                                                  'out_octets': '47871086854',
                                                                                                                  'out_ucast_pkts': '50264642',
                                                                                                                  'poller_hash': 'NDE1MzBwZWVyaW50ZnBvbiA3NQ=='},
                                                                                                          {       'in_nucast_pkts': '1258',
                                                                                                                  'in_octets': '110516723755',
                                                                                                                  'in_ucast_pkts': '964251937',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '187553',
                                                                                                                  'out_octets': '5299737095987',
                                                                                                                  'out_ucast_pkts': '3670609971',
                                                                                                                  'poller_hash': 'NjQwQjRGcGVlcmludGZwb24gODc='},
                                                                                                          {       'in_nucast_pkts': '554996',
                                                                                                                  'in_octets': '59120811305',
                                                                                                                  'in_ucast_pkts': '71620677',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270610',
                                                                                                                  'out_octets': '93132510634',
                                                                                                                  'out_ucast_pkts': '101427770',
                                                                                                                  'poller_hash': 'RjFGOHBlZXJpbnRmcG9uIDEwNw=='},
                                                                                                          {       'in_nucast_pkts': '9553',
                                                                                                                  'in_octets': '80682227679',
                                                                                                                  'in_ucast_pkts': '415695547',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270594',
                                                                                                                  'out_octets': '2095956129196',
                                                                                                                  'out_ucast_pkts': '1549153913',
                                                                                                                  'poller_hash': 'MzhGMUZEcGVlcmludGZwb24gMTA5'},
                                                                                                          {       'in_nucast_pkts': '11676',
                                                                                                                  'in_octets': '276743507962',
                                                                                                                  'in_ucast_pkts': '443303333',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '205239',
                                                                                                                  'out_octets': '1227224531813',
                                                                                                                  'out_ucast_pkts': '1016840566',
                                                                                                                  'poller_hash': 'MjVEOTM0cGVlcmludGZwb24gMTEw'},
                                                                                                          {       'in_nucast_pkts': '12800806',
                                                                                                                  'in_octets': '91221522109',
                                                                                                                  'in_ucast_pkts': '340760261',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9926858439',
                                                                                                                  'out_octets': '13975306644160',
                                                                                                                  'out_ucast_pkts': '706135380',
                                                                                                                  'poller_hash': 'NTVFMTIzcGVlcmludGZwb24gMTEx'},
                                                                                                          {       'in_nucast_pkts': '17388953',
                                                                                                                  'in_octets': '26735649151',
                                                                                                                  'in_ucast_pkts': '86281446',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '22859516432',
                                                                                                                  'out_octets': '30942072585161',
                                                                                                                  'out_ucast_pkts': '321691068',
                                                                                                                  'poller_hash': 'MTk5OUM1cGVlcmludGZwb24gMTEy'},
                                                                                                          {       'in_nucast_pkts': '47810',
                                                                                                                  'in_octets': '123870414103',
                                                                                                                  'in_ucast_pkts': '556905546',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '271262',
                                                                                                                  'out_octets': '1821206500224',
                                                                                                                  'out_ucast_pkts': '1392790193',
                                                                                                                  'poller_hash': 'NDU1NjczcGVlcmludGZwb24gMTEz'},
                                                                                                          {       'in_nucast_pkts': '3165567',
                                                                                                                  'in_octets': '118245322817',
                                                                                                                  'in_ucast_pkts': '1568910372',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10484206',
                                                                                                                  'out_octets': '135806638767',
                                                                                                                  'out_ucast_pkts': '1959959531',
                                                                                                                  'poller_hash': 'QTlDOEY5cGVlcmludGZwb24gMTE0'},
                                                                                                          {       'in_nucast_pkts': '4480462',
                                                                                                                  'in_octets': '150007097691',
                                                                                                                  'in_ucast_pkts': '1400560212',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9633052408',
                                                                                                                  'out_octets': '18732966664727',
                                                                                                                  'out_ucast_pkts': '4052266630',
                                                                                                                  'poller_hash': 'MkZDQzM4cGVlcmludGZwb24gMTc2'},
                                                                                                          {       'in_nucast_pkts': '93',
                                                                                                                  'in_octets': '36099483292',
                                                                                                                  'in_ucast_pkts': '108628175',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1278861',
                                                                                                                  'out_octets': '615946674160',
                                                                                                                  'out_ucast_pkts': '440233889',
                                                                                                                  'poller_hash': 'QzgyMTMxcGVlcmludGZwb24gMTYxNjU3'},
                                                                                                          {       'in_nucast_pkts': '38672',
                                                                                                                  'in_octets': '71253279478',
                                                                                                                  'in_ucast_pkts': '342405460',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5816815',
                                                                                                                  'out_octets': '1363622230219',
                                                                                                                  'out_ucast_pkts': '1026401534',
                                                                                                                  'poller_hash': 'QzgzQjk3cGVlcmludGZwb24gMTcwNzEy'},
                                                                                                          {       'in_nucast_pkts': '3508351',
                                                                                                                  'in_octets': '1144248226',
                                                                                                                  'in_ucast_pkts': '4335384',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10404009171',
                                                                                                                  'out_octets': '13874600074114',
                                                                                                                  'out_ucast_pkts': '3187402',
                                                                                                                  'poller_hash': 'QzgxQ0JFcGVlcmludGZwb24gMjA2Njgw'},
                                                                                                          {       'in_nucast_pkts': '1392',
                                                                                                                  'in_octets': '18684170428',
                                                                                                                  'in_ucast_pkts': '104916261',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6876002',
                                                                                                                  'out_octets': '721660409807',
                                                                                                                  'out_ucast_pkts': '525173852',
                                                                                                                  'poller_hash': 'MTE5NTE1MXBlZXJpbnRmcG9uIDIxNDYyMA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '628891836002',
                                                                                         'out_octets': '1103845816579726',
                                                                                         'out_ucast_pkts': '191944805649',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzE=',
                                                                                         'pons': [       {       'id': '1/1',
                                                                                                                 'links': [       {       'connected_time': '14643839',
                                                                                                                                          'fiber_length': 1957,
                                                                                                                                          'poller_hash': 'MzIyOTAxcGVlcnBvbnBvbiAz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14407969',
                                                                                                                                          'fiber_length': 1818,
                                                                                                                                          'poller_hash': 'OTU2RjA0cGVlcnBvbnBvbiAyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14364797',
                                                                                                                                          'fiber_length': 1841,
                                                                                                                                          'poller_hash': 'MUZDNEVGcGVlcnBvbnBvbiA3Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14628991',
                                                                                                                                          'fiber_length': 1895,
                                                                                                                                          'poller_hash': 'NTVGQkE1cGVlcnBvbnBvbiA3Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14628859',
                                                                                                                                          'fiber_length': 1848,
                                                                                                                                          'poller_hash': 'MkVEOUQwcGVlcnBvbnBvbiA3NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14628809',
                                                                                                                                          'fiber_length': 1838,
                                                                                                                                          'poller_hash': 'NDE1MzBwZWVycG9ucG9uIDc1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '9779392',
                                                                                                                                          'fiber_length': 1475,
                                                                                                                                          'poller_hash': 'NjQwQjRGcGVlcnBvbnBvbiA4Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14628545',
                                                                                                                                          'fiber_length': 1677,
                                                                                                                                          'poller_hash': 'RjFGOHBlZXJwb25wb24gMTA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14628836',
                                                                                                                                          'fiber_length': 1732,
                                                                                                                                          'poller_hash': 'MzhGMUZEcGVlcnBvbnBvbiAxMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '11141479',
                                                                                                                                          'fiber_length': 1740,
                                                                                                                                          'poller_hash': 'MjVEOTM0cGVlcnBvbnBvbiAxMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14628666',
                                                                                                                                          'fiber_length': 1735,
                                                                                                                                          'poller_hash': 'NTVFMTIzcGVlcnBvbnBvbiAxMTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14628873',
                                                                                                                                          'fiber_length': 1715,
                                                                                                                                          'poller_hash': 'MTk5OUM1cGVlcnBvbnBvbiAxMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14629042',
                                                                                                                                          'fiber_length': 1671,
                                                                                                                                          'poller_hash': 'NDU1NjczcGVlcnBvbnBvbiAxMTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14643886',
                                                                                                                                          'fiber_length': 1876,
                                                                                                                                          'poller_hash': 'QTlDOEY5cGVlcnBvbnBvbiAxMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14358091',
                                                                                                                                          'fiber_length': 1677,
                                                                                                                                          'poller_hash': 'MkZDQzM4cGVlcnBvbnBvbiAxNzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '2476272',
                                                                                                                                          'fiber_length': 1800,
                                                                                                                                          'poller_hash': 'QzgyMTMxcGVlcnBvbnBvbiAxNjE2NTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '11219388',
                                                                                                                                          'fiber_length': 1527,
                                                                                                                                          'poller_hash': 'QzgzQjk3cGVlcnBvbnBvbiAxNzA3MTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '14644027',
                                                                                                                                          'fiber_length': 1970,
                                                                                                                                          'poller_hash': 'QzgxQ0JFcGVlcnBvbnBvbiAyMDY2ODA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599},
                                                                                                                                  {       'connected_time': '13317266',
                                                                                                                                          'fiber_length': 1831,
                                                                                                                                          'poller_hash': 'MTE5NTE1MXBlZXJwb25wb24gMjE0NjIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.599}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/1',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/2',
                                                                                         'in_discards': '3123',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16869823',
                                                                                         'in_octets': '15894533013995',
                                                                                         'in_ucast_pkts': '83689869528',
                                                                                         'links': [       {       'in_nucast_pkts': '18676606',
                                                                                                                  'in_octets': '1162632019754',
                                                                                                                  'in_ucast_pkts': '1985832007',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '22930033615',
                                                                                                                  'out_octets': '35093438326039',
                                                                                                                  'out_ucast_pkts': '3496094356',
                                                                                                                  'poller_hash': 'M0ZCMzVEcGVlcmludGZwb24gMjg='},
                                                                                                          {       'in_nucast_pkts': '1146',
                                                                                                                  'in_octets': '65980692699',
                                                                                                                  'in_ucast_pkts': '356209025',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '122072',
                                                                                                                  'out_octets': '1144403866375',
                                                                                                                  'out_ucast_pkts': '920668787',
                                                                                                                  'poller_hash': 'QzU3Q0RwZWVyaW50ZnBvbiA0OQ=='},
                                                                                                          {       'in_nucast_pkts': '18078222',
                                                                                                                  'in_octets': '24138600244',
                                                                                                                  'in_ucast_pkts': '58655845',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18668808855',
                                                                                                                  'out_octets': '25345559553760',
                                                                                                                  'out_ucast_pkts': '145335542',
                                                                                                                  'poller_hash': 'QkYyMzRCcGVlcmludGZwb24gMTE2'},
                                                                                                          {       'in_nucast_pkts': '7486754',
                                                                                                                  'in_octets': '79183830936',
                                                                                                                  'in_ucast_pkts': '271136048',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1980231244',
                                                                                                                  'out_octets': '3121294085471',
                                                                                                                  'out_ucast_pkts': '861249359',
                                                                                                                  'poller_hash': 'MkM5RUQ0cGVlcmludGZwb24gMTE3'},
                                                                                                          {       'in_nucast_pkts': '7',
                                                                                                                  'in_octets': '11647809709',
                                                                                                                  'in_ucast_pkts': '132941187',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '851363',
                                                                                                                  'out_octets': '431683052157',
                                                                                                                  'out_ucast_pkts': '291526528',
                                                                                                                  'poller_hash': 'QzgzQjk4cGVlcmludGZwb24gMTcxNzA5'},
                                                                                                          {       'in_nucast_pkts': '5664361',
                                                                                                                  'in_octets': '13266710422',
                                                                                                                  'in_ucast_pkts': '44972112',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18160741022',
                                                                                                                  'out_octets': '24287657423995',
                                                                                                                  'out_ucast_pkts': '67485919',
                                                                                                                  'poller_hash': 'MTE5NTFBOXBlZXJpbnRmcG9uIDIxNjAwOQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '689028250045',
                                                                                         'out_octets': '1157615994381212',
                                                                                         'out_ucast_pkts': '187953454234',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzI=',
                                                                                         'pons': [       {       'id': '1/2',
                                                                                                                 'links': [       {       'connected_time': '14628752',
                                                                                                                                          'fiber_length': 1169,
                                                                                                                                          'poller_hash': 'M0ZCMzVEcGVlcnBvbnBvbiAyOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.85},
                                                                                                                                  {       'connected_time': '14628963',
                                                                                                                                          'fiber_length': 1162,
                                                                                                                                          'poller_hash': 'QzU3Q0RwZWVycG9ucG9uIDQ5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.85},
                                                                                                                                  {       'connected_time': '14628646',
                                                                                                                                          'fiber_length': 1117,
                                                                                                                                          'poller_hash': 'QkYyMzRCcGVlcnBvbnBvbiAxMTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.85},
                                                                                                                                  {       'connected_time': '14628695',
                                                                                                                                          'fiber_length': 1104,
                                                                                                                                          'poller_hash': 'MkM5RUQ0cGVlcnBvbnBvbiAxMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.85},
                                                                                                                                  {       'connected_time': '1550315',
                                                                                                                                          'fiber_length': 499,
                                                                                                                                          'poller_hash': 'QzgzQjk4cGVlcnBvbnBvbiAxNzE3MDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.85},
                                                                                                                                  {       'connected_time': '11411498',
                                                                                                                                          'fiber_length': 1188,
                                                                                                                                          'poller_hash': 'MTE5NTFBOXBlZXJwb25wb24gMjE2MDA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.85}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/2',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/3',
                                                                                         'in_discards': '15735',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '4162570',
                                                                                         'in_octets': '15133436721463',
                                                                                         'in_ucast_pkts': '74086446073',
                                                                                         'links': [       {       'in_nucast_pkts': '9111',
                                                                                                                  'in_octets': '20846071158',
                                                                                                                  'in_ucast_pkts': '82520153',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7593548',
                                                                                                                  'out_octets': '678281697680',
                                                                                                                  'out_ucast_pkts': '509007530',
                                                                                                                  'poller_hash': 'ODcyNDFCcGVlcmludGZwb24gMzE='},
                                                                                                          {       'in_nucast_pkts': '150425',
                                                                                                                  'in_octets': '207869731483',
                                                                                                                  'in_ucast_pkts': '788044794',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8471409',
                                                                                                                  'out_octets': '4213244353333',
                                                                                                                  'out_ucast_pkts': '3033524722',
                                                                                                                  'poller_hash': 'QjUxMEUycGVlcmludGZwb24gMzY='},
                                                                                                          {       'in_nucast_pkts': '1433148',
                                                                                                                  'in_octets': '6890126055',
                                                                                                                  'in_ucast_pkts': '68289708',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '373332049',
                                                                                                                  'out_octets': '920729378675',
                                                                                                                  'out_ucast_pkts': '311307299',
                                                                                                                  'poller_hash': 'MzIxMDMzcGVlcmludGZwb24gNDQ='},
                                                                                                          {       'in_nucast_pkts': '301000',
                                                                                                                  'in_octets': '466122620660',
                                                                                                                  'in_ucast_pkts': '1145375527',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7565331',
                                                                                                                  'out_octets': '3659380709381',
                                                                                                                  'out_ucast_pkts': '2713597932',
                                                                                                                  'poller_hash': 'QTlDNzg2cGVlcmludGZwb24gODU='},
                                                                                                          {       'in_nucast_pkts': '4010',
                                                                                                                  'in_octets': '47211897246',
                                                                                                                  'in_ucast_pkts': '391765968',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270575',
                                                                                                                  'out_octets': '1440424694053',
                                                                                                                  'out_ucast_pkts': '1010582942',
                                                                                                                  'poller_hash': 'M0NGNEFwZWVyaW50ZnBvbiAxMjE='},
                                                                                                          {       'in_nucast_pkts': '16067',
                                                                                                                  'in_octets': '302291675527',
                                                                                                                  'in_ucast_pkts': '2329706840',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '269805',
                                                                                                                  'out_octets': '8170000063874',
                                                                                                                  'out_ucast_pkts': '5773635268',
                                                                                                                  'poller_hash': 'NDE1QjBwZWVyaW50ZnBvbiAxMjI='},
                                                                                                          {       'in_nucast_pkts': '6871',
                                                                                                                  'in_octets': '27908298990',
                                                                                                                  'in_ucast_pkts': '73563694',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270239',
                                                                                                                  'out_octets': '424089011595',
                                                                                                                  'out_ucast_pkts': '335661531',
                                                                                                                  'poller_hash': 'NzIyMDY1cGVlcmludGZwb24gMTI0'},
                                                                                                          {       'in_nucast_pkts': '46528',
                                                                                                                  'in_octets': '75299334766',
                                                                                                                  'in_ucast_pkts': '375060756',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '271179',
                                                                                                                  'out_octets': '1953108477290',
                                                                                                                  'out_ucast_pkts': '1467296737',
                                                                                                                  'poller_hash': 'NEUzNkE4cGVlcmludGZwb24gMTI2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MkU5MTRBcGVlcmludGZwb24gMTM1'},
                                                                                                          {       'in_nucast_pkts': '1783948',
                                                                                                                  'in_octets': '25700702625',
                                                                                                                  'in_ucast_pkts': '87703087',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1071067461',
                                                                                                                  'out_octets': '1696746250941',
                                                                                                                  'out_ucast_pkts': '342663525',
                                                                                                                  'poller_hash': 'ODcyNTM1cGVlcmludGZwb24gMTM2'},
                                                                                                          {       'in_nucast_pkts': '99516',
                                                                                                                  'in_octets': '109698515632',
                                                                                                                  'in_ucast_pkts': '614051085',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '227431',
                                                                                                                  'out_octets': '3470533157640',
                                                                                                                  'out_ucast_pkts': '2470427213',
                                                                                                                  'poller_hash': 'MTMwMDlBcGVlcmludGZwb24gMTM4'},
                                                                                                          {       'in_nucast_pkts': '4815',
                                                                                                                  'in_octets': '47146356394',
                                                                                                                  'in_ucast_pkts': '4921995918',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '143838',
                                                                                                                  'out_octets': '1604023705657',
                                                                                                                  'out_ucast_pkts': '1081978300',
                                                                                                                  'poller_hash': 'RjIzQXBlZXJpbnRmcG9uIDEzOQ=='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'M0NGMzNwZWVyaW50ZnBvbiAxNDA='},
                                                                                                          {       'in_nucast_pkts': '45993',
                                                                                                                  'in_octets': '434667548148',
                                                                                                                  'in_ucast_pkts': '1188341719',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '271231',
                                                                                                                  'out_octets': '6355483069260',
                                                                                                                  'out_ucast_pkts': '4791823160',
                                                                                                                  'poller_hash': 'MzI5NjQycGVlcmludGZwb24gMTQy'},
                                                                                                          {       'in_nucast_pkts': '344989',
                                                                                                                  'in_octets': '132016963108',
                                                                                                                  'in_ucast_pkts': '4836943062',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270589',
                                                                                                                  'out_octets': '2581647353520',
                                                                                                                  'out_ucast_pkts': '1952031758',
                                                                                                                  'poller_hash': 'NDE4QUNwZWVyaW50ZnBvbiAxNDM='},
                                                                                                          {       'in_nucast_pkts': '13465',
                                                                                                                  'in_octets': '75997155063',
                                                                                                                  'in_ucast_pkts': '519711804',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270588',
                                                                                                                  'out_octets': '2632784349439',
                                                                                                                  'out_ucast_pkts': '1865189633',
                                                                                                                  'poller_hash': 'M0NDMDhwZWVyaW50ZnBvbiAxNDQ='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'RjEwNnBlZXJpbnRmcG9uIDE0NQ=='},
                                                                                                          {       'in_nucast_pkts': '49066',
                                                                                                                  'in_octets': '23325400862',
                                                                                                                  'in_ucast_pkts': '104897448',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '271243',
                                                                                                                  'out_octets': '772283699903',
                                                                                                                  'out_ucast_pkts': '584381513',
                                                                                                                  'poller_hash': 'QzU4NkJwZWVyaW50ZnBvbiAxNDY='},
                                                                                                          {       'in_nucast_pkts': '76920',
                                                                                                                  'in_octets': '212061336287',
                                                                                                                  'in_ucast_pkts': '478172310',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '272173',
                                                                                                                  'out_octets': '2562643096175',
                                                                                                                  'out_ucast_pkts': '1889444476',
                                                                                                                  'poller_hash': 'M0NGNEVwZWVyaW50ZnBvbiAxNDg='},
                                                                                                          {       'in_nucast_pkts': '9347',
                                                                                                                  'in_octets': '37519150487',
                                                                                                                  'in_ucast_pkts': '242179043',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270544',
                                                                                                                  'out_octets': '1828675806405',
                                                                                                                  'out_ucast_pkts': '1278588304',
                                                                                                                  'poller_hash': 'MTk5QTI1cGVlcmludGZwb24gMTUw'},
                                                                                                          {       'in_nucast_pkts': '7805910',
                                                                                                                  'in_octets': '30642867762',
                                                                                                                  'in_ucast_pkts': '91029987',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8306205978',
                                                                                                                  'out_octets': '11196486312442',
                                                                                                                  'out_ucast_pkts': '350246446',
                                                                                                                  'poller_hash': 'MTk5QTM5cGVlcmludGZwb24gMTUx'},
                                                                                                          {       'in_nucast_pkts': '22133',
                                                                                                                  'in_octets': '1373922382',
                                                                                                                  'in_ucast_pkts': '3593507',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7593602',
                                                                                                                  'out_octets': '9628630968',
                                                                                                                  'out_ucast_pkts': '10639456',
                                                                                                                  'poller_hash': 'QzgzMjEycGVlcmludGZwb24gMTUz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTM1MzhwZWVyaW50ZnBvbiAxNTQ='},
                                                                                                          {       'in_nucast_pkts': '16727719',
                                                                                                                  'in_octets': '416260936717',
                                                                                                                  'in_ucast_pkts': '689471020',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '23600807443',
                                                                                                                  'out_octets': '34631979924098',
                                                                                                                  'out_ucast_pkts': '2348070558',
                                                                                                                  'poller_hash': 'NzFEODBBcGVlcmludGZwb24gMTU1'},
                                                                                                          {       'in_nucast_pkts': '8863484',
                                                                                                                  'in_octets': '103076154706',
                                                                                                                  'in_ucast_pkts': '399060608',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7275329210',
                                                                                                                  'out_octets': '11192525860056',
                                                                                                                  'out_ucast_pkts': '1113516049',
                                                                                                                  'poller_hash': 'QjBBMkEwcGVlcmludGZwb24gMTUwODcy'},
                                                                                                          {       'in_nucast_pkts': '13742175',
                                                                                                                  'in_octets': '154168342020',
                                                                                                                  'in_ucast_pkts': '846656013',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13093811942',
                                                                                                                  'out_octets': '21275375205987',
                                                                                                                  'out_ucast_pkts': '2667214989',
                                                                                                                  'poller_hash': 'QkYyMUU4cGVlcmludGZwb24gMTY0MDYz'},
                                                                                                          {       'in_nucast_pkts': '251',
                                                                                                                  'in_octets': '21633778261',
                                                                                                                  'in_ucast_pkts': '38783917',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1458565',
                                                                                                                  'out_octets': '106399329402',
                                                                                                                  'out_ucast_pkts': '86453667',
                                                                                                                  'poller_hash': 'QzgzQkJCcGVlcmludGZwb24gMTcyMzA5'},
                                                                                                          {       'in_nucast_pkts': '3769811',
                                                                                                                  'in_octets': '24226963009',
                                                                                                                  'in_ucast_pkts': '177427259',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5697521268',
                                                                                                                  'out_octets': '7998611963549',
                                                                                                                  'out_ucast_pkts': '396001155',
                                                                                                                  'poller_hash': 'QzgxNUYxcGVlcmludGZwb24gMjA3MzUy'},
                                                                                                          {       'in_nucast_pkts': '5672',
                                                                                                                  'in_octets': '133210846486',
                                                                                                                  'in_ucast_pkts': '1014885022',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7443452',
                                                                                                                  'out_octets': '7347964884312',
                                                                                                                  'out_ucast_pkts': '5071582819',
                                                                                                                  'poller_hash': 'MTFCMjJCRHBlZXJpbnRmcG9uIDIxMjA4OA=='},
                                                                                                          {       'in_nucast_pkts': '4288',
                                                                                                                  'in_octets': '20460113964',
                                                                                                                  'in_ucast_pkts': '176448006',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '38782',
                                                                                                                  'out_octets': '800029455416',
                                                                                                                  'out_ucast_pkts': '558961932',
                                                                                                                  'poller_hash': 'NDcxQzYzcGVlcmludGZwb24gMjI0Njc5'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '450945607168',
                                                                                         'out_octets': '946000371221292',
                                                                                         'out_ucast_pkts': '239478856412',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzM=',
                                                                                         'pons': [       {       'id': '1/3',
                                                                                                                 'links': [       {       'connected_time': '14643671',
                                                                                                                                          'fiber_length': 1138,
                                                                                                                                          'poller_hash': 'ODcyNDFCcGVlcnBvbnBvbiAzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '15060995',
                                                                                                                                          'fiber_length': 1009,
                                                                                                                                          'poller_hash': 'QjUxMEUycGVlcnBvbnBvbiAzNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '1955580',
                                                                                                                                          'fiber_length': 982,
                                                                                                                                          'poller_hash': 'MzIxMDMzcGVlcnBvbnBvbiA0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14643917',
                                                                                                                                          'fiber_length': 1125,
                                                                                                                                          'poller_hash': 'QTlDNzg2cGVlcnBvbnBvbiA4NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628637',
                                                                                                                                          'fiber_length': 1090,
                                                                                                                                          'poller_hash': 'M0NGNEFwZWVycG9ucG9uIDEyMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628622',
                                                                                                                                          'fiber_length': 1070,
                                                                                                                                          'poller_hash': 'NDE1QjBwZWVycG9ucG9uIDEyMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628822',
                                                                                                                                          'fiber_length': 1128,
                                                                                                                                          'poller_hash': 'NzIyMDY1cGVlcnBvbnBvbiAxMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628749',
                                                                                                                                          'fiber_length': 1156,
                                                                                                                                          'poller_hash': 'NEUzNkE4cGVlcnBvbnBvbiAxMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628758',
                                                                                                                                          'fiber_length': 956,
                                                                                                                                          'poller_hash': 'MkU5MTRBcGVlcnBvbnBvbiAxMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '10240020',
                                                                                                                                          'fiber_length': 1017,
                                                                                                                                          'poller_hash': 'ODcyNTM1cGVlcnBvbnBvbiAxMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '12497623',
                                                                                                                                          'fiber_length': 958,
                                                                                                                                          'poller_hash': 'MTMwMDlBcGVlcnBvbnBvbiAxMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628840',
                                                                                                                                          'fiber_length': 825,
                                                                                                                                          'poller_hash': 'RjIzQXBlZXJwb25wb24gMTM5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'poller_hash': 'M0NGMzNwZWVycG9ucG9uIDE0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628889',
                                                                                                                                          'fiber_length': 837,
                                                                                                                                          'poller_hash': 'MzI5NjQycGVlcnBvbnBvbiAxNDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628783',
                                                                                                                                          'fiber_length': 755,
                                                                                                                                          'poller_hash': 'NDE4QUNwZWVycG9ucG9uIDE0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -21.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628743',
                                                                                                                                          'fiber_length': 708,
                                                                                                                                          'poller_hash': 'M0NDMDhwZWVycG9ucG9uIDE0NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'poller_hash': 'RjEwNnBlZXJwb25wb24gMTQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628535',
                                                                                                                                          'fiber_length': 726,
                                                                                                                                          'poller_hash': 'QzU4NkJwZWVycG9ucG9uIDE0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628729',
                                                                                                                                          'fiber_length': 571,
                                                                                                                                          'poller_hash': 'M0NGNEVwZWVycG9ucG9uIDE0OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628834',
                                                                                                                                          'fiber_length': 614,
                                                                                                                                          'poller_hash': 'MTk5QTI1cGVlcnBvbnBvbiAxNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628778',
                                                                                                                                          'fiber_length': 751,
                                                                                                                                          'poller_hash': 'MTk5QTM5cGVlcnBvbnBvbiAxNTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14643691',
                                                                                                                                          'fiber_length': 742,
                                                                                                                                          'poller_hash': 'QzgzMjEycGVlcnBvbnBvbiAxNTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628495',
                                                                                                                                          'fiber_length': 609,
                                                                                                                                          'poller_hash': 'MTM1MzhwZWVycG9ucG9uIDE1NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14628755',
                                                                                                                                          'fiber_length': 672,
                                                                                                                                          'poller_hash': 'NzFEODBBcGVlcnBvbnBvbiAxNTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14644043',
                                                                                                                                          'fiber_length': 1025,
                                                                                                                                          'poller_hash': 'QjBBMkEwcGVlcnBvbnBvbiAxNTA4NzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14629041',
                                                                                                                                          'fiber_length': 682,
                                                                                                                                          'poller_hash': 'QkYyMUU4cGVlcnBvbnBvbiAxNjQwNjM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '2824075',
                                                                                                                                          'fiber_length': 1206,
                                                                                                                                          'poller_hash': 'QzgzQkJCcGVlcnBvbnBvbiAxNzIzMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14644130',
                                                                                                                                          'fiber_length': 930,
                                                                                                                                          'poller_hash': 'QzgxNUYxcGVlcnBvbnBvbiAyMDczNTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '14360489',
                                                                                                                                          'fiber_length': 855,
                                                                                                                                          'poller_hash': 'MTFCMjJCRHBlZXJwb25wb24gMjEyMDg4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747},
                                                                                                                                  {       'connected_time': '4647369',
                                                                                                                                          'fiber_length': 657,
                                                                                                                                          'poller_hash': 'NDcxQzYzcGVlcnBvbnBvbiAyMjQ2Nzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.747}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/3',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/4',
                                                                                         'in_discards': '175602',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1559724',
                                                                                         'in_octets': '11785094975081',
                                                                                         'in_ucast_pkts': '47770854807',
                                                                                         'links': [       {       'in_nucast_pkts': '10995074',
                                                                                                                  'in_octets': '3531565223',
                                                                                                                  'in_ucast_pkts': '13413605',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26036354325',
                                                                                                                  'out_octets': '34518942877063',
                                                                                                                  'out_ucast_pkts': '9929493',
                                                                                                                  'poller_hash': 'MzIyM0Y5cGVlcmludGZwb24gOQ=='},
                                                                                                          {       'in_nucast_pkts': '83',
                                                                                                                  'in_octets': '44240365815',
                                                                                                                  'in_ucast_pkts': '365355238',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '28670',
                                                                                                                  'out_octets': '967259001438',
                                                                                                                  'out_ucast_pkts': '678716015',
                                                                                                                  'poller_hash': 'M0FERDZFcGVlcmludGZwb24gMTc='},
                                                                                                          {       'in_nucast_pkts': '15770',
                                                                                                                  'in_octets': '459842638020',
                                                                                                                  'in_ucast_pkts': '1495397511',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '122848',
                                                                                                                  'out_octets': '4439926492947',
                                                                                                                  'out_ucast_pkts': '3276642858',
                                                                                                                  'poller_hash': 'NEQ0MUY0cGVlcmludGZwb24gMjk='},
                                                                                                          {       'in_nucast_pkts': '13229564',
                                                                                                                  'in_octets': '368994947058',
                                                                                                                  'in_ucast_pkts': '1320114287',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7619123321',
                                                                                                                  'out_octets': '15906751417431',
                                                                                                                  'out_ucast_pkts': '4226165850',
                                                                                                                  'poller_hash': 'Mzk2MUE5cGVlcmludGZwb24gNTA='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MUM1RENGcGVlcmludGZwb24gOTM='},
                                                                                                          {       'in_nucast_pkts': '2179175',
                                                                                                                  'in_octets': '5581093381',
                                                                                                                  'in_ucast_pkts': '16913514',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3499976774',
                                                                                                                  'out_octets': '4645278359539',
                                                                                                                  'out_ucast_pkts': '36197836',
                                                                                                                  'poller_hash': 'QzU4NTBwZWVyaW50ZnBvbiAxNTc='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODcyNDY2cGVlcmludGZwb24gMTU4'},
                                                                                                          {       'in_nucast_pkts': '11807222',
                                                                                                                  'in_octets': '189392710694',
                                                                                                                  'in_ucast_pkts': '868530102',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6127858539',
                                                                                                                  'out_octets': '10935549638949',
                                                                                                                  'out_ucast_pkts': '2292277099',
                                                                                                                  'poller_hash': 'NTVGQkQ2cGVlcmludGZwb24gMTU5'},
                                                                                                          {       'in_nucast_pkts': '4004',
                                                                                                                  'in_octets': '45253072907',
                                                                                                                  'in_ucast_pkts': '421692477',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '273714',
                                                                                                                  'out_octets': '1870889634182',
                                                                                                                  'out_ucast_pkts': '1314782075',
                                                                                                                  'poller_hash': 'MTMwM0RwZWVyaW50ZnBvbiAxNjA='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'MTk5QTFCcGVlcmludGZwb24gMTYx'},
                                                                                                          {       'in_nucast_pkts': '50012',
                                                                                                                  'in_octets': '62051958243',
                                                                                                                  'in_ucast_pkts': '341917819',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '271219',
                                                                                                                  'out_octets': '1907716230077',
                                                                                                                  'out_ucast_pkts': '1358787518',
                                                                                                                  'poller_hash': 'MjQ4QUU2cGVlcmludGZwb24gMTYy'},
                                                                                                          {       'in_nucast_pkts': '3684275',
                                                                                                                  'in_octets': '190729735040',
                                                                                                                  'in_ucast_pkts': '1004782867',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '541059',
                                                                                                                  'out_octets': '4575050769530',
                                                                                                                  'out_ucast_pkts': '3362519750',
                                                                                                                  'poller_hash': 'MTYxMDIxcGVlcmludGZwb24gMTYz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MjQ4QUQ3cGVlcmludGZwb24gMTY0'},
                                                                                                          {       'in_nucast_pkts': '46212',
                                                                                                                  'in_octets': '59873776807',
                                                                                                                  'in_ucast_pkts': '243295383',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270602',
                                                                                                                  'out_octets': '558020044490',
                                                                                                                  'out_ucast_pkts': '485544339',
                                                                                                                  'poller_hash': 'Mzc4OEMxcGVlcmludGZwb24gMTY1'},
                                                                                                          {       'in_nucast_pkts': '22275',
                                                                                                                  'in_octets': '108663607410',
                                                                                                                  'in_ucast_pkts': '478335469',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270593',
                                                                                                                  'out_octets': '2441430881503',
                                                                                                                  'out_ucast_pkts': '1755836176',
                                                                                                                  'poller_hash': 'MkZDQ0UxcGVlcmludGZwb24gMTY2'},
                                                                                                          {       'in_nucast_pkts': '3785917',
                                                                                                                  'in_octets': '72936841067',
                                                                                                                  'in_ucast_pkts': '322747856',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9626556333',
                                                                                                                  'out_octets': '14962553494612',
                                                                                                                  'out_ucast_pkts': '1549699962',
                                                                                                                  'poller_hash': 'QzgzQkFFcGVlcmludGZwb24gMTY2MTIx'},
                                                                                                          {       'in_nucast_pkts': '684610',
                                                                                                                  'in_octets': '4505561494',
                                                                                                                  'in_ucast_pkts': '7902047',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4915600',
                                                                                                                  'out_octets': '11271046396',
                                                                                                                  'out_ucast_pkts': '11381466',
                                                                                                                  'poller_hash': 'QzgxRDZGcGVlcmludGZwb24gMjExNjUz'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '313466668414',
                                                                                         'out_octets': '610382533435985',
                                                                                         'out_ucast_pkts': '136198144002',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzQ=',
                                                                                         'pons': [       {       'id': '1/4',
                                                                                                                 'links': [       {       'connected_time': '14643880',
                                                                                                                                          'fiber_length': 662,
                                                                                                                                          'poller_hash': 'MzIyM0Y5cGVlcnBvbnBvbiA5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '3432179',
                                                                                                                                          'fiber_length': 518,
                                                                                                                                          'poller_hash': 'M0FERDZFcGVlcnBvbnBvbiAxNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14628936',
                                                                                                                                          'fiber_length': 545,
                                                                                                                                          'poller_hash': 'NEQ0MUY0cGVlcnBvbnBvbiAyOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14628925',
                                                                                                                                          'fiber_length': 536,
                                                                                                                                          'poller_hash': 'Mzk2MUE5cGVlcnBvbnBvbiA1MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14628762',
                                                                                                                                          'fiber_length': 166,
                                                                                                                                          'poller_hash': 'MUM1RENGcGVlcnBvbnBvbiA5Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '5527888',
                                                                                                                                          'fiber_length': 592,
                                                                                                                                          'poller_hash': 'QzU4NTBwZWVycG9ucG9uIDE1Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'poller_hash': 'ODcyNDY2cGVlcnBvbnBvbiAxNTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14628878',
                                                                                                                                          'fiber_length': 484,
                                                                                                                                          'poller_hash': 'NTVGQkQ2cGVlcnBvbnBvbiAxNTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14628435',
                                                                                                                                          'fiber_length': 358,
                                                                                                                                          'poller_hash': 'MTMwM0RwZWVycG9ucG9uIDE2MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14629120',
                                                                                                                                          'fiber_length': 539,
                                                                                                                                          'poller_hash': 'MTk5QTFCcGVlcnBvbnBvbiAxNjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14628911',
                                                                                                                                          'fiber_length': 573,
                                                                                                                                          'poller_hash': 'MjQ4QUU2cGVlcnBvbnBvbiAxNjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14628936',
                                                                                                                                          'fiber_length': 514,
                                                                                                                                          'poller_hash': 'MTYxMDIxcGVlcnBvbnBvbiAxNjM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14629131',
                                                                                                                                          'fiber_length': 583,
                                                                                                                                          'poller_hash': 'MjQ4QUQ3cGVlcnBvbnBvbiAxNjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14628835',
                                                                                                                                          'fiber_length': 612,
                                                                                                                                          'poller_hash': 'Mzc4OEMxcGVlcnBvbnBvbiAxNjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14628996',
                                                                                                                                          'fiber_length': 647,
                                                                                                                                          'poller_hash': 'MkZDQ0UxcGVlcnBvbnBvbiAxNjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '14644160',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'QzgzQkFFcGVlcnBvbnBvbiAxNjYxMjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634},
                                                                                                                                  {       'connected_time': '9081036',
                                                                                                                                          'fiber_length': 1018,
                                                                                                                                          'poller_hash': 'QzgxRDZGcGVlcnBvbnBvbiAyMTE2NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.634}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/4',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/5',
                                                                                         'in_discards': '9321',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '53476366',
                                                                                         'in_octets': '32356452044087',
                                                                                         'in_ucast_pkts': '101493633707',
                                                                                         'links': [       {       'in_nucast_pkts': '50604',
                                                                                                                  'in_octets': '5783851673409',
                                                                                                                  'in_ucast_pkts': '6881509144',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26',
                                                                                                                  'out_octets': '14244625426642',
                                                                                                                  'out_ucast_pkts': '12298269258',
                                                                                                                  'poller_hash': 'NEQ0MjUwcGVlcmludGZwb24gNg=='},
                                                                                                          {       'in_nucast_pkts': '3317',
                                                                                                                  'in_octets': '246704686286',
                                                                                                                  'in_ucast_pkts': '855726166',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '262984',
                                                                                                                  'out_octets': '2821544618823',
                                                                                                                  'out_ucast_pkts': '2071397488',
                                                                                                                  'poller_hash': 'NDNDMjFBcGVlcmludGZwb24gMTM='},
                                                                                                          {       'in_nucast_pkts': '16475622',
                                                                                                                  'in_octets': '255513776369',
                                                                                                                  'in_ucast_pkts': '369121173',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '19483316730',
                                                                                                                  'out_octets': '26536815210422',
                                                                                                                  'out_ucast_pkts': '496708236',
                                                                                                                  'poller_hash': 'MkZFQTAzcGVlcmludGZwb24gMjQ='},
                                                                                                          {       'in_nucast_pkts': '14677139',
                                                                                                                  'in_octets': '48664483546',
                                                                                                                  'in_ucast_pkts': '157767889',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6441369106',
                                                                                                                  'out_octets': '8849570557958',
                                                                                                                  'out_ucast_pkts': '337894086',
                                                                                                                  'poller_hash': 'NkFDMkM3cGVlcmludGZwb24gNDA='},
                                                                                                          {       'in_nucast_pkts': '1374',
                                                                                                                  'in_octets': '23351743311',
                                                                                                                  'in_ucast_pkts': '73906379',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '73953',
                                                                                                                  'out_octets': '411290920015',
                                                                                                                  'out_ucast_pkts': '317998087',
                                                                                                                  'poller_hash': 'NTVERkIxcGVlcmludGZwb24gOTk='},
                                                                                                          {       'in_nucast_pkts': '15253925',
                                                                                                                  'in_octets': '1184452839242',
                                                                                                                  'in_ucast_pkts': '2151462656',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '28149869010',
                                                                                                                  'out_octets': '41282497516574',
                                                                                                                  'out_ucast_pkts': '3625787291',
                                                                                                                  'poller_hash': 'NzZFOTkwcGVlcmludGZwb24gMTgy'},
                                                                                                          {       'in_nucast_pkts': '4044',
                                                                                                                  'in_octets': '29489608232',
                                                                                                                  'in_ucast_pkts': '129989997',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '273745',
                                                                                                                  'out_octets': '180147318637',
                                                                                                                  'out_ucast_pkts': '197176312',
                                                                                                                  'poller_hash': 'MTUzQzNwZWVyaW50ZnBvbiAxODM='},
                                                                                                          {       'in_nucast_pkts': '3162318',
                                                                                                                  'in_octets': '97093300214',
                                                                                                                  'in_ucast_pkts': '1270887063',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3158867',
                                                                                                                  'out_octets': '113591109961',
                                                                                                                  'out_ucast_pkts': '1648107668',
                                                                                                                  'poller_hash': 'N0ZGNXBlZXJpbnRmcG9uIDE4NQ=='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'MzI5NjM5cGVlcmludGZwb24gMTg3'},
                                                                                                          {       'in_nucast_pkts': '5700',
                                                                                                                  'in_octets': '579712414509',
                                                                                                                  'in_ucast_pkts': '3328334157',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '269031',
                                                                                                                  'out_octets': '9348082990622',
                                                                                                                  'out_ucast_pkts': '7329571225',
                                                                                                                  'poller_hash': 'MTk5QTAwcGVlcmludGZwb24gMTg4'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'NDE4QjNwZWVyaW50ZnBvbiAxODk='},
                                                                                                          {       'in_nucast_pkts': '4126',
                                                                                                                  'in_octets': '6904586934',
                                                                                                                  'in_ucast_pkts': '35850470',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '80024',
                                                                                                                  'out_octets': '152161977183',
                                                                                                                  'out_ucast_pkts': '111717134',
                                                                                                                  'poller_hash': 'M0NGQTBwZWVyaW50ZnBvbiAxOTA='},
                                                                                                          {       'in_nucast_pkts': '61846',
                                                                                                                  'in_octets': '125426840729',
                                                                                                                  'in_ucast_pkts': '344448293',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '122143',
                                                                                                                  'out_octets': '1337918225023',
                                                                                                                  'out_ucast_pkts': '1034267950',
                                                                                                                  'poller_hash': 'NDcxNDZFcGVlcmludGZwb24gMTkx'},
                                                                                                          {       'in_nucast_pkts': '13427184',
                                                                                                                  'in_octets': '67655714654',
                                                                                                                  'in_ucast_pkts': '335428211',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10210578953',
                                                                                                                  'out_octets': '14661607771000',
                                                                                                                  'out_ucast_pkts': '26684082780',
                                                                                                                  'poller_hash': 'NDE4QjVwZWVyaW50ZnBvbiAxOTI='},
                                                                                                          {       'in_nucast_pkts': '17381164',
                                                                                                                  'in_octets': '46569736259',
                                                                                                                  'in_ucast_pkts': '220024475',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '22431422701',
                                                                                                                  'out_octets': '30694222565320',
                                                                                                                  'out_ucast_pkts': '639375880',
                                                                                                                  'poller_hash': 'NDcwNUVEcGVlcmludGZwb24gMTkz'},
                                                                                                          {       'in_nucast_pkts': '5586359',
                                                                                                                  'in_octets': '3659416764',
                                                                                                                  'in_ucast_pkts': '4313251498',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11160873512',
                                                                                                                  'out_octets': '14923907592060',
                                                                                                                  'out_ucast_pkts': '34387597997',
                                                                                                                  'poller_hash': 'NDE1NDlwZWVyaW50ZnBvbiAxOTQ='},
                                                                                                          {       'in_nucast_pkts': '37',
                                                                                                                  'in_octets': '21686151630',
                                                                                                                  'in_ucast_pkts': '69661708',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '124294',
                                                                                                                  'out_octets': '69560658077',
                                                                                                                  'out_ucast_pkts': '75163854',
                                                                                                                  'poller_hash': 'NEVCMTdEcGVlcmludGZwb24gMTk1'},
                                                                                                          {       'in_nucast_pkts': '12681301',
                                                                                                                  'in_octets': '19482560112',
                                                                                                                  'in_ucast_pkts': '73939336',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '20541104162',
                                                                                                                  'out_octets': '28011712489495',
                                                                                                                  'out_ucast_pkts': '231035176',
                                                                                                                  'poller_hash': 'QkYyNEI0cGVlcmludGZwb24gMTk2'},
                                                                                                          {       'in_nucast_pkts': '3058',
                                                                                                                  'in_octets': '232893867747',
                                                                                                                  'in_ucast_pkts': '794076345',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270593',
                                                                                                                  'out_octets': '3236176278454',
                                                                                                                  'out_ucast_pkts': '2484846175',
                                                                                                                  'poller_hash': 'MkYzQUQ5cGVlcmludGZwb24gMTk3'},
                                                                                                          {       'in_nucast_pkts': '12027051',
                                                                                                                  'in_octets': '130427201345',
                                                                                                                  'in_ucast_pkts': '528964072',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10740288203',
                                                                                                                  'out_octets': '16519819478507',
                                                                                                                  'out_ucast_pkts': '1612324934',
                                                                                                                  'poller_hash': 'NzU3QkNwZWVyaW50ZnBvbiAxOTg='},
                                                                                                          {       'in_nucast_pkts': '8323',
                                                                                                                  'in_octets': '11842782650',
                                                                                                                  'in_ucast_pkts': '31900052',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7592963',
                                                                                                                  'out_octets': '94713026657',
                                                                                                                  'out_ucast_pkts': '77748493',
                                                                                                                  'poller_hash': 'QzgxMUUwcGVlcmludGZwb24gMTU3NzUz'},
                                                                                                          {       'in_nucast_pkts': '3552',
                                                                                                                  'in_octets': '78277025590',
                                                                                                                  'in_ucast_pkts': '355030631',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7593657',
                                                                                                                  'out_octets': '970068987500',
                                                                                                                  'out_ucast_pkts': '925235303',
                                                                                                                  'poller_hash': 'QzgzQzBDcGVlcmludGZwb24gMTc0NDY0'},
                                                                                                          {       'in_nucast_pkts': '920',
                                                                                                                  'in_octets': '41107620700',
                                                                                                                  'in_ucast_pkts': '233311407',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2091846',
                                                                                                                  'out_octets': '1638942345772',
                                                                                                                  'out_ucast_pkts': '1154060065',
                                                                                                                  'poller_hash': 'QzgxRTMwcGVlcmludGZwb24gMjA2NDkw'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '616706227917',
                                                                                         'out_octets': '1074092546382957',
                                                                                         'out_ucast_pkts': '214292916738',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzU=',
                                                                                         'pons': [       {       'id': '1/5',
                                                                                                                 'links': [       {       'connected_time': '14629030',
                                                                                                                                          'fiber_length': 1529,
                                                                                                                                          'poller_hash': 'NEQ0MjUwcGVlcnBvbnBvbiA2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14358114',
                                                                                                                                          'fiber_length': 1307,
                                                                                                                                          'poller_hash': 'NDNDMjFBcGVlcnBvbnBvbiAxMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14629132',
                                                                                                                                          'fiber_length': 670,
                                                                                                                                          'poller_hash': 'MkZFQTAzcGVlcnBvbnBvbiAyNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14628557',
                                                                                                                                          'fiber_length': 691,
                                                                                                                                          'poller_hash': 'NkFDMkM3cGVlcnBvbnBvbiA0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '9771475',
                                                                                                                                          'fiber_length': 615,
                                                                                                                                          'poller_hash': 'NTVERkIxcGVlcnBvbnBvbiA5OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14628849',
                                                                                                                                          'fiber_length': 1441,
                                                                                                                                          'poller_hash': 'NzZFOTkwcGVlcnBvbnBvbiAxODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14628422',
                                                                                                                                          'fiber_length': 881,
                                                                                                                                          'poller_hash': 'MTUzQzNwZWVycG9ucG9uIDE4Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14628091',
                                                                                                                                          'fiber_length': 834,
                                                                                                                                          'poller_hash': 'N0ZGNXBlZXJwb25wb24gMTg1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'poller_hash': 'MzI5NjM5cGVlcnBvbnBvbiAxODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14628839',
                                                                                                                                          'fiber_length': 953,
                                                                                                                                          'poller_hash': 'MTk5QTAwcGVlcnBvbnBvbiAxODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'poller_hash': 'NDE4QjNwZWVycG9ucG9uIDE4OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '1783685',
                                                                                                                                          'fiber_length': 667,
                                                                                                                                          'poller_hash': 'M0NGQTBwZWVycG9ucG9uIDE5MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14629128',
                                                                                                                                          'fiber_length': 578,
                                                                                                                                          'poller_hash': 'NDcxNDZFcGVlcnBvbnBvbiAxOTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14628811',
                                                                                                                                          'fiber_length': 511,
                                                                                                                                          'poller_hash': 'NDE4QjVwZWVycG9ucG9uIDE5Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14628862',
                                                                                                                                          'fiber_length': 653,
                                                                                                                                          'poller_hash': 'NDcwNUVEcGVlcnBvbnBvbiAxOTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14628873',
                                                                                                                                          'fiber_length': 705,
                                                                                                                                          'poller_hash': 'NDE1NDlwZWVycG9ucG9uIDE5NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '4772493',
                                                                                                                                          'fiber_length': 761,
                                                                                                                                          'poller_hash': 'NEVCMTdEcGVlcnBvbnBvbiAxOTU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '10204550',
                                                                                                                                          'fiber_length': 1360,
                                                                                                                                          'poller_hash': 'QkYyNEI0cGVlcnBvbnBvbiAxOTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14628714',
                                                                                                                                          'fiber_length': 1317,
                                                                                                                                          'poller_hash': 'MkYzQUQ5cGVlcnBvbnBvbiAxOTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14629179',
                                                                                                                                          'fiber_length': 1356,
                                                                                                                                          'poller_hash': 'NzU3QkNwZWVycG9ucG9uIDE5OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14644109',
                                                                                                                                          'fiber_length': 1022,
                                                                                                                                          'poller_hash': 'QzgxMUUwcGVlcnBvbnBvbiAxNTc3NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '14643928',
                                                                                                                                          'fiber_length': 971,
                                                                                                                                          'poller_hash': 'QzgzQzBDcGVlcnBvbnBvbiAxNzQ0NjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732},
                                                                                                                                  {       'connected_time': '4039318',
                                                                                                                                          'fiber_length': 895,
                                                                                                                                          'poller_hash': 'QzgxRTMwcGVlcnBvbnBvbiAyMDY0OTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.732}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/5',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/6',
                                                                                         'in_discards': '68740',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '21634928',
                                                                                         'in_octets': '21772592926891',
                                                                                         'in_ucast_pkts': '99432083927',
                                                                                         'links': [       {       'in_nucast_pkts': '21419832',
                                                                                                                  'in_octets': '404971153268',
                                                                                                                  'in_ucast_pkts': '943552361',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '39232389504',
                                                                                                                  'out_octets': '55439027860319',
                                                                                                                  'out_ucast_pkts': '2337988402',
                                                                                                                  'poller_hash': 'MzIxMUIzcGVlcmludGZwb24gNA=='},
                                                                                                          {       'in_nucast_pkts': '43168',
                                                                                                                  'in_octets': '57439845300',
                                                                                                                  'in_ucast_pkts': '556962038',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5008814',
                                                                                                                  'out_octets': '1642670442466',
                                                                                                                  'out_ucast_pkts': '1141617479',
                                                                                                                  'poller_hash': 'NDJCOUQzcGVlcmludGZwb24gMTA='},
                                                                                                          {       'in_nucast_pkts': '7971664',
                                                                                                                  'in_octets': '73088497325',
                                                                                                                  'in_ucast_pkts': '365741604',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15368692203',
                                                                                                                  'out_octets': '22957566886351',
                                                                                                                  'out_ucast_pkts': '1935672083',
                                                                                                                  'poller_hash': 'ODcyNDJBcGVlcmludGZwb24gMTU='},
                                                                                                          {       'in_nucast_pkts': '5920967',
                                                                                                                  'in_octets': '283546169532',
                                                                                                                  'in_ucast_pkts': '1035892691',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15599565839',
                                                                                                                  'out_octets': '24110756266573',
                                                                                                                  'out_ucast_pkts': '2619388698',
                                                                                                                  'poller_hash': 'NDI4MTkxcGVlcmludGZwb24gMzU='},
                                                                                                          {       'in_nucast_pkts': '14693859',
                                                                                                                  'in_octets': '114513869439',
                                                                                                                  'in_ucast_pkts': '493855061',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '16991042353',
                                                                                                                  'out_octets': '26624919830258',
                                                                                                                  'out_ucast_pkts': '2737151945',
                                                                                                                  'poller_hash': 'MzIyM0QzcGVlcmludGZwb24gNDM='},
                                                                                                          {       'in_nucast_pkts': '16',
                                                                                                                  'in_octets': '90944076826',
                                                                                                                  'in_ucast_pkts': '800032431',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4442025',
                                                                                                                  'out_octets': '2725416772685',
                                                                                                                  'out_ucast_pkts': '1863925685',
                                                                                                                  'poller_hash': 'NDJEMkJCcGVlcmludGZwb24gODM='},
                                                                                                          {       'in_nucast_pkts': '5600',
                                                                                                                  'in_octets': '349777869061',
                                                                                                                  'in_ucast_pkts': '2978584080',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270305',
                                                                                                                  'out_octets': '9273826460667',
                                                                                                                  'out_ucast_pkts': '6493292145',
                                                                                                                  'poller_hash': 'ODc0NEZwZWVyaW50ZnBvbiAxMjc='},
                                                                                                          {       'in_nucast_pkts': '3717465',
                                                                                                                  'in_octets': '6406769892',
                                                                                                                  'in_ucast_pkts': '31198595',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7696911435',
                                                                                                                  'out_octets': '10230356892557',
                                                                                                                  'out_ucast_pkts': '47092324',
                                                                                                                  'poller_hash': 'NEQxMTFGcGVlcmludGZwb24gMjAz'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'MkZDQzMycGVlcmludGZwb24gMjA0'},
                                                                                                          {       'in_nucast_pkts': '3162575',
                                                                                                                  'in_octets': '94633645810',
                                                                                                                  'in_ucast_pkts': '961376937',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3158974',
                                                                                                                  'out_octets': '84477752694',
                                                                                                                  'out_ucast_pkts': '1221356829',
                                                                                                                  'poller_hash': 'NDE1N0VwZWVyaW50ZnBvbiAyMDY='},
                                                                                                          {       'in_nucast_pkts': '106317',
                                                                                                                  'in_octets': '125739866652',
                                                                                                                  'in_ucast_pkts': '1240053600',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270571',
                                                                                                                  'out_octets': '5161151054110',
                                                                                                                  'out_ucast_pkts': '3503748808',
                                                                                                                  'poller_hash': 'NDE1QUJwZWVyaW50ZnBvbiAyMDc='},
                                                                                                          {       'in_nucast_pkts': '726785',
                                                                                                                  'in_octets': '156385227686',
                                                                                                                  'in_ucast_pkts': '1122850368',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '121994',
                                                                                                                  'out_octets': '5779525041682',
                                                                                                                  'out_ucast_pkts': '4003574450',
                                                                                                                  'poller_hash': 'QkYyNTA1cGVlcmludGZwb24gMjA4'},
                                                                                                          {       'in_nucast_pkts': '747358',
                                                                                                                  'in_octets': '216201807982',
                                                                                                                  'in_ucast_pkts': '1257850453',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '274803',
                                                                                                                  'out_octets': '5657564982781',
                                                                                                                  'out_ucast_pkts': '4162830119',
                                                                                                                  'poller_hash': 'NDcwM0FGcGVlcmludGZwb24gMjA5'},
                                                                                                          {       'in_nucast_pkts': '7461886',
                                                                                                                  'in_octets': '198894783516',
                                                                                                                  'in_ucast_pkts': '932170879',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18461704410',
                                                                                                                  'out_octets': '27368682511077',
                                                                                                                  'out_ucast_pkts': '2154045476',
                                                                                                                  'poller_hash': 'ODcyNDVFcGVlcmludGZwb24gMjEw'},
                                                                                                          {       'in_nucast_pkts': '1280826',
                                                                                                                  'in_octets': '114714987',
                                                                                                                  'in_ucast_pkts': '286305',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1560011106',
                                                                                                                  'out_octets': '2002516996665',
                                                                                                                  'out_ucast_pkts': '115399',
                                                                                                                  'poller_hash': 'Mzk1MDdBcGVlcmludGZwb24gMjEx'},
                                                                                                          {       'in_nucast_pkts': '9282',
                                                                                                                  'in_octets': '99718364430',
                                                                                                                  'in_ucast_pkts': '497467985',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7593738',
                                                                                                                  'out_octets': '3220783018100',
                                                                                                                  'out_ucast_pkts': '2304018197',
                                                                                                                  'poller_hash': 'QzgxQzNGcGVlcmludGZwb24gMjEy'},
                                                                                                          {       'in_nucast_pkts': '7908',
                                                                                                                  'in_octets': '355812151228',
                                                                                                                  'in_ucast_pkts': '1373126597',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270473',
                                                                                                                  'out_octets': '5762441763725',
                                                                                                                  'out_ucast_pkts': '4156244554',
                                                                                                                  'poller_hash': 'MTk5QTMycGVlcmludGZwb24gMjE0'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'QURFMjRwZWVyaW50ZnBvbiAyMTU='},
                                                                                                          {       'in_nucast_pkts': '14591729',
                                                                                                                  'in_octets': '6632703790',
                                                                                                                  'in_ucast_pkts': '33790246',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '23659503106',
                                                                                                                  'out_octets': '31377492429277',
                                                                                                                  'out_ucast_pkts': '76793274',
                                                                                                                  'poller_hash': 'NzZGMjFDcGVlcmludGZwb24gMjE3'},
                                                                                                          {       'in_nucast_pkts': '45762',
                                                                                                                  'in_octets': '183573737941',
                                                                                                                  'in_ucast_pkts': '561550066',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '271206',
                                                                                                                  'out_octets': '5004129764488',
                                                                                                                  'out_ucast_pkts': '3538587775',
                                                                                                                  'poller_hash': 'NEQ0MjRGcGVlcmludGZwb24gMjE4'},
                                                                                                          {       'in_nucast_pkts': '11465828',
                                                                                                                  'in_octets': '58659987071',
                                                                                                                  'in_ucast_pkts': '252594732',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3272363244',
                                                                                                                  'out_octets': '5245072864247',
                                                                                                                  'out_ucast_pkts': '847660598',
                                                                                                                  'poller_hash': 'NDAwMzhGcGVlcmludGZwb24gMjE5'},
                                                                                                          {       'in_nucast_pkts': '12884858',
                                                                                                                  'in_octets': '23726185676',
                                                                                                                  'in_ucast_pkts': '100055275',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3390635750',
                                                                                                                  'out_octets': '4823607715580',
                                                                                                                  'out_ucast_pkts': '427912341',
                                                                                                                  'poller_hash': 'ODZCQkVwZWVyaW50ZnBvbiAyMjA='},
                                                                                                          {       'in_nucast_pkts': '49853',
                                                                                                                  'in_octets': '90068084082',
                                                                                                                  'in_ucast_pkts': '392253202',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7594463',
                                                                                                                  'out_octets': '2121103130257',
                                                                                                                  'out_ucast_pkts': '1608822473',
                                                                                                                  'poller_hash': 'OTU0RjQ1cGVlcmludGZwb24gMTQzODgy'},
                                                                                                          {       'in_nucast_pkts': '250155',
                                                                                                                  'in_octets': '694262750',
                                                                                                                  'in_ucast_pkts': '2862192',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '759178554',
                                                                                                                  'out_octets': '1014755611602',
                                                                                                                  'out_ucast_pkts': '8872763',
                                                                                                                  'poller_hash': 'QzgzODFBcGVlcmludGZwb24gMTYwOTk2'},
                                                                                                          {       'in_nucast_pkts': '155208',
                                                                                                                  'in_octets': '233797232367',
                                                                                                                  'in_ucast_pkts': '1155967836',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7562179',
                                                                                                                  'out_octets': '4770625462954',
                                                                                                                  'out_ucast_pkts': '3464801859',
                                                                                                                  'poller_hash': 'QzgxRTAxcGVlcmludGZwb24gMjA1NDU2'},
                                                                                                          {       'in_nucast_pkts': '10187528',
                                                                                                                  'in_octets': '48577387898',
                                                                                                                  'in_ucast_pkts': '141419251',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4603946092',
                                                                                                                  'out_octets': '6479353705109',
                                                                                                                  'out_ucast_pkts': '591965113',
                                                                                                                  'poller_hash': 'MTE5NTE0OXBlZXJpbnRmcG9uIDIxNTk2OQ=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '914256867614',
                                                                                         'out_octets': '1633918223195492',
                                                                                         'out_ucast_pkts': '287402223944',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzY=',
                                                                                         'pons': [       {       'id': '1/6',
                                                                                                                 'links': [       {       'connected_time': '14643716',
                                                                                                                                          'fiber_length': 1274,
                                                                                                                                          'poller_hash': 'MzIxMUIzcGVlcnBvbnBvbiA0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '6374418',
                                                                                                                                          'fiber_length': 1319,
                                                                                                                                          'poller_hash': 'NDJCOUQzcGVlcnBvbnBvbiAxMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14643733',
                                                                                                                                          'fiber_length': 1491,
                                                                                                                                          'poller_hash': 'ODcyNDJBcGVlcnBvbnBvbiAxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14643931',
                                                                                                                                          'fiber_length': 1490,
                                                                                                                                          'poller_hash': 'NDI4MTkxcGVlcnBvbnBvbiAzNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14644074',
                                                                                                                                          'fiber_length': 1451,
                                                                                                                                          'poller_hash': 'MzIyM0QzcGVlcnBvbnBvbiA0Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '8537006',
                                                                                                                                          'fiber_length': 1338,
                                                                                                                                          'poller_hash': 'NDJEMkJCcGVlcnBvbnBvbiA4Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628898',
                                                                                                                                          'fiber_length': 1387,
                                                                                                                                          'poller_hash': 'ODc0NEZwZWVycG9ucG9uIDEyNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628825',
                                                                                                                                          'fiber_length': 1329,
                                                                                                                                          'poller_hash': 'NEQxMTFGcGVlcnBvbnBvbiAyMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'poller_hash': 'MkZDQzMycGVlcnBvbnBvbiAyMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628840',
                                                                                                                                          'fiber_length': 1247,
                                                                                                                                          'poller_hash': 'NDE1N0VwZWVycG9ucG9uIDIwNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628847',
                                                                                                                                          'fiber_length': 1273,
                                                                                                                                          'poller_hash': 'NDE1QUJwZWVycG9ucG9uIDIwNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628296',
                                                                                                                                          'fiber_length': 1353,
                                                                                                                                          'poller_hash': 'QkYyNTA1cGVlcnBvbnBvbiAyMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628634',
                                                                                                                                          'fiber_length': 1330,
                                                                                                                                          'poller_hash': 'NDcwM0FGcGVlcnBvbnBvbiAyMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14643927',
                                                                                                                                          'fiber_length': 1476,
                                                                                                                                          'poller_hash': 'ODcyNDVFcGVlcnBvbnBvbiAyMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '4218200',
                                                                                                                                          'fiber_length': 1207,
                                                                                                                                          'poller_hash': 'Mzk1MDdBcGVlcnBvbnBvbiAyMTE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14643956',
                                                                                                                                          'fiber_length': 1301,
                                                                                                                                          'poller_hash': 'QzgxQzNGcGVlcnBvbnBvbiAyMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628707',
                                                                                                                                          'fiber_length': 1074,
                                                                                                                                          'poller_hash': 'MTk5QTMycGVlcnBvbnBvbiAyMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'poller_hash': 'QURFMjRwZWVycG9ucG9uIDIxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628860',
                                                                                                                                          'fiber_length': 1007,
                                                                                                                                          'poller_hash': 'NzZGMjFDcGVlcnBvbnBvbiAyMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628958',
                                                                                                                                          'fiber_length': 1327,
                                                                                                                                          'poller_hash': 'NEQ0MjRGcGVlcnBvbnBvbiAyMTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628766',
                                                                                                                                          'fiber_length': 1198,
                                                                                                                                          'poller_hash': 'NDAwMzhGcGVlcnBvbnBvbiAyMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14628797',
                                                                                                                                          'fiber_length': 1227,
                                                                                                                                          'poller_hash': 'ODZCQkVwZWVycG9ucG9uIDIyMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14644069',
                                                                                                                                          'fiber_length': 1530,
                                                                                                                                          'poller_hash': 'OTU0RjQ1cGVlcnBvbnBvbiAxNDM4ODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '322678',
                                                                                                                                          'fiber_length': 1226,
                                                                                                                                          'poller_hash': 'QzgzODFBcGVlcnBvbnBvbiAxNjA5OTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '14644078',
                                                                                                                                          'fiber_length': 1090,
                                                                                                                                          'poller_hash': 'QzgxRTAxcGVlcnBvbnBvbiAyMDU0NTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05},
                                                                                                                                  {       'connected_time': '11498949',
                                                                                                                                          'fiber_length': 1179,
                                                                                                                                          'poller_hash': 'MTE5NTE0OXBlZXJwb25wb24gMjE1OTY5',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 4.05}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/6',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/7',
                                                                                         'in_discards': '5665',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '7813037',
                                                                                         'in_octets': '18286601509298',
                                                                                         'in_ucast_pkts': '79071305091',
                                                                                         'links': [       {       'in_nucast_pkts': '16309249',
                                                                                                                  'in_octets': '48001141268',
                                                                                                                  'in_ucast_pkts': '168225429',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7028985150',
                                                                                                                  'out_octets': '9869751555048',
                                                                                                                  'out_ucast_pkts': '634970064',
                                                                                                                  'poller_hash': 'M0FERDcxcGVlcmludGZwb24gMQ=='},
                                                                                                          {       'in_nucast_pkts': '44985',
                                                                                                                  'in_octets': '549767299075',
                                                                                                                  'in_ucast_pkts': '1437550432',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270917',
                                                                                                                  'out_octets': '5059888873197',
                                                                                                                  'out_ucast_pkts': '3823526497',
                                                                                                                  'poller_hash': 'MzNENTgwcGVlcmludGZwb24gMg=='},
                                                                                                          {       'in_nucast_pkts': '15850550',
                                                                                                                  'in_octets': '85528827923',
                                                                                                                  'in_ucast_pkts': '656174674',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6729439851',
                                                                                                                  'out_octets': '11118297102766',
                                                                                                                  'out_ucast_pkts': '1573864424',
                                                                                                                  'poller_hash': 'NDJDNDE0cGVlcmludGZwb24gNQ=='},
                                                                                                          {       'in_nucast_pkts': '25874',
                                                                                                                  'in_octets': '46133098052',
                                                                                                                  'in_ucast_pkts': '181785162',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '945038',
                                                                                                                  'out_octets': '529518290927',
                                                                                                                  'out_ucast_pkts': '412435736',
                                                                                                                  'poller_hash': 'NDNDMjRDcGVlcmludGZwb24gOA=='},
                                                                                                          {       'in_nucast_pkts': '3394332',
                                                                                                                  'in_octets': '100003926520',
                                                                                                                  'in_ucast_pkts': '845109271',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9084394010',
                                                                                                                  'out_octets': '15062097504851',
                                                                                                                  'out_ucast_pkts': '2354930245',
                                                                                                                  'poller_hash': 'MzIxN0NBcGVlcmludGZwb24gMTE='},
                                                                                                          {       'in_nucast_pkts': '6911059',
                                                                                                                  'in_octets': '160435475902',
                                                                                                                  'in_ucast_pkts': '232380937',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10672529014',
                                                                                                                  'out_octets': '14680940872910',
                                                                                                                  'out_ucast_pkts': '593063899',
                                                                                                                  'poller_hash': 'MzIxNzE4cGVlcmludGZwb24gMTI='},
                                                                                                          {       'in_nucast_pkts': '10525796',
                                                                                                                  'in_octets': '111940418568',
                                                                                                                  'in_ucast_pkts': '574499854',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5681970628',
                                                                                                                  'out_octets': '10197324023541',
                                                                                                                  'out_ucast_pkts': '2067405028',
                                                                                                                  'poller_hash': 'MzIxN0EycGVlcmludGZwb24gMTQ='},
                                                                                                          {       'in_nucast_pkts': '45213',
                                                                                                                  'in_octets': '95707045129',
                                                                                                                  'in_ucast_pkts': '274029766',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270834',
                                                                                                                  'out_octets': '1310723248786',
                                                                                                                  'out_ucast_pkts': '1067406068',
                                                                                                                  'poller_hash': 'M0FFQzIxcGVlcmludGZwb24gMTY='},
                                                                                                          {       'in_nucast_pkts': '13130627',
                                                                                                                  'in_octets': '193396113095',
                                                                                                                  'in_ucast_pkts': '595698136',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '38955186615',
                                                                                                                  'out_octets': '54420370236767',
                                                                                                                  'out_ucast_pkts': '1811682051',
                                                                                                                  'poller_hash': 'NDJEMzhGcGVlcmludGZwb24gMTk='},
                                                                                                          {       'in_nucast_pkts': '5697',
                                                                                                                  'in_octets': '9661444668',
                                                                                                                  'in_ucast_pkts': '28126755',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '122211',
                                                                                                                  'out_octets': '89580768562',
                                                                                                                  'out_ucast_pkts': '69884959',
                                                                                                                  'poller_hash': 'NzFEODk3cGVlcmludGZwb24gMjI='},
                                                                                                          {       'in_nucast_pkts': '16631495',
                                                                                                                  'in_octets': '49753064177',
                                                                                                                  'in_ucast_pkts': '187722321',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12708034574',
                                                                                                                  'out_octets': '17142266975762',
                                                                                                                  'out_ucast_pkts': '432011781',
                                                                                                                  'poller_hash': 'MkVCOUI4cGVlcmludGZwb24gMjU='},
                                                                                                          {       'in_nucast_pkts': '23451545',
                                                                                                                  'in_octets': '340651059895',
                                                                                                                  'in_ucast_pkts': '424588647',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '33978219141',
                                                                                                                  'out_octets': '46902891601144',
                                                                                                                  'out_ucast_pkts': '1176681865',
                                                                                                                  'poller_hash': 'NTU2M0QxcGVlcmludGZwb24gMjY='},
                                                                                                          {       'in_nucast_pkts': '5502152',
                                                                                                                  'in_octets': '85661665890',
                                                                                                                  'in_ucast_pkts': '447078631',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10595542793',
                                                                                                                  'out_octets': '15975618804352',
                                                                                                                  'out_ucast_pkts': '1439710374',
                                                                                                                  'poller_hash': 'MTc1RTZEcGVlcmludGZwb24gMjc='},
                                                                                                          {       'in_nucast_pkts': '9440',
                                                                                                                  'in_octets': '130845485968',
                                                                                                                  'in_ucast_pkts': '716585687',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7593579',
                                                                                                                  'out_octets': '2993780427478',
                                                                                                                  'out_ucast_pkts': '2187032543',
                                                                                                                  'poller_hash': 'NDJEMzdGcGVlcmludGZwb24gODI='},
                                                                                                          {       'in_nucast_pkts': '2651986',
                                                                                                                  'in_octets': '53118180582',
                                                                                                                  'in_ucast_pkts': '168693625',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1693003758',
                                                                                                                  'out_octets': '2891230407486',
                                                                                                                  'out_ucast_pkts': '522607497',
                                                                                                                  'poller_hash': 'NDJEMUJEcGVlcmludGZwb24gODk='},
                                                                                                          {       'in_nucast_pkts': '7253',
                                                                                                                  'in_octets': '114747606857',
                                                                                                                  'in_ucast_pkts': '266980969',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '159596',
                                                                                                                  'out_octets': '1008427416993',
                                                                                                                  'out_ucast_pkts': '777151047',
                                                                                                                  'poller_hash': 'NEUzRDA0cGVlcmludGZwb24gMTE5'},
                                                                                                          {       'in_nucast_pkts': '10095202',
                                                                                                                  'in_octets': '13152842483',
                                                                                                                  'in_ucast_pkts': '69436478',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '27914618715',
                                                                                                                  'out_octets': '37574401496219',
                                                                                                                  'out_ucast_pkts': '150697343',
                                                                                                                  'poller_hash': 'NzIyMjEzcGVlcmludGZwb24gMTIw'},
                                                                                                          {       'in_nucast_pkts': '43168',
                                                                                                                  'in_octets': '72675304774',
                                                                                                                  'in_ucast_pkts': '504094768',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '271498',
                                                                                                                  'out_octets': '2895948738971',
                                                                                                                  'out_ucast_pkts': '2081146132',
                                                                                                                  'poller_hash': 'MTk5OUU5cGVlcmludGZwb24gMTI1'},
                                                                                                          {       'in_nucast_pkts': '123684',
                                                                                                                  'in_octets': '189827384837',
                                                                                                                  'in_ucast_pkts': '878335828',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '189800',
                                                                                                                  'out_octets': '3619104846229',
                                                                                                                  'out_ucast_pkts': '2565011561',
                                                                                                                  'poller_hash': 'QTlGQjlwZWVyaW50ZnBvbiAxMzE='},
                                                                                                          {       'in_nucast_pkts': '7634115',
                                                                                                                  'in_octets': '18079974671',
                                                                                                                  'in_ucast_pkts': '104182036',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3824357141',
                                                                                                                  'out_octets': '4899096086514',
                                                                                                                  'out_ucast_pkts': '233183635',
                                                                                                                  'poller_hash': 'QkYyNEYxcGVlcmludGZwb24gMTM0'},
                                                                                                          {       'in_nucast_pkts': '10804273',
                                                                                                                  'in_octets': '289908075413',
                                                                                                                  'in_ucast_pkts': '1861423455',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6281737937',
                                                                                                                  'out_octets': '14081635402845',
                                                                                                                  'out_ucast_pkts': '4389881337',
                                                                                                                  'poller_hash': 'MkVEOUY1cGVlcmludGZwb24gMjIy'},
                                                                                                          {       'in_nucast_pkts': '3659196',
                                                                                                                  'in_octets': '42942599121',
                                                                                                                  'in_ucast_pkts': '8692687130',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270602',
                                                                                                                  'out_octets': '197647458916',
                                                                                                                  'out_ucast_pkts': '190012170',
                                                                                                                  'poller_hash': 'NDE1RkVwZWVyaW50ZnBvbiAyMjM='},
                                                                                                          {       'in_nucast_pkts': '11445719',
                                                                                                                  'in_octets': '174408592122',
                                                                                                                  'in_ucast_pkts': '4873276433',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4309663625',
                                                                                                                  'out_octets': '7446062644735',
                                                                                                                  'out_ucast_pkts': '5734189993',
                                                                                                                  'poller_hash': 'M0NGOURwZWVyaW50ZnBvbiAyMjQ='},
                                                                                                          {       'in_nucast_pkts': '5713274',
                                                                                                                  'in_octets': '15274534801',
                                                                                                                  'in_ucast_pkts': '70535394',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12606003812',
                                                                                                                  'out_octets': '16974103010078',
                                                                                                                  'out_ucast_pkts': '98893647900',
                                                                                                                  'poller_hash': 'M0NGQThwZWVyaW50ZnBvbiAyMjU='},
                                                                                                          {       'in_nucast_pkts': '5111',
                                                                                                                  'in_octets': '4013730452',
                                                                                                                  'in_ucast_pkts': '25615980',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12243',
                                                                                                                  'out_octets': '170670972602',
                                                                                                                  'out_ucast_pkts': '124620287',
                                                                                                                  'poller_hash': 'MTc1RTY2cGVlcmludGZwb24gMjI2'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MjVCNUY5cGVlcmludGZwb24gMjI3'},
                                                                                                          {       'in_nucast_pkts': '9126123',
                                                                                                                  'in_octets': '17646409128',
                                                                                                                  'in_ucast_pkts': '69422511',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '16527663744',
                                                                                                                  'out_octets': '22209562508498',
                                                                                                                  'out_ucast_pkts': '257217618',
                                                                                                                  'poller_hash': 'NDAwM0Q0cGVlcmludGZwb24gMjI4'},
                                                                                                          {       'in_nucast_pkts': '9693072',
                                                                                                                  'in_octets': '374245789036',
                                                                                                                  'in_ucast_pkts': '563123983',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '25426561239',
                                                                                                                  'out_octets': '35846769166203',
                                                                                                                  'out_ucast_pkts': '1348598175',
                                                                                                                  'poller_hash': 'QzgxREQycGVlcmludGZwb24gMjI5'},
                                                                                                          {       'in_nucast_pkts': '12265',
                                                                                                                  'in_octets': '21947564396',
                                                                                                                  'in_ucast_pkts': '99207986',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8471787',
                                                                                                                  'out_octets': '328737482570',
                                                                                                                  'out_ucast_pkts': '263296797',
                                                                                                                  'poller_hash': 'NUE2QzU0cGVlcmludGZwb24gMTM4Njk0'},
                                                                                                          {       'in_nucast_pkts': '294789',
                                                                                                                  'in_octets': '52411837640',
                                                                                                                  'in_ucast_pkts': '296190771',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4673675',
                                                                                                                  'out_octets': '999396718841',
                                                                                                                  'out_ucast_pkts': '742856701',
                                                                                                                  'poller_hash': 'ODJBNTVBcGVlcmludGZwb24gMTQwOTM5'},
                                                                                                          {       'in_nucast_pkts': '202804',
                                                                                                                  'in_octets': '330296471100',
                                                                                                                  'in_ucast_pkts': '1765780626',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7560706',
                                                                                                                  'out_octets': '6808465578480',
                                                                                                                  'out_ucast_pkts': '4926470281',
                                                                                                                  'poller_hash': 'QzgxOTE0cGVlcmludGZwb24gMTk2MjI0'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '941652542773',
                                                                                         'out_octets': '1588786166639228',
                                                                                         'out_ucast_pkts': '227291135803',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzc=',
                                                                                         'pons': [       {       'id': '1/7',
                                                                                                                 'links': [       {       'connected_time': '14628607',
                                                                                                                                          'fiber_length': 757,
                                                                                                                                          'poller_hash': 'M0FERDcxcGVlcnBvbnBvbiAx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628974',
                                                                                                                                          'fiber_length': 1251,
                                                                                                                                          'poller_hash': 'MzNENTgwcGVlcnBvbnBvbiAy',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14643722',
                                                                                                                                          'fiber_length': 1181,
                                                                                                                                          'poller_hash': 'NDJDNDE0cGVlcnBvbnBvbiA1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '15060181',
                                                                                                                                          'fiber_length': 431,
                                                                                                                                          'poller_hash': 'NDNDMjRDcGVlcnBvbnBvbiA4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14357718',
                                                                                                                                          'fiber_length': 1048,
                                                                                                                                          'poller_hash': 'MzIxN0NBcGVlcnBvbnBvbiAxMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14643977',
                                                                                                                                          'fiber_length': 1083,
                                                                                                                                          'poller_hash': 'MzIxNzE4cGVlcnBvbnBvbiAxMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14361795',
                                                                                                                                          'fiber_length': 1224,
                                                                                                                                          'poller_hash': 'MzIxN0EycGVlcnBvbnBvbiAxNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628873',
                                                                                                                                          'fiber_length': 819,
                                                                                                                                          'poller_hash': 'M0FFQzIxcGVlcnBvbnBvbiAxNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14643665',
                                                                                                                                          'fiber_length': 853,
                                                                                                                                          'poller_hash': 'NDJEMzhGcGVlcnBvbnBvbiAxOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628727',
                                                                                                                                          'fiber_length': 621,
                                                                                                                                          'poller_hash': 'NzFEODk3cGVlcnBvbnBvbiAyMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628712',
                                                                                                                                          'fiber_length': 1135,
                                                                                                                                          'poller_hash': 'MkVCOUI4cGVlcnBvbnBvbiAyNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628417',
                                                                                                                                          'fiber_length': 1050,
                                                                                                                                          'poller_hash': 'NTU2M0QxcGVlcnBvbnBvbiAyNg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628647',
                                                                                                                                          'fiber_length': 444,
                                                                                                                                          'poller_hash': 'MTc1RTZEcGVlcnBvbnBvbiAyNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14643752',
                                                                                                                                          'fiber_length': 1284,
                                                                                                                                          'poller_hash': 'NDJEMzdGcGVlcnBvbnBvbiA4Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '3545930',
                                                                                                                                          'fiber_length': 893,
                                                                                                                                          'poller_hash': 'NDJEMUJEcGVlcnBvbnBvbiA4OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '7332905',
                                                                                                                                          'fiber_length': 1174,
                                                                                                                                          'poller_hash': 'NEUzRDA0cGVlcnBvbnBvbiAxMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628883',
                                                                                                                                          'fiber_length': 1259,
                                                                                                                                          'poller_hash': 'NzIyMjEzcGVlcnBvbnBvbiAxMjA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628819',
                                                                                                                                          'fiber_length': 428,
                                                                                                                                          'poller_hash': 'MTk5OUU5cGVlcnBvbnBvbiAxMjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '9979802',
                                                                                                                                          'fiber_length': 890,
                                                                                                                                          'poller_hash': 'QTlGQjlwZWVycG9ucG9uIDEzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628864',
                                                                                                                                          'fiber_length': 607,
                                                                                                                                          'poller_hash': 'QkYyNEYxcGVlcnBvbnBvbiAxMzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628473',
                                                                                                                                          'fiber_length': 1200,
                                                                                                                                          'poller_hash': 'MkVEOUY1cGVlcnBvbnBvbiAyMjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628811',
                                                                                                                                          'fiber_length': 1137,
                                                                                                                                          'poller_hash': 'NDE1RkVwZWVycG9ucG9uIDIyMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628781',
                                                                                                                                          'fiber_length': 1161,
                                                                                                                                          'poller_hash': 'M0NGOURwZWVycG9ucG9uIDIyNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628798',
                                                                                                                                          'fiber_length': 1169,
                                                                                                                                          'poller_hash': 'M0NGQThwZWVycG9ucG9uIDIyNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '595144',
                                                                                                                                          'fiber_length': 1108,
                                                                                                                                          'poller_hash': 'MTc1RTY2cGVlcnBvbnBvbiAyMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628442',
                                                                                                                                          'fiber_length': 1081,
                                                                                                                                          'poller_hash': 'MjVCNUY5cGVlcnBvbnBvbiAyMjc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14628986',
                                                                                                                                          'fiber_length': 1034,
                                                                                                                                          'poller_hash': 'NDAwM0Q0cGVlcnBvbnBvbiAyMjg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14643956',
                                                                                                                                          'fiber_length': 1118,
                                                                                                                                          'poller_hash': 'QzgxREQycGVlcnBvbnBvbiAyMjk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '15061053',
                                                                                                                                          'fiber_length': 1038,
                                                                                                                                          'poller_hash': 'NUE2QzU0cGVlcnBvbnBvbiAxMzg2OTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '8986269',
                                                                                                                                          'fiber_length': 1370,
                                                                                                                                          'poller_hash': 'ODJBNTVBcGVlcnBvbnBvbiAxNDA5Mzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519},
                                                                                                                                  {       'connected_time': '14644153',
                                                                                                                                          'fiber_length': 1557,
                                                                                                                                          'poller_hash': 'QzgxOTE0cGVlcnBvbnBvbiAxOTYyMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.519}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/7',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/8',
                                                                                         'in_discards': '141494',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '5496166',
                                                                                         'in_octets': '16828310206353',
                                                                                         'in_ucast_pkts': '74551465449',
                                                                                         'links': [       {       'in_nucast_pkts': '12590008',
                                                                                                                  'in_octets': '197178900114',
                                                                                                                  'in_ucast_pkts': '384113525',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '19192575989',
                                                                                                                  'out_octets': '27574186856631',
                                                                                                                  'out_ucast_pkts': '1452081518',
                                                                                                                  'poller_hash': 'NDI4MUQwcGVlcmludGZwb24gMzI='},
                                                                                                          {       'in_nucast_pkts': '12677956',
                                                                                                                  'in_octets': '367127893201',
                                                                                                                  'in_ucast_pkts': '2194828850',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8647603350',
                                                                                                                  'out_octets': '18533945431829',
                                                                                                                  'out_ucast_pkts': '4998950683',
                                                                                                                  'poller_hash': 'NDcwOTJDcGVlcmludGZwb24gMzM='},
                                                                                                          {       'in_nucast_pkts': '1466111',
                                                                                                                  'in_octets': '51469644276',
                                                                                                                  'in_ucast_pkts': '80816603',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '522954220',
                                                                                                                  'out_octets': '946531435900',
                                                                                                                  'out_ucast_pkts': '207410643',
                                                                                                                  'poller_hash': 'MjQ4QUMzcGVlcmludGZwb24gMzQ='},
                                                                                                          {       'in_nucast_pkts': '3676412',
                                                                                                                  'in_octets': '378752340573',
                                                                                                                  'in_ucast_pkts': '972398053',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '542100',
                                                                                                                  'out_octets': '4755540617724',
                                                                                                                  'out_ucast_pkts': '3638803798',
                                                                                                                  'poller_hash': 'NTYwMjYycGVlcmludGZwb24gMzg='},
                                                                                                          {       'in_nucast_pkts': '4921050',
                                                                                                                  'in_octets': '9975007993',
                                                                                                                  'in_ucast_pkts': '49119341',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4103007472',
                                                                                                                  'out_octets': '5378358765570',
                                                                                                                  'out_ucast_pkts': '84656857',
                                                                                                                  'poller_hash': 'MzI5NjNDcGVlcmludGZwb24gMzk='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'NEQ0MUVFcGVlcmludGZwb24gNDI='},
                                                                                                          {       'in_nucast_pkts': '11871146',
                                                                                                                  'in_octets': '53029892926',
                                                                                                                  'in_ucast_pkts': '203997182',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2053579251',
                                                                                                                  'out_octets': '3733149292466',
                                                                                                                  'out_ucast_pkts': '836761109',
                                                                                                                  'poller_hash': 'QzRGRjRwZWVyaW50ZnBvbiA0NQ=='},
                                                                                                          {       'in_nucast_pkts': '9116',
                                                                                                                  'in_octets': '66432781212',
                                                                                                                  'in_ucast_pkts': '453344640',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15',
                                                                                                                  'out_octets': '2791909714374',
                                                                                                                  'out_ucast_pkts': '1973019156',
                                                                                                                  'poller_hash': 'NTVFQTkwcGVlcmludGZwb24gNDc='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'N0ZFMkFwZWVyaW50ZnBvbiA1MQ=='},
                                                                                                          {       'in_nucast_pkts': '6920503',
                                                                                                                  'in_octets': '23959004468',
                                                                                                                  'in_ucast_pkts': '59334708',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11484878607',
                                                                                                                  'out_octets': '15091156516139',
                                                                                                                  'out_ucast_pkts': '114095618',
                                                                                                                  'poller_hash': 'NDJDOENGcGVlcmludGZwb24gNzY='},
                                                                                                          {       'in_nucast_pkts': '11375574',
                                                                                                                  'in_octets': '138539039170',
                                                                                                                  'in_ucast_pkts': '712948191',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10672783105',
                                                                                                                  'out_octets': '17589274230352',
                                                                                                                  'out_ucast_pkts': '2374477112',
                                                                                                                  'poller_hash': 'ODY5M0RGcGVlcmludGZwb24gOTA='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'QUMzRTRwZWVyaW50ZnBvbiAxMzc='},
                                                                                                          {       'in_nucast_pkts': '153399',
                                                                                                                  'in_octets': '219275030399',
                                                                                                                  'in_ucast_pkts': '445986038',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '276036',
                                                                                                                  'out_octets': '804532267954',
                                                                                                                  'out_ucast_pkts': '718223238',
                                                                                                                  'poller_hash': 'NDE1NDJwZWVyaW50ZnBvbiAxOTk='},
                                                                                                          {       'in_nucast_pkts': '3670',
                                                                                                                  'in_octets': '892498825423',
                                                                                                                  'in_ucast_pkts': '2071136902',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '262929',
                                                                                                                  'out_octets': '3106515556749',
                                                                                                                  'out_ucast_pkts': '2540721448',
                                                                                                                  'poller_hash': 'Q0MwQjZwZWVyaW50ZnBvbiAyMDA='},
                                                                                                          {       'in_nucast_pkts': '8281896',
                                                                                                                  'in_octets': '22999031016',
                                                                                                                  'in_ucast_pkts': '141001019',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11849598504',
                                                                                                                  'out_octets': '16285875671787',
                                                                                                                  'out_ucast_pkts': '552465005',
                                                                                                                  'poller_hash': 'MzY1NUE5cGVlcmludGZwb24gMjAx'},
                                                                                                          {       'in_nucast_pkts': '7402',
                                                                                                                  'in_octets': '154318533697',
                                                                                                                  'in_ucast_pkts': '661362376',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270553',
                                                                                                                  'out_octets': '1922269727563',
                                                                                                                  'out_ucast_pkts': '1507315276',
                                                                                                                  'poller_hash': 'NDE1MkZwZWVyaW50ZnBvbiAyMDI='},
                                                                                                          {       'in_nucast_pkts': '9029',
                                                                                                                  'in_octets': '57976074723',
                                                                                                                  'in_ucast_pkts': '246787659',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270590',
                                                                                                                  'out_octets': '493046643140',
                                                                                                                  'out_ucast_pkts': '419760900',
                                                                                                                  'poller_hash': 'M0VCQTUzcGVlcmludGZwb24gMjMw'},
                                                                                                          {       'in_nucast_pkts': '85915',
                                                                                                                  'in_octets': '136795205654',
                                                                                                                  'in_ucast_pkts': '617855792',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '71450',
                                                                                                                  'out_octets': '2595885117096',
                                                                                                                  'out_ucast_pkts': '1941567187',
                                                                                                                  'poller_hash': 'M0FFQkJEcGVlcmludGZwb24gMjM4'},
                                                                                                          {       'in_nucast_pkts': '10898',
                                                                                                                  'in_octets': '199873296311',
                                                                                                                  'in_ucast_pkts': '1184373714',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270552',
                                                                                                                  'out_octets': '3409593990792',
                                                                                                                  'out_ucast_pkts': '2670902733',
                                                                                                                  'poller_hash': 'M0FFQkI2cGVlcmludGZwb24gMjM5'},
                                                                                                          {       'in_nucast_pkts': '13283',
                                                                                                                  'in_octets': '81750790693',
                                                                                                                  'in_ucast_pkts': '362053392',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '270574',
                                                                                                                  'out_octets': '1408735471104',
                                                                                                                  'out_ucast_pkts': '1009531261',
                                                                                                                  'poller_hash': 'M0FFQjk4cGVlcmludGZwb24gMjQw'},
                                                                                                          {       'in_nucast_pkts': '3204126',
                                                                                                                  'in_octets': '126617983625',
                                                                                                                  'in_ucast_pkts': '230524148',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3621125693',
                                                                                                                  'out_octets': '5328684628956',
                                                                                                                  'out_ucast_pkts': '557256037',
                                                                                                                  'poller_hash': 'MTMwMDVGcGVlcmludGZwb24gMjQx'},
                                                                                                          {       'in_nucast_pkts': '4917909',
                                                                                                                  'in_octets': '19053541931',
                                                                                                                  'in_ucast_pkts': '48431273',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3483597402',
                                                                                                                  'out_octets': '4608486067206',
                                                                                                                  'out_ucast_pkts': '141678217',
                                                                                                                  'poller_hash': 'MTMwMDhCcGVlcmludGZwb24gMjQy'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'NDAwRjY0cGVlcmludGZwb24gMjQz'},
                                                                                                          {       'in_nucast_pkts': '3459',
                                                                                                                  'in_octets': '2176623874',
                                                                                                                  'in_ucast_pkts': '15008651',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '23849',
                                                                                                                  'out_octets': '62478340722',
                                                                                                                  'out_ucast_pkts': '44748326',
                                                                                                                  'poller_hash': 'NzFEOEEwcGVlcmludGZwb24gMjQ0'},
                                                                                                          {       'in_nucast_pkts': '10739',
                                                                                                                  'in_octets': '12594845548',
                                                                                                                  'in_ucast_pkts': '59113320',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '269575',
                                                                                                                  'out_octets': '182294197357',
                                                                                                                  'out_ucast_pkts': '161525589',
                                                                                                                  'poller_hash': 'NTU2M0I2cGVlcmludGZwb24gMjQ1'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODczMjNwZWVyaW50ZnBvbiAyNDY='},
                                                                                                          {       'in_nucast_pkts': '9057152',
                                                                                                                  'in_octets': '224190004167',
                                                                                                                  'in_ucast_pkts': '1726734213',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18503338807',
                                                                                                                  'out_octets': '29611673794941',
                                                                                                                  'out_ucast_pkts': '3442459641',
                                                                                                                  'poller_hash': 'NEQ0MUY1cGVlcmludGZwb24gMjQ3'},
                                                                                                          {       'in_nucast_pkts': '19389232',
                                                                                                                  'in_octets': '12125313181',
                                                                                                                  'in_ucast_pkts': '34364244',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6917725976',
                                                                                                                  'out_octets': '8616540324176',
                                                                                                                  'out_ucast_pkts': '101373891',
                                                                                                                  'poller_hash': 'MjQ4QUUzcGVlcmludGZwb24gMjQ4'},
                                                                                                          {       'in_nucast_pkts': '11674676',
                                                                                                                  'in_octets': '167770872207',
                                                                                                                  'in_ucast_pkts': '827655043',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5136004438',
                                                                                                                  'out_octets': '9482570095992',
                                                                                                                  'out_ucast_pkts': '1995371369',
                                                                                                                  'poller_hash': 'NDAwNDU1cGVlcmludGZwb24gMjQ5'},
                                                                                                          {       'in_nucast_pkts': '2482860',
                                                                                                                  'in_octets': '8078036728',
                                                                                                                  'in_ucast_pkts': '30896287',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6582386287',
                                                                                                                  'out_octets': '8986391744142',
                                                                                                                  'out_ucast_pkts': '140033124',
                                                                                                                  'poller_hash': 'ODY5MzlDcGVlcmludGZwb24gMTM4ODgx'},
                                                                                                          {       'in_nucast_pkts': '5770918',
                                                                                                                  'in_octets': '77918917229',
                                                                                                                  'in_ucast_pkts': '534263923',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8471740',
                                                                                                                  'out_octets': '2829274323755',
                                                                                                                  'out_ucast_pkts': '1967092495',
                                                                                                                  'poller_hash': 'ODQ0QkU1cGVlcmludGZwb24gMTQwODUz'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '665841663503',
                                                                                         'out_octets': '1172794250006086',
                                                                                         'out_ucast_pkts': '197398238365',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzg=',
                                                                                         'pons': [       {       'id': '1/8',
                                                                                                                 'links': [       {       'connected_time': '12589738',
                                                                                                                                          'fiber_length': 1372,
                                                                                                                                          'poller_hash': 'NDI4MUQwcGVlcnBvbnBvbiAzMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628770',
                                                                                                                                          'fiber_length': 1354,
                                                                                                                                          'poller_hash': 'NDcwOTJDcGVlcnBvbnBvbiAzMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '8985769',
                                                                                                                                          'fiber_length': 951,
                                                                                                                                          'poller_hash': 'MjQ4QUMzcGVlcnBvbnBvbiAzNA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628515',
                                                                                                                                          'fiber_length': 450,
                                                                                                                                          'poller_hash': 'NTYwMjYycGVlcnBvbnBvbiAzOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628850',
                                                                                                                                          'fiber_length': 599,
                                                                                                                                          'poller_hash': 'MzI5NjNDcGVlcnBvbnBvbiAzOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628716',
                                                                                                                                          'fiber_length': 457,
                                                                                                                                          'poller_hash': 'NEQ0MUVFcGVlcnBvbnBvbiA0Mg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '8985595',
                                                                                                                                          'fiber_length': 940,
                                                                                                                                          'poller_hash': 'QzRGRjRwZWVycG9ucG9uIDQ1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628866',
                                                                                                                                          'fiber_length': 590,
                                                                                                                                          'poller_hash': 'NTVFQTkwcGVlcnBvbnBvbiA0Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628769',
                                                                                                                                          'fiber_length': 1139,
                                                                                                                                          'poller_hash': 'N0ZFMkFwZWVycG9ucG9uIDUx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '8985772',
                                                                                                                                          'fiber_length': 982,
                                                                                                                                          'poller_hash': 'NDJDOENGcGVlcnBvbnBvbiA3Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14643826',
                                                                                                                                          'fiber_length': 792,
                                                                                                                                          'poller_hash': 'ODY5M0RGcGVlcnBvbnBvbiA5MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'poller_hash': 'QUMzRTRwZWVycG9ucG9uIDEzNw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628852',
                                                                                                                                          'fiber_length': 656,
                                                                                                                                          'poller_hash': 'NDE1NDJwZWVycG9ucG9uIDE5OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14363849',
                                                                                                                                          'fiber_length': 726,
                                                                                                                                          'poller_hash': 'Q0MwQjZwZWVycG9ucG9uIDIwMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628659',
                                                                                                                                          'fiber_length': 836,
                                                                                                                                          'poller_hash': 'MzY1NUE5cGVlcnBvbnBvbiAyMDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628872',
                                                                                                                                          'fiber_length': 699,
                                                                                                                                          'poller_hash': 'NDE1MkZwZWVycG9ucG9uIDIwMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628917',
                                                                                                                                          'fiber_length': 405,
                                                                                                                                          'poller_hash': 'M0VCQTUzcGVlcnBvbnBvbiAyMzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '8565981',
                                                                                                                                          'fiber_length': 1234,
                                                                                                                                          'poller_hash': 'M0FFQkJEcGVlcnBvbnBvbiAyMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628937',
                                                                                                                                          'fiber_length': 945,
                                                                                                                                          'poller_hash': 'M0FFQkI2cGVlcnBvbnBvbiAyMzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14629140',
                                                                                                                                          'fiber_length': 491,
                                                                                                                                          'poller_hash': 'M0FFQjk4cGVlcnBvbnBvbiAyNDA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '8985718',
                                                                                                                                          'fiber_length': 1057,
                                                                                                                                          'poller_hash': 'MTMwMDVGcGVlcnBvbnBvbiAyNDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628701',
                                                                                                                                          'fiber_length': 782,
                                                                                                                                          'poller_hash': 'MTMwMDhCcGVlcnBvbnBvbiAyNDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '4321372',
                                                                                                                                          'fiber_length': 893,
                                                                                                                                          'poller_hash': 'NDAwRjY0cGVlcnBvbnBvbiAyNDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '2852499',
                                                                                                                                          'fiber_length': 467,
                                                                                                                                          'poller_hash': 'NzFEOEEwcGVlcnBvbnBvbiAyNDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14629108',
                                                                                                                                          'fiber_length': 580,
                                                                                                                                          'poller_hash': 'NTU2M0I2cGVlcnBvbnBvbiAyNDU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '75415',
                                                                                                                                          'fiber_length': 1019,
                                                                                                                                          'poller_hash': 'ODczMjNwZWVycG9ucG9uIDI0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628953',
                                                                                                                                          'fiber_length': 1181,
                                                                                                                                          'poller_hash': 'NEQ0MUY1cGVlcnBvbnBvbiAyNDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14628840',
                                                                                                                                          'fiber_length': 1099,
                                                                                                                                          'poller_hash': 'MjQ4QUUzcGVlcnBvbnBvbiAyNDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '14629098',
                                                                                                                                          'fiber_length': 1110,
                                                                                                                                          'poller_hash': 'NDAwNDU1cGVlcnBvbnBvbiAyNDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '5255614',
                                                                                                                                          'fiber_length': 976,
                                                                                                                                          'poller_hash': 'ODY5MzlDcGVlcnBvbnBvbiAxMzg4ODE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678},
                                                                                                                                  {       'connected_time': '15061208',
                                                                                                                                          'fiber_length': 1109,
                                                                                                                                          'poller_hash': 'ODQ0QkU1cGVlcnBvbnBvbiAxNDA4NTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.678}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/8',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzg=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03006',
                                                           'name': 'GPON-8',
                                                           'poller_hash': 'MjExNzAzNjAxMTg4',
                                                           'serial_number': '211703601188',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '76928066'},
                                                   {       'id': '2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '2/x3',
                                                                                         'in_discards': '455333812',
                                                                                         'in_errors': '1521',
                                                                                         'in_nucast_pkts': '10171848167545',
                                                                                         'in_octets': '38477027641351940',
                                                                                         'in_ucast_pkts': '19284062908565',
                                                                                         'mac_address': 'cc:be:59:12:6a:8f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01511',
                                                                                         'name': 'ethernet '
                                                                                                 '2/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '2082931852',
                                                                                         'out_octets': '3321690718190181',
                                                                                         'out_ucast_pkts': '8515535497776',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/x4',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18637615',
                                                                                         'in_octets': '2531393217',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': 'cc:be:59:12:6a:90',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC02',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 '2/x4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '29793171',
                                                                                         'out_octets': '35176094813530',
                                                                                         'out_ucast_pkts': '112510662115',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0TUNDTC1TVUJTIDIveDQ=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2417090',
                                                                                         'in_octets': '864109425',
                                                                                         'in_ucast_pkts': '9082339',
                                                                                         'mac_address': 'cc:be:59:12:6a:81',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-GB-GE-T',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '790259428',
                                                                                         'out_octets': '106218044813',
                                                                                         'out_ucast_pkts': '8265680',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMQ==',
                                                                                         'speed': '100000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '2/g2',
                                                                                         'mac_address': 'cc:be:59:12:6a:82',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '2/g3',
                                                                                         'mac_address': 'cc:be:59:12:6a:83',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMw=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g4',
                                                                                         'in_discards': '123',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '75725',
                                                                                         'in_octets': '5077044315',
                                                                                         'in_ucast_pkts': '24823957',
                                                                                         'mac_address': 'cc:be:59:12:6a:84',
                                                                                         'manufacturer': 'BROCADE',
                                                                                         'model': '57-1000042-01',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '83481833',
                                                                                         'out_octets': '13756604479',
                                                                                         'out_ucast_pkts': '60184388',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/1',
                                                                                         'in_discards': '127101',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '5277102',
                                                                                         'in_octets': '21225383593315',
                                                                                         'in_ucast_pkts': '100190907899',
                                                                                         'links': [       {       'in_nucast_pkts': '2157',
                                                                                                                  'in_octets': '122186921276',
                                                                                                                  'in_ucast_pkts': '601445791',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '431614',
                                                                                                                  'out_octets': '1750007511817',
                                                                                                                  'out_ucast_pkts': '1343011291',
                                                                                                                  'poller_hash': 'NTU2M0FCcGVlcmludGZwb24gMjUw'},
                                                                                                          {       'in_nucast_pkts': '83290',
                                                                                                                  'in_octets': '367135583502',
                                                                                                                  'in_ucast_pkts': '3338024059',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '535391',
                                                                                                                  'out_octets': '6356523071662',
                                                                                                                  'out_ucast_pkts': '4430871159',
                                                                                                                  'poller_hash': 'NEQ0MjNEcGVlcmludGZwb24gMjUz'},
                                                                                                          {       'in_nucast_pkts': '8800',
                                                                                                                  'in_octets': '49866112958',
                                                                                                                  'in_ucast_pkts': '458310615',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '518560',
                                                                                                                  'out_octets': '1774099828498',
                                                                                                                  'out_ucast_pkts': '1252024486',
                                                                                                                  'poller_hash': 'QzUwMTBwZWVyaW50ZnBvbiAyNTQ='},
                                                                                                          {       'in_nucast_pkts': '680503',
                                                                                                                  'in_octets': '27937094133',
                                                                                                                  'in_ucast_pkts': '219953415',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '447999',
                                                                                                                  'out_octets': '1102542599790',
                                                                                                                  'out_ucast_pkts': '761947592',
                                                                                                                  'poller_hash': 'NEQ0MUY3cGVlcmludGZwb24gMjU3'},
                                                                                                          {       'in_nucast_pkts': '10950297',
                                                                                                                  'in_octets': '49820814636',
                                                                                                                  'in_ucast_pkts': '154266127',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4865264310',
                                                                                                                  'out_octets': '6840586239655',
                                                                                                                  'out_ucast_pkts': '443898730',
                                                                                                                  'poller_hash': 'QkYxRTFCcGVlcmludGZwb24gMjU4'},
                                                                                                          {       'in_nucast_pkts': '14282676',
                                                                                                                  'in_octets': '52192289652',
                                                                                                                  'in_ucast_pkts': '135883092',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '29486444354',
                                                                                                                  'out_octets': '40082564080161',
                                                                                                                  'out_ucast_pkts': '451729298',
                                                                                                                  'poller_hash': 'MjQ4QUM1cGVlcmludGZwb24gMjYw'},
                                                                                                          {       'in_nucast_pkts': '4210998',
                                                                                                                  'in_octets': '220984446862',
                                                                                                                  'in_ucast_pkts': '929714306',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5166366691',
                                                                                                                  'out_octets': '10108138370781',
                                                                                                                  'out_ucast_pkts': '2638147520',
                                                                                                                  'poller_hash': 'M0ZGRkUzcGVlcmludGZwb24gMjYx'},
                                                                                                          {       'in_nucast_pkts': '17834536',
                                                                                                                  'in_octets': '229974985328',
                                                                                                                  'in_ucast_pkts': '1814061610',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '535066',
                                                                                                                  'out_octets': '4853595354419',
                                                                                                                  'out_ucast_pkts': '3444586325',
                                                                                                                  'poller_hash': 'NDE4QjdwZWVyaW50ZnBvbiAyNjM='},
                                                                                                          {       'in_nucast_pkts': '9572',
                                                                                                                  'in_octets': '259683870182',
                                                                                                                  'in_ucast_pkts': '2360981005',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534685',
                                                                                                                  'out_octets': '7364409114409',
                                                                                                                  'out_ucast_pkts': '5099467842',
                                                                                                                  'poller_hash': 'MjNBMDAzcGVlcmludGZwb24gMjY1'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'NTU1Q0I4cGVlcmludGZwb24gMjY5'},
                                                                                                          {       'in_nucast_pkts': '7578920',
                                                                                                                  'in_octets': '8159463903',
                                                                                                                  'in_ucast_pkts': '40336612',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14452168962',
                                                                                                                  'out_octets': '19277745162013',
                                                                                                                  'out_ucast_pkts': '162374143',
                                                                                                                  'poller_hash': 'MkZDQzMxcGVlcmludGZwb24gMjcw'},
                                                                                                          {       'in_nucast_pkts': '1168428',
                                                                                                                  'in_octets': '487359671597',
                                                                                                                  'in_ucast_pkts': '1519580538',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '598060',
                                                                                                                  'out_octets': '4440669992266',
                                                                                                                  'out_ucast_pkts': '3779107677',
                                                                                                                  'poller_hash': 'RjIzQTVwZWVyaW50ZnBvbiAyNzE='},
                                                                                                          {       'in_nucast_pkts': '160591',
                                                                                                                  'in_octets': '324056997016',
                                                                                                                  'in_ucast_pkts': '1882117132',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '536406',
                                                                                                                  'out_octets': '6668443104156',
                                                                                                                  'out_ucast_pkts': '4729269527',
                                                                                                                  'poller_hash': 'MTk5OUY3cGVlcmludGZwb24gMjcy'},
                                                                                                          {       'in_nucast_pkts': '9273',
                                                                                                                  'in_octets': '74846806850',
                                                                                                                  'in_ucast_pkts': '272153194',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534614',
                                                                                                                  'out_octets': '2181816246959',
                                                                                                                  'out_ucast_pkts': '1598376680',
                                                                                                                  'poller_hash': 'MTI0ODQ1cGVlcmludGZwb24gMjcz'},
                                                                                                          {       'in_nucast_pkts': '23956',
                                                                                                                  'in_octets': '238558859117',
                                                                                                                  'in_ucast_pkts': '569036110',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534406',
                                                                                                                  'out_octets': '2202468440761',
                                                                                                                  'out_ucast_pkts': '1724388677',
                                                                                                                  'poller_hash': 'MTk5OUUxcGVlcmludGZwb24gMjc0'},
                                                                                                          {       'in_nucast_pkts': '7633993',
                                                                                                                  'in_octets': '10754735159',
                                                                                                                  'in_ucast_pkts': '34220498',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11003077239',
                                                                                                                  'out_octets': '14696398399187',
                                                                                                                  'out_ucast_pkts': '54281555',
                                                                                                                  'poller_hash': 'NEQ0MjQycGVlcmludGZwb24gMjc1'},
                                                                                                          {       'in_nucast_pkts': '46168',
                                                                                                                  'in_octets': '196461665206',
                                                                                                                  'in_ucast_pkts': '784404209',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '535305',
                                                                                                                  'out_octets': '2374918877006',
                                                                                                                  'out_ucast_pkts': '1750955073',
                                                                                                                  'poller_hash': 'NDAwN0ZGcGVlcmludGZwb24gMjc2'},
                                                                                                          {       'in_nucast_pkts': '6388',
                                                                                                                  'in_octets': '93195322859',
                                                                                                                  'in_ucast_pkts': '304149497',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534509',
                                                                                                                  'out_octets': '2416877340863',
                                                                                                                  'out_ucast_pkts': '1749236624',
                                                                                                                  'poller_hash': 'NzIyMDQxcGVlcmludGZwb24gMjc3'},
                                                                                                          {       'in_nucast_pkts': '13432135',
                                                                                                                  'in_octets': '41879686570',
                                                                                                                  'in_ucast_pkts': '301271646',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '26243265032',
                                                                                                                  'out_octets': '36980261843461',
                                                                                                                  'out_ucast_pkts': '1064735653',
                                                                                                                  'poller_hash': 'QTlDOTMxcGVlcmludGZwb24gMTU2NDU2'},
                                                                                                          {       'in_nucast_pkts': '47843',
                                                                                                                  'in_octets': '87296979300',
                                                                                                                  'in_ucast_pkts': '781190473',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7851829',
                                                                                                                  'out_octets': '2968224938957',
                                                                                                                  'out_ucast_pkts': '2081591778',
                                                                                                                  'poller_hash': 'QzgzRTBBcGVlcmludGZwb24gMTYxNjA3'},
                                                                                                          {       'in_nucast_pkts': '2944127',
                                                                                                                  'in_octets': '34067341158',
                                                                                                                  'in_ucast_pkts': '77430482',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1779690',
                                                                                                                  'out_octets': '410400980698',
                                                                                                                  'out_ucast_pkts': '302394650',
                                                                                                                  'poller_hash': 'QzgzQkFCcGVlcmludGZwb24gMTY0MjA3'},
                                                                                                          {       'in_nucast_pkts': '6370032',
                                                                                                                  'in_octets': '161718433095',
                                                                                                                  'in_ucast_pkts': '787063284',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1950063112',
                                                                                                                  'out_octets': '5085710126375',
                                                                                                                  'out_ucast_pkts': '1902994889',
                                                                                                                  'poller_hash': 'MTE5NTE1QnBlZXJpbnRmcG9uIDIxMjYyMA=='},
                                                                                                          {       'in_nucast_pkts': '22555',
                                                                                                                  'in_octets': '320866866043',
                                                                                                                  'in_ucast_pkts': '2114218168',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '120744',
                                                                                                                  'out_octets': '9562929365427',
                                                                                                                  'out_ucast_pkts': '6805306579',
                                                                                                                  'poller_hash': 'QkYyNEQzcGVlcmludGZwb24gMjEzMjM4'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '494411512657',
                                                                                         'out_octets': '1034392023431035',
                                                                                         'out_ucast_pkts': '265138078666',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzE=',
                                                                                         'pons': [       {       'id': '2/1',
                                                                                                                 'links': [       {       'connected_time': '11076245',
                                                                                                                                          'fiber_length': 1149,
                                                                                                                                          'poller_hash': 'NTU2M0FCcGVlcnBvbnBvbiAyNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628899',
                                                                                                                                          'fiber_length': 906,
                                                                                                                                          'poller_hash': 'NEQ0MjNEcGVlcnBvbnBvbiAyNTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628917',
                                                                                                                                          'fiber_length': 985,
                                                                                                                                          'poller_hash': 'QzUwMTBwZWVycG9ucG9uIDI1NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '11501245',
                                                                                                                                          'fiber_length': 911,
                                                                                                                                          'poller_hash': 'NEQ0MUY3cGVlcnBvbnBvbiAyNTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628819',
                                                                                                                                          'fiber_length': 949,
                                                                                                                                          'poller_hash': 'QkYxRTFCcGVlcnBvbnBvbiAyNTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14629208',
                                                                                                                                          'fiber_length': 819,
                                                                                                                                          'poller_hash': 'MjQ4QUM1cGVlcnBvbnBvbiAyNjA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628943',
                                                                                                                                          'fiber_length': 805,
                                                                                                                                          'poller_hash': 'M0ZGRkUzcGVlcnBvbnBvbiAyNjE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628969',
                                                                                                                                          'fiber_length': 712,
                                                                                                                                          'poller_hash': 'NDE4QjdwZWVycG9ucG9uIDI2Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628891',
                                                                                                                                          'fiber_length': 841,
                                                                                                                                          'poller_hash': 'MjNBMDAzcGVlcnBvbnBvbiAyNjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628948',
                                                                                                                                          'fiber_length': 1423,
                                                                                                                                          'poller_hash': 'NTU1Q0I4cGVlcnBvbnBvbiAyNjk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14629041',
                                                                                                                                          'fiber_length': 967,
                                                                                                                                          'poller_hash': 'MkZDQzMxcGVlcnBvbnBvbiAyNzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628703',
                                                                                                                                          'fiber_length': 611,
                                                                                                                                          'poller_hash': 'RjIzQTVwZWVycG9ucG9uIDI3MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628902',
                                                                                                                                          'fiber_length': 588,
                                                                                                                                          'poller_hash': 'MTk5OUY3cGVlcnBvbnBvbiAyNzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628962',
                                                                                                                                          'fiber_length': 589,
                                                                                                                                          'poller_hash': 'MTI0ODQ1cGVlcnBvbnBvbiAyNzM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628842',
                                                                                                                                          'fiber_length': 736,
                                                                                                                                          'poller_hash': 'MTk5OUUxcGVlcnBvbnBvbiAyNzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '6574285',
                                                                                                                                          'fiber_length': 623,
                                                                                                                                          'poller_hash': 'NEQ0MjQycGVlcnBvbnBvbiAyNzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14628927',
                                                                                                                                          'fiber_length': 630,
                                                                                                                                          'poller_hash': 'NDAwN0ZGcGVlcnBvbnBvbiAyNzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14629039',
                                                                                                                                          'fiber_length': 628,
                                                                                                                                          'poller_hash': 'NzIyMDQxcGVlcnBvbnBvbiAyNzc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14643985',
                                                                                                                                          'fiber_length': 1215,
                                                                                                                                          'poller_hash': 'QTlDOTMxcGVlcnBvbnBvbiAxNTY0NTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14643969',
                                                                                                                                          'fiber_length': 1042,
                                                                                                                                          'poller_hash': 'QzgzRTBBcGVlcnBvbnBvbiAxNjE2MDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '3447677',
                                                                                                                                          'fiber_length': 1256,
                                                                                                                                          'poller_hash': 'QzgzQkFCcGVlcnBvbnBvbiAxNjQyMDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '6985569',
                                                                                                                                          'fiber_length': 1018,
                                                                                                                                          'poller_hash': 'MTE5NTE1QnBlZXJwb25wb24gMjEyNjIw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68},
                                                                                                                                  {       'connected_time': '14354011',
                                                                                                                                          'fiber_length': 778,
                                                                                                                                          'poller_hash': 'QkYyNEQzcGVlcnBvbnBvbiAyMTMyMzg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.68}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/1',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/2',
                                                                                         'in_discards': '134347',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '15637021',
                                                                                         'in_octets': '17469965002984',
                                                                                         'in_ucast_pkts': '84747951813',
                                                                                         'links': [       {       'in_nucast_pkts': '5600',
                                                                                                                  'in_octets': '100779965436',
                                                                                                                  'in_ucast_pkts': '409627382',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '528664',
                                                                                                                  'out_octets': '1363542698021',
                                                                                                                  'out_ucast_pkts': '995046961',
                                                                                                                  'poller_hash': 'NDNDM0REcGVlcmludGZwb24gNw=='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'NDE1M0NwZWVyaW50ZnBvbiAyNzg='},
                                                                                                          {       'in_nucast_pkts': '16158245',
                                                                                                                  'in_octets': '216579041069',
                                                                                                                  'in_ucast_pkts': '1476756622',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '18043497760',
                                                                                                                  'out_octets': '30791779904903',
                                                                                                                  'out_ucast_pkts': '5032045205',
                                                                                                                  'poller_hash': 'MjVEOEFFcGVlcmludGZwb24gMjc5'},
                                                                                                          {       'in_nucast_pkts': '14988',
                                                                                                                  'in_octets': '99482997255',
                                                                                                                  'in_ucast_pkts': '657999990',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2820955',
                                                                                                                  'out_octets': '2566591969249',
                                                                                                                  'out_ucast_pkts': '1781303951',
                                                                                                                  'poller_hash': 'QzgxRjQycGVlcmludGZwb24gMjgw'},
                                                                                                          {       'in_nucast_pkts': '10943100',
                                                                                                                  'in_octets': '62535516485',
                                                                                                                  'in_ucast_pkts': '338462150',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1623663445',
                                                                                                                  'out_octets': '2961785374568',
                                                                                                                  'out_ucast_pkts': '56643038545',
                                                                                                                  'poller_hash': 'NDE4QjhwZWVyaW50ZnBvbiAyODE='},
                                                                                                          {       'in_nucast_pkts': '390587',
                                                                                                                  'in_octets': '108445264038',
                                                                                                                  'in_ucast_pkts': '462979176',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7558569',
                                                                                                                  'out_octets': '3025177305953',
                                                                                                                  'out_ucast_pkts': '2298012250',
                                                                                                                  'poller_hash': 'OTU2RjIycGVlcmludGZwb24gMjgy'},
                                                                                                          {       'in_nucast_pkts': '17068385',
                                                                                                                  'in_octets': '147268350114',
                                                                                                                  'in_ucast_pkts': '999217305',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '17208759',
                                                                                                                  'out_octets': '3303582682625',
                                                                                                                  'out_ucast_pkts': '2324814347',
                                                                                                                  'poller_hash': 'MkNBMzBEcGVlcmludGZwb24gMjg0'},
                                                                                                          {       'in_nucast_pkts': '4113',
                                                                                                                  'in_octets': '90206434138',
                                                                                                                  'in_ucast_pkts': '594927250',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '513803',
                                                                                                                  'out_octets': '2747499988232',
                                                                                                                  'out_ucast_pkts': '1997018462',
                                                                                                                  'poller_hash': 'MzI5NTRGcGVlcmludGZwb24gMjg1'},
                                                                                                          {       'in_nucast_pkts': '23',
                                                                                                                  'in_octets': '4906176985',
                                                                                                                  'in_ucast_pkts': '25353448',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '231899',
                                                                                                                  'out_octets': '34948451805',
                                                                                                                  'out_ucast_pkts': '37989210',
                                                                                                                  'poller_hash': 'MTk5QTJEcGVlcmludGZwb24gMjg3'},
                                                                                                          {       'in_nucast_pkts': '45917',
                                                                                                                  'in_octets': '144604039492',
                                                                                                                  'in_ucast_pkts': '534024310',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '535367',
                                                                                                                  'out_octets': '3366004133164',
                                                                                                                  'out_ucast_pkts': '2457686367',
                                                                                                                  'poller_hash': 'MkZFOUYzcGVlcmludGZwb24gMjg4'},
                                                                                                          {       'in_nucast_pkts': '14646401',
                                                                                                                  'in_octets': '49475147560',
                                                                                                                  'in_ucast_pkts': '257115628',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '16782833840',
                                                                                                                  'out_octets': '23709714748440',
                                                                                                                  'out_ucast_pkts': '851426590',
                                                                                                                  'poller_hash': 'MTY0MjgxcGVlcmludGZwb24gMjg5'},
                                                                                                          {       'in_nucast_pkts': '4988405',
                                                                                                                  'in_octets': '38304533013',
                                                                                                                  'in_ucast_pkts': '144961576',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2160915985',
                                                                                                                  'out_octets': '3200910027336',
                                                                                                                  'out_ucast_pkts': '13317949460',
                                                                                                                  'poller_hash': 'NDE1MzVwZWVyaW50ZnBvbiAyOTE='},
                                                                                                          {       'in_nucast_pkts': '135',
                                                                                                                  'in_octets': '150527807624',
                                                                                                                  'in_ucast_pkts': '412204104',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '353356',
                                                                                                                  'out_octets': '1118581373790',
                                                                                                                  'out_ucast_pkts': '894700128',
                                                                                                                  'poller_hash': 'MzhGMUVBcGVlcmludGZwb24gMjkz'},
                                                                                                          {       'in_nucast_pkts': '32270',
                                                                                                                  'in_octets': '289232187685',
                                                                                                                  'in_ucast_pkts': '1655640365',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534600',
                                                                                                                  'out_octets': '4861416048654',
                                                                                                                  'out_ucast_pkts': '3758156430',
                                                                                                                  'poller_hash': 'MkVEMDNGcGVlcmludGZwb24gMjk0'},
                                                                                                          {       'in_nucast_pkts': '4369889',
                                                                                                                  'in_octets': '9998327361',
                                                                                                                  'in_ucast_pkts': '111589545',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9298667313',
                                                                                                                  'out_octets': '13282073533991',
                                                                                                                  'out_ucast_pkts': '34971783196',
                                                                                                                  'poller_hash': 'M0QwRkFwZWVyaW50ZnBvbiAyOTU='},
                                                                                                          {       'in_nucast_pkts': '9289',
                                                                                                                  'in_octets': '478138474991',
                                                                                                                  'in_ucast_pkts': '2639134715',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534730',
                                                                                                                  'out_octets': '12697072099843',
                                                                                                                  'out_ucast_pkts': '8740584494',
                                                                                                                  'poller_hash': 'MTJGRkREcGVlcmludGZwb24gMjk2'},
                                                                                                          {       'in_nucast_pkts': '32655',
                                                                                                                  'in_octets': '198602828647',
                                                                                                                  'in_ucast_pkts': '739471427',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534680',
                                                                                                                  'out_octets': '3383989212107',
                                                                                                                  'out_ucast_pkts': '2499423249',
                                                                                                                  'poller_hash': 'NzU3QkJwZWVyaW50ZnBvbiAyOTc='},
                                                                                                          {       'in_nucast_pkts': '48612',
                                                                                                                  'in_octets': '28625284702',
                                                                                                                  'in_ucast_pkts': '118525733',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7562127',
                                                                                                                  'out_octets': '386770629307',
                                                                                                                  'out_ucast_pkts': '317288915',
                                                                                                                  'poller_hash': 'QzgzQkYzcGVlcmludGZwb24gMjk4'},
                                                                                                          {       'in_nucast_pkts': '7599346',
                                                                                                                  'in_octets': '75573010281',
                                                                                                                  'in_ucast_pkts': '243306705',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4728942282',
                                                                                                                  'out_octets': '6887953627818',
                                                                                                                  'out_ucast_pkts': '827957287',
                                                                                                                  'poller_hash': 'NDMzRTVGcGVlcmludGZwb24gMjk5'},
                                                                                                          {       'in_nucast_pkts': '12737374',
                                                                                                                  'in_octets': '55010476627',
                                                                                                                  'in_ucast_pkts': '139429730',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '22667913225',
                                                                                                                  'out_octets': '31243794242642',
                                                                                                                  'out_ucast_pkts': '766430861',
                                                                                                                  'poller_hash': 'MzI5NjM2cGVlcmludGZwb24gMzAw'},
                                                                                                          {       'in_nucast_pkts': '17802',
                                                                                                                  'in_octets': '226557869145',
                                                                                                                  'in_ucast_pkts': '771084017',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '528683',
                                                                                                                  'out_octets': '2091712220601',
                                                                                                                  'out_ucast_pkts': '1531349143',
                                                                                                                  'poller_hash': 'MUM0REE5cGVlcmludGZwb24gMzAy'},
                                                                                                          {       'in_nucast_pkts': '2407630',
                                                                                                                  'in_octets': '59118938737',
                                                                                                                  'in_ucast_pkts': '386224396',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534740',
                                                                                                                  'out_octets': '1191229965216',
                                                                                                                  'out_ucast_pkts': '849513004',
                                                                                                                  'poller_hash': 'NzIxRDFDcGVlcmludGZwb24gMzAz'},
                                                                                                          {       'in_nucast_pkts': '44172',
                                                                                                                  'in_octets': '125521774169',
                                                                                                                  'in_ucast_pkts': '569406704',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '529059',
                                                                                                                  'out_octets': '2869468060428',
                                                                                                                  'out_ucast_pkts': '2127049736',
                                                                                                                  'poller_hash': 'NTU2M0YwcGVlcmludGZwb24gMzA0'},
                                                                                                          {       'in_nucast_pkts': '4544718',
                                                                                                                  'in_octets': '46453695798',
                                                                                                                  'in_ucast_pkts': '337194808',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '12723645984',
                                                                                                                  'out_octets': '17894715621746',
                                                                                                                  'out_ucast_pkts': '766940790',
                                                                                                                  'poller_hash': 'QzgxRERCcGVlcmludGZwb24gMTM4MDA3'},
                                                                                                          {       'in_nucast_pkts': '2390401',
                                                                                                                  'in_octets': '62490446690',
                                                                                                                  'in_ucast_pkts': '294538287',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '122076',
                                                                                                                  'out_octets': '1386257369907',
                                                                                                                  'out_ucast_pkts': '1059729808',
                                                                                                                  'poller_hash': 'MzhGMThCcGVlcmludGZwb24gMTY2NzY4'},
                                                                                                          {       'in_nucast_pkts': '145955813',
                                                                                                                  'in_octets': '25763695048',
                                                                                                                  'in_ucast_pkts': '56993090',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4241789141',
                                                                                                                  'out_octets': '5782952547352',
                                                                                                                  'out_ucast_pkts': '154509839',
                                                                                                                  'poller_hash': 'QzgxRTNGcGVlcmludGZwb24gMjA3MzYy'},
                                                                                                          {       'in_nucast_pkts': '13705454',
                                                                                                                  'in_octets': '202354601642',
                                                                                                                  'in_ucast_pkts': '398659529',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3939515533',
                                                                                                                  'out_octets': '5890675039825',
                                                                                                                  'out_ucast_pkts': '909076459',
                                                                                                                  'poller_hash': 'QzgxREI3cGVlcmludGZwb24gMjA3ODMw'},
                                                                                                          {       'in_nucast_pkts': '1805692',
                                                                                                                  'in_octets': '551606756',
                                                                                                                  'in_ucast_pkts': '2058470',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5675211061',
                                                                                                                  'out_octets': '7544118764280',
                                                                                                                  'out_ucast_pkts': '1524270',
                                                                                                                  'poller_hash': 'MTI3NTE4Q3BlZXJpbnRmcG9uIDIyMTExMA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '503993017302',
                                                                                         'out_octets': '1023354714894964',
                                                                                         'out_ucast_pkts': '248530586603',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzI=',
                                                                                         'pons': [       {       'id': '2/2',
                                                                                                                 'links': [       {       'connected_time': '14360200',
                                                                                                                                          'fiber_length': 1303,
                                                                                                                                          'poller_hash': 'NDNDM0REcGVlcnBvbnBvbiA3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628979',
                                                                                                                                          'fiber_length': 432,
                                                                                                                                          'poller_hash': 'NDE1M0NwZWVycG9ucG9uIDI3OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628596',
                                                                                                                                          'fiber_length': 519,
                                                                                                                                          'poller_hash': 'MjVEOEFFcGVlcnBvbnBvbiAyNzk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '5170784',
                                                                                                                                          'fiber_length': 599,
                                                                                                                                          'poller_hash': 'QzgxRjQycGVlcnBvbnBvbiAyODA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628960',
                                                                                                                                          'fiber_length': 432,
                                                                                                                                          'poller_hash': 'NDE4QjhwZWVycG9ucG9uIDI4MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14644040',
                                                                                                                                          'fiber_length': 644,
                                                                                                                                          'poller_hash': 'OTU2RjIycGVlcnBvbnBvbiAyODI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628682',
                                                                                                                                          'fiber_length': 445,
                                                                                                                                          'poller_hash': 'MkNBMzBEcGVlcnBvbnBvbiAyODQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628908',
                                                                                                                                          'fiber_length': 469,
                                                                                                                                          'poller_hash': 'MzI5NTRGcGVlcnBvbnBvbiAyODU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '4917475',
                                                                                                                                          'fiber_length': 542,
                                                                                                                                          'poller_hash': 'MTk5QTJEcGVlcnBvbnBvbiAyODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628932',
                                                                                                                                          'fiber_length': 1385,
                                                                                                                                          'poller_hash': 'MkZFOUYzcGVlcnBvbnBvbiAyODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14629006',
                                                                                                                                          'fiber_length': 1386,
                                                                                                                                          'poller_hash': 'MTY0MjgxcGVlcnBvbnBvbiAyODk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14629182',
                                                                                                                                          'fiber_length': 1309,
                                                                                                                                          'poller_hash': 'NDE1MzVwZWVycG9ucG9uIDI5MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '8628228',
                                                                                                                                          'fiber_length': 1246,
                                                                                                                                          'poller_hash': 'MzhGMUVBcGVlcnBvbnBvbiAyOTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14616669',
                                                                                                                                          'fiber_length': 1254,
                                                                                                                                          'poller_hash': 'MkVEMDNGcGVlcnBvbnBvbiAyOTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628767',
                                                                                                                                          'fiber_length': 1144,
                                                                                                                                          'poller_hash': 'M0QwRkFwZWVycG9ucG9uIDI5NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628811',
                                                                                                                                          'fiber_length': 1262,
                                                                                                                                          'poller_hash': 'MTJGRkREcGVlcnBvbnBvbiAyOTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14629363',
                                                                                                                                          'fiber_length': 1209,
                                                                                                                                          'poller_hash': 'NzU3QkJwZWVycG9ucG9uIDI5Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14644067',
                                                                                                                                          'fiber_length': 1469,
                                                                                                                                          'poller_hash': 'QzgzQkYzcGVlcnBvbnBvbiAyOTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14629071',
                                                                                                                                          'fiber_length': 1381,
                                                                                                                                          'poller_hash': 'NDMzRTVGcGVlcnBvbnBvbiAyOTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628930',
                                                                                                                                          'fiber_length': 1436,
                                                                                                                                          'poller_hash': 'MzI5NjM2cGVlcnBvbnBvbiAzMDA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14358527',
                                                                                                                                          'fiber_length': 1129,
                                                                                                                                          'poller_hash': 'MUM0REE5cGVlcnBvbnBvbiAzMDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628776',
                                                                                                                                          'fiber_length': 1075,
                                                                                                                                          'poller_hash': 'NzIxRDFDcGVlcnBvbnBvbiAzMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14374662',
                                                                                                                                          'fiber_length': 1080,
                                                                                                                                          'poller_hash': 'NTU2M0YwcGVlcnBvbnBvbiAzMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '5687253',
                                                                                                                                          'fiber_length': 577,
                                                                                                                                          'poller_hash': 'QzgxRERCcGVlcnBvbnBvbiAxMzgwMDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14628875',
                                                                                                                                          'fiber_length': 1421,
                                                                                                                                          'poller_hash': 'MzhGMThCcGVlcnBvbnBvbiAxNjY3Njg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '6052967',
                                                                                                                                          'fiber_length': 688,
                                                                                                                                          'poller_hash': 'QzgxRTNGcGVlcnBvbnBvbiAyMDczNjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '14644125',
                                                                                                                                          'fiber_length': 1454,
                                                                                                                                          'poller_hash': 'QzgxREI3cGVlcnBvbnBvbiAyMDc4MzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671},
                                                                                                                                  {       'connected_time': '6820740',
                                                                                                                                          'fiber_length': 1569,
                                                                                                                                          'poller_hash': 'MTI3NTE4Q3BlZXJwb25wb24gMjIxMTEw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.671}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/2',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/3',
                                                                                         'in_discards': '126858',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23056818',
                                                                                         'in_octets': '22880995955076',
                                                                                         'in_ucast_pkts': '89812782049',
                                                                                         'links': [       {       'oper_up': False,
                                                                                                                  'poller_hash': 'NTEyNTg5cGVlcmludGZwb24gNDE='},
                                                                                                          {       'in_nucast_pkts': '744719',
                                                                                                                  'in_octets': '256043863032',
                                                                                                                  'in_ucast_pkts': '745693618',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '401503',
                                                                                                                  'out_octets': '3418663406013',
                                                                                                                  'out_ucast_pkts': '2598913349',
                                                                                                                  'poller_hash': 'MkFBODc4cGVlcmludGZwb24gMjM0'},
                                                                                                          {       'in_nucast_pkts': '3440438',
                                                                                                                  'in_octets': '43455498895',
                                                                                                                  'in_ucast_pkts': '144271027',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6533237',
                                                                                                                  'out_octets': '276152782319',
                                                                                                                  'out_ucast_pkts': '269793928',
                                                                                                                  'poller_hash': 'MTM1NDhwZWVyaW50ZnBvbiAyODY='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'QURFMzJwZWVyaW50ZnBvbiAzMDU='},
                                                                                                          {       'in_nucast_pkts': '15349832',
                                                                                                                  'in_octets': '126597415468',
                                                                                                                  'in_ucast_pkts': '500192581',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '20677201674',
                                                                                                                  'out_octets': '29326993207418',
                                                                                                                  'out_ucast_pkts': '1329079817',
                                                                                                                  'poller_hash': 'MzhGMTExcGVlcmludGZwb24gMzA2'},
                                                                                                          {       'in_nucast_pkts': '12274961',
                                                                                                                  'in_octets': '19547687316',
                                                                                                                  'in_ucast_pkts': '73687536',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14554655287',
                                                                                                                  'out_octets': '19707369620277',
                                                                                                                  'out_ucast_pkts': '136642629',
                                                                                                                  'poller_hash': 'NDAwOERDcGVlcmludGZwb24gMzA3'},
                                                                                                          {       'in_nucast_pkts': '4141236',
                                                                                                                  'in_octets': '236693274607',
                                                                                                                  'in_ucast_pkts': '1579070110',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11027837248',
                                                                                                                  'out_octets': '20564413696636',
                                                                                                                  'out_ucast_pkts': '4202851677',
                                                                                                                  'poller_hash': 'MTMwMDhEcGVlcmludGZwb24gMzA4'},
                                                                                                          {       'in_nucast_pkts': '3897677',
                                                                                                                  'in_octets': '353068762',
                                                                                                                  'in_ucast_pkts': '902615',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5214053014',
                                                                                                                  'out_octets': '6798603149677',
                                                                                                                  'out_ucast_pkts': '335070',
                                                                                                                  'poller_hash': 'MTk5OUY2cGVlcmludGZwb24gMzA5'},
                                                                                                          {       'in_nucast_pkts': '5831855',
                                                                                                                  'in_octets': '187831043069',
                                                                                                                  'in_ucast_pkts': '1452761639',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1067105580',
                                                                                                                  'out_octets': '5242478776163',
                                                                                                                  'out_ucast_pkts': '3035564679',
                                                                                                                  'poller_hash': 'MkM5QTBFcGVlcmludGZwb24gMzEw'},
                                                                                                          {       'in_nucast_pkts': '15279',
                                                                                                                  'in_octets': '797303688147',
                                                                                                                  'in_ucast_pkts': '1706277975',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '91735',
                                                                                                                  'out_octets': '4650468669246',
                                                                                                                  'out_ucast_pkts': '3633482109',
                                                                                                                  'poller_hash': 'MjQ4QUQycGVlcmludGZwb24gMzEy'},
                                                                                                          {       'in_nucast_pkts': '7293129',
                                                                                                                  'in_octets': '14118839071',
                                                                                                                  'in_ucast_pkts': '88730072',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '21123936646',
                                                                                                                  'out_octets': '28584068725115',
                                                                                                                  'out_ucast_pkts': '315670831',
                                                                                                                  'poller_hash': 'QzgzMDkzcGVlcmludGZwb24gMzEz'},
                                                                                                          {       'in_nucast_pkts': '2343',
                                                                                                                  'in_octets': '53155777980',
                                                                                                                  'in_ucast_pkts': '254227718',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7178122',
                                                                                                                  'out_octets': '1380031670603',
                                                                                                                  'out_ucast_pkts': '995027490',
                                                                                                                  'poller_hash': 'ODcyNEZDcGVlcmludGZwb24gMzE0'},
                                                                                                          {       'in_nucast_pkts': '7824151',
                                                                                                                  'in_octets': '215165612406',
                                                                                                                  'in_ucast_pkts': '1079724977',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3946511471',
                                                                                                                  'out_octets': '8438024780102',
                                                                                                                  'out_ucast_pkts': '2728512208',
                                                                                                                  'poller_hash': 'ODZCOEJwZWVyaW50ZnBvbiAzMTU='},
                                                                                                          {       'in_nucast_pkts': '9334',
                                                                                                                  'in_octets': '64121564844',
                                                                                                                  'in_ucast_pkts': '292680986',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534742',
                                                                                                                  'out_octets': '1482882426664',
                                                                                                                  'out_ucast_pkts': '1088604825',
                                                                                                                  'poller_hash': 'NzIzNjRFcGVlcmludGZwb24gMzE2'},
                                                                                                          {       'in_nucast_pkts': '46577',
                                                                                                                  'in_octets': '111079202706',
                                                                                                                  'in_ucast_pkts': '687301314',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '535293',
                                                                                                                  'out_octets': '4698281586543',
                                                                                                                  'out_ucast_pkts': '3416160067',
                                                                                                                  'poller_hash': 'MTc2MjEwcGVlcmludGZwb24gMzE3'},
                                                                                                          {       'in_nucast_pkts': '4309064',
                                                                                                                  'in_octets': '790757289998',
                                                                                                                  'in_ucast_pkts': '1434457422',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8004535511',
                                                                                                                  'out_octets': '14818425338071',
                                                                                                                  'out_ucast_pkts': '3088665363',
                                                                                                                  'poller_hash': 'NzZFOUJBcGVlcmludGZwb24gMzE4'},
                                                                                                          {       'in_nucast_pkts': '4093187',
                                                                                                                  'in_octets': '9370888237',
                                                                                                                  'in_ucast_pkts': '39373700',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11190007205',
                                                                                                                  'out_octets': '15016014048136',
                                                                                                                  'out_ucast_pkts': '82612379',
                                                                                                                  'poller_hash': 'NEQ0MjREcGVlcmludGZwb24gMzE5'},
                                                                                                          {       'in_nucast_pkts': '6589',
                                                                                                                  'in_octets': '228294105750',
                                                                                                                  'in_ucast_pkts': '956061726',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534612',
                                                                                                                  'out_octets': '4358795370504',
                                                                                                                  'out_ucast_pkts': '3321672536',
                                                                                                                  'poller_hash': 'MjQ4QUM2cGVlcmludGZwb24gMzIw'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'NTYyQkRwZWVyaW50ZnBvbiAzNDA='},
                                                                                                          {       'in_nucast_pkts': '8995',
                                                                                                                  'in_octets': '18539727327',
                                                                                                                  'in_ucast_pkts': '118237370',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1334372',
                                                                                                                  'out_octets': '500953018263',
                                                                                                                  'out_ucast_pkts': '358663408',
                                                                                                                  'poller_hash': 'NUE2QzkycGVlcmludGZwb24gMTM5MTkw'},
                                                                                                          {       'in_nucast_pkts': '3193978',
                                                                                                                  'in_octets': '190833918660',
                                                                                                                  'in_ucast_pkts': '540938813',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7870540251',
                                                                                                                  'out_octets': '12144395838268',
                                                                                                                  'out_ucast_pkts': '1235660750',
                                                                                                                  'poller_hash': 'Q0JEMjlBcGVlcmludGZwb24gMTY1MDUw'},
                                                                                                          {       'in_nucast_pkts': '26417',
                                                                                                                  'in_octets': '20803921007',
                                                                                                                  'in_ucast_pkts': '131266048',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1689922',
                                                                                                                  'out_octets': '385785620215',
                                                                                                                  'out_ucast_pkts': '277724980',
                                                                                                                  'poller_hash': 'QzgzQkEzcGVlcmludGZwb24gMTY4NTY0'},
                                                                                                          {       'in_nucast_pkts': '45290',
                                                                                                                  'in_octets': '26625892513',
                                                                                                                  'in_ucast_pkts': '120358881',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534900',
                                                                                                                  'out_octets': '1035955568193',
                                                                                                                  'out_ucast_pkts': '814945037',
                                                                                                                  'poller_hash': 'NzIzQTEwcGVlcmludGZwb24gMTcxNzE5'},
                                                                                                          {       'in_nucast_pkts': '1246136',
                                                                                                                  'in_octets': '15703953936',
                                                                                                                  'in_ucast_pkts': '95080389',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '553027419',
                                                                                                                  'out_octets': '1180309506438',
                                                                                                                  'out_ucast_pkts': '436051655',
                                                                                                                  'poller_hash': 'QzgzQkRBcGVlcmludGZwb24gMTcxOTg3'},
                                                                                                          {       'in_nucast_pkts': '4564234',
                                                                                                                  'in_octets': '305886574121',
                                                                                                                  'in_ucast_pkts': '1001383620',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '14007155181',
                                                                                                                  'out_octets': '22320717576823',
                                                                                                                  'out_ucast_pkts': '2666746977',
                                                                                                                  'poller_hash': 'QzgzQjlDcGVlcmludGZwb24gMTkzNjIy'},
                                                                                                          {       'in_nucast_pkts': '43132',
                                                                                                                  'in_octets': '151885635428',
                                                                                                                  'in_ucast_pkts': '1138991917',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6553234',
                                                                                                                  'out_octets': '4467768463406',
                                                                                                                  'out_ucast_pkts': '3234199875',
                                                                                                                  'poller_hash': 'MTFCMjVBOXBlZXJpbnRmcG9uIDIxNTc4Mw=='},
                                                                                                          {       'in_nucast_pkts': '5184',
                                                                                                                  'in_octets': '19166389532',
                                                                                                                  'in_ucast_pkts': '90735506',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1259042',
                                                                                                                  'out_octets': '502315443708',
                                                                                                                  'out_ucast_pkts': '363757327',
                                                                                                                  'poller_hash': 'RUJDMkVFcGVlcmludGZwb24gMjMxMzg4'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '410870093819',
                                                                                         'out_octets': '898068384986009',
                                                                                         'out_ucast_pkts': '250514073181',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzM=',
                                                                                         'pons': [       {       'id': '2/3',
                                                                                                                 'links': [       {       'poller_hash': 'NTEyNTg5cGVlcnBvbnBvbiA0MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '8985786',
                                                                                                                                          'fiber_length': 1156,
                                                                                                                                          'poller_hash': 'MkFBODc4cGVlcnBvbnBvbiAyMzQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14628863',
                                                                                                                                          'fiber_length': 384,
                                                                                                                                          'poller_hash': 'MTM1NDhwZWVycG9ucG9uIDI4Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'poller_hash': 'QURFMzJwZWVycG9ucG9uIDMwNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14628840',
                                                                                                                                          'fiber_length': 924,
                                                                                                                                          'poller_hash': 'MzhGMTExcGVlcnBvbnBvbiAzMDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14628957',
                                                                                                                                          'fiber_length': 1237,
                                                                                                                                          'poller_hash': 'NDAwOERDcGVlcnBvbnBvbiAzMDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14629133',
                                                                                                                                          'fiber_length': 1016,
                                                                                                                                          'poller_hash': 'MTMwMDhEcGVlcnBvbnBvbiAzMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14629012',
                                                                                                                                          'fiber_length': 994,
                                                                                                                                          'poller_hash': 'MTk5OUY2cGVlcnBvbnBvbiAzMDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14628925',
                                                                                                                                          'fiber_length': 985,
                                                                                                                                          'poller_hash': 'MkM5QTBFcGVlcnBvbnBvbiAzMTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '10976552',
                                                                                                                                          'fiber_length': 859,
                                                                                                                                          'poller_hash': 'MjQ4QUQycGVlcnBvbnBvbiAzMTI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14643996',
                                                                                                                                          'fiber_length': 952,
                                                                                                                                          'poller_hash': 'QzgzMDkzcGVlcnBvbnBvbiAzMTM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '13388025',
                                                                                                                                          'fiber_length': 1001,
                                                                                                                                          'poller_hash': 'ODcyNEZDcGVlcnBvbnBvbiAzMTQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14628862',
                                                                                                                                          'fiber_length': 824,
                                                                                                                                          'poller_hash': 'ODZCOEJwZWVycG9ucG9uIDMxNQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14628975',
                                                                                                                                          'fiber_length': 899,
                                                                                                                                          'poller_hash': 'NzIzNjRFcGVlcnBvbnBvbiAzMTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14629084',
                                                                                                                                          'fiber_length': 717,
                                                                                                                                          'poller_hash': 'MTc2MjEwcGVlcnBvbnBvbiAzMTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14628883',
                                                                                                                                          'fiber_length': 780,
                                                                                                                                          'poller_hash': 'NzZFOUJBcGVlcnBvbnBvbiAzMTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14629006',
                                                                                                                                          'fiber_length': 666,
                                                                                                                                          'poller_hash': 'NEQ0MjREcGVlcnBvbnBvbiAzMTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14629237',
                                                                                                                                          'fiber_length': 1276,
                                                                                                                                          'poller_hash': 'MjQ4QUM2cGVlcnBvbnBvbiAzMjA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'poller_hash': 'NTYyQkRwZWVycG9ucG9uIDM0MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '2410543',
                                                                                                                                          'fiber_length': 1054,
                                                                                                                                          'poller_hash': 'NUE2QzkycGVlcnBvbnBvbiAxMzkxOTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '8191753',
                                                                                                                                          'fiber_length': 1327,
                                                                                                                                          'poller_hash': 'Q0JEMjlBcGVlcnBvbnBvbiAxNjUwNTA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '3272796',
                                                                                                                                          'fiber_length': 1019,
                                                                                                                                          'poller_hash': 'QzgzQkEzcGVlcnBvbnBvbiAxNjg1NjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '14629205',
                                                                                                                                          'fiber_length': 1005,
                                                                                                                                          'poller_hash': 'NzIzQTEwcGVlcnBvbnBvbiAxNzE3MTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '8985925',
                                                                                                                                          'fiber_length': 1384,
                                                                                                                                          'poller_hash': 'QzgzQkRBcGVlcnBvbnBvbiAxNzE5ODc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '8986090',
                                                                                                                                          'fiber_length': 1245,
                                                                                                                                          'poller_hash': 'QzgzQjlDcGVlcnBvbnBvbiAxOTM2MjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '12176659',
                                                                                                                                          'fiber_length': 889,
                                                                                                                                          'poller_hash': 'MTFCMjVBOXBlZXJwb25wb24gMjE1Nzgz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966},
                                                                                                                                  {       'connected_time': '1013895',
                                                                                                                                          'fiber_length': 1055,
                                                                                                                                          'poller_hash': 'RUJDMkVFcGVlcnBvbnBvbiAyMzEzODg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.966}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/3',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/4',
                                                                                         'in_discards': '146963',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '7091611',
                                                                                         'in_octets': '23091134842918',
                                                                                         'in_ucast_pkts': '76586042043',
                                                                                         'links': [       {       'in_nucast_pkts': '12262',
                                                                                                                  'in_octets': '15386219973',
                                                                                                                  'in_ucast_pkts': '114031952',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2402055',
                                                                                                                  'out_octets': '550198883075',
                                                                                                                  'out_ucast_pkts': '378979184',
                                                                                                                  'poller_hash': 'MzIyODY1cGVlcmludGZwb24gMjM='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'RjBGOHBlZXJpbnRmcG9uIDEyMw=='},
                                                                                                          {       'in_nucast_pkts': '2499115',
                                                                                                                  'in_octets': '28656634402',
                                                                                                                  'in_ucast_pkts': '159061576',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3568220042',
                                                                                                                  'out_octets': '5178950352185',
                                                                                                                  'out_ucast_pkts': '333589773',
                                                                                                                  'poller_hash': 'NDI4MTZFcGVlcmludGZwb24gMjMx'},
                                                                                                          {       'in_nucast_pkts': '4245216',
                                                                                                                  'in_octets': '13496897875',
                                                                                                                  'in_ucast_pkts': '53819928',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2173632846',
                                                                                                                  'out_octets': '2845987325781',
                                                                                                                  'out_ucast_pkts': '151121029',
                                                                                                                  'poller_hash': 'MUY3REExcGVlcmludGZwb24gMjMy'},
                                                                                                          {       'in_nucast_pkts': '1838',
                                                                                                                  'in_octets': '3507239498',
                                                                                                                  'in_ucast_pkts': '18311779',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '90234',
                                                                                                                  'out_octets': '129153030326',
                                                                                                                  'out_ucast_pkts': '90818935',
                                                                                                                  'poller_hash': 'MkFBOTQ2cGVlcmludGZwb24gMjMz'},
                                                                                                          {       'in_nucast_pkts': '1575',
                                                                                                                  'in_octets': '579506973743',
                                                                                                                  'in_ucast_pkts': '1112890834',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '74935',
                                                                                                                  'out_octets': '3215248098424',
                                                                                                                  'out_ucast_pkts': '2570515384',
                                                                                                                  'poller_hash': 'MzNBRDA5cGVlcmludGZwb24gMjM1'},
                                                                                                          {       'in_nucast_pkts': '4451748',
                                                                                                                  'in_octets': '125064707040',
                                                                                                                  'in_ucast_pkts': '980721365',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4948879125',
                                                                                                                  'out_octets': '11172303287740',
                                                                                                                  'out_ucast_pkts': '3323556099',
                                                                                                                  'poller_hash': 'M0FFQzFGcGVlcmludGZwb24gMjM2'},
                                                                                                          {       'in_nucast_pkts': '49117',
                                                                                                                  'in_octets': '7039850540',
                                                                                                                  'in_ucast_pkts': '64337732',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '32732',
                                                                                                                  'out_octets': '559957002435',
                                                                                                                  'out_ucast_pkts': '379487251',
                                                                                                                  'poller_hash': 'M0FFQkM4cGVlcmludGZwb24gMjM3'},
                                                                                                          {       'in_nucast_pkts': '81286',
                                                                                                                  'in_octets': '1160678980614',
                                                                                                                  'in_ucast_pkts': '3082624998',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534383',
                                                                                                                  'out_octets': '5467297910083',
                                                                                                                  'out_ucast_pkts': '4166717904',
                                                                                                                  'poller_hash': 'MjVEOTJCcGVlcmludGZwb24gMzI0'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'MzI5NjM3cGVlcmludGZwb24gMzI1'},
                                                                                                          {       'in_nucast_pkts': '2062649',
                                                                                                                  'in_octets': '28265249013',
                                                                                                                  'in_ucast_pkts': '94026032',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2717891795',
                                                                                                                  'out_octets': '3848980613084',
                                                                                                                  'out_ucast_pkts': '307790147',
                                                                                                                  'poller_hash': 'NDJDOEZBcGVlcmludGZwb24gMzI2'},
                                                                                                          {       'in_nucast_pkts': '2306544',
                                                                                                                  'in_octets': '59639741030',
                                                                                                                  'in_ucast_pkts': '222486646',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1179925218',
                                                                                                                  'out_octets': '2771347623050',
                                                                                                                  'out_ucast_pkts': '998820391',
                                                                                                                  'poller_hash': 'MjQ4QUVBcGVlcmludGZwb24gMzI3'},
                                                                                                          {       'in_nucast_pkts': '29019',
                                                                                                                  'in_octets': '172967507001',
                                                                                                                  'in_ucast_pkts': '959905352',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534667',
                                                                                                                  'out_octets': '3689554932899',
                                                                                                                  'out_ucast_pkts': '2659517581',
                                                                                                                  'poller_hash': 'NDZDRTBBcGVlcmludGZwb24gMzI4'},
                                                                                                          {       'in_nucast_pkts': '9531318',
                                                                                                                  'in_octets': '16848960184',
                                                                                                                  'in_ucast_pkts': '61954701',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '21522045422',
                                                                                                                  'out_octets': '28886617976862',
                                                                                                                  'out_ucast_pkts': '173633258',
                                                                                                                  'poller_hash': 'MjQ4QUY0cGVlcmludGZwb24gMzI5'},
                                                                                                          {       'in_nucast_pkts': '5622',
                                                                                                                  'in_octets': '200950597027',
                                                                                                                  'in_ucast_pkts': '946193579',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '122048',
                                                                                                                  'out_octets': '4162712801973',
                                                                                                                  'out_ucast_pkts': '2964151111',
                                                                                                                  'poller_hash': 'NzZBQ0U4cGVlcmludGZwb24gMzMw'},
                                                                                                          {       'in_nucast_pkts': '9353',
                                                                                                                  'in_octets': '121392795564',
                                                                                                                  'in_ucast_pkts': '684301021',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '335948',
                                                                                                                  'out_octets': '2832343447124',
                                                                                                                  'out_ucast_pkts': '2072184061',
                                                                                                                  'poller_hash': 'NzU3QUNwZWVyaW50ZnBvbiAzMzE='},
                                                                                                          {       'in_nucast_pkts': '46846',
                                                                                                                  'in_octets': '105955619532',
                                                                                                                  'in_ucast_pkts': '418148290',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '535389',
                                                                                                                  'out_octets': '1764283918961',
                                                                                                                  'out_ucast_pkts': '1415589740',
                                                                                                                  'poller_hash': 'NzFBNERCcGVlcmludGZwb24gMzMy'},
                                                                                                          {       'in_nucast_pkts': '1328817',
                                                                                                                  'in_octets': '325155493',
                                                                                                                  'in_ucast_pkts': '537360',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1122041030',
                                                                                                                  'out_octets': '1500366218776',
                                                                                                                  'out_ucast_pkts': '382786',
                                                                                                                  'poller_hash': 'M0NGQUFwZWVyaW50ZnBvbiAzMzM='},
                                                                                                          {       'in_nucast_pkts': '4061132',
                                                                                                                  'in_octets': '85996661442',
                                                                                                                  'in_ucast_pkts': '436248070',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '533226',
                                                                                                                  'out_octets': '2201565350485',
                                                                                                                  'out_ucast_pkts': '1569654012',
                                                                                                                  'poller_hash': 'RjIzQ3BlZXJpbnRmcG9uIDMzNA=='},
                                                                                                          {       'in_nucast_pkts': '25467',
                                                                                                                  'in_octets': '195603637250',
                                                                                                                  'in_ucast_pkts': '1054847393',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534756',
                                                                                                                  'out_octets': '4582535879186',
                                                                                                                  'out_ucast_pkts': '3490597158',
                                                                                                                  'poller_hash': 'MTY0Mjc3cGVlcmludGZwb24gMzM1'},
                                                                                                          {       'in_nucast_pkts': '14160198',
                                                                                                                  'in_octets': '70043398595',
                                                                                                                  'in_ucast_pkts': '255380896',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9023206250',
                                                                                                                  'out_octets': '12926392942421',
                                                                                                                  'out_ucast_pkts': '740100335',
                                                                                                                  'poller_hash': 'NTU2M0QzcGVlcmludGZwb24gMzM2'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'M0NGQTZwZWVyaW50ZnBvbiAzMzg='},
                                                                                                          {       'in_nucast_pkts': '7911',
                                                                                                                  'in_octets': '118928639409',
                                                                                                                  'in_ucast_pkts': '260095743',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534755',
                                                                                                                  'out_octets': '330548261320',
                                                                                                                  'out_ucast_pkts': '370463515',
                                                                                                                  'poller_hash': 'MTU0NURwZWVyaW50ZnBvbiAzMzk='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODY3OEI2cGVlcmludGZwb24gMzQ3'},
                                                                                                          {       'in_nucast_pkts': '64113',
                                                                                                                  'in_octets': '101639126999',
                                                                                                                  'in_ucast_pkts': '794325455',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8212373',
                                                                                                                  'out_octets': '3160966218309',
                                                                                                                  'out_ucast_pkts': '2356373054',
                                                                                                                  'poller_hash': 'NUE2Qjk5cGVlcmludGZwb24gMTM5MTk4'},
                                                                                                          {       'in_nucast_pkts': '118088',
                                                                                                                  'in_octets': '317872646753',
                                                                                                                  'in_ucast_pkts': '421498860',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7562144',
                                                                                                                  'out_octets': '1245809811909',
                                                                                                                  'out_ucast_pkts': '967793090',
                                                                                                                  'poller_hash': 'ODY5M0M2cGVlcmludGZwb24gMTQyMzU2'},
                                                                                                          {       'in_nucast_pkts': '3712903',
                                                                                                                  'in_octets': '59300739443',
                                                                                                                  'in_ucast_pkts': '173327168',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '9904398408',
                                                                                                                  'out_octets': '13513123523971',
                                                                                                                  'out_ucast_pkts': '340431237',
                                                                                                                  'poller_hash': 'MzQ5RDZFcGVlcmludGZwb24gMTQ4MTI1'},
                                                                                                          {       'in_nucast_pkts': '14805760',
                                                                                                                  'in_octets': '73883109481',
                                                                                                                  'in_ucast_pkts': '377609470',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '20212544613',
                                                                                                                  'out_octets': '29572036193725',
                                                                                                                  'out_ucast_pkts': '1620330947',
                                                                                                                  'poller_hash': 'QzgzQkNDcGVlcmludGZwb24gMTY2NjU4'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MTI3NTBEM3BlZXJpbnRmcG9uIDIxNzcxNg=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '499386101052',
                                                                                         'out_octets': '930686035579107',
                                                                                         'out_ucast_pkts': '191174743887',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzQ=',
                                                                                         'pons': [       {       'id': '2/4',
                                                                                                                 'links': [       {       'connected_time': '4372949',
                                                                                                                                          'fiber_length': 1082,
                                                                                                                                          'poller_hash': 'MzIyODY1cGVlcnBvbnBvbiAyMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14628670',
                                                                                                                                          'fiber_length': 794,
                                                                                                                                          'poller_hash': 'RjBGOHBlZXJwb25wb24gMTIz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '2664779',
                                                                                                                                          'fiber_length': 930,
                                                                                                                                          'poller_hash': 'NDI4MTZFcGVlcnBvbnBvbiAyMzE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14628675',
                                                                                                                                          'fiber_length': 577,
                                                                                                                                          'poller_hash': 'MUY3REExcGVlcnBvbnBvbiAyMzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '1629133',
                                                                                                                                          'fiber_length': 938,
                                                                                                                                          'poller_hash': 'MkFBOTQ2cGVlcnBvbnBvbiAyMzM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '8969570',
                                                                                                                                          'fiber_length': 960,
                                                                                                                                          'poller_hash': 'MzNBRDA5cGVlcnBvbnBvbiAyMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14612872',
                                                                                                                                          'fiber_length': 598,
                                                                                                                                          'poller_hash': 'M0FFQzFGcGVlcnBvbnBvbiAyMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '4298896',
                                                                                                                                          'fiber_length': 574,
                                                                                                                                          'poller_hash': 'M0FFQkM4cGVlcnBvbnBvbiAyMzc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14629068',
                                                                                                                                          'fiber_length': 864,
                                                                                                                                          'poller_hash': 'MjVEOTJCcGVlcnBvbnBvbiAzMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'poller_hash': 'MzI5NjM3cGVlcnBvbnBvbiAzMjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '8985877',
                                                                                                                                          'fiber_length': 937,
                                                                                                                                          'poller_hash': 'NDJDOEZBcGVlcnBvbnBvbiAzMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '8985918',
                                                                                                                                          'fiber_length': 862,
                                                                                                                                          'poller_hash': 'MjQ4QUVBcGVlcnBvbnBvbiAzMjc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14629053',
                                                                                                                                          'fiber_length': 572,
                                                                                                                                          'poller_hash': 'NDZDRTBBcGVlcnBvbnBvbiAzMjg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14628722',
                                                                                                                                          'fiber_length': 486,
                                                                                                                                          'poller_hash': 'MjQ4QUY0cGVlcnBvbnBvbiAzMjk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14628968',
                                                                                                                                          'fiber_length': 462,
                                                                                                                                          'poller_hash': 'NzZBQ0U4cGVlcnBvbnBvbiAzMzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '8014664',
                                                                                                                                          'fiber_length': 553,
                                                                                                                                          'poller_hash': 'NzU3QUNwZWVycG9ucG9uIDMzMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14628923',
                                                                                                                                          'fiber_length': 640,
                                                                                                                                          'poller_hash': 'NzFBNERCcGVlcnBvbnBvbiAzMzI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14628889',
                                                                                                                                          'fiber_length': 497,
                                                                                                                                          'poller_hash': 'M0NGQUFwZWVycG9ucG9uIDMzMw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14628895',
                                                                                                                                          'fiber_length': 479,
                                                                                                                                          'poller_hash': 'RjIzQ3BlZXJwb25wb24gMzM0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14628899',
                                                                                                                                          'fiber_length': 395,
                                                                                                                                          'poller_hash': 'MTY0Mjc3cGVlcnBvbnBvbiAzMzU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14629155',
                                                                                                                                          'fiber_length': 368,
                                                                                                                                          'poller_hash': 'NTU2M0QzcGVlcnBvbnBvbiAzMzY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14628882',
                                                                                                                                          'fiber_length': 439,
                                                                                                                                          'poller_hash': 'M0NGQTZwZWVycG9ucG9uIDMzOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14628657',
                                                                                                                                          'fiber_length': 495,
                                                                                                                                          'poller_hash': 'MTU0NURwZWVycG9ucG9uIDMzOQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14644195',
                                                                                                                                          'fiber_length': 878,
                                                                                                                                          'poller_hash': 'ODY3OEI2cGVlcnBvbnBvbiAzNDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '15060985',
                                                                                                                                          'fiber_length': 1023,
                                                                                                                                          'poller_hash': 'NUE2Qjk5cGVlcnBvbnBvbiAxMzkxOTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14643967',
                                                                                                                                          'fiber_length': 1290,
                                                                                                                                          'poller_hash': 'ODY5M0M2cGVlcnBvbnBvbiAxNDIzNTY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14644149',
                                                                                                                                          'fiber_length': 883,
                                                                                                                                          'poller_hash': 'MzQ5RDZFcGVlcnBvbnBvbiAxNDgxMjU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '14644056',
                                                                                                                                          'fiber_length': 469,
                                                                                                                                          'poller_hash': 'QzgzQkNDcGVlcnBvbnBvbiAxNjY2NTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791},
                                                                                                                                  {       'connected_time': '9160730',
                                                                                                                                          'fiber_length': 706,
                                                                                                                                          'poller_hash': 'MTI3NTBEM3BlZXJwb25wb24gMjE3NzE2',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.791}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/4',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/5',
                                                                                         'in_discards': '171994',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2496909',
                                                                                         'in_octets': '9146717096573',
                                                                                         'in_ucast_pkts': '21425817266',
                                                                                         'links': [       {       'in_nucast_pkts': '3264',
                                                                                                                  'in_octets': '136607110436',
                                                                                                                  'in_ucast_pkts': '717285803',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '124493',
                                                                                                                  'out_octets': '2869217726909',
                                                                                                                  'out_ucast_pkts': '2302000673',
                                                                                                                  'poller_hash': 'M0VCQTE5cGVlcmludGZwb24gMTg='},
                                                                                                          {       'in_nucast_pkts': '9383609',
                                                                                                                  'in_octets': '17329164112',
                                                                                                                  'in_ucast_pkts': '72899817',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10352502239',
                                                                                                                  'out_octets': '13944360854755',
                                                                                                                  'out_ucast_pkts': '258408509',
                                                                                                                  'poller_hash': 'NDJCOUU2cGVlcmludGZwb24gNDY='},
                                                                                                          {       'in_nucast_pkts': '78466',
                                                                                                                  'in_octets': '22593865588',
                                                                                                                  'in_ucast_pkts': '73019354',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7856883',
                                                                                                                  'out_octets': '178362487719',
                                                                                                                  'out_ucast_pkts': '159341843',
                                                                                                                  'poller_hash': 'ODcyNDcwcGVlcmludGZwb24gNTM='},
                                                                                                          {       'in_nucast_pkts': '3285023',
                                                                                                                  'in_octets': '19773864882',
                                                                                                                  'in_ucast_pkts': '115121969',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6619475343',
                                                                                                                  'out_octets': '9346739696750',
                                                                                                                  'out_ucast_pkts': '8949434678',
                                                                                                                  'poller_hash': 'NDE1M0ZwZWVyaW50ZnBvbiA1NA=='},
                                                                                                          {       'in_nucast_pkts': '10819171',
                                                                                                                  'in_octets': '146820260572',
                                                                                                                  'in_ucast_pkts': '263789568',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3553081739',
                                                                                                                  'out_octets': '5272917044792',
                                                                                                                  'out_ucast_pkts': '628401352',
                                                                                                                  'poller_hash': 'NzFBNDkycGVlcmludGZwb24gNTU='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'M0QwRkNwZWVyaW50ZnBvbiA1Nw=='},
                                                                                                          {       'in_nucast_pkts': '220948',
                                                                                                                  'in_octets': '326004332989',
                                                                                                                  'in_ucast_pkts': '681483608',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534945',
                                                                                                                  'out_octets': '2299324835285',
                                                                                                                  'out_ucast_pkts': '1824008384',
                                                                                                                  'poller_hash': 'M0QwRUZwZWVyaW50ZnBvbiA1OA=='},
                                                                                                          {       'in_nucast_pkts': '7144144',
                                                                                                                  'in_octets': '21183091080',
                                                                                                                  'in_ucast_pkts': '72401418',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7729266775',
                                                                                                                  'out_octets': '10108731001439',
                                                                                                                  'out_ucast_pkts': '148297805',
                                                                                                                  'poller_hash': 'NzFEMkU1cGVlcmludGZwb24gNTk='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'M0QwRjRwZWVyaW50ZnBvbiA2MA=='},
                                                                                                          {       'in_nucast_pkts': '15680',
                                                                                                                  'in_octets': '3340776674',
                                                                                                                  'in_ucast_pkts': '10621485',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '117598',
                                                                                                                  'out_octets': '14443256230',
                                                                                                                  'out_ucast_pkts': '15740176',
                                                                                                                  'poller_hash': 'NDE1MjJwZWVyaW50ZnBvbiA2MQ=='},
                                                                                                          {       'in_nucast_pkts': '9441',
                                                                                                                  'in_octets': '73093787988',
                                                                                                                  'in_ucast_pkts': '312826624',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534615',
                                                                                                                  'out_octets': '1488127735315',
                                                                                                                  'out_ucast_pkts': '1179389257',
                                                                                                                  'poller_hash': 'ODg5QjRwZWVyaW50ZnBvbiA2Mw=='},
                                                                                                          {       'in_nucast_pkts': '15436',
                                                                                                                  'in_octets': '237557120526',
                                                                                                                  'in_ucast_pkts': '823399776',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534097',
                                                                                                                  'out_octets': '4615459864957',
                                                                                                                  'out_ucast_pkts': '3411594447',
                                                                                                                  'poller_hash': 'MTk5QTM2cGVlcmludGZwb24gNjQ='},
                                                                                                          {       'in_nucast_pkts': '19034083',
                                                                                                                  'in_octets': '70931326315',
                                                                                                                  'in_ucast_pkts': '106946808',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '19018424311',
                                                                                                                  'out_octets': '25691893729047',
                                                                                                                  'out_ucast_pkts': '321156919',
                                                                                                                  'poller_hash': 'NTU2M0FEcGVlcmludGZwb24gNjU='},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'NTYwQzE5cGVlcmludGZwb24gNjc='},
                                                                                                          {       'in_nucast_pkts': '13130860',
                                                                                                                  'in_octets': '222984101772',
                                                                                                                  'in_ucast_pkts': '919918431',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4074739124',
                                                                                                                  'out_octets': '8884204894822',
                                                                                                                  'out_ucast_pkts': '2685253362',
                                                                                                                  'poller_hash': 'NTYwMjYzcGVlcmludGZwb24gNzA='},
                                                                                                          {       'in_nucast_pkts': '45953208',
                                                                                                                  'in_octets': '144277184064',
                                                                                                                  'in_ucast_pkts': '564106410',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '13981263938',
                                                                                                                  'out_octets': '20495349454369',
                                                                                                                  'out_ucast_pkts': '1553905050',
                                                                                                                  'poller_hash': 'MTk5QTMxcGVlcmludGZwb24gOTQ='},
                                                                                                          {       'in_nucast_pkts': '6453948',
                                                                                                                  'in_octets': '114569851892',
                                                                                                                  'in_ucast_pkts': '608221805',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10199948131',
                                                                                                                  'out_octets': '17216743848053',
                                                                                                                  'out_ucast_pkts': '2659130739',
                                                                                                                  'poller_hash': 'NDkzNDBwZWVyaW50ZnBvbiA5OA=='},
                                                                                                          {       'in_nucast_pkts': '40470',
                                                                                                                  'in_octets': '2152073903756',
                                                                                                                  'in_ucast_pkts': '1526154413',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7853321',
                                                                                                                  'out_octets': '286805721012',
                                                                                                                  'out_ucast_pkts': '466774354',
                                                                                                                  'poller_hash': 'ODY5NDE5cGVlcmludGZwb24gMTQyMzI2'},
                                                                                                          {       'in_nucast_pkts': '7432045',
                                                                                                                  'in_octets': '8345243554',
                                                                                                                  'in_ucast_pkts': '31600643',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15523926961',
                                                                                                                  'out_octets': '20976748017373',
                                                                                                                  'out_ucast_pkts': '122831114',
                                                                                                                  'poller_hash': 'QkYyNEQxcGVlcmludGZwb24gMTY2NzE4'},
                                                                                                          {       'in_nucast_pkts': '3351514',
                                                                                                                  'in_octets': '194266039001',
                                                                                                                  'in_ucast_pkts': '1046720106',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3997647691',
                                                                                                                  'out_octets': '9228450819706',
                                                                                                                  'out_ucast_pkts': '3015383173',
                                                                                                                  'poller_hash': 'Q0JFMDUycGVlcmludGZwb24gMTY4NDU5'},
                                                                                                          {       'in_nucast_pkts': '15521594',
                                                                                                                  'in_octets': '16447468507',
                                                                                                                  'in_ucast_pkts': '61861300',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '19845579416',
                                                                                                                  'out_octets': '26691915512339',
                                                                                                                  'out_ucast_pkts': '239095935',
                                                                                                                  'poller_hash': 'QzgxREQwcGVlcmludGZwb24gMTk4MjI0'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '285075182278',
                                                                                         'out_octets': '461120766813828',
                                                                                         'out_ucast_pkts': '56435776488',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzU=',
                                                                                         'pons': [       {       'id': '2/5',
                                                                                                                 'links': [       {       'connected_time': '14628722',
                                                                                                                                          'fiber_length': 2650,
                                                                                                                                          'poller_hash': 'M0VCQTE5cGVlcnBvbnBvbiAxOA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '8874032',
                                                                                                                                          'fiber_length': 3056,
                                                                                                                                          'poller_hash': 'NDJCOUU2cGVlcnBvbnBvbiA0Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14643884',
                                                                                                                                          'fiber_length': 3561,
                                                                                                                                          'poller_hash': 'ODcyNDcwcGVlcnBvbnBvbiA1Mw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '4793033',
                                                                                                                                          'fiber_length': 3519,
                                                                                                                                          'poller_hash': 'NDE1M0ZwZWVycG9ucG9uIDU0',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628813',
                                                                                                                                          'fiber_length': 3183,
                                                                                                                                          'poller_hash': 'NzFBNDkycGVlcnBvbnBvbiA1NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628535',
                                                                                                                                          'fiber_length': 2568,
                                                                                                                                          'poller_hash': 'M0QwRkNwZWVycG9ucG9uIDU3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628723',
                                                                                                                                          'fiber_length': 3038,
                                                                                                                                          'poller_hash': 'M0QwRUZwZWVycG9ucG9uIDU4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628885',
                                                                                                                                          'fiber_length': 3122,
                                                                                                                                          'poller_hash': 'NzFEMkU1cGVlcnBvbnBvbiA1OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628692',
                                                                                                                                          'fiber_length': 3119,
                                                                                                                                          'poller_hash': 'M0QwRjRwZWVycG9ucG9uIDYw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -25.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '2173535',
                                                                                                                                          'fiber_length': 3121,
                                                                                                                                          'poller_hash': 'NDE1MjJwZWVycG9ucG9uIDYx',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628758',
                                                                                                                                          'fiber_length': 2956,
                                                                                                                                          'poller_hash': 'ODg5QjRwZWVycG9ucG9uIDYz',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628649',
                                                                                                                                          'fiber_length': 2731,
                                                                                                                                          'poller_hash': 'MTk5QTM2cGVlcnBvbnBvbiA2NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628929',
                                                                                                                                          'fiber_length': 2848,
                                                                                                                                          'poller_hash': 'NTU2M0FEcGVlcnBvbnBvbiA2NQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628364',
                                                                                                                                          'fiber_length': 2932,
                                                                                                                                          'poller_hash': 'NTYwQzE5cGVlcnBvbnBvbiA2Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628709',
                                                                                                                                          'fiber_length': 2659,
                                                                                                                                          'poller_hash': 'NTYwMjYzcGVlcnBvbnBvbiA3MA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628750',
                                                                                                                                          'fiber_length': 2654,
                                                                                                                                          'poller_hash': 'MTk5QTMxcGVlcnBvbnBvbiA5NA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14628451',
                                                                                                                                          'fiber_length': 3090,
                                                                                                                                          'poller_hash': 'NDkzNDBwZWVycG9ucG9uIDk4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14644130',
                                                                                                                                          'fiber_length': 3459,
                                                                                                                                          'poller_hash': 'ODY5NDE5cGVlcnBvbnBvbiAxNDIzMjY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14629154',
                                                                                                                                          'fiber_length': 3182,
                                                                                                                                          'poller_hash': 'QkYyNEQxcGVlcnBvbnBvbiAxNjY3MTg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14643997',
                                                                                                                                          'fiber_length': 2973,
                                                                                                                                          'poller_hash': 'Q0JFMDUycGVlcnBvbnBvbiAxNjg0NTk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731},
                                                                                                                                  {       'connected_time': '14644033',
                                                                                                                                          'fiber_length': 3062,
                                                                                                                                          'poller_hash': 'QzgxREQwcGVlcnBvbnBvbiAxOTgyMjQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.731}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/5',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/6',
                                                                                         'in_discards': '126185',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '225351',
                                                                                         'in_octets': '5692594564376',
                                                                                         'in_ucast_pkts': '23286717862',
                                                                                         'links': [       {       'in_nucast_pkts': '149184',
                                                                                                                  'in_octets': '153438881290',
                                                                                                                  'in_ucast_pkts': '530955831',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4640374',
                                                                                                                  'out_octets': '1449839168786',
                                                                                                                  'out_ucast_pkts': '1299994349',
                                                                                                                  'poller_hash': 'ODcyNDI1cGVlcmludGZwb24gMTQzMDQz'},
                                                                                                          {       'in_nucast_pkts': '1929',
                                                                                                                  'in_octets': '62225287396',
                                                                                                                  'in_ucast_pkts': '132549202',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '2931845',
                                                                                                                  'out_octets': '368467201826',
                                                                                                                  'out_ucast_pkts': '318785110',
                                                                                                                  'poller_hash': 'ODcyNDcxcGVlcmludGZwb24gMTQ0NDQ2'},
                                                                                                          {       'in_nucast_pkts': '3982970',
                                                                                                                  'in_octets': '14892658982',
                                                                                                                  'in_ucast_pkts': '106200517',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10349580610',
                                                                                                                  'out_octets': '14192603863885',
                                                                                                                  'out_ucast_pkts': '385498382',
                                                                                                                  'poller_hash': 'OTU2RkE3cGVlcmludGZwb24gMTQ1NjMw'},
                                                                                                          {       'in_nucast_pkts': '8047953',
                                                                                                                  'in_octets': '163714324344',
                                                                                                                  'in_ucast_pkts': '364243499',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '21105576593',
                                                                                                                  'out_octets': '29561366747186',
                                                                                                                  'out_ucast_pkts': '878905004',
                                                                                                                  'poller_hash': 'OTU2RjI2cGVlcmludGZwb24gMTQ2MDAx'},
                                                                                                          {       'in_nucast_pkts': '48446',
                                                                                                                  'in_octets': '13287564527',
                                                                                                                  'in_ucast_pkts': '62258008',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '7857287',
                                                                                                                  'out_octets': '373996494662',
                                                                                                                  'out_ucast_pkts': '298824304',
                                                                                                                  'poller_hash': 'QTlDODk5cGVlcmludGZwb24gMTQ3Mzk3'},
                                                                                                          {       'in_nucast_pkts': '32768',
                                                                                                                  'in_octets': '120932144386',
                                                                                                                  'in_ucast_pkts': '883601257',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4857783',
                                                                                                                  'out_octets': '3457135451796',
                                                                                                                  'out_ucast_pkts': '2457238323',
                                                                                                                  'poller_hash': 'QjUxMTUxcGVlcmludGZwb24gMTUxMjAy'},
                                                                                                          {       'in_nucast_pkts': '15626666',
                                                                                                                  'in_octets': '40134572601',
                                                                                                                  'in_ucast_pkts': '83690578',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3473213614',
                                                                                                                  'out_octets': '3991865305210',
                                                                                                                  'out_ucast_pkts': '199772087',
                                                                                                                  'poller_hash': 'ODY5MzhCcGVlcmludGZwb24gMTU2NDMw'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'QzgzQkZDcGVlcmludGZwb24gMTYxNjQ3'},
                                                                                                          {       'in_nucast_pkts': '14078',
                                                                                                                  'in_octets': '45661575764',
                                                                                                                  'in_ucast_pkts': '101774394',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '4406092',
                                                                                                                  'out_octets': '456574256148',
                                                                                                                  'out_ucast_pkts': '340625796',
                                                                                                                  'poller_hash': 'QzgzQjZFcGVlcmludGZwb24gMTcwNzIy'},
                                                                                                          {       'in_nucast_pkts': '14419',
                                                                                                                  'in_octets': '70508994966',
                                                                                                                  'in_ucast_pkts': '385715692',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3402768',
                                                                                                                  'out_octets': '1597826049682',
                                                                                                                  'out_ucast_pkts': '1186893908',
                                                                                                                  'poller_hash': 'QzgxQzdCcGVlcmludGZwb24gMjA3MTQ5'},
                                                                                                          {       'in_nucast_pkts': '48423',
                                                                                                                  'in_octets': '303608925349',
                                                                                                                  'in_ucast_pkts': '779177215',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6915655',
                                                                                                                  'out_octets': '2152531587737',
                                                                                                                  'out_ucast_pkts': '1895977829',
                                                                                                                  'poller_hash': 'MTFCMjIzNXBlZXJpbnRmcG9uIDIxMjU4MA=='}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '2/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '224667840729',
                                                                                         'out_octets': '399443717466596',
                                                                                         'out_ucast_pkts': '70606795018',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzY=',
                                                                                         'pons': [       {       'id': '2/6',
                                                                                                                 'links': [       {       'connected_time': '8985888',
                                                                                                                                          'fiber_length': 999,
                                                                                                                                          'poller_hash': 'ODcyNDI1cGVlcnBvbnBvbiAxNDMwNDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '5676933',
                                                                                                                                          'fiber_length': 1234,
                                                                                                                                          'poller_hash': 'ODcyNDcxcGVlcnBvbnBvbiAxNDQ0NDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '5012199',
                                                                                                                                          'fiber_length': 397,
                                                                                                                                          'poller_hash': 'OTU2RkE3cGVlcnBvbnBvbiAxNDU2MzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '14644172',
                                                                                                                                          'fiber_length': 921,
                                                                                                                                          'poller_hash': 'OTU2RjI2cGVlcnBvbnBvbiAxNDYwMDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '14644060',
                                                                                                                                          'fiber_length': 1119,
                                                                                                                                          'poller_hash': 'QTlDODk5cGVlcnBvbnBvbiAxNDczOTc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '8986236',
                                                                                                                                          'fiber_length': 1020,
                                                                                                                                          'poller_hash': 'QjUxMTUxcGVlcnBvbnBvbiAxNTEyMDI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '14644037',
                                                                                                                                          'fiber_length': 1062,
                                                                                                                                          'poller_hash': 'ODY5MzhCcGVlcnBvbnBvbiAxNTY0MzA=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '14644139',
                                                                                                                                          'fiber_length': 993,
                                                                                                                                          'poller_hash': 'QzgzQkZDcGVlcnBvbnBvbiAxNjE2NDc=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '8132111',
                                                                                                                                          'fiber_length': 989,
                                                                                                                                          'poller_hash': 'QzgzQjZFcGVlcnBvbnBvbiAxNzA3MjI=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '6286046',
                                                                                                                                          'fiber_length': 560,
                                                                                                                                          'poller_hash': 'QzgxQzdCcGVlcnBvbnBvbiAyMDcxNDk=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679},
                                                                                                                                  {       'connected_time': '13809055',
                                                                                                                                          'fiber_length': 1456,
                                                                                                                                          'poller_hash': 'MTFCMjIzNXBlZXJwb25wb24gMjEyNTgw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.679}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/6',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/7',
                                                                                         'in_discards': '1333',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1777901',
                                                                                         'in_octets': '5669391585501',
                                                                                         'in_ucast_pkts': '20085943775',
                                                                                         'links': [       {       'in_nucast_pkts': '8292671',
                                                                                                                  'in_octets': '50570366897',
                                                                                                                  'in_ucast_pkts': '233441762',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '11524255990',
                                                                                                                  'out_octets': '16153388382256',
                                                                                                                  'out_ucast_pkts': '777395856',
                                                                                                                  'poller_hash': 'M0ZDM0MycGVlcmludGZwb24gMjE='},
                                                                                                          {       'in_nucast_pkts': '2014063',
                                                                                                                  'in_octets': '19293428354',
                                                                                                                  'in_ucast_pkts': '86336370',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '1721889912',
                                                                                                                  'out_octets': '2485247716102',
                                                                                                                  'out_ucast_pkts': '265221221',
                                                                                                                  'poller_hash': 'MzIxOTU4cGVlcmludGZwb24gMzA='},
                                                                                                          {       'in_nucast_pkts': '27395',
                                                                                                                  'in_octets': '73925458599',
                                                                                                                  'in_ucast_pkts': '320042035',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '269749',
                                                                                                                  'out_octets': '968946151835',
                                                                                                                  'out_ucast_pkts': '750080459',
                                                                                                                  'poller_hash': 'MTJGRkVFcGVlcmludGZwb24gNjk='},
                                                                                                          {       'in_nucast_pkts': '9363',
                                                                                                                  'in_octets': '13574433419',
                                                                                                                  'in_ucast_pkts': '97569350',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534732',
                                                                                                                  'out_octets': '317698300987',
                                                                                                                  'out_ucast_pkts': '239294082',
                                                                                                                  'poller_hash': 'MTk5OUUzcGVlcmludGZwb24gNzc='},
                                                                                                          {       'in_nucast_pkts': '4032',
                                                                                                                  'in_octets': '26555486613',
                                                                                                                  'in_ucast_pkts': '91875650',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '537915',
                                                                                                                  'out_octets': '694006257697',
                                                                                                                  'out_ucast_pkts': '562674215',
                                                                                                                  'poller_hash': 'M0QwRjJwZWVyaW50ZnBvbiA3OA=='},
                                                                                                          {       'in_nucast_pkts': '10913378',
                                                                                                                  'in_octets': '38979070249',
                                                                                                                  'in_ucast_pkts': '163914232',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '15428185029',
                                                                                                                  'out_octets': '21340266023466',
                                                                                                                  'out_ucast_pkts': '459478583',
                                                                                                                  'poller_hash': 'NkRCQzk4cGVlcmludGZwb24gNzk='},
                                                                                                          {       'in_nucast_pkts': '517572',
                                                                                                                  'in_octets': '593993915333',
                                                                                                                  'in_ucast_pkts': '1926909584',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '16',
                                                                                                                  'out_octets': '1676534785734',
                                                                                                                  'out_ucast_pkts': '2056672888',
                                                                                                                  'poller_hash': 'M0QwRjZwZWVyaW50ZnBvbiA4MA=='},
                                                                                                          {       'in_nucast_pkts': '16338359',
                                                                                                                  'in_octets': '203169927997',
                                                                                                                  'in_ucast_pkts': '631454668',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '3907363925',
                                                                                                                  'out_octets': '6935702049394',
                                                                                                                  'out_ucast_pkts': '1457961913',
                                                                                                                  'poller_hash': 'NzZDRkY4cGVlcmludGZwb24gODE='},
                                                                                                          {       'in_nucast_pkts': '6574959',
                                                                                                                  'in_octets': '48852931704',
                                                                                                                  'in_ucast_pkts': '212285552',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '5191203141',
                                                                                                                  'out_octets': '6998519967465',
                                                                                                                  'out_ucast_pkts': '463913241',
                                                                                                                  'poller_hash': 'NDJDRTk4cGVlcmludGZwb24gODY='},
                                                                                                          {       'in_nucast_pkts': '65',
                                                                                                                  'in_octets': '8083146879',
                                                                                                                  'in_ucast_pkts': '35532391',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '120688',
                                                                                                                  'out_octets': '110382749294',
                                                                                                                  'out_ucast_pkts': '87861865',
                                                                                                                  'poller_hash': 'NzIyMDNEcGVlcmludGZwb24gODg='},
                                                                                                          {       'in_nucast_pkts': '1297939',
                                                                                                                  'in_octets': '7800728207',
                                                                                                                  'in_ucast_pkts': '60384937',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '928143352',
                                                                                                                  'out_octets': '1425407732728',
                                                                                                                  'out_ucast_pkts': '138925780',
                                                                                                                  'poller_hash': 'M0QwRTlwZWVyaW50ZnBvbiA5NQ=='},
                                                                                                          {       'in_nucast_pkts': '40090',
                                                                                                                  'in_octets': '37725632',
                                                                                                                  'in_ucast_pkts': '328104',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '44071',
                                                                                                                  'out_octets': '2995470404',
                                                                                                                  'out_ucast_pkts': '1995736',
                                                                                                                  'poller_hash': 'M0ZGQUI5cGVlcmludGZwb24gOTY='},
                                                                                                          {       'in_nucast_pkts': '2974',
                                                                                                                  'in_octets': '19097660080',
                                                                                                                  'in_ucast_pkts': '141954355',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534727',
                                                                                                                  'out_octets': '581398262724',
                                                                                                                  'out_ucast_pkts': '427895353',
                                                                                                                  'poller_hash': 'NDE1ODVwZWVyaW50ZnBvbiA5Nw=='},
                                                                                                          {       'in_nucast_pkts': '11134',
                                                                                                                  'in_octets': '594970993143',
                                                                                                                  'in_ucast_pkts': '1008562162',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '534720',
                                                                                                                  'out_octets': '2011027733536',
                                                                                                                  'out_ucast_pkts': '1917066043',
                                                                                                                  'poller_hash': 'MTU0NTJwZWVyaW50ZnBvbiAxMDA='},
                                                                                                          {       'in_nucast_pkts': '67748',
                                                                                                                  'in_octets': '259289741531',
                                                                                                                  'in_ucast_pkts': '1405419065',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '539810',
                                                                                                                  'out_octets': '3837748236244',
                                                                                                                  'out_ucast_pkts': '2715670122',
                                                                                                                  'poller_hash': 'NDE1OTFwZWVyaW50ZnBvbiAxMDE='},
                                                                                                          {       'in_nucast_pkts': '19991663',
                                                                                                                  'in_octets': '110280046178',
                                                                                                                  'in_ucast_pkts': '419105918',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '33870498926',
                                                                                                                  'out_octets': '46504293493722',
                                                                                                                  'out_ucast_pkts': '952118736',
                                                                                                                  'poller_hash': 'N0ZFODRwZWVyaW50ZnBvbiAxMDI='},
                                                                                                          {       'in_nucast_pkts': '4645968',
                                                                                                                  'in_octets': '103623707574',
                                                                                                                  'in_ucast_pkts': '969137812',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '6555371824',
                                                                                                                  'out_octets': '11766096543031',
                                                                                                                  'out_ucast_pkts': '2173953611',
                                                                                                                  'poller_hash': 'MzkwQUI4cGVlcmludGZwb24gMTAz'},
                                                                                                          {       'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'MzI5NURDcGVlcmludGZwb24gMTA0'},
                                                                                                          {       'in_nucast_pkts': '4831152',
                                                                                                                  'in_octets': '73851836590',
                                                                                                                  'in_ucast_pkts': '290298437',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '10317797066',
                                                                                                                  'out_octets': '14928811701464',
                                                                                                                  'out_ucast_pkts': '931758831',
                                                                                                                  'poller_hash': 'MkZFOUJBcGVlcmludGZwb24gMTA1'},
                                                                                                          {       'in_nucast_pkts': '7439518',
                                                                                                                  'in_octets': '169674715920',
                                                                                                                  'in_ucast_pkts': '1240487182',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '21666720077',
                                                                                                                  'out_octets': '32838393280023',
                                                                                                                  'out_ucast_pkts': '2607434603',
                                                                                                                  'poller_hash': 'QzgzQkIwcGVlcmludGZwb24gMTA2'},
                                                                                                          {       'in_nucast_pkts': '5208667',
                                                                                                                  'in_octets': '132200796461',
                                                                                                                  'in_ucast_pkts': '674719318',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '8808830312',
                                                                                                                  'out_octets': '14083232315444',
                                                                                                                  'out_ucast_pkts': '1708699556',
                                                                                                                  'poller_hash': 'M0FFQkMwcGVlcmludGZwb24gMTA4'}],
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '2/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '225366480887',
                                                                                         'out_octets': '359691748219154',
                                                                                         'out_ucast_pkts': '42013020323',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzc=',
                                                                                         'pons': [       {       'id': '2/7',
                                                                                                                 'links': [       {       'connected_time': '14628944',
                                                                                                                                          'fiber_length': 1288,
                                                                                                                                          'poller_hash': 'M0ZDM0MycGVlcnBvbnBvbiAyMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '8459643',
                                                                                                                                          'fiber_length': 2218,
                                                                                                                                          'poller_hash': 'MzIxOTU4cGVlcnBvbnBvbiAzMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '6557309',
                                                                                                                                          'fiber_length': 2078,
                                                                                                                                          'poller_hash': 'MTJGRkVFcGVlcnBvbnBvbiA2OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628928',
                                                                                                                                          'fiber_length': 2481,
                                                                                                                                          'poller_hash': 'MTk5OUUzcGVlcnBvbnBvbiA3Nw==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628681',
                                                                                                                                          'fiber_length': 2400,
                                                                                                                                          'poller_hash': 'M0QwRjJwZWVycG9ucG9uIDc4',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14629054',
                                                                                                                                          'fiber_length': 2449,
                                                                                                                                          'poller_hash': 'NkRCQzk4cGVlcnBvbnBvbiA3OQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628666',
                                                                                                                                          'fiber_length': 2359,
                                                                                                                                          'poller_hash': 'M0QwRjZwZWVycG9ucG9uIDgw',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628824',
                                                                                                                                          'fiber_length': 2358,
                                                                                                                                          'poller_hash': 'NzZDRkY4cGVlcnBvbnBvbiA4MQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14643779',
                                                                                                                                          'fiber_length': 2811,
                                                                                                                                          'poller_hash': 'NDJDRTk4cGVlcnBvbnBvbiA4Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628860',
                                                                                                                                          'fiber_length': 1377,
                                                                                                                                          'poller_hash': 'NzIyMDNEcGVlcnBvbnBvbiA4OA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '1217594',
                                                                                                                                          'fiber_length': 2611,
                                                                                                                                          'poller_hash': 'M0QwRTlwZWVycG9ucG9uIDk1',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14629124',
                                                                                                                                          'fiber_length': 1644,
                                                                                                                                          'poller_hash': 'M0ZGQUI5cGVlcnBvbnBvbiA5Ng==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628564',
                                                                                                                                          'fiber_length': 1801,
                                                                                                                                          'poller_hash': 'NDE1ODVwZWVycG9ucG9uIDk3',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628482',
                                                                                                                                          'fiber_length': 1314,
                                                                                                                                          'poller_hash': 'MTU0NTJwZWVycG9ucG9uIDEwMA==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628616',
                                                                                                                                          'fiber_length': 1229,
                                                                                                                                          'poller_hash': 'NDE1OTFwZWVycG9ucG9uIDEwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628866',
                                                                                                                                          'fiber_length': 1998,
                                                                                                                                          'poller_hash': 'N0ZFODRwZWVycG9ucG9uIDEwMg==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628478',
                                                                                                                                          'fiber_length': 2109,
                                                                                                                                          'poller_hash': 'MzkwQUI4cGVlcnBvbnBvbiAxMDM=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628896',
                                                                                                                                          'fiber_length': 2039,
                                                                                                                                          'poller_hash': 'MzI5NURDcGVlcnBvbnBvbiAxMDQ=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14628828',
                                                                                                                                          'fiber_length': 2020,
                                                                                                                                          'poller_hash': 'MkZFOUJBcGVlcnBvbnBvbiAxMDU=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14643763',
                                                                                                                                          'fiber_length': 2109,
                                                                                                                                          'poller_hash': 'QzgzQkIwcGVlcnBvbnBvbiAxMDY=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701},
                                                                                                                                  {       'connected_time': '14407785',
                                                                                                                                          'fiber_length': 2136,
                                                                                                                                          'poller_hash': 'M0FFQkMwcGVlcnBvbnBvbiAxMDg=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.701}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/7',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/8',
                                                                                         'in_discards': '365244',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '841929',
                                                                                         'in_octets': '22173383013247',
                                                                                         'in_ucast_pkts': '91053707612',
                                                                                         'links': [       {       'in_nucast_pkts': '10123',
                                                                                                                  'in_octets': '34621954503',
                                                                                                                  'in_ucast_pkts': '193545260',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '628909',
                                                                                                                  'out_octets': '537806655808',
                                                                                                                  'out_ucast_pkts': '405643559',
                                                                                                                  'poller_hash': 'NDJDMTE4cGVlcmludGZwb24gOTE='},
                                                                                                          {       'in_nucast_pkts': '7274630',
                                                                                                                  'in_octets': '16933732290',
                                                                                                                  'in_ucast_pkts': '103413698',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '19973905610',
                                                                                                                  'out_octets': '27071296406139',
                                                                                                                  'out_ucast_pkts': '365915203',
                                                                                                                  'poller_hash': 'NDJDOTNGcGVlcmludGZwb24gOTI='},
                                                                                                          {       'in_nucast_pkts': '47527',
                                                                                                                  'in_octets': '56452661547',
                                                                                                                  'in_ucast_pkts': '492940304',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '682124',
                                                                                                                  'out_octets': '1869953213072',
                                                                                                                  'out_ucast_pkts': '1306126199',
                                                                                                                  'poller_hash': 'NjQwQUVEcGVlcmludGZwb24gMzQx'},
                                                                                                          {       'in_nucast_pkts': '15739',
                                                                                                                  'in_octets': '63418602276',
                                                                                                                  'in_ucast_pkts': '527775360',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '681475',
                                                                                                                  'out_octets': '2891324668864',
                                                                                                                  'out_ucast_pkts': '2002454593',
                                                                                                                  'poller_hash': 'NjQwQUU0cGVlcmludGZwb24gMzQz'},
                                                                                                          {       'in_nucast_pkts': '8345',
                                                                                                                  'in_octets': '46113428267',
                                                                                                                  'in_ucast_pkts': '159214964',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '681476',
                                                                                                                  'out_octets': '616329105850',
                                                                                                                  'out_ucast_pkts': '470900895',
                                                                                                                  'poller_hash': 'NjQwQjJGcGVlcmludGZwb24gMzQ0'},
                                                                                                          {       'in_nucast_pkts': '7279174',
                                                                                                                  'in_octets': '81715482915',
                                                                                                                  'in_ucast_pkts': '257311686',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_nucast_pkts': '19965657198',
                                                                                                                  'out_octets': '27495958115534',
                                                                                                                  'out_ucast_pkts': '723749502',
                             