import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):

    def test_calix_axos_E7_2_23_2_0_01(self):
        obj = self.run_data("calix.axos.E7-2.23.2.0.01")
        exp_info = {
         'model': 'E7-2', 'sta_count': 159, 'sw_version': '23.2.0', 'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '071904929255', 'system_mac_address': '00:02:5d:fe:73:6a'
        }
        exp_sta_stats = {
                None: {       'dev_macs': None,
                              'ip_address': None,
                              'mac_address': None,
                              'name': '85/g1',
                              'serial_number': '87BA22',
                              'system_mac_address': None},
                'd0:76:8f:1f:d6:1a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d6:1a',
                                             'name': '15/g1',
                                             'serial_number': '87B15E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d6:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d6:f8',
                                             'name': '236/g1',
                                             'serial_number': '87B1A8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d7:2e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d7:2e',
                                             'name': '19/g1',
                                             'serial_number': '87B1BA',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d7:34': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d7:34',
                                             'name': '176/g1',
                                             'serial_number': '87B1BC',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d7:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d7:d6',
                                             'name': '209/g1',
                                             'serial_number': '87B1F2',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:33': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:33',
                                             'name': '169/g1',
                                             'serial_number': '87B211',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:57': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:57',
                                             'name': '28/g1',
                                             'serial_number': '87B21D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:c3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:c3',
                                             'name': '22/g1',
                                             'serial_number': '87B241',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:c9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:c9',
                                             'name': '278/g1',
                                             'serial_number': '87B243',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:e1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:e1',
                                             'name': '24/g1',
                                             'serial_number': '87B24B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:ea': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:ea',
                                             'name': '27/g1',
                                             'serial_number': '87B24E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:ff': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:ff',
                                             'name': '26/g1',
                                             'serial_number': '87B255',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d9:2c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d9:2c',
                                             'name': '158/g1',
                                             'serial_number': '87B264',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d9:59': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d9:59',
                                             'name': '23/g1',
                                             'serial_number': '87B273',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d9:7a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d9:7a',
                                             'name': '31/g1',
                                             'serial_number': '87B27E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d9:ad': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d9:ad',
                                             'name': '14/g1',
                                             'serial_number': '87B28F',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d9:e9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d9:e9',
                                             'name': '20/g1',
                                             'serial_number': '87B2A3',
                                             'system_mac_address': None},
                'd0:76:8f:1f:db:84': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:db:84',
                                             'name': '258/g1',
                                             'serial_number': '87B32C',
                                             'system_mac_address': None},
                'd0:76:8f:1f:db:9f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:db:9f',
                                             'name': '179/g1',
                                             'serial_number': '87B335',
                                             'system_mac_address': None},
                'd0:76:8f:1f:db:db': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:db:db',
                                             'name': '228/g1',
                                             'serial_number': '87B349',
                                             'system_mac_address': None},
                'd0:76:8f:1f:db:e7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:db:e7',
                                             'name': '233/g1',
                                             'serial_number': '87B34D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e0:28': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e0:28',
                                             'name': '65/g1',
                                             'serial_number': '87B4B8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e8:50': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e8:50',
                                             'name': '177/g1',
                                             'serial_number': '87B770',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e8:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e8:f8',
                                             'name': '159/g1',
                                             'serial_number': '87B7A8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e9:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e9:af',
                                             'name': '120/g1',
                                             'serial_number': '87B7E5',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e9:dc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e9:dc',
                                             'name': '263/g1',
                                             'serial_number': '87B7F4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e9:df': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e9:df',
                                             'name': '150/g1',
                                             'serial_number': '87B7F5',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e9:fd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e9:fd',
                                             'name': '94/g1',
                                             'serial_number': '87B7FF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ea:2a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ea:2a',
                                             'name': '99/g1',
                                             'serial_number': '87B80E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ea:93': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ea:93',
                                             'name': '110/g1',
                                             'serial_number': '87B831',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ea:db': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ea:db',
                                             'name': '98/g1',
                                             'serial_number': '87B849',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ea:f9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ea:f9',
                                             'name': '118/g1',
                                             'serial_number': '87B853',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:1a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:1a',
                                             'name': '103/g1',
                                             'serial_number': '87B85E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:5c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:5c',
                                             'name': '108/g1',
                                             'serial_number': '87B874',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:5f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:5f',
                                             'name': '122/g1',
                                             'serial_number': '87B875',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:71': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:71',
                                             'name': '202/g1',
                                             'serial_number': '87B87B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:7d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:7d',
                                             'name': '275/g1',
                                             'serial_number': '87B87F',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:cb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:cb',
                                             'name': '149/g1',
                                             'serial_number': '87B899',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:d1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:d1',
                                             'name': '102/g1',
                                             'serial_number': '87B89B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:e6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:e6',
                                             'name': '100/g1',
                                             'serial_number': '87B8A2',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:25': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:25',
                                             'name': '116/g1',
                                             'serial_number': '87B8B7',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:3d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:3d',
                                             'name': '111/g1',
                                             'serial_number': '87B8BF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:7c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:7c',
                                             'name': '109/g1',
                                             'serial_number': '87B8D4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:85': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:85',
                                             'name': '181/g1',
                                             'serial_number': '87B8D7',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:d0',
                                             'name': '64/g1',
                                             'serial_number': '87B8F0',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:f1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:f1',
                                             'name': '250/g1',
                                             'serial_number': '87B8FB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ed:03': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ed:03',
                                             'name': '162/g1',
                                             'serial_number': '87B901',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ed:06': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ed:06',
                                             'name': '160/g1',
                                             'serial_number': '87B902',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ed:09': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ed:09',
                                             'name': '66/g1',
                                             'serial_number': '87B903',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ed:21': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ed:21',
                                             'name': '89/g1',
                                             'serial_number': '87B90B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ed:b7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ed:b7',
                                             'name': '123/g1',
                                             'serial_number': '87B93D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:4a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:4a',
                                             'name': '135/g1',
                                             'serial_number': '87B96E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:b9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:b9',
                                             'name': '264/g1',
                                             'serial_number': '87B993',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:bf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:bf',
                                             'name': '171/g1',
                                             'serial_number': '87B995',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:cb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:cb',
                                             'name': '252/g1',
                                             'serial_number': '87B999',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:da': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:da',
                                             'name': '255/g1',
                                             'serial_number': '87B99E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:e0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:e0',
                                             'name': '274/g1',
                                             'serial_number': '87B9A0',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:07': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:07',
                                             'name': '265/g1',
                                             'serial_number': '87B9AD',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:10',
                                             'name': '240/g1',
                                             'serial_number': '87B9B0',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:19': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:19',
                                             'name': '92/g1',
                                             'serial_number': '87B9B3',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:1f',
                                             'name': '261/g1',
                                             'serial_number': '87B9B5',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:4c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:4c',
                                             'name': '46/g1',
                                             'serial_number': '87B9C4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:61': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:61',
                                             'name': '58/g1',
                                             'serial_number': '87B9CB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:64',
                                             'name': '166/g1',
                                             'serial_number': '87B9CC',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:67': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:67',
                                             'name': '267/g1',
                                             'serial_number': '87B9CD',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:6a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:6a',
                                             'name': '246/g1',
                                             'serial_number': '87B9CE',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:6d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:6d',
                                             'name': '191/g1',
                                             'serial_number': '87B9CF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:76': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:76',
                                             'name': '238/g1',
                                             'serial_number': '87B9D2',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:79': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:79',
                                             'name': '200/g1',
                                             'serial_number': '87B9D3',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:7c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:7c',
                                             'name': '251/g1',
                                             'serial_number': '87B9D4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:7f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:7f',
                                             'name': '165/g1',
                                             'serial_number': '87B9D5',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:82': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:82',
                                             'name': '272/g1',
                                             'serial_number': '87B9D6',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:91': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:91',
                                             'name': '182/g1',
                                             'serial_number': '87B9DB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:9a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:9a',
                                             'name': '170/g1',
                                             'serial_number': '87B9DE',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:9d',
                                             'name': '132/g1',
                                             'serial_number': '87B9DF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:a0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:a0',
                                             'name': '164/g1',
                                             'serial_number': '87B9E0',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:a3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:a3',
                                             'name': '196/g1',
                                             'serial_number': '87B9E1',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:a6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:a6',
                                             'name': '174/g1',
                                             'serial_number': '87B9E2',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:ac': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:ac',
                                             'name': '172/g1',
                                             'serial_number': '87B9E4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:b5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:b5',
                                             'name': '273/g1',
                                             'serial_number': '87B9E7',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:b8',
                                             'name': '51/g1',
                                             'serial_number': '87B9E8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:c7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:c7',
                                             'name': '49/g1',
                                             'serial_number': '87B9ED',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:ca': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:ca',
                                             'name': '47/g1',
                                             'serial_number': '87B9EE',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:d3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:d3',
                                             'name': '48/g1',
                                             'serial_number': '87B9F1',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:e2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:e2',
                                             'name': '55/g1',
                                             'serial_number': '87B9F6',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:ee',
                                             'name': '62/g1',
                                             'serial_number': '87B9FA',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:fd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:fd',
                                             'name': '91/g1',
                                             'serial_number': '87B9FF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:06': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:06',
                                             'name': '63/g1',
                                             'serial_number': '87BA02',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:09': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:09',
                                             'name': '54/g1',
                                             'serial_number': '87BA03',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:0f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:0f',
                                             'name': '61/g1',
                                             'serial_number': '87BA05',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:12': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:12',
                                             'name': '57/g1',
                                             'serial_number': '87BA06',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:48',
                                             'name': '35/g1',
                                             'serial_number': '87BA18',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:4e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:4e',
                                             'name': '115/g1',
                                             'serial_number': '87BA1A',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:51': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:51',
                                             'name': '84/g1',
                                             'serial_number': '87BA1B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:54': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:54',
                                             'name': '130/g1',
                                             'serial_number': '87BA1C',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:5d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:5d',
                                             'name': '87/g1',
                                             'serial_number': '87BA1F',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:69': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:69',
                                             'name': '86/g1',
                                             'serial_number': '87BA23',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:6c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:6c',
                                             'name': '80/g1',
                                             'serial_number': '87BA24',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:6f',
                                             'name': '30/g1',
                                             'serial_number': '87BA25',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:72': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:72',
                                             'name': '119/g1',
                                             'serial_number': '87BA26',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:75': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:75',
                                             'name': '96/g1',
                                             'serial_number': '87BA27',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:81': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:81',
                                             'name': '199/g1',
                                             'serial_number': '87BA2B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:87': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:87',
                                             'name': '262/g1',
                                             'serial_number': '87BA2D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:90': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:90',
                                             'name': '146/g1',
                                             'serial_number': '87BA30',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:99': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:99',
                                             'name': '157/g1',
                                             'serial_number': '87BA33',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:9c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:9c',
                                             'name': '153/g1',
                                             'serial_number': '87BA34',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:9f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:9f',
                                             'name': '187/g1',
                                             'serial_number': '87BA35',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:a8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:a8',
                                             'name': '256/g1',
                                             'serial_number': '87BA38',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ab': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ab',
                                             'name': '145/g1',
                                             'serial_number': '87BA39',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ae': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ae',
                                             'name': '134/g1',
                                             'serial_number': '87BA3A',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ba': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ba',
                                             'name': '151/g1',
                                             'serial_number': '87BA3E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:c3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:c3',
                                             'name': '136/g1',
                                             'serial_number': '87BA41',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:c9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:c9',
                                             'name': '201/g1',
                                             'serial_number': '87BA43',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:cf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:cf',
                                             'name': '198/g1',
                                             'serial_number': '87BA45',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:d5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:d5',
                                             'name': '152/g1',
                                             'serial_number': '87BA47',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ea': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ea',
                                             'name': '235/g1',
                                             'serial_number': '87BA4E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ed': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ed',
                                             'name': '147/g1',
                                             'serial_number': '87BA4F',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ff': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ff',
                                             'name': '253/g1',
                                             'serial_number': '87BA55',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:05': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:05',
                                             'name': '148/g1',
                                             'serial_number': '87BA57',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:08': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:08',
                                             'name': '232/g1',
                                             'serial_number': '87BA58',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:4d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:4d',
                                             'name': '83/g1',
                                             'serial_number': '87BA6F',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:9b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:9b',
                                             'name': '78/g1',
                                             'serial_number': '87BA89',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:a7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:a7',
                                             'name': '41/g1',
                                             'serial_number': '87BA8D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:d7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:d7',
                                             'name': '33/g1',
                                             'serial_number': '87BA9D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:f8',
                                             'name': '36/g1',
                                             'serial_number': '87BAA8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:fb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:fb',
                                             'name': '42/g1',
                                             'serial_number': '87BAA9',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:01': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:01',
                                             'name': '37/g1',
                                             'serial_number': '87BAAB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:10',
                                             'name': '38/g1',
                                             'serial_number': '87BAB0',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:13': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:13',
                                             'name': '82/g1',
                                             'serial_number': '87BAB1',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:31': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:31',
                                             'name': '34/g1',
                                             'serial_number': '87BABB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:7c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:7c',
                                             'name': '257/g1',
                                             'serial_number': '87BAD4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:ac': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:ac',
                                             'name': 'sonar_item_2594/g1',
                                             'serial_number': '87BAE4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:b2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:b2',
                                             'name': '214/g1',
                                             'serial_number': '87BAE6',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:b5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:b5',
                                             'name': '259/g1',
                                             'serial_number': '87BAE7',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:be': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:be',
                                             'name': '239/g1',
                                             'serial_number': '87BAEA',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:c1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:c1',
                                             'name': '124/g1',
                                             'serial_number': '87BAEB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:c4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:c4',
                                             'name': '237/g1',
                                             'serial_number': '87BAEC',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:c7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:c7',
                                             'name': '197/g1',
                                             'serial_number': '87BAED',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:8b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:8b',
                                             'name': '213/g1',
                                             'serial_number': '87BED9',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:9d',
                                             'name': '105/g1',
                                             'serial_number': '87BEDF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:b2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:b2',
                                             'name': '74/g1',
                                             'serial_number': '87BEE6',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:b8',
                                             'name': '271/g1',
                                             'serial_number': '87BEE8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:bb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:bb',
                                             'name': '75/g1',
                                             'serial_number': '87BEE9',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:c4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:c4',
                                             'name': '71/g1',
                                             'serial_number': '87BEEC',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '26',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '9112648587',
                                                              'in_ucast_pkts': '64139725',
                                                              'mac_address': '48:77:46:53:bd:c0',
                                                              'mtu': 1500,
                                                              'name': 'craft 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '29256997666',
                                                              'out_ucast_pkts': '61413588',
                                                              'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzBjcmFmdCAx'},
                                                      {       'admin_up': True,
                                                              'id': '28',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'craft 2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '5428',
                                                              'out_ucast_pkts': '121',
                                                              'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzBjcmFmdCAy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2',
                                'modules': [       {       'cpu': 27.0,
                                                           'id': '1/1',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '110000101',
                                                                                         'mac_address': '48:77:46:53:bd:d5',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDUxLzEvZzE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000102',
                                                                                         'mac_address': '48:77:46:53:bd:d6',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDYxLzEvZzI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000103',
                                                                                         'mac_address': '48:77:46:53:bd:d7',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDcxLzEvZzM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000104',
                                                                                         'mac_address': '48:77:46:53:bd:d8',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDgxLzEvZzQ='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000105',
                                                                                         'mac_address': '48:77:46:53:bd:d9',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDkxLzEvZzU='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000106',
                                                                                         'mac_address': '48:77:46:53:bd:da',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZGExLzEvZzY='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000107',
                                                                                         'mac_address': '48:77:46:53:bd:db',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZGIxLzEvZzc='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000108',
                                                                                         'mac_address': '48:77:46:53:bd:dc',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZGMxLzEvZzg='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010101',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1254919848',
                                                                                         'in_octets': '342985461552407',
                                                                                         'in_ucast_pkts': '249233718175',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '48:77:46:53:bd:c5',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01629',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '72678063',
                                                                                         'out_octets': '26250111008183',
                                                                                         'out_ucast_pkts': '95243235107',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzUxLzEveDE=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010102',
                                                                                         'mac_address': '48:77:46:53:bd:c6',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzYxLzEveDI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010103',
                                                                                         'mac_address': '48:77:46:53:bd:c7',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzcxLzEveDM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010104',
                                                                                         'mac_address': '48:77:46:53:bd:c8',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzgxLzEveDQ='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010105',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '12304820',
                                                                                         'in_octets': '1663032999763',
                                                                                         'in_ucast_pkts': '7479406054',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCMTk2cGVlcmludGYyOS9ncDE='},
                                                                                                          {       'in_errors': '14',
                                                                                                                  'in_nucast_pkts': '16837736193',
                                                                                                                  'in_octets': '16979794819',
                                                                                                                  'in_ucast_pkts': '142058626',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '665349400781',
                                                                                                                  'out_octets': '665814734561',
                                                                                                                  'out_ucast_pkts': '465333780',
                                                                                                                  'poller_hash': 'ODdCQTI1cGVlcmludGYzMC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '33745979636',
                                                                                                                  'in_octets': '33812753197',
                                                                                                                  'in_ucast_pkts': '66773561',
                                                                                                                  'oper_up': False,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '180686420600',
                                                                                                                  'out_octets': '180841283715',
                                                                                                                  'out_ucast_pkts': '154863115',
                                                                                                                  'poller_hash': 'ODdCQTlEcGVlcmludGYzMy9ncDE='},
                                                                                                          {       'in_errors': '22',
                                                                                                                  'in_nucast_pkts': '11884891744',
                                                                                                                  'in_octets': '11933939573',
                                                                                                                  'in_ucast_pkts': '49047829',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '222393442192',
                                                                                                                  'out_octets': '222556739510',
                                                                                                                  'out_ucast_pkts': '163297318',
                                                                                                                  'poller_hash': 'ODdCQUJCcGVlcmludGYzNC9ncDE='},
                                                                                                          {       'in_errors': '88',
                                                                                                                  'in_nucast_pkts': '62049513090',
                                                                                                                  'in_octets': '62245469340',
                                                                                                                  'in_ucast_pkts': '195956250',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '794625876859',
                                                                                                                  'out_octets': '795183005472',
                                                                                                                  'out_ucast_pkts': '557128613',
                                                                                                                  'poller_hash': 'ODdCQTE4cGVlcmludGYzNS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '37494441459',
                                                                                                                  'in_octets': '37668325789',
                                                                                                                  'in_ucast_pkts': '173884330',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '544470695776',
                                                                                                                  'out_octets': '544896754328',
                                                                                                                  'out_ucast_pkts': '426058552',
                                                                                                                  'poller_hash': 'ODdCQUE4cGVlcmludGYzNi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13902158407',
                                                                                                                  'in_octets': '13989462664',
                                                                                                                  'in_ucast_pkts': '87304257',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '601829539699',
                                                                                                                  'out_octets': '602242113643',
                                                                                                                  'out_ucast_pkts': '412573944',
                                                                                                                  'poller_hash': 'ODdCQUIwcGVlcmludGYzOC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13682147640',
                                                                                                                  'in_octets': '13705641394',
                                                                                                                  'in_ucast_pkts': '23493754',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '86770319145',
                                                                                                                  'out_octets': '86843175207',
                                                                                                                  'out_ucast_pkts': '72856062',
                                                                                                                  'poller_hash': 'ODdCQThEcGVlcmludGY0MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '22317947702',
                                                                                                                  'in_octets': '22442882796',
                                                                                                                  'in_ucast_pkts': '124935094',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '483681941772',
                                                                                                                  'out_octets': '484049985904',
                                                                                                                  'out_ucast_pkts': '368044132',
                                                                                                                  'poller_hash': 'ODdCQUE5cGVlcmludGY0Mi9ncDE='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOTQwcGVlcmludGY0NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11340527447',
                                                                                                                  'in_octets': '11427465913',
                                                                                                                  'in_ucast_pkts': '86938466',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '401108404887',
                                                                                                                  'out_octets': '401390678766',
                                                                                                                  'out_ucast_pkts': '282273879',
                                                                                                                  'poller_hash': 'ODdCOUZBcGVlcmludGY2Mi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12095487588',
                                                                                                                  'in_octets': '12138480926',
                                                                                                                  'in_ucast_pkts': '42993338',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '99176523645',
                                                                                                                  'out_octets': '99256069228',
                                                                                                                  'out_ucast_pkts': '79545583',
                                                                                                                  'poller_hash': 'ODdCQTNFcGVlcmludGYxNTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '15132799292',
                                                                                                                  'in_octets': '15205223750',
                                                                                                                  'in_ucast_pkts': '72424458',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '318058766612',
                                                                                                                  'out_octets': '318291652075',
                                                                                                                  'out_ucast_pkts': '232885463',
                                                                                                                  'poller_hash': 'ODdCQTM1cGVlcmludGYxODcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '486872729',
                                                                                                                  'in_octets': '488048727',
                                                                                                                  'in_ucast_pkts': '1175998',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1586642458',
                                                                                                                  'out_octets': '1588265606',
                                                                                                                  'out_ucast_pkts': '1623148',
                                                                                                                  'poller_hash': 'ODdCOUUxcGVlcmludGYxOTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '29384508744',
                                                                                                                  'in_octets': '29717027276',
                                                                                                                  'in_ucast_pkts': '332518532',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1252348361937',
                                                                                                                  'out_octets': '1253187488413',
                                                                                                                  'out_ucast_pkts': '839126476',
                                                                                                                  'poller_hash': 'ODdCMzREcGVlcmludGYyMzMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '74704342844',
                                                                                                                  'in_octets': '74943149125',
                                                                                                                  'in_ucast_pkts': '238806281',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1353911092181',
                                                                                                                  'out_octets': '1354912961197',
                                                                                                                  'out_ucast_pkts': '1001869016',
                                                                                                                  'poller_hash': 'ODdCQTRFcGVlcmludGYyMzUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '31377814209',
                                                                                                                  'in_octets': '31472398720',
                                                                                                                  'in_ucast_pkts': '94584511',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '509335556408',
                                                                                                                  'out_octets': '509715069383',
                                                                                                                  'out_ucast_pkts': '379512975',
                                                                                                                  'poller_hash': 'ODdCQTU1cGVlcmludGYyNTMvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:c9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': '1/1/gp1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '17',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '3089',
                                                                                         'out_octets': '31851281143210',
                                                                                         'out_ucast_pkts': '22980355316',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax',
                                                                                         'pons': [       {       'id': '110010105',
                                                                                                                 'links': [       {       'poller_hash': 'ODdCMTk2cGVlcnBvbjI5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2907979',
                                                                                                                                          'fiber_length': 541,
                                                                                                                                          'poller_hash': 'ODdCQTI1cGVlcnBvbjMwL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '5696088',
                                                                                                                                          'fiber_length': 611,
                                                                                                                                          'poller_hash': 'ODdCQTlEcGVlcnBvbjMzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2907992',
                                                                                                                                          'fiber_length': 966,
                                                                                                                                          'poller_hash': 'ODdCQUJCcGVlcnBvbjM0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2907988',
                                                                                                                                          'fiber_length': 913,
                                                                                                                                          'poller_hash': 'ODdCQTE4cGVlcnBvbjM1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2907992',
                                                                                                                                          'fiber_length': 814,
                                                                                                                                          'poller_hash': 'ODdCQUE4cGVlcnBvbjM2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2576626',
                                                                                                                                          'fiber_length': 844,
                                                                                                                                          'poller_hash': 'ODdCQUIwcGVlcnBvbjM4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2908006',
                                                                                                                                          'fiber_length': 842,
                                                                                                                                          'poller_hash': 'ODdCQThEcGVlcnBvbjQxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2907996',
                                                                                                                                          'fiber_length': 582,
                                                                                                                                          'poller_hash': 'ODdCQUE5cGVlcnBvbjQyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'poller_hash': 'ODdCOTQwcGVlcnBvbjQ0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2908014',
                                                                                                                                          'fiber_length': 916,
                                                                                                                                          'poller_hash': 'ODdCOUZBcGVlcnBvbjYyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '5352006',
                                                                                                                                          'fiber_length': 1040,
                                                                                                                                          'poller_hash': 'ODdCQTNFcGVlcnBvbjE1MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2907999',
                                                                                                                                          'fiber_length': 712,
                                                                                                                                          'poller_hash': 'ODdCQTM1cGVlcnBvbjE4Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '81989',
                                                                                                                                          'fiber_length': 1009,
                                                                                                                                          'poller_hash': 'ODdCOUUxcGVlcnBvbjE5Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2908012',
                                                                                                                                          'fiber_length': 552,
                                                                                                                                          'poller_hash': 'ODdCMzREcGVlcnBvbjIzMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2908034',
                                                                                                                                          'fiber_length': 516,
                                                                                                                                          'poller_hash': 'ODdCQTRFcGVlcnBvbjIzNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '5351991',
                                                                                                                                          'fiber_length': 999,
                                                                                                                                          'poller_hash': 'ODdCQTU1cGVlcnBvbjI1My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/1/gp1',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010106',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': False,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODdCMzQ5cGVlcmludGYyMjgvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:ca',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp2',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '40',
                                                                                         'out_octets': '3920',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2ExLzEvZ3Ay',
                                                                                         'pons': [       {       'id': '110010106',
                                                                                                                 'links': [       {       'connected_time': '13075336',
                                                                                                                                          'fiber_length': 223,
                                                                                                                                          'poller_hash': 'ODdCMzQ5cGVlcnBvbjIyOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.668897}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/1/gp2',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNhMTEwMDEwMTA2',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010107',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2434139',
                                                                                         'in_octets': '1208950147378',
                                                                                         'in_ucast_pkts': '4819016493',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '55774836841',
                                                                                                                  'in_octets': '56087604239',
                                                                                                                  'in_ucast_pkts': '312767398',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1529689147698',
                                                                                                                  'out_octets': '1530751155258',
                                                                                                                  'out_ucast_pkts': '1062007560',
                                                                                                                  'poller_hash': 'ODdCQTAycGVlcmludGY2My9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12541850932',
                                                                                                                  'in_octets': '12625353551',
                                                                                                                  'in_ucast_pkts': '83502619',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '263145872385',
                                                                                                                  'out_octets': '263362047486',
                                                                                                                  'out_ucast_pkts': '216175101',
                                                                                                                  'poller_hash': 'ODdCRUU2cGVlcmludGY3NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '45983706549',
                                                                                                                  'in_octets': '46249391212',
                                                                                                                  'in_ucast_pkts': '265684663',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1305346866741',
                                                                                                                  'out_octets': '1306255503495',
                                                                                                                  'out_ucast_pkts': '908636754',
                                                                                                                  'poller_hash': 'ODdCQTg5cGVlcmludGY3OC9ncDE='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCQTlCcGVlcmludGY3OS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '34885927657',
                                                                                                                  'in_octets': '35056680484',
                                                                                                                  'in_ucast_pkts': '170752827',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '445818581428',
                                                                                                                  'out_octets': '446143472972',
                                                                                                                  'out_ucast_pkts': '324891544',
                                                                                                                  'poller_hash': 'ODdCQTMwcGVlcmludGYxNDYvZ3Ax'},
                                                                                                          {       'in_errors': '6',
                                                                                                                  'in_nucast_pkts': '29850836760',
                                                                                                                  'in_octets': '30003062989',
                                                                                                                  'in_ucast_pkts': '152226229',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '368192831579',
                                                                                                                  'out_octets': '368493618907',
                                                                                                                  'out_ucast_pkts': '300787328',
                                                                                                                  'poller_hash': 'ODdCOUUycGVlcmludGYxNzQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '37799809514',
                                                                                                                  'in_octets': '37894992136',
                                                                                                                  'in_ucast_pkts': '95182622',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '324818183738',
                                                                                                                  'out_octets': '325105599640',
                                                                                                                  'out_ucast_pkts': '287415902',
                                                                                                                  'poller_hash': 'ODdCQTJCcGVlcmludGYxOTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '92012892392',
                                                                                                                  'in_octets': '92181686982',
                                                                                                                  'in_ucast_pkts': '168794590',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '337588261466',
                                                                                                                  'out_octets': '337862988135',
                                                                                                                  'out_ucast_pkts': '274726669',
                                                                                                                  'poller_hash': 'ODdCQUU2cGVlcmludGYyMTQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '14470318542',
                                                                                                                  'in_octets': '14557861709',
                                                                                                                  'in_ucast_pkts': '87543167',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '487042379501',
                                                                                                                  'out_octets': '487386343357',
                                                                                                                  'out_ucast_pkts': '343963856',
                                                                                                                  'poller_hash': 'ODdCQUVDcGVlcmludGYyMzcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '38765232051',
                                                                                                                  'in_octets': '38953424431',
                                                                                                                  'in_ucast_pkts': '188192380',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '558184691972',
                                                                                                                  'out_octets': '558585753288',
                                                                                                                  'out_ucast_pkts': '401061316',
                                                                                                                  'poller_hash': 'ODdCOUIwcGVlcmludGYyNDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9421034508',
                                                                                                                  'in_octets': '9448545097',
                                                                                                                  'in_ucast_pkts': '27510589',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '85683061701',
                                                                                                                  'out_octets': '85746607023',
                                                                                                                  'out_ucast_pkts': '63545322',
                                                                                                                  'poller_hash': 'ODdCOUNFcGVlcmludGYyNDYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '30482374637',
                                                                                                                  'in_octets': '30630998859',
                                                                                                                  'in_ucast_pkts': '148624222',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '598482503542',
                                                                                                                  'out_octets': '598920224800',
                                                                                                                  'out_ucast_pkts': '437721258',
                                                                                                                  'poller_hash': 'ODdCOUEwcGVlcmludGYyNzQvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:cb',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp3',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '10',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '1078',
                                                                                         'out_octets': '17357237112621',
                                                                                         'out_ucast_pkts': '12773779937',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2IxLzEvZ3Az',
                                                                                         'pons': [       {       'id': '110010107',
                                                                                                                 'links': [       {       'connected_time': '2907990',
                                                                                                                                          'fiber_length': 1065,
                                                                                                                                          'poller_hash': 'ODdCQTAycGVlcnBvbjYzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -7.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '4995983',
                                                                                                                                          'fiber_length': 1242,
                                                                                                                                          'poller_hash': 'ODdCRUU2cGVlcnBvbjc0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '5351981',
                                                                                                                                          'fiber_length': 1175,
                                                                                                                                          'poller_hash': 'ODdCQTg5cGVlcnBvbjc4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'poller_hash': 'ODdCQTlCcGVlcnBvbjc5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '5351985',
                                                                                                                                          'fiber_length': 1116,
                                                                                                                                          'poller_hash': 'ODdCQTMwcGVlcnBvbjE0Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '5351999',
                                                                                                                                          'fiber_length': 1234,
                                                                                                                                          'poller_hash': 'ODdCOUUycGVlcnBvbjE3NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '5352047',
                                                                                                                                          'fiber_length': 1290,
                                                                                                                                          'poller_hash': 'ODdCQTJCcGVlcnBvbjE5OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '1806981',
                                                                                                                                          'fiber_length': 1222,
                                                                                                                                          'poller_hash': 'ODdCQUU2cGVlcnBvbjIxNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '1380736',
                                                                                                                                          'fiber_length': 1111,
                                                                                                                                          'poller_hash': 'ODdCQUVDcGVlcnBvbjIzNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '3258587',
                                                                                                                                          'fiber_length': 1256,
                                                                                                                                          'poller_hash': 'ODdCOUIwcGVlcnBvbjI0MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '2306217',
                                                                                                                                          'fiber_length': 1328,
                                                                                                                                          'poller_hash': 'ODdCOUNFcGVlcnBvbjI0Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '5352006',
                                                                                                                                          'fiber_length': 1292,
                                                                                                                                          'poller_hash': 'ODdCOUEwcGVlcnBvbjI3NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/1/gp3',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNiMTEwMDEwMTA3',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010108',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '69711706',
                                                                                         'in_octets': '3880610699689',
                                                                                         'in_ucast_pkts': '11578470028',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '110409506298',
                                                                                                                  'in_octets': '110750631143',
                                                                                                                  'in_ucast_pkts': '341124845',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1245041801479',
                                                                                                                  'out_octets': '1245987765171',
                                                                                                                  'out_ucast_pkts': '945963692',
                                                                                                                  'poller_hash': 'ODdCOUVFcGVlcmludGY0Ny9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '29419365769',
                                                                                                                  'in_octets': '29510108313',
                                                                                                                  'in_ucast_pkts': '90742544',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '423273552059',
                                                                                                                  'out_octets': '423592382756',
                                                                                                                  'out_ucast_pkts': '318830697',
                                                                                                                  'poller_hash': 'ODdCOUVEcGVlcmludGY0OS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '345594501105',
                                                                                                                  'in_octets': '345911223132',
                                                                                                                  'in_ucast_pkts': '316722027',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '399268977648',
                                                                                                                  'out_octets': '399600525833',
                                                                                                                  'out_ucast_pkts': '331548185',
                                                                                                                  'poller_hash': 'ODdCOUU4cGVlcmludGY1MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '46217746986',
                                                                                                                  'in_octets': '46472173116',
                                                                                                                  'in_ucast_pkts': '254426130',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1365431048996',
                                                                                                                  'out_octets': '1366373228101',
                                                                                                                  'out_ucast_pkts': '942179105',
                                                                                                                  'poller_hash': 'ODdCQTAzcGVlcmludGY1NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '65328542730',
                                                                                                                  'in_octets': '65719983793',
                                                                                                                  'in_ucast_pkts': '391441063',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1597936986595',
                                                                                                                  'out_octets': '1599015513739',
                                                                                                                  'out_ucast_pkts': '1078527144',
                                                                                                                  'poller_hash': 'ODdCOUY2cGVlcmludGY1NS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '20013903867',
                                                                                                                  'in_octets': '20225962816',
                                                                                                                  'in_ucast_pkts': '212058949',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1458931306758',
                                                                                                                  'out_octets': '1459932234396',
                                                                                                                  'out_ucast_pkts': '1000927638',
                                                                                                                  'poller_hash': 'ODdCOEYwcGVlcmludGY2NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '43869263520',
                                                                                                                  'in_octets': '43935020501',
                                                                                                                  'in_ucast_pkts': '65756981',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '185472597110',
                                                                                                                  'out_octets': '185636889735',
                                                                                                                  'out_ucast_pkts': '164292625',
                                                                                                                  'poller_hash': 'ODdCRUVDcGVlcmludGY3MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23225203535',
                                                                                                                  'in_octets': '23462763243',
                                                                                                                  'in_ucast_pkts': '237559708',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '800134887019',
                                                                                                                  'out_octets': '800690829534',
                                                                                                                  'out_ucast_pkts': '555942515',
                                                                                                                  'poller_hash': 'ODdCRUU5cGVlcmludGY3NS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '19836561339',
                                                                                                                  'in_octets': '19926991262',
                                                                                                                  'in_ucast_pkts': '90429923',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '286921387126',
                                                                                                                  'out_octets': '287158022707',
                                                                                                                  'out_ucast_pkts': '236635581',
                                                                                                                  'poller_hash': 'ODdCQTFGcGVlcmludGY4Ny9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1574059656',
                                                                                                                  'in_octets': '1585437827',
                                                                                                                  'in_ucast_pkts': '11378171',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '33877471907',
                                                                                                                  'out_octets': '33901157346',
                                                                                                                  'out_ucast_pkts': '23685439',
                                                                                                                  'poller_hash': 'ODdCOEQ0cGVlcmludGYxMDkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10051814815',
                                                                                                                  'in_octets': '10143041519',
                                                                                                                  'in_ucast_pkts': '91226704',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '236946835150',
                                                                                                                  'out_octets': '237110502520',
                                                                                                                  'out_ucast_pkts': '163667370',
                                                                                                                  'poller_hash': 'ODdCQTM0cGVlcmludGYxNTMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '247795819537',
                                                                                                                  'in_octets': '248172674634',
                                                                                                                  'in_ucast_pkts': '376855097',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '666395362317',
                                                                                                                  'out_octets': '667015362292',
                                                                                                                  'out_ucast_pkts': '619999975',
                                                                                                                  'poller_hash': 'ODdCOURFcGVlcmludGYxNzAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '32196594792',
                                                                                                                  'in_octets': '32320170408',
                                                                                                                  'in_ucast_pkts': '123575616',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '754197832210',
                                                                                                                  'out_octets': '754749992097',
                                                                                                                  'out_ucast_pkts': '552159887',
                                                                                                                  'poller_hash': 'ODdCOUI1cGVlcmludGYyNjEvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:cc',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp4',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '13',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '3542',
                                                                                         'out_octets': '44532464200723',
                                                                                         'out_ucast_pkts': '32519522356',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0',
                                                                                         'pons': [       {       'id': '110010108',
                                                                                                                 'links': [       {       'connected_time': '2908002',
                                                                                                                                          'fiber_length': 1357,
                                                                                                                                          'poller_hash': 'ODdCOUVFcGVlcnBvbjQ3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2908007',
                                                                                                                                          'fiber_length': 1230,
                                                                                                                                          'poller_hash': 'ODdCOUVEcGVlcnBvbjQ5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2907999',
                                                                                                                                          'fiber_length': 1274,
                                                                                                                                          'poller_hash': 'ODdCOUU4cGVlcnBvbjUxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2908013',
                                                                                                                                          'fiber_length': 1378,
                                                                                                                                          'poller_hash': 'ODdCQTAzcGVlcnBvbjU0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2907984',
                                                                                                                                          'fiber_length': 1242,
                                                                                                                                          'poller_hash': 'ODdCOUY2cGVlcnBvbjU1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -8.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2402349',
                                                                                                                                          'fiber_length': 1175,
                                                                                                                                          'poller_hash': 'ODdCOEYwcGVlcnBvbjY0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2907975',
                                                                                                                                          'fiber_length': 1332,
                                                                                                                                          'poller_hash': 'ODdCRUVDcGVlcnBvbjcxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2908043',
                                                                                                                                          'fiber_length': 1369,
                                                                                                                                          'poller_hash': 'ODdCRUU5cGVlcnBvbjc1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '1601223',
                                                                                                                                          'fiber_length': 1357,
                                                                                                                                          'poller_hash': 'ODdCQTFGcGVlcnBvbjg3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '232417',
                                                                                                                                          'fiber_length': 1265,
                                                                                                                                          'poller_hash': 'ODdCOEQ0cGVlcnBvbjEwOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2908016',
                                                                                                                                          'fiber_length': 1344,
                                                                                                                                          'poller_hash': 'ODdCQTM0cGVlcnBvbjE1My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2908015',
                                                                                                                                          'fiber_length': 1365,
                                                                                                                                          'poller_hash': 'ODdCOURFcGVlcnBvbjE3MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '3033480',
                                                                                                                                          'fiber_length': 1197,
                                                                                                                                          'poller_hash': 'ODdCOUI1cGVlcnBvbjI2MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/1/gp4',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010109',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '436443',
                                                                                         'in_octets': '846503445615',
                                                                                         'in_ucast_pkts': '4382903718',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23138393185',
                                                                                                                  'in_octets': '23292697540',
                                                                                                                  'in_ucast_pkts': '154304355',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '508307869277',
                                                                                                                  'out_octets': '508685308761',
                                                                                                                  'out_ucast_pkts': '377439484',
                                                                                                                  'poller_hash': 'ODdCOUNCcGVlcmludGY1OC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5178450518',
                                                                                                                  'in_octets': '5217035699',
                                                                                                                  'in_ucast_pkts': '38585181',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '137858504048',
                                                                                                                  'out_octets': '137957706524',
                                                                                                                  'out_ucast_pkts': '99202476',
                                                                                                                  'poller_hash': 'ODdCQTZGcGVlcmludGY4My9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '14521540760',
                                                                                                                  'in_octets': '14567410310',
                                                                                                                  'in_ucast_pkts': '45869550',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '152691108851',
                                                                                                                  'out_octets': '152804097896',
                                                                                                                  'out_ucast_pkts': '112989045',
                                                                                                                  'poller_hash': 'ODdCOEEycGVlcmludGYxMDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '26285705507',
                                                                                                                  'in_octets': '26409204243',
                                                                                                                  'in_ucast_pkts': '123498736',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '847150353045',
                                                                                                                  'out_octets': '847759240208',
                                                                                                                  'out_ucast_pkts': '608887163',
                                                                                                                  'poller_hash': 'ODdCQTM5cGVlcmludGYxNDUvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOTNGcGVlcmludGYyNDgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '45047166304',
                                                                                                                  'in_octets': '45263265117',
                                                                                                                  'in_ucast_pkts': '216098813',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '715699183469',
                                                                                                                  'out_octets': '716247567416',
                                                                                                                  'out_ucast_pkts': '548383947',
                                                                                                                  'poller_hash': 'ODdCQUU3cGVlcmludGYyNTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11380074800',
                                                                                                                  'in_octets': '11453513252',
                                                                                                                  'in_ucast_pkts': '73438452',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '346377560657',
                                                                                                                  'out_octets': '346623614790',
                                                                                                                  'out_ucast_pkts': '246054133',
                                                                                                                  'poller_hash': 'ODdCN0Y0cGVlcmludGYyNjMvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:cd',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp5',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '6',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '607',
                                                                                         'out_octets': '17002187146402',
                                                                                         'out_ucast_pkts': '12247393581',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2QxLzEvZ3A1',
                                                                                         'pons': [       {       'id': '110010109',
                                                                                                                 'links': [       {       'connected_time': '5696037',
                                                                                                                                          'fiber_length': 1520,
                                                                                                                                          'poller_hash': 'ODdCOUNCcGVlcnBvbjU4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.689745},
                                                                                                                                  {       'connected_time': '761291',
                                                                                                                                          'fiber_length': 1451,
                                                                                                                                          'poller_hash': 'ODdCQTZGcGVlcnBvbjgzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.689745},
                                                                                                                                  {       'connected_time': '1514365',
                                                                                                                                          'fiber_length': 1402,
                                                                                                                                          'poller_hash': 'ODdCOEEycGVlcnBvbjEwMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.689745},
                                                                                                                                  {       'connected_time': '5696061',
                                                                                                                                          'fiber_length': 1516,
                                                                                                                                          'poller_hash': 'ODdCQTM5cGVlcnBvbjE0NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.689745},
                                                                                                                                  {       'poller_hash': 'ODdCOTNGcGVlcnBvbjI0OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.689745},
                                                                                                                                  {       'connected_time': '5590310',
                                                                                                                                          'fiber_length': 1451,
                                                                                                                                          'poller_hash': 'ODdCQUU3cGVlcnBvbjI1OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.689745},
                                                                                                                                  {       'connected_time': '679708',
                                                                                                                                          'fiber_length': 1488,
                                                                                                                                          'poller_hash': 'ODdCN0Y0cGVlcnBvbjI2My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -28.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.689745}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/1/gp5',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNkMTEwMDEwMTA5',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010110',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '132183',
                                                                                         'in_octets': '455685634780',
                                                                                         'in_ucast_pkts': '2620468145',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6520433516',
                                                                                                                  'in_octets': '6574771549',
                                                                                                                  'in_ucast_pkts': '54338033',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '341205354897',
                                                                                                                  'out_octets': '341441351161',
                                                                                                                  'out_ucast_pkts': '235996264',
                                                                                                                  'poller_hash': 'ODdCOUM0cGVlcmludGY0Ni9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1633370928',
                                                                                                                  'in_octets': '1643489308',
                                                                                                                  'in_ucast_pkts': '10118380',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '45593965247',
                                                                                                                  'out_octets': '45626770289',
                                                                                                                  'out_ucast_pkts': '32805042',
                                                                                                                  'poller_hash': 'ODdCQTQ3cGVlcmludGYxNTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5789378529',
                                                                                                                  'in_octets': '5825646679',
                                                                                                                  'in_ucast_pkts': '36268150',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '86636181979',
                                                                                                                  'out_octets': '86704418160',
                                                                                                                  'out_ucast_pkts': '68236181',
                                                                                                                  'poller_hash': 'ODdCMzM1cGVlcmludGYxNzkvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:ce',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp6',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '3',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '434',
                                                                                         'out_octets': '9797693344621',
                                                                                         'out_ucast_pkts': '6990971251',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2UxLzEvZ3A2',
                                                                                         'pons': [       {       'id': '110010110',
                                                                                                                 'links': [       {       'connected_time': '692014',
                                                                                                                                          'fiber_length': 1456,
                                                                                                                                          'poller_hash': 'ODdCOUM0cGVlcnBvbjQ2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737393},
                                                                                                                                  {       'connected_time': '300956',
                                                                                                                                          'fiber_length': 1323,
                                                                                                                                          'poller_hash': 'ODdCQTQ3cGVlcnBvbjE1Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737393},
                                                                                                                                  {       'connected_time': '484341',
                                                                                                                                          'fiber_length': 1459,
                                                                                                                                          'poller_hash': 'ODdCMzM1cGVlcnBvbjE3OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737393}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/1/gp6',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNlMTEwMDEwMTEw',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010111',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2896938',
                                                                                         'in_octets': '3097799705223',
                                                                                         'in_ucast_pkts': '6242753667',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '34105741822',
                                                                                                                  'in_octets': '34340532216',
                                                                                                                  'in_ucast_pkts': '234790394',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '908751354807',
                                                                                                                  'out_octets': '909415017317',
                                                                                                                  'out_ucast_pkts': '663662510',
                                                                                                                  'poller_hash': 'ODdCOUYxcGVlcmludGY0OC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '51518498594',
                                                                                                                  'in_octets': '51755018596',
                                                                                                                  'in_ucast_pkts': '236520002',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1267943192010',
                                                                                                                  'out_octets': '1268827529006',
                                                                                                                  'out_ucast_pkts': '884336996',
                                                                                                                  'poller_hash': 'ODdCQTI0cGVlcmludGY4MC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': False,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODdCQUIxcGVlcmludGY4Mi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6686019306',
                                                                                                                  'in_octets': '6717637475',
                                                                                                                  'in_ucast_pkts': '31618169',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '120635335222',
                                                                                                                  'out_octets': '120737553803',
                                                                                                                  'out_ucast_pkts': '102218581',
                                                                                                                  'poller_hash': 'ODdCQTI2cGVlcmludGYxMTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10409026487',
                                                                                                                  'in_octets': '10475759810',
                                                                                                                  'in_ucast_pkts': '66733323',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '319301173401',
                                                                                                                  'out_octets': '319531140664',
                                                                                                                  'out_ucast_pkts': '229967263',
                                                                                                                  'poller_hash': 'ODdCQTRGcGVlcmludGYxNDcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3554749345',
                                                                                                                  'in_octets': '3573156740',
                                                                                                                  'in_ucast_pkts': '18407395',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '64276075808',
                                                                                                                  'out_octets': '64331157079',
                                                                                                                  'out_ucast_pkts': '55081271',
                                                                                                                  'poller_hash': 'ODdCOUU0cGVlcmludGYxNzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '211276777933',
                                                                                                                  'in_octets': '211462936772',
                                                                                                                  'in_ucast_pkts': '186158839',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '174630848421',
                                                                                                                  'out_octets': '174843735155',
                                                                                                                  'out_ucast_pkts': '212886734',
                                                                                                                  'poller_hash': 'ODdCRUQ5cGVlcmludGYyMTMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23395595587',
                                                                                                                  'in_octets': '23577287612',
                                                                                                                  'in_ucast_pkts': '181692025',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '867163289377',
                                                                                                                  'out_octets': '867777535960',
                                                                                                                  'out_ucast_pkts': '614246583',
                                                                                                                  'poller_hash': 'ODdCMzJDcGVlcmludGYyNTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '64545344504',
                                                                                                                  'in_octets': '64959413843',
                                                                                                                  'in_ucast_pkts': '414069339',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1297004310437',
                                                                                                                  'out_octets': '1297945913089',
                                                                                                                  'out_ucast_pkts': '941602652',
                                                                                                                  'poller_hash': 'ODdCOUQ2cGVlcmludGYyNzIvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:cf',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp7',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '8',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '1401',
                                                                                         'out_octets': '20136341864843',
                                                                                         'out_ucast_pkts': '15417048552',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2YxLzEvZ3A3',
                                                                                         'pons': [       {       'id': '110010111',
                                                                                                                 'links': [       {       'connected_time': '5351998',
                                                                                                                                          'fiber_length': 1340,
                                                                                                                                          'poller_hash': 'ODdCOUYxcGVlcnBvbjQ4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.640817},
                                                                                                                                  {       'connected_time': '5351981',
                                                                                                                                          'fiber_length': 1145,
                                                                                                                                          'poller_hash': 'ODdCQTI0cGVlcnBvbjgwL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.640817},
                                                                                                                                  {       'connected_time': '905102',
                                                                                                                                          'fiber_length': 1339,
                                                                                                                                          'poller_hash': 'ODdCQUIxcGVlcnBvbjgyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.640817},
                                                                                                                                  {       'connected_time': '5352007',
                                                                                                                                          'fiber_length': 1271,
                                                                                                                                          'poller_hash': 'ODdCQTI2cGVlcnBvbjExOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.640817},
                                                                                                                                  {       'connected_time': '512364',
                                                                                                                                          'fiber_length': 1369,
                                                                                                                                          'poller_hash': 'ODdCQTRGcGVlcnBvbjE0Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.640817},
                                                                                                                                  {       'connected_time': '5351983',
                                                                                                                                          'fiber_length': 1125,
                                                                                                                                          'poller_hash': 'ODdCOUU0cGVlcnBvbjE3Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.640817},
                                                                                                                                  {       'connected_time': '895715',
                                                                                                                                          'fiber_length': 1272,
                                                                                                                                          'poller_hash': 'ODdCRUQ5cGVlcnBvbjIxMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.640817},
                                                                                                                                  {       'connected_time': '5352043',
                                                                                                                                          'fiber_length': 1383,
                                                                                                                                          'poller_hash': 'ODdCMzJDcGVlcnBvbjI1OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.640817},
                                                                                                                                  {       'connected_time': '5352038',
                                                                                                                                          'fiber_length': 1148,
                                                                                                                                          'poller_hash': 'ODdCOUQ2cGVlcnBvbjI3Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.640817}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/1/gp7',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNmMTEwMDEwMTEx',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010112',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '526806',
                                                                                         'in_octets': '898663623895',
                                                                                         'in_ucast_pkts': '3853335097',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '32984859770',
                                                                                                                  'in_octets': '33207453738',
                                                                                                                  'in_ucast_pkts': '222593968',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '759914587042',
                                                                                                                  'out_octets': '760532808128',
                                                                                                                  'out_ucast_pkts': '618221086',
                                                                                                                  'poller_hash': 'ODdCQTA2cGVlcmludGY1Ny9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '48400289221',
                                                                                                                  'in_octets': '48607604843',
                                                                                                                  'in_ucast_pkts': '207315622',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1156362086182',
                                                                                                                  'out_octets': '1157265640709',
                                                                                                                  'out_ucast_pkts': '903554527',
                                                                                                                  'poller_hash': 'ODdCQTA1cGVlcmludGY2MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '34648217472',
                                                                                                                  'in_octets': '34796819724',
                                                                                                                  'in_ucast_pkts': '148602252',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1382313447793',
                                                                                                                  'out_octets': '1383297527858',
                                                                                                                  'out_ucast_pkts': '984080065',
                                                                                                                  'poller_hash': 'ODdCNEI4cGVlcmludGY2NS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4595914201',
                                                                                                                  'in_octets': '4633574019',
                                                                                                                  'in_ucast_pkts': '37659818',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '338291897873',
                                                                                                                  'out_octets': '338522777135',
                                                                                                                  'out_ucast_pkts': '230879262',
                                                                                                                  'poller_hash': 'ODdCQTFCcGVlcmludGY4NC9ncDE='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCQTIycGVlcmludGY4NS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1775981151',
                                                                                                                  'in_octets': '1787301560',
                                                                                                                  'in_ucast_pkts': '11320409',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '33908880338',
                                                                                                                  'out_octets': '33932785715',
                                                                                                                  'out_ucast_pkts': '23905377',
                                                                                                                  'poller_hash': 'ODdCOTBCcGVlcmludGY4OS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '148918348030',
                                                                                                                  'in_octets': '149513728861',
                                                                                                                  'in_ucast_pkts': '595380831',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1572859143333',
                                                                                                                  'out_octets': '1574054319018',
                                                                                                                  'out_ucast_pkts': '1195175685',
                                                                                                                  'poller_hash': 'ODdCQTU3cGVlcmludGYxNDgvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOUEzcGVlcmludGYxNzMvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCMkE0cGVlcmludGYyMTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '26563296014',
                                                                                                                  'in_octets': '26684584392',
                                                                                                                  'in_ucast_pkts': '121288378',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '411187832510',
                                                                                                                  'out_octets': '411476973395',
                                                                                                                  'out_ucast_pkts': '289140885',
                                                                                                                  'poller_hash': 'ODdCOUFEcGVlcmludGYyNjUvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOUFDcGVlcmludGYyNjYvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:d0',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp8',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '9',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '5245',
                                                                                         'out_octets': '16542526416578',
                                                                                         'out_ucast_pkts': '12136931949',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4',
                                                                                         'pons': [       {       'id': '110010112',
                                                                                                                 'links': [       {       'connected_time': '5352005',
                                                                                                                                          'fiber_length': 1447,
                                                                                                                                          'poller_hash': 'ODdCQTA2cGVlcnBvbjU3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117},
                                                                                                                                  {       'connected_time': '5352037',
                                                                                                                                          'fiber_length': 1417,
                                                                                                                                          'poller_hash': 'ODdCQTA1cGVlcnBvbjYxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117},
                                                                                                                                  {       'connected_time': '5351977',
                                                                                                                                          'fiber_length': 1198,
                                                                                                                                          'poller_hash': 'ODdCNEI4cGVlcnBvbjY1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117},
                                                                                                                                  {       'connected_time': '1648401',
                                                                                                                                          'fiber_length': 1227,
                                                                                                                                          'poller_hash': 'ODdCQTFCcGVlcnBvbjg0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117},
                                                                                                                                  {       'poller_hash': 'ODdCQTIycGVlcnBvbjg1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117},
                                                                                                                                  {       'connected_time': '181230',
                                                                                                                                          'fiber_length': 1286,
                                                                                                                                          'poller_hash': 'ODdCOTBCcGVlcnBvbjg5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117},
                                                                                                                                  {       'connected_time': '4559959',
                                                                                                                                          'fiber_length': 1359,
                                                                                                                                          'poller_hash': 'ODdCQTU3cGVlcnBvbjE0OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117},
                                                                                                                                  {       'poller_hash': 'ODdCOUEzcGVlcnBvbjE3My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117},
                                                                                                                                  {       'poller_hash': 'ODdCMkE0cGVlcnBvbjIxMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117},
                                                                                                                                  {       'connected_time': '5352015',
                                                                                                                                          'fiber_length': 1392,
                                                                                                                                          'poller_hash': 'ODdCOUFEcGVlcnBvbjI2NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117},
                                                                                                                                  {       'poller_hash': 'ODdCOUFDcGVlcnBvbjI2Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.690117}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/1/gp8',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'mem': 48.0,
                                                           'model': 'GPON-8 r2',
                                                           'name': '1/1',
                                                           'poller_hash': 'NDcyMDA2MDE5MzA1',
                                                           'serial_number': '472006019305',
                                                           'sw_version': '23.2.0',
                                                           'temperature': 23.5,
                                                           'uptime': '13074600'},
                                                   {       'cpu': 25.0,
                                                           'id': '1/2',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '120000101',
                                                                                         'mac_address': '48:77:46:53:46:1d',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MWQxLzIvZzE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000102',
                                                                                         'mac_address': '48:77:46:53:46:1e',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MWUxLzIvZzI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000103',
                                                                                         'mac_address': '48:77:46:53:46:1f',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MWYxLzIvZzM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000104',
                                                                                         'mac_address': '48:77:46:53:46:20',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MjAxLzIvZzQ='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000105',
                                                                                         'mac_address': '48:77:46:53:46:21',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MjExLzIvZzU='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000106',
                                                                                         'mac_address': '48:77:46:53:46:22',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MjIxLzIvZzY='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000107',
                                                                                         'mac_address': '48:77:46:53:46:23',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MjMxLzIvZzc='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000108',
                                                                                         'mac_address': '48:77:46:53:46:24',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MjQxLzIvZzg='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010101',
                                                                                         'mac_address': '48:77:46:53:46:0d',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MGQxLzIveDE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010102',
                                                                                         'mac_address': '48:77:46:53:46:0e',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MGUxLzIveDI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010103',
                                                                                         'mac_address': '48:77:46:53:46:0f',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MGYxLzIveDM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010104',
                                                                                         'mac_address': '48:77:46:53:46:10',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTAxLzIveDQ='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010105',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '679745',
                                                                                         'in_octets': '1725294035009',
                                                                                         'in_ucast_pkts': '9385138700',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10907800459',
                                                                                                                  'in_octets': '10956834303',
                                                                                                                  'in_ucast_pkts': '49033844',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '222309058641',
                                                                                                                  'out_octets': '222480237271',
                                                                                                                  'out_ucast_pkts': '171178630',
                                                                                                                  'poller_hash': 'ODdCQTIzcGVlcmludGY4Ni9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '39120229349',
                                                                                                                  'in_octets': '39288734457',
                                                                                                                  'in_ucast_pkts': '168505108',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '434888344822',
                                                                                                                  'out_octets': '435211914118',
                                                                                                                  'out_ucast_pkts': '323569296',
                                                                                                                  'poller_hash': 'ODdCOUZGcGVlcmludGY5MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4777829540',
                                                                                                                  'in_octets': '4811993229',
                                                                                                                  'in_ucast_pkts': '34163689',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '161615072142',
                                                                                                                  'out_octets': '161725789956',
                                                                                                                  'out_ucast_pkts': '110717814',
                                                                                                                  'poller_hash': 'ODdCN0ZGcGVlcmludGY5NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '52114281488',
                                                                                                                  'in_octets': '52474307871',
                                                                                                                  'in_ucast_pkts': '360026383',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1058078576532',
                                                                                                                  'out_octets': '1058837701547',
                                                                                                                  'out_ucast_pkts': '759125015',
                                                                                                                  'poller_hash': 'ODdCQTI3cGVlcmludGY5Ni9ncDE='},
                                                                                                          {       'in_errors': '1',
                                                                                                                  'in_nucast_pkts': '16652303508',
                                                                                                                  'in_octets': '16817503023',
                                                                                                                  'in_ucast_pkts': '165199515',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '636202164198',
                                                                                                                  'out_octets': '636638136890',
                                                                                                                  'out_ucast_pkts': '435972692',
                                                                                                                  'poller_hash': 'ODdCODBFcGVlcmludGY5OS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '122877930802',
                                                                                                                  'in_octets': '123069180550',
                                                                                                                  'in_ucast_pkts': '191249748',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1088579656932',
                                                                                                                  'out_octets': '1089405053622',
                                                                                                                  'out_ucast_pkts': '825396690',
                                                                                                                  'poller_hash': 'ODdCRURGcGVlcmludGYxMDUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4014898255',
                                                                                                                  'in_octets': '4020711683',
                                                                                                                  'in_ucast_pkts': '5813428',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '10271328258',
                                                                                                                  'out_octets': '10281307361',
                                                                                                                  'out_ucast_pkts': '9979103',
                                                                                                                  'poller_hash': 'ODdCNzcwcGVlcmludGYxNzcvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOURBcGVlcmludGYxOTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7696667668',
                                                                                                                  'in_octets': '7729636754',
                                                                                                                  'in_ucast_pkts': '32969086',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '69904429689',
                                                                                                                  'out_octets': '69965439677',
                                                                                                                  'out_ucast_pkts': '61009988',
                                                                                                                  'poller_hash': 'ODdCOUQzcGVlcmludGYyMDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '8210585014',
                                                                                                                  'in_octets': '8277259082',
                                                                                                                  'in_ucast_pkts': '66674068',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '257968745786',
                                                                                                                  'out_octets': '258151570279',
                                                                                                                  'out_ucast_pkts': '182824493',
                                                                                                                  'poller_hash': 'ODdCOTlFcGVlcmludGYyNTUvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:11',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '441',
                                                                                         'out_octets': '31920257434431',
                                                                                         'out_ucast_pkts': '22711573397',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax',
                                                                                         'pons': [       {       'id': '120010105',
                                                                                                                 'links': [       {       'connected_time': '5696025',
                                                                                                                                          'fiber_length': 1541,
                                                                                                                                          'poller_hash': 'ODdCQTIzcGVlcnBvbjg2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '1114752',
                                                                                                                                          'fiber_length': 1272,
                                                                                                                                          'poller_hash': 'ODdCOUZGcGVlcnBvbjkxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '231076',
                                                                                                                                          'fiber_length': 1338,
                                                                                                                                          'poller_hash': 'ODdCN0ZGcGVlcnBvbjk0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '4096875',
                                                                                                                                          'fiber_length': 1337,
                                                                                                                                          'poller_hash': 'ODdCQTI3cGVlcnBvbjk2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '567038',
                                                                                                                                          'fiber_length': 1279,
                                                                                                                                          'poller_hash': 'ODdCODBFcGVlcnBvbjk5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '5696023',
                                                                                                                                          'fiber_length': 1369,
                                                                                                                                          'poller_hash': 'ODdCRURGcGVlcnBvbjEwNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '5696066',
                                                                                                                                          'fiber_length': 1395,
                                                                                                                                          'poller_hash': 'ODdCNzcwcGVlcnBvbjE3Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'poller_hash': 'ODdCOURBcGVlcnBvbjE5MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '5696051',
                                                                                                                                          'fiber_length': 1334,
                                                                                                                                          'poller_hash': 'ODdCOUQzcGVlcnBvbjIwMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '1710427',
                                                                                                                                          'fiber_length': 1370,
                                                                                                                                          'poller_hash': 'ODdCOTlFcGVlcnBvbjI1NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp1',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010106',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1929570',
                                                                                         'in_octets': '878070897235',
                                                                                         'in_ucast_pkts': '2905904640',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '59133334969',
                                                                                                                  'in_octets': '59375237682',
                                                                                                                  'in_ucast_pkts': '241902713',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '784450992701',
                                                                                                                  'out_octets': '785028457281',
                                                                                                                  'out_ucast_pkts': '577464580',
                                                                                                                  'poller_hash': 'ODdCQTNBcGVlcmludGYxMzQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7526497139',
                                                                                                                  'in_octets': '7556707684',
                                                                                                                  'in_ucast_pkts': '30210545',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '65073087391',
                                                                                                                  'out_octets': '65130457611',
                                                                                                                  'out_ucast_pkts': '57370220',
                                                                                                                  'poller_hash': 'ODdCOTZFcGVlcmludGYxMzUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9053999205',
                                                                                                                  'in_octets': '9100717926',
                                                                                                                  'in_ucast_pkts': '46718721',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '219180470462',
                                                                                                                  'out_octets': '219338364243',
                                                                                                                  'out_ucast_pkts': '157893781',
                                                                                                                  'poller_hash': 'ODdCQTMzcGVlcmludGYxNTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '246782231034',
                                                                                                                  'in_octets': '247270515982',
                                                                                                                  'in_ucast_pkts': '488284948',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1950989068215',
                                                                                                                  'out_octets': '1952550101204',
                                                                                                                  'out_ucast_pkts': '1561032989',
                                                                                                                  'poller_hash': 'ODdCOTAycGVlcmludGYxNjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9053634508',
                                                                                                                  'in_octets': '9099271319',
                                                                                                                  'in_ucast_pkts': '45636811',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '172788212851',
                                                                                                                  'out_octets': '172920493853',
                                                                                                                  'out_ucast_pkts': '132281002',
                                                                                                                  'poller_hash': 'ODdCOUQ1cGVlcmludGYxNjUvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOUMwcGVlcmludGYxODYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '180479220',
                                                                                                                  'in_octets': '180864764',
                                                                                                                  'in_ucast_pkts': '385544',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '277772960',
                                                                                                                  'out_octets': '278519217',
                                                                                                                  'out_ucast_pkts': '746257',
                                                                                                                  'poller_hash': 'ODdCODdCcGVlcmludGYyMDIvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCQUUwcGVlcmludGYyNDcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '140269288',
                                                                                                                  'in_octets': '140556317',
                                                                                                                  'in_ucast_pkts': '287029',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '216017145',
                                                                                                                  'out_octets': '216695432',
                                                                                                                  'out_ucast_pkts': '678287',
                                                                                                                  'poller_hash': 'ODdCQTJEcGVlcmludGYyNjIvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:12',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp2',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '721',
                                                                                         'out_octets': '10800194566754',
                                                                                         'out_ucast_pkts': '8160847395',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTIxLzIvZ3Ay',
                                                                                         'pons': [       {       'id': '120010106',
                                                                                                                 'links': [       {       'connected_time': '2908008',
                                                                                                                                          'fiber_length': 488,
                                                                                                                                          'poller_hash': 'ODdCQTNBcGVlcnBvbjEzNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '2907990',
                                                                                                                                          'fiber_length': 598,
                                                                                                                                          'poller_hash': 'ODdCOTZFcGVlcnBvbjEzNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '2908019',
                                                                                                                                          'fiber_length': 543,
                                                                                                                                          'poller_hash': 'ODdCQTMzcGVlcnBvbjE1Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '7138905',
                                                                                                                                          'fiber_length': 470,
                                                                                                                                          'poller_hash': 'ODdCOTAycGVlcnBvbjE2MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '2908015',
                                                                                                                                          'fiber_length': 641,
                                                                                                                                          'poller_hash': 'ODdCOUQ1cGVlcnBvbjE2NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'poller_hash': 'ODdCOUMwcGVlcnBvbjE4Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '2908030',
                                                                                                                                          'fiber_length': 594,
                                                                                                                                          'poller_hash': 'ODdCODdCcGVlcnBvbjIwMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'poller_hash': 'ODdCQUUwcGVlcnBvbjI0Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '2908036',
                                                                                                                                          'fiber_length': 534,
                                                                                                                                          'poller_hash': 'ODdCQTJEcGVlcnBvbjI2Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp2',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjEyMTIwMDEwMTA2',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010107',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '3171289',
                                                                                         'in_octets': '188360313113',
                                                                                         'in_ucast_pkts': '998703136',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '18771885679',
                                                                                                                  'in_octets': '18836841413',
                                                                                                                  'in_ucast_pkts': '64955734',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '228130445099',
                                                                                                                  'out_octets': '228315805549',
                                                                                                                  'out_ucast_pkts': '185360450',
                                                                                                                  'poller_hash': 'ODdCODk5cGVlcmludGYxNDkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '564333397',
                                                                                                                  'in_octets': '567128809',
                                                                                                                  'in_ucast_pkts': '2795412',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6969261115',
                                                                                                                  'out_octets': '6975356635',
                                                                                                                  'out_ucast_pkts': '6095520',
                                                                                                                  'poller_hash': 'ODdCOTAxcGVlcmludGYxNjIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '200226889',
                                                                                                                  'in_octets': '200752438',
                                                                                                                  'in_ucast_pkts': '525549',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '133049598',
                                                                                                                  'out_octets': '133539558',
                                                                                                                  'out_ucast_pkts': '489960',
                                                                                                                  'poller_hash': 'ODdCOUNGcGVlcmludGYxOTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '26900987999',
                                                                                                                  'in_octets': '27047221322',
                                                                                                                  'in_ucast_pkts': '146233323',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '979016976770',
                                                                                                                  'out_octets': '979686912840',
                                                                                                                  'out_ucast_pkts': '669936070',
                                                                                                                  'poller_hash': 'ODdCOUNEcGVlcmludGYyNjcvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:13',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp3',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '759',
                                                                                         'out_octets': '4512639325382',
                                                                                         'out_ucast_pkts': '3225295603',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTMxLzIvZ3Az',
                                                                                         'pons': [       {       'id': '120010107',
                                                                                                                 'links': [       {       'connected_time': '2812196',
                                                                                                                                          'fiber_length': 582,
                                                                                                                                          'poller_hash': 'ODdCODk5cGVlcnBvbjE0OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719171},
                                                                                                                                  {       'connected_time': '2908008',
                                                                                                                                          'fiber_length': 563,
                                                                                                                                          'poller_hash': 'ODdCOTAxcGVlcnBvbjE2Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719171},
                                                                                                                                  {       'connected_time': '941530',
                                                                                                                                          'fiber_length': 516,
                                                                                                                                          'poller_hash': 'ODdCOUNGcGVlcnBvbjE5MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719171},
                                                                                                                                  {       'connected_time': '2908028',
                                                                                                                                          'fiber_length': 568,
                                                                                                                                          'poller_hash': 'ODdCOUNEcGVlcnBvbjI2Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719171}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp3',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjEzMTIwMDEwMTA3',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010108',
                                                                                         'in_discards': '2',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '181490',
                                                                                         'in_octets': '133645326739',
                                                                                         'in_ucast_pkts': '539478402',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '17888250400',
                                                                                                                  'in_octets': '17933438722',
                                                                                                                  'in_ucast_pkts': '45188322',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '102710451215',
                                                                                                                  'out_octets': '102804242053',
                                                                                                                  'out_ucast_pkts': '93790838',
                                                                                                                  'poller_hash': 'ODdCN0Y1cGVlcmludGYxNTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1612639294',
                                                                                                                  'in_octets': '1624309797',
                                                                                                                  'in_ucast_pkts': '11670503',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '26865760702',
                                                                                                                  'out_octets': '26887895067',
                                                                                                                  'out_ucast_pkts': '22134365',
                                                                                                                  'poller_hash': 'ODdCN0E4cGVlcmludGYxNTkvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'N0Q5RjJDcGVlcmludGYxODkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '2393052987',
                                                                                                                  'in_octets': '2401604653',
                                                                                                                  'in_ucast_pkts': '8551666',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '18665656951',
                                                                                                                  'out_octets': '18680740908',
                                                                                                                  'out_ucast_pkts': '15083957',
                                                                                                                  'poller_hash': 'ODdCQUVEcGVlcmludGYxOTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '361812697',
                                                                                                                  'in_octets': '363068561',
                                                                                                                  'in_ucast_pkts': '1255864',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1551995241',
                                                                                                                  'out_octets': '1554067331',
                                                                                                                  'out_ucast_pkts': '2072090',
                                                                                                                  'poller_hash': 'ODdCQTQzcGVlcmludGYyMDEvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCM0RCcGVlcmludGYyNjAvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:14',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp4',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '2732',
                                                                                         'out_octets': '1363155423713',
                                                                                         'out_ucast_pkts': '1107952112',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTQxLzIvZ3A0',
                                                                                         'pons': [       {       'id': '120010108',
                                                                                                                 'links': [       {       'connected_time': '2908006',
                                                                                                                                          'fiber_length': 680,
                                                                                                                                          'poller_hash': 'ODdCN0Y1cGVlcnBvbjE1MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.788701},
                                                                                                                                  {       'connected_time': '2908007',
                                                                                                                                          'fiber_length': 683,
                                                                                                                                          'poller_hash': 'ODdCN0E4cGVlcnBvbjE1OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.788701},
                                                                                                                                  {       'poller_hash': 'N0Q5RjJDcGVlcnBvbjE4OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.788701},
                                                                                                                                  {       'connected_time': '2908021',
                                                                                                                                          'fiber_length': 716,
                                                                                                                                          'poller_hash': 'ODdCQUVEcGVlcnBvbjE5Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.788701},
                                                                                                                                  {       'connected_time': '2908001',
                                                                                                                                          'fiber_length': 768,
                                                                                                                                          'poller_hash': 'ODdCQTQzcGVlcnBvbjIwMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.788701},
                                                                                                                                  {       'poller_hash': 'ODdCM0RCcGVlcnBvbjI2MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.788701}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp4',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjE0MTIwMDEwMTA4',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010109',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '856509',
                                                                                         'in_octets': '2295409177171',
                                                                                         'in_ucast_pkts': '9844714303',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11353694259',
                                                                                                                  'in_octets': '11387254738',
                                                                                                                  'in_ucast_pkts': '33560479',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '163158983444',
                                                                                                                  'out_octets': '163287279029',
                                                                                                                  'out_ucast_pkts': '128295585',
                                                                                                                  'poller_hash': 'ODdCODQ5cGVlcmludGY5OC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': False,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODdCODlCcGVlcmludGYxMDIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '8206035896',
                                                                                                                  'in_octets': '8228586492',
                                                                                                                  'in_ucast_pkts': '22550596',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '95386499388',
                                                                                                                  'out_octets': '95465229342',
                                                                                                                  'out_ucast_pkts': '78729954',
                                                                                                                  'poller_hash': 'ODdCODVFcGVlcmludGYxMDMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4791685494',
                                                                                                                  'in_octets': '4818099780',
                                                                                                                  'in_ucast_pkts': '26414286',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '156903193101',
                                                                                                                  'out_octets': '157016311987',
                                                                                                                  'out_ucast_pkts': '113118886',
                                                                                                                  'poller_hash': 'ODdCODc0cGVlcmludGYxMDgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9775470928',
                                                                                                                  'in_octets': '9834953189',
                                                                                                                  'in_ucast_pkts': '59482261',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '520272602170',
                                                                                                                  'out_octets': '520635732457',
                                                                                                                  'out_ucast_pkts': '363130287',
                                                                                                                  'poller_hash': 'ODdCOEJGcGVlcmludGYxMTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6547827097',
                                                                                                                  'in_octets': '6577951329',
                                                                                                                  'in_ucast_pkts': '30124232',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '179690853897',
                                                                                                                  'out_octets': '179827653248',
                                                                                                                  'out_ucast_pkts': '136799351',
                                                                                                                  'poller_hash': 'ODdCN0U1cGVlcmludGYxMjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '8700318290',
                                                                                                                  'in_octets': '8769170573',
                                                                                                                  'in_ucast_pkts': '68852283',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '263268005766',
                                                                                                                  'out_octets': '263485396183',
                                                                                                                  'out_ucast_pkts': '217390417',
                                                                                                                  'poller_hash': 'ODdCODc1cGVlcmludGYxMjIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '145114823',
                                                                                                                  'in_octets': '145345005',
                                                                                                                  'in_ucast_pkts': '230182',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '138591462',
                                                                                                                  'out_octets': '139182580',
                                                                                                                  'out_ucast_pkts': '591118',
                                                                                                                  'poller_hash': 'ODdCOTNEcGVlcmludGYxMjMvZ3Ax'},
                                                                                                          {       'in_errors': '1',
                                                                                                                  'in_nucast_pkts': '65799952802',
                                                                                                                  'in_octets': '66123401859',
                                                                                                                  'in_ucast_pkts': '323449057',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1257329737583',
                                                                                                                  'out_octets': '1258226538474',
                                                                                                                  'out_ucast_pkts': '896800891',
                                                                                                                  'poller_hash': 'ODdCQTQxcGVlcmludGYxMzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '58338812175',
                                                                                                                  'in_octets': '58440712054',
                                                                                                                  'in_ucast_pkts': '101899879',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '162393179079',
                                                                                                                  'out_octets': '162525766842',
                                                                                                                  'out_ucast_pkts': '132587763',
                                                                                                                  'poller_hash': 'ODdCOUUwcGVlcmludGYxNjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '8457351755',
                                                                                                                  'in_octets': '8514368489',
                                                                                                                  'in_ucast_pkts': '57016734',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '221727226033',
                                                                                                                  'out_octets': '221890434968',
                                                                                                                  'out_ucast_pkts': '163208935',
                                                                                                                  'poller_hash': 'ODdCOURCcGVlcmludGYxODIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '73679242673',
                                                                                                                  'in_octets': '73977540386',
                                                                                                                  'in_ucast_pkts': '298297713',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1367320467685',
                                                                                                                  'out_octets': '1368332174051',
                                                                                                                  'out_ucast_pkts': '1011706366',
                                                                                                                  'poller_hash': 'ODdCMUE4cGVlcmludGYyMzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '492078163',
                                                                                                                  'in_octets': '494232866',
                                                                                                                  'in_ucast_pkts': '2154703',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '808450000',
                                                                                                                  'out_octets': '811050960',
                                                                                                                  'out_ucast_pkts': '2600960',
                                                                                                                  'poller_hash': 'ODdCOUQ0cGVlcmludGYyNTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '59312984758',
                                                                                                                  'in_octets': '60073877684',
                                                                                                                  'in_ucast_pkts': '760892926',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2222525311366',
                                                                                                                  'out_octets': '2224010434191',
                                                                                                                  'out_ucast_pkts': '1485122825',
                                                                                                                  'poller_hash': 'ODdCOTk5cGVlcmludGYyNTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '35576666798',
                                                                                                                  'in_octets': '35954477898',
                                                                                                                  'in_ucast_pkts': '377811100',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1274000105097',
                                                                                                                  'out_octets': '1274875764736',
                                                                                                                  'out_ucast_pkts': '875659639',
                                                                                                                  'poller_hash': 'ODdCQTM4cGVlcmludGYyNTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13955375485',
                                                                                                                  'in_octets': '14048691611',
                                                                                                                  'in_ucast_pkts': '93316126',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '332521609188',
                                                                                                                  'out_octets': '332763289910',
                                                                                                                  'out_ucast_pkts': '241680722',
                                                                                                                  'poller_hash': 'ODdCQUQ0cGVlcmludGYyNTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '55313482',
                                                                                                                  'out_octets': '55321928',
                                                                                                                  'out_ucast_pkts': '8446',
                                                                                                                  'poller_hash': 'ODdCOTkzcGVlcmludGYyNjQvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:15',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp5',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '3178',
                                                                                         'out_octets': '34240772386542',
                                                                                         'out_ucast_pkts': '24658127260',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1',
                                                                                         'pons': [       {       'id': '120010109',
                                                                                                                 'links': [       {       'connected_time': '2908019',
                                                                                                                                          'fiber_length': 890,
                                                                                                                                          'poller_hash': 'ODdCODQ5cGVlcnBvbjk4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2908008',
                                                                                                                                          'fiber_length': 1015,
                                                                                                                                          'poller_hash': 'ODdCODlCcGVlcnBvbjEwMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2908029',
                                                                                                                                          'fiber_length': 1081,
                                                                                                                                          'poller_hash': 'ODdCODVFcGVlcnBvbjEwMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2907982',
                                                                                                                                          'fiber_length': 940,
                                                                                                                                          'poller_hash': 'ODdCODc0cGVlcnBvbjEwOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2908018',
                                                                                                                                          'fiber_length': 993,
                                                                                                                                          'poller_hash': 'ODdCOEJGcGVlcnBvbjExMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '1622791',
                                                                                                                                          'fiber_length': 972,
                                                                                                                                          'poller_hash': 'ODdCN0U1cGVlcnBvbjEyMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '1199658',
                                                                                                                                          'fiber_length': 1136,
                                                                                                                                          'poller_hash': 'ODdCODc1cGVlcnBvbjEyMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2907998',
                                                                                                                                          'fiber_length': 877,
                                                                                                                                          'poller_hash': 'ODdCOTNEcGVlcnBvbjEyMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2908008',
                                                                                                                                          'fiber_length': 1042,
                                                                                                                                          'poller_hash': 'ODdCQTQxcGVlcnBvbjEzNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '1527484',
                                                                                                                                          'fiber_length': 1089,
                                                                                                                                          'poller_hash': 'ODdCOUUwcGVlcnBvbjE2NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '1358298',
                                                                                                                                          'fiber_length': 1015,
                                                                                                                                          'poller_hash': 'ODdCOURCcGVlcnBvbjE4Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2907999',
                                                                                                                                          'fiber_length': 1029,
                                                                                                                                          'poller_hash': 'ODdCMUE4cGVlcnBvbjIzNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2908028',
                                                                                                                                          'fiber_length': 1037,
                                                                                                                                          'poller_hash': 'ODdCOUQ0cGVlcnBvbjI1MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2908052',
                                                                                                                                          'fiber_length': 887,
                                                                                                                                          'poller_hash': 'ODdCOTk5cGVlcnBvbjI1Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2908030',
                                                                                                                                          'fiber_length': 816,
                                                                                                                                          'poller_hash': 'ODdCQTM4cGVlcnBvbjI1Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2908026',
                                                                                                                                          'fiber_length': 812,
                                                                                                                                          'poller_hash': 'ODdCQUQ0cGVlcnBvbjI1Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '1710726',
                                                                                                                                          'fiber_length': 1012,
                                                                                                                                          'poller_hash': 'ODdCOTkzcGVlcnBvbjI2NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp5',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010110',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16444710',
                                                                                         'in_octets': '1555360308054',
                                                                                         'in_ucast_pkts': '8169006014',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '29298333814',
                                                                                                                  'in_octets': '29418825189',
                                                                                                                  'in_ucast_pkts': '120491375',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '259773976996',
                                                                                                                  'out_octets': '259987564851',
                                                                                                                  'out_ucast_pkts': '213587855',
                                                                                                                  'poller_hash': 'ODdCODMxcGVlcmludGYxMTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '59419935900',
                                                                                                                  'in_octets': '59902504266',
                                                                                                                  'in_ucast_pkts': '482568366',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1462598594927',
                                                                                                                  'out_octets': '1463602390033',
                                                                                                                  'out_ucast_pkts': '1003795106',
                                                                                                                  'poller_hash': 'ODdCQTFBcGVlcmludGYxMTUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12949131508',
                                                                                                                  'in_octets': '13013102733',
                                                                                                                  'in_ucast_pkts': '63971225',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '184476477713',
                                                                                                                  'out_octets': '184610725279',
                                                                                                                  'out_ucast_pkts': '134247566',
                                                                                                                  'poller_hash': 'ODdCOEI3cGVlcmludGYxMTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6547343723',
                                                                                                                  'in_octets': '6558621416',
                                                                                                                  'in_ucast_pkts': '11277693',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '38386014557',
                                                                                                                  'out_octets': '38416154839',
                                                                                                                  'out_ucast_pkts': '30140282',
                                                                                                                  'poller_hash': 'ODdCODUzcGVlcmludGYxMTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1711677398',
                                                                                                                  'in_octets': '1718555971',
                                                                                                                  'in_ucast_pkts': '6878573',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '5227873978',
                                                                                                                  'out_octets': '5235783923',
                                                                                                                  'out_ucast_pkts': '7909945',
                                                                                                                  'poller_hash': 'ODdCQTFDcGVlcmludGYxMzAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '636043090',
                                                                                                                  'in_octets': '637498950',
                                                                                                                  'in_ucast_pkts': '1455860',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '6445625964',
                                                                                                                  'out_octets': '6451160961',
                                                                                                                  'out_ucast_pkts': '5534997',
                                                                                                                  'poller_hash': 'ODdCOUNDcGVlcmludGYxNjYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5436142728',
                                                                                                                  'in_octets': '5477970899',
                                                                                                                  'in_ucast_pkts': '41828171',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '336698572138',
                                                                                                                  'out_octets': '336929035619',
                                                                                                                  'out_ucast_pkts': '230463481',
                                                                                                                  'poller_hash': 'ODdCMjExcGVlcmludGYxNjkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10345954090',
                                                                                                                  'in_octets': '10392835221',
                                                                                                                  'in_ucast_pkts': '46881131',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '163576566794',
                                                                                                                  'out_octets': '163702251941',
                                                                                                                  'out_ucast_pkts': '125685147',
                                                                                                                  'poller_hash': 'ODdCOTk1cGVlcmludGYxNzEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '84272137',
                                                                                                                  'in_octets': '85268162',
                                                                                                                  'in_ucast_pkts': '996025',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '353999651',
                                                                                                                  'out_octets': '355266927',
                                                                                                                  'out_ucast_pkts': '1267276',
                                                                                                                  'poller_hash': 'ODdCOEQ3cGVlcmludGYxODEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4901386016',
                                                                                                                  'in_octets': '4931413105',
                                                                                                                  'in_ucast_pkts': '30027089',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '134796995523',
                                                                                                                  'out_octets': '134891832914',
                                                                                                                  'out_ucast_pkts': '94837391',
                                                                                                                  'poller_hash': 'ODdCQTQ1cGVlcmludGYxOTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10915472748',
                                                                                                                  'in_octets': '11004549348',
                                                                                                                  'in_ucast_pkts': '89076600',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '382521584488',
                                                                                                                  'out_octets': '382794445113',
                                                                                                                  'out_ucast_pkts': '272860625',
                                                                                                                  'poller_hash': 'ODdCMUYycGVlcmludGYyMDkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '926308617',
                                                                                                                  'in_octets': '931681244',
                                                                                                                  'in_ucast_pkts': '5372627',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '34401731420',
                                                                                                                  'out_octets': '34425454952',
                                                                                                                  'out_ucast_pkts': '23723532',
                                                                                                                  'poller_hash': 'ODdCOUQycGVlcmludGYyMzgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '30979249087',
                                                                                                                  'in_octets': '31222232023',
                                                                                                                  'in_ucast_pkts': '242982936',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1060586655951',
                                                                                                                  'out_octets': '1061314510385',
                                                                                                                  'out_ucast_pkts': '727854434',
                                                                                                                  'poller_hash': 'ODdCQUVBcGVlcmludGYyMzkvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCQTREcGVlcmludGYyNDQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4765995543',
                                                                                                                  'in_octets': '4788490941',
                                                                                                                  'in_ucast_pkts': '22495398',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '94063722028',
                                                                                                                  'out_octets': '94136574287',
                                                                                                                  'out_ucast_pkts': '72852259',
                                                                                                                  'poller_hash': 'ODdCOEZCcGVlcmludGYyNTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '15469736456',
                                                                                                                  'in_octets': '15578009143',
                                                                                                                  'in_ucast_pkts': '108272687',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '529317157167',
                                                                                                                  'out_octets': '529684171585',
                                                                                                                  'out_ucast_pkts': '367014418',
                                                                                                                  'poller_hash': 'ODdCRUU4cGVlcmludGYyNzEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5844474980',
                                                                                                                  'in_octets': '5912491017',
                                                                                                                  'in_ucast_pkts': '68016037',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '194800566983',
                                                                                                                  'out_octets': '194934416093',
                                                                                                                  'out_ucast_pkts': '133849110',
                                                                                                                  'poller_hash': 'ODdCODdGcGVlcmludGYyNzUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10009248682',
                                                                                                                  'in_octets': '10041905796',
                                                                                                                  'in_ucast_pkts': '32657114',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '176489826243',
                                                                                                                  'out_octets': '176629988780',
                                                                                                                  'out_ucast_pkts': '140162537',
                                                                                                                  'poller_hash': 'ODdCMjQzcGVlcmludGYyNzgvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:16',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp6',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '1223',
                                                                                         'out_octets': '28401362584740',
                                                                                         'out_ucast_pkts': '20067661604',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2',
                                                                                         'pons': [       {       'id': '120010110',
                                                                                                                 'links': [       {       'connected_time': '2908015',
                                                                                                                                          'fiber_length': 921,
                                                                                                                                          'poller_hash': 'ODdCODMxcGVlcnBvbjExMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2908011',
                                                                                                                                          'fiber_length': 770,
                                                                                                                                          'poller_hash': 'ODdCQTFBcGVlcnBvbjExNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '1789045',
                                                                                                                                          'fiber_length': 643,
                                                                                                                                          'poller_hash': 'ODdCOEI3cGVlcnBvbjExNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '273755',
                                                                                                                                          'fiber_length': 759,
                                                                                                                                          'poller_hash': 'ODdCODUzcGVlcnBvbjExOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2908000',
                                                                                                                                          'fiber_length': 941,
                                                                                                                                          'poller_hash': 'ODdCQTFDcGVlcnBvbjEzMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2908018',
                                                                                                                                          'fiber_length': 766,
                                                                                                                                          'poller_hash': 'ODdCOUNDcGVlcnBvbjE2Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2907999',
                                                                                                                                          'fiber_length': 847,
                                                                                                                                          'poller_hash': 'ODdCMjExcGVlcnBvbjE2OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2908032',
                                                                                                                                          'fiber_length': 856,
                                                                                                                                          'poller_hash': 'ODdCOTk1cGVlcnBvbjE3MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2908048',
                                                                                                                                          'fiber_length': 940,
                                                                                                                                          'poller_hash': 'ODdCOEQ3cGVlcnBvbjE4MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2908042',
                                                                                                                                          'fiber_length': 773,
                                                                                                                                          'poller_hash': 'ODdCQTQ1cGVlcnBvbjE5OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2908025',
                                                                                                                                          'fiber_length': 818,
                                                                                                                                          'poller_hash': 'ODdCMUYycGVlcnBvbjIwOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '309813',
                                                                                                                                          'fiber_length': 666,
                                                                                                                                          'poller_hash': 'ODdCOUQycGVlcnBvbjIzOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2907083',
                                                                                                                                          'fiber_length': 676,
                                                                                                                                          'poller_hash': 'ODdCQUVBcGVlcnBvbjIzOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'poller_hash': 'ODdCQTREcGVlcnBvbjI0NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2908025',
                                                                                                                                          'fiber_length': 848,
                                                                                                                                          'poller_hash': 'ODdCOEZCcGVlcnBvbjI1MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2908008',
                                                                                                                                          'fiber_length': 730,
                                                                                                                                          'poller_hash': 'ODdCRUU4cGVlcnBvbjI3MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '1031719',
                                                                                                                                          'fiber_length': 877,
                                                                                                                                          'poller_hash': 'ODdCODdGcGVlcnBvbjI3NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2908010',
                                                                                                                                          'fiber_length': 880,
                                                                                                                                          'poller_hash': 'ODdCMjQzcGVlcnBvbjI3OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp6',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010111',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '483517',
                                                                                         'in_octets': '5368875875793',
                                                                                         'in_ucast_pkts': '18757057145',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '23139280744',
                                                                                                                  'in_octets': '23349182629',
                                                                                                                  'in_ucast_pkts': '209901885',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '779937532373',
                                                                                                                  'out_octets': '780472465253',
                                                                                                                  'out_ucast_pkts': '534932880',
                                                                                                                  'poller_hash': 'ODdCMjhGcGVlcmludGYxNC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3153064919',
                                                                                                                  'in_octets': '3166521343',
                                                                                                                  'in_ucast_pkts': '13456424',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '16101417359',
                                                                                                                  'out_octets': '16119708285',
                                                                                                                  'out_ucast_pkts': '18290926',
                                                                                                                  'poller_hash': 'ODdCMTVFcGVlcmludGYxNS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '416119722408',
                                                                                                                  'in_octets': '417216842126',
                                                                                                                  'in_ucast_pkts': '1097119718',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3444140650929',
                                                                                                                  'out_octets': '3446761529693',
                                                                                                                  'out_ucast_pkts': '2620878764',
                                                                                                                  'poller_hash': 'ODdCMUJBcGVlcmludGYxOS9ncDE='},
                                                                                                          {       'in_errors': '1608817',
                                                                                                                  'in_nucast_pkts': '137945804595',
                                                                                                                  'in_octets': '139280372424',
                                                                                                                  'in_ucast_pkts': '1334567829',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4180049955361',
                                                                                                                  'out_octets': '4182900230689',
                                                                                                                  'out_ucast_pkts': '2850275328',
                                                                                                                  'poller_hash': 'ODdCMkEzcGVlcmludGYyMC9ncDE='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCMTVCcGVlcmludGYyMS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '153182480360',
                                                                                                                  'in_octets': '154203608011',
                                                                                                                  'in_ucast_pkts': '1021127651',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3490427098163',
                                                                                                                  'out_octets': '3493018865383',
                                                                                                                  'out_ucast_pkts': '2591767220',
                                                                                                                  'poller_hash': 'ODdCMjQxcGVlcmludGYyMi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '302834643876',
                                                                                                                  'in_octets': '303278131887',
                                                                                                                  'in_ucast_pkts': '443488011',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '916386369406',
                                                                                                                  'out_octets': '917161570292',
                                                                                                                  'out_ucast_pkts': '775200886',
                                                                                                                  'poller_hash': 'ODdCMjczcGVlcmludGYyMy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '95856004474',
                                                                                                                  'in_octets': '96041789562',
                                                                                                                  'in_ucast_pkts': '185785088',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '343000368879',
                                                                                                                  'out_octets': '343269046757',
                                                                                                                  'out_ucast_pkts': '268677878',
                                                                                                                  'poller_hash': 'ODdCMjRCcGVlcmludGYyNC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6833325155',
                                                                                                                  'in_octets': '6851792524',
                                                                                                                  'in_ucast_pkts': '18467369',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '174245068209',
                                                                                                                  'out_octets': '174370278039',
                                                                                                                  'out_ucast_pkts': '125209830',
                                                                                                                  'poller_hash': 'ODdCMjU1cGVlcmludGYyNi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '54541450810',
                                                                                                                  'in_octets': '54877235678',
                                                                                                                  'in_ucast_pkts': '335784868',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2266403807970',
                                                                                                                  'out_octets': '2267951837885',
                                                                                                                  'out_ucast_pkts': '1548029915',
                                                                                                                  'poller_hash': 'ODdCMjdFcGVlcmludGYzMS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '644673114',
                                                                                                                  'in_octets': '644673114',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '512',
                                                                                                                  'out_octets': '512',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODdCQUFCcGVlcmludGYzNy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3635900891',
                                                                                                                  'in_octets': '3647840753',
                                                                                                                  'in_ucast_pkts': '11939862',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '47343596552',
                                                                                                                  'out_octets': '47382256245',
                                                                                                                  'out_ucast_pkts': '38659693',
                                                                                                                  'poller_hash': 'ODdCOTAzcGVlcmludGY2Ni9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '346912949003',
                                                                                                                  'in_octets': '347469873834',
                                                                                                                  'in_ucast_pkts': '556924831',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1190246761823',
                                                                                                                  'out_octets': '1191146838707',
                                                                                                                  'out_ucast_pkts': '900076884',
                                                                                                                  'poller_hash': 'ODdCMUJDcGVlcmludGYxNzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12448306088',
                                                                                                                  'in_octets': '12462781008',
                                                                                                                  'in_ucast_pkts': '14474920',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '8639887566',
                                                                                                                  'out_octets': '8654840417',
                                                                                                                  'out_ucast_pkts': '14952851',
                                                                                                                  'poller_hash': 'ODdCQTU4cGVlcmludGYyMzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11895980569',
                                                                                                                  'in_octets': '11946102362',
                                                                                                                  'in_ucast_pkts': '50121793',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '136869116579',
                                                                                                                  'out_octets': '136975303890',
                                                                                                                  'out_ucast_pkts': '106187311',
                                                                                                                  'poller_hash': 'ODdCOUU3cGVlcmludGYyNzMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '41249829865',
                                                                                                                  'in_octets': '41433971908',
                                                                                                                  'in_ucast_pkts': '184142043',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '479128338925',
                                                                                                                  'out_octets': '479469791758',
                                                                                                                  'out_ucast_pkts': '341452833',
                                                                                                                  'poller_hash': 'ODdCQUU0cGVlcmludGZzb25hcl9pdGVtXzI1OTQvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:17',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp7',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '1008',
                                                                                         'out_octets': '64823603000233',
                                                                                         'out_ucast_pkts': '46345327486',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3',
                                                                                         'pons': [       {       'id': '120010111',
                                                                                                                 'links': [       {       'connected_time': '861301',
                                                                                                                                          'fiber_length': 355,
                                                                                                                                          'poller_hash': 'ODdCMjhGcGVlcnBvbjE0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2907988',
                                                                                                                                          'fiber_length': 371,
                                                                                                                                          'poller_hash': 'ODdCMTVFcGVlcnBvbjE1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2907976',
                                                                                                                                          'fiber_length': 406,
                                                                                                                                          'poller_hash': 'ODdCMUJBcGVlcnBvbjE5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2908008',
                                                                                                                                          'fiber_length': 465,
                                                                                                                                          'poller_hash': 'ODdCMkEzcGVlcnBvbjIwL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'poller_hash': 'ODdCMTVCcGVlcnBvbjIxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '5696011',
                                                                                                                                          'fiber_length': 858,
                                                                                                                                          'poller_hash': 'ODdCMjQxcGVlcnBvbjIyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '5093054',
                                                                                                                                          'fiber_length': 811,
                                                                                                                                          'poller_hash': 'ODdCMjczcGVlcnBvbjIzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2663065',
                                                                                                                                          'fiber_length': 411,
                                                                                                                                          'poller_hash': 'ODdCMjRCcGVlcnBvbjI0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '598951',
                                                                                                                                          'fiber_length': 414,
                                                                                                                                          'poller_hash': 'ODdCMjU1cGVlcnBvbjI2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -27.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '5696060',
                                                                                                                                          'fiber_length': 819,
                                                                                                                                          'poller_hash': 'ODdCMjdFcGVlcnBvbjMxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '5695996',
                                                                                                                                          'fiber_length': 766,
                                                                                                                                          'poller_hash': 'ODdCQUFCcGVlcnBvbjM3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2907998',
                                                                                                                                          'fiber_length': 501,
                                                                                                                                          'poller_hash': 'ODdCOTAzcGVlcnBvbjY2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '5696044',
                                                                                                                                          'fiber_length': 764,
                                                                                                                                          'poller_hash': 'ODdCMUJDcGVlcnBvbjE3Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '5696059',
                                                                                                                                          'fiber_length': 848,
                                                                                                                                          'poller_hash': 'ODdCQTU4cGVlcnBvbjIzMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '3100266',
                                                                                                                                          'fiber_length': 408,
                                                                                                                                          'poller_hash': 'ODdCOUU3cGVlcnBvbjI3My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2908039',
                                                                                                                                          'fiber_length': 373,
                                                                                                                                          'poller_hash': 'ODdCQUU0cGVlcnBvbnNvbmFyX2l0ZW1fMjU5NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp7',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010112',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '13600612',
                                                                                         'in_octets': '2059614934105',
                                                                                         'in_ucast_pkts': '3659621833',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5586152037',
                                                                                                                  'in_octets': '5639277725',
                                                                                                                  'in_ucast_pkts': '53125688',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '257814046409',
                                                                                                                  'out_octets': '257991507542',
                                                                                                                  'out_ucast_pkts': '177461133',
                                                                                                                  'poller_hash': 'ODdCMjRFcGVlcmludGYyNy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '177832604',
                                                                                                                  'in_octets': '179072513',
                                                                                                                  'in_ucast_pkts': '1239909',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '508308190',
                                                                                                                  'out_octets': '509317585',
                                                                                                                  'out_ucast_pkts': '1009395',
                                                                                                                  'poller_hash': 'ODdCMjFEcGVlcmludGYyOC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '29194689096',
                                                                                                                  'in_octets': '29342074869',
                                                                                                                  'in_ucast_pkts': '147385773',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '839636916811',
                                                                                                                  'out_octets': '840233928247',
                                                                                                                  'out_ucast_pkts': '597011436',
                                                                                                                  'poller_hash': 'ODdCOUIzcGVlcmludGY5Mi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '293453293883',
                                                                                                                  'in_octets': '293999963881',
                                                                                                                  'in_ucast_pkts': '546669998',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1522016243594',
                                                                                                                  'out_octets': '1523134301637',
                                                                                                                  'out_ucast_pkts': '1118058043',
                                                                                                                  'poller_hash': 'ODdCQUVCcGVlcmludGYxMjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '16225196824',
                                                                                                                  'in_octets': '16275001399',
                                                                                                                  'in_ucast_pkts': '49804575',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '166654241164',
                                                                                                                  'out_octets': '166786836173',
                                                                                                                  'out_ucast_pkts': '132595009',
                                                                                                                  'poller_hash': 'ODdCOURGcGVlcmludGYxMzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5659803984',
                                                                                                                  'in_octets': '5679635271',
                                                                                                                  'in_ucast_pkts': '19831287',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '62255135654',
                                                                                                                  'out_octets': '62310840776',
                                                                                                                  'out_ucast_pkts': '55705122',
                                                                                                                  'poller_hash': 'ODdCMjY0cGVlcmludGYxNTgvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:18',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp8',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '300',
                                                                                         'out_octets': '10617185460271',
                                                                                         'out_ucast_pkts': '7868153810',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTgxLzIvZ3A4',
                                                                                         'pons': [       {       'id': '120010112',
                                                                                                                 'links': [       {       'connected_time': '2907983',
                                                                                                                                          'fiber_length': 318,
                                                                                                                                          'poller_hash': 'ODdCMjRFcGVlcnBvbjI3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391},
                                                                                                                                  {       'connected_time': '2907992',
                                                                                                                                          'fiber_length': 363,
                                                                                                                                          'poller_hash': 'ODdCMjFEcGVlcnBvbjI4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391},
                                                                                                                                  {       'connected_time': '2907988',
                                                                                                                                          'fiber_length': 456,
                                                                                                                                          'poller_hash': 'ODdCOUIzcGVlcnBvbjkyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391},
                                                                                                                                  {       'connected_time': '2908015',
                                                                                                                                          'fiber_length': 472,
                                                                                                                                          'poller_hash': 'ODdCQUVCcGVlcnBvbjEyNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391},
                                                                                                                                  {       'connected_time': '2908009',
                                                                                                                                          'fiber_length': 454,
                                                                                                                                          'poller_hash': 'ODdCOURGcGVlcnBvbjEzMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391},
                                                                                                                                  {       'connected_time': '2908005',
                                                                                                                                          'fiber_length': 422,
                                                                                                                                          'poller_hash': 'ODdCMjY0cGVlcnBvbjE1OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'maximum_loss': -8.0,
                                                                                                                 'minimum_loss': -28.0,
                                                                                                                 'name': '1/2/gp8',
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjE4MTIwMDEwMTEy',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'mem': 47.0,
                                                           'model': 'GPON-8 r2',
                                                           'name': '1/2',
                                                           'poller_hash': 'NDcyMDA0MDA3NTc5',
                                                           'serial_number': '472004007579',
                                                           'sw_version': '23.2.0',
                                                           'temperature': 24.1,
                                                           'uptime': '13074600'}],
                                'serial_number': '071904929255',
                                'sw_version': '23.2.0',
                                'system_mac_address': '00:02:5d:fe:73:6a'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000161',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '23139280744',
                                                                       'in_octets': '23349182629',
                                                                       'in_ucast_pkts': '209901885',
                                                                       'mac_address': 'd0:76:8f:1f:d9:ad',
                                                                       'mtu': 2000,
                                                                       'name': '14/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '779937532373',
                                                                       'out_octets': '780472465253',
                                                                       'out_ucast_pkts': '534932880',
                                                                       'poller_hash': 'ODdCMjhGcGVlcmludGYxNC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '14',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '779937532373',
                                                                       'in_octets': '780472465253',
                                                                       'in_ucast_pkts': '534932880',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:00:3b:d7'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '779937532373',
                                                                                                'in_octets': '780472465253',
                                                                                                'in_ucast_pkts': '534932880',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '23139280744',
                                                                                                'out_octets': '23349182629',
                                                                                                'out_ucast_pkts': '209901885',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '14/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '23139280744',
                                                                       'out_octets': '23349182629',
                                                                       'out_ucast_pkts': '209901885',
                                                                       'poller_hash': 'ODdCMjhGcGVlcmludGYxNC9ncDE=',
                                                                       'pons': [       {       'id': '14',
                                                                                               'links': [       {       'connected_time': '861301',
                                                                                                                        'fiber_length': 355,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '14/gp1',
                                                                                               'poller_hash': 'ODdCMjhGcGVlcnBvbjE0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 14',
                                         'poller_hash': 'ODdCMjhG',
                                         'serial_number': '87B28F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d9:ad',
                                         'uptime': '861301'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000193',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3153064919',
                                                                       'in_octets': '3166521343',
                                                                       'in_ucast_pkts': '13456424',
                                                                       'mac_address': 'd0:76:8f:1f:d6:1a',
                                                                       'mtu': 2000,
                                                                       'name': '15/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '16101417359',
                                                                       'out_octets': '16119708285',
                                                                       'out_ucast_pkts': '18290926',
                                                                       'poller_hash': 'ODdCMTVFcGVlcmludGYxNS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '15',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '16101417359',
                                                                       'in_octets': '16119708285',
                                                                       'in_ucast_pkts': '18290926',
                                                                       'links': [       {       'bridged_mac_addresses': [       '14:59:c0:b6:67:95'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '16101417359',
                                                                                                'in_octets': '16119708285',
                                                                                                'in_ucast_pkts': '18290926',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3153064919',
                                                                                                'out_octets': '3166521343',
                                                                                                'out_ucast_pkts': '13456424',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '15/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3153064919',
                                                                       'out_octets': '3166521343',
                                                                       'out_ucast_pkts': '13456424',
                                                                       'poller_hash': 'ODdCMTVFcGVlcmludGYxNS9ncDE=',
                                                                       'pons': [       {       'id': '15',
                                                                                               'links': [       {       'connected_time': '2907988',
                                                                                                                        'fiber_length': 371,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '15/gp1',
                                                                                               'poller_hash': 'ODdCMTVFcGVlcnBvbjE1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 15',
                                         'poller_hash': 'ODdCMTVF',
                                         'serial_number': '87B15E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d6:1a',
                                         'uptime': '2907988'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000321',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '416119722408',
                                                                       'in_octets': '417216842126',
                                                                       'in_ucast_pkts': '1097119718',
                                                                       'mac_address': 'd0:76:8f:1f:d7:2e',
                                                                       'mtu': 2000,
                                                                       'name': '19/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3444140650929',
                                                                       'out_octets': '3446761529693',
                                                                       'out_ucast_pkts': '2620878764',
                                                                       'poller_hash': 'ODdCMUJBcGVlcmludGYxOS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '19',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3444140650929',
                                                                       'in_octets': '3446761529693',
                                                                       'in_ucast_pkts': '2620878764',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:b2:33:4c'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '3444140650929',
                                                                                                'in_octets': '3446761529693',
                                                                                                'in_ucast_pkts': '2620878764',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '416119722408',
                                                                                                'out_octets': '417216842126',
                                                                                                'out_ucast_pkts': '1097119718',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '19/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '416119722408',
                                                                       'out_octets': '417216842126',
                                                                       'out_ucast_pkts': '1097119718',
                                                                       'poller_hash': 'ODdCMUJBcGVlcmludGYxOS9ncDE=',
                                                                       'pons': [       {       'id': '19',
                                                                                               'links': [       {       'connected_time': '2907976',
                                                                                                                        'fiber_length': 406,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '19/gp1',
                                                                                               'poller_hash': 'ODdCMUJBcGVlcnBvbjE5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 19',
                                         'poller_hash': 'ODdCMUJB',
                                         'serial_number': '87B1BA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d7:2e',
                                         'uptime': '2907976'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000353',
                                                                       'in_errors': '1608817',
                                                                       'in_nucast_pkts': '137945804595',
                                                                       'in_octets': '139280372424',
                                                                       'in_ucast_pkts': '1334567829',
                                                                       'mac_address': 'd0:76:8f:1f:d9:e9',
                                                                       'mtu': 2000,
                                                                       'name': '20/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4180049955361',
                                                                       'out_octets': '4182900230689',
                                                                       'out_ucast_pkts': '2850275328',
                                                                       'poller_hash': 'ODdCMkEzcGVlcmludGYyMC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '20',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4180049955361',
                                                                       'in_octets': '4182900230689',
                                                                       'in_ucast_pkts': '2850275328',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:00:3b:bc'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '4180049955361',
                                                                                                'in_octets': '4182900230689',
                                                                                                'in_ucast_pkts': '2850275328',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '1608817',
                                                                                                'out_nucast_pkts': '137945804595',
                                                                                                'out_octets': '139280372424',
                                                                                                'out_ucast_pkts': '1334567829',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '20/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '1608817',
                                                                       'out_nucast_pkts': '137945804595',
                                                                       'out_octets': '139280372424',
                                                                       'out_ucast_pkts': '1334567829',
                                                                       'poller_hash': 'ODdCMkEzcGVlcmludGYyMC9ncDE=',
                                                                       'pons': [       {       'id': '20',
                                                                                               'links': [       {       'connected_time': '2908008',
                                                                                                                        'fiber_length': 465,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '20/gp1',
                                                                                               'poller_hash': 'ODdCMkEzcGVlcnBvbjIwL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 20',
                                         'poller_hash': 'ODdCMkEz',
                                         'serial_number': '87B2A3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d9:e9',
                                         'uptime': '2908008'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000385',
                                                                       'name': '21/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCMTVCcGVlcmludGYyMS9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '21',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '21/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCMTVCcGVlcmludGYyMS9ncDE=',
                                                                       'pons': [       {       'id': '21',
                                                                                               'links': [       {       'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '21/gp1',
                                                                                               'poller_hash': 'ODdCMTVCcGVlcnBvbjIxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'name': 'ont 21',
                                         'poller_hash': 'ODdCMTVC',
                                         'serial_number': '87B15B',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000417',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '153182480360',
                                                                       'in_octets': '154203608011',
                                                                       'in_ucast_pkts': '1021127651',
                                                                       'mac_address': 'd0:76:8f:1f:d8:c3',
                                                                       'mtu': 2000,
                                                                       'name': '22/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3490427098163',
                                                                       'out_octets': '3493018865383',
                                                                       'out_ucast_pkts': '2591767220',
                                                                       'poller_hash': 'ODdCMjQxcGVlcmludGYyMi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '22',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3490427098163',
                                                                       'in_octets': '3493018865383',
                                                                       'in_ucast_pkts': '2591767220',
                                                                       'links': [       {       'bridged_mac_addresses': [       '18:a6:f7:05:32:9b'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '3490427098163',
                                                                                                'in_octets': '3493018865383',
                                                                                                'in_ucast_pkts': '2591767220',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '153182480360',
                                                                                                'out_octets': '154203608011',
                                                                                                'out_ucast_pkts': '1021127651',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '22/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '153182480360',
                                                                       'out_octets': '154203608011',
                                                                       'out_ucast_pkts': '1021127651',
                                                                       'poller_hash': 'ODdCMjQxcGVlcmludGYyMi9ncDE=',
                                                                       'pons': [       {       'id': '22',
                                                                                               'links': [       {       'connected_time': '5696011',
                                                                                                                        'fiber_length': 858,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '22/gp1',
                                                                                               'poller_hash': 'ODdCMjQxcGVlcnBvbjIyL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 22',
                                         'poller_hash': 'ODdCMjQx',
                                         'serial_number': '87B241',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d8:c3',
                                         'uptime': '5696011'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000449',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '302834643876',
                                                                       'in_octets': '303278131887',
                                                                       'in_ucast_pkts': '443488011',
                                                                       'mac_address': 'd0:76:8f:1f:d9:59',
                                                                       'mtu': 2000,
                                                                       'name': '23/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '916386369406',
                                                                       'out_octets': '917161570292',
                                                                       'out_ucast_pkts': '775200886',
                                                                       'poller_hash': 'ODdCMjczcGVlcmludGYyMy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '23',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '916386369406',
                                                                       'in_octets': '917161570292',
                                                                       'in_ucast_pkts': '775200886',
                                                                       'links': [       {       'bridged_mac_addresses': [       '48:77:46:f9:ba:85'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '916386369406',
                                                                                                'in_octets': '917161570292',
                                                                                                'in_ucast_pkts': '775200886',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '302834643876',
                                                                                                'out_octets': '303278131887',
                                                                                                'out_ucast_pkts': '443488011',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '23/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '302834643876',
                                                                       'out_octets': '303278131887',
                                                                       'out_ucast_pkts': '443488011',
                                                                       'poller_hash': 'ODdCMjczcGVlcmludGYyMy9ncDE=',
                                                                       'pons': [       {       'id': '23',
                                                                                               'links': [       {       'connected_time': '5093054',
                                                                                                                        'fiber_length': 811,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '23/gp1',
                                                                                               'poller_hash': 'ODdCMjczcGVlcnBvbjIzL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 23',
                                         'poller_hash': 'ODdCMjcz',
                                         'serial_number': '87B273',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d9:59',
                                         'uptime': '5093054'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000481',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '95856004474',
                                                                       'in_octets': '96041789562',
                                                                       'in_ucast_pkts': '185785088',
                                                                       'mac_address': 'd0:76:8f:1f:d8:e1',
                                                                       'mtu': 2000,
                                                                       'name': '24/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '343000368879',
                                                                       'out_octets': '343269046757',
                                                                       'out_ucast_pkts': '268677878',
                                                                       'poller_hash': 'ODdCMjRCcGVlcmludGYyNC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '24',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '343000368879',
                                                                       'in_octets': '343269046757',
                                                                       'in_ucast_pkts': '268677878',
                                                                       'links': [       {       'bridged_mac_addresses': [       'a4:13:4e:a8:16:35'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '343000368879',
                                                                                                'in_octets': '343269046757',
                                                                                                'in_ucast_pkts': '268677878',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '95856004474',
                                                                                                'out_octets': '96041789562',
                                                                                                'out_ucast_pkts': '185785088',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '24/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '95856004474',
                                                                       'out_octets': '96041789562',
                                                                       'out_ucast_pkts': '185785088',
                                                                       'poller_hash': 'ODdCMjRCcGVlcmludGYyNC9ncDE=',
                                                                       'pons': [       {       'id': '24',
                                                                                               'links': [       {       'connected_time': '2663065',
                                                                                                                        'fiber_length': 411,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '24/gp1',
                                                                                               'poller_hash': 'ODdCMjRCcGVlcnBvbjI0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 24',
                                         'poller_hash': 'ODdCMjRC',
                                         'serial_number': '87B24B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d8:e1',
                                         'uptime': '2663065'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000545',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6833325155',
                                                                       'in_octets': '6851792524',
                                                                       'in_ucast_pkts': '18467369',
                                                                       'mac_address': 'd0:76:8f:1f:d8:ff',
                                                                       'mtu': 2000,
                                                                       'name': '26/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '174245068209',
                                                                       'out_octets': '174370278039',
                                                                       'out_ucast_pkts': '125209830',
                                                                       'poller_hash': 'ODdCMjU1cGVlcmludGYyNi9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '26',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '174245068209',
                                                                       'in_octets': '174370278039',
                                                                       'in_ucast_pkts': '125209830',
                                                                       'links': [       {       'bridged_mac_addresses': [       '00:18:61:40:4e:51'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '174245068209',
                                                                                                'in_octets': '174370278039',
                                                                                                'in_ucast_pkts': '125209830',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '6833325155',
                                                                                                'out_octets': '6851792524',
                                                                                                'out_ucast_pkts': '18467369',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '26/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6833325155',
                                                                       'out_octets': '6851792524',
                                                                       'out_ucast_pkts': '18467369',
                                                                       'poller_hash': 'ODdCMjU1cGVlcmludGYyNi9ncDE=',
                                                                       'pons': [       {       'id': '26',
                                                                                               'links': [       {       'connected_time': '598951',
                                                                                                                        'fiber_length': 414,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -30.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '26/gp1',
                                                                                               'poller_hash': 'ODdCMjU1cGVlcnBvbjI2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 26',
                                         'poller_hash': 'ODdCMjU1',
                                         'serial_number': '87B255',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d8:ff',
                                         'uptime': '598951'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000577',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5586152037',
                                                                       'in_octets': '5639277725',
                                                                       'in_ucast_pkts': '53125688',
                                                                       'mac_address': 'd0:76:8f:1f:d8:ea',
                                                                       'mtu': 2000,
                                                                       'name': '27/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '257814046409',
                                                                       'out_octets': '257991507542',
                                                                       'out_ucast_pkts': '177461133',
                                                                       'poller_hash': 'ODdCMjRFcGVlcmludGYyNy9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '27',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '257814046409',
                                                                       'in_octets': '257991507542',
                                                                       'in_ucast_pkts': '177461133',
                                                                       'links': [       {       'bridged_mac_addresses': [       'c0:56:27:c7:b1:b7'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '257814046409',
                                                                                                'in_octets': '257991507542',
                                                                                                'in_ucast_pkts': '177461133',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '5586152037',
                                                                                                'out_octets': '5639277725',
                                                                                                'out_ucast_pkts': '53125688',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTgxLzIvZ3A4'}],
                                                                       'name': '27/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '5586152037',
                                                                       'out_octets': '5639277725',
                                                                       'out_ucast_pkts': '53125688',
                                                                       'poller_hash': 'ODdCMjRFcGVlcmludGYyNy9ncDE=',
                                                                       'pons': [       {       'id': '27',
                                                                                               'links': [       {       'connected_time': '2907983',
                                                                                                                        'fiber_length': 318,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE4MTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '27/gp1',
                                                                                               'poller_hash': 'ODdCMjRFcGVlcnBvbjI3L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 27',
                                         'poller_hash': 'ODdCMjRF',
                                         'serial_number': '87B24E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d8:ea',
                                         'uptime': '2907983'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000609',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '177832604',
                                                                       'in_octets': '179072513',
                                                                       'in_ucast_pkts': '1239909',
                                                                       'mac_address': 'd0:76:8f:1f:d8:57',
                                                                       'mtu': 2000,
                                                                       'name': '28/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '508308190',
                                                                       'out_octets': '509317585',
                                                                       'out_ucast_pkts': '1009395',
                                                                       'poller_hash': 'ODdCMjFEcGVlcmludGYyOC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '28',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '508308190',
                                                                       'in_octets': '509317585',
                                                                       'in_ucast_pkts': '1009395',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:7f:81:dd'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '508308190',
                                                                                                'in_octets': '509317585',
                                                                                                'in_ucast_pkts': '1009395',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '177832604',
                                                                                                'out_octets': '179072513',
                                                                                                'out_ucast_pkts': '1239909',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTgxLzIvZ3A4'}],
                                                                       'name': '28/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '177832604',
                                                                       'out_octets': '179072513',
                                                                       'out_ucast_pkts': '1239909',
                                                                       'poller_hash': 'ODdCMjFEcGVlcmludGYyOC9ncDE=',
                                                                       'pons': [       {       'id': '28',
                                                                                               'links': [       {       'connected_time': '2907992',
                                                                                                                        'fiber_length': 363,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE4MTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '28/gp1',
                                                                                               'poller_hash': 'ODdCMjFEcGVlcnBvbjI4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 28',
                                         'poller_hash': 'ODdCMjFE',
                                         'serial_number': '87B21D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d8:57',
                                         'uptime': '2907992'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000641',
                                                                       'name': '29/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCMTk2cGVlcmludGYyOS9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '29',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '29/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCMTk2cGVlcmludGYyOS9ncDE=',
                                                                       'pons': [       {       'id': '29',
                                                                                               'links': [       {       'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '29/gp1',
                                                                                               'poller_hash': 'ODdCMTk2cGVlcnBvbjI5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'name': 'ont 29',
                                         'poller_hash': 'ODdCMTk2',
                                         'serial_number': '87B196',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000673',
                                                                       'in_errors': '14',
                                                                       'in_nucast_pkts': '16837736193',
                                                                       'in_octets': '16979794819',
                                                                       'in_ucast_pkts': '142058626',
                                                                       'mac_address': 'd0:76:8f:1f:f0:6f',
                                                                       'mtu': 2000,
                                                                       'name': '30/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '665349400781',
                                                                       'out_octets': '665814734561',
                                                                       'out_ucast_pkts': '465333780',
                                                                       'poller_hash': 'ODdCQTI1cGVlcmludGYzMC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '30',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '665349400781',
                                                                       'in_octets': '665814734561',
                                                                       'in_ucast_pkts': '465333780',
                                                                       'links': [       {       'bridged_mac_addresses': [       'c0:c9:e3:fb:22:c5'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '665349400781',
                                                                                                'in_octets': '665814734561',
                                                                                                'in_ucast_pkts': '465333780',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '14',
                                                                                                'out_nucast_pkts': '16837736193',
                                                                                                'out_octets': '16979794819',
                                                                                                'out_ucast_pkts': '142058626',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '30/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '14',
                                                                       'out_nucast_pkts': '16837736193',
                                                                       'out_octets': '16979794819',
                                                                       'out_ucast_pkts': '142058626',
                                                                       'poller_hash': 'ODdCQTI1cGVlcmludGYzMC9ncDE=',
                                                                       'pons': [       {       'id': '30',
                                                                                               'links': [       {       'connected_time': '2907979',
                                                                                                                        'fiber_length': 541,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '30/gp1',
                                                                                               'poller_hash': 'ODdCQTI1cGVlcnBvbjMwL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 30',
                                         'poller_hash': 'ODdCQTI1',
                                         'serial_number': '87BA25',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:6f',
                                         'uptime': '2907979'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000705',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '54541450810',
                                                                       'in_octets': '54877235678',
                                                                       'in_ucast_pkts': '335784868',
                                                                       'mac_address': 'd0:76:8f:1f:d9:7a',
                                                                       'mtu': 2000,
                                                                       'name': '31/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2266403807970',
                                                                       'out_octets': '2267951837885',
                                                                       'out_ucast_pkts': '1548029915',
                                                                       'poller_hash': 'ODdCMjdFcGVlcmludGYzMS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '31',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2266403807970',
                                                                       'in_octets': '2267951837885',
                                                                       'in_ucast_pkts': '1548029915',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:05:52:85'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '2266403807970',
                                                                                                'in_octets': '2267951837885',
                                                                                                'in_ucast_pkts': '1548029915',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '54541450810',
                                                                                                'out_octets': '54877235678',
                                                                                                'out_ucast_pkts': '335784868',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '31/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '54541450810',
                                                                       'out_octets': '54877235678',
                                                                       'out_ucast_pkts': '335784868',
                                                                       'poller_hash': 'ODdCMjdFcGVlcmludGYzMS9ncDE=',
                                                                       'pons': [       {       'id': '31',
                                                                                               'links': [       {       'connected_time': '5696060',
                                                                                                                        'fiber_length': 819,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '31/gp1',
                                                                                               'poller_hash': 'ODdCMjdFcGVlcnBvbjMxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 31',
                                         'poller_hash': 'ODdCMjdF',
                                         'serial_number': '87B27E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d9:7a',
                                         'uptime': '5696060'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000769',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '33745979636',
                                                                       'in_octets': '33812753197',
                                                                       'in_ucast_pkts': '66773561',
                                                                       'mac_address': 'd0:76:8f:1f:f1:d7',
                                                                       'mtu': 2000,
                                                                       'name': '33/g1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '180686420600',
                                                                       'out_octets': '180841283715',
                                                                       'out_ucast_pkts': '154863115',
                                                                       'poller_hash': 'ODdCQTlEcGVlcmludGYzMy9nMQ==',
                                                                       'speed': '0'},
                                                               {       'admin_up': True,
                                                                       'id': '33',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '180686420600',
                                                                       'in_octets': '180841283715',
                                                                       'in_ucast_pkts': '154863115',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '180686420600',
                                                                                                'in_octets': '180841283715',
                                                                                                'in_ucast_pkts': '154863115',
                                                                                                'oper_up': False,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '33745979636',
                                                                                                'out_octets': '33812753197',
                                                                                                'out_ucast_pkts': '66773561',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '33/gp1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '33745979636',
                                                                       'out_octets': '33812753197',
                                                                       'out_ucast_pkts': '66773561',
                                                                       'poller_hash': 'ODdCQTlEcGVlcmludGYzMy9ncDE=',
                                                                       'pons': [       {       'id': '33',
                                                                                               'links': [       {       'connected_time': '5696088',
                                                                                                                        'fiber_length': 611,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '33/gp1',
                                                                                               'poller_hash': 'ODdCQTlEcGVlcnBvbjMzL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 33',
                                         'poller_hash': 'ODdCQTlE',
                                         'serial_number': '87BA9D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:d7',
                                         'uptime': '5696088'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000801',
                                                                       'in_errors': '22',
                                                                       'in_nucast_pkts': '11884891744',
                                                                       'in_octets': '11933939573',
                                                                       'in_ucast_pkts': '49047829',
                                                                       'mac_address': 'd0:76:8f:1f:f2:31',
                                                                       'mtu': 2000,
                                                                       'name': '34/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '222393442192',
                                                                       'out_octets': '222556739510',
                                                                       'out_ucast_pkts': '163297318',
                                                                       'poller_hash': 'ODdCQUJCcGVlcmludGYzNC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '34',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '222393442192',
                                                                       'in_octets': '222556739510',
                                                                       'in_ucast_pkts': '163297318',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:b2:33:34'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '222393442192',
                                                                                                'in_octets': '222556739510',
                                                                                                'in_ucast_pkts': '163297318',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '22',
                                                                                                'out_nucast_pkts': '11884891744',
                                                                                                'out_octets': '11933939573',
                                                                                                'out_ucast_pkts': '49047829',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '34/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '22',
                                                                       'out_nucast_pkts': '11884891744',
                                                                       'out_octets': '11933939573',
                                                                       'out_ucast_pkts': '49047829',
                                                                       'poller_hash': 'ODdCQUJCcGVlcmludGYzNC9ncDE=',
                                                                       'pons': [       {       'id': '34',
                                                                                               'links': [       {       'connected_time': '2907992',
                                                                                                                        'fiber_length': 966,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '34/gp1',
                                                                                               'poller_hash': 'ODdCQUJCcGVlcnBvbjM0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 34',
                                         'poller_hash': 'ODdCQUJC',
                                         'serial_number': '87BABB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f2:31',
                                         'uptime': '2907992'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000833',
                                                                       'in_errors': '88',
                                                                       'in_nucast_pkts': '62049513090',
                                                                       'in_octets': '62245469340',
                                                                       'in_ucast_pkts': '195956250',
                                                                       'mac_address': 'd0:76:8f:1f:f0:48',
                                                                       'mtu': 2000,
                                                                       'name': '35/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '794625876859',
                                                                       'out_octets': '795183005472',
                                                                       'out_ucast_pkts': '557128613',
                                                                       'poller_hash': 'ODdCQTE4cGVlcmludGYzNS9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '35',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '794625876859',
                                                                       'in_octets': '795183005472',
                                                                       'in_ucast_pkts': '557128613',
                                                                       'links': [       {       'bridged_mac_addresses': [       'f8:85:f9:72:76:a6'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '794625876859',
                                                                                                'in_octets': '795183005472',
                                                                                                'in_ucast_pkts': '557128613',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '88',
                                                                                                'out_nucast_pkts': '62049513090',
                                                                                                'out_octets': '62245469340',
                                                                                                'out_ucast_pkts': '195956250',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '35/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '88',
                                                                       'out_nucast_pkts': '62049513090',
                                                                       'out_octets': '62245469340',
                                                                       'out_ucast_pkts': '195956250',
                                                                       'poller_hash': 'ODdCQTE4cGVlcmludGYzNS9ncDE=',
                                                                       'pons': [       {       'id': '35',
                                                                                               'links': [       {       'connected_time': '2907988',
                                                                                                                        'fiber_length': 913,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '35/gp1',
                                                                                               'poller_hash': 'ODdCQTE4cGVlcnBvbjM1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 35',
                                         'poller_hash': 'ODdCQTE4',
                                         'serial_number': '87BA18',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:48',
                                         'uptime': '2907988'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000865',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '37494441459',
                                                                       'in_octets': '37668325789',
                                                                       'in_ucast_pkts': '173884330',
                                                                       'mac_address': 'd0:76:8f:1f:f1:f8',
                                                                       'mtu': 2000,
                                                                       'name': '36/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '544470695776',
                                                                       'out_octets': '544896754328',
                                                                       'out_ucast_pkts': '426058552',
                                                                       'poller_hash': 'ODdCQUE4cGVlcmludGYzNi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '36',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '544470695776',
                                                                       'in_octets': '544896754328',
                                                                       'in_ucast_pkts': '426058552',
                                                                       'links': [       {       'bridged_mac_addresses': [       '60:32:b1:41:c9:11'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '544470695776',
                                                                                                'in_octets': '544896754328',
                                                                                                'in_ucast_pkts': '426058552',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '37494441459',
                                                                                                'out_octets': '37668325789',
                                                                                                'out_ucast_pkts': '173884330',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '36/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '37494441459',
                                                                       'out_octets': '37668325789',
                                                                       'out_ucast_pkts': '173884330',
                                                                       'poller_hash': 'ODdCQUE4cGVlcmludGYzNi9ncDE=',
                                                                       'pons': [       {       'id': '36',
                                                                                               'links': [       {       'connected_time': '2907992',
                                                                                                                        'fiber_length': 814,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '36/gp1',
                                                                                               'poller_hash': 'ODdCQUE4cGVlcnBvbjM2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 36',
                                         'poller_hash': 'ODdCQUE4',
                                         'serial_number': '87BAA8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:f8',
                                         'uptime': '2907992'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000897',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '644673114',
                                                                       'in_octets': '644673114',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': 'd0:76:8f:1f:f2:01',
                                                                       'mtu': 2000,
                                                                       'name': '37/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '512',
                                                                       'out_octets': '512',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ODdCQUFCcGVlcmludGYzNy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '37',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '512',
                                                                       'in_octets': '512',
                                                                       'in_ucast_pkts': '0',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '512',
                                                                                                'in_octets': '512',
                                                                                                'in_ucast_pkts': '0',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '644673114',
                                                                                                'out_octets': '644673114',
                                                                                                'out_ucast_pkts': '0',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '37/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '644673114',
                                                                       'out_octets': '644673114',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ODdCQUFCcGVlcmludGYzNy9ncDE=',
                                                                       'pons': [       {       'id': '37',
                                                                                               'links': [       {       'connected_time': '5695996',
                                                                                                                        'fiber_length': 766,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '37/gp1',
                                                                                               'poller_hash': 'ODdCQUFCcGVlcnBvbjM3L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 37',
                                         'poller_hash': 'ODdCQUFC',
                                         'serial_number': '87BAAB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f2:01',
                                         'uptime': '5695996'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000929',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13902158407',
                                                                       'in_octets': '13989462664',
                                                                       'in_ucast_pkts': '87304257',
                                                                       'mac_address': 'd0:76:8f:1f:f2:10',
                                                                       'mtu': 2000,
                                                                       'name': '38/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '601829539699',
                                                                       'out_octets': '602242113643',
                                                                       'out_ucast_pkts': '412573944',
                                                                       'poller_hash': 'ODdCQUIwcGVlcmludGYzOC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '38',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '601829539699',
                                                                       'in_octets': '602242113643',
                                                                       'in_ucast_pkts': '412573944',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:1e:b5:95'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '601829539699',
                                                                                                'in_octets': '602242113643',
                                                                                                'in_ucast_pkts': '412573944',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13902158407',
                                                                                                'out_octets': '13989462664',
                                                                                                'out_ucast_pkts': '87304257',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '38/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13902158407',
                                                                       'out_octets': '13989462664',
                                                                       'out_ucast_pkts': '87304257',
                                                                       'poller_hash': 'ODdCQUIwcGVlcmludGYzOC9ncDE=',
                                                                       'pons': [       {       'id': '38',
                                                                                               'links': [       {       'connected_time': '2576626',
                                                                                                                        'fiber_length': 844,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '38/gp1',
                                                                                               'poller_hash': 'ODdCQUIwcGVlcnBvbjM4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 38',
                                         'poller_hash': 'ODdCQUIw',
                                         'serial_number': '87BAB0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f2:10',
                                         'uptime': '2576626'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001025',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13682147640',
                                                                       'in_octets': '13705641394',
                                                                       'in_ucast_pkts': '23493754',
                                                                       'mac_address': 'd0:76:8f:1f:f1:a7',
                                                                       'mtu': 2000,
                                                                       'name': '41/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '86770319145',
                                                                       'out_octets': '86843175207',
                                                                       'out_ucast_pkts': '72856062',
                                                                       'poller_hash': 'ODdCQThEcGVlcmludGY0MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '41',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '86770319145',
                                                                       'in_octets': '86843175207',
                                                                       'in_ucast_pkts': '72856062',
                                                                       'links': [       {       'bridged_mac_addresses': [       'bc:22:28:b4:f8:9f'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '86770319145',
                                                                                                'in_octets': '86843175207',
                                                                                                'in_ucast_pkts': '72856062',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13682147640',
                                                                                                'out_octets': '13705641394',
                                                                                                'out_ucast_pkts': '23493754',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '41/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13682147640',
                                                                       'out_octets': '13705641394',
                                                                       'out_ucast_pkts': '23493754',
                                                                       'poller_hash': 'ODdCQThEcGVlcmludGY0MS9ncDE=',
                                                                       'pons': [       {       'id': '41',
                                                                                               'links': [       {       'connected_time': '2908006',
                                                                                                                        'fiber_length': 842,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '41/gp1',
                                                                                               'poller_hash': 'ODdCQThEcGVlcnBvbjQxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 41',
                                         'poller_hash': 'ODdCQThE',
                                         'serial_number': '87BA8D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:a7',
                                         'uptime': '2908006'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001057',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '22317947702',
                                                                       'in_octets': '22442882796',
                                                                       'in_ucast_pkts': '124935094',
                                                                       'mac_address': 'd0:76:8f:1f:f1:fb',
                                                                       'mtu': 2000,
                                                                       'name': '42/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '483681941772',
                                                                       'out_octets': '484049985904',
                                                                       'out_ucast_pkts': '368044132',
                                                                       'poller_hash': 'ODdCQUE5cGVlcmludGY0Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '42',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '483681941772',
                                                                       'in_octets': '484049985904',
                                                                       'in_ucast_pkts': '368044132',
                                                                       'links': [       {       'bridged_mac_addresses': [       '90:a7:c1:56:33:01'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '483681941772',
                                                                                                'in_octets': '484049985904',
                                                                                                'in_ucast_pkts': '368044132',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '22317947702',
                                                                                                'out_octets': '22442882796',
                                                                                                'out_ucast_pkts': '124935094',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '42/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '22317947702',
                                                                       'out_octets': '22442882796',
                                                                       'out_ucast_pkts': '124935094',
                                                                       'poller_hash': 'ODdCQUE5cGVlcmludGY0Mi9ncDE=',
                                                                       'pons': [       {       'id': '42',
                                                                                               'links': [       {       'connected_time': '2907996',
                                                                                                                        'fiber_length': 582,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '42/gp1',
                                                                                               'poller_hash': 'ODdCQUE5cGVlcnBvbjQyL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 42',
                                         'poller_hash': 'ODdCQUE5',
                                         'serial_number': '87BAA9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:fb',
                                         'uptime': '2907996'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001121',
                                                                       'name': '44/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCOTQwcGVlcmludGY0NC9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '44',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '44/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCOTQwcGVlcmludGY0NC9ncDE=',
                                                                       'pons': [       {       'id': '44',
                                                                                               'links': [       {       'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '44/gp1',
                                                                                               'poller_hash': 'ODdCOTQwcGVlcnBvbjQ0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'name': 'ont 44',
                                         'poller_hash': 'ODdCOTQw',
                                         'serial_number': '87B940',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001185',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6520433516',
                                                                       'in_octets': '6574771549',
                                                                       'in_ucast_pkts': '54338033',
                                                                       'mac_address': 'd0:76:8f:1f:ef:4c',
                                                                       'mtu': 2000,
                                                                       'name': '46/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '341205354897',
                                                                       'out_octets': '341441351161',
                                                                       'out_ucast_pkts': '235996264',
                                                                       'poller_hash': 'ODdCOUM0cGVlcmludGY0Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '46',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '341205354897',
                                                                       'in_octets': '341441351161',
                                                                       'in_ucast_pkts': '235996264',
                                                                       'links': [       {       'bridged_mac_addresses': [       '84:16:f9:d6:d5:3c'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '341205354897',
                                                                                                'in_octets': '341441351161',
                                                                                                'in_ucast_pkts': '235996264',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '6520433516',
                                                                                                'out_octets': '6574771549',
                                                                                                'out_ucast_pkts': '54338033',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2UxLzEvZ3A2'}],
                                                                       'name': '46/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6520433516',
                                                                       'out_octets': '6574771549',
                                                                       'out_ucast_pkts': '54338033',
                                                                       'poller_hash': 'ODdCOUM0cGVlcmludGY0Ni9ncDE=',
                                                                       'pons': [       {       'id': '46',
                                                                                               'links': [       {       'connected_time': '692014',
                                                                                                                        'fiber_length': 1456,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNlMTEwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '46/gp1',
                                                                                               'poller_hash': 'ODdCOUM0cGVlcnBvbjQ2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 46',
                                         'poller_hash': 'ODdCOUM0',
                                         'serial_number': '87B9C4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:4c',
                                         'uptime': '692014'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001217',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '110409506298',
                                                                       'in_octets': '110750631143',
                                                                       'in_ucast_pkts': '341124845',
                                                                       'mac_address': 'd0:76:8f:1f:ef:ca',
                                                                       'mtu': 2000,
                                                                       'name': '47/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1245041801479',
                                                                       'out_octets': '1245987765171',
                                                                       'out_ucast_pkts': '945963692',
                                                                       'poller_hash': 'ODdCOUVFcGVlcmludGY0Ny9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '47',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1245041801479',
                                                                       'in_octets': '1245987765171',
                                                                       'in_ucast_pkts': '945963692',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:1e:d7:71'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1245041801479',
                                                                                                'in_octets': '1245987765171',
                                                                                                'in_ucast_pkts': '945963692',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '110409506298',
                                                                                                'out_octets': '110750631143',
                                                                                                'out_ucast_pkts': '341124845',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '47/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '110409506298',
                                                                       'out_octets': '110750631143',
                                                                       'out_ucast_pkts': '341124845',
                                                                       'poller_hash': 'ODdCOUVFcGVlcmludGY0Ny9ncDE=',
                                                                       'pons': [       {       'id': '47',
                                                                                               'links': [       {       'connected_time': '2908002',
                                                                                                                        'fiber_length': 1357,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '47/gp1',
                                                                                               'poller_hash': 'ODdCOUVFcGVlcnBvbjQ3L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 47',
                                         'poller_hash': 'ODdCOUVF',
                                         'serial_number': '87B9EE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:ca',
                                         'uptime': '2908002'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001249',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '34105741822',
                                                                       'in_octets': '34340532216',
                                                                       'in_ucast_pkts': '234790394',
                                                                       'mac_address': 'd0:76:8f:1f:ef:d3',
                                                                       'mtu': 2000,
                                                                       'name': '48/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '908751354807',
                                                                       'out_octets': '909415017317',
                                                                       'out_ucast_pkts': '663662510',
                                                                       'poller_hash': 'ODdCOUYxcGVlcmludGY0OC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '48',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '908751354807',
                                                                       'in_octets': '909415017317',
                                                                       'in_ucast_pkts': '663662510',
                                                                       'links': [       {       'bridged_mac_addresses': [       '6c:72:20:12:4c:9f'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '908751354807',
                                                                                                'in_octets': '909415017317',
                                                                                                'in_ucast_pkts': '663662510',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '34105741822',
                                                                                                'out_octets': '34340532216',
                                                                                                'out_ucast_pkts': '234790394',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2YxLzEvZ3A3'}],
                                                                       'name': '48/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '34105741822',
                                                                       'out_octets': '34340532216',
                                                                       'out_ucast_pkts': '234790394',
                                                                       'poller_hash': 'ODdCOUYxcGVlcmludGY0OC9ncDE=',
                                                                       'pons': [       {       'id': '48',
                                                                                               'links': [       {       'connected_time': '5351998',
                                                                                                                        'fiber_length': 1340,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNmMTEwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '48/gp1',
                                                                                               'poller_hash': 'ODdCOUYxcGVlcnBvbjQ4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 48',
                                         'poller_hash': 'ODdCOUYx',
                                         'serial_number': '87B9F1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:d3',
                                         'uptime': '5351998'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001281',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '29419365769',
                                                                       'in_octets': '29510108313',
                                                                       'in_ucast_pkts': '90742544',
                                                                       'mac_address': 'd0:76:8f:1f:ef:c7',
                                                                       'mtu': 2000,
                                                                       'name': '49/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '423273552059',
                                                                       'out_octets': '423592382756',
                                                                       'out_ucast_pkts': '318830697',
                                                                       'poller_hash': 'ODdCOUVEcGVlcmludGY0OS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '49',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '423273552059',
                                                                       'in_octets': '423592382756',
                                                                       'in_ucast_pkts': '318830697',
                                                                       'links': [       {       'bridged_mac_addresses': [       '3c:37:86:6a:3d:14'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '423273552059',
                                                                                                'in_octets': '423592382756',
                                                                                                'in_ucast_pkts': '318830697',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '29419365769',
                                                                                                'out_octets': '29510108313',
                                                                                                'out_ucast_pkts': '90742544',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '49/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '29419365769',
                                                                       'out_octets': '29510108313',
                                                                       'out_ucast_pkts': '90742544',
                                                                       'poller_hash': 'ODdCOUVEcGVlcmludGY0OS9ncDE=',
                                                                       'pons': [       {       'id': '49',
                                                                                               'links': [       {       'connected_time': '2908007',
                                                                                                                        'fiber_length': 1230,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '49/gp1',
                                                                                               'poller_hash': 'ODdCOUVEcGVlcnBvbjQ5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 49',
                                         'poller_hash': 'ODdCOUVE',
                                         'serial_number': '87B9ED',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:c7',
                                         'uptime': '2908007'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001345',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '345594501105',
                                                                       'in_octets': '345911223132',
                                                                       'in_ucast_pkts': '316722027',
                                                                       'mac_address': 'd0:76:8f:1f:ef:b8',
                                                                       'mtu': 2000,
                                                                       'name': '51/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '399268977648',
                                                                       'out_octets': '399600525833',
                                                                       'out_ucast_pkts': '331548185',
                                                                       'poller_hash': 'ODdCOUU4cGVlcmludGY1MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '51',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '399268977648',
                                                                       'in_octets': '399600525833',
                                                                       'in_ucast_pkts': '331548185',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:7c:2a:ea'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '399268977648',
                                                                                                'in_octets': '399600525833',
                                                                                                'in_ucast_pkts': '331548185',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '345594501105',
                                                                                                'out_octets': '345911223132',
                                                                                                'out_ucast_pkts': '316722027',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '51/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '345594501105',
                                                                       'out_octets': '345911223132',
                                                                       'out_ucast_pkts': '316722027',
                                                                       'poller_hash': 'ODdCOUU4cGVlcmludGY1MS9ncDE=',
                                                                       'pons': [       {       'id': '51',
                                                                                               'links': [       {       'connected_time': '2907999',
                                                                                                                        'fiber_length': 1274,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '51/gp1',
                                                                                               'poller_hash': 'ODdCOUU4cGVlcnBvbjUxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 51',
                                         'poller_hash': 'ODdCOUU4',
                                         'serial_number': '87B9E8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:b8',
                                         'uptime': '2907999'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001441',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '46217746986',
                                                                       'in_octets': '46472173116',
                                                                       'in_ucast_pkts': '254426130',
                                                                       'mac_address': 'd0:76:8f:1f:f0:09',
                                                                       'mtu': 2000,
                                                                       'name': '54/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1365431048996',
                                                                       'out_octets': '1366373228101',
                                                                       'out_ucast_pkts': '942179105',
                                                                       'poller_hash': 'ODdCQTAzcGVlcmludGY1NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '54',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1365431048996',
                                                                       'in_octets': '1366373228101',
                                                                       'in_ucast_pkts': '942179105',
                                                                       'links': [       {       'bridged_mac_addresses': [       '18:d6:c7:23:bb:2d'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1365431048996',
                                                                                                'in_octets': '1366373228101',
                                                                                                'in_ucast_pkts': '942179105',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '46217746986',
                                                                                                'out_octets': '46472173116',
                                                                                                'out_ucast_pkts': '254426130',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '54/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '46217746986',
                                                                       'out_octets': '46472173116',
                                                                       'out_ucast_pkts': '254426130',
                                                                       'poller_hash': 'ODdCQTAzcGVlcmludGY1NC9ncDE=',
                                                                       'pons': [       {       'id': '54',
                                                                                               'links': [       {       'connected_time': '2908013',
                                                                                                                        'fiber_length': 1378,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '54/gp1',
                                                                                               'poller_hash': 'ODdCQTAzcGVlcnBvbjU0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 54',
                                         'poller_hash': 'ODdCQTAz',
                                         'serial_number': '87BA03',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:09',
                                         'uptime': '2908013'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001473',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '65328542730',
                                                                       'in_octets': '65719983793',
                                                                       'in_ucast_pkts': '391441063',
                                                                       'mac_address': 'd0:76:8f:1f:ef:e2',
                                                                       'mtu': 2000,
                                                                       'name': '55/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1597936986595',
                                                                       'out_octets': '1599015513739',
                                                                       'out_ucast_pkts': '1078527144',
                                                                       'poller_hash': 'ODdCOUY2cGVlcmludGY1NS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '55',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1597936986595',
                                                                       'in_octets': '1599015513739',
                                                                       'in_ucast_pkts': '1078527144',
                                                                       'links': [       {       'bridged_mac_addresses': [       'e4:6f:13:36:d9:2f'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1597936986595',
                                                                                                'in_octets': '1599015513739',
                                                                                                'in_ucast_pkts': '1078527144',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '65328542730',
                                                                                                'out_octets': '65719983793',
                                                                                                'out_ucast_pkts': '391441063',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '55/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '65328542730',
                                                                       'out_octets': '65719983793',
                                                                       'out_ucast_pkts': '391441063',
                                                                       'poller_hash': 'ODdCOUY2cGVlcmludGY1NS9ncDE=',
                                                                       'pons': [       {       'id': '55',
                                                                                               'links': [       {       'connected_time': '2907984',
                                                                                                                        'fiber_length': 1242,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '55/gp1',
                                                                                               'poller_hash': 'ODdCOUY2cGVlcnBvbjU1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 55',
                                         'poller_hash': 'ODdCOUY2',
                                         'serial_number': '87B9F6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:e2',
                                         'uptime': '2907984'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001537',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '32984859770',
                                                                       'in_octets': '33207453738',
                                                                       'in_ucast_pkts': '222593968',
                                                                       'mac_address': 'd0:76:8f:1f:f0:12',
                                                                       'mtu': 2000,
                                                                       'name': '57/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '759914587042',
                                                                       'out_octets': '760532808128',
                                                                       'out_ucast_pkts': '618221086',
                                                                       'poller_hash': 'ODdCQTA2cGVlcmludGY1Ny9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '57',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '759914587042',
                                                                       'in_octets': '760532808128',
                                                                       'in_ucast_pkts': '618221086',
                                                                       'links': [       {       'bridged_mac_addresses': [       'c4:e9:0a:4e:e9:80'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '759914587042',
                                                                                                'in_octets': '760532808128',
                                                                                                'in_ucast_pkts': '618221086',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '32984859770',
                                                                                                'out_octets': '33207453738',
                                                                                                'out_ucast_pkts': '222593968',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '57/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '32984859770',
                                                                       'out_octets': '33207453738',
                                                                       'out_ucast_pkts': '222593968',
                                                                       'poller_hash': 'ODdCQTA2cGVlcmludGY1Ny9ncDE=',
                                                                       'pons': [       {       'id': '57',
                                                                                               'links': [       {       'connected_time': '5352005',
                                                                                                                        'fiber_length': 1447,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '57/gp1',
                                                                                               'poller_hash': 'ODdCQTA2cGVlcnBvbjU3L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 57',
                                         'poller_hash': 'ODdCQTA2',
                                         'serial_number': '87BA06',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:12',
                                         'uptime': '5352005'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001569',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '23138393185',
                                                                       'in_octets': '23292697540',
                                                                       'in_ucast_pkts': '154304355',
                                                                       'mac_address': 'd0:76:8f:1f:ef:61',
                                                                       'mtu': 2000,
                                                                       'name': '58/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '508307869277',
                                                                       'out_octets': '508685308761',
                                                                       'out_ucast_pkts': '377439484',
                                                                       'poller_hash': 'ODdCOUNCcGVlcmludGY1OC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '58',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '508307869277',
                                                                       'in_octets': '508685308761',
                                                                       'in_ucast_pkts': '377439484',
                                                                       'links': [       {       'bridged_mac_addresses': [       'b8:94:70:cf:b4:68'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '508307869277',
                                                                                                'in_octets': '508685308761',
                                                                                                'in_ucast_pkts': '377439484',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '23138393185',
                                                                                                'out_octets': '23292697540',
                                                                                                'out_ucast_pkts': '154304355',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2QxLzEvZ3A1'}],
                                                                       'name': '58/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '23138393185',
                                                                       'out_octets': '23292697540',
                                                                       'out_ucast_pkts': '154304355',
                                                                       'poller_hash': 'ODdCOUNCcGVlcmludGY1OC9ncDE=',
                                                                       'pons': [       {       'id': '58',
                                                                                               'links': [       {       'connected_time': '5696037',
                                                                                                                        'fiber_length': 1520,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNkMTEwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '58/gp1',
                                                                                               'poller_hash': 'ODdCOUNCcGVlcnBvbjU4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 58',
                                         'poller_hash': 'ODdCOUNC',
                                         'serial_number': '87B9CB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:61',
                                         'uptime': '5696037'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001665',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '48400289221',
                                                                       'in_octets': '48607604843',
                                                                       'in_ucast_pkts': '207315622',
                                                                       'mac_address': 'd0:76:8f:1f:f0:0f',
                                                                       'mtu': 2000,
                                                                       'name': '61/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1156362086182',
                                                                       'out_octets': '1157265640709',
                                                                       'out_ucast_pkts': '903554527',
                                                                       'poller_hash': 'ODdCQTA1cGVlcmludGY2MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '61',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1156362086182',
                                                                       'in_octets': '1157265640709',
                                                                       'in_ucast_pkts': '903554527',
                                                                       'links': [       {       'bridged_mac_addresses': [       'c4:e9:0a:4e:ed:54'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1156362086182',
                                                                                                'in_octets': '1157265640709',
                                                                                                'in_ucast_pkts': '903554527',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '48400289221',
                                                                                                'out_octets': '48607604843',
                                                                                                'out_ucast_pkts': '207315622',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '61/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '48400289221',
                                                                       'out_octets': '48607604843',
                                                                       'out_ucast_pkts': '207315622',
                                                                       'poller_hash': 'ODdCQTA1cGVlcmludGY2MS9ncDE=',
                                                                       'pons': [       {       'id': '61',
                                                                                               'links': [       {       'connected_time': '5352037',
                                                                                                                        'fiber_length': 1417,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '61/gp1',
                                                                                               'poller_hash': 'ODdCQTA1cGVlcnBvbjYxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 61',
                                         'poller_hash': 'ODdCQTA1',
                                         'serial_number': '87BA05',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:0f',
                                         'uptime': '5352037'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001697',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11340527447',
                                                                       'in_octets': '11427465913',
                                                                       'in_ucast_pkts': '86938466',
                                                                       'mac_address': 'd0:76:8f:1f:ef:ee',
                                                                       'mtu': 2000,
                                                                       'name': '62/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '401108404887',
                                                                       'out_octets': '401390678766',
                                                                       'out_ucast_pkts': '282273879',
                                                                       'poller_hash': 'ODdCOUZBcGVlcmludGY2Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '62',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '401108404887',
                                                                       'in_octets': '401390678766',
                                                                       'in_ucast_pkts': '282273879',
                                                                       'links': [       {       'bridged_mac_addresses': [       '14:eb:b6:af:d8:79'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '401108404887',
                                                                                                'in_octets': '401390678766',
                                                                                                'in_ucast_pkts': '282273879',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '11340527447',
                                                                                                'out_octets': '11427465913',
                                                                                                'out_ucast_pkts': '86938466',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '62/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '11340527447',
                                                                       'out_octets': '11427465913',
                                                                       'out_ucast_pkts': '86938466',
                                                                       'poller_hash': 'ODdCOUZBcGVlcmludGY2Mi9ncDE=',
                                                                       'pons': [       {       'id': '62',
                                                                                               'links': [       {       'connected_time': '2908014',
                                                                                                                        'fiber_length': 916,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '62/gp1',
                                                                                               'poller_hash': 'ODdCOUZBcGVlcnBvbjYyL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 62',
                                         'poller_hash': 'ODdCOUZB',
                                         'serial_number': '87B9FA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:ee',
                                         'uptime': '2908014'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001729',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '55774836841',
                                                                       'in_octets': '56087604239',
                                                                       'in_ucast_pkts': '312767398',
                                                                       'mac_address': 'd0:76:8f:1f:f0:06',
                                                                       'mtu': 2000,
                                                                       'name': '63/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1529689147698',
                                                                       'out_octets': '1530751155258',
                                                                       'out_ucast_pkts': '1062007560',
                                                                       'poller_hash': 'ODdCQTAycGVlcmludGY2My9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '63',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1529689147698',
                                                                       'in_octets': '1530751155258',
                                                                       'in_ucast_pkts': '1062007560',
                                                                       'links': [       {       'bridged_mac_addresses': [       '40:9b:cd:2c:ea:c3'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1529689147698',
                                                                                                'in_octets': '1530751155258',
                                                                                                'in_ucast_pkts': '1062007560',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '55774836841',
                                                                                                'out_octets': '56087604239',
                                                                                                'out_ucast_pkts': '312767398',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2IxLzEvZ3Az'}],
                                                                       'name': '63/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '55774836841',
                                                                       'out_octets': '56087604239',
                                                                       'out_ucast_pkts': '312767398',
                                                                       'poller_hash': 'ODdCQTAycGVlcmludGY2My9ncDE=',
                                                                       'pons': [       {       'id': '63',
                                                                                               'links': [       {       'connected_time': '2907990',
                                                                                                                        'fiber_length': 1065,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNiMTEwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '63/gp1',
                                                                                               'poller_hash': 'ODdCQTAycGVlcnBvbjYzL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 63',
                                         'poller_hash': 'ODdCQTAy',
                                         'serial_number': '87BA02',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:06',
                                         'uptime': '2907990'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001761',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20013903867',
                                                                       'in_octets': '20225962816',
                                                                       'in_ucast_pkts': '212058949',
                                                                       'mac_address': 'd0:76:8f:1f:ec:d0',
                                                                       'mtu': 2000,
                                                                       'name': '64/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1458931306758',
                                                                       'out_octets': '1459932234396',
                                                                       'out_ucast_pkts': '1000927638',
                                                                       'poller_hash': 'ODdCOEYwcGVlcmludGY2NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '64',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1458931306758',
                                                                       'in_octets': '1459932234396',
                                                                       'in_ucast_pkts': '1000927638',
                                                                       'links': [       {       'bridged_mac_addresses': [       '9c:3d:cf:05:1f:7d'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1458931306758',
                                                                                                'in_octets': '1459932234396',
                                                                                                'in_ucast_pkts': '1000927638',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '20013903867',
                                                                                                'out_octets': '20225962816',
                                                                                                'out_ucast_pkts': '212058949',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '64/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '20013903867',
                                                                       'out_octets': '20225962816',
                                                                       'out_ucast_pkts': '212058949',
                                                                       'poller_hash': 'ODdCOEYwcGVlcmludGY2NC9ncDE=',
                                                                       'pons': [       {       'id': '64',
                                                                                               'links': [       {       'connected_time': '2402349',
                                                                                                                        'fiber_length': 1175,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '64/gp1',
                                                                                               'poller_hash': 'ODdCOEYwcGVlcnBvbjY0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 64',
                                         'poller_hash': 'ODdCOEYw',
                                         'serial_number': '87B8F0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ec:d0',
                                         'uptime': '2402349'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001793',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '34648217472',
                                                                       'in_octets': '34796819724',
                                                                       'in_ucast_pkts': '148602252',
                                                                       'mac_address': 'd0:76:8f:1f:e0:28',
                                                                       'mtu': 2000,
                                                                       'name': '65/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1382313447793',
                                                                       'out_octets': '1383297527858',
                                                                       'out_ucast_pkts': '984080065',
                                                                       'poller_hash': 'ODdCNEI4cGVlcmludGY2NS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '65',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1382313447793',
                                                                       'in_octets': '1383297527858',
                                                                       'in_ucast_pkts': '984080065',
                                                                       'links': [       {       'bridged_mac_addresses': [       '84:d3:43:01:34:91'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1382313447793',
                                                                                                'in_octets': '1383297527858',
                                                                                                'in_ucast_pkts': '984080065',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '34648217472',
                                                                                                'out_octets': '34796819724',
                                                                                                'out_ucast_pkts': '148602252',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '65/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '34648217472',
                                                                       'out_octets': '34796819724',
                                                                       'out_ucast_pkts': '148602252',
                                                                       'poller_hash': 'ODdCNEI4cGVlcmludGY2NS9ncDE=',
                                                                       'pons': [       {       'id': '65',
                                                                                               'links': [       {       'connected_time': '5351977',
                                                                                                                        'fiber_length': 1198,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '65/gp1',
                                                                                               'poller_hash': 'ODdCNEI4cGVlcnBvbjY1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 65',
                                         'poller_hash': 'ODdCNEI4',
                                         'serial_number': '87B4B8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:e0:28',
                                         'uptime': '5351977'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001825',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3635900891',
                                                                       'in_octets': '3647840753',
                                                                       'in_ucast_pkts': '11939862',
                                                                       'mac_address': 'd0:76:8f:1f:ed:09',
                                                                       'mtu': 2000,
                                                                       'name': '66/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '47343596552',
                                                                       'out_octets': '47382256245',
                                                                       'out_ucast_pkts': '38659693',
                                                                       'poller_hash': 'ODdCOTAzcGVlcmludGY2Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '66',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '47343596552',
                                                                       'in_octets': '47382256245',
                                                                       'in_ucast_pkts': '38659693',
                                                                       'links': [       {       'bridged_mac_addresses': [       'a8:5e:45:dd:42:00'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '47343596552',
                                                                                                'in_octets': '47382256245',
                                                                                                'in_ucast_pkts': '38659693',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3635900891',
                                                                                                'out_octets': '3647840753',
                                                                                                'out_ucast_pkts': '11939862',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '66/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3635900891',
                                                                       'out_octets': '3647840753',
                                                                       'out_ucast_pkts': '11939862',
                                                                       'poller_hash': 'ODdCOTAzcGVlcmludGY2Ni9ncDE=',
                                                                       'pons': [       {       'id': '66',
                                                                                               'links': [       {       'connected_time': '2907998',
                                                                                                                        'fiber_length': 501,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '66/gp1',
                                                                                               'poller_hash': 'ODdCOTAzcGVlcnBvbjY2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 66',
                                         'poller_hash': 'ODdCOTAz',
                                         'serial_number': '87B903',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ed:09',
                                         'uptime': '2907998'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001985',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '43869263520',
                                                                       'in_octets': '43935020501',
                                                                       'in_ucast_pkts': '65756981',
                                                                       'mac_address': 'd0:76:8f:1f:fe:c4',
                                                                       'mtu': 2000,
                                                                       'name': '71/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '185472597110',
                                                                       'out_octets': '185636889735',
                                                                       'out_ucast_pkts': '164292625',
                                                                       'poller_hash': 'ODdCRUVDcGVlcmludGY3MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '71',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '185472597110',
                                                                       'in_octets': '185636889735',
                                                                       'in_ucast_pkts': '164292625',
                                                                       'links': [       {       'bridged_mac_addresses': [       'bc:0f:9a:7a:eb:1e'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '185472597110',
                                                                                                'in_octets': '185636889735',
                                                                                                'in_ucast_pkts': '164292625',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '43869263520',
                                                                                                'out_octets': '43935020501',
                                                                                                'out_ucast_pkts': '65756981',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '71/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '43869263520',
                                                                       'out_octets': '43935020501',
                                                                       'out_ucast_pkts': '65756981',
                                                                       'poller_hash': 'ODdCRUVDcGVlcmludGY3MS9ncDE=',
                                                                       'pons': [       {       'id': '71',
                                                                                               'links': [       {       'connected_time': '2907975',
                                                                                                                        'fiber_length': 1332,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '71/gp1',
                                                                                               'poller_hash': 'ODdCRUVDcGVlcnBvbjcxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 71',
                                         'poller_hash': 'ODdCRUVD',
                                         'serial_number': '87BEEC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:fe:c4',
                                         'uptime': '2907975'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002081',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12541850932',
                                                                       'in_octets': '12625353551',
                                                                       'in_ucast_pkts': '83502619',
                                                                       'mac_address': 'd0:76:8f:1f:fe:b2',
                                                                       'mtu': 2000,
                                                                       'name': '74/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '263145872385',
                                                                       'out_octets': '263362047486',
                                                                       'out_ucast_pkts': '216175101',
                                                                       'poller_hash': 'ODdCRUU2cGVlcmludGY3NC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '74',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '263145872385',
                                                                       'in_octets': '263362047486',
                                                                       'in_ucast_pkts': '216175101',
                                                                       'links': [       {       'bridged_mac_addresses': [       'b4:75:0e:a7:0e:23'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '263145872385',
                                                                                                'in_octets': '263362047486',
                                                                                                'in_ucast_pkts': '216175101',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '12541850932',
                                                                                                'out_octets': '12625353551',
                                                                                                'out_ucast_pkts': '83502619',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2IxLzEvZ3Az'}],
                                                                       'name': '74/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '12541850932',
                                                                       'out_octets': '12625353551',
                                                                       'out_ucast_pkts': '83502619',
                                                                       'poller_hash': 'ODdCRUU2cGVlcmludGY3NC9ncDE=',
                                                                       'pons': [       {       'id': '74',
                                                                                               'links': [       {       'connected_time': '4995983',
                                                                                                                        'fiber_length': 1242,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNiMTEwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '74/gp1',
                                                                                               'poller_hash': 'ODdCRUU2cGVlcnBvbjc0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 74',
                                         'poller_hash': 'ODdCRUU2',
                                         'serial_number': '87BEE6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:fe:b2',
                                         'uptime': '4995983'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002113',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '23225203535',
                                                                       'in_octets': '23462763243',
                                                                       'in_ucast_pkts': '237559708',
                                                                       'mac_address': 'd0:76:8f:1f:fe:bb',
                                                                       'mtu': 2000,
                                                                       'name': '75/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '800134887019',
                                                                       'out_octets': '800690829534',
                                                                       'out_ucast_pkts': '555942515',
                                                                       'poller_hash': 'ODdCRUU5cGVlcmludGY3NS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '75',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '800134887019',
                                                                       'in_octets': '800690829534',
                                                                       'in_ucast_pkts': '555942515',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:05:6f:74'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '800134887019',
                                                                                                'in_octets': '800690829534',
                                                                                                'in_ucast_pkts': '555942515',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '23225203535',
                                                                                                'out_octets': '23462763243',
                                                                                                'out_ucast_pkts': '237559708',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '75/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '23225203535',
                                                                       'out_octets': '23462763243',
                                                                       'out_ucast_pkts': '237559708',
                                                                       'poller_hash': 'ODdCRUU5cGVlcmludGY3NS9ncDE=',
                                                                       'pons': [       {       'id': '75',
                                                                                               'links': [       {       'connected_time': '2908043',
                                                                                                                        'fiber_length': 1369,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '75/gp1',
                                                                                               'poller_hash': 'ODdCRUU5cGVlcnBvbjc1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 75',
                                         'poller_hash': 'ODdCRUU5',
                                         'serial_number': '87BEE9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:fe:bb',
                                         'uptime': '2908043'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002209',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '45983706549',
                                                                       'in_octets': '46249391212',
                                                                       'in_ucast_pkts': '265684663',
                                                                       'mac_address': 'd0:76:8f:1f:f1:9b',
                                                                       'mtu': 2000,
                                                                       'name': '78/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1305346866741',
                                                                       'out_octets': '1306255503495',
                                                                       'out_ucast_pkts': '908636754',
                                                                       'poller_hash': 'ODdCQTg5cGVlcmludGY3OC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '78',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1305346866741',
                                                                       'in_octets': '1306255503495',
                                                                       'in_ucast_pkts': '908636754',
                                                                       'links': [       {       'bridged_mac_addresses': [       'c4:71:54:1d:a7:d4'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1305346866741',
                                                                                                'in_octets': '1306255503495',
                                                                                                'in_ucast_pkts': '908636754',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '45983706549',
                                                                                                'out_octets': '46249391212',
                                                                                                'out_ucast_pkts': '265684663',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2IxLzEvZ3Az'}],
                                                                       'name': '78/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '45983706549',
                                                                       'out_octets': '46249391212',
                                                                       'out_ucast_pkts': '265684663',
                                                                       'poller_hash': 'ODdCQTg5cGVlcmludGY3OC9ncDE=',
                                                                       'pons': [       {       'id': '78',
                                                                                               'links': [       {       'connected_time': '5351981',
                                                                                                                        'fiber_length': 1175,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNiMTEwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '78/gp1',
                                                                                               'poller_hash': 'ODdCQTg5cGVlcnBvbjc4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 78',
                                         'poller_hash': 'ODdCQTg5',
                                         'serial_number': '87BA89',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:9b',
                                         'uptime': '5351981'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002241',
                                                                       'name': '79/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCQTlCcGVlcmludGY3OS9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '79',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2IxLzEvZ3Az'}],
                                                                       'name': '79/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCQTlCcGVlcmludGY3OS9ncDE=',
                                                                       'pons': [       {       'id': '79',
                                                                                               'links': [       {       'poller_hash': 'NDg3NzQ2NTNiZGNiMTEwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '79/gp1',
                                                                                               'poller_hash': 'ODdCQTlCcGVlcnBvbjc5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'name': 'ont 79',
                                         'poller_hash': 'ODdCQTlC',
                                         'serial_number': '87BA9B',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002273',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '51518498594',
                                                                       'in_octets': '51755018596',
                                                                       'in_ucast_pkts': '236520002',
                                                                       'mac_address': 'd0:76:8f:1f:f0:6c',
                                                                       'mtu': 2000,
                                                                       'name': '80/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1267943192010',
                                                                       'out_octets': '1268827529006',
                                                                       'out_ucast_pkts': '884336996',
                                                                       'poller_hash': 'ODdCQTI0cGVlcmludGY4MC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '80',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1267943192010',
                                                                       'in_octets': '1268827529006',
                                                                       'in_ucast_pkts': '884336996',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:00:38:f5'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1267943192010',
                                                                                                'in_octets': '1268827529006',
                                                                                                'in_ucast_pkts': '884336996',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '51518498594',
                                                                                                'out_octets': '51755018596',
                                                                                                'out_ucast_pkts': '236520002',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2YxLzEvZ3A3'}],
                                                                       'name': '80/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '51518498594',
                                                                       'out_octets': '51755018596',
                                                                       'out_ucast_pkts': '236520002',
                                                                       'poller_hash': 'ODdCQTI0cGVlcmludGY4MC9ncDE=',
                                                                       'pons': [       {       'id': '80',
                                                                                               'links': [       {       'connected_time': '5351981',
                                                                                                                        'fiber_length': 1145,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNmMTEwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '80/gp1',
                                                                                               'poller_hash': 'ODdCQTI0cGVlcnBvbjgwL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 80',
                                         'poller_hash': 'ODdCQTI0',
                                         'serial_number': '87BA24',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:6c',
                                         'uptime': '5351981'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002337',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': 'd0:76:8f:1f:f2:13',
                                                                       'mtu': 2000,
                                                                       'name': '82/g1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ODdCQUIxcGVlcmludGY4Mi9nMQ==',
                                                                       'speed': '0'},
                                                               {       'admin_up': True,
                                                                       'id': '82',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '0',
                                                                                                'in_ucast_pkts': '0',
                                                                                                'oper_up': False,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '0',
                                                                                                'out_ucast_pkts': '0',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2YxLzEvZ3A3'}],
                                                                       'name': '82/gp1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ODdCQUIxcGVlcmludGY4Mi9ncDE=',
                                                                       'pons': [       {       'id': '82',
                                                                                               'links': [       {       'connected_time': '905102',
                                                                                                                        'fiber_length': 1339,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNmMTEwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '82/gp1',
                                                                                               'poller_hash': 'ODdCQUIxcGVlcnBvbjgyL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 82',
                                         'poller_hash': 'ODdCQUIx',
                                         'serial_number': '87BAB1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f2:13',
                                         'uptime': '905102'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002369',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '5178450518',
                                                                       'in_octets': '5217035699',
                                                                       'in_ucast_pkts': '38585181',
                                                                       'mac_address': 'd0:76:8f:1f:f1:4d',
                                                                       'mtu': 2000,
                                                                       'name': '83/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '137858504048',
                                                                       'out_octets': '137957706524',
                                                                       'out_ucast_pkts': '99202476',
                                                                       'poller_hash': 'ODdCQTZGcGVlcmludGY4My9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '83',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '137858504048',
                                                                       'in_octets': '137957706524',
                                                                       'in_ucast_pkts': '99202476',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:05:5d:2c'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '137858504048',
                                                                                                'in_octets': '137957706524',
                                                                                                'in_ucast_pkts': '99202476',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '5178450518',
                                                                                                'out_octets': '5217035699',
                                                                                                'out_ucast_pkts': '38585181',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2QxLzEvZ3A1'}],
                                                                       'name': '83/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '5178450518',
                                                                       'out_octets': '5217035699',
                                                                       'out_ucast_pkts': '38585181',
                                                                       'poller_hash': 'ODdCQTZGcGVlcmludGY4My9ncDE=',
                                                                       'pons': [       {       'id': '83',
                                                                                               'links': [       {       'connected_time': '761291',
                                                                                                                        'fiber_length': 1451,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNkMTEwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '83/gp1',
                                                                                               'poller_hash': 'ODdCQTZGcGVlcnBvbjgzL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 83',
                                         'poller_hash': 'ODdCQTZG',
                                         'serial_number': '87BA6F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:4d',
                                         'uptime': '761291'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002401',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4595914201',
                                                                       'in_octets': '4633574019',
                                                                       'in_ucast_pkts': '37659818',
                                                                       'mac_address': 'd0:76:8f:1f:f0:51',
                                                                       'mtu': 2000,
                                                                       'name': '84/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '338291897873',
                                                                       'out_octets': '338522777135',
                                                                       'out_ucast_pkts': '230879262',
                                                                       'poller_hash': 'ODdCQTFCcGVlcmludGY4NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '84',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '338291897873',
                                                                       'in_octets': '338522777135',
                                                                       'in_ucast_pkts': '230879262',
                                                                       'links': [       {       'bridged_mac_addresses': [       '58:d5:6e:c7:5c:3f'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '338291897873',
                                                                                                'in_octets': '338522777135',
                                                                                                'in_ucast_pkts': '230879262',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4595914201',
                                                                                                'out_octets': '4633574019',
                                                                                                'out_ucast_pkts': '37659818',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '84/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4595914201',
                                                                       'out_octets': '4633574019',
                                                                       'out_ucast_pkts': '37659818',
                                                                       'poller_hash': 'ODdCQTFCcGVlcmludGY4NC9ncDE=',
                                                                       'pons': [       {       'id': '84',
                                                                                               'links': [       {       'connected_time': '1648401',
                                                                                                                        'fiber_length': 1227,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '84/gp1',
                                                                                               'poller_hash': 'ODdCQTFCcGVlcnBvbjg0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 84',
                                         'poller_hash': 'ODdCQTFC',
                                         'serial_number': '87BA1B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:51',
                                         'uptime': '1648401'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002433',
                                                                       'name': '85/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCQTIycGVlcmludGY4NS9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '85',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '85/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCQTIycGVlcmludGY4NS9ncDE=',
                                                                       'pons': [       {       'id': '85',
                                                                                               'links': [       {       'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'name': '85/gp1',
                                                                                               'poller_hash': 'ODdCQTIycGVlcnBvbjg1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'name': 'ont 85',
                                         'poller_hash': 'ODdCQTIy',
                                         'serial_number': '87BA22',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002465',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '10907800459',
                                                                       'in_octets': '10956834303',
                                                                       'in_ucast_pkts': '49033844',
                                                                       'mac_address': 'd0:76:8f:1f:f0:69',
                                                                       'mtu': 2000,
                                                                       'name': '86/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '222309058641',
                                                                       'out_octets': '222480237271',
                                                                       'out_ucast_pkts': '171178630',
                                                                       'poller_hash': 'ODdCQTIzcGVlcmludGY4Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '86',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '222309058641',
                                                                       'in_octets': '222480237271',
                                                                       'in_ucast_pkts': '171178630',
                                                                       'links': [       {       'bridged_mac_addresses': [       '48:77:46:fe:81:80'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '222309058641',
                                                                                                'in_octets': '222480237271',
                                                                                                'in_ucast_pkts': '171178630',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '10907800459',
                                                                                                'out_octets': '10956834303',
                                                                                                'out_ucast_pkts': '49033844',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '86/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '10907800459',
                                                                       'out_octets': '10956834303',
                                                                       'out_ucast_pkts': '49033844',
                                                                       'poller_hash': 'ODdCQTIzcGVlcmludGY4Ni9ncDE=',
                                                                       'pons': [       {       'id': '86',
                                                                                               'links': [       {       'connected_time': '5696025',
                                                                                                                        'fiber_length': 1541,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '86/gp1',
                                                                                               'poller_hash': 'ODdCQTIzcGVlcnBvbjg2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 86',
                                         'poller_hash': 'ODdCQTIz',
                                         'serial_number': '87BA23',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:69',
                                         'uptime': '5696025'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002497',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '19836561339',
                                                                       'in_octets': '19926991262',
                                                                       'in_ucast_pkts': '90429923',
                                                                       'mac_address': 'd0:76:8f:1f:f0:5d',
                                                                       'mtu': 2000,
                                                                       'name': '87/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '286921387126',
                                                                       'out_octets': '287158022707',
                                                                       'out_ucast_pkts': '236635581',
                                                                       'poller_hash': 'ODdCQTFGcGVlcmludGY4Ny9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '87',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '286921387126',
                                                                       'in_octets': '287158022707',
                                                                       'in_ucast_pkts': '236635581',
                                                                       'links': [       {       'bridged_mac_addresses': [       '60:38:e0:d8:c8:63'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '286921387126',
                                                                                                'in_octets': '287158022707',
                                                                                                'in_ucast_pkts': '236635581',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '19836561339',
                                                                                                'out_octets': '19926991262',
                                                                                                'out_ucast_pkts': '90429923',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '87/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '19836561339',
                                                                       'out_octets': '19926991262',
                                                                       'out_ucast_pkts': '90429923',
                                                                       'poller_hash': 'ODdCQTFGcGVlcmludGY4Ny9ncDE=',
                                                                       'pons': [       {       'id': '87',
                                                                                               'links': [       {       'connected_time': '1601223',
                                                                                                                        'fiber_length': 1357,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '87/gp1',
                                                                                               'poller_hash': 'ODdCQTFGcGVlcnBvbjg3L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 87',
                                         'poller_hash': 'ODdCQTFG',
                                         'serial_number': '87BA1F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:5d',
                                         'uptime': '1601223'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002561',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1775981151',
                                                                       'in_octets': '1787301560',
                                                                       'in_ucast_pkts': '11320409',
                                                                       'mac_address': 'd0:76:8f:1f:ed:21',
                                                                       'mtu': 2000,
                                                                       'name': '89/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '33908880338',
                                                                       'out_octets': '33932785715',
                                                                       'out_ucast_pkts': '23905377',
                                                                       'poller_hash': 'ODdCOTBCcGVlcmludGY4OS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '89',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '33908880338',
                                                                       'in_octets': '33932785715',
                                                                       'in_ucast_pkts': '23905377',
                                                                       'links': [       {       'bridged_mac_addresses': [       '48:77:46:fe:dc:b2'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '33908880338',
                                                                                                'in_octets': '33932785715',
                                                                                                'in_ucast_pkts': '23905377',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1775981151',
                                                                                                'out_octets': '1787301560',
                                                                                                'out_ucast_pkts': '11320409',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '89/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1775981151',
                                                                       'out_octets': '1787301560',
                                                                       'out_ucast_pkts': '11320409',
                                                                       'poller_hash': 'ODdCOTBCcGVlcmludGY4OS9ncDE=',
                                                                       'pons': [       {       'id': '89',
                                                                                               'links': [       {       'connected_time': '181230',
                                                                                                                        'fiber_length': 1286,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '89/gp1',
                                                                                               'poller_hash': 'ODdCOTBCcGVlcnBvbjg5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 89',
                                         'poller_hash': 'ODdCOTBC',
                                         'serial_number': '87B90B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ed:21',
                                         'uptime': '181230'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002625',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '39120229349',
                                                                       'in_octets': '39288734457',
                                                                       'in_ucast_pkts': '168505108',
                                                                       'mac_address': 'd0:76:8f:1f:ef:fd',
                                                                       'mtu': 2000,
                                                                       'name': '91/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '434888344822',
                                                                       'out_octets': '435211914118',
                                                                       'out_ucast_pkts': '323569296',
                                                                       'poller_hash': 'ODdCOUZGcGVlcmludGY5MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '91',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '434888344822',
                                                                       'in_octets': '435211914118',
                                                                       'in_ucast_pkts': '323569296',
                                                                       'links': [       {       'bridged_mac_addresses': [       '48:77:46:f9:bf:76'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '434888344822',
                                                                                                'in_octets': '435211914118',
                                                                                                'in_ucast_pkts': '323569296',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '39120229349',
                                                                                                'out_octets': '39288734457',
                                                                                                'out_ucast_pkts': '168505108',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '91/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '39120229349',
                                                                       'out_octets': '39288734457',
                                                                       'out_ucast_pkts': '168505108',
                                                                       'poller_hash': 'ODdCOUZGcGVlcmludGY5MS9ncDE=',
                                                                       'pons': [       {       'id': '91',
                                                                                               'links': [       {       'connected_time': '1114752',
                                                                                                                        'fiber_length': 1272,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '91/gp1',
                                                                                               'poller_hash': 'ODdCOUZGcGVlcnBvbjkxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 91',
                                         'poller_hash': 'ODdCOUZG',
                                         'serial_number': '87B9FF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:fd',
                                         'uptime': '1114752'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002657',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '29194689096',
                                                                       'in_octets': '29342074869',
                                                                       'in_ucast_pkts': '147385773',
                                                                       'mac_address': 'd0:76:8f:1f:ef:19',
                                                                       'mtu': 2000,
                                                                       'name': '92/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '839636916811',
                                                                       'out_octets': '840233928247',
                                                                       'out_ucast_pkts': '597011436',
                                                                       'poller_hash': 'ODdCOUIzcGVlcmludGY5Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '92',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '839636916811',
                                                                       'in_octets': '840233928247',
                                                                       'in_ucast_pkts': '597011436',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:b2:36:44'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '839636916811',
                                                                                                'in_octets': '840233928247',
                                                                                                'in_ucast_pkts': '597011436',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '29194689096',
                                                                                                'out_octets': '29342074869',
                                                                                                'out_ucast_pkts': '147385773',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTgxLzIvZ3A4'}],
                                                                       'name': '92/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '29194689096',
                                                                       'out_octets': '29342074869',
                                                                       'out_ucast_pkts': '147385773',
                                                                       'poller_hash': 'ODdCOUIzcGVlcmludGY5Mi9ncDE=',
                                                                       'pons': [       {       'id': '92',
                                                                                               'links': [       {       'connected_time': '2907988',
                                                                                                                        'fiber_length': 456,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE4MTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '92/gp1',
                                                                                               'poller_hash': 'ODdCOUIzcGVlcnBvbjkyL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 92',
                                         'poller_hash': 'ODdCOUIz',
                                         'serial_number': '87B9B3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:19',
                                         'uptime': '2907988'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002721',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4777829540',
                                                                       'in_octets': '4811993229',
                                                                       'in_ucast_pkts': '34163689',
                                                                       'mac_address': 'd0:76:8f:1f:e9:fd',
                                                                       'mtu': 2000,
                                                                       'name': '94/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '161615072142',
                                                                       'out_octets': '161725789956',
                                                                       'out_ucast_pkts': '110717814',
                                                                       'poller_hash': 'ODdCN0ZGcGVlcmludGY5NC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '94',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '161615072142',
                                                                       'in_octets': '161725789956',
                                                                       'in_ucast_pkts': '110717814',
                                                                       'links': [       {       'bridged_mac_addresses': [       'a0:63:91:72:1d:1f'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '161615072142',
                                                                                                'in_octets': '161725789956',
                                                                                                'in_ucast_pkts': '110717814',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4777829540',
                                                                                                'out_octets': '4811993229',
                                                                                                'out_ucast_pkts': '34163689',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '94/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4777829540',
                                                                       'out_octets': '4811993229',
                                                                       'out_ucast_pkts': '34163689',
                                                                       'poller_hash': 'ODdCN0ZGcGVlcmludGY5NC9ncDE=',
                                                                       'pons': [       {       'id': '94',
                                                                                               'links': [       {       'connected_time': '231076',
                                                                                                                        'fiber_length': 1338,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '94/gp1',
                                                                                               'poller_hash': 'ODdCN0ZGcGVlcnBvbjk0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 94',
                                         'poller_hash': 'ODdCN0ZG',
                                         'serial_number': '87B7FF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:e9:fd',
                                         'uptime': '231076'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002753',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '52114281488',
                                                                       'in_octets': '52474307871',
                                                                       'in_ucast_pkts': '360026383',
                                                                       'mac_address': 'd0:76:8f:1f:f0:75',
                                                                       'mtu': 2000,
                                                                       'name': '96/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1058078576532',
                                                                       'out_octets': '1058837701547',
                                                                       'out_ucast_pkts': '759125015',
                                                                       'poller_hash': 'ODdCQTI3cGVlcmludGY5Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '96',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1058078576532',
                                                                       'in_octets': '1058837701547',
                                                                       'in_ucast_pkts': '759125015',
                                                                       'links': [       {       'bridged_mac_addresses': [       'e8:9f:80:dd:68:47'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1058078576532',
                                                                                                'in_octets': '1058837701547',
                                                                                                'in_ucast_pkts': '759125015',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '52114281488',
                                                                                                'out_octets': '52474307871',
                                                                                                'out_ucast_pkts': '360026383',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '96/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '52114281488',
                                                                       'out_octets': '52474307871',
                                                                       'out_ucast_pkts': '360026383',
                                                                       'poller_hash': 'ODdCQTI3cGVlcmludGY5Ni9ncDE=',
                                                                       'pons': [       {       'id': '96',
                                                                                               'links': [       {       'connected_time': '4096875',
                                                                                                                        'fiber_length': 1337,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '96/gp1',
                                                                                               'poller_hash': 'ODdCQTI3cGVlcnBvbjk2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 96',
                                         'poller_hash': 'ODdCQTI3',
                                         'serial_number': '87BA27',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:75',
                                         'uptime': '4096875'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002817',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11353694259',
                                                                       'in_octets': '11387254738',
                                                                       'in_ucast_pkts': '33560479',
                                                                       'mac_address': 'd0:76:8f:1f:ea:db',
                                                                       'mtu': 2000,
                                                                       'name': '98/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '163158983444',
                                                                       'out_octets': '163287279029',
                                                                       'out_ucast_pkts': '128295585',
                                                                       'poller_hash': 'ODdCODQ5cGVlcmludGY5OC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '98',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '163158983444',
                                                                       'in_octets': '163287279029',
                                                                       'in_ucast_pkts': '128295585',
                                                                       'links': [       {       'bridged_mac_addresses': [       '48:77:46:fe:74:ea'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '163158983444',
                                                                                                'in_octets': '163287279029',
                                                                                                'in_ucast_pkts': '128295585',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '11353694259',
                                                                                                'out_octets': '11387254738',
                                                                                                'out_ucast_pkts': '33560479',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '98/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '11353694259',
                                                                       'out_octets': '11387254738',
                                                                       'out_ucast_pkts': '33560479',
                                                                       'poller_hash': 'ODdCODQ5cGVlcmludGY5OC9ncDE=',
                                                                       'pons': [       {       'id': '98',
                                                                                               'links': [       {       'connected_time': '2908019',
                                                                                                                        'fiber_length': 890,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '98/gp1',
                                                                                               'poller_hash': 'ODdCODQ5cGVlcnBvbjk4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 98',
                                         'poller_hash': 'ODdCODQ5',
                                         'serial_number': '87B849',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ea:db',
                                         'uptime': '2908019'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002849',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '16652303508',
                                                                       'in_octets': '16817503023',
                                                                       'in_ucast_pkts': '165199515',
                                                                       'mac_address': 'd0:76:8f:1f:ea:2a',
                                                                       'mtu': 2000,
                                                                       'name': '99/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '636202164198',
                                                                       'out_octets': '636638136890',
                                                                       'out_ucast_pkts': '435972692',
                                                                       'poller_hash': 'ODdCODBFcGVlcmludGY5OS9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '99',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '636202164198',
                                                                       'in_octets': '636638136890',
                                                                       'in_ucast_pkts': '435972692',
                                                                       'links': [       {       'bridged_mac_addresses': [       'd0:76:8f:6e:9f:7d'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '636202164198',
                                                                                                'in_octets': '636638136890',
                                                                                                'in_ucast_pkts': '435972692',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '1',
                                                                                                'out_nucast_pkts': '16652303508',
                                                                                                'out_octets': '16817503023',
                                                                                                'out_ucast_pkts': '165199515',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '99/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '1',
                                                                       'out_nucast_pkts': '16652303508',
                                                                       'out_octets': '16817503023',
                                                                       'out_ucast_pkts': '165199515',
                                                                       'poller_hash': 'ODdCODBFcGVlcmludGY5OS9ncDE=',
                                                                       'pons': [       {       'id': '99',
                                                                                               'links': [       {       'connected_time': '567038',
                                                                                                                        'fiber_length': 1279,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '99/gp1',
                                                                                               'poller_hash': 'ODdCODBFcGVlcnBvbjk5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 99',
                                         'poller_hash': 'ODdCODBF',
                                         'serial_number': '87B80E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ea:2a',
                                         'uptime': '567038'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002881',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14521540760',
                                                                       'in_octets': '14567410310',
                                                                       'in_ucast_pkts': '45869550',
                                                                       'mac_address': 'd0:76:8f:1f:eb:e6',
                                                                       'mtu': 2000,
                                                                       'name': '100/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '152691108851',
                                                                       'out_octets': '152804097896',
                                                                       'out_ucast_pkts': '112989045',
                                                                       'poller_hash': 'ODdCOEEycGVlcmludGYxMDAvZzE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '100',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '152691108851',
                                                                       'in_octets': '152804097896',
                                                                       'in_ucast_pkts': '112989045',
                                                                       'links': [       {       'bridged_mac_addresses': [       '40:9b:cd:9f:d9:af'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '152691108851',
                                                                                                'in_octets': '152804097896',
                                                                                                'in_ucast_pkts': '112989045',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '14521540760',
                                                                                                'out_octets': '14567410310',
                                                                                                'out_ucast_pkts': '45869550',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2QxLzEvZ3A1'}],
                                                                       'name': '100/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '14521540760',
                                                                       'out_octets': '14567410310',
                                                                       'out_ucast_pkts': '45869550',
                                                                       'poller_hash': 'ODdCOEEycGVlcmludGYxMDAvZ3Ax',
                                                                       'pons': [       {       'id': '100',
                                                                                               'links': [       {       'connected_time': '1514365',
                                                                                                                        'fiber_length': 1402,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNkMTEwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '100/gp1',
                                                                                               'poller_hash': 'ODdCOEEycGVlcnBvbjEwMC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 100',
                                         'poller_hash': 'ODdCOEEy',
                                         'serial_number': '87B8A2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:eb:e6',
                                         'uptime': '1514365'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002945',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': 'd0:76:8f:1f:eb:d1',
                                                                       'mtu': 2000,
                                                                       'name': '102/g1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ODdCODlCcGVlcmludGYxMDIvZzE=',
                                                                       'speed': '0'},
                                                               {       'admin_up': True,
                                                                       'id': '102',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '0',
                                                                                                'in_ucast_pkts': '0',
                                                                                                'oper_up': False,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '0',
                                                                                                'out_ucast_pkts': '0',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '102/gp1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ODdCODlCcGVlcmludGYxMDIvZ3Ax',
                                                                       'pons': [       {       'id': '102',
                                                                                               'links': [       {       'connected_time': '2908008',
                                                                                                                        'fiber_length': 1015,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '102/gp1',
                                                                                               'poller_hash': 'ODdCODlCcGVlcnBvbjEwMi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 102',
                                         'poller_hash': 'ODdCODlC',
                                         'serial_number': '87B89B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:eb:d1',
                                         'uptime': '2908008'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002977',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8206035896',
                                                                       'in_octets': '8228586492',
                                                                       'in_ucast_pkts': '22550596',
                                                                       'mac_address': 'd0:76:8f:1f:eb:1a',
                                                                       'mtu': 2000,
                                                                       'name': '103/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '95386499388',
                                                                       'out_octets': '95465229342',
                                                                       'out_ucast_pkts': '78729954',
                                                                       'poller_hash': 'ODdCODVFcGVlcmludGYxMDMvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '103',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '95386499388',
                                                                       'in_octets': '95465229342',
                                                                       'in_ucast_pkts': '78729954',
                                                                       'links': [       {       'bridged_mac_addresses': [       '48:77:46:fe:82:97'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '95386499388',
                                                                                                'in_octets': '95465229342',
                                                                                                'in_ucast_pkts': '78729954',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '8206035896',
                                                                                                'out_octets': '8228586492',
                                                                                                'out_ucast_pkts': '22550596',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '103/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '8206035896',
                                                                       'out_octets': '8228586492',
                                                                       'out_ucast_pkts': '22550596',
                                                                       'poller_hash': 'ODdCODVFcGVlcmludGYxMDMvZ3Ax',
                                                                       'pons': [       {       'id': '103',
                                                                                               'links': [       {       'connected_time': '2908029',
                                                                                                                        'fiber_length': 1081,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '103/gp1',
                                                                                               'poller_hash': 'ODdCODVFcGVlcnBvbjEwMy9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 103',
                                         'poller_hash': 'ODdCODVF',
                                         'serial_number': '87B85E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:eb:1a',
                                         'uptime': '2908029'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003041',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '122877930802',
                                                                       'in_octets': '123069180550',
                                                                       'in_ucast_pkts': '191249748',
                                                                       'mac_address': 'd0:76:8f:1f:fe:9d',
                                                                       'mtu': 2000,
                                                                       'name': '105/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1088579656932',
                                                                       'out_octets': '1089405053622',
                                                                       'out_ucast_pkts': '825396690',
                                                                       'poller_hash': 'ODdCRURGcGVlcmludGYxMDUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '105',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1088579656932',
                                                                       'in_octets': '1089405053622',
                                                                       'in_ucast_pkts': '825396690',
                                                                       'links': [       {       'bridged_mac_addresses': [       '48:77:46:fe:82:7c'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1088579656932',
                                                                                                'in_octets': '1089405053622',
                                                                                                'in_ucast_pkts': '825396690',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '122877930802',
                                                                                                'out_octets': '123069180550',
                                                                                                'out_ucast_pkts': '191249748',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '105/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '122877930802',
                                                                       'out_octets': '123069180550',
                                                                       'out_ucast_pkts': '191249748',
                                                                       'poller_hash': 'ODdCRURGcGVlcmludGYxMDUvZ3Ax',
                                                                       'pons': [       {       'id': '105',
                                                                                               'links': [       {       'connected_time': '5696023',
                                                                                                                        'fiber_length': 1369,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '105/gp1',
                                                                                               'poller_hash': 'ODdCRURGcGVlcnBvbjEwNS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 105',
                                         'poller_hash': 'ODdCRURG',
                                         'serial_number': '87BEDF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:fe:9d',
                                         'uptime': '5696023'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003137',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4791685494',
                                                                       'in_octets': '4818099780',
                                                                       'in_ucast_pkts': '26414286',
                                                                       'mac_address': 'd0:76:8f:1f:eb:5c',
                                                                       'mtu': 2000,
                                                                       'name': '108/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '156903193101',
                                                                       'out_octets': '157016311987',
                                                                       'out_ucast_pkts': '113118886',
                                                                       'poller_hash': 'ODdCODc0cGVlcmludGYxMDgvZzE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '108',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '156903193101',
                                                                       'in_octets': '157016311987',
                                                                       'in_ucast_pkts': '113118886',
                                                                       'links': [       {       'bridged_mac_addresses': [       '6c:b0:ce:34:f4:a8'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '156903193101',
                                                                                                'in_octets': '157016311987',
                                                                                                'in_ucast_pkts': '113118886',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4791685494',
                                                                                                'out_octets': '4818099780',
                                                                                                'out_ucast_pkts': '26414286',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '108/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4791685494',
                                                                       'out_octets': '4818099780',
                                                                       'out_ucast_pkts': '26414286',
                                                                       'poller_hash': 'ODdCODc0cGVlcmludGYxMDgvZ3Ax',
                                                                       'pons': [       {       'id': '108',
                                                                                               'links': [       {       'connected_time': '2907982',
                                                                                                                        'fiber_length': 940,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '108/gp1',
                                                                                               'poller_hash': 'ODdCODc0cGVlcnBvbjEwOC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 108',
                                         'poller_hash': 'ODdCODc0',
                                         'serial_number': '87B874',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:eb:5c',
                                         'uptime': '2907982'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003169',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1574059656',
                                                                       'in_octets': '1585437827',
                                                                       'in_ucast_pkts': '11378171',
                                                                       'mac_address': 'd0:76:8f:1f:ec:7c',
                                                                       'mtu': 2000,
                                                                       'name': '109/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '33877471907',
                                                                       'out_octets': '33901157346',
                                                                       'out_ucast_pkts': '23685439',
                                                                       'poller_hash': 'ODdCOEQ0cGVlcmludGYxMDkvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '109',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '33877471907',
                                                                       'in_octets': '33901157346',
                                                                       'in_ucast_pkts': '23685439',
                                                                       'links': [       {       'bridged_mac_addresses': [       'e0:1c:fc:17:29:bf'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '33877471907',
                                                                                                'in_octets': '33901157346',
                                                                                                'in_ucast_pkts': '23685439',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1574059656',
                                                                                                'out_octets': '1585437827',
                                                                                                'out_ucast_pkts': '11378171',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '109/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1574059656',
                                                                       'out_octets': '1585437827',
                                                                       'out_ucast_pkts': '11378171',
                                                                       'poller_hash': 'ODdCOEQ0cGVlcmludGYxMDkvZ3Ax',
                                                                       'pons': [       {       'id': '109',
                                                                                               'links': [       {       'connected_time': '232417',
                                                                                                                        'fiber_length': 1265,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '109/gp1',
                                                                                               'poller_hash': 'ODdCOEQ0cGVlcnBvbjEwOS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 109',
                                         'poller_hash': 'ODdCOEQ0',
                                         'serial_number': '87B8D4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ec:7c',
                                         'uptime': '232417'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003201',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '29298333814',
                                                                       'in_octets': '29418825189',
                                                                       'in_ucast_pkts': '120491375',
                                                                       'mac_address': 'd0:76:8f:1f:ea:93',
                                                                       'mtu': 2000,
                                                                       'name': '110/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '259773976996',
                                                                       'out_octets': '259987564851',
                                                                       'out_ucast_pkts': '213587855',
                                                                       'poller_hash': 'ODdCODMxcGVlcmludGYxMTAvZzE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '110',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '259773976996',
                                                                       'in_octets': '259987564851',
                                                                       'in_ucast_pkts': '213587855',
                                                                       'links': [       {       'bridged_mac_addresses': [       '50:c7:bf:6d:0a:a2'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '259773976996',
                                                                                                'in_octets': '259987564851',
                                                                                                'in_ucast_pkts': '213587855',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '29298333814',
                                                                                                'out_octets': '29418825189',
                                                                                                'out_ucast_pkts': '120491375',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2'}],
                                                                       'name': '110/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '29298333814',
                                                                       'out_octets': '29418825189',
                                                                       'out_ucast_pkts': '120491375',
                                                                       'poller_hash': 'ODdCODMxcGVlcmludGYxMTAvZ3Ax',
                                                                       'pons': [       {       'id': '110',
                                                                                               'links': [       {       'connected_time': '2908015',
                                                                                                                        'fiber_length': 921,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '110/gp1',
                                                                                               'poller_hash': 'ODdCODMxcGVlcnBvbjExMC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 110',
                                         'poller_hash': 'ODdCODMx',
                                         'serial_number': '87B831',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ea:93',
                                         'uptime': '2908015'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003233',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '9775470928',
                                                                       'in_octets': '9834953189',
                                                                       'in_ucast_pkts': '59482261',
                                                                       'mac_address': 'd0:76:8f:1f:ec:3d',
                                                                       'mtu': 2000,
                                                                       'name': '111/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '520272602170',
                                                                       'out_octets': '520635732457',
                                                                       'out_ucast_pkts': '363130287',
                                                                       'poller_hash': 'ODdCOEJGcGVlcmludGYxMTEvZzE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '111',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '520272602170',
                                                                       'in_octets': '520635732457',
                                                                       'in_ucast_pkts': '363130287',
                                                                       'links': [       {       'bridged_mac_addresses': [       'bc:0f:9a:7b:0a:74'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '520272602170',
                                                                                                'in_octets': '520635732457',
                                                                                                'in_ucast_pkts': '363130287',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '9775470928',
                                                                                                'out_octets': '9834953189',
                                                                                                'out_ucast_pkts': '59482261',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '111/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '9775470928',
                                                                       'out_octets': '9834953189',
                                                                       'out_ucast_pkts': '59482261',
                                                                       'poller_hash': 'ODdCOEJGcGVlcmludGYxMTEvZ3Ax',
                                                                       'pons': [       {       'id': '111',
                                                                                               'links': [       {       'connected_time': '2908018',
                                                                                                                        'fiber_length': 993,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '111/gp1',
                                                                                               'poller_hash': 'ODdCOEJGcGVlcnBvbjExMS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 111',
                                         'poller_hash': 'ODdCOEJG',
                                         'serial_number': '87B8BF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ec:3d',
                                         'uptime': '2908018'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003361',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '59419935900',
                                                                       'in_octets': '59902504266',
                                                                       'in_ucast_pkts': '482568366',
                                                                       'mac_address': 'd0:76:8f:1f:f0:4e',
                                                                       'mtu': 2000,
                                                                       'name': '115/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1462598594927',
                                                                       'out_octets': '1463602390033',
                                                                       'out_ucast_pkts': '1003795106',
                                                                       'poller_hash': 'ODdCQTFBcGVlcmludGYxMTUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '115',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1462598594927',
                                                                       'in_octets': '1463602390033',
                                                                       'in_ucast_pkts': '1003795106',
                                                                       'links': [       {       'bridged_mac_addresses': [       '48:77:46:fe:81:ec'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '1462598594927',
                                                                                                'in_octets': '1463602390033',
                                                                                                'in_ucast_pkts': '1003795106',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '59419935900',
                                                                                                'out_octets': '59902504266',
                                                                                                'out_ucast_pkts': '482568366',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2'}],
                                                                       'name': '115/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '59419935900',
                                                                       'out_octets': '59902504266',
                                                                       'out_ucast_pkts': '482568366',
                                                                       'poller_hash': 'ODdCQTFBcGVlcmludGYxMTUvZ3Ax',
                                                                       'pons': [       {       'id': '115',
                                                                                               'links': [       {       'connected_time': '2908011',
                                                                                                                        'fiber_length': 770,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '115/gp1',
                                                                                               'poller_hash': 'ODdCQTFBcGVlcnBvbjExNS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 115',
                                         'poller_hash': 'ODdCQTFB',
                                         'serial_number': '87BA1A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:4e',
                                         'uptime': '2908011'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003393',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12949131508',
                                                                       'in_octets': '13013102733',
                                                                       'in_ucast_pkts': '63971225',
                                                                       'mac_address': 'd0:76:8f:1f:ec:25',
                                                                       'mtu': 2000,
                                                                       'name': '116/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '184476477713',
                                                                       'out_octets': '184610725279',
                                                                       'out_ucast_pkts': '134247566',
                                                                       'poller_hash': 'ODdCOEI3cGVlcmludGYxMTYvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '116',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '184476477713',
                                                                       'in_octets': '184610725279',
                                                                       'in_ucast_pkts': '134247566',
                                                                       'links': [       {       'bridged_mac_addresses': [       '08:bf:b8:b3:ca:90'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '184476477713',
                                                                                                'in_octets': '184610725279',
                                                                                                'in_ucast_pkts': '134247566',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '12949131508',
                                                                                                'out_octets': '13013102733',
                                                                                                'out_ucast_pkts': '63971225',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2'}],
                                                                       'name': '116/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '12949131508',
                                                                       'out_octets': '13013102733',
                                                                       'out_ucast_pkts': '63971225',
                                                                       'poller_hash': 'ODdCOEI3cGVlcmludGYxMTYvZ3Ax',
                                                                       'pons': [       {       'id': '116',
                                                                                               'links': [       {       'connected_time': '1789045',
                                                                                                                        'fiber_length': 643,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '116/gp1',
                                                                                               'poller_hash': 'ODdCOEI3cGVlcnBvbjExNi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 116',
                                         'poller_hash': 'ODdCOEI3',
                                         'serial_number': '87B8B7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ec:25',
                                         'uptime': '1789045'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003457',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6547343723',
                                                                       'in_octets': '6558621416',
                                                                       'in_ucast_pkts': '11277693',
                                                                       'mac_address': 'd0:76:8f:1f:ea:f9',
                                                                       'mtu': 2000,
                                                                       'name': '118/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '38386014557',
                                                                       'out_octets': '38416154839',
                                                                       'out_ucast_pkts': '30140282',
                                                                       'poller_hash': 'ODdCODUzcGVlcmludGYxMTgvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '118',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '38386014557',
                                                                       'in_octets': '38416154839',
                                                                       'in_ucast_pkts': '30140282',
                                                                       'links': [       {       'bridged_mac_addresses': [       'c0:c9:e3:09:ed:61'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '38386014557',
                                                                                                'in_octets': '38416154839',
                                                                                                'in_ucast_pkts': '30140282',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '6547343723',
                                                                                                'out_octets': '6558621416',
                                                                                                'out_ucast_pkts': '11277693',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2'}],
                                                                       'name': '118/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6547343723',
                                                                       'out_octets': '6558621416',
                                                                       'out_ucast_pkts': '11277693',
                                                                       'poller_hash': 'ODdCODUzcGVlcmludGYxMTgvZ3Ax',
                                                                       'pons': [       {       'id': '118',
                                                                                               'links': [       {       'connected_time': '273755',
                                                                                                                        'fiber_length': 759,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '118/gp1',
                                                                                               'poller_hash': 'ODdCODUzcGVlcnBvbjExOC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 118',
                                         'poller_hash': 'ODdCODUz',
                                         'serial_number': '87B853',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ea:f9',
                                         'uptime': '273755'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003489',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6686019306',
                                                                       'in_octets': '6717637475',
                                                                       'in_ucast_pkts': '31618169',
                                                                       'mac_address': 'd0:76:8f:1f:f0:72',
                                                                       'mtu': 2000,
                                                                       'name': '119/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '120635335222',
                                                                       'out_octets': '120737553803',
                                                                       'out_ucast_pkts': '102218581',
                                                                       'poller_hash': 'ODdCQTI2cGVlcmludGYxMTkvZzE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '119',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '120635335222',
                                                                       'in_octets': '120737553803',
                                                                       'in_ucast_pkts': '102218581',
                                                                       'links': [       {       'bridged_mac_addresses': [       '10:be:f5:da:31:cf'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '120635335222',
                                                                                                'in_octets': '120737553803',
                                                                                                'in_ucast_pkts': '102218581',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '6686019306',
                                                                                                'out_octets': '6717637475',
                                                                                                'out_ucast_pkts': '31618169',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2YxLzEvZ3A3'}],
                                                                       'name': '119/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6686019306',
                                                                       'out_octets': '6717637475',
                                                                       'out_ucast_pkts': '31618169',
                                                                       'poller_hash': 'ODdCQTI2cGVlcmludGYxMTkvZ3Ax',
                                                                       'pons': [       {       'id': '119',
                                                                                               'links': [       {       'connected_time': '5352007',
                                                                                                                        'fiber_length': 1271,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNmMTEwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'maximum_loss': -8.0,
                                                                                               'minimum_loss': -27.0,
                                                                                               'name': '119/gp1',
                                                                                               'poller_hash': 'ODdCQTI2cGVlcnBvbjExOS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 119',
                                         'poller_hash': 'ODdCQTI2',
                                         'serial_number': '87BA26',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:72',
                                         'uptime': '5352007'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003521',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6547827097',
                                                                       'in_octets': '6577951329',
                                                                       'in_ucast_pkts': '30124232',
                                                                       'mac_address': 'd0:76:8f:1f:e9:af',
                                                                       'mtu': 2000,
                                                                       'name': '120/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '179690853897',
                                                                       'out_octets': '179827653248',
                                                                       'out_ucast_pkts': '136799351',
                                                                       'poller_hash': 'ODdCN0U1cGVlcmludGYxMjAvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '120',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '179690853897',
                                                                       'in_octets': '179827653248',
                                                                       'in_ucast_pkts': '136799351',
                                                                       'links': [       {       'bridged_mac_addresses': [       'dc:ef:09:a1:01:92'],
                                                                                                'in_errors': '0',
                                                                                                'in_nucast_pkts': '179690853897',
                                                                                                'in_octets': '179827653248',
                                                                                                'in_ucast_pkts': '136799351',
                                                                                                'oper_up': True,
                                                                 