import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):

    def test_calix_exa_E7_2_EXA_3_4_30_40_01(self):
        obj = self.run_data("calix.exa.E7-2 (EXA).3.4.30.40.01")
        exp_info = {
         'model': 'E7-2 (EXA)', 'sw_version': '3.4.30.40', 'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': None, 'system_mac_address': None
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'Calix',
                                'model': 'E7-2 (EXA)',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1/x3',
                                                                                         'in_discards': '20970547',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1885938261',
                                                                                         'in_octets': '3091939462944884',
                                                                                         'in_ucast_pkts': '7565860166630',
                                                                                         'mac_address': 'cc:be:59:12:6a:d7',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-10G-DAC',
                                                                                         'name': 'ethernet '
                                                                                                 '1/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '10010084275019',
                                                                                         'out_octets': '34940298506943810',
                                                                                         'out_ucast_pkts': '16754456586145',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/x4',
                                                                                         'in_discards': '1614443',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17817075',
                                                                                         'in_octets': '817787410708586',
                                                                                         'in_ucast_pkts': '607624887691',
                                                                                         'mac_address': 'cc:be:59:12:6a:d8',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC02',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 '1/x4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '33924162',
                                                                                         'out_octets': '27574464639446',
                                                                                         'out_ucast_pkts': '114964226908',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4TUNDTC1TVUJTIDEveDQ=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2564',
                                                                                         'in_octets': '682781',
                                                                                         'in_ucast_pkts': '3781',
                                                                                         'mac_address': 'cc:be:59:12:6a:c9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01669',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '274911490',
                                                                                         'out_octets': '19578805062',
                                                                                         'out_ucast_pkts': '1078059',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g2',
                                                                                         'in_discards': '222',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '894',
                                                                                         'in_octets': '3453079',
                                                                                         'in_ucast_pkts': '16501',
                                                                                         'mac_address': 'cc:be:59:12:6a:ca',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g2',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '20407',
                                                                                         'out_octets': '30163120',
                                                                                         'out_ucast_pkts': '26099',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g3',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': 'cc:be:59:12:6a:cb',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g3',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '1/g4',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': 'cc:be:59:12:6a:cc',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g4',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4ZXRoZXJuZXQgMS9nNA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/1',
                                                                                         'in_discards': '170005',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '21194627',
                                                                                         'in_octets': '18238612681954',
                                                                                         'in_ucast_pkts': '70494416187',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '623066540103',
                                                                                         'out_octets': '1093179241770631',
                                                                                         'out_ucast_pkts': '189784179977',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzE=',
                                                                                         'pons': [       {       'id': '1/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/1',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/2',
                                                                                         'in_discards': '3123',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16848627',
                                                                                         'in_octets': '15857658086356',
                                                                                         'in_ucast_pkts': '83454436756',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '684174897478',
                                                                                         'out_octets': '1150286747570986',
                                                                                         'out_ucast_pkts': '187402344912',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzI=',
                                                                                         'pons': [       {       'id': '1/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/2',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/3',
                                                                                         'in_discards': '14780',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '4129449',
                                                                                         'in_octets': '14837065993750',
                                                                                         'in_ucast_pkts': '72658961700',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '446713747803',
                                                                                         'out_octets': '933299937561712',
                                                                                         'out_ucast_pkts': '234529061157',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzM=',
                                                                                         'pons': [       {       'id': '1/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/3',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/4',
                                                                                         'in_discards': '175583',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1534829',
                                                                                         'in_octets': '11618334953611',
                                                                                         'in_ucast_pkts': '46990119416',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '308300794558',
                                                                                         'out_octets': '600202567451479',
                                                                                         'out_ucast_pkts': '133864245663',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzQ=',
                                                                                         'pons': [       {       'id': '1/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/4',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/5',
                                                                                         'in_discards': '9305',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '53141668',
                                                                                         'in_octets': '32047248223237',
                                                                                         'in_ucast_pkts': '100270236044',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '608731338107',
                                                                                         'out_octets': '1059256520072757',
                                                                                         'out_ucast_pkts': '211130815370',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzU=',
                                                                                         'pons': [       {       'id': '1/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/5',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/6',
                                                                                         'in_discards': '68493',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '21310490',
                                                                                         'in_octets': '21300163357214',
                                                                                         'in_ucast_pkts': '97300628009',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '903635279876',
                                                                                         'out_octets': '1611158589267213',
                                                                                         'out_ucast_pkts': '281343292710',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzY=',
                                                                                         'pons': [       {       'id': '1/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/6',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/7',
                                                                                         'in_discards': '5467',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '7707613',
                                                                                         'in_octets': '17911306028321',
                                                                                         'in_ucast_pkts': '77474130271',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '927276244767',
                                                                                         'out_octets': '1562993677443657',
                                                                                         'out_ucast_pkts': '222717515265',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzc=',
                                                                                         'pons': [       {       'id': '1/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/7',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/8',
                                                                                         'in_discards': '127396',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '5421042',
                                                                                         'in_octets': '16533513874233',
                                                                                         'in_ucast_pkts': '72940709148',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '1/8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '656143086194',
                                                                                         'out_octets': '1153299026995252',
                                                                                         'out_ucast_pkts': '192889162656',
                                                                                         'poller_hash': 'MjExNzAzNjAxMTg4Z3BvbiAxLzg=',
                                                                                         'pons': [       {       'id': '1/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '1/8',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMTg4cG9uZ3BvbiAxLzg=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03006',
                                                           'name': 'GPON-8',
                                                           'poller_hash': 'MjExNzAzNjAxMTg4',
                                                           'serial_number': '211703601188',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '75800064'},
                                                   {       'id': '2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '2/x3',
                                                                                         'in_discards': '453148400',
                                                                                         'in_errors': '1521',
                                                                                         'in_nucast_pkts': '10009921523398',
                                                                                         'in_octets': '38099027736196148',
                                                                                         'in_ucast_pkts': '19157996353470',
                                                                                         'mac_address': 'cc:be:59:12:6a:8f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01511',
                                                                                         'name': 'ethernet '
                                                                                                 '2/x3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '2063198014',
                                                                                         'out_octets': '3304347378620722',
                                                                                         'out_ucast_pkts': '8463897173287',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi94Mw==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/x4',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17473651',
                                                                                         'in_octets': '2373304515',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': 'cc:be:59:12:6a:90',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC02',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 '2/x4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '28117786',
                                                                                         'out_octets': '33070096814073',
                                                                                         'out_ucast_pkts': '103614093137',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0TUNDTC1TVUJTIDIveDQ=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2417090',
                                                                                         'in_octets': '818106048',
                                                                                         'in_ucast_pkts': '8487345',
                                                                                         'mac_address': 'cc:be:59:12:6a:81',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-GB-GE-T',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '776374120',
                                                                                         'out_octets': '103686998194',
                                                                                         'out_ucast_pkts': '7664091',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMQ==',
                                                                                         'speed': '100000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '2/g2',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': 'cc:be:59:12:6a:82',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g2',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '2/g3',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': 'cc:be:59:12:6a:83',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g3',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nMw=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g4',
                                                                                         'in_discards': '123',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '71225',
                                                                                         'in_octets': '4656554165',
                                                                                         'in_ucast_pkts': '23388069',
                                                                                         'mac_address': 'cc:be:59:12:6a:84',
                                                                                         'manufacturer': 'BROCADE',
                                                                                         'model': '57-1000042-01',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '78974676',
                                                                                         'out_octets': '13188544454',
                                                                                         'out_ucast_pkts': '58220246',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0ZXRoZXJuZXQgMi9nNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/1',
                                                                                         'in_discards': '126988',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '5186201',
                                                                                         'in_octets': '20868258883112',
                                                                                         'in_ucast_pkts': '98358638156',
                                                                                         'name': 'gpon '
                                                                                                 '2/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '485775045391',
                                                                                         'out_octets': '1016347737099764',
                                                                                         'out_ucast_pkts': '260557752046',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzE=',
                                                                                         'pons': [       {       'id': '2/1',
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/1',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/2',
                                                                                         'in_discards': '134278',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '15566899',
                                                                                         'in_octets': '17172330743007',
                                                                                         'in_ucast_pkts': '83201262770',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '496358177726',
                                                                                         'out_octets': '1006001487326311',
                                                                                         'out_ucast_pkts': '243469353477',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzI=',
                                                                                         'pons': [       {       'id': '2/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/2',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/3',
                                                                                         'in_discards': '125808',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '22719107',
                                                                                         'in_octets': '22385046579362',
                                                                                         'in_ucast_pkts': '88067434009',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '402790837285',
                                                                                         'out_octets': '880686736747491',
                                                                                         'out_ucast_pkts': '245791331946',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzM=',
                                                                                         'pons': [       {       'id': '2/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/3',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/4',
                                                                                         'in_discards': '145686',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '7042437',
                                                                                         'in_octets': '22756144926372',
                                                                                         'in_ucast_pkts': '75330068440',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '494679869962',
                                                                                         'out_octets': '919276770691543',
                                                                                         'out_ucast_pkts': '187500640641',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzQ=',
                                                                                         'pons': [       {       'id': '2/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/4',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/5',
                                                                                         'in_discards': '166537',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2421972',
                                                                                         'in_octets': '8889096832373',
                                                                                         'in_ucast_pkts': '20807267506',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '276730314086',
                                                                                         'out_octets': '447414254767475',
                                                                                         'out_ucast_pkts': '54628611768',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzU=',
                                                                                         'pons': [       {       'id': '2/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/5',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/6',
                                                                                         'in_discards': '124996',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '214126',
                                                                                         'in_octets': '5586209623586',
                                                                                         'in_ucast_pkts': '22797498582',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '2/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '221147456418',
                                                                                         'out_octets': '392809772457918',
                                                                                         'out_ucast_pkts': '69195039355',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzY=',
                                                                                         'pons': [       {       'id': '2/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/6',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/7',
                                                                                         'in_discards': '1319',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1712073',
                                                                                         'in_octets': '5469879833481',
                                                                                         'in_ucast_pkts': '19158077307',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '2/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '215484166927',
                                                                                         'out_octets': '343498965120212',
                                                                                         'out_ucast_pkts': '39951771016',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzc=',
                                                                                         'pons': [       {       'id': '2/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/7',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/8',
                                                                                         'in_discards': '362015',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '820936',
                                                                                         'in_octets': '21789411787852',
                                                                                         'in_ucast_pkts': '89613696300',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '2/8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '245265215074',
                                                                                         'out_octets': '693293362815965',
                                                                                         'out_ucast_pkts': '259581958790',
                                                                                         'poller_hash': 'MjExNzAzNjAxMjc0Z3BvbiAyLzg=',
                                                                                         'pons': [       {       'id': '2/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '2/8',
                                                                                                                 'poller_hash': 'MjExNzAzNjAxMjc0cG9uZ3BvbiAyLzg=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03006',
                                                           'name': 'GPON-8',
                                                           'poller_hash': 'MjExNzAzNjAxMjc0',
                                                           'serial_number': '211703601274',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '75799521'}],
                                'system_mac_address': 'cc:be:59:12:6a:7f'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))

    def test_calix_exa_E7_20_3_4_30_40_01(self):
        obj = self.run_data("calix.exa.E7-20.3.4.30.40.01")
        exp_info = {
         'model': 'E7-20', 'sw_version': '3.4.30.40', 'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': None, 'system_mac_address': None
        }
        exp_sta_stats = {
         
        }
        exp_ne_msg = {
                'data': {       'manufacturer': 'Calix',
                                'model': 'E7-20',
                                'modules': [       {       'id': '1',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '1/g1',
                                                                                         'in_discards': '2',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '4099259',
                                                                                         'in_octets': '344735263348',
                                                                                         'in_ucast_pkts': '1749827349',
                                                                                         'mac_address': '00:02:5d:ad:f8:0a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '11316967252',
                                                                                         'out_octets': '26056896275861',
                                                                                         'out_ucast_pkts': '8763086307',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cx',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g2',
                                                                                         'in_discards': '5067',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '48931424',
                                                                                         'in_octets': '829632045855',
                                                                                         'in_ucast_pkts': '1728103304',
                                                                                         'mac_address': '00:02:5d:ad:f8:0b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '28263630684',
                                                                                         'out_octets': '39331599408441',
                                                                                         'out_ucast_pkts': '3124066022',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cy',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g3',
                                                                                         'in_discards': '7',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '586452',
                                                                                         'in_octets': '52890036377',
                                                                                         'in_ucast_pkts': '118460254',
                                                                                         'mac_address': '00:02:5d:ad:f8:0c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190551592',
                                                                                         'out_octets': '308965495159',
                                                                                         'out_ucast_pkts': '263848251',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cz',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g4',
                                                                                         'in_discards': '382',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '29344000',
                                                                                         'in_octets': '280379488878',
                                                                                         'in_ucast_pkts': '893342532',
                                                                                         'mac_address': '00:02:5d:ad:f8:0d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '38096049926',
                                                                                         'out_octets': '53593837890386',
                                                                                         'out_ucast_pkts': '3355389528',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2c0',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g5',
                                                                                         'in_discards': '12',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10657980',
                                                                                         'in_octets': '265719060644',
                                                                                         'in_ucast_pkts': '1059019342',
                                                                                         'mac_address': '00:02:5d:ad:f8:0e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '17294382847',
                                                                                         'out_octets': '25275727364218',
                                                                                         'out_ucast_pkts': '3362559120',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2c1',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g6',
                                                                                         'in_discards': '148',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '43628',
                                                                                         'in_octets': '541286333446',
                                                                                         'in_ucast_pkts': '3083155192',
                                                                                         'mac_address': '00:02:5d:ad:f8:0f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477122359',
                                                                                         'out_octets': '14724991295256',
                                                                                         'out_ucast_pkts': '10633861484',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2c2',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g7',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '23394109',
                                                                                         'in_octets': '106411597424',
                                                                                         'in_ucast_pkts': '567764601',
                                                                                         'mac_address': '00:02:5d:ad:f8:10',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '33802217393',
                                                                                         'out_octets': '45324860069084',
                                                                                         'out_ucast_pkts': '1620410365',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2c3',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g8',
                                                                                         'in_discards': '134',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9279452',
                                                                                         'in_octets': '248036181000',
                                                                                         'in_ucast_pkts': '1309706740',
                                                                                         'mac_address': '00:02:5d:ad:f8:11',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '19412259494',
                                                                                         'out_octets': '29090621976532',
                                                                                         'out_ucast_pkts': '3709422934',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2c4',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g9',
                                                                                         'in_discards': '12',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '585857',
                                                                                         'in_octets': '173497988759',
                                                                                         'in_ucast_pkts': '1499085557',
                                                                                         'mac_address': '00:02:5d:ad:f8:12',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g9',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1476598109',
                                                                                         'out_octets': '6548525697969',
                                                                                         'out_ucast_pkts': '4475602480',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2c5',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g10',
                                                                                         'in_discards': '16',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '15627792',
                                                                                         'in_octets': '42622782226',
                                                                                         'in_ucast_pkts': '156439650',
                                                                                         'mac_address': '00:02:5d:ad:f8:13',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '8107751159',
                                                                                         'out_octets': '8664174819424',
                                                                                         'out_ucast_pkts': '328333079',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cxMA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g11',
                                                                                         'in_discards': '109',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16567700',
                                                                                         'in_octets': '336149338689',
                                                                                         'in_ucast_pkts': '953625019',
                                                                                         'mac_address': '00:02:5d:ad:f8:14',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '25276818959',
                                                                                         'out_octets': '33970724799907',
                                                                                         'out_ucast_pkts': '2054657411',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cxMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g12',
                                                                                         'in_discards': '27',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '31059',
                                                                                         'in_octets': '61263240092',
                                                                                         'in_ucast_pkts': '267338272',
                                                                                         'mac_address': '00:02:5d:ad:f8:15',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236568353',
                                                                                         'out_octets': '2466353372184',
                                                                                         'out_ucast_pkts': '1805217946',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cxMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g13',
                                                                                         'in_discards': '50',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '42273',
                                                                                         'in_octets': '306352484628',
                                                                                         'in_ucast_pkts': '885528905',
                                                                                         'mac_address': '00:02:5d:ad:f8:16',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g13',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191134268',
                                                                                         'out_octets': '4478727103236',
                                                                                         'out_ucast_pkts': '3296274731',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cxMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g14',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '351379',
                                                                                         'in_octets': '779530627356',
                                                                                         'in_ucast_pkts': '2678229310',
                                                                                         'mac_address': '00:02:5d:ad:f8:17',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g14',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431650866',
                                                                                         'out_octets': '9604220935691',
                                                                                         'out_ucast_pkts': '6930521130',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cxNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g15',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '582418',
                                                                                         'in_octets': '351592496385',
                                                                                         'in_ucast_pkts': '1826190352',
                                                                                         'mac_address': '00:02:5d:ad:f8:18',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236014077',
                                                                                         'out_octets': '11039861125539',
                                                                                         'out_ucast_pkts': '8158675534',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cxNQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g16',
                                                                                         'in_discards': '129',
                                                                                         'in_errors': '1204946',
                                                                                         'in_nucast_pkts': '10949329',
                                                                                         'in_octets': '487239921377',
                                                                                         'in_ucast_pkts': '2351175567',
                                                                                         'mac_address': '00:02:5d:ad:f8:19',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '30524879643',
                                                                                         'out_octets': '45134418135921',
                                                                                         'out_ucast_pkts': '4875485976',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cxNg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g17',
                                                                                         'in_discards': '17',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '15281104',
                                                                                         'in_octets': '26137800451',
                                                                                         'in_ucast_pkts': '177568962',
                                                                                         'mac_address': '00:02:5d:ad:f8:1a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '21722662951',
                                                                                         'out_octets': '27621131745558',
                                                                                         'out_ucast_pkts': '524394600',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cxNw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g18',
                                                                                         'in_discards': '118',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18880249',
                                                                                         'in_octets': '75994717260',
                                                                                         'in_ucast_pkts': '350309093',
                                                                                         'mac_address': '00:02:5d:ad:f8:1b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '55601259692',
                                                                                         'out_octets': '74561322397458',
                                                                                         'out_ucast_pkts': '1121978720',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cxOA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g19',
                                                                                         'in_discards': '15',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16664403',
                                                                                         'in_octets': '370800966790',
                                                                                         'in_ucast_pkts': '2380161729',
                                                                                         'mac_address': '00:02:5d:ad:f8:1c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '37727622021',
                                                                                         'out_octets': '57190483572573',
                                                                                         'out_ucast_pkts': '6449093955',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cxOQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g20',
                                                                                         'in_discards': '647',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '39676',
                                                                                         'in_octets': '679124291520',
                                                                                         'in_ucast_pkts': '4662566952',
                                                                                         'mac_address': '00:02:5d:ad:f8:1d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g20',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1430519342',
                                                                                         'out_octets': '21028777354908',
                                                                                         'out_ucast_pkts': '14546351389',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cyMA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g21',
                                                                                         'in_discards': '63',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16389018',
                                                                                         'in_octets': '365950502072',
                                                                                         'in_ucast_pkts': '1585648807',
                                                                                         'mac_address': '00:02:5d:ad:f8:1e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '52118367402',
                                                                                         'out_octets': '74767360428032',
                                                                                         'out_ucast_pkts': '4891811278',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cyMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g22',
                                                                                         'in_discards': '138',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '30608',
                                                                                         'in_octets': '397843999263',
                                                                                         'in_ucast_pkts': '2410517750',
                                                                                         'mac_address': '00:02:5d:ad:f8:1f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191104949',
                                                                                         'out_octets': '10070295814411',
                                                                                         'out_ucast_pkts': '7388263885',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cyMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g23',
                                                                                         'in_discards': '1605',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '5717146',
                                                                                         'in_octets': '182105298569',
                                                                                         'in_ucast_pkts': '456276884',
                                                                                         'mac_address': '00:02:5d:ad:f8:20',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g23',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '10431611105',
                                                                                         'out_octets': '15083999817054',
                                                                                         'out_ucast_pkts': '1280508652',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cyMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '1/g24',
                                                                                         'in_discards': '10476518',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '11971920',
                                                                                         'in_octets': '38009053247',
                                                                                         'in_ucast_pkts': '217231805',
                                                                                         'mac_address': '00:02:5d:ad:f8:21',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '1/g24',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '5321015383',
                                                                                         'out_octets': '6875697692381',
                                                                                         'out_ucast_pkts': '275873936',
                                                                                         'poller_hash': 'ODExMTAwMDM2NzVldGhlcm5ldCAxL2cyNA==',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDM2NzU=',
                                                           'serial_number': '81110003675',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931285'},
                                                   {       'id': '2',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '2/g1',
                                                                                         'in_discards': '26',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '825913',
                                                                                         'in_octets': '27984695123',
                                                                                         'in_ucast_pkts': '73693050',
                                                                                         'mac_address': '00:02:5d:ae:03:e0',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g1',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '2668879135',
                                                                                         'out_octets': '3037922238007',
                                                                                         'out_ucast_pkts': '380271526',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cx'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g2',
                                                                                         'in_discards': '29',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '19056412',
                                                                                         'in_octets': '365773293337',
                                                                                         'in_ucast_pkts': '1238378672',
                                                                                         'mac_address': '00:02:5d:ae:03:e1',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '53491860508',
                                                                                         'out_octets': '73693481818030',
                                                                                         'out_ucast_pkts': '2749636958',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cy',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g3',
                                                                                         'in_discards': '11838',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '260571',
                                                                                         'in_octets': '397511268250',
                                                                                         'in_ucast_pkts': '2895517090',
                                                                                         'mac_address': '00:02:5d:ae:03:e2',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431524781',
                                                                                         'out_octets': '11523165034142',
                                                                                         'out_ucast_pkts': '8135864068',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cz',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g4',
                                                                                         'in_discards': '97',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '15839644',
                                                                                         'in_octets': '143882020447',
                                                                                         'in_ucast_pkts': '724829790',
                                                                                         'mac_address': '00:02:5d:ae:03:e3',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '15841893531',
                                                                                         'out_octets': '22675362388389',
                                                                                         'out_ucast_pkts': '3119509609',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2c0',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g5',
                                                                                         'in_discards': '116',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18400701',
                                                                                         'in_octets': '429324191103',
                                                                                         'in_ucast_pkts': '1778810017',
                                                                                         'mac_address': '00:02:5d:ae:03:e4',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '47112806328',
                                                                                         'out_octets': '67879692656646',
                                                                                         'out_ucast_pkts': '4851491526',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2c1',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '2/g6',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ae:03:e5',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g6',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2c2'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g7',
                                                                                         'in_discards': '24585',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '33116',
                                                                                         'in_octets': '350479096272',
                                                                                         'in_ucast_pkts': '3292969279',
                                                                                         'mac_address': '00:02:5d:ae:03:e6',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477228389',
                                                                                         'out_octets': '12419200287417',
                                                                                         'out_ucast_pkts': '8475816452',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2c3',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g8',
                                                                                         'in_discards': '1067',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1045081',
                                                                                         'in_octets': '111899039535',
                                                                                         'in_ucast_pkts': '535635195',
                                                                                         'mac_address': '00:02:5d:ae:03:e7',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1883135324',
                                                                                         'out_octets': '2583627838891',
                                                                                         'out_ucast_pkts': '1619177924',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2c4',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g9',
                                                                                         'in_discards': '59',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '34879',
                                                                                         'in_octets': '163571409137',
                                                                                         'in_ucast_pkts': '722216372',
                                                                                         'mac_address': '00:02:5d:ae:03:e8',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g9',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191091659',
                                                                                         'out_octets': '1883775741974',
                                                                                         'out_ucast_pkts': '1498090528',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2c5',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g10',
                                                                                         'in_discards': '13',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '378578',
                                                                                         'in_octets': '173192641019',
                                                                                         'in_ucast_pkts': '989990398',
                                                                                         'mac_address': '00:02:5d:ae:03:e9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1476790283',
                                                                                         'out_octets': '3427478999620',
                                                                                         'out_ucast_pkts': '2495799925',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cxMA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g11',
                                                                                         'in_discards': '33',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '36558',
                                                                                         'in_octets': '44695409486',
                                                                                         'in_ucast_pkts': '142231973',
                                                                                         'mac_address': '00:02:5d:ae:03:ea',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477146237',
                                                                                         'out_octets': '445088703611',
                                                                                         'out_ucast_pkts': '271270457',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cxMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g12',
                                                                                         'in_discards': '313',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '285643',
                                                                                         'in_octets': '2010292082981',
                                                                                         'in_ucast_pkts': '5072628971',
                                                                                         'mac_address': '00:02:5d:ae:03:eb',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236242434',
                                                                                         'out_octets': '32070824872993',
                                                                                         'out_ucast_pkts': '23473826991',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cxMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g13',
                                                                                         'in_discards': '1',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '59237',
                                                                                         'in_octets': '1276573941861',
                                                                                         'in_ucast_pkts': '3675589373',
                                                                                         'mac_address': '00:02:5d:ae:03:ec',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g13',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191101544',
                                                                                         'out_octets': '11550858547352',
                                                                                         'out_ucast_pkts': '10046966227',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cxMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g14',
                                                                                         'in_discards': '61',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '772391',
                                                                                         'in_octets': '3761935870252',
                                                                                         'in_ucast_pkts': '5158268918',
                                                                                         'mac_address': '00:02:5d:ae:03:ed',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g14',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190393090',
                                                                                         'out_octets': '5527842344169',
                                                                                         'out_ucast_pkts': '6395125145',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cxNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g15',
                                                                                         'in_discards': '161',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17169249',
                                                                                         'in_octets': '26873461775',
                                                                                         'in_ucast_pkts': '131808684',
                                                                                         'mac_address': '00:02:5d:ae:03:ee',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '6022406956',
                                                                                         'out_octets': '5631723574961',
                                                                                         'out_ucast_pkts': '228841400',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cxNQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g16',
                                                                                         'in_discards': '74',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '25225441',
                                                                                         'in_octets': '584118678756',
                                                                                         'in_ucast_pkts': '2700450880',
                                                                                         'mac_address': '00:02:5d:ae:03:ef',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '57343597836',
                                                                                         'out_octets': '85992436848867',
                                                                                         'out_ucast_pkts': '7410517398',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cxNg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g17',
                                                                                         'in_discards': '132',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10477461',
                                                                                         'in_octets': '980568469695',
                                                                                         'in_ucast_pkts': '3075382648',
                                                                                         'mac_address': '00:02:5d:ae:03:f0',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '21822349005',
                                                                                         'out_octets': '39611713733061',
                                                                                         'out_ucast_pkts': '9180949379',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cxNw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g18',
                                                                                         'in_discards': '1934',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '15968112',
                                                                                         'in_octets': '153645242891',
                                                                                         'in_ucast_pkts': '1063735061',
                                                                                         'mac_address': '00:02:5d:ae:03:f1',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '13076221186',
                                                                                         'out_octets': '19044737083549',
                                                                                         'out_ucast_pkts': '3036062325',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cxOA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g19',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '380780',
                                                                                         'in_octets': '657545986811',
                                                                                         'in_ucast_pkts': '1194747839',
                                                                                         'mac_address': '00:02:5d:ae:03:f2',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190791490',
                                                                                         'out_octets': '4317523135996',
                                                                                         'out_ucast_pkts': '3192711992',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cxOQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g20',
                                                                                         'in_discards': '9',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9834741',
                                                                                         'in_octets': '108994070138',
                                                                                         'in_ucast_pkts': '557567506',
                                                                                         'mac_address': '00:02:5d:ae:03:f3',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g20',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '20616526618',
                                                                                         'out_octets': '27814753935357',
                                                                                         'out_ucast_pkts': '1798481843',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cyMA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g21',
                                                                                         'in_discards': '51',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '33713',
                                                                                         'in_octets': '107682314306',
                                                                                         'in_ucast_pkts': '638404902',
                                                                                         'mac_address': '00:02:5d:ae:03:f4',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236509636',
                                                                                         'out_octets': '2723725511510',
                                                                                         'out_ucast_pkts': '1973087558',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cyMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g22',
                                                                                         'in_discards': '367',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '30845',
                                                                                         'in_octets': '198777638501',
                                                                                         'in_ucast_pkts': '922718069',
                                                                                         'mac_address': '00:02:5d:ae:03:f5',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190607487',
                                                                                         'out_octets': '2588764881779',
                                                                                         'out_ucast_pkts': '2180315842',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cyMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g23',
                                                                                         'in_discards': '9',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '344671',
                                                                                         'in_octets': '309147205457',
                                                                                         'in_ucast_pkts': '1771590705',
                                                                                         'mac_address': '00:02:5d:ae:03:f6',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g23',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190771904',
                                                                                         'out_octets': '9777928632645',
                                                                                         'out_ucast_pkts': '6912366458',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cyMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '2/g24',
                                                                                         'in_discards': '42',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9171859',
                                                                                         'in_octets': '111834564434',
                                                                                         'in_ucast_pkts': '680176361',
                                                                                         'mac_address': '00:02:5d:ae:03:f7',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '2/g24',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '32163620785',
                                                                                         'out_octets': '44269765101819',
                                                                                         'out_ucast_pkts': '2173786287',
                                                                                         'poller_hash': 'ODExMTAwMDM2MjFldGhlcm5ldCAyL2cyNA==',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDM2MjE=',
                                                           'serial_number': '81110003621',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931003'},
                                                   {       'id': '3',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '3/g1',
                                                                                         'in_discards': '136',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '417713',
                                                                                         'in_octets': '1699500028967',
                                                                                         'in_ucast_pkts': '4290353559',
                                                                                         'mac_address': '00:02:5d:d5:30:be',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235961076',
                                                                                         'out_octets': '14918453348415',
                                                                                         'out_ucast_pkts': '11469660849',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g2',
                                                                                         'in_discards': '76',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '34846',
                                                                                         'in_octets': '408767709452',
                                                                                         'in_ucast_pkts': '1898520296',
                                                                                         'mac_address': '00:02:5d:d5:30:bf',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190920910',
                                                                                         'out_octets': '6902705029990',
                                                                                         'out_ucast_pkts': '5140419808',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g3',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '21097890',
                                                                                         'in_octets': '532751269258',
                                                                                         'in_ucast_pkts': '1762928995',
                                                                                         'mac_address': '00:02:5d:d5:30:c0',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '34668339603',
                                                                                         'out_octets': '51390934677234',
                                                                                         'out_ucast_pkts': '5297835719',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g4',
                                                                                         'in_discards': '23',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '8970163',
                                                                                         'in_octets': '340012061232',
                                                                                         'in_ucast_pkts': '2109569230',
                                                                                         'mac_address': '00:02:5d:d5:30:c1',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '3454837110',
                                                                                         'out_octets': '13286202560434',
                                                                                         'out_ucast_pkts': '8176311314',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g5',
                                                                                         'in_discards': '17',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '3942528',
                                                                                         'in_octets': '3053102943',
                                                                                         'in_ucast_pkts': '16604834',
                                                                                         'mac_address': '00:02:5d:d5:30:c2',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '4630411593',
                                                                                         'out_octets': '4162592744336',
                                                                                         'out_ucast_pkts': '16840128',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nNQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g6',
                                                                                         'in_discards': '200',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '34983',
                                                                                         'in_octets': '683464256688',
                                                                                         'in_ucast_pkts': '3252243516',
                                                                                         'mac_address': '00:02:5d:d5:30:c3',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1430294414',
                                                                                         'out_octets': '12567060750357',
                                                                                         'out_ucast_pkts': '9154107192',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nNg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g7',
                                                                                         'in_discards': '15',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '8919811',
                                                                                         'in_octets': '205417473924',
                                                                                         'in_ucast_pkts': '941206917',
                                                                                         'mac_address': '00:02:5d:d5:30:c4',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '30238450161',
                                                                                         'out_octets': '43501724889313',
                                                                                         'out_ucast_pkts': '3610493622',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nNw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g8',
                                                                                         'in_discards': '35',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '273388',
                                                                                         'in_octets': '233645998913',
                                                                                         'in_ucast_pkts': '939365696',
                                                                                         'mac_address': '00:02:5d:d5:30:c5',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236161391',
                                                                                         'out_octets': '4063702474079',
                                                                                         'out_ucast_pkts': '3319890452',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nOA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '3/g9',
                                                                                         'in_discards': '1',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '227103',
                                                                                         'in_octets': '239169615290',
                                                                                         'in_ucast_pkts': '431917303',
                                                                                         'mac_address': '00:02:5d:d5:30:c6',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g9',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '994880741',
                                                                                         'out_octets': '2142462894915',
                                                                                         'out_ucast_pkts': '1508974678',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nOQ=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g10',
                                                                                         'in_discards': '98',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '549402',
                                                                                         'in_octets': '196705127706',
                                                                                         'in_ucast_pkts': '695770814',
                                                                                         'mac_address': '00:02:5d:d5:30:c7',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235873374',
                                                                                         'out_octets': '3605630285657',
                                                                                         'out_ucast_pkts': '2869019238',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMTA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g11',
                                                                                         'in_discards': '20',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '7973671',
                                                                                         'in_octets': '61899613442',
                                                                                         'in_ucast_pkts': '259683145',
                                                                                         'mac_address': '00:02:5d:d5:30:c8',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '7362019742',
                                                                                         'out_octets': '7998263401467',
                                                                                         'out_ucast_pkts': '600021575',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMTE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g12',
                                                                                         'in_discards': '30',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '43047',
                                                                                         'in_octets': '87027602336',
                                                                                         'in_ucast_pkts': '440185043',
                                                                                         'mac_address': '00:02:5d:d5:30:c9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431484854',
                                                                                         'out_octets': '3096386441960',
                                                                                         'out_ucast_pkts': '2269511356',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMTI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g13',
                                                                                         'in_discards': '88',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '11759132',
                                                                                         'in_octets': '133692307095',
                                                                                         'in_ucast_pkts': '247466675',
                                                                                         'mac_address': '00:02:5d:d5:30:ca',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g13',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '13892653110',
                                                                                         'out_octets': '16397446910658',
                                                                                         'out_ucast_pkts': '911216799',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMTM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '3/g14',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:d5:30:cb',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g14',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMTQ='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g15',
                                                                                         'in_discards': '1379012',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2425975',
                                                                                         'in_octets': '6399989524718',
                                                                                         'in_ucast_pkts': '25073437407',
                                                                                         'mac_address': '00:02:5d:d5:30:cc',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '850252965',
                                                                                         'out_octets': '83820351771819',
                                                                                         'out_ucast_pkts': '63763326056',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMTU=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g16',
                                                                                         'in_discards': '12',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '22127',
                                                                                         'in_octets': '1444091908939',
                                                                                         'in_ucast_pkts': '2782406211',
                                                                                         'mac_address': '00:02:5d:d5:30:cd',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431505149',
                                                                                         'out_octets': '5865100316420',
                                                                                         'out_ucast_pkts': '5074162041',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMTY=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g17',
                                                                                         'in_discards': '156',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '8178430',
                                                                                         'in_octets': '56480782246',
                                                                                         'in_ucast_pkts': '239087024',
                                                                                         'mac_address': '00:02:5d:d5:30:ce',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '28212984549',
                                                                                         'out_octets': '36579146524400',
                                                                                         'out_ucast_pkts': '562951774',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMTc=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g18',
                                                                                         'in_discards': '17',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10232661',
                                                                                         'in_octets': '74344889325',
                                                                                         'in_ucast_pkts': '301172093',
                                                                                         'mac_address': '00:02:5d:d5:30:cf',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '35960706449',
                                                                                         'out_octets': '46920124072271',
                                                                                         'out_ucast_pkts': '532245244',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMTg=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g19',
                                                                                         'in_discards': '35',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '20426691',
                                                                                         'in_octets': '41338006278',
                                                                                         'in_ucast_pkts': '180559816',
                                                                                         'mac_address': '00:02:5d:d5:30:d0',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '58212423789',
                                                                                         'out_octets': '77014069646330',
                                                                                         'out_ucast_pkts': '366128758',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMTk=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g20',
                                                                                         'in_discards': '78',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '35584',
                                                                                         'in_octets': '139522876568',
                                                                                         'in_ucast_pkts': '987762790',
                                                                                         'mac_address': '00:02:5d:d5:30:d1',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g20',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431218068',
                                                                                         'out_octets': '4913776910385',
                                                                                         'out_ucast_pkts': '3489179284',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMjA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g21',
                                                                                         'in_discards': '1895',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2348892',
                                                                                         'in_octets': '871229012581',
                                                                                         'in_ucast_pkts': '5081065460',
                                                                                         'mac_address': '00:02:5d:d5:30:d2',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '2750123315',
                                                                                         'out_octets': '26299838481578',
                                                                                         'out_ucast_pkts': '17587894473',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMjE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g22',
                                                                                         'in_discards': '279',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '334810',
                                                                                         'in_octets': '347493448270',
                                                                                         'in_ucast_pkts': '1686689230',
                                                                                         'mac_address': '00:02:5d:d5:30:d3',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236095902',
                                                                                         'out_octets': '6100867799422',
                                                                                         'out_ucast_pkts': '4393218246',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMjI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g23',
                                                                                         'in_discards': '166',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '993796',
                                                                                         'in_octets': '725424970611',
                                                                                         'in_ucast_pkts': '3386092542',
                                                                                         'mac_address': '00:02:5d:d5:30:d4',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g23',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235361195',
                                                                                         'out_octets': '12918639289856',
                                                                                         'out_ucast_pkts': '9619187806',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMjM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '3/g24',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '335319',
                                                                                         'in_octets': '301940119829',
                                                                                         'in_ucast_pkts': '2021840054',
                                                                                         'mac_address': '00:02:5d:d5:30:d5',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '3/g24',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236095895',
                                                                                         'out_octets': '11645963296110',
                                                                                         'out_ucast_pkts': '8291801952',
                                                                                         'poller_hash': 'MjExNDA3NjAxNTczZXRoZXJuZXQgMy9nMjQ=',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'MjExNDA3NjAxNTcz',
                                                           'serial_number': '211407601573',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41920576'},
                                                   {       'id': '4',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '4/g1',
                                                                                         'in_discards': '200',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18555328',
                                                                                         'in_octets': '1019110199928',
                                                                                         'in_ucast_pkts': '3387662236',
                                                                                         'mac_address': '00:02:5d:ae:1c:10',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '59244120948',
                                                                                         'out_octets': '86654150407192',
                                                                                         'out_ucast_pkts': '6901529676',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cx',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g2',
                                                                                         'in_discards': '95',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '29738',
                                                                                         'in_octets': '110353485538',
                                                                                         'in_ucast_pkts': '134777811',
                                                                                         'mac_address': '00:02:5d:ae:1c:11',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477330418',
                                                                                         'out_octets': '414463600869',
                                                                                         'out_ucast_pkts': '267648354',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cy',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g3',
                                                                                         'in_discards': '6',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '357281',
                                                                                         'in_octets': '305271995280',
                                                                                         'in_ucast_pkts': '2606090170',
                                                                                         'mac_address': '00:02:5d:ae:1c:12',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431382802',
                                                                                         'out_octets': '8447212075685',
                                                                                         'out_ucast_pkts': '5792638058',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cz',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g4',
                                                                                         'in_discards': '207',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '38047',
                                                                                         'in_octets': '521873579030',
                                                                                         'in_ucast_pkts': '3361566210',
                                                                                         'mac_address': '00:02:5d:ae:1c:13',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477134854',
                                                                                         'out_octets': '16655965970320',
                                                                                         'out_ucast_pkts': '11659170374',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2c0',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g5',
                                                                                         'in_discards': '154',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '11589858',
                                                                                         'in_octets': '257300656625',
                                                                                         'in_ucast_pkts': '629626398',
                                                                                         'mac_address': '00:02:5d:ae:1c:14',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '23840533201',
                                                                                         'out_octets': '32252364523052',
                                                                                         'out_ucast_pkts': '1996895125',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2c1',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g6',
                                                                                         'in_discards': '224',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '277615',
                                                                                         'in_octets': '1718248441647',
                                                                                         'in_ucast_pkts': '5718262906',
                                                                                         'mac_address': '00:02:5d:ae:1c:15',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236215275',
                                                                                         'out_octets': '13861167204045',
                                                                                         'out_ucast_pkts': '10716036948',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2c2',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g7',
                                                                                         'in_discards': '93',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '37875',
                                                                                         'in_octets': '673158443295',
                                                                                         'in_ucast_pkts': '1507607327',
                                                                                         'mac_address': '00:02:5d:ae:1c:16',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1413617927',
                                                                                         'out_octets': '4890118786789',
                                                                                         'out_ucast_pkts': '3629757939',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2c3',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g8',
                                                                                         'in_discards': '71',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '15897441',
                                                                                         'in_octets': '152403072708',
                                                                                         'in_ucast_pkts': '689679846',
                                                                                         'mac_address': '00:02:5d:ae:1c:17',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '12669085435',
                                                                                         'out_octets': '17035538899964',
                                                                                         'out_ucast_pkts': '2017047770',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2c4',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g9',
                                                                                         'in_discards': '8',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '13283745',
                                                                                         'in_octets': '6581373176379',
                                                                                         'in_ucast_pkts': '12008118586',
                                                                                         'mac_address': '00:02:5d:ae:1c:18',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g9',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '32030404768',
                                                                                         'out_octets': '68999367508489',
                                                                                         'out_ucast_pkts': '23470567060',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2c5',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g10',
                                                                                         'in_discards': '365',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '30380',
                                                                                         'in_octets': '733792941327',
                                                                                         'in_ucast_pkts': '1818480336',
                                                                                         'mac_address': '00:02:5d:ae:1c:19',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191103603',
                                                                                         'out_octets': '9917671920653',
                                                                                         'out_ucast_pkts': '7587973679',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cxMA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g11',
                                                                                         'in_discards': '173',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '754061',
                                                                                         'in_octets': '465274154767',
                                                                                         'in_ucast_pkts': '899007315',
                                                                                         'mac_address': '00:02:5d:ae:1c:1a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190371264',
                                                                                         'out_octets': '4077351420493',
                                                                                         'out_ucast_pkts': '3196185503',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cxMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g12',
                                                                                         'in_discards': '342',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '8776971',
                                                                                         'in_octets': '695508211609',
                                                                                         'in_ucast_pkts': '2411494901',
                                                                                         'mac_address': '00:02:5d:ae:1c:1b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '19917223415',
                                                                                         'out_octets': '34717852170425',
                                                                                         'out_ucast_pkts': '7849958231',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cxMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g13',
                                                                                         'in_discards': '30',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18902539',
                                                                                         'in_octets': '720352195919',
                                                                                         'in_ucast_pkts': '1951081452',
                                                                                         'mac_address': '00:02:5d:ae:1c:1c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g13',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '53369502011',
                                                                                         'out_octets': '74029258153343',
                                                                                         'out_ucast_pkts': '3653701471',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cxMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g14',
                                                                                         'in_discards': '190',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '945371',
                                                                                         'in_octets': '909357598143',
                                                                                         'in_ucast_pkts': '2132502352',
                                                                                         'mac_address': '00:02:5d:ae:1c:1d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g14',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235646075',
                                                                                         'out_octets': '5534408262779',
                                                                                         'out_ucast_pkts': '4619880257',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cxNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g15',
                                                                                         'in_discards': '46',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '283349',
                                                                                         'in_octets': '109933176240',
                                                                                         'in_ucast_pkts': '421422193',
                                                                                         'mac_address': '00:02:5d:ae:1c:1e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236297185',
                                                                                         'out_octets': '2214166116954',
                                                                                         'out_ucast_pkts': '1630393748',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cxNQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '4/g16',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ae:1c:1f',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g16',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cxNg=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g17',
                                                                                         'in_discards': '127',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9512259',
                                                                                         'in_octets': '351810573301',
                                                                                         'in_ucast_pkts': '974370603',
                                                                                         'mac_address': '00:02:5d:ae:1c:20',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '33678152113',
                                                                                         'out_octets': '46547740407193',
                                                                                         'out_ucast_pkts': '2620088208',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cxNw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g18',
                                                                                         'in_discards': '337',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '281624',
                                                                                         'in_octets': '619346074783',
                                                                                         'in_ucast_pkts': '3164264596',
                                                                                         'mac_address': '00:02:5d:ae:1c:21',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '238064248',
                                                                                         'out_octets': '13643350020435',
                                                                                         'out_ucast_pkts': '10671481385',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cxOA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g19',
                                                                                         'in_discards': '172',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '453961',
                                                                                         'in_octets': '413309753884',
                                                                                         'in_ucast_pkts': '1130394023',
                                                                                         'mac_address': '00:02:5d:ae:1c:22',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190664895',
                                                                                         'out_octets': '3403010350835',
                                                                                         'out_ucast_pkts': '2712487659',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cxOQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g20',
                                                                                         'in_discards': '17',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17539552',
                                                                                         'in_octets': '1164660409031',
                                                                                         'in_ucast_pkts': '5874835056',
                                                                                         'mac_address': '00:02:5d:ae:1c:23',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g20',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '43589399444',
                                                                                         'out_octets': '82048255128911',
                                                                                         'out_ucast_pkts': '17894541929',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cyMA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g21',
                                                                                         'in_discards': '9',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '462568',
                                                                                         'in_octets': '403615943802',
                                                                                         'in_ucast_pkts': '1102768963',
                                                                                         'mac_address': '00:02:5d:ae:1c:24',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1476904192',
                                                                                         'out_octets': '3139232810730',
                                                                                         'out_ucast_pkts': '2515150086',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cyMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g22',
                                                                                         'in_discards': '208',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '28925819',
                                                                                         'in_octets': '587625302169',
                                                                                         'in_ucast_pkts': '2774150065',
                                                                                         'mac_address': '00:02:5d:ae:1c:25',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '66454821605',
                                                                                         'out_octets': '98768217805208',
                                                                                         'out_ucast_pkts': '8975559504',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cyMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '4/g23',
                                                                                         'in_discards': '582',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2284896',
                                                                                         'in_octets': '331919137287',
                                                                                         'in_ucast_pkts': '1184093409',
                                                                                         'mac_address': '00:02:5d:ae:1c:26',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g23',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '7868100247',
                                                                                         'out_octets': '14865065913305',
                                                                                         'out_ucast_pkts': '3750532179',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cyMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '4/g24',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ae:1c:27',
                                                                                         'name': 'ethernet '
                                                                                                 '4/g24',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDQwMDlldGhlcm5ldCA0L2cyNA=='}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDQwMDk=',
                                                           'serial_number': '81110004009',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41930067'},
                                                   {       'id': '5',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '5/g1',
                                                                                         'in_discards': '25',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '40457',
                                                                                         'in_octets': '113697763385',
                                                                                         'in_ucast_pkts': '890738670',
                                                                                         'mac_address': '00:02:5d:e6:61:05',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191165835',
                                                                                         'out_octets': '3841851996363',
                                                                                         'out_ucast_pkts': '2900523894',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g2',
                                                                                         'in_discards': '12',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '32566',
                                                                                         'in_octets': '15592128341',
                                                                                         'in_ucast_pkts': '68483121',
                                                                                         'mac_address': '00:02:5d:e6:61:06',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236502068',
                                                                                         'out_octets': '572893540815',
                                                                                         'out_ucast_pkts': '413283470',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g3',
                                                                                         'in_discards': '302',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '40520',
                                                                                         'in_octets': '896557038760',
                                                                                         'in_ucast_pkts': '3734186718',
                                                                                         'mac_address': '00:02:5d:e6:61:07',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477420667',
                                                                                         'out_octets': '16253221760586',
                                                                                         'out_ucast_pkts': '11736498850',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g4',
                                                                                         'in_discards': '54',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10233054',
                                                                                         'in_octets': '70643106405',
                                                                                         'in_ucast_pkts': '345577927',
                                                                                         'mac_address': '00:02:5d:e6:61:08',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '21606324651',
                                                                                         'out_octets': '27927610623402',
                                                                                         'out_ucast_pkts': '923106302',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g5',
                                                                                         'in_discards': '188',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '33591',
                                                                                         'in_octets': '1059812111633',
                                                                                         'in_ucast_pkts': '4863027225',
                                                                                         'mac_address': '00:02:5d:e6:61:09',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191132737',
                                                                                         'out_octets': '13017154857763',
                                                                                         'out_ucast_pkts': '10255991288',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nNQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g6',
                                                                                         'in_discards': '20',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '8601241',
                                                                                         'in_octets': '31893225136',
                                                                                         'in_ucast_pkts': '151686332',
                                                                                         'mac_address': '00:02:5d:e6:61:0a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '10727447783',
                                                                                         'out_octets': '12501935074083',
                                                                                         'out_ucast_pkts': '480403350',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nNg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g7',
                                                                                         'in_discards': '53',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '34152',
                                                                                         'in_octets': '243738298452',
                                                                                         'in_ucast_pkts': '1612678082',
                                                                                         'mac_address': '00:02:5d:e6:61:0b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191140784',
                                                                                         'out_octets': '6975296732924',
                                                                                         'out_ucast_pkts': '4810922164',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nNw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '5/g8',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:e6:61:0c',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g8',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nOA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g9',
                                                                                         'in_discards': '15',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '799551',
                                                                                         'in_octets': '163325565558',
                                                                                         'in_ucast_pkts': '231706350',
                                                                                         'mac_address': '00:02:5d:e6:61:0d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g9',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190400867',
                                                                                         'out_octets': '295685576601',
                                                                                         'out_ucast_pkts': '285088320',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nOQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g10',
                                                                                         'in_discards': '109',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '956943',
                                                                                         'in_octets': '49125616825',
                                                                                         'in_ucast_pkts': '231015723',
                                                                                         'mac_address': '00:02:5d:e6:61:0e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235667760',
                                                                                         'out_octets': '604904991938',
                                                                                         'out_ucast_pkts': '536799064',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMTA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g11',
                                                                                         'in_discards': '15',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '807621',
                                                                                         'in_octets': '806145470420',
                                                                                         'in_ucast_pkts': '3277470038',
                                                                                         'mac_address': '00:02:5d:e6:61:0f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190396661',
                                                                                         'out_octets': '18058783959754',
                                                                                         'out_ucast_pkts': '12810275226',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMTE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g12',
                                                                                         'in_discards': '15',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '241972',
                                                                                         'in_octets': '130209284',
                                                                                         'in_ucast_pkts': '427753',
                                                                                         'mac_address': '00:02:5d:e6:61:10',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '78816842',
                                                                                         'out_octets': '5466469749',
                                                                                         'out_ucast_pkts': '436841',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMTI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g13',
                                                                                         'in_discards': '1546',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '47690',
                                                                                         'in_octets': '943004444341',
                                                                                         'in_ucast_pkts': '4099876217',
                                                                                         'mac_address': '00:02:5d:e6:61:11',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g13',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431436748',
                                                                                         'out_octets': '24056104875367',
                                                                                         'out_ucast_pkts': '16685371450',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMTM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g14',
                                                                                         'in_discards': '178809',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '866750',
                                                                                         'in_octets': '109870602582',
                                                                                         'in_ucast_pkts': '271810941',
                                                                                         'mac_address': '00:02:5d:e6:61:12',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g14',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '165941880',
                                                                                         'out_octets': '1122724301856',
                                                                                         'out_ucast_pkts': '899599934',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMTQ=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g15',
                                                                                         'in_discards': '31',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '772169',
                                                                                         'in_octets': '311752315898',
                                                                                         'in_ucast_pkts': '1390949824',
                                                                                         'mac_address': '00:02:5d:e6:61:13',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190429550',
                                                                                         'out_octets': '5739742171471',
                                                                                         'out_ucast_pkts': '4335574586',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMTU=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g16',
                                                                                         'in_discards': '249',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16838423',
                                                                                         'in_octets': '235160369239',
                                                                                         'in_ucast_pkts': '1176701113',
                                                                                         'mac_address': '00:02:5d:e6:61:14',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '28445803120',
                                                                                         'out_octets': '39256319476865',
                                                                                         'out_ucast_pkts': '2532565795',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMTY=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g17',
                                                                                         'in_discards': '121',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '784514',
                                                                                         'in_octets': '164325507732',
                                                                                         'in_ucast_pkts': '523620900',
                                                                                         'mac_address': '00:02:5d:e6:61:15',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431058806',
                                                                                         'out_octets': '2592853488907',
                                                                                         'out_ucast_pkts': '1830433653',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMTc=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g18',
                                                                                         'in_discards': '21053',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '535746',
                                                                                         'in_octets': '217788583777',
                                                                                         'in_ucast_pkts': '1170737981',
                                                                                         'mac_address': '00:02:5d:e6:61:16',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190512383',
                                                                                         'out_octets': '6852551370624',
                                                                                         'out_ucast_pkts': '5067672826',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMTg=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g19',
                                                                                         'in_discards': '27',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1043593',
                                                                                         'in_octets': '417467663855',
                                                                                         'in_ucast_pkts': '364349723',
                                                                                         'mac_address': '00:02:5d:e6:61:17',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235586595',
                                                                                         'out_octets': '89918664618',
                                                                                         'out_ucast_pkts': '340298978',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMTk=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '5/g20',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:e6:61:18',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g20',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMjA='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g21',
                                                                                         'in_discards': '15',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16038296',
                                                                                         'in_octets': '2388682852454',
                                                                                         'in_ucast_pkts': '4801253186',
                                                                                         'mac_address': '00:02:5d:e6:61:19',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '32105870879',
                                                                                         'out_octets': '52741281144325',
                                                                                         'out_ucast_pkts': '10245912218',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMjE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g22',
                                                                                         'in_discards': '79',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '771804',
                                                                                         'in_octets': '139188009500',
                                                                                         'in_ucast_pkts': '270958949',
                                                                                         'mac_address': '00:02:5d:e6:61:1a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1476673405',
                                                                                         'out_octets': '666594939368',
                                                                                         'out_ucast_pkts': '460757622',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMjI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g23',
                                                                                         'in_discards': '57',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '34701',
                                                                                         'in_octets': '87293156273',
                                                                                         'in_ucast_pkts': '485411448',
                                                                                         'mac_address': '00:02:5d:e6:61:1b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g23',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191133438',
                                                                                         'out_octets': '4066424997471',
                                                                                         'out_ucast_pkts': '2989438065',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMjM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '5/g24',
                                                                                         'in_discards': '32152',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '641238',
                                                                                         'in_octets': '109668549916',
                                                                                         'in_ucast_pkts': '658455610',
                                                                                         'mac_address': '00:02:5d:e6:61:1c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '5/g24',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190380084',
                                                                                         'out_octets': '2642244444553',
                                                                                         'out_ucast_pkts': '1996454515',
                                                                                         'poller_hash': 'MjExNTA5NjAxMDIxZXRoZXJuZXQgNS9nMjQ=',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'MjExNTA5NjAxMDIx',
                                                           'serial_number': '211509601021',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931281'},
                                                   {       'id': '6',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '6/g1',
                                                                                         'in_discards': '141',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '811138',
                                                                                         'in_octets': '766388812137',
                                                                                         'in_ucast_pkts': '3168079165',
                                                                                         'mac_address': '00:02:5d:ec:68:63',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190377196',
                                                                                         'out_octets': '15406079575006',
                                                                                         'out_ucast_pkts': '11700381061',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g2',
                                                                                         'in_discards': '27',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1045667',
                                                                                         'in_octets': '228558592999',
                                                                                         'in_ucast_pkts': '1276398013',
                                                                                         'mac_address': '00:02:5d:ec:68:64',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235596745',
                                                                                         'out_octets': '9078916772500',
                                                                                         'out_ucast_pkts': '6642302135',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g3',
                                                                                         'in_discards': '758',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18377287',
                                                                                         'in_octets': '340305769719',
                                                                                         'in_ucast_pkts': '2051702112',
                                                                                         'mac_address': '00:02:5d:ec:68:65',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '60162996007',
                                                                                         'out_octets': '92159956574094',
                                                                                         'out_ucast_pkts': '9243820892',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g4',
                                                                                         'in_discards': '205',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '649355',
                                                                                         'in_octets': '16049677919',
                                                                                         'in_ucast_pkts': '107791285',
                                                                                         'mac_address': '00:02:5d:ec:68:66',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190523869',
                                                                                         'out_octets': '286016608003',
                                                                                         'out_ucast_pkts': '247746467',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g5',
                                                                                         'in_discards': '54',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '866557',
                                                                                         'in_octets': '185280412549',
                                                                                         'in_ucast_pkts': '313185529',
                                                                                         'mac_address': '00:02:5d:ec:68:67',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235773077',
                                                                                         'out_octets': '628728675020',
                                                                                         'out_ucast_pkts': '564449344',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nNQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g6',
                                                                                         'in_discards': '28',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1048887',
                                                                                         'in_octets': '25438297271',
                                                                                         'in_ucast_pkts': '120095143',
                                                                                         'mac_address': '00:02:5d:ec:68:68',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235593195',
                                                                                         'out_octets': '170549828370',
                                                                                         'out_ucast_pkts': '175376063',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nNg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g7',
                                                                                         'in_discards': '98',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '637204',
                                                                                         'in_octets': '501826847792',
                                                                                         'in_ucast_pkts': '2116318930',
                                                                                         'mac_address': '00:02:5d:ec:68:69',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1471898724',
                                                                                         'out_octets': '8023986709495',
                                                                                         'out_ucast_pkts': '5765873967',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nNw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g8',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ec:68:6a',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g8',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nOA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g9',
                                                                                         'in_discards': '7',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '344987',
                                                                                         'in_octets': '1057421128548',
                                                                                         'in_ucast_pkts': '2790933099',
                                                                                         'mac_address': '00:02:5d:ec:68:6b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g9',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190828719',
                                                                                         'out_octets': '2036979619672',
                                                                                         'out_ucast_pkts': '2355527810',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nOQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g10',
                                                                                         'in_discards': '824',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '45270',
                                                                                         'in_octets': '1552890217064',
                                                                                         'in_ucast_pkts': '4334421445',
                                                                                         'mac_address': '00:02:5d:ec:68:6c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191107756',
                                                                                         'out_octets': '17147055057475',
                                                                                         'out_ucast_pkts': '13043515013',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMTA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g11',
                                                                                         'in_discards': '931',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '34933857',
                                                                                         'in_octets': '460552812706',
                                                                                         'in_ucast_pkts': '567610364',
                                                                                         'mac_address': '00:02:5d:ec:68:6d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '72290799346',
                                                                                         'out_octets': '96770553765247',
                                                                                         'out_ucast_pkts': '880665681',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMTE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g12',
                                                                                         'in_discards': '121',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '817276',
                                                                                         'in_octets': '263844523594',
                                                                                         'in_ucast_pkts': '533522652',
                                                                                         'mac_address': '00:02:5d:ec:68:6e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190371209',
                                                                                         'out_octets': '1083678108569',
                                                                                         'out_ucast_pkts': '999875228',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMTI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g13',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ec:68:6f',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g13',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMTM='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g14',
                                                                                         'in_discards': '55',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16171818',
                                                                                         'in_octets': '571527374778',
                                                                                         'in_ucast_pkts': '1430475026',
                                                                                         'mac_address': '00:02:5d:ec:68:70',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g14',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '16974815959',
                                                                                         'out_octets': '24746654688689',
                                                                                         'out_ucast_pkts': '3465641975',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMTQ=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g15',
                                                                                         'in_discards': '30',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '27590141',
                                                                                         'in_octets': '362169777065',
                                                                                         'in_ucast_pkts': '1194857281',
                                                                                         'mac_address': '00:02:5d:ec:68:71',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '49838730143',
                                                                                         'out_octets': '69408325728030',
                                                                                         'out_ucast_pkts': '3430977108',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMTU=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g16',
                                                                                         'in_discards': '33',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '44055',
                                                                                         'in_octets': '485916155426',
                                                                                         'in_ucast_pkts': '1577981174',
                                                                                         'mac_address': '00:02:5d:ec:68:72',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191137802',
                                                                                         'out_octets': '5178874050961',
                                                                                         'out_ucast_pkts': '3850894290',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMTY=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g17',
                                                                                         'in_discards': '42280',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '567659',
                                                                                         'in_octets': '272753028577',
                                                                                         'in_ucast_pkts': '2463496457',
                                                                                         'mac_address': '00:02:5d:ec:68:73',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190327268',
                                                                                         'out_octets': '13756853325130',
                                                                                         'out_ucast_pkts': '9424328683',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMTc=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g18',
                                                                                         'in_discards': '227',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '35597',
                                                                                         'in_octets': '382690766891',
                                                                                         'in_ucast_pkts': '3066807779',
                                                                                         'mac_address': '00:02:5d:ec:68:74',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191177241',
                                                                                         'out_octets': '11749158174404',
                                                                                         'out_ucast_pkts': '8259843959',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMTg=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g19',
                                                                                         'in_discards': '15',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '602023',
                                                                                         'in_octets': '6558940250881',
                                                                                         'in_ucast_pkts': '11545403815',
                                                                                         'mac_address': '00:02:5d:ec:68:75',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190617695',
                                                                                         'out_octets': '28662523847978',
                                                                                         'out_ucast_pkts': '24097522076',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMTk=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g20',
                                                                                         'in_discards': '261',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '510327',
                                                                                         'in_octets': '84061861575',
                                                                                         'in_ucast_pkts': '476903883',
                                                                                         'mac_address': '00:02:5d:ec:68:76',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g20',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190669703',
                                                                                         'out_octets': '2722055600777',
                                                                                         'out_ucast_pkts': '1864287727',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMjA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g21',
                                                                                         'in_discards': '155',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '15873693',
                                                                                         'in_octets': '214173190609',
                                                                                         'in_ucast_pkts': '1030311350',
                                                                                         'mac_address': '00:02:5d:ec:68:77',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '4890792241',
                                                                                         'out_octets': '10090103448756',
                                                                                         'out_ucast_pkts': '4756928960',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMjE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g22',
                                                                                         'in_discards': '141',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '247526',
                                                                                         'in_octets': '130966947',
                                                                                         'in_ucast_pkts': '417349',
                                                                                         'mac_address': '00:02:5d:ec:68:78',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431580008',
                                                                                         'out_octets': '131799104727',
                                                                                         'out_ucast_pkts': '2833537',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMjI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '6/g23',
                                                                                         'in_discards': '27',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '560969',
                                                                                         'in_octets': '1484863543566',
                                                                                         'in_ucast_pkts': '5604537854',
                                                                                         'mac_address': '00:02:5d:ec:68:79',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g23',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236087862',
                                                                                         'out_octets': '18522996029399',
                                                                                         'out_ucast_pkts': '14771579725',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMjM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '6/g24',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ec:68:7a',
                                                                                         'name': 'ethernet '
                                                                                                 '6/g24',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNjAzNjAxMTkwZXRoZXJuZXQgNi9nMjQ='}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'MjExNjAzNjAxMTkw',
                                                           'serial_number': '211603601190',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41930951'},
                                                   {       'id': '7',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '7/1',
                                                                                         'in_discards': '2502431',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2633038',
                                                                                         'in_octets': '15788938672465',
                                                                                         'in_ucast_pkts': '49864349137',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '7/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '91124837107',
                                                                                         'out_octets': '274885177962861',
                                                                                         'out_ucast_pkts': '115482433251',
                                                                                         'poller_hash': 'MjExNjA1NjAxMjE1Z3BvbiA3LzE=',
                                                                                         'pons': [       {       'id': '7/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '7/1',
                                                                                                                 'poller_hash': 'MjExNjA1NjAxMjE1cG9uZ3BvbiA3LzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '7/2',
                                                                                         'in_discards': '118390',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '361313',
                                                                                         'in_octets': '9048823123272',
                                                                                         'in_ucast_pkts': '28087870997',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '7/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '97930407823',
                                                                                         'out_octets': '219959305124704',
                                                                                         'out_ucast_pkts': '67728071322',
                                                                                         'poller_hash': 'MjExNjA1NjAxMjE1Z3BvbiA3LzI=',
                                                                                         'pons': [       {       'id': '7/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '7/2',
                                                                                                                 'poller_hash': 'MjExNjA1NjAxMjE1cG9uZ3BvbiA3LzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '7/3',
                                                                                         'in_discards': '4420',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '33739',
                                                                                         'in_octets': '3223117823563',
                                                                                         'in_ucast_pkts': '15213173166',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '7/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '184145600729',
                                                                                         'out_octets': '302913498633244',
                                                                                         'out_ucast_pkts': '40230780771',
                                                                                         'poller_hash': 'MjExNjA1NjAxMjE1Z3BvbiA3LzM=',
                                                                                         'pons': [       {       'id': '7/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '7/3',
                                                                                                                 'poller_hash': 'MjExNjA1NjAxMjE1cG9uZ3BvbiA3LzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '7/4',
                                                                                         'in_discards': '143077',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '168390',
                                                                                         'in_octets': '12681403074411',
                                                                                         'in_ucast_pkts': '49174434237',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '7/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '83218226558',
                                                                                         'out_octets': '284057570533146',
                                                                                         'out_ucast_pkts': '125717702923',
                                                                                         'poller_hash': 'MjExNjA1NjAxMjE1Z3BvbiA3LzQ=',
                                                                                         'pons': [       {       'id': '7/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '7/4',
                                                                                                                 'poller_hash': 'MjExNjA1NjAxMjE1cG9uZ3BvbiA3LzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '7/5',
                                                                                         'in_discards': '443',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '487383',
                                                                                         'in_octets': '3662855996895',
                                                                                         'in_ucast_pkts': '19285791365',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '7/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '189279379017',
                                                                                         'out_octets': '327735217849620',
                                                                                         'out_ucast_pkts': '51957279306',
                                                                                         'poller_hash': 'MjExNjA1NjAxMjE1Z3BvbiA3LzU=',
                                                                                         'pons': [       {       'id': '7/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '7/5',
                                                                                                                 'poller_hash': 'MjExNjA1NjAxMjE1cG9uZ3BvbiA3LzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '7/6',
                                                                                         'in_discards': '27',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9419136',
                                                                                         'in_octets': '9066550891840',
                                                                                         'in_ucast_pkts': '15735398840',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '7/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '176799087339',
                                                                                         'out_octets': '281976329850681',
                                                                                         'out_ucast_pkts': '34772982202',
                                                                                         'poller_hash': 'MjExNjA1NjAxMjE1Z3BvbiA3LzY=',
                                                                                         'pons': [       {       'id': '7/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '7/6',
                                                                                                                 'poller_hash': 'MjExNjA1NjAxMjE1cG9uZ3BvbiA3LzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '7/7',
                                                                                         'in_discards': '1417',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9484518',
                                                                                         'in_octets': '7220447312606',
                                                                                         'in_ucast_pkts': '23744113961',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '7/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '169535256215',
                                                                                         'out_octets': '321198436219033',
                                                                                         'out_ucast_pkts': '67828979321',
                                                                                         'poller_hash': 'MjExNjA1NjAxMjE1Z3BvbiA3Lzc=',
                                                                                         'pons': [       {       'id': '7/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '7/7',
                                                                                                                 'poller_hash': 'MjExNjA1NjAxMjE1cG9uZ3BvbiA3Lzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '7/8',
                                                                                         'in_discards': '3545',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '7939475',
                                                                                         'in_octets': '5834178360142',
                                                                                         'in_ucast_pkts': '24693578720',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '7/8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '30810873237',
                                                                                         'out_octets': '131149635035200',
                                                                                         'out_ucast_pkts': '67481807018',
                                                                                         'poller_hash': 'MjExNjA1NjAxMjE1Z3BvbiA3Lzg=',
                                                                                         'pons': [       {       'id': '7/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '7/8',
                                                                                                                 'poller_hash': 'MjExNjA1NjAxMjE1cG9uZ3BvbiA3Lzg=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03007',
                                                           'name': 'GPON-8x',
                                                           'poller_hash': 'MjExNjA1NjAxMjE1',
                                                           'serial_number': '211605601215',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931232'},
                                                   {       'id': '8',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '8/1',
                                                                                         'in_discards': '13838',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '52725',
                                                                                         'in_octets': '8966721063100',
                                                                                         'in_ucast_pkts': '37186426863',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '8/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '228155763736',
                                                                                         'out_octets': '452017058446483',
                                                                                         'out_ucast_pkts': '103022400235',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjcyZ3BvbiA4LzE=',
                                                                                         'pons': [       {       'id': '8/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '8/1',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjcycG9uZ3BvbiA4LzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '8/2',
                                                                                         'in_discards': '456',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '5877628',
                                                                                         'in_octets': '30103212747640',
                                                                                         'in_ucast_pkts': '54622382928',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '8/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '143116747233',
                                                                                         'out_octets': '327633393210333',
                                                                                         'out_ucast_pkts': '115632647244',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjcyZ3BvbiA4LzI=',
                                                                                         'pons': [       {       'id': '8/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '8/2',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjcycG9uZ3BvbiA4LzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '8/3',
                                                                                         'in_discards': '253523',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9450855',
                                                                                         'in_octets': '28309668131941',
                                                                                         'in_ucast_pkts': '45810839993',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '8/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '128795247229',
                                                                                         'out_octets': '305863902834883',
                                                                                         'out_ucast_pkts': '99883997082',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjcyZ3BvbiA4LzM=',
                                                                                         'pons': [       {       'id': '8/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '8/3',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjcycG9uZ3BvbiA4LzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '8/4',
                                                                                         'in_discards': '165463',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '141391',
                                                                                         'in_octets': '6890586811375',
                                                                                         'in_ucast_pkts': '22783009825',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '8/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '233969522480',
                                                                                         'out_octets': '403615034430975',
                                                                                         'out_ucast_pkts': '63759866032',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjcyZ3BvbiA4LzQ=',
                                                                                         'pons': [       {       'id': '8/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '8/4',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjcycG9uZ3BvbiA4LzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '8/5',
                                                                                         'in_discards': '9895',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9513066',
                                                                                         'in_octets': '84566508382772',
                                                                                         'in_ucast_pkts': '188444490378',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '8/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '140487132894',
                                                                                         'out_octets': '640910934865963',
                                                                                         'out_ucast_pkts': '348156351553',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjcyZ3BvbiA4LzU=',
                                                                                         'pons': [       {       'id': '8/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '8/5',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjcycG9uZ3BvbiA4LzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '8/6',
                                                                                         'in_discards': '113255',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9515081',
                                                                                         'in_octets': '6545384451711',
                                                                                         'in_ucast_pkts': '26595930898',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '8/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '81077192612',
                                                                                         'out_octets': '202488148563055',
                                                                                         'out_ucast_pkts': '70895642095',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjcyZ3BvbiA4LzY=',
                                                                                         'pons': [       {       'id': '8/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '8/6',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjcycG9uZ3BvbiA4LzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '8/7',
                                                                                         'in_discards': '3631',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '14476167',
                                                                                         'in_octets': '157813009011555',
                                                                                         'in_ucast_pkts': '202955729926',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '8/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '185017063297',
                                                                                         'out_octets': '474602958389472',
                                                                                         'out_ucast_pkts': '244169600280',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjcyZ3BvbiA4Lzc=',
                                                                                         'pons': [       {       'id': '8/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '8/7',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjcycG9uZ3BvbiA4Lzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '8/8',
                                                                                         'in_discards': '6257',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '272593',
                                                                                         'in_octets': '8929779773571',
                                                                                         'in_ucast_pkts': '20354882997',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '8/8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '326166285036',
                                                                                         'out_octets': '501171574935183',
                                                                                         'out_ucast_pkts': '46349508576',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjcyZ3BvbiA4Lzg=',
                                                                                         'pons': [       {       'id': '8/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '8/8',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjcycG9uZ3BvbiA4Lzg=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03007',
                                                           'name': 'GPON-8x',
                                                           'poller_hash': 'MjExNjEyNjA2Njcy',
                                                           'serial_number': '211612606672',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41854921'},
                                                   {       'id': '9',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '9/1',
                                                                                         'in_discards': '947',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '300835',
                                                                                         'in_octets': '2217616221204',
                                                                                         'in_ucast_pkts': '10775588830',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '9/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '215790505082',
                                                                                         'out_octets': '336755025029446',
                                                                                         'out_ucast_pkts': '32242082507',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjUwZ3BvbiA5LzE=',
                                                                                         'pons': [       {       'id': '9/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '9/1',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjUwcG9uZ3BvbiA5LzE=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '9/2',
                                                                                         'in_discards': '33563',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '39106828',
                                                                                         'in_octets': '9511041584996',
                                                                                         'in_ucast_pkts': '34265967668',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '9/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '211136936394',
                                                                                         'out_octets': '414764692105219',
                                                                                         'out_ucast_pkts': '96910469565',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjUwZ3BvbiA5LzI=',
                                                                                         'pons': [       {       'id': '9/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '9/2',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjUwcG9uZ3BvbiA5LzI=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '9/3',
                                                                                         'in_discards': '11741',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '29806',
                                                                                         'in_octets': '11495222912542',
                                                                                         'in_ucast_pkts': '36007141207',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '9/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '145913478548',
                                                                                         'out_octets': '316596498975922',
                                                                                         'out_ucast_pkts': '90699959973',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjUwZ3BvbiA5LzM=',
                                                                                         'pons': [       {       'id': '9/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '9/3',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjUwcG9uZ3BvbiA5LzM=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '9/4',
                                                                                         'in_discards': '8073',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '75112210',
                                                                                         'in_octets': '8633233781651',
                                                                                         'in_ucast_pkts': '27244524919',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '9/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '271284380811',
                                                                                         'out_octets': '467465398716612',
                                                                                         'out_ucast_pkts': '74112211445',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjUwZ3BvbiA5LzQ=',
                                                                                         'pons': [       {       'id': '9/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '9/4',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjUwcG9uZ3BvbiA5LzQ=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '9/5',
                                                                                         'in_discards': '126321',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '15692618',
                                                                                         'in_octets': '8620410254238',
                                                                                         'in_ucast_pkts': '29252722309',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '9/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '45672530941',
                                                                                         'out_octets': '162229484216087',
                                                                                         'out_ucast_pkts': '76029983590',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjUwZ3BvbiA5LzU=',
                                                                                         'pons': [       {       'id': '9/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '9/5',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjUwcG9uZ3BvbiA5LzU=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '9/6',
                                                                                         'in_discards': '6046',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '151123',
                                                                                         'in_octets': '13320585703359',
                                                                                         'in_ucast_pkts': '29925208796',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '9/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '7515302189',
                                                                                         'out_octets': '116335772993374',
                                                                                         'out_ucast_pkts': '80714567258',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjUwZ3BvbiA5LzY=',
                                                                                         'pons': [       {       'id': '9/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '9/6',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjUwcG9uZ3BvbiA5LzY=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '9/7',
                                                                                         'in_discards': '14229',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '3858210',
                                                                                         'in_octets': '11414026380948',
                                                                                         'in_ucast_pkts': '41634255428',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '9/7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '274482830431',
                                                                                         'out_octets': '495832022016028',
                                                                                         'out_ucast_pkts': '96011059560',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjUwZ3BvbiA5Lzc=',
                                                                                         'pons': [       {       'id': '9/7',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '9/7',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjUwcG9uZ3BvbiA5Lzc=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '9/8',
                                                                                         'in_discards': '1209451',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1531694',
                                                                                         'in_octets': '7220487890789',
                                                                                         'in_ucast_pkts': '32396701320',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05071',
                                                                                         'name': 'gpon '
                                                                                                 '9/8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '102105973725',
                                                                                         'out_octets': '280768818243248',
                                                                                         'out_ucast_pkts': '103296216691',
                                                                                         'poller_hash': 'MjExNjEyNjA2NjUwZ3BvbiA5Lzg=',
                                                                                         'pons': [       {       'id': '9/8',
                                                                                                                 'max_distance': 60000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '9/8',
                                                                                                                 'poller_hash': 'MjExNjEyNjA2NjUwcG9uZ3BvbiA5Lzg=',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03007',
                                                           'name': 'GPON-8x',
                                                           'poller_hash': 'MjExNjEyNjA2NjUw',
                                                           'serial_number': '211612606650',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931337'},
                                                   {       'id': '14',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '14/1',
                                                                                         'in_discards': '8044',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1329413',
                                                                                         'in_octets': '3144233767337',
                                                                                         'in_ucast_pkts': '12940403134',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '14/1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '478861665057',
                                                                                         'out_octets': '699213029953097',
                                                                                         'out_ucast_pkts': '37167820993',
                                                                                         'poller_hash': 'NDcxOTA1MDEwMzUzZ3BvbiAxNC8x',
                                                                                         'pons': [       {       'id': '14/1',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '14/1',
                                                                                                                 'poller_hash': 'NDcxOTA1MDEwMzUzcG9uZ3BvbiAxNC8x',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '14/2',
                                                                                         'in_discards': '161354',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1409347',
                                                                                         'in_octets': '26623642522470',
                                                                                         'in_ucast_pkts': '76558355969',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01782',
                                                                                         'name': 'gpon '
                                                                                                 '14/2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '394862775407',
                                                                                         'out_octets': '808694497549276',
                                                                                         'out_ucast_pkts': '200386266901',
                                                                                         'poller_hash': 'NDcxOTA1MDEwMzUzZ3BvbiAxNC8y',
                                                                                         'pons': [       {       'id': '14/2',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '14/2',
                                                                                                                 'poller_hash': 'NDcxOTA1MDEwMzUzcG9uZ3BvbiAxNC8y',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '14/3',
                                                                                         'in_discards': '112522',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '221986',
                                                                                         'in_octets': '19118782023826',
                                                                                         'in_ucast_pkts': '65230395046',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '14/3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '453460313583',
                                                                                         'out_octets': '863630851567308',
                                                                                         'out_ucast_pkts': '181802579800',
                                                                                         'poller_hash': 'NDcxOTA1MDEwMzUzZ3BvbiAxNC8z',
                                                                                         'pons': [       {       'id': '14/3',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '14/3',
                                                                                                                 'poller_hash': 'NDcxOTA1MDEwMzUzcG9uZ3BvbiAxNC8z',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '14/4',
                                                                                         'in_discards': '1465383',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1675299',
                                                                                         'in_octets': '37407870813885',
                                                                                         'in_ucast_pkts': '82257681075',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '14/4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '432208963082',
                                                                                         'out_octets': '829094748617947',
                                                                                         'out_ucast_pkts': '199233779346',
                                                                                         'poller_hash': 'NDcxOTA1MDEwMzUzZ3BvbiAxNC80',
                                                                                         'pons': [       {       'id': '14/4',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '14/4',
                                                                                                                 'poller_hash': 'NDcxOTA1MDEwMzUzcG9uZ3BvbiAxNC80',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '14/5',
                                                                                         'in_discards': '20011',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '333030',
                                                                                         'in_octets': '4624390642244',
                                                                                         'in_ucast_pkts': '22077008335',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '14/5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '114958334231',
                                                                                         'out_octets': '236128741686567',
                                                                                         'out_ucast_pkts': '58737987963',
                                                                                         'poller_hash': 'NDcxOTA1MDEwMzUzZ3BvbiAxNC81',
                                                                                         'pons': [       {       'id': '14/5',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '14/5',
                                                                                                                 'poller_hash': 'NDcxOTA1MDEwMzUzcG9uZ3BvbiAxNC81',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '14/6',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '1710257814948',
                                                                                         'in_ucast_pkts': '2121851506',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': 'gpon '
                                                                                                 '14/6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '22598143',
                                                                                         'out_octets': '2803680537461',
                                                                                         'out_ucast_pkts': '3111015060',
                                                                                         'poller_hash': 'NDcxOTA1MDEwMzUzZ3BvbiAxNC82',
                                                                                         'pons': [       {       'id': '14/6',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '14/6',
                                                                                                                 'poller_hash': 'NDcxOTA1MDEwMzUzcG9uZ3BvbiAxNC82',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': False,
                                                                                         'id': '14/7',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'name': 'gpon '
                                                                                                 '14/7',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'NDcxOTA1MDEwMzUzZ3BvbiAxNC83',
                                                                                         'pons': [       {       'id': '14/7',
                                                                                                                 'name': 'gpon '
                                                                                                                         '14/7',
                                                                                                                 'poller_hash': 'NDcxOTA1MDEwMzUzcG9uZ3BvbiAxNC83',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '14/8',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2082',
                                                                                         'in_octets': '560116763',
                                                                                         'in_ucast_pkts': '1665017',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': 'gpon '
                                                                                                 '14/8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '460896',
                                                                                         'out_octets': '530174920',
                                                                                         'out_ucast_pkts': '4250661',
                                                                                         'poller_hash': 'NDcxOTA1MDEwMzUzZ3BvbiAxNC84',
                                                                                         'pons': [       {       'id': '14/8',
                                                                                                                 'max_distance': 20000,
                                                                                                                 'name': 'gpon '
                                                                                                                         '14/8',
                                                                                                                 'poller_hash': 'NDcxOTA1MDEwMzUzcG9uZ3BvbiAxNC84',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-03007',
                                                           'name': 'GPON-8x',
                                                           'poller_hash': 'NDcxOTA1MDEwMzUz',
                                                           'serial_number': '471905010353',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931227'},
                                                   {       'id': '15',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '15/g1',
                                                                                         'in_discards': '71',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '508295',
                                                                                         'in_octets': '1175479408596',
                                                                                         'in_ucast_pkts': '6382787507',
                                                                                         'mac_address': '00:02:5d:e0:6e:bf',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236099937',
                                                                                         'out_octets': '25133561876120',
                                                                                         'out_ucast_pkts': '18014788494',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g2',
                                                                                         'in_discards': '107',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '265708',
                                                                                         'in_octets': '469646021485',
                                                                                         'in_ucast_pkts': '2312058266',
                                                                                         'mac_address': '00:02:5d:e0:6e:c0',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236346669',
                                                                                         'out_octets': '9407716171318',
                                                                                         'out_ucast_pkts': '7004008348',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '15/g3',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:e0:6e:c1',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g3',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzM='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g4',
                                                                                         'in_discards': '1758',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '36117',
                                                                                         'in_octets': '1773736455871',
                                                                                         'in_ucast_pkts': '4455473148',
                                                                                         'mac_address': '00:02:5d:e0:6e:c2',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191095439',
                                                                                         'out_octets': '16640191229014',
                                                                                         'out_ucast_pkts': '13329343409',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzQ=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g5',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '918707',
                                                                                         'in_octets': '5455063725228',
                                                                                         'in_ucast_pkts': '11667492105',
                                                                                         'mac_address': '00:02:5d:e0:6e:c3',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235694183',
                                                                                         'out_octets': '30754166791093',
                                                                                         'out_ucast_pkts': '25316872439',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzU=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g6',
                                                                                         'in_discards': '34',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '816541',
                                                                                         'in_octets': '2663529951215',
                                                                                         'in_ucast_pkts': '6502470120',
                                                                                         'mac_address': '00:02:5d:e0:6e:c4',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235791919',
                                                                                         'out_octets': '18742192618165',
                                                                                         'out_ucast_pkts': '14303925678',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzY=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g7',
                                                                                         'in_discards': '26',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '16211043',
                                                                                         'in_octets': '35224697646',
                                                                                         'in_ucast_pkts': '140373162',
                                                                                         'mac_address': '00:02:5d:e0:6e:c5',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '17216381103',
                                                                                         'out_octets': '21310463360481',
                                                                                         'out_ucast_pkts': '397341202',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzc=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g8',
                                                                                         'in_discards': '43',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '318147',
                                                                                         'in_octets': '155009909596',
                                                                                         'in_ucast_pkts': '997501508',
                                                                                         'mac_address': '00:02:5d:e0:6e:c6',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1413498171',
                                                                                         'out_octets': '8446274181608',
                                                                                         'out_ucast_pkts': '5806044487',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzg=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g9',
                                                                                         'in_discards': '5',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '351285',
                                                                                         'in_octets': '1397084721725',
                                                                                         'in_ucast_pkts': '3393443856',
                                                                                         'mac_address': '00:02:5d:e0:6e:c7',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g9',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190816535',
                                                                                         'out_octets': '18041282209892',
                                                                                         'out_ucast_pkts': '13218693704',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzk=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g10',
                                                                                         'in_discards': '3',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '280042',
                                                                                         'in_octets': '251950715688',
                                                                                         'in_ucast_pkts': '1428667686',
                                                                                         'mac_address': '00:02:5d:e0:6e:c8',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190904910',
                                                                                         'out_octets': '10277476210801',
                                                                                         'out_ucast_pkts': '7301740486',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzEw',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g11',
                                                                                         'in_discards': '86',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18302678',
                                                                                         'in_octets': '207459359775',
                                                                                         'in_ucast_pkts': '1551106304',
                                                                                         'mac_address': '00:02:5d:e0:6e:c9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '28659590671',
                                                                                         'out_octets': '42981316906887',
                                                                                         'out_ucast_pkts': '4719914205',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzEx',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g12',
                                                                                         'in_discards': '143',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1045195',
                                                                                         'in_octets': '306627952954',
                                                                                         'in_ucast_pkts': '1067144178',
                                                                                         'mac_address': '00:02:5d:e0:6e:ca',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235520425',
                                                                                         'out_octets': '1955640479543',
                                                                                         'out_ucast_pkts': '1851720208',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzEy',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g13',
                                                                                         'in_discards': '10',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '593666',
                                                                                         'in_octets': '415941774880',
                                                                                         'in_ucast_pkts': '2939038120',
                                                                                         'mac_address': '00:02:5d:e0:6e:cb',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g13',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1476839852',
                                                                                         'out_octets': '9748694791342',
                                                                                         'out_ucast_pkts': '6751017832',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzEz',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g14',
                                                                                         'in_discards': '217',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '293001',
                                                                                         'in_octets': '332190486660',
                                                                                         'in_ucast_pkts': '2293316069',
                                                                                         'mac_address': '00:02:5d:e0:6e:cc',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g14',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1476863739',
                                                                                         'out_octets': '7588886704644',
                                                                                         'out_ucast_pkts': '5245793796',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzE0',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '15/g15',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:e0:6e:cd',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g15',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzE1'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g16',
                                                                                         'in_discards': '499',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10341975',
                                                                                         'in_octets': '84971350377',
                                                                                         'in_ucast_pkts': '504478597',
                                                                                         'mac_address': '00:02:5d:e0:6e:ce',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '14625115230',
                                                                                         'out_octets': '18771607699654',
                                                                                         'out_ucast_pkts': '1214345937',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzE2',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g17',
                                                                                         'in_discards': '123',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '761430',
                                                                                         'in_octets': '475135044530',
                                                                                         'in_ucast_pkts': '2130615670',
                                                                                         'mac_address': '00:02:5d:e0:6e:cf',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '256694974',
                                                                                         'out_octets': '8985715966383',
                                                                                         'out_ucast_pkts': '6488089844',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzE3',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g18',
                                                                                         'in_discards': '7',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '581484',
                                                                                         'in_octets': '3344353007106',
                                                                                         'in_ucast_pkts': '7417973636',
                                                                                         'mac_address': '00:02:5d:e0:6e:d0',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235975773',
                                                                                         'out_octets': '31118485683632',
                                                                                         'out_ucast_pkts': '23347778608',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzE4',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g19',
                                                                                         'in_discards': '9',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '590170',
                                                                                         'in_octets': '219219216190',
                                                                                         'in_ucast_pkts': '741852313',
                                                                                         'mac_address': '00:02:5d:e0:6e:d1',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190559530',
                                                                                         'out_octets': '4185213531488',
                                                                                         'out_ucast_pkts': '3060118582',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzE5',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g20',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '3494',
                                                                                         'in_octets': '472246081',
                                                                                         'in_ucast_pkts': '1520524',
                                                                                         'mac_address': '00:02:5d:e0:6e:d2',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g20',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '25435944',
                                                                                         'out_octets': '3244546775',
                                                                                         'out_ucast_pkts': '1923071',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzIw'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g21',
                                                                                         'in_discards': '1',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '404944',
                                                                                         'in_octets': '7477496097841',
                                                                                         'in_ucast_pkts': '8177150124',
                                                                                         'mac_address': '00:02:5d:e0:6e:d3',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236202439',
                                                                                         'out_octets': '9456073328353',
                                                                                         'out_ucast_pkts': '11698632843',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzIx',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g22',
                                                                                         'in_discards': '160',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '33883895',
                                                                                         'in_octets': '626904334462',
                                                                                         'in_ucast_pkts': '1910244321',
                                                                                         'mac_address': '00:02:5d:e0:6e:d4',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '56810240881',
                                                                                         'out_octets': '85458286312467',
                                                                                         'out_ucast_pkts': '7710743182',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzIy',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g23',
                                                                                         'in_discards': '90',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '266997',
                                                                                         'in_octets': '219374819257',
                                                                                         'in_ucast_pkts': '1304668341',
                                                                                         'mac_address': '00:02:5d:e0:6e:d5',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g23',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236344604',
                                                                                         'out_octets': '5273601150387',
                                                                                         'out_ucast_pkts': '3726852600',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzIz',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '15/g24',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '315200',
                                                                                         'in_octets': '217467173076',
                                                                                         'in_ucast_pkts': '1523723617',
                                                                                         'mac_address': '00:02:5d:e0:6e:d6',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '15/g24',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477128321',
                                                                                         'out_octets': '8790280378173',
                                                                                         'out_ucast_pkts': '5988810810',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDA5ZXRoZXJuZXQgMTUvZzI0',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'MjExNTA1NjAwMDA5',
                                                           'serial_number': '211505600009',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931348'},
                                                   {       'id': '16',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '16/g1',
                                                                                         'in_discards': '22',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '53236',
                                                                                         'in_octets': '103062633875',
                                                                                         'in_ucast_pkts': '1005260996',
                                                                                         'mac_address': '00:02:5d:e0:6e:65',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431944485',
                                                                                         'out_octets': '3651960807127',
                                                                                         'out_ucast_pkts': '2467728354',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g2',
                                                                                         'in_discards': '220',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '34946',
                                                                                         'in_octets': '1071287002232',
                                                                                         'in_ucast_pkts': '3962803401',
                                                                                         'mac_address': '00:02:5d:e0:6e:66',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191120450',
                                                                                         'out_octets': '15584089490221',
                                                                                         'out_ucast_pkts': '11872117983',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g3',
                                                                                         'in_discards': '2',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '322370',
                                                                                         'in_octets': '472170059153',
                                                                                         'in_ucast_pkts': '2150272608',
                                                                                         'mac_address': '00:02:5d:e0:6e:67',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190803218',
                                                                                         'out_octets': '10119496445854',
                                                                                         'out_ucast_pkts': '7185449797',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g4',
                                                                                         'in_discards': '81',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1501880',
                                                                                         'in_octets': '13644368719',
                                                                                         'in_ucast_pkts': '65897626',
                                                                                         'mac_address': '00:02:5d:e0:6e:68',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1925993137',
                                                                                         'out_octets': '2313230880715',
                                                                                         'out_ucast_pkts': '147059902',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzQ=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g5',
                                                                                         'in_discards': '7',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '35786552',
                                                                                         'in_octets': '1737802834353',
                                                                                         'in_ucast_pkts': '2222766054',
                                                                                         'mac_address': '00:02:5d:e0:6e:69',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '90987438425',
                                                                                         'out_octets': '122154787763977',
                                                                                         'out_ucast_pkts': '1937340568',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzU=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g6',
                                                                                         'in_discards': '18',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '45778',
                                                                                         'in_octets': '126888661774',
                                                                                         'in_ucast_pkts': '835279816',
                                                                                         'mac_address': '00:02:5d:e0:6e:6a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191130823',
                                                                                         'out_octets': '3009713069870',
                                                                                         'out_ucast_pkts': '2181771942',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzY=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g7',
                                                                                         'in_discards': '46',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '305033',
                                                                                         'in_octets': '781673624336',
                                                                                         'in_ucast_pkts': '1802357331',
                                                                                         'mac_address': '00:02:5d:e0:6e:6b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1426953560',
                                                                                         'out_octets': '5411583352818',
                                                                                         'out_ucast_pkts': '3754257294',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzc=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g8',
                                                                                         'in_discards': '47',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '45313',
                                                                                         'in_octets': '542868505661',
                                                                                         'in_ucast_pkts': '1333602192',
                                                                                         'mac_address': '00:02:5d:e0:6e:6c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236555732',
                                                                                         'out_octets': '4480243900069',
                                                                                         'out_ucast_pkts': '3724034980',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzg=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g9',
                                                                                         'in_discards': '14692',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '47412',
                                                                                         'in_octets': '145272692333',
                                                                                         'in_ucast_pkts': '949418980',
                                                                                         'mac_address': '00:02:5d:e0:6e:6d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g9',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236424119',
                                                                                         'out_octets': '5468610781011',
                                                                                         'out_ucast_pkts': '3847383508',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzk=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g10',
                                                                                         'in_discards': '1977',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '36584',
                                                                                         'in_octets': '505086539414',
                                                                                         'in_ucast_pkts': '1448908253',
                                                                                         'mac_address': '00:02:5d:e0:6e:6e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431705210',
                                                                                         'out_octets': '6426911151379',
                                                                                         'out_ucast_pkts': '4693815567',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzEw',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g11',
                                                                                         'in_discards': '82',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '159103',
                                                                                         'in_octets': '10234597416203',
                                                                                         'in_ucast_pkts': '18363497516',
                                                                                         'mac_address': '00:02:5d:e0:6e:6f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191024930',
                                                                                         'out_octets': '22315707917736',
                                                                                         'out_ucast_pkts': '24094121935',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzEx',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g12',
                                                                                         'in_discards': '1154',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '45541',
                                                                                         'in_octets': '610016176601',
                                                                                         'in_ucast_pkts': '2709457893',
                                                                                         'mac_address': '00:02:5d:e0:6e:70',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1423327501',
                                                                                         'out_octets': '9165108253053',
                                                                                         'out_ucast_pkts': '6630061070',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzEy',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g13',
                                                                                         'in_discards': '3',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '334990',
                                                                                         'in_octets': '1115902878457',
                                                                                         'in_ucast_pkts': '6571627271',
                                                                                         'mac_address': '00:02:5d:e0:6e:71',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g13',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190840860',
                                                                                         'out_octets': '25011710107769',
                                                                                         'out_ucast_pkts': '17675597469',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzEz',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g14',
                                                                                         'in_discards': '214',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '8285',
                                                                                         'in_octets': '66807554909',
                                                                                         'in_ucast_pkts': '182425223',
                                                                                         'mac_address': '00:02:5d:e0:6e:72',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g14',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '327147608',
                                                                                         'out_octets': '1331690036326',
                                                                                         'out_ucast_pkts': '975148553',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzE0',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g15',
                                                                                         'in_discards': '55',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9802355',
                                                                                         'in_octets': '186588270249',
                                                                                         'in_ucast_pkts': '1248435692',
                                                                                         'mac_address': '00:02:5d:e0:6e:73',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '35623637851',
                                                                                         'out_octets': '54987678622292',
                                                                                         'out_ucast_pkts': '6560943948',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzE1',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g16',
                                                                                         'in_discards': '102',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '20786',
                                                                                         'in_octets': '427965846693',
                                                                                         'in_ucast_pkts': '3470254220',
                                                                                         'mac_address': '00:02:5d:e0:6e:74',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191156962',
                                                                                         'out_octets': '11796571005145',
                                                                                         'out_ucast_pkts': '8119523632',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzE2',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g17',
                                                                                         'in_discards': '41027',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '342485',
                                                                                         'in_octets': '18073679876335',
                                                                                         'in_ucast_pkts': '31102840394',
                                                                                         'mac_address': '00:02:5d:e0:6e:75',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236190355',
                                                                                         'out_octets': '73195954208495',
                                                                                         'out_ucast_pkts': '58786926681',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzE3',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g18',
                                                                                         'in_discards': '34',
                                                                                         'in_errors': '3424',
                                                                                         'in_nucast_pkts': '27176458',
                                                                                         'in_octets': '316491448841',
                                                                                         'in_ucast_pkts': '509152374',
                                                                                         'mac_address': '00:02:5d:e0:6e:76',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '44123584535',
                                                                                         'out_octets': '58946978909587',
                                                                                         'out_ucast_pkts': '1166380171',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzE4',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g19',
                                                                                         'in_discards': '19694',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '5757565',
                                                                                         'in_octets': '388897525869',
                                                                                         'in_ucast_pkts': '2799081527',
                                                                                         'mac_address': '00:02:5d:e0:6e:77',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '13430649061',
                                                                                         'out_octets': '29078719827308',
                                                                                         'out_ucast_pkts': '8972268451',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzE5',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g20',
                                                                                         'in_discards': '377',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '261026',
                                                                                         'in_octets': '745307458579',
                                                                                         'in_ucast_pkts': '4503979365',
                                                                                         'mac_address': '00:02:5d:e0:6e:78',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g20',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236340792',
                                                                                         'out_octets': '13290977750959',
                                                                                         'out_ucast_pkts': '9741166188',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzIw',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g21',
                                                                                         'in_discards': '559',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '268263',
                                                                                         'in_octets': '394691046076',
                                                                                         'in_ucast_pkts': '2623328559',
                                                                                         'mac_address': '00:02:5d:e0:6e:79',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1476885987',
                                                                                         'out_octets': '15547453815336',
                                                                                         'out_ucast_pkts': '10612374207',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzIx',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g22',
                                                                                         'in_discards': '47',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18940401',
                                                                                         'in_octets': '396926002524',
                                                                                         'in_ucast_pkts': '1469632227',
                                                                                         'mac_address': '00:02:5d:e0:6e:7a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '60727812461',
                                                                                         'out_octets': '90691673077059',
                                                                                         'out_ucast_pkts': '7487633168',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzIy',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '16/g23',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:e0:6e:7b',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g23',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzIz'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '16/g24',
                                                                                         'in_discards': '546',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18866897',
                                                                                         'in_octets': '22770491566767',
                                                                                         'in_ucast_pkts': '16994585141',
                                                                                         'mac_address': '00:02:5d:e0:6e:7c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '16/g24',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '63097780672',
                                                                                         'out_octets': '89393093324005',
                                                                                         'out_ucast_pkts': '10216642994',
                                                                                         'poller_hash': 'MjExNTA1NjAwMDk1ZXRoZXJuZXQgMTYvZzI0',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'MjExNTA1NjAwMDk1',
                                                           'serial_number': '211505600095',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41930980'},
                                                   {       'id': '17',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '17/g1',
                                                                                         'in_discards': '1',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '276103',
                                                                                         'in_octets': '82525557018',
                                                                                         'in_ucast_pkts': '432951895',
                                                                                         'mac_address': '00:02:5d:ae:24:44',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236306582',
                                                                                         'out_octets': '596759985657',
                                                                                         'out_ucast_pkts': '607132894',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g2',
                                                                                         'in_discards': '11',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '22676586',
                                                                                         'in_octets': '311386591316',
                                                                                         'in_ucast_pkts': '846535880',
                                                                                         'mac_address': '00:02:5d:ae:24:45',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '100461718970',
                                                                                         'out_octets': '137339321721855',
                                                                                         'out_ucast_pkts': '2474118399',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g3',
                                                                                         'in_discards': '4',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '19574884',
                                                                                         'in_octets': '13330736759',
                                                                                         'in_ucast_pkts': '76239927',
                                                                                         'mac_address': '00:02:5d:ae:24:46',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '51146573858',
                                                                                         'out_octets': '67133514402020',
                                                                                         'out_ucast_pkts': '101389452',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g4',
                                                                                         'in_discards': '104675',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '7959880',
                                                                                         'in_octets': '340163185944',
                                                                                         'in_ucast_pkts': '2088159985',
                                                                                         'mac_address': '00:02:5d:ae:24:47',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '29229052147',
                                                                                         'out_octets': '45161300449691',
                                                                                         'out_ucast_pkts': '5745626165',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g5',
                                                                                         'in_discards': '372',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9168046',
                                                                                         'in_octets': '12544419081122',
                                                                                         'in_ucast_pkts': '15052387316',
                                                                                         'mac_address': '00:02:5d:ae:24:48',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '8276557429',
                                                                                         'out_octets': '12075416262668',
                                                                                         'out_ucast_pkts': '8657988531',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nNQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g6',
                                                                                         'in_discards': '14',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '530081',
                                                                                         'in_octets': '396561558567',
                                                                                         'in_ucast_pkts': '2367755695',
                                                                                         'mac_address': '00:02:5d:ae:24:49',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431131056',
                                                                                         'out_octets': '9543066629741',
                                                                                         'out_ucast_pkts': '6808946152',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nNg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g7',
                                                                                         'in_discards': '101',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '45338',
                                                                                         'in_octets': '573447865301',
                                                                                         'in_ucast_pkts': '3786289131',
                                                                                         'mac_address': '00:02:5d:ae:24:4a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431471761',
                                                                                         'out_octets': '18831406094940',
                                                                                         'out_ucast_pkts': '13026883317',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nNw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g8',
                                                                                         'in_discards': '119',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '29993624',
                                                                                         'in_octets': '554923395831',
                                                                                         'in_ucast_pkts': '1649518555',
                                                                                         'mac_address': '00:02:5d:ae:24:4b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '70743278255',
                                                                                         'out_octets': '100869997103259',
                                                                                         'out_ucast_pkts': '5523071078',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nOA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g9',
                                                                                         'in_discards': '8',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9991910',
                                                                                         'in_octets': '128317026361',
                                                                                         'in_ucast_pkts': '794142461',
                                                                                         'mac_address': '00:02:5d:ae:24:4c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g9',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '22198973875',
                                                                                         'out_octets': '30315804243429',
                                                                                         'out_ucast_pkts': '2110858084',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nOQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '17/g10',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ae:24:4d',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g10',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMTA='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g11',
                                                                                         'in_discards': '2',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '562455',
                                                                                         'in_octets': '344047487040',
                                                                                         'in_ucast_pkts': '946438266',
                                                                                         'mac_address': '00:02:5d:ae:24:4e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190598932',
                                                                                         'out_octets': '4663802878737',
                                                                                         'out_ucast_pkts': '3625615168',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMTE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g12',
                                                                                         'in_discards': '90',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '6215443',
                                                                                         'in_octets': '257181036574',
                                                                                         'in_ucast_pkts': '990762184',
                                                                                         'mac_address': '00:02:5d:ae:24:4f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '10205457496',
                                                                                         'out_octets': '17186633808196',
                                                                                         'out_ucast_pkts': '4095235955',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMTI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g13',
                                                                                         'in_discards': '16',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '504241',
                                                                                         'in_octets': '925727350031',
                                                                                         'in_ucast_pkts': '5172776719',
                                                                                         'mac_address': '00:02:5d:ae:24:50',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g13',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236075707',
                                                                                         'out_octets': '19693643751065',
                                                                                         'out_ucast_pkts': '13898196453',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMTM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '17/g14',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ae:24:51',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g14',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMTQ='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g15',
                                                                                         'in_discards': '17',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '11968255',
                                                                                         'in_octets': '150698235662',
                                                                                         'in_ucast_pkts': '668516648',
                                                                                         'mac_address': '00:02:5d:ae:24:52',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '23209717184',
                                                                                         'out_octets': '32273107395577',
                                                                                         'out_ucast_pkts': '2551076904',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMTU=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g16',
                                                                                         'in_discards': '7',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '8451405',
                                                                                         'in_octets': '851006317749',
                                                                                         'in_ucast_pkts': '3790929937',
                                                                                         'mac_address': '00:02:5d:ae:24:53',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '3891883458',
                                                                                         'out_octets': '14536172236963',
                                                                                         'out_ucast_pkts': '8777801048',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMTY=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g17',
                                                                                         'in_discards': '111',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '36908',
                                                                                         'in_octets': '467429137440',
                                                                                         'in_ucast_pkts': '2480051845',
                                                                                         'mac_address': '00:02:5d:ae:24:54',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191091336',
                                                                                         'out_octets': '8717831382275',
                                                                                         'out_ucast_pkts': '6766018764',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMTc=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g18',
                                                                                         'in_discards': '177',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17391512',
                                                                                         'in_octets': '292862150699',
                                                                                         'in_ucast_pkts': '1293366122',
                                                                                         'mac_address': '00:02:5d:ae:24:55',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '36546365419',
                                                                                         'out_octets': '52346864463338',
                                                                                         'out_ucast_pkts': '3881884064',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMTg=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g19',
                                                                                         'in_discards': '22614',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '337459',
                                                                                         'in_octets': '126888704485',
                                                                                         'in_ucast_pkts': '1007787113',
                                                                                         'mac_address': '00:02:5d:ae:24:56',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190815517',
                                                                                         'out_octets': '5646891903045',
                                                                                         'out_ucast_pkts': '3956251196',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMTk=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g20',
                                                                                         'in_discards': '113',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '269916',
                                                                                         'in_octets': '427434095425',
                                                                                         'in_ucast_pkts': '2580711324',
                                                                                         'mac_address': '00:02:5d:ae:24:57',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g20',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236304773',
                                                                                         'out_octets': '9396002576497',
                                                                                         'out_ucast_pkts': '6727355527',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMjA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g21',
                                                                                         'in_discards': '15',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '251347',
                                                                                         'in_octets': '133867623',
                                                                                         'in_ucast_pkts': '398620',
                                                                                         'mac_address': '00:02:5d:ae:24:58',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431654208',
                                                                                         'out_octets': '131805976211',
                                                                                         'out_ucast_pkts': '2789979',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMjE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g22',
                                                                                         'in_discards': '467',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '6259074',
                                                                                         'in_octets': '253092386776',
                                                                                         'in_ucast_pkts': '820678813',
                                                                                         'mac_address': '00:02:5d:ae:24:59',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '23213034410',
                                                                                         'out_octets': '31748976755858',
                                                                                         'out_ucast_pkts': '1658343192',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMjI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g23',
                                                                                         'in_discards': '432',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '259024',
                                                                                         'in_octets': '116713422094',
                                                                                         'in_ucast_pkts': '229722429',
                                                                                         'mac_address': '00:02:5d:ae:24:5a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g23',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '233216960',
                                                                                         'out_octets': '529810123059',
                                                                                         'out_ucast_pkts': '539496646',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMjM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '17/g24',
                                                                                         'in_discards': '353',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '43502',
                                                                                         'in_octets': '4435450922397',
                                                                                         'in_ucast_pkts': '6664400892',
                                                                                         'mac_address': '00:02:5d:ae:24:5b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '17/g24',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1472281380',
                                                                                         'out_octets': '12398453588264',
                                                                                         'out_ucast_pkts': '11060885148',
                                                                                         'poller_hash': 'ODExMTAwMDM5ODhldGhlcm5ldCAxNy9nMjQ=',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDM5ODg=',
                                                           'serial_number': '81110003988',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41928558'},
                                                   {       'id': '18',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '18/g1',
                                                                                         'in_discards': '73',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '579216',
                                                                                         'in_octets': '113166064109',
                                                                                         'in_ucast_pkts': '506967766',
                                                                                         'mac_address': '00:02:5d:ad:f7:92',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235985177',
                                                                                         'out_octets': '416394276759',
                                                                                         'out_ucast_pkts': '656202161',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g2',
                                                                                         'in_discards': '84',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '29215',
                                                                                         'in_octets': '50007204881',
                                                                                         'in_ucast_pkts': '126388118',
                                                                                         'mac_address': '00:02:5d:ad:f7:93',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236562459',
                                                                                         'out_octets': '240473868015',
                                                                                         'out_ucast_pkts': '200022618',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g3',
                                                                                         'in_discards': '13',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '363775',
                                                                                         'in_octets': '221969148424',
                                                                                         'in_ucast_pkts': '1568500956',
                                                                                         'mac_address': '00:02:5d:ad:f7:94',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1476661516',
                                                                                         'out_octets': '5304298041769',
                                                                                         'out_ucast_pkts': '3745827725',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '18/g4',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ad:f7:95',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g4',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nNA=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g5',
                                                                                         'in_discards': '9',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '354620',
                                                                                         'in_octets': '13008981030193',
                                                                                         'in_ucast_pkts': '23331359405',
                                                                                         'mac_address': '00:02:5d:ad:f7:96',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190865629',
                                                                                         'out_octets': '4917564630266',
                                                                                         'out_ucast_pkts': '12539454186',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nNQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g6',
                                                                                         'in_discards': '100',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17429957',
                                                                                         'in_octets': '279149019858',
                                                                                         'in_ucast_pkts': '827547954',
                                                                                         'mac_address': '00:02:5d:ad:f7:97',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '49940445619',
                                                                                         'out_octets': '68057385697863',
                                                                                         'out_ucast_pkts': '2279412801',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nNg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g7',
                                                                                         'in_discards': '577',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18592680',
                                                                                         'in_octets': '657706024793',
                                                                                         'in_ucast_pkts': '2253986405',
                                                                                         'mac_address': '00:02:5d:ad:f7:98',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '57537785966',
                                                                                         'out_octets': '83367777513752',
                                                                                         'out_ucast_pkts': '5726349124',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nNw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g8',
                                                                                         'in_discards': '1301614',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10217052',
                                                                                         'in_octets': '116122521940',
                                                                                         'in_ucast_pkts': '625524589',
                                                                                         'mac_address': '00:02:5d:ad:f7:99',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '25715593105',
                                                                                         'out_octets': '35335591252849',
                                                                                         'out_ucast_pkts': '2138322396',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nOA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '18/g9',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ad:f7:9a',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g9',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nOQ=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g10',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18944342',
                                                                                         'in_octets': '329047946179',
                                                                                         'in_ucast_pkts': '1002588829',
                                                                                         'mac_address': '00:02:5d:ad:f7:9b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '66490361576',
                                                                                         'out_octets': '90630784327018',
                                                                                         'out_ucast_pkts': '2263563163',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMTA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g11',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '11467092',
                                                                                         'in_octets': '41445310056',
                                                                                         'in_ucast_pkts': '217179071',
                                                                                         'mac_address': '00:02:5d:ad:f7:9c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '29618080024',
                                                                                         'out_octets': '38109329515279',
                                                                                         'out_ucast_pkts': '424990328',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMTE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g12',
                                                                                         'in_discards': '371',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '43343',
                                                                                         'in_octets': '752849912109',
                                                                                         'in_ucast_pkts': '4834262003',
                                                                                         'mac_address': '00:02:5d:ad:f7:9d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477100515',
                                                                                         'out_octets': '17264328963505',
                                                                                         'out_ucast_pkts': '12340206313',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMTI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g13',
                                                                                         'in_discards': '105',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '308752',
                                                                                         'in_octets': '251374316920',
                                                                                         'in_ucast_pkts': '1597223700',
                                                                                         'mac_address': '00:02:5d:ad:f7:9e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g13',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477127396',
                                                                                         'out_octets': '6197524740467',
                                                                                         'out_ucast_pkts': '4705697473',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMTM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g14',
                                                                                         'in_discards': '12',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '593052',
                                                                                         'in_octets': '274000385478',
                                                                                         'in_ucast_pkts': '1133576376',
                                                                                         'mac_address': '00:02:5d:ad:f7:9f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g14',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190606483',
                                                                                         'out_octets': '3940996823196',
                                                                                         'out_ucast_pkts': '2971532994',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMTQ=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g15',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '13226715',
                                                                                         'in_octets': '5386110098567',
                                                                                         'in_ucast_pkts': '8904563348',
                                                                                         'mac_address': '00:02:5d:ad:f7:a0',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '22588023303',
                                                                                         'out_octets': '47724774329253',
                                                                                         'out_ucast_pkts': '16962127863',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMTU=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g16',
                                                                                         'in_discards': '170',
                                                                                         'in_errors': '150',
                                                                                         'in_nucast_pkts': '532541',
                                                                                         'in_octets': '320814211445',
                                                                                         'in_ucast_pkts': '1965933719',
                                                                                         'mac_address': '00:02:5d:ad:f7:a1',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235499977',
                                                                                         'out_octets': '7287870504096',
                                                                                         'out_ucast_pkts': '5196506348',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMTY=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g17',
                                                                                         'in_discards': '49076',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '626845',
                                                                                         'in_octets': '1256701152883',
                                                                                         'in_ucast_pkts': '3389116405',
                                                                                         'mac_address': '00:02:5d:ad:f7:a2',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '183863963',
                                                                                         'out_octets': '13024089174641',
                                                                                         'out_ucast_pkts': '9777964608',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMTc=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g18',
                                                                                         'in_discards': '64',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10932645',
                                                                                         'in_octets': '6537100744666',
                                                                                         'in_ucast_pkts': '7713520537',
                                                                                         'mac_address': '00:02:5d:ad:f7:a3',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '33158630790',
                                                                                         'out_octets': '55441559666150',
                                                                                         'out_ucast_pkts': '10847361919',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMTg=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '18/g19',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ad:f7:a4',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g19',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMTk='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '18/g20',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ad:f7:a5',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g20',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMjA='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g21',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ad:f7:a6',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g21',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMjE='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g22',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ad:f7:a7',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g22',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMjI='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g23',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ad:f7:a8',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g23',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMjM='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '18/g24',
                                                                                         'in_discards': '26',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '178469',
                                                                                         'in_octets': '154330369',
                                                                                         'in_ucast_pkts': '546813',
                                                                                         'mac_address': '00:02:5d:ad:f7:a9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '18/g24',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '757411088',
                                                                                         'out_octets': '68372471882',
                                                                                         'out_ucast_pkts': '3280104',
                                                                                         'poller_hash': 'ODExMTAwMDM1NjRldGhlcm5ldCAxOC9nMjQ=',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDM1NjQ=',
                                                           'serial_number': '81110003564',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931162'},
                                                   {       'id': '19',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '19/g1',
                                                                                         'in_discards': '35',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '24127556',
                                                                                         'in_octets': '1343487797259',
                                                                                         'in_ucast_pkts': '6803030429',
                                                                                         'mac_address': '00:02:5d:ae:23:72',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '39500152589',
                                                                                         'out_octets': '72658864193936',
                                                                                         'out_ucast_pkts': '15990986595',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g2',
                                                                                         'in_discards': '27',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2839113',
                                                                                         'in_octets': '42887653308',
                                                                                         'in_ucast_pkts': '174806508',
                                                                                         'mac_address': '00:02:5d:ae:23:73',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '8703347126',
                                                                                         'out_octets': '10404032450250',
                                                                                         'out_ucast_pkts': '393994492',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g3',
                                                                                         'in_discards': '164',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '20474597',
                                                                                         'in_octets': '2159071601476',
                                                                                         'in_ucast_pkts': '6299027237',
                                                                                         'mac_address': '00:02:5d:ae:23:74',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '29078550331',
                                                                                         'out_octets': '55988587648957',
                                                                                         'out_ucast_pkts': '14598797432',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g4',
                                                                                         'in_discards': '116',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '289995',
                                                                                         'in_octets': '70350802757',
                                                                                         'in_ucast_pkts': '248335768',
                                                                                         'mac_address': '00:02:5d:ae:23:75',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236302906',
                                                                                         'out_octets': '1384468870493',
                                                                                         'out_ucast_pkts': '1118505743',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g5',
                                                                                         'in_discards': '2',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '49495',
                                                                                         'in_octets': '238826709956',
                                                                                         'in_ucast_pkts': '1176364935',
                                                                                         'mac_address': '00:02:5d:ae:23:76',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431945189',
                                                                                         'out_octets': '3568279947595',
                                                                                         'out_ucast_pkts': '2656227195',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nNQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g6',
                                                                                         'in_discards': '15',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '816925',
                                                                                         'in_octets': '1085451652015',
                                                                                         'in_ucast_pkts': '2471316029',
                                                                                         'mac_address': '00:02:5d:ae:23:77',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190359150',
                                                                                         'out_octets': '9933702083965',
                                                                                         'out_ucast_pkts': '8054155398',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nNg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g7',
                                                                                         'in_discards': '4',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18795996',
                                                                                         'in_octets': '70507928686',
                                                                                         'in_ucast_pkts': '256107419',
                                                                                         'mac_address': '00:02:5d:ae:23:78',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g7',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '53487868565',
                                                                                         'out_octets': '71366676772005',
                                                                                         'out_ucast_pkts': '864812738',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nNw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g8',
                                                                                         'in_discards': '93',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '35176',
                                                                                         'in_octets': '212417333914',
                                                                                         'in_ucast_pkts': '1467627123',
                                                                                         'mac_address': '00:02:5d:ae:23:79',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431659713',
                                                                                         'out_octets': '6179348051523',
                                                                                         'out_ucast_pkts': '4373815334',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nOA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g9',
                                                                                         'in_discards': '1330',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '29729',
                                                                                         'in_octets': '2044033929549',
                                                                                         'in_ucast_pkts': '4828935478',
                                                                                         'mac_address': '00:02:5d:ae:23:7a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g9',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191144222',
                                                                                         'out_octets': '17101714407295',
                                                                                         'out_ucast_pkts': '12659938748',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nOQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g10',
                                                                                         'in_discards': '7',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17654827',
                                                                                         'in_octets': '497081711719',
                                                                                         'in_ucast_pkts': '1461796684',
                                                                                         'mac_address': '00:02:5d:ae:23:7b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '47911186747',
                                                                                         'out_octets': '66977252816849',
                                                                                         'out_ucast_pkts': '3384001426',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMTA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g11',
                                                                                         'in_discards': '27',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '37354398',
                                                                                         'in_octets': '672851248213',
                                                                                         'in_ucast_pkts': '5024104398',
                                                                                         'mac_address': '00:02:5d:ae:23:7c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '87311919853',
                                                                                         'out_octets': '135218700746403',
                                                                                         'out_ucast_pkts': '13367910085',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMTE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g12',
                                                                                         'in_discards': '182',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '263684',
                                                                                         'in_octets': '404632296781',
                                                                                         'in_ucast_pkts': '1405214287',
                                                                                         'mac_address': '00:02:5d:ae:23:7d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236274726',
                                                                                         'out_octets': '4537756863329',
                                                                                         'out_ucast_pkts': '3274278129',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMTI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g13',
                                                                                         'in_discards': '97',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '33536',
                                                                                         'in_octets': '733873866370',
                                                                                         'in_ucast_pkts': '2271489379',
                                                                                         'mac_address': '00:02:5d:ae:23:7e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g13',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191117003',
                                                                                         'out_octets': '7991737632386',
                                                                                         'out_ucast_pkts': '5921162733',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMTM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '19/g14',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ae:23:7f',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g14',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMTQ='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g15',
                                                                                         'in_discards': '579',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '279834',
                                                                                         'in_octets': '224019616969',
                                                                                         'in_ucast_pkts': '1364176599',
                                                                                         'mac_address': '00:02:5d:ae:23:80',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235161491',
                                                                                         'out_octets': '4311897205775',
                                                                                         'out_ucast_pkts': '3106212437',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMTU=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g16',
                                                                                         'in_discards': '58',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17764635',
                                                                                         'in_octets': '112966582040',
                                                                                         'in_ucast_pkts': '868041338',
                                                                                         'mac_address': '00:02:5d:ae:23:81',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '19111215034',
                                                                                         'out_octets': '27954930569354',
                                                                                         'out_ucast_pkts': '3369228518',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMTY=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g17',
                                                                                         'in_discards': '401',
                                                                                         'in_errors': '8',
                                                                                         'in_nucast_pkts': '11840950',
                                                                                         'in_octets': '238966658432',
                                                                                         'in_ucast_pkts': '1824674218',
                                                                                         'mac_address': '00:02:5d:ae:23:82',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '30963718654',
                                                                                         'out_octets': '46758046220041',
                                                                                         'out_ucast_pkts': '5090277059',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMTc=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g18',
                                                                                         'in_discards': '5',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '306849',
                                                                                         'in_octets': '622092793443',
                                                                                         'in_ucast_pkts': '4147883994',
                                                                                         'mac_address': '00:02:5d:ae:23:83',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190831960',
                                                                                         'out_octets': '12184532978086',
                                                                                         'out_ucast_pkts': '8857724160',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMTg=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g19',
                                                                                         'in_discards': '13',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '565395',
                                                                                         'in_octets': '248477575048',
                                                                                         'in_ucast_pkts': '1688696527',
                                                                                         'mac_address': '00:02:5d:ae:23:84',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236030769',
                                                                                         'out_octets': '10085341164985',
                                                                                         'out_ucast_pkts': '7071409752',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMTk=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g20',
                                                                                         'in_discards': '2',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10030906',
                                                                                         'in_octets': '22303837336',
                                                                                         'in_ucast_pkts': '145797396',
                                                                                         'mac_address': '00:02:5d:ae:23:85',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g20',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '7497305044',
                                                                                         'out_octets': '7631848398854',
                                                                                         'out_ucast_pkts': '141821065',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMjA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g21',
                                                                                         'in_discards': '122',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '297374',
                                                                                         'in_octets': '427643717478',
                                                                                         'in_ucast_pkts': '1795057122',
                                                                                         'mac_address': '00:02:5d:ae:23:86',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236252366',
                                                                                         'out_octets': '8356636473626',
                                                                                         'out_ucast_pkts': '6370315167',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMjE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g22',
                                                                                         'in_discards': '5',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '17012539',
                                                                                         'in_octets': '5984629904734',
                                                                                         'in_ucast_pkts': '10247458145',
                                                                                         'mac_address': '00:02:5d:ae:23:87',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '50689938252',
                                                                                         'out_octets': '97290347162316',
                                                                                         'out_ucast_pkts': '24966829875',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMjI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g23',
                                                                                         'in_discards': '190',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '329349',
                                                                                         'in_octets': '210703801464',
                                                                                         'in_ucast_pkts': '881402245',
                                                                                         'mac_address': '00:02:5d:ae:23:88',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g23',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1476979482',
                                                                                         'out_octets': '3079312125439',
                                                                                         'out_ucast_pkts': '2351613061',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMjM=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '19/g24',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '353853',
                                                                                         'in_octets': '819153113476',
                                                                                         'in_ucast_pkts': '7003874100',
                                                                                         'mac_address': '00:02:5d:ae:23:89',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '19/g24',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477074977',
                                                                                         'out_octets': '23682101654217',
                                                                                         'out_ucast_pkts': '16389696713',
                                                                                         'poller_hash': 'ODExMTAwMDQwNTFldGhlcm5ldCAxOS9nMjQ=',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDQwNTE=',
                                                           'serial_number': '81110004051',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931321'},
                                                   {       'id': '20',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': '20/g1',
                                                                                         'in_discards': '363',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '829565',
                                                                                         'in_octets': '1466492682428',
                                                                                         'in_ucast_pkts': '7426329945',
                                                                                         'mac_address': '00:02:5d:ae:1f:3a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235484355',
                                                                                         'out_octets': '20937988610118',
                                                                                         'out_ucast_pkts': '15840868143',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g2',
                                                                                         'in_discards': '18',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '39320',
                                                                                         'in_octets': '148845469191',
                                                                                         'in_ucast_pkts': '434819447',
                                                                                         'mac_address': '00:02:5d:ae:1f:3b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191138272',
                                                                                         'out_octets': '1711158325981',
                                                                                         'out_ucast_pkts': '1381702665',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g3',
                                                                                         'in_discards': '7',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '45506',
                                                                                         'in_octets': '2241330183',
                                                                                         'in_ucast_pkts': '20246211',
                                                                                         'mac_address': '00:02:5d:ae:1f:3c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g3',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191100585',
                                                                                         'out_octets': '69339031993',
                                                                                         'out_ucast_pkts': '42996723',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMw==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g4',
                                                                                         'in_discards': '210',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '40267',
                                                                                         'in_octets': '1056604539922',
                                                                                         'in_ucast_pkts': '3515830656',
                                                                                         'mac_address': '00:02:5d:ae:1f:3d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '191151141',
                                                                                         'out_octets': '9231503450461',
                                                                                         'out_ucast_pkts': '6952426257',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nNA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g5',
                                                                                         'in_discards': '119',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9348911',
                                                                                         'in_octets': '386790125973',
                                                                                         'in_ucast_pkts': '2653371618',
                                                                                         'mac_address': '00:02:5d:ae:1f:3e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g5',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '24800624437',
                                                                                         'out_octets': '39698132138686',
                                                                                         'out_ucast_pkts': '6345945105',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nNQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g6',
                                                                                         'in_discards': '9',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '43175',
                                                                                         'in_octets': '395390551948',
                                                                                         'in_ucast_pkts': '1952654895',
                                                                                         'mac_address': '00:02:5d:ae:1f:3f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g6',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1477165872',
                                                                                         'out_octets': '6999131852059',
                                                                                         'out_ucast_pkts': '4968000130',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nNg==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g7',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ae:1f:40',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g7',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nNw=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g8',
                                                                                         'in_discards': '13',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9332150',
                                                                                         'in_octets': '65649938163',
                                                                                         'in_ucast_pkts': '214389142',
                                                                                         'mac_address': '00:02:5d:ae:1f:41',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g8',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '32963181939',
                                                                                         'out_octets': '42771666175122',
                                                                                         'out_ucast_pkts': '440188697',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nOA==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g9',
                                                                                         'in_discards': '6',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '24356',
                                                                                         'in_octets': '5457531427168',
                                                                                         'in_ucast_pkts': '10647152313',
                                                                                         'mac_address': '00:02:5d:ae:1f:42',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g9',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190264613',
                                                                                         'out_octets': '21896436152775',
                                                                                         'out_ucast_pkts': '18005673819',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nOQ==',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g10',
                                                                                         'in_discards': '15',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18586309',
                                                                                         'in_octets': '4455852525760',
                                                                                         'in_ucast_pkts': '6048914702',
                                                                                         'mac_address': '00:02:5d:ae:1f:43',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g10',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '54362608610',
                                                                                         'out_octets': '84020107147681',
                                                                                         'out_ucast_pkts': '10663918521',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMTA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g11',
                                                                                         'in_discards': '165',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '7636443',
                                                                                         'in_octets': '222405312100',
                                                                                         'in_ucast_pkts': '1189566399',
                                                                                         'mac_address': '00:02:5d:ae:1f:44',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g11',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '5821861695',
                                                                                         'out_octets': '11810813854021',
                                                                                         'out_ucast_pkts': '4588746420',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMTE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g12',
                                                                                         'in_discards': '100',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '18157214',
                                                                                         'in_octets': '180085223090',
                                                                                         'in_ucast_pkts': '1637767550',
                                                                                         'mac_address': '00:02:5d:ae:1f:45',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g12',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '48289999288',
                                                                                         'out_octets': '70498620935760',
                                                                                         'out_ucast_pkts': '5007252037',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMTI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '20/g13',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ae:1f:46',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g13',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMTM='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g14',
                                                                                         'in_discards': '61',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '395105',
                                                                                         'in_octets': '1163434640313',
                                                                                         'in_ucast_pkts': '10354358744',
                                                                                         'mac_address': '00:02:5d:ae:1f:47',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g14',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '236123591',
                                                                                         'out_octets': '37671592873019',
                                                                                         'out_ucast_pkts': '25825980749',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMTQ=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g15',
                                                                                         'in_discards': '1',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '356356',
                                                                                         'in_octets': '216782665635',
                                                                                         'in_ucast_pkts': '523985757',
                                                                                         'mac_address': '00:02:5d:ae:1f:48',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g15',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '190830338',
                                                                                         'out_octets': '1940947719999',
                                                                                         'out_ucast_pkts': '1496414254',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMTU=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g16',
                                                                                         'in_discards': '2',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '6411887',
                                                                                         'in_octets': '377067379072',
                                                                                         'in_ucast_pkts': '2777697288',
                                                                                         'mac_address': '00:02:5d:ae:1f:49',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g16',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '17795871797',
                                                                                         'out_octets': '33210764330382',
                                                                                         'out_ucast_pkts': '8080460972',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMTY=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g17',
                                                                                         'in_discards': '16',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '740066',
                                                                                         'in_octets': '912384209494',
                                                                                         'in_ucast_pkts': '2826328245',
                                                                                         'mac_address': '00:02:5d:ae:1f:4a',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g17',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '235840639',
                                                                                         'out_octets': '6793535110128',
                                                                                         'out_ucast_pkts': '5754766505',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMTc=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g18',
                                                                                         'in_discards': '336',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '6033693',
                                                                                         'in_octets': '285789445737',
                                                                                         'in_ucast_pkts': '1016671462',
                                                                                         'mac_address': '00:02:5d:ae:1f:4b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g18',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '7027125099',
                                                                                         'out_octets': '10356230711180',
                                                                                         'out_ucast_pkts': '2589020079',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMTg=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g19',
                                                                                         'in_discards': '71',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '13774413',
                                                                                         'in_octets': '283273788932',
                                                                                         'in_ucast_pkts': '872180125',
                                                                                         'mac_address': '00:02:5d:ae:1f:4c',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g19',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '46800328321',
                                                                                         'out_octets': '63479752209293',
                                                                                         'out_ucast_pkts': '1802101979',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMTk=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g20',
                                                                                         'in_discards': '19',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '4565653',
                                                                                         'in_octets': '1123835055226',
                                                                                         'in_ucast_pkts': '9412638570',
                                                                                         'mac_address': '00:02:5d:ae:1f:4d',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g20',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '10998145156',
                                                                                         'out_octets': '29563491205729',
                                                                                         'out_ucast_pkts': '15203022606',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMjA=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g21',
                                                                                         'in_discards': '202206',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '871109',
                                                                                         'in_octets': '150191729610',
                                                                                         'in_ucast_pkts': '634271000',
                                                                                         'mac_address': '00:02:5d:ae:1f:4e',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g21',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1585335221',
                                                                                         'out_octets': '2926772282725',
                                                                                         'out_ucast_pkts': '1820499713',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMjE=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g22',
                                                                                         'in_discards': '293',
                                                                                         'in_errors': '59638',
                                                                                         'in_nucast_pkts': '140852',
                                                                                         'in_octets': '151518486',
                                                                                         'in_ucast_pkts': '649540',
                                                                                         'mac_address': '00:02:5d:ae:1f:4f',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g22',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '233498240',
                                                                                         'out_octets': '21361476443',
                                                                                         'out_ucast_pkts': '1590124',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMjI=',
                                                                                         'speed': '1000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g23',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:ae:1f:50',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g23',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMjM='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '20/g24',
                                                                                         'in_discards': '8',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '574234',
                                                                                         'in_octets': '508468992416',
                                                                                         'in_ucast_pkts': '2293887289',
                                                                                         'mac_address': '00:02:5d:ae:1f:51',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01792',
                                                                                         'name': 'ethernet '
                                                                                                 '20/g24',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '1431216637',
                                                                                         'out_octets': '7983561185843',
                                                                                         'out_ucast_pkts': '5794453476',
                                                                                         'poller_hash': 'ODExMTAwMDM5MzNldGhlcm5ldCAyMC9nMjQ=',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02093',
                                                           'name': 'GE-24x',
                                                           'poller_hash': 'ODExMTAwMDM5MzM=',
                                                           'serial_number': '81110003933',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41930995'},
                                                   {       'id': 'A',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': 'A/x1',
                                                                                         'in_discards': '18901',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '22786274',
                                                                                         'in_octets': '2938827886305559',
                                                                                         'in_ucast_pkts': '2255055481360',
                                                                                         'mac_address': '00:02:5d:bf:6c:4a',
                                                                                         'manufacturer': 'FS',
                                                                                         'model': 'SFPP-PC01',
                                                                                         'name': 'MCCL-SUBS '
                                                                                                 'A/x1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '86374507',
                                                                                         'out_octets': '344500553033094',
                                                                                         'out_ucast_pkts': '924572124322',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTEyTUNDTC1TVUJTIEEveDE=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': 'A/x2',
                                                                                         'in_discards': '140816165',
                                                                                         'in_errors': '1537',
                                                                                         'in_nucast_pkts': '5520163100621',
                                                                                         'in_octets': '17961910806202174',
                                                                                         'in_ucast_pkts': '8189193078853',
                                                                                         'mac_address': '00:02:5d:bf:6c:4b',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01507',
                                                                                         'name': 'ethernet '
                                                                                                 'A/x2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '947176133',
                                                                                         'out_octets': '1494240490119517',
                                                                                         'out_ucast_pkts': '3573328667847',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTEyZXRoZXJuZXQgQS94Mg==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': 'A/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1760',
                                                                                         'in_octets': '103291359',
                                                                                         'in_ucast_pkts': '380567',
                                                                                         'mac_address': '00:02:5d:bf:6c:4e',
                                                                                         'name': 'ethernet '
                                                                                                 'A/g1',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '126156',
                                                                                         'out_octets': '2626160753',
                                                                                         'out_ucast_pkts': '1912035',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTEyZXRoZXJuZXQgQS9nMQ=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': 'A/g2',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '403941',
                                                                                         'in_octets': '852290786',
                                                                                         'in_ucast_pkts': '12123292',
                                                                                         'mac_address': '00:02:5d:bf:6c:4f',
                                                                                         'manufacturer': 'BROCADE',
                                                                                         'model': '57-1000042-01',
                                                                                         'name': 'ethernet '
                                                                                                 'A/g2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '655155449',
                                                                                         'out_octets': '89650933175',
                                                                                         'out_ucast_pkts': '11702311',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTEyZXRoZXJuZXQgQS9nMg==',
                                                                                         'speed': '100000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': 'A/g3',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:bf:6c:50',
                                                                                         'name': 'ethernet '
                                                                                                 'A/g3',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTEyZXRoZXJuZXQgQS9nMw=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': 'A/g4',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:bf:6c:51',
                                                                                         'name': 'ethernet '
                                                                                                 'A/g4',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTEyZXRoZXJuZXQgQS9nNA=='}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02092',
                                                           'name': 'SCP-10GE',
                                                           'poller_hash': 'MjExMzAyNjAxOTEy',
                                                           'serial_number': '211302601912',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931214'},
                                                   {       'id': 'B',
                                                           'interfaces': [       {       'admin_up': True,
                                                                                         'id': 'B/x1',
                                                                                         'in_discards': '13570524',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2771945906',
                                                                                         'in_octets': '674219462793804',
                                                                                         'in_ucast_pkts': '1183340767098',
                                                                                         'mac_address': '00:02:5d:bf:6d:aa',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01423',
                                                                                         'name': 'ethernet '
                                                                                                 'B/x1',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '5520592513760',
                                                                                         'out_octets': '10466683932199251',
                                                                                         'out_ucast_pkts': '2389685867509',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTU4ZXRoZXJuZXQgQi94MQ==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': True,
                                                                                         'id': 'B/x2',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '80',
                                                                                         'in_nucast_pkts': '6463',
                                                                                         'in_octets': '350230929852074',
                                                                                         'in_ucast_pkts': '1316659861521',
                                                                                         'mac_address': '00:02:5d:bf:6d:ab',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01509',
                                                                                         'name': 'ethernet '
                                                                                                 'B/x2',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '4606133',
                                                                                         'out_octets': '4460482027396103',
                                                                                         'out_ucast_pkts': '3418370583018',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTU4ZXRoZXJuZXQgQi94Mg==',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': 'B/g1',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:bf:6d:ae',
                                                                                         'name': 'ethernet '
                                                                                                 'B/g1',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTU4ZXRoZXJuZXQgQi9nMQ=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': 'B/g2',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:bf:6d:af',
                                                                                         'name': 'ethernet '
                                                                                                 'B/g2',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTU4ZXRoZXJuZXQgQi9nMg=='},
                                                                                 {       'admin_up': False,
                                                                                         'id': 'B/g3',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'mac_address': '00:02:5d:bf:6d:b0',
                                                                                         'name': 'ethernet '
                                                                                                 'B/g3',
                                                                                         'oper_up': False,
                                                                                         'out_nucast_pkts': '0',
                                                                                         'out_octets': '0',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTU4ZXRoZXJuZXQgQi9nMw=='},
                                                                                 {       'admin_up': True,
                                                                                         'id': 'B/g4',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '75017',
                                                                                         'in_octets': '5884578664',
                                                                                         'in_ucast_pkts': '31699021',
                                                                                         'mac_address': '00:02:5d:bf:6d:b1',
                                                                                         'manufacturer': 'FiberStore',
                                                                                         'model': 'SFP-GB-GE-T',
                                                                                         'name': 'ethernet '
                                                                                                 'B/g4',
                                                                                         'oper_up': True,
                                                                                         'out_nucast_pkts': '66044824',
                                                                                         'out_octets': '20785958328',
                                                                                         'out_ucast_pkts': '70005946',
                                                                                         'poller_hash': 'MjExMzAyNjAxOTU4ZXRoZXJuZXQgQi9nNA==',
                                                                                         'speed': '1000000000'}],
                                                           'manufacturer': 'Calix',
                                                           'model': '100-02092',
                                                           'name': 'SCP-10GE',
                                                           'poller_hash': 'MjExMzAyNjAxOTU4',
                                                           'serial_number': '211302601958',
                                                           'sw_version': '3.4.30.40',
                                                           'uptime': '41931759'}],
                                'system_mac_address': '00:02:5d:f4:8c:07'}
        }
        id_field = 'mac_address' if not obj.stations else ('mac_address' if hasattr(obj.stations[0], 'mac_address') and getattr(obj.stations[0], 'mac_address') else ('imsi' if hasattr(obj.stations[0], 'imsi') else 'serial'))
        cur_info = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('info', 'ap', obj.model) + [('vendor', 'str'), ('model', 'str'), ('sw_version', 'str')]}
        if 'rf_freq' in cur_info and cur_info.get('rf_freq') and (cur_info['rf_freq'] <= 0 or int.bit_length(cur_info['rf_freq']) >= 32):
            cur_info.pop('rf_freq')
        cur_stats = {x: getattr(obj, x, None) for (x, data_type) in self.apdd.get_metric_fields('stats', 'ap', obj.model)}
        cur_sta_stats = {getattr(sta, id_field): {x: getattr(sta, x, None) for (x, data_type) in sorted(self.apdd.get_metric_fields('stats', 'cpe', obj.model)) + [(id_field, 'str'), ('ip_address', 'str'), ('name', 'str'), ('dev_macs', 'str')]} for sta in sorted(obj.stations)}
        cur_ne_msg = getattr(obj, 'network_element_update_msg', None)
        cur_ne_msg = cur_ne_msg.pb if cur_ne_msg else None
        self.assertEqual(cur_info, exp_info)
        self.assertEqual(cur_stats, exp_stats)
        self.assertEqual(cur_sta_stats, exp_sta_stats)
        self.assertTrue(self.compare_pb_dict(cur_ne_msg, exp_ne_msg))
