import os.path
import sys

sys.path.append(os.path.dirname(__file__))  # let code under test load stubs
from device_test import DeviceTestCase

class TestCalixModels(DeviceTestCase):

    def test_calix_axos_E7_2_23_2_0_01(self):
        obj = self.run_data("calix.axos.E7-2.23.2.0.01")
        exp_info = {
         'model': 'E7-2', 'sw_version': '23.2.0', 'vendor': 'Calix'
        }
        exp_stats = {
         'serial_number': '071904929255', 'system_mac_address': '00:02:5d:fe:73:6a'
        }
        exp_sta_stats = {
                None: {       'dev_macs': None,
                              'ip_address': None,
                              'mac_address': None,
                              'name': '85/g1',
                              'serial_number': '87BA22',
                              'system_mac_address': None},
                '48:77:46:d2:3f:0d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': '48:77:46:d2:3f:0d',
                                             'name': '189/g1',
                                             'serial_number': '7D9F2C',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d6:1a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d6:1a',
                                             'name': '15/g1',
                                             'serial_number': '87B15E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d6:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d6:f8',
                                             'name': '236/g1',
                                             'serial_number': '87B1A8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d7:2e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d7:2e',
                                             'name': '19/g1',
                                             'serial_number': '87B1BA',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d7:34': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d7:34',
                                             'name': '176/g1',
                                             'serial_number': '87B1BC',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d7:d6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d7:d6',
                                             'name': '209/g1',
                                             'serial_number': '87B1F2',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:33': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:33',
                                             'name': '169/g1',
                                             'serial_number': '87B211',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:57': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:57',
                                             'name': '28/g1',
                                             'serial_number': '87B21D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:c3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:c3',
                                             'name': '22/g1',
                                             'serial_number': '87B241',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:c9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:c9',
                                             'name': '278/g1',
                                             'serial_number': '87B243',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:e1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:e1',
                                             'name': '24/g1',
                                             'serial_number': '87B24B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:ea': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:ea',
                                             'name': '27/g1',
                                             'serial_number': '87B24E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d8:ff': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d8:ff',
                                             'name': '26/g1',
                                             'serial_number': '87B255',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d9:2c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d9:2c',
                                             'name': '158/g1',
                                             'serial_number': '87B264',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d9:59': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d9:59',
                                             'name': '23/g1',
                                             'serial_number': '87B273',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d9:7a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d9:7a',
                                             'name': '31/g1',
                                             'serial_number': '87B27E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d9:ad': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d9:ad',
                                             'name': '14/g1',
                                             'serial_number': '87B28F',
                                             'system_mac_address': None},
                'd0:76:8f:1f:d9:e9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:d9:e9',
                                             'name': '20/g1',
                                             'serial_number': '87B2A3',
                                             'system_mac_address': None},
                'd0:76:8f:1f:db:84': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:db:84',
                                             'name': '258/g1',
                                             'serial_number': '87B32C',
                                             'system_mac_address': None},
                'd0:76:8f:1f:db:9f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:db:9f',
                                             'name': '179/g1',
                                             'serial_number': '87B335',
                                             'system_mac_address': None},
                'd0:76:8f:1f:db:db': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:db:db',
                                             'name': '228/g1',
                                             'serial_number': '87B349',
                                             'system_mac_address': None},
                'd0:76:8f:1f:db:e7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:db:e7',
                                             'name': '233/g1',
                                             'serial_number': '87B34D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e0:28': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e0:28',
                                             'name': '65/g1',
                                             'serial_number': '87B4B8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e8:50': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e8:50',
                                             'name': '177/g1',
                                             'serial_number': '87B770',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e8:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e8:f8',
                                             'name': '159/g1',
                                             'serial_number': '87B7A8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e9:af': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e9:af',
                                             'name': '120/g1',
                                             'serial_number': '87B7E5',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e9:dc': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e9:dc',
                                             'name': '263/g1',
                                             'serial_number': '87B7F4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e9:df': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e9:df',
                                             'name': '150/g1',
                                             'serial_number': '87B7F5',
                                             'system_mac_address': None},
                'd0:76:8f:1f:e9:fd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:e9:fd',
                                             'name': '94/g1',
                                             'serial_number': '87B7FF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ea:2a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ea:2a',
                                             'name': '99/g1',
                                             'serial_number': '87B80E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ea:93': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ea:93',
                                             'name': '110/g1',
                                             'serial_number': '87B831',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ea:db': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ea:db',
                                             'name': '98/g1',
                                             'serial_number': '87B849',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ea:f9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ea:f9',
                                             'name': '118/g1',
                                             'serial_number': '87B853',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:1a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:1a',
                                             'name': '103/g1',
                                             'serial_number': '87B85E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:5c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:5c',
                                             'name': '108/g1',
                                             'serial_number': '87B874',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:5f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:5f',
                                             'name': '122/g1',
                                             'serial_number': '87B875',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:71': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:71',
                                             'name': '202/g1',
                                             'serial_number': '87B87B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:7d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:7d',
                                             'name': '275/g1',
                                             'serial_number': '87B87F',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:cb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:cb',
                                             'name': '149/g1',
                                             'serial_number': '87B899',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:d1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:d1',
                                             'name': '102/g1',
                                             'serial_number': '87B89B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:eb:e6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:eb:e6',
                                             'name': '100/g1',
                                             'serial_number': '87B8A2',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:25': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:25',
                                             'name': '116/g1',
                                             'serial_number': '87B8B7',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:3d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:3d',
                                             'name': '111/g1',
                                             'serial_number': '87B8BF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:7c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:7c',
                                             'name': '109/g1',
                                             'serial_number': '87B8D4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:85': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:85',
                                             'name': '181/g1',
                                             'serial_number': '87B8D7',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:d0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:d0',
                                             'name': '64/g1',
                                             'serial_number': '87B8F0',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ec:f1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ec:f1',
                                             'name': '250/g1',
                                             'serial_number': '87B8FB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ed:03': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ed:03',
                                             'name': '162/g1',
                                             'serial_number': '87B901',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ed:06': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ed:06',
                                             'name': '160/g1',
                                             'serial_number': '87B902',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ed:09': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ed:09',
                                             'name': '66/g1',
                                             'serial_number': '87B903',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ed:21': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ed:21',
                                             'name': '89/g1',
                                             'serial_number': '87B90B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ed:b7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ed:b7',
                                             'name': '123/g1',
                                             'serial_number': '87B93D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:4a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:4a',
                                             'name': '135/g1',
                                             'serial_number': '87B96E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:b9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:b9',
                                             'name': '264/g1',
                                             'serial_number': '87B993',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:bf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:bf',
                                             'name': '171/g1',
                                             'serial_number': '87B995',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:cb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:cb',
                                             'name': '252/g1',
                                             'serial_number': '87B999',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:da': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:da',
                                             'name': '255/g1',
                                             'serial_number': '87B99E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ee:e0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ee:e0',
                                             'name': '274/g1',
                                             'serial_number': '87B9A0',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:07': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:07',
                                             'name': '265/g1',
                                             'serial_number': '87B9AD',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:10',
                                             'name': '240/g1',
                                             'serial_number': '87B9B0',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:19': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:19',
                                             'name': '92/g1',
                                             'serial_number': '87B9B3',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:1f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:1f',
                                             'name': '261/g1',
                                             'serial_number': '87B9B5',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:4c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:4c',
                                             'name': '46/g1',
                                             'serial_number': '87B9C4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:61': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:61',
                                             'name': '58/g1',
                                             'serial_number': '87B9CB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:64': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:64',
                                             'name': '166/g1',
                                             'serial_number': '87B9CC',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:67': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:67',
                                             'name': '267/g1',
                                             'serial_number': '87B9CD',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:6a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:6a',
                                             'name': '246/g1',
                                             'serial_number': '87B9CE',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:6d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:6d',
                                             'name': '191/g1',
                                             'serial_number': '87B9CF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:76': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:76',
                                             'name': '238/g1',
                                             'serial_number': '87B9D2',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:79': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:79',
                                             'name': '200/g1',
                                             'serial_number': '87B9D3',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:7c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:7c',
                                             'name': '251/g1',
                                             'serial_number': '87B9D4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:7f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:7f',
                                             'name': '165/g1',
                                             'serial_number': '87B9D5',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:82': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:82',
                                             'name': '272/g1',
                                             'serial_number': '87B9D6',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:91': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:91',
                                             'name': '182/g1',
                                             'serial_number': '87B9DB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:9a': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:9a',
                                             'name': '170/g1',
                                             'serial_number': '87B9DE',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:9d',
                                             'name': '132/g1',
                                             'serial_number': '87B9DF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:a0': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:a0',
                                             'name': '164/g1',
                                             'serial_number': '87B9E0',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:a3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:a3',
                                             'name': '196/g1',
                                             'serial_number': '87B9E1',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:a6': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:a6',
                                             'name': '174/g1',
                                             'serial_number': '87B9E2',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:ac': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:ac',
                                             'name': '172/g1',
                                             'serial_number': '87B9E4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:b5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:b5',
                                             'name': '273/g1',
                                             'serial_number': '87B9E7',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:b8',
                                             'name': '51/g1',
                                             'serial_number': '87B9E8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:c7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:c7',
                                             'name': '49/g1',
                                             'serial_number': '87B9ED',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:ca': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:ca',
                                             'name': '47/g1',
                                             'serial_number': '87B9EE',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:d3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:d3',
                                             'name': '48/g1',
                                             'serial_number': '87B9F1',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:e2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:e2',
                                             'name': '55/g1',
                                             'serial_number': '87B9F6',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:ee': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:ee',
                                             'name': '62/g1',
                                             'serial_number': '87B9FA',
                                             'system_mac_address': None},
                'd0:76:8f:1f:ef:fd': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:ef:fd',
                                             'name': '91/g1',
                                             'serial_number': '87B9FF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:06': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:06',
                                             'name': '63/g1',
                                             'serial_number': '87BA02',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:09': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:09',
                                             'name': '54/g1',
                                             'serial_number': '87BA03',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:0f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:0f',
                                             'name': '61/g1',
                                             'serial_number': '87BA05',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:12': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:12',
                                             'name': '57/g1',
                                             'serial_number': '87BA06',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:48': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:48',
                                             'name': '35/g1',
                                             'serial_number': '87BA18',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:4e': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:4e',
                                             'name': '115/g1',
                                             'serial_number': '87BA1A',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:51': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:51',
                                             'name': '84/g1',
                                             'serial_number': '87BA1B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:54': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:54',
                                             'name': '130/g1',
                                             'serial_number': '87BA1C',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:5d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:5d',
                                             'name': '87/g1',
                                             'serial_number': '87BA1F',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:69': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:69',
                                             'name': '86/g1',
                                             'serial_number': '87BA23',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:6c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:6c',
                                             'name': '80/g1',
                                             'serial_number': '87BA24',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:6f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:6f',
                                             'name': '30/g1',
                                             'serial_number': '87BA25',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:72': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:72',
                                             'name': '119/g1',
                                             'serial_number': '87BA26',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:75': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:75',
                                             'name': '96/g1',
                                             'serial_number': '87BA27',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:81': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:81',
                                             'name': '199/g1',
                                             'serial_number': '87BA2B',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:87': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:87',
                                             'name': '262/g1',
                                             'serial_number': '87BA2D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:90': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:90',
                                             'name': '146/g1',
                                             'serial_number': '87BA30',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:99': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:99',
                                             'name': '157/g1',
                                             'serial_number': '87BA33',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:9c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:9c',
                                             'name': '153/g1',
                                             'serial_number': '87BA34',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:9f': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:9f',
                                             'name': '187/g1',
                                             'serial_number': '87BA35',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:a8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:a8',
                                             'name': '256/g1',
                                             'serial_number': '87BA38',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ab': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ab',
                                             'name': '145/g1',
                                             'serial_number': '87BA39',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ae': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ae',
                                             'name': '134/g1',
                                             'serial_number': '87BA3A',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ba': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ba',
                                             'name': '151/g1',
                                             'serial_number': '87BA3E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:c3': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:c3',
                                             'name': '136/g1',
                                             'serial_number': '87BA41',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:c9': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:c9',
                                             'name': '201/g1',
                                             'serial_number': '87BA43',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:cf': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:cf',
                                             'name': '198/g1',
                                             'serial_number': '87BA45',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:d5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:d5',
                                             'name': '152/g1',
                                             'serial_number': '87BA47',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ea': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ea',
                                             'name': '235/g1',
                                             'serial_number': '87BA4E',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ed': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ed',
                                             'name': '147/g1',
                                             'serial_number': '87BA4F',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f0:ff': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f0:ff',
                                             'name': '253/g1',
                                             'serial_number': '87BA55',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:05': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:05',
                                             'name': '148/g1',
                                             'serial_number': '87BA57',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:08': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:08',
                                             'name': '232/g1',
                                             'serial_number': '87BA58',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:4d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:4d',
                                             'name': '83/g1',
                                             'serial_number': '87BA6F',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:9b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:9b',
                                             'name': '78/g1',
                                             'serial_number': '87BA89',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:a7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:a7',
                                             'name': '41/g1',
                                             'serial_number': '87BA8D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:d7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:d7',
                                             'name': '33/g1',
                                             'serial_number': '87BA9D',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:f8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:f8',
                                             'name': '36/g1',
                                             'serial_number': '87BAA8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f1:fb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f1:fb',
                                             'name': '42/g1',
                                             'serial_number': '87BAA9',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:01': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:01',
                                             'name': '37/g1',
                                             'serial_number': '87BAAB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:10': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:10',
                                             'name': '38/g1',
                                             'serial_number': '87BAB0',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:13': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:13',
                                             'name': '82/g1',
                                             'serial_number': '87BAB1',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:31': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:31',
                                             'name': '34/g1',
                                             'serial_number': '87BABB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:7c': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:7c',
                                             'name': '257/g1',
                                             'serial_number': '87BAD4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:ac': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:ac',
                                             'name': 'sonar_item_2594/g1',
                                             'serial_number': '87BAE4',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:b2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:b2',
                                             'name': '214/g1',
                                             'serial_number': '87BAE6',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:b5': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:b5',
                                             'name': '259/g1',
                                             'serial_number': '87BAE7',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:be': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:be',
                                             'name': '239/g1',
                                             'serial_number': '87BAEA',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:c1': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:c1',
                                             'name': '124/g1',
                                             'serial_number': '87BAEB',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:c4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:c4',
                                             'name': '237/g1',
                                             'serial_number': '87BAEC',
                                             'system_mac_address': None},
                'd0:76:8f:1f:f2:c7': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:f2:c7',
                                             'name': '197/g1',
                                             'serial_number': '87BAED',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:8b': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:8b',
                                             'name': '213/g1',
                                             'serial_number': '87BED9',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:9d': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:9d',
                                             'name': '105/g1',
                                             'serial_number': '87BEDF',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:b2': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:b2',
                                             'name': '74/g1',
                                             'serial_number': '87BEE6',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:b8': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:b8',
                                             'name': '271/g1',
                                             'serial_number': '87BEE8',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:bb': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:bb',
                                             'name': '75/g1',
                                             'serial_number': '87BEE9',
                                             'system_mac_address': None},
                'd0:76:8f:1f:fe:c4': {       'dev_macs': None,
                                             'ip_address': None,
                                             'mac_address': 'd0:76:8f:1f:fe:c4',
                                             'name': '71/g1',
                                             'serial_number': '87BEEC',
                                             'system_mac_address': None}
        }
        exp_ne_msg = {
                'data': {       'interfaces': [       {       'admin_up': True,
                                                              'id': '26',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '5756004530',
                                                              'in_ucast_pkts': '29483434',
                                                              'mac_address': '48:77:46:53:bd:c0',
                                                              'mtu': 1500,
                                                              'name': 'craft 1',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '9414380843',
                                                              'out_ucast_pkts': '28994158',
                                                              'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzBjcmFmdCAx'},
                                                      {       'admin_up': True,
                                                              'id': '28',
                                                              'in_discards': '0',
                                                              'in_errors': '0',
                                                              'in_octets': '0',
                                                              'in_ucast_pkts': '0',
                                                              'mtu': 1500,
                                                              'name': 'craft 2',
                                                              'oper_up': True,
                                                              'out_discards': '0',
                                                              'out_errors': '0',
                                                              'out_octets': '5428',
                                                              'out_ucast_pkts': '121',
                                                              'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzBjcmFmdCAy'}],
                                'manufacturer': 'Calix',
                                'model': 'E7-2',
                                'modules': [       {       'cpu': 23.0,
                                                           'id': '1/1',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '110000101',
                                                                                         'mac_address': '48:77:46:53:bd:d5',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDUxLzEvZzE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000102',
                                                                                         'mac_address': '48:77:46:53:bd:d6',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDYxLzEvZzI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000103',
                                                                                         'mac_address': '48:77:46:53:bd:d7',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDcxLzEvZzM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000104',
                                                                                         'mac_address': '48:77:46:53:bd:d8',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDgxLzEvZzQ='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000105',
                                                                                         'mac_address': '48:77:46:53:bd:d9',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDkxLzEvZzU='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000106',
                                                                                         'mac_address': '48:77:46:53:bd:da',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZGExLzEvZzY='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000107',
                                                                                         'mac_address': '48:77:46:53:bd:db',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZGIxLzEvZzc='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110000108',
                                                                                         'mac_address': '48:77:46:53:bd:dc',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/g8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZGMxLzEvZzg='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010101',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '962863061',
                                                                                         'in_octets': '254359410463064',
                                                                                         'in_ucast_pkts': '185047379909',
                                                                                         'in_unknown_protos': '0',
                                                                                         'mac_address': '48:77:46:53:bd:c5',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-01629',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '57135431',
                                                                                         'out_octets': '19690248931996',
                                                                                         'out_ucast_pkts': '71040510386',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzUxLzEveDE=',
                                                                                         'speed': '10000000000'},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010102',
                                                                                         'mac_address': '48:77:46:53:bd:c6',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzYxLzEveDI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010103',
                                                                                         'mac_address': '48:77:46:53:bd:c7',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzcxLzEveDM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '110010104',
                                                                                         'mac_address': '48:77:46:53:bd:c8',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/1/x4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzgxLzEveDQ='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010105',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '9222660',
                                                                                         'in_octets': '1280766338221',
                                                                                         'in_ucast_pkts': '5708563550',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCMTk2cGVlcmludGYyOS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10813577359',
                                                                                                                  'in_octets': '10895224847',
                                                                                                                  'in_ucast_pkts': '81647488',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '376106960416',
                                                                                                                  'out_octets': '376369747568',
                                                                                                                  'out_ucast_pkts': '262787152',
                                                                                                                  'poller_hash': 'ODdCQTI1cGVlcmludGYzMC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '33745979636',
                                                                                                                  'in_octets': '33812753197',
                                                                                                                  'in_ucast_pkts': '66773561',
                                                                                                                  'oper_up': False,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '180686420600',
                                                                                                                  'out_octets': '180841283715',
                                                                                                                  'out_ucast_pkts': '154863115',
                                                                                                                  'poller_hash': 'ODdCQTlEcGVlcmludGYzMy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '8795012504',
                                                                                                                  'in_octets': '8832899382',
                                                                                                                  'in_ucast_pkts': '37886878',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '167180060889',
                                                                                                                  'out_octets': '167300049316',
                                                                                                                  'out_ucast_pkts': '119988427',
                                                                                                                  'poller_hash': 'ODdCQUJCcGVlcmludGYzNC9ncDE='},
                                                                                                          {       'in_errors': '1',
                                                                                                                  'in_nucast_pkts': '44520811161',
                                                                                                                  'in_octets': '44683078820',
                                                                                                                  'in_ucast_pkts': '162267659',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '812002721064',
                                                                                                                  'out_octets': '812561541758',
                                                                                                                  'out_ucast_pkts': '558820694',
                                                                                                                  'poller_hash': 'ODdCQTE4cGVlcmludGYzNS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '27325840296',
                                                                                                                  'in_octets': '27404722645',
                                                                                                                  'in_ucast_pkts': '78882349',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '214891773406',
                                                                                                                  'out_octets': '215063823291',
                                                                                                                  'out_ucast_pkts': '172049885',
                                                                                                                  'poller_hash': 'ODdCQUE4cGVlcmludGYzNi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7299285953',
                                                                                                                  'in_octets': '7350657434',
                                                                                                                  'in_ucast_pkts': '51371481',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '283580611761',
                                                                                                                  'out_octets': '283776069286',
                                                                                                                  'out_ucast_pkts': '195457525',
                                                                                                                  'poller_hash': 'ODdCQUIwcGVlcmludGYzOC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '21255200458',
                                                                                                                  'in_octets': '21292914037',
                                                                                                                  'in_ucast_pkts': '37713579',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '139249043723',
                                                                                                                  'out_octets': '139366242684',
                                                                                                                  'out_ucast_pkts': '117198961',
                                                                                                                  'poller_hash': 'ODdCQThEcGVlcmludGY0MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '14298568438',
                                                                                                                  'in_octets': '14363264045',
                                                                                                                  'in_ucast_pkts': '64695607',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '307873430243',
                                                                                                                  'out_octets': '308114506593',
                                                                                                                  'out_ucast_pkts': '241076350',
                                                                                                                  'poller_hash': 'ODdCQUE5cGVlcmludGY0Mi9ncDE='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOTQwcGVlcmludGY0NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '2520208678',
                                                                                                                  'in_octets': '2539747960',
                                                                                                                  'in_ucast_pkts': '19539282',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '72767788369',
                                                                                                                  'out_octets': '72819700223',
                                                                                                                  'out_ucast_pkts': '51911854',
                                                                                                                  'poller_hash': 'ODdCOUZBcGVlcmludGY2Mi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4897139069',
                                                                                                                  'in_octets': '4913133751',
                                                                                                                  'in_ucast_pkts': '15994682',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '38282946840',
                                                                                                                  'out_octets': '38313918583',
                                                                                                                  'out_ucast_pkts': '30971743',
                                                                                                                  'poller_hash': 'ODdCQTNFcGVlcmludGYxNTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '55225661957',
                                                                                                                  'in_octets': '55288717597',
                                                                                                                  'in_ucast_pkts': '63055640',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '145568931585',
                                                                                                                  'out_octets': '145706928566',
                                                                                                                  'out_ucast_pkts': '137996981',
                                                                                                                  'poller_hash': 'ODdCQTM1cGVlcmludGYxODcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9103411601',
                                                                                                                  'in_octets': '9130231319',
                                                                                                                  'in_ucast_pkts': '26819718',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '38711581482',
                                                                                                                  'out_octets': '38747524110',
                                                                                                                  'out_ucast_pkts': '35942628',
                                                                                                                  'poller_hash': 'ODdCOUUxcGVlcmludGYxOTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '15268109981',
                                                                                                                  'in_octets': '15440439822',
                                                                                                                  'in_ucast_pkts': '172329841',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '602374637836',
                                                                                                                  'out_octets': '602778707761',
                                                                                                                  'out_ucast_pkts': '404069925',
                                                                                                                  'poller_hash': 'ODdCMzREcGVlcmludGYyMzMvZ3Ax'},
                                                                                                          {       'in_errors': '42',
                                                                                                                  'in_nucast_pkts': '71381321110',
                                                                                                                  'in_octets': '71607370270',
                                                                                                                  'in_ucast_pkts': '226049160',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1154465381321',
                                                                                                                  'out_octets': '1155338515529',
                                                                                                                  'out_ucast_pkts': '873134208',
                                                                                                                  'poller_hash': 'ODdCQTRFcGVlcmludGYyMzUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13225514729',
                                                                                                                  'in_octets': '13252425855',
                                                                                                                  'in_ucast_pkts': '26911126',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '105781133166',
                                                                                                                  'out_octets': '105863676786',
                                                                                                                  'out_ucast_pkts': '82543620',
                                                                                                                  'poller_hash': 'ODdCQTU1cGVlcmludGYyNTMvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:c9',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05121',
                                                                                         'name': '1/1/gp1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '17',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '2522',
                                                                                         'out_octets': '24059514224221',
                                                                                         'out_ucast_pkts': '17395936231',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax',
                                                                                         'pons': [       {       'id': '110010105',
                                                                                                                 'links': [       {       'poller_hash': 'ODdCMTk2cGVlcnBvbjI5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '1552468',
                                                                                                                                          'fiber_length': 540,
                                                                                                                                          'poller_hash': 'ODdCQTI1cGVlcnBvbjMwL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2602723',
                                                                                                                                          'fiber_length': 611,
                                                                                                                                          'poller_hash': 'ODdCQTlEcGVlcnBvbjMzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2602725',
                                                                                                                                          'fiber_length': 965,
                                                                                                                                          'poller_hash': 'ODdCQUJCcGVlcnBvbjM0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2602718',
                                                                                                                                          'fiber_length': 914,
                                                                                                                                          'poller_hash': 'ODdCQTE4cGVlcnBvbjM1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2602718',
                                                                                                                                          'fiber_length': 815,
                                                                                                                                          'poller_hash': 'ODdCQUE4cGVlcnBvbjM2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '1913554',
                                                                                                                                          'fiber_length': 844,
                                                                                                                                          'poller_hash': 'ODdCQUIwcGVlcnBvbjM4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2602732',
                                                                                                                                          'fiber_length': 842,
                                                                                                                                          'poller_hash': 'ODdCQThEcGVlcnBvbjQxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2602727',
                                                                                                                                          'fiber_length': 582,
                                                                                                                                          'poller_hash': 'ODdCQUE5cGVlcnBvbjQyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'poller_hash': 'ODdCOTQwcGVlcnBvbjQ0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '790548',
                                                                                                                                          'fiber_length': 916,
                                                                                                                                          'poller_hash': 'ODdCOUZBcGVlcnBvbjYyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2258638',
                                                                                                                                          'fiber_length': 1040,
                                                                                                                                          'poller_hash': 'ODdCQTNFcGVlcnBvbjE1MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2602728',
                                                                                                                                          'fiber_length': 712,
                                                                                                                                          'poller_hash': 'ODdCQTM1cGVlcnBvbjE4Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2180234',
                                                                                                                                          'fiber_length': 1009,
                                                                                                                                          'poller_hash': 'ODdCOUUxcGVlcnBvbjE5Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '1634830',
                                                                                                                                          'fiber_length': 551,
                                                                                                                                          'poller_hash': 'ODdCMzREcGVlcnBvbjIzMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2602756',
                                                                                                                                          'fiber_length': 516,
                                                                                                                                          'poller_hash': 'ODdCQTRFcGVlcnBvbjIzNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203},
                                                                                                                                  {       'connected_time': '2258634',
                                                                                                                                          'fiber_length': 999,
                                                                                                                                          'poller_hash': 'ODdCQTU1cGVlcnBvbjI1My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.670203}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010106',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '0',
                                                                                         'in_octets': '0',
                                                                                         'in_ucast_pkts': '0',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': False,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODdCMzQ5cGVlcmludGYyMjgvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:ca',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp2',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '40',
                                                                                         'out_octets': '3920',
                                                                                         'out_ucast_pkts': '0',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2ExLzEvZ3Ay',
                                                                                         'pons': [       {       'id': '110010106',
                                                                                                                 'links': [       {       'connected_time': '9981966',
                                                                                                                                          'fiber_length': 223,
                                                                                                                                          'poller_hash': 'ODdCMzQ5cGVlcnBvbjIyOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.668897}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNhMTEwMDEwMTA2',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010107',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1833030',
                                                                                         'in_octets': '800119521015',
                                                                                         'in_ucast_pkts': '3228617043',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '40708693106',
                                                                                                                  'in_octets': '40957415956',
                                                                                                                  'in_ucast_pkts': '248722850',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1124474365699',
                                                                                                                  'out_octets': '1125259512848',
                                                                                                                  'out_ucast_pkts': '785147149',
                                                                                                                  'poller_hash': 'ODdCQTAycGVlcmludGY2My9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4411023638',
                                                                                                                  'in_octets': '4440527251',
                                                                                                                  'in_ucast_pkts': '29503613',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '93582010984',
                                                                                                                  'out_octets': '93659265335',
                                                                                                                  'out_ucast_pkts': '77254351',
                                                                                                                  'poller_hash': 'ODdCRUU2cGVlcmludGY3NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '18580002972',
                                                                                                                  'in_octets': '18665697110',
                                                                                                                  'in_ucast_pkts': '85694138',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '433774107885',
                                                                                                                  'out_octets': '434079542957',
                                                                                                                  'out_ucast_pkts': '305435072',
                                                                                                                  'poller_hash': 'ODdCQTg5cGVlcmludGY3OC9ncDE='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCQTlCcGVlcmludGY3OS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '14620078978',
                                                                                                                  'in_octets': '14682167130',
                                                                                                                  'in_ucast_pkts': '62088152',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '149919017546',
                                                                                                                  'out_octets': '150031333931',
                                                                                                                  'out_ucast_pkts': '112316385',
                                                                                                                  'poller_hash': 'ODdCQTMwcGVlcmludGYxNDYvZ3Ax'},
                                                                                                          {       'in_errors': '6',
                                                                                                                  'in_nucast_pkts': '11094350207',
                                                                                                                  'in_octets': '11132142287',
                                                                                                                  'in_ucast_pkts': '37792080',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '80317282186',
                                                                                                                  'out_octets': '80394469860',
                                                                                                                  'out_ucast_pkts': '77187674',
                                                                                                                  'poller_hash': 'ODdCOUUycGVlcmludGYxNzQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '25562318119',
                                                                                                                  'in_octets': '25636354985',
                                                                                                                  'in_ucast_pkts': '74036866',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '273571791912',
                                                                                                                  'out_octets': '273816435357',
                                                                                                                  'out_ucast_pkts': '244643445',
                                                                                                                  'poller_hash': 'ODdCQTJCcGVlcmludGYxOTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '298539426',
                                                                                                                  'in_octets': '299655070',
                                                                                                                  'in_ucast_pkts': '1115644',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4140879327',
                                                                                                                  'out_octets': '4144197897',
                                                                                                                  'out_ucast_pkts': '3318570',
                                                                                                                  'poller_hash': 'ODdCQUU2cGVlcmludGYyMTQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '30648892202',
                                                                                                                  'in_octets': '30791696660',
                                                                                                                  'in_ucast_pkts': '142804458',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '535299421169',
                                                                                                                  'out_octets': '535686272776',
                                                                                                                  'out_ucast_pkts': '386851607',
                                                                                                                  'poller_hash': 'ODdCQUVDcGVlcmludGYyMzcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1780607649',
                                                                                                                  'in_octets': '1791900757',
                                                                                                                  'in_ucast_pkts': '11293108',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '36814923613',
                                                                                                                  'out_octets': '36841090372',
                                                                                                                  'out_ucast_pkts': '26166759',
                                                                                                                  'poller_hash': 'ODdCOUIwcGVlcmludGYyNDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9263940070',
                                                                                                                  'in_octets': '9291118259',
                                                                                                                  'in_ucast_pkts': '27178189',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '101912475337',
                                                                                                                  'out_octets': '101985565379',
                                                                                                                  'out_ucast_pkts': '73090042',
                                                                                                                  'poller_hash': 'ODdCOUNFcGVlcmludGYyNDYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6871518972',
                                                                                                                  'in_octets': '6903874723',
                                                                                                                  'in_ucast_pkts': '32355751',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '194134892944',
                                                                                                                  'out_octets': '194277694648',
                                                                                                                  'out_ucast_pkts': '142801704',
                                                                                                                  'poller_hash': 'ODdCOUEwcGVlcmludGYyNzQvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:cb',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp3',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '10',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '932',
                                                                                         'out_octets': '11559893867507',
                                                                                         'out_ucast_pkts': '8599073082',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2IxLzEvZ3Az',
                                                                                         'pons': [       {       'id': '110010107',
                                                                                                                 'links': [       {       'connected_time': '2602719',
                                                                                                                                          'fiber_length': 1065,
                                                                                                                                          'poller_hash': 'ODdCQTAycGVlcnBvbjYzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -7.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '1902642',
                                                                                                                                          'fiber_length': 1242,
                                                                                                                                          'poller_hash': 'ODdCRUU2cGVlcnBvbjc0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '2258622',
                                                                                                                                          'fiber_length': 1175,
                                                                                                                                          'poller_hash': 'ODdCQTg5cGVlcnBvbjc4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'poller_hash': 'ODdCQTlCcGVlcnBvbjc5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '2258628',
                                                                                                                                          'fiber_length': 1116,
                                                                                                                                          'poller_hash': 'ODdCQTMwcGVlcnBvbjE0Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '2258635',
                                                                                                                                          'fiber_length': 1234,
                                                                                                                                          'poller_hash': 'ODdCOUUycGVlcnBvbjE3NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '2258656',
                                                                                                                                          'fiber_length': 1290,
                                                                                                                                          'poller_hash': 'ODdCQTJCcGVlcnBvbjE5OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '23558',
                                                                                                                                          'fiber_length': 1222,
                                                                                                                                          'poller_hash': 'ODdCQUU2cGVlcnBvbjIxNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '2258635',
                                                                                                                                          'fiber_length': 1111,
                                                                                                                                          'poller_hash': 'ODdCQUVDcGVlcnBvbjIzNy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '165228',
                                                                                                                                          'fiber_length': 1256,
                                                                                                                                          'poller_hash': 'ODdCOUIwcGVlcnBvbjI0MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '2258640',
                                                                                                                                          'fiber_length': 1327,
                                                                                                                                          'poller_hash': 'ODdCOUNFcGVlcnBvbjI0Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612},
                                                                                                                                  {       'connected_time': '2258643',
                                                                                                                                          'fiber_length': 1292,
                                                                                                                                          'poller_hash': 'ODdCOUEwcGVlcnBvbjI3NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.63612}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNiMTEwMDEwMTA3',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010108',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '54629585',
                                                                                         'in_octets': '2851543058596',
                                                                                         'in_ucast_pkts': '8686749362',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '91534448530',
                                                                                                                  'in_octets': '91752405575',
                                                                                                                  'in_ucast_pkts': '217957045',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '886503968222',
                                                                                                                  'out_octets': '887197640514',
                                                                                                                  'out_ucast_pkts': '693672292',
                                                                                                                  'poller_hash': 'ODdCOUVFcGVlcmludGY0Ny9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '46575945345',
                                                                                                                  'in_octets': '46690824695',
                                                                                                                  'in_ucast_pkts': '114879350',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '590863639413',
                                                                                                                  'out_octets': '591289590737',
                                                                                                                  'out_ucast_pkts': '425951324',
                                                                                                                  'poller_hash': 'ODdCOUVEcGVlcmludGY0OS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '18358074126',
                                                                                                                  'in_octets': '18440662987',
                                                                                                                  'in_ucast_pkts': '82588861',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '360786433875',
                                                                                                                  'out_octets': '361050326269',
                                                                                                                  'out_ucast_pkts': '263892394',
                                                                                                                  'poller_hash': 'ODdCOUU4cGVlcmludGY1MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '47133020808',
                                                                                                                  'in_octets': '47360399629',
                                                                                                                  'in_ucast_pkts': '227378821',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1233341622741',
                                                                                                                  'out_octets': '1234192684395',
                                                                                                                  'out_ucast_pkts': '851061654',
                                                                                                                  'poller_hash': 'ODdCQTAzcGVlcmludGY1NC9ncDE='},
                                                                                                          {       'in_errors': '4',
                                                                                                                  'in_nucast_pkts': '57195020186',
                                                                                                                  'in_octets': '57610054798',
                                                                                                                  'in_ucast_pkts': '415034612',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1481265763461',
                                                                                                                  'out_octets': '1482264780757',
                                                                                                                  'out_ucast_pkts': '999017296',
                                                                                                                  'poller_hash': 'ODdCOUY2cGVlcmludGY1NS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '20156419018',
                                                                                                                  'in_octets': '20365855253',
                                                                                                                  'in_ucast_pkts': '209436235',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1587439981848',
                                                                                                                  'out_octets': '1588533886120',
                                                                                                                  'out_ucast_pkts': '1093904272',
                                                                                                                  'poller_hash': 'ODdCOEYwcGVlcmludGY2NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9546122994',
                                                                                                                  'in_octets': '9635305244',
                                                                                                                  'in_ucast_pkts': '89182250',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '253173947438',
                                                                                                                  'out_octets': '253359279622',
                                                                                                                  'out_ucast_pkts': '185332184',
                                                                                                                  'poller_hash': 'ODdCRUVDcGVlcmludGY3MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '17707379496',
                                                                                                                  'in_octets': '17871609366',
                                                                                                                  'in_ucast_pkts': '164229870',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '605908493878',
                                                                                                                  'out_octets': '606336886362',
                                                                                                                  'out_ucast_pkts': '428392484',
                                                                                                                  'poller_hash': 'ODdCRUU5cGVlcmludGY3NS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '33287906442',
                                                                                                                  'in_octets': '33395034622',
                                                                                                                  'in_ucast_pkts': '107128180',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '207769980823',
                                                                                                                  'out_octets': '207975347794',
                                                                                                                  'out_ucast_pkts': '205366971',
                                                                                                                  'poller_hash': 'ODdCQTFGcGVlcmludGY4Ny9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '16880711351',
                                                                                                                  'in_octets': '17066788005',
                                                                                                                  'in_ucast_pkts': '186076654',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '621784717118',
                                                                                                                  'out_octets': '622215112777',
                                                                                                                  'out_ucast_pkts': '430395659',
                                                                                                                  'poller_hash': 'ODdCOEQ0cGVlcmludGYxMDkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7205440549',
                                                                                                                  'in_octets': '7264761669',
                                                                                                                  'in_ucast_pkts': '59321120',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '151048294351',
                                                                                                                  'out_octets': '151154248094',
                                                                                                                  'out_ucast_pkts': '105953743',
                                                                                                                  'poller_hash': 'ODdCQTM0cGVlcmludGYxNTMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '368151429176',
                                                                                                                  'in_octets': '368652173318',
                                                                                                                  'in_ucast_pkts': '500744142',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '687071406238',
                                                                                                                  'out_octets': '687742349368',
                                                                                                                  'out_ucast_pkts': '670943130',
                                                                                                                  'poller_hash': 'ODdCOURFcGVlcmludGYxNzAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '18192199880',
                                                                                                                  'in_octets': '18303578198',
                                                                                                                  'in_ucast_pkts': '111378318',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '549591359305',
                                                                                                                  'out_octets': '549990811687',
                                                                                                                  'out_ucast_pkts': '399452382',
                                                                                                                  'poller_hash': 'ODdCOUI1cGVlcmludGYyNjEvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:cc',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp4',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '13',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '2833',
                                                                                         'out_octets': '33660961829513',
                                                                                         'out_ucast_pkts': '24599887222',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0',
                                                                                         'pons': [       {       'id': '110010108',
                                                                                                                 'links': [       {       'connected_time': '2602731',
                                                                                                                                          'fiber_length': 1357,
                                                                                                                                          'poller_hash': 'ODdCOUVFcGVlcnBvbjQ3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602738',
                                                                                                                                          'fiber_length': 1230,
                                                                                                                                          'poller_hash': 'ODdCOUVEcGVlcnBvbjQ5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602730',
                                                                                                                                          'fiber_length': 1274,
                                                                                                                                          'poller_hash': 'ODdCOUU4cGVlcnBvbjUxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602738',
                                                                                                                                          'fiber_length': 1377,
                                                                                                                                          'poller_hash': 'ODdCQTAzcGVlcnBvbjU0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602713',
                                                                                                                                          'fiber_length': 1242,
                                                                                                                                          'poller_hash': 'ODdCOUY2cGVlcnBvbjU1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -8.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602721',
                                                                                                                                          'fiber_length': 1176,
                                                                                                                                          'poller_hash': 'ODdCOEYwcGVlcnBvbjY0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602706',
                                                                                                                                          'fiber_length': 1331,
                                                                                                                                          'poller_hash': 'ODdCRUVDcGVlcnBvbjcxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602744',
                                                                                                                                          'fiber_length': 1370,
                                                                                                                                          'poller_hash': 'ODdCRUU5cGVlcnBvbjc1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602740',
                                                                                                                                          'fiber_length': 1357,
                                                                                                                                          'poller_hash': 'ODdCQTFGcGVlcnBvbjg3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602727',
                                                                                                                                          'fiber_length': 1265,
                                                                                                                                          'poller_hash': 'ODdCOEQ0cGVlcnBvbjEwOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602741',
                                                                                                                                          'fiber_length': 1344,
                                                                                                                                          'poller_hash': 'ODdCQTM0cGVlcnBvbjE1My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '2602744',
                                                                                                                                          'fiber_length': 1365,
                                                                                                                                          'poller_hash': 'ODdCOURFcGVlcnBvbjE3MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576},
                                                                                                                                  {       'connected_time': '1405088',
                                                                                                                                          'fiber_length': 1196,
                                                                                                                                          'poller_hash': 'ODdCOUI1cGVlcnBvbjI2MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699576}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010109',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '350824',
                                                                                         'in_octets': '657085949785',
                                                                                         'in_ucast_pkts': '3370124498',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9157551497',
                                                                                                                  'in_octets': '9198996542',
                                                                                                                  'in_ucast_pkts': '41445045',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '161522803201',
                                                                                                                  'out_octets': '161650587587',
                                                                                                                  'out_ucast_pkts': '127784386',
                                                                                                                  'poller_hash': 'ODdCOUNCcGVlcmludGY1OC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '26164608591',
                                                                                                                  'in_octets': '26324351391',
                                                                                                                  'in_ucast_pkts': '159742800',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '445720607179',
                                                                                                                  'out_octets': '446069031922',
                                                                                                                  'out_ucast_pkts': '348424743',
                                                                                                                  'poller_hash': 'ODdCQTZGcGVlcmludGY4My9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10559896019',
                                                                                                                  'in_octets': '10596668713',
                                                                                                                  'in_ucast_pkts': '36772694',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '116277250063',
                                                                                                                  'out_octets': '116363121589',
                                                                                                                  'out_ucast_pkts': '85871526',
                                                                                                                  'poller_hash': 'ODdCOEEycGVlcmludGYxMDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11837080952',
                                                                                                                  'in_octets': '11890811910',
                                                                                                                  'in_ucast_pkts': '53730958',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '336766453821',
                                                                                                                  'out_octets': '337011620863',
                                                                                                                  'out_ucast_pkts': '245167042',
                                                                                                                  'poller_hash': 'ODdCQTM5cGVlcmludGYxNDUvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOTNGcGVlcmludGYyNDgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '18298543550',
                                                                                                                  'in_octets': '18377393350',
                                                                                                                  'in_ucast_pkts': '78849800',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '270536188534',
                                                                                                                  'out_octets': '270748260304',
                                                                                                                  'out_ucast_pkts': '212071770',
                                                                                                                  'poller_hash': 'ODdCQUU3cGVlcmludGYyNTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '60706832267',
                                                                                                                  'in_octets': '61190951834',
                                                                                                                  'in_ucast_pkts': '484119567',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1942269850225',
                                                                                                                  'out_octets': '1943629209883',
                                                                                                                  'out_ucast_pkts': '1359359658',
                                                                                                                  'poller_hash': 'ODdCN0Y0cGVlcmludGYyNjMvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:cd',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp5',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '6',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '532',
                                                                                         'out_octets': '12773751520309',
                                                                                         'out_ucast_pkts': '9214808362',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2QxLzEvZ3A1',
                                                                                         'pons': [       {       'id': '110010109',
                                                                                                                 'links': [       {       'connected_time': '2602675',
                                                                                                                                          'fiber_length': 1520,
                                                                                                                                          'poller_hash': 'ODdCOUNCcGVlcnBvbjU4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.66871},
                                                                                                                                  {       'connected_time': '2602673',
                                                                                                                                          'fiber_length': 1450,
                                                                                                                                          'poller_hash': 'ODdCQTZGcGVlcnBvbjgzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.66871},
                                                                                                                                  {       'connected_time': '1240987',
                                                                                                                                          'fiber_length': 1403,
                                                                                                                                          'poller_hash': 'ODdCOEEycGVlcnBvbjEwMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.66871},
                                                                                                                                  {       'connected_time': '2602689',
                                                                                                                                          'fiber_length': 1516,
                                                                                                                                          'poller_hash': 'ODdCQTM5cGVlcnBvbjE0NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.66871},
                                                                                                                                  {       'poller_hash': 'ODdCOTNGcGVlcnBvbjI0OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.66871},
                                                                                                                                  {       'connected_time': '2496935',
                                                                                                                                          'fiber_length': 1451,
                                                                                                                                          'poller_hash': 'ODdCQUU3cGVlcnBvbjI1OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.66871},
                                                                                                                                  {       'connected_time': '2602723',
                                                                                                                                          'fiber_length': 1488,
                                                                                                                                          'poller_hash': 'ODdCN0Y0cGVlcnBvbjI2My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -28.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.66871}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNkMTEwMDEwMTA5',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010110',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '101714',
                                                                                         'in_octets': '341023893556',
                                                                                         'in_ucast_pkts': '1906344032',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '24780720661',
                                                                                                                  'in_octets': '24974132071',
                                                                                                                  'in_ucast_pkts': '193411410',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1143527239378',
                                                                                                                  'out_octets': '1144313862501',
                                                                                                                  'out_ucast_pkts': '786623123',
                                                                                                                  'poller_hash': 'ODdCOUM0cGVlcmludGY0Ni9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '18229786712',
                                                                                                                  'in_octets': '18337421755',
                                                                                                                  'in_ucast_pkts': '107635043',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '334389752607',
                                                                                                                  'out_octets': '334654494617',
                                                                                                                  'out_ucast_pkts': '264742010',
                                                                                                                  'poller_hash': 'ODdCQTQ3cGVlcmludGYxNTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '43439050977',
                                                                                                                  'in_octets': '43654921854',
                                                                                                                  'in_ucast_pkts': '215870877',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '433953975185',
                                                                                                                  'out_octets': '434270922758',
                                                                                                                  'out_ucast_pkts': '316947573',
                                                                                                                  'poller_hash': 'ODdCMzM1cGVlcmludGYxNzkvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:ce',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp6',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '3',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '361',
                                                                                         'out_octets': '7014839658755',
                                                                                         'out_ucast_pkts': '5044604178',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2UxLzEvZ3A2',
                                                                                         'pons': [       {       'id': '110010110',
                                                                                                                 'links': [       {       'connected_time': '2602713',
                                                                                                                                          'fiber_length': 1458,
                                                                                                                                          'poller_hash': 'ODdCOUM0cGVlcnBvbjQ2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737393},
                                                                                                                                  {       'connected_time': '2602752',
                                                                                                                                          'fiber_length': 1324,
                                                                                                                                          'poller_hash': 'ODdCQTQ3cGVlcnBvbjE1Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -10.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737393},
                                                                                                                                  {       'connected_time': '2602739',
                                                                                                                                          'fiber_length': 1459,
                                                                                                                                          'poller_hash': 'ODdCMzM1cGVlcnBvbjE3OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.737393}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNlMTEwMDEwMTEw',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010111',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2858653',
                                                                                         'in_octets': '2240899421665',
                                                                                         'in_ucast_pkts': '4652448403',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '14463635741',
                                                                                                                  'in_octets': '14544326181',
                                                                                                                  'in_ucast_pkts': '80690440',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '353228776591',
                                                                                                                  'out_octets': '353491502642',
                                                                                                                  'out_ucast_pkts': '262726051',
                                                                                                                  'poller_hash': 'ODdCOUYxcGVlcmludGY0OC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '20494135247',
                                                                                                                  'in_octets': '20600301295',
                                                                                                                  'in_ucast_pkts': '106166048',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '544179187781',
                                                                                                                  'out_octets': '544554306277',
                                                                                                                  'out_ucast_pkts': '375118496',
                                                                                                                  'poller_hash': 'ODdCQTI0cGVlcmludGY4MC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '0',
                                                                                                                  'in_octets': '0',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': False,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '0',
                                                                                                                  'out_octets': '0',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODdCQUIxcGVlcmludGY4Mi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '2806911631',
                                                                                                                  'in_octets': '2819504627',
                                                                                                                  'in_ucast_pkts': '12592996',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '43016426040',
                                                                                                                  'out_octets': '43054171945',
                                                                                                                  'out_ucast_pkts': '37745905',
                                                                                                                  'poller_hash': 'ODdCQTI2cGVlcmludGYxMTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '49555905054',
                                                                                                                  'in_octets': '49914948532',
                                                                                                                  'in_ucast_pkts': '359043478',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1570315157120',
                                                                                                                  'out_octets': '1571415787003',
                                                                                                                  'out_ucast_pkts': '1100629883',
                                                                                                                  'poller_hash': 'ODdCQTRGcGVlcmludGYxNDcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1595367042',
                                                                                                                  'in_octets': '1603207226',
                                                                                                                  'in_ucast_pkts': '7840184',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '22102710769',
                                                                                                                  'out_octets': '22122336122',
                                                                                                                  'out_ucast_pkts': '19625353',
                                                                                                                  'poller_hash': 'ODdCOUU0cGVlcmludGYxNzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '40657573',
                                                                                                                  'in_octets': '41068630',
                                                                                                                  'in_ucast_pkts': '411057',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '8138520',
                                                                                                                  'out_octets': '8211154',
                                                                                                                  'out_ucast_pkts': '72634',
                                                                                                                  'poller_hash': 'ODdCRUQ5cGVlcmludGYyMTMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9028155577',
                                                                                                                  'in_octets': '9097795261',
                                                                                                                  'in_ucast_pkts': '69639684',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '359757652399',
                                                                                                                  'out_octets': '360011707901',
                                                                                                                  'out_ucast_pkts': '254055502',
                                                                                                                  'poller_hash': 'ODdCMzJDcGVlcmludGYyNTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '44132082112',
                                                                                                                  'in_octets': '44425323196',
                                                                                                                  'in_ucast_pkts': '293241084',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '918199347324',
                                                                                                                  'out_octets': '918864664042',
                                                                                                                  'out_ucast_pkts': '665316718',
                                                                                                                  'poller_hash': 'ODdCOUQ2cGVlcmludGYyNzIvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:cf',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp7',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '8',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '1181',
                                                                                         'out_octets': '15095772795014',
                                                                                         'out_ucast_pkts': '11548753809',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2YxLzEvZ3A3',
                                                                                         'pons': [       {       'id': '110010111',
                                                                                                                 'links': [       {       'connected_time': '2258629',
                                                                                                                                          'fiber_length': 1340,
                                                                                                                                          'poller_hash': 'ODdCOUYxcGVlcnBvbjQ4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.664229},
                                                                                                                                  {       'connected_time': '2258622',
                                                                                                                                          'fiber_length': 1145,
                                                                                                                                          'poller_hash': 'ODdCQTI0cGVlcnBvbjgwL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.664229},
                                                                                                                                  {       'connected_time': '169479',
                                                                                                                                          'fiber_length': 1339,
                                                                                                                                          'poller_hash': 'ODdCQUIxcGVlcnBvbjgyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.664229},
                                                                                                                                  {       'connected_time': '2258634',
                                                                                                                                          'fiber_length': 1271,
                                                                                                                                          'poller_hash': 'ODdCQTI2cGVlcnBvbjExOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.664229},
                                                                                                                                  {       'connected_time': '2067625',
                                                                                                                                          'fiber_length': 1369,
                                                                                                                                          'poller_hash': 'ODdCQTRGcGVlcnBvbjE0Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.664229},
                                                                                                                                  {       'connected_time': '2258627',
                                                                                                                                          'fiber_length': 1125,
                                                                                                                                          'poller_hash': 'ODdCOUU0cGVlcnBvbjE3Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.664229},
                                                                                                                                  {       'connected_time': '49940',
                                                                                                                                          'fiber_length': 1271,
                                                                                                                                          'poller_hash': 'ODdCRUQ5cGVlcnBvbjIxMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.664229},
                                                                                                                                  {       'connected_time': '2258655',
                                                                                                                                          'fiber_length': 1383,
                                                                                                                                          'poller_hash': 'ODdCMzJDcGVlcnBvbjI1OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.664229},
                                                                                                                                  {       'connected_time': '2258655',
                                                                                                                                          'fiber_length': 1148,
                                                                                                                                          'poller_hash': 'ODdCOUQ2cGVlcnBvbjI3Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.664229}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGNmMTEwMDEwMTEx',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '110010112',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '394930',
                                                                                         'in_octets': '654491145037',
                                                                                         'in_ucast_pkts': '2736648291',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11464787629',
                                                                                                                  'in_octets': '11542992389',
                                                                                                                  'in_ucast_pkts': '78204760',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '279947321178',
                                                                                                                  'out_octets': '280159648116',
                                                                                                                  'out_ucast_pkts': '212326938',
                                                                                                                  'poller_hash': 'ODdCQTA2cGVlcmludGY1Ny9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '19753494143',
                                                                                                                  'in_octets': '19846636169',
                                                                                                                  'in_ucast_pkts': '93142026',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '520907256351',
                                                                                                                  'out_octets': '521313399188',
                                                                                                                  'out_ucast_pkts': '406142837',
                                                                                                                  'poller_hash': 'ODdCQTA1cGVlcmludGY2MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '15555664334',
                                                                                                                  'in_octets': '15614207031',
                                                                                                                  'in_ucast_pkts': '58542697',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '636802503252',
                                                                                                                  'out_octets': '637251632807',
                                                                                                                  'out_ucast_pkts': '449129555',
                                                                                                                  'poller_hash': 'ODdCNEI4cGVlcmludGY2NS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6590160503',
                                                                                                                  'in_octets': '6646025974',
                                                                                                                  'in_ucast_pkts': '55865471',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '518183689128',
                                                                                                                  'out_octets': '518536857699',
                                                                                                                  'out_ucast_pkts': '353168571',
                                                                                                                  'poller_hash': 'ODdCQTFCcGVlcmludGY4NC9ncDE='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCQTIycGVlcmludGY4NS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '176161251',
                                                                                                                  'in_octets': '176358619',
                                                                                                                  'in_ucast_pkts': '197368',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '105808212',
                                                                                                                  'out_octets': '105929003',
                                                                                                                  'out_ucast_pkts': '120791',
                                                                                                                  'poller_hash': 'ODdCOTBCcGVlcmludGY4OS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '46517003474',
                                                                                                                  'in_octets': '46699318589',
                                                                                                                  'in_ucast_pkts': '182315115',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '465225143817',
                                                                                                                  'out_octets': '465590603590',
                                                                                                                  'out_ucast_pkts': '365459773',
                                                                                                                  'poller_hash': 'ODdCQTU3cGVlcmludGYxNDgvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOUEzcGVlcmludGYxNzMvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCMkE0cGVlcmludGYyMTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '2476930377',
                                                                                                                  'in_octets': '2488902581',
                                                                                                                  'in_ucast_pkts': '11972204',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '85125897482',
                                                                                                                  'out_octets': '85187226680',
                                                                                                                  'out_ucast_pkts': '61329198',
                                                                                                                  'poller_hash': 'ODdCOUFEcGVlcmludGYyNjUvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOUFDcGVlcmludGYyNjYvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:bd:d0',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/1/gp8',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '9',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '4099',
                                                                                         'out_octets': '12036172760707',
                                                                                         'out_ucast_pkts': '8821006274',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4',
                                                                                         'pons': [       {       'id': '110010112',
                                                                                                                 'links': [       {       'connected_time': '2258632',
                                                                                                                                          'fiber_length': 1447,
                                                                                                                                          'poller_hash': 'ODdCQTA2cGVlcnBvbjU3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305},
                                                                                                                                  {       'connected_time': '2258646',
                                                                                                                                          'fiber_length': 1417,
                                                                                                                                          'poller_hash': 'ODdCQTA1cGVlcnBvbjYxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305},
                                                                                                                                  {       'connected_time': '2258620',
                                                                                                                                          'fiber_length': 1198,
                                                                                                                                          'poller_hash': 'ODdCNEI4cGVlcnBvbjY1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305},
                                                                                                                                  {       'connected_time': '2258621',
                                                                                                                                          'fiber_length': 1228,
                                                                                                                                          'poller_hash': 'ODdCQTFCcGVlcnBvbjg0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305},
                                                                                                                                  {       'poller_hash': 'ODdCQTIycGVlcnBvbjg1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305},
                                                                                                                                  {       'connected_time': '10387',
                                                                                                                                          'fiber_length': 1287,
                                                                                                                                          'poller_hash': 'ODdCOTBCcGVlcnBvbjg5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305},
                                                                                                                                  {       'connected_time': '1466611',
                                                                                                                                          'fiber_length': 1359,
                                                                                                                                          'poller_hash': 'ODdCQTU3cGVlcnBvbjE0OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305},
                                                                                                                                  {       'poller_hash': 'ODdCOUEzcGVlcnBvbjE3My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305},
                                                                                                                                  {       'poller_hash': 'ODdCMkE0cGVlcnBvbjIxMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305},
                                                                                                                                  {       'connected_time': '2258646',
                                                                                                                                          'fiber_length': 1392,
                                                                                                                                          'poller_hash': 'ODdCOUFEcGVlcnBvbjI2NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305},
                                                                                                                                  {       'poller_hash': 'ODdCOUFDcGVlcnBvbjI2Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.674305}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'mem': 47.0,
                                                           'model': 'GPON-8 r2',
                                                           'name': '1/1',
                                                           'poller_hash': 'NDcyMDA2MDE5MzA1',
                                                           'serial_number': '472006019305',
                                                           'sw_version': '23.2.0',
                                                           'temperature': 23.4,
                                                           'uptime': '9981360'},
                                                   {       'cpu': 24.0,
                                                           'id': '1/2',
                                                           'interfaces': [       {       'admin_up': False,
                                                                                         'id': '120000101',
                                                                                         'mac_address': '48:77:46:53:46:1d',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MWQxLzIvZzE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000102',
                                                                                         'mac_address': '48:77:46:53:46:1e',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MWUxLzIvZzI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000103',
                                                                                         'mac_address': '48:77:46:53:46:1f',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MWYxLzIvZzM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000104',
                                                                                         'mac_address': '48:77:46:53:46:20',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MjAxLzIvZzQ='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000105',
                                                                                         'mac_address': '48:77:46:53:46:21',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g5',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MjExLzIvZzU='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000106',
                                                                                         'mac_address': '48:77:46:53:46:22',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g6',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MjIxLzIvZzY='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000107',
                                                                                         'mac_address': '48:77:46:53:46:23',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g7',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MjMxLzIvZzc='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120000108',
                                                                                         'mac_address': '48:77:46:53:46:24',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/g8',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MjQxLzIvZzg='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010101',
                                                                                         'mac_address': '48:77:46:53:46:0d',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x1',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MGQxLzIveDE='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010102',
                                                                                         'mac_address': '48:77:46:53:46:0e',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x2',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MGUxLzIveDI='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010103',
                                                                                         'mac_address': '48:77:46:53:46:0f',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x3',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MGYxLzIveDM='},
                                                                                 {       'admin_up': False,
                                                                                         'id': '120010104',
                                                                                         'mac_address': '48:77:46:53:46:10',
                                                                                         'mtu': 2000,
                                                                                         'name': '1/2/x4',
                                                                                         'oper_up': False,
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTAxLzIveDQ='},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010105',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '519836',
                                                                                         'in_octets': '1347403096433',
                                                                                         'in_ucast_pkts': '7295155509',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4344069909',
                                                                                                                  'in_octets': '4365482950',
                                                                                                                  'in_ucast_pkts': '21413041',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '89770582339',
                                                                                                                  'out_octets': '89839578668',
                                                                                                                  'out_ucast_pkts': '68996329',
                                                                                                                  'poller_hash': 'ODdCQTIzcGVlcmludGY4Ni9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '64768318339',
                                                                                                                  'in_octets': '65114442523',
                                                                                                                  'in_ucast_pkts': '346124184',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '882780972098',
                                                                                                                  'out_octets': '883461563743',
                                                                                                                  'out_ucast_pkts': '680591645',
                                                                                                                  'poller_hash': 'ODdCOUZGcGVlcmludGY5MS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '28298777937',
                                                                                                                  'in_octets': '28544967510',
                                                                                                                  'in_ucast_pkts': '246189573',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1060832984061',
                                                                                                                  'out_octets': '1061554935307',
                                                                                                                  'out_ucast_pkts': '721951246',
                                                                                                                  'poller_hash': 'ODdCN0ZGcGVlcmludGY5NC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10082729345',
                                                                                                                  'in_octets': '10146566384',
                                                                                                                  'in_ucast_pkts': '63837039',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '199987812831',
                                                                                                                  'out_octets': '200134837447',
                                                                                                                  'out_ucast_pkts': '147024616',
                                                                                                                  'poller_hash': 'ODdCQTI3cGVlcmludGY5Ni9ncDE='},
                                                                                                          {       'in_errors': '1',
                                                                                                                  'in_nucast_pkts': '40149351413',
                                                                                                                  'in_octets': '40549026103',
                                                                                                                  'in_ucast_pkts': '399674690',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1375071753065',
                                                                                                                  'out_octets': '1376019662121',
                                                                                                                  'out_ucast_pkts': '947909056',
                                                                                                                  'poller_hash': 'ODdCODBFcGVlcmludGY5OS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '73474341500',
                                                                                                                  'in_octets': '73572191955',
                                                                                                                  'in_ucast_pkts': '97850455',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '532220840295',
                                                                                                                  'out_octets': '532626394905',
                                                                                                                  'out_ucast_pkts': '405554610',
                                                                                                                  'poller_hash': 'ODdCRURGcGVlcmludGYxMDUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '951962548',
                                                                                                                  'in_octets': '954024273',
                                                                                                                  'in_ucast_pkts': '2061725',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3002043856',
                                                                                                                  'out_octets': '3005221126',
                                                                                                                  'out_ucast_pkts': '3177270',
                                                                                                                  'poller_hash': 'ODdCNzcwcGVlcmludGYxNzcvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOURBcGVlcmludGYxOTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3702685457',
                                                                                                                  'in_octets': '3716938289',
                                                                                                                  'in_ucast_pkts': '14252832',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '24494948042',
                                                                                                                  'out_octets': '24518310833',
                                                                                                                  'out_ucast_pkts': '23362791',
                                                                                                                  'poller_hash': 'ODdCOUQzcGVlcmludGYyMDAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5952982661',
                                                                                                                  'in_octets': '6015689937',
                                                                                                                  'in_ucast_pkts': '62707276',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '203136337726',
                                                                                                                  'out_octets': '203278128504',
                                                                                                                  'out_ucast_pkts': '141790778',
                                                                                                                  'poller_hash': 'ODdCOTlFcGVlcmludGYyNTUvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:11',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp1',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '432',
                                                                                         'out_octets': '24564604512979',
                                                                                         'out_ucast_pkts': '17491215431',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax',
                                                                                         'pons': [       {       'id': '120010105',
                                                                                                                 'links': [       {       'connected_time': '2602670',
                                                                                                                                          'fiber_length': 1541,
                                                                                                                                          'poller_hash': 'ODdCQTIzcGVlcnBvbjg2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '2602682',
                                                                                                                                          'fiber_length': 1272,
                                                                                                                                          'poller_hash': 'ODdCOUZGcGVlcnBvbjkxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '1530169',
                                                                                                                                          'fiber_length': 1337,
                                                                                                                                          'poller_hash': 'ODdCN0ZGcGVlcnBvbjk0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '1003506',
                                                                                                                                          'fiber_length': 1337,
                                                                                                                                          'poller_hash': 'ODdCQTI3cGVlcnBvbjk2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '1239371',
                                                                                                                                          'fiber_length': 1279,
                                                                                                                                          'poller_hash': 'ODdCODBFcGVlcnBvbjk5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '2602669',
                                                                                                                                          'fiber_length': 1369,
                                                                                                                                          'poller_hash': 'ODdCRURGcGVlcnBvbjEwNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '2602694',
                                                                                                                                          'fiber_length': 1395,
                                                                                                                                          'poller_hash': 'ODdCNzcwcGVlcnBvbjE3Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'poller_hash': 'ODdCOURBcGVlcnBvbjE5MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '2602686',
                                                                                                                                          'fiber_length': 1334,
                                                                                                                                          'poller_hash': 'ODdCOUQzcGVlcnBvbjIwMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878},
                                                                                                                                  {       'connected_time': '2602700',
                                                                                                                                          'fiber_length': 1370,
                                                                                                                                          'poller_hash': 'ODdCOTlFcGVlcnBvbjI1NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.639878}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010106',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '1798634',
                                                                                         'in_octets': '689148879067',
                                                                                         'in_ucast_pkts': '2336652561',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '29872900879',
                                                                                                                  'in_octets': '30082866693',
                                                                                                                  'in_ucast_pkts': '209965814',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '800503418901',
                                                                                                                  'out_octets': '801072827695',
                                                                                                                  'out_ucast_pkts': '569408794',
                                                                                                                  'poller_hash': 'ODdCQTNBcGVlcmludGYxMzQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13418076580',
                                                                                                                  'in_octets': '13464851058',
                                                                                                                  'in_ucast_pkts': '46774478',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '90125391734',
                                                                                                                  'out_octets': '90204380792',
                                                                                                                  'out_ucast_pkts': '78989058',
                                                                                                                  'poller_hash': 'ODdCOTZFcGVlcmludGYxMzUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6486815893',
                                                                                                                  'in_octets': '6527428794',
                                                                                                                  'in_ucast_pkts': '40612901',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '196643921303',
                                                                                                                  'out_octets': '196787196553',
                                                                                                                  'out_ucast_pkts': '143275250',
                                                                                                                  'poller_hash': 'ODdCQTMzcGVlcmludGYxNTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '149922256462',
                                                                                                                  'in_octets': '150220393194',
                                                                                                                  'in_ucast_pkts': '298136732',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1059916660715',
                                                                                                                  'out_octets': '1060781820829',
                                                                                                                  'out_ucast_pkts': '865160114',
                                                                                                                  'poller_hash': 'ODdCOTAycGVlcmludGYxNjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10423247978',
                                                                                                                  'in_octets': '10476779118',
                                                                                                                  'in_ucast_pkts': '53531140',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '159993042239',
                                                                                                                  'out_octets': '160116511640',
                                                                                                                  'out_ucast_pkts': '123469401',
                                                                                                                  'poller_hash': 'ODdCOUQ1cGVlcmludGYxNjUvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCOUMwcGVlcmludGYxODYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '190702060',
                                                                                                                  'in_octets': '191110834',
                                                                                                                  'in_ucast_pkts': '408774',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '281393310',
                                                                                                                  'out_octets': '282057008',
                                                                                                                  'out_ucast_pkts': '663698',
                                                                                                                  'poller_hash': 'ODdCODdCcGVlcmludGYyMDIvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCQUUwcGVlcmludGYyNDcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '191816723',
                                                                                                                  'in_octets': '192243631',
                                                                                                                  'in_ucast_pkts': '426908',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '353974940',
                                                                                                                  'out_octets': '354734254',
                                                                                                                  'out_ucast_pkts': '759314',
                                                                                                                  'poller_hash': 'ODdCQTJEcGVlcmludGYyNjIvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:12',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp2',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '637',
                                                                                         'out_octets': '8578623039267',
                                                                                         'out_ucast_pkts': '6482291142',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTIxLzIvZ3Ay',
                                                                                         'pons': [       {       'id': '120010106',
                                                                                                                 'links': [       {       'connected_time': '2602733',
                                                                                                                                          'fiber_length': 487,
                                                                                                                                          'poller_hash': 'ODdCQTNBcGVlcnBvbjEzNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '2602721',
                                                                                                                                          'fiber_length': 599,
                                                                                                                                          'poller_hash': 'ODdCOTZFcGVlcnBvbjEzNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '2602750',
                                                                                                                                          'fiber_length': 543,
                                                                                                                                          'poller_hash': 'ODdCQTMzcGVlcnBvbjE1Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '4045528',
                                                                                                                                          'fiber_length': 470,
                                                                                                                                          'poller_hash': 'ODdCOTAycGVlcnBvbjE2MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '1472108',
                                                                                                                                          'fiber_length': 641,
                                                                                                                                          'poller_hash': 'ODdCOUQ1cGVlcnBvbjE2NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'poller_hash': 'ODdCOUMwcGVlcnBvbjE4Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '2602753',
                                                                                                                                          'fiber_length': 594,
                                                                                                                                          'poller_hash': 'ODdCODdCcGVlcnBvbjIwMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'poller_hash': 'ODdCQUUwcGVlcnBvbjI0Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706},
                                                                                                                                  {       'connected_time': '2602755',
                                                                                                                                          'fiber_length': 534,
                                                                                                                                          'poller_hash': 'ODdCQTJEcGVlcnBvbjI2Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.784706}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjEyMTIwMDEwMTA2',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010107',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '2542682',
                                                                                         'in_octets': '133282278829',
                                                                                         'in_ucast_pkts': '751353800',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3986982637',
                                                                                                                  'in_octets': '3997971221',
                                                                                                                  'in_ucast_pkts': '10988584',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '32994817622',
                                                                                                                  'out_octets': '33021716457',
                                                                                                                  'out_ucast_pkts': '26898835',
                                                                                                                  'poller_hash': 'ODdCODk5cGVlcmludGYxNDkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1640033746',
                                                                                                                  'in_octets': '1646082733',
                                                                                                                  'in_ucast_pkts': '6048987',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '14136670018',
                                                                                                                  'out_octets': '14148220843',
                                                                                                                  'out_ucast_pkts': '11550825',
                                                                                                                  'poller_hash': 'ODdCOTAxcGVlcmludGYxNjIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '286257992',
                                                                                                                  'in_octets': '286593143',
                                                                                                                  'in_ucast_pkts': '335151',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '37758924',
                                                                                                                  'out_octets': '37912200',
                                                                                                                  'out_ucast_pkts': '153276',
                                                                                                                  'poller_hash': 'ODdCOUNGcGVlcmludGYxOTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11367999565',
                                                                                                                  'in_octets': '11464843057',
                                                                                                                  'in_ucast_pkts': '96843492',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '452503711318',
                                                                                                                  'out_octets': '452818613962',
                                                                                                                  'out_ucast_pkts': '314902644',
                                                                                                                  'poller_hash': 'ODdCOUNEcGVlcmludGYyNjcvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:13',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp3',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '595',
                                                                                         'out_octets': '3132258810495',
                                                                                         'out_ucast_pkts': '2249526681',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTMxLzIvZ3Az',
                                                                                         'pons': [       {       'id': '120010107',
                                                                                                                 'links': [       {       'connected_time': '586805',
                                                                                                                                          'fiber_length': 582,
                                                                                                                                          'poller_hash': 'ODdCODk5cGVlcnBvbjE0OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.696796},
                                                                                                                                  {       'connected_time': '2421384',
                                                                                                                                          'fiber_length': 562,
                                                                                                                                          'poller_hash': 'ODdCOTAxcGVlcnBvbjE2Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.696796},
                                                                                                                                  {       'connected_time': '253065',
                                                                                                                                          'fiber_length': 516,
                                                                                                                                          'poller_hash': 'ODdCOUNGcGVlcnBvbjE5MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.696796},
                                                                                                                                  {       'connected_time': '1695686',
                                                                                                                                          'fiber_length': 568,
                                                                                                                                          'poller_hash': 'ODdCOUNEcGVlcnBvbjI2Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.696796}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjEzMTIwMDEwMTA3',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010108',
                                                                                         'in_discards': '2',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '143863',
                                                                                         'in_octets': '106762575259',
                                                                                         'in_ucast_pkts': '451557000',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '16633603761',
                                                                                                                  'in_octets': '16676775550',
                                                                                                                  'in_ucast_pkts': '43171789',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '98127063242',
                                                                                                                  'out_octets': '98216508586',
                                                                                                                  'out_ucast_pkts': '89445344',
                                                                                                                  'poller_hash': 'ODdCN0Y1cGVlcmludGYxNTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1861205494',
                                                                                                                  'in_octets': '1876473980',
                                                                                                                  'in_ucast_pkts': '15268486',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '46570692548',
                                                                                                                  'out_octets': '46605445325',
                                                                                                                  'out_ucast_pkts': '34752777',
                                                                                                                  'poller_hash': 'ODdCN0E4cGVlcmludGYxNTkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3819259140',
                                                                                                                  'in_octets': '3840363195',
                                                                                                                  'in_ucast_pkts': '21104055',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '57287072308',
                                                                                                                  'out_octets': '57330311017',
                                                                                                                  'out_ucast_pkts': '43238709',
                                                                                                                  'poller_hash': 'N0Q5RjJDcGVlcmludGYxODkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3015460010',
                                                                                                                  'in_octets': '3029248198',
                                                                                                                  'in_ucast_pkts': '13788188',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '29087250783',
                                                                                                                  'out_octets': '29112122037',
                                                                                                                  'out_ucast_pkts': '24871254',
                                                                                                                  'poller_hash': 'ODdCQUVEcGVlcmludGYxOTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4995729574',
                                                                                                                  'in_octets': '5040747523',
                                                                                                                  'in_ucast_pkts': '45017949',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '128964418234',
                                                                                                                  'out_octets': '129056378636',
                                                                                                                  'out_ucast_pkts': '91960402',
                                                                                                                  'poller_hash': 'ODdCQTQzcGVlcmludGYyMDEvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCM0RCcGVlcmludGYyNjAvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:14',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp4',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '2164',
                                                                                         'out_octets': '1165645446709',
                                                                                         'out_ucast_pkts': '936804268',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTQxLzIvZ3A0',
                                                                                         'pons': [       {       'id': '120010108',
                                                                                                                 'links': [       {       'connected_time': '2602734',
                                                                                                                                          'fiber_length': 681,
                                                                                                                                          'poller_hash': 'ODdCN0Y1cGVlcnBvbjE1MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.802655},
                                                                                                                                  {       'connected_time': '2602734',
                                                                                                                                          'fiber_length': 683,
                                                                                                                                          'poller_hash': 'ODdCN0E4cGVlcnBvbjE1OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.802655},
                                                                                                                                  {       'connected_time': '2602706',
                                                                                                                                          'fiber_length': 640,
                                                                                                                                          'poller_hash': 'N0Q5RjJDcGVlcnBvbjE4OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -23.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.802655},
                                                                                                                                  {       'connected_time': '2602747',
                                                                                                                                          'fiber_length': 716,
                                                                                                                                          'poller_hash': 'ODdCQUVEcGVlcnBvbjE5Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.802655},
                                                                                                                                  {       'connected_time': '2602729',
                                                                                                                                          'fiber_length': 770,
                                                                                                                                          'poller_hash': 'ODdCQTQzcGVlcnBvbjIwMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.802655},
                                                                                                                                  {       'poller_hash': 'ODdCM0RCcGVlcnBvbjI2MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.802655}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjE0MTIwMDEwMTA4',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010109',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '656985',
                                                                                         'in_octets': '1726883804914',
                                                                                         'in_ucast_pkts': '7047911067',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13364671626',
                                                                                                                  'in_octets': '13398720740',
                                                                                                                  'in_ucast_pkts': '34049114',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '135270006274',
                                                                                                                  'out_octets': '135379700334',
                                                                                                                  'out_ucast_pkts': '109694060',
                                                                                                                  'poller_hash': 'ODdCODQ5cGVlcmludGY5OC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '18271322604',
                                                                                                                  'in_octets': '18307780346',
                                                                                                                  'in_ucast_pkts': '36457742',
                                                                                                                  'oper_up': False,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '88792805789',
                                                                                                                  'out_octets': '88871615848',
                                                                                                                  'out_ucast_pkts': '78810059',
                                                                                                                  'poller_hash': 'ODdCODlCcGVlcmludGYxMDIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7400155608',
                                                                                                                  'in_octets': '7416865672',
                                                                                                                  'in_ucast_pkts': '16710064',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '53190327068',
                                                                                                                  'out_octets': '53236304501',
                                                                                                                  'out_ucast_pkts': '45977433',
                                                                                                                  'poller_hash': 'ODdCODVFcGVlcmludGYxMDMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3172664872',
                                                                                                                  'in_octets': '3190379901',
                                                                                                                  'in_ucast_pkts': '17715029',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '123151647206',
                                                                                                                  'out_octets': '123240638252',
                                                                                                                  'out_ucast_pkts': '88991046',
                                                                                                                  'poller_hash': 'ODdCODc0cGVlcmludGYxMDgvZ3Ax'},
                                                                                                          {       'in_errors': '1',
                                                                                                                  'in_nucast_pkts': '7841565651',
                                                                                                                  'in_octets': '7888256609',
                                                                                                                  'in_ucast_pkts': '46690958',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '429185354835',
                                                                                                                  'out_octets': '429483641776',
                                                                                                                  'out_ucast_pkts': '298286941',
                                                                                                                  'poller_hash': 'ODdCOEJGcGVlcmludGYxMTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13195802876',
                                                                                                                  'in_octets': '13263609593',
                                                                                                                  'in_ucast_pkts': '67806717',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '376416283939',
                                                                                                                  'out_octets': '376690592113',
                                                                                                                  'out_ucast_pkts': '274308174',
                                                                                                                  'poller_hash': 'ODdCN0U1cGVlcmludGYxMjAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '11457675528',
                                                                                                                  'in_octets': '11548974953',
                                                                                                                  'in_ucast_pkts': '91299425',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '170673092790',
                                                                                                                  'out_octets': '170859445079',
                                                                                                                  'out_ucast_pkts': '186352289',
                                                                                                                  'poller_hash': 'ODdCODc1cGVlcmludGYxMjIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '128676150',
                                                                                                                  'in_octets': '128879733',
                                                                                                                  'in_ucast_pkts': '203583',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '119970328',
                                                                                                                  'out_octets': '120435103',
                                                                                                                  'out_ucast_pkts': '464775',
                                                                                                                  'poller_hash': 'ODdCOTNEcGVlcmludGYxMjMvZ3Ax'},
                                                                                                          {       'in_errors': '1',
                                                                                                                  'in_nucast_pkts': '46930100998',
                                                                                                                  'in_octets': '47115431431',
                                                                                                                  'in_ucast_pkts': '185330433',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '776212844721',
                                                                                                                  'out_octets': '776785139226',
                                                                                                                  'out_ucast_pkts': '572294505',
                                                                                                                  'poller_hash': 'ODdCQTQxcGVlcmludGYxMzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '41842271216',
                                                                                                                  'in_octets': '41886735432',
                                                                                                                  'in_ucast_pkts': '44464216',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '18725755385',
                                                                                                                  'out_octets': '18753019306',
                                                                                                                  'out_ucast_pkts': '27263921',
                                                                                                                  'poller_hash': 'ODdCOUUwcGVlcmludGYxNjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '13853572364',
                                                                                                                  'in_octets': '13967711980',
                                                                                                                  'in_ucast_pkts': '114139616',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '403112126043',
                                                                                                                  'out_octets': '403399294267',
                                                                                                                  'out_ucast_pkts': '287168224',
                                                                                                                  'poller_hash': 'ODdCOURCcGVlcmludGYxODIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '49146966831',
                                                                                                                  'in_octets': '49329585238',
                                                                                                                  'in_ucast_pkts': '182618407',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '757325785826',
                                                                                                                  'out_octets': '757895314535',
                                                                                                                  'out_ucast_pkts': '569528709',
                                                                                                                  'poller_hash': 'ODdCMUE4cGVlcmludGYyMzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '539059740',
                                                                                                                  'in_octets': '541794129',
                                                                                                                  'in_ucast_pkts': '2734389',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2507807220',
                                                                                                                  'out_octets': '2510906376',
                                                                                                                  'out_ucast_pkts': '3099156',
                                                                                                                  'poller_hash': 'ODdCOUQ0cGVlcmludGYyNTEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '63286292782',
                                                                                                                  'in_octets': '64069892324',
                                                                                                                  'in_ucast_pkts': '783599542',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2284021197961',
                                                                                                                  'out_octets': '2285545574707',
                                                                                                                  'out_ucast_pkts': '1524376746',
                                                                                                                  'poller_hash': 'ODdCOTk5cGVlcmludGYyNTIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '36757126909',
                                                                                                                  'in_octets': '37134387420',
                                                                                                                  'in_ucast_pkts': '377260511',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1200952277089',
                                                                                                                  'out_octets': '1201775514772',
                                                                                                                  'out_ucast_pkts': '823237683',
                                                                                                                  'poller_hash': 'ODdCQTM4cGVlcmludGYyNTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '15809802191',
                                                                                                                  'in_octets': '15897297077',
                                                                                                                  'in_ucast_pkts': '87494886',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '282711423875',
                                                                                                                  'out_octets': '282920763412',
                                                                                                                  'out_ucast_pkts': '209339537',
                                                                                                                  'poller_hash': 'ODdCQUQ0cGVlcmludGYyNTcvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '6551685221',
                                                                                                                  'in_octets': '6592660852',
                                                                                                                  'in_ucast_pkts': '40975631',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '122628612854',
                                                                                                                  'out_octets': '122712432483',
                                                                                                                  'out_ucast_pkts': '83819629',
                                                                                                                  'poller_hash': 'ODdCOTkzcGVlcmludGYyNjQvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:15',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp5',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '2589',
                                                                                         'out_octets': '24400660875926',
                                                                                         'out_ucast_pkts': '17614981767',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1',
                                                                                         'pons': [       {       'id': '120010109',
                                                                                                                 'links': [       {       'connected_time': '2602744',
                                                                                                                                          'fiber_length': 890,
                                                                                                                                          'poller_hash': 'ODdCODQ5cGVlcnBvbjk4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602736',
                                                                                                                                          'fiber_length': 1015,
                                                                                                                                          'poller_hash': 'ODdCODlCcGVlcnBvbjEwMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602754',
                                                                                                                                          'fiber_length': 1081,
                                                                                                                                          'poller_hash': 'ODdCODVFcGVlcnBvbjEwMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602715',
                                                                                                                                          'fiber_length': 940,
                                                                                                                                          'poller_hash': 'ODdCODc0cGVlcnBvbjEwOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602741',
                                                                                                                                          'fiber_length': 993,
                                                                                                                                          'poller_hash': 'ODdCOEJGcGVlcnBvbjExMS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602753',
                                                                                                                                          'fiber_length': 972,
                                                                                                                                          'poller_hash': 'ODdCN0U1cGVlcnBvbjEyMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '1562093',
                                                                                                                                          'fiber_length': 1136,
                                                                                                                                          'poller_hash': 'ODdCODc1cGVlcnBvbjEyMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602726',
                                                                                                                                          'fiber_length': 878,
                                                                                                                                          'poller_hash': 'ODdCOTNEcGVlcnBvbjEyMy9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602737',
                                                                                                                                          'fiber_length': 1042,
                                                                                                                                          'poller_hash': 'ODdCQTQxcGVlcnBvbjEzNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '1043841',
                                                                                                                                          'fiber_length': 1089,
                                                                                                                                          'poller_hash': 'ODdCOUUwcGVlcnBvbjE2NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602730',
                                                                                                                                          'fiber_length': 1015,
                                                                                                                                          'poller_hash': 'ODdCOURCcGVlcnBvbjE4Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '1892281',
                                                                                                                                          'fiber_length': 1030,
                                                                                                                                          'poller_hash': 'ODdCMUE4cGVlcnBvbjIzNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602746',
                                                                                                                                          'fiber_length': 1038,
                                                                                                                                          'poller_hash': 'ODdCOUQ0cGVlcnBvbjI1MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602773',
                                                                                                                                          'fiber_length': 886,
                                                                                                                                          'poller_hash': 'ODdCOTk5cGVlcnBvbjI1Mi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602782',
                                                                                                                                          'fiber_length': 815,
                                                                                                                                          'poller_hash': 'ODdCQTM4cGVlcnBvbjI1Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2602748',
                                                                                                                                          'fiber_length': 811,
                                                                                                                                          'poller_hash': 'ODdCQUQ0cGVlcnBvbjI1Ny9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682},
                                                                                                                                  {       'connected_time': '2059923',
                                                                                                                                          'fiber_length': 1013,
                                                                                                                                          'poller_hash': 'ODdCOTkzcGVlcnBvbjI2NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.749682}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010110',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '13074236',
                                                                                         'in_octets': '1232539955314',
                                                                                         'in_ucast_pkts': '6327858948',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '17275849308',
                                                                                                                  'in_octets': '17396439045',
                                                                                                                  'in_ucast_pkts': '120589737',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '298529931829',
                                                                                                                  'out_octets': '298748322581',
                                                                                                                  'out_ucast_pkts': '218390752',
                                                                                                                  'poller_hash': 'ODdCODMxcGVlcmludGYxMTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '48229201362',
                                                                                                                  'in_octets': '48627616508',
                                                                                                                  'in_ucast_pkts': '398415146',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1261851815087',
                                                                                                                  'out_octets': '1262715957295',
                                                                                                                  'out_ucast_pkts': '864142208',
                                                                                                                  'poller_hash': 'ODdCQTFBcGVlcmludGYxMTUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '14443860351',
                                                                                                                  'in_octets': '14482413398',
                                                                                                                  'in_ucast_pkts': '38553047',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '92605003254',
                                                                                                                  'out_octets': '92676061310',
                                                                                                                  'out_ucast_pkts': '71058056',
                                                                                                                  'poller_hash': 'ODdCOEI3cGVlcmludGYxMTYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '48872779056',
                                                                                                                  'in_octets': '48998328147',
                                                                                                                  'in_ucast_pkts': '125549091',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '531918402860',
                                                                                                                  'out_octets': '532318394450',
                                                                                                                  'out_ucast_pkts': '399991590',
                                                                                                                  'poller_hash': 'ODdCODUzcGVlcmludGYxMTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '34189357165',
                                                                                                                  'in_octets': '34410423810',
                                                                                                                  'in_ucast_pkts': '221066645',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '713932433521',
                                                                                                                  'out_octets': '714433062028',
                                                                                                                  'out_ucast_pkts': '500628507',
                                                                                                                  'poller_hash': 'ODdCQTFDcGVlcmludGYxMzAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '785400631',
                                                                                                                  'in_octets': '786825309',
                                                                                                                  'in_ucast_pkts': '1424678',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '4254400049',
                                                                                                                  'out_octets': '4258330418',
                                                                                                                  'out_ucast_pkts': '3930369',
                                                                                                                  'poller_hash': 'ODdCOUNDcGVlcmludGYxNjYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5508938510',
                                                                                                                  'in_octets': '5551173346',
                                                                                                                  'in_ucast_pkts': '42234836',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '414679325801',
                                                                                                                  'out_octets': '414960553280',
                                                                                                                  'out_ucast_pkts': '281227479',
                                                                                                                  'poller_hash': 'ODdCMjExcGVlcmludGYxNjkvZ3Ax'},
                                                                                                          {       'in_errors': '146',
                                                                                                                  'in_nucast_pkts': '2628995947',
                                                                                                                  'in_octets': '2642703288',
                                                                                                                  'in_ucast_pkts': '13707341',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '76006113614',
                                                                                                                  'out_octets': '76060855887',
                                                                                                                  'out_ucast_pkts': '54742273',
                                                                                                                  'poller_hash': 'ODdCOTk1cGVlcmludGYxNzEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1998460542',
                                                                                                                  'in_octets': '2003816554',
                                                                                                                  'in_ucast_pkts': '5356012',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '11492089611',
                                                                                                                  'out_octets': '11502599268',
                                                                                                                  'out_ucast_pkts': '10509657',
                                                                                                                  'poller_hash': 'ODdCOEQ3cGVlcmludGYxODEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5021850965',
                                                                                                                  'in_octets': '5058529127',
                                                                                                                  'in_ucast_pkts': '36678162',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '186354986458',
                                                                                                                  'out_octets': '186481664913',
                                                                                                                  'out_ucast_pkts': '126678455',
                                                                                                                  'poller_hash': 'ODdCQTQ1cGVlcmludGYxOTgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12082507203',
                                                                                                                  'in_octets': '12163170472',
                                                                                                                  'in_ucast_pkts': '80663269',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '317315340500',
                                                                                                                  'out_octets': '317541932190',
                                                                                                                  'out_ucast_pkts': '226591690',
                                                                                                                  'poller_hash': 'ODdCMUYycGVlcmludGYyMDkvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '10438129919',
                                                                                                                  'in_octets': '10472246834',
                                                                                                                  'in_ucast_pkts': '34116915',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '210539041299',
                                                                                                                  'out_octets': '210686111014',
                                                                                                                  'out_ucast_pkts': '147069715',
                                                                                                                  'poller_hash': 'ODdCOUQycGVlcmludGYyMzgvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9660170301',
                                                                                                                  'in_octets': '9731306885',
                                                                                                                  'in_ucast_pkts': '71136584',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '303586676023',
                                                                                                                  'out_octets': '303796840167',
                                                                                                                  'out_ucast_pkts': '210164144',
                                                                                                                  'poller_hash': 'ODdCQUVBcGVlcmludGYyMzkvZ3Ax'},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCQTREcGVlcmludGYyNDQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3774809003',
                                                                                                                  'in_octets': '3789699823',
                                                                                                                  'in_ucast_pkts': '14890820',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '53688710526',
                                                                                                                  'out_octets': '53732968796',
                                                                                                                  'out_ucast_pkts': '44258270',
                                                                                                                  'poller_hash': 'ODdCOEZCcGVlcmludGYyNTAvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '9171939957',
                                                                                                                  'in_octets': '9240587685',
                                                                                                                  'in_ucast_pkts': '68647728',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '341146852603',
                                                                                                                  'out_octets': '341383459442',
                                                                                                                  'out_ucast_pkts': '236606839',
                                                                                                                  'poller_hash': 'ODdCRUU4cGVlcmludGYyNzEvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '16202385610',
                                                                                                                  'in_octets': '16398553455',
                                                                                                                  'in_ucast_pkts': '196167845',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '554062117819',
                                                                                                                  'out_octets': '554440610862',
                                                                                                                  'out_ucast_pkts': '378493043',
                                                                                                                  'poller_hash': 'ODdCODdGcGVlcmludGYyNzUvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5869389835',
                                                                                                                  'in_octets': '5918957033',
                                                                                                                  'in_ucast_pkts': '49567198',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '144201533209',
                                                                                                                  'out_octets': '144301348090',
                                                                                                                  'out_ucast_pkts': '99814881',
                                                                                                                  'poller_hash': 'ODdCMjQzcGVlcmludGYyNzgvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:16',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp6',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '1126',
                                                                                         'out_octets': '21523012822195',
                                                                                         'out_ucast_pkts': '15216230939',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2',
                                                                                         'pons': [       {       'id': '120010110',
                                                                                                                 'links': [       {       'connected_time': '2602740',
                                                                                                                                          'fiber_length': 923,
                                                                                                                                          'poller_hash': 'ODdCODMxcGVlcnBvbjExMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602740',
                                                                                                                                          'fiber_length': 770,
                                                                                                                                          'poller_hash': 'ODdCQTFBcGVlcnBvbjExNS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602737',
                                                                                                                                          'fiber_length': 644,
                                                                                                                                          'poller_hash': 'ODdCOEI3cGVlcnBvbjExNi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602726',
                                                                                                                                          'fiber_length': 759,
                                                                                                                                          'poller_hash': 'ODdCODUzcGVlcnBvbjExOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -19.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602727',
                                                                                                                                          'fiber_length': 942,
                                                                                                                                          'poller_hash': 'ODdCQTFDcGVlcnBvbjEzMC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602745',
                                                                                                                                          'fiber_length': 766,
                                                                                                                                          'poller_hash': 'ODdCOUNDcGVlcnBvbjE2Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602727',
                                                                                                                                          'fiber_length': 847,
                                                                                                                                          'poller_hash': 'ODdCMjExcGVlcnBvbjE2OS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '694092',
                                                                                                                                          'fiber_length': 856,
                                                                                                                                          'poller_hash': 'ODdCOTk1cGVlcnBvbjE3MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602772',
                                                                                                                                          'fiber_length': 939,
                                                                                                                                          'poller_hash': 'ODdCOEQ3cGVlcnBvbjE4MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602761',
                                                                                                                                          'fiber_length': 774,
                                                                                                                                          'poller_hash': 'ODdCQTQ1cGVlcnBvbjE5OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602752',
                                                                                                                                          'fiber_length': 818,
                                                                                                                                          'poller_hash': 'ODdCMUYycGVlcnBvbjIwOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602744',
                                                                                                                                          'fiber_length': 666,
                                                                                                                                          'poller_hash': 'ODdCOUQycGVlcnBvbjIzOC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '941551',
                                                                                                                                          'fiber_length': 676,
                                                                                                                                          'poller_hash': 'ODdCQUVBcGVlcnBvbjIzOS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'poller_hash': 'ODdCQTREcGVlcnBvbjI0NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602749',
                                                                                                                                          'fiber_length': 847,
                                                                                                                                          'poller_hash': 'ODdCOEZCcGVlcnBvbjI1MC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.4,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602734',
                                                                                                                                          'fiber_length': 730,
                                                                                                                                          'poller_hash': 'ODdCRUU4cGVlcnBvbjI3MS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602765',
                                                                                                                                          'fiber_length': 877,
                                                                                                                                          'poller_hash': 'ODdCODdGcGVlcnBvbjI3NS9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909},
                                                                                                                                  {       'connected_time': '2602737',
                                                                                                                                          'fiber_length': 880,
                                                                                                                                          'poller_hash': 'ODdCMjQzcGVlcnBvbjI3OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.719909}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010111',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '362746',
                                                                                         'in_octets': '3953642385366',
                                                                                         'in_ucast_pkts': '13746053336',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '51392811113',
                                                                                                                  'in_octets': '51873366361',
                                                                                                                  'in_ucast_pkts': '480555248',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '2034396664603',
                                                                                                                  'out_octets': '2035794948716',
                                                                                                                  'out_ucast_pkts': '1398284113',
                                                                                                                  'poller_hash': 'ODdCMjhGcGVlcmludGYxNC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '2676359314',
                                                                                                                  'in_octets': '2690566459',
                                                                                                                  'in_ucast_pkts': '14207145',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '27747644004',
                                                                                                                  'out_octets': '27771590427',
                                                                                                                  'out_ucast_pkts': '23946423',
                                                                                                                  'poller_hash': 'ODdCMTVFcGVlcmludGYxNS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '449172508129',
                                                                                                                  'in_octets': '450503066422',
                                                                                                                  'in_ucast_pkts': '1330558293',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3991993242239',
                                                                                                                  'out_octets': '3994905242246',
                                                                                                                  'out_ucast_pkts': '2912000007',
                                                                                                                  'poller_hash': 'ODdCMUJBcGVlcmludGYxOS9ncDE='},
                                                                                                          {       'in_errors': '97679',
                                                                                                                  'in_nucast_pkts': '10031335944',
                                                                                                                  'in_octets': '10112626602',
                                                                                                                  'in_ucast_pkts': '81290658',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '240385975732',
                                                                                                                  'out_octets': '240553378831',
                                                                                                                  'out_ucast_pkts': '167403099',
                                                                                                                  'poller_hash': 'ODdCMkEzcGVlcmludGYyMC9ncDE='},
                                                                                                          {       'oper_up': False,
                                                                                                                  'poller_hash': 'ODdCMTVCcGVlcmludGYyMS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '59366523330',
                                                                                                                  'in_octets': '59763908040',
                                                                                                                  'in_ucast_pkts': '397384710',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1263736867846',
                                                                                                                  'out_octets': '1264675830558',
                                                                                                                  'out_ucast_pkts': '938962712',
                                                                                                                  'poller_hash': 'ODdCMjQxcGVlcmludGYyMi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '106043069790',
                                                                                                                  'in_octets': '106203064992',
                                                                                                                  'in_ucast_pkts': '159995202',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '328493167059',
                                                                                                                  'out_octets': '328769300119',
                                                                                                                  'out_ucast_pkts': '276133060',
                                                                                                                  'poller_hash': 'ODdCMjczcGVlcmludGYyMy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '137154204584',
                                                                                                                  'in_octets': '137420960322',
                                                                                                                  'in_ucast_pkts': '266755738',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '479915842340',
                                                                                                                  'out_octets': '480303377529',
                                                                                                                  'out_ucast_pkts': '387535189',
                                                                                                                  'poller_hash': 'ODdCMjRCcGVlcmludGYyNC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '7622062298',
                                                                                                                  'in_octets': '7649829775',
                                                                                                                  'in_ucast_pkts': '27767477',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '280199365008',
                                                                                                                  'out_octets': '280394304998',
                                                                                                                  'out_ucast_pkts': '194939990',
                                                                                                                  'poller_hash': 'ODdCMjU1cGVlcmludGYyNi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '26193385025',
                                                                                                                  'in_octets': '26355312223',
                                                                                                                  'in_ucast_pkts': '161927198',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1102450736741',
                                                                                                                  'out_octets': '1103202710819',
                                                                                                                  'out_ucast_pkts': '751974078',
                                                                                                                  'poller_hash': 'ODdCMjdFcGVlcmludGYzMS9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '294572270',
                                                                                                                  'in_octets': '294572270',
                                                                                                                  'in_ucast_pkts': '0',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '512',
                                                                                                                  'out_octets': '512',
                                                                                                                  'out_ucast_pkts': '0',
                                                                                                                  'poller_hash': 'ODdCQUFCcGVlcmludGYzNy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '4255656914',
                                                                                                                  'in_octets': '4274333284',
                                                                                                                  'in_ucast_pkts': '18676370',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '54161735242',
                                                                                                                  'out_octets': '54206743242',
                                                                                                                  'out_ucast_pkts': '45008000',
                                                                                                                  'poller_hash': 'ODdCOTAzcGVlcmludGY2Ni9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '162416227175',
                                                                                                                  'in_octets': '162658535692',
                                                                                                                  'in_ucast_pkts': '242308517',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '471857319687',
                                                                                                                  'out_octets': '472219907181',
                                                                                                                  'out_ucast_pkts': '362587494',
                                                                                                                  'poller_hash': 'ODdCMUJDcGVlcmludGYxNzYvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1677354987',
                                                                                                                  'in_octets': '1681439901',
                                                                                                                  'in_ucast_pkts': '4084914',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3440837468',
                                                                                                                  'out_octets': '3446064291',
                                                                                                                  'out_ucast_pkts': '5226823',
                                                                                                                  'poller_hash': 'ODdCQTU4cGVlcmludGYyMzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '71642054',
                                                                                                                  'in_octets': '72400596',
                                                                                                                  'in_ucast_pkts': '758542',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '3655845690',
                                                                                                                  'out_octets': '3658345029',
                                                                                                                  'out_ucast_pkts': '2499339',
                                                                                                                  'poller_hash': 'ODdCOUU3cGVlcmludGYyNzMvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '12281552992',
                                                                                                                  'in_octets': '12355555387',
                                                                                                                  'in_ucast_pkts': '74002395',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '179492822804',
                                                                                                                  'out_octets': '179629101281',
                                                                                                                  'out_ucast_pkts': '136278477',
                                                                                                                  'poller_hash': 'ODdCQUU0cGVlcmludGZzb25hcl9pdGVtXzI1OTQvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:17',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp7',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '918',
                                                                                         'out_octets': '47874105883351',
                                                                                         'out_ucast_pkts': '34147757199',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3',
                                                                                         'pons': [       {       'id': '120010111',
                                                                                                                 'links': [       {       'connected_time': '2602735',
                                                                                                                                          'fiber_length': 357,
                                                                                                                                          'poller_hash': 'ODdCMjhGcGVlcnBvbjE0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.0,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2602721',
                                                                                                                                          'fiber_length': 370,
                                                                                                                                          'poller_hash': 'ODdCMTVFcGVlcnBvbjE1L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -20.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2602708',
                                                                                                                                          'fiber_length': 408,
                                                                                                                                          'poller_hash': 'ODdCMUJBcGVlcnBvbjE5L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '321365',
                                                                                                                                          'fiber_length': 465,
                                                                                                                                          'poller_hash': 'ODdCMkEzcGVlcnBvbjIwL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.1,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'poller_hash': 'ODdCMTVCcGVlcnBvbjIxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2602663',
                                                                                                                                          'fiber_length': 858,
                                                                                                                                          'poller_hash': 'ODdCMjQxcGVlcnBvbjIyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '1999708',
                                                                                                                                          'fiber_length': 811,
                                                                                                                                          'poller_hash': 'ODdCMjczcGVlcnBvbjIzL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '6837726',
                                                                                                                                          'fiber_length': 410,
                                                                                                                                          'poller_hash': 'ODdCMjRCcGVlcnBvbjI0L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '876619',
                                                                                                                                          'fiber_length': 415,
                                                                                                                                          'poller_hash': 'ODdCMjU1cGVlcnBvbjI2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -27.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2602684',
                                                                                                                                          'fiber_length': 819,
                                                                                                                                          'poller_hash': 'ODdCMjdFcGVlcnBvbjMxL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2602656',
                                                                                                                                          'fiber_length': 766,
                                                                                                                                          'poller_hash': 'ODdCQUFCcGVlcnBvbjM3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.6,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2602728',
                                                                                                                                          'fiber_length': 501,
                                                                                                                                          'poller_hash': 'ODdCOTAzcGVlcnBvbjY2L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2602682',
                                                                                                                                          'fiber_length': 764,
                                                                                                                                          'poller_hash': 'ODdCMUJDcGVlcnBvbjE3Ni9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.8,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '2602690',
                                                                                                                                          'fiber_length': 848,
                                                                                                                                          'poller_hash': 'ODdCQTU4cGVlcnBvbjIzMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '6895',
                                                                                                                                          'fiber_length': 408,
                                                                                                                                          'poller_hash': 'ODdCOUU3cGVlcnBvbjI3My9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -15.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342},
                                                                                                                                  {       'connected_time': '613885',
                                                                                                                                          'fiber_length': 373,
                                                                                                                                          'poller_hash': 'ODdCQUU0cGVlcnBvbnNvbmFyX2l0ZW1fMjU5NC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -16.2,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.778342}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]},
                                                                                 {       'admin_up': True,
                                                                                         'id': '120010112',
                                                                                         'in_discards': '0',
                                                                                         'in_errors': '0',
                                                                                         'in_nucast_pkts': '10263402',
                                                                                         'in_octets': '1679270126311',
                                                                                         'in_ucast_pkts': '2788454412',
                                                                                         'in_unknown_protos': '0',
                                                                                         'links': [       {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '3892479829',
                                                                                                                  'in_octets': '3923295030',
                                                                                                                  'in_ucast_pkts': '30815201',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '146842533469',
                                                                                                                  'out_octets': '146944561734',
                                                                                                                  'out_ucast_pkts': '102028265',
                                                                                                                  'poller_hash': 'ODdCMjRFcGVlcmludGYyNy9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '1250755556',
                                                                                                                  'in_octets': '1256889941',
                                                                                                                  'in_ucast_pkts': '6134385',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '12480869494',
                                                                                                                  'out_octets': '12491563137',
                                                                                                                  'out_ucast_pkts': '10693643',
                                                                                                                  'poller_hash': 'ODdCMjFEcGVlcmludGYyOC9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '51216705647',
                                                                                                                  'in_octets': '51341036598',
                                                                                                                  'in_ucast_pkts': '124330951',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '557398464686',
                                                                                                                  'out_octets': '557815774607',
                                                                                                                  'out_ucast_pkts': '417309921',
                                                                                                                  'poller_hash': 'ODdCOUIzcGVlcmludGY5Mi9ncDE='},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '266288008968',
                                                                                                                  'in_octets': '266735178968',
                                                                                                                  'in_ucast_pkts': '447170000',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '1217230449975',
                                                                                                                  'out_octets': '1218125455407',
                                                                                                                  'out_ucast_pkts': '895005432',
                                                                                                                  'poller_hash': 'ODdCQUVCcGVlcmludGYxMjQvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '15159442923',
                                                                                                                  'in_octets': '15203368389',
                                                                                                                  'in_ucast_pkts': '43925466',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '112737527757',
                                                                                                                  'out_octets': '112832220246',
                                                                                                                  'out_ucast_pkts': '94692489',
                                                                                                                  'poller_hash': 'ODdCOURGcGVlcmludGYxMzIvZ3Ax'},
                                                                                                          {       'in_errors': '0',
                                                                                                                  'in_nucast_pkts': '5161925054',
                                                                                                                  'in_octets': '5180784452',
                                                                                                                  'in_ucast_pkts': '18859398',
                                                                                                                  'oper_up': True,
                                                                                                                  'out_errors': '0',
                                                                                                                  'out_nucast_pkts': '54606879094',
                                                                                                                  'out_octets': '54656536565',
                                                                                                                  'out_ucast_pkts': '49657471',
                                                                                                                  'poller_hash': 'ODdCMjY0cGVlcmludGYxNTgvZ3Ax'}],
                                                                                         'mac_address': '48:77:46:53:46:18',
                                                                                         'manufacturer': 'Calix',
                                                                                         'model': '100-05148',
                                                                                         'name': '1/2/gp8',
                                                                                         'oper_up': True,
                                                                                         'out_discards': '0',
                                                                                         'out_errors': '0',
                                                                                         'out_nucast_pkts': '294',
                                                                                         'out_octets': '7596209594789',
                                                                                         'out_ucast_pkts': '5667260481',
                                                                                         'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTgxLzIvZ3A4',
                                                                                         'pons': [       {       'id': '120010112',
                                                                                                                 'links': [       {       'connected_time': '2602714',
                                                                                                                                          'fiber_length': 318,
                                                                                                                                          'poller_hash': 'ODdCMjRFcGVlcnBvbjI3L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -13.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391},
                                                                                                                                  {       'connected_time': '2602723',
                                                                                                                                          'fiber_length': 363,
                                                                                                                                          'poller_hash': 'ODdCMjFEcGVlcnBvbjI4L2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -24.7,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391},
                                                                                                                                  {       'connected_time': '2602716',
                                                                                                                                          'fiber_length': 456,
                                                                                                                                          'poller_hash': 'ODdCOUIzcGVlcnBvbjkyL2dwMQ==',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391},
                                                                                                                                  {       'connected_time': '2602739',
                                                                                                                                          'fiber_length': 472,
                                                                                                                                          'poller_hash': 'ODdCQUVCcGVlcnBvbjEyNC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -18.3,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391},
                                                                                                                                  {       'connected_time': '2602736',
                                                                                                                                          'fiber_length': 455,
                                                                                                                                          'poller_hash': 'ODdCOURGcGVlcnBvbjEzMi9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -17.9,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391},
                                                                                                                                  {       'connected_time': '2602734',
                                                                                                                                          'fiber_length': 422,
                                                                                                                                          'poller_hash': 'ODdCMjY0cGVlcnBvbjE1OC9ncDE=',
                                                                                                                                          'rx_link_rate': '1244160000',
                                                                                                                                          'rx_power': -14.5,
                                                                                                                                          'tx_link_rate': '2488320000',
                                                                                                                                          'tx_power': 3.699391}],
                                                                                                                 'max_distance': 20000,
                                                                                                                 'poller_hash': 'NDg3NzQ2NTM0NjE4MTIwMDEwMTEy',
                                                                                                                 'pon_technology': 'GPON',
                                                                                                                 'rx_link_rate': '1244160000',
                                                                                                                 'split_ratio': 64,
                                                                                                                 'tx_link_rate': '2488320000'}]}],
                                                           'manufacturer': 'Calix',
                                                           'mem': 46.0,
                                                           'model': 'GPON-8 r2',
                                                           'name': '1/2',
                                                           'poller_hash': 'NDcyMDA0MDA3NTc5',
                                                           'serial_number': '472004007579',
                                                           'sw_version': '23.2.0',
                                                           'temperature': 24.0,
                                                           'uptime': '9981360'}],
                                'serial_number': '071904929255',
                                'sw_version': '23.2.0',
                                'system_mac_address': '00:02:5d:fe:73:6a'},
                'peers': [       {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000161',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '51392811113',
                                                                       'in_octets': '51873366361',
                                                                       'in_ucast_pkts': '480555248',
                                                                       'mac_address': 'd0:76:8f:1f:d9:ad',
                                                                       'mtu': 2000,
                                                                       'name': '14/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2034396664603',
                                                                       'out_octets': '2035794948716',
                                                                       'out_ucast_pkts': '1398284113',
                                                                       'poller_hash': 'ODdCMjhGcGVlcmludGYxNC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '14',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2034396664603',
                                                                       'in_octets': '2035794948716',
                                                                       'in_ucast_pkts': '1398284113',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '2034396664603',
                                                                                                'in_octets': '2035794948716',
                                                                                                'in_ucast_pkts': '1398284113',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '51392811113',
                                                                                                'out_octets': '51873366361',
                                                                                                'out_ucast_pkts': '480555248',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '14/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '51392811113',
                                                                       'out_octets': '51873366361',
                                                                       'out_ucast_pkts': '480555248',
                                                                       'poller_hash': 'ODdCMjhGcGVlcmludGYxNC9ncDE=',
                                                                       'pons': [       {       'id': '14',
                                                                                               'links': [       {       'connected_time': '2602735',
                                                                                                                        'fiber_length': 357,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMjhGcGVlcnBvbjE0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 14',
                                         'poller_hash': 'ODdCMjhG',
                                         'serial_number': '87B28F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d9:ad',
                                         'uptime': '2602735'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000193',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2676359314',
                                                                       'in_octets': '2690566459',
                                                                       'in_ucast_pkts': '14207145',
                                                                       'mac_address': 'd0:76:8f:1f:d6:1a',
                                                                       'mtu': 2000,
                                                                       'name': '15/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '27747644004',
                                                                       'out_octets': '27771590427',
                                                                       'out_ucast_pkts': '23946423',
                                                                       'poller_hash': 'ODdCMTVFcGVlcmludGYxNS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '15',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '27747644004',
                                                                       'in_octets': '27771590427',
                                                                       'in_ucast_pkts': '23946423',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '27747644004',
                                                                                                'in_octets': '27771590427',
                                                                                                'in_ucast_pkts': '23946423',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2676359314',
                                                                                                'out_octets': '2690566459',
                                                                                                'out_ucast_pkts': '14207145',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '15/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2676359314',
                                                                       'out_octets': '2690566459',
                                                                       'out_ucast_pkts': '14207145',
                                                                       'poller_hash': 'ODdCMTVFcGVlcmludGYxNS9ncDE=',
                                                                       'pons': [       {       'id': '15',
                                                                                               'links': [       {       'connected_time': '2602721',
                                                                                                                        'fiber_length': 370,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMTVFcGVlcnBvbjE1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 15',
                                         'poller_hash': 'ODdCMTVF',
                                         'serial_number': '87B15E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d6:1a',
                                         'uptime': '2602721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000321',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '449172508129',
                                                                       'in_octets': '450503066422',
                                                                       'in_ucast_pkts': '1330558293',
                                                                       'mac_address': 'd0:76:8f:1f:d7:2e',
                                                                       'mtu': 2000,
                                                                       'name': '19/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3991993242239',
                                                                       'out_octets': '3994905242246',
                                                                       'out_ucast_pkts': '2912000007',
                                                                       'poller_hash': 'ODdCMUJBcGVlcmludGYxOS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '19',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3991993242239',
                                                                       'in_octets': '3994905242246',
                                                                       'in_ucast_pkts': '2912000007',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '3991993242239',
                                                                                                'in_octets': '3994905242246',
                                                                                                'in_ucast_pkts': '2912000007',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '449172508129',
                                                                                                'out_octets': '450503066422',
                                                                                                'out_ucast_pkts': '1330558293',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '19/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '449172508129',
                                                                       'out_octets': '450503066422',
                                                                       'out_ucast_pkts': '1330558293',
                                                                       'poller_hash': 'ODdCMUJBcGVlcmludGYxOS9ncDE=',
                                                                       'pons': [       {       'id': '19',
                                                                                               'links': [       {       'connected_time': '2602708',
                                                                                                                        'fiber_length': 408,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMUJBcGVlcnBvbjE5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 19',
                                         'poller_hash': 'ODdCMUJB',
                                         'serial_number': '87B1BA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d7:2e',
                                         'uptime': '2602708'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000353',
                                                                       'in_errors': '97679',
                                                                       'in_nucast_pkts': '10031335944',
                                                                       'in_octets': '10112626602',
                                                                       'in_ucast_pkts': '81290658',
                                                                       'mac_address': 'd0:76:8f:1f:d9:e9',
                                                                       'mtu': 2000,
                                                                       'name': '20/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '240385975732',
                                                                       'out_octets': '240553378831',
                                                                       'out_ucast_pkts': '167403099',
                                                                       'poller_hash': 'ODdCMkEzcGVlcmludGYyMC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '20',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '240385975732',
                                                                       'in_octets': '240553378831',
                                                                       'in_ucast_pkts': '167403099',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '240385975732',
                                                                                                'in_octets': '240553378831',
                                                                                                'in_ucast_pkts': '167403099',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '97679',
                                                                                                'out_nucast_pkts': '10031335944',
                                                                                                'out_octets': '10112626602',
                                                                                                'out_ucast_pkts': '81290658',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '20/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '97679',
                                                                       'out_nucast_pkts': '10031335944',
                                                                       'out_octets': '10112626602',
                                                                       'out_ucast_pkts': '81290658',
                                                                       'poller_hash': 'ODdCMkEzcGVlcmludGYyMC9ncDE=',
                                                                       'pons': [       {       'id': '20',
                                                                                               'links': [       {       'connected_time': '321365',
                                                                                                                        'fiber_length': 465,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMkEzcGVlcnBvbjIwL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 20',
                                         'poller_hash': 'ODdCMkEz',
                                         'serial_number': '87B2A3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d9:e9',
                                         'uptime': '321365'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000385',
                                                                       'name': '21/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCMTVCcGVlcmludGYyMS9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '21',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '21/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCMTVCcGVlcmludGYyMS9ncDE=',
                                                                       'pons': [       {       'id': '21',
                                                                                               'links': [       {       'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMTVCcGVlcnBvbjIxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '0',
                                         'name': 'ont 21',
                                         'poller_hash': 'ODdCMTVC',
                                         'serial_number': '87B15B',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000417',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '59366523330',
                                                                       'in_octets': '59763908040',
                                                                       'in_ucast_pkts': '397384710',
                                                                       'mac_address': 'd0:76:8f:1f:d8:c3',
                                                                       'mtu': 2000,
                                                                       'name': '22/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1263736867846',
                                                                       'out_octets': '1264675830558',
                                                                       'out_ucast_pkts': '938962712',
                                                                       'poller_hash': 'ODdCMjQxcGVlcmludGYyMi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '22',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1263736867846',
                                                                       'in_octets': '1264675830558',
                                                                       'in_ucast_pkts': '938962712',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1263736867846',
                                                                                                'in_octets': '1264675830558',
                                                                                                'in_ucast_pkts': '938962712',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '59366523330',
                                                                                                'out_octets': '59763908040',
                                                                                                'out_ucast_pkts': '397384710',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '22/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '59366523330',
                                                                       'out_octets': '59763908040',
                                                                       'out_ucast_pkts': '397384710',
                                                                       'poller_hash': 'ODdCMjQxcGVlcmludGYyMi9ncDE=',
                                                                       'pons': [       {       'id': '22',
                                                                                               'links': [       {       'connected_time': '2602663',
                                                                                                                        'fiber_length': 858,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMjQxcGVlcnBvbjIyL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 22',
                                         'poller_hash': 'ODdCMjQx',
                                         'serial_number': '87B241',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d8:c3',
                                         'uptime': '2602663'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000449',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '106043069790',
                                                                       'in_octets': '106203064992',
                                                                       'in_ucast_pkts': '159995202',
                                                                       'mac_address': 'd0:76:8f:1f:d9:59',
                                                                       'mtu': 2000,
                                                                       'name': '23/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '328493167059',
                                                                       'out_octets': '328769300119',
                                                                       'out_ucast_pkts': '276133060',
                                                                       'poller_hash': 'ODdCMjczcGVlcmludGYyMy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '23',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '328493167059',
                                                                       'in_octets': '328769300119',
                                                                       'in_ucast_pkts': '276133060',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '328493167059',
                                                                                                'in_octets': '328769300119',
                                                                                                'in_ucast_pkts': '276133060',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '106043069790',
                                                                                                'out_octets': '106203064992',
                                                                                                'out_ucast_pkts': '159995202',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '23/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '106043069790',
                                                                       'out_octets': '106203064992',
                                                                       'out_ucast_pkts': '159995202',
                                                                       'poller_hash': 'ODdCMjczcGVlcmludGYyMy9ncDE=',
                                                                       'pons': [       {       'id': '23',
                                                                                               'links': [       {       'connected_time': '1999708',
                                                                                                                        'fiber_length': 811,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMjczcGVlcnBvbjIzL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 23',
                                         'poller_hash': 'ODdCMjcz',
                                         'serial_number': '87B273',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d9:59',
                                         'uptime': '1999708'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000481',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '137154204584',
                                                                       'in_octets': '137420960322',
                                                                       'in_ucast_pkts': '266755738',
                                                                       'mac_address': 'd0:76:8f:1f:d8:e1',
                                                                       'mtu': 2000,
                                                                       'name': '24/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '479915842340',
                                                                       'out_octets': '480303377529',
                                                                       'out_ucast_pkts': '387535189',
                                                                       'poller_hash': 'ODdCMjRCcGVlcmludGYyNC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '24',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '479915842340',
                                                                       'in_octets': '480303377529',
                                                                       'in_ucast_pkts': '387535189',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '479915842340',
                                                                                                'in_octets': '480303377529',
                                                                                                'in_ucast_pkts': '387535189',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '137154204584',
                                                                                                'out_octets': '137420960322',
                                                                                                'out_ucast_pkts': '266755738',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '24/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '137154204584',
                                                                       'out_octets': '137420960322',
                                                                       'out_ucast_pkts': '266755738',
                                                                       'poller_hash': 'ODdCMjRCcGVlcmludGYyNC9ncDE=',
                                                                       'pons': [       {       'id': '24',
                                                                                               'links': [       {       'connected_time': '6837726',
                                                                                                                        'fiber_length': 410,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMjRCcGVlcnBvbjI0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 24',
                                         'poller_hash': 'ODdCMjRC',
                                         'serial_number': '87B24B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d8:e1',
                                         'uptime': '6837726'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000545',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7622062298',
                                                                       'in_octets': '7649829775',
                                                                       'in_ucast_pkts': '27767477',
                                                                       'mac_address': 'd0:76:8f:1f:d8:ff',
                                                                       'mtu': 2000,
                                                                       'name': '26/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '280199365008',
                                                                       'out_octets': '280394304998',
                                                                       'out_ucast_pkts': '194939990',
                                                                       'poller_hash': 'ODdCMjU1cGVlcmludGYyNi9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '26',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '280199365008',
                                                                       'in_octets': '280394304998',
                                                                       'in_ucast_pkts': '194939990',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '280199365008',
                                                                                                'in_octets': '280394304998',
                                                                                                'in_ucast_pkts': '194939990',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '7622062298',
                                                                                                'out_octets': '7649829775',
                                                                                                'out_ucast_pkts': '27767477',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '26/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7622062298',
                                                                       'out_octets': '7649829775',
                                                                       'out_ucast_pkts': '27767477',
                                                                       'poller_hash': 'ODdCMjU1cGVlcmludGYyNi9ncDE=',
                                                                       'pons': [       {       'id': '26',
                                                                                               'links': [       {       'connected_time': '876619',
                                                                                                                        'fiber_length': 415,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -30.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMjU1cGVlcnBvbjI2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 26',
                                         'poller_hash': 'ODdCMjU1',
                                         'serial_number': '87B255',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d8:ff',
                                         'uptime': '876619'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000577',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3892479829',
                                                                       'in_octets': '3923295030',
                                                                       'in_ucast_pkts': '30815201',
                                                                       'mac_address': 'd0:76:8f:1f:d8:ea',
                                                                       'mtu': 2000,
                                                                       'name': '27/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '146842533469',
                                                                       'out_octets': '146944561734',
                                                                       'out_ucast_pkts': '102028265',
                                                                       'poller_hash': 'ODdCMjRFcGVlcmludGYyNy9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '27',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '146842533469',
                                                                       'in_octets': '146944561734',
                                                                       'in_ucast_pkts': '102028265',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '146842533469',
                                                                                                'in_octets': '146944561734',
                                                                                                'in_ucast_pkts': '102028265',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3892479829',
                                                                                                'out_octets': '3923295030',
                                                                                                'out_ucast_pkts': '30815201',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTgxLzIvZ3A4'}],
                                                                       'name': '27/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3892479829',
                                                                       'out_octets': '3923295030',
                                                                       'out_ucast_pkts': '30815201',
                                                                       'poller_hash': 'ODdCMjRFcGVlcmludGYyNy9ncDE=',
                                                                       'pons': [       {       'id': '27',
                                                                                               'links': [       {       'connected_time': '2602714',
                                                                                                                        'fiber_length': 318,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE4MTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMjRFcGVlcnBvbjI3L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 27',
                                         'poller_hash': 'ODdCMjRF',
                                         'serial_number': '87B24E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d8:ea',
                                         'uptime': '2602714'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000609',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1250755556',
                                                                       'in_octets': '1256889941',
                                                                       'in_ucast_pkts': '6134385',
                                                                       'mac_address': 'd0:76:8f:1f:d8:57',
                                                                       'mtu': 2000,
                                                                       'name': '28/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '12480869494',
                                                                       'out_octets': '12491563137',
                                                                       'out_ucast_pkts': '10693643',
                                                                       'poller_hash': 'ODdCMjFEcGVlcmludGYyOC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '28',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '12480869494',
                                                                       'in_octets': '12491563137',
                                                                       'in_ucast_pkts': '10693643',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '12480869494',
                                                                                                'in_octets': '12491563137',
                                                                                                'in_ucast_pkts': '10693643',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '1250755556',
                                                                                                'out_octets': '1256889941',
                                                                                                'out_ucast_pkts': '6134385',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTgxLzIvZ3A4'}],
                                                                       'name': '28/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1250755556',
                                                                       'out_octets': '1256889941',
                                                                       'out_ucast_pkts': '6134385',
                                                                       'poller_hash': 'ODdCMjFEcGVlcmludGYyOC9ncDE=',
                                                                       'pons': [       {       'id': '28',
                                                                                               'links': [       {       'connected_time': '2602723',
                                                                                                                        'fiber_length': 363,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE4MTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -24.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMjFEcGVlcnBvbjI4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 28',
                                         'poller_hash': 'ODdCMjFE',
                                         'serial_number': '87B21D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d8:57',
                                         'uptime': '2602723'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000641',
                                                                       'name': '29/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCMTk2cGVlcmludGYyOS9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '29',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '29/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCMTk2cGVlcmludGYyOS9ncDE=',
                                                                       'pons': [       {       'id': '29',
                                                                                               'links': [       {       'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMTk2cGVlcnBvbjI5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '0',
                                         'name': 'ont 29',
                                         'poller_hash': 'ODdCMTk2',
                                         'serial_number': '87B196',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000673',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '10813577359',
                                                                       'in_octets': '10895224847',
                                                                       'in_ucast_pkts': '81647488',
                                                                       'mac_address': 'd0:76:8f:1f:f0:6f',
                                                                       'mtu': 2000,
                                                                       'name': '30/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '376106960416',
                                                                       'out_octets': '376369747568',
                                                                       'out_ucast_pkts': '262787152',
                                                                       'poller_hash': 'ODdCQTI1cGVlcmludGYzMC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '30',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '376106960416',
                                                                       'in_octets': '376369747568',
                                                                       'in_ucast_pkts': '262787152',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '376106960416',
                                                                                                'in_octets': '376369747568',
                                                                                                'in_ucast_pkts': '262787152',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '10813577359',
                                                                                                'out_octets': '10895224847',
                                                                                                'out_ucast_pkts': '81647488',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '30/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '10813577359',
                                                                       'out_octets': '10895224847',
                                                                       'out_ucast_pkts': '81647488',
                                                                       'poller_hash': 'ODdCQTI1cGVlcmludGYzMC9ncDE=',
                                                                       'pons': [       {       'id': '30',
                                                                                               'links': [       {       'connected_time': '1552468',
                                                                                                                        'fiber_length': 540,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTI1cGVlcnBvbjMwL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 30',
                                         'poller_hash': 'ODdCQTI1',
                                         'serial_number': '87BA25',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:6f',
                                         'uptime': '1552468'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000705',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '26193385025',
                                                                       'in_octets': '26355312223',
                                                                       'in_ucast_pkts': '161927198',
                                                                       'mac_address': 'd0:76:8f:1f:d9:7a',
                                                                       'mtu': 2000,
                                                                       'name': '31/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1102450736741',
                                                                       'out_octets': '1103202710819',
                                                                       'out_ucast_pkts': '751974078',
                                                                       'poller_hash': 'ODdCMjdFcGVlcmludGYzMS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '31',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1102450736741',
                                                                       'in_octets': '1103202710819',
                                                                       'in_ucast_pkts': '751974078',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1102450736741',
                                                                                                'in_octets': '1103202710819',
                                                                                                'in_ucast_pkts': '751974078',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '26193385025',
                                                                                                'out_octets': '26355312223',
                                                                                                'out_ucast_pkts': '161927198',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '31/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '26193385025',
                                                                       'out_octets': '26355312223',
                                                                       'out_ucast_pkts': '161927198',
                                                                       'poller_hash': 'ODdCMjdFcGVlcmludGYzMS9ncDE=',
                                                                       'pons': [       {       'id': '31',
                                                                                               'links': [       {       'connected_time': '2602684',
                                                                                                                        'fiber_length': 819,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCMjdFcGVlcnBvbjMxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 31',
                                         'poller_hash': 'ODdCMjdF',
                                         'serial_number': '87B27E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:d9:7a',
                                         'uptime': '2602684'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000769',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '33745979636',
                                                                       'in_octets': '33812753197',
                                                                       'in_ucast_pkts': '66773561',
                                                                       'mac_address': 'd0:76:8f:1f:f1:d7',
                                                                       'mtu': 2000,
                                                                       'name': '33/g1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '180686420600',
                                                                       'out_octets': '180841283715',
                                                                       'out_ucast_pkts': '154863115',
                                                                       'poller_hash': 'ODdCQTlEcGVlcmludGYzMy9nMQ==',
                                                                       'speed': '0'},
                                                               {       'admin_up': True,
                                                                       'id': '33',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '180686420600',
                                                                       'in_octets': '180841283715',
                                                                       'in_ucast_pkts': '154863115',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '180686420600',
                                                                                                'in_octets': '180841283715',
                                                                                                'in_ucast_pkts': '154863115',
                                                                                                'oper_up': False,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '33745979636',
                                                                                                'out_octets': '33812753197',
                                                                                                'out_ucast_pkts': '66773561',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '33/gp1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '33745979636',
                                                                       'out_octets': '33812753197',
                                                                       'out_ucast_pkts': '66773561',
                                                                       'poller_hash': 'ODdCQTlEcGVlcmludGYzMy9ncDE=',
                                                                       'pons': [       {       'id': '33',
                                                                                               'links': [       {       'connected_time': '2602723',
                                                                                                                        'fiber_length': 611,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTlEcGVlcnBvbjMzL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 33',
                                         'poller_hash': 'ODdCQTlE',
                                         'serial_number': '87BA9D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:d7',
                                         'uptime': '2602723'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000801',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '8795012504',
                                                                       'in_octets': '8832899382',
                                                                       'in_ucast_pkts': '37886878',
                                                                       'mac_address': 'd0:76:8f:1f:f2:31',
                                                                       'mtu': 2000,
                                                                       'name': '34/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '167180060889',
                                                                       'out_octets': '167300049316',
                                                                       'out_ucast_pkts': '119988427',
                                                                       'poller_hash': 'ODdCQUJCcGVlcmludGYzNC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '34',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '167180060889',
                                                                       'in_octets': '167300049316',
                                                                       'in_ucast_pkts': '119988427',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '167180060889',
                                                                                                'in_octets': '167300049316',
                                                                                                'in_ucast_pkts': '119988427',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '8795012504',
                                                                                                'out_octets': '8832899382',
                                                                                                'out_ucast_pkts': '37886878',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '34/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '8795012504',
                                                                       'out_octets': '8832899382',
                                                                       'out_ucast_pkts': '37886878',
                                                                       'poller_hash': 'ODdCQUJCcGVlcmludGYzNC9ncDE=',
                                                                       'pons': [       {       'id': '34',
                                                                                               'links': [       {       'connected_time': '2602725',
                                                                                                                        'fiber_length': 965,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQUJCcGVlcnBvbjM0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 34',
                                         'poller_hash': 'ODdCQUJC',
                                         'serial_number': '87BABB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f2:31',
                                         'uptime': '2602725'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000833',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '44520811161',
                                                                       'in_octets': '44683078820',
                                                                       'in_ucast_pkts': '162267659',
                                                                       'mac_address': 'd0:76:8f:1f:f0:48',
                                                                       'mtu': 2000,
                                                                       'name': '35/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '812002721064',
                                                                       'out_octets': '812561541758',
                                                                       'out_ucast_pkts': '558820694',
                                                                       'poller_hash': 'ODdCQTE4cGVlcmludGYzNS9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '35',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '812002721064',
                                                                       'in_octets': '812561541758',
                                                                       'in_ucast_pkts': '558820694',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '812002721064',
                                                                                                'in_octets': '812561541758',
                                                                                                'in_ucast_pkts': '558820694',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '1',
                                                                                                'out_nucast_pkts': '44520811161',
                                                                                                'out_octets': '44683078820',
                                                                                                'out_ucast_pkts': '162267659',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '35/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '1',
                                                                       'out_nucast_pkts': '44520811161',
                                                                       'out_octets': '44683078820',
                                                                       'out_ucast_pkts': '162267659',
                                                                       'poller_hash': 'ODdCQTE4cGVlcmludGYzNS9ncDE=',
                                                                       'pons': [       {       'id': '35',
                                                                                               'links': [       {       'connected_time': '2602718',
                                                                                                                        'fiber_length': 914,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTE4cGVlcnBvbjM1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 35',
                                         'poller_hash': 'ODdCQTE4',
                                         'serial_number': '87BA18',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:48',
                                         'uptime': '2602718'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000865',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '27325840296',
                                                                       'in_octets': '27404722645',
                                                                       'in_ucast_pkts': '78882349',
                                                                       'mac_address': 'd0:76:8f:1f:f1:f8',
                                                                       'mtu': 2000,
                                                                       'name': '36/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '214891773406',
                                                                       'out_octets': '215063823291',
                                                                       'out_ucast_pkts': '172049885',
                                                                       'poller_hash': 'ODdCQUE4cGVlcmludGYzNi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '36',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '214891773406',
                                                                       'in_octets': '215063823291',
                                                                       'in_ucast_pkts': '172049885',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '214891773406',
                                                                                                'in_octets': '215063823291',
                                                                                                'in_ucast_pkts': '172049885',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '27325840296',
                                                                                                'out_octets': '27404722645',
                                                                                                'out_ucast_pkts': '78882349',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '36/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '27325840296',
                                                                       'out_octets': '27404722645',
                                                                       'out_ucast_pkts': '78882349',
                                                                       'poller_hash': 'ODdCQUE4cGVlcmludGYzNi9ncDE=',
                                                                       'pons': [       {       'id': '36',
                                                                                               'links': [       {       'connected_time': '2602718',
                                                                                                                        'fiber_length': 815,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQUE4cGVlcnBvbjM2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 36',
                                         'poller_hash': 'ODdCQUE4',
                                         'serial_number': '87BAA8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:f8',
                                         'uptime': '2602718'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000897',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '294572270',
                                                                       'in_octets': '294572270',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': 'd0:76:8f:1f:f2:01',
                                                                       'mtu': 2000,
                                                                       'name': '37/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '512',
                                                                       'out_octets': '512',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ODdCQUFCcGVlcmludGYzNy9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '37',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '512',
                                                                       'in_octets': '512',
                                                                       'in_ucast_pkts': '0',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '512',
                                                                                                'in_octets': '512',
                                                                                                'in_ucast_pkts': '0',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '294572270',
                                                                                                'out_octets': '294572270',
                                                                                                'out_ucast_pkts': '0',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '37/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '294572270',
                                                                       'out_octets': '294572270',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ODdCQUFCcGVlcmludGYzNy9ncDE=',
                                                                       'pons': [       {       'id': '37',
                                                                                               'links': [       {       'connected_time': '2602656',
                                                                                                                        'fiber_length': 766,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQUFCcGVlcnBvbjM3L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 37',
                                         'poller_hash': 'ODdCQUFC',
                                         'serial_number': '87BAAB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f2:01',
                                         'uptime': '2602656'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1000929',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7299285953',
                                                                       'in_octets': '7350657434',
                                                                       'in_ucast_pkts': '51371481',
                                                                       'mac_address': 'd0:76:8f:1f:f2:10',
                                                                       'mtu': 2000,
                                                                       'name': '38/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '283580611761',
                                                                       'out_octets': '283776069286',
                                                                       'out_ucast_pkts': '195457525',
                                                                       'poller_hash': 'ODdCQUIwcGVlcmludGYzOC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '38',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '283580611761',
                                                                       'in_octets': '283776069286',
                                                                       'in_ucast_pkts': '195457525',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '283580611761',
                                                                                                'in_octets': '283776069286',
                                                                                                'in_ucast_pkts': '195457525',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '7299285953',
                                                                                                'out_octets': '7350657434',
                                                                                                'out_ucast_pkts': '51371481',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '38/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7299285953',
                                                                       'out_octets': '7350657434',
                                                                       'out_ucast_pkts': '51371481',
                                                                       'poller_hash': 'ODdCQUIwcGVlcmludGYzOC9ncDE=',
                                                                       'pons': [       {       'id': '38',
                                                                                               'links': [       {       'connected_time': '1913554',
                                                                                                                        'fiber_length': 844,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQUIwcGVlcnBvbjM4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 38',
                                         'poller_hash': 'ODdCQUIw',
                                         'serial_number': '87BAB0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f2:10',
                                         'uptime': '1913554'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001025',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '21255200458',
                                                                       'in_octets': '21292914037',
                                                                       'in_ucast_pkts': '37713579',
                                                                       'mac_address': 'd0:76:8f:1f:f1:a7',
                                                                       'mtu': 2000,
                                                                       'name': '41/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '139249043723',
                                                                       'out_octets': '139366242684',
                                                                       'out_ucast_pkts': '117198961',
                                                                       'poller_hash': 'ODdCQThEcGVlcmludGY0MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '41',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '139249043723',
                                                                       'in_octets': '139366242684',
                                                                       'in_ucast_pkts': '117198961',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '139249043723',
                                                                                                'in_octets': '139366242684',
                                                                                                'in_ucast_pkts': '117198961',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '21255200458',
                                                                                                'out_octets': '21292914037',
                                                                                                'out_ucast_pkts': '37713579',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '41/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '21255200458',
                                                                       'out_octets': '21292914037',
                                                                       'out_ucast_pkts': '37713579',
                                                                       'poller_hash': 'ODdCQThEcGVlcmludGY0MS9ncDE=',
                                                                       'pons': [       {       'id': '41',
                                                                                               'links': [       {       'connected_time': '2602732',
                                                                                                                        'fiber_length': 842,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQThEcGVlcnBvbjQxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 41',
                                         'poller_hash': 'ODdCQThE',
                                         'serial_number': '87BA8D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:a7',
                                         'uptime': '2602732'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001057',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14298568438',
                                                                       'in_octets': '14363264045',
                                                                       'in_ucast_pkts': '64695607',
                                                                       'mac_address': 'd0:76:8f:1f:f1:fb',
                                                                       'mtu': 2000,
                                                                       'name': '42/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '307873430243',
                                                                       'out_octets': '308114506593',
                                                                       'out_ucast_pkts': '241076350',
                                                                       'poller_hash': 'ODdCQUE5cGVlcmludGY0Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '42',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '307873430243',
                                                                       'in_octets': '308114506593',
                                                                       'in_ucast_pkts': '241076350',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '307873430243',
                                                                                                'in_octets': '308114506593',
                                                                                                'in_ucast_pkts': '241076350',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '14298568438',
                                                                                                'out_octets': '14363264045',
                                                                                                'out_ucast_pkts': '64695607',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '42/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '14298568438',
                                                                       'out_octets': '14363264045',
                                                                       'out_ucast_pkts': '64695607',
                                                                       'poller_hash': 'ODdCQUE5cGVlcmludGY0Mi9ncDE=',
                                                                       'pons': [       {       'id': '42',
                                                                                               'links': [       {       'connected_time': '2602727',
                                                                                                                        'fiber_length': 582,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQUE5cGVlcnBvbjQyL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 42',
                                         'poller_hash': 'ODdCQUE5',
                                         'serial_number': '87BAA9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:fb',
                                         'uptime': '2602727'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001121',
                                                                       'name': '44/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCOTQwcGVlcmludGY0NC9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '44',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '44/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCOTQwcGVlcmludGY0NC9ncDE=',
                                                                       'pons': [       {       'id': '44',
                                                                                               'links': [       {       'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOTQwcGVlcnBvbjQ0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '0',
                                         'name': 'ont 44',
                                         'poller_hash': 'ODdCOTQw',
                                         'serial_number': '87B940',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001185',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '24780720661',
                                                                       'in_octets': '24974132071',
                                                                       'in_ucast_pkts': '193411410',
                                                                       'mac_address': 'd0:76:8f:1f:ef:4c',
                                                                       'mtu': 2000,
                                                                       'name': '46/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1143527239378',
                                                                       'out_octets': '1144313862501',
                                                                       'out_ucast_pkts': '786623123',
                                                                       'poller_hash': 'ODdCOUM0cGVlcmludGY0Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '46',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1143527239378',
                                                                       'in_octets': '1144313862501',
                                                                       'in_ucast_pkts': '786623123',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1143527239378',
                                                                                                'in_octets': '1144313862501',
                                                                                                'in_ucast_pkts': '786623123',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '24780720661',
                                                                                                'out_octets': '24974132071',
                                                                                                'out_ucast_pkts': '193411410',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2UxLzEvZ3A2'}],
                                                                       'name': '46/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '24780720661',
                                                                       'out_octets': '24974132071',
                                                                       'out_ucast_pkts': '193411410',
                                                                       'poller_hash': 'ODdCOUM0cGVlcmludGY0Ni9ncDE=',
                                                                       'pons': [       {       'id': '46',
                                                                                               'links': [       {       'connected_time': '2602713',
                                                                                                                        'fiber_length': 1458,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNlMTEwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOUM0cGVlcnBvbjQ2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 46',
                                         'poller_hash': 'ODdCOUM0',
                                         'serial_number': '87B9C4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:4c',
                                         'uptime': '2602713'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001217',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '91534448530',
                                                                       'in_octets': '91752405575',
                                                                       'in_ucast_pkts': '217957045',
                                                                       'mac_address': 'd0:76:8f:1f:ef:ca',
                                                                       'mtu': 2000,
                                                                       'name': '47/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '886503968222',
                                                                       'out_octets': '887197640514',
                                                                       'out_ucast_pkts': '693672292',
                                                                       'poller_hash': 'ODdCOUVFcGVlcmludGY0Ny9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '47',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '886503968222',
                                                                       'in_octets': '887197640514',
                                                                       'in_ucast_pkts': '693672292',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '886503968222',
                                                                                                'in_octets': '887197640514',
                                                                                                'in_ucast_pkts': '693672292',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '91534448530',
                                                                                                'out_octets': '91752405575',
                                                                                                'out_ucast_pkts': '217957045',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '47/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '91534448530',
                                                                       'out_octets': '91752405575',
                                                                       'out_ucast_pkts': '217957045',
                                                                       'poller_hash': 'ODdCOUVFcGVlcmludGY0Ny9ncDE=',
                                                                       'pons': [       {       'id': '47',
                                                                                               'links': [       {       'connected_time': '2602731',
                                                                                                                        'fiber_length': 1357,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOUVFcGVlcnBvbjQ3L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 47',
                                         'poller_hash': 'ODdCOUVF',
                                         'serial_number': '87B9EE',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:ca',
                                         'uptime': '2602731'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001249',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14463635741',
                                                                       'in_octets': '14544326181',
                                                                       'in_ucast_pkts': '80690440',
                                                                       'mac_address': 'd0:76:8f:1f:ef:d3',
                                                                       'mtu': 2000,
                                                                       'name': '48/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '353228776591',
                                                                       'out_octets': '353491502642',
                                                                       'out_ucast_pkts': '262726051',
                                                                       'poller_hash': 'ODdCOUYxcGVlcmludGY0OC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '48',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '353228776591',
                                                                       'in_octets': '353491502642',
                                                                       'in_ucast_pkts': '262726051',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '353228776591',
                                                                                                'in_octets': '353491502642',
                                                                                                'in_ucast_pkts': '262726051',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '14463635741',
                                                                                                'out_octets': '14544326181',
                                                                                                'out_ucast_pkts': '80690440',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2YxLzEvZ3A3'}],
                                                                       'name': '48/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '14463635741',
                                                                       'out_octets': '14544326181',
                                                                       'out_ucast_pkts': '80690440',
                                                                       'poller_hash': 'ODdCOUYxcGVlcmludGY0OC9ncDE=',
                                                                       'pons': [       {       'id': '48',
                                                                                               'links': [       {       'connected_time': '2258629',
                                                                                                                        'fiber_length': 1340,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNmMTEwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOUYxcGVlcnBvbjQ4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 48',
                                         'poller_hash': 'ODdCOUYx',
                                         'serial_number': '87B9F1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:d3',
                                         'uptime': '2258629'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001281',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '46575945345',
                                                                       'in_octets': '46690824695',
                                                                       'in_ucast_pkts': '114879350',
                                                                       'mac_address': 'd0:76:8f:1f:ef:c7',
                                                                       'mtu': 2000,
                                                                       'name': '49/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '590863639413',
                                                                       'out_octets': '591289590737',
                                                                       'out_ucast_pkts': '425951324',
                                                                       'poller_hash': 'ODdCOUVEcGVlcmludGY0OS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '49',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '590863639413',
                                                                       'in_octets': '591289590737',
                                                                       'in_ucast_pkts': '425951324',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '590863639413',
                                                                                                'in_octets': '591289590737',
                                                                                                'in_ucast_pkts': '425951324',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '46575945345',
                                                                                                'out_octets': '46690824695',
                                                                                                'out_ucast_pkts': '114879350',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '49/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '46575945345',
                                                                       'out_octets': '46690824695',
                                                                       'out_ucast_pkts': '114879350',
                                                                       'poller_hash': 'ODdCOUVEcGVlcmludGY0OS9ncDE=',
                                                                       'pons': [       {       'id': '49',
                                                                                               'links': [       {       'connected_time': '2602738',
                                                                                                                        'fiber_length': 1230,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOUVEcGVlcnBvbjQ5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 49',
                                         'poller_hash': 'ODdCOUVE',
                                         'serial_number': '87B9ED',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:c7',
                                         'uptime': '2602738'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001345',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '18358074126',
                                                                       'in_octets': '18440662987',
                                                                       'in_ucast_pkts': '82588861',
                                                                       'mac_address': 'd0:76:8f:1f:ef:b8',
                                                                       'mtu': 2000,
                                                                       'name': '51/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '360786433875',
                                                                       'out_octets': '361050326269',
                                                                       'out_ucast_pkts': '263892394',
                                                                       'poller_hash': 'ODdCOUU4cGVlcmludGY1MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '51',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '360786433875',
                                                                       'in_octets': '361050326269',
                                                                       'in_ucast_pkts': '263892394',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '360786433875',
                                                                                                'in_octets': '361050326269',
                                                                                                'in_ucast_pkts': '263892394',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '18358074126',
                                                                                                'out_octets': '18440662987',
                                                                                                'out_ucast_pkts': '82588861',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '51/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '18358074126',
                                                                       'out_octets': '18440662987',
                                                                       'out_ucast_pkts': '82588861',
                                                                       'poller_hash': 'ODdCOUU4cGVlcmludGY1MS9ncDE=',
                                                                       'pons': [       {       'id': '51',
                                                                                               'links': [       {       'connected_time': '2602730',
                                                                                                                        'fiber_length': 1274,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOUU4cGVlcnBvbjUxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 51',
                                         'poller_hash': 'ODdCOUU4',
                                         'serial_number': '87B9E8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:b8',
                                         'uptime': '2602730'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001441',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '47133020808',
                                                                       'in_octets': '47360399629',
                                                                       'in_ucast_pkts': '227378821',
                                                                       'mac_address': 'd0:76:8f:1f:f0:09',
                                                                       'mtu': 2000,
                                                                       'name': '54/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1233341622741',
                                                                       'out_octets': '1234192684395',
                                                                       'out_ucast_pkts': '851061654',
                                                                       'poller_hash': 'ODdCQTAzcGVlcmludGY1NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '54',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1233341622741',
                                                                       'in_octets': '1234192684395',
                                                                       'in_ucast_pkts': '851061654',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1233341622741',
                                                                                                'in_octets': '1234192684395',
                                                                                                'in_ucast_pkts': '851061654',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '47133020808',
                                                                                                'out_octets': '47360399629',
                                                                                                'out_ucast_pkts': '227378821',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '54/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '47133020808',
                                                                       'out_octets': '47360399629',
                                                                       'out_ucast_pkts': '227378821',
                                                                       'poller_hash': 'ODdCQTAzcGVlcmludGY1NC9ncDE=',
                                                                       'pons': [       {       'id': '54',
                                                                                               'links': [       {       'connected_time': '2602738',
                                                                                                                        'fiber_length': 1377,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTAzcGVlcnBvbjU0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 54',
                                         'poller_hash': 'ODdCQTAz',
                                         'serial_number': '87BA03',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:09',
                                         'uptime': '2602738'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001473',
                                                                       'in_errors': '4',
                                                                       'in_nucast_pkts': '57195020186',
                                                                       'in_octets': '57610054798',
                                                                       'in_ucast_pkts': '415034612',
                                                                       'mac_address': 'd0:76:8f:1f:ef:e2',
                                                                       'mtu': 2000,
                                                                       'name': '55/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1481265763461',
                                                                       'out_octets': '1482264780757',
                                                                       'out_ucast_pkts': '999017296',
                                                                       'poller_hash': 'ODdCOUY2cGVlcmludGY1NS9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '55',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1481265763461',
                                                                       'in_octets': '1482264780757',
                                                                       'in_ucast_pkts': '999017296',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1481265763461',
                                                                                                'in_octets': '1482264780757',
                                                                                                'in_ucast_pkts': '999017296',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '4',
                                                                                                'out_nucast_pkts': '57195020186',
                                                                                                'out_octets': '57610054798',
                                                                                                'out_ucast_pkts': '415034612',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '55/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '4',
                                                                       'out_nucast_pkts': '57195020186',
                                                                       'out_octets': '57610054798',
                                                                       'out_ucast_pkts': '415034612',
                                                                       'poller_hash': 'ODdCOUY2cGVlcmludGY1NS9ncDE=',
                                                                       'pons': [       {       'id': '55',
                                                                                               'links': [       {       'connected_time': '2602713',
                                                                                                                        'fiber_length': 1242,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOUY2cGVlcnBvbjU1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 55',
                                         'poller_hash': 'ODdCOUY2',
                                         'serial_number': '87B9F6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:e2',
                                         'uptime': '2602713'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001537',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11464787629',
                                                                       'in_octets': '11542992389',
                                                                       'in_ucast_pkts': '78204760',
                                                                       'mac_address': 'd0:76:8f:1f:f0:12',
                                                                       'mtu': 2000,
                                                                       'name': '57/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '279947321178',
                                                                       'out_octets': '280159648116',
                                                                       'out_ucast_pkts': '212326938',
                                                                       'poller_hash': 'ODdCQTA2cGVlcmludGY1Ny9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '57',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '279947321178',
                                                                       'in_octets': '280159648116',
                                                                       'in_ucast_pkts': '212326938',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '279947321178',
                                                                                                'in_octets': '280159648116',
                                                                                                'in_ucast_pkts': '212326938',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '11464787629',
                                                                                                'out_octets': '11542992389',
                                                                                                'out_ucast_pkts': '78204760',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '57/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '11464787629',
                                                                       'out_octets': '11542992389',
                                                                       'out_ucast_pkts': '78204760',
                                                                       'poller_hash': 'ODdCQTA2cGVlcmludGY1Ny9ncDE=',
                                                                       'pons': [       {       'id': '57',
                                                                                               'links': [       {       'connected_time': '2258632',
                                                                                                                        'fiber_length': 1447,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTA2cGVlcnBvbjU3L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 57',
                                         'poller_hash': 'ODdCQTA2',
                                         'serial_number': '87BA06',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:12',
                                         'uptime': '2258632'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001569',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '9157551497',
                                                                       'in_octets': '9198996542',
                                                                       'in_ucast_pkts': '41445045',
                                                                       'mac_address': 'd0:76:8f:1f:ef:61',
                                                                       'mtu': 2000,
                                                                       'name': '58/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '161522803201',
                                                                       'out_octets': '161650587587',
                                                                       'out_ucast_pkts': '127784386',
                                                                       'poller_hash': 'ODdCOUNCcGVlcmludGY1OC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '58',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '161522803201',
                                                                       'in_octets': '161650587587',
                                                                       'in_ucast_pkts': '127784386',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '161522803201',
                                                                                                'in_octets': '161650587587',
                                                                                                'in_ucast_pkts': '127784386',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '9157551497',
                                                                                                'out_octets': '9198996542',
                                                                                                'out_ucast_pkts': '41445045',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2QxLzEvZ3A1'}],
                                                                       'name': '58/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '9157551497',
                                                                       'out_octets': '9198996542',
                                                                       'out_ucast_pkts': '41445045',
                                                                       'poller_hash': 'ODdCOUNCcGVlcmludGY1OC9ncDE=',
                                                                       'pons': [       {       'id': '58',
                                                                                               'links': [       {       'connected_time': '2602675',
                                                                                                                        'fiber_length': 1520,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNkMTEwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOUNCcGVlcnBvbjU4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 58',
                                         'poller_hash': 'ODdCOUNC',
                                         'serial_number': '87B9CB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:61',
                                         'uptime': '2602675'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001665',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '19753494143',
                                                                       'in_octets': '19846636169',
                                                                       'in_ucast_pkts': '93142026',
                                                                       'mac_address': 'd0:76:8f:1f:f0:0f',
                                                                       'mtu': 2000,
                                                                       'name': '61/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '520907256351',
                                                                       'out_octets': '521313399188',
                                                                       'out_ucast_pkts': '406142837',
                                                                       'poller_hash': 'ODdCQTA1cGVlcmludGY2MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '61',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '520907256351',
                                                                       'in_octets': '521313399188',
                                                                       'in_ucast_pkts': '406142837',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '520907256351',
                                                                                                'in_octets': '521313399188',
                                                                                                'in_ucast_pkts': '406142837',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '19753494143',
                                                                                                'out_octets': '19846636169',
                                                                                                'out_ucast_pkts': '93142026',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '61/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '19753494143',
                                                                       'out_octets': '19846636169',
                                                                       'out_ucast_pkts': '93142026',
                                                                       'poller_hash': 'ODdCQTA1cGVlcmludGY2MS9ncDE=',
                                                                       'pons': [       {       'id': '61',
                                                                                               'links': [       {       'connected_time': '2258646',
                                                                                                                        'fiber_length': 1417,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTA1cGVlcnBvbjYxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 61',
                                         'poller_hash': 'ODdCQTA1',
                                         'serial_number': '87BA05',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:0f',
                                         'uptime': '2258646'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001697',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2520208678',
                                                                       'in_octets': '2539747960',
                                                                       'in_ucast_pkts': '19539282',
                                                                       'mac_address': 'd0:76:8f:1f:ef:ee',
                                                                       'mtu': 2000,
                                                                       'name': '62/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '72767788369',
                                                                       'out_octets': '72819700223',
                                                                       'out_ucast_pkts': '51911854',
                                                                       'poller_hash': 'ODdCOUZBcGVlcmludGY2Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '62',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '72767788369',
                                                                       'in_octets': '72819700223',
                                                                       'in_ucast_pkts': '51911854',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '72767788369',
                                                                                                'in_octets': '72819700223',
                                                                                                'in_ucast_pkts': '51911854',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2520208678',
                                                                                                'out_octets': '2539747960',
                                                                                                'out_ucast_pkts': '19539282',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6YzkxLzEvZ3Ax'}],
                                                                       'name': '62/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2520208678',
                                                                       'out_octets': '2539747960',
                                                                       'out_ucast_pkts': '19539282',
                                                                       'poller_hash': 'ODdCOUZBcGVlcmludGY2Mi9ncDE=',
                                                                       'pons': [       {       'id': '62',
                                                                                               'links': [       {       'connected_time': '790548',
                                                                                                                        'fiber_length': 916,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGM5MTEwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOUZBcGVlcnBvbjYyL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 62',
                                         'poller_hash': 'ODdCOUZB',
                                         'serial_number': '87B9FA',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:ee',
                                         'uptime': '790548'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001729',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '40708693106',
                                                                       'in_octets': '40957415956',
                                                                       'in_ucast_pkts': '248722850',
                                                                       'mac_address': 'd0:76:8f:1f:f0:06',
                                                                       'mtu': 2000,
                                                                       'name': '63/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1124474365699',
                                                                       'out_octets': '1125259512848',
                                                                       'out_ucast_pkts': '785147149',
                                                                       'poller_hash': 'ODdCQTAycGVlcmludGY2My9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '63',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1124474365699',
                                                                       'in_octets': '1125259512848',
                                                                       'in_ucast_pkts': '785147149',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1124474365699',
                                                                                                'in_octets': '1125259512848',
                                                                                                'in_ucast_pkts': '785147149',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '40708693106',
                                                                                                'out_octets': '40957415956',
                                                                                                'out_ucast_pkts': '248722850',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2IxLzEvZ3Az'}],
                                                                       'name': '63/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '40708693106',
                                                                       'out_octets': '40957415956',
                                                                       'out_ucast_pkts': '248722850',
                                                                       'poller_hash': 'ODdCQTAycGVlcmludGY2My9ncDE=',
                                                                       'pons': [       {       'id': '63',
                                                                                               'links': [       {       'connected_time': '2602719',
                                                                                                                        'fiber_length': 1065,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNiMTEwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -11.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTAycGVlcnBvbjYzL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 63',
                                         'poller_hash': 'ODdCQTAy',
                                         'serial_number': '87BA02',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:06',
                                         'uptime': '2602719'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001761',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20156419018',
                                                                       'in_octets': '20365855253',
                                                                       'in_ucast_pkts': '209436235',
                                                                       'mac_address': 'd0:76:8f:1f:ec:d0',
                                                                       'mtu': 2000,
                                                                       'name': '64/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1587439981848',
                                                                       'out_octets': '1588533886120',
                                                                       'out_ucast_pkts': '1093904272',
                                                                       'poller_hash': 'ODdCOEYwcGVlcmludGY2NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '64',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1587439981848',
                                                                       'in_octets': '1588533886120',
                                                                       'in_ucast_pkts': '1093904272',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1587439981848',
                                                                                                'in_octets': '1588533886120',
                                                                                                'in_ucast_pkts': '1093904272',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '20156419018',
                                                                                                'out_octets': '20365855253',
                                                                                                'out_ucast_pkts': '209436235',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '64/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '20156419018',
                                                                       'out_octets': '20365855253',
                                                                       'out_ucast_pkts': '209436235',
                                                                       'poller_hash': 'ODdCOEYwcGVlcmludGY2NC9ncDE=',
                                                                       'pons': [       {       'id': '64',
                                                                                               'links': [       {       'connected_time': '2602721',
                                                                                                                        'fiber_length': 1176,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOEYwcGVlcnBvbjY0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 64',
                                         'poller_hash': 'ODdCOEYw',
                                         'serial_number': '87B8F0',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ec:d0',
                                         'uptime': '2602721'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001793',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '15555664334',
                                                                       'in_octets': '15614207031',
                                                                       'in_ucast_pkts': '58542697',
                                                                       'mac_address': 'd0:76:8f:1f:e0:28',
                                                                       'mtu': 2000,
                                                                       'name': '65/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '636802503252',
                                                                       'out_octets': '637251632807',
                                                                       'out_ucast_pkts': '449129555',
                                                                       'poller_hash': 'ODdCNEI4cGVlcmludGY2NS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '65',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '636802503252',
                                                                       'in_octets': '637251632807',
                                                                       'in_ucast_pkts': '449129555',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '636802503252',
                                                                                                'in_octets': '637251632807',
                                                                                                'in_ucast_pkts': '449129555',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '15555664334',
                                                                                                'out_octets': '15614207031',
                                                                                                'out_ucast_pkts': '58542697',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '65/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '15555664334',
                                                                       'out_octets': '15614207031',
                                                                       'out_ucast_pkts': '58542697',
                                                                       'poller_hash': 'ODdCNEI4cGVlcmludGY2NS9ncDE=',
                                                                       'pons': [       {       'id': '65',
                                                                                               'links': [       {       'connected_time': '2258620',
                                                                                                                        'fiber_length': 1198,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCNEI4cGVlcnBvbjY1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 65',
                                         'poller_hash': 'ODdCNEI4',
                                         'serial_number': '87B4B8',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:e0:28',
                                         'uptime': '2258620'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001825',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4255656914',
                                                                       'in_octets': '4274333284',
                                                                       'in_ucast_pkts': '18676370',
                                                                       'mac_address': 'd0:76:8f:1f:ed:09',
                                                                       'mtu': 2000,
                                                                       'name': '66/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '54161735242',
                                                                       'out_octets': '54206743242',
                                                                       'out_ucast_pkts': '45008000',
                                                                       'poller_hash': 'ODdCOTAzcGVlcmludGY2Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '66',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '54161735242',
                                                                       'in_octets': '54206743242',
                                                                       'in_ucast_pkts': '45008000',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '54161735242',
                                                                                                'in_octets': '54206743242',
                                                                                                'in_ucast_pkts': '45008000',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4255656914',
                                                                                                'out_octets': '4274333284',
                                                                                                'out_ucast_pkts': '18676370',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTcxLzIvZ3A3'}],
                                                                       'name': '66/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4255656914',
                                                                       'out_octets': '4274333284',
                                                                       'out_ucast_pkts': '18676370',
                                                                       'poller_hash': 'ODdCOTAzcGVlcmludGY2Ni9ncDE=',
                                                                       'pons': [       {       'id': '66',
                                                                                               'links': [       {       'connected_time': '2602728',
                                                                                                                        'fiber_length': 501,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE3MTIwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOTAzcGVlcnBvbjY2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 66',
                                         'poller_hash': 'ODdCOTAz',
                                         'serial_number': '87B903',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ed:09',
                                         'uptime': '2602728'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1001985',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '9546122994',
                                                                       'in_octets': '9635305244',
                                                                       'in_ucast_pkts': '89182250',
                                                                       'mac_address': 'd0:76:8f:1f:fe:c4',
                                                                       'mtu': 2000,
                                                                       'name': '71/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '253173947438',
                                                                       'out_octets': '253359279622',
                                                                       'out_ucast_pkts': '185332184',
                                                                       'poller_hash': 'ODdCRUVDcGVlcmludGY3MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '71',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '253173947438',
                                                                       'in_octets': '253359279622',
                                                                       'in_ucast_pkts': '185332184',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '253173947438',
                                                                                                'in_octets': '253359279622',
                                                                                                'in_ucast_pkts': '185332184',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '9546122994',
                                                                                                'out_octets': '9635305244',
                                                                                                'out_ucast_pkts': '89182250',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '71/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '9546122994',
                                                                       'out_octets': '9635305244',
                                                                       'out_ucast_pkts': '89182250',
                                                                       'poller_hash': 'ODdCRUVDcGVlcmludGY3MS9ncDE=',
                                                                       'pons': [       {       'id': '71',
                                                                                               'links': [       {       'connected_time': '2602706',
                                                                                                                        'fiber_length': 1331,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCRUVDcGVlcnBvbjcxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 71',
                                         'poller_hash': 'ODdCRUVD',
                                         'serial_number': '87BEEC',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:fe:c4',
                                         'uptime': '2602706'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002081',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4411023638',
                                                                       'in_octets': '4440527251',
                                                                       'in_ucast_pkts': '29503613',
                                                                       'mac_address': 'd0:76:8f:1f:fe:b2',
                                                                       'mtu': 2000,
                                                                       'name': '74/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '93582010984',
                                                                       'out_octets': '93659265335',
                                                                       'out_ucast_pkts': '77254351',
                                                                       'poller_hash': 'ODdCRUU2cGVlcmludGY3NC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '74',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '93582010984',
                                                                       'in_octets': '93659265335',
                                                                       'in_ucast_pkts': '77254351',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '93582010984',
                                                                                                'in_octets': '93659265335',
                                                                                                'in_ucast_pkts': '77254351',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4411023638',
                                                                                                'out_octets': '4440527251',
                                                                                                'out_ucast_pkts': '29503613',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2IxLzEvZ3Az'}],
                                                                       'name': '74/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4411023638',
                                                                       'out_octets': '4440527251',
                                                                       'out_ucast_pkts': '29503613',
                                                                       'poller_hash': 'ODdCRUU2cGVlcmludGY3NC9ncDE=',
                                                                       'pons': [       {       'id': '74',
                                                                                               'links': [       {       'connected_time': '1902642',
                                                                                                                        'fiber_length': 1242,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNiMTEwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCRUU2cGVlcnBvbjc0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 74',
                                         'poller_hash': 'ODdCRUU2',
                                         'serial_number': '87BEE6',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:fe:b2',
                                         'uptime': '1902642'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002113',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '17707379496',
                                                                       'in_octets': '17871609366',
                                                                       'in_ucast_pkts': '164229870',
                                                                       'mac_address': 'd0:76:8f:1f:fe:bb',
                                                                       'mtu': 2000,
                                                                       'name': '75/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '605908493878',
                                                                       'out_octets': '606336886362',
                                                                       'out_ucast_pkts': '428392484',
                                                                       'poller_hash': 'ODdCRUU5cGVlcmludGY3NS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '75',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '605908493878',
                                                                       'in_octets': '606336886362',
                                                                       'in_ucast_pkts': '428392484',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '605908493878',
                                                                                                'in_octets': '606336886362',
                                                                                                'in_ucast_pkts': '428392484',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '17707379496',
                                                                                                'out_octets': '17871609366',
                                                                                                'out_ucast_pkts': '164229870',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '75/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '17707379496',
                                                                       'out_octets': '17871609366',
                                                                       'out_ucast_pkts': '164229870',
                                                                       'poller_hash': 'ODdCRUU5cGVlcmludGY3NS9ncDE=',
                                                                       'pons': [       {       'id': '75',
                                                                                               'links': [       {       'connected_time': '2602744',
                                                                                                                        'fiber_length': 1370,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCRUU5cGVlcnBvbjc1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 75',
                                         'poller_hash': 'ODdCRUU5',
                                         'serial_number': '87BEE9',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:fe:bb',
                                         'uptime': '2602744'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002209',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '18580002972',
                                                                       'in_octets': '18665697110',
                                                                       'in_ucast_pkts': '85694138',
                                                                       'mac_address': 'd0:76:8f:1f:f1:9b',
                                                                       'mtu': 2000,
                                                                       'name': '78/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '433774107885',
                                                                       'out_octets': '434079542957',
                                                                       'out_ucast_pkts': '305435072',
                                                                       'poller_hash': 'ODdCQTg5cGVlcmludGY3OC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '78',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '433774107885',
                                                                       'in_octets': '434079542957',
                                                                       'in_ucast_pkts': '305435072',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '433774107885',
                                                                                                'in_octets': '434079542957',
                                                                                                'in_ucast_pkts': '305435072',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '18580002972',
                                                                                                'out_octets': '18665697110',
                                                                                                'out_ucast_pkts': '85694138',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2IxLzEvZ3Az'}],
                                                                       'name': '78/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '18580002972',
                                                                       'out_octets': '18665697110',
                                                                       'out_ucast_pkts': '85694138',
                                                                       'poller_hash': 'ODdCQTg5cGVlcmludGY3OC9ncDE=',
                                                                       'pons': [       {       'id': '78',
                                                                                               'links': [       {       'connected_time': '2258622',
                                                                                                                        'fiber_length': 1175,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNiMTEwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTg5cGVlcnBvbjc4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 78',
                                         'poller_hash': 'ODdCQTg5',
                                         'serial_number': '87BA89',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:9b',
                                         'uptime': '2258622'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002241',
                                                                       'name': '79/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCQTlCcGVlcmludGY3OS9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '79',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2IxLzEvZ3Az'}],
                                                                       'name': '79/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCQTlCcGVlcmludGY3OS9ncDE=',
                                                                       'pons': [       {       'id': '79',
                                                                                               'links': [       {       'poller_hash': 'NDg3NzQ2NTNiZGNiMTEwMDEwMTA3',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTlCcGVlcnBvbjc5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '0',
                                         'name': 'ont 79',
                                         'poller_hash': 'ODdCQTlC',
                                         'serial_number': '87BA9B',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002273',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '20494135247',
                                                                       'in_octets': '20600301295',
                                                                       'in_ucast_pkts': '106166048',
                                                                       'mac_address': 'd0:76:8f:1f:f0:6c',
                                                                       'mtu': 2000,
                                                                       'name': '80/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '544179187781',
                                                                       'out_octets': '544554306277',
                                                                       'out_ucast_pkts': '375118496',
                                                                       'poller_hash': 'ODdCQTI0cGVlcmludGY4MC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '80',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '544179187781',
                                                                       'in_octets': '544554306277',
                                                                       'in_ucast_pkts': '375118496',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '544179187781',
                                                                                                'in_octets': '544554306277',
                                                                                                'in_ucast_pkts': '375118496',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '20494135247',
                                                                                                'out_octets': '20600301295',
                                                                                                'out_ucast_pkts': '106166048',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2YxLzEvZ3A3'}],
                                                                       'name': '80/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '20494135247',
                                                                       'out_octets': '20600301295',
                                                                       'out_ucast_pkts': '106166048',
                                                                       'poller_hash': 'ODdCQTI0cGVlcmludGY4MC9ncDE=',
                                                                       'pons': [       {       'id': '80',
                                                                                               'links': [       {       'connected_time': '2258622',
                                                                                                                        'fiber_length': 1145,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNmMTEwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTI0cGVlcnBvbjgwL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 80',
                                         'poller_hash': 'ODdCQTI0',
                                         'serial_number': '87BA24',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:6c',
                                         'uptime': '2258622'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002337',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'mac_address': 'd0:76:8f:1f:f2:13',
                                                                       'mtu': 2000,
                                                                       'name': '82/g1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ODdCQUIxcGVlcmludGY4Mi9nMQ==',
                                                                       'speed': '0'},
                                                               {       'admin_up': True,
                                                                       'id': '82',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '0',
                                                                       'in_octets': '0',
                                                                       'in_ucast_pkts': '0',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '0',
                                                                                                'in_octets': '0',
                                                                                                'in_ucast_pkts': '0',
                                                                                                'oper_up': False,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '0',
                                                                                                'out_octets': '0',
                                                                                                'out_ucast_pkts': '0',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2YxLzEvZ3A3'}],
                                                                       'name': '82/gp1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '0',
                                                                       'out_octets': '0',
                                                                       'out_ucast_pkts': '0',
                                                                       'poller_hash': 'ODdCQUIxcGVlcmludGY4Mi9ncDE=',
                                                                       'pons': [       {       'id': '82',
                                                                                               'links': [       {       'connected_time': '169479',
                                                                                                                        'fiber_length': 1339,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNmMTEwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQUIxcGVlcnBvbjgyL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 82',
                                         'poller_hash': 'ODdCQUIx',
                                         'serial_number': '87BAB1',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f2:13',
                                         'uptime': '169479'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002369',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '26164608591',
                                                                       'in_octets': '26324351391',
                                                                       'in_ucast_pkts': '159742800',
                                                                       'mac_address': 'd0:76:8f:1f:f1:4d',
                                                                       'mtu': 2000,
                                                                       'name': '83/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '445720607179',
                                                                       'out_octets': '446069031922',
                                                                       'out_ucast_pkts': '348424743',
                                                                       'poller_hash': 'ODdCQTZGcGVlcmludGY4My9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '83',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '445720607179',
                                                                       'in_octets': '446069031922',
                                                                       'in_ucast_pkts': '348424743',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '445720607179',
                                                                                                'in_octets': '446069031922',
                                                                                                'in_ucast_pkts': '348424743',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '26164608591',
                                                                                                'out_octets': '26324351391',
                                                                                                'out_ucast_pkts': '159742800',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2QxLzEvZ3A1'}],
                                                                       'name': '83/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '26164608591',
                                                                       'out_octets': '26324351391',
                                                                       'out_ucast_pkts': '159742800',
                                                                       'poller_hash': 'ODdCQTZGcGVlcmludGY4My9ncDE=',
                                                                       'pons': [       {       'id': '83',
                                                                                               'links': [       {       'connected_time': '2602673',
                                                                                                                        'fiber_length': 1450,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNkMTEwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTZGcGVlcnBvbjgzL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 83',
                                         'poller_hash': 'ODdCQTZG',
                                         'serial_number': '87BA6F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f1:4d',
                                         'uptime': '2602673'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002401',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '6590160503',
                                                                       'in_octets': '6646025974',
                                                                       'in_ucast_pkts': '55865471',
                                                                       'mac_address': 'd0:76:8f:1f:f0:51',
                                                                       'mtu': 2000,
                                                                       'name': '84/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '518183689128',
                                                                       'out_octets': '518536857699',
                                                                       'out_ucast_pkts': '353168571',
                                                                       'poller_hash': 'ODdCQTFCcGVlcmludGY4NC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '84',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '518183689128',
                                                                       'in_octets': '518536857699',
                                                                       'in_ucast_pkts': '353168571',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '518183689128',
                                                                                                'in_octets': '518536857699',
                                                                                                'in_ucast_pkts': '353168571',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '6590160503',
                                                                                                'out_octets': '6646025974',
                                                                                                'out_ucast_pkts': '55865471',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '84/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '6590160503',
                                                                       'out_octets': '6646025974',
                                                                       'out_ucast_pkts': '55865471',
                                                                       'poller_hash': 'ODdCQTFCcGVlcmludGY4NC9ncDE=',
                                                                       'pons': [       {       'id': '84',
                                                                                               'links': [       {       'connected_time': '2258621',
                                                                                                                        'fiber_length': 1228,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTFCcGVlcnBvbjg0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 84',
                                         'poller_hash': 'ODdCQTFC',
                                         'serial_number': '87BA1B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:51',
                                         'uptime': '2258621'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002433',
                                                                       'name': '85/g1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCQTIycGVlcmludGY4NS9nMQ=='},
                                                               {       'admin_up': True,
                                                                       'id': '85',
                                                                       'links': [       {       'oper_up': False,
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '85/gp1',
                                                                       'oper_up': False,
                                                                       'poller_hash': 'ODdCQTIycGVlcmludGY4NS9ncDE=',
                                                                       'pons': [       {       'id': '85',
                                                                                               'links': [       {       'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'tx_link_rate': '1244160000'}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTIycGVlcnBvbjg1L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '0',
                                         'name': 'ont 85',
                                         'poller_hash': 'ODdCQTIy',
                                         'serial_number': '87BA22',
                                         'status': 'ELEMENT_STATUS_OFFLINE'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002465',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '4344069909',
                                                                       'in_octets': '4365482950',
                                                                       'in_ucast_pkts': '21413041',
                                                                       'mac_address': 'd0:76:8f:1f:f0:69',
                                                                       'mtu': 2000,
                                                                       'name': '86/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '89770582339',
                                                                       'out_octets': '89839578668',
                                                                       'out_ucast_pkts': '68996329',
                                                                       'poller_hash': 'ODdCQTIzcGVlcmludGY4Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '86',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '89770582339',
                                                                       'in_octets': '89839578668',
                                                                       'in_ucast_pkts': '68996329',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '89770582339',
                                                                                                'in_octets': '89839578668',
                                                                                                'in_ucast_pkts': '68996329',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '4344069909',
                                                                                                'out_octets': '4365482950',
                                                                                                'out_ucast_pkts': '21413041',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '86/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '4344069909',
                                                                       'out_octets': '4365482950',
                                                                       'out_ucast_pkts': '21413041',
                                                                       'poller_hash': 'ODdCQTIzcGVlcmludGY4Ni9ncDE=',
                                                                       'pons': [       {       'id': '86',
                                                                                               'links': [       {       'connected_time': '2602670',
                                                                                                                        'fiber_length': 1541,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTIzcGVlcnBvbjg2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 86',
                                         'poller_hash': 'ODdCQTIz',
                                         'serial_number': '87BA23',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:69',
                                         'uptime': '2602670'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002497',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '33287906442',
                                                                       'in_octets': '33395034622',
                                                                       'in_ucast_pkts': '107128180',
                                                                       'mac_address': 'd0:76:8f:1f:f0:5d',
                                                                       'mtu': 2000,
                                                                       'name': '87/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '207769980823',
                                                                       'out_octets': '207975347794',
                                                                       'out_ucast_pkts': '205366971',
                                                                       'poller_hash': 'ODdCQTFGcGVlcmludGY4Ny9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '87',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '207769980823',
                                                                       'in_octets': '207975347794',
                                                                       'in_ucast_pkts': '205366971',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '207769980823',
                                                                                                'in_octets': '207975347794',
                                                                                                'in_ucast_pkts': '205366971',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '33287906442',
                                                                                                'out_octets': '33395034622',
                                                                                                'out_ucast_pkts': '107128180',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '87/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '33287906442',
                                                                       'out_octets': '33395034622',
                                                                       'out_ucast_pkts': '107128180',
                                                                       'poller_hash': 'ODdCQTFGcGVlcmludGY4Ny9ncDE=',
                                                                       'pons': [       {       'id': '87',
                                                                                               'links': [       {       'connected_time': '2602740',
                                                                                                                        'fiber_length': 1357,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTFGcGVlcnBvbjg3L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 87',
                                         'poller_hash': 'ODdCQTFG',
                                         'serial_number': '87BA1F',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:5d',
                                         'uptime': '2602740'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002561',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '176161251',
                                                                       'in_octets': '176358619',
                                                                       'in_ucast_pkts': '197368',
                                                                       'mac_address': 'd0:76:8f:1f:ed:21',
                                                                       'mtu': 2000,
                                                                       'name': '89/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '105808212',
                                                                       'out_octets': '105929003',
                                                                       'out_ucast_pkts': '120791',
                                                                       'poller_hash': 'ODdCOTBCcGVlcmludGY4OS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '89',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '105808212',
                                                                       'in_octets': '105929003',
                                                                       'in_ucast_pkts': '120791',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '105808212',
                                                                                                'in_octets': '105929003',
                                                                                                'in_ucast_pkts': '120791',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '176161251',
                                                                                                'out_octets': '176358619',
                                                                                                'out_ucast_pkts': '197368',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6ZDAxLzEvZ3A4'}],
                                                                       'name': '89/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '176161251',
                                                                       'out_octets': '176358619',
                                                                       'out_ucast_pkts': '197368',
                                                                       'poller_hash': 'ODdCOTBCcGVlcmludGY4OS9ncDE=',
                                                                       'pons': [       {       'id': '89',
                                                                                               'links': [       {       'connected_time': '10387',
                                                                                                                        'fiber_length': 1287,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGQwMTEwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOTBCcGVlcnBvbjg5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 89',
                                         'poller_hash': 'ODdCOTBC',
                                         'serial_number': '87B90B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ed:21',
                                         'uptime': '10387'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002625',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '64768318339',
                                                                       'in_octets': '65114442523',
                                                                       'in_ucast_pkts': '346124184',
                                                                       'mac_address': 'd0:76:8f:1f:ef:fd',
                                                                       'mtu': 2000,
                                                                       'name': '91/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '882780972098',
                                                                       'out_octets': '883461563743',
                                                                       'out_ucast_pkts': '680591645',
                                                                       'poller_hash': 'ODdCOUZGcGVlcmludGY5MS9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '91',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '882780972098',
                                                                       'in_octets': '883461563743',
                                                                       'in_ucast_pkts': '680591645',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '882780972098',
                                                                                                'in_octets': '883461563743',
                                                                                                'in_ucast_pkts': '680591645',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '64768318339',
                                                                                                'out_octets': '65114442523',
                                                                                                'out_ucast_pkts': '346124184',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '91/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '64768318339',
                                                                       'out_octets': '65114442523',
                                                                       'out_ucast_pkts': '346124184',
                                                                       'poller_hash': 'ODdCOUZGcGVlcmludGY5MS9ncDE=',
                                                                       'pons': [       {       'id': '91',
                                                                                               'links': [       {       'connected_time': '2602682',
                                                                                                                        'fiber_length': 1272,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOUZGcGVlcnBvbjkxL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 91',
                                         'poller_hash': 'ODdCOUZG',
                                         'serial_number': '87B9FF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:fd',
                                         'uptime': '2602682'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002657',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '51216705647',
                                                                       'in_octets': '51341036598',
                                                                       'in_ucast_pkts': '124330951',
                                                                       'mac_address': 'd0:76:8f:1f:ef:19',
                                                                       'mtu': 2000,
                                                                       'name': '92/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '557398464686',
                                                                       'out_octets': '557815774607',
                                                                       'out_ucast_pkts': '417309921',
                                                                       'poller_hash': 'ODdCOUIzcGVlcmludGY5Mi9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '92',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '557398464686',
                                                                       'in_octets': '557815774607',
                                                                       'in_ucast_pkts': '417309921',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '557398464686',
                                                                                                'in_octets': '557815774607',
                                                                                                'in_ucast_pkts': '417309921',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '51216705647',
                                                                                                'out_octets': '51341036598',
                                                                                                'out_ucast_pkts': '124330951',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTgxLzIvZ3A4'}],
                                                                       'name': '92/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '51216705647',
                                                                       'out_octets': '51341036598',
                                                                       'out_ucast_pkts': '124330951',
                                                                       'poller_hash': 'ODdCOUIzcGVlcmludGY5Mi9ncDE=',
                                                                       'pons': [       {       'id': '92',
                                                                                               'links': [       {       'connected_time': '2602716',
                                                                                                                        'fiber_length': 456,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE4MTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOUIzcGVlcnBvbjkyL2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 92',
                                         'poller_hash': 'ODdCOUIz',
                                         'serial_number': '87B9B3',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ef:19',
                                         'uptime': '2602716'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002721',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '28298777937',
                                                                       'in_octets': '28544967510',
                                                                       'in_ucast_pkts': '246189573',
                                                                       'mac_address': 'd0:76:8f:1f:e9:fd',
                                                                       'mtu': 2000,
                                                                       'name': '94/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1060832984061',
                                                                       'out_octets': '1061554935307',
                                                                       'out_ucast_pkts': '721951246',
                                                                       'poller_hash': 'ODdCN0ZGcGVlcmludGY5NC9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '94',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1060832984061',
                                                                       'in_octets': '1061554935307',
                                                                       'in_ucast_pkts': '721951246',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1060832984061',
                                                                                                'in_octets': '1061554935307',
                                                                                                'in_ucast_pkts': '721951246',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '28298777937',
                                                                                                'out_octets': '28544967510',
                                                                                                'out_ucast_pkts': '246189573',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '94/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '28298777937',
                                                                       'out_octets': '28544967510',
                                                                       'out_ucast_pkts': '246189573',
                                                                       'poller_hash': 'ODdCN0ZGcGVlcmludGY5NC9ncDE=',
                                                                       'pons': [       {       'id': '94',
                                                                                               'links': [       {       'connected_time': '1530169',
                                                                                                                        'fiber_length': 1337,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCN0ZGcGVlcnBvbjk0L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 94',
                                         'poller_hash': 'ODdCN0ZG',
                                         'serial_number': '87B7FF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:e9:fd',
                                         'uptime': '1530169'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002753',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '10082729345',
                                                                       'in_octets': '10146566384',
                                                                       'in_ucast_pkts': '63837039',
                                                                       'mac_address': 'd0:76:8f:1f:f0:75',
                                                                       'mtu': 2000,
                                                                       'name': '96/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '199987812831',
                                                                       'out_octets': '200134837447',
                                                                       'out_ucast_pkts': '147024616',
                                                                       'poller_hash': 'ODdCQTI3cGVlcmludGY5Ni9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '96',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '199987812831',
                                                                       'in_octets': '200134837447',
                                                                       'in_ucast_pkts': '147024616',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '199987812831',
                                                                                                'in_octets': '200134837447',
                                                                                                'in_ucast_pkts': '147024616',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '10082729345',
                                                                                                'out_octets': '10146566384',
                                                                                                'out_ucast_pkts': '63837039',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '96/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '10082729345',
                                                                       'out_octets': '10146566384',
                                                                       'out_ucast_pkts': '63837039',
                                                                       'poller_hash': 'ODdCQTI3cGVlcmludGY5Ni9ncDE=',
                                                                       'pons': [       {       'id': '96',
                                                                                               'links': [       {       'connected_time': '1003506',
                                                                                                                        'fiber_length': 1337,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTI3cGVlcnBvbjk2L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 96',
                                         'poller_hash': 'ODdCQTI3',
                                         'serial_number': '87BA27',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:75',
                                         'uptime': '1003506'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002817',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13364671626',
                                                                       'in_octets': '13398720740',
                                                                       'in_ucast_pkts': '34049114',
                                                                       'mac_address': 'd0:76:8f:1f:ea:db',
                                                                       'mtu': 2000,
                                                                       'name': '98/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '135270006274',
                                                                       'out_octets': '135379700334',
                                                                       'out_ucast_pkts': '109694060',
                                                                       'poller_hash': 'ODdCODQ5cGVlcmludGY5OC9nMQ==',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '98',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '135270006274',
                                                                       'in_octets': '135379700334',
                                                                       'in_ucast_pkts': '109694060',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '135270006274',
                                                                                                'in_octets': '135379700334',
                                                                                                'in_ucast_pkts': '109694060',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13364671626',
                                                                                                'out_octets': '13398720740',
                                                                                                'out_ucast_pkts': '34049114',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '98/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13364671626',
                                                                       'out_octets': '13398720740',
                                                                       'out_ucast_pkts': '34049114',
                                                                       'poller_hash': 'ODdCODQ5cGVlcmludGY5OC9ncDE=',
                                                                       'pons': [       {       'id': '98',
                                                                                               'links': [       {       'connected_time': '2602744',
                                                                                                                        'fiber_length': 890,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCODQ5cGVlcnBvbjk4L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 98',
                                         'poller_hash': 'ODdCODQ5',
                                         'serial_number': '87B849',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ea:db',
                                         'uptime': '2602744'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002849',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '40149351413',
                                                                       'in_octets': '40549026103',
                                                                       'in_ucast_pkts': '399674690',
                                                                       'mac_address': 'd0:76:8f:1f:ea:2a',
                                                                       'mtu': 2000,
                                                                       'name': '99/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1375071753065',
                                                                       'out_octets': '1376019662121',
                                                                       'out_ucast_pkts': '947909056',
                                                                       'poller_hash': 'ODdCODBFcGVlcmludGY5OS9nMQ==',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '99',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1375071753065',
                                                                       'in_octets': '1376019662121',
                                                                       'in_ucast_pkts': '947909056',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1375071753065',
                                                                                                'in_octets': '1376019662121',
                                                                                                'in_ucast_pkts': '947909056',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '1',
                                                                                                'out_nucast_pkts': '40149351413',
                                                                                                'out_octets': '40549026103',
                                                                                                'out_ucast_pkts': '399674690',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '99/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '1',
                                                                       'out_nucast_pkts': '40149351413',
                                                                       'out_octets': '40549026103',
                                                                       'out_ucast_pkts': '399674690',
                                                                       'poller_hash': 'ODdCODBFcGVlcmludGY5OS9ncDE=',
                                                                       'pons': [       {       'id': '99',
                                                                                               'links': [       {       'connected_time': '1239371',
                                                                                                                        'fiber_length': 1279,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCODBFcGVlcnBvbjk5L2dwMQ==',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 99',
                                         'poller_hash': 'ODdCODBF',
                                         'serial_number': '87B80E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ea:2a',
                                         'uptime': '1239371'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002881',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '10559896019',
                                                                       'in_octets': '10596668713',
                                                                       'in_ucast_pkts': '36772694',
                                                                       'mac_address': 'd0:76:8f:1f:eb:e6',
                                                                       'mtu': 2000,
                                                                       'name': '100/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '116277250063',
                                                                       'out_octets': '116363121589',
                                                                       'out_ucast_pkts': '85871526',
                                                                       'poller_hash': 'ODdCOEEycGVlcmludGYxMDAvZzE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '100',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '116277250063',
                                                                       'in_octets': '116363121589',
                                                                       'in_ucast_pkts': '85871526',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '116277250063',
                                                                                                'in_octets': '116363121589',
                                                                                                'in_ucast_pkts': '85871526',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '10559896019',
                                                                                                'out_octets': '10596668713',
                                                                                                'out_ucast_pkts': '36772694',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2QxLzEvZ3A1'}],
                                                                       'name': '100/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '10559896019',
                                                                       'out_octets': '10596668713',
                                                                       'out_ucast_pkts': '36772694',
                                                                       'poller_hash': 'ODdCOEEycGVlcmludGYxMDAvZ3Ax',
                                                                       'pons': [       {       'id': '100',
                                                                                               'links': [       {       'connected_time': '1240987',
                                                                                                                        'fiber_length': 1403,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNkMTEwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOEEycGVlcnBvbjEwMC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 100',
                                         'poller_hash': 'ODdCOEEy',
                                         'serial_number': '87B8A2',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:eb:e6',
                                         'uptime': '1240987'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002945',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '18271322604',
                                                                       'in_octets': '18307780346',
                                                                       'in_ucast_pkts': '36457742',
                                                                       'mac_address': 'd0:76:8f:1f:eb:d1',
                                                                       'mtu': 2000,
                                                                       'name': '102/g1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '88792805789',
                                                                       'out_octets': '88871615848',
                                                                       'out_ucast_pkts': '78810059',
                                                                       'poller_hash': 'ODdCODlCcGVlcmludGYxMDIvZzE=',
                                                                       'speed': '0'},
                                                               {       'admin_up': True,
                                                                       'id': '102',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '88792805789',
                                                                       'in_octets': '88871615848',
                                                                       'in_ucast_pkts': '78810059',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '88792805789',
                                                                                                'in_octets': '88871615848',
                                                                                                'in_ucast_pkts': '78810059',
                                                                                                'oper_up': False,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '18271322604',
                                                                                                'out_octets': '18307780346',
                                                                                                'out_ucast_pkts': '36457742',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '102/gp1',
                                                                       'oper_up': False,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '18271322604',
                                                                       'out_octets': '18307780346',
                                                                       'out_ucast_pkts': '36457742',
                                                                       'poller_hash': 'ODdCODlCcGVlcmludGYxMDIvZ3Ax',
                                                                       'pons': [       {       'id': '102',
                                                                                               'links': [       {       'connected_time': '2602736',
                                                                                                                        'fiber_length': 1015,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCODlCcGVlcnBvbjEwMi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 102',
                                         'poller_hash': 'ODdCODlC',
                                         'serial_number': '87B89B',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:eb:d1',
                                         'uptime': '2602736'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1002977',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '7400155608',
                                                                       'in_octets': '7416865672',
                                                                       'in_ucast_pkts': '16710064',
                                                                       'mac_address': 'd0:76:8f:1f:eb:1a',
                                                                       'mtu': 2000,
                                                                       'name': '103/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '53190327068',
                                                                       'out_octets': '53236304501',
                                                                       'out_ucast_pkts': '45977433',
                                                                       'poller_hash': 'ODdCODVFcGVlcmludGYxMDMvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '103',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '53190327068',
                                                                       'in_octets': '53236304501',
                                                                       'in_ucast_pkts': '45977433',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '53190327068',
                                                                                                'in_octets': '53236304501',
                                                                                                'in_ucast_pkts': '45977433',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '7400155608',
                                                                                                'out_octets': '7416865672',
                                                                                                'out_ucast_pkts': '16710064',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '103/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '7400155608',
                                                                       'out_octets': '7416865672',
                                                                       'out_ucast_pkts': '16710064',
                                                                       'poller_hash': 'ODdCODVFcGVlcmludGYxMDMvZ3Ax',
                                                                       'pons': [       {       'id': '103',
                                                                                               'links': [       {       'connected_time': '2602754',
                                                                                                                        'fiber_length': 1081,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCODVFcGVlcnBvbjEwMy9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 103',
                                         'poller_hash': 'ODdCODVF',
                                         'serial_number': '87B85E',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:eb:1a',
                                         'uptime': '2602754'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003041',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '73474341500',
                                                                       'in_octets': '73572191955',
                                                                       'in_ucast_pkts': '97850455',
                                                                       'mac_address': 'd0:76:8f:1f:fe:9d',
                                                                       'mtu': 2000,
                                                                       'name': '105/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '532220840295',
                                                                       'out_octets': '532626394905',
                                                                       'out_ucast_pkts': '405554610',
                                                                       'poller_hash': 'ODdCRURGcGVlcmludGYxMDUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '105',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '532220840295',
                                                                       'in_octets': '532626394905',
                                                                       'in_ucast_pkts': '405554610',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '532220840295',
                                                                                                'in_octets': '532626394905',
                                                                                                'in_ucast_pkts': '405554610',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '73474341500',
                                                                                                'out_octets': '73572191955',
                                                                                                'out_ucast_pkts': '97850455',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTExLzIvZ3Ax'}],
                                                                       'name': '105/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '73474341500',
                                                                       'out_octets': '73572191955',
                                                                       'out_ucast_pkts': '97850455',
                                                                       'poller_hash': 'ODdCRURGcGVlcmludGYxMDUvZ3Ax',
                                                                       'pons': [       {       'id': '105',
                                                                                               'links': [       {       'connected_time': '2602669',
                                                                                                                        'fiber_length': 1369,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjExMTIwMDEwMTA1',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCRURGcGVlcnBvbjEwNS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 105',
                                         'poller_hash': 'ODdCRURG',
                                         'serial_number': '87BEDF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:fe:9d',
                                         'uptime': '2602669'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003137',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '3172664872',
                                                                       'in_octets': '3190379901',
                                                                       'in_ucast_pkts': '17715029',
                                                                       'mac_address': 'd0:76:8f:1f:eb:5c',
                                                                       'mtu': 2000,
                                                                       'name': '108/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '123151647206',
                                                                       'out_octets': '123240638252',
                                                                       'out_ucast_pkts': '88991046',
                                                                       'poller_hash': 'ODdCODc0cGVlcmludGYxMDgvZzE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '108',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '123151647206',
                                                                       'in_octets': '123240638252',
                                                                       'in_ucast_pkts': '88991046',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '123151647206',
                                                                                                'in_octets': '123240638252',
                                                                                                'in_ucast_pkts': '88991046',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '3172664872',
                                                                                                'out_octets': '3190379901',
                                                                                                'out_ucast_pkts': '17715029',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '108/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '3172664872',
                                                                       'out_octets': '3190379901',
                                                                       'out_ucast_pkts': '17715029',
                                                                       'poller_hash': 'ODdCODc0cGVlcmludGYxMDgvZ3Ax',
                                                                       'pons': [       {       'id': '108',
                                                                                               'links': [       {       'connected_time': '2602715',
                                                                                                                        'fiber_length': 940,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCODc0cGVlcnBvbjEwOC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 108',
                                         'poller_hash': 'ODdCODc0',
                                         'serial_number': '87B874',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:eb:5c',
                                         'uptime': '2602715'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003169',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '16880711351',
                                                                       'in_octets': '17066788005',
                                                                       'in_ucast_pkts': '186076654',
                                                                       'mac_address': 'd0:76:8f:1f:ec:7c',
                                                                       'mtu': 2000,
                                                                       'name': '109/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '621784717118',
                                                                       'out_octets': '622215112777',
                                                                       'out_ucast_pkts': '430395659',
                                                                       'poller_hash': 'ODdCOEQ0cGVlcmludGYxMDkvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '109',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '621784717118',
                                                                       'in_octets': '622215112777',
                                                                       'in_ucast_pkts': '430395659',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '621784717118',
                                                                                                'in_octets': '622215112777',
                                                                                                'in_ucast_pkts': '430395659',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '16880711351',
                                                                                                'out_octets': '17066788005',
                                                                                                'out_ucast_pkts': '186076654',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2MxLzEvZ3A0'}],
                                                                       'name': '109/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '16880711351',
                                                                       'out_octets': '17066788005',
                                                                       'out_ucast_pkts': '186076654',
                                                                       'poller_hash': 'ODdCOEQ0cGVlcmludGYxMDkvZ3Ax',
                                                                       'pons': [       {       'id': '109',
                                                                                               'links': [       {       'connected_time': '2602727',
                                                                                                                        'fiber_length': 1265,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNjMTEwMDEwMTA4',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOEQ0cGVlcnBvbjEwOS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 109',
                                         'poller_hash': 'ODdCOEQ0',
                                         'serial_number': '87B8D4',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ec:7c',
                                         'uptime': '2602727'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003201',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '17275849308',
                                                                       'in_octets': '17396439045',
                                                                       'in_ucast_pkts': '120589737',
                                                                       'mac_address': 'd0:76:8f:1f:ea:93',
                                                                       'mtu': 2000,
                                                                       'name': '110/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '298529931829',
                                                                       'out_octets': '298748322581',
                                                                       'out_ucast_pkts': '218390752',
                                                                       'poller_hash': 'ODdCODMxcGVlcmludGYxMTAvZzE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '110',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '298529931829',
                                                                       'in_octets': '298748322581',
                                                                       'in_ucast_pkts': '218390752',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '298529931829',
                                                                                                'in_octets': '298748322581',
                                                                                                'in_ucast_pkts': '218390752',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '17275849308',
                                                                                                'out_octets': '17396439045',
                                                                                                'out_ucast_pkts': '120589737',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2'}],
                                                                       'name': '110/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '17275849308',
                                                                       'out_octets': '17396439045',
                                                                       'out_ucast_pkts': '120589737',
                                                                       'poller_hash': 'ODdCODMxcGVlcmludGYxMTAvZ3Ax',
                                                                       'pons': [       {       'id': '110',
                                                                                               'links': [       {       'connected_time': '2602740',
                                                                                                                        'fiber_length': 923,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCODMxcGVlcnBvbjExMC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 110',
                                         'poller_hash': 'ODdCODMx',
                                         'serial_number': '87B831',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ea:93',
                                         'uptime': '2602740'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003233',
                                                                       'in_errors': '1',
                                                                       'in_nucast_pkts': '7841565651',
                                                                       'in_octets': '7888256609',
                                                                       'in_ucast_pkts': '46690958',
                                                                       'mac_address': 'd0:76:8f:1f:ec:3d',
                                                                       'mtu': 2000,
                                                                       'name': '111/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '429185354835',
                                                                       'out_octets': '429483641776',
                                                                       'out_ucast_pkts': '298286941',
                                                                       'poller_hash': 'ODdCOEJGcGVlcmludGYxMTEvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '111',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '429185354835',
                                                                       'in_octets': '429483641776',
                                                                       'in_ucast_pkts': '298286941',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '429185354835',
                                                                                                'in_octets': '429483641776',
                                                                                                'in_ucast_pkts': '298286941',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '1',
                                                                                                'out_nucast_pkts': '7841565651',
                                                                                                'out_octets': '7888256609',
                                                                                                'out_ucast_pkts': '46690958',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '111/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '1',
                                                                       'out_nucast_pkts': '7841565651',
                                                                       'out_octets': '7888256609',
                                                                       'out_ucast_pkts': '46690958',
                                                                       'poller_hash': 'ODdCOEJGcGVlcmludGYxMTEvZ3Ax',
                                                                       'pons': [       {       'id': '111',
                                                                                               'links': [       {       'connected_time': '2602741',
                                                                                                                        'fiber_length': 993,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -19.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOEJGcGVlcnBvbjExMS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 111',
                                         'poller_hash': 'ODdCOEJG',
                                         'serial_number': '87B8BF',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ec:3d',
                                         'uptime': '2602741'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003361',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '48229201362',
                                                                       'in_octets': '48627616508',
                                                                       'in_ucast_pkts': '398415146',
                                                                       'mac_address': 'd0:76:8f:1f:f0:4e',
                                                                       'mtu': 2000,
                                                                       'name': '115/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1261851815087',
                                                                       'out_octets': '1262715957295',
                                                                       'out_ucast_pkts': '864142208',
                                                                       'poller_hash': 'ODdCQTFBcGVlcmludGYxMTUvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '115',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1261851815087',
                                                                       'in_octets': '1262715957295',
                                                                       'in_ucast_pkts': '864142208',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1261851815087',
                                                                                                'in_octets': '1262715957295',
                                                                                                'in_ucast_pkts': '864142208',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '48229201362',
                                                                                                'out_octets': '48627616508',
                                                                                                'out_ucast_pkts': '398415146',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2'}],
                                                                       'name': '115/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '48229201362',
                                                                       'out_octets': '48627616508',
                                                                       'out_ucast_pkts': '398415146',
                                                                       'poller_hash': 'ODdCQTFBcGVlcmludGYxMTUvZ3Ax',
                                                                       'pons': [       {       'id': '115',
                                                                                               'links': [       {       'connected_time': '2602740',
                                                                                                                        'fiber_length': 770,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -20.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTFBcGVlcnBvbjExNS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 115',
                                         'poller_hash': 'ODdCQTFB',
                                         'serial_number': '87BA1A',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:4e',
                                         'uptime': '2602740'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003393',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '14443860351',
                                                                       'in_octets': '14482413398',
                                                                       'in_ucast_pkts': '38553047',
                                                                       'mac_address': 'd0:76:8f:1f:ec:25',
                                                                       'mtu': 2000,
                                                                       'name': '116/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '92605003254',
                                                                       'out_octets': '92676061310',
                                                                       'out_ucast_pkts': '71058056',
                                                                       'poller_hash': 'ODdCOEI3cGVlcmludGYxMTYvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '116',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '92605003254',
                                                                       'in_octets': '92676061310',
                                                                       'in_ucast_pkts': '71058056',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '92605003254',
                                                                                                'in_octets': '92676061310',
                                                                                                'in_ucast_pkts': '71058056',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '14443860351',
                                                                                                'out_octets': '14482413398',
                                                                                                'out_ucast_pkts': '38553047',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2'}],
                                                                       'name': '116/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '14443860351',
                                                                       'out_octets': '14482413398',
                                                                       'out_ucast_pkts': '38553047',
                                                                       'poller_hash': 'ODdCOEI3cGVlcmludGYxMTYvZ3Ax',
                                                                       'pons': [       {       'id': '116',
                                                                                               'links': [       {       'connected_time': '2602737',
                                                                                                                        'fiber_length': 644,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOEI3cGVlcnBvbjExNi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 116',
                                         'poller_hash': 'ODdCOEI3',
                                         'serial_number': '87B8B7',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ec:25',
                                         'uptime': '2602737'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003457',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '48872779056',
                                                                       'in_octets': '48998328147',
                                                                       'in_ucast_pkts': '125549091',
                                                                       'mac_address': 'd0:76:8f:1f:ea:f9',
                                                                       'mtu': 2000,
                                                                       'name': '118/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '531918402860',
                                                                       'out_octets': '532318394450',
                                                                       'out_ucast_pkts': '399991590',
                                                                       'poller_hash': 'ODdCODUzcGVlcmludGYxMTgvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '118',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '531918402860',
                                                                       'in_octets': '532318394450',
                                                                       'in_ucast_pkts': '399991590',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '531918402860',
                                                                                                'in_octets': '532318394450',
                                                                                                'in_ucast_pkts': '399991590',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '48872779056',
                                                                                                'out_octets': '48998328147',
                                                                                                'out_ucast_pkts': '125549091',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2'}],
                                                                       'name': '118/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '48872779056',
                                                                       'out_octets': '48998328147',
                                                                       'out_ucast_pkts': '125549091',
                                                                       'poller_hash': 'ODdCODUzcGVlcmludGYxMTgvZ3Ax',
                                                                       'pons': [       {       'id': '118',
                                                                                               'links': [       {       'connected_time': '2602726',
                                                                                                                        'fiber_length': 759,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCODUzcGVlcnBvbjExOC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 118',
                                         'poller_hash': 'ODdCODUz',
                                         'serial_number': '87B853',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ea:f9',
                                         'uptime': '2602726'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003489',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '2806911631',
                                                                       'in_octets': '2819504627',
                                                                       'in_ucast_pkts': '12592996',
                                                                       'mac_address': 'd0:76:8f:1f:f0:72',
                                                                       'mtu': 2000,
                                                                       'name': '119/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '43016426040',
                                                                       'out_octets': '43054171945',
                                                                       'out_ucast_pkts': '37745905',
                                                                       'poller_hash': 'ODdCQTI2cGVlcmludGYxMTkvZzE=',
                                                                       'speed': '100000000'},
                                                               {       'admin_up': True,
                                                                       'id': '119',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '43016426040',
                                                                       'in_octets': '43054171945',
                                                                       'in_ucast_pkts': '37745905',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '43016426040',
                                                                                                'in_octets': '43054171945',
                                                                                                'in_ucast_pkts': '37745905',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '2806911631',
                                                                                                'out_octets': '2819504627',
                                                                                                'out_ucast_pkts': '12592996',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6YmQ6Y2YxLzEvZ3A3'}],
                                                                       'name': '119/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '2806911631',
                                                                       'out_octets': '2819504627',
                                                                       'out_ucast_pkts': '12592996',
                                                                       'poller_hash': 'ODdCQTI2cGVlcmludGYxMTkvZ3Ax',
                                                                       'pons': [       {       'id': '119',
                                                                                               'links': [       {       'connected_time': '2258634',
                                                                                                                        'fiber_length': 1271,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTNiZGNmMTEwMDEwMTEx',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTI2cGVlcnBvbjExOS9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 119',
                                         'poller_hash': 'ODdCQTI2',
                                         'serial_number': '87BA26',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:72',
                                         'uptime': '2258634'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003521',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '13195802876',
                                                                       'in_octets': '13263609593',
                                                                       'in_ucast_pkts': '67806717',
                                                                       'mac_address': 'd0:76:8f:1f:e9:af',
                                                                       'mtu': 2000,
                                                                       'name': '120/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '376416283939',
                                                                       'out_octets': '376690592113',
                                                                       'out_ucast_pkts': '274308174',
                                                                       'poller_hash': 'ODdCN0U1cGVlcmludGYxMjAvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '120',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '376416283939',
                                                                       'in_octets': '376690592113',
                                                                       'in_ucast_pkts': '274308174',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '376416283939',
                                                                                                'in_octets': '376690592113',
                                                                                                'in_ucast_pkts': '274308174',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '13195802876',
                                                                                                'out_octets': '13263609593',
                                                                                                'out_ucast_pkts': '67806717',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '120/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '13195802876',
                                                                       'out_octets': '13263609593',
                                                                       'out_ucast_pkts': '67806717',
                                                                       'poller_hash': 'ODdCN0U1cGVlcmludGYxMjAvZ3Ax',
                                                                       'pons': [       {       'id': '120',
                                                                                               'links': [       {       'connected_time': '2602753',
                                                                                                                        'fiber_length': 972,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCN0U1cGVlcnBvbjEyMC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 120',
                                         'poller_hash': 'ODdCN0U1',
                                         'serial_number': '87B7E5',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:e9:af',
                                         'uptime': '2602753'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003585',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '11457675528',
                                                                       'in_octets': '11548974953',
                                                                       'in_ucast_pkts': '91299425',
                                                                       'mac_address': 'd0:76:8f:1f:eb:5f',
                                                                       'mtu': 2000,
                                                                       'name': '122/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '170673092790',
                                                                       'out_octets': '170859445079',
                                                                       'out_ucast_pkts': '186352289',
                                                                       'poller_hash': 'ODdCODc1cGVlcmludGYxMjIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '122',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '170673092790',
                                                                       'in_octets': '170859445079',
                                                                       'in_ucast_pkts': '186352289',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '170673092790',
                                                                                                'in_octets': '170859445079',
                                                                                                'in_ucast_pkts': '186352289',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '11457675528',
                                                                                                'out_octets': '11548974953',
                                                                                                'out_ucast_pkts': '91299425',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '122/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '11457675528',
                                                                       'out_octets': '11548974953',
                                                                       'out_ucast_pkts': '91299425',
                                                                       'poller_hash': 'ODdCODc1cGVlcmludGYxMjIvZ3Ax',
                                                                       'pons': [       {       'id': '122',
                                                                                               'links': [       {       'connected_time': '1562093',
                                                                                                                        'fiber_length': 1136,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -17.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCODc1cGVlcnBvbjEyMi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 122',
                                         'poller_hash': 'ODdCODc1',
                                         'serial_number': '87B875',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:eb:5f',
                                         'uptime': '1562093'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003617',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '128676150',
                                                                       'in_octets': '128879733',
                                                                       'in_ucast_pkts': '203583',
                                                                       'mac_address': 'd0:76:8f:1f:ed:b7',
                                                                       'mtu': 2000,
                                                                       'name': '123/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '119970328',
                                                                       'out_octets': '120435103',
                                                                       'out_ucast_pkts': '464775',
                                                                       'poller_hash': 'ODdCOTNEcGVlcmludGYxMjMvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '123',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '119970328',
                                                                       'in_octets': '120435103',
                                                                       'in_ucast_pkts': '464775',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '119970328',
                                                                                                'in_octets': '120435103',
                                                                                                'in_ucast_pkts': '464775',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '128676150',
                                                                                                'out_octets': '128879733',
                                                                                                'out_ucast_pkts': '203583',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTUxLzIvZ3A1'}],
                                                                       'name': '123/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '128676150',
                                                                       'out_octets': '128879733',
                                                                       'out_ucast_pkts': '203583',
                                                                       'poller_hash': 'ODdCOTNEcGVlcmludGYxMjMvZ3Ax',
                                                                       'pons': [       {       'id': '123',
                                                                                               'links': [       {       'connected_time': '2602726',
                                                                                                                        'fiber_length': 878,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE1MTIwMDEwMTA5',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOTNEcGVlcnBvbjEyMy9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 123',
                                         'poller_hash': 'ODdCOTNE',
                                         'serial_number': '87B93D',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:ed:b7',
                                         'uptime': '2602726'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003649',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '266288008968',
                                                                       'in_octets': '266735178968',
                                                                       'in_ucast_pkts': '447170000',
                                                                       'mac_address': 'd0:76:8f:1f:f2:c1',
                                                                       'mtu': 2000,
                                                                       'name': '124/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '1217230449975',
                                                                       'out_octets': '1218125455407',
                                                                       'out_ucast_pkts': '895005432',
                                                                       'poller_hash': 'ODdCQUVCcGVlcmludGYxMjQvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '124',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '1217230449975',
                                                                       'in_octets': '1218125455407',
                                                                       'in_ucast_pkts': '895005432',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '1217230449975',
                                                                                                'in_octets': '1218125455407',
                                                                                                'in_ucast_pkts': '895005432',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '266288008968',
                                                                                                'out_octets': '266735178968',
                                                                                                'out_ucast_pkts': '447170000',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTgxLzIvZ3A4'}],
                                                                       'name': '124/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '266288008968',
                                                                       'out_octets': '266735178968',
                                                                       'out_ucast_pkts': '447170000',
                                                                       'poller_hash': 'ODdCQUVCcGVlcmludGYxMjQvZ3Ax',
                                                                       'pons': [       {       'id': '124',
                                                                                               'links': [       {       'connected_time': '2602739',
                                                                                                                        'fiber_length': 472,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE4MTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQUVCcGVlcnBvbjEyNC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 124',
                                         'poller_hash': 'ODdCQUVC',
                                         'serial_number': '87BAEB',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f2:c1',
                                         'uptime': '2602739'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003841',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '34189357165',
                                                                       'in_octets': '34410423810',
                                                                       'in_ucast_pkts': '221066645',
                                                                       'mac_address': 'd0:76:8f:1f:f0:54',
                                                                       'mtu': 2000,
                                                                       'name': '130/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '713932433521',
                                                                       'out_octets': '714433062028',
                                                                       'out_ucast_pkts': '500628507',
                                                                       'poller_hash': 'ODdCQTFDcGVlcmludGYxMzAvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '130',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '713932433521',
                                                                       'in_octets': '714433062028',
                                                                       'in_ucast_pkts': '500628507',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '713932433521',
                                                                                                'in_octets': '714433062028',
                                                                                                'in_ucast_pkts': '500628507',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '34189357165',
                                                                                                'out_octets': '34410423810',
                                                                                                'out_ucast_pkts': '221066645',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTYxLzIvZ3A2'}],
                                                                       'name': '130/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '34189357165',
                                                                       'out_octets': '34410423810',
                                                                       'out_ucast_pkts': '221066645',
                                                                       'poller_hash': 'ODdCQTFDcGVlcmludGYxMzAvZ3Ax',
                                                                       'pons': [       {       'id': '130',
                                                                                               'links': [       {       'connected_time': '2602727',
                                                                                                                        'fiber_length': 942,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE2MTIwMDEwMTEw',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -18.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCQTFDcGVlcnBvbjEzMC9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 130',
                                         'poller_hash': 'ODdCQTFD',
                                         'serial_number': '87BA1C',
                                         'status': 'ELEMENT_STATUS_ONLINE',
                                         'sw_version': '12.2.12.2.3',
                                         'system_mac_address': 'd0:76:8f:1f:f0:54',
                                         'uptime': '2602727'},
                                 {       'interfaces': [       {       'admin_up': True,
                                                                       'id': '1003905',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '15159442923',
                                                                       'in_octets': '15203368389',
                                                                       'in_ucast_pkts': '43925466',
                                                                       'mac_address': 'd0:76:8f:1f:ef:9d',
                                                                       'mtu': 2000,
                                                                       'name': '132/g1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '112737527757',
                                                                       'out_octets': '112832220246',
                                                                       'out_ucast_pkts': '94692489',
                                                                       'poller_hash': 'ODdCOURGcGVlcmludGYxMzIvZzE=',
                                                                       'speed': '1000000000'},
                                                               {       'admin_up': True,
                                                                       'id': '132',
                                                                       'in_errors': '0',
                                                                       'in_nucast_pkts': '112737527757',
                                                                       'in_octets': '112832220246',
                                                                       'in_ucast_pkts': '94692489',
                                                                       'links': [       {       'in_errors': '0',
                                                                                                'in_nucast_pkts': '112737527757',
                                                                                                'in_octets': '112832220246',
                                                                                                'in_ucast_pkts': '94692489',
                                                                                                'oper_up': True,
                                                                                                'out_errors': '0',
                                                                                                'out_nucast_pkts': '15159442923',
                                                                                                'out_octets': '15203368389',
                                                                                                'out_ucast_pkts': '43925466',
                                                                                                'poller_hash': 'NDg6Nzc6NDY6NTM6NDY6MTgxLzIvZ3A4'}],
                                                                       'name': '132/gp1',
                                                                       'oper_up': True,
                                                                       'out_errors': '0',
                                                                       'out_nucast_pkts': '15159442923',
                                                                       'out_octets': '15203368389',
                                                                       'out_ucast_pkts': '43925466',
                                                                       'poller_hash': 'ODdCOURGcGVlcmludGYxMzIvZ3Ax',
                                                                       'pons': [       {       'id': '132',
                                                                                               'links': [       {       'connected_time': '2602736',
                                                                                                                        'fiber_length': 455,
                                                                                                                        'poller_hash': 'NDg3NzQ2NTM0NjE4MTIwMDEwMTEy',
                                                                                                                        'rx_link_rate': '2488320000',
                                                                                                                        'rx_power': -21.0,
                                                                                                                        'tx_link_rate': '1244160000',
                                                                                                                        'tx_power': 2.0}],
                                                                                               'max_distance': 20000,
                                                                                               'poller_hash': 'ODdCOURGcGVlcnBvbjEzMi9ncDE=',
                                                                                               'pon_technology': 'GPON',
                                                                                               'rx_link_rate': '2488320000',
                                                                                               'split_ratio': 64,
                                                                                               'tx_link_rate': '1244160000'}]}],
                                         'manufacturer': 'CXNK',
                                         'model': '803G',
                                         'name': 'ont 132',
                                         'poller_hash': 'ODdCOURG',
       